#
# PySNMP MIB module MSDP-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/MSDP-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:22:15 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( OctetString, Integer, ObjectIdentifier, ) = mibBuilder.importSymbols("ASN1", "OctetString", "Integer", "ObjectIdentifier")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ValueRangeConstraint, SingleValueConstraint, ValueSizeConstraint, ConstraintsUnion, ConstraintsIntersection, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ValueRangeConstraint", "SingleValueConstraint", "ValueSizeConstraint", "ConstraintsUnion", "ConstraintsIntersection")
( ModuleCompliance, ObjectGroup, NotificationGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup", "NotificationGroup")
( Bits, Counter32, Unsigned32, MibScalar, MibTable, MibTableRow, MibTableColumn, NotificationType, iso, ModuleIdentity, ObjectIdentity, experimental, IpAddress, MibIdentifier, Integer32, TimeTicks, Gauge32, Counter64, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Unsigned32", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "NotificationType", "iso", "ModuleIdentity", "ObjectIdentity", "experimental", "IpAddress", "MibIdentifier", "Integer32", "TimeTicks", "Gauge32", "Counter64")
( DisplayString, TimeStamp, TruthValue, RowStatus, TextualConvention, ) = mibBuilder.importSymbols("SNMPv2-TC", "DisplayString", "TimeStamp", "TruthValue", "RowStatus", "TextualConvention")
msdpMIB = ModuleIdentity((1, 3, 6, 1, 3, 92)).setRevisions(("2006-08-01 00:00",))
if mibBuilder.loadTexts: msdpMIB.setLastUpdated('200608010000Z')
if mibBuilder.loadTexts: msdpMIB.setOrganization('IETF MBONED Working Group')
if mibBuilder.loadTexts: msdpMIB.setContactInfo('Bill Fenner\n            75 Willow Road\n            Menlo Park, CA  94025\n            Phone: +1 650 867 6073\n            E-mail: fenner@research.att.com\n\n            Dave Thaler\n            One Microsoft Way\n            Redmond, WA  98052\n            Phone: +1 425 703 8835\n            Email: dthaler@microsoft.com\n\n            MBONED Working Group: mboned@lists.uoregon.edu')
if mibBuilder.loadTexts: msdpMIB.setDescription('An experimental MIB module for MSDP Management and\n            Monitoring.\n            Copyright (C) The Internet Society 2006.  This version of\n            this MIB module is part of RFC 4624; see the RFC itself\n            for full legal notices.')
msdpMIBobjects = MibIdentifier((1, 3, 6, 1, 3, 92, 1))
msdp = MibIdentifier((1, 3, 6, 1, 3, 92, 1, 1))
msdpEnabled = MibScalar((1, 3, 6, 1, 3, 92, 1, 1, 1), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: msdpEnabled.setDescription('The state of MSDP on this MSDP speaker - globally enabled\n            or disabled.\n\n            Changes to this object should be stored to non-volatile\n            memory.')
msdpCacheLifetime = MibScalar((1, 3, 6, 1, 3, 92, 1, 1, 2), TimeTicks()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: msdpCacheLifetime.setDescription('The lifetime given to SA cache entries when created or\n            refreshed.  This is the [SG-State-Period] in the MSDP\n            spec.  A value of 0 means no SA caching is done by this\n            MSDP speaker.\n\n            Changes to this object should be stored to non-volatile\n            memory.\n\n            This object does not measure time per se; instead, it\n            is the delta from the time at which an SA message is\n            received at which it should be expired if not refreshed.\n            (i.e., it is the value of msdpSACacheExpiryTime\n            immediately after receiving an SA message applying to\n            that row.)  As such, TimeInterval would be a more\n            appropriate SYNTAX; it remains TimeTicks for backwards\n            compatibility.')
msdpNumSACacheEntries = MibScalar((1, 3, 6, 1, 3, 92, 1, 1, 3), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: msdpNumSACacheEntries.setDescription('The total number of entries in the SA Cache table.')
msdpRPAddress = MibScalar((1, 3, 6, 1, 3, 92, 1, 1, 11), IpAddress()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: msdpRPAddress.setDescription('The Rendezvous Point (RP) address used when sourcing\n            MSDP SA messages.  May be 0.0.0.0 on non-RPs.\n\n            Changes to this object should be stored to non-volatile\n            memory.')
msdpRequestsTable = MibTable((1, 3, 6, 1, 3, 92, 1, 1, 4), )
if mibBuilder.loadTexts: msdpRequestsTable.setDescription("The (conceptual) table listing group ranges and MSDP peers\n            used when deciding where to send an SA Request message, when\n            required.  If SA Requests are not enabled, this table may be\n            empty.\n\n            In order to choose a peer to whom to send an SA Request for\n            a given group, G, the subset of entries in this table whose\n            (msdpRequestsPeerType, msdpRequestsPeer) tuple represents a\n            peer whose msdpPeerState is established are examined.  The\n            set is further reduced by examining only those entries for\n            which msdpPeerRequestsGroupAddressType equals the address\n            type of G.  The entries with the highest value of\n            msdpRequestsGroupPrefix are considered, where the group G\n            falls within the range described by the combination of\n            msdpRequestsGroup and msdpRequestsGroupPrefix.  (This\n            sequence is commonly known as a 'longest-match' lookup.)\n\n            Finally, if multiple entries remain, the entry with the\n            lowest value of msdpRequestsPriority is chosen.  The SA\n            Request message is sent to the peer described by this row.")
msdpRequestsEntry = MibTableRow((1, 3, 6, 1, 3, 92, 1, 1, 4, 1), ).setIndexNames((0, "MSDP-MIB", "msdpRequestsGroupAddress"), (0, "MSDP-MIB", "msdpRequestsGroupMask"))
if mibBuilder.loadTexts: msdpRequestsEntry.setDescription('An entry (conceptual row) representing a group range\n            used when deciding where to send an SA Request\n            message.')
msdpRequestsGroupAddress = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 4, 1, 1), IpAddress())
if mibBuilder.loadTexts: msdpRequestsGroupAddress.setDescription('The group address that, when combined with the mask\n            in this entry, represents the group range to which\n            this row applies.')
msdpRequestsGroupMask = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 4, 1, 2), IpAddress())
if mibBuilder.loadTexts: msdpRequestsGroupMask.setDescription('The mask that, when combined with the group address\n            in this entry, represents the group range to which\n            this row applies.')
msdpRequestsPeer = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 4, 1, 3), IpAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: msdpRequestsPeer.setDescription("The peer to which MSDP SA Requests for groups matching\n            this entry's group range will be sent.  This object,\n            combined with msdpRequestsPeerType, must match the INDEX\n            of a row in the msdpPeerTable, and to be considered,\n            this peer's msdpPeerState must be established.")
msdpRequestsStatus = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 4, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: msdpRequestsStatus.setDescription('The status of this row, by which new rows may be added\n            to the table or old rows may be deleted.')
msdpPeerTable = MibTable((1, 3, 6, 1, 3, 92, 1, 1, 5), )
if mibBuilder.loadTexts: msdpPeerTable.setDescription("The (conceptual) table listing the MSDP speaker's peers.")
msdpPeerEntry = MibTableRow((1, 3, 6, 1, 3, 92, 1, 1, 5, 1), ).setIndexNames((0, "MSDP-MIB", "msdpPeerRemoteAddress"))
if mibBuilder.loadTexts: msdpPeerEntry.setDescription("An entry (conceptual row) representing an MSDP peer.\n\n            If row creation is supported, dynamically added rows are\n            added to the system's stable configuration (corresponding\n            to a StorageType value of nonVolatile).  ")
msdpPeerRemoteAddress = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 5, 1, 1), IpAddress())
if mibBuilder.loadTexts: msdpPeerRemoteAddress.setDescription('The address of the remote MSDP peer.')
msdpPeerState = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 5, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5,))).clone(namedValues=NamedValues(("inactive", 1), ("listen", 2), ("connecting", 3), ("established", 4), ("disabled", 5),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: msdpPeerState.setDescription('The state of the MSDP TCP connection with this peer.')
msdpPeerRPFFailures = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 5, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: msdpPeerRPFFailures.setDescription('The number of SA messages received from this peer that\n            failed the Peer-RPF check.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            msdpPeerDiscontinuityTime.')
msdpPeerInSAs = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 5, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: msdpPeerInSAs.setDescription('The number of MSDP SA messages received on this\n            connection.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            msdpPeerDiscontinuityTime.')
msdpPeerOutSAs = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 5, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: msdpPeerOutSAs.setDescription('The number of MSDP SA messages transmitted on this\n            connection.\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            msdpPeerDiscontinuityTime.')
msdpPeerInSARequests = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 5, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: msdpPeerInSARequests.setDescription('The number of MSDP SA-Request messages received on this\n            connection.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            msdpPeerDiscontinuityTime.')
msdpPeerOutSARequests = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 5, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: msdpPeerOutSARequests.setDescription('The number of MSDP SA-Request messages transmitted on\n            this connection.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            msdpPeerDiscontinuityTime.')
msdpPeerInSAResponses = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 5, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: msdpPeerInSAResponses.setDescription('The number of MSDP SA-Response messages received on this\n            connection.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            msdpPeerDiscontinuityTime.')
msdpPeerOutSAResponses = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 5, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: msdpPeerOutSAResponses.setDescription('The number of MSDP SA Response messages transmitted on\n            this TCP connection.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            msdpPeerDiscontinuityTime.')
msdpPeerInControlMessages = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 5, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: msdpPeerInControlMessages.setDescription('The total number of MSDP messages, excluding encapsulated\n            data packets, received on this TCP connection.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            msdpPeerDiscontinuityTime.')
msdpPeerOutControlMessages = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 5, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: msdpPeerOutControlMessages.setDescription('The total number of MSDP messages, excluding encapsulated\n            data packets, transmitted on this TCP connection.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            msdpPeerDiscontinuityTime.')
msdpPeerInDataPackets = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 5, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: msdpPeerInDataPackets.setDescription('The total number of encapsulated data packets received\n            from this peer.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            msdpPeerDiscontinuityTime.')
msdpPeerOutDataPackets = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 5, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: msdpPeerOutDataPackets.setDescription('The total number of encapsulated data packets sent to\n            this peer.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            msdpPeerDiscontinuityTime.')
msdpPeerFsmEstablishedTransitions = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 5, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: msdpPeerFsmEstablishedTransitions.setDescription('The total number of times the MSDP FSM transitioned into\n            the ESTABLISHED state.')
msdpPeerFsmEstablishedTime = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 5, 1, 16), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: msdpPeerFsmEstablishedTime.setDescription('This timestamp is set to the value of sysUpTime when a\n            peer transitions into or out of the ESTABLISHED state.\n            It is set to zero when the MSDP speaker is booted.')
msdpPeerInMessageTime = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 5, 1, 17), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: msdpPeerInMessageTime.setDescription('The sysUpTime value when the last MSDP message was\n            received from the peer.  It is set to zero when the MSDP\n            speaker is booted.')
msdpPeerLocalAddress = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 5, 1, 18), IpAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: msdpPeerLocalAddress.setDescription("The local IP address used for this entry's MSDP TCP\n            connection.")
msdpPeerConnectRetryInterval = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 5, 1, 20), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535)).clone(30)).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: msdpPeerConnectRetryInterval.setDescription('Time interval, in seconds, for the [ConnectRetry-period]\n            for this peer.')
msdpPeerHoldTimeConfigured = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 5, 1, 21), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(0,0),ValueRangeConstraint(3,65535),)).clone(75)).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: msdpPeerHoldTimeConfigured.setDescription('Time interval, in seconds, for the [HoldTime-Period]\n            configured for this MSDP speaker with this peer.  If the\n            value of this object is zero (0), the MSDP connection is\n            never torn down due to the absence of messages from the\n            peer.')
msdpPeerKeepAliveConfigured = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 5, 1, 22), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(0,0),ValueRangeConstraint(1,21845),)).clone(60)).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: msdpPeerKeepAliveConfigured.setDescription('Time interval, in seconds, for the [KeepAlive-Period]\n            configured for this MSDP speaker with this peer.  If the\n            value of this object is zero (0), no periodic KEEPALIVE\n            messages are sent to the peer after the MSDP connection\n            has been established.')
msdpPeerDataTtl = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 5, 1, 23), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255)).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: msdpPeerDataTtl.setDescription('The minimum TTL a packet is required to have before it\n            may be forwarded using SA encapsulation to this peer.')
msdpPeerProcessRequestsFrom = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 5, 1, 24), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: msdpPeerProcessRequestsFrom.setDescription('This object indicates whether to process MSDP SA\n            Request messages from this peer.  If True(1), MSDP SA\n            Request messages from this peer are processed and replied\n            to (if appropriate) with SA Response messages.  If\n            False(2), MSDP SA Request messages from this peer are\n            silently ignored.  It defaults to False when\n            msdpCacheLifetime is 0 and to True when msdpCacheLifetime\n            is non-0.\n\n            This object is deprecated because MSDP SA Requests were\n            removed from the MSDP specification.')
msdpPeerStatus = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 5, 1, 25), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: msdpPeerStatus.setDescription("The RowStatus object by which peers can be added and\n            deleted.  A transition to 'active' will cause the MSDP\n            'Enable MSDP peering with P' Event to be generated.  A\n            transition out of the 'active' state will cause the MSDP\n            'Disable MSDP peering with P' Event to be generated.\n            Care should be used in providing write access to this\n            object without adequate authentication.\n\n            msdpPeerRemoteAddress is the only variable that must be\n            set to a valid value before the row can be activated.\n            Since this is the table's INDEX, a row can be activated\n            by simply setting the msdpPeerStatus variable.\n\n            It is possible to modify other columns in the same\n            conceptual row when the status value is active(1).")
msdpPeerRemotePort = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 5, 1, 26), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535)).clone(639)).setMaxAccess("readonly")
if mibBuilder.loadTexts: msdpPeerRemotePort.setDescription('The remote port for the TCP connection between the MSDP\n            peers.')
msdpPeerLocalPort = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 5, 1, 27), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535)).clone(639)).setMaxAccess("readonly")
if mibBuilder.loadTexts: msdpPeerLocalPort.setDescription('The local port for the TCP connection between the MSDP\n            peers.')
msdpPeerEncapsulationType = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 5, 1, 29), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1,))).clone(namedValues=NamedValues(("none", 0), ("tcp", 1),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: msdpPeerEncapsulationType.setDescription('The encapsulation in use when encapsulating data in SA\n            messages to this peer.')
msdpPeerConnectionAttempts = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 5, 1, 30), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: msdpPeerConnectionAttempts.setDescription('The number of times the state machine has transitioned\n            from INACTIVE to CONNECTING.')
msdpPeerInNotifications = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 5, 1, 31), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: msdpPeerInNotifications.setDescription('The number of MSDP Notification messages received from\n            this peer.\n            This object is deprecated because MSDP Notifications have\n            been removed from the spec.')
msdpPeerOutNotifications = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 5, 1, 32), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: msdpPeerOutNotifications.setDescription('The number of MSDP Notification messages transmitted to\n            this peer.\n\n            This object is deprecated because MSDP Notifications have\n            been removed from the spec.')
msdpPeerLastError = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 5, 1, 33), OctetString().subtype(subtypeSpec=ValueSizeConstraint(2,2)).setFixedLength(2).clone(hexValue="0000")).setMaxAccess("readonly")
if mibBuilder.loadTexts: msdpPeerLastError.setDescription('The last error code and subcode received via Notification\n            from this peer.  If no error has occurred, this field is\n            zero.  Otherwise, the first byte of this two-byte OCTET\n            STRING contains the O-bit and error code, and the second\n            byte contains the subcode.\n            This object is deprecated because MSDP Notifications have\n            been removed from the spec.')
msdpPeerDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 5, 1, 34), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: msdpPeerDiscontinuityTime.setDescription("The value of sysUpTime on the most recent occasion at\n            which one or more of this entry's counters suffered a\n            discontinuity.  See the DESCRIPTION of each object to see\n            if it is expected to have discontinuities.  These\n            discontinuities may occur at peer connection\n            establishment.\n\n            If no such discontinuities have occurred since the last\n            reinitialization of the local management subsystem, then\n            this object contains a zero value.")
msdpSACacheTable = MibTable((1, 3, 6, 1, 3, 92, 1, 1, 6), )
if mibBuilder.loadTexts: msdpSACacheTable.setDescription("The (conceptual) table listing the MSDP SA advertisements\n            currently in the MSDP speaker's cache.")
msdpSACacheEntry = MibTableRow((1, 3, 6, 1, 3, 92, 1, 1, 6, 1), ).setIndexNames((0, "MSDP-MIB", "msdpSACacheGroupAddr"), (0, "MSDP-MIB", "msdpSACacheSourceAddr"), (0, "MSDP-MIB", "msdpSACacheOriginRP"))
if mibBuilder.loadTexts: msdpSACacheEntry.setDescription('An entry (conceptual row) representing an MSDP SA\n            advertisement.  The INDEX to this table includes\n            msdpSACacheOriginRP for diagnosing incorrect MSDP\n            advertisements; normally, a Group and Source pair would\n            be unique.\n\n            Row creation is not permitted; msdpSACacheStatus may only\n            be used to delete rows from this table.')
msdpSACacheGroupAddr = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 6, 1, 1), IpAddress())
if mibBuilder.loadTexts: msdpSACacheGroupAddr.setDescription('The group address of the SA Cache entry.')
msdpSACacheSourceAddr = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 6, 1, 2), IpAddress())
if mibBuilder.loadTexts: msdpSACacheSourceAddr.setDescription('The source address of the SA Cache entry.')
msdpSACacheOriginRP = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 6, 1, 3), IpAddress())
if mibBuilder.loadTexts: msdpSACacheOriginRP.setDescription("The RP of the SA Cache entry.  This field is in the INDEX\n            in order to catch multiple RP's advertising the same\n            source and group.")
msdpSACachePeerLearnedFrom = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 6, 1, 4), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: msdpSACachePeerLearnedFrom.setDescription('The peer from which this SA Cache entry was last\n            accepted.  This address must correspond to the\n            msdpPeerRemoteAddress value for a row in the MSDP Peer\n            Table.  This should be 0.0.0.0 on the router that\n            originated the entry.')
msdpSACacheRPFPeer = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 6, 1, 5), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: msdpSACacheRPFPeer.setDescription('The peer from which an SA message corresponding to this\n            cache entry would be accepted (i.e., the RPF peer for\n            msdpSACacheOriginRP).  This may be different than\n            msdpSACachePeerLearnedFrom if this entry was created by\n            an MSDP SA-Response.  This address must correspond to\n            the msdpPeerRemoteAddress value for a row in the MSDP\n            Peer Table, or it may be 0.0.0.0 if no RPF peer exists.')
msdpSACacheInSAs = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 6, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: msdpSACacheInSAs.setDescription('The number of MSDP SA messages received relevant to this\n            cache entry.  This object must be initialized to zero\n            when creating a cache entry.')
msdpSACacheInDataPackets = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 6, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: msdpSACacheInDataPackets.setDescription('The number of MSDP-encapsulated data packets received\n            relevant to this cache entry.  This object must be\n            initialized to zero when creating a cache entry.')
msdpSACacheUpTime = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 6, 1, 8), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: msdpSACacheUpTime.setDescription('The time since this entry was first placed in the SA\n            cache.\n            The first epoch is the time that the entry was first\n            placed in the SA cache, and the second epoch is the\n            current time.')
msdpSACacheExpiryTime = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 6, 1, 9), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: msdpSACacheExpiryTime.setDescription('The time remaining before this entry will expire from\n            the SA cache.\n\n            The first epoch is now, and the second epoch is the time\n            that the entry will expire.')
msdpSACacheStatus = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 6, 1, 10), RowStatus().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 6,))).clone(namedValues=NamedValues(("active", 1), ("destroy", 6),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: msdpSACacheStatus.setDescription("The status of this row in the table.  The only allowable\n            actions are to retrieve the status, which will be\n            'active', or to set the status to 'destroy' in order to\n            remove this entry from the cache.\n\n            Row creation is not permitted.\n\n            No columnar objects are writable, so there are none that\n            may be changed while the status value is active(1).")
msdpMeshGroupTable = MibTable((1, 3, 6, 1, 3, 92, 1, 1, 12), )
if mibBuilder.loadTexts: msdpMeshGroupTable.setDescription('The (conceptual) table listing MSDP Mesh Group\n            configuration.')
msdpMeshGroupEntry = MibTableRow((1, 3, 6, 1, 3, 92, 1, 1, 12, 1), ).setIndexNames((0, "MSDP-MIB", "msdpMeshGroupName"), (0, "MSDP-MIB", "msdpMeshGroupPeerAddress"))
if mibBuilder.loadTexts: msdpMeshGroupEntry.setDescription("An entry (conceptual row) representing a peer in an MSDP\n            Mesh Group.\n\n            If row creation is supported, dynamically added rows are\n            added to the system's stable configuration\n            (corresponding to a StorageType value of nonVolatile).")
msdpMeshGroupName = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 12, 1, 1), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1,64)))
if mibBuilder.loadTexts: msdpMeshGroupName.setDescription('The name of the mesh group.')
msdpMeshGroupPeerAddress = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 12, 1, 2), IpAddress())
if mibBuilder.loadTexts: msdpMeshGroupPeerAddress.setDescription('A peer address that is a member of the mesh group with\n            name msdpMeshGroupName.  The msdpMeshGroupPeerAddress\n            must match a row in the msdpPeerTable.')
msdpMeshGroupStatus = MibTableColumn((1, 3, 6, 1, 3, 92, 1, 1, 12, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: msdpMeshGroupStatus.setDescription("This entry's status, by which new entries may be added\n               to the table and old entries deleted.\n\n               msdpMeshGroupName and msdpMeshGroupPeerAddress must be\n               set to valid values before the row can be activated.\n               Since these are the table's INDEX, a row can be activated\n               by simply setting the msdpMeshGroupStatus variable.\n\n               It is not possible to modify other columns in the same\n               conceptual row when the status value is active(1),\n               because the only other objects in the row are part of the\n               INDEX.  Changing one of these changes the row, so an old\n               row must be deleted and a new one created.")
msdpTraps = MibIdentifier((1, 3, 6, 1, 3, 92, 1, 1, 0))
msdpEstablished = NotificationType((1, 3, 6, 1, 3, 92, 1, 1, 0, 1)).setObjects(*(("MSDP-MIB", "msdpPeerFsmEstablishedTransitions"),))
if mibBuilder.loadTexts: msdpEstablished.setDescription('The MSDP Established event is generated when the MSDP FSM\n            enters the ESTABLISHED state.')
msdpBackwardTransition = NotificationType((1, 3, 6, 1, 3, 92, 1, 1, 0, 2)).setObjects(*(("MSDP-MIB", "msdpPeerState"),))
if mibBuilder.loadTexts: msdpBackwardTransition.setDescription('The MSDPBackwardTransition Event is generated when the\n            MSDP FSM moves from a higher-numbered state to a\n            lower-numbered state.')
msdpMIBConformance = MibIdentifier((1, 3, 6, 1, 3, 92, 1, 1, 8))
msdpMIBCompliances = MibIdentifier((1, 3, 6, 1, 3, 92, 1, 1, 8, 1))
msdpMIBGroups = MibIdentifier((1, 3, 6, 1, 3, 92, 1, 1, 8, 2))
msdpMIBCompliance = ModuleCompliance((1, 3, 6, 1, 3, 92, 1, 1, 8, 1, 1)).setObjects(*(("MSDP-MIB", "msdpMIBGlobalsGroup"), ("MSDP-MIB", "msdpMIBPeerGroup"), ("MSDP-MIB", "msdpMIBNotificationGroup"), ("MSDP-MIB", "msdpMIBEncapsulationGroup"), ("MSDP-MIB", "msdpMIBSACacheGroup"), ("MSDP-MIB", "msdpMIBRequestsGroup"), ("MSDP-MIB", "msdpMIBRPGroup"), ("MSDP-MIB", "msdpMIBMeshGroupGroup"),))
if mibBuilder.loadTexts: msdpMIBCompliance.setDescription('The compliance statement for entities that implement a pre-\n            RFC version of MSDP.  This statement is deprecated because\n            it includes objects used for managing/monitoring aspects of\n            MSDP that were removed before it was published as an RFC.')
msdpMIBFullCompliance = ModuleCompliance((1, 3, 6, 1, 3, 92, 1, 1, 8, 1, 2)).setObjects(*(("MSDP-MIB", "msdpMIBGlobalsGroup"), ("MSDP-MIB", "msdpMIBPeerGroup2"), ("MSDP-MIB", "msdpMIBSACacheGroup"), ("MSDP-MIB", "msdpMIBEncapsulationGroup"), ("MSDP-MIB", "msdpMIBRPGroup"), ("MSDP-MIB", "msdpMIBMeshGroupGroup"),))
if mibBuilder.loadTexts: msdpMIBFullCompliance.setDescription('The compliance statement for entities that implement MSDP\n            (RFC3618).')
msdpMIBReadOnlyCompliance = ModuleCompliance((1, 3, 6, 1, 3, 92, 1, 1, 8, 1, 3)).setObjects(*(("MSDP-MIB", "msdpMIBGlobalsGroup"), ("MSDP-MIB", "msdpMIBPeerGroup2"), ("MSDP-MIB", "msdpMIBSACacheGroup"), ("MSDP-MIB", "msdpMIBEncapsulationGroup"), ("MSDP-MIB", "msdpMIBRPGroup"), ("MSDP-MIB", "msdpMIBMeshGroupGroup"),))
if mibBuilder.loadTexts: msdpMIBReadOnlyCompliance.setDescription('The compliance statement for entities that implement MSDP\n            (RFC3618), but do not permit configuration (or only permit\n            partial configuration) via SNMP.')
msdpMIBGlobalsGroup = ObjectGroup((1, 3, 6, 1, 3, 92, 1, 1, 8, 2, 1)).setObjects(*(("MSDP-MIB", "msdpEnabled"),))
if mibBuilder.loadTexts: msdpMIBGlobalsGroup.setDescription('A collection of objects providing information on global MSDP\n            state.')
msdpMIBPeerGroup = ObjectGroup((1, 3, 6, 1, 3, 92, 1, 1, 8, 2, 2)).setObjects(*(("MSDP-MIB", "msdpPeerRPFFailures"), ("MSDP-MIB", "msdpPeerState"), ("MSDP-MIB", "msdpPeerInSAs"), ("MSDP-MIB", "msdpPeerOutSAs"), ("MSDP-MIB", "msdpPeerInSARequests"), ("MSDP-MIB", "msdpPeerOutSARequests"), ("MSDP-MIB", "msdpPeerInSAResponses"), ("MSDP-MIB", "msdpPeerOutSAResponses"), ("MSDP-MIB", "msdpPeerInNotifications"), ("MSDP-MIB", "msdpPeerOutNotifications"), ("MSDP-MIB", "msdpPeerInControlMessages"), ("MSDP-MIB", "msdpPeerOutControlMessages"), ("MSDP-MIB", "msdpPeerFsmEstablishedTransitions"), ("MSDP-MIB", "msdpPeerFsmEstablishedTime"), ("MSDP-MIB", "msdpPeerLocalAddress"), ("MSDP-MIB", "msdpPeerRemotePort"), ("MSDP-MIB", "msdpPeerLocalPort"), ("MSDP-MIB", "msdpPeerConnectRetryInterval"), ("MSDP-MIB", "msdpPeerHoldTimeConfigured"), ("MSDP-MIB", "msdpPeerKeepAliveConfigured"), ("MSDP-MIB", "msdpPeerInMessageTime"), ("MSDP-MIB", "msdpPeerProcessRequestsFrom"), ("MSDP-MIB", "msdpPeerConnectionAttempts"), ("MSDP-MIB", "msdpPeerLastError"), ("MSDP-MIB", "msdpPeerStatus"), ("MSDP-MIB", "msdpPeerDiscontinuityTime"),))
if mibBuilder.loadTexts: msdpMIBPeerGroup.setDescription('A collection of objects for managing MSDP peers.  This group\n            is deprecated in favor of msdpMIBPeerGroup2 because it\n            contains objects for managing aspects of MSDP that were\n            removed before it was published as an RFC.')
msdpMIBEncapsulationGroup = ObjectGroup((1, 3, 6, 1, 3, 92, 1, 1, 8, 2, 3)).setObjects(*(("MSDP-MIB", "msdpPeerInDataPackets"), ("MSDP-MIB", "msdpPeerOutDataPackets"), ("MSDP-MIB", "msdpPeerDataTtl"), ("MSDP-MIB", "msdpPeerEncapsulationType"),))
if mibBuilder.loadTexts: msdpMIBEncapsulationGroup.setDescription('A collection of objects for managing encapsulations if the\n            MSDP encapsulation interfaces are not given interface\n            indices.')
msdpMIBSACacheGroup = ObjectGroup((1, 3, 6, 1, 3, 92, 1, 1, 8, 2, 4)).setObjects(*(("MSDP-MIB", "msdpCacheLifetime"), ("MSDP-MIB", "msdpNumSACacheEntries"), ("MSDP-MIB", "msdpSACachePeerLearnedFrom"), ("MSDP-MIB", "msdpSACacheRPFPeer"), ("MSDP-MIB", "msdpSACacheInSAs"), ("MSDP-MIB", "msdpSACacheInDataPackets"), ("MSDP-MIB", "msdpSACacheUpTime"), ("MSDP-MIB", "msdpSACacheExpiryTime"), ("MSDP-MIB", "msdpSACacheStatus"),))
if mibBuilder.loadTexts: msdpMIBSACacheGroup.setDescription('A collection of objects for managing MSDP SA cache entries.')
msdpMIBNotificationGroup = NotificationGroup((1, 3, 6, 1, 3, 92, 1, 1, 8, 2, 5)).setObjects(*(("MSDP-MIB", "msdpEstablished"), ("MSDP-MIB", "msdpBackwardTransition"),))
if mibBuilder.loadTexts: msdpMIBNotificationGroup.setDescription('A collection of notifications for signaling changes in MSDP\n            peer relationships.')
msdpMIBRequestsGroup = ObjectGroup((1, 3, 6, 1, 3, 92, 1, 1, 8, 2, 6)).setObjects(*(("MSDP-MIB", "msdpRequestsPeer"), ("MSDP-MIB", "msdpRequestsStatus"),))
if mibBuilder.loadTexts: msdpMIBRequestsGroup.setDescription('A collection of objects for managing MSDP Request\n            transmission.  This group is deprecated because Requests\n            were removed from MSDP before its publication as an RFC.')
msdpMIBRPGroup = ObjectGroup((1, 3, 6, 1, 3, 92, 1, 1, 8, 2, 7)).setObjects(*(("MSDP-MIB", "msdpRPAddress"),))
if mibBuilder.loadTexts: msdpMIBRPGroup.setDescription('A collection of objects for MSDP speakers that source MSDP\n            messages.')
msdpMIBMeshGroupGroup = ObjectGroup((1, 3, 6, 1, 3, 92, 1, 1, 8, 2, 8)).setObjects(*(("MSDP-MIB", "msdpMeshGroupStatus"),))
if mibBuilder.loadTexts: msdpMIBMeshGroupGroup.setDescription('A collection of objects for MSDP speakers that can\n            participate in MSDP mesh groups.')
msdpMIBPeerGroup2 = ObjectGroup((1, 3, 6, 1, 3, 92, 1, 1, 8, 2, 9)).setObjects(*(("MSDP-MIB", "msdpPeerRPFFailures"), ("MSDP-MIB", "msdpPeerState"), ("MSDP-MIB", "msdpPeerInSAs"), ("MSDP-MIB", "msdpPeerOutSAs"), ("MSDP-MIB", "msdpPeerInSARequests"), ("MSDP-MIB", "msdpPeerOutSARequests"), ("MSDP-MIB", "msdpPeerInControlMessages"), ("MSDP-MIB", "msdpPeerOutControlMessages"), ("MSDP-MIB", "msdpPeerFsmEstablishedTransitions"), ("MSDP-MIB", "msdpPeerFsmEstablishedTime"), ("MSDP-MIB", "msdpPeerLocalAddress"), ("MSDP-MIB", "msdpPeerRemotePort"), ("MSDP-MIB", "msdpPeerLocalPort"), ("MSDP-MIB", "msdpPeerConnectRetryInterval"), ("MSDP-MIB", "msdpPeerHoldTimeConfigured"), ("MSDP-MIB", "msdpPeerKeepAliveConfigured"), ("MSDP-MIB", "msdpPeerInMessageTime"), ("MSDP-MIB", "msdpPeerConnectionAttempts"), ("MSDP-MIB", "msdpPeerStatus"), ("MSDP-MIB", "msdpPeerDiscontinuityTime"),))
if mibBuilder.loadTexts: msdpMIBPeerGroup2.setDescription('A collection of objects for managing MSDP peers.')
mibBuilder.exportSymbols("MSDP-MIB", msdpSACacheOriginRP=msdpSACacheOriginRP, PYSNMP_MODULE_ID=msdpMIB, msdpRPAddress=msdpRPAddress, msdpPeerRemotePort=msdpPeerRemotePort, msdpPeerHoldTimeConfigured=msdpPeerHoldTimeConfigured, msdpPeerInNotifications=msdpPeerInNotifications, msdpSACacheInDataPackets=msdpSACacheInDataPackets, msdpPeerConnectionAttempts=msdpPeerConnectionAttempts, msdpPeerInControlMessages=msdpPeerInControlMessages, msdpPeerKeepAliveConfigured=msdpPeerKeepAliveConfigured, msdpSACacheStatus=msdpSACacheStatus, msdpPeerInSAResponses=msdpPeerInSAResponses, msdpBackwardTransition=msdpBackwardTransition, msdpMIBPeerGroup2=msdpMIBPeerGroup2, msdpMIBCompliance=msdpMIBCompliance, msdpPeerDiscontinuityTime=msdpPeerDiscontinuityTime, msdpMIBConformance=msdpMIBConformance, msdpSACacheRPFPeer=msdpSACacheRPFPeer, msdpMIBRequestsGroup=msdpMIBRequestsGroup, msdpRequestsTable=msdpRequestsTable, msdpPeerDataTtl=msdpPeerDataTtl, msdpMIBEncapsulationGroup=msdpMIBEncapsulationGroup, msdpRequestsPeer=msdpRequestsPeer, msdpPeerOutSARequests=msdpPeerOutSARequests, msdpMIBRPGroup=msdpMIBRPGroup, msdpNumSACacheEntries=msdpNumSACacheEntries, msdpPeerOutSAs=msdpPeerOutSAs, msdpMeshGroupEntry=msdpMeshGroupEntry, msdpMIBPeerGroup=msdpMIBPeerGroup, msdpMIBCompliances=msdpMIBCompliances, msdpMIBMeshGroupGroup=msdpMIBMeshGroupGroup, msdpRequestsStatus=msdpRequestsStatus, msdpSACacheInSAs=msdpSACacheInSAs, msdpSACacheSourceAddr=msdpSACacheSourceAddr, msdpMIBobjects=msdpMIBobjects, msdpPeerStatus=msdpPeerStatus, msdpRequestsEntry=msdpRequestsEntry, msdpSACacheExpiryTime=msdpSACacheExpiryTime, msdpSACacheGroupAddr=msdpSACacheGroupAddr, msdpMeshGroupStatus=msdpMeshGroupStatus, msdpMIBNotificationGroup=msdpMIBNotificationGroup, msdpEnabled=msdpEnabled, msdpSACacheEntry=msdpSACacheEntry, msdpMIBReadOnlyCompliance=msdpMIBReadOnlyCompliance, msdpMIBSACacheGroup=msdpMIBSACacheGroup, msdpPeerInMessageTime=msdpPeerInMessageTime, msdpEstablished=msdpEstablished, msdpPeerState=msdpPeerState, msdpPeerLocalPort=msdpPeerLocalPort, msdpPeerRemoteAddress=msdpPeerRemoteAddress, msdpPeerFsmEstablishedTime=msdpPeerFsmEstablishedTime, msdpPeerOutNotifications=msdpPeerOutNotifications, msdpMIBFullCompliance=msdpMIBFullCompliance, msdpPeerLocalAddress=msdpPeerLocalAddress, msdpRequestsGroupAddress=msdpRequestsGroupAddress, msdpMIBGroups=msdpMIBGroups, msdp=msdp, msdpMeshGroupName=msdpMeshGroupName, msdpPeerFsmEstablishedTransitions=msdpPeerFsmEstablishedTransitions, msdpCacheLifetime=msdpCacheLifetime, msdpPeerInSARequests=msdpPeerInSARequests, msdpPeerOutSAResponses=msdpPeerOutSAResponses, msdpPeerOutControlMessages=msdpPeerOutControlMessages, msdpPeerLastError=msdpPeerLastError, msdpSACacheTable=msdpSACacheTable, msdpTraps=msdpTraps, msdpPeerInDataPackets=msdpPeerInDataPackets, msdpSACacheUpTime=msdpSACacheUpTime, msdpPeerEntry=msdpPeerEntry, msdpPeerOutDataPackets=msdpPeerOutDataPackets, msdpMIB=msdpMIB, msdpPeerTable=msdpPeerTable, msdpPeerProcessRequestsFrom=msdpPeerProcessRequestsFrom, msdpSACachePeerLearnedFrom=msdpSACachePeerLearnedFrom, msdpPeerConnectRetryInterval=msdpPeerConnectRetryInterval, msdpMIBGlobalsGroup=msdpMIBGlobalsGroup, msdpRequestsGroupMask=msdpRequestsGroupMask, msdpMeshGroupPeerAddress=msdpMeshGroupPeerAddress, msdpPeerEncapsulationType=msdpPeerEncapsulationType, msdpPeerRPFFailures=msdpPeerRPFFailures, msdpMeshGroupTable=msdpMeshGroupTable, msdpPeerInSAs=msdpPeerInSAs)
