---
title: QCoro 0.13.0 Release Announcement
date: "2026-02-13"
description: >
  AsyncGenerator improvements, build fixes and bugfixes
---

<!--
SPDX-FileCopyrightText: 2026 Daniel Vrátil <dvratil@kde.org>

SPDX-License-Identifier: GFDL-1.3-or-later
-->

# QCoro 0.13.0 Release Announcement

This release brings improvements to generators, better build system integration and
several bugfixes.

As always, big thanks to everyone who reported issues and contributed to QCoro.
Your help is much appreciated!

## Directly Awaiting Qt Types in AsyncGenerator Coroutines

The biggest improvement in this release is that `QCoro::AsyncGenerator` coroutines now support
directly `co_await`ing Qt types without the `qCoro()` wrapper, just like `QCoro::Task` coroutines
already do ([#292][issue292]).

Previously, if you wanted to await a `QNetworkReply` inside an `AsyncGenerator`, you had to
wrap it with `qCoro()`:

```cpp
QCoro::AsyncGenerator<QByteArray> fetchPages(QNetworkAccessManager &nam, QStringList urls) {
    for (const auto &url : urls) {
        auto *reply = co_await qCoro(nam.get(QNetworkRequest{QUrl{url}}));
        co_yield reply->readAll();
    }
}
```

Starting with QCoro 0.13.0, you can `co_await` directly, just like in `QCoro::Task`:

```cpp
QCoro::AsyncGenerator<QByteArray> fetchPages(QNetworkAccessManager &nam, QStringList urls) {
    for (const auto &url : urls) {
        auto *reply = co_await nam.get(QNetworkRequest{QUrl{url}});
        co_yield reply->readAll();
    }
}
```

## Other Features and Changes

* Generator's `.end()` method is now `const` (and `constexpr`), so it can be called on const generator objects ([#294][issue294]).
* `GeneratorIterator` can now be constructed in an invalid state, allowing lazy initialization of iterators ([#318][issue318]).
* `qcoro.h` now only includes QtNetwork and QtDBus headers when those features are actually enabled, resulting in cleaner builds when optional modules are disabled ([#280][issue280]).

## Bugfixes

* Fixed memory leak in QFuture coro wrapper when a task is destroyed while awaiting on a QFuture ([#312][issue312], Daniel Vrátil)
* Fixed include paths when using QCoro with CMake's FetchContent ([#282][issue282], Daniel Vrátil; [#310][pr310], Nicolas Fella)
* Fixed QCoroNetworkReply test on Qt 6.10 ([#305][pr305], Daniel Vrátil)

## Full changelog

[See changelog on Github](https://github.com/danvratil/qcoro/releases/tag/v0.13.0)

## Support

If you enjoy using QCoro, consider supporting its development on [GitHub Sponsors][github-sponsors] or buy me a coffee
on [Ko-fi][kofi] (after all, more coffee means more code, right?).

[issue292]: https://github.com/qcoro/qcoro/issues/292
[issue294]: https://github.com/qcoro/qcoro/issues/294
[issue318]: https://github.com/qcoro/qcoro/issues/318
[issue280]: https://github.com/qcoro/qcoro/issues/280
[issue312]: https://github.com/qcoro/qcoro/issues/312
[issue282]: https://github.com/qcoro/qcoro/issues/282
[pr310]: https://github.com/qcoro/qcoro/pull/310
[pr305]: https://github.com/qcoro/qcoro/pull/305

[github-sponsors]: https://github.com/sponsors/danvratil
[kofi]: https://ko-fi.com/danvratil
