% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cliapp-docs.R
\name{themes}
\alias{themes}
\title{CLI themes}
\description{
CLI elements can be styled via a CSS-like language of selectors and
properties. Only a small subset of CSS3 is supported, and
a lot visual properties cannot be implemented on a terminal, so these
will be ignored as well.
}
\section{Adding themes}{

The style of an element is calculated from themes from four sources.
These form a stack, and the themes on the top of the stack take
precedence, over themes in the bottom.
\enumerate{
\item The cli package has a builtin theme. This is always active.
See \code{\link[=builtin_theme]{builtin_theme()}}.
\item When an app object is created via \code{\link[=start_app]{start_app()}}, the caller can
specify a theme, that is added to theme stack. If no theme is
specified for \code{\link[=start_app]{start_app()}}, the content of the \code{cli.theme} option
is used. Removed when the corresponding app stops.
\item The user may speficy a theme in the \code{cli.user_theme} option. This
is added to the stack \emph{after} the app's theme (step 2.), so it can
override its settings. Removed when the app that added it stops.
\item Themes specified explicitly in \code{\link[=cli_div]{cli_div()}} elements. These are
removed from the theme stack, when the corresponding \code{\link[=cli_div]{cli_div()}}
elements are closed.
}
}

\section{Writing themes}{

A theme is a named list of lists. The name of each entry is a CSS
selector. Only a subset of CSS is supported:
\itemize{
\item Type selectors, e.g. \code{input} selects all \verb{<input>} elements.
\item Class selectors, e.g. \code{.index} selects any element that has a class
of "index".
\item ID selector. \verb{#toc} will match the element that has the ID "toc".
\item The descendant combinator, i.e. the space, that selects nodes
that are descendants of the first element. E.g. \verb{div span} will match
all \verb{<span>} elements that are inside a \verb{<div>} element.
}

The content of a theme list entry is another named list, where the
names are CSS properties, e.g. \code{color}, or \code{font-weight} or
\code{margin-left}, and the list entries themselves define the values of
the properties. See \code{\link[=builtin_theme]{builtin_theme()}} and \code{\link[=simple_theme]{simple_theme()}} for examples.
}

\section{Formatter callbacks}{

For flexibility, themes may also define formatter functions, with
property name \code{fmt}. These will be called once the other styles are
applied to an element. They are only called on elements that produce
output, i.e. \emph{not} on container elements.
}

\section{Supported properties}{

Right now only a limited set of properties are supported. These include
left, right, top and bottom margins, background and foreground colors,
bold and italic fonts, underlined text. The \code{before} and \code{after}
properties are supported to insert text before and after the
content of the element.

More properties might be adder later.

Please see the example themes and the source code for now for the
details.
}

\section{Examples}{

Color of headings, that are only active in paragraphs with an
'output' class:\preformatted{list(
  "par.output h1" = list("background-color" = "red", color = "#e0e0e0"),
  "par.output h2" = list("background-color" = "orange", color = "#e0e0e0"),
  "par.output h3" = list("background-color" = "blue", color = "#e0e0e0")
)
}

Create a custom alert type:\preformatted{list(
  ".alert-start" = list(before = symbol$play),
  ".alert-stop"  = list(before = symbol$stop)
)
}
}

