% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sheet_relocate.R
\name{sheet_relocate}
\alias{sheet_relocate}
\title{Relocate one or more (work)sheets}
\usage{
sheet_relocate(ss, sheet, .before = if (is.null(.after)) 1, .after = NULL)
}
\arguments{
\item{ss}{Something that identifies a Google Sheet:
\itemize{
\item its file id as a string or \code{\link[googledrive:drive_id]{drive_id}}
\item a URL from which we can recover the id
\item a one-row \code{\link[googledrive:dribble]{dribble}}, which is how googledrive
represents Drive files
\item an instance of \code{googlesheets4_spreadsheet}, which is what \code{\link[=gs4_get]{gs4_get()}}
returns
}

Processed through \code{\link[=as_sheets_id]{as_sheets_id()}}.}

\item{sheet}{Sheet to relocate, in the sense of "worksheet" or "tab". You can identify a sheet by name, with a string, or by position, with a number. You can pass a vector to move multiple sheets at once or even a list, if you need to mix names and positions.}

\item{.before, .after}{Specification of where to locate the sheets(s)
identified by \code{sheet}. Exactly one of \code{.before} and \code{.after} must be
specified. Refer to an existing sheet by name (via a string) or by position
(via a number).}
}
\value{
The input \code{ss}, as an instance of \code{\link{sheets_id}}
}
\description{
Move (work)sheets around within a (spread)Sheet. The outcome is most
predictable for these common and simple use cases:
\itemize{
\item Reorder and move one or more sheets to the front.
\item Move a single sheet to a specific (but arbitrary) location.
\item Move multiple sheets to the back with \code{.after = 100} (\code{.after} can be
any number greater than or equal to the number of sheets).
}

If your relocation task is more complicated and you are puzzled by the
result, break it into a sequence of simpler calls to
\code{sheet_relocate()}.
}
\examples{
\dontshow{if (gs4_has_token()) withAutoprint(\{ # examplesIf}
sheet_names <- c("alfa", "bravo", "charlie", "delta", "echo", "foxtrot")
ss <- gs4_create("sheet-relocate-demo", sheets = sheet_names)
sheet_names(ss)

# move one sheet, forwards then backwards
ss \%>\%
  sheet_relocate("echo", .before = "bravo") \%>\%
  sheet_names()
ss \%>\%
  sheet_relocate("echo", .after = "delta") \%>\%
  sheet_names()

# reorder and move multiple sheets to the front
ss \%>\%
  sheet_relocate(list("foxtrot", 4)) \%>\%
  sheet_names()

# put the sheets back in the original order
ss \%>\%
  sheet_relocate(sheet_names) \%>\%
  sheet_names()

# reorder and move multiple sheets to the back
ss \%>\%
  sheet_relocate(c("bravo", "alfa", "echo"), .after = 10) \%>\%
  sheet_names()

# clean up
gs4_find("sheet-relocate-demo") \%>\%
  googledrive::drive_trash()
\dontshow{\}) # examplesIf}
}
\seealso{
Constructs a batch of \code{UpdateSheetPropertiesRequest}s (one per sheet):
\itemize{
\item \url{https://developers.google.com/sheets/api/reference/rest/v4/spreadsheets/request#UpdateSheetPropertiesRequest}
}

Other worksheet functions: 
\code{\link{sheet_add}()},
\code{\link{sheet_append}()},
\code{\link{sheet_copy}()},
\code{\link{sheet_delete}()},
\code{\link{sheet_properties}()},
\code{\link{sheet_rename}()},
\code{\link{sheet_resize}()},
\code{\link{sheet_write}()}
}
\concept{worksheet functions}
