% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/movMF_reduce_partitional.R
\name{movMF_reduce_partitional}
\alias{movMF_reduce_partitional}
\title{von Mises-Fisher mixture model reduction - partitional method}
\usage{
movMF_reduce_partitional(
  means,
  concentrations,
  weights,
  target.num = 2,
  method = c("hclust", "kmedoids")
)
}
\arguments{
\item{means}{a \eqn{(K \times p)} matrix of means of the von Mises-Fisher components.}

\item{concentrations}{a \eqn{K} vector of concentrations of the von Mises-Fisher components.}

\item{weights}{a \eqn{K} vector of weights of the von Mises-Fisher components.}

\item{target.num}{a desired number of components after reduction. Default is 2.}

\item{method}{a clustering method to be used. Default is "hclust".}
}
\value{
a named list of the reduced mixture model containing \describe{
\item{means}{a \eqn{(\code{target.num} \times p)} matrix of means of the von Mises-Fisher components.}
\item{concentrations}{a \eqn{\code{target.num}} vector of concentrations of the von Mises-Fisher components.}
\item{weights}{a \eqn{\code{target.num}} vector of weights of the von Mises-Fisher components.}
}
}
\description{
When given parameters of the von Mises-Fisher mixture model, this function 
aims at mixture model reduction using a partitional method.
}
