% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patchwork-package.r
\docType{package}
\name{patchwork-package}
\alias{patchwork}
\alias{patchwork-package}
\title{patchwork: The Composer of Plots}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

The 'ggplot2' package provides a strong API for sequentially building up a plot, but does not concern itself with composition of multiple plots. 'patchwork' is a package that expands the API to allow for arbitrarily complex composition of plots by, among others, providing mathematical operators for combining multiple plots. Other packages that try to address this need (but with a different approach) are 'gridExtra' and 'cowplot'.
}
\section{Overview}{

The use and premise of \code{patchwork} is simple: Just add \code{ggplot2} plots
together to compose multiplot layouts. Because of this simplicity there is
not much more to say. Still, a few functions allow you to modify the
behaviour, e.g.:
\itemize{
\item \code{\link[=plot_layout]{plot_layout()}} allows you to define the grid that plots are put into
\item \code{\link[=plot_annotation]{plot_annotation()}} allows you to add titles, tags etc.
}
}

\section{Learn more}{

The guides below will teach you all about what you can do with patchwork.
\itemize{
\item \href{https://patchwork.data-imaginist.com/articles/patchwork.html}{Getting Started}
\item \href{https://patchwork.data-imaginist.com/articles/guides/assembly.html}{Assembling Plots}
\item \href{https://patchwork.data-imaginist.com/articles/guides/layout.html}{Defining Layouts}
\item \href{https://patchwork.data-imaginist.com/articles/guides/annotation.html}{Adding Annotation}
\item \href{https://patchwork.data-imaginist.com/articles/guides/multipage.html}{Aligning across pages}
}
}

\examples{
library(ggplot2)
# You can add plots saved to variables

p1 <- ggplot(mtcars) + geom_point(aes(mpg, disp))
p2 <- ggplot(mtcars) + geom_boxplot(aes(gear, disp, group = gear))

p1 + p2

# Or build it up in one step
ggplot(mtcars) +
  geom_point(aes(mpg, disp)) +
  ggplot(mtcars) +
  geom_boxplot(aes(gear, disp, group = gear))

}
\seealso{
Useful links:
\itemize{
  \item \url{https://patchwork.data-imaginist.com}
  \item \url{https://github.com/thomasp85/patchwork}
  \item Report bugs at \url{https://github.com/thomasp85/patchwork/issues}
}

}
\author{
\strong{Maintainer}: Thomas Lin Pedersen \email{thomasp85@gmail.com} (\href{https://orcid.org/0000-0002-5147-4711}{ORCID})

}
\keyword{internal}
