% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knitr.R
\name{render_notes}
\alias{render_notes}
\title{Renders rmarkdown Documents Using User Default Options}
\usage{
render_notes(
  input,
  output_format = NULL,
  output_options = NULL,
  ...,
  .config = NULL
)
}
\arguments{
\item{input}{The input file to be rendered. This can be an R script (.R),
an R Markdown document (.Rmd), or a plain markdown document.}

\item{output_format}{The R Markdown output format to convert to. The option
\code{"all"} will render all formats defined within the file. The option can
be the name of a format (e.g. \code{"html_document"}) and that will render
the document to that single format. One can also use a vector of format
names to render to multiple formats. Alternatively, you can pass an output
format object (e.g. \code{html_document()}). If using \code{NULL} then the
output format is the first one defined in the YAML frontmatter in the input
file (this defaults to HTML if no format is specified there).}

\item{output_options}{List of output options that can override the options
specified in metadata (e.g. could be used to force \code{self_contained} or
\code{mathjax = "local"}). Note that this is only valid when the output
format is read from metadata (i.e. not a custom format object passed to
\code{output_format}).}

\item{...}{other arguments passed to \code{\link[rmarkdown]{render}}}

\item{.config}{location of the default options (a YAML file).
Default behaviour is to look for file \code{'.rmarkdown.yaml'} in the user's
home directory, or, if missing, for a yaml section \code{rmarkdown::render}
in the user's R profile.}
}
\description{
Renders rmarkdown Documents Using User Default Options
}
\seealso{
\code{\link{read.yaml_section}}
}
