% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress-bars.R
\name{progress_bars}
\alias{progress_bars}
\title{Progress bars in purrr}
\description{
purrr's map functions have a \code{.progress} argument that you can use to
create a progress bar. \code{.progress} can be:
\itemize{
\item \code{FALSE}, the default: does not create a progress bar.
\item \code{TRUE}: creates a basic unnamed progress bar.
\item A string: creates a basic progress bar with the given name.
\item A named list of progress bar parameters, as described below.
}

It's good practice to name your progress bars, to make it clear what
calculation or process they belong to. We recommend keeping the names
under 20 characters, so the whole progress bar fits comfortably even on
on narrower displays.
\subsection{Progress bar parameters}{
\itemize{
\item \code{clear}: whether to remove the progress bar from the screen after
termination. Defaults to \code{TRUE}.
\item \code{format}: format string. This overrides the default format string of
the progress bar type. It must be given for the \code{custom} type.
Format strings may contain R expressions to evaluate in braces.
They support cli \link[cli:pluralization]{pluralization}, and
\link[=inline-markup]{styling} and they can contain special
\link[cli:progress-variables]{progress variables}.
\item \code{format_done}: format string for successful termination. By default
the same as \code{format}.
\item \code{format_failed}: format string for unsuccessful termination.
By default the same as \code{format}.
\item \code{name}: progress bar name. This is by default the empty string and it
is displayed at the beginning of the progress bar.
\item \code{show_after}: numeric scalar. Only show the progress bar after this
number of seconds. It overrides the \code{cli.progress_show_after}
global option.
\item \code{type}: progress bar type. Currently supported types are:
\itemize{
\item \code{iterator}: the default, a for loop or a mapping function,
\item \code{tasks}: a (typically small) number of tasks,
\item \code{download}: download of one file,
\item \code{custom}: custom type, \code{format} must not be \code{NULL} for this type.
The default display is different for each progress bar type.
}
}
}

\subsection{Further documentation}{

purrr's progress bars are powered by cli, so see
\href{https://cli.r-lib.org/articles/progress.html}{Introduction to progress bars in cli}
and \href{https://cli.r-lib.org/articles/progress-advanced.html}{Advanced cli progress bars}
for more details.
}
}
