% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trends.R
\name{get_trends}
\alias{get_trends}
\title{Get Twitter trends data.}
\usage{
get_trends(
  woeid = 1,
  lat = NULL,
  lng = NULL,
  exclude_hashtags = FALSE,
  token = NULL,
  parse = TRUE
)
}
\arguments{
\item{woeid}{Numeric, WOEID (Yahoo! Where On Earth ID) or character
string of desired town or country. Users may also supply latitude
and longitude coordinates to fetch the closest available trends
data given the provided location. Latitude/longitude coordinates
should be provided as WOEID value consisting of 2 numeric values
or via one latitude value and one longitude value (to the
appropriately named parameters).  To browse all available trend
places, see \code{\link[=trends_available]{trends_available()}}}

\item{lat}{Optional alternative to WOEID. Numeric, latitude in
degrees.  If two coordinates are provided for WOEID, this
function will coerce the first value to latitude.}

\item{lng}{Optional alternative to WOEID. Numeric, longitude in
degrees.  If two coordinates are provided for WOEID, this
function will coerce the second value to longitude.}

\item{exclude_hashtags}{Logical, indicating whether or not to
exclude hashtags. Defaults to FALSE--meaning, hashtags are
included in returned trends.}

\item{token}{Expert use only. Use this to override authentication for
a single API call. In most cases you are better off changing the
default for all calls. See \code{\link[=auth_as]{auth_as()}} for details.}

\item{parse}{If \code{TRUE}, the default, returns a tidy data frame. Use \code{FALSE}
to return the "raw" list corresponding to the JSON returned from the
Twitter API.}
}
\value{
Tibble data frame of trends data for a given geographical area.
}
\description{
Get Twitter trends data.
}
\examples{
if (auth_has_default()) {

## Retrieve available trends
trends <- trends_available()
trends

## Store WOEID for Worldwide trends
worldwide <- trends$woeid[grep("world", trends$name, ignore.case = TRUE)[1]]

## Retrieve worldwide trends datadata
ww_trends <- get_trends(worldwide)

## Preview trends data
ww_trends

## Retrieve trends data using latitude, longitude near New York City
nyc_trends <- get_trends(lat = 40.7, lng = -74.0)

## should be same result if lat/long supplied as first argument
nyc_trends <- get_trends(c(40.7, -74.0))

## Preview trends data
nyc_trends

## Provide a city or location name using a regular expression string to
## have the function internals do the WOEID lookup/matching for you
(luk <- get_trends("london"))

}

}
\seealso{
Other trends: 
\code{\link{trends_available}()}
}
\concept{trends}
