% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label-glue.R
\name{label_glue}
\alias{label_glue}
\title{Interpolated labels}
\usage{
label_glue(pattern = "{x}", ..., parse = FALSE, .envir = caller_env())
}
\arguments{
\item{pattern}{A glue string used for formatting. The \code{x} variable holds the
breaks, so that \code{"{x}"} (default) returns the breaks as-is.}

\item{...}{Arguments passed on to \code{\link[glue:glue]{glue::glue()}}.}

\item{parse}{Whether to return labels as expressions.}

\item{.envir}{[\code{environment}: \code{parent.frame()}]\cr Environment to evaluate each expression in. Expressions are
evaluated from left to right. If \code{.x} is an environment, the expressions are
evaluated in that environment and \code{.envir} is ignored. If \code{NULL} is passed, it is equivalent to \code{\link[=emptyenv]{emptyenv()}}.}
}
\value{
All \code{label_()} functions return a "labelling" function, i.e. a function that
takes a vector \code{x} and returns a character vector of \code{length(x)} giving a
label for each input value.

Labelling functions are designed to be used with the \code{labels} argument of
ggplot2 scales. The examples demonstrate their use with x scales, but
they work similarly for all scales, including those that generate legends
rather than axes.
}
\description{
Use \code{label_glue()} to perform string interpolation using the \pkg{glue}
package. Enclosed expressions will be evaluated as R code.
}
\examples{
# Example variables
animal  <- "penguin"
species <- c("Adelie",  "Chinstrap", "Emperor", "Gentoo")

# Typical use, note that {x} will become the breaks
demo_discrete(species, labels = label_glue("The {x}\n{animal}"))
# It adapts to the breaks that are present
demo_discrete(species[-3], labels =  label_glue("The {x}\n{animal}"))
# Contrary to directly glueing species + animal, which results in mislabelling!
demo_discrete(species[-3], labels = glue::glue("The {species}\n{animal}"))
}
\seealso{
Other labels for continuous scales: 
\code{\link{label_bytes}()},
\code{\link{label_currency}()},
\code{\link{label_number_auto}()},
\code{\link{label_number_si}()},
\code{\link{label_ordinal}()},
\code{\link{label_parse}()},
\code{\link{label_percent}()},
\code{\link{label_pvalue}()},
\code{\link{label_scientific}()}

Other labels for discrete scales: 
\code{\link{label_dictionary}()},
\code{\link{label_parse}()},
\code{\link{label_wrap}()}
}
\concept{labels for continuous scales}
\concept{labels for discrete scales}
