% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci.R
\name{use_gitlab_ci}
\alias{use_gitlab_ci}
\alias{use_circleci}
\alias{use_circleci_badge}
\title{Continuous integration setup and badges}
\usage{
use_gitlab_ci()

use_circleci(browse = rlang::is_interactive(), image = "rocker/verse:latest")

use_circleci_badge(repo_spec = NULL)
}
\arguments{
\item{browse}{Open a browser window to enable automatic builds for the
package.}

\item{image}{The Docker image to use for build. Must be available on
\href{https://hub.docker.com}{DockerHub}. The
\href{https://hub.docker.com/r/rocker/verse}{rocker/verse} image includes
TeXLive, pandoc, and the tidyverse packages. For a minimal image, try
\href{https://hub.docker.com/r/rocker/r-ver}{rocker/r-ver}. To specify a version
of R, change the tag from \code{latest} to the version you want, e.g.
\verb{rocker/r-ver:3.5.3}.}

\item{repo_spec}{Optional GitHub repo specification in this form: \code{owner/repo}. This can usually be inferred from the GitHub remotes of active project.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#questioning}{\figure{lifecycle-questioning.svg}{options: alt='[Questioning]'}}}{\strong{[Questioning]}}

These functions are not actively used by the tidyverse team, and may not
currently work. Use at your own risk.

Sets up third-party continuous integration (CI) services for an R package
on GitLab or CircleCI. These functions:
\itemize{
\item Add service-specific configuration files and add them to \code{.Rbuildignore}.
\item Activate a service or give the user a detailed prompt.
\item Provide the markdown to insert a badge into README.
}
}
\section{\code{use_gitlab_ci()}}{

Adds a basic \code{.gitlab-ci.yml} to the top-level directory of a package. This
is a configuration file for the \href{https://docs.gitlab.com/ee/ci/}{GitLab CI/CD} continuous integration service.
}

\section{\code{use_circleci()}}{

Adds a basic \code{.circleci/config.yml} to the top-level directory of a package.
This is a configuration file for the \href{https://circleci.com/}{CircleCI}
continuous integration service.
}

\section{\code{use_circleci_badge()}}{

Only adds the \href{https://circleci.com/}{Circle CI} badge. Use for a project
where Circle CI is already configured.
}

