/*
RailControl - Model Railway Control Software

Copyright (c) 2017-2025 by Teddy / Dominik Mahrer - www.railcontrol.org

RailControl is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 3, or (at your option) any
later version.

RailControl is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with RailControl; see the file LICENCE. If not see
<http://www.gnu.org/licenses/>.
*/

#pragma once

#include <string>

#include "DataModel/ObjectIdentifier.h"
#include "Server/Web/HtmlTag.h"
#include "Server/Web/HtmlTagLabel.h"
#include "Server/Web/HtmlTagSelect.h"

namespace Server { namespace Web
{
	class HtmlTagSelectWithLabel : public HtmlTag
	{
		public:
			HtmlTagSelectWithLabel() = delete;

			HtmlTagSelectWithLabel(const std::string& name,
				const Languages::TextSelector label,
				const std::map<std::string,DataModel::ObjectIdentifier>& options,
				const DataModel::ObjectIdentifier& defaultValue = DataModel::ObjectIdentifier());

			template<typename T>
			HtmlTagSelectWithLabel(const std::string& name,
				const Languages::TextSelector label,
				const std::map<std::string,T>& options,
				const int defaultValue = 0)
			:	HtmlTag("div")
			{
				HtmlTag::AddClass("input_select_with_label");
				AddChildTag(HtmlTagLabel(label, "s_" + name));
				AddChildTag(HtmlTagSelect(name, options, defaultValue));
			}

			template<typename T>
			HtmlTagSelectWithLabel(const std::string& name,
				const Languages::TextSelector label,
				const Languages::TextSelector hint,
				const std::map<std::string,T>& options,
				const int defaultValue = 0)
			:	HtmlTag("div")
			{
				HtmlTag::AddClass("input_select_with_label");
				AddChildTag(HtmlTagLabel(label, hint, "s_" + name));
				AddChildTag(HtmlTagSelect(name, options, defaultValue));
			}

			template<typename T>
			HtmlTagSelectWithLabel(const std::string& name,
				const Languages::TextSelector label,
				const std::map<T,Languages::TextSelector>& options,
				const T defaultValue = 0)
			:	HtmlTag("div")
			{
				HtmlTag::AddClass("input_select_with_label");
				AddChildTag(HtmlTagLabel(label, "s_" + name));
				AddChildTag(HtmlTagSelect(name, options, defaultValue));
			}

			template<typename T>
			HtmlTagSelectWithLabel(const std::string& name,
				const Languages::TextSelector label,
				const Languages::TextSelector hint,
				const std::map<T,Languages::TextSelector>& options,
				const T defaultValue = 0)
			:	HtmlTag("div")
			{
				HtmlTag::AddClass("input_select_with_label");
				AddChildTag(HtmlTagLabel(label, hint, "s_" + name));
				AddChildTag(HtmlTagSelect(name, options, defaultValue));
			}

			template<typename T>
			HtmlTagSelectWithLabel(const std::string& name,
				const Languages::TextSelector label,
				const std::map<T,std::string>& options,
				const T defaultValue = 0)
			:	HtmlTag("div")
			{
				HtmlTag::AddClass("input_select_with_label");
				AddChildTag(HtmlTagLabel(label, "s_" + name));
				AddChildTag(HtmlTagSelect(name, options, defaultValue));
			}

			template<typename T>
			HtmlTagSelectWithLabel(const std::string& name,
				const std::string& label,
				const std::map<T,std::string>& options,
				const T defaultValue = 0)
			:	HtmlTag("div")
			{
				HtmlTag::AddClass("input_select_with_label");
				AddChildTag(HtmlTagLabel(label, "s_" + name));
				AddChildTag(HtmlTagSelect(name, options, defaultValue));
			}

			virtual ~HtmlTagSelectWithLabel()
			{
			}

			virtual HtmlTag AddAttribute(const std::string& name, const std::string& value = "") override;

			virtual bool IsAttributeSet(const std::string& name) override;

			virtual HtmlTag AddClass(const std::string& _class) override;
	};
}} // namespace Server::Web

