// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Security.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.security {

  public class SSHHostKey : ICloneable {
    public object Clone() {
      SSHHostKey copy = new SSHHostKey();
      copy.key = this.key;
      copy.type = this.type;
      copy.fingerprints = this.fingerprints;
      return copy;
    }

    public LightJson.JsonObject Encode() {
      LightJson.JsonObject json = new LightJson.JsonObject();
      json["key"] = this.key;
      json["type"] = (int)this.type;
      json["fingerprints"] = new JsonArray(this.fingerprints.Select(
        _value => (JsonValue)(_value.Encode())));
      return json;
    }

    public static SSHHostKey Decode(LightJson.JsonObject json, Agent agent) {
      SSHHostKey inst = new SSHHostKey();
      inst.key = (string)json["key"];
      inst.type = (Com.Raritan.Idl.security.SSHHostKeyType)(int)json["type"];
      inst.fingerprints = new System.Collections.Generic.List<Com.Raritan.Idl.security.SSHKeyFingerprint>(json["fingerprints"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.security.SSHKeyFingerprint.Decode(_value, agent)));
      return inst;
    }

    public string key = "";
    public Com.Raritan.Idl.security.SSHHostKeyType type = Com.Raritan.Idl.security.SSHHostKeyType.SSH_HOST_KEY_TYPE_RSA;
    public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.security.SSHKeyFingerprint> fingerprints = new System.Collections.Generic.List<Com.Raritan.Idl.security.SSHKeyFingerprint>();
  }
}
