/* Generated by re2c */
// re2c $INPUT -o $OUTPUT -igcd --flex-syntax --case-inverted
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) 1998-2015 Zend Technologies Ltd. (http://www.zend.com) |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   | Flex version authors:                                                |
   |          Andi Gutmans <andi@zend.com>                                |
   |          Zeev Suraski <zeev@zend.com>                                |
   +----------------------------------------------------------------------+
*/

/* $Id$ */

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_language_scanner_defs.h"

#include <errno.h>
#include "zend.h"
#ifdef PHP_WIN32
# include <Winuser.h>
#endif
#include "zend_alloc.h"
#include <zend_language_parser.h>
#include "zend_compile.h"
#include "zend_language_scanner.h"
#include "zend_highlight.h"
#include "zend_constants.h"
#include "zend_variables.h"
#include "zend_operators.h"
#include "zend_API.h"
#include "zend_strtod.h"
#include "zend_exceptions.h"
#include "zend_virtual_cwd.h"
#include "tsrm_config_common.h"

#define YYCTYPE   unsigned char
#define YYFILL(n) { if ((YYCURSOR + n) >= (YYLIMIT + ZEND_MMAP_AHEAD)) { return 0; } }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do { YYCURSOR = (unsigned char*)yytext + x; \
                          yyleng   = (unsigned int)x; } while(0)
#define yymore()     goto yymore_restart

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 16

#if ZEND_MMAP_AHEAD < YYMAXFILL
# error ZEND_MMAP_AHEAD should be greater than or equal to YYMAXFILL
#endif

#ifdef HAVE_STDARG_H
# include <stdarg.h>
#endif

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

/* Globals Macros */
#define SCNG	LANG_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id language_scanner_globals_id;
#else
ZEND_API zend_php_scanner_globals language_scanner_globals;
#endif

#define HANDLE_NEWLINES(s, l)													\
do {																			\
	char *p = (s), *boundary = p+(l);											\
																				\
	while (p<boundary) {														\
		if (*p == '\n' || (*p == '\r' && (*(p+1) != '\n'))) {					\
			CG(zend_lineno)++;													\
		}																		\
		p++;																	\
	}																			\
} while (0)

#define HANDLE_NEWLINE(c) \
{ \
	if (c == '\n' || c == '\r') { \
		CG(zend_lineno)++; \
	} \
}

/* To save initial string length after scanning to first variable */
#define SET_DOUBLE_QUOTES_SCANNED_LENGTH(len) SCNG(scanned_string_len) = (len)
#define GET_DOUBLE_QUOTES_SCANNED_LENGTH()    SCNG(scanned_string_len)

#define IS_LABEL_START(c) (((c) >= 'a' && (c) <= 'z') || ((c) >= 'A' && (c) <= 'Z') || (c) == '_' || (c) >= 0x7F)

#define ZEND_IS_OCT(c)  ((c)>='0' && (c)<='7')
#define ZEND_IS_HEX(c)  (((c)>='0' && (c)<='9') || ((c)>='a' && (c)<='f') || ((c)>='A' && (c)<='F'))

BEGIN_EXTERN_C()

static size_t encoding_filter_script_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	ZEND_ASSERT(internal_encoding);
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, internal_encoding, LANG_SCNG(script_encoding));
}

static size_t encoding_filter_script_to_intermediate(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, zend_multibyte_encoding_utf8, LANG_SCNG(script_encoding));
}

static size_t encoding_filter_intermediate_to_script(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
LANG_SCNG(script_encoding), zend_multibyte_encoding_utf8);
}

static size_t encoding_filter_intermediate_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	ZEND_ASSERT(internal_encoding);
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
internal_encoding, zend_multibyte_encoding_utf8);
}


static void _yy_push_state(int new_state)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION());
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(void)
{
	int *stack_state = zend_stack_top(&SCNG(state_stack));
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, unsigned int len)
{
	YYCURSOR       = (YYCTYPE*)str;
	YYLIMIT        = YYCURSOR + len;
	if (!SCNG(yy_start)) {
		SCNG(yy_start) = YYCURSOR;
	}
}

void startup_scanner(void)
{
	CG(parse_error) = 0;
	CG(doc_comment) = NULL;
	zend_stack_init(&SCNG(state_stack), sizeof(int));
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));
}

static void heredoc_label_dtor(zend_heredoc_label *heredoc_label) {
    efree(heredoc_label->label);
}

void shutdown_scanner(void)
{
	CG(parse_error) = 0;
	RESET_DOC_COMMENT();
	zend_stack_destroy(&SCNG(state_stack));
	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
}

ZEND_API void zend_save_lexical_state(zend_lex_state *lex_state)
{
	lex_state->yy_leng   = SCNG(yy_leng);
	lex_state->yy_start  = SCNG(yy_start);
	lex_state->yy_text   = SCNG(yy_text);
	lex_state->yy_cursor = SCNG(yy_cursor);
	lex_state->yy_marker = SCNG(yy_marker);
	lex_state->yy_limit  = SCNG(yy_limit);

	lex_state->state_stack = SCNG(state_stack);
	zend_stack_init(&SCNG(state_stack), sizeof(int));

	lex_state->heredoc_label_stack = SCNG(heredoc_label_stack);
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));

	lex_state->in = SCNG(yy_in);
	lex_state->yy_state = YYSTATE;
	lex_state->filename = zend_get_compiled_filename();
	lex_state->lineno = CG(zend_lineno);

	lex_state->script_org = SCNG(script_org);
	lex_state->script_org_size = SCNG(script_org_size);
	lex_state->script_filtered = SCNG(script_filtered);
	lex_state->script_filtered_size = SCNG(script_filtered_size);
	lex_state->input_filter = SCNG(input_filter);
	lex_state->output_filter = SCNG(output_filter);
	lex_state->script_encoding = SCNG(script_encoding);

	lex_state->ast = CG(ast);
	lex_state->ast_arena = CG(ast_arena);
}

ZEND_API void zend_restore_lexical_state(zend_lex_state *lex_state)
{
	SCNG(yy_leng)   = lex_state->yy_leng;
	SCNG(yy_start)  = lex_state->yy_start;
	SCNG(yy_text)   = lex_state->yy_text;
	SCNG(yy_cursor) = lex_state->yy_cursor;
	SCNG(yy_marker) = lex_state->yy_marker;
	SCNG(yy_limit)  = lex_state->yy_limit;

	zend_stack_destroy(&SCNG(state_stack));
	SCNG(state_stack) = lex_state->state_stack;

	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
	SCNG(heredoc_label_stack) = lex_state->heredoc_label_stack;

	SCNG(yy_in) = lex_state->in;
	YYSETCONDITION(lex_state->yy_state);
	CG(zend_lineno) = lex_state->lineno;
	zend_restore_compiled_filename(lex_state->filename);

	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	SCNG(script_org) = lex_state->script_org;
	SCNG(script_org_size) = lex_state->script_org_size;
	SCNG(script_filtered) = lex_state->script_filtered;
	SCNG(script_filtered_size) = lex_state->script_filtered_size;
	SCNG(input_filter) = lex_state->input_filter;
	SCNG(output_filter) = lex_state->output_filter;
	SCNG(script_encoding) = lex_state->script_encoding;

	CG(ast) = lex_state->ast;
	CG(ast_arena) = lex_state->ast_arena;

	RESET_DOC_COMMENT();
}

ZEND_API void zend_destroy_file_handle(zend_file_handle *file_handle)
{
	zend_llist_del_element(&CG(open_files), file_handle, (int (*)(void *, void *)) zend_compare_file_handles);
	/* zend_file_handle_dtor() operates on the copy, so we have to NULLify the original here */
	file_handle->opened_path = NULL;
	if (file_handle->free_filename) {
		file_handle->filename = NULL;
	}
}

#define BOM_UTF32_BE	"\x00\x00\xfe\xff"
#define	BOM_UTF32_LE	"\xff\xfe\x00\x00"
#define	BOM_UTF16_BE	"\xfe\xff"
#define	BOM_UTF16_LE	"\xff\xfe"
#define	BOM_UTF8		"\xef\xbb\xbf"

static const zend_encoding *zend_multibyte_detect_utf_encoding(const unsigned char *script, size_t script_size)
{
	const unsigned char *p;
	int wchar_size = 2;
	int le = 0;

	/* utf-16 or utf-32? */
	p = script;
	assert(p >= script);
	while ((size_t)(p-script) < script_size) {
		p = memchr(p, 0, script_size-(p-script)-2);
		if (!p) {
			break;
		}
		if (*(p+1) == '\0' && *(p+2) == '\0') {
			wchar_size = 4;
			break;
		}

		/* searching for UTF-32 specific byte orders, so this will do */
		p += 4;
	}

	/* BE or LE? */
	p = script;
	assert(p >= script);
	while ((size_t)(p-script) < script_size) {
		if (*p == '\0' && *(p+wchar_size-1) != '\0') {
			/* BE */
			le = 0;
			break;
		} else if (*p != '\0' && *(p+wchar_size-1) == '\0') {
			/* LE* */
			le = 1;
			break;
		}
		p += wchar_size;
	}

	if (wchar_size == 2) {
		return le ? zend_multibyte_encoding_utf16le : zend_multibyte_encoding_utf16be;
	} else {
		return le ? zend_multibyte_encoding_utf32le : zend_multibyte_encoding_utf32be;
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_detect_unicode(void)
{
	const zend_encoding *script_encoding = NULL;
	int bom_size;
	unsigned char *pos1, *pos2;

	if (LANG_SCNG(script_org_size) < sizeof(BOM_UTF32_LE)-1) {
		return NULL;
	}

	/* check out BOM */
	if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_BE, sizeof(BOM_UTF32_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32be;
		bom_size = sizeof(BOM_UTF32_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_LE, sizeof(BOM_UTF32_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32le;
		bom_size = sizeof(BOM_UTF32_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_BE, sizeof(BOM_UTF16_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16be;
		bom_size = sizeof(BOM_UTF16_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_LE, sizeof(BOM_UTF16_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16le;
		bom_size = sizeof(BOM_UTF16_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF8, sizeof(BOM_UTF8)-1)) {
		script_encoding = zend_multibyte_encoding_utf8;
		bom_size = sizeof(BOM_UTF8)-1;
	}

	if (script_encoding) {
		/* remove BOM */
		LANG_SCNG(script_org) += bom_size;
		LANG_SCNG(script_org_size) -= bom_size;

		return script_encoding;
	}

	/* script contains NULL bytes -> auto-detection */
	if ((pos1 = memchr(LANG_SCNG(script_org), 0, LANG_SCNG(script_org_size)))) {
		/* check if the NULL byte is after the __HALT_COMPILER(); */
		pos2 = LANG_SCNG(script_org);

		while (pos1 - pos2 >= sizeof("__HALT_COMPILER();")-1) {
			pos2 = memchr(pos2, '_', pos1 - pos2);
			if (!pos2) break;
			pos2++;
			if (strncasecmp((char*)pos2, "_HALT_COMPILER", sizeof("_HALT_COMPILER")-1) == 0) {
				pos2 += sizeof("_HALT_COMPILER")-1;
				while (*pos2 == ' '  ||
					   *pos2 == '\t' ||
					   *pos2 == '\r' ||
					   *pos2 == '\n') {
					pos2++;
				}
				if (*pos2 == '(') {
					pos2++;
					while (*pos2 == ' '  ||
						   *pos2 == '\t' ||
						   *pos2 == '\r' ||
						   *pos2 == '\n') {
						pos2++;
					}
					if (*pos2 == ')') {
						pos2++;
						while (*pos2 == ' '  ||
							   *pos2 == '\t' ||
							   *pos2 == '\r' ||
							   *pos2 == '\n') {
							pos2++;
						}
						if (*pos2 == ';') {
							return NULL;
						}
					}
				}
			}
		}
		/* make best effort if BOM is missing */
		return zend_multibyte_detect_utf_encoding(LANG_SCNG(script_org), LANG_SCNG(script_org_size));
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_find_script_encoding(void)
{
	const zend_encoding *script_encoding;

	if (CG(detect_unicode)) {
		/* check out bom(byte order mark) and see if containing wchars */
		script_encoding = zend_multibyte_detect_unicode();
		if (script_encoding != NULL) {
			/* bom or wchar detection is prior to 'script_encoding' option */
			return script_encoding;
		}
	}

	/* if no script_encoding specified, just leave alone */
	if (!CG(script_encoding_list) || !CG(script_encoding_list_size)) {
		return NULL;
	}

	/* if multiple encodings specified, detect automagically */
	if (CG(script_encoding_list_size) > 1) {
		return zend_multibyte_encoding_detector(LANG_SCNG(script_org), LANG_SCNG(script_org_size), CG(script_encoding_list), CG(script_encoding_list_size));
	}

	return CG(script_encoding_list)[0];
}

ZEND_API int zend_multibyte_set_filter(const zend_encoding *onetime_encoding)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	const zend_encoding *script_encoding = onetime_encoding ? onetime_encoding: zend_multibyte_find_script_encoding();

	if (!script_encoding) {
		return FAILURE;
	}

	/* judge input/output filter */
	LANG_SCNG(script_encoding) = script_encoding;
	LANG_SCNG(input_filter) = NULL;
	LANG_SCNG(output_filter) = NULL;

	if (!internal_encoding || LANG_SCNG(script_encoding) == internal_encoding) {
		if (!zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
			/* and if not, work around w/ script_encoding -> utf-8 -> script_encoding conversion */
			LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
			LANG_SCNG(output_filter) = encoding_filter_intermediate_to_script;
		} else {
			LANG_SCNG(input_filter) = NULL;
			LANG_SCNG(output_filter) = NULL;
		}
		return SUCCESS;
	}

	if (zend_multibyte_check_lexer_compatibility(internal_encoding)) {
		LANG_SCNG(input_filter) = encoding_filter_script_to_internal;
		LANG_SCNG(output_filter) = NULL;
	} else if (zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
		LANG_SCNG(input_filter) = NULL;
		LANG_SCNG(output_filter) = encoding_filter_script_to_internal;
	} else {
		/* both script and internal encodings are incompatible w/ flex */
		LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
		LANG_SCNG(output_filter) = encoding_filter_intermediate_to_internal;
	}

	return 0;
}

ZEND_API int open_file_for_scanning(zend_file_handle *file_handle)
{
	const char *file_path = NULL;
	char *buf;
	size_t size, offset = 0;
	zend_string *compiled_filename;

	/* The shebang line was read, get the current position to obtain the buffer start */
	if (CG(start_lineno) == 2 && file_handle->type == ZEND_HANDLE_FP && file_handle->handle.fp) {
		if ((offset = ftell(file_handle->handle.fp)) == -1) {
			offset = 0;
		}
	}

	if (zend_stream_fixup(file_handle, &buf, &size) == FAILURE) {
		return FAILURE;
	}

	zend_llist_add_element(&CG(open_files), file_handle);
	if (file_handle->handle.stream.handle >= (void*)file_handle && file_handle->handle.stream.handle <= (void*)(file_handle+1)) {
		zend_file_handle *fh = (zend_file_handle*)zend_llist_get_last(&CG(open_files));
		size_t diff = (char*)file_handle->handle.stream.handle - (char*)file_handle;
		fh->handle.stream.handle = (void*)(((char*)fh) + diff);
		file_handle->handle.stream.handle = fh->handle.stream.handle;
	}

	/* Reset the scanner for scanning the new file */
	SCNG(yy_in) = file_handle;
	SCNG(yy_start) = NULL;

	if (size != -1) {
		if (CG(multibyte)) {
			SCNG(script_org) = (unsigned char*)buf;
			SCNG(script_org_size) = size;
			SCNG(script_filtered) = NULL;

			zend_multibyte_set_filter(NULL);

			if (SCNG(input_filter)) {
				if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size))) {
					zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
							"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
				}
				buf = (char*)SCNG(script_filtered);
				size = SCNG(script_filtered_size);
			}
		}
		SCNG(yy_start) = (unsigned char *)buf - offset;
		yy_scan_buffer(buf, (unsigned int)size);
	} else {
		zend_error_noreturn(E_COMPILE_ERROR, "zend_stream_mmap() failed");
	}

	BEGIN(INITIAL);

	if (file_handle->opened_path) {
		file_path = file_handle->opened_path;
	} else {
		file_path = file_handle->filename;
	}

	compiled_filename = zend_string_init(file_path, strlen(file_path), 0);
	zend_set_compiled_filename(compiled_filename);
	zend_string_release(compiled_filename);

	if (CG(start_lineno)) {
		CG(zend_lineno) = CG(start_lineno);
		CG(start_lineno) = 0;
	} else {
		CG(zend_lineno) = 1;
	}

	RESET_DOC_COMMENT();
	CG(increment_lineno) = 0;
	return SUCCESS;
}
END_EXTERN_C()


ZEND_API zend_op_array *compile_file(zend_file_handle *file_handle, int type)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = (zend_op_array *) emalloc(sizeof(zend_op_array));
	zend_op_array *original_active_op_array = CG(active_op_array);
	int compiler_result;
	zend_bool compilation_successful=0;
	zval retval_zv;
	zend_bool original_in_compilation = CG(in_compilation);

	ZVAL_LONG(&retval_zv, 1);

	zend_save_lexical_state(&original_lex_state);

	if (open_file_for_scanning(file_handle)==FAILURE) {
		if (type==ZEND_REQUIRE) {
			zend_message_dispatcher(ZMSG_FAILED_REQUIRE_FOPEN, file_handle->filename);
			zend_bailout();
		} else {
			zend_message_dispatcher(ZMSG_FAILED_INCLUDE_FOPEN, file_handle->filename);
		}
		compilation_successful=0;
	} else {
		init_op_array(op_array, ZEND_USER_FUNCTION, INITIAL_OP_ARRAY_SIZE);
		CG(in_compilation) = 1;
		CG(active_op_array) = op_array;
		zend_stack_push(&CG(context_stack), (void *) &CG(context));
		zend_init_compiler_context();
		CG(ast_arena) = zend_arena_create(1024 * 32);
		compiler_result = zendparse();
		if (compiler_result != 0) { /* parser error */
			zend_bailout();
		}
		if (zend_ast_process) {
			zend_ast_process(CG(ast));
		}
		zend_compile_top_stmt(CG(ast));
		zend_ast_destroy(CG(ast));
		zend_arena_destroy(CG(ast_arena));
		zend_do_end_compilation();
		zend_emit_final_return(&retval_zv);
		CG(in_compilation) = original_in_compilation;
		compilation_successful=1;
	}

	CG(active_op_array) = original_active_op_array;
	if (compilation_successful) {
		pass_two(op_array);
		zend_release_labels(0);
	} else {
		efree_size(op_array, sizeof(zend_op_array));
		op_array = NULL;
	}

	zend_restore_lexical_state(&original_lex_state);
	return op_array;
}


zend_op_array *compile_filename(int type, zval *filename)
{
	zend_file_handle file_handle;
	zval tmp;
	zend_op_array *retval;
	char *opened_path = NULL;

	if (Z_TYPE_P(filename) != IS_STRING) {
		tmp = *filename;
		zval_copy_ctor(&tmp);
		convert_to_string(&tmp);
		filename = &tmp;
	}
	file_handle.filename = Z_STRVAL_P(filename);
	file_handle.free_filename = 0;
	file_handle.type = ZEND_HANDLE_FILENAME;
	file_handle.opened_path = NULL;
	file_handle.handle.fp = NULL;

	retval = zend_compile_file(&file_handle, type);
	if (retval && file_handle.handle.stream.handle) {
		if (!file_handle.opened_path) {
			file_handle.opened_path = opened_path = estrndup(Z_STRVAL_P(filename), Z_STRLEN_P(filename));
		}

		zend_hash_str_add_empty_element(&EG(included_files), file_handle.opened_path, strlen(file_handle.opened_path));

		if (opened_path) {
			efree(opened_path);
		}
	}
	zend_destroy_file_handle(&file_handle);

	if (filename==&tmp) {
		zval_dtor(&tmp);
	}
	return retval;
}

ZEND_API int zend_prepare_string_for_scanning(zval *str, char *filename)
{
	char *buf;
	size_t size, old_len;
	zend_string *new_compiled_filename;

	/* enforce ZEND_MMAP_AHEAD trailing NULLs for flex... */
	old_len = Z_STRLEN_P(str);
	Z_STR_P(str) = zend_string_realloc(Z_STR_P(str), old_len + ZEND_MMAP_AHEAD, 0);
	Z_TYPE_INFO_P(str) = IS_STRING_EX;
	memset(Z_STRVAL_P(str) + old_len, 0, ZEND_MMAP_AHEAD + 1);

	SCNG(yy_in) = NULL;
	SCNG(yy_start) = NULL;

	buf = Z_STRVAL_P(str);
	size = old_len;

	if (CG(multibyte)) {
		SCNG(script_org) = (unsigned char*)buf;
		SCNG(script_org_size) = size;
		SCNG(script_filtered) = NULL;

		zend_multibyte_set_filter(zend_multibyte_get_internal_encoding());

		if (SCNG(input_filter)) {
			if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size))) {
				zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
						"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
			}
			buf = (char*)SCNG(script_filtered);
			size = SCNG(script_filtered_size);
		}
	}

	yy_scan_buffer(buf, (unsigned int)size);

	new_compiled_filename = zend_string_init(filename, strlen(filename), 0);
	zend_set_compiled_filename(new_compiled_filename);
	zend_string_release(new_compiled_filename);
	CG(zend_lineno) = 1;
	CG(increment_lineno) = 0;
	RESET_DOC_COMMENT();
	return SUCCESS;
}


ZEND_API size_t zend_get_scanned_file_offset(void)
{
	size_t offset = SCNG(yy_cursor) - SCNG(yy_start);
	if (SCNG(input_filter)) {
		size_t original_offset = offset, length = 0;
		do {
			unsigned char *p = NULL;
			if ((size_t)-1 == SCNG(input_filter)(&p, &length, SCNG(script_org), offset)) {
				return (size_t)-1;
			}
			efree(p);
			if (length > original_offset) {
				offset--;
			} else if (length < original_offset) {
				offset++;
			}
		} while (original_offset != length);
	}
	return offset;
}


zend_op_array *compile_string(zval *source_string, char *filename)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = NULL;
	zval tmp;
	zend_bool original_in_compilation = CG(in_compilation);

	if (Z_STRLEN_P(source_string)==0) {
		return NULL;
	}

	ZVAL_DUP(&tmp, source_string);
	convert_to_string(&tmp);
	source_string = &tmp;

	CG(in_compilation) = 1;
	zend_save_lexical_state(&original_lex_state);
	if (zend_prepare_string_for_scanning(source_string, filename) == SUCCESS) {
		CG(ast) = NULL;
		CG(ast_arena) = zend_arena_create(1024 * 32);
		BEGIN(ST_IN_SCRIPTING);

		if (!zendparse()) {
			zend_op_array *original_active_op_array = CG(active_op_array);
			op_array = emalloc(sizeof(zend_op_array));
			init_op_array(op_array, ZEND_EVAL_CODE, INITIAL_OP_ARRAY_SIZE);
			CG(active_op_array) = op_array;

			zend_stack_push(&CG(context_stack), (void *) &CG(context));
			zend_init_compiler_context();
			if (zend_ast_process) {
				zend_ast_process(CG(ast));
			}
			zend_compile_top_stmt(CG(ast));
			zend_do_end_compilation();
			zend_emit_final_return(NULL);
			pass_two(op_array);
			zend_release_labels(0);

			CG(active_op_array) = original_active_op_array;
		}

		zend_ast_destroy(CG(ast));
		zend_arena_destroy(CG(ast_arena));
	}

	zend_restore_lexical_state(&original_lex_state);
	zval_dtor(&tmp);
	CG(in_compilation) = original_in_compilation;
	return op_array;
}


BEGIN_EXTERN_C()
int highlight_file(char *filename, zend_syntax_highlighter_ini *syntax_highlighter_ini)
{
	zend_lex_state original_lex_state;
	zend_file_handle file_handle;

	file_handle.type = ZEND_HANDLE_FILENAME;
	file_handle.filename = filename;
	file_handle.free_filename = 0;
	file_handle.opened_path = NULL;
	zend_save_lexical_state(&original_lex_state);
	if (open_file_for_scanning(&file_handle)==FAILURE) {
		zend_message_dispatcher(ZMSG_FAILED_HIGHLIGHT_FOPEN, filename);
		zend_restore_lexical_state(&original_lex_state);
		return FAILURE;
	}
	zend_highlight(syntax_highlighter_ini);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_destroy_file_handle(&file_handle);
	zend_restore_lexical_state(&original_lex_state);
	return SUCCESS;
}

int highlight_string(zval *str, zend_syntax_highlighter_ini *syntax_highlighter_ini, char *str_name)
{
	zend_lex_state original_lex_state;
	zval tmp = *str;

	str = &tmp;
	zval_copy_ctor(str);
	zend_save_lexical_state(&original_lex_state);
	if (zend_prepare_string_for_scanning(str, str_name)==FAILURE) {
		zend_restore_lexical_state(&original_lex_state);
		return FAILURE;
	}
	BEGIN(INITIAL);
	zend_highlight(syntax_highlighter_ini);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_restore_lexical_state(&original_lex_state);
	zval_dtor(str);
	return SUCCESS;
}

ZEND_API void zend_multibyte_yyinput_again(zend_encoding_filter old_input_filter, const zend_encoding *old_encoding)
{
	size_t length;
	unsigned char *new_yy_start;

	/* convert and set */
	if (!SCNG(input_filter)) {
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
			SCNG(script_filtered) = NULL;
		}
		SCNG(script_filtered_size) = 0;
		length = SCNG(script_org_size);
		new_yy_start = SCNG(script_org);
	} else {
		if ((size_t)-1 == SCNG(input_filter)(&new_yy_start, &length, SCNG(script_org), SCNG(script_org_size))) {
			zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
					"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
		}
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
		}
		SCNG(script_filtered) = new_yy_start;
		SCNG(script_filtered_size) = length;
	}

	SCNG(yy_cursor) = new_yy_start + (SCNG(yy_cursor) - SCNG(yy_start));
	SCNG(yy_marker) = new_yy_start + (SCNG(yy_marker) - SCNG(yy_start));
	SCNG(yy_text) = new_yy_start + (SCNG(yy_text) - SCNG(yy_start));
	SCNG(yy_limit) = new_yy_start + length;

	SCNG(yy_start) = new_yy_start;
}


// TODO: avoid reallocation ???
# define zend_copy_value(zendlval, yytext, yyleng) \
	if (SCNG(output_filter)) { \
		size_t sz = 0; \
		char *s = NULL; \
		SCNG(output_filter)((unsigned char **)&s, &sz, (unsigned char *)yytext, (size_t)yyleng); \
		ZVAL_STRINGL(zendlval, s, sz); \
		efree(s); \
	} else { \
		ZVAL_STRINGL(zendlval, yytext, yyleng); \
	}

static void zend_scan_escape_string(zval *zendlval, char *str, int len, char quote_type)
{
	register char *s, *t;
	char *end;

	ZVAL_STRINGL(zendlval, str, len);

	/* convert escape sequences */
	s = t = Z_STRVAL_P(zendlval);
	end = s+Z_STRLEN_P(zendlval);
	while (s<end) {
		if (*s=='\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				break;
			}

			switch(*s) {
				case 'n':
					*t++ = '\n';
					Z_STRLEN_P(zendlval)--;
					break;
				case 'r':
					*t++ = '\r';
					Z_STRLEN_P(zendlval)--;
					break;
				case 't':
					*t++ = '\t';
					Z_STRLEN_P(zendlval)--;
					break;
				case 'f':
					*t++ = '\f';
					Z_STRLEN_P(zendlval)--;
					break;
				case 'v':
					*t++ = '\v';
					Z_STRLEN_P(zendlval)--;
					break;
				case 'e':
#ifdef PHP_WIN32
					*t++ = VK_ESCAPE;
#else
					*t++ = '\e';
#endif
					Z_STRLEN_P(zendlval)--;
					break;
				case '"':
				case '`':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
				case '\\':
				case '$':
					*t++ = *s;
					Z_STRLEN_P(zendlval)--;
					break;
				case 'x':
				case 'X':
					if (ZEND_IS_HEX(*(s+1))) {
						char hex_buf[3] = { 0, 0, 0 };

						Z_STRLEN_P(zendlval)--; /* for the 'x' */

						hex_buf[0] = *(++s);
						Z_STRLEN_P(zendlval)--;
						if (ZEND_IS_HEX(*(s+1))) {
							hex_buf[1] = *(++s);
							Z_STRLEN_P(zendlval)--;
						}
						*t++ = (char) ZEND_STRTOL(hex_buf, NULL, 16);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
				/* UTF-8 codepoint escape, format: /\\u\{\x+\}/ */
				case 'u':
					{
						/* cache where we started so we can parse after validating */
						char *start = s + 1;
						size_t len = 0;
						zend_bool valid = 1;
						unsigned long codepoint;
						size_t byte_len = 0;

						if (*start != '{') {
							/* we silently let this pass to avoid breaking code
							 * with JSON in string literals (e.g. "\"\u202e\""
							 */
							*t++ = '\\';
							*t++ = 'u';
							break;
						} else {
							/* on the other hand, invalid \u{blah} errors */
							s++;
							len++;
							s++;
							while (*s != '}') {
								if (!ZEND_IS_HEX(*s)) {
									valid = 0;
									break;
								} else {
									len++;
								}
								s++;
							}
							if (*s == '}') {
								valid = 1;
								len++;
							}
						}

						/* \u{} is invalid */
						if (len <= 2) {
							valid = 0;
						}

						if (!valid) {
							zend_error(E_COMPILE_ERROR, "Invalid UTF-8 codepoint escape sequence");
						}

						errno = 0;
						codepoint = strtoul(start + 1, NULL, 16);

						/* per RFC 3629, UTF-8 can only represent 21 bits */
						if (codepoint > 0x10FFFF || errno) {
							zend_error_noreturn(E_COMPILE_ERROR, "Invalid UTF-8 codepoint escape sequence: Codepoint too large");
						}

						/* based on https://en.wikipedia.org/wiki/UTF-8#Sample_code */
						if (codepoint < 0x80) {
							byte_len = 1;
							*t++ = codepoint;
						} else if (codepoint <= 0x7FF) {
							byte_len = 2;
							*t++ = (codepoint >> 6) + 0xC0;
							*t++ = (codepoint & 0x3F) + 0x80;
						} else if (codepoint <= 0xFFFF) {
							byte_len = 3;
							*t++ = (codepoint >> 12) + 0xE0;
							*t++ = ((codepoint >> 6) & 0x3F) + 0x80;
							*t++ = (codepoint & 0x3F) + 0x80;
						} else if (codepoint <= 0x10FFFF) {
							byte_len = 4;
							*t++ = (codepoint >> 18) + 0xF0;
							*t++ = ((codepoint >> 12) & 0x3F) + 0x80;
							*t++ = ((codepoint >> 6) & 0x3F) + 0x80;
							*t++ = (codepoint & 0x3F) + 0x80;
						}

						Z_STRLEN_P(zendlval) -= 2; /* \u */
						Z_STRLEN_P(zendlval) -= (len - byte_len);
					}
					break;
				default:
					/* check for an octal */
					if (ZEND_IS_OCT(*s)) {
						char octal_buf[4] = { 0, 0, 0, 0 };

						octal_buf[0] = *s;
						Z_STRLEN_P(zendlval)--;
						if (ZEND_IS_OCT(*(s+1))) {
							octal_buf[1] = *(++s);
							Z_STRLEN_P(zendlval)--;
							if (ZEND_IS_OCT(*(s+1))) {
								octal_buf[2] = *(++s);
								Z_STRLEN_P(zendlval)--;
							}
						}
						*t++ = (char) ZEND_STRTOL(octal_buf, NULL, 8);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;
	if (SCNG(output_filter)) {
		size_t sz = 0;
		unsigned char *str;
		// TODO: avoid realocation ???
		s = Z_STRVAL_P(zendlval);
		SCNG(output_filter)(&str, &sz, (unsigned char *)s, (size_t)Z_STRLEN_P(zendlval));
		zval_ptr_dtor(zendlval);
		ZVAL_STRINGL(zendlval, (char *) str, sz);
		efree(str);
	}
}


int lex_scan(zval *zendlval)
{
restart:
	SCNG(yy_text) = YYCURSOR;


{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static void *yyctable[10] = {
		&&yyc_ST_IN_SCRIPTING,
		&&yyc_ST_LOOKING_FOR_PROPERTY,
		&&yyc_ST_BACKQUOTE,
		&&yyc_ST_DOUBLE_QUOTES,
		&&yyc_ST_HEREDOC,
		&&yyc_ST_LOOKING_FOR_VARNAME,
		&&yyc_ST_VAR_OFFSET,
		&&yyc_INITIAL,
		&&yyc_ST_END_HEREDOC,
		&&yyc_ST_NOWDOC,
	};
	goto *yyctable[YYGETCONDITION()];
/* *********************************** */
yyc_ST_IN_SCRIPTING:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,  36,   4,   0,   0,   4,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 36,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			216, 216, 152, 152, 152, 152, 152, 152, 
			152, 152,   0,   0,   0,   0,   0,   0, 
			  0, 144, 144, 144, 144, 144, 144,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,  16, 
			  0, 144, 144, 144, 144, 144, 144,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
		};
		YYDEBUG(0, *YYCURSOR);
		YYFILL(16);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy4,  &&yy4,  &&yy2,  &&yy2,  &&yy4,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy4,  &&yy7,  &&yy9,  &&yy11, &&yy13, &&yy14, &&yy15, &&yy16,
				&&yy18, &&yy19, &&yy20, &&yy21, &&yy19, &&yy22, &&yy23, &&yy24,
				&&yy25, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
				&&yy27, &&yy27, &&yy29, &&yy19, &&yy30, &&yy31, &&yy32, &&yy33,
				&&yy19, &&yy34, &&yy36, &&yy37, &&yy38, &&yy39, &&yy40, &&yy41,
				&&yy42, &&yy44, &&yy42, &&yy42, &&yy45, &&yy42, &&yy46, &&yy47,
				&&yy48, &&yy42, &&yy49, &&yy50, &&yy51, &&yy52, &&yy53, &&yy54,
				&&yy55, &&yy56, &&yy42, &&yy19, &&yy57, &&yy19, &&yy59, &&yy60,
				&&yy61, &&yy34, &&yy36, &&yy37, &&yy38, &&yy39, &&yy40, &&yy41,
				&&yy42, &&yy44, &&yy42, &&yy42, &&yy45, &&yy42, &&yy46, &&yy47,
				&&yy48, &&yy42, &&yy49, &&yy50, &&yy51, &&yy52, &&yy53, &&yy54,
				&&yy55, &&yy56, &&yy42, &&yy63, &&yy65, &&yy66, &&yy19, &&yy42,
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42,
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42,
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42,
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42,
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42,
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42,
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42,
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42,
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42,
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42,
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42,
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42,
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42,
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42,
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42,
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42
			};
			goto *yytarget[yych];
		}
yy2:
		YYDEBUG(2, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(3, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	zend_error(E_COMPILE_WARNING,"Unexpected character in input:  '%c' (ASCII=%d) state=%d", yytext[0], yytext[0], YYSTATE);
	goto restart;
}
yy4:
		YYDEBUG(4, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(5, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy4;
		}
		YYDEBUG(6, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	HANDLE_NEWLINES(yytext, yyleng);
	return T_WHITESPACE;
}
yy7:
		YYDEBUG(7, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy68;
yy8:
		YYDEBUG(8, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return yytext[0];
}
yy9:
		YYDEBUG(9, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(10, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int bprefix = (yytext[0] != '"') ? 1 : 0;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				yyleng = YYCURSOR - SCNG(yy_text);
				zend_scan_escape_string(zendlval, yytext+bprefix+1, yyleng-bprefix-2, '"');
				return T_CONSTANT_ENCAPSED_STRING;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	/* Remember how much was scanned to save rescanning */
	SET_DOUBLE_QUOTES_SCANNED_LENGTH(YYCURSOR - SCNG(yy_text) - yyleng);

	YYCURSOR = SCNG(yy_text) + yyleng;

	BEGIN(ST_DOUBLE_QUOTES);
	return '"';
}
yy11:
		YYDEBUG(11, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(12, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				CG(zend_lineno)++;
				break;
			case '?':
				if (*YYCURSOR == '>') {
					YYCURSOR--;
					break;
				}
				/* fall through */
			default:
				continue;
		}

		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	return T_COMMENT;
}
yy13:
		YYDEBUG(13, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy8;
			if (yych <= 'Z') goto yy70;
			if (yych <= '^') goto yy8;
			goto yy70;
		} else {
			if (yych <= '`') goto yy8;
			if (yych <= 'z') goto yy70;
			if (yych <= '~') goto yy8;
			goto yy70;
		}
yy14:
		YYDEBUG(14, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy73;
		goto yy8;
yy15:
		YYDEBUG(15, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '&') goto yy75;
		if (yych == '=') goto yy77;
		goto yy8;
yy16:
		YYDEBUG(16, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(17, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	register char *s, *t;
	char *end;
	int bprefix = (yytext[0] != '\'') ? 1 : 0;

	while (1) {
		if (YYCURSOR < YYLIMIT) {
			if (*YYCURSOR == '\'') {
				YYCURSOR++;
				yyleng = YYCURSOR - SCNG(yy_text);

				break;
			} else if (*YYCURSOR++ == '\\' && YYCURSOR < YYLIMIT) {
				YYCURSOR++;
			}
		} else {
			yyleng = YYLIMIT - SCNG(yy_text);

			/* Unclosed single quotes; treat similar to double quotes, but without a separate token
			 * for ' (unrecognized by parser), instead of old flex fallback to "Unexpected character..."
			 * rule, which continued in ST_IN_SCRIPTING state after the quote */
			ZVAL_NULL(zendlval);
			return T_ENCAPSED_AND_WHITESPACE;
		}
	}

	ZVAL_STRINGL(zendlval, yytext+bprefix+1, yyleng-bprefix-2);

	/* convert escape sequences */
	s = t = Z_STRVAL_P(zendlval);
	end = s+Z_STRLEN_P(zendlval);
	while (s<end) {
		if (*s=='\\') {
			s++;

			switch(*s) {
				case '\\':
				case '\'':
					*t++ = *s;
					Z_STRLEN_P(zendlval)--;
					break;
				default:
					*t++ = '\\';
					*t++ = *s;
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;

	if (SCNG(output_filter)) {
		size_t sz = 0;
		char *str = NULL;
		s = Z_STRVAL_P(zendlval);
		// TODO: avoid reallocation ???
		SCNG(output_filter)((unsigned char **)&str, &sz, (unsigned char *)s, (size_t)Z_STRLEN_P(zendlval));
		ZVAL_STRINGL(zendlval, str, sz);
	}
	return T_CONSTANT_ENCAPSED_STRING;
}
yy18:
		YYDEBUG(18, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy80, &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy80, &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy80, &&yy80, &&yy8,  &&yy80, &&yy8,  &&yy80, &&yy8,
				&&yy8,  &&yy80, &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy80,
				&&yy8,  &&yy8,  &&yy80, &&yy80, &&yy8,  &&yy80, &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy80, &&yy80, &&yy8,  &&yy80, &&yy8,  &&yy80, &&yy8,
				&&yy8,  &&yy80, &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy80,
				&&yy8,  &&yy8,  &&yy80, &&yy80, &&yy8,  &&yy80, &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8
			};
			goto *yytarget[yych];
		}
yy19:
		YYDEBUG(19, *YYCURSOR);
		++YYCURSOR;
		goto yy8;
yy20:
		YYDEBUG(20, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '*') goto yy91;
		if (yych == '=') goto yy93;
		goto yy8;
yy21:
		YYDEBUG(21, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '+') goto yy95;
		if (yych == '=') goto yy97;
		goto yy8;
yy22:
		YYDEBUG(22, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') {
			if (yych == '-') goto yy99;
			goto yy8;
		} else {
			if (yych <= '=') goto yy101;
			if (yych <= '>') goto yy103;
			goto yy8;
		}
yy23:
		YYDEBUG(23, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') {
			if (yych == '.') goto yy105;
			goto yy8;
		} else {
			if (yych <= '9') goto yy106;
			if (yych == '=') goto yy109;
			goto yy8;
		}
yy24:
		YYDEBUG(24, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '.') {
			if (yych == '*') goto yy111;
			goto yy8;
		} else {
			if (yych <= '/') goto yy11;
			if (yych == '=') goto yy113;
			goto yy8;
		}
yy25:
		YYDEBUG(25, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,
				&&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,
				&&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,
				&&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,
				&&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,
				&&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,
				&&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,
				&&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,
				&&yy28,  &&yy28,  &&yy115, &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,
				&&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,
				&&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,
				&&yy117, &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,
				&&yy28,  &&yy28,  &&yy115, &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,
				&&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,
				&&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,
				&&yy117, &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,
				&&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,
				&&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,
				&&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,
				&&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,
				&&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,
				&&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,
				&&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,
				&&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,
				&&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,
				&&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,
				&&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,
				&&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,
				&&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,
				&&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,
				&&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,
				&&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28,  &&yy28
			};
			goto *yytarget[yych];
		}
yy26:
		YYDEBUG(26, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *end;
	if (yyleng < MAX_LENGTH_OF_LONG - 1) { /* Won't overflow */
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(yytext, &end, 0));
		/* This isn't an assert, we need to ensure 019 isn't valid octal
		 * Because the lexing itself doesn't do that for us
		 */
		if (end != yytext + yyleng) {
			zend_error_noreturn(E_COMPILE_ERROR, "Invalid numeric literal");
		}
		ZEND_ASSERT(!errno);
	} else {
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(yytext, &end, 0));
		if (errno == ERANGE) { /* Overflow */
			errno = 0;
			if (yytext[0] == '0') { /* octal overflow */
				errno = 0;
				ZVAL_DOUBLE(zendlval, zend_oct_strtod(yytext, (const char **)&end));
			} else {
				ZVAL_DOUBLE(zendlval, zend_strtod(yytext, (const char **)&end));
			}
			/* Also not an assert for the same reason */
			if (end != yytext + yyleng) {
				zend_error_noreturn(E_COMPILE_ERROR, "Invalid numeric literal");
			}
			ZEND_ASSERT(!errno);
			return T_DNUMBER;
		}
		/* Also not an assert for the same reason */
		if (end != yytext + yyleng) {
			zend_error_noreturn(E_COMPILE_ERROR, "Invalid numeric literal");
		}
		ZEND_ASSERT(!errno);
	}
	return T_LNUMBER;
}
yy27:
		YYDEBUG(27, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy28:
		YYDEBUG(28, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy27;
		}
		if (yych <= 'D') {
			if (yych == '.') goto yy106;
			goto yy26;
		} else {
			if (yych <= 'E') goto yy116;
			if (yych == 'e') goto yy116;
			goto yy26;
		}
yy29:
		YYDEBUG(29, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == ':') goto yy118;
		goto yy8;
yy30:
		YYDEBUG(30, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ';') goto yy8;
		if (yych <= '<') goto yy120;
		if (yych <= '=') goto yy122;
		if (yych <= '>') goto yy124;
		goto yy8;
yy31:
		YYDEBUG(31, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy8;
		if (yych <= '=') goto yy125;
		if (yych <= '>') goto yy127;
		goto yy8;
yy32:
		YYDEBUG(32, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy8;
		if (yych <= '=') goto yy129;
		if (yych <= '>') goto yy131;
		goto yy8;
yy33:
		YYDEBUG(33, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '=') goto yy8;
		if (yych <= '>') goto yy133;
		if (yych <= '?') goto yy135;
		goto yy8;
yy34:
		YYDEBUG(34, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy137, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy138, &&yy43,
				&&yy43,  &&yy43,  &&yy139, &&yy140, &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy137, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy138, &&yy43,
				&&yy43,  &&yy43,  &&yy139, &&yy140, &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43
			};
			goto *yytarget[yych];
		}
yy35:
		YYDEBUG(35, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, yytext, yyleng);
	return T_STRING;
}
yy36:
		YYDEBUG(36, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy9,   &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy16,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy142, &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy143, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy143, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43
			};
			goto *yytarget[yych];
		}
yy37:
		YYDEBUG(37, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy144, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy145, &&yy43,  &&yy43,  &&yy146,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy144, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy145, &&yy43,  &&yy43,  &&yy146,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43
			};
			goto *yytarget[yych];
		}
yy38:
		YYDEBUG(38, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy147, &&yy43,  &&yy43,
				&&yy43,  &&yy148, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy149,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy147, &&yy43,  &&yy43,
				&&yy43,  &&yy148, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy149,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43
			};
			goto *yytarget[yych];
		}
yy39:
		YYDEBUG(39, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy151, &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy152, &&yy153, &&yy154, &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy155, &&yy43,
				&&yy156, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy151, &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy152, &&yy153, &&yy154, &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy155, &&yy43,
				&&yy156, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43
			};
			goto *yytarget[yych];
		}
yy40:
		YYDEBUG(40, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy157, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy158,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy159, &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy157, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy158,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy159, &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43
			};
			goto *yytarget[yych];
		}
yy41:
		YYDEBUG(41, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy160, &&yy43,  &&yy43,  &&yy161,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy160, &&yy43,  &&yy43,  &&yy161,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43
			};
			goto *yytarget[yych];
		}
yy42:
		YYDEBUG(42, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy43:
		YYDEBUG(43, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		goto yy35;
yy44:
		YYDEBUG(44, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy162, &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy164, &&yy165, &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy166, &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy162, &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy164, &&yy165, &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy166, &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43
			};
			goto *yytarget[yych];
		}
yy45:
		YYDEBUG(45, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy167;
		if (yych == 'i') goto yy167;
		goto yy43;
yy46:
		YYDEBUG(46, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy168, &&yy43,  &&yy43,  &&yy43,  &&yy169, &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy168, &&yy43,  &&yy43,  &&yy43,  &&yy169, &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43
			};
			goto *yytarget[yych];
		}
yy47:
		YYDEBUG(47, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy170;
		if (yych == 'r') goto yy170;
		goto yy43;
yy48:
		YYDEBUG(48, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy172, &&yy43,  &&yy43,  &&yy173, &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy172, &&yy43,  &&yy43,  &&yy173, &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43
			};
			goto *yytarget[yych];
		}
yy49:
		YYDEBUG(49, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy174;
		if (yych == 'e') goto yy174;
		goto yy43;
yy50:
		YYDEBUG(50, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy175, &&yy43,  &&yy43,  &&yy176,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy175, &&yy43,  &&yy43,  &&yy176,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43
			};
			goto *yytarget[yych];
		}
yy51:
		YYDEBUG(51, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy177, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy178, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy177, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy178, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43
			};
			goto *yytarget[yych];
		}
yy52:
		YYDEBUG(52, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy179, &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy180, &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy179, &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy180, &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43
			};
			goto *yytarget[yych];
		}
yy53:
		YYDEBUG(53, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy181;
		if (yych == 'a') goto yy181;
		goto yy43;
yy54:
		YYDEBUG(54, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy182;
		if (yych == 'h') goto yy182;
		goto yy43;
yy55:
		YYDEBUG(55, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy183;
		if (yych == 'o') goto yy183;
		goto yy43;
yy56:
		YYDEBUG(56, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy184;
		if (yych == 'i') goto yy184;
		goto yy43;
yy57:
		YYDEBUG(57, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(58, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_NS_SEPARATOR;
}
yy59:
		YYDEBUG(59, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy185;
		goto yy8;
yy60:
		YYDEBUG(60, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy187;
		goto yy43;
yy61:
		YYDEBUG(61, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(62, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_BACKQUOTE);
	return '`';
}
yy63:
		YYDEBUG(63, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(64, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	return '{';
}
yy65:
		YYDEBUG(65, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy188;
		if (yych == '|') goto yy190;
		goto yy8;
yy66:
		YYDEBUG(66, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(67, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RESET_DOC_COMMENT();
	if (!zend_stack_is_empty(&SCNG(state_stack))) {
		yy_pop_state();
	}
	return '}';
}
yy68:
		YYDEBUG(68, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy192;
yy69:
		YYDEBUG(69, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_NOT_EQUAL;
}
yy70:
		YYDEBUG(70, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(71, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72,
				&&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72,
				&&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72,
				&&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72,
				&&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72,
				&&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72,
				&&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70,
				&&yy70, &&yy70, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72,
				&&yy72, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70,
				&&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70,
				&&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70,
				&&yy70, &&yy70, &&yy70, &&yy72, &&yy72, &&yy72, &&yy72, &&yy70,
				&&yy72, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70,
				&&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70,
				&&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70,
				&&yy70, &&yy70, &&yy70, &&yy72, &&yy72, &&yy72, &&yy72, &&yy70,
				&&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70,
				&&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70,
				&&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70,
				&&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70,
				&&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70,
				&&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70,
				&&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70,
				&&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70,
				&&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70,
				&&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70,
				&&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70,
				&&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70,
				&&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70,
				&&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70,
				&&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70,
				&&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70
			};
			goto *yytarget[yych];
		}
yy72:
		YYDEBUG(72, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	return T_VARIABLE;
}
yy73:
		YYDEBUG(73, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(74, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_MOD_EQUAL;
}
yy75:
		YYDEBUG(75, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(76, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_BOOLEAN_AND;
}
yy77:
		YYDEBUG(77, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(78, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_AND_EQUAL;
}
yy79:
		YYDEBUG(79, *YYCURSOR);
		++YYCURSOR;
		YYFILL(7);
		yych = *YYCURSOR;
yy80:
		YYDEBUG(80, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81,
				&&yy81, &&yy79, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81,
				&&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81,
				&&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81,
				&&yy79, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81,
				&&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81,
				&&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81,
				&&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81,
				&&yy81, &&yy82, &&yy83, &&yy81, &&yy84, &&yy81, &&yy85, &&yy81,
				&&yy81, &&yy86, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy87,
				&&yy81, &&yy81, &&yy88, &&yy89, &&yy81, &&yy90, &&yy81, &&yy81,
				&&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81,
				&&yy81, &&yy82, &&yy83, &&yy81, &&yy84, &&yy81, &&yy85, &&yy81,
				&&yy81, &&yy86, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy87,
				&&yy81, &&yy81, &&yy88, &&yy89, &&yy81, &&yy90, &&yy81, &&yy81,
				&&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81,
				&&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81,
				&&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81,
				&&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81,
				&&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81,
				&&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81,
				&&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81,
				&&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81,
				&&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81,
				&&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81,
				&&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81,
				&&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81,
				&&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81,
				&&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81,
				&&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81,
				&&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81,
				&&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81
			};
			goto *yytarget[yych];
		}
yy81:
		YYDEBUG(81, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 2) {
			if (yyaccept <= 1) {
				if (yyaccept == 0) {
					goto yy8;
				} else {
					goto yy26;
				}
			} else {
				goto yy35;
			}
		} else {
			if (yyaccept <= 4) {
				if (yyaccept == 3) {
					goto yy108;
				} else {
					goto yy112;
				}
			} else {
				goto yy121;
			}
		}
yy82:
		YYDEBUG(82, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy194;
		if (yych == 'r') goto yy194;
		goto yy81;
yy83:
		YYDEBUG(83, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy195, &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy196,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy195, &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy196,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81
			};
			goto *yytarget[yych];
		}
yy84:
		YYDEBUG(84, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy197;
		if (yych == 'o') goto yy197;
		goto yy81;
yy85:
		YYDEBUG(85, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy198;
		if (yych == 'l') goto yy198;
		goto yy81;
yy86:
		YYDEBUG(86, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy199;
		if (yych == 'n') goto yy199;
		goto yy81;
yy87:
		YYDEBUG(87, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy200;
		if (yych == 'b') goto yy200;
		goto yy81;
yy88:
		YYDEBUG(88, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy201;
		if (yych == 'e') goto yy201;
		goto yy81;
yy89:
		YYDEBUG(89, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy202;
		if (yych == 't') goto yy202;
		goto yy81;
yy90:
		YYDEBUG(90, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy203;
		if (yych == 'n') goto yy203;
		goto yy81;
yy91:
		YYDEBUG(91, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy204;
		YYDEBUG(92, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_POW;
}
yy93:
		YYDEBUG(93, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(94, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_MUL_EQUAL;
}
yy95:
		YYDEBUG(95, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(96, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INC;
}
yy97:
		YYDEBUG(97, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(98, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PLUS_EQUAL;
}
yy99:
		YYDEBUG(99, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(100, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DEC;
}
yy101:
		YYDEBUG(101, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(102, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_MINUS_EQUAL;
}
yy103:
		YYDEBUG(103, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(104, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	return T_OBJECT_OPERATOR;
}
yy105:
		YYDEBUG(105, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '.') goto yy206;
		goto yy81;
yy106:
		YYDEBUG(106, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(107, *YYCURSOR);
		if (yych <= 'D') {
			if (yych <= '/') goto yy108;
			if (yych <= '9') goto yy106;
		} else {
			if (yych <= 'E') goto yy116;
			if (yych == 'e') goto yy116;
		}
yy108:
		YYDEBUG(108, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	const char *end;

	ZVAL_DOUBLE(zendlval, zend_strtod(yytext, &end));
	/* errno isn't checked since we allow HUGE_VAL/INF overflow */
	ZEND_ASSERT(end == yytext + yyleng);
	return T_DNUMBER;
}
yy109:
		YYDEBUG(109, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(110, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CONCAT_EQUAL;
}
yy111:
		YYDEBUG(111, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '*') goto yy208;
yy112:
		YYDEBUG(112, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int doc_com;

	if (yyleng > 2) {
		doc_com = 1;
		RESET_DOC_COMMENT();
	} else {
		doc_com = 0;
	}

	while (YYCURSOR < YYLIMIT) {
		if (*YYCURSOR++ == '*' && *YYCURSOR == '/') {
			break;
		}
	}

	if (YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	} else {
		zend_error(E_COMPILE_WARNING, "Unterminated comment starting line %d", CG(zend_lineno));
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	HANDLE_NEWLINES(yytext, yyleng);

	if (doc_com) {
		CG(doc_comment) = zend_string_init(yytext, yyleng, 0);
		return T_DOC_COMMENT;
	}

	return T_COMMENT;
}
yy113:
		YYDEBUG(113, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(114, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DIV_EQUAL;
}
yy115:
		YYDEBUG(115, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy209;
		}
		goto yy81;
yy116:
		YYDEBUG(116, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ',') {
			if (yych == '+') goto yy212;
			goto yy81;
		} else {
			if (yych <= '-') goto yy212;
			if (yych <= '/') goto yy81;
			if (yych <= '9') goto yy213;
			goto yy81;
		}
yy117:
		YYDEBUG(117, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy215;
		}
		goto yy81;
yy118:
		YYDEBUG(118, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(119, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PAAMAYIM_NEKUDOTAYIM;
}
yy120:
		YYDEBUG(120, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') goto yy121;
		if (yych <= '<') goto yy218;
		if (yych <= '=') goto yy220;
yy121:
		YYDEBUG(121, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_SL;
}
yy122:
		YYDEBUG(122, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(123, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_SMALLER_OR_EQUAL;
}
yy124:
		YYDEBUG(124, *YYCURSOR);
		++YYCURSOR;
		goto yy69;
yy125:
		YYDEBUG(125, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy222;
		YYDEBUG(126, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_EQUAL;
}
yy127:
		YYDEBUG(127, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(128, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DOUBLE_ARROW;
}
yy129:
		YYDEBUG(129, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(130, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_GREATER_OR_EQUAL;
}
yy131:
		YYDEBUG(131, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy224;
		YYDEBUG(132, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_SR;
}
yy133:
		YYDEBUG(133, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy226;
		if (yych == '\r') goto yy227;
yy134:
		YYDEBUG(134, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(INITIAL);
	return T_CLOSE_TAG;  /* implicit ';' at php-end tag */
}
yy135:
		YYDEBUG(135, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(136, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_COALESCE;
}
yy137:
		YYDEBUG(137, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy228;
		if (yych == 's') goto yy228;
		goto yy43;
yy138:
		YYDEBUG(138, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy229;
		if (yych == 'd') goto yy229;
		goto yy43;
yy139:
		YYDEBUG(139, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy231;
		if (yych == 'r') goto yy231;
		goto yy43;
yy140:
		YYDEBUG(140, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(141, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_AS;
}
yy142:
		YYDEBUG(142, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy232;
		goto yy81;
yy143:
		YYDEBUG(143, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy233;
		if (yych == 'e') goto yy233;
		goto yy43;
yy144:
		YYDEBUG(144, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy234, &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy235, &&yy236, &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy234, &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy235, &&yy236, &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43
			};
			goto *yytarget[yych];
		}
yy145:
		YYDEBUG(145, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy237, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy238,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy237, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy238,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43
			};
			goto *yytarget[yych];
		}
yy146:
		YYDEBUG(146, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy239;
		if (yych == 'n') goto yy239;
		goto yy43;
yy147:
		YYDEBUG(147, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy240, &&yy43,  &&yy43,  &&yy241, &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy240, &&yy43,  &&yy43,  &&yy241, &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43
			};
			goto *yytarget[yych];
		}
yy148:
		YYDEBUG(148, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy242;
		if (yych == 'e') goto yy242;
		goto yy43;
yy149:
		YYDEBUG(149, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(150, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DO;
}
yy151:
		YYDEBUG(151, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy244;
		if (yych == 'h') goto yy244;
		goto yy43;
yy152:
		YYDEBUG(152, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy245;
		if (yych == 's') goto yy245;
		goto yy43;
yy153:
		YYDEBUG(153, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy246;
		if (yych == 'p') goto yy246;
		goto yy43;
yy154:
		YYDEBUG(154, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy247;
		if (yych == 'd') goto yy247;
		goto yy43;
yy155:
		YYDEBUG(155, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy248;
		if (yych == 'a') goto yy248;
		goto yy43;
yy156:
		YYDEBUG(156, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy249, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy250, &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy249, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy250, &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43
			};
			goto *yytarget[yych];
		}
yy157:
		YYDEBUG(157, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy251;
		if (yych == 'n') goto yy251;
		goto yy43;
yy158:
		YYDEBUG(158, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy252;
		if (yych == 'r') goto yy252;
		goto yy43;
yy159:
		YYDEBUG(159, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy254;
		if (yych == 'n') goto yy254;
		goto yy43;
yy160:
		YYDEBUG(160, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy255;
		if (yych == 'o') goto yy255;
		goto yy43;
yy161:
		YYDEBUG(161, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy256;
		if (yych == 't') goto yy256;
		goto yy43;
yy162:
		YYDEBUG(162, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(163, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IF;
}
yy164:
		YYDEBUG(164, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy257;
		if (yych == 'p') goto yy257;
		goto yy43;
yy165:
		YYDEBUG(165, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy258, &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy259, &&yy260, &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy258, &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy259, &&yy260, &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43
			};
			goto *yytarget[yych];
		}
yy166:
		YYDEBUG(166, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy261;
		if (yych == 's') goto yy261;
		goto yy43;
yy167:
		YYDEBUG(167, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy262;
		if (yych == 's') goto yy262;
		goto yy43;
yy168:
		YYDEBUG(168, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy263;
		if (yych == 'm') goto yy263;
		goto yy43;
yy169:
		YYDEBUG(169, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy264;
		if (yych == 'w') goto yy264;
		goto yy43;
yy170:
		YYDEBUG(170, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(171, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_LOGICAL_OR;
}
yy172:
		YYDEBUG(172, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy266, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy267,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy266, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy267,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43
			};
			goto *yytarget[yych];
		}
yy173:
		YYDEBUG(173, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy268;
		if (yych == 'b') goto yy268;
		goto yy43;
yy174:
		YYDEBUG(174, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy269, &&yy43,  &&yy43,  &&yy270, &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy269, &&yy43,  &&yy43,  &&yy270, &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43
			};
			goto *yytarget[yych];
		}
yy175:
		YYDEBUG(175, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy271;
		if (yych == 'a') goto yy271;
		goto yy43;
yy176:
		YYDEBUG(176, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy272;
		if (yych == 'i') goto yy272;
		goto yy43;
yy177:
		YYDEBUG(177, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy273;
		if (yych == 'r') goto yy273;
		goto yy43;
yy178:
		YYDEBUG(178, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy274, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy275, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy274, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy275, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43
			};
			goto *yytarget[yych];
		}
yy179:
		YYDEBUG(179, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy277;
		if (yych == 's') goto yy277;
		goto yy43;
yy180:
		YYDEBUG(180, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy278;
		if (yych == 'e') goto yy278;
		goto yy43;
yy181:
		YYDEBUG(181, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy280;
		if (yych == 'r') goto yy280;
		goto yy43;
yy182:
		YYDEBUG(182, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy282;
		if (yych == 'i') goto yy282;
		goto yy43;
yy183:
		YYDEBUG(183, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy283;
		if (yych == 'r') goto yy283;
		goto yy43;
yy184:
		YYDEBUG(184, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy285;
		if (yych == 'e') goto yy285;
		goto yy43;
yy185:
		YYDEBUG(185, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(186, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_XOR_EQUAL;
}
yy187:
		YYDEBUG(187, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy286, &&yy287, &&yy43,  &&yy288, &&yy43,
				&&yy289, &&yy43,  &&yy43,  &&yy43,  &&yy290, &&yy291, &&yy292, &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy293, &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy286, &&yy287, &&yy43,  &&yy288, &&yy43,
				&&yy289, &&yy43,  &&yy43,  &&yy43,  &&yy290, &&yy291, &&yy292, &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy293, &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43
			};
			goto *yytarget[yych];
		}
yy188:
		YYDEBUG(188, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(189, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_OR_EQUAL;
}
yy190:
		YYDEBUG(190, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(191, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_BOOLEAN_OR;
}
yy192:
		YYDEBUG(192, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(193, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_NOT_IDENTICAL;
}
yy194:
		YYDEBUG(194, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy294;
		if (yych == 'r') goto yy294;
		goto yy81;
yy195:
		YYDEBUG(195, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy295;
		if (yych == 'n') goto yy295;
		goto yy81;
yy196:
		YYDEBUG(196, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy296;
		if (yych == 'o') goto yy296;
		goto yy81;
yy197:
		YYDEBUG(197, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy297;
		if (yych == 'u') goto yy297;
		goto yy81;
yy198:
		YYDEBUG(198, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy298;
		if (yych == 'o') goto yy298;
		goto yy81;
yy199:
		YYDEBUG(199, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy299;
		if (yych == 't') goto yy299;
		goto yy81;
yy200:
		YYDEBUG(200, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'J') goto yy300;
		if (yych == 'j') goto yy300;
		goto yy81;
yy201:
		YYDEBUG(201, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy301;
		if (yych == 'a') goto yy301;
		goto yy81;
yy202:
		YYDEBUG(202, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy302;
		if (yych == 'r') goto yy302;
		goto yy81;
yy203:
		YYDEBUG(203, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy303;
		if (yych == 's') goto yy303;
		goto yy81;
yy204:
		YYDEBUG(204, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(205, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_POW_EQUAL;
}
yy206:
		YYDEBUG(206, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(207, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ELLIPSIS;
}
yy208:
		YYDEBUG(208, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy81;
			if (yych <= '\n') goto yy304;
			goto yy81;
		} else {
			if (yych <= '\r') goto yy304;
			if (yych == ' ') goto yy304;
			goto yy81;
		}
yy209:
		YYDEBUG(209, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(210, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy209;
		}
		YYDEBUG(211, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *bin = yytext + 2; /* Skip "0b" */
	int len = yyleng - 2;
	char *end;

	/* Skip any leading 0s */
	while (*bin == '0') {
		++bin;
		--len;
	}

	if (len < SIZEOF_ZEND_LONG * 8) {
		if (len == 0) {
			ZVAL_LONG(zendlval, 0);
		} else {
			errno = 0;
			ZVAL_LONG(zendlval, ZEND_STRTOL(bin, &end, 2));
			ZEND_ASSERT(!errno && end == yytext + yyleng);
		}
		return T_LNUMBER;
	} else {
		ZVAL_DOUBLE(zendlval, zend_bin_strtod(bin, (const char **)&end));
		/* errno isn't checked since we allow HUGE_VAL/INF overflow */
		ZEND_ASSERT(end == yytext + yyleng);
		return T_DNUMBER;
	}
}
yy212:
		YYDEBUG(212, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '/') goto yy81;
		if (yych >= ':') goto yy81;
yy213:
		YYDEBUG(213, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(214, *YYCURSOR);
		if (yych <= '/') goto yy108;
		if (yych <= '9') goto yy213;
		goto yy108;
yy215:
		YYDEBUG(215, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(216, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy215;
		}
		YYDEBUG(217, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *hex = yytext + 2; /* Skip "0x" */
	int len = yyleng - 2;
	char *end;

	/* Skip any leading 0s */
	while (*hex == '0') {
		hex++;
		len--;
	}

	if (len < SIZEOF_ZEND_LONG * 2 || (len == SIZEOF_ZEND_LONG * 2 && *hex <= '7')) {
		if (len == 0) {
			ZVAL_LONG(zendlval, 0);
		} else {
			errno = 0;
			ZVAL_LONG(zendlval, ZEND_STRTOL(hex, &end, 16));
			ZEND_ASSERT(!errno && end == hex + len);
		}
		return T_LNUMBER;
	} else {
		ZVAL_DOUBLE(zendlval, zend_hex_strtod(hex, (const char **)&end));
		/* errno isn't checked since we allow HUGE_VAL/INF overflow */
		ZEND_ASSERT(end == hex + len);
		return T_DNUMBER;
	}
}
yy218:
		YYDEBUG(218, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(219, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy218, &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy218, &&yy81,  &&yy306, &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy307,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy308,
				&&yy81,  &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308
			};
			goto *yytarget[yych];
		}
yy220:
		YYDEBUG(220, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(221, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_SL_EQUAL;
}
yy222:
		YYDEBUG(222, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(223, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_IDENTICAL;
}
yy224:
		YYDEBUG(224, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(225, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_SR_EQUAL;
}
yy226:
		YYDEBUG(226, *YYCURSOR);
		++YYCURSOR;
		goto yy134;
yy227:
		YYDEBUG(227, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy226;
		goto yy134;
yy228:
		YYDEBUG(228, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy310;
		if (yych == 't') goto yy310;
		goto yy43;
yy229:
		YYDEBUG(229, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(230, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_LOGICAL_AND;
}
yy231:
		YYDEBUG(231, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy311;
		if (yych == 'a') goto yy311;
		goto yy43;
yy232:
		YYDEBUG(232, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy218;
		goto yy81;
yy233:
		YYDEBUG(233, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy312;
		if (yych == 'a') goto yy312;
		goto yy43;
yy234:
		YYDEBUG(234, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy313;
		if (yych == 'l') goto yy313;
		goto yy43;
yy235:
		YYDEBUG(235, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy314;
		if (yych == 'e') goto yy314;
		goto yy43;
yy236:
		YYDEBUG(236, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy316;
		if (yych == 'c') goto yy316;
		goto yy43;
yy237:
		YYDEBUG(237, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy317;
		if (yych == 's') goto yy317;
		goto yy43;
yy238:
		YYDEBUG(238, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy318;
		if (yych == 'n') goto yy318;
		goto yy43;
yy239:
		YYDEBUG(239, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych <= 'R') goto yy43;
			if (yych <= 'S') goto yy319;
			goto yy320;
		} else {
			if (yych <= 'r') goto yy43;
			if (yych <= 's') goto yy319;
			if (yych <= 't') goto yy320;
			goto yy43;
		}
yy240:
		YYDEBUG(240, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy321;
		if (yych == 'l') goto yy321;
		goto yy43;
yy241:
		YYDEBUG(241, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy322;
		if (yych == 'a') goto yy322;
		goto yy43;
yy242:
		YYDEBUG(242, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(243, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_EXIT;
}
yy244:
		YYDEBUG(244, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy323;
		if (yych == 'o') goto yy323;
		goto yy43;
yy245:
		YYDEBUG(245, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy325;
		if (yych == 'e') goto yy325;
		goto yy43;
yy246:
		YYDEBUG(246, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy327;
		if (yych == 't') goto yy327;
		goto yy43;
yy247:
		YYDEBUG(247, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy328, &&yy43,  &&yy329, &&yy43,
				&&yy43,  &&yy330, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy331, &&yy43,  &&yy43,  &&yy43,  &&yy332,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy328, &&yy43,  &&yy329, &&yy43,
				&&yy43,  &&yy330, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy331, &&yy43,  &&yy43,  &&yy43,  &&yy332,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43
			};
			goto *yytarget[yych];
		}
yy248:
		YYDEBUG(248, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy333;
		if (yych == 'l') goto yy333;
		goto yy43;
yy249:
		YYDEBUG(249, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy335;
		if (yych == 't') goto yy335;
		goto yy43;
yy250:
		YYDEBUG(250, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy337;
		if (yych == 'e') goto yy337;
		goto yy43;
yy251:
		YYDEBUG(251, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy338;
		if (yych == 'a') goto yy338;
		goto yy43;
yy252:
		YYDEBUG(252, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy253, &&yy253, &&yy253, &&yy253, &&yy253, &&yy253, &&yy253, &&yy253,
				&&yy253, &&yy253, &&yy253, &&yy253, &&yy253, &&yy253, &&yy253, &&yy253,
				&&yy253, &&yy253, &&yy253, &&yy253, &&yy253, &&yy253, &&yy253, &&yy253,
				&&yy253, &&yy253, &&yy253, &&yy253, &&yy253, &&yy253, &&yy253, &&yy253,
				&&yy253, &&yy253, &&yy253, &&yy253, &&yy253, &&yy253, &&yy253, &&yy253,
				&&yy253, &&yy253, &&yy253, &&yy253, &&yy253, &&yy253, &&yy253, &&yy253,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy253, &&yy253, &&yy253, &&yy253, &&yy253, &&yy253,
				&&yy253, &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy339, &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy253, &&yy253, &&yy253, &&yy253, &&yy42,
				&&yy253, &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy339, &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy253, &&yy253, &&yy253, &&yy253, &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42
			};
			goto *yytarget[yych];
		}
yy253:
		YYDEBUG(253, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FOR;
}
yy254:
		YYDEBUG(254, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy340;
		if (yych == 'c') goto yy340;
		goto yy43;
yy255:
		YYDEBUG(255, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy341;
		if (yych == 'b') goto yy341;
		goto yy43;
yy256:
		YYDEBUG(256, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy342;
		if (yych == 'o') goto yy342;
		goto yy43;
yy257:
		YYDEBUG(257, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy344;
		if (yych == 'l') goto yy344;
		goto yy43;
yy258:
		YYDEBUG(258, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy345;
		if (yych == 'l') goto yy345;
		goto yy43;
yy259:
		YYDEBUG(259, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy346;
		if (yych == 't') goto yy346;
		goto yy43;
yy260:
		YYDEBUG(260, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy347;
		if (yych == 'e') goto yy347;
		goto yy43;
yy261:
		YYDEBUG(261, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy348;
		if (yych == 'e') goto yy348;
		goto yy43;
yy262:
		YYDEBUG(262, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy349;
		if (yych == 't') goto yy349;
		goto yy43;
yy263:
		YYDEBUG(263, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy351;
		if (yych == 'e') goto yy351;
		goto yy43;
yy264:
		YYDEBUG(264, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(265, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_NEW;
}
yy266:
		YYDEBUG(266, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy352, &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy353, &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy352, &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy353, &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43
			};
			goto *yytarget[yych];
		}
yy267:
		YYDEBUG(267, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy354;
		if (yych == 't') goto yy354;
		goto yy43;
yy268:
		YYDEBUG(268, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy355;
		if (yych == 'l') goto yy355;
		goto yy43;
yy269:
		YYDEBUG(269, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy356;
		if (yych == 'u') goto yy356;
		goto yy43;
yy270:
		YYDEBUG(270, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy357;
		if (yych == 'u') goto yy357;
		goto yy43;
yy271:
		YYDEBUG(271, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy358;
		if (yych == 't') goto yy358;
		goto yy43;
yy272:
		YYDEBUG(272, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy359;
		if (yych == 't') goto yy359;
		goto yy43;
yy273:
		YYDEBUG(273, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy360;
		if (yych == 'o') goto yy360;
		goto yy43;
yy274:
		YYDEBUG(274, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy361;
		if (yych == 'i') goto yy361;
		goto yy43;
yy275:
		YYDEBUG(275, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(276, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_TRY;
}
yy277:
		YYDEBUG(277, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy362;
		if (yych == 'e') goto yy362;
		goto yy43;
yy278:
		YYDEBUG(278, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(279, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_USE;
}
yy280:
		YYDEBUG(280, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(281, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_VAR;
}
yy282:
		YYDEBUG(282, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy363;
		if (yych == 'l') goto yy363;
		goto yy43;
yy283:
		YYDEBUG(283, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(284, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_LOGICAL_XOR;
}
yy285:
		YYDEBUG(285, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy364;
		if (yych == 'l') goto yy364;
		goto yy43;
yy286:
		YYDEBUG(286, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy365;
		if (yych == 'l') goto yy365;
		goto yy43;
yy287:
		YYDEBUG(287, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy366;
		if (yych == 'i') goto yy366;
		goto yy43;
yy288:
		YYDEBUG(288, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy367, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy368, &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy367, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy368, &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43
			};
			goto *yytarget[yych];
		}
yy289:
		YYDEBUG(289, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy369;
		if (yych == 'a') goto yy369;
		goto yy43;
yy290:
		YYDEBUG(290, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy370;
		if (yych == 'i') goto yy370;
		goto yy43;
yy291:
		YYDEBUG(291, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy371;
		if (yych == 'e') goto yy371;
		goto yy43;
yy292:
		YYDEBUG(292, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy372;
		if (yych == 'a') goto yy372;
		goto yy43;
yy293:
		YYDEBUG(293, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy373;
		if (yych == 'r') goto yy373;
		goto yy43;
yy294:
		YYDEBUG(294, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy374;
		if (yych == 'a') goto yy374;
		goto yy81;
yy295:
		YYDEBUG(295, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy375;
		if (yych == 'a') goto yy375;
		goto yy81;
yy296:
		YYDEBUG(296, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy376;
		if (yych == 'l') goto yy376;
		goto yy81;
yy297:
		YYDEBUG(297, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy377;
		if (yych == 'b') goto yy377;
		goto yy81;
yy298:
		YYDEBUG(298, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy378;
		if (yych == 'a') goto yy378;
		goto yy81;
yy299:
		YYDEBUG(299, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy383;
		if (yych == 'e') goto yy383;
		goto yy380;
yy300:
		YYDEBUG(300, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy384;
		if (yych == 'e') goto yy384;
		goto yy81;
yy301:
		YYDEBUG(301, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy385;
		if (yych == 'l') goto yy385;
		goto yy81;
yy302:
		YYDEBUG(302, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy387;
		if (yych == 'i') goto yy387;
		goto yy81;
yy303:
		YYDEBUG(303, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy388;
		if (yych == 'e') goto yy388;
		goto yy81;
yy304:
		YYDEBUG(304, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(305, *YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy112;
			if (yych <= '\n') goto yy304;
			goto yy112;
		} else {
			if (yych <= '\r') goto yy304;
			if (yych == ' ') goto yy304;
			goto yy112;
		}
yy306:
		YYDEBUG(306, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '"') goto yy81;
		if (yych <= '/') goto yy390;
		if (yych <= '9') goto yy81;
		goto yy390;
yy307:
		YYDEBUG(307, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\'') goto yy81;
		if (yych <= '/') goto yy392;
		if (yych <= '9') goto yy81;
		goto yy392;
yy308:
		YYDEBUG(308, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(309, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy393, &&yy81,  &&yy81,  &&yy395, &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy308,
				&&yy81,  &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308
			};
			goto *yytarget[yych];
		}
yy310:
		YYDEBUG(310, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy396;
		if (yych == 'r') goto yy396;
		goto yy43;
yy311:
		YYDEBUG(311, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy397;
		if (yych == 'y') goto yy397;
		goto yy43;
yy312:
		YYDEBUG(312, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'K') goto yy399;
		if (yych == 'k') goto yy399;
		goto yy43;
yy313:
		YYDEBUG(313, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy401;
		if (yych == 'a') goto yy401;
		goto yy43;
yy314:
		YYDEBUG(314, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(315, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CASE;
}
yy316:
		YYDEBUG(316, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy402;
		if (yych == 'h') goto yy402;
		goto yy43;
yy317:
		YYDEBUG(317, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy404;
		if (yych == 's') goto yy404;
		goto yy43;
yy318:
		YYDEBUG(318, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy406;
		if (yych == 'e') goto yy406;
		goto yy43;
yy319:
		YYDEBUG(319, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy408;
		if (yych == 't') goto yy408;
		goto yy43;
yy320:
		YYDEBUG(320, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy410;
		if (yych == 'i') goto yy410;
		goto yy43;
yy321:
		YYDEBUG(321, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy411;
		if (yych == 'a') goto yy411;
		goto yy43;
yy322:
		YYDEBUG(322, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy412;
		if (yych == 'u') goto yy412;
		goto yy43;
yy323:
		YYDEBUG(323, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(324, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ECHO;
}
yy325:
		YYDEBUG(325, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326,
				&&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326,
				&&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326,
				&&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326,
				&&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326,
				&&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy326, &&yy326, &&yy326, &&yy326, &&yy326, &&yy326,
				&&yy326, &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy413, &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy326, &&yy326, &&yy326, &&yy326, &&yy42,
				&&yy326, &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy413, &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy326, &&yy326, &&yy326, &&yy326, &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42
			};
			goto *yytarget[yych];
		}
yy326:
		YYDEBUG(326, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ELSE;
}
yy327:
		YYDEBUG(327, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy414;
		if (yych == 'y') goto yy414;
		goto yy43;
yy328:
		YYDEBUG(328, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy416;
		if (yych == 'e') goto yy416;
		goto yy43;
yy329:
		YYDEBUG(329, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy417;
		if (yych == 'o') goto yy417;
		goto yy43;
yy330:
		YYDEBUG(330, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy418;
		if (yych == 'f') goto yy418;
		goto yy43;
yy331:
		YYDEBUG(331, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy420;
		if (yych == 'w') goto yy420;
		goto yy43;
yy332:
		YYDEBUG(332, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy421;
		if (yych == 'h') goto yy421;
		goto yy43;
yy333:
		YYDEBUG(333, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(334, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_EVAL;
}
yy335:
		YYDEBUG(335, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(336, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_EXIT;
}
yy337:
		YYDEBUG(337, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy422;
		if (yych == 'n') goto yy422;
		goto yy43;
yy338:
		YYDEBUG(338, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy423;
		if (yych == 'l') goto yy423;
		goto yy43;
yy339:
		YYDEBUG(339, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy425;
		if (yych == 'a') goto yy425;
		goto yy43;
yy340:
		YYDEBUG(340, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy426;
		if (yych == 't') goto yy426;
		goto yy43;
yy341:
		YYDEBUG(341, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy427;
		if (yych == 'a') goto yy427;
		goto yy43;
yy342:
		YYDEBUG(342, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(343, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_GOTO;
}
yy344:
		YYDEBUG(344, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy428;
		if (yych == 'e') goto yy428;
		goto yy43;
yy345:
		YYDEBUG(345, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy429;
		if (yych == 'u') goto yy429;
		goto yy43;
yy346:
		YYDEBUG(346, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy430, &&yy43,  &&yy43,  &&yy43,  &&yy431, &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy430, &&yy43,  &&yy43,  &&yy43,  &&yy431, &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43
			};
			goto *yytarget[yych];
		}
yy347:
		YYDEBUG(347, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy432;
		if (yych == 'r') goto yy432;
		goto yy43;
yy348:
		YYDEBUG(348, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy433;
		if (yych == 't') goto yy433;
		goto yy43;
yy349:
		YYDEBUG(349, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(350, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_LIST;
}
yy351:
		YYDEBUG(351, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy435;
		if (yych == 's') goto yy435;
		goto yy43;
yy352:
		YYDEBUG(352, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy436;
		if (yych == 't') goto yy436;
		goto yy43;
yy353:
		YYDEBUG(353, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy438;
		if (yych == 'a') goto yy438;
		goto yy43;
yy354:
		YYDEBUG(354, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy439;
		if (yych == 'e') goto yy439;
		goto yy43;
yy355:
		YYDEBUG(355, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy440;
		if (yych == 'i') goto yy440;
		goto yy43;
yy356:
		YYDEBUG(356, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy441;
		if (yych == 'i') goto yy441;
		goto yy43;
yy357:
		YYDEBUG(357, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy442;
		if (yych == 'r') goto yy442;
		goto yy43;
yy358:
		YYDEBUG(358, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy443;
		if (yych == 'i') goto yy443;
		goto yy43;
yy359:
		YYDEBUG(359, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy444;
		if (yych == 'c') goto yy444;
		goto yy43;
yy360:
		YYDEBUG(360, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy445;
		if (yych == 'w') goto yy445;
		goto yy43;
yy361:
		YYDEBUG(361, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy447;
		if (yych == 't') goto yy447;
		goto yy43;
yy362:
		YYDEBUG(362, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy449;
		if (yych == 't') goto yy449;
		goto yy43;
yy363:
		YYDEBUG(363, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy451;
		if (yych == 'e') goto yy451;
		goto yy43;
yy364:
		YYDEBUG(364, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy453;
		if (yych == 'd') goto yy453;
		goto yy43;
yy365:
		YYDEBUG(365, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy455;
		if (yych == 'a') goto yy455;
		goto yy43;
yy366:
		YYDEBUG(366, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy456;
		if (yych == 'r') goto yy456;
		goto yy43;
yy367:
		YYDEBUG(367, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy457;
		if (yych == 'l') goto yy457;
		goto yy43;
yy368:
		YYDEBUG(368, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy458;
		if (yych == 'n') goto yy458;
		goto yy43;
yy369:
		YYDEBUG(369, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy459;
		if (yych == 'l') goto yy459;
		goto yy43;
yy370:
		YYDEBUG(370, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy460;
		if (yych == 'n') goto yy460;
		goto yy43;
yy371:
		YYDEBUG(371, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy461;
		if (yych == 't') goto yy461;
		goto yy43;
yy372:
		YYDEBUG(372, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy462;
		if (yych == 'm') goto yy462;
		goto yy43;
yy373:
		YYDEBUG(373, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy463;
		if (yych == 'a') goto yy463;
		goto yy43;
yy374:
		YYDEBUG(374, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy464;
		if (yych == 'y') goto yy464;
		goto yy81;
yy375:
		YYDEBUG(375, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy466;
		if (yych == 'r') goto yy466;
		goto yy81;
yy376:
		YYDEBUG(376, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy471;
		if (yych == 'e') goto yy471;
		goto yy468;
yy377:
		YYDEBUG(377, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy472;
		if (yych == 'l') goto yy472;
		goto yy81;
yy378:
		YYDEBUG(378, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy385;
		if (yych == 't') goto yy385;
		goto yy81;
yy379:
		YYDEBUG(379, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy380:
		YYDEBUG(380, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy379;
			goto yy81;
		} else {
			if (yych <= ' ') goto yy379;
			if (yych != ')') goto yy81;
		}
		YYDEBUG(381, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(382, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INT_CAST;
}
yy383:
		YYDEBUG(383, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy473;
		if (yych == 'g') goto yy473;
		goto yy81;
yy384:
		YYDEBUG(384, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy474;
		if (yych == 'c') goto yy474;
		goto yy81;
yy385:
		YYDEBUG(385, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(386, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy385;
			goto yy81;
		} else {
			if (yych <= ' ') goto yy385;
			if (yych == ')') goto yy475;
			goto yy81;
		}
yy387:
		YYDEBUG(387, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy477;
		if (yych == 'n') goto yy477;
		goto yy81;
yy388:
		YYDEBUG(388, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy478;
		if (yych == 't') goto yy478;
		goto yy81;
yy389:
		YYDEBUG(389, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy390:
		YYDEBUG(390, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy480, &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy389,
				&&yy81,  &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389,
				&&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389, &&yy389
			};
			goto *yytarget[yych];
		}
yy391:
		YYDEBUG(391, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy392:
		YYDEBUG(392, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy480,
				&&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy81,
				&&yy81,  &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy391,
				&&yy81,  &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy81,  &&yy81,  &&yy81,  &&yy81,  &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391,
				&&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391, &&yy391
			};
			goto *yytarget[yych];
		}
yy393:
		YYDEBUG(393, *YYCURSOR);
		++YYCURSOR;
yy394:
		YYDEBUG(394, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *s;
	int bprefix = (yytext[0] != '<') ? 1 : 0;
	zend_heredoc_label *heredoc_label = emalloc(sizeof(zend_heredoc_label));

	CG(zend_lineno)++;
	heredoc_label->length = yyleng-bprefix-3-1-(yytext[yyleng-2]=='\r'?1:0);
	s = yytext+bprefix+3;
	while ((*s == ' ') || (*s == '\t')) {
		s++;
		heredoc_label->length--;
	}

	if (*s == '\'') {
		s++;
		heredoc_label->length -= 2;

		BEGIN(ST_NOWDOC);
	} else {
		if (*s == '"') {
			s++;
			heredoc_label->length -= 2;
		}

		BEGIN(ST_HEREDOC);
	}

	heredoc_label->label = estrndup(s, heredoc_label->length);

	/* Check for ending label on the next line */
	if (heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, s, heredoc_label->length)) {
		YYCTYPE *end = YYCURSOR + heredoc_label->length;

		if (*end == ';') {
			end++;
		}

		if (*end == '\n' || *end == '\r') {
			BEGIN(ST_END_HEREDOC);
		}
	}

	zend_ptr_stack_push(&SCNG(heredoc_label_stack), (void *) heredoc_label);

	return T_START_HEREDOC;
}
yy395:
		YYDEBUG(395, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy393;
		goto yy394;
yy396:
		YYDEBUG(396, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy481;
		if (yych == 'a') goto yy481;
		goto yy43;
yy397:
		YYDEBUG(397, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(398, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ARRAY;
}
yy399:
		YYDEBUG(399, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(400, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_BREAK;
}
yy401:
		YYDEBUG(401, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy482;
		if (yych == 'b') goto yy482;
		goto yy43;
yy402:
		YYDEBUG(402, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(403, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CATCH;
}
yy404:
		YYDEBUG(404, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(405, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CLASS;
}
yy406:
		YYDEBUG(406, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(407, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CLONE;
}
yy408:
		YYDEBUG(408, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(409, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CONST;
}
yy410:
		YYDEBUG(410, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy483;
		if (yych == 'n') goto yy483;
		goto yy43;
yy411:
		YYDEBUG(411, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy484;
		if (yych == 'r') goto yy484;
		goto yy43;
yy412:
		YYDEBUG(412, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy485;
		if (yych == 'l') goto yy485;
		goto yy43;
yy413:
		YYDEBUG(413, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy486;
		if (yych == 'f') goto yy486;
		goto yy43;
yy414:
		YYDEBUG(414, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(415, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_EMPTY;
}
yy416:
		YYDEBUG(416, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy488;
		if (yych == 'c') goto yy488;
		goto yy43;
yy417:
		YYDEBUG(417, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy489;
		if (yych == 'r') goto yy489;
		goto yy43;
yy418:
		YYDEBUG(418, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(419, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDIF;
}
yy420:
		YYDEBUG(420, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy491;
		if (yych == 'i') goto yy491;
		goto yy43;
yy421:
		YYDEBUG(421, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy492;
		if (yych == 'i') goto yy492;
		goto yy43;
yy422:
		YYDEBUG(422, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy493;
		if (yych == 'd') goto yy493;
		goto yy43;
yy423:
		YYDEBUG(423, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy424, &&yy424, &&yy424, &&yy424, &&yy424, &&yy424, &&yy424, &&yy424,
				&&yy424, &&yy424, &&yy424, &&yy424, &&yy424, &&yy424, &&yy424, &&yy424,
				&&yy424, &&yy424, &&yy424, &&yy424, &&yy424, &&yy424, &&yy424, &&yy424,
				&&yy424, &&yy424, &&yy424, &&yy424, &&yy424, &&yy424, &&yy424, &&yy424,
				&&yy424, &&yy424, &&yy424, &&yy424, &&yy424, &&yy424, &&yy424, &&yy424,
				&&yy424, &&yy424, &&yy424, &&yy424, &&yy424, &&yy424, &&yy424, &&yy424,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy424, &&yy424, &&yy424, &&yy424, &&yy424, &&yy424,
				&&yy424, &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy494, &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy424, &&yy424, &&yy424, &&yy424, &&yy42,
				&&yy424, &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy494, &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy424, &&yy424, &&yy424, &&yy424, &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42
			};
			goto *yytarget[yych];
		}
yy424:
		YYDEBUG(424, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FINAL;
}
yy425:
		YYDEBUG(425, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy495;
		if (yych == 'c') goto yy495;
		goto yy43;
yy426:
		YYDEBUG(426, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy496;
		if (yych == 'i') goto yy496;
		goto yy43;
yy427:
		YYDEBUG(427, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy497;
		if (yych == 'l') goto yy497;
		goto yy43;
yy428:
		YYDEBUG(428, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy499;
		if (yych == 'm') goto yy499;
		goto yy43;
yy429:
		YYDEBUG(429, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy500;
		if (yych == 'd') goto yy500;
		goto yy43;
yy430:
		YYDEBUG(430, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy501;
		if (yych == 'n') goto yy501;
		goto yy43;
yy431:
		YYDEBUG(431, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy502;
		if (yych == 'a') goto yy502;
		goto yy43;
yy432:
		YYDEBUG(432, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy503;
		if (yych == 'f') goto yy503;
		goto yy43;
yy433:
		YYDEBUG(433, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(434, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ISSET;
}
yy435:
		YYDEBUG(435, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy504;
		if (yych == 'p') goto yy504;
		goto yy43;
yy436:
		YYDEBUG(436, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(437, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PRINT;
}
yy438:
		YYDEBUG(438, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy505;
		if (yych == 't') goto yy505;
		goto yy43;
yy439:
		YYDEBUG(439, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy506;
		if (yych == 'c') goto yy506;
		goto yy43;
yy440:
		YYDEBUG(440, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy507;
		if (yych == 'c') goto yy507;
		goto yy43;
yy441:
		YYDEBUG(441, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy509;
		if (yych == 'r') goto yy509;
		goto yy43;
yy442:
		YYDEBUG(442, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy510;
		if (yych == 'n') goto yy510;
		goto yy43;
yy443:
		YYDEBUG(443, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy512;
		if (yych == 'c') goto yy512;
		goto yy43;
yy444:
		YYDEBUG(444, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy514;
		if (yych == 'h') goto yy514;
		goto yy43;
yy445:
		YYDEBUG(445, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(446, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_THROW;
}
yy447:
		YYDEBUG(447, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(448, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_TRAIT;
}
yy449:
		YYDEBUG(449, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(450, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_UNSET;
}
yy451:
		YYDEBUG(451, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(452, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_WHILE;
}
yy453:
		YYDEBUG(453, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(454, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_YIELD;
}
yy455:
		YYDEBUG(455, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy516;
		if (yych == 's') goto yy516;
		goto yy43;
yy456:
		YYDEBUG(456, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy517;
		goto yy43;
yy457:
		YYDEBUG(457, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy518;
		if (yych == 'e') goto yy518;
		goto yy43;
yy458:
		YYDEBUG(458, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy519;
		if (yych == 'c') goto yy519;
		goto yy43;
yy459:
		YYDEBUG(459, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy520;
		if (yych == 't') goto yy520;
		goto yy43;
yy460:
		YYDEBUG(460, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy521;
		if (yych == 'e') goto yy521;
		goto yy43;
yy461:
		YYDEBUG(461, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy522;
		if (yych == 'h') goto yy522;
		goto yy43;
yy462:
		YYDEBUG(462, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy523;
		if (yych == 'e') goto yy523;
		goto yy43;
yy463:
		YYDEBUG(463, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy524;
		if (yych == 'i') goto yy524;
		goto yy43;
yy464:
		YYDEBUG(464, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(465, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy464;
			goto yy81;
		} else {
			if (yych <= ' ') goto yy464;
			if (yych == ')') goto yy525;
			goto yy81;
		}
yy466:
		YYDEBUG(466, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy527;
		if (yych == 'y') goto yy527;
		goto yy81;
yy467:
		YYDEBUG(467, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy468:
		YYDEBUG(468, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy467;
			goto yy81;
		} else {
			if (yych <= ' ') goto yy467;
			if (yych != ')') goto yy81;
		}
		YYDEBUG(469, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(470, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_BOOL_CAST;
}
yy471:
		YYDEBUG(471, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy529;
		if (yych == 'a') goto yy529;
		goto yy81;
yy472:
		YYDEBUG(472, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy385;
		if (yych == 'e') goto yy385;
		goto yy81;
yy473:
		YYDEBUG(473, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy530;
		if (yych == 'e') goto yy530;
		goto yy81;
yy474:
		YYDEBUG(474, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy531;
		if (yych == 't') goto yy531;
		goto yy81;
yy475:
		YYDEBUG(475, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(476, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DOUBLE_CAST;
}
yy477:
		YYDEBUG(477, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy527;
		if (yych == 'g') goto yy527;
		goto yy81;
yy478:
		YYDEBUG(478, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(479, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy478;
			goto yy81;
		} else {
			if (yych <= ' ') goto yy478;
			if (yych == ')') goto yy533;
			goto yy81;
		}
yy480:
		YYDEBUG(480, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy393;
		if (yych == '\r') goto yy395;
		goto yy81;
yy481:
		YYDEBUG(481, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy535;
		if (yych == 'c') goto yy535;
		goto yy43;
yy482:
		YYDEBUG(482, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy536;
		if (yych == 'l') goto yy536;
		goto yy43;
yy483:
		YYDEBUG(483, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy537;
		if (yych == 'u') goto yy537;
		goto yy43;
yy484:
		YYDEBUG(484, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy538;
		if (yych == 'e') goto yy538;
		goto yy43;
yy485:
		YYDEBUG(485, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy540;
		if (yych == 't') goto yy540;
		goto yy43;
yy486:
		YYDEBUG(486, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(487, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ELSEIF;
}
yy488:
		YYDEBUG(488, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy542;
		if (yych == 'l') goto yy542;
		goto yy43;
yy489:
		YYDEBUG(489, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy490, &&yy490, &&yy490, &&yy490, &&yy490, &&yy490, &&yy490, &&yy490,
				&&yy490, &&yy490, &&yy490, &&yy490, &&yy490, &&yy490, &&yy490, &&yy490,
				&&yy490, &&yy490, &&yy490, &&yy490, &&yy490, &&yy490, &&yy490, &&yy490,
				&&yy490, &&yy490, &&yy490, &&yy490, &&yy490, &&yy490, &&yy490, &&yy490,
				&&yy490, &&yy490, &&yy490, &&yy490, &&yy490, &&yy490, &&yy490, &&yy490,
				&&yy490, &&yy490, &&yy490, &&yy490, &&yy490, &&yy490, &&yy490, &&yy490,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy490, &&yy490, &&yy490, &&yy490, &&yy490, &&yy490,
				&&yy490, &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy543, &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy490, &&yy490, &&yy490, &&yy490, &&yy42,
				&&yy490, &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy543, &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy490, &&yy490, &&yy490, &&yy490, &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42
			};
			goto *yytarget[yych];
		}
yy490:
		YYDEBUG(490, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDFOR;
}
yy491:
		YYDEBUG(491, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy544;
		if (yych == 't') goto yy544;
		goto yy43;
yy492:
		YYDEBUG(492, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy545;
		if (yych == 'l') goto yy545;
		goto yy43;
yy493:
		YYDEBUG(493, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy546;
		if (yych == 's') goto yy546;
		goto yy43;
yy494:
		YYDEBUG(494, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy548;
		if (yych == 'y') goto yy548;
		goto yy43;
yy495:
		YYDEBUG(495, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy550;
		if (yych == 'h') goto yy550;
		goto yy43;
yy496:
		YYDEBUG(496, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy552;
		if (yych == 'o') goto yy552;
		goto yy43;
yy497:
		YYDEBUG(497, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(498, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_GLOBAL;
}
yy499:
		YYDEBUG(499, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy553;
		if (yych == 'e') goto yy553;
		goto yy43;
yy500:
		YYDEBUG(500, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy554;
		if (yych == 'e') goto yy554;
		goto yy43;
yy501:
		YYDEBUG(501, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy556;
		if (yych == 'c') goto yy556;
		goto yy43;
yy502:
		YYDEBUG(502, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy557;
		if (yych == 'd') goto yy557;
		goto yy43;
yy503:
		YYDEBUG(503, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy558;
		if (yych == 'a') goto yy558;
		goto yy43;
yy504:
		YYDEBUG(504, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy559;
		if (yych == 'a') goto yy559;
		goto yy43;
yy505:
		YYDEBUG(505, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy560;
		if (yych == 'e') goto yy560;
		goto yy43;
yy506:
		YYDEBUG(506, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy562;
		if (yych == 't') goto yy562;
		goto yy43;
yy507:
		YYDEBUG(507, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(508, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PUBLIC;
}
yy509:
		YYDEBUG(509, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy563;
		if (yych == 'e') goto yy563;
		goto yy43;
yy510:
		YYDEBUG(510, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(511, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_RETURN;
}
yy512:
		YYDEBUG(512, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(513, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_STATIC;
}
yy514:
		YYDEBUG(514, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(515, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_SWITCH;
}
yy516:
		YYDEBUG(516, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy565;
		if (yych == 's') goto yy565;
		goto yy43;
yy517:
		YYDEBUG(517, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy566;
		goto yy43;
yy518:
		YYDEBUG(518, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy568;
		goto yy43;
yy519:
		YYDEBUG(519, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy569;
		if (yych == 't') goto yy569;
		goto yy43;
yy520:
		YYDEBUG(520, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy570;
		goto yy43;
yy521:
		YYDEBUG(521, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy571;
		goto yy43;
yy522:
		YYDEBUG(522, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy572;
		if (yych == 'o') goto yy572;
		goto yy43;
yy523:
		YYDEBUG(523, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy573;
		if (yych == 's') goto yy573;
		goto yy43;
yy524:
		YYDEBUG(524, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy574;
		if (yych == 't') goto yy574;
		goto yy43;
yy525:
		YYDEBUG(525, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(526, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ARRAY_CAST;
}
yy527:
		YYDEBUG(527, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(528, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy527;
			goto yy81;
		} else {
			if (yych <= ' ') goto yy527;
			if (yych == ')') goto yy575;
			goto yy81;
		}
yy529:
		YYDEBUG(529, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy467;
		if (yych == 'n') goto yy467;
		goto yy81;
yy530:
		YYDEBUG(530, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy379;
		if (yych == 'r') goto yy379;
		goto yy81;
yy531:
		YYDEBUG(531, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(532, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy81;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych == ')') goto yy577;
			goto yy81;
		}
yy533:
		YYDEBUG(533, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(534, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_UNSET_CAST;
}
yy535:
		YYDEBUG(535, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy579;
		if (yych == 't') goto yy579;
		goto yy43;
yy536:
		YYDEBUG(536, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy581;
		if (yych == 'e') goto yy581;
		goto yy43;
yy537:
		YYDEBUG(537, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy583;
		if (yych == 'e') goto yy583;
		goto yy43;
yy538:
		YYDEBUG(538, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(539, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DECLARE;
}
yy540:
		YYDEBUG(540, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(541, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DEFAULT;
}
yy542:
		YYDEBUG(542, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy585;
		if (yych == 'a') goto yy585;
		goto yy43;
yy543:
		YYDEBUG(543, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy586;
		if (yych == 'a') goto yy586;
		goto yy43;
yy544:
		YYDEBUG(544, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy587;
		if (yych == 'c') goto yy587;
		goto yy43;
yy545:
		YYDEBUG(545, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy588;
		if (yych == 'e') goto yy588;
		goto yy43;
yy546:
		YYDEBUG(546, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(547, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_EXTENDS;
}
yy548:
		YYDEBUG(548, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(549, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FINALLY;
}
yy550:
		YYDEBUG(550, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(551, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FOREACH;
}
yy552:
		YYDEBUG(552, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy590;
		if (yych == 'n') goto yy590;
		goto yy43;
yy553:
		YYDEBUG(553, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy592;
		if (yych == 'n') goto yy592;
		goto yy43;
yy554:
		YYDEBUG(554, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy555, &&yy555, &&yy555, &&yy555, &&yy555, &&yy555, &&yy555, &&yy555,
				&&yy555, &&yy555, &&yy555, &&yy555, &&yy555, &&yy555, &&yy555, &&yy555,
				&&yy555, &&yy555, &&yy555, &&yy555, &&yy555, &&yy555, &&yy555, &&yy555,
				&&yy555, &&yy555, &&yy555, &&yy555, &&yy555, &&yy555, &&yy555, &&yy555,
				&&yy555, &&yy555, &&yy555, &&yy555, &&yy555, &&yy555, &&yy555, &&yy555,
				&&yy555, &&yy555, &&yy555, &&yy555, &&yy555, &&yy555, &&yy555, &&yy555,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy555, &&yy555, &&yy555, &&yy555, &&yy555, &&yy555,
				&&yy555, &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy555, &&yy555, &&yy555, &&yy555, &&yy593,
				&&yy555, &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy555, &&yy555, &&yy555, &&yy555, &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42
			};
			goto *yytarget[yych];
		}
yy555:
		YYDEBUG(555, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INCLUDE;
}
yy556:
		YYDEBUG(556, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy594;
		if (yych == 'e') goto yy594;
		goto yy43;
yy557:
		YYDEBUG(557, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy595;
		if (yych == 'o') goto yy595;
		goto yy43;
yy558:
		YYDEBUG(558, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy596;
		if (yych == 'c') goto yy596;
		goto yy43;
yy559:
		YYDEBUG(559, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy597;
		if (yych == 'c') goto yy597;
		goto yy43;
yy560:
		YYDEBUG(560, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(561, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PRIVATE;
}
yy562:
		YYDEBUG(562, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy598;
		if (yych == 'e') goto yy598;
		goto yy43;
yy563:
		YYDEBUG(563, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy564, &&yy564, &&yy564, &&yy564, &&yy564, &&yy564, &&yy564, &&yy564,
				&&yy564, &&yy564, &&yy564, &&yy564, &&yy564, &&yy564, &&yy564, &&yy564,
				&&yy564, &&yy564, &&yy564, &&yy564, &&yy564, &&yy564, &&yy564, &&yy564,
				&&yy564, &&yy564, &&yy564, &&yy564, &&yy564, &&yy564, &&yy564, &&yy564,
				&&yy564, &&yy564, &&yy564, &&yy564, &&yy564, &&yy564, &&yy564, &&yy564,
				&&yy564, &&yy564, &&yy564, &&yy564, &&yy564, &&yy564, &&yy564, &&yy564,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy564, &&yy564, &&yy564, &&yy564, &&yy564, &&yy564,
				&&yy564, &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy564, &&yy564, &&yy564, &&yy564, &&yy599,
				&&yy564, &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy564, &&yy564, &&yy564, &&yy564, &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,
				&&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42,  &&yy42
			};
			goto *yytarget[yych];
		}
yy564:
		YYDEBUG(564, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_REQUIRE;
}
yy565:
		YYDEBUG(565, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy600;
		goto yy43;
yy566:
		YYDEBUG(566, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(567, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DIR;
}
yy568:
		YYDEBUG(568, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy601;
		goto yy43;
yy569:
		YYDEBUG(569, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy603;
		if (yych == 'i') goto yy603;
		goto yy43;
yy570:
		YYDEBUG(570, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy604;
		if (yych == 'c') goto yy604;
		goto yy43;
yy571:
		YYDEBUG(571, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy605;
		goto yy43;
yy572:
		YYDEBUG(572, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy607;
		if (yych == 'd') goto yy607;
		goto yy43;
yy573:
		YYDEBUG(573, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy608;
		if (yych == 'p') goto yy608;
		goto yy43;
yy574:
		YYDEBUG(574, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy609;
		goto yy43;
yy575:
		YYDEBUG(575, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(576, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_STRING_CAST;
}
yy577:
		YYDEBUG(577, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(578, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_OBJECT_CAST;
}
yy579:
		YYDEBUG(579, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(580, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ABSTRACT;
}
yy581:
		YYDEBUG(581, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(582, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
 return T_CALLABLE;
}
yy583:
		YYDEBUG(583, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(584, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CONTINUE;
}
yy585:
		YYDEBUG(585, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy610;
		if (yych == 'r') goto yy610;
		goto yy43;
yy586:
		YYDEBUG(586, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy611;
		if (yych == 'c') goto yy611;
		goto yy43;
yy587:
		YYDEBUG(587, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy612;
		if (yych == 'h') goto yy612;
		goto yy43;
yy588:
		YYDEBUG(588, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(589, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDWHILE;
}
yy590:
		YYDEBUG(590, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(591, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FUNCTION;
}
yy592:
		YYDEBUG(592, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy614;
		if (yych == 't') goto yy614;
		goto yy43;
yy593:
		YYDEBUG(593, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy615;
		if (yych == 'o') goto yy615;
		goto yy43;
yy594:
		YYDEBUG(594, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy616;
		if (yych == 'o') goto yy616;
		goto yy43;
yy595:
		YYDEBUG(595, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy617;
		if (yych == 'f') goto yy617;
		goto yy43;
yy596:
		YYDEBUG(596, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy619;
		if (yych == 'e') goto yy619;
		goto yy43;
yy597:
		YYDEBUG(597, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy621;
		if (yych == 'e') goto yy621;
		goto yy43;
yy598:
		YYDEBUG(598, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy623;
		if (yych == 'd') goto yy623;
		goto yy43;
yy599:
		YYDEBUG(599, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy625;
		if (yych == 'o') goto yy625;
		goto yy43;
yy600:
		YYDEBUG(600, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy626;
		goto yy43;
yy601:
		YYDEBUG(601, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(602, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FILE;
}
yy603:
		YYDEBUG(603, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy628;
		if (yych == 'o') goto yy628;
		goto yy43;
yy604:
		YYDEBUG(604, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy629;
		if (yych == 'o') goto yy629;
		goto yy43;
yy605:
		YYDEBUG(605, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(606, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_LINE;
}
yy607:
		YYDEBUG(607, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy630;
		goto yy43;
yy608:
		YYDEBUG(608, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy631;
		if (yych == 'a') goto yy631;
		goto yy43;
yy609:
		YYDEBUG(609, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy632;
		goto yy43;
yy610:
		YYDEBUG(610, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy634;
		if (yych == 'e') goto yy634;
		goto yy43;
yy611:
		YYDEBUG(611, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy636;
		if (yych == 'h') goto yy636;
		goto yy43;
yy612:
		YYDEBUG(612, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(613, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDSWITCH;
}
yy614:
		YYDEBUG(614, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy638;
		if (yych == 's') goto yy638;
		goto yy43;
yy615:
		YYDEBUG(615, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy640;
		if (yych == 'n') goto yy640;
		goto yy43;
yy616:
		YYDEBUG(616, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy641;
		if (yych == 'f') goto yy641;
		goto yy43;
yy617:
		YYDEBUG(617, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(618, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
        return T_INSTEADOF;
}
yy619:
		YYDEBUG(619, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(620, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INTERFACE;
}
yy621:
		YYDEBUG(621, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(622, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_NAMESPACE;
}
yy623:
		YYDEBUG(623, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(624, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PROTECTED;
}
yy625:
		YYDEBUG(625, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy643;
		if (yych == 'n') goto yy643;
		goto yy43;
yy626:
		YYDEBUG(626, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(627, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CLASS_C;
}
yy628:
		YYDEBUG(628, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy644;
		if (yych == 'n') goto yy644;
		goto yy43;
yy629:
		YYDEBUG(629, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy645;
		if (yych == 'm') goto yy645;
		goto yy43;
yy630:
		YYDEBUG(630, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy646;
		goto yy43;
yy631:
		YYDEBUG(631, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy648;
		if (yych == 'c') goto yy648;
		goto yy43;
yy632:
		YYDEBUG(632, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(633, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_TRAIT_C;
}
yy634:
		YYDEBUG(634, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(635, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDDECLARE;
}
yy636:
		YYDEBUG(636, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(637, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDFOREACH;
}
yy638:
		YYDEBUG(638, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(639, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IMPLEMENTS;
}
yy640:
		YYDEBUG(640, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy649;
		if (yych == 'c') goto yy649;
		goto yy43;
yy641:
		YYDEBUG(641, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(642, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INSTANCEOF;
}
yy643:
		YYDEBUG(643, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy650;
		if (yych == 'c') goto yy650;
		goto yy43;
yy644:
		YYDEBUG(644, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy651;
		goto yy43;
yy645:
		YYDEBUG(645, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy652;
		if (yych == 'p') goto yy652;
		goto yy43;
yy646:
		YYDEBUG(646, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(647, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_METHOD_C;
}
yy648:
		YYDEBUG(648, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy653;
		if (yych == 'e') goto yy653;
		goto yy43;
yy649:
		YYDEBUG(649, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy654;
		if (yych == 'e') goto yy654;
		goto yy43;
yy650:
		YYDEBUG(650, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy656;
		if (yych == 'e') goto yy656;
		goto yy43;
yy651:
		YYDEBUG(651, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy658;
		goto yy43;
yy652:
		YYDEBUG(652, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy660;
		if (yych == 'i') goto yy660;
		goto yy43;
yy653:
		YYDEBUG(653, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy661;
		goto yy43;
yy654:
		YYDEBUG(654, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(655, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INCLUDE_ONCE;
}
yy656:
		YYDEBUG(656, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(657, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_REQUIRE_ONCE;
}
yy658:
		YYDEBUG(658, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(659, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FUNC_C;
}
yy660:
		YYDEBUG(660, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy662;
		if (yych == 'l') goto yy662;
		goto yy43;
yy661:
		YYDEBUG(661, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy663;
		goto yy43;
yy662:
		YYDEBUG(662, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy665;
		if (yych == 'e') goto yy665;
		goto yy43;
yy663:
		YYDEBUG(663, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(664, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_NS_C;
}
yy665:
		YYDEBUG(665, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy666;
		if (yych != 'r') goto yy43;
yy666:
		YYDEBUG(666, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy42;
		}
		YYDEBUG(667, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_HALT_COMPILER;
}
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_PROPERTY:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,  64,  64,   0,   0,  64,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 64,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(668, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy670, &&yy670, &&yy670, &&yy670, &&yy670, &&yy670, &&yy670, &&yy670,
				&&yy670, &&yy672, &&yy672, &&yy670, &&yy670, &&yy672, &&yy670, &&yy670,
				&&yy670, &&yy670, &&yy670, &&yy670, &&yy670, &&yy670, &&yy670, &&yy670,
				&&yy670, &&yy670, &&yy670, &&yy670, &&yy670, &&yy670, &&yy670, &&yy670,
				&&yy672, &&yy670, &&yy670, &&yy670, &&yy670, &&yy670, &&yy670, &&yy670,
				&&yy670, &&yy670, &&yy670, &&yy670, &&yy670, &&yy675, &&yy670, &&yy670,
				&&yy670, &&yy670, &&yy670, &&yy670, &&yy670, &&yy670, &&yy670, &&yy670,
				&&yy670, &&yy670, &&yy670, &&yy670, &&yy670, &&yy670, &&yy670, &&yy670,
				&&yy670, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676,
				&&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676,
				&&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676,
				&&yy676, &&yy676, &&yy676, &&yy670, &&yy670, &&yy670, &&yy670, &&yy676,
				&&yy670, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676,
				&&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676,
				&&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676,
				&&yy676, &&yy676, &&yy676, &&yy670, &&yy670, &&yy670, &&yy670, &&yy676,
				&&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676,
				&&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676,
				&&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676,
				&&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676,
				&&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676,
				&&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676,
				&&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676,
				&&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676,
				&&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676,
				&&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676,
				&&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676,
				&&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676,
				&&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676,
				&&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676,
				&&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676,
				&&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676, &&yy676
			};
			goto *yytarget[yych];
		}
yy670:
		YYDEBUG(670, *YYCURSOR);
		++YYCURSOR;
yy671:
		YYDEBUG(671, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	yy_pop_state();
	goto restart;
}
yy672:
		YYDEBUG(672, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(673, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy672;
		}
		YYDEBUG(674, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	HANDLE_NEWLINES(yytext, yyleng);
	return T_WHITESPACE;
}
yy675:
		YYDEBUG(675, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy679;
		goto yy671;
yy676:
		YYDEBUG(676, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(677, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy676;
		}
		YYDEBUG(678, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_pop_state();
	zend_copy_value(zendlval, yytext, yyleng);
	return T_STRING;
}
yy679:
		YYDEBUG(679, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(680, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_OBJECT_OPERATOR;
}
	}
/* *********************************** */
yyc_ST_BACKQUOTE:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(681, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych == '$') goto yy685;
		} else {
			if (yych <= '`') goto yy686;
			if (yych == '{') goto yy688;
		}
		YYDEBUG(683, *YYCURSOR);
		++YYCURSOR;
yy684:
		YYDEBUG(684, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '`':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng, '`');
	return T_ENCAPSED_AND_WHITESPACE;
}
yy685:
		YYDEBUG(685, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy684, &&yy684, &&yy684, &&yy684, &&yy684, &&yy684, &&yy684, &&yy684,
				&&yy684, &&yy684, &&yy684, &&yy684, &&yy684, &&yy684, &&yy684, &&yy684,
				&&yy684, &&yy684, &&yy684, &&yy684, &&yy684, &&yy684, &&yy684, &&yy684,
				&&yy684, &&yy684, &&yy684, &&yy684, &&yy684, &&yy684, &&yy684, &&yy684,
				&&yy684, &&yy684, &&yy684, &&yy684, &&yy684, &&yy684, &&yy684, &&yy684,
				&&yy684, &&yy684, &&yy684, &&yy684, &&yy684, &&yy684, &&yy684, &&yy684,
				&&yy684, &&yy684, &&yy684, &&yy684, &&yy684, &&yy684, &&yy684, &&yy684,
				&&yy684, &&yy684, &&yy684, &&yy684, &&yy684, &&yy684, &&yy684, &&yy684,
				&&yy684, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689,
				&&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689,
				&&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689,
				&&yy689, &&yy689, &&yy689, &&yy684, &&yy684, &&yy684, &&yy684, &&yy689,
				&&yy684, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689,
				&&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689,
				&&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689,
				&&yy689, &&yy689, &&yy689, &&yy692, &&yy684, &&yy684, &&yy684, &&yy689,
				&&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689,
				&&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689,
				&&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689,
				&&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689,
				&&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689,
				&&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689,
				&&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689,
				&&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689,
				&&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689,
				&&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689,
				&&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689,
				&&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689,
				&&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689,
				&&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689,
				&&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689,
				&&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689
			};
			goto *yytarget[yych];
		}
yy686:
		YYDEBUG(686, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(687, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_IN_SCRIPTING);
	return '`';
}
yy688:
		YYDEBUG(688, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy694;
		goto yy684;
yy689:
		YYDEBUG(689, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(690, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy689;
		}
		if (yych == '-') goto yy696;
		if (yych <= '@') goto yy691;
		if (yych <= '[') goto yy698;
yy691:
		YYDEBUG(691, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	return T_VARIABLE;
}
yy692:
		YYDEBUG(692, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(693, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	return T_DOLLAR_OPEN_CURLY_BRACES;
}
yy694:
		YYDEBUG(694, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(695, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	Z_LVAL_P(zendlval) = (zend_long) '{';
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	return T_CURLY_OPEN;
}
yy696:
		YYDEBUG(696, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy700;
yy697:
		YYDEBUG(697, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy691;
yy698:
		YYDEBUG(698, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(699, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	return T_VARIABLE;
}
yy700:
		YYDEBUG(700, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy697;
			if (yych <= 'Z') goto yy701;
			if (yych <= '^') goto yy697;
		} else {
			if (yych <= '`') goto yy697;
			if (yych <= 'z') goto yy701;
			if (yych <= '~') goto yy697;
		}
yy701:
		YYDEBUG(701, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(702, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	return T_VARIABLE;
}
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(703, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '#') {
			if (yych == '"') goto yy707;
		} else {
			if (yych <= '$') goto yy709;
			if (yych == '{') goto yy710;
		}
		YYDEBUG(705, *YYCURSOR);
		++YYCURSOR;
yy706:
		YYDEBUG(706, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (GET_DOUBLE_QUOTES_SCANNED_LENGTH()) {
		YYCURSOR += GET_DOUBLE_QUOTES_SCANNED_LENGTH() - 1;
		SET_DOUBLE_QUOTES_SCANNED_LENGTH(0);

		goto double_quotes_scan_done;
	}

	if (YYCURSOR > YYLIMIT) {
		return 0;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

double_quotes_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng, '"');
	return T_ENCAPSED_AND_WHITESPACE;
}
yy707:
		YYDEBUG(707, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(708, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_IN_SCRIPTING);
	return '"';
}
yy709:
		YYDEBUG(709, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706,
				&&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706,
				&&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706,
				&&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706,
				&&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706,
				&&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706,
				&&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706,
				&&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706,
				&&yy706, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711,
				&&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711,
				&&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711,
				&&yy711, &&yy711, &&yy711, &&yy706, &&yy706, &&yy706, &&yy706, &&yy711,
				&&yy706, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711,
				&&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711,
				&&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711,
				&&yy711, &&yy711, &&yy711, &&yy714, &&yy706, &&yy706, &&yy706, &&yy711,
				&&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711,
				&&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711,
				&&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711,
				&&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711,
				&&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711,
				&&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711,
				&&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711,
				&&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711,
				&&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711,
				&&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711,
				&&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711,
				&&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711,
				&&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711,
				&&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711,
				&&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711,
				&&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711
			};
			goto *yytarget[yych];
		}
yy710:
		YYDEBUG(710, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy716;
		goto yy706;
yy711:
		YYDEBUG(711, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(712, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy711;
		}
		if (yych == '-') goto yy718;
		if (yych <= '@') goto yy713;
		if (yych <= '[') goto yy720;
yy713:
		YYDEBUG(713, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	return T_VARIABLE;
}
yy714:
		YYDEBUG(714, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(715, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	return T_DOLLAR_OPEN_CURLY_BRACES;
}
yy716:
		YYDEBUG(716, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(717, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	Z_LVAL_P(zendlval) = (zend_long) '{';
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	return T_CURLY_OPEN;
}
yy718:
		YYDEBUG(718, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy722;
yy719:
		YYDEBUG(719, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy713;
yy720:
		YYDEBUG(720, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(721, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	return T_VARIABLE;
}
yy722:
		YYDEBUG(722, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy719;
			if (yych <= 'Z') goto yy723;
			if (yych <= '^') goto yy719;
		} else {
			if (yych <= '`') goto yy719;
			if (yych <= 'z') goto yy723;
			if (yych <= '~') goto yy719;
		}
yy723:
		YYDEBUG(723, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(724, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	return T_VARIABLE;
}
	}
/* *********************************** */
yyc_ST_HEREDOC:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(725, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '$') goto yy729;
		if (yych == '{') goto yy730;
		YYDEBUG(727, *YYCURSOR);
		++YYCURSOR;
yy728:
		YYDEBUG(728, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int newline = 0;

	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));

	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					YYCTYPE *end = YYCURSOR + heredoc_label->length;

					if (*end == ';') {
						end++;
					}

					if (*end == '\n' || *end == '\r') {
						/* newline before label will be subtracted from returned text, but
						 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
						if (YYCURSOR[-2] == '\r' && YYCURSOR[-1] == '\n') {
							newline = 2; /* Windows newline */
						} else {
							newline = 1;
						}

						CG(increment_lineno) = 1; /* For newline before label */
						BEGIN(ST_END_HEREDOC);

						goto heredoc_scan_done;
					}
				}
				continue;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '\n' && *YYCURSOR != '\r') {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

heredoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng - newline, 0);
	return T_ENCAPSED_AND_WHITESPACE;
}
yy729:
		YYDEBUG(729, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy728, &&yy728, &&yy728, &&yy728, &&yy728, &&yy728, &&yy728, &&yy728,
				&&yy728, &&yy728, &&yy728, &&yy728, &&yy728, &&yy728, &&yy728, &&yy728,
				&&yy728, &&yy728, &&yy728, &&yy728, &&yy728, &&yy728, &&yy728, &&yy728,
				&&yy728, &&yy728, &&yy728, &&yy728, &&yy728, &&yy728, &&yy728, &&yy728,
				&&yy728, &&yy728, &&yy728, &&yy728, &&yy728, &&yy728, &&yy728, &&yy728,
				&&yy728, &&yy728, &&yy728, &&yy728, &&yy728, &&yy728, &&yy728, &&yy728,
				&&yy728, &&yy728, &&yy728, &&yy728, &&yy728, &&yy728, &&yy728, &&yy728,
				&&yy728, &&yy728, &&yy728, &&yy728, &&yy728, &&yy728, &&yy728, &&yy728,
				&&yy728, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731,
				&&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731,
				&&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731,
				&&yy731, &&yy731, &&yy731, &&yy728, &&yy728, &&yy728, &&yy728, &&yy731,
				&&yy728, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731,
				&&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731,
				&&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731,
				&&yy731, &&yy731, &&yy731, &&yy734, &&yy728, &&yy728, &&yy728, &&yy731,
				&&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731,
				&&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731,
				&&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731,
				&&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731,
				&&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731,
				&&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731,
				&&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731,
				&&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731,
				&&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731,
				&&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731,
				&&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731,
				&&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731,
				&&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731,
				&&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731,
				&&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731,
				&&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731, &&yy731
			};
			goto *yytarget[yych];
		}
yy730:
		YYDEBUG(730, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy736;
		goto yy728;
yy731:
		YYDEBUG(731, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(732, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy731;
		}
		if (yych == '-') goto yy738;
		if (yych <= '@') goto yy733;
		if (yych <= '[') goto yy740;
yy733:
		YYDEBUG(733, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	return T_VARIABLE;
}
yy734:
		YYDEBUG(734, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(735, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	return T_DOLLAR_OPEN_CURLY_BRACES;
}
yy736:
		YYDEBUG(736, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(737, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	Z_LVAL_P(zendlval) = (zend_long) '{';
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	return T_CURLY_OPEN;
}
yy738:
		YYDEBUG(738, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy742;
yy739:
		YYDEBUG(739, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy733;
yy740:
		YYDEBUG(740, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(741, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	return T_VARIABLE;
}
yy742:
		YYDEBUG(742, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy739;
			if (yych <= 'Z') goto yy743;
			if (yych <= '^') goto yy739;
		} else {
			if (yych <= '`') goto yy739;
			if (yych <= 'z') goto yy743;
			if (yych <= '~') goto yy739;
		}
yy743:
		YYDEBUG(743, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(744, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	return T_VARIABLE;
}
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_VARNAME:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(745, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy747;
			if (yych <= 'Z') goto yy749;
			if (yych >= '_') goto yy749;
		} else {
			if (yych <= '`') goto yy747;
			if (yych <= 'z') goto yy749;
			if (yych >= 0x7F) goto yy749;
		}
yy747:
		YYDEBUG(747, *YYCURSOR);
		++YYCURSOR;
yy748:
		YYDEBUG(748, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	yy_pop_state();
	yy_push_state(ST_IN_SCRIPTING);
	goto restart;
}
yy749:
		YYDEBUG(749, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy748, &&yy748, &&yy748, &&yy748, &&yy748, &&yy748, &&yy748, &&yy748,
				&&yy748, &&yy748, &&yy748, &&yy748, &&yy748, &&yy748, &&yy748, &&yy748,
				&&yy748, &&yy748, &&yy748, &&yy748, &&yy748, &&yy748, &&yy748, &&yy748,
				&&yy748, &&yy748, &&yy748, &&yy748, &&yy748, &&yy748, &&yy748, &&yy748,
				&&yy748, &&yy748, &&yy748, &&yy748, &&yy748, &&yy748, &&yy748, &&yy748,
				&&yy748, &&yy748, &&yy748, &&yy748, &&yy748, &&yy748, &&yy748, &&yy748,
				&&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751,
				&&yy751, &&yy751, &&yy748, &&yy748, &&yy748, &&yy748, &&yy748, &&yy748,
				&&yy748, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751,
				&&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751,
				&&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751,
				&&yy751, &&yy751, &&yy751, &&yy751, &&yy748, &&yy748, &&yy748, &&yy751,
				&&yy748, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751,
				&&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751,
				&&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751,
				&&yy751, &&yy751, &&yy751, &&yy748, &&yy748, &&yy751, &&yy748, &&yy751,
				&&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751,
				&&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751,
				&&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751,
				&&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751,
				&&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751,
				&&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751,
				&&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751,
				&&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751,
				&&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751,
				&&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751,
				&&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751,
				&&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751,
				&&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751,
				&&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751,
				&&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751,
				&&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751, &&yy751
			};
			goto *yytarget[yych];
		}
yy750:
		YYDEBUG(750, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy751:
		YYDEBUG(751, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy750;
		}
		if (yych <= '@') goto yy752;
		if (yych <= '[') goto yy753;
		if (yych == '}') goto yy753;
yy752:
		YYDEBUG(752, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy748;
yy753:
		YYDEBUG(753, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(754, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	zend_copy_value(zendlval, yytext, yyleng);
	yy_pop_state();
	yy_push_state(ST_IN_SCRIPTING);
	return T_STRING_VARNAME;
}
	}
/* *********************************** */
yyc_ST_VAR_OFFSET:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			240, 240, 176, 176, 176, 176, 176, 176, 
			176, 176,   0,   0,   0,   0,   0,   0, 
			  0, 160, 160, 160, 160, 160, 160,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,   0,   0,   0,   0,  32, 
			  0, 160, 160, 160, 160, 160, 160,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,   0,   0,   0,   0,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
		};
		YYDEBUG(755, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy757, &&yy757, &&yy757, &&yy757, &&yy757, &&yy757, &&yy757, &&yy757,
				&&yy757, &&yy759, &&yy759, &&yy757, &&yy757, &&yy759, &&yy757, &&yy757,
				&&yy757, &&yy757, &&yy757, &&yy757, &&yy757, &&yy757, &&yy757, &&yy757,
				&&yy757, &&yy757, &&yy757, &&yy757, &&yy757, &&yy757, &&yy757, &&yy757,
				&&yy759, &&yy761, &&yy761, &&yy759, &&yy763, &&yy761, &&yy761, &&yy759,
				&&yy761, &&yy761, &&yy761, &&yy761, &&yy761, &&yy761, &&yy761, &&yy761,
				&&yy764, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766,
				&&yy766, &&yy766, &&yy761, &&yy761, &&yy761, &&yy761, &&yy761, &&yy761,
				&&yy761, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768,
				&&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768,
				&&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768,
				&&yy768, &&yy768, &&yy768, &&yy761, &&yy759, &&yy771, &&yy761, &&yy768,
				&&yy761, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768,
				&&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768,
				&&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768,
				&&yy768, &&yy768, &&yy768, &&yy761, &&yy761, &&yy761, &&yy761, &&yy768,
				&&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768,
				&&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768,
				&&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768,
				&&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768,
				&&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768,
				&&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768,
				&&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768,
				&&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768,
				&&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768,
				&&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768,
				&&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768,
				&&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768,
				&&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768,
				&&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768,
				&&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768,
				&&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768, &&yy768
			};
			goto *yytarget[yych];
		}
yy757:
		YYDEBUG(757, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(758, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	zend_error(E_COMPILE_WARNING,"Unexpected character in input:  '%c' (ASCII=%d) state=%d", yytext[0], yytext[0], YYSTATE);
	goto restart;
}
yy759:
		YYDEBUG(759, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(760, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Invalid rule to return a more explicit parse error with proper line number */
	yyless(0);
	yy_pop_state();
	ZVAL_NULL(zendlval);
	return T_ENCAPSED_AND_WHITESPACE;
}
yy761:
		YYDEBUG(761, *YYCURSOR);
		++YYCURSOR;
yy762:
		YYDEBUG(762, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Only '[' can be valid, but returning other tokens will allow a more explicit parse error */
	return yytext[0];
}
yy763:
		YYDEBUG(763, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy762;
			if (yych <= 'Z') goto yy773;
			if (yych <= '^') goto yy762;
			goto yy773;
		} else {
			if (yych <= '`') goto yy762;
			if (yych <= 'z') goto yy773;
			if (yych <= '~') goto yy762;
			goto yy773;
		}
yy764:
		YYDEBUG(764, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765,
				&&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765,
				&&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765,
				&&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765,
				&&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765,
				&&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765,
				&&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776,
				&&yy776, &&yy776, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765,
				&&yy765, &&yy765, &&yy779, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765,
				&&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765,
				&&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765,
				&&yy781, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765,
				&&yy765, &&yy765, &&yy779, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765,
				&&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765,
				&&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765,
				&&yy781, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765,
				&&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765,
				&&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765,
				&&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765,
				&&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765,
				&&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765,
				&&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765,
				&&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765,
				&&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765,
				&&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765,
				&&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765,
				&&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765,
				&&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765,
				&&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765,
				&&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765,
				&&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765,
				&&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765, &&yy765
			};
			goto *yytarget[yych];
		}
yy765:
		YYDEBUG(765, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Offset could be treated as a long */
	if (yyleng < MAX_LENGTH_OF_LONG - 1 || (yyleng == MAX_LENGTH_OF_LONG - 1 && strcmp(yytext, long_min_digits) < 0)) {
		char *end;
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(yytext, &end, 10));
		if (errno == ERANGE) {
			goto string;
		}
		ZEND_ASSERT(end == yytext + yyleng);
	} else {
string:
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	return T_NUM_STRING;
}
yy766:
		YYDEBUG(766, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(767, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy766;
		}
		goto yy765;
yy768:
		YYDEBUG(768, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(769, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy768;
		}
		YYDEBUG(770, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, yytext, yyleng);
	return T_STRING;
}
yy771:
		YYDEBUG(771, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(772, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_pop_state();
	return ']';
}
yy773:
		YYDEBUG(773, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(774, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy775, &&yy775, &&yy775, &&yy775, &&yy775, &&yy775, &&yy775, &&yy775,
				&&yy775, &&yy775, &&yy775, &&yy775, &&yy775, &&yy775, &&yy775, &&yy775,
				&&yy775, &&yy775, &&yy775, &&yy775, &&yy775, &&yy775, &&yy775, &&yy775,
				&&yy775, &&yy775, &&yy775, &&yy775, &&yy775, &&yy775, &&yy775, &&yy775,
				&&yy775, &&yy775, &&yy775, &&yy775, &&yy775, &&yy775, &&yy775, &&yy775,
				&&yy775, &&yy775, &&yy775, &&yy775, &&yy775, &&yy775, &&yy775, &&yy775,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy775, &&yy775, &&yy775, &&yy775, &&yy775, &&yy775,
				&&yy775, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy775, &&yy775, &&yy775, &&yy775, &&yy773,
				&&yy775, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy775, &&yy775, &&yy775, &&yy775, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773
			};
			goto *yytarget[yych];
		}
yy775:
		YYDEBUG(775, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	return T_VARIABLE;
}
yy776:
		YYDEBUG(776, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(777, *YYCURSOR);
		if (yych <= '/') goto yy778;
		if (yych <= '9') goto yy776;
yy778:
		YYDEBUG(778, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Offset must be treated as a string */
	ZVAL_STRINGL(zendlval, yytext, yyleng);
	return T_NUM_STRING;
}
yy779:
		YYDEBUG(779, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy782;
		}
yy780:
		YYDEBUG(780, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy765;
yy781:
		YYDEBUG(781, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy784;
		}
		goto yy780;
yy782:
		YYDEBUG(782, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(783, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy782;
		}
		goto yy778;
yy784:
		YYDEBUG(784, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(785, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy784;
		}
		goto yy778;
	}
/* *********************************** */
yyc_INITIAL:
	YYDEBUG(786, *YYCURSOR);
	YYFILL(7);
	yych = *YYCURSOR;
	if (yych == '<') goto yy790;
	YYDEBUG(788, *YYCURSOR);
	++YYCURSOR;
yy789:
	YYDEBUG(789, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

inline_char_handler:

	while (1) {
		YYCTYPE *ptr = memchr(YYCURSOR, '<', YYLIMIT - YYCURSOR);

		YYCURSOR = ptr ? ptr + 1 : YYLIMIT;

		if (YYCURSOR >= YYLIMIT) {
			break;
		}

		if (*YYCURSOR == '?') {
			if (CG(short_tags) || !strncasecmp((char*)YYCURSOR + 1, "php", 3) || (*(YYCURSOR + 1) == '=')) { /* Assume [ \t\n\r] follows "php" */

				YYCURSOR--;
				break;
			}
		}
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	if (SCNG(output_filter)) {
		size_t readsize;
		char *s = NULL;
		size_t sz = 0;
		// TODO: avoid reallocation ???
		readsize = SCNG(output_filter)((unsigned char **)&s, &sz, (unsigned char *)yytext, (size_t)yyleng);
		ZVAL_STRINGL(zendlval, s, sz);
		efree(s);
		if (readsize < yyleng) {
			yyless(readsize);
		}
	} else {
	  ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	HANDLE_NEWLINES(yytext, yyleng);
	return T_INLINE_HTML;
}
yy790:
	YYDEBUG(790, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '?') goto yy789;
	YYDEBUG(791, *YYCURSOR);
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych == '=') goto yy793;
	} else {
		if (yych <= 'P') goto yy795;
		if (yych == 'p') goto yy795;
	}
yy792:
	YYDEBUG(792, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (CG(short_tags)) {
		BEGIN(ST_IN_SCRIPTING);
		return T_OPEN_TAG;
	} else {
		goto inline_char_handler;
	}
}
yy793:
	YYDEBUG(793, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(794, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	BEGIN(ST_IN_SCRIPTING);
	return T_OPEN_TAG_WITH_ECHO;
}
yy795:
	YYDEBUG(795, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy797;
	if (yych == 'h') goto yy797;
yy796:
	YYDEBUG(796, *YYCURSOR);
	YYCURSOR = YYMARKER;
	goto yy792;
yy797:
	YYDEBUG(797, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy798;
	if (yych != 'p') goto yy796;
yy798:
	YYDEBUG(798, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\f') {
		if (yych <= 0x08) goto yy796;
		if (yych >= '\v') goto yy796;
	} else {
		if (yych <= '\r') goto yy801;
		if (yych != ' ') goto yy796;
	}
yy799:
	YYDEBUG(799, *YYCURSOR);
	++YYCURSOR;
yy800:
	YYDEBUG(800, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	HANDLE_NEWLINE(yytext[yyleng-1]);
	BEGIN(ST_IN_SCRIPTING);
	return T_OPEN_TAG;
}
yy801:
	YYDEBUG(801, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\n') goto yy799;
	goto yy800;
/* *********************************** */
yyc_ST_END_HEREDOC:
	YYDEBUG(802, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(804, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(805, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_pop(&SCNG(heredoc_label_stack));

	YYCURSOR += heredoc_label->length - 1;
	yyleng = heredoc_label->length;

	heredoc_label_dtor(heredoc_label);
	efree(heredoc_label);

	BEGIN(ST_IN_SCRIPTING);
	return T_END_HEREDOC;
}
/* *********************************** */
yyc_ST_NOWDOC:
	YYDEBUG(806, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(808, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(809, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	int newline = 0;

	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));

	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					YYCTYPE *end = YYCURSOR + heredoc_label->length;

					if (*end == ';') {
						end++;
					}

					if (*end == '\n' || *end == '\r') {
						/* newline before label will be subtracted from returned text, but
						 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
						if (YYCURSOR[-2] == '\r' && YYCURSOR[-1] == '\n') {
							newline = 2; /* Windows newline */
						} else {
							newline = 1;
						}

						CG(increment_lineno) = 1; /* For newline before label */
						BEGIN(ST_END_HEREDOC);

						goto nowdoc_scan_done;
					}
				}
				/* fall through */
			default:
				continue;
		}
	}

nowdoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_copy_value(zendlval, yytext, yyleng - newline);
	HANDLE_NEWLINES(yytext, yyleng - newline);
	return T_ENCAPSED_AND_WHITESPACE;
}
}

}
real_world/php20150211_zend_language_scanner.re:1096:12: warning: escape has no effect: '\[' [-Wuseless-escape]
real_world/php20150211_zend_language_scanner.re:1477:19: warning: escape has no effect: '\*' [-Wuseless-escape]
real_world/php20150211_zend_language_scanner.re:1481:19: warning: escape has no effect: '\*' [-Wuseless-escape]
real_world/php20150211_zend_language_scanner.re:2359:2: warning: looks like you use hardcoded numbers instead of autogenerated condition names: better add '/*!types:re2c*/' directive or '-t, --type-header' option and don't rely on fixed condition order. [-Wcondition-order]
