// Code generated by go-swagger; DO NOT EDIT.

//
// Copyright 2021 The Sigstore Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package pubkey

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/validate"
)

// NewGetPublicKeyParams creates a new GetPublicKeyParams object
//
// There are no default values defined in the spec.
func NewGetPublicKeyParams() GetPublicKeyParams {

	return GetPublicKeyParams{}
}

// GetPublicKeyParams contains all the bound params for the get public key operation
// typically these are obtained from a http.Request
//
// swagger:parameters getPublicKey
type GetPublicKeyParams struct {

	// HTTP Request Object
	HTTPRequest *http.Request `json:"-"`

	/*The tree ID of the tree you wish to get a public key for
	  Pattern: ^[0-9]+$
	  In: query
	*/
	TreeID *string
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls.
//
// To ensure default values, the struct must have been initialized with NewGetPublicKeyParams() beforehand.
func (o *GetPublicKeyParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error

	o.HTTPRequest = r

	qs := runtime.Values(r.URL.Query())

	qTreeID, qhkTreeID, _ := qs.GetOK("treeID")
	if err := o.bindTreeID(qTreeID, qhkTreeID, route.Formats); err != nil {
		res = append(res, err)
	}
	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindTreeID binds and validates parameter TreeID from query.
func (o *GetPublicKeyParams) bindTreeID(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		return nil
	}
	o.TreeID = &raw

	if err := o.validateTreeID(formats); err != nil {
		return err
	}

	return nil
}

// validateTreeID carries on validations for parameter TreeID
func (o *GetPublicKeyParams) validateTreeID(formats strfmt.Registry) error {

	if err := validate.Pattern("treeID", "query", *o.TreeID, `^[0-9]+$`); err != nil {
		return err
	}

	return nil
}
