use super::Element;

/// The total number of periods in the periodic table
pub const N_PERIODS: u32 = 7;

impl Element {
    /// Returns the element's period number in the periodic table.
    ///
    /// ```
    /// use mendeleev::Element;
    /// assert_eq!(Element::H.period(), 1);
    /// assert_eq!(Element::Og.period(), 7);
    /// ```
    pub const fn period(&self) -> u32 {
        match self {
            Element::H => 1,
            Element::He => 1,
            Element::Li => 2,
            Element::Be => 2,
            Element::B => 2,
            Element::C => 2,
            Element::N => 2,
            Element::O => 2,
            Element::F => 2,
            Element::Ne => 2,
            Element::Na => 3,
            Element::Mg => 3,
            Element::Al => 3,
            Element::Si => 3,
            Element::P => 3,
            Element::S => 3,
            Element::Cl => 3,
            Element::Ar => 3,
            Element::K => 4,
            Element::Ca => 4,
            Element::Sc => 4,
            Element::Ti => 4,
            Element::V => 4,
            Element::Cr => 4,
            Element::Mn => 4,
            Element::Fe => 4,
            Element::Co => 4,
            Element::Ni => 4,
            Element::Cu => 4,
            Element::Zn => 4,
            Element::Ga => 4,
            Element::Ge => 4,
            Element::As => 4,
            Element::Se => 4,
            Element::Br => 4,
            Element::Kr => 4,
            Element::Rb => 5,
            Element::Sr => 5,
            Element::Y => 5,
            Element::Zr => 5,
            Element::Nb => 5,
            Element::Mo => 5,
            Element::Tc => 5,
            Element::Ru => 5,
            Element::Rh => 5,
            Element::Pd => 5,
            Element::Ag => 5,
            Element::Cd => 5,
            Element::In => 5,
            Element::Sn => 5,
            Element::Sb => 5,
            Element::Te => 5,
            Element::I => 5,
            Element::Xe => 5,
            Element::Cs => 6,
            Element::Ba => 6,
            Element::La => 6,
            Element::Ce => 6,
            Element::Pr => 6,
            Element::Nd => 6,
            Element::Pm => 6,
            Element::Sm => 6,
            Element::Eu => 6,
            Element::Gd => 6,
            Element::Tb => 6,
            Element::Dy => 6,
            Element::Ho => 6,
            Element::Er => 6,
            Element::Tm => 6,
            Element::Yb => 6,
            Element::Lu => 6,
            Element::Hf => 6,
            Element::Ta => 6,
            Element::W => 6,
            Element::Re => 6,
            Element::Os => 6,
            Element::Ir => 6,
            Element::Pt => 6,
            Element::Au => 6,
            Element::Hg => 6,
            Element::Tl => 6,
            Element::Pb => 6,
            Element::Bi => 6,
            Element::Po => 6,
            Element::At => 6,
            Element::Rn => 6,
            Element::Fr => 7,
            Element::Ra => 7,
            Element::Ac => 7,
            Element::Th => 7,
            Element::Pa => 7,
            Element::U => 7,
            Element::Np => 7,
            Element::Pu => 7,
            Element::Am => 7,
            Element::Cm => 7,
            Element::Bk => 7,
            Element::Cf => 7,
            Element::Es => 7,
            Element::Fm => 7,
            Element::Md => 7,
            Element::No => 7,
            Element::Lr => 7,
            Element::Rf => 7,
            Element::Db => 7,
            Element::Sg => 7,
            Element::Bh => 7,
            Element::Hs => 7,
            Element::Mt => 7,
            Element::Ds => 7,
            Element::Rg => 7,
            Element::Cn => 7,
            Element::Nh => 7,
            Element::Fl => 7,
            Element::Mc => 7,
            Element::Lv => 7,
            Element::Ts => 7,
            Element::Og => 7,
        }
    }
}
