/*
 * MOTIS API
 *
 * This is the MOTIS routing API.
 *
 * The version of the OpenAPI document: v1
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct Plan200Response {
    /// the routing query
    #[serde(rename = "requestParameters")]
    pub request_parameters: std::collections::HashMap<String, String>,
    /// debug statistics
    #[serde(rename = "debugOutput")]
    pub debug_output: std::collections::HashMap<String, i32>,
    #[serde(rename = "from")]
    pub from: Box<models::Place>,
    #[serde(rename = "to")]
    pub to: Box<models::Place>,
    /// Direct trips by `WALK`, `BIKE`, `CAR`, etc. without time-dependency. The starting time (`arriveBy=false`) / arrival time (`arriveBy=true`) is always the queried `time` parameter (set to \\\"now\\\" if not set). But all `direct` connections are meant to be independent of absolute times. 
    #[serde(rename = "direct")]
    pub direct: Vec<models::Itinerary>,
    /// list of itineraries
    #[serde(rename = "itineraries")]
    pub itineraries: Vec<models::Itinerary>,
    /// Use the cursor to get the previous page of results. Insert the cursor into the request and post it to get the previous page. The previous page is a set of itineraries departing BEFORE the first itinerary in the result for a depart after search. When using the default sort order the previous set of itineraries is inserted before the current result. 
    #[serde(rename = "previousPageCursor")]
    pub previous_page_cursor: String,
    /// Use the cursor to get the next page of results. Insert the cursor into the request and post it to get the next page. The next page is a set of itineraries departing AFTER the last itinerary in this result. 
    #[serde(rename = "nextPageCursor")]
    pub next_page_cursor: String,
}

impl Plan200Response {
    pub fn new(request_parameters: std::collections::HashMap<String, String>, debug_output: std::collections::HashMap<String, i32>, from: models::Place, to: models::Place, direct: Vec<models::Itinerary>, itineraries: Vec<models::Itinerary>, previous_page_cursor: String, next_page_cursor: String) -> Plan200Response {
        Plan200Response {
            request_parameters,
            debug_output,
            from: Box::new(from),
            to: Box::new(to),
            direct,
            itineraries,
            previous_page_cursor,
            next_page_cursor,
        }
    }
}

