#encoding: utf-8
#- Name: SiSU
#
#  - Description: documents, structuring, processing, publishing, search
#    misc
#
#  - Author: Ralph Amissah
#    <ralph.amissah@gmail.com>
#
#  - Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
#    2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2019,
#    2020, 2021, Ralph Amissah,
#    All Rights Reserved.
#
#  - License: GPL 3 or later:
#
#    SiSU, a framework for document structuring, publishing and search
#
#    Copyright (C) Ralph Amissah
#
#    This program is free software: you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation, either version 3 of the License, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful, but WITHOUT
#    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
#    FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
#    more details.
#
#    You should have received a copy of the GNU General Public License along with
#    this program. If not, see <http://www.gnu.org/licenses/>.
#
#    If you have Internet connection, the latest version of the GPL should be
#    available at these locations:
#    <http://www.fsf.org/licensing/licenses/gpl.html>
#    <http://www.gnu.org/licenses/gpl.html>
#
#    <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>
#
#  - SiSU uses:
#    - Standard SiSU markup syntax,
#    - Standard SiSU meta-markup syntax, and the
#    - Standard SiSU object citation numbering and system
#
#  - Homepages:
#    <http://www.sisudoc.org>
#
#  - Git
#    <https://git.sisudoc.org/projects/>
#    <https://git.sisudoc.org/projects/sisu>
#    <https://git.sisudoc.org/projects/sisu-markup>
module SiSU_Webserv
  class WebrickStart
    begin
      require 'time'
      require 'webrick'
        include WEBrick
    rescue LoadError
      SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).
        error('time or webrick NOT FOUND (LoadError)')
    end
    require_relative 'se'                                 # se.rb
      include SiSU_Env
      include SiSU_Screen
    def initialize
      @cX=SiSU_Screen::Ansi.new('yes').cX
      @env=SiSU_Env::InfoEnv.new
      port=SiSU_Env::InfoPort.new
      @host=@env.url.webrick
      @port=port.webrick
      @serve=[]
      Dir.foreach(@env.path.webserv) do |x|
        if x !~/^\./ \
        and FileTest.directory?("#{@env.path.webserv}/#{x}")
          @serve << x
        end
      end
      @mount=[]
      @serve.each {|x| @mount << ["/#{x}", "#{@env.path.webserv}/#{x}"]}
      @pwd=Dir.pwd
      @week=Time.now.strftime(%{%Yw%W})
      puts "\n"
      @mount.each { |x,y|
        puts "  * #{@cX.blue}#{@host}:#{@port}#{x}/#{@cX.off}"
      }
      get=Dir.pwd
      brick(@port,get)
    end
    def brick(port,get='')
      cgidir=if get=~/pwd/ then Dir.pwd
      else                      '/usr/lib/cgi-bin'
      end
      port=SiSU_Env::InfoPort.new.webrick
      begin
        s=HTTPServer.new(
          Port:         port,
          DocumentRoot: Dir::pwd + '/htdocs',
          CGIPathEnv:   ENV['PATH']
        )
        cgi_dir=File.expand_path(cgidir)
        @mount.each { |x,y|                                                        # mount subdirectories
          s.mount(x, HTTPServlet::FileHandler, y, true)
        }
        s.mount('/cgi-bin', HTTPServlet::FileHandler, cgi_dir, { FancyIndexing: true })
        trap("INT"){ s.shutdown }
        s.start
      rescue
        SiSU_Errors::Rescued.new($!,$@,'-W',nil).location do #fix
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
      end
    end
    def wb_cgi
      begin                                                                          #%
        wb_s2=''
                                                                 #% writes file wb.cgi to shared directories ...
                                                                 #% wb_top
        wb_top=%q(#!/usr/bin/env ruby
        # * arch-tag: webrick info on environment, mounted directories, and contents of pwd
        begin
          require 'time'
          require 'cgi'
          require 'fcgi'
        rescue LoadError
          puts 'time, cgi or fcgi NOT FOUND (LoadError)'
        end
        ls=Dir.entries('./')
        dir_contents=[]
        ls.each { |x| dir_contents << "<a href=\"./#{x}/\">#{x}</a><br>" unless x =~/^(\.)+$/ }
        dir_contents=dir_contents.sort.join(' ')
        #host=ENV['HOSTNAME']
        #host=%x{echo $HOSTNAME}
        )
        wb_s1=<<-WOK

  page=CGI.new "html3"
  page.out {
    page.html {
      page.head { page.title {"#{@host} Webrick Report"} } +
      page.body {
        page.h1 {"Webrick #{@host}"} +
        page.p {"Webrick is Ruby's built in webserver."} +
        page.center {"Host name: " + page.b{"#{@host} "} + "(#{@host})  port: " + page.b{"#{@port}"}} +
        page.center {"#{Time.now}"} +
        page.center {"#{Time.now.strftime(%{%Yw%W})}"} +
        page.p {''} +
        page.p {''} +
        page.p {page.b{"Webrick Served Directories: "}} +
        WOK
                                                               #% wb_s2 (mounts)
        @mount.each do |x,y| wb_s2 += <<-WOK
          page.p {%{<a href="#{@host}:#{@port}#{x}/">#{x}</a> } +
            %{<a href="#{@host}:#{@port}#{x}/">#{@host}:#{@port}#{x}</a> (mounts: #{y}/)   <a href="#{@host}:#{@port}#{x}/wb.cgi">info (wb.cgi)</a>}} +
          WOK
        end
                                                               #% wb_end
        wb_end=<<-WOK
        page.p {page.b{"Contents of PWD (see URL): "}} +
        page.p {"#\{dir_contents}"}
      }
    }
  }
        WOK
        @mount.each { |x,y|                                      #% wb puts
          puts y
            filename=File.new("#{y}/wb.cgi",'w')
            filename << wb_top
            filename << wb_s1
            filename << wb_s2
            filename << wb_end
            filename.close
            FileUtils::chmod(0755,"#{y}/wb.cgi &") if FileTest.file?("#{y}/wb.cgi &")
        }
      rescue
        SiSU_Errors::Rescued.new($!,$@,'-W',nil).location do #fix
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
      end
    end
  end
ensure
end
__END__
