# How to get involved with Sonic Pi's translation effort

[![Weblate](https://hosted.weblate.org/widgets/sonic-pi/-/svg-badge.svg)](https://hosted.weblate.org/engage/sonic-pi/)

__(This document is meant for translators who want to help bring Sonic Pi
to their language. If you're contributing code to Sonic Pi, please read
the primer to the [Translation Workflow](TRANSLATION-WORKFLOW.md) to
learn about the inner workings of i18n in your code.)__

Sonic Pi is designed to be usable by everyone including school students
from 10 years old. It's therefore important to us that it is usable
outside the English-speaking world. We are crowd-sourcing the
translation effort so if you want to help people in your community to be
able to play with it in your language, please consider joining the
translation effort.

Luckily a number of fabulous contributors have already started to
translate much of Sonic Pi to their language. However, we always
appreciate help by those willing to proofread, spellcheck or update the
existing translations. Every contribution - big or small is hugely
appreciated.

*Thanks to everybody involved!*


## Getting started

As Sonic Pi development moves fast, there are always updates to the GUI
(Graphical User Interface) and the tutorial. To help translators keep
track of these changes, we use
*[Weblate](https://hosted.weblate.org/engage/sonic-pi/)*, an
open-source web-based translation editor.

The nice thing about Weblate is that you don't need to be a developer to
help translate Sonic Pi.


## What you can translate

* The *Sonic Pi Qt GUI* is the application you use on your desktop
  screen. It contains few message strings and translating it is easy.

* The *Tutorial* is a long document. Translating it requires
  significantly more effort, but it's very rewarding as it is a
  step-by-step introduction for new users to Sonic Pi.

  The tutorial is written in
  [Github Markdown](https://guides.github.com/features/mastering-markdown/),
  which contains a few special control character sequences.

* (The *Reference* cannot be translated - yet. We're working on that.)


## How to fix or contribute a translation

So if you want to...

* add a missing translation
* proofread an existing translation
* correct a mistake in a translation
* translate to a whole new language

...all you need to do is visit [Sonic Pi on
Weblate](https://hosted.weblate.org/engage/sonic-pi/), sign up and
follow the instructions there.

Weblate gives you a number of helpful tools, e.g. it spots common
mistakes and you can keep a glossary of recurring terms that you can
share with other translators.

We can't thank you enough for putting up with the inconvenience of
translating Sonic Pi, but allow me to ask you for one more giant
favour: If you want to help keep the translation up-to-date in the
future, please consider [subscribing to the Sonic Pi project on
Weblate](https://hosted.weblate.org/accounts/profile/#subscriptions) so
that you will be informed of new or changed strings.


## Translation style

The original English text was written in a fun, friendly, open and
informal style designed to be accessible to children and adults
alike. We would invite you to attempt to adopt this style when working
on translations to another language. For example, try to use simple
language where possible - and where not, try and explain what the
complicated/technical words mean.

If it helps, try to think of Sonic Pi as a friend - and adopt the language
a friend might use when explaining things to you.


## How to fix the original English texts

You cannot change the original English strings with Weblate. If you
spot a mistake in the English texts, please [file an
issue](https://github.com/samaaron/sonic-pi/issues) or correct it with
a pull request here on github. Thanks!
