9.3 Multiple Live Loops

# Multiple Live Loops

Consider the following live loop:

```
live_loop :foo do
  play 50
  sleep 1
end
```

You may have wondered why it needs the name `:foo`. This name is
important because it signifies that this live loop is different from all
other live loops. 

*There can never be two live loops running with the same name*.

This means that if we want multiple concurrently running live loops, we
just need to give them different names:

```
live_loop :foo do
  use_synth :prophet
  play :c1, release: 8, cutoff: rrand(70, 130)
  sleep 8
end

live_loop :bar do
  sample :bd_haus
  sleep 0.5
end
```

You can now update and change each live loop independently and it all
just works.

## Syncing Live Loops

One thing you might have already noticed is that live loops work
automatically with the thread cue mechanism we explored
previously. Every time the live loop loops, it generates a new `cue`
event with the name of the live loop. We can therefore `sync` on these
cues to ensure our loops are in sync without having to stop anything.

Consider this badly synced code:

```
live_loop :foo do
  play :e4, release: 0.5
  sleep 0.4
end

live_loop :bar do
  sample :bd_haus
  sleep 1
end
```

Let's see if we can fix the timing and sync without stopping it. First,
let's fix the `:foo` loop to make the sleep a factor of 1 - something like
`0.5` will do:

```
live_loop :foo do
  play :e4, release: 0.5
  sleep 0.5
end

live_loop :bar do
  sample :bd_haus
  sleep 1
end
```

We're not quite finished yet though - you'll notice that the beats don't
quite line up correctly. This is because the loops are *out of
phase*. Let's fix that by syncing one to the other:

```
live_loop :foo do
  play :e4, release: 0.5
  sleep 0.5
end

live_loop :bar do
  sync :foo
  sample :bd_haus
  sleep 1
end
```

Wow, everything is now perfectly in time - all without stopping.

Now, go forth and live code with live loops!
