/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.BaseHash;
import cds.healpix.CompassPoint;
import java.util.EnumSet;

final class BaseHashEquatorial
extends BaseHash {
    private static final EnumSet<CompassPoint.MainWind> noNeighbour = EnumSet.of(CompassPoint.MainWind.N, CompassPoint.MainWind.S);

    protected BaseHashEquatorial(int baseHash) {
        super(baseHash);
    }

    @Override
    protected void fillNeighbours(int d0h, int[] neighbours) {
        int hm1Modulo4;
        assert (4 <= d0h && d0h < 8);
        int hModulo4 = d0h & 3;
        int hp1Modulo4 = hModulo4 + 1 & 3;
        neighbours[CompassPoint.MainWind.SE.getIndex()] = hModulo4 + 8;
        neighbours[CompassPoint.MainWind.E.getIndex()] = hp1Modulo4 + 4;
        neighbours[CompassPoint.MainWind.NE.getIndex()] = hModulo4;
        neighbours[CompassPoint.MainWind.S.getIndex()] = -1;
        neighbours[CompassPoint.MainWind.C.getIndex()] = d0h;
        neighbours[CompassPoint.MainWind.N.getIndex()] = -1;
        neighbours[CompassPoint.MainWind.NW.getIndex()] = hm1Modulo4 = hModulo4 - 1 & 3;
        neighbours[CompassPoint.MainWind.W.getIndex()] = hm1Modulo4 + 4;
        neighbours[CompassPoint.MainWind.SW.getIndex()] = hm1Modulo4 + 8;
    }

    @Override
    CompassPoint.MainWind getDirectionFromNeighbour(CompassPoint.MainWind neighbourMainWind) {
        if (noNeighbour.contains((Object)neighbourMainWind)) {
            throw new IllegalArgumentException("No neighbour in direction " + (Object)((Object)neighbourMainWind));
        }
        return neighbourMainWind.getOppositeDirection();
    }

    @Override
    CompassPoint.MainWind getEdgeCellDirectionFromNeighbour(CompassPoint.MainWind innerDirection, CompassPoint.MainWind neighbourDirection) {
        return neighbourDirection.getOppositeDirection();
    }

    @Override
    int pickRightIndexOnNeighbourSouthToEastAxis(CompassPoint.MainWind neighbourDirection, int iAxisSE, int iAxisSW, int nsideMinus1) {
        return neighbourDirection.pickRightIntValue(iAxisSE, -1, 0, nsideMinus1, iAxisSE, 0, nsideMinus1, -1, iAxisSE);
    }

    @Override
    long pickRightIndexBitsOnNeighbourSouthToEastAxis(CompassPoint.MainWind neighbourDirection, long iAxisSEBits, long jAxisSWBits, long nsideMinus1Bits) {
        return neighbourDirection.pickRightLongValue(iAxisSEBits, -1L, 0L, nsideMinus1Bits, iAxisSEBits, 0L, nsideMinus1Bits, -1L, iAxisSEBits);
    }

    @Override
    int pickRightIndexOnNeighbourSouthToWestAxis(CompassPoint.MainWind neighbourDirection, int iAxisSE, int iAxisSW, int nsideMinus1) {
        return neighbourDirection.pickRightIntValue(0, -1, iAxisSW, 0, iAxisSW, nsideMinus1, iAxisSW, -1, nsideMinus1);
    }

    @Override
    long pickRightIndexSWBits(CompassPoint.MainWind neighbourDirection, long iAxisSEBits, long jAxisSWBits, long nsideMinus1Bits) {
        return neighbourDirection.pickRightLongValue(0L, -1L, jAxisSWBits, 0L, jAxisSWBits, nsideMinus1Bits, jAxisSWBits, -1L, nsideMinus1Bits);
    }
}

