## TFSA-2022-034: Null-dereference when specializing tensor type

### CVE Number
CVE-2022-23570

### Impact
When decoding a tensor from protobuf, TensorFlow might do a null-dereference if attributes of some mutable arguments to some operations are missing from the proto. This is [guarded by a `DCHECK`](https://github.com/tensorflow/tensorflow/blob/a1320ec1eac186da1d03f033109191f715b2b130/tensorflow/core/framework/full_type_util.cc#L104-L106):

```cc
  const auto* attr = attrs.Find(arg->s());
  DCHECK(attr != nullptr);
  if (attr->value_case() == AttrValue::kList) {
    // ...
  }
```

However, `DCHECK` is a no-op in production builds and an assertion failure in debug builds. In the first case execution proceeds to the dereferencing of the null pointer, whereas in the second case it results in a crash due to the assertion failure.

### Patches
We have patched the issue in GitHub commit [8a513cec4bec15961fbfdedcaa5376522980455c](https://github.com/tensorflow/tensorflow/commit/8a513cec4bec15961fbfdedcaa5376522980455c).

The fix will be included in TensorFlow 2.8.0. We will also cherrypick this commit on TensorFlow 2.7.1, and TensorFlow 2.6.3, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.
