#include <iostream>

#include "CommandlineOptions.hh"

#include "Symmetry.hh"
#include "Chirotope.hh"

int main (const int argc, const char** argv) {
  using namespace topcom;

  CommandlineOptions::init(argc, argv);
  MessageStreams::forced() << std::endl;
  MessageStreams::forced() << "------------------------------------------------------------------\n";
  MessageStreams::forced() << " computing the chirotope of a point configuration \n";
  MessageStreams::forced() << " TOPCOM client: " << CommandlineOptions::client() << '\n';
  MessageStreams::forced() << "------------------------------------------------------------------\n";
  MessageStreams::forced() << std::endl;
  PointConfiguration points;
  if (std::cin >> points) {
    PointConfiguration points_full_rank(points);
    points_full_rank.transform_to_full_rank();
    if ((points_full_rank.coldim() < 1) || (points_full_rank.rowdim() < 1)) {
      MessageStreams::verbose() << "no of points and rank must be at least one." << std::endl;
      return 1;
    }
    if (points_full_rank.rowdim() > points_full_rank.coldim()) {
      MessageStreams::forced() << "rank must not be larger than no of points." << std::endl;
      return 1;
    }
    Chirotope chiro(points_full_rank, true);
    chiro.print_string(MessageStreams::result());
    SymmetryGroup symmetries(points_full_rank.coldim());
    if (symmetries.read_generators(std::cin)) {
      symmetries.write_sorted_generators(MessageStreams::result());
      MessageStreams::result() << std::endl;
    }
    else {
      MessageStreams::verbose() << "no valid symmetry generators found." << std::endl;
    }
    return 0;
  }
  else {
    MessageStreams::forced() << argv[0] << ": error while reading point configuration." << std::endl;
    return 1;
  }
}

// eof points2chiro.cc
