require 'unit_helper'

require 'vagrant-lxc/plugin'
require 'vagrant-lxc/provider'
require 'vagrant-lxc/action/compress_rootfs'

describe Vagrant::LXC::Action::CompressRootFS do
  let(:app)                    { double(:app, call: true) }
  let(:env)                    { {machine: machine, ui: double(info: true)} }
  let(:machine)                { double(Vagrant::Machine, provider: provider) }
  let(:provider)               { double(Vagrant::LXC::Provider, driver: driver) }
  let(:driver)                 { double(Vagrant::LXC::Driver, compress_rootfs: compressed_rootfs_path) }
  let(:compressed_rootfs_path) { '/path/to/rootfs.tar.gz' }

  subject { described_class.new(app, env) }

  before do
    provider.stub_chain(:state, :id).and_return(:stopped)
    subject.call(env)
  end

  it "asks the driver to compress container's rootfs" do
    expect(driver).to have_received(:compress_rootfs)
  end

  it 'sets export.temp_dir on action env' do
    expect(env['package.rootfs']).to eq(compressed_rootfs_path)
  end
end
