/* armv8-aes-asm
 *
 * Copyright (C) 2006-2025 wolfSSL Inc.
 *
 * This file is part of wolfSSL.
 *
 * wolfSSL is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * wolfSSL is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1335, USA
 */

#include <wolfssl/wolfcrypt/libwolfssl_sources_asm.h>

/* Generated using (from wolfssl):
 *   cd ../scripts
 *   ruby ./aes/aes.rb arm64 \
 *       ../wolfssl/wolfcrypt/src/port/arm/armv8-aes-asm.S
 */
#ifdef WOLFSSL_ARMASM
#ifdef __aarch64__
#ifndef WOLFSSL_ARMASM_INLINE
#if !defined(NO_AES) && defined(WOLFSSL_ARMASM)
#ifndef WOLFSSL_ARMASM_NO_HW_CRYPTO
#ifndef __APPLE__
.text
.globl	AES_set_key_AARCH64
.type	AES_set_key_AARCH64,@function
.align	2
AES_set_key_AARCH64:
#else
.section	__TEXT,__text
.globl	_AES_set_key_AARCH64
.p2align	2
_AES_set_key_AARCH64:
#endif /* __APPLE__ */
	cmp	x1, #24
	blt	L_aes_set_key_arm64_crypto_start_128
	bgt	L_aes_set_key_arm64_crypto_start_256
	ldr	x4, [x0], #8
	ldr	x6, [x0], #8
	ldr	x8, [x0], #8
	stp	x4, x6, [x2], #16
	str	x8, [x2], #8
	lsr	x5, x4, #32
	lsr	x7, x6, #32
	lsr	x9, x8, #32
	dup	v1.4s, w9
	movi	v0.16b, #0
	aese	v0.16b, v1.16b
	mov	w12, v0.s[0]
	ror	w12, w12, #8
	eor	w4, w4, #1
	eor	w4, w4, w12
	eor	w5, w5, w4
	eor	w6, w6, w5
	eor	w7, w7, w6
	eor	w8, w8, w7
	eor	w9, w9, w8
	stp	w4, w5, [x2], #8
	stp	w6, w7, [x2], #8
	stp	w8, w9, [x2], #8
	dup	v1.4s, w9
	movi	v0.16b, #0
	aese	v0.16b, v1.16b
	mov	w12, v0.s[0]
	ror	w12, w12, #8
	eor	w4, w4, #2
	eor	w4, w4, w12
	eor	w5, w5, w4
	eor	w6, w6, w5
	eor	w7, w7, w6
	eor	w8, w8, w7
	eor	w9, w9, w8
	stp	w4, w5, [x2], #8
	stp	w6, w7, [x2], #8
	stp	w8, w9, [x2], #8
	dup	v1.4s, w9
	movi	v0.16b, #0
	aese	v0.16b, v1.16b
	mov	w12, v0.s[0]
	ror	w12, w12, #8
	eor	w4, w4, #4
	eor	w4, w4, w12
	eor	w5, w5, w4
	eor	w6, w6, w5
	eor	w7, w7, w6
	eor	w8, w8, w7
	eor	w9, w9, w8
	stp	w4, w5, [x2], #8
	stp	w6, w7, [x2], #8
	stp	w8, w9, [x2], #8
	dup	v1.4s, w9
	movi	v0.16b, #0
	aese	v0.16b, v1.16b
	mov	w12, v0.s[0]
	ror	w12, w12, #8
	eor	w4, w4, #8
	eor	w4, w4, w12
	eor	w5, w5, w4
	eor	w6, w6, w5
	eor	w7, w7, w6
	eor	w8, w8, w7
	eor	w9, w9, w8
	stp	w4, w5, [x2], #8
	stp	w6, w7, [x2], #8
	stp	w8, w9, [x2], #8
	dup	v1.4s, w9
	movi	v0.16b, #0
	aese	v0.16b, v1.16b
	mov	w12, v0.s[0]
	ror	w12, w12, #8
	eor	w4, w4, #16
	eor	w4, w4, w12
	eor	w5, w5, w4
	eor	w6, w6, w5
	eor	w7, w7, w6
	eor	w8, w8, w7
	eor	w9, w9, w8
	stp	w4, w5, [x2], #8
	stp	w6, w7, [x2], #8
	stp	w8, w9, [x2], #8
	dup	v1.4s, w9
	movi	v0.16b, #0
	aese	v0.16b, v1.16b
	mov	w12, v0.s[0]
	ror	w12, w12, #8
	eor	w4, w4, #32
	eor	w4, w4, w12
	eor	w5, w5, w4
	eor	w6, w6, w5
	eor	w7, w7, w6
	eor	w8, w8, w7
	eor	w9, w9, w8
	stp	w4, w5, [x2], #8
	stp	w6, w7, [x2], #8
	stp	w8, w9, [x2], #8
	dup	v1.4s, w9
	movi	v0.16b, #0
	aese	v0.16b, v1.16b
	mov	w12, v0.s[0]
	ror	w12, w12, #8
	eor	w4, w4, #0x40
	eor	w4, w4, w12
	eor	w5, w5, w4
	eor	w6, w6, w5
	eor	w7, w7, w6
	eor	w8, w8, w7
	eor	w9, w9, w8
	stp	w4, w5, [x2], #8
	stp	w6, w7, [x2], #8
	stp	w8, w9, [x2], #8
	dup	v1.4s, w9
	movi	v0.16b, #0
	aese	v0.16b, v1.16b
	mov	w12, v0.s[0]
	ror	w12, w12, #8
	eor	w4, w4, #0x80
	eor	w4, w4, w12
	eor	w5, w5, w4
	eor	w6, w6, w5
	eor	w7, w7, w6
	stp	w4, w5, [x2], #8
	stp	w6, w7, [x2], #8
	cmp	x3, #0
	beq	L_aes_set_key_arm64_crypto_done
	sub	x2, x2, #0xd0
	ldur	q0, [x2]
	ldur	q1, [x2, #192]
	stur	q1, [x2]
	stur	q0, [x2, #192]
	ldur	q0, [x2, #16]
	ldur	q1, [x2, #176]
	aesimc	v0.16b, v0.16b
	aesimc	v1.16b, v1.16b
	stur	q1, [x2, #16]
	stur	q0, [x2, #176]
	ldur	q0, [x2, #32]
	ldur	q1, [x2, #160]
	aesimc	v0.16b, v0.16b
	aesimc	v1.16b, v1.16b
	stur	q1, [x2, #32]
	stur	q0, [x2, #160]
	ldur	q0, [x2, #48]
	ldur	q1, [x2, #144]
	aesimc	v0.16b, v0.16b
	aesimc	v1.16b, v1.16b
	stur	q1, [x2, #48]
	stur	q0, [x2, #144]
	ldur	q0, [x2, #64]
	ldur	q1, [x2, #128]
	aesimc	v0.16b, v0.16b
	aesimc	v1.16b, v1.16b
	stur	q1, [x2, #64]
	stur	q0, [x2, #128]
	ldur	q0, [x2, #80]
	ldur	q1, [x2, #112]
	aesimc	v0.16b, v0.16b
	aesimc	v1.16b, v1.16b
	stur	q1, [x2, #80]
	stur	q0, [x2, #112]
	ldur	q0, [x2, #96]
	aesimc	v0.16b, v0.16b
	stur	q0, [x2, #96]
	b	L_aes_set_key_arm64_crypto_done
L_aes_set_key_arm64_crypto_start_256:
	ldr	x4, [x0], #8
	ldr	x6, [x0], #8
	ldr	x8, [x0], #8
	ldr	x10, [x0], #8
	stp	x4, x6, [x2], #16
	stp	x8, x10, [x2], #16
	lsr	x5, x4, #32
	lsr	x7, x6, #32
	lsr	x9, x8, #32
	lsr	x11, x10, #32
	dup	v1.4s, w11
	movi	v0.16b, #0
	aese	v0.16b, v1.16b
	mov	w12, v0.s[0]
	ror	w12, w12, #8
	eor	w4, w4, #1
	eor	w4, w4, w12
	eor	w5, w5, w4
	eor	w6, w6, w5
	eor	w7, w7, w6
	dup	v1.4s, w7
	movi	v0.16b, #0
	aese	v0.16b, v1.16b
	mov	w12, v0.s[0]
	eor	w8, w8, w12
	eor	w9, w9, w8
	eor	w10, w10, w9
	eor	w11, w11, w10
	stp	w4, w5, [x2], #8
	stp	w6, w7, [x2], #8
	stp	w8, w9, [x2], #8
	stp	w10, w11, [x2], #8
	dup	v1.4s, w11
	movi	v0.16b, #0
	aese	v0.16b, v1.16b
	mov	w12, v0.s[0]
	ror	w12, w12, #8
	eor	w4, w4, #2
	eor	w4, w4, w12
	eor	w5, w5, w4
	eor	w6, w6, w5
	eor	w7, w7, w6
	dup	v1.4s, w7
	movi	v0.16b, #0
	aese	v0.16b, v1.16b
	mov	w12, v0.s[0]
	eor	w8, w8, w12
	eor	w9, w9, w8
	eor	w10, w10, w9
	eor	w11, w11, w10
	stp	w4, w5, [x2], #8
	stp	w6, w7, [x2], #8
	stp	w8, w9, [x2], #8
	stp	w10, w11, [x2], #8
	dup	v1.4s, w11
	movi	v0.16b, #0
	aese	v0.16b, v1.16b
	mov	w12, v0.s[0]
	ror	w12, w12, #8
	eor	w4, w4, #4
	eor	w4, w4, w12
	eor	w5, w5, w4
	eor	w6, w6, w5
	eor	w7, w7, w6
	dup	v1.4s, w7
	movi	v0.16b, #0
	aese	v0.16b, v1.16b
	mov	w12, v0.s[0]
	eor	w8, w8, w12
	eor	w9, w9, w8
	eor	w10, w10, w9
	eor	w11, w11, w10
	stp	w4, w5, [x2], #8
	stp	w6, w7, [x2], #8
	stp	w8, w9, [x2], #8
	stp	w10, w11, [x2], #8
	dup	v1.4s, w11
	movi	v0.16b, #0
	aese	v0.16b, v1.16b
	mov	w12, v0.s[0]
	ror	w12, w12, #8
	eor	w4, w4, #8
	eor	w4, w4, w12
	eor	w5, w5, w4
	eor	w6, w6, w5
	eor	w7, w7, w6
	dup	v1.4s, w7
	movi	v0.16b, #0
	aese	v0.16b, v1.16b
	mov	w12, v0.s[0]
	eor	w8, w8, w12
	eor	w9, w9, w8
	eor	w10, w10, w9
	eor	w11, w11, w10
	stp	w4, w5, [x2], #8
	stp	w6, w7, [x2], #8
	stp	w8, w9, [x2], #8
	stp	w10, w11, [x2], #8
	dup	v1.4s, w11
	movi	v0.16b, #0
	aese	v0.16b, v1.16b
	mov	w12, v0.s[0]
	ror	w12, w12, #8
	eor	w4, w4, #16
	eor	w4, w4, w12
	eor	w5, w5, w4
	eor	w6, w6, w5
	eor	w7, w7, w6
	dup	v1.4s, w7
	movi	v0.16b, #0
	aese	v0.16b, v1.16b
	mov	w12, v0.s[0]
	eor	w8, w8, w12
	eor	w9, w9, w8
	eor	w10, w10, w9
	eor	w11, w11, w10
	stp	w4, w5, [x2], #8
	stp	w6, w7, [x2], #8
	stp	w8, w9, [x2], #8
	stp	w10, w11, [x2], #8
	dup	v1.4s, w11
	movi	v0.16b, #0
	aese	v0.16b, v1.16b
	mov	w12, v0.s[0]
	ror	w12, w12, #8
	eor	w4, w4, #32
	eor	w4, w4, w12
	eor	w5, w5, w4
	eor	w6, w6, w5
	eor	w7, w7, w6
	dup	v1.4s, w7
	movi	v0.16b, #0
	aese	v0.16b, v1.16b
	mov	w12, v0.s[0]
	eor	w8, w8, w12
	eor	w9, w9, w8
	eor	w10, w10, w9
	eor	w11, w11, w10
	stp	w4, w5, [x2], #8
	stp	w6, w7, [x2], #8
	stp	w8, w9, [x2], #8
	stp	w10, w11, [x2], #8
	dup	v1.4s, w11
	movi	v0.16b, #0
	aese	v0.16b, v1.16b
	mov	w12, v0.s[0]
	ror	w12, w12, #8
	eor	w4, w4, #0x40
	eor	w4, w4, w12
	eor	w5, w5, w4
	eor	w6, w6, w5
	eor	w7, w7, w6
	stp	w4, w5, [x2], #8
	stp	w6, w7, [x2], #8
	cmp	x3, #0
	beq	L_aes_set_key_arm64_crypto_done
	sub	x2, x2, #0xf0
	ldur	q0, [x2]
	ldur	q1, [x2, #224]
	stur	q1, [x2]
	stur	q0, [x2, #224]
	ldur	q0, [x2, #16]
	ldur	q1, [x2, #208]
	aesimc	v0.16b, v0.16b
	aesimc	v1.16b, v1.16b
	stur	q1, [x2, #16]
	stur	q0, [x2, #208]
	ldur	q0, [x2, #32]
	ldur	q1, [x2, #192]
	aesimc	v0.16b, v0.16b
	aesimc	v1.16b, v1.16b
	stur	q1, [x2, #32]
	stur	q0, [x2, #192]
	ldur	q0, [x2, #48]
	ldur	q1, [x2, #176]
	aesimc	v0.16b, v0.16b
	aesimc	v1.16b, v1.16b
	stur	q1, [x2, #48]
	stur	q0, [x2, #176]
	ldur	q0, [x2, #64]
	ldur	q1, [x2, #160]
	aesimc	v0.16b, v0.16b
	aesimc	v1.16b, v1.16b
	stur	q1, [x2, #64]
	stur	q0, [x2, #160]
	ldur	q0, [x2, #80]
	ldur	q1, [x2, #144]
	aesimc	v0.16b, v0.16b
	aesimc	v1.16b, v1.16b
	stur	q1, [x2, #80]
	stur	q0, [x2, #144]
	ldur	q0, [x2, #96]
	ldur	q1, [x2, #128]
	aesimc	v0.16b, v0.16b
	aesimc	v1.16b, v1.16b
	stur	q1, [x2, #96]
	stur	q0, [x2, #128]
	ldur	q0, [x2, #112]
	aesimc	v0.16b, v0.16b
	stur	q0, [x2, #112]
	b	L_aes_set_key_arm64_crypto_done
L_aes_set_key_arm64_crypto_start_128:
	ldr	x4, [x0], #8
	ldr	x6, [x0], #8
	stp	x4, x6, [x2], #16
	lsr	x5, x4, #32
	lsr	x7, x6, #32
	dup	v1.4s, w7
	movi	v0.16b, #0
	aese	v0.16b, v1.16b
	mov	w12, v0.s[0]
	ror	w12, w12, #8
	eor	w4, w4, #1
	eor	w4, w4, w12
	eor	w5, w5, w4
	eor	w6, w6, w5
	eor	w7, w7, w6
	stp	w4, w5, [x2], #8
	stp	w6, w7, [x2], #8
	dup	v1.4s, w7
	movi	v0.16b, #0
	aese	v0.16b, v1.16b
	mov	w12, v0.s[0]
	ror	w12, w12, #8
	eor	w4, w4, #2
	eor	w4, w4, w12
	eor	w5, w5, w4
	eor	w6, w6, w5
	eor	w7, w7, w6
	stp	w4, w5, [x2], #8
	stp	w6, w7, [x2], #8
	dup	v1.4s, w7
	movi	v0.16b, #0
	aese	v0.16b, v1.16b
	mov	w12, v0.s[0]
	ror	w12, w12, #8
	eor	w4, w4, #4
	eor	w4, w4, w12
	eor	w5, w5, w4
	eor	w6, w6, w5
	eor	w7, w7, w6
	stp	w4, w5, [x2], #8
	stp	w6, w7, [x2], #8
	dup	v1.4s, w7
	movi	v0.16b, #0
	aese	v0.16b, v1.16b
	mov	w12, v0.s[0]
	ror	w12, w12, #8
	eor	w4, w4, #8
	eor	w4, w4, w12
	eor	w5, w5, w4
	eor	w6, w6, w5
	eor	w7, w7, w6
	stp	w4, w5, [x2], #8
	stp	w6, w7, [x2], #8
	dup	v1.4s, w7
	movi	v0.16b, #0
	aese	v0.16b, v1.16b
	mov	w12, v0.s[0]
	ror	w12, w12, #8
	eor	w4, w4, #16
	eor	w4, w4, w12
	eor	w5, w5, w4
	eor	w6, w6, w5
	eor	w7, w7, w6
	stp	w4, w5, [x2], #8
	stp	w6, w7, [x2], #8
	dup	v1.4s, w7
	movi	v0.16b, #0
	aese	v0.16b, v1.16b
	mov	w12, v0.s[0]
	ror	w12, w12, #8
	eor	w4, w4, #32
	eor	w4, w4, w12
	eor	w5, w5, w4
	eor	w6, w6, w5
	eor	w7, w7, w6
	stp	w4, w5, [x2], #8
	stp	w6, w7, [x2], #8
	dup	v1.4s, w7
	movi	v0.16b, #0
	aese	v0.16b, v1.16b
	mov	w12, v0.s[0]
	ror	w12, w12, #8
	eor	w4, w4, #0x40
	eor	w4, w4, w12
	eor	w5, w5, w4
	eor	w6, w6, w5
	eor	w7, w7, w6
	stp	w4, w5, [x2], #8
	stp	w6, w7, [x2], #8
	dup	v1.4s, w7
	movi	v0.16b, #0
	aese	v0.16b, v1.16b
	mov	w12, v0.s[0]
	ror	w12, w12, #8
	eor	w4, w4, #0x80
	eor	w4, w4, w12
	eor	w5, w5, w4
	eor	w6, w6, w5
	eor	w7, w7, w6
	stp	w4, w5, [x2], #8
	stp	w6, w7, [x2], #8
	dup	v1.4s, w7
	movi	v0.16b, #0
	aese	v0.16b, v1.16b
	mov	w12, v0.s[0]
	mov	w13, #27
	ror	w12, w12, #8
	eor	w4, w4, w13
	eor	w4, w4, w12
	eor	w5, w5, w4
	eor	w6, w6, w5
	eor	w7, w7, w6
	stp	w4, w5, [x2], #8
	stp	w6, w7, [x2], #8
	dup	v1.4s, w7
	movi	v0.16b, #0
	aese	v0.16b, v1.16b
	mov	w12, v0.s[0]
	mov	w13, #54
	ror	w12, w12, #8
	eor	w4, w4, w13
	eor	w4, w4, w12
	eor	w5, w5, w4
	eor	w6, w6, w5
	eor	w7, w7, w6
	stp	w4, w5, [x2], #8
	stp	w6, w7, [x2], #8
	cmp	x3, #0
	beq	L_aes_set_key_arm64_crypto_done
	sub	x2, x2, #0xb0
	ldur	q0, [x2]
	ldur	q1, [x2, #160]
	stur	q1, [x2]
	stur	q0, [x2, #160]
	ldur	q0, [x2, #16]
	ldur	q1, [x2, #144]
	aesimc	v0.16b, v0.16b
	aesimc	v1.16b, v1.16b
	stur	q1, [x2, #16]
	stur	q0, [x2, #144]
	ldur	q0, [x2, #32]
	ldur	q1, [x2, #128]
	aesimc	v0.16b, v0.16b
	aesimc	v1.16b, v1.16b
	stur	q1, [x2, #32]
	stur	q0, [x2, #128]
	ldur	q0, [x2, #48]
	ldur	q1, [x2, #112]
	aesimc	v0.16b, v0.16b
	aesimc	v1.16b, v1.16b
	stur	q1, [x2, #48]
	stur	q0, [x2, #112]
	ldur	q0, [x2, #64]
	ldur	q1, [x2, #96]
	aesimc	v0.16b, v0.16b
	aesimc	v1.16b, v1.16b
	stur	q1, [x2, #64]
	stur	q0, [x2, #96]
	ldur	q0, [x2, #80]
	aesimc	v0.16b, v0.16b
	stur	q0, [x2, #80]
L_aes_set_key_arm64_crypto_done:
	ret
#ifndef __APPLE__
	.size	AES_set_key_AARCH64,.-AES_set_key_AARCH64
#endif /* __APPLE__ */
#if defined(HAVE_AESCCM) || defined(HAVE_AESGCM) || defined(WOLFSSL_AES_DIRECT) || defined(WOLFSSL_AES_COUNTER) || defined(HAVE_AES_CBC)
#ifndef __APPLE__
.text
.globl	AES_encrypt_AARCH64
.type	AES_encrypt_AARCH64,@function
.align	2
AES_encrypt_AARCH64:
#else
.section	__TEXT,__text
.globl	_AES_encrypt_AARCH64
.p2align	2
_AES_encrypt_AARCH64:
#endif /* __APPLE__ */
	ld1	{v0.16b}, [x0]
	ld1	{v1.2d, v2.2d, v3.2d, v4.2d}, [x2], #0x40
	aese	v0.16b, v1.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v2.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v3.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v4.16b
	aesmc	v0.16b, v0.16b
	ld1	{v1.2d, v2.2d, v3.2d, v4.2d}, [x2], #0x40
	aese	v0.16b, v1.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v2.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v3.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v4.16b
	aesmc	v0.16b, v0.16b
	subs	w3, w3, #10
	ld1	{v1.2d, v2.2d}, [x2], #32
	aese	v0.16b, v1.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v2.16b
	beq	L_aes_encrypt_arm64_crypto_round_done
	ld1	{v1.2d, v2.2d}, [x2], #32
	subs	w3, w3, #2
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v1.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v2.16b
	beq	L_aes_encrypt_arm64_crypto_round_done
	ld1	{v1.2d, v2.2d}, [x2], #32
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v1.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v2.16b
L_aes_encrypt_arm64_crypto_round_done:
	ld1	{v1.2d}, [x2]
	eor	v0.16b, v0.16b, v1.16b
	st1	{v0.16b}, [x1]
	ret
#ifndef __APPLE__
	.size	AES_encrypt_AARCH64,.-AES_encrypt_AARCH64
#endif /* __APPLE__ */
#endif /* defined(HAVE_AESCCM) || defined(HAVE_AESGCM) || defined(WOLFSSL_AES_DIRECT) || defined(WOLFSSL_AES_COUNTER) || defined(HAVE_AES_CBC) */
#if !defined(WC_AES_BITSLICED) || defined(WOLFSSL_AES_DIRECT) || defined(WOLFSSL_AES_COUNTER)
#ifdef HAVE_AES_DECRYPT
#ifndef __APPLE__
.text
.globl	AES_decrypt_AARCH64
.type	AES_decrypt_AARCH64,@function
.align	2
AES_decrypt_AARCH64:
#else
.section	__TEXT,__text
.globl	_AES_decrypt_AARCH64
.p2align	2
_AES_decrypt_AARCH64:
#endif /* __APPLE__ */
	ld1	{v0.16b}, [x0]
	ld1	{v1.2d, v2.2d, v3.2d, v4.2d}, [x2], #0x40
	aesd	v0.16b, v1.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v2.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v3.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v4.16b
	aesimc	v0.16b, v0.16b
	ld1	{v1.2d, v2.2d, v3.2d, v4.2d}, [x2], #0x40
	aesd	v0.16b, v1.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v2.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v3.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v4.16b
	aesimc	v0.16b, v0.16b
	ld1	{v1.2d, v2.2d}, [x2], #32
	aesd	v0.16b, v1.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v2.16b
	subs	w3, w3, #10
	beq	L_aes_decrypt_arm64_crypto_round_done
	ld1	{v1.2d, v2.2d}, [x2], #32
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v1.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v2.16b
	subs	w3, w3, #2
	beq	L_aes_decrypt_arm64_crypto_round_done
	ld1	{v1.2d, v2.2d}, [x2], #32
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v1.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v2.16b
L_aes_decrypt_arm64_crypto_round_done:
	ld1	{v1.2d}, [x2]
	eor	v0.16b, v0.16b, v1.16b
	st1	{v0.16b}, [x1]
	ret
#ifndef __APPLE__
	.size	AES_decrypt_AARCH64,.-AES_decrypt_AARCH64
#endif /* __APPLE__ */
#endif /* HAVE_AES_DECRYPT */
#endif /* !defined(WC_AES_BITSLICED) || defined(WOLFSSL_AES_DIRECT) || defined(WOLFSSL_AES_COUNTER) */
#ifdef HAVE_AES_ECB
#ifndef __APPLE__
.text
.globl	AES_encrypt_blocks_AARCH64
.type	AES_encrypt_blocks_AARCH64,@function
.align	2
AES_encrypt_blocks_AARCH64:
#else
.section	__TEXT,__text
.globl	_AES_encrypt_blocks_AARCH64
.p2align	2
_AES_encrypt_blocks_AARCH64:
#endif /* __APPLE__ */
	stp	x29, x30, [sp, #-32]!
	add	x29, sp, #0
	ld1	{v16.2d, v17.2d, v18.2d, v19.2d}, [x3], #0x40
	ld1	{v20.2d, v21.2d, v22.2d, v23.2d}, [x3], #0x40
	ld1	{v24.2d, v25.2d, v26.2d}, [x3], #48
	lsr	w2, w2, #4
	cmp	w4, #12
	blt	L_aes_encrypt_blocks_arm64_crypto_start_128
	bgt	L_aes_encrypt_blocks_arm64_crypto_start_256
	# AES_ECB_192
#ifndef NO_AES_192
	ld1	{v27.2d, v28.2d}, [x3], #32
	cmp	w2, #1
	beq	L_aes_encrypt_blocks_arm64_crypto_192_start_1
	cmp	w2, #8
	blt	L_aes_encrypt_blocks_arm64_crypto_192_start_4
L_aes_encrypt_blocks_arm64_crypto_192_start_8:
	ld1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x0], #0x40
	ld1	{v4.16b, v5.16b, v6.16b, v7.16b}, [x0], #0x40
	aese	v0.16b, v16.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v16.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v16.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v16.16b
	aesmc	v3.16b, v3.16b
	aese	v4.16b, v16.16b
	aesmc	v4.16b, v4.16b
	aese	v5.16b, v16.16b
	aesmc	v5.16b, v5.16b
	aese	v6.16b, v16.16b
	aesmc	v6.16b, v6.16b
	aese	v7.16b, v16.16b
	aesmc	v7.16b, v7.16b
	aese	v0.16b, v17.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v17.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v17.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v17.16b
	aesmc	v3.16b, v3.16b
	aese	v4.16b, v17.16b
	aesmc	v4.16b, v4.16b
	aese	v5.16b, v17.16b
	aesmc	v5.16b, v5.16b
	aese	v6.16b, v17.16b
	aesmc	v6.16b, v6.16b
	aese	v7.16b, v17.16b
	aesmc	v7.16b, v7.16b
	aese	v0.16b, v18.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v18.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v18.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v18.16b
	aesmc	v3.16b, v3.16b
	aese	v4.16b, v18.16b
	aesmc	v4.16b, v4.16b
	aese	v5.16b, v18.16b
	aesmc	v5.16b, v5.16b
	aese	v6.16b, v18.16b
	aesmc	v6.16b, v6.16b
	aese	v7.16b, v18.16b
	aesmc	v7.16b, v7.16b
	aese	v0.16b, v19.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v19.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v19.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v19.16b
	aesmc	v3.16b, v3.16b
	aese	v4.16b, v19.16b
	aesmc	v4.16b, v4.16b
	aese	v5.16b, v19.16b
	aesmc	v5.16b, v5.16b
	aese	v6.16b, v19.16b
	aesmc	v6.16b, v6.16b
	aese	v7.16b, v19.16b
	aesmc	v7.16b, v7.16b
	aese	v0.16b, v20.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v20.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v20.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v20.16b
	aesmc	v3.16b, v3.16b
	aese	v4.16b, v20.16b
	aesmc	v4.16b, v4.16b
	aese	v5.16b, v20.16b
	aesmc	v5.16b, v5.16b
	aese	v6.16b, v20.16b
	aesmc	v6.16b, v6.16b
	aese	v7.16b, v20.16b
	aesmc	v7.16b, v7.16b
	aese	v0.16b, v21.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v21.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v21.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v21.16b
	aesmc	v3.16b, v3.16b
	aese	v4.16b, v21.16b
	aesmc	v4.16b, v4.16b
	aese	v5.16b, v21.16b
	aesmc	v5.16b, v5.16b
	aese	v6.16b, v21.16b
	aesmc	v6.16b, v6.16b
	aese	v7.16b, v21.16b
	aesmc	v7.16b, v7.16b
	aese	v0.16b, v22.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v22.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v22.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v22.16b
	aesmc	v3.16b, v3.16b
	aese	v4.16b, v22.16b
	aesmc	v4.16b, v4.16b
	aese	v5.16b, v22.16b
	aesmc	v5.16b, v5.16b
	aese	v6.16b, v22.16b
	aesmc	v6.16b, v6.16b
	aese	v7.16b, v22.16b
	aesmc	v7.16b, v7.16b
	aese	v0.16b, v23.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v23.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v23.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v23.16b
	aesmc	v3.16b, v3.16b
	aese	v4.16b, v23.16b
	aesmc	v4.16b, v4.16b
	aese	v5.16b, v23.16b
	aesmc	v5.16b, v5.16b
	aese	v6.16b, v23.16b
	aesmc	v6.16b, v6.16b
	aese	v7.16b, v23.16b
	aesmc	v7.16b, v7.16b
	aese	v0.16b, v24.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v24.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v24.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v24.16b
	aesmc	v3.16b, v3.16b
	aese	v4.16b, v24.16b
	aesmc	v4.16b, v4.16b
	aese	v5.16b, v24.16b
	aesmc	v5.16b, v5.16b
	aese	v6.16b, v24.16b
	aesmc	v6.16b, v6.16b
	aese	v7.16b, v24.16b
	aesmc	v7.16b, v7.16b
	aese	v0.16b, v25.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v25.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v25.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v25.16b
	aesmc	v3.16b, v3.16b
	aese	v4.16b, v25.16b
	aesmc	v4.16b, v4.16b
	aese	v5.16b, v25.16b
	aesmc	v5.16b, v5.16b
	aese	v6.16b, v25.16b
	aesmc	v6.16b, v6.16b
	aese	v7.16b, v25.16b
	aesmc	v7.16b, v7.16b
	aese	v0.16b, v26.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v26.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v26.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v26.16b
	aesmc	v3.16b, v3.16b
	aese	v4.16b, v26.16b
	aesmc	v4.16b, v4.16b
	aese	v5.16b, v26.16b
	aesmc	v5.16b, v5.16b
	aese	v6.16b, v26.16b
	aesmc	v6.16b, v6.16b
	aese	v7.16b, v26.16b
	aesmc	v7.16b, v7.16b
	aese	v0.16b, v27.16b
	eor	v0.16b, v0.16b, v28.16b
	aese	v1.16b, v27.16b
	eor	v1.16b, v1.16b, v28.16b
	aese	v2.16b, v27.16b
	eor	v2.16b, v2.16b, v28.16b
	aese	v3.16b, v27.16b
	eor	v3.16b, v3.16b, v28.16b
	aese	v4.16b, v27.16b
	eor	v4.16b, v4.16b, v28.16b
	aese	v5.16b, v27.16b
	eor	v5.16b, v5.16b, v28.16b
	aese	v6.16b, v27.16b
	eor	v6.16b, v6.16b, v28.16b
	aese	v7.16b, v27.16b
	eor	v7.16b, v7.16b, v28.16b
	sub	w2, w2, #8
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x1], #0x40
	st1	{v4.16b, v5.16b, v6.16b, v7.16b}, [x1], #0x40
	cmp	w2, #8
	bge	L_aes_encrypt_blocks_arm64_crypto_192_start_8
L_aes_encrypt_blocks_arm64_crypto_192_start_4:
	cmp	w2, #4
	blt	L_aes_encrypt_blocks_arm64_crypto_192_start_2
	ld1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x0], #0x40
	aese	v0.16b, v16.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v16.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v16.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v16.16b
	aesmc	v3.16b, v3.16b
	aese	v0.16b, v17.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v17.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v17.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v17.16b
	aesmc	v3.16b, v3.16b
	aese	v0.16b, v18.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v18.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v18.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v18.16b
	aesmc	v3.16b, v3.16b
	aese	v0.16b, v19.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v19.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v19.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v19.16b
	aesmc	v3.16b, v3.16b
	aese	v0.16b, v20.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v20.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v20.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v20.16b
	aesmc	v3.16b, v3.16b
	aese	v0.16b, v21.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v21.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v21.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v21.16b
	aesmc	v3.16b, v3.16b
	aese	v0.16b, v22.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v22.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v22.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v22.16b
	aesmc	v3.16b, v3.16b
	aese	v0.16b, v23.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v23.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v23.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v23.16b
	aesmc	v3.16b, v3.16b
	aese	v0.16b, v24.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v24.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v24.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v24.16b
	aesmc	v3.16b, v3.16b
	aese	v0.16b, v25.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v25.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v25.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v25.16b
	aesmc	v3.16b, v3.16b
	aese	v0.16b, v26.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v26.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v26.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v26.16b
	aesmc	v3.16b, v3.16b
	aese	v0.16b, v27.16b
	eor	v0.16b, v0.16b, v28.16b
	aese	v1.16b, v27.16b
	eor	v1.16b, v1.16b, v28.16b
	aese	v2.16b, v27.16b
	eor	v2.16b, v2.16b, v28.16b
	aese	v3.16b, v27.16b
	eor	v3.16b, v3.16b, v28.16b
	sub	w2, w2, #4
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x1], #0x40
L_aes_encrypt_blocks_arm64_crypto_192_start_2:
	cmp	w2, #2
	blt	L_aes_encrypt_blocks_arm64_crypto_192_start_1
	ld1	{v0.16b, v1.16b}, [x0], #32
	aese	v0.16b, v16.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v16.16b
	aesmc	v1.16b, v1.16b
	aese	v0.16b, v17.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v17.16b
	aesmc	v1.16b, v1.16b
	aese	v0.16b, v18.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v18.16b
	aesmc	v1.16b, v1.16b
	aese	v0.16b, v19.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v19.16b
	aesmc	v1.16b, v1.16b
	aese	v0.16b, v20.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v20.16b
	aesmc	v1.16b, v1.16b
	aese	v0.16b, v21.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v21.16b
	aesmc	v1.16b, v1.16b
	aese	v0.16b, v22.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v22.16b
	aesmc	v1.16b, v1.16b
	aese	v0.16b, v23.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v23.16b
	aesmc	v1.16b, v1.16b
	aese	v0.16b, v24.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v24.16b
	aesmc	v1.16b, v1.16b
	aese	v0.16b, v25.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v25.16b
	aesmc	v1.16b, v1.16b
	aese	v0.16b, v26.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v26.16b
	aesmc	v1.16b, v1.16b
	aese	v0.16b, v27.16b
	eor	v0.16b, v0.16b, v28.16b
	aese	v1.16b, v27.16b
	eor	v1.16b, v1.16b, v28.16b
	sub	w2, w2, #2
	st1	{v0.16b, v1.16b}, [x1], #32
L_aes_encrypt_blocks_arm64_crypto_192_start_1:
	cbz	w2, L_aes_encrypt_blocks_arm64_crypto_192_done
	ld1	{v0.16b}, [x0], #16
	aese	v0.16b, v16.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v17.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v18.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v19.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v20.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v21.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v22.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v23.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v24.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v25.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v26.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v27.16b
	eor	v0.16b, v0.16b, v28.16b
	st1	{v0.16b}, [x1], #16
L_aes_encrypt_blocks_arm64_crypto_192_done:
#endif /* !NO_AES_192 */
	b	L_aes_encrypt_blocks_arm64_crypto_done
	# AES_ECB_256
L_aes_encrypt_blocks_arm64_crypto_start_256:
#ifndef NO_AES_256
	ld1	{v27.2d, v28.2d, v29.2d, v30.2d}, [x3], #0x40
	cmp	w2, #1
	beq	L_aes_encrypt_blocks_arm64_crypto_256_start_1
	cmp	w2, #8
	blt	L_aes_encrypt_blocks_arm64_crypto_256_start_4
L_aes_encrypt_blocks_arm64_crypto_256_start_8:
	ld1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x0], #0x40
	ld1	{v4.16b, v5.16b, v6.16b, v7.16b}, [x0], #0x40
	aese	v0.16b, v16.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v16.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v16.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v16.16b
	aesmc	v3.16b, v3.16b
	aese	v4.16b, v16.16b
	aesmc	v4.16b, v4.16b
	aese	v5.16b, v16.16b
	aesmc	v5.16b, v5.16b
	aese	v6.16b, v16.16b
	aesmc	v6.16b, v6.16b
	aese	v7.16b, v16.16b
	aesmc	v7.16b, v7.16b
	aese	v0.16b, v17.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v17.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v17.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v17.16b
	aesmc	v3.16b, v3.16b
	aese	v4.16b, v17.16b
	aesmc	v4.16b, v4.16b
	aese	v5.16b, v17.16b
	aesmc	v5.16b, v5.16b
	aese	v6.16b, v17.16b
	aesmc	v6.16b, v6.16b
	aese	v7.16b, v17.16b
	aesmc	v7.16b, v7.16b
	aese	v0.16b, v18.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v18.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v18.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v18.16b
	aesmc	v3.16b, v3.16b
	aese	v4.16b, v18.16b
	aesmc	v4.16b, v4.16b
	aese	v5.16b, v18.16b
	aesmc	v5.16b, v5.16b
	aese	v6.16b, v18.16b
	aesmc	v6.16b, v6.16b
	aese	v7.16b, v18.16b
	aesmc	v7.16b, v7.16b
	aese	v0.16b, v19.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v19.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v19.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v19.16b
	aesmc	v3.16b, v3.16b
	aese	v4.16b, v19.16b
	aesmc	v4.16b, v4.16b
	aese	v5.16b, v19.16b
	aesmc	v5.16b, v5.16b
	aese	v6.16b, v19.16b
	aesmc	v6.16b, v6.16b
	aese	v7.16b, v19.16b
	aesmc	v7.16b, v7.16b
	aese	v0.16b, v20.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v20.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v20.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v20.16b
	aesmc	v3.16b, v3.16b
	aese	v4.16b, v20.16b
	aesmc	v4.16b, v4.16b
	aese	v5.16b, v20.16b
	aesmc	v5.16b, v5.16b
	aese	v6.16b, v20.16b
	aesmc	v6.16b, v6.16b
	aese	v7.16b, v20.16b
	aesmc	v7.16b, v7.16b
	aese	v0.16b, v21.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v21.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v21.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v21.16b
	aesmc	v3.16b, v3.16b
	aese	v4.16b, v21.16b
	aesmc	v4.16b, v4.16b
	aese	v5.16b, v21.16b
	aesmc	v5.16b, v5.16b
	aese	v6.16b, v21.16b
	aesmc	v6.16b, v6.16b
	aese	v7.16b, v21.16b
	aesmc	v7.16b, v7.16b
	aese	v0.16b, v22.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v22.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v22.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v22.16b
	aesmc	v3.16b, v3.16b
	aese	v4.16b, v22.16b
	aesmc	v4.16b, v4.16b
	aese	v5.16b, v22.16b
	aesmc	v5.16b, v5.16b
	aese	v6.16b, v22.16b
	aesmc	v6.16b, v6.16b
	aese	v7.16b, v22.16b
	aesmc	v7.16b, v7.16b
	aese	v0.16b, v23.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v23.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v23.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v23.16b
	aesmc	v3.16b, v3.16b
	aese	v4.16b, v23.16b
	aesmc	v4.16b, v4.16b
	aese	v5.16b, v23.16b
	aesmc	v5.16b, v5.16b
	aese	v6.16b, v23.16b
	aesmc	v6.16b, v6.16b
	aese	v7.16b, v23.16b
	aesmc	v7.16b, v7.16b
	aese	v0.16b, v24.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v24.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v24.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v24.16b
	aesmc	v3.16b, v3.16b
	aese	v4.16b, v24.16b
	aesmc	v4.16b, v4.16b
	aese	v5.16b, v24.16b
	aesmc	v5.16b, v5.16b
	aese	v6.16b, v24.16b
	aesmc	v6.16b, v6.16b
	aese	v7.16b, v24.16b
	aesmc	v7.16b, v7.16b
	aese	v0.16b, v25.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v25.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v25.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v25.16b
	aesmc	v3.16b, v3.16b
	aese	v4.16b, v25.16b
	aesmc	v4.16b, v4.16b
	aese	v5.16b, v25.16b
	aesmc	v5.16b, v5.16b
	aese	v6.16b, v25.16b
	aesmc	v6.16b, v6.16b
	aese	v7.16b, v25.16b
	aesmc	v7.16b, v7.16b
	aese	v0.16b, v26.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v26.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v26.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v26.16b
	aesmc	v3.16b, v3.16b
	aese	v4.16b, v26.16b
	aesmc	v4.16b, v4.16b
	aese	v5.16b, v26.16b
	aesmc	v5.16b, v5.16b
	aese	v6.16b, v26.16b
	aesmc	v6.16b, v6.16b
	aese	v7.16b, v26.16b
	aesmc	v7.16b, v7.16b
	aese	v0.16b, v27.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v27.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v27.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v27.16b
	aesmc	v3.16b, v3.16b
	aese	v4.16b, v27.16b
	aesmc	v4.16b, v4.16b
	aese	v5.16b, v27.16b
	aesmc	v5.16b, v5.16b
	aese	v6.16b, v27.16b
	aesmc	v6.16b, v6.16b
	aese	v7.16b, v27.16b
	aesmc	v7.16b, v7.16b
	aese	v0.16b, v28.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v28.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v28.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v28.16b
	aesmc	v3.16b, v3.16b
	aese	v4.16b, v28.16b
	aesmc	v4.16b, v4.16b
	aese	v5.16b, v28.16b
	aesmc	v5.16b, v5.16b
	aese	v6.16b, v28.16b
	aesmc	v6.16b, v6.16b
	aese	v7.16b, v28.16b
	aesmc	v7.16b, v7.16b
	aese	v0.16b, v29.16b
	eor	v0.16b, v0.16b, v30.16b
	aese	v1.16b, v29.16b
	eor	v1.16b, v1.16b, v30.16b
	aese	v2.16b, v29.16b
	eor	v2.16b, v2.16b, v30.16b
	aese	v3.16b, v29.16b
	eor	v3.16b, v3.16b, v30.16b
	aese	v4.16b, v29.16b
	eor	v4.16b, v4.16b, v30.16b
	aese	v5.16b, v29.16b
	eor	v5.16b, v5.16b, v30.16b
	aese	v6.16b, v29.16b
	eor	v6.16b, v6.16b, v30.16b
	aese	v7.16b, v29.16b
	eor	v7.16b, v7.16b, v30.16b
	sub	w2, w2, #8
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x1], #0x40
	st1	{v4.16b, v5.16b, v6.16b, v7.16b}, [x1], #0x40
	cmp	w2, #8
	bge	L_aes_encrypt_blocks_arm64_crypto_256_start_8
L_aes_encrypt_blocks_arm64_crypto_256_start_4:
	cmp	w2, #4
	blt	L_aes_encrypt_blocks_arm64_crypto_256_start_2
	ld1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x0], #0x40
	aese	v0.16b, v16.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v16.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v16.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v16.16b
	aesmc	v3.16b, v3.16b
	aese	v0.16b, v17.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v17.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v17.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v17.16b
	aesmc	v3.16b, v3.16b
	aese	v0.16b, v18.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v18.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v18.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v18.16b
	aesmc	v3.16b, v3.16b
	aese	v0.16b, v19.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v19.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v19.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v19.16b
	aesmc	v3.16b, v3.16b
	aese	v0.16b, v20.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v20.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v20.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v20.16b
	aesmc	v3.16b, v3.16b
	aese	v0.16b, v21.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v21.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v21.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v21.16b
	aesmc	v3.16b, v3.16b
	aese	v0.16b, v22.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v22.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v22.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v22.16b
	aesmc	v3.16b, v3.16b
	aese	v0.16b, v23.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v23.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v23.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v23.16b
	aesmc	v3.16b, v3.16b
	aese	v0.16b, v24.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v24.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v24.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v24.16b
	aesmc	v3.16b, v3.16b
	aese	v0.16b, v25.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v25.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v25.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v25.16b
	aesmc	v3.16b, v3.16b
	aese	v0.16b, v26.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v26.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v26.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v26.16b
	aesmc	v3.16b, v3.16b
	aese	v0.16b, v27.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v27.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v27.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v27.16b
	aesmc	v3.16b, v3.16b
	aese	v0.16b, v28.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v28.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v28.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v28.16b
	aesmc	v3.16b, v3.16b
	aese	v0.16b, v29.16b
	eor	v0.16b, v0.16b, v30.16b
	aese	v1.16b, v29.16b
	eor	v1.16b, v1.16b, v30.16b
	aese	v2.16b, v29.16b
	eor	v2.16b, v2.16b, v30.16b
	aese	v3.16b, v29.16b
	eor	v3.16b, v3.16b, v30.16b
	sub	w2, w2, #4
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x1], #0x40
L_aes_encrypt_blocks_arm64_crypto_256_start_2:
	cmp	w2, #2
	blt	L_aes_encrypt_blocks_arm64_crypto_256_start_1
	ld1	{v0.16b, v1.16b}, [x0], #32
	aese	v0.16b, v16.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v16.16b
	aesmc	v1.16b, v1.16b
	aese	v0.16b, v17.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v17.16b
	aesmc	v1.16b, v1.16b
	aese	v0.16b, v18.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v18.16b
	aesmc	v1.16b, v1.16b
	aese	v0.16b, v19.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v19.16b
	aesmc	v1.16b, v1.16b
	aese	v0.16b, v20.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v20.16b
	aesmc	v1.16b, v1.16b
	aese	v0.16b, v21.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v21.16b
	aesmc	v1.16b, v1.16b
	aese	v0.16b, v22.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v22.16b
	aesmc	v1.16b, v1.16b
	aese	v0.16b, v23.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v23.16b
	aesmc	v1.16b, v1.16b
	aese	v0.16b, v24.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v24.16b
	aesmc	v1.16b, v1.16b
	aese	v0.16b, v25.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v25.16b
	aesmc	v1.16b, v1.16b
	aese	v0.16b, v26.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v26.16b
	aesmc	v1.16b, v1.16b
	aese	v0.16b, v27.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v27.16b
	aesmc	v1.16b, v1.16b
	aese	v0.16b, v28.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v28.16b
	aesmc	v1.16b, v1.16b
	aese	v0.16b, v29.16b
	eor	v0.16b, v0.16b, v30.16b
	aese	v1.16b, v29.16b
	eor	v1.16b, v1.16b, v30.16b
	sub	w2, w2, #2
	st1	{v0.16b, v1.16b}, [x1], #32
L_aes_encrypt_blocks_arm64_crypto_256_start_1:
	cbz	w2, L_aes_encrypt_blocks_arm64_crypto_256_done
	ld1	{v0.16b}, [x0], #16
	aese	v0.16b, v16.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v17.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v18.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v19.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v20.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v21.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v22.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v23.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v24.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v25.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v26.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v27.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v28.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v29.16b
	eor	v0.16b, v0.16b, v30.16b
	st1	{v0.16b}, [x1], #16
L_aes_encrypt_blocks_arm64_crypto_256_done:
#endif /* !NO_AES_256 */
	b	L_aes_encrypt_blocks_arm64_crypto_done
	# AES_ECB_128
L_aes_encrypt_blocks_arm64_crypto_start_128:
#ifndef NO_AES_128
	cmp	w2, #1
	beq	L_aes_encrypt_blocks_arm64_crypto_128_start_1
	cmp	w2, #8
	blt	L_aes_encrypt_blocks_arm64_crypto_128_start_4
L_aes_encrypt_blocks_arm64_crypto_128_start_8:
	ld1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x0], #0x40
	ld1	{v4.16b, v5.16b, v6.16b, v7.16b}, [x0], #0x40
	aese	v0.16b, v16.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v16.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v16.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v16.16b
	aesmc	v3.16b, v3.16b
	aese	v4.16b, v16.16b
	aesmc	v4.16b, v4.16b
	aese	v5.16b, v16.16b
	aesmc	v5.16b, v5.16b
	aese	v6.16b, v16.16b
	aesmc	v6.16b, v6.16b
	aese	v7.16b, v16.16b
	aesmc	v7.16b, v7.16b
	aese	v0.16b, v17.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v17.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v17.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v17.16b
	aesmc	v3.16b, v3.16b
	aese	v4.16b, v17.16b
	aesmc	v4.16b, v4.16b
	aese	v5.16b, v17.16b
	aesmc	v5.16b, v5.16b
	aese	v6.16b, v17.16b
	aesmc	v6.16b, v6.16b
	aese	v7.16b, v17.16b
	aesmc	v7.16b, v7.16b
	aese	v0.16b, v18.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v18.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v18.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v18.16b
	aesmc	v3.16b, v3.16b
	aese	v4.16b, v18.16b
	aesmc	v4.16b, v4.16b
	aese	v5.16b, v18.16b
	aesmc	v5.16b, v5.16b
	aese	v6.16b, v18.16b
	aesmc	v6.16b, v6.16b
	aese	v7.16b, v18.16b
	aesmc	v7.16b, v7.16b
	aese	v0.16b, v19.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v19.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v19.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v19.16b
	aesmc	v3.16b, v3.16b
	aese	v4.16b, v19.16b
	aesmc	v4.16b, v4.16b
	aese	v5.16b, v19.16b
	aesmc	v5.16b, v5.16b
	aese	v6.16b, v19.16b
	aesmc	v6.16b, v6.16b
	aese	v7.16b, v19.16b
	aesmc	v7.16b, v7.16b
	aese	v0.16b, v20.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v20.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v20.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v20.16b
	aesmc	v3.16b, v3.16b
	aese	v4.16b, v20.16b
	aesmc	v4.16b, v4.16b
	aese	v5.16b, v20.16b
	aesmc	v5.16b, v5.16b
	aese	v6.16b, v20.16b
	aesmc	v6.16b, v6.16b
	aese	v7.16b, v20.16b
	aesmc	v7.16b, v7.16b
	aese	v0.16b, v21.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v21.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v21.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v21.16b
	aesmc	v3.16b, v3.16b
	aese	v4.16b, v21.16b
	aesmc	v4.16b, v4.16b
	aese	v5.16b, v21.16b
	aesmc	v5.16b, v5.16b
	aese	v6.16b, v21.16b
	aesmc	v6.16b, v6.16b
	aese	v7.16b, v21.16b
	aesmc	v7.16b, v7.16b
	aese	v0.16b, v22.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v22.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v22.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v22.16b
	aesmc	v3.16b, v3.16b
	aese	v4.16b, v22.16b
	aesmc	v4.16b, v4.16b
	aese	v5.16b, v22.16b
	aesmc	v5.16b, v5.16b
	aese	v6.16b, v22.16b
	aesmc	v6.16b, v6.16b
	aese	v7.16b, v22.16b
	aesmc	v7.16b, v7.16b
	aese	v0.16b, v23.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v23.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v23.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v23.16b
	aesmc	v3.16b, v3.16b
	aese	v4.16b, v23.16b
	aesmc	v4.16b, v4.16b
	aese	v5.16b, v23.16b
	aesmc	v5.16b, v5.16b
	aese	v6.16b, v23.16b
	aesmc	v6.16b, v6.16b
	aese	v7.16b, v23.16b
	aesmc	v7.16b, v7.16b
	aese	v0.16b, v24.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v24.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v24.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v24.16b
	aesmc	v3.16b, v3.16b
	aese	v4.16b, v24.16b
	aesmc	v4.16b, v4.16b
	aese	v5.16b, v24.16b
	aesmc	v5.16b, v5.16b
	aese	v6.16b, v24.16b
	aesmc	v6.16b, v6.16b
	aese	v7.16b, v24.16b
	aesmc	v7.16b, v7.16b
	aese	v0.16b, v25.16b
	eor	v0.16b, v0.16b, v26.16b
	aese	v1.16b, v25.16b
	eor	v1.16b, v1.16b, v26.16b
	aese	v2.16b, v25.16b
	eor	v2.16b, v2.16b, v26.16b
	aese	v3.16b, v25.16b
	eor	v3.16b, v3.16b, v26.16b
	aese	v4.16b, v25.16b
	eor	v4.16b, v4.16b, v26.16b
	aese	v5.16b, v25.16b
	eor	v5.16b, v5.16b, v26.16b
	aese	v6.16b, v25.16b
	eor	v6.16b, v6.16b, v26.16b
	aese	v7.16b, v25.16b
	eor	v7.16b, v7.16b, v26.16b
	sub	w2, w2, #8
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x1], #0x40
	st1	{v4.16b, v5.16b, v6.16b, v7.16b}, [x1], #0x40
	cmp	w2, #8
	bge	L_aes_encrypt_blocks_arm64_crypto_128_start_8
L_aes_encrypt_blocks_arm64_crypto_128_start_4:
	cmp	w2, #4
	blt	L_aes_encrypt_blocks_arm64_crypto_128_start_2
	ld1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x0], #0x40
	aese	v0.16b, v16.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v16.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v16.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v16.16b
	aesmc	v3.16b, v3.16b
	aese	v0.16b, v17.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v17.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v17.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v17.16b
	aesmc	v3.16b, v3.16b
	aese	v0.16b, v18.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v18.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v18.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v18.16b
	aesmc	v3.16b, v3.16b
	aese	v0.16b, v19.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v19.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v19.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v19.16b
	aesmc	v3.16b, v3.16b
	aese	v0.16b, v20.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v20.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v20.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v20.16b
	aesmc	v3.16b, v3.16b
	aese	v0.16b, v21.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v21.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v21.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v21.16b
	aesmc	v3.16b, v3.16b
	aese	v0.16b, v22.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v22.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v22.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v22.16b
	aesmc	v3.16b, v3.16b
	aese	v0.16b, v23.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v23.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v23.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v23.16b
	aesmc	v3.16b, v3.16b
	aese	v0.16b, v24.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v24.16b
	aesmc	v1.16b, v1.16b
	aese	v2.16b, v24.16b
	aesmc	v2.16b, v2.16b
	aese	v3.16b, v24.16b
	aesmc	v3.16b, v3.16b
	aese	v0.16b, v25.16b
	eor	v0.16b, v0.16b, v26.16b
	aese	v1.16b, v25.16b
	eor	v1.16b, v1.16b, v26.16b
	aese	v2.16b, v25.16b
	eor	v2.16b, v2.16b, v26.16b
	aese	v3.16b, v25.16b
	eor	v3.16b, v3.16b, v26.16b
	sub	w2, w2, #4
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x1], #0x40
L_aes_encrypt_blocks_arm64_crypto_128_start_2:
	cmp	w2, #2
	blt	L_aes_encrypt_blocks_arm64_crypto_128_start_1
	ld1	{v0.16b, v1.16b}, [x0], #32
	aese	v0.16b, v16.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v16.16b
	aesmc	v1.16b, v1.16b
	aese	v0.16b, v17.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v17.16b
	aesmc	v1.16b, v1.16b
	aese	v0.16b, v18.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v18.16b
	aesmc	v1.16b, v1.16b
	aese	v0.16b, v19.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v19.16b
	aesmc	v1.16b, v1.16b
	aese	v0.16b, v20.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v20.16b
	aesmc	v1.16b, v1.16b
	aese	v0.16b, v21.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v21.16b
	aesmc	v1.16b, v1.16b
	aese	v0.16b, v22.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v22.16b
	aesmc	v1.16b, v1.16b
	aese	v0.16b, v23.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v23.16b
	aesmc	v1.16b, v1.16b
	aese	v0.16b, v24.16b
	aesmc	v0.16b, v0.16b
	aese	v1.16b, v24.16b
	aesmc	v1.16b, v1.16b
	aese	v0.16b, v25.16b
	eor	v0.16b, v0.16b, v26.16b
	aese	v1.16b, v25.16b
	eor	v1.16b, v1.16b, v26.16b
	sub	w2, w2, #2
	st1	{v0.16b, v1.16b}, [x1], #32
L_aes_encrypt_blocks_arm64_crypto_128_start_1:
	cbz	w2, L_aes_encrypt_blocks_arm64_crypto_128_done
	ld1	{v0.16b}, [x0], #16
	aese	v0.16b, v16.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v17.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v18.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v19.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v20.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v21.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v22.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v23.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v24.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v25.16b
	eor	v0.16b, v0.16b, v26.16b
	st1	{v0.16b}, [x1], #16
L_aes_encrypt_blocks_arm64_crypto_128_done:
#endif /* !NO_AES_128 */
L_aes_encrypt_blocks_arm64_crypto_done:
	ldp	x29, x30, [sp], #32
	ret
#ifndef __APPLE__
	.size	AES_encrypt_blocks_AARCH64,.-AES_encrypt_blocks_AARCH64
#endif /* __APPLE__ */
#ifdef HAVE_AES_DECRYPT
#ifndef __APPLE__
.text
.globl	AES_decrypt_blocks_AARCH64
.type	AES_decrypt_blocks_AARCH64,@function
.align	2
AES_decrypt_blocks_AARCH64:
#else
.section	__TEXT,__text
.globl	_AES_decrypt_blocks_AARCH64
.p2align	2
_AES_decrypt_blocks_AARCH64:
#endif /* __APPLE__ */
	stp	x29, x30, [sp, #-32]!
	add	x29, sp, #0
	ld1	{v16.2d, v17.2d, v18.2d, v19.2d}, [x3], #0x40
	ld1	{v20.2d, v21.2d, v22.2d, v23.2d}, [x3], #0x40
	ld1	{v24.2d, v25.2d, v26.2d}, [x3], #48
	lsr	w2, w2, #4
	cmp	w4, #12
	blt	L_aes_decrypt_blocks_arm64_crypto_start_128
	bgt	L_aes_decrypt_blocks_arm64_crypto_start_256
	# AES_ECB_192
#ifndef NO_AES_192
	ld1	{v27.2d, v28.2d}, [x3], #32
	cmp	w2, #1
	beq	L_aes_decrypt_blocks_arm64_crypto_192_start_1
	cmp	w2, #8
	blt	L_aes_decrypt_blocks_arm64_crypto_192_start_4
L_aes_decrypt_blocks_arm64_crypto_192_start_8:
	ld1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x0], #0x40
	ld1	{v4.16b, v5.16b, v6.16b, v7.16b}, [x0], #0x40
	aesd	v0.16b, v16.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v16.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v16.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v16.16b
	aesimc	v3.16b, v3.16b
	aesd	v4.16b, v16.16b
	aesimc	v4.16b, v4.16b
	aesd	v5.16b, v16.16b
	aesimc	v5.16b, v5.16b
	aesd	v6.16b, v16.16b
	aesimc	v6.16b, v6.16b
	aesd	v7.16b, v16.16b
	aesimc	v7.16b, v7.16b
	aesd	v0.16b, v17.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v17.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v17.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v17.16b
	aesimc	v3.16b, v3.16b
	aesd	v4.16b, v17.16b
	aesimc	v4.16b, v4.16b
	aesd	v5.16b, v17.16b
	aesimc	v5.16b, v5.16b
	aesd	v6.16b, v17.16b
	aesimc	v6.16b, v6.16b
	aesd	v7.16b, v17.16b
	aesimc	v7.16b, v7.16b
	aesd	v0.16b, v18.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v18.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v18.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v18.16b
	aesimc	v3.16b, v3.16b
	aesd	v4.16b, v18.16b
	aesimc	v4.16b, v4.16b
	aesd	v5.16b, v18.16b
	aesimc	v5.16b, v5.16b
	aesd	v6.16b, v18.16b
	aesimc	v6.16b, v6.16b
	aesd	v7.16b, v18.16b
	aesimc	v7.16b, v7.16b
	aesd	v0.16b, v19.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v19.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v19.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v19.16b
	aesimc	v3.16b, v3.16b
	aesd	v4.16b, v19.16b
	aesimc	v4.16b, v4.16b
	aesd	v5.16b, v19.16b
	aesimc	v5.16b, v5.16b
	aesd	v6.16b, v19.16b
	aesimc	v6.16b, v6.16b
	aesd	v7.16b, v19.16b
	aesimc	v7.16b, v7.16b
	aesd	v0.16b, v20.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v20.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v20.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v20.16b
	aesimc	v3.16b, v3.16b
	aesd	v4.16b, v20.16b
	aesimc	v4.16b, v4.16b
	aesd	v5.16b, v20.16b
	aesimc	v5.16b, v5.16b
	aesd	v6.16b, v20.16b
	aesimc	v6.16b, v6.16b
	aesd	v7.16b, v20.16b
	aesimc	v7.16b, v7.16b
	aesd	v0.16b, v21.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v21.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v21.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v21.16b
	aesimc	v3.16b, v3.16b
	aesd	v4.16b, v21.16b
	aesimc	v4.16b, v4.16b
	aesd	v5.16b, v21.16b
	aesimc	v5.16b, v5.16b
	aesd	v6.16b, v21.16b
	aesimc	v6.16b, v6.16b
	aesd	v7.16b, v21.16b
	aesimc	v7.16b, v7.16b
	aesd	v0.16b, v22.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v22.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v22.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v22.16b
	aesimc	v3.16b, v3.16b
	aesd	v4.16b, v22.16b
	aesimc	v4.16b, v4.16b
	aesd	v5.16b, v22.16b
	aesimc	v5.16b, v5.16b
	aesd	v6.16b, v22.16b
	aesimc	v6.16b, v6.16b
	aesd	v7.16b, v22.16b
	aesimc	v7.16b, v7.16b
	aesd	v0.16b, v23.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v23.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v23.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v23.16b
	aesimc	v3.16b, v3.16b
	aesd	v4.16b, v23.16b
	aesimc	v4.16b, v4.16b
	aesd	v5.16b, v23.16b
	aesimc	v5.16b, v5.16b
	aesd	v6.16b, v23.16b
	aesimc	v6.16b, v6.16b
	aesd	v7.16b, v23.16b
	aesimc	v7.16b, v7.16b
	aesd	v0.16b, v24.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v24.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v24.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v24.16b
	aesimc	v3.16b, v3.16b
	aesd	v4.16b, v24.16b
	aesimc	v4.16b, v4.16b
	aesd	v5.16b, v24.16b
	aesimc	v5.16b, v5.16b
	aesd	v6.16b, v24.16b
	aesimc	v6.16b, v6.16b
	aesd	v7.16b, v24.16b
	aesimc	v7.16b, v7.16b
	aesd	v0.16b, v25.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v25.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v25.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v25.16b
	aesimc	v3.16b, v3.16b
	aesd	v4.16b, v25.16b
	aesimc	v4.16b, v4.16b
	aesd	v5.16b, v25.16b
	aesimc	v5.16b, v5.16b
	aesd	v6.16b, v25.16b
	aesimc	v6.16b, v6.16b
	aesd	v7.16b, v25.16b
	aesimc	v7.16b, v7.16b
	aesd	v0.16b, v26.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v26.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v26.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v26.16b
	aesimc	v3.16b, v3.16b
	aesd	v4.16b, v26.16b
	aesimc	v4.16b, v4.16b
	aesd	v5.16b, v26.16b
	aesimc	v5.16b, v5.16b
	aesd	v6.16b, v26.16b
	aesimc	v6.16b, v6.16b
	aesd	v7.16b, v26.16b
	aesimc	v7.16b, v7.16b
	aesd	v0.16b, v27.16b
	eor	v0.16b, v0.16b, v28.16b
	aesd	v1.16b, v27.16b
	eor	v1.16b, v1.16b, v28.16b
	aesd	v2.16b, v27.16b
	eor	v2.16b, v2.16b, v28.16b
	aesd	v3.16b, v27.16b
	eor	v3.16b, v3.16b, v28.16b
	aesd	v4.16b, v27.16b
	eor	v4.16b, v4.16b, v28.16b
	aesd	v5.16b, v27.16b
	eor	v5.16b, v5.16b, v28.16b
	aesd	v6.16b, v27.16b
	eor	v6.16b, v6.16b, v28.16b
	aesd	v7.16b, v27.16b
	eor	v7.16b, v7.16b, v28.16b
	sub	w2, w2, #8
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x1], #0x40
	st1	{v4.16b, v5.16b, v6.16b, v7.16b}, [x1], #0x40
	cmp	w2, #8
	bge	L_aes_decrypt_blocks_arm64_crypto_192_start_8
L_aes_decrypt_blocks_arm64_crypto_192_start_4:
	cmp	w2, #4
	blt	L_aes_decrypt_blocks_arm64_crypto_192_start_2
	ld1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x0], #0x40
	aesd	v0.16b, v16.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v16.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v16.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v16.16b
	aesimc	v3.16b, v3.16b
	aesd	v0.16b, v17.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v17.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v17.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v17.16b
	aesimc	v3.16b, v3.16b
	aesd	v0.16b, v18.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v18.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v18.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v18.16b
	aesimc	v3.16b, v3.16b
	aesd	v0.16b, v19.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v19.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v19.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v19.16b
	aesimc	v3.16b, v3.16b
	aesd	v0.16b, v20.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v20.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v20.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v20.16b
	aesimc	v3.16b, v3.16b
	aesd	v0.16b, v21.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v21.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v21.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v21.16b
	aesimc	v3.16b, v3.16b
	aesd	v0.16b, v22.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v22.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v22.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v22.16b
	aesimc	v3.16b, v3.16b
	aesd	v0.16b, v23.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v23.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v23.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v23.16b
	aesimc	v3.16b, v3.16b
	aesd	v0.16b, v24.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v24.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v24.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v24.16b
	aesimc	v3.16b, v3.16b
	aesd	v0.16b, v25.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v25.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v25.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v25.16b
	aesimc	v3.16b, v3.16b
	aesd	v0.16b, v26.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v26.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v26.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v26.16b
	aesimc	v3.16b, v3.16b
	aesd	v0.16b, v27.16b
	eor	v0.16b, v0.16b, v28.16b
	aesd	v1.16b, v27.16b
	eor	v1.16b, v1.16b, v28.16b
	aesd	v2.16b, v27.16b
	eor	v2.16b, v2.16b, v28.16b
	aesd	v3.16b, v27.16b
	eor	v3.16b, v3.16b, v28.16b
	sub	w2, w2, #4
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x1], #0x40
L_aes_decrypt_blocks_arm64_crypto_192_start_2:
	cmp	w2, #2
	blt	L_aes_decrypt_blocks_arm64_crypto_192_start_1
	ld1	{v0.16b, v1.16b}, [x0], #32
	aesd	v0.16b, v16.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v16.16b
	aesimc	v1.16b, v1.16b
	aesd	v0.16b, v17.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v17.16b
	aesimc	v1.16b, v1.16b
	aesd	v0.16b, v18.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v18.16b
	aesimc	v1.16b, v1.16b
	aesd	v0.16b, v19.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v19.16b
	aesimc	v1.16b, v1.16b
	aesd	v0.16b, v20.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v20.16b
	aesimc	v1.16b, v1.16b
	aesd	v0.16b, v21.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v21.16b
	aesimc	v1.16b, v1.16b
	aesd	v0.16b, v22.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v22.16b
	aesimc	v1.16b, v1.16b
	aesd	v0.16b, v23.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v23.16b
	aesimc	v1.16b, v1.16b
	aesd	v0.16b, v24.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v24.16b
	aesimc	v1.16b, v1.16b
	aesd	v0.16b, v25.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v25.16b
	aesimc	v1.16b, v1.16b
	aesd	v0.16b, v26.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v26.16b
	aesimc	v1.16b, v1.16b
	aesd	v0.16b, v27.16b
	eor	v0.16b, v0.16b, v28.16b
	aesd	v1.16b, v27.16b
	eor	v1.16b, v1.16b, v28.16b
	sub	w2, w2, #2
	st1	{v0.16b, v1.16b}, [x1], #32
L_aes_decrypt_blocks_arm64_crypto_192_start_1:
	cbz	w2, L_aes_decrypt_blocks_arm64_crypto_192_done
	ld1	{v0.16b}, [x0], #16
	aesd	v0.16b, v16.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v17.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v18.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v19.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v20.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v21.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v22.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v23.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v24.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v25.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v26.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v27.16b
	eor	v0.16b, v0.16b, v28.16b
	st1	{v0.16b}, [x1], #16
L_aes_decrypt_blocks_arm64_crypto_192_done:
#endif /* !NO_AES_192 */
	b	L_aes_decrypt_blocks_arm64_crypto_done
	# AES_ECB_256
L_aes_decrypt_blocks_arm64_crypto_start_256:
#ifndef NO_AES_256
	ld1	{v27.2d, v28.2d, v29.2d, v30.2d}, [x3], #0x40
	cmp	w2, #1
	beq	L_aes_decrypt_blocks_arm64_crypto_256_start_1
	cmp	w2, #8
	blt	L_aes_decrypt_blocks_arm64_crypto_256_start_4
L_aes_decrypt_blocks_arm64_crypto_256_start_8:
	ld1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x0], #0x40
	ld1	{v4.16b, v5.16b, v6.16b, v7.16b}, [x0], #0x40
	aesd	v0.16b, v16.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v16.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v16.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v16.16b
	aesimc	v3.16b, v3.16b
	aesd	v4.16b, v16.16b
	aesimc	v4.16b, v4.16b
	aesd	v5.16b, v16.16b
	aesimc	v5.16b, v5.16b
	aesd	v6.16b, v16.16b
	aesimc	v6.16b, v6.16b
	aesd	v7.16b, v16.16b
	aesimc	v7.16b, v7.16b
	aesd	v0.16b, v17.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v17.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v17.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v17.16b
	aesimc	v3.16b, v3.16b
	aesd	v4.16b, v17.16b
	aesimc	v4.16b, v4.16b
	aesd	v5.16b, v17.16b
	aesimc	v5.16b, v5.16b
	aesd	v6.16b, v17.16b
	aesimc	v6.16b, v6.16b
	aesd	v7.16b, v17.16b
	aesimc	v7.16b, v7.16b
	aesd	v0.16b, v18.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v18.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v18.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v18.16b
	aesimc	v3.16b, v3.16b
	aesd	v4.16b, v18.16b
	aesimc	v4.16b, v4.16b
	aesd	v5.16b, v18.16b
	aesimc	v5.16b, v5.16b
	aesd	v6.16b, v18.16b
	aesimc	v6.16b, v6.16b
	aesd	v7.16b, v18.16b
	aesimc	v7.16b, v7.16b
	aesd	v0.16b, v19.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v19.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v19.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v19.16b
	aesimc	v3.16b, v3.16b
	aesd	v4.16b, v19.16b
	aesimc	v4.16b, v4.16b
	aesd	v5.16b, v19.16b
	aesimc	v5.16b, v5.16b
	aesd	v6.16b, v19.16b
	aesimc	v6.16b, v6.16b
	aesd	v7.16b, v19.16b
	aesimc	v7.16b, v7.16b
	aesd	v0.16b, v20.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v20.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v20.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v20.16b
	aesimc	v3.16b, v3.16b
	aesd	v4.16b, v20.16b
	aesimc	v4.16b, v4.16b
	aesd	v5.16b, v20.16b
	aesimc	v5.16b, v5.16b
	aesd	v6.16b, v20.16b
	aesimc	v6.16b, v6.16b
	aesd	v7.16b, v20.16b
	aesimc	v7.16b, v7.16b
	aesd	v0.16b, v21.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v21.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v21.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v21.16b
	aesimc	v3.16b, v3.16b
	aesd	v4.16b, v21.16b
	aesimc	v4.16b, v4.16b
	aesd	v5.16b, v21.16b
	aesimc	v5.16b, v5.16b
	aesd	v6.16b, v21.16b
	aesimc	v6.16b, v6.16b
	aesd	v7.16b, v21.16b
	aesimc	v7.16b, v7.16b
	aesd	v0.16b, v22.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v22.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v22.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v22.16b
	aesimc	v3.16b, v3.16b
	aesd	v4.16b, v22.16b
	aesimc	v4.16b, v4.16b
	aesd	v5.16b, v22.16b
	aesimc	v5.16b, v5.16b
	aesd	v6.16b, v22.16b
	aesimc	v6.16b, v6.16b
	aesd	v7.16b, v22.16b
	aesimc	v7.16b, v7.16b
	aesd	v0.16b, v23.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v23.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v23.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v23.16b
	aesimc	v3.16b, v3.16b
	aesd	v4.16b, v23.16b
	aesimc	v4.16b, v4.16b
	aesd	v5.16b, v23.16b
	aesimc	v5.16b, v5.16b
	aesd	v6.16b, v23.16b
	aesimc	v6.16b, v6.16b
	aesd	v7.16b, v23.16b
	aesimc	v7.16b, v7.16b
	aesd	v0.16b, v24.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v24.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v24.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v24.16b
	aesimc	v3.16b, v3.16b
	aesd	v4.16b, v24.16b
	aesimc	v4.16b, v4.16b
	aesd	v5.16b, v24.16b
	aesimc	v5.16b, v5.16b
	aesd	v6.16b, v24.16b
	aesimc	v6.16b, v6.16b
	aesd	v7.16b, v24.16b
	aesimc	v7.16b, v7.16b
	aesd	v0.16b, v25.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v25.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v25.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v25.16b
	aesimc	v3.16b, v3.16b
	aesd	v4.16b, v25.16b
	aesimc	v4.16b, v4.16b
	aesd	v5.16b, v25.16b
	aesimc	v5.16b, v5.16b
	aesd	v6.16b, v25.16b
	aesimc	v6.16b, v6.16b
	aesd	v7.16b, v25.16b
	aesimc	v7.16b, v7.16b
	aesd	v0.16b, v26.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v26.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v26.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v26.16b
	aesimc	v3.16b, v3.16b
	aesd	v4.16b, v26.16b
	aesimc	v4.16b, v4.16b
	aesd	v5.16b, v26.16b
	aesimc	v5.16b, v5.16b
	aesd	v6.16b, v26.16b
	aesimc	v6.16b, v6.16b
	aesd	v7.16b, v26.16b
	aesimc	v7.16b, v7.16b
	aesd	v0.16b, v27.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v27.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v27.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v27.16b
	aesimc	v3.16b, v3.16b
	aesd	v4.16b, v27.16b
	aesimc	v4.16b, v4.16b
	aesd	v5.16b, v27.16b
	aesimc	v5.16b, v5.16b
	aesd	v6.16b, v27.16b
	aesimc	v6.16b, v6.16b
	aesd	v7.16b, v27.16b
	aesimc	v7.16b, v7.16b
	aesd	v0.16b, v28.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v28.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v28.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v28.16b
	aesimc	v3.16b, v3.16b
	aesd	v4.16b, v28.16b
	aesimc	v4.16b, v4.16b
	aesd	v5.16b, v28.16b
	aesimc	v5.16b, v5.16b
	aesd	v6.16b, v28.16b
	aesimc	v6.16b, v6.16b
	aesd	v7.16b, v28.16b
	aesimc	v7.16b, v7.16b
	aesd	v0.16b, v29.16b
	eor	v0.16b, v0.16b, v30.16b
	aesd	v1.16b, v29.16b
	eor	v1.16b, v1.16b, v30.16b
	aesd	v2.16b, v29.16b
	eor	v2.16b, v2.16b, v30.16b
	aesd	v3.16b, v29.16b
	eor	v3.16b, v3.16b, v30.16b
	aesd	v4.16b, v29.16b
	eor	v4.16b, v4.16b, v30.16b
	aesd	v5.16b, v29.16b
	eor	v5.16b, v5.16b, v30.16b
	aesd	v6.16b, v29.16b
	eor	v6.16b, v6.16b, v30.16b
	aesd	v7.16b, v29.16b
	eor	v7.16b, v7.16b, v30.16b
	sub	w2, w2, #8
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x1], #0x40
	st1	{v4.16b, v5.16b, v6.16b, v7.16b}, [x1], #0x40
	cmp	w2, #8
	bge	L_aes_decrypt_blocks_arm64_crypto_256_start_8
L_aes_decrypt_blocks_arm64_crypto_256_start_4:
	cmp	w2, #4
	blt	L_aes_decrypt_blocks_arm64_crypto_256_start_2
	ld1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x0], #0x40
	aesd	v0.16b, v16.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v16.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v16.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v16.16b
	aesimc	v3.16b, v3.16b
	aesd	v0.16b, v17.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v17.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v17.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v17.16b
	aesimc	v3.16b, v3.16b
	aesd	v0.16b, v18.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v18.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v18.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v18.16b
	aesimc	v3.16b, v3.16b
	aesd	v0.16b, v19.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v19.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v19.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v19.16b
	aesimc	v3.16b, v3.16b
	aesd	v0.16b, v20.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v20.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v20.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v20.16b
	aesimc	v3.16b, v3.16b
	aesd	v0.16b, v21.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v21.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v21.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v21.16b
	aesimc	v3.16b, v3.16b
	aesd	v0.16b, v22.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v22.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v22.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v22.16b
	aesimc	v3.16b, v3.16b
	aesd	v0.16b, v23.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v23.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v23.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v23.16b
	aesimc	v3.16b, v3.16b
	aesd	v0.16b, v24.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v24.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v24.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v24.16b
	aesimc	v3.16b, v3.16b
	aesd	v0.16b, v25.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v25.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v25.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v25.16b
	aesimc	v3.16b, v3.16b
	aesd	v0.16b, v26.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v26.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v26.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v26.16b
	aesimc	v3.16b, v3.16b
	aesd	v0.16b, v27.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v27.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v27.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v27.16b
	aesimc	v3.16b, v3.16b
	aesd	v0.16b, v28.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v28.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v28.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v28.16b
	aesimc	v3.16b, v3.16b
	aesd	v0.16b, v29.16b
	eor	v0.16b, v0.16b, v30.16b
	aesd	v1.16b, v29.16b
	eor	v1.16b, v1.16b, v30.16b
	aesd	v2.16b, v29.16b
	eor	v2.16b, v2.16b, v30.16b
	aesd	v3.16b, v29.16b
	eor	v3.16b, v3.16b, v30.16b
	sub	w2, w2, #4
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x1], #0x40
L_aes_decrypt_blocks_arm64_crypto_256_start_2:
	cmp	w2, #2
	blt	L_aes_decrypt_blocks_arm64_crypto_256_start_1
	ld1	{v0.16b, v1.16b}, [x0], #32
	aesd	v0.16b, v16.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v16.16b
	aesimc	v1.16b, v1.16b
	aesd	v0.16b, v17.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v17.16b
	aesimc	v1.16b, v1.16b
	aesd	v0.16b, v18.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v18.16b
	aesimc	v1.16b, v1.16b
	aesd	v0.16b, v19.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v19.16b
	aesimc	v1.16b, v1.16b
	aesd	v0.16b, v20.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v20.16b
	aesimc	v1.16b, v1.16b
	aesd	v0.16b, v21.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v21.16b
	aesimc	v1.16b, v1.16b
	aesd	v0.16b, v22.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v22.16b
	aesimc	v1.16b, v1.16b
	aesd	v0.16b, v23.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v23.16b
	aesimc	v1.16b, v1.16b
	aesd	v0.16b, v24.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v24.16b
	aesimc	v1.16b, v1.16b
	aesd	v0.16b, v25.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v25.16b
	aesimc	v1.16b, v1.16b
	aesd	v0.16b, v26.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v26.16b
	aesimc	v1.16b, v1.16b
	aesd	v0.16b, v27.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v27.16b
	aesimc	v1.16b, v1.16b
	aesd	v0.16b, v28.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v28.16b
	aesimc	v1.16b, v1.16b
	aesd	v0.16b, v29.16b
	eor	v0.16b, v0.16b, v30.16b
	aesd	v1.16b, v29.16b
	eor	v1.16b, v1.16b, v30.16b
	sub	w2, w2, #2
	st1	{v0.16b, v1.16b}, [x1], #32
L_aes_decrypt_blocks_arm64_crypto_256_start_1:
	cbz	w2, L_aes_decrypt_blocks_arm64_crypto_256_done
	ld1	{v0.16b}, [x0], #16
	aesd	v0.16b, v16.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v17.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v18.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v19.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v20.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v21.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v22.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v23.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v24.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v25.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v26.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v27.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v28.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v29.16b
	eor	v0.16b, v0.16b, v30.16b
	st1	{v0.16b}, [x1], #16
L_aes_decrypt_blocks_arm64_crypto_256_done:
#endif /* !NO_AES_256 */
	b	L_aes_decrypt_blocks_arm64_crypto_done
	# AES_ECB_128
L_aes_decrypt_blocks_arm64_crypto_start_128:
#ifndef NO_AES_128
	cmp	w2, #1
	beq	L_aes_decrypt_blocks_arm64_crypto_128_start_1
	cmp	w2, #8
	blt	L_aes_decrypt_blocks_arm64_crypto_128_start_4
L_aes_decrypt_blocks_arm64_crypto_128_start_8:
	ld1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x0], #0x40
	ld1	{v4.16b, v5.16b, v6.16b, v7.16b}, [x0], #0x40
	aesd	v0.16b, v16.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v16.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v16.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v16.16b
	aesimc	v3.16b, v3.16b
	aesd	v4.16b, v16.16b
	aesimc	v4.16b, v4.16b
	aesd	v5.16b, v16.16b
	aesimc	v5.16b, v5.16b
	aesd	v6.16b, v16.16b
	aesimc	v6.16b, v6.16b
	aesd	v7.16b, v16.16b
	aesimc	v7.16b, v7.16b
	aesd	v0.16b, v17.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v17.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v17.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v17.16b
	aesimc	v3.16b, v3.16b
	aesd	v4.16b, v17.16b
	aesimc	v4.16b, v4.16b
	aesd	v5.16b, v17.16b
	aesimc	v5.16b, v5.16b
	aesd	v6.16b, v17.16b
	aesimc	v6.16b, v6.16b
	aesd	v7.16b, v17.16b
	aesimc	v7.16b, v7.16b
	aesd	v0.16b, v18.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v18.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v18.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v18.16b
	aesimc	v3.16b, v3.16b
	aesd	v4.16b, v18.16b
	aesimc	v4.16b, v4.16b
	aesd	v5.16b, v18.16b
	aesimc	v5.16b, v5.16b
	aesd	v6.16b, v18.16b
	aesimc	v6.16b, v6.16b
	aesd	v7.16b, v18.16b
	aesimc	v7.16b, v7.16b
	aesd	v0.16b, v19.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v19.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v19.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v19.16b
	aesimc	v3.16b, v3.16b
	aesd	v4.16b, v19.16b
	aesimc	v4.16b, v4.16b
	aesd	v5.16b, v19.16b
	aesimc	v5.16b, v5.16b
	aesd	v6.16b, v19.16b
	aesimc	v6.16b, v6.16b
	aesd	v7.16b, v19.16b
	aesimc	v7.16b, v7.16b
	aesd	v0.16b, v20.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v20.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v20.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v20.16b
	aesimc	v3.16b, v3.16b
	aesd	v4.16b, v20.16b
	aesimc	v4.16b, v4.16b
	aesd	v5.16b, v20.16b
	aesimc	v5.16b, v5.16b
	aesd	v6.16b, v20.16b
	aesimc	v6.16b, v6.16b
	aesd	v7.16b, v20.16b
	aesimc	v7.16b, v7.16b
	aesd	v0.16b, v21.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v21.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v21.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v21.16b
	aesimc	v3.16b, v3.16b
	aesd	v4.16b, v21.16b
	aesimc	v4.16b, v4.16b
	aesd	v5.16b, v21.16b
	aesimc	v5.16b, v5.16b
	aesd	v6.16b, v21.16b
	aesimc	v6.16b, v6.16b
	aesd	v7.16b, v21.16b
	aesimc	v7.16b, v7.16b
	aesd	v0.16b, v22.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v22.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v22.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v22.16b
	aesimc	v3.16b, v3.16b
	aesd	v4.16b, v22.16b
	aesimc	v4.16b, v4.16b
	aesd	v5.16b, v22.16b
	aesimc	v5.16b, v5.16b
	aesd	v6.16b, v22.16b
	aesimc	v6.16b, v6.16b
	aesd	v7.16b, v22.16b
	aesimc	v7.16b, v7.16b
	aesd	v0.16b, v23.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v23.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v23.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v23.16b
	aesimc	v3.16b, v3.16b
	aesd	v4.16b, v23.16b
	aesimc	v4.16b, v4.16b
	aesd	v5.16b, v23.16b
	aesimc	v5.16b, v5.16b
	aesd	v6.16b, v23.16b
	aesimc	v6.16b, v6.16b
	aesd	v7.16b, v23.16b
	aesimc	v7.16b, v7.16b
	aesd	v0.16b, v24.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v24.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v24.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v24.16b
	aesimc	v3.16b, v3.16b
	aesd	v4.16b, v24.16b
	aesimc	v4.16b, v4.16b
	aesd	v5.16b, v24.16b
	aesimc	v5.16b, v5.16b
	aesd	v6.16b, v24.16b
	aesimc	v6.16b, v6.16b
	aesd	v7.16b, v24.16b
	aesimc	v7.16b, v7.16b
	aesd	v0.16b, v25.16b
	eor	v0.16b, v0.16b, v26.16b
	aesd	v1.16b, v25.16b
	eor	v1.16b, v1.16b, v26.16b
	aesd	v2.16b, v25.16b
	eor	v2.16b, v2.16b, v26.16b
	aesd	v3.16b, v25.16b
	eor	v3.16b, v3.16b, v26.16b
	aesd	v4.16b, v25.16b
	eor	v4.16b, v4.16b, v26.16b
	aesd	v5.16b, v25.16b
	eor	v5.16b, v5.16b, v26.16b
	aesd	v6.16b, v25.16b
	eor	v6.16b, v6.16b, v26.16b
	aesd	v7.16b, v25.16b
	eor	v7.16b, v7.16b, v26.16b
	sub	w2, w2, #8
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x1], #0x40
	st1	{v4.16b, v5.16b, v6.16b, v7.16b}, [x1], #0x40
	cmp	w2, #8
	bge	L_aes_decrypt_blocks_arm64_crypto_128_start_8
L_aes_decrypt_blocks_arm64_crypto_128_start_4:
	cmp	w2, #4
	blt	L_aes_decrypt_blocks_arm64_crypto_128_start_2
	ld1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x0], #0x40
	aesd	v0.16b, v16.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v16.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v16.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v16.16b
	aesimc	v3.16b, v3.16b
	aesd	v0.16b, v17.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v17.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v17.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v17.16b
	aesimc	v3.16b, v3.16b
	aesd	v0.16b, v18.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v18.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v18.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v18.16b
	aesimc	v3.16b, v3.16b
	aesd	v0.16b, v19.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v19.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v19.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v19.16b
	aesimc	v3.16b, v3.16b
	aesd	v0.16b, v20.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v20.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v20.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v20.16b
	aesimc	v3.16b, v3.16b
	aesd	v0.16b, v21.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v21.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v21.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v21.16b
	aesimc	v3.16b, v3.16b
	aesd	v0.16b, v22.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v22.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v22.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v22.16b
	aesimc	v3.16b, v3.16b
	aesd	v0.16b, v23.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v23.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v23.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v23.16b
	aesimc	v3.16b, v3.16b
	aesd	v0.16b, v24.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v24.16b
	aesimc	v1.16b, v1.16b
	aesd	v2.16b, v24.16b
	aesimc	v2.16b, v2.16b
	aesd	v3.16b, v24.16b
	aesimc	v3.16b, v3.16b
	aesd	v0.16b, v25.16b
	eor	v0.16b, v0.16b, v26.16b
	aesd	v1.16b, v25.16b
	eor	v1.16b, v1.16b, v26.16b
	aesd	v2.16b, v25.16b
	eor	v2.16b, v2.16b, v26.16b
	aesd	v3.16b, v25.16b
	eor	v3.16b, v3.16b, v26.16b
	sub	w2, w2, #4
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x1], #0x40
L_aes_decrypt_blocks_arm64_crypto_128_start_2:
	cmp	w2, #2
	blt	L_aes_decrypt_blocks_arm64_crypto_128_start_1
	ld1	{v0.16b, v1.16b}, [x0], #32
	aesd	v0.16b, v16.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v16.16b
	aesimc	v1.16b, v1.16b
	aesd	v0.16b, v17.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v17.16b
	aesimc	v1.16b, v1.16b
	aesd	v0.16b, v18.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v18.16b
	aesimc	v1.16b, v1.16b
	aesd	v0.16b, v19.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v19.16b
	aesimc	v1.16b, v1.16b
	aesd	v0.16b, v20.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v20.16b
	aesimc	v1.16b, v1.16b
	aesd	v0.16b, v21.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v21.16b
	aesimc	v1.16b, v1.16b
	aesd	v0.16b, v22.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v22.16b
	aesimc	v1.16b, v1.16b
	aesd	v0.16b, v23.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v23.16b
	aesimc	v1.16b, v1.16b
	aesd	v0.16b, v24.16b
	aesimc	v0.16b, v0.16b
	aesd	v1.16b, v24.16b
	aesimc	v1.16b, v1.16b
	aesd	v0.16b, v25.16b
	eor	v0.16b, v0.16b, v26.16b
	aesd	v1.16b, v25.16b
	eor	v1.16b, v1.16b, v26.16b
	sub	w2, w2, #2
	st1	{v0.16b, v1.16b}, [x1], #32
L_aes_decrypt_blocks_arm64_crypto_128_start_1:
	cbz	w2, L_aes_decrypt_blocks_arm64_crypto_128_done
	ld1	{v0.16b}, [x0], #16
	aesd	v0.16b, v16.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v17.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v18.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v19.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v20.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v21.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v22.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v23.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v24.16b
	aesimc	v0.16b, v0.16b
	aesd	v0.16b, v25.16b
	eor	v0.16b, v0.16b, v26.16b
	st1	{v0.16b}, [x1], #16
L_aes_decrypt_blocks_arm64_crypto_128_done:
#endif /* !NO_AES_128 */
L_aes_decrypt_blocks_arm64_crypto_done:
	ldp	x29, x30, [sp], #32
	ret
#ifndef __APPLE__
	.size	AES_decrypt_blocks_AARCH64,.-AES_decrypt_blocks_AARCH64
#endif /* __APPLE__ */
#endif /* HAVE_AES_DECRYPT */
#endif /* HAVE_AES_ECB */
#ifdef HAVE_AES_CBC
#ifndef __APPLE__
.text
.globl	AES_CBC_encrypt_AARCH64
.type	AES_CBC_encrypt_AARCH64,@function
.align	2
AES_CBC_encrypt_AARCH64:
#else
.section	__TEXT,__text
.globl	_AES_CBC_encrypt_AARCH64
.p2align	2
_AES_CBC_encrypt_AARCH64:
#endif /* __APPLE__ */
	ld1	{v16.2d, v17.2d, v18.2d, v19.2d}, [x4], #0x40
	ld1	{v20.2d, v21.2d, v22.2d, v23.2d}, [x4], #0x40
	ld1	{v0.2d}, [x3]
	subs	w5, w5, #12
	lsr	w2, w2, #4
	blt	L_aes_cbc_encrypt_arm64_crypto_start_128
	bgt	L_aes_cbc_encrypt_arm64_crypto_start_256
	# AES_CBC_192
#ifndef NO_AES_192
	ld1	{v24.2d, v25.2d, v26.2d, v27.2d}, [x4], #0x40
L_aes_cbc_encrypt_arm64_crypto_loop_192:
	ld1	{v28.2d}, [x4]
	ld1	{v1.16b}, [x0], #16
	subs	w2, w2, #1
	eor	v0.16b, v0.16b, v1.16b
	aese	v0.16b, v16.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v17.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v18.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v19.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v20.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v21.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v22.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v23.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v24.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v25.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v26.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v27.16b
	eor	v0.16b, v0.16b, v28.16b
	st1	{v0.16b}, [x1], #16
	bne	L_aes_cbc_encrypt_arm64_crypto_loop_192
#endif /* !NO_AES_192 */
	b	L_aes_cbc_encrypt_arm64_crypto_done
	# AES_CBC_256
L_aes_cbc_encrypt_arm64_crypto_start_256:
#ifndef NO_AES_256
	ld1	{v24.2d, v25.2d, v26.2d, v27.2d}, [x4], #0x40
	ld1	{v28.2d, v29.2d}, [x4], #32
L_aes_cbc_encrypt_arm64_crypto_loop_256:
	ld1	{v30.2d}, [x4]
	ld1	{v1.16b}, [x0], #16
	subs	w2, w2, #1
	eor	v0.16b, v0.16b, v1.16b
	aese	v0.16b, v16.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v17.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v18.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v19.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v20.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v21.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v22.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v23.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v24.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v25.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v26.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v27.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v28.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v29.16b
	eor	v0.16b, v0.16b, v30.16b
	st1	{v0.16b}, [x1], #16
	bne	L_aes_cbc_encrypt_arm64_crypto_loop_256
#endif /* !NO_AES_256 */
	b	L_aes_cbc_encrypt_arm64_crypto_done
	# AES_CBC_128
L_aes_cbc_encrypt_arm64_crypto_start_128:
#ifndef NO_AES_128
	ld1	{v24.2d, v25.2d}, [x4], #32
L_aes_cbc_encrypt_arm64_crypto_loop_128:
	ld1	{v26.2d}, [x4]
	ld1	{v1.16b}, [x0], #16
	subs	w2, w2, #1
	eor	v0.16b, v0.16b, v1.16b
	aese	v0.16b, v16.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v17.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v18.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v19.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v20.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v21.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v22.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v23.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v24.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v25.16b
	eor	v0.16b, v0.16b, v26.16b
	st1	{v0.16b}, [x1], #16
	bne	L_aes_cbc_encrypt_arm64_crypto_loop_128
#endif /* !NO_AES_128 */
L_aes_cbc_encrypt_arm64_crypto_done:
	st1	{v0.2d}, [x3]
	ret
#ifndef __APPLE__
	.size	AES_CBC_encrypt_AARCH64,.-AES_CBC_encrypt_AARCH64
#endif /* __APPLE__ */
#ifdef HAVE_AES_DECRYPT
#ifndef __APPLE__
.text
.globl	AES_CBC_decrypt_AARCH64
.type	AES_CBC_decrypt_AARCH64,@function
.align	2
AES_CBC_decrypt_AARCH64:
#else
.section	__TEXT,__text
.globl	_AES_CBC_decrypt_AARCH64
.p2align	2
_AES_CBC_decrypt_AARCH64:
#endif /* __APPLE__ */
	ld1	{v16.2d, v17.2d, v18.2d, v19.2d}, [x4], #0x40
	ld1	{v20.2d, v21.2d, v22.2d, v23.2d}, [x4], #0x40
	ld1	{v0.2d}, [x3]
	lsr	w2, w2, #4
	cmp	w5, #12
	blt	L_aes_cbc_decrypt_blocks_arm64_crypto_start_128
	bgt	L_aes_cbc_decrypt_blocks_arm64_crypto_start_256
	# AES_CBC_192
#ifndef NO_AES_192
	ld1	{v24.2d, v25.2d, v26.2d, v27.2d}, [x4], #0x40
	ld1	{v28.2d}, [x4]
	cmp	w2, #10
	ble	L_aes_cbc_decrypt_blocks_arm64_crypto_192_start_1
L_aes_cbc_decrypt_blocks_arm64_crypto_192_start_1_long:
	ld1	{v1.16b}, [x0], #16
	sub	w2, w2, #1
	mov	v2.16b, v1.16b
	aesd	v1.16b, v16.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v17.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v18.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v19.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v20.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v21.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v22.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v23.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v24.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v25.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v26.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v27.16b
	eor	v0.16b, v0.16b, v28.16b
	eor	v1.16b, v1.16b, v0.16b
	mov	v0.16b, v2.16b
	st1	{v1.16b}, [x1], #16
	cmp	w2, #1
	bge	L_aes_cbc_decrypt_blocks_arm64_crypto_192_start_1_long
	b	L_aes_cbc_decrypt_blocks_arm64_crypto_done
L_aes_cbc_decrypt_blocks_arm64_crypto_192_start_1:
	ld1	{v1.16b}, [x0], #16
	sub	w2, w2, #1
	eor	v2.16b, v0.16b, v28.16b
	mov	v0.16b, v1.16b
	aesd	v1.16b, v16.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v17.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v18.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v19.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v20.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v21.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v22.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v23.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v24.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v25.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v26.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v27.16b
	eor	v1.16b, v1.16b, v2.16b
	st1	{v1.16b}, [x1], #16
	cmp	w2, #1
	bge	L_aes_cbc_decrypt_blocks_arm64_crypto_192_start_1
#endif /* !NO_AES_192 */
	b	L_aes_cbc_decrypt_blocks_arm64_crypto_done
	# AES_CBC_256
L_aes_cbc_decrypt_blocks_arm64_crypto_start_256:
#ifndef NO_AES_256
	ld1	{v24.2d, v25.2d, v26.2d, v27.2d}, [x4], #0x40
	ld1	{v28.2d, v29.2d}, [x4], #32
	ld1	{v30.2d}, [x4]
	cmp	w2, #5
	ble	L_aes_cbc_decrypt_blocks_arm64_crypto_256_start_1
L_aes_cbc_decrypt_blocks_arm64_crypto_256_start_1_long:
	ld1	{v1.16b}, [x0], #16
	sub	w2, w2, #1
	mov	v2.16b, v1.16b
	aesd	v1.16b, v16.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v17.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v18.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v19.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v20.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v21.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v22.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v23.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v24.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v25.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v26.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v27.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v28.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v29.16b
	eor	v0.16b, v0.16b, v30.16b
	eor	v1.16b, v1.16b, v0.16b
	mov	v0.16b, v2.16b
	st1	{v1.16b}, [x1], #16
	cmp	w2, #1
	bge	L_aes_cbc_decrypt_blocks_arm64_crypto_256_start_1_long
	b	L_aes_cbc_decrypt_blocks_arm64_crypto_done
L_aes_cbc_decrypt_blocks_arm64_crypto_256_start_1:
	ld1	{v1.16b}, [x0], #16
	sub	w2, w2, #1
	eor	v2.16b, v0.16b, v30.16b
	mov	v0.16b, v1.16b
	aesd	v1.16b, v16.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v17.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v18.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v19.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v20.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v21.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v22.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v23.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v24.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v25.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v26.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v27.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v28.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v29.16b
	eor	v1.16b, v1.16b, v2.16b
	st1	{v1.16b}, [x1], #16
	cmp	w2, #1
	bge	L_aes_cbc_decrypt_blocks_arm64_crypto_256_start_1
#endif /* !NO_AES_256 */
	b	L_aes_cbc_decrypt_blocks_arm64_crypto_done
	# AES_CBC_128
L_aes_cbc_decrypt_blocks_arm64_crypto_start_128:
#ifndef NO_AES_128
	ld1	{v24.2d, v25.2d}, [x4], #32
	ld1	{v26.2d}, [x4]
	cmp	w2, #24
	ble	L_aes_cbc_decrypt_blocks_arm64_crypto_128_start_1
L_aes_cbc_decrypt_blocks_arm64_crypto_128_start_1_long:
	ld1	{v1.16b}, [x0], #16
	sub	w2, w2, #1
	mov	v2.16b, v1.16b
	aesd	v1.16b, v16.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v17.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v18.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v19.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v20.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v21.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v22.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v23.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v24.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v25.16b
	eor	v0.16b, v0.16b, v26.16b
	eor	v1.16b, v1.16b, v0.16b
	mov	v0.16b, v2.16b
	st1	{v1.16b}, [x1], #16
	cmp	w2, #1
	bge	L_aes_cbc_decrypt_blocks_arm64_crypto_128_start_1_long
	b	L_aes_cbc_decrypt_blocks_arm64_crypto_done
L_aes_cbc_decrypt_blocks_arm64_crypto_128_start_1:
	ld1	{v1.16b}, [x0], #16
	sub	w2, w2, #1
	eor	v2.16b, v0.16b, v26.16b
	mov	v0.16b, v1.16b
	aesd	v1.16b, v16.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v17.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v18.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v19.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v20.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v21.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v22.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v23.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v24.16b
	aesimc	v1.16b, v1.16b
	aesd	v1.16b, v25.16b
	eor	v1.16b, v1.16b, v2.16b
	st1	{v1.16b}, [x1], #16
	cmp	w2, #1
	bge	L_aes_cbc_decrypt_blocks_arm64_crypto_128_start_1
#endif /* !NO_AES_128 */
L_aes_cbc_decrypt_blocks_arm64_crypto_done:
	st1	{v0.2d}, [x3]
	ret
#ifndef __APPLE__
	.size	AES_CBC_decrypt_AARCH64,.-AES_CBC_decrypt_AARCH64
#endif /* __APPLE__ */
#endif /* HAVE_AES_DECRYPT */
#endif /* HAVE_AES_CBC */
#ifdef WOLFSSL_AES_COUNTER
#ifndef __APPLE__
.text
.globl	AES_CTR_encrypt_AARCH64
.type	AES_CTR_encrypt_AARCH64,@function
.align	2
AES_CTR_encrypt_AARCH64:
#else
.section	__TEXT,__text
.globl	_AES_CTR_encrypt_AARCH64
.p2align	2
_AES_CTR_encrypt_AARCH64:
#endif /* __APPLE__ */
	stp	x29, x30, [sp, #-144]!
	add	x29, sp, #0
	stp	x17, x19, [x29, #16]
	stp	x20, x21, [x29, #32]
	stp	x22, x23, [x29, #48]
	stp	x24, x25, [x29, #64]
	stp	d8, d9, [x29, #80]
	stp	d10, d11, [x29, #96]
	stp	d12, d13, [x29, #112]
	stp	d14, d15, [x29, #128]
	ld1	{v0.2d, v1.2d, v2.2d, v3.2d}, [x4], #0x40
	ld1	{v4.2d, v5.2d, v6.2d, v7.2d}, [x4], #0x40
	ld1	{v15.2d}, [x3]
	rev64	v16.16b, v15.16b
	lsr	w8, w2, #4
	and	w2, w2, #15
	mov	x9, v16.d[1]
	mov	x10, v16.d[0]
	cmp	w7, #12
	blt	L_aes_ctr_encrypt_arm64_crypto_start_128
	bgt	L_aes_ctr_encrypt_arm64_crypto_start_256
	# AES_CTR_192
#ifndef NO_AES_192
	ld1	{v8.2d, v9.2d, v10.2d, v11.2d}, [x4], #0x40
	ld1	{v12.2d}, [x4]
	cmp	w8, #1
	ble	L_aes_ctr_encrypt_arm64_crypto_192_start_1
	adds	x11, x9, #1
	adc	x12, x10, xzr
	cmp	w8, #8
	blt	L_aes_ctr_encrypt_arm64_crypto_192_start_4
	adds	x13, x9, #2
	adc	x14, x10, xzr
	adds	x15, x9, #3
	adc	x16, x10, xzr
L_aes_ctr_encrypt_arm64_crypto_192_start_8:
	ld1	{v24.16b, v25.16b, v26.16b, v27.16b}, [x0], #0x40
	ld1	{v28.16b, v29.16b, v30.16b, v31.16b}, [x0], #0x40
	mov	v17.d[0], x12
	mov	v17.d[1], x11
	mov	v18.d[0], x14
	mov	v18.d[1], x13
	adds	x17, x9, #4
	mov	v19.d[0], x16
	adc	x19, x10, xzr
	mov	v19.d[1], x15
	adds	x20, x9, #5
	mov	v20.d[0], x19
	adc	x21, x10, xzr
	mov	v20.d[1], x17
	adds	x22, x9, #6
	mov	v21.d[0], x21
	adc	x23, x10, xzr
	mov	v21.d[1], x20
	adds	x24, x9, #7
	mov	v22.d[0], x23
	adc	x25, x10, xzr
	mov	v22.d[1], x22
	mov	v23.d[0], x25
	mov	v23.d[1], x24
	rev64	v16.16b, v16.16b
	rev64	v17.16b, v17.16b
	rev64	v18.16b, v18.16b
	rev64	v19.16b, v19.16b
	rev64	v20.16b, v20.16b
	rev64	v21.16b, v21.16b
	rev64	v22.16b, v22.16b
	rev64	v23.16b, v23.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v0.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v0.16b
	aesmc	v19.16b, v19.16b
	aese	v20.16b, v0.16b
	aesmc	v20.16b, v20.16b
	aese	v21.16b, v0.16b
	aesmc	v21.16b, v21.16b
	aese	v22.16b, v0.16b
	aesmc	v22.16b, v22.16b
	aese	v23.16b, v0.16b
	aesmc	v23.16b, v23.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v1.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v1.16b
	aesmc	v19.16b, v19.16b
	aese	v20.16b, v1.16b
	aesmc	v20.16b, v20.16b
	aese	v21.16b, v1.16b
	aesmc	v21.16b, v21.16b
	aese	v22.16b, v1.16b
	aesmc	v22.16b, v22.16b
	aese	v23.16b, v1.16b
	aesmc	v23.16b, v23.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v2.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v2.16b
	aesmc	v19.16b, v19.16b
	aese	v20.16b, v2.16b
	aesmc	v20.16b, v20.16b
	aese	v21.16b, v2.16b
	aesmc	v21.16b, v21.16b
	aese	v22.16b, v2.16b
	aesmc	v22.16b, v22.16b
	aese	v23.16b, v2.16b
	aesmc	v23.16b, v23.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v3.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v3.16b
	aesmc	v19.16b, v19.16b
	aese	v20.16b, v3.16b
	aesmc	v20.16b, v20.16b
	aese	v21.16b, v3.16b
	aesmc	v21.16b, v21.16b
	aese	v22.16b, v3.16b
	aesmc	v22.16b, v22.16b
	aese	v23.16b, v3.16b
	aesmc	v23.16b, v23.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v4.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v4.16b
	aesmc	v19.16b, v19.16b
	aese	v20.16b, v4.16b
	aesmc	v20.16b, v20.16b
	aese	v21.16b, v4.16b
	aesmc	v21.16b, v21.16b
	aese	v22.16b, v4.16b
	aesmc	v22.16b, v22.16b
	aese	v23.16b, v4.16b
	aesmc	v23.16b, v23.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v5.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v5.16b
	aesmc	v19.16b, v19.16b
	aese	v20.16b, v5.16b
	aesmc	v20.16b, v20.16b
	aese	v21.16b, v5.16b
	aesmc	v21.16b, v21.16b
	aese	v22.16b, v5.16b
	aesmc	v22.16b, v22.16b
	aese	v23.16b, v5.16b
	aesmc	v23.16b, v23.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v6.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v6.16b
	aesmc	v19.16b, v19.16b
	aese	v20.16b, v6.16b
	aesmc	v20.16b, v20.16b
	aese	v21.16b, v6.16b
	aesmc	v21.16b, v21.16b
	aese	v22.16b, v6.16b
	aesmc	v22.16b, v22.16b
	aese	v23.16b, v6.16b
	aesmc	v23.16b, v23.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v7.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v7.16b
	aesmc	v19.16b, v19.16b
	aese	v20.16b, v7.16b
	aesmc	v20.16b, v20.16b
	aese	v21.16b, v7.16b
	aesmc	v21.16b, v21.16b
	aese	v22.16b, v7.16b
	aesmc	v22.16b, v22.16b
	aese	v23.16b, v7.16b
	aesmc	v23.16b, v23.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v8.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v8.16b
	aesmc	v19.16b, v19.16b
	aese	v20.16b, v8.16b
	aesmc	v20.16b, v20.16b
	aese	v21.16b, v8.16b
	aesmc	v21.16b, v21.16b
	aese	v22.16b, v8.16b
	aesmc	v22.16b, v22.16b
	aese	v23.16b, v8.16b
	aesmc	v23.16b, v23.16b
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v9.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v9.16b
	aesmc	v19.16b, v19.16b
	aese	v20.16b, v9.16b
	aesmc	v20.16b, v20.16b
	aese	v21.16b, v9.16b
	aesmc	v21.16b, v21.16b
	aese	v22.16b, v9.16b
	aesmc	v22.16b, v22.16b
	aese	v23.16b, v9.16b
	aesmc	v23.16b, v23.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v10.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v10.16b
	aesmc	v19.16b, v19.16b
	aese	v20.16b, v10.16b
	aesmc	v20.16b, v20.16b
	aese	v21.16b, v10.16b
	aesmc	v21.16b, v21.16b
	aese	v22.16b, v10.16b
	aesmc	v22.16b, v22.16b
	aese	v23.16b, v10.16b
	aesmc	v23.16b, v23.16b
	aese	v16.16b, v11.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v11.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v18.16b, v11.16b
	eor	v18.16b, v18.16b, v12.16b
	aese	v19.16b, v11.16b
	eor	v19.16b, v19.16b, v12.16b
	aese	v20.16b, v11.16b
	eor	v20.16b, v20.16b, v12.16b
	aese	v21.16b, v11.16b
	eor	v21.16b, v21.16b, v12.16b
	aese	v22.16b, v11.16b
	eor	v22.16b, v22.16b, v12.16b
	aese	v23.16b, v11.16b
	eor	v23.16b, v23.16b, v12.16b
	adds	x9, x9, #8
	eor	v24.16b, v24.16b, v16.16b
	adc	x10, x10, xzr
	eor	v25.16b, v25.16b, v17.16b
	adds	x11, x11, #8
	eor	v26.16b, v26.16b, v18.16b
	adc	x12, x12, xzr
	eor	v27.16b, v27.16b, v19.16b
	adds	x13, x13, #8
	eor	v28.16b, v28.16b, v20.16b
	adc	x14, x14, xzr
	eor	v29.16b, v29.16b, v21.16b
	adds	x15, x15, #8
	eor	v30.16b, v30.16b, v22.16b
	adc	x16, x16, xzr
	eor	v31.16b, v31.16b, v23.16b
	sub	w8, w8, #8
	st1	{v24.16b, v25.16b, v26.16b, v27.16b}, [x1], #0x40
	st1	{v28.16b, v29.16b, v30.16b, v31.16b}, [x1], #0x40
	mov	v16.d[0], x10
	mov	v16.d[1], x9
	cmp	w8, #8
	bge	L_aes_ctr_encrypt_arm64_crypto_192_start_8
L_aes_ctr_encrypt_arm64_crypto_192_start_4:
	cmp	w8, #4
	blt	L_aes_ctr_encrypt_arm64_crypto_192_start_2
	ld1	{v24.16b, v25.16b, v26.16b, v27.16b}, [x0], #0x40
	adds	x13, x9, #2
	mov	v17.d[0], x12
	adc	x14, x10, xzr
	mov	v17.d[1], x11
	adds	x15, x9, #3
	mov	v18.d[0], x14
	adc	x16, x10, xzr
	mov	v18.d[1], x13
	mov	v19.d[0], x16
	mov	v19.d[1], x15
	rev64	v16.16b, v16.16b
	rev64	v17.16b, v17.16b
	rev64	v18.16b, v18.16b
	rev64	v19.16b, v19.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v0.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v0.16b
	aesmc	v19.16b, v19.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v1.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v1.16b
	aesmc	v19.16b, v19.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v2.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v2.16b
	aesmc	v19.16b, v19.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v3.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v3.16b
	aesmc	v19.16b, v19.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v4.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v4.16b
	aesmc	v19.16b, v19.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v5.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v5.16b
	aesmc	v19.16b, v19.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v6.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v6.16b
	aesmc	v19.16b, v19.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v7.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v7.16b
	aesmc	v19.16b, v19.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v8.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v8.16b
	aesmc	v19.16b, v19.16b
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v9.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v9.16b
	aesmc	v19.16b, v19.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v10.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v10.16b
	aesmc	v19.16b, v19.16b
	aese	v16.16b, v11.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v11.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v18.16b, v11.16b
	eor	v18.16b, v18.16b, v12.16b
	aese	v19.16b, v11.16b
	eor	v19.16b, v19.16b, v12.16b
	adds	x9, x9, #4
	eor	v24.16b, v24.16b, v16.16b
	adc	x10, x10, xzr
	eor	v25.16b, v25.16b, v17.16b
	adds	x11, x11, #4
	eor	v26.16b, v26.16b, v18.16b
	adc	x12, x12, xzr
	eor	v27.16b, v27.16b, v19.16b
	sub	w8, w8, #4
	st1	{v24.16b, v25.16b, v26.16b, v27.16b}, [x1], #0x40
	mov	v16.d[0], x10
	mov	v16.d[1], x9
L_aes_ctr_encrypt_arm64_crypto_192_start_2:
	cmp	w8, #2
	blt	L_aes_ctr_encrypt_arm64_crypto_192_start_1
	ld1	{v24.16b, v25.16b}, [x0], #32
	eor	v20.16b, v20.16b, v20.16b
	ext	v19.16b, v16.16b, v16.16b, #8
	movi	v18.16b, #1
	ext	v18.16b, v18.16b, v20.16b, #15
	add	v17.2d, v19.2d, v18.2d
	cmeq	v19.2d, v17.2d, #0
	ext	v19.16b, v20.16b, v19.16b, #8
	sub	v17.2d, v17.2d, v19.2d
	ext	v17.16b, v17.16b, v17.16b, #8
	rev64	v16.16b, v16.16b
	rev64	v17.16b, v17.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v16.16b, v11.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v11.16b
	eor	v17.16b, v17.16b, v12.16b
	adds	x9, x9, #2
	eor	v24.16b, v24.16b, v16.16b
	adc	x10, x10, xzr
	eor	v25.16b, v25.16b, v17.16b
	sub	w8, w8, #2
	st1	{v24.16b, v25.16b}, [x1], #32
	mov	v16.d[0], x10
	mov	v16.d[1], x9
L_aes_ctr_encrypt_arm64_crypto_192_start_1:
	cbz	w8, L_aes_ctr_encrypt_arm64_crypto_192_done
	ld1	{v24.16b}, [x0], #16
	rev64	v16.16b, v16.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v11.16b
	eor	v16.16b, v16.16b, v12.16b
	adds	x9, x9, #1
	eor	v24.16b, v24.16b, v16.16b
	adc	x10, x10, xzr
	st1	{v24.16b}, [x1], #16
L_aes_ctr_encrypt_arm64_crypto_192_done:
	cbz	w2, L_aes_ctr_encrypt_arm64_crypto_192_partial_done
	mov	v16.d[0], x10
	mov	v16.d[1], x9
	rev64	v16.16b, v16.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v11.16b
	eor	v16.16b, v16.16b, v12.16b
	adds	x9, x9, #1
	adc	x10, x10, xzr
	st1	{v16.2d}, [x5]
	mov	w13, #16
	sub	w13, w13, w2
L_aes_ctr_encrypt_arm64_crypto_192_start_byte:
	ldrb	w11, [x5], #1
	ldrb	w12, [x0], #1
	eor	w11, w11, w12
	subs	w2, w2, #1
	strb	w11, [x1], #1
	bgt	L_aes_ctr_encrypt_arm64_crypto_192_start_byte
	str	w13, [x6]
L_aes_ctr_encrypt_arm64_crypto_192_partial_done:
#endif /* !NO_AES_192 */
	b	L_aes_ctr_encrypt_arm64_crypto_done
	# AES_CTR_256
L_aes_ctr_encrypt_arm64_crypto_start_256:
#ifndef NO_AES_256
	ld1	{v8.2d, v9.2d, v10.2d, v11.2d}, [x4], #0x40
	ld1	{v12.2d, v13.2d}, [x4], #32
	ld1	{v14.2d}, [x4]
	cmp	w8, #1
	ble	L_aes_ctr_encrypt_arm64_crypto_256_start_1
	adds	x11, x9, #1
	adc	x12, x10, xzr
	cmp	w8, #8
	blt	L_aes_ctr_encrypt_arm64_crypto_256_start_4
	adds	x13, x9, #2
	adc	x14, x10, xzr
	adds	x15, x9, #3
	adc	x16, x10, xzr
L_aes_ctr_encrypt_arm64_crypto_256_start_8:
	ld1	{v24.16b, v25.16b, v26.16b, v27.16b}, [x0], #0x40
	ld1	{v28.16b, v29.16b, v30.16b, v31.16b}, [x0], #0x40
	mov	v17.d[0], x12
	mov	v17.d[1], x11
	mov	v18.d[0], x14
	mov	v18.d[1], x13
	adds	x17, x9, #4
	mov	v19.d[0], x16
	adc	x19, x10, xzr
	mov	v19.d[1], x15
	adds	x20, x9, #5
	mov	v20.d[0], x19
	adc	x21, x10, xzr
	mov	v20.d[1], x17
	adds	x22, x9, #6
	mov	v21.d[0], x21
	adc	x23, x10, xzr
	mov	v21.d[1], x20
	adds	x24, x9, #7
	mov	v22.d[0], x23
	adc	x25, x10, xzr
	mov	v22.d[1], x22
	mov	v23.d[0], x25
	mov	v23.d[1], x24
	rev64	v16.16b, v16.16b
	rev64	v17.16b, v17.16b
	rev64	v18.16b, v18.16b
	rev64	v19.16b, v19.16b
	rev64	v20.16b, v20.16b
	rev64	v21.16b, v21.16b
	rev64	v22.16b, v22.16b
	rev64	v23.16b, v23.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v0.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v0.16b
	aesmc	v19.16b, v19.16b
	aese	v20.16b, v0.16b
	aesmc	v20.16b, v20.16b
	aese	v21.16b, v0.16b
	aesmc	v21.16b, v21.16b
	aese	v22.16b, v0.16b
	aesmc	v22.16b, v22.16b
	aese	v23.16b, v0.16b
	aesmc	v23.16b, v23.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v1.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v1.16b
	aesmc	v19.16b, v19.16b
	aese	v20.16b, v1.16b
	aesmc	v20.16b, v20.16b
	aese	v21.16b, v1.16b
	aesmc	v21.16b, v21.16b
	aese	v22.16b, v1.16b
	aesmc	v22.16b, v22.16b
	aese	v23.16b, v1.16b
	aesmc	v23.16b, v23.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v2.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v2.16b
	aesmc	v19.16b, v19.16b
	aese	v20.16b, v2.16b
	aesmc	v20.16b, v20.16b
	aese	v21.16b, v2.16b
	aesmc	v21.16b, v21.16b
	aese	v22.16b, v2.16b
	aesmc	v22.16b, v22.16b
	aese	v23.16b, v2.16b
	aesmc	v23.16b, v23.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v3.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v3.16b
	aesmc	v19.16b, v19.16b
	aese	v20.16b, v3.16b
	aesmc	v20.16b, v20.16b
	aese	v21.16b, v3.16b
	aesmc	v21.16b, v21.16b
	aese	v22.16b, v3.16b
	aesmc	v22.16b, v22.16b
	aese	v23.16b, v3.16b
	aesmc	v23.16b, v23.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v4.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v4.16b
	aesmc	v19.16b, v19.16b
	aese	v20.16b, v4.16b
	aesmc	v20.16b, v20.16b
	aese	v21.16b, v4.16b
	aesmc	v21.16b, v21.16b
	aese	v22.16b, v4.16b
	aesmc	v22.16b, v22.16b
	aese	v23.16b, v4.16b
	aesmc	v23.16b, v23.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v5.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v5.16b
	aesmc	v19.16b, v19.16b
	aese	v20.16b, v5.16b
	aesmc	v20.16b, v20.16b
	aese	v21.16b, v5.16b
	aesmc	v21.16b, v21.16b
	aese	v22.16b, v5.16b
	aesmc	v22.16b, v22.16b
	aese	v23.16b, v5.16b
	aesmc	v23.16b, v23.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v6.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v6.16b
	aesmc	v19.16b, v19.16b
	aese	v20.16b, v6.16b
	aesmc	v20.16b, v20.16b
	aese	v21.16b, v6.16b
	aesmc	v21.16b, v21.16b
	aese	v22.16b, v6.16b
	aesmc	v22.16b, v22.16b
	aese	v23.16b, v6.16b
	aesmc	v23.16b, v23.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v7.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v7.16b
	aesmc	v19.16b, v19.16b
	aese	v20.16b, v7.16b
	aesmc	v20.16b, v20.16b
	aese	v21.16b, v7.16b
	aesmc	v21.16b, v21.16b
	aese	v22.16b, v7.16b
	aesmc	v22.16b, v22.16b
	aese	v23.16b, v7.16b
	aesmc	v23.16b, v23.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v8.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v8.16b
	aesmc	v19.16b, v19.16b
	aese	v20.16b, v8.16b
	aesmc	v20.16b, v20.16b
	aese	v21.16b, v8.16b
	aesmc	v21.16b, v21.16b
	aese	v22.16b, v8.16b
	aesmc	v22.16b, v22.16b
	aese	v23.16b, v8.16b
	aesmc	v23.16b, v23.16b
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v9.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v9.16b
	aesmc	v19.16b, v19.16b
	aese	v20.16b, v9.16b
	aesmc	v20.16b, v20.16b
	aese	v21.16b, v9.16b
	aesmc	v21.16b, v21.16b
	aese	v22.16b, v9.16b
	aesmc	v22.16b, v22.16b
	aese	v23.16b, v9.16b
	aesmc	v23.16b, v23.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v10.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v10.16b
	aesmc	v19.16b, v19.16b
	aese	v20.16b, v10.16b
	aesmc	v20.16b, v20.16b
	aese	v21.16b, v10.16b
	aesmc	v21.16b, v21.16b
	aese	v22.16b, v10.16b
	aesmc	v22.16b, v22.16b
	aese	v23.16b, v10.16b
	aesmc	v23.16b, v23.16b
	aese	v16.16b, v11.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v11.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v11.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v11.16b
	aesmc	v19.16b, v19.16b
	aese	v20.16b, v11.16b
	aesmc	v20.16b, v20.16b
	aese	v21.16b, v11.16b
	aesmc	v21.16b, v21.16b
	aese	v22.16b, v11.16b
	aesmc	v22.16b, v22.16b
	aese	v23.16b, v11.16b
	aesmc	v23.16b, v23.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v12.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v12.16b
	aesmc	v19.16b, v19.16b
	aese	v20.16b, v12.16b
	aesmc	v20.16b, v20.16b
	aese	v21.16b, v12.16b
	aesmc	v21.16b, v21.16b
	aese	v22.16b, v12.16b
	aesmc	v22.16b, v22.16b
	aese	v23.16b, v12.16b
	aesmc	v23.16b, v23.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v14.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v14.16b
	aese	v18.16b, v13.16b
	eor	v18.16b, v18.16b, v14.16b
	aese	v19.16b, v13.16b
	eor	v19.16b, v19.16b, v14.16b
	aese	v20.16b, v13.16b
	eor	v20.16b, v20.16b, v14.16b
	aese	v21.16b, v13.16b
	eor	v21.16b, v21.16b, v14.16b
	aese	v22.16b, v13.16b
	eor	v22.16b, v22.16b, v14.16b
	aese	v23.16b, v13.16b
	eor	v23.16b, v23.16b, v14.16b
	adds	x9, x9, #8
	eor	v24.16b, v24.16b, v16.16b
	adc	x10, x10, xzr
	eor	v25.16b, v25.16b, v17.16b
	adds	x11, x11, #8
	eor	v26.16b, v26.16b, v18.16b
	adc	x12, x12, xzr
	eor	v27.16b, v27.16b, v19.16b
	adds	x13, x13, #8
	eor	v28.16b, v28.16b, v20.16b
	adc	x14, x14, xzr
	eor	v29.16b, v29.16b, v21.16b
	adds	x15, x15, #8
	eor	v30.16b, v30.16b, v22.16b
	adc	x16, x16, xzr
	eor	v31.16b, v31.16b, v23.16b
	sub	w8, w8, #8
	st1	{v24.16b, v25.16b, v26.16b, v27.16b}, [x1], #0x40
	st1	{v28.16b, v29.16b, v30.16b, v31.16b}, [x1], #0x40
	mov	v16.d[0], x10
	mov	v16.d[1], x9
	cmp	w8, #8
	bge	L_aes_ctr_encrypt_arm64_crypto_256_start_8
L_aes_ctr_encrypt_arm64_crypto_256_start_4:
	cmp	w8, #4
	blt	L_aes_ctr_encrypt_arm64_crypto_256_start_2
	ld1	{v24.16b, v25.16b, v26.16b, v27.16b}, [x0], #0x40
	adds	x13, x9, #2
	mov	v17.d[0], x12
	adc	x14, x10, xzr
	mov	v17.d[1], x11
	adds	x15, x9, #3
	mov	v18.d[0], x14
	adc	x16, x10, xzr
	mov	v18.d[1], x13
	mov	v19.d[0], x16
	mov	v19.d[1], x15
	rev64	v16.16b, v16.16b
	rev64	v17.16b, v17.16b
	rev64	v18.16b, v18.16b
	rev64	v19.16b, v19.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v0.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v0.16b
	aesmc	v19.16b, v19.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v1.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v1.16b
	aesmc	v19.16b, v19.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v2.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v2.16b
	aesmc	v19.16b, v19.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v3.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v3.16b
	aesmc	v19.16b, v19.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v4.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v4.16b
	aesmc	v19.16b, v19.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v5.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v5.16b
	aesmc	v19.16b, v19.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v6.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v6.16b
	aesmc	v19.16b, v19.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v7.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v7.16b
	aesmc	v19.16b, v19.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v8.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v8.16b
	aesmc	v19.16b, v19.16b
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v9.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v9.16b
	aesmc	v19.16b, v19.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v10.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v10.16b
	aesmc	v19.16b, v19.16b
	aese	v16.16b, v11.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v11.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v11.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v11.16b
	aesmc	v19.16b, v19.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v12.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v12.16b
	aesmc	v19.16b, v19.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v14.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v14.16b
	aese	v18.16b, v13.16b
	eor	v18.16b, v18.16b, v14.16b
	aese	v19.16b, v13.16b
	eor	v19.16b, v19.16b, v14.16b
	adds	x9, x9, #4
	eor	v24.16b, v24.16b, v16.16b
	adc	x10, x10, xzr
	eor	v25.16b, v25.16b, v17.16b
	adds	x11, x11, #4
	eor	v26.16b, v26.16b, v18.16b
	adc	x12, x12, xzr
	eor	v27.16b, v27.16b, v19.16b
	sub	w8, w8, #4
	st1	{v24.16b, v25.16b, v26.16b, v27.16b}, [x1], #0x40
	mov	v16.d[0], x10
	mov	v16.d[1], x9
L_aes_ctr_encrypt_arm64_crypto_256_start_2:
	cmp	w8, #2
	blt	L_aes_ctr_encrypt_arm64_crypto_256_start_1
	ld1	{v24.16b, v25.16b}, [x0], #32
	eor	v20.16b, v20.16b, v20.16b
	ext	v19.16b, v16.16b, v16.16b, #8
	movi	v18.16b, #1
	ext	v18.16b, v18.16b, v20.16b, #15
	add	v17.2d, v19.2d, v18.2d
	cmeq	v19.2d, v17.2d, #0
	ext	v19.16b, v20.16b, v19.16b, #8
	sub	v17.2d, v17.2d, v19.2d
	ext	v17.16b, v17.16b, v17.16b, #8
	rev64	v16.16b, v16.16b
	rev64	v17.16b, v17.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v16.16b, v11.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v11.16b
	aesmc	v17.16b, v17.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v14.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v14.16b
	adds	x9, x9, #2
	eor	v24.16b, v24.16b, v16.16b
	adc	x10, x10, xzr
	eor	v25.16b, v25.16b, v17.16b
	sub	w8, w8, #2
	st1	{v24.16b, v25.16b}, [x1], #32
	mov	v16.d[0], x10
	mov	v16.d[1], x9
L_aes_ctr_encrypt_arm64_crypto_256_start_1:
	cbz	w8, L_aes_ctr_encrypt_arm64_crypto_256_done
	ld1	{v24.16b}, [x0], #16
	rev64	v16.16b, v16.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v11.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v14.16b
	adds	x9, x9, #1
	eor	v24.16b, v24.16b, v16.16b
	adc	x10, x10, xzr
	st1	{v24.16b}, [x1], #16
L_aes_ctr_encrypt_arm64_crypto_256_done:
	cbz	w2, L_aes_ctr_encrypt_arm64_crypto_256_partial_done
	mov	v16.d[0], x10
	mov	v16.d[1], x9
	rev64	v16.16b, v16.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v11.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v14.16b
	adds	x9, x9, #1
	adc	x10, x10, xzr
	st1	{v16.2d}, [x5]
	mov	w13, #16
	sub	w13, w13, w2
L_aes_ctr_encrypt_arm64_crypto_256_start_byte:
	ldrb	w11, [x5], #1
	ldrb	w12, [x0], #1
	eor	w11, w11, w12
	subs	w2, w2, #1
	strb	w11, [x1], #1
	bgt	L_aes_ctr_encrypt_arm64_crypto_256_start_byte
	str	w13, [x6]
L_aes_ctr_encrypt_arm64_crypto_256_partial_done:
#endif /* !NO_AES_256 */
	b	L_aes_ctr_encrypt_arm64_crypto_done
	# AES_CTR_128
L_aes_ctr_encrypt_arm64_crypto_start_128:
#ifndef NO_AES_128
	ld1	{v8.2d, v9.2d}, [x4], #32
	ld1	{v10.2d}, [x4]
	cmp	w8, #1
	ble	L_aes_ctr_encrypt_arm64_crypto_128_start_1
	adds	x11, x9, #1
	adc	x12, x10, xzr
	cmp	w8, #8
	blt	L_aes_ctr_encrypt_arm64_crypto_128_start_4
	adds	x13, x9, #2
	adc	x14, x10, xzr
	adds	x15, x9, #3
	adc	x16, x10, xzr
L_aes_ctr_encrypt_arm64_crypto_128_start_8:
	ld1	{v24.16b, v25.16b, v26.16b, v27.16b}, [x0], #0x40
	ld1	{v28.16b, v29.16b, v30.16b, v31.16b}, [x0], #0x40
	mov	v17.d[0], x12
	mov	v17.d[1], x11
	mov	v18.d[0], x14
	mov	v18.d[1], x13
	adds	x17, x9, #4
	mov	v19.d[0], x16
	adc	x19, x10, xzr
	mov	v19.d[1], x15
	adds	x20, x9, #5
	mov	v20.d[0], x19
	adc	x21, x10, xzr
	mov	v20.d[1], x17
	adds	x22, x9, #6
	mov	v21.d[0], x21
	adc	x23, x10, xzr
	mov	v21.d[1], x20
	adds	x24, x9, #7
	mov	v22.d[0], x23
	adc	x25, x10, xzr
	mov	v22.d[1], x22
	mov	v23.d[0], x25
	mov	v23.d[1], x24
	rev64	v16.16b, v16.16b
	rev64	v17.16b, v17.16b
	rev64	v18.16b, v18.16b
	rev64	v19.16b, v19.16b
	rev64	v20.16b, v20.16b
	rev64	v21.16b, v21.16b
	rev64	v22.16b, v22.16b
	rev64	v23.16b, v23.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v0.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v0.16b
	aesmc	v19.16b, v19.16b
	aese	v20.16b, v0.16b
	aesmc	v20.16b, v20.16b
	aese	v21.16b, v0.16b
	aesmc	v21.16b, v21.16b
	aese	v22.16b, v0.16b
	aesmc	v22.16b, v22.16b
	aese	v23.16b, v0.16b
	aesmc	v23.16b, v23.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v1.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v1.16b
	aesmc	v19.16b, v19.16b
	aese	v20.16b, v1.16b
	aesmc	v20.16b, v20.16b
	aese	v21.16b, v1.16b
	aesmc	v21.16b, v21.16b
	aese	v22.16b, v1.16b
	aesmc	v22.16b, v22.16b
	aese	v23.16b, v1.16b
	aesmc	v23.16b, v23.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v2.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v2.16b
	aesmc	v19.16b, v19.16b
	aese	v20.16b, v2.16b
	aesmc	v20.16b, v20.16b
	aese	v21.16b, v2.16b
	aesmc	v21.16b, v21.16b
	aese	v22.16b, v2.16b
	aesmc	v22.16b, v22.16b
	aese	v23.16b, v2.16b
	aesmc	v23.16b, v23.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v3.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v3.16b
	aesmc	v19.16b, v19.16b
	aese	v20.16b, v3.16b
	aesmc	v20.16b, v20.16b
	aese	v21.16b, v3.16b
	aesmc	v21.16b, v21.16b
	aese	v22.16b, v3.16b
	aesmc	v22.16b, v22.16b
	aese	v23.16b, v3.16b
	aesmc	v23.16b, v23.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v4.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v4.16b
	aesmc	v19.16b, v19.16b
	aese	v20.16b, v4.16b
	aesmc	v20.16b, v20.16b
	aese	v21.16b, v4.16b
	aesmc	v21.16b, v21.16b
	aese	v22.16b, v4.16b
	aesmc	v22.16b, v22.16b
	aese	v23.16b, v4.16b
	aesmc	v23.16b, v23.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v5.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v5.16b
	aesmc	v19.16b, v19.16b
	aese	v20.16b, v5.16b
	aesmc	v20.16b, v20.16b
	aese	v21.16b, v5.16b
	aesmc	v21.16b, v21.16b
	aese	v22.16b, v5.16b
	aesmc	v22.16b, v22.16b
	aese	v23.16b, v5.16b
	aesmc	v23.16b, v23.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v6.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v6.16b
	aesmc	v19.16b, v19.16b
	aese	v20.16b, v6.16b
	aesmc	v20.16b, v20.16b
	aese	v21.16b, v6.16b
	aesmc	v21.16b, v21.16b
	aese	v22.16b, v6.16b
	aesmc	v22.16b, v22.16b
	aese	v23.16b, v6.16b
	aesmc	v23.16b, v23.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v7.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v7.16b
	aesmc	v19.16b, v19.16b
	aese	v20.16b, v7.16b
	aesmc	v20.16b, v20.16b
	aese	v21.16b, v7.16b
	aesmc	v21.16b, v21.16b
	aese	v22.16b, v7.16b
	aesmc	v22.16b, v22.16b
	aese	v23.16b, v7.16b
	aesmc	v23.16b, v23.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v8.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v8.16b
	aesmc	v19.16b, v19.16b
	aese	v20.16b, v8.16b
	aesmc	v20.16b, v20.16b
	aese	v21.16b, v8.16b
	aesmc	v21.16b, v21.16b
	aese	v22.16b, v8.16b
	aesmc	v22.16b, v22.16b
	aese	v23.16b, v8.16b
	aesmc	v23.16b, v23.16b
	aese	v16.16b, v9.16b
	eor	v16.16b, v16.16b, v10.16b
	aese	v17.16b, v9.16b
	eor	v17.16b, v17.16b, v10.16b
	aese	v18.16b, v9.16b
	eor	v18.16b, v18.16b, v10.16b
	aese	v19.16b, v9.16b
	eor	v19.16b, v19.16b, v10.16b
	aese	v20.16b, v9.16b
	eor	v20.16b, v20.16b, v10.16b
	aese	v21.16b, v9.16b
	eor	v21.16b, v21.16b, v10.16b
	aese	v22.16b, v9.16b
	eor	v22.16b, v22.16b, v10.16b
	aese	v23.16b, v9.16b
	eor	v23.16b, v23.16b, v10.16b
	adds	x9, x9, #8
	eor	v24.16b, v24.16b, v16.16b
	adc	x10, x10, xzr
	eor	v25.16b, v25.16b, v17.16b
	adds	x11, x11, #8
	eor	v26.16b, v26.16b, v18.16b
	adc	x12, x12, xzr
	eor	v27.16b, v27.16b, v19.16b
	adds	x13, x13, #8
	eor	v28.16b, v28.16b, v20.16b
	adc	x14, x14, xzr
	eor	v29.16b, v29.16b, v21.16b
	adds	x15, x15, #8
	eor	v30.16b, v30.16b, v22.16b
	adc	x16, x16, xzr
	eor	v31.16b, v31.16b, v23.16b
	sub	w8, w8, #8
	st1	{v24.16b, v25.16b, v26.16b, v27.16b}, [x1], #0x40
	st1	{v28.16b, v29.16b, v30.16b, v31.16b}, [x1], #0x40
	mov	v16.d[0], x10
	mov	v16.d[1], x9
	cmp	w8, #8
	bge	L_aes_ctr_encrypt_arm64_crypto_128_start_8
L_aes_ctr_encrypt_arm64_crypto_128_start_4:
	cmp	w8, #4
	blt	L_aes_ctr_encrypt_arm64_crypto_128_start_2
	ld1	{v24.16b, v25.16b, v26.16b, v27.16b}, [x0], #0x40
	adds	x13, x9, #2
	mov	v17.d[0], x12
	adc	x14, x10, xzr
	mov	v17.d[1], x11
	adds	x15, x9, #3
	mov	v18.d[0], x14
	adc	x16, x10, xzr
	mov	v18.d[1], x13
	mov	v19.d[0], x16
	mov	v19.d[1], x15
	rev64	v16.16b, v16.16b
	rev64	v17.16b, v17.16b
	rev64	v18.16b, v18.16b
	rev64	v19.16b, v19.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v0.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v0.16b
	aesmc	v19.16b, v19.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v1.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v1.16b
	aesmc	v19.16b, v19.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v2.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v2.16b
	aesmc	v19.16b, v19.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v3.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v3.16b
	aesmc	v19.16b, v19.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v4.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v4.16b
	aesmc	v19.16b, v19.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v5.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v5.16b
	aesmc	v19.16b, v19.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v6.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v6.16b
	aesmc	v19.16b, v19.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v7.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v7.16b
	aesmc	v19.16b, v19.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v18.16b, v8.16b
	aesmc	v18.16b, v18.16b
	aese	v19.16b, v8.16b
	aesmc	v19.16b, v19.16b
	aese	v16.16b, v9.16b
	eor	v16.16b, v16.16b, v10.16b
	aese	v17.16b, v9.16b
	eor	v17.16b, v17.16b, v10.16b
	aese	v18.16b, v9.16b
	eor	v18.16b, v18.16b, v10.16b
	aese	v19.16b, v9.16b
	eor	v19.16b, v19.16b, v10.16b
	adds	x9, x9, #4
	eor	v24.16b, v24.16b, v16.16b
	adc	x10, x10, xzr
	eor	v25.16b, v25.16b, v17.16b
	adds	x11, x11, #4
	eor	v26.16b, v26.16b, v18.16b
	adc	x12, x12, xzr
	eor	v27.16b, v27.16b, v19.16b
	sub	w8, w8, #4
	st1	{v24.16b, v25.16b, v26.16b, v27.16b}, [x1], #0x40
	mov	v16.d[0], x10
	mov	v16.d[1], x9
L_aes_ctr_encrypt_arm64_crypto_128_start_2:
	cmp	w8, #2
	blt	L_aes_ctr_encrypt_arm64_crypto_128_start_1
	ld1	{v24.16b, v25.16b}, [x0], #32
	eor	v20.16b, v20.16b, v20.16b
	ext	v19.16b, v16.16b, v16.16b, #8
	movi	v18.16b, #1
	ext	v18.16b, v18.16b, v20.16b, #15
	add	v17.2d, v19.2d, v18.2d
	cmeq	v19.2d, v17.2d, #0
	ext	v19.16b, v20.16b, v19.16b, #8
	sub	v17.2d, v17.2d, v19.2d
	ext	v17.16b, v17.16b, v17.16b, #8
	rev64	v16.16b, v16.16b
	rev64	v17.16b, v17.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v16.16b, v9.16b
	eor	v16.16b, v16.16b, v10.16b
	aese	v17.16b, v9.16b
	eor	v17.16b, v17.16b, v10.16b
	adds	x9, x9, #2
	eor	v24.16b, v24.16b, v16.16b
	adc	x10, x10, xzr
	eor	v25.16b, v25.16b, v17.16b
	sub	w8, w8, #2
	st1	{v24.16b, v25.16b}, [x1], #32
	mov	v16.d[0], x10
	mov	v16.d[1], x9
L_aes_ctr_encrypt_arm64_crypto_128_start_1:
	cbz	w8, L_aes_ctr_encrypt_arm64_crypto_128_done
	ld1	{v24.16b}, [x0], #16
	rev64	v16.16b, v16.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v9.16b
	eor	v16.16b, v16.16b, v10.16b
	adds	x9, x9, #1
	eor	v24.16b, v24.16b, v16.16b
	adc	x10, x10, xzr
	st1	{v24.16b}, [x1], #16
L_aes_ctr_encrypt_arm64_crypto_128_done:
	cbz	w2, L_aes_ctr_encrypt_arm64_crypto_128_partial_done
	mov	v16.d[0], x10
	mov	v16.d[1], x9
	rev64	v16.16b, v16.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v16.16b, v9.16b
	eor	v16.16b, v16.16b, v10.16b
	adds	x9, x9, #1
	adc	x10, x10, xzr
	st1	{v16.2d}, [x5]
	mov	w13, #16
	sub	w13, w13, w2
L_aes_ctr_encrypt_arm64_crypto_128_start_byte:
	ldrb	w11, [x5], #1
	ldrb	w12, [x0], #1
	eor	w11, w11, w12
	subs	w2, w2, #1
	strb	w11, [x1], #1
	bgt	L_aes_ctr_encrypt_arm64_crypto_128_start_byte
	str	w13, [x6]
L_aes_ctr_encrypt_arm64_crypto_128_partial_done:
#endif /* !NO_AES_128 */
L_aes_ctr_encrypt_arm64_crypto_done:
	rev	x11, x10
	rev	x12, x9
	stp	x11, x12, [x3]
	ldp	x17, x19, [x29, #16]
	ldp	x20, x21, [x29, #32]
	ldp	x22, x23, [x29, #48]
	ldp	x24, x25, [x29, #64]
	ldp	d8, d9, [x29, #80]
	ldp	d10, d11, [x29, #96]
	ldp	d12, d13, [x29, #112]
	ldp	d14, d15, [x29, #128]
	ldp	x29, x30, [sp], #0x90
	ret
#ifndef __APPLE__
	.size	AES_CTR_encrypt_AARCH64,.-AES_CTR_encrypt_AARCH64
#endif /* __APPLE__ */
#endif /* WOLFSSL_AES_COUNTER */
#ifdef HAVE_AESGCM
#ifndef __APPLE__
.text
.globl	AES_GCM_set_key_AARCH64
.type	AES_GCM_set_key_AARCH64,@function
.align	2
AES_GCM_set_key_AARCH64:
#else
.section	__TEXT,__text
.globl	_AES_GCM_set_key_AARCH64
.p2align	2
_AES_GCM_set_key_AARCH64:
#endif /* __APPLE__ */
	ld1	{v0.16b}, [x0]
	ld1	{v1.2d, v2.2d, v3.2d, v4.2d}, [x1], #0x40
	aese	v0.16b, v1.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v2.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v3.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v4.16b
	aesmc	v0.16b, v0.16b
	ld1	{v1.2d, v2.2d, v3.2d, v4.2d}, [x1], #0x40
	aese	v0.16b, v1.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v2.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v3.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v4.16b
	aesmc	v0.16b, v0.16b
	subs	w3, w3, #10
	ld1	{v1.2d, v2.2d}, [x1], #32
	aese	v0.16b, v1.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v2.16b
	beq	L_aes_gcm_set_key_arm64_crypto_round_done
	ld1	{v1.2d, v2.2d}, [x1], #32
	subs	w3, w3, #2
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v1.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v2.16b
	beq	L_aes_gcm_set_key_arm64_crypto_round_done
	ld1	{v1.2d, v2.2d}, [x1], #32
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v1.16b
	aesmc	v0.16b, v0.16b
	aese	v0.16b, v2.16b
L_aes_gcm_set_key_arm64_crypto_round_done:
	ld1	{v1.2d}, [x1]
	eor	v0.16b, v0.16b, v1.16b
	rbit	v0.16b, v0.16b
	st1	{v0.2d}, [x2]
	ret
#ifndef __APPLE__
	.size	AES_GCM_set_key_AARCH64,.-AES_GCM_set_key_AARCH64
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	AES_GCM_encrypt_AARCH64
.type	AES_GCM_encrypt_AARCH64,@function
.align	2
AES_GCM_encrypt_AARCH64:
#else
.section	__TEXT,__text
.globl	_AES_GCM_encrypt_AARCH64
.p2align	2
_AES_GCM_encrypt_AARCH64:
#endif /* __APPLE__ */
	stp	x29, x30, [sp, #-144]!
	add	x29, sp, #0
	stp	x17, x19, [x29, #24]
	stp	x20, x21, [x29, #40]
	stp	x22, x23, [x29, #56]
	str	x24, [x29, #72]
	stp	d8, d9, [x29, #80]
	stp	d10, d11, [x29, #96]
	stp	d12, d13, [x29, #112]
	stp	d14, d15, [x29, #128]
	ldr	w8, [x29, #144]
	ldr	x9, [x29, #152]
	ldr	x10, [x29, #160]
	ldr	x11, [x29, #168]
	ldr	x12, [x29, #176]
	ldr	w13, [x29, #184]
	movi	v27.16b, #0x87
	eor	v26.16b, v26.16b, v26.16b
	ushr	v27.2d, v27.2d, #56
	ld1	{v22.2d}, [x10]
	cmp	w8, #0x40
	csetm	x16, lt
	cmp	w2, #32
	csetm	x17, lt
	ands	x16, x16, x17
	bne	L_aes_gcm_encrypt_arm64_crypto_h_done
	# Square H => H^2
	pmull2	v31.1q, v22.2d, v22.2d
	pmull	v30.1q, v22.1d, v22.1d
	pmull2	v28.1q, v31.2d, v27.2d
	ext	v29.16b, v30.16b, v31.16b, #8
	eor	v29.16b, v29.16b, v28.16b
	pmull2	v31.1q, v29.2d, v27.2d
	mov	v30.d[1], v29.d[0]
	eor	v23.16b, v30.16b, v31.16b
	cmp	w8, #0x100
	csetm	x16, lt
	cmp	w2, #0x40
	csetm	x17, lt
	ands	x16, x16, x17
	bne	L_aes_gcm_encrypt_arm64_crypto_h_done
	# Multiply H and H^2  => H^3
	pmull	v28.1q, v22.1d, v23.1d
	pmull2	v29.1q, v22.2d, v23.2d
	ext	v31.16b, v22.16b, v22.16b, #8
	pmull	v30.1q, v31.1d, v23.1d
	pmull2	v31.1q, v31.2d, v23.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v24.16b, v28.16b, v30.16b
	# Square H^2 => H^4
	pmull2	v31.1q, v23.2d, v23.2d
	pmull	v30.1q, v23.1d, v23.1d
	pmull2	v28.1q, v31.2d, v27.2d
	ext	v29.16b, v30.16b, v31.16b, #8
	eor	v29.16b, v29.16b, v28.16b
	pmull2	v31.1q, v29.2d, v27.2d
	mov	v30.d[1], v29.d[0]
	eor	v25.16b, v30.16b, v31.16b
	# Done
	cmp	w8, #0x400
	csetm	x16, lt
	cmp	w2, #0x200
	csetm	x17, lt
	ands	x16, x16, x17
	bne	L_aes_gcm_encrypt_arm64_crypto_h_done
	# Multiply H and H^4  => H^5
	pmull	v28.1q, v22.1d, v25.1d
	pmull2	v29.1q, v22.2d, v25.2d
	ext	v31.16b, v22.16b, v22.16b, #8
	pmull	v30.1q, v31.1d, v25.1d
	pmull2	v31.1q, v31.2d, v25.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v4.16b, v28.16b, v30.16b
	# Square H^3 => H^6
	pmull2	v31.1q, v24.2d, v24.2d
	pmull	v30.1q, v24.1d, v24.1d
	pmull2	v28.1q, v31.2d, v27.2d
	ext	v29.16b, v30.16b, v31.16b, #8
	eor	v29.16b, v29.16b, v28.16b
	pmull2	v31.1q, v29.2d, v27.2d
	mov	v30.d[1], v29.d[0]
	eor	v5.16b, v30.16b, v31.16b
	# Multiply H and H^6  => H^7
	pmull	v28.1q, v22.1d, v5.1d
	pmull2	v29.1q, v22.2d, v5.2d
	ext	v31.16b, v22.16b, v22.16b, #8
	pmull	v30.1q, v31.1d, v5.1d
	pmull2	v31.1q, v31.2d, v5.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v6.16b, v28.16b, v30.16b
	# Square H^4 => H^8
	pmull2	v31.1q, v25.2d, v25.2d
	pmull	v30.1q, v25.1d, v25.1d
	pmull2	v28.1q, v31.2d, v27.2d
	ext	v29.16b, v30.16b, v31.16b, #8
	eor	v29.16b, v29.16b, v28.16b
	pmull2	v31.1q, v29.2d, v27.2d
	mov	v30.d[1], v29.d[0]
	eor	v7.16b, v30.16b, v31.16b
	# Done
L_aes_gcm_encrypt_arm64_crypto_h_done:
	lsr	w14, w8, #4
	cmp	w14, #4
	blt	L_aes_gcm_encrypt_arm64_crypto_aad_start_1
	cmp	w14, #16
	blt	L_aes_gcm_encrypt_arm64_crypto_aad_start_2
	cmp	w14, #0x40
	blt	L_aes_gcm_encrypt_arm64_crypto_aad_start_4
L_aes_gcm_encrypt_arm64_crypto_aad_start_8:
	ld1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x7], #0x40
	ld1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x7], #0x40
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	rbit	v0.16b, v0.16b
	rbit	v1.16b, v1.16b
	rbit	v2.16b, v2.16b
	rbit	v3.16b, v3.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	ext	v31.16b, v3.16b, v3.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	sub	w14, w14, #8
	cmp	w14, #8
	bge	L_aes_gcm_encrypt_arm64_crypto_aad_start_8
	cmp	w14, #1
	blt	L_aes_gcm_encrypt_arm64_crypto_aad_done
	beq	L_aes_gcm_encrypt_arm64_crypto_aad_start_1
	cmp	w14, #16
	blt	L_aes_gcm_encrypt_arm64_crypto_aad_start_2
L_aes_gcm_encrypt_arm64_crypto_aad_start_4:
	ld1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x7], #0x40
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	sub	w14, w14, #4
	cmp	w14, #4
	bge	L_aes_gcm_encrypt_arm64_crypto_aad_start_4
	cmp	w14, #1
	blt	L_aes_gcm_encrypt_arm64_crypto_aad_done
	beq	L_aes_gcm_encrypt_arm64_crypto_aad_start_1
L_aes_gcm_encrypt_arm64_crypto_aad_start_2:
	ld1	{v18.16b, v19.16b}, [x7], #32
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v19.1d, v22.1d
	pmull2	v29.1q, v19.2d, v22.2d
	ext	v31.16b, v19.16b, v19.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v21.1d
	pmull2	v26.1q, v23.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	sub	w14, w14, #2
	cmp	w14, #1
	bgt	L_aes_gcm_encrypt_arm64_crypto_aad_start_2
	blt	L_aes_gcm_encrypt_arm64_crypto_aad_done
L_aes_gcm_encrypt_arm64_crypto_aad_start_1:
	cbz	w14, L_aes_gcm_encrypt_arm64_crypto_aad_done
L_aes_gcm_encrypt_arm64_crypto_aad_both_1:
	ld1	{v18.16b}, [x7], #16
	rbit	v18.16b, v18.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	subs	w14, w14, #1
	bne	L_aes_gcm_encrypt_arm64_crypto_aad_both_1
L_aes_gcm_encrypt_arm64_crypto_aad_done:
	and	w14, w8, #15
	cbz	w14, L_aes_gcm_encrypt_arm64_crypto_aad_partial_done
	eor	v28.16b, v28.16b, v28.16b
	mov	w20, w14
	st1	{v28.2d}, [x11]
	cmp	w20, #8
	blt	L_aes_gcm_encrypt_arm64_crypto_aad_start_dw
	ldr	x19, [x7], #8
	sub	w20, w20, #8
	str	x19, [x11], #8
L_aes_gcm_encrypt_arm64_crypto_aad_start_dw:
	cmp	w20, #4
	blt	L_aes_gcm_encrypt_arm64_crypto_aad_start_sw
	ldr	w19, [x7], #4
	sub	w20, w20, #4
	str	w19, [x11], #4
L_aes_gcm_encrypt_arm64_crypto_aad_start_sw:
	cmp	w20, #2
	blt	L_aes_gcm_encrypt_arm64_crypto_aad_start_byte
	ldrh	w19, [x7], #2
	sub	w20, w20, #2
	strh	w19, [x11], #2
L_aes_gcm_encrypt_arm64_crypto_aad_start_byte:
	cbz	w20, L_aes_gcm_encrypt_arm64_crypto_aad_end_bytes
	ldrb	w19, [x7], #1
	subs	w20, w20, #1
	strb	w19, [x11], #1
	bne	L_aes_gcm_encrypt_arm64_crypto_aad_start_byte
L_aes_gcm_encrypt_arm64_crypto_aad_end_bytes:
	sub	x11, x11, x14
	ld1	{v18.2d}, [x11]
	rbit	v18.16b, v18.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_encrypt_arm64_crypto_aad_partial_done:
	# Load Nonce
	cmp	w4, #12
	bne	L_aes_gcm_encrypt_arm64_crypto_ghash_nonce
	ldr	x16, [x3]
	movi	v13.4s, #1, lsl 24
	ldr	w17, [x3, #8]
	mov	v13.d[0], x16
	mov	v13.s[2], w17
	mov	w15, #1
	b	L_aes_gcm_encrypt_arm64_crypto_done_nonce
L_aes_gcm_encrypt_arm64_crypto_ghash_nonce:
	eor	v13.16b, v13.16b, v13.16b
	lsr	w14, w4, #4
	cbz	w14, L_aes_gcm_encrypt_arm64_crypto_nonce_done
L_aes_gcm_encrypt_arm64_crypto_nonce_start_1:
	ld1	{v18.16b}, [x3], #16
	rbit	v18.16b, v18.16b
	eor	v21.16b, v13.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v13.16b, v28.16b, v30.16b
	# Done GHASH
	subs	w14, w14, #1
	bne	L_aes_gcm_encrypt_arm64_crypto_nonce_start_1
L_aes_gcm_encrypt_arm64_crypto_nonce_done:
	and	w24, w4, #15
	cbz	x24, L_aes_gcm_encrypt_arm64_crypto_nonce_partial_done
	eor	v28.16b, v28.16b, v28.16b
	mov	w20, w24
	st1	{v28.2d}, [x11]
	cmp	w20, #8
	blt	L_aes_gcm_encrypt_arm64_crypto_nonce_start_dw
	ldr	x19, [x3], #8
	sub	w20, w20, #8
	str	x19, [x11], #8
L_aes_gcm_encrypt_arm64_crypto_nonce_start_dw:
	cmp	w20, #4
	blt	L_aes_gcm_encrypt_arm64_crypto_nonce_start_sw
	ldr	w19, [x3], #4
	sub	w20, w20, #4
	str	w19, [x11], #4
L_aes_gcm_encrypt_arm64_crypto_nonce_start_sw:
	cmp	w20, #2
	blt	L_aes_gcm_encrypt_arm64_crypto_nonce_start_byte
	ldrh	w19, [x3], #2
	sub	w20, w20, #2
	strh	w19, [x11], #2
L_aes_gcm_encrypt_arm64_crypto_nonce_start_byte:
	cbz	w20, L_aes_gcm_encrypt_arm64_crypto_nonce_end_bytes
	ldrb	w19, [x3], #1
	subs	w20, w20, #1
	strb	w19, [x11], #1
	bne	L_aes_gcm_encrypt_arm64_crypto_nonce_start_byte
L_aes_gcm_encrypt_arm64_crypto_nonce_end_bytes:
	sub	x11, x11, x24
	ld1	{v18.2d}, [x11]
	rbit	v18.16b, v18.16b
	eor	v21.16b, v13.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v13.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_encrypt_arm64_crypto_nonce_partial_done:
	eor	x14, x14, x14
	lsl	x24, x4, #3
	mov	v28.d[0], x14
	mov	v28.d[1], x24
	rev64	v28.16b, v28.16b
	rbit	v28.16b, v28.16b
	eor	v13.16b, v13.16b, v28.16b
	pmull	v28.1q, v13.1d, v22.1d
	pmull2	v29.1q, v13.2d, v22.2d
	ext	v31.16b, v13.16b, v13.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v13.16b, v28.16b, v30.16b
	rbit	v13.16b, v13.16b
	mov	w15, v13.s[3]
	rev	w15, w15
L_aes_gcm_encrypt_arm64_crypto_done_nonce:
	st1	{v13.2d}, [x12]
	lsr	w14, w2, #4
	cmp	w13, #12
	blt	L_aes_gcm_encrypt_arm64_crypto_start_128
	bgt	L_aes_gcm_encrypt_arm64_crypto_start_256
	# AES_GCM_192
#ifndef NO_AES_192
	cmp	w14, #32
	blt	L_aes_gcm_encrypt_arm64_crypto_192_start_4
L_aes_gcm_encrypt_arm64_crypto_192_start_8:
	ldr	q12, [x9]
	add	w24, w15, #1
	mov	v14.16b, v13.16b
	add	w23, w15, #2
	mov	v15.16b, v13.16b
	add	w22, w15, #3
	mov	v16.16b, v13.16b
	add	w21, w15, #4
	mov	v17.16b, v13.16b
	add	w20, w15, #5
	mov	v8.16b, v13.16b
	add	w19, w15, #6
	mov	v9.16b, v13.16b
	add	w17, w15, #7
	mov	v10.16b, v13.16b
	add	w15, w15, #8
	mov	v11.16b, v13.16b
	rev	w24, w24
	rev	w23, w23
	rev	w22, w22
	rev	w21, w21
	rev	w20, w20
	rev	w19, w19
	rev	w17, w17
	rev	w16, w15
	mov	v14.s[3], w24
	mov	v15.s[3], w23
	mov	v16.s[3], w22
	mov	v17.s[3], w21
	mov	v8.s[3], w20
	mov	v9.s[3], w19
	mov	v10.s[3], w17
	mov	v11.s[3], w16
	ldr	q13, [x9, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w14, w14, #8
	ldr	q12, [x9, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b}, [x0], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v19.16b}, [x0], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v20.16b}, [x0], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ld1	{v21.16b}, [x0], #16
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #160]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	ld1	{v0.16b}, [x0], #16
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ld1	{v1.16b}, [x0], #16
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v2.16b}, [x0], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ld1	{v3.16b}, [x0], #16
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #176]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #192]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	eor	v0.16b, v0.16b, v8.16b
	eor	v1.16b, v1.16b, v9.16b
	eor	v2.16b, v2.16b, v10.16b
	eor	v3.16b, v3.16b, v11.16b
	ld1	{v13.2d}, [x12]
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x1], #0x40
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x1], #0x40
	cmp	w14, #8
	blt	L_aes_gcm_encrypt_arm64_crypto_192_end_8
L_aes_gcm_encrypt_arm64_crypto_192_both_8:
	ldr	q12, [x9]
	add	w24, w15, #1
	mov	v14.16b, v13.16b
	add	w23, w15, #2
	mov	v15.16b, v13.16b
	add	w22, w15, #3
	mov	v16.16b, v13.16b
	add	w21, w15, #4
	mov	v17.16b, v13.16b
	add	w20, w15, #5
	mov	v8.16b, v13.16b
	add	w19, w15, #6
	mov	v9.16b, v13.16b
	add	w17, w15, #7
	mov	v10.16b, v13.16b
	add	w15, w15, #8
	mov	v11.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w24, w24
	rbit	v19.16b, v19.16b
	rev	w23, w23
	rbit	v20.16b, v20.16b
	rev	w22, w22
	rbit	v21.16b, v21.16b
	rev	w21, w21
	rbit	v0.16b, v0.16b
	rev	w20, w20
	rbit	v1.16b, v1.16b
	rev	w19, w19
	rbit	v2.16b, v2.16b
	rev	w17, w17
	rbit	v3.16b, v3.16b
	rev	w16, w15
	mov	v14.s[3], w24
	mov	v15.s[3], w23
	mov	v16.s[3], w22
	mov	v17.s[3], w21
	mov	v8.s[3], w20
	mov	v9.s[3], w19
	mov	v10.s[3], w17
	mov	v11.s[3], w16
	ldr	q13, [x9, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v18.16b, v18.16b, v26.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ext	v31.16b, v3.16b, v3.16b, #8
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w14, w14, #8
	ldr	q12, [x9, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v29.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	mov	v28.d[1], v31.d[0]
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v18.16b}, [x0], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ld1	{v19.16b}, [x0], #16
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ld1	{v20.16b}, [x0], #16
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ld1	{v21.16b}, [x0], #16
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v0.16b}, [x0], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v1.16b}, [x0], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v2.16b}, [x0], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ld1	{v3.16b}, [x0], #16
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #160]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #176]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #192]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	ld1	{v13.2d}, [x12]
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x1], #0x40
	eor	v0.16b, v0.16b, v8.16b
	eor	v1.16b, v1.16b, v9.16b
	eor	v2.16b, v2.16b, v10.16b
	eor	v3.16b, v3.16b, v11.16b
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x1], #0x40
	cmp	w14, #8
	bge	L_aes_gcm_encrypt_arm64_crypto_192_both_8
L_aes_gcm_encrypt_arm64_crypto_192_end_8:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	rbit	v0.16b, v0.16b
	rbit	v1.16b, v1.16b
	rbit	v2.16b, v2.16b
	rbit	v3.16b, v3.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	ext	v31.16b, v3.16b, v3.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_encrypt_arm64_crypto_192_start_4:
	ld1	{v0.2d, v1.2d, v2.2d, v3.2d}, [x9], #0x40
	ld1	{v4.2d, v5.2d, v6.2d, v7.2d}, [x9], #0x40
	ld1	{v8.2d, v9.2d, v10.2d, v11.2d}, [x9], #0x40
	ld1	{v12.2d}, [x9]
	cmp	w14, #1
	blt	L_aes_gcm_encrypt_arm64_crypto_192_done
	beq	L_aes_gcm_encrypt_arm64_crypto_192_start_1
	cmp	w14, #4
	blt	L_aes_gcm_encrypt_arm64_crypto_192_start_2
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w19, w15, #2
	mov	v15.16b, v13.16b
	add	w17, w15, #3
	mov	v16.16b, v13.16b
	add	w15, w15, #4
	mov	v17.16b, v13.16b
	rev	w20, w20
	rev	w19, w19
	rev	w17, w17
	rev	w16, w15
	mov	v14.s[3], w20
	mov	v15.s[3], w19
	mov	v16.s[3], w17
	mov	v17.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w14, w14, #4
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x0], #16
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	ld1	{v19.16b}, [x0], #16
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	ld1	{v20.16b}, [x0], #16
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	ld1	{v21.16b}, [x0], #16
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v11.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v11.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v11.16b
	eor	v17.16b, v17.16b, v12.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	cmp	w14, #4
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x1], #0x40
	blt	L_aes_gcm_encrypt_arm64_crypto_192_end_4
L_aes_gcm_encrypt_arm64_crypto_192_both_4:
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w19, w15, #2
	mov	v15.16b, v13.16b
	add	w17, w15, #3
	mov	v16.16b, v13.16b
	add	w15, w15, #4
	mov	v17.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w20, w20
	rev	w19, w19
	rev	w17, w17
	rbit	v19.16b, v19.16b
	rev	w16, w15
	mov	v14.s[3], w20
	mov	v15.s[3], w19
	mov	v16.s[3], w17
	mov	v17.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	rbit	v20.16b, v20.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	rbit	v21.16b, v21.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	eor	v18.16b, v18.16b, v26.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	ext	v31.16b, v21.16b, v21.16b, #8
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w14, w14, #4
	eor	v31.16b, v31.16b, v29.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	mov	v28.d[1], v31.d[0]
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x0], #0x40
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v11.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v11.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v11.16b
	eor	v17.16b, v17.16b, v12.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	cmp	w14, #4
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x1], #0x40
	bge	L_aes_gcm_encrypt_arm64_crypto_192_both_4
L_aes_gcm_encrypt_arm64_crypto_192_end_4:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cmp	w14, #1
	beq	L_aes_gcm_encrypt_arm64_crypto_192_start_1
	blt	L_aes_gcm_encrypt_arm64_crypto_192_done
L_aes_gcm_encrypt_arm64_crypto_192_start_2:
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w15, w15, #2
	mov	v15.16b, v13.16b
	rev	w20, w20
	rev	w16, w15
	mov	v14.s[3], w20
	mov	v15.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	subs	w14, w14, #2
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x0], #16
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	ld1	{v19.16b}, [x0], #16
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v11.16b
	eor	v15.16b, v15.16b, v12.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	st1	{v18.16b, v19.16b}, [x1], #32
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v19.1d, v22.1d
	pmull2	v29.1q, v19.2d, v22.2d
	ext	v31.16b, v19.16b, v19.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v21.1d
	pmull2	v26.1q, v23.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cbz	w14, L_aes_gcm_encrypt_arm64_crypto_192_done
L_aes_gcm_encrypt_arm64_crypto_192_start_1:
	add	w15, w15, #1
	mov	v14.16b, v13.16b
	rev	w16, w15
	mov	v14.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x0], #16
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	eor	v18.16b, v18.16b, v14.16b
	st1	{v18.16b}, [x1], #16
	rbit	v18.16b, v18.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_encrypt_arm64_crypto_192_done:
	ands	w14, w2, #15
	beq	L_aes_gcm_encrypt_arm64_crypto_192_partial_done
	eor	v16.16b, v16.16b, v16.16b
	mov	w19, w14
	st1	{v16.2d}, [x11]
	cmp	x19, #8
	blt	L_aes_gcm_encrypt_arm64_crypto_192_start_dw
	ldr	x17, [x0], #8
	sub	x19, x19, #8
	str	x17, [x11], #8
L_aes_gcm_encrypt_arm64_crypto_192_start_dw:
	cmp	x19, #4
	blt	L_aes_gcm_encrypt_arm64_crypto_192_start_sw
	ldr	w17, [x0], #4
	sub	x19, x19, #4
	str	w17, [x11], #4
L_aes_gcm_encrypt_arm64_crypto_192_start_sw:
	cmp	x19, #2
	blt	L_aes_gcm_encrypt_arm64_crypto_192_start_byte
	ldrh	w17, [x0], #2
	sub	x19, x19, #2
	strh	w17, [x11], #2
L_aes_gcm_encrypt_arm64_crypto_192_start_byte:
	cbz	x19, L_aes_gcm_encrypt_arm64_crypto_192_end_bytes
	ldrb	w17, [x0], #1
	subs	x19, x19, #1
	strb	w17, [x11], #1
	bne	L_aes_gcm_encrypt_arm64_crypto_192_start_byte
L_aes_gcm_encrypt_arm64_crypto_192_end_bytes:
	sub	x11, x11, x14
	ld1	{v16.2d}, [x11]
	add	w15, w15, #1
	mov	v14.16b, v13.16b
	rev	w16, w15
	mov	v14.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	eor	v16.16b, v16.16b, v14.16b
	st1	{v16.2d}, [x11]
	mov	w19, w14
	cmp	x19, #8
	blt	L_aes_gcm_encrypt_arm64_crypto_192_out_start_dw
	ldr	x17, [x11], #8
	sub	x19, x19, #8
	str	x17, [x1], #8
L_aes_gcm_encrypt_arm64_crypto_192_out_start_dw:
	cmp	x19, #4
	blt	L_aes_gcm_encrypt_arm64_crypto_192_out_start_sw
	ldr	w17, [x11], #4
	sub	x19, x19, #4
	str	w17, [x1], #4
L_aes_gcm_encrypt_arm64_crypto_192_out_start_sw:
	cmp	x19, #2
	blt	L_aes_gcm_encrypt_arm64_crypto_192_out_start_byte
	ldrh	w17, [x11], #2
	sub	x19, x19, #2
	strh	w17, [x1], #2
L_aes_gcm_encrypt_arm64_crypto_192_out_start_byte:
	cbz	x19, L_aes_gcm_encrypt_arm64_crypto_192_out_end_bytes
	ldrb	w17, [x11], #1
	subs	x19, x19, #1
	strb	w17, [x1], #1
	bne	L_aes_gcm_encrypt_arm64_crypto_192_out_start_byte
L_aes_gcm_encrypt_arm64_crypto_192_out_end_bytes:
	mov	x17, #16
	sub	x17, x17, x14
L_aes_gcm_encrypt_arm64_crypto_192_start_zero:
	subs	x17, x17, #1
	strb	wzr, [x11], #1
	bne	L_aes_gcm_encrypt_arm64_crypto_192_start_zero
	sub	x11, x11, #16
	ld1	{v14.2d}, [x11]
	rbit	v14.16b, v14.16b
	eor	v15.16b, v26.16b, v14.16b
	#   X  = C * H^1
	pmull	v28.1q, v15.1d, v22.1d
	pmull2	v29.1q, v15.2d, v22.2d
	ext	v31.16b, v15.16b, v15.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_encrypt_arm64_crypto_192_partial_done:
	ld1	{v14.2d}, [x12]
	lsl	x8, x8, #3
	rbit	x8, x8
	mov	v28.d[0], x8
	lsl	x2, x2, #3
	rbit	x2, x2
	mov	v28.d[1], x2
	eor	v26.16b, v26.16b, v28.16b
	pmull	v28.1q, v26.1d, v22.1d
	pmull2	v29.1q, v26.2d, v22.2d
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	ext	v31.16b, v26.16b, v26.16b, #8
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v29.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	mov	v28.d[1], v31.d[0]
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v28.16b, v30.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	rbit	v26.16b, v26.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	eor	v26.16b, v26.16b, v14.16b
	cmp	w6, #16
	bne	L_aes_gcm_encrypt_arm64_crypto_192_tag_partial
	st1	{v26.16b}, [x5]
	b	L_aes_gcm_encrypt_arm64_crypto_done
L_aes_gcm_encrypt_arm64_crypto_192_tag_partial:
	st1	{v26.16b}, [x11]
	cmp	w6, #8
	blt	L_aes_gcm_encrypt_arm64_crypto_192_tag_start_dw
	ldr	x16, [x11], #8
	sub	w6, w6, #8
	str	x16, [x5], #8
L_aes_gcm_encrypt_arm64_crypto_192_tag_start_dw:
	cmp	w6, #4
	blt	L_aes_gcm_encrypt_arm64_crypto_192_tag_start_sw
	ldr	w16, [x11], #4
	sub	w6, w6, #4
	str	w16, [x5], #4
L_aes_gcm_encrypt_arm64_crypto_192_tag_start_sw:
	cmp	w6, #2
	blt	L_aes_gcm_encrypt_arm64_crypto_192_tag_start_byte
	ldrh	w16, [x11], #2
	sub	w6, w6, #2
	strh	w16, [x5], #2
L_aes_gcm_encrypt_arm64_crypto_192_tag_start_byte:
	cbz	w6, L_aes_gcm_encrypt_arm64_crypto_192_tag_end_bytes
	ldrb	w16, [x11], #1
	subs	w6, w6, #1
	strb	w16, [x5], #1
	bne	L_aes_gcm_encrypt_arm64_crypto_192_tag_start_byte
L_aes_gcm_encrypt_arm64_crypto_192_tag_end_bytes:
#endif /* !NO_AES_192 */
	b	L_aes_gcm_encrypt_arm64_crypto_done
	# AES_GCM_256
L_aes_gcm_encrypt_arm64_crypto_start_256:
#ifndef NO_AES_256
	cmp	w14, #32
	blt	L_aes_gcm_encrypt_arm64_crypto_256_start_4
L_aes_gcm_encrypt_arm64_crypto_256_start_8:
	ldr	q12, [x9]
	add	w24, w15, #1
	mov	v14.16b, v13.16b
	add	w23, w15, #2
	mov	v15.16b, v13.16b
	add	w22, w15, #3
	mov	v16.16b, v13.16b
	add	w21, w15, #4
	mov	v17.16b, v13.16b
	add	w20, w15, #5
	mov	v8.16b, v13.16b
	add	w19, w15, #6
	mov	v9.16b, v13.16b
	add	w17, w15, #7
	mov	v10.16b, v13.16b
	add	w15, w15, #8
	mov	v11.16b, v13.16b
	rev	w24, w24
	rev	w23, w23
	rev	w22, w22
	rev	w21, w21
	rev	w20, w20
	rev	w19, w19
	rev	w17, w17
	rev	w16, w15
	mov	v14.s[3], w24
	mov	v15.s[3], w23
	mov	v16.s[3], w22
	mov	v17.s[3], w21
	mov	v8.s[3], w20
	mov	v9.s[3], w19
	mov	v10.s[3], w17
	mov	v11.s[3], w16
	ldr	q13, [x9, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w14, w14, #8
	ldr	q12, [x9, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b}, [x0], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v19.16b}, [x0], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v20.16b}, [x0], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ld1	{v21.16b}, [x0], #16
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #160]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	ld1	{v0.16b}, [x0], #16
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ld1	{v1.16b}, [x0], #16
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v2.16b}, [x0], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ld1	{v3.16b}, [x0], #16
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #176]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #192]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #208]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #224]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	eor	v0.16b, v0.16b, v8.16b
	eor	v1.16b, v1.16b, v9.16b
	eor	v2.16b, v2.16b, v10.16b
	eor	v3.16b, v3.16b, v11.16b
	ld1	{v13.2d}, [x12]
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x1], #0x40
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x1], #0x40
	cmp	w14, #8
	blt	L_aes_gcm_encrypt_arm64_crypto_256_end_8
L_aes_gcm_encrypt_arm64_crypto_256_both_8:
	ldr	q12, [x9]
	add	w24, w15, #1
	mov	v14.16b, v13.16b
	add	w23, w15, #2
	mov	v15.16b, v13.16b
	add	w22, w15, #3
	mov	v16.16b, v13.16b
	add	w21, w15, #4
	mov	v17.16b, v13.16b
	add	w20, w15, #5
	mov	v8.16b, v13.16b
	add	w19, w15, #6
	mov	v9.16b, v13.16b
	add	w17, w15, #7
	mov	v10.16b, v13.16b
	add	w15, w15, #8
	mov	v11.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w24, w24
	rbit	v19.16b, v19.16b
	rev	w23, w23
	rbit	v20.16b, v20.16b
	rev	w22, w22
	rbit	v21.16b, v21.16b
	rev	w21, w21
	rbit	v0.16b, v0.16b
	rev	w20, w20
	rbit	v1.16b, v1.16b
	rev	w19, w19
	rbit	v2.16b, v2.16b
	rev	w17, w17
	rbit	v3.16b, v3.16b
	rev	w16, w15
	mov	v14.s[3], w24
	mov	v15.s[3], w23
	mov	v16.s[3], w22
	mov	v17.s[3], w21
	mov	v8.s[3], w20
	mov	v9.s[3], w19
	mov	v10.s[3], w17
	mov	v11.s[3], w16
	ldr	q13, [x9, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v18.16b, v18.16b, v26.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ext	v31.16b, v3.16b, v3.16b, #8
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w14, w14, #8
	ldr	q12, [x9, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v29.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	mov	v28.d[1], v31.d[0]
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v18.16b}, [x0], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ld1	{v19.16b}, [x0], #16
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ld1	{v20.16b}, [x0], #16
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ld1	{v21.16b}, [x0], #16
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v0.16b}, [x0], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v1.16b}, [x0], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v2.16b}, [x0], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ld1	{v3.16b}, [x0], #16
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #160]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #176]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #192]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #208]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #224]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	ld1	{v13.2d}, [x12]
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x1], #0x40
	eor	v0.16b, v0.16b, v8.16b
	eor	v1.16b, v1.16b, v9.16b
	eor	v2.16b, v2.16b, v10.16b
	eor	v3.16b, v3.16b, v11.16b
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x1], #0x40
	cmp	w14, #8
	bge	L_aes_gcm_encrypt_arm64_crypto_256_both_8
L_aes_gcm_encrypt_arm64_crypto_256_end_8:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	rbit	v0.16b, v0.16b
	rbit	v1.16b, v1.16b
	rbit	v2.16b, v2.16b
	rbit	v3.16b, v3.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	ext	v31.16b, v3.16b, v3.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_encrypt_arm64_crypto_256_start_4:
	ld1	{v0.2d, v1.2d, v2.2d, v3.2d}, [x9], #0x40
	ld1	{v4.2d, v5.2d, v6.2d, v7.2d}, [x9], #0x40
	ld1	{v8.2d, v9.2d, v10.2d, v11.2d}, [x9], #0x40
	ld1	{v12.2d}, [x9], #16
	cmp	w14, #1
	blt	L_aes_gcm_encrypt_arm64_crypto_256_done
	beq	L_aes_gcm_encrypt_arm64_crypto_256_start_1
	cmp	w14, #4
	blt	L_aes_gcm_encrypt_arm64_crypto_256_start_2
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w19, w15, #2
	mov	v15.16b, v13.16b
	add	w17, w15, #3
	mov	v16.16b, v13.16b
	add	w15, w15, #4
	mov	v17.16b, v13.16b
	rev	w20, w20
	rev	w19, w19
	rev	w17, w17
	rev	w16, w15
	mov	v14.s[3], w20
	mov	v15.s[3], w19
	mov	v16.s[3], w17
	mov	v17.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w14, w14, #4
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x0], #16
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	ld1	{v19.16b}, [x0], #16
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	ld1	{v20.16b}, [x0], #16
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	ld1	{v21.16b}, [x0], #16
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v11.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v11.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v11.16b
	aesmc	v17.16b, v17.16b
	ld1	{v29.2d, v30.2d}, [x9]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	aese	v15.16b, v29.16b
	eor	v15.16b, v15.16b, v30.16b
	aese	v16.16b, v29.16b
	eor	v16.16b, v16.16b, v30.16b
	aese	v17.16b, v29.16b
	eor	v17.16b, v17.16b, v30.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	cmp	w14, #4
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x1], #0x40
	blt	L_aes_gcm_encrypt_arm64_crypto_256_end_4
L_aes_gcm_encrypt_arm64_crypto_256_both_4:
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w19, w15, #2
	mov	v15.16b, v13.16b
	add	w17, w15, #3
	mov	v16.16b, v13.16b
	add	w15, w15, #4
	mov	v17.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w20, w20
	rev	w19, w19
	rev	w17, w17
	rbit	v19.16b, v19.16b
	rev	w16, w15
	mov	v14.s[3], w20
	mov	v15.s[3], w19
	mov	v16.s[3], w17
	mov	v17.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	rbit	v20.16b, v20.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	rbit	v21.16b, v21.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	eor	v18.16b, v18.16b, v26.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	ext	v31.16b, v21.16b, v21.16b, #8
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w14, w14, #4
	eor	v31.16b, v31.16b, v29.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	mov	v28.d[1], v31.d[0]
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x0], #0x40
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v11.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v11.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v11.16b
	aesmc	v17.16b, v17.16b
	ld1	{v29.2d, v30.2d}, [x9]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	aese	v15.16b, v29.16b
	eor	v15.16b, v15.16b, v30.16b
	aese	v16.16b, v29.16b
	eor	v16.16b, v16.16b, v30.16b
	aese	v17.16b, v29.16b
	eor	v17.16b, v17.16b, v30.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	cmp	w14, #4
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x1], #0x40
	bge	L_aes_gcm_encrypt_arm64_crypto_256_both_4
L_aes_gcm_encrypt_arm64_crypto_256_end_4:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cmp	w14, #1
	beq	L_aes_gcm_encrypt_arm64_crypto_256_start_1
	blt	L_aes_gcm_encrypt_arm64_crypto_256_done
L_aes_gcm_encrypt_arm64_crypto_256_start_2:
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w15, w15, #2
	mov	v15.16b, v13.16b
	rev	w20, w20
	rev	w16, w15
	mov	v14.s[3], w20
	mov	v15.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	subs	w14, w14, #2
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x0], #16
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	ld1	{v19.16b}, [x0], #16
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v11.16b
	aesmc	v15.16b, v15.16b
	ld1	{v29.2d, v30.2d}, [x9]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	aese	v15.16b, v29.16b
	eor	v15.16b, v15.16b, v30.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	st1	{v18.16b, v19.16b}, [x1], #32
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v19.1d, v22.1d
	pmull2	v29.1q, v19.2d, v22.2d
	ext	v31.16b, v19.16b, v19.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v21.1d
	pmull2	v26.1q, v23.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cbz	w14, L_aes_gcm_encrypt_arm64_crypto_256_done
L_aes_gcm_encrypt_arm64_crypto_256_start_1:
	add	w15, w15, #1
	mov	v14.16b, v13.16b
	rev	w16, w15
	mov	v14.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x0], #16
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	ldr	q29, [x9]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ldr	q30, [x9, #16]
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	eor	v18.16b, v18.16b, v14.16b
	st1	{v18.16b}, [x1], #16
	rbit	v18.16b, v18.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_encrypt_arm64_crypto_256_done:
	ands	w14, w2, #15
	beq	L_aes_gcm_encrypt_arm64_crypto_256_partial_done
	eor	v16.16b, v16.16b, v16.16b
	mov	w19, w14
	st1	{v16.2d}, [x11]
	cmp	x19, #8
	blt	L_aes_gcm_encrypt_arm64_crypto_256_start_dw
	ldr	x17, [x0], #8
	sub	x19, x19, #8
	str	x17, [x11], #8
L_aes_gcm_encrypt_arm64_crypto_256_start_dw:
	cmp	x19, #4
	blt	L_aes_gcm_encrypt_arm64_crypto_256_start_sw
	ldr	w17, [x0], #4
	sub	x19, x19, #4
	str	w17, [x11], #4
L_aes_gcm_encrypt_arm64_crypto_256_start_sw:
	cmp	x19, #2
	blt	L_aes_gcm_encrypt_arm64_crypto_256_start_byte
	ldrh	w17, [x0], #2
	sub	x19, x19, #2
	strh	w17, [x11], #2
L_aes_gcm_encrypt_arm64_crypto_256_start_byte:
	cbz	x19, L_aes_gcm_encrypt_arm64_crypto_256_end_bytes
	ldrb	w17, [x0], #1
	subs	x19, x19, #1
	strb	w17, [x11], #1
	bne	L_aes_gcm_encrypt_arm64_crypto_256_start_byte
L_aes_gcm_encrypt_arm64_crypto_256_end_bytes:
	sub	x11, x11, x14
	ld1	{v16.2d}, [x11]
	add	w15, w15, #1
	mov	v14.16b, v13.16b
	rev	w16, w15
	mov	v14.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	ldr	q29, [x9]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ldr	q30, [x9, #16]
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	eor	v16.16b, v16.16b, v14.16b
	st1	{v16.2d}, [x11]
	mov	w19, w14
	cmp	x19, #8
	blt	L_aes_gcm_encrypt_arm64_crypto_256_out_start_dw
	ldr	x17, [x11], #8
	sub	x19, x19, #8
	str	x17, [x1], #8
L_aes_gcm_encrypt_arm64_crypto_256_out_start_dw:
	cmp	x19, #4
	blt	L_aes_gcm_encrypt_arm64_crypto_256_out_start_sw
	ldr	w17, [x11], #4
	sub	x19, x19, #4
	str	w17, [x1], #4
L_aes_gcm_encrypt_arm64_crypto_256_out_start_sw:
	cmp	x19, #2
	blt	L_aes_gcm_encrypt_arm64_crypto_256_out_start_byte
	ldrh	w17, [x11], #2
	sub	x19, x19, #2
	strh	w17, [x1], #2
L_aes_gcm_encrypt_arm64_crypto_256_out_start_byte:
	cbz	x19, L_aes_gcm_encrypt_arm64_crypto_256_out_end_bytes
	ldrb	w17, [x11], #1
	subs	x19, x19, #1
	strb	w17, [x1], #1
	bne	L_aes_gcm_encrypt_arm64_crypto_256_out_start_byte
L_aes_gcm_encrypt_arm64_crypto_256_out_end_bytes:
	mov	x17, #16
	sub	x17, x17, x14
L_aes_gcm_encrypt_arm64_crypto_256_start_zero:
	subs	x17, x17, #1
	strb	wzr, [x11], #1
	bne	L_aes_gcm_encrypt_arm64_crypto_256_start_zero
	sub	x11, x11, #16
	ld1	{v14.2d}, [x11]
	rbit	v14.16b, v14.16b
	eor	v15.16b, v26.16b, v14.16b
	#   X  = C * H^1
	pmull	v28.1q, v15.1d, v22.1d
	pmull2	v29.1q, v15.2d, v22.2d
	ext	v31.16b, v15.16b, v15.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_encrypt_arm64_crypto_256_partial_done:
	ld1	{v14.2d}, [x12]
	lsl	x8, x8, #3
	rbit	x8, x8
	mov	v28.d[0], x8
	lsl	x2, x2, #3
	rbit	x2, x2
	mov	v28.d[1], x2
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v26.16b, v28.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	pmull	v28.1q, v26.1d, v22.1d
	pmull2	v29.1q, v26.2d, v22.2d
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	ext	v31.16b, v26.16b, v26.16b, #8
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v29.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	pmull2	v30.1q, v31.2d, v27.2d
	ldr	q11, [x9, #-32]
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	mov	v28.d[1], v31.d[0]
	ldr	q12, [x9, #-16]
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v28.16b, v30.16b
	ldr	q29, [x9]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	rbit	v26.16b, v26.16b
	ldr	q30, [x9, #16]
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	eor	v26.16b, v26.16b, v14.16b
	cmp	w6, #16
	bne	L_aes_gcm_encrypt_arm64_crypto_256_tag_partial
	st1	{v26.16b}, [x5]
	b	L_aes_gcm_encrypt_arm64_crypto_done
L_aes_gcm_encrypt_arm64_crypto_256_tag_partial:
	st1	{v26.16b}, [x11]
	cmp	w6, #8
	blt	L_aes_gcm_encrypt_arm64_crypto_256_tag_start_dw
	ldr	x16, [x11], #8
	sub	w6, w6, #8
	str	x16, [x5], #8
L_aes_gcm_encrypt_arm64_crypto_256_tag_start_dw:
	cmp	w6, #4
	blt	L_aes_gcm_encrypt_arm64_crypto_256_tag_start_sw
	ldr	w16, [x11], #4
	sub	w6, w6, #4
	str	w16, [x5], #4
L_aes_gcm_encrypt_arm64_crypto_256_tag_start_sw:
	cmp	w6, #2
	blt	L_aes_gcm_encrypt_arm64_crypto_256_tag_start_byte
	ldrh	w16, [x11], #2
	sub	w6, w6, #2
	strh	w16, [x5], #2
L_aes_gcm_encrypt_arm64_crypto_256_tag_start_byte:
	cbz	w6, L_aes_gcm_encrypt_arm64_crypto_256_tag_end_bytes
	ldrb	w16, [x11], #1
	subs	w6, w6, #1
	strb	w16, [x5], #1
	bne	L_aes_gcm_encrypt_arm64_crypto_256_tag_start_byte
L_aes_gcm_encrypt_arm64_crypto_256_tag_end_bytes:
#endif /* !NO_AES_256 */
	b	L_aes_gcm_encrypt_arm64_crypto_done
	# AES_GCM_128
L_aes_gcm_encrypt_arm64_crypto_start_128:
#ifndef NO_AES_128
	cmp	w14, #32
	blt	L_aes_gcm_encrypt_arm64_crypto_128_start_4
L_aes_gcm_encrypt_arm64_crypto_128_start_8:
	ldr	q12, [x9]
	add	w24, w15, #1
	mov	v14.16b, v13.16b
	add	w23, w15, #2
	mov	v15.16b, v13.16b
	add	w22, w15, #3
	mov	v16.16b, v13.16b
	add	w21, w15, #4
	mov	v17.16b, v13.16b
	add	w20, w15, #5
	mov	v8.16b, v13.16b
	add	w19, w15, #6
	mov	v9.16b, v13.16b
	add	w17, w15, #7
	mov	v10.16b, v13.16b
	add	w15, w15, #8
	mov	v11.16b, v13.16b
	rev	w24, w24
	rev	w23, w23
	rev	w22, w22
	rev	w21, w21
	rev	w20, w20
	rev	w19, w19
	rev	w17, w17
	rev	w16, w15
	mov	v14.s[3], w24
	mov	v15.s[3], w23
	mov	v16.s[3], w22
	mov	v17.s[3], w21
	mov	v8.s[3], w20
	mov	v9.s[3], w19
	mov	v10.s[3], w17
	mov	v11.s[3], w16
	ldr	q13, [x9, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w14, w14, #8
	ldr	q12, [x9, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b}, [x0], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v19.16b}, [x0], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v20.16b}, [x0], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ld1	{v21.16b}, [x0], #16
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #160]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	ld1	{v0.16b}, [x0], #16
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	ld1	{v1.16b}, [x0], #16
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	ld1	{v2.16b}, [x0], #16
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	ld1	{v3.16b}, [x0], #16
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	eor	v0.16b, v0.16b, v8.16b
	eor	v1.16b, v1.16b, v9.16b
	eor	v2.16b, v2.16b, v10.16b
	eor	v3.16b, v3.16b, v11.16b
	ld1	{v13.2d}, [x12]
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x1], #0x40
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x1], #0x40
	cmp	w14, #8
	blt	L_aes_gcm_encrypt_arm64_crypto_128_end_8
L_aes_gcm_encrypt_arm64_crypto_128_both_8:
	ldr	q12, [x9]
	add	w24, w15, #1
	mov	v14.16b, v13.16b
	add	w23, w15, #2
	mov	v15.16b, v13.16b
	add	w22, w15, #3
	mov	v16.16b, v13.16b
	add	w21, w15, #4
	mov	v17.16b, v13.16b
	add	w20, w15, #5
	mov	v8.16b, v13.16b
	add	w19, w15, #6
	mov	v9.16b, v13.16b
	add	w17, w15, #7
	mov	v10.16b, v13.16b
	add	w15, w15, #8
	mov	v11.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w24, w24
	rbit	v19.16b, v19.16b
	rev	w23, w23
	rbit	v20.16b, v20.16b
	rev	w22, w22
	rbit	v21.16b, v21.16b
	rev	w21, w21
	rbit	v0.16b, v0.16b
	rev	w20, w20
	rbit	v1.16b, v1.16b
	rev	w19, w19
	rbit	v2.16b, v2.16b
	rev	w17, w17
	rbit	v3.16b, v3.16b
	rev	w16, w15
	mov	v14.s[3], w24
	mov	v15.s[3], w23
	mov	v16.s[3], w22
	mov	v17.s[3], w21
	mov	v8.s[3], w20
	mov	v9.s[3], w19
	mov	v10.s[3], w17
	mov	v11.s[3], w16
	ldr	q13, [x9, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v18.16b, v18.16b, v26.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ext	v31.16b, v3.16b, v3.16b, #8
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w14, w14, #8
	ldr	q12, [x9, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v29.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	mov	v28.d[1], v31.d[0]
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v18.16b}, [x0], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ld1	{v19.16b}, [x0], #16
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ld1	{v20.16b}, [x0], #16
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ld1	{v21.16b}, [x0], #16
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v0.16b}, [x0], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v1.16b}, [x0], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v2.16b}, [x0], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ld1	{v3.16b}, [x0], #16
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #160]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	ld1	{v13.2d}, [x12]
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x1], #0x40
	eor	v0.16b, v0.16b, v8.16b
	eor	v1.16b, v1.16b, v9.16b
	eor	v2.16b, v2.16b, v10.16b
	eor	v3.16b, v3.16b, v11.16b
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x1], #0x40
	cmp	w14, #8
	bge	L_aes_gcm_encrypt_arm64_crypto_128_both_8
L_aes_gcm_encrypt_arm64_crypto_128_end_8:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	rbit	v0.16b, v0.16b
	rbit	v1.16b, v1.16b
	rbit	v2.16b, v2.16b
	rbit	v3.16b, v3.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	ext	v31.16b, v3.16b, v3.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_encrypt_arm64_crypto_128_start_4:
	ld1	{v0.2d, v1.2d, v2.2d, v3.2d}, [x9], #0x40
	ld1	{v4.2d, v5.2d, v6.2d, v7.2d}, [x9], #0x40
	ld1	{v8.2d, v9.2d}, [x9], #32
	ld1	{v10.2d}, [x9]
	cmp	w14, #1
	blt	L_aes_gcm_encrypt_arm64_crypto_128_done
	beq	L_aes_gcm_encrypt_arm64_crypto_128_start_1
	cmp	w14, #4
	blt	L_aes_gcm_encrypt_arm64_crypto_128_start_2
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w19, w15, #2
	mov	v15.16b, v13.16b
	add	w17, w15, #3
	mov	v16.16b, v13.16b
	add	w15, w15, #4
	mov	v17.16b, v13.16b
	rev	w20, w20
	rev	w19, w19
	rev	w17, w17
	rev	w16, w15
	mov	v14.s[3], w20
	mov	v15.s[3], w19
	mov	v16.s[3], w17
	mov	v17.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w14, w14, #4
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x0], #16
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	ld1	{v19.16b}, [x0], #16
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	ld1	{v20.16b}, [x0], #16
	aese	v15.16b, v9.16b
	eor	v15.16b, v15.16b, v10.16b
	ld1	{v21.16b}, [x0], #16
	aese	v16.16b, v9.16b
	eor	v16.16b, v16.16b, v10.16b
	aese	v17.16b, v9.16b
	eor	v17.16b, v17.16b, v10.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	cmp	w14, #4
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x1], #0x40
	blt	L_aes_gcm_encrypt_arm64_crypto_128_end_4
L_aes_gcm_encrypt_arm64_crypto_128_both_4:
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w19, w15, #2
	mov	v15.16b, v13.16b
	add	w17, w15, #3
	mov	v16.16b, v13.16b
	add	w15, w15, #4
	mov	v17.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w20, w20
	rev	w19, w19
	rev	w17, w17
	rbit	v19.16b, v19.16b
	rev	w16, w15
	mov	v14.s[3], w20
	mov	v15.s[3], w19
	mov	v16.s[3], w17
	mov	v17.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	rbit	v20.16b, v20.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	rbit	v21.16b, v21.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	eor	v18.16b, v18.16b, v26.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	ext	v31.16b, v21.16b, v21.16b, #8
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w14, w14, #4
	eor	v31.16b, v31.16b, v29.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	mov	v28.d[1], v31.d[0]
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x0], #0x40
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	aese	v15.16b, v9.16b
	eor	v15.16b, v15.16b, v10.16b
	aese	v16.16b, v9.16b
	eor	v16.16b, v16.16b, v10.16b
	aese	v17.16b, v9.16b
	eor	v17.16b, v17.16b, v10.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	cmp	w14, #4
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x1], #0x40
	bge	L_aes_gcm_encrypt_arm64_crypto_128_both_4
L_aes_gcm_encrypt_arm64_crypto_128_end_4:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cmp	w14, #1
	beq	L_aes_gcm_encrypt_arm64_crypto_128_start_1
	blt	L_aes_gcm_encrypt_arm64_crypto_128_done
L_aes_gcm_encrypt_arm64_crypto_128_start_2:
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w15, w15, #2
	mov	v15.16b, v13.16b
	rev	w20, w20
	rev	w16, w15
	mov	v14.s[3], w20
	mov	v15.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	subs	w14, w14, #2
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x0], #16
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	ld1	{v19.16b}, [x0], #16
	aese	v15.16b, v9.16b
	eor	v15.16b, v15.16b, v10.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	st1	{v18.16b, v19.16b}, [x1], #32
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v19.1d, v22.1d
	pmull2	v29.1q, v19.2d, v22.2d
	ext	v31.16b, v19.16b, v19.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v21.1d
	pmull2	v26.1q, v23.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cbz	w14, L_aes_gcm_encrypt_arm64_crypto_128_done
L_aes_gcm_encrypt_arm64_crypto_128_start_1:
	add	w15, w15, #1
	mov	v14.16b, v13.16b
	rev	w16, w15
	mov	v14.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	ld1	{v18.16b}, [x0], #16
	eor	v18.16b, v18.16b, v14.16b
	st1	{v18.16b}, [x1], #16
	rbit	v18.16b, v18.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_encrypt_arm64_crypto_128_done:
	ands	w14, w2, #15
	beq	L_aes_gcm_encrypt_arm64_crypto_128_partial_done
	eor	v16.16b, v16.16b, v16.16b
	mov	w19, w14
	st1	{v16.2d}, [x11]
	cmp	x19, #8
	blt	L_aes_gcm_encrypt_arm64_crypto_128_start_dw
	ldr	x17, [x0], #8
	sub	x19, x19, #8
	str	x17, [x11], #8
L_aes_gcm_encrypt_arm64_crypto_128_start_dw:
	cmp	x19, #4
	blt	L_aes_gcm_encrypt_arm64_crypto_128_start_sw
	ldr	w17, [x0], #4
	sub	x19, x19, #4
	str	w17, [x11], #4
L_aes_gcm_encrypt_arm64_crypto_128_start_sw:
	cmp	x19, #2
	blt	L_aes_gcm_encrypt_arm64_crypto_128_start_byte
	ldrh	w17, [x0], #2
	sub	x19, x19, #2
	strh	w17, [x11], #2
L_aes_gcm_encrypt_arm64_crypto_128_start_byte:
	cbz	x19, L_aes_gcm_encrypt_arm64_crypto_128_end_bytes
	ldrb	w17, [x0], #1
	subs	x19, x19, #1
	strb	w17, [x11], #1
	bne	L_aes_gcm_encrypt_arm64_crypto_128_start_byte
L_aes_gcm_encrypt_arm64_crypto_128_end_bytes:
	sub	x11, x11, x14
	ld1	{v16.2d}, [x11]
	add	w15, w15, #1
	mov	v14.16b, v13.16b
	rev	w16, w15
	mov	v14.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	eor	v16.16b, v16.16b, v14.16b
	st1	{v16.2d}, [x11]
	mov	w19, w14
	cmp	x19, #8
	blt	L_aes_gcm_encrypt_arm64_crypto_128_out_start_dw
	ldr	x17, [x11], #8
	sub	x19, x19, #8
	str	x17, [x1], #8
L_aes_gcm_encrypt_arm64_crypto_128_out_start_dw:
	cmp	x19, #4
	blt	L_aes_gcm_encrypt_arm64_crypto_128_out_start_sw
	ldr	w17, [x11], #4
	sub	x19, x19, #4
	str	w17, [x1], #4
L_aes_gcm_encrypt_arm64_crypto_128_out_start_sw:
	cmp	x19, #2
	blt	L_aes_gcm_encrypt_arm64_crypto_128_out_start_byte
	ldrh	w17, [x11], #2
	sub	x19, x19, #2
	strh	w17, [x1], #2
L_aes_gcm_encrypt_arm64_crypto_128_out_start_byte:
	cbz	x19, L_aes_gcm_encrypt_arm64_crypto_128_out_end_bytes
	ldrb	w17, [x11], #1
	subs	x19, x19, #1
	strb	w17, [x1], #1
	bne	L_aes_gcm_encrypt_arm64_crypto_128_out_start_byte
L_aes_gcm_encrypt_arm64_crypto_128_out_end_bytes:
	mov	x17, #16
	sub	x17, x17, x14
L_aes_gcm_encrypt_arm64_crypto_128_start_zero:
	subs	x17, x17, #1
	strb	wzr, [x11], #1
	bne	L_aes_gcm_encrypt_arm64_crypto_128_start_zero
	sub	x11, x11, #16
	ld1	{v14.2d}, [x11]
	rbit	v14.16b, v14.16b
	eor	v15.16b, v26.16b, v14.16b
	#   X  = C * H^1
	pmull	v28.1q, v15.1d, v22.1d
	pmull2	v29.1q, v15.2d, v22.2d
	ext	v31.16b, v15.16b, v15.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_encrypt_arm64_crypto_128_partial_done:
	ld1	{v14.2d}, [x12]
	lsl	x8, x8, #3
	rbit	x8, x8
	mov	v28.d[0], x8
	lsl	x2, x2, #3
	rbit	x2, x2
	mov	v28.d[1], x2
	eor	v26.16b, v26.16b, v28.16b
	pmull	v28.1q, v26.1d, v22.1d
	pmull2	v29.1q, v26.2d, v22.2d
	ext	v31.16b, v26.16b, v26.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v29.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	mov	v28.d[1], v31.d[0]
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v28.16b, v30.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	rbit	v26.16b, v26.16b
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	eor	v26.16b, v26.16b, v14.16b
	cmp	w6, #16
	bne	L_aes_gcm_encrypt_arm64_crypto_128_tag_partial
	st1	{v26.16b}, [x5]
	b	L_aes_gcm_encrypt_arm64_crypto_done
L_aes_gcm_encrypt_arm64_crypto_128_tag_partial:
	st1	{v26.16b}, [x11]
	cmp	w6, #8
	blt	L_aes_gcm_encrypt_arm64_crypto_128_tag_start_dw
	ldr	x16, [x11], #8
	sub	w6, w6, #8
	str	x16, [x5], #8
L_aes_gcm_encrypt_arm64_crypto_128_tag_start_dw:
	cmp	w6, #4
	blt	L_aes_gcm_encrypt_arm64_crypto_128_tag_start_sw
	ldr	w16, [x11], #4
	sub	w6, w6, #4
	str	w16, [x5], #4
L_aes_gcm_encrypt_arm64_crypto_128_tag_start_sw:
	cmp	w6, #2
	blt	L_aes_gcm_encrypt_arm64_crypto_128_tag_start_byte
	ldrh	w16, [x11], #2
	sub	w6, w6, #2
	strh	w16, [x5], #2
L_aes_gcm_encrypt_arm64_crypto_128_tag_start_byte:
	cbz	w6, L_aes_gcm_encrypt_arm64_crypto_128_tag_end_bytes
	ldrb	w16, [x11], #1
	subs	w6, w6, #1
	strb	w16, [x5], #1
	bne	L_aes_gcm_encrypt_arm64_crypto_128_tag_start_byte
L_aes_gcm_encrypt_arm64_crypto_128_tag_end_bytes:
#endif /* !NO_AES_128 */
L_aes_gcm_encrypt_arm64_crypto_done:
	ldp	x17, x19, [x29, #24]
	ldp	x20, x21, [x29, #40]
	ldp	x22, x23, [x29, #56]
	ldr	x24, [x29, #72]
	ldp	d8, d9, [x29, #80]
	ldp	d10, d11, [x29, #96]
	ldp	d12, d13, [x29, #112]
	ldp	d14, d15, [x29, #128]
	ldp	x29, x30, [sp], #0x90
	ret
#ifndef __APPLE__
	.size	AES_GCM_encrypt_AARCH64,.-AES_GCM_encrypt_AARCH64
#endif /* __APPLE__ */
#ifdef HAVE_AES_DECRYPT
#ifndef __APPLE__
.text
.globl	AES_GCM_decrypt_AARCH64
.type	AES_GCM_decrypt_AARCH64,@function
.align	2
AES_GCM_decrypt_AARCH64:
#else
.section	__TEXT,__text
.globl	_AES_GCM_decrypt_AARCH64
.p2align	2
_AES_GCM_decrypt_AARCH64:
#endif /* __APPLE__ */
	stp	x29, x30, [sp, #-144]!
	add	x29, sp, #0
	stp	x17, x19, [x29, #24]
	stp	x20, x21, [x29, #40]
	stp	x22, x23, [x29, #56]
	str	x24, [x29, #72]
	stp	d8, d9, [x29, #80]
	stp	d10, d11, [x29, #96]
	stp	d12, d13, [x29, #112]
	stp	d14, d15, [x29, #128]
	ldr	w8, [x29, #144]
	ldr	x9, [x29, #152]
	ldr	x10, [x29, #160]
	ldr	x11, [x29, #168]
	ldr	x12, [x29, #176]
	ldr	w13, [x29, #184]
	movi	v27.16b, #0x87
	eor	v26.16b, v26.16b, v26.16b
	ushr	v27.2d, v27.2d, #56
	ld1	{v22.2d}, [x10]
	cmp	w8, #0x40
	csetm	x16, lt
	cmp	w2, #32
	csetm	x17, lt
	ands	x16, x16, x17
	bne	L_aes_gcm_decrypt_arm64_crypto_h_done
	# Square H => H^2
	pmull2	v31.1q, v22.2d, v22.2d
	pmull	v30.1q, v22.1d, v22.1d
	pmull2	v28.1q, v31.2d, v27.2d
	ext	v29.16b, v30.16b, v31.16b, #8
	eor	v29.16b, v29.16b, v28.16b
	pmull2	v31.1q, v29.2d, v27.2d
	mov	v30.d[1], v29.d[0]
	eor	v23.16b, v30.16b, v31.16b
	cmp	w8, #0x100
	csetm	x16, lt
	cmp	w2, #0x40
	csetm	x17, lt
	ands	x16, x16, x17
	bne	L_aes_gcm_decrypt_arm64_crypto_h_done
	# Multiply H and H^2  => H^3
	pmull	v28.1q, v22.1d, v23.1d
	pmull2	v29.1q, v22.2d, v23.2d
	ext	v31.16b, v22.16b, v22.16b, #8
	pmull	v30.1q, v31.1d, v23.1d
	pmull2	v31.1q, v31.2d, v23.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v24.16b, v28.16b, v30.16b
	# Square H^2 => H^4
	pmull2	v31.1q, v23.2d, v23.2d
	pmull	v30.1q, v23.1d, v23.1d
	pmull2	v28.1q, v31.2d, v27.2d
	ext	v29.16b, v30.16b, v31.16b, #8
	eor	v29.16b, v29.16b, v28.16b
	pmull2	v31.1q, v29.2d, v27.2d
	mov	v30.d[1], v29.d[0]
	eor	v25.16b, v30.16b, v31.16b
	# Done
	cmp	w8, #0x400
	csetm	x16, lt
	cmp	w2, #0x200
	csetm	x17, lt
	ands	x16, x16, x17
	bne	L_aes_gcm_decrypt_arm64_crypto_h_done
	# Multiply H and H^4  => H^5
	pmull	v28.1q, v22.1d, v25.1d
	pmull2	v29.1q, v22.2d, v25.2d
	ext	v31.16b, v22.16b, v22.16b, #8
	pmull	v30.1q, v31.1d, v25.1d
	pmull2	v31.1q, v31.2d, v25.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v4.16b, v28.16b, v30.16b
	# Square H^3 => H^6
	pmull2	v31.1q, v24.2d, v24.2d
	pmull	v30.1q, v24.1d, v24.1d
	pmull2	v28.1q, v31.2d, v27.2d
	ext	v29.16b, v30.16b, v31.16b, #8
	eor	v29.16b, v29.16b, v28.16b
	pmull2	v31.1q, v29.2d, v27.2d
	mov	v30.d[1], v29.d[0]
	eor	v5.16b, v30.16b, v31.16b
	# Multiply H and H^6  => H^7
	pmull	v28.1q, v22.1d, v5.1d
	pmull2	v29.1q, v22.2d, v5.2d
	ext	v31.16b, v22.16b, v22.16b, #8
	pmull	v30.1q, v31.1d, v5.1d
	pmull2	v31.1q, v31.2d, v5.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v6.16b, v28.16b, v30.16b
	# Square H^4 => H^8
	pmull2	v31.1q, v25.2d, v25.2d
	pmull	v30.1q, v25.1d, v25.1d
	pmull2	v28.1q, v31.2d, v27.2d
	ext	v29.16b, v30.16b, v31.16b, #8
	eor	v29.16b, v29.16b, v28.16b
	pmull2	v31.1q, v29.2d, v27.2d
	mov	v30.d[1], v29.d[0]
	eor	v7.16b, v30.16b, v31.16b
	# Done
L_aes_gcm_decrypt_arm64_crypto_h_done:
	lsr	w14, w8, #4
	cmp	w14, #4
	blt	L_aes_gcm_decrypt_arm64_crypto_aad_start_1
	cmp	w14, #16
	blt	L_aes_gcm_decrypt_arm64_crypto_aad_start_2
	cmp	w14, #0x40
	blt	L_aes_gcm_decrypt_arm64_crypto_aad_start_4
L_aes_gcm_decrypt_arm64_crypto_aad_start_8:
	ld1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x7], #0x40
	ld1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x7], #0x40
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	rbit	v0.16b, v0.16b
	rbit	v1.16b, v1.16b
	rbit	v2.16b, v2.16b
	rbit	v3.16b, v3.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	ext	v31.16b, v3.16b, v3.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	sub	w14, w14, #8
	cmp	w14, #8
	bge	L_aes_gcm_decrypt_arm64_crypto_aad_start_8
	cmp	w14, #1
	blt	L_aes_gcm_decrypt_arm64_crypto_aad_done
	beq	L_aes_gcm_decrypt_arm64_crypto_aad_start_1
	cmp	w14, #16
	blt	L_aes_gcm_decrypt_arm64_crypto_aad_start_2
L_aes_gcm_decrypt_arm64_crypto_aad_start_4:
	ld1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x7], #0x40
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	sub	w14, w14, #4
	cmp	w14, #4
	bge	L_aes_gcm_decrypt_arm64_crypto_aad_start_4
	cmp	w14, #1
	blt	L_aes_gcm_decrypt_arm64_crypto_aad_done
	beq	L_aes_gcm_decrypt_arm64_crypto_aad_start_1
L_aes_gcm_decrypt_arm64_crypto_aad_start_2:
	ld1	{v18.16b, v19.16b}, [x7], #32
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v19.1d, v22.1d
	pmull2	v29.1q, v19.2d, v22.2d
	ext	v31.16b, v19.16b, v19.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v21.1d
	pmull2	v26.1q, v23.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	sub	w14, w14, #2
	cmp	w14, #1
	bgt	L_aes_gcm_decrypt_arm64_crypto_aad_start_2
	blt	L_aes_gcm_decrypt_arm64_crypto_aad_done
L_aes_gcm_decrypt_arm64_crypto_aad_start_1:
	cbz	w14, L_aes_gcm_decrypt_arm64_crypto_aad_done
L_aes_gcm_decrypt_arm64_crypto_aad_both_1:
	ld1	{v18.16b}, [x7], #16
	rbit	v18.16b, v18.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	subs	w14, w14, #1
	bne	L_aes_gcm_decrypt_arm64_crypto_aad_both_1
L_aes_gcm_decrypt_arm64_crypto_aad_done:
	and	w14, w8, #15
	cbz	w14, L_aes_gcm_decrypt_arm64_crypto_aad_partial_done
	eor	v28.16b, v28.16b, v28.16b
	mov	w20, w14
	st1	{v28.2d}, [x11]
	cmp	w20, #8
	blt	L_aes_gcm_decrypt_arm64_crypto_aad_start_dw
	ldr	x19, [x7], #8
	sub	w20, w20, #8
	str	x19, [x11], #8
L_aes_gcm_decrypt_arm64_crypto_aad_start_dw:
	cmp	w20, #4
	blt	L_aes_gcm_decrypt_arm64_crypto_aad_start_sw
	ldr	w19, [x7], #4
	sub	w20, w20, #4
	str	w19, [x11], #4
L_aes_gcm_decrypt_arm64_crypto_aad_start_sw:
	cmp	w20, #2
	blt	L_aes_gcm_decrypt_arm64_crypto_aad_start_byte
	ldrh	w19, [x7], #2
	sub	w20, w20, #2
	strh	w19, [x11], #2
L_aes_gcm_decrypt_arm64_crypto_aad_start_byte:
	cbz	w20, L_aes_gcm_decrypt_arm64_crypto_aad_end_bytes
	ldrb	w19, [x7], #1
	subs	w20, w20, #1
	strb	w19, [x11], #1
	bne	L_aes_gcm_decrypt_arm64_crypto_aad_start_byte
L_aes_gcm_decrypt_arm64_crypto_aad_end_bytes:
	sub	x11, x11, x14
	ld1	{v18.2d}, [x11]
	rbit	v18.16b, v18.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_decrypt_arm64_crypto_aad_partial_done:
	# Load Nonce
	cmp	w4, #12
	bne	L_aes_gcm_decrypt_arm64_crypto_ghash_nonce
	ldr	x16, [x3]
	movi	v13.4s, #1, lsl 24
	ldr	w17, [x3, #8]
	mov	v13.d[0], x16
	mov	v13.s[2], w17
	mov	w15, #1
	b	L_aes_gcm_decrypt_arm64_crypto_done_nonce
L_aes_gcm_decrypt_arm64_crypto_ghash_nonce:
	eor	v13.16b, v13.16b, v13.16b
	lsr	w14, w4, #4
	cbz	w14, L_aes_gcm_decrypt_arm64_crypto_nonce_done
L_aes_gcm_decrypt_arm64_crypto_nonce_start_1:
	ld1	{v18.16b}, [x3], #16
	rbit	v18.16b, v18.16b
	eor	v21.16b, v13.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v13.16b, v28.16b, v30.16b
	# Done GHASH
	subs	w14, w14, #1
	bne	L_aes_gcm_decrypt_arm64_crypto_nonce_start_1
L_aes_gcm_decrypt_arm64_crypto_nonce_done:
	and	w24, w4, #15
	cbz	x24, L_aes_gcm_decrypt_arm64_crypto_nonce_partial_done
	eor	v28.16b, v28.16b, v28.16b
	mov	w20, w24
	st1	{v28.2d}, [x11]
	cmp	w20, #8
	blt	L_aes_gcm_decrypt_arm64_crypto_nonce_start_dw
	ldr	x19, [x3], #8
	sub	w20, w20, #8
	str	x19, [x11], #8
L_aes_gcm_decrypt_arm64_crypto_nonce_start_dw:
	cmp	w20, #4
	blt	L_aes_gcm_decrypt_arm64_crypto_nonce_start_sw
	ldr	w19, [x3], #4
	sub	w20, w20, #4
	str	w19, [x11], #4
L_aes_gcm_decrypt_arm64_crypto_nonce_start_sw:
	cmp	w20, #2
	blt	L_aes_gcm_decrypt_arm64_crypto_nonce_start_byte
	ldrh	w19, [x3], #2
	sub	w20, w20, #2
	strh	w19, [x11], #2
L_aes_gcm_decrypt_arm64_crypto_nonce_start_byte:
	cbz	w20, L_aes_gcm_decrypt_arm64_crypto_nonce_end_bytes
	ldrb	w19, [x3], #1
	subs	w20, w20, #1
	strb	w19, [x11], #1
	bne	L_aes_gcm_decrypt_arm64_crypto_nonce_start_byte
L_aes_gcm_decrypt_arm64_crypto_nonce_end_bytes:
	sub	x11, x11, x24
	ld1	{v18.2d}, [x11]
	rbit	v18.16b, v18.16b
	eor	v21.16b, v13.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v13.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_decrypt_arm64_crypto_nonce_partial_done:
	eor	x14, x14, x14
	lsl	x24, x4, #3
	mov	v28.d[0], x14
	mov	v28.d[1], x24
	rev64	v28.16b, v28.16b
	rbit	v28.16b, v28.16b
	eor	v13.16b, v13.16b, v28.16b
	pmull	v28.1q, v13.1d, v22.1d
	pmull2	v29.1q, v13.2d, v22.2d
	ext	v31.16b, v13.16b, v13.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v13.16b, v28.16b, v30.16b
	rbit	v13.16b, v13.16b
	mov	w15, v13.s[3]
	rev	w15, w15
L_aes_gcm_decrypt_arm64_crypto_done_nonce:
	st1	{v13.2d}, [x12]
	lsr	w14, w2, #4
	cmp	w13, #12
	blt	L_aes_gcm_decrypt_arm64_crypto_start_128
	bgt	L_aes_gcm_decrypt_arm64_crypto_start_256
	# AES_GCM_192
#ifndef NO_AES_192
	cmp	w14, #32
	blt	L_aes_gcm_decrypt_arm64_crypto_192_start_4
L_aes_gcm_decrypt_arm64_crypto_192_start_8:
	ldr	q12, [x9]
	add	w24, w15, #1
	mov	v14.16b, v13.16b
	add	w23, w15, #2
	mov	v15.16b, v13.16b
	add	w22, w15, #3
	mov	v16.16b, v13.16b
	add	w21, w15, #4
	mov	v17.16b, v13.16b
	add	w20, w15, #5
	mov	v8.16b, v13.16b
	add	w19, w15, #6
	mov	v9.16b, v13.16b
	add	w17, w15, #7
	mov	v10.16b, v13.16b
	add	w15, w15, #8
	mov	v11.16b, v13.16b
	rev	w24, w24
	mov	v14.s[3], w24
	rev	w23, w23
	mov	v15.s[3], w23
	rev	w22, w22
	mov	v16.s[3], w22
	rev	w21, w21
	mov	v17.s[3], w21
	rev	w20, w20
	mov	v8.s[3], w20
	rev	w19, w19
	mov	v9.s[3], w19
	rev	w17, w17
	mov	v10.s[3], w17
	rev	w16, w15
	mov	v11.s[3], w16
	ldr	q13, [x9, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w14, w14, #8
	ldr	q12, [x9, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ld1	{v18.16b}, [x0], #16
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v19.16b}, [x0], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v20.16b}, [x0], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v21.16b}, [x0], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #160]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	ld1	{v0.16b}, [x0], #16
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	ld1	{v1.16b}, [x0], #16
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ld1	{v2.16b}, [x0], #16
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v3.16b}, [x0], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #176]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #192]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	eor	v8.16b, v8.16b, v0.16b
	eor	v9.16b, v9.16b, v1.16b
	eor	v10.16b, v10.16b, v2.16b
	eor	v11.16b, v11.16b, v3.16b
	ld1	{v13.2d}, [x12]
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x1], #0x40
	st1	{v8.16b, v9.16b, v10.16b, v11.16b}, [x1], #0x40
	cmp	w14, #8
	blt	L_aes_gcm_decrypt_arm64_crypto_192_end_8
L_aes_gcm_decrypt_arm64_crypto_192_both_8:
	ldr	q12, [x9]
	add	w24, w15, #1
	mov	v14.16b, v13.16b
	add	w23, w15, #2
	mov	v15.16b, v13.16b
	add	w22, w15, #3
	mov	v16.16b, v13.16b
	add	w21, w15, #4
	mov	v17.16b, v13.16b
	add	w20, w15, #5
	mov	v8.16b, v13.16b
	add	w19, w15, #6
	mov	v9.16b, v13.16b
	add	w17, w15, #7
	mov	v10.16b, v13.16b
	add	w15, w15, #8
	mov	v11.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w24, w24
	rbit	v19.16b, v19.16b
	mov	v14.s[3], w24
	rev	w23, w23
	rbit	v20.16b, v20.16b
	mov	v15.s[3], w23
	rev	w22, w22
	rbit	v21.16b, v21.16b
	mov	v16.s[3], w22
	rev	w21, w21
	rbit	v0.16b, v0.16b
	mov	v17.s[3], w21
	rev	w20, w20
	rbit	v1.16b, v1.16b
	mov	v8.s[3], w20
	rev	w19, w19
	rbit	v2.16b, v2.16b
	mov	v9.s[3], w19
	rev	w17, w17
	rbit	v3.16b, v3.16b
	mov	v10.s[3], w17
	rev	w16, w15
	eor	v18.16b, v18.16b, v26.16b
	mov	v11.s[3], w16
	ldr	q13, [x9, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ext	v31.16b, v3.16b, v3.16b, #8
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor	v31.16b, v31.16b, v29.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w14, w14, #8
	ldr	q12, [x9, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	mov	v28.d[1], v31.d[0]
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ld1	{v18.16b}, [x0], #16
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v19.16b}, [x0], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ld1	{v20.16b}, [x0], #16
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ld1	{v21.16b}, [x0], #16
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ld1	{v0.16b}, [x0], #16
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v1.16b}, [x0], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v2.16b}, [x0], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v3.16b}, [x0], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #160]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #176]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #192]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	ld1	{v13.2d}, [x12]
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x1], #0x40
	eor	v8.16b, v8.16b, v0.16b
	eor	v9.16b, v9.16b, v1.16b
	eor	v10.16b, v10.16b, v2.16b
	eor	v11.16b, v11.16b, v3.16b
	st1	{v8.16b, v9.16b, v10.16b, v11.16b}, [x1], #0x40
	cmp	w14, #8
	bge	L_aes_gcm_decrypt_arm64_crypto_192_both_8
L_aes_gcm_decrypt_arm64_crypto_192_end_8:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	rbit	v0.16b, v0.16b
	rbit	v1.16b, v1.16b
	rbit	v2.16b, v2.16b
	rbit	v3.16b, v3.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	ext	v31.16b, v3.16b, v3.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_decrypt_arm64_crypto_192_start_4:
	ld1	{v0.2d, v1.2d, v2.2d, v3.2d}, [x9], #0x40
	ld1	{v4.2d, v5.2d, v6.2d, v7.2d}, [x9], #0x40
	ld1	{v8.2d, v9.2d, v10.2d, v11.2d}, [x9], #0x40
	ld1	{v12.2d}, [x9]
	cmp	w14, #1
	blt	L_aes_gcm_decrypt_arm64_crypto_192_done
	beq	L_aes_gcm_decrypt_arm64_crypto_192_start_1
	cmp	w14, #4
	blt	L_aes_gcm_decrypt_arm64_crypto_192_start_2
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w19, w15, #2
	mov	v15.16b, v13.16b
	add	w17, w15, #3
	mov	v16.16b, v13.16b
	add	w15, w15, #4
	mov	v17.16b, v13.16b
	rev	w20, w20
	mov	v14.s[3], w20
	rev	w19, w19
	mov	v15.s[3], w19
	rev	w17, w17
	mov	v16.s[3], w17
	rev	w16, w15
	mov	v17.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w14, w14, #4
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b}, [x0], #16
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	ld1	{v19.16b}, [x0], #16
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	ld1	{v20.16b}, [x0], #16
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	ld1	{v21.16b}, [x0], #16
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v11.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v11.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v11.16b
	eor	v17.16b, v17.16b, v12.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	cmp	w14, #4
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x1], #0x40
	blt	L_aes_gcm_decrypt_arm64_crypto_192_end_4
L_aes_gcm_decrypt_arm64_crypto_192_both_4:
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w19, w15, #2
	mov	v15.16b, v13.16b
	add	w17, w15, #3
	mov	v16.16b, v13.16b
	add	w15, w15, #4
	mov	v17.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w20, w20
	rbit	v19.16b, v19.16b
	mov	v14.s[3], w20
	rev	w19, w19
	rbit	v20.16b, v20.16b
	mov	v15.s[3], w19
	rev	w17, w17
	rbit	v21.16b, v21.16b
	mov	v16.s[3], w17
	rev	w16, w15
	mov	v17.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	eor	v18.16b, v18.16b, v26.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	ext	v31.16b, v21.16b, v21.16b, #8
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	eor	v31.16b, v31.16b, v29.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w14, w14, #4
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	mov	v28.d[1], v31.d[0]
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x0], #0x40
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v11.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v11.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v11.16b
	eor	v17.16b, v17.16b, v12.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	cmp	w14, #4
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x1], #0x40
	bge	L_aes_gcm_decrypt_arm64_crypto_192_both_4
L_aes_gcm_decrypt_arm64_crypto_192_end_4:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cmp	w14, #1
	beq	L_aes_gcm_decrypt_arm64_crypto_192_start_1
	blt	L_aes_gcm_decrypt_arm64_crypto_192_done
L_aes_gcm_decrypt_arm64_crypto_192_start_2:
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w15, w15, #2
	mov	v15.16b, v13.16b
	rev	w20, w20
	mov	v14.s[3], w20
	rev	w16, w15
	mov	v15.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	subs	w14, w14, #2
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x0], #16
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	ld1	{v19.16b}, [x0], #16
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v11.16b
	eor	v15.16b, v15.16b, v12.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	st1	{v14.16b, v15.16b}, [x1], #32
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v19.1d, v22.1d
	pmull2	v29.1q, v19.2d, v22.2d
	ext	v31.16b, v19.16b, v19.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v21.1d
	pmull2	v26.1q, v23.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cbz	w14, L_aes_gcm_decrypt_arm64_crypto_192_done
L_aes_gcm_decrypt_arm64_crypto_192_start_1:
	ld1	{v15.16b}, [x0], #16
	add	w15, w15, #1
	mov	v14.16b, v13.16b
	rbit	v15.16b, v15.16b
	rev	w16, w15
	mov	v14.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	eor	v16.16b, v26.16b, v15.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	#   X  = C * H^1
	pmull	v28.1q, v16.1d, v22.1d
	pmull2	v29.1q, v16.2d, v22.2d
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	ext	v31.16b, v16.16b, v16.16b, #8
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v29.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	mov	v28.d[1], v31.d[0]
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	rbit	v15.16b, v15.16b
	eor	v14.16b, v14.16b, v15.16b
	st1	{v14.16b}, [x1], #16
L_aes_gcm_decrypt_arm64_crypto_192_done:
	ands	w14, w2, #15
	beq	L_aes_gcm_decrypt_arm64_crypto_192_partial_done
	eor	v15.16b, v15.16b, v15.16b
	mov	w19, w14
	st1	{v15.2d}, [x11]
	cmp	x19, #8
	blt	L_aes_gcm_decrypt_arm64_crypto_192_start_dw
	ldr	x17, [x0], #8
	sub	x19, x19, #8
	str	x17, [x11], #8
L_aes_gcm_decrypt_arm64_crypto_192_start_dw:
	cmp	x19, #4
	blt	L_aes_gcm_decrypt_arm64_crypto_192_start_sw
	ldr	w17, [x0], #4
	sub	x19, x19, #4
	str	w17, [x11], #4
L_aes_gcm_decrypt_arm64_crypto_192_start_sw:
	cmp	x19, #2
	blt	L_aes_gcm_decrypt_arm64_crypto_192_start_byte
	ldrh	w17, [x0], #2
	sub	x19, x19, #2
	strh	w17, [x11], #2
L_aes_gcm_decrypt_arm64_crypto_192_start_byte:
	cbz	x19, L_aes_gcm_decrypt_arm64_crypto_192_end_bytes
	ldrb	w17, [x0], #1
	subs	x19, x19, #1
	strb	w17, [x11], #1
	bne	L_aes_gcm_decrypt_arm64_crypto_192_start_byte
L_aes_gcm_decrypt_arm64_crypto_192_end_bytes:
	sub	x11, x11, x14
	ld1	{v15.2d}, [x11]
	add	w15, w15, #1
	mov	v14.16b, v13.16b
	rbit	v15.16b, v15.16b
	rev	w16, w15
	mov	v14.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	eor	v16.16b, v26.16b, v15.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	#   X  = C * H^1
	pmull	v28.1q, v16.1d, v22.1d
	pmull2	v29.1q, v16.2d, v22.2d
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	ext	v31.16b, v16.16b, v16.16b, #8
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v29.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	mov	v28.d[1], v31.d[0]
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	rbit	v15.16b, v15.16b
	eor	v14.16b, v14.16b, v15.16b
	st1	{v14.2d}, [x11]
	cmp	w14, #8
	blt	L_aes_gcm_decrypt_arm64_crypto_192_out_start_dw
	ldr	x17, [x11], #8
	sub	w14, w14, #8
	str	x17, [x1], #8
L_aes_gcm_decrypt_arm64_crypto_192_out_start_dw:
	cmp	w14, #4
	blt	L_aes_gcm_decrypt_arm64_crypto_192_out_start_sw
	ldr	w17, [x11], #4
	sub	w14, w14, #4
	str	w17, [x1], #4
L_aes_gcm_decrypt_arm64_crypto_192_out_start_sw:
	cmp	w14, #2
	blt	L_aes_gcm_decrypt_arm64_crypto_192_out_start_byte
	ldrh	w17, [x11], #2
	sub	w14, w14, #2
	strh	w17, [x1], #2
L_aes_gcm_decrypt_arm64_crypto_192_out_start_byte:
	cbz	w14, L_aes_gcm_decrypt_arm64_crypto_192_out_end_bytes
	ldrb	w17, [x11], #1
	subs	w14, w14, #1
	strb	w17, [x1], #1
	bne	L_aes_gcm_decrypt_arm64_crypto_192_out_start_byte
L_aes_gcm_decrypt_arm64_crypto_192_out_end_bytes:
L_aes_gcm_decrypt_arm64_crypto_192_partial_done:
	ld1	{v14.2d}, [x12]
	lsl	x8, x8, #3
	rbit	x8, x8
	mov	v28.d[0], x8
	lsl	x2, x2, #3
	rbit	x2, x2
	mov	v28.d[1], x2
	eor	v26.16b, v26.16b, v28.16b
	pmull	v28.1q, v26.1d, v22.1d
	pmull2	v29.1q, v26.2d, v22.2d
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	ext	v31.16b, v26.16b, v26.16b, #8
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v29.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	mov	v28.d[1], v31.d[0]
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v28.16b, v30.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	rbit	v26.16b, v26.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	eor	v26.16b, v26.16b, v14.16b
	cmp	w6, #16
	blt	L_aes_gcm_decrypt_arm64_crypto_192_part_tag
	ld1	{v28.16b}, [x5]
	b	L_aes_gcm_decrypt_arm64_crypto_192_tag_loaded
L_aes_gcm_decrypt_arm64_crypto_192_part_tag:
	eor	v28.16b, v28.16b, v28.16b
	mov	x17, x6
	st1	{v28.2d}, [x11]
	cmp	x17, #8
	blt	L_aes_gcm_decrypt_arm64_crypto_192_tag_start_dw
	ldr	x16, [x5], #8
	sub	x17, x17, #8
	str	x16, [x11], #8
L_aes_gcm_decrypt_arm64_crypto_192_tag_start_dw:
	cmp	x17, #4
	blt	L_aes_gcm_decrypt_arm64_crypto_192_tag_start_sw
	ldr	w16, [x5], #4
	sub	x17, x17, #4
	str	w16, [x11], #4
L_aes_gcm_decrypt_arm64_crypto_192_tag_start_sw:
	cmp	x17, #2
	blt	L_aes_gcm_decrypt_arm64_crypto_192_tag_start_byte
	ldrh	w16, [x5], #2
	sub	x17, x17, #2
	strh	w16, [x11], #2
L_aes_gcm_decrypt_arm64_crypto_192_tag_start_byte:
	cbz	x17, L_aes_gcm_decrypt_arm64_crypto_192_tag_end_bytes
	ldrb	w16, [x5], #1
	subs	x17, x17, #1
	strb	w16, [x11], #1
	bne	L_aes_gcm_decrypt_arm64_crypto_192_tag_start_byte
L_aes_gcm_decrypt_arm64_crypto_192_tag_end_bytes:
	sub	x11, x11, x6
	ld1	{v28.2d}, [x11]
	mov	x17, #16
	st1	{v26.2d}, [x11]
	sub	x17, x17, x6
	add	x11, x11, x6
L_aes_gcm_decrypt_arm64_crypto_192_calc_tag_byte:
	strb	wzr, [x11], #1
	subs	x17, x17, #1
	bne	L_aes_gcm_decrypt_arm64_crypto_192_calc_tag_byte
	subs	x11, x11, #16
	ld1	{v26.2d}, [x11]
L_aes_gcm_decrypt_arm64_crypto_192_tag_loaded:
	eor	v28.16b, v28.16b, v26.16b
	mov	x16, v28.d[0]
	mov	x17, v28.d[1]
	mov	w19, #-180
	orr	x16, x16, x17
	cmp	x16, #0
	csetm	x0, ne
	and	x0, x0, x19
#endif /* !NO_AES_192 */
	b	L_aes_gcm_decrypt_arm64_crypto_done
	# AES_GCM_256
L_aes_gcm_decrypt_arm64_crypto_start_256:
#ifndef NO_AES_256
	cmp	w14, #32
	blt	L_aes_gcm_decrypt_arm64_crypto_256_start_4
L_aes_gcm_decrypt_arm64_crypto_256_start_8:
	ldr	q12, [x9]
	add	w24, w15, #1
	mov	v14.16b, v13.16b
	add	w23, w15, #2
	mov	v15.16b, v13.16b
	add	w22, w15, #3
	mov	v16.16b, v13.16b
	add	w21, w15, #4
	mov	v17.16b, v13.16b
	add	w20, w15, #5
	mov	v8.16b, v13.16b
	add	w19, w15, #6
	mov	v9.16b, v13.16b
	add	w17, w15, #7
	mov	v10.16b, v13.16b
	add	w15, w15, #8
	mov	v11.16b, v13.16b
	rev	w24, w24
	mov	v14.s[3], w24
	rev	w23, w23
	mov	v15.s[3], w23
	rev	w22, w22
	mov	v16.s[3], w22
	rev	w21, w21
	mov	v17.s[3], w21
	rev	w20, w20
	mov	v8.s[3], w20
	rev	w19, w19
	mov	v9.s[3], w19
	rev	w17, w17
	mov	v10.s[3], w17
	rev	w16, w15
	mov	v11.s[3], w16
	ldr	q13, [x9, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w14, w14, #8
	ldr	q12, [x9, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ld1	{v18.16b}, [x0], #16
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v19.16b}, [x0], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v20.16b}, [x0], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v21.16b}, [x0], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #160]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	ld1	{v0.16b}, [x0], #16
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	ld1	{v1.16b}, [x0], #16
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ld1	{v2.16b}, [x0], #16
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v3.16b}, [x0], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #176]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #192]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #208]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #224]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	eor	v8.16b, v8.16b, v0.16b
	eor	v9.16b, v9.16b, v1.16b
	eor	v10.16b, v10.16b, v2.16b
	eor	v11.16b, v11.16b, v3.16b
	ld1	{v13.2d}, [x12]
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x1], #0x40
	st1	{v8.16b, v9.16b, v10.16b, v11.16b}, [x1], #0x40
	cmp	w14, #8
	blt	L_aes_gcm_decrypt_arm64_crypto_256_end_8
L_aes_gcm_decrypt_arm64_crypto_256_both_8:
	ldr	q12, [x9]
	add	w24, w15, #1
	mov	v14.16b, v13.16b
	add	w23, w15, #2
	mov	v15.16b, v13.16b
	add	w22, w15, #3
	mov	v16.16b, v13.16b
	add	w21, w15, #4
	mov	v17.16b, v13.16b
	add	w20, w15, #5
	mov	v8.16b, v13.16b
	add	w19, w15, #6
	mov	v9.16b, v13.16b
	add	w17, w15, #7
	mov	v10.16b, v13.16b
	add	w15, w15, #8
	mov	v11.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w24, w24
	rbit	v19.16b, v19.16b
	mov	v14.s[3], w24
	rev	w23, w23
	rbit	v20.16b, v20.16b
	mov	v15.s[3], w23
	rev	w22, w22
	rbit	v21.16b, v21.16b
	mov	v16.s[3], w22
	rev	w21, w21
	rbit	v0.16b, v0.16b
	mov	v17.s[3], w21
	rev	w20, w20
	rbit	v1.16b, v1.16b
	mov	v8.s[3], w20
	rev	w19, w19
	rbit	v2.16b, v2.16b
	mov	v9.s[3], w19
	rev	w17, w17
	rbit	v3.16b, v3.16b
	mov	v10.s[3], w17
	rev	w16, w15
	eor	v18.16b, v18.16b, v26.16b
	mov	v11.s[3], w16
	ldr	q13, [x9, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ext	v31.16b, v3.16b, v3.16b, #8
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor	v31.16b, v31.16b, v29.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w14, w14, #8
	ldr	q12, [x9, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	mov	v28.d[1], v31.d[0]
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ld1	{v18.16b}, [x0], #16
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v19.16b}, [x0], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ld1	{v20.16b}, [x0], #16
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ld1	{v21.16b}, [x0], #16
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ld1	{v0.16b}, [x0], #16
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v1.16b}, [x0], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v2.16b}, [x0], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v3.16b}, [x0], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #160]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #176]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #192]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #208]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #224]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	ld1	{v13.2d}, [x12]
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x1], #0x40
	eor	v8.16b, v8.16b, v0.16b
	eor	v9.16b, v9.16b, v1.16b
	eor	v10.16b, v10.16b, v2.16b
	eor	v11.16b, v11.16b, v3.16b
	st1	{v8.16b, v9.16b, v10.16b, v11.16b}, [x1], #0x40
	cmp	w14, #8
	bge	L_aes_gcm_decrypt_arm64_crypto_256_both_8
L_aes_gcm_decrypt_arm64_crypto_256_end_8:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	rbit	v0.16b, v0.16b
	rbit	v1.16b, v1.16b
	rbit	v2.16b, v2.16b
	rbit	v3.16b, v3.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	ext	v31.16b, v3.16b, v3.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_decrypt_arm64_crypto_256_start_4:
	ld1	{v0.2d, v1.2d, v2.2d, v3.2d}, [x9], #0x40
	ld1	{v4.2d, v5.2d, v6.2d, v7.2d}, [x9], #0x40
	ld1	{v8.2d, v9.2d, v10.2d, v11.2d}, [x9], #0x40
	ld1	{v12.2d}, [x9], #16
	cmp	w14, #1
	blt	L_aes_gcm_decrypt_arm64_crypto_256_done
	beq	L_aes_gcm_decrypt_arm64_crypto_256_start_1
	cmp	w14, #4
	blt	L_aes_gcm_decrypt_arm64_crypto_256_start_2
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w19, w15, #2
	mov	v15.16b, v13.16b
	add	w17, w15, #3
	mov	v16.16b, v13.16b
	add	w15, w15, #4
	mov	v17.16b, v13.16b
	rev	w20, w20
	mov	v14.s[3], w20
	rev	w19, w19
	mov	v15.s[3], w19
	rev	w17, w17
	mov	v16.s[3], w17
	rev	w16, w15
	mov	v17.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w14, w14, #4
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b}, [x0], #16
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	ld1	{v19.16b}, [x0], #16
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	ld1	{v20.16b}, [x0], #16
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	ld1	{v21.16b}, [x0], #16
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v11.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v11.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v11.16b
	aesmc	v17.16b, v17.16b
	ld1	{v29.2d, v30.2d}, [x9]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	aese	v15.16b, v29.16b
	eor	v15.16b, v15.16b, v30.16b
	aese	v16.16b, v29.16b
	eor	v16.16b, v16.16b, v30.16b
	aese	v17.16b, v29.16b
	eor	v17.16b, v17.16b, v30.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	cmp	w14, #4
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x1], #0x40
	blt	L_aes_gcm_decrypt_arm64_crypto_256_end_4
L_aes_gcm_decrypt_arm64_crypto_256_both_4:
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w19, w15, #2
	mov	v15.16b, v13.16b
	add	w17, w15, #3
	mov	v16.16b, v13.16b
	add	w15, w15, #4
	mov	v17.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w20, w20
	rbit	v19.16b, v19.16b
	mov	v14.s[3], w20
	rev	w19, w19
	rbit	v20.16b, v20.16b
	mov	v15.s[3], w19
	rev	w17, w17
	rbit	v21.16b, v21.16b
	mov	v16.s[3], w17
	rev	w16, w15
	mov	v17.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	eor	v18.16b, v18.16b, v26.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	ext	v31.16b, v21.16b, v21.16b, #8
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	eor	v31.16b, v31.16b, v29.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w14, w14, #4
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	mov	v28.d[1], v31.d[0]
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x0], #0x40
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v11.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v11.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v11.16b
	aesmc	v17.16b, v17.16b
	ld1	{v29.2d, v30.2d}, [x9]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	aese	v15.16b, v29.16b
	eor	v15.16b, v15.16b, v30.16b
	aese	v16.16b, v29.16b
	eor	v16.16b, v16.16b, v30.16b
	aese	v17.16b, v29.16b
	eor	v17.16b, v17.16b, v30.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	cmp	w14, #4
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x1], #0x40
	bge	L_aes_gcm_decrypt_arm64_crypto_256_both_4
L_aes_gcm_decrypt_arm64_crypto_256_end_4:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cmp	w14, #1
	beq	L_aes_gcm_decrypt_arm64_crypto_256_start_1
	blt	L_aes_gcm_decrypt_arm64_crypto_256_done
L_aes_gcm_decrypt_arm64_crypto_256_start_2:
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w15, w15, #2
	mov	v15.16b, v13.16b
	rev	w20, w20
	mov	v14.s[3], w20
	rev	w16, w15
	mov	v15.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	subs	w14, w14, #2
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x0], #16
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	ld1	{v19.16b}, [x0], #16
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v11.16b
	aesmc	v15.16b, v15.16b
	ld1	{v29.2d, v30.2d}, [x9]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	aese	v15.16b, v29.16b
	eor	v15.16b, v15.16b, v30.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	st1	{v14.16b, v15.16b}, [x1], #32
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v19.1d, v22.1d
	pmull2	v29.1q, v19.2d, v22.2d
	ext	v31.16b, v19.16b, v19.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v21.1d
	pmull2	v26.1q, v23.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cbz	w14, L_aes_gcm_decrypt_arm64_crypto_256_done
L_aes_gcm_decrypt_arm64_crypto_256_start_1:
	add	w15, w15, #1
	mov	v14.16b, v13.16b
	rev	w16, w15
	mov	v14.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x0], #16
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	ldr	q29, [x9]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ldr	q30, [x9, #16]
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	eor	v14.16b, v14.16b, v18.16b
	st1	{v14.16b}, [x1], #16
	rbit	v18.16b, v18.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_decrypt_arm64_crypto_256_done:
	ands	w14, w2, #15
	beq	L_aes_gcm_decrypt_arm64_crypto_256_partial_done
	eor	v15.16b, v15.16b, v15.16b
	mov	w19, w14
	st1	{v15.2d}, [x11]
	cmp	x19, #8
	blt	L_aes_gcm_decrypt_arm64_crypto_256_start_dw
	ldr	x17, [x0], #8
	sub	x19, x19, #8
	str	x17, [x11], #8
L_aes_gcm_decrypt_arm64_crypto_256_start_dw:
	cmp	x19, #4
	blt	L_aes_gcm_decrypt_arm64_crypto_256_start_sw
	ldr	w17, [x0], #4
	sub	x19, x19, #4
	str	w17, [x11], #4
L_aes_gcm_decrypt_arm64_crypto_256_start_sw:
	cmp	x19, #2
	blt	L_aes_gcm_decrypt_arm64_crypto_256_start_byte
	ldrh	w17, [x0], #2
	sub	x19, x19, #2
	strh	w17, [x11], #2
L_aes_gcm_decrypt_arm64_crypto_256_start_byte:
	cbz	x19, L_aes_gcm_decrypt_arm64_crypto_256_end_bytes
	ldrb	w17, [x0], #1
	subs	x19, x19, #1
	strb	w17, [x11], #1
	bne	L_aes_gcm_decrypt_arm64_crypto_256_start_byte
L_aes_gcm_decrypt_arm64_crypto_256_end_bytes:
	sub	x11, x11, x14
	ld1	{v15.2d}, [x11]
	add	w15, w15, #1
	mov	v14.16b, v13.16b
	rbit	v15.16b, v15.16b
	rev	w16, w15
	mov	v14.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	eor	v16.16b, v26.16b, v15.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	#   X  = C * H^1
	pmull	v28.1q, v16.1d, v22.1d
	pmull2	v29.1q, v16.2d, v22.2d
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	ext	v31.16b, v16.16b, v16.16b, #8
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v29.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	mov	v28.d[1], v31.d[0]
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	ldr	q29, [x9]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ldr	q30, [x9, #16]
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	rbit	v15.16b, v15.16b
	eor	v14.16b, v14.16b, v15.16b
	st1	{v14.2d}, [x11]
	cmp	w14, #8
	blt	L_aes_gcm_decrypt_arm64_crypto_256_out_start_dw
	ldr	x17, [x11], #8
	sub	w14, w14, #8
	str	x17, [x1], #8
L_aes_gcm_decrypt_arm64_crypto_256_out_start_dw:
	cmp	w14, #4
	blt	L_aes_gcm_decrypt_arm64_crypto_256_out_start_sw
	ldr	w17, [x11], #4
	sub	w14, w14, #4
	str	w17, [x1], #4
L_aes_gcm_decrypt_arm64_crypto_256_out_start_sw:
	cmp	w14, #2
	blt	L_aes_gcm_decrypt_arm64_crypto_256_out_start_byte
	ldrh	w17, [x11], #2
	sub	w14, w14, #2
	strh	w17, [x1], #2
L_aes_gcm_decrypt_arm64_crypto_256_out_start_byte:
	cbz	w14, L_aes_gcm_decrypt_arm64_crypto_256_out_end_bytes
	ldrb	w17, [x11], #1
	subs	w14, w14, #1
	strb	w17, [x1], #1
	bne	L_aes_gcm_decrypt_arm64_crypto_256_out_start_byte
L_aes_gcm_decrypt_arm64_crypto_256_out_end_bytes:
L_aes_gcm_decrypt_arm64_crypto_256_partial_done:
	ld1	{v14.2d}, [x12]
	lsl	x8, x8, #3
	rbit	x8, x8
	mov	v28.d[0], x8
	lsl	x2, x2, #3
	rbit	x2, x2
	mov	v28.d[1], x2
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v26.16b, v28.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	pmull	v28.1q, v26.1d, v22.1d
	pmull2	v29.1q, v26.2d, v22.2d
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	ext	v31.16b, v26.16b, v26.16b, #8
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v29.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	pmull2	v30.1q, v31.2d, v27.2d
	ldr	q11, [x9, #-32]
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	mov	v28.d[1], v31.d[0]
	ldr	q12, [x9, #-16]
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v28.16b, v30.16b
	ldr	q29, [x9]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	rbit	v26.16b, v26.16b
	ldr	q30, [x9, #16]
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	eor	v26.16b, v26.16b, v14.16b
	cmp	w6, #16
	blt	L_aes_gcm_decrypt_arm64_crypto_256_part_tag
	ld1	{v28.16b}, [x5]
	b	L_aes_gcm_decrypt_arm64_crypto_256_tag_loaded
L_aes_gcm_decrypt_arm64_crypto_256_part_tag:
	eor	v28.16b, v28.16b, v28.16b
	mov	x17, x6
	st1	{v28.2d}, [x11]
	cmp	x17, #8
	blt	L_aes_gcm_decrypt_arm64_crypto_256_tag_start_dw
	ldr	x16, [x5], #8
	sub	x17, x17, #8
	str	x16, [x11], #8
L_aes_gcm_decrypt_arm64_crypto_256_tag_start_dw:
	cmp	x17, #4
	blt	L_aes_gcm_decrypt_arm64_crypto_256_tag_start_sw
	ldr	w16, [x5], #4
	sub	x17, x17, #4
	str	w16, [x11], #4
L_aes_gcm_decrypt_arm64_crypto_256_tag_start_sw:
	cmp	x17, #2
	blt	L_aes_gcm_decrypt_arm64_crypto_256_tag_start_byte
	ldrh	w16, [x5], #2
	sub	x17, x17, #2
	strh	w16, [x11], #2
L_aes_gcm_decrypt_arm64_crypto_256_tag_start_byte:
	cbz	x17, L_aes_gcm_decrypt_arm64_crypto_256_tag_end_bytes
	ldrb	w16, [x5], #1
	subs	x17, x17, #1
	strb	w16, [x11], #1
	bne	L_aes_gcm_decrypt_arm64_crypto_256_tag_start_byte
L_aes_gcm_decrypt_arm64_crypto_256_tag_end_bytes:
	sub	x11, x11, x6
	ld1	{v28.2d}, [x11]
	mov	x17, #16
	st1	{v26.2d}, [x11]
	sub	x17, x17, x6
	add	x11, x11, x6
L_aes_gcm_decrypt_arm64_crypto_256_calc_tag_byte:
	strb	wzr, [x11], #1
	subs	x17, x17, #1
	bne	L_aes_gcm_decrypt_arm64_crypto_256_calc_tag_byte
	subs	x11, x11, #16
	ld1	{v26.2d}, [x11]
L_aes_gcm_decrypt_arm64_crypto_256_tag_loaded:
	eor	v28.16b, v28.16b, v26.16b
	mov	x16, v28.d[0]
	mov	x17, v28.d[1]
	mov	w19, #-180
	orr	x16, x16, x17
	cmp	x16, #0
	csetm	x0, ne
	and	x0, x0, x19
#endif /* !NO_AES_256 */
	b	L_aes_gcm_decrypt_arm64_crypto_done
	# AES_GCM_128
L_aes_gcm_decrypt_arm64_crypto_start_128:
#ifndef NO_AES_128
	cmp	w14, #32
	blt	L_aes_gcm_decrypt_arm64_crypto_128_start_4
L_aes_gcm_decrypt_arm64_crypto_128_start_8:
	ldr	q12, [x9]
	add	w24, w15, #1
	mov	v14.16b, v13.16b
	add	w23, w15, #2
	mov	v15.16b, v13.16b
	add	w22, w15, #3
	mov	v16.16b, v13.16b
	add	w21, w15, #4
	mov	v17.16b, v13.16b
	add	w20, w15, #5
	mov	v8.16b, v13.16b
	add	w19, w15, #6
	mov	v9.16b, v13.16b
	add	w17, w15, #7
	mov	v10.16b, v13.16b
	add	w15, w15, #8
	mov	v11.16b, v13.16b
	rev	w24, w24
	mov	v14.s[3], w24
	rev	w23, w23
	mov	v15.s[3], w23
	rev	w22, w22
	mov	v16.s[3], w22
	rev	w21, w21
	mov	v17.s[3], w21
	rev	w20, w20
	mov	v8.s[3], w20
	rev	w19, w19
	mov	v9.s[3], w19
	rev	w17, w17
	mov	v10.s[3], w17
	rev	w16, w15
	mov	v11.s[3], w16
	ldr	q13, [x9, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w14, w14, #8
	ldr	q12, [x9, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ld1	{v18.16b}, [x0], #16
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v19.16b}, [x0], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v20.16b}, [x0], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v21.16b}, [x0], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #160]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	ld1	{v0.16b}, [x0], #16
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	ld1	{v1.16b}, [x0], #16
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	ld1	{v2.16b}, [x0], #16
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	ld1	{v3.16b}, [x0], #16
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	eor	v8.16b, v8.16b, v0.16b
	eor	v9.16b, v9.16b, v1.16b
	eor	v10.16b, v10.16b, v2.16b
	eor	v11.16b, v11.16b, v3.16b
	ld1	{v13.2d}, [x12]
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x1], #0x40
	st1	{v8.16b, v9.16b, v10.16b, v11.16b}, [x1], #0x40
	cmp	w14, #8
	blt	L_aes_gcm_decrypt_arm64_crypto_128_end_8
L_aes_gcm_decrypt_arm64_crypto_128_both_8:
	ldr	q12, [x9]
	add	w24, w15, #1
	mov	v14.16b, v13.16b
	add	w23, w15, #2
	mov	v15.16b, v13.16b
	add	w22, w15, #3
	mov	v16.16b, v13.16b
	add	w21, w15, #4
	mov	v17.16b, v13.16b
	add	w20, w15, #5
	mov	v8.16b, v13.16b
	add	w19, w15, #6
	mov	v9.16b, v13.16b
	add	w17, w15, #7
	mov	v10.16b, v13.16b
	add	w15, w15, #8
	mov	v11.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w24, w24
	rbit	v19.16b, v19.16b
	mov	v14.s[3], w24
	rev	w23, w23
	rbit	v20.16b, v20.16b
	mov	v15.s[3], w23
	rev	w22, w22
	rbit	v21.16b, v21.16b
	mov	v16.s[3], w22
	rev	w21, w21
	rbit	v0.16b, v0.16b
	mov	v17.s[3], w21
	rev	w20, w20
	rbit	v1.16b, v1.16b
	mov	v8.s[3], w20
	rev	w19, w19
	rbit	v2.16b, v2.16b
	mov	v9.s[3], w19
	rev	w17, w17
	rbit	v3.16b, v3.16b
	mov	v10.s[3], w17
	rev	w16, w15
	eor	v18.16b, v18.16b, v26.16b
	mov	v11.s[3], w16
	ldr	q13, [x9, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ext	v31.16b, v3.16b, v3.16b, #8
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor	v31.16b, v31.16b, v29.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w14, w14, #8
	ldr	q12, [x9, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	mov	v28.d[1], v31.d[0]
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ld1	{v18.16b}, [x0], #16
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v19.16b}, [x0], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ld1	{v20.16b}, [x0], #16
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ld1	{v21.16b}, [x0], #16
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ld1	{v0.16b}, [x0], #16
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v1.16b}, [x0], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v2.16b}, [x0], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v3.16b}, [x0], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #160]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	ld1	{v13.2d}, [x12]
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x1], #0x40
	eor	v8.16b, v8.16b, v0.16b
	eor	v9.16b, v9.16b, v1.16b
	eor	v10.16b, v10.16b, v2.16b
	eor	v11.16b, v11.16b, v3.16b
	st1	{v8.16b, v9.16b, v10.16b, v11.16b}, [x1], #0x40
	cmp	w14, #8
	bge	L_aes_gcm_decrypt_arm64_crypto_128_both_8
L_aes_gcm_decrypt_arm64_crypto_128_end_8:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	rbit	v0.16b, v0.16b
	rbit	v1.16b, v1.16b
	rbit	v2.16b, v2.16b
	rbit	v3.16b, v3.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	ext	v31.16b, v3.16b, v3.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_decrypt_arm64_crypto_128_start_4:
	ld1	{v0.2d, v1.2d, v2.2d, v3.2d}, [x9], #0x40
	ld1	{v4.2d, v5.2d, v6.2d, v7.2d}, [x9], #0x40
	ld1	{v8.2d, v9.2d}, [x9], #32
	ld1	{v10.2d}, [x9]
	cmp	w14, #1
	blt	L_aes_gcm_decrypt_arm64_crypto_128_done
	beq	L_aes_gcm_decrypt_arm64_crypto_128_start_1
	cmp	w14, #4
	blt	L_aes_gcm_decrypt_arm64_crypto_128_start_2
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w19, w15, #2
	mov	v15.16b, v13.16b
	add	w17, w15, #3
	mov	v16.16b, v13.16b
	add	w15, w15, #4
	mov	v17.16b, v13.16b
	rev	w20, w20
	mov	v14.s[3], w20
	rev	w19, w19
	mov	v15.s[3], w19
	rev	w17, w17
	mov	v16.s[3], w17
	rev	w16, w15
	mov	v17.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w14, w14, #4
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b}, [x0], #16
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	ld1	{v19.16b}, [x0], #16
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	ld1	{v20.16b}, [x0], #16
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	ld1	{v21.16b}, [x0], #16
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	aese	v15.16b, v9.16b
	eor	v15.16b, v15.16b, v10.16b
	aese	v16.16b, v9.16b
	eor	v16.16b, v16.16b, v10.16b
	aese	v17.16b, v9.16b
	eor	v17.16b, v17.16b, v10.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	cmp	w14, #4
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x1], #0x40
	blt	L_aes_gcm_decrypt_arm64_crypto_128_end_4
L_aes_gcm_decrypt_arm64_crypto_128_both_4:
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w19, w15, #2
	mov	v15.16b, v13.16b
	add	w17, w15, #3
	mov	v16.16b, v13.16b
	add	w15, w15, #4
	mov	v17.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w20, w20
	rbit	v19.16b, v19.16b
	mov	v14.s[3], w20
	rev	w19, w19
	rbit	v20.16b, v20.16b
	mov	v15.s[3], w19
	rev	w17, w17
	rbit	v21.16b, v21.16b
	mov	v16.s[3], w17
	rev	w16, w15
	mov	v17.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	eor	v18.16b, v18.16b, v26.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	ext	v31.16b, v21.16b, v21.16b, #8
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	eor	v31.16b, v31.16b, v29.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w14, w14, #4
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	mov	v28.d[1], v31.d[0]
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x0], #0x40
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	aese	v15.16b, v9.16b
	eor	v15.16b, v15.16b, v10.16b
	aese	v16.16b, v9.16b
	eor	v16.16b, v16.16b, v10.16b
	aese	v17.16b, v9.16b
	eor	v17.16b, v17.16b, v10.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	cmp	w14, #4
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x1], #0x40
	bge	L_aes_gcm_decrypt_arm64_crypto_128_both_4
L_aes_gcm_decrypt_arm64_crypto_128_end_4:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cmp	w14, #1
	beq	L_aes_gcm_decrypt_arm64_crypto_128_start_1
	blt	L_aes_gcm_decrypt_arm64_crypto_128_done
L_aes_gcm_decrypt_arm64_crypto_128_start_2:
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w15, w15, #2
	mov	v15.16b, v13.16b
	rev	w20, w20
	mov	v14.s[3], w20
	rev	w16, w15
	mov	v15.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	subs	w14, w14, #2
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x0], #16
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	ld1	{v19.16b}, [x0], #16
	aese	v15.16b, v9.16b
	eor	v15.16b, v15.16b, v10.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	st1	{v14.16b, v15.16b}, [x1], #32
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v19.1d, v22.1d
	pmull2	v29.1q, v19.2d, v22.2d
	ext	v31.16b, v19.16b, v19.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v21.1d
	pmull2	v26.1q, v23.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cbz	w14, L_aes_gcm_decrypt_arm64_crypto_128_done
L_aes_gcm_decrypt_arm64_crypto_128_start_1:
	add	w15, w15, #1
	mov	v14.16b, v13.16b
	rev	w16, w15
	mov	v14.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	ld1	{v18.16b}, [x0], #16
	eor	v14.16b, v14.16b, v18.16b
	st1	{v14.16b}, [x1], #16
	rbit	v18.16b, v18.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_decrypt_arm64_crypto_128_done:
	ands	w14, w2, #15
	beq	L_aes_gcm_decrypt_arm64_crypto_128_partial_done
	eor	v15.16b, v15.16b, v15.16b
	mov	w19, w14
	st1	{v15.2d}, [x11]
	cmp	x19, #8
	blt	L_aes_gcm_decrypt_arm64_crypto_128_start_dw
	ldr	x17, [x0], #8
	sub	x19, x19, #8
	str	x17, [x11], #8
L_aes_gcm_decrypt_arm64_crypto_128_start_dw:
	cmp	x19, #4
	blt	L_aes_gcm_decrypt_arm64_crypto_128_start_sw
	ldr	w17, [x0], #4
	sub	x19, x19, #4
	str	w17, [x11], #4
L_aes_gcm_decrypt_arm64_crypto_128_start_sw:
	cmp	x19, #2
	blt	L_aes_gcm_decrypt_arm64_crypto_128_start_byte
	ldrh	w17, [x0], #2
	sub	x19, x19, #2
	strh	w17, [x11], #2
L_aes_gcm_decrypt_arm64_crypto_128_start_byte:
	cbz	x19, L_aes_gcm_decrypt_arm64_crypto_128_end_bytes
	ldrb	w17, [x0], #1
	subs	x19, x19, #1
	strb	w17, [x11], #1
	bne	L_aes_gcm_decrypt_arm64_crypto_128_start_byte
L_aes_gcm_decrypt_arm64_crypto_128_end_bytes:
	sub	x11, x11, x14
	ld1	{v15.2d}, [x11]
	add	w15, w15, #1
	mov	v14.16b, v13.16b
	rbit	v15.16b, v15.16b
	rev	w16, w15
	mov	v14.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	eor	v16.16b, v26.16b, v15.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	#   X  = C * H^1
	pmull	v28.1q, v16.1d, v22.1d
	pmull2	v29.1q, v16.2d, v22.2d
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	ext	v31.16b, v16.16b, v16.16b, #8
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v29.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	rbit	v15.16b, v15.16b
	eor	v14.16b, v14.16b, v15.16b
	st1	{v14.2d}, [x11]
	cmp	w14, #8
	blt	L_aes_gcm_decrypt_arm64_crypto_128_out_start_dw
	ldr	x17, [x11], #8
	sub	w14, w14, #8
	str	x17, [x1], #8
L_aes_gcm_decrypt_arm64_crypto_128_out_start_dw:
	cmp	w14, #4
	blt	L_aes_gcm_decrypt_arm64_crypto_128_out_start_sw
	ldr	w17, [x11], #4
	sub	w14, w14, #4
	str	w17, [x1], #4
L_aes_gcm_decrypt_arm64_crypto_128_out_start_sw:
	cmp	w14, #2
	blt	L_aes_gcm_decrypt_arm64_crypto_128_out_start_byte
	ldrh	w17, [x11], #2
	sub	w14, w14, #2
	strh	w17, [x1], #2
L_aes_gcm_decrypt_arm64_crypto_128_out_start_byte:
	cbz	w14, L_aes_gcm_decrypt_arm64_crypto_128_out_end_bytes
	ldrb	w17, [x11], #1
	subs	w14, w14, #1
	strb	w17, [x1], #1
	bne	L_aes_gcm_decrypt_arm64_crypto_128_out_start_byte
L_aes_gcm_decrypt_arm64_crypto_128_out_end_bytes:
L_aes_gcm_decrypt_arm64_crypto_128_partial_done:
	ld1	{v14.2d}, [x12]
	lsl	x8, x8, #3
	rbit	x8, x8
	mov	v28.d[0], x8
	lsl	x2, x2, #3
	rbit	x2, x2
	mov	v28.d[1], x2
	eor	v26.16b, v26.16b, v28.16b
	pmull	v28.1q, v26.1d, v22.1d
	pmull2	v29.1q, v26.2d, v22.2d
	ext	v31.16b, v26.16b, v26.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v29.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	mov	v28.d[1], v31.d[0]
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v28.16b, v30.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	rbit	v26.16b, v26.16b
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	eor	v26.16b, v26.16b, v14.16b
	cmp	w6, #16
	blt	L_aes_gcm_decrypt_arm64_crypto_128_part_tag
	ld1	{v28.16b}, [x5]
	b	L_aes_gcm_decrypt_arm64_crypto_128_tag_loaded
L_aes_gcm_decrypt_arm64_crypto_128_part_tag:
	eor	v28.16b, v28.16b, v28.16b
	mov	x17, x6
	st1	{v28.2d}, [x11]
	cmp	x17, #8
	blt	L_aes_gcm_decrypt_arm64_crypto_128_tag_start_dw
	ldr	x16, [x5], #8
	sub	x17, x17, #8
	str	x16, [x11], #8
L_aes_gcm_decrypt_arm64_crypto_128_tag_start_dw:
	cmp	x17, #4
	blt	L_aes_gcm_decrypt_arm64_crypto_128_tag_start_sw
	ldr	w16, [x5], #4
	sub	x17, x17, #4
	str	w16, [x11], #4
L_aes_gcm_decrypt_arm64_crypto_128_tag_start_sw:
	cmp	x17, #2
	blt	L_aes_gcm_decrypt_arm64_crypto_128_tag_start_byte
	ldrh	w16, [x5], #2
	sub	x17, x17, #2
	strh	w16, [x11], #2
L_aes_gcm_decrypt_arm64_crypto_128_tag_start_byte:
	cbz	x17, L_aes_gcm_decrypt_arm64_crypto_128_tag_end_bytes
	ldrb	w16, [x5], #1
	subs	x17, x17, #1
	strb	w16, [x11], #1
	bne	L_aes_gcm_decrypt_arm64_crypto_128_tag_start_byte
L_aes_gcm_decrypt_arm64_crypto_128_tag_end_bytes:
	sub	x11, x11, x6
	ld1	{v28.2d}, [x11]
	mov	x17, #16
	st1	{v26.2d}, [x11]
	sub	x17, x17, x6
	add	x11, x11, x6
L_aes_gcm_decrypt_arm64_crypto_128_calc_tag_byte:
	strb	wzr, [x11], #1
	subs	x17, x17, #1
	bne	L_aes_gcm_decrypt_arm64_crypto_128_calc_tag_byte
	subs	x11, x11, #16
	ld1	{v26.2d}, [x11]
L_aes_gcm_decrypt_arm64_crypto_128_tag_loaded:
	eor	v28.16b, v28.16b, v26.16b
	mov	x16, v28.d[0]
	mov	x17, v28.d[1]
	mov	w19, #-180
	orr	x16, x16, x17
	cmp	x16, #0
	csetm	x0, ne
	and	x0, x0, x19
#endif /* !NO_AES_128 */
L_aes_gcm_decrypt_arm64_crypto_done:
	ldp	x17, x19, [x29, #24]
	ldp	x20, x21, [x29, #40]
	ldp	x22, x23, [x29, #56]
	ldr	x24, [x29, #72]
	ldp	d8, d9, [x29, #80]
	ldp	d10, d11, [x29, #96]
	ldp	d12, d13, [x29, #112]
	ldp	d14, d15, [x29, #128]
	ldp	x29, x30, [sp], #0x90
	ret
#ifndef __APPLE__
	.size	AES_GCM_decrypt_AARCH64,.-AES_GCM_decrypt_AARCH64
#endif /* __APPLE__ */
#endif /* HAVE_AES_DECRYPT */
#ifdef WOLFSSL_ARMASM_CRYPTO_SHA3
#ifndef __APPLE__
.text
.globl	AES_GCM_encrypt_AARCH64_EOR3
.type	AES_GCM_encrypt_AARCH64_EOR3,@function
.align	2
AES_GCM_encrypt_AARCH64_EOR3:
#else
.section	__TEXT,__text
.globl	_AES_GCM_encrypt_AARCH64_EOR3
.p2align	2
_AES_GCM_encrypt_AARCH64_EOR3:
#endif /* __APPLE__ */
	stp	x29, x30, [sp, #-144]!
	add	x29, sp, #0
	stp	x17, x19, [x29, #24]
	stp	x20, x21, [x29, #40]
	stp	x22, x23, [x29, #56]
	str	x24, [x29, #72]
	stp	d8, d9, [x29, #80]
	stp	d10, d11, [x29, #96]
	stp	d12, d13, [x29, #112]
	stp	d14, d15, [x29, #128]
	ldr	w8, [x29, #144]
	ldr	x9, [x29, #152]
	ldr	x10, [x29, #160]
	ldr	x11, [x29, #168]
	ldr	x12, [x29, #176]
	ldr	w13, [x29, #184]
	movi	v27.16b, #0x87
	eor	v26.16b, v26.16b, v26.16b
	ushr	v27.2d, v27.2d, #56
	ld1	{v22.2d}, [x10]
	cmp	w8, #0x40
	csetm	x16, lt
	cmp	w2, #32
	csetm	x17, lt
	ands	x16, x16, x17
	bne	L_aes_gcm_encrypt_arm64_crypto_eor3_h_done
	# Square H => H^2
	pmull2	v31.1q, v22.2d, v22.2d
	pmull	v30.1q, v22.1d, v22.1d
	pmull2	v28.1q, v31.2d, v27.2d
	ext	v29.16b, v30.16b, v31.16b, #8
	eor	v29.16b, v29.16b, v28.16b
	pmull2	v31.1q, v29.2d, v27.2d
	mov	v30.d[1], v29.d[0]
	eor	v23.16b, v30.16b, v31.16b
	cmp	w8, #0x100
	csetm	x16, lt
	cmp	w2, #0x40
	csetm	x17, lt
	ands	x16, x16, x17
	bne	L_aes_gcm_encrypt_arm64_crypto_eor3_h_done
	# Multiply H and H^2  => H^3
	pmull	v28.1q, v22.1d, v23.1d
	pmull2	v29.1q, v22.2d, v23.2d
	ext	v31.16b, v22.16b, v22.16b, #8
	pmull	v30.1q, v31.1d, v23.1d
	pmull2	v31.1q, v31.2d, v23.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v24.16b, v28.16b, v30.16b
	# Square H^2 => H^4
	pmull2	v31.1q, v23.2d, v23.2d
	pmull	v30.1q, v23.1d, v23.1d
	pmull2	v28.1q, v31.2d, v27.2d
	ext	v29.16b, v30.16b, v31.16b, #8
	eor	v29.16b, v29.16b, v28.16b
	pmull2	v31.1q, v29.2d, v27.2d
	mov	v30.d[1], v29.d[0]
	eor	v25.16b, v30.16b, v31.16b
	# Done
	cmp	w8, #0x400
	csetm	x16, lt
	cmp	w2, #0x200
	csetm	x17, lt
	ands	x16, x16, x17
	bne	L_aes_gcm_encrypt_arm64_crypto_eor3_h_done
	# Multiply H and H^4  => H^5
	pmull	v28.1q, v22.1d, v25.1d
	pmull2	v29.1q, v22.2d, v25.2d
	ext	v31.16b, v22.16b, v22.16b, #8
	pmull	v30.1q, v31.1d, v25.1d
	pmull2	v31.1q, v31.2d, v25.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v4.16b, v28.16b, v30.16b
	# Square H^3 => H^6
	pmull2	v31.1q, v24.2d, v24.2d
	pmull	v30.1q, v24.1d, v24.1d
	pmull2	v28.1q, v31.2d, v27.2d
	ext	v29.16b, v30.16b, v31.16b, #8
	eor	v29.16b, v29.16b, v28.16b
	pmull2	v31.1q, v29.2d, v27.2d
	mov	v30.d[1], v29.d[0]
	eor	v5.16b, v30.16b, v31.16b
	# Multiply H and H^6  => H^7
	pmull	v28.1q, v22.1d, v5.1d
	pmull2	v29.1q, v22.2d, v5.2d
	ext	v31.16b, v22.16b, v22.16b, #8
	pmull	v30.1q, v31.1d, v5.1d
	pmull2	v31.1q, v31.2d, v5.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v6.16b, v28.16b, v30.16b
	# Square H^4 => H^8
	pmull2	v31.1q, v25.2d, v25.2d
	pmull	v30.1q, v25.1d, v25.1d
	pmull2	v28.1q, v31.2d, v27.2d
	ext	v29.16b, v30.16b, v31.16b, #8
	eor	v29.16b, v29.16b, v28.16b
	pmull2	v31.1q, v29.2d, v27.2d
	mov	v30.d[1], v29.d[0]
	eor	v7.16b, v30.16b, v31.16b
	# Done
L_aes_gcm_encrypt_arm64_crypto_eor3_h_done:
	lsr	w14, w8, #4
	cmp	w14, #4
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_aad_start_1
	cmp	w14, #16
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_aad_start_2
	cmp	w14, #0x40
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_aad_start_4
L_aes_gcm_encrypt_arm64_crypto_eor3_aad_start_8:
	ld1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x7], #0x40
	ld1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x7], #0x40
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	rbit	v0.16b, v0.16b
	rbit	v1.16b, v1.16b
	rbit	v2.16b, v2.16b
	rbit	v3.16b, v3.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	ext	v31.16b, v3.16b, v3.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	sub	w14, w14, #8
	cmp	w14, #8
	bge	L_aes_gcm_encrypt_arm64_crypto_eor3_aad_start_8
	cmp	w14, #1
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_aad_done
	beq	L_aes_gcm_encrypt_arm64_crypto_eor3_aad_start_1
	cmp	w14, #16
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_aad_start_2
L_aes_gcm_encrypt_arm64_crypto_eor3_aad_start_4:
	ld1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x7], #0x40
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	sub	w14, w14, #4
	cmp	w14, #4
	bge	L_aes_gcm_encrypt_arm64_crypto_eor3_aad_start_4
	cmp	w14, #1
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_aad_done
	beq	L_aes_gcm_encrypt_arm64_crypto_eor3_aad_start_1
L_aes_gcm_encrypt_arm64_crypto_eor3_aad_start_2:
	ld1	{v18.16b, v19.16b}, [x7], #32
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v19.1d, v22.1d
	pmull2	v29.1q, v19.2d, v22.2d
	ext	v31.16b, v19.16b, v19.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v21.1d
	pmull2	v26.1q, v23.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	sub	w14, w14, #2
	cmp	w14, #1
	bgt	L_aes_gcm_encrypt_arm64_crypto_eor3_aad_start_2
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_aad_done
L_aes_gcm_encrypt_arm64_crypto_eor3_aad_start_1:
	cbz	w14, L_aes_gcm_encrypt_arm64_crypto_eor3_aad_done
L_aes_gcm_encrypt_arm64_crypto_eor3_aad_both_1:
	ld1	{v18.16b}, [x7], #16
	rbit	v18.16b, v18.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	subs	w14, w14, #1
	bne	L_aes_gcm_encrypt_arm64_crypto_eor3_aad_both_1
L_aes_gcm_encrypt_arm64_crypto_eor3_aad_done:
	and	w14, w8, #15
	cbz	w14, L_aes_gcm_encrypt_arm64_crypto_eor3_aad_partial_done
	eor	v28.16b, v28.16b, v28.16b
	mov	w20, w14
	st1	{v28.2d}, [x11]
	cmp	w20, #8
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_aad_start_dw
	ldr	x19, [x7], #8
	sub	w20, w20, #8
	str	x19, [x11], #8
L_aes_gcm_encrypt_arm64_crypto_eor3_aad_start_dw:
	cmp	w20, #4
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_aad_start_sw
	ldr	w19, [x7], #4
	sub	w20, w20, #4
	str	w19, [x11], #4
L_aes_gcm_encrypt_arm64_crypto_eor3_aad_start_sw:
	cmp	w20, #2
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_aad_start_byte
	ldrh	w19, [x7], #2
	sub	w20, w20, #2
	strh	w19, [x11], #2
L_aes_gcm_encrypt_arm64_crypto_eor3_aad_start_byte:
	cbz	w20, L_aes_gcm_encrypt_arm64_crypto_eor3_aad_end_bytes
	ldrb	w19, [x7], #1
	subs	w20, w20, #1
	strb	w19, [x11], #1
	bne	L_aes_gcm_encrypt_arm64_crypto_eor3_aad_start_byte
L_aes_gcm_encrypt_arm64_crypto_eor3_aad_end_bytes:
	sub	x11, x11, x14
	ld1	{v18.2d}, [x11]
	rbit	v18.16b, v18.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_encrypt_arm64_crypto_eor3_aad_partial_done:
	# Load Nonce
	cmp	w4, #12
	bne	L_aes_gcm_encrypt_arm64_crypto_eor3_ghash_nonce
	ldr	x16, [x3]
	movi	v13.4s, #1, lsl 24
	ldr	w17, [x3, #8]
	mov	v13.d[0], x16
	mov	v13.s[2], w17
	mov	w15, #1
	b	L_aes_gcm_encrypt_arm64_crypto_eor3_done_nonce
L_aes_gcm_encrypt_arm64_crypto_eor3_ghash_nonce:
	eor	v13.16b, v13.16b, v13.16b
	lsr	w14, w4, #4
	cbz	w14, L_aes_gcm_encrypt_arm64_crypto_eor3_nonce_done
L_aes_gcm_encrypt_arm64_crypto_eor3_nonce_start_1:
	ld1	{v18.16b}, [x3], #16
	rbit	v18.16b, v18.16b
	eor	v21.16b, v13.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v13.16b, v28.16b, v30.16b
	# Done GHASH
	subs	w14, w14, #1
	bne	L_aes_gcm_encrypt_arm64_crypto_eor3_nonce_start_1
L_aes_gcm_encrypt_arm64_crypto_eor3_nonce_done:
	and	w24, w4, #15
	cbz	x24, L_aes_gcm_encrypt_arm64_crypto_eor3_nonce_partial_done
	eor	v28.16b, v28.16b, v28.16b
	mov	w20, w24
	st1	{v28.2d}, [x11]
	cmp	w20, #8
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_nonce_start_dw
	ldr	x19, [x3], #8
	sub	w20, w20, #8
	str	x19, [x11], #8
L_aes_gcm_encrypt_arm64_crypto_eor3_nonce_start_dw:
	cmp	w20, #4
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_nonce_start_sw
	ldr	w19, [x3], #4
	sub	w20, w20, #4
	str	w19, [x11], #4
L_aes_gcm_encrypt_arm64_crypto_eor3_nonce_start_sw:
	cmp	w20, #2
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_nonce_start_byte
	ldrh	w19, [x3], #2
	sub	w20, w20, #2
	strh	w19, [x11], #2
L_aes_gcm_encrypt_arm64_crypto_eor3_nonce_start_byte:
	cbz	w20, L_aes_gcm_encrypt_arm64_crypto_eor3_nonce_end_bytes
	ldrb	w19, [x3], #1
	subs	w20, w20, #1
	strb	w19, [x11], #1
	bne	L_aes_gcm_encrypt_arm64_crypto_eor3_nonce_start_byte
L_aes_gcm_encrypt_arm64_crypto_eor3_nonce_end_bytes:
	sub	x11, x11, x24
	ld1	{v18.2d}, [x11]
	rbit	v18.16b, v18.16b
	eor	v21.16b, v13.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v13.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_encrypt_arm64_crypto_eor3_nonce_partial_done:
	eor	x14, x14, x14
	lsl	x24, x4, #3
	mov	v28.d[0], x14
	mov	v28.d[1], x24
	rev64	v28.16b, v28.16b
	rbit	v28.16b, v28.16b
	eor	v13.16b, v13.16b, v28.16b
	pmull	v28.1q, v13.1d, v22.1d
	pmull2	v29.1q, v13.2d, v22.2d
	ext	v31.16b, v13.16b, v13.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v13.16b, v28.16b, v30.16b
	rbit	v13.16b, v13.16b
	mov	w15, v13.s[3]
	rev	w15, w15
L_aes_gcm_encrypt_arm64_crypto_eor3_done_nonce:
	st1	{v13.2d}, [x12]
	lsr	w14, w2, #4
	cmp	w13, #12
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_start_128
	bgt	L_aes_gcm_encrypt_arm64_crypto_eor3_start_256
	# AES_GCM_192
#ifndef NO_AES_192
	cmp	w14, #32
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_192_start_4
L_aes_gcm_encrypt_arm64_crypto_eor3_192_start_8:
	ldr	q12, [x9]
	add	w24, w15, #1
	mov	v14.16b, v13.16b
	add	w23, w15, #2
	mov	v15.16b, v13.16b
	add	w22, w15, #3
	mov	v16.16b, v13.16b
	add	w21, w15, #4
	mov	v17.16b, v13.16b
	add	w20, w15, #5
	mov	v8.16b, v13.16b
	add	w19, w15, #6
	mov	v9.16b, v13.16b
	add	w17, w15, #7
	mov	v10.16b, v13.16b
	add	w15, w15, #8
	mov	v11.16b, v13.16b
	rev	w24, w24
	rev	w23, w23
	rev	w22, w22
	rev	w21, w21
	rev	w20, w20
	rev	w19, w19
	rev	w17, w17
	rev	w16, w15
	mov	v14.s[3], w24
	mov	v15.s[3], w23
	mov	v16.s[3], w22
	mov	v17.s[3], w21
	mov	v8.s[3], w20
	mov	v9.s[3], w19
	mov	v10.s[3], w17
	mov	v11.s[3], w16
	ldr	q13, [x9, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w14, w14, #8
	ldr	q12, [x9, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b}, [x0], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v19.16b}, [x0], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v20.16b}, [x0], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ld1	{v21.16b}, [x0], #16
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #160]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	ld1	{v0.16b}, [x0], #16
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ld1	{v1.16b}, [x0], #16
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v2.16b}, [x0], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ld1	{v3.16b}, [x0], #16
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #176]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #192]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	eor	v0.16b, v0.16b, v8.16b
	eor	v1.16b, v1.16b, v9.16b
	eor	v2.16b, v2.16b, v10.16b
	eor	v3.16b, v3.16b, v11.16b
	ld1	{v13.2d}, [x12]
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x1], #0x40
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x1], #0x40
	cmp	w14, #8
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_192_end_8
L_aes_gcm_encrypt_arm64_crypto_eor3_192_both_8:
	ldr	q12, [x9]
	add	w24, w15, #1
	mov	v14.16b, v13.16b
	add	w23, w15, #2
	mov	v15.16b, v13.16b
	add	w22, w15, #3
	mov	v16.16b, v13.16b
	add	w21, w15, #4
	mov	v17.16b, v13.16b
	add	w20, w15, #5
	mov	v8.16b, v13.16b
	add	w19, w15, #6
	mov	v9.16b, v13.16b
	add	w17, w15, #7
	mov	v10.16b, v13.16b
	add	w15, w15, #8
	mov	v11.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w24, w24
	rbit	v19.16b, v19.16b
	rev	w23, w23
	rbit	v20.16b, v20.16b
	rev	w22, w22
	rbit	v21.16b, v21.16b
	rev	w21, w21
	rbit	v0.16b, v0.16b
	rev	w20, w20
	rbit	v1.16b, v1.16b
	rev	w19, w19
	rbit	v2.16b, v2.16b
	rev	w17, w17
	rbit	v3.16b, v3.16b
	rev	w16, w15
	mov	v14.s[3], w24
	mov	v15.s[3], w23
	mov	v16.s[3], w22
	mov	v17.s[3], w21
	mov	v8.s[3], w20
	mov	v9.s[3], w19
	mov	v10.s[3], w17
	mov	v11.s[3], w16
	ldr	q13, [x9, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v18.16b, v18.16b, v26.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ext	v31.16b, v3.16b, v3.16b, #8
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w14, w14, #8
	ldr	q12, [x9, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	mov	v28.d[1], v31.d[0]
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v28.16b, v30.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	# Done GHASH
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v18.16b}, [x0], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ld1	{v19.16b}, [x0], #16
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ld1	{v20.16b}, [x0], #16
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ld1	{v21.16b}, [x0], #16
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v0.16b}, [x0], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v1.16b}, [x0], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v2.16b}, [x0], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ld1	{v3.16b}, [x0], #16
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #160]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #176]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #192]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	ld1	{v13.2d}, [x12]
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x1], #0x40
	eor	v0.16b, v0.16b, v8.16b
	eor	v1.16b, v1.16b, v9.16b
	eor	v2.16b, v2.16b, v10.16b
	eor	v3.16b, v3.16b, v11.16b
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x1], #0x40
	cmp	w14, #8
	bge	L_aes_gcm_encrypt_arm64_crypto_eor3_192_both_8
L_aes_gcm_encrypt_arm64_crypto_eor3_192_end_8:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	rbit	v0.16b, v0.16b
	rbit	v1.16b, v1.16b
	rbit	v2.16b, v2.16b
	rbit	v3.16b, v3.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	ext	v31.16b, v3.16b, v3.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_encrypt_arm64_crypto_eor3_192_start_4:
	ld1	{v0.2d, v1.2d, v2.2d, v3.2d}, [x9], #0x40
	ld1	{v4.2d, v5.2d, v6.2d, v7.2d}, [x9], #0x40
	ld1	{v8.2d, v9.2d, v10.2d, v11.2d}, [x9], #0x40
	ld1	{v12.2d}, [x9]
	cmp	w14, #1
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_192_done
	beq	L_aes_gcm_encrypt_arm64_crypto_eor3_192_start_1
	cmp	w14, #4
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_192_start_2
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w19, w15, #2
	mov	v15.16b, v13.16b
	add	w17, w15, #3
	mov	v16.16b, v13.16b
	add	w15, w15, #4
	mov	v17.16b, v13.16b
	rev	w20, w20
	rev	w19, w19
	rev	w17, w17
	rev	w16, w15
	mov	v14.s[3], w20
	mov	v15.s[3], w19
	mov	v16.s[3], w17
	mov	v17.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w14, w14, #4
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x0], #16
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	ld1	{v19.16b}, [x0], #16
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	ld1	{v20.16b}, [x0], #16
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	ld1	{v21.16b}, [x0], #16
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v11.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v11.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v11.16b
	eor	v17.16b, v17.16b, v12.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	cmp	w14, #4
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x1], #0x40
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_192_end_4
L_aes_gcm_encrypt_arm64_crypto_eor3_192_both_4:
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w19, w15, #2
	mov	v15.16b, v13.16b
	add	w17, w15, #3
	mov	v16.16b, v13.16b
	add	w15, w15, #4
	mov	v17.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w20, w20
	rev	w19, w19
	rev	w17, w17
	rbit	v19.16b, v19.16b
	rev	w16, w15
	mov	v14.s[3], w20
	mov	v15.s[3], w19
	mov	v16.s[3], w17
	mov	v17.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	rbit	v20.16b, v20.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	rbit	v21.16b, v21.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	eor	v18.16b, v18.16b, v26.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	ext	v31.16b, v21.16b, v21.16b, #8
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w14, w14, #4
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	mov	v28.d[1], v31.d[0]
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	eor	v26.16b, v28.16b, v30.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	# Done GHASH
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x0], #0x40
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v11.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v11.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v11.16b
	eor	v17.16b, v17.16b, v12.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	cmp	w14, #4
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x1], #0x40
	bge	L_aes_gcm_encrypt_arm64_crypto_eor3_192_both_4
L_aes_gcm_encrypt_arm64_crypto_eor3_192_end_4:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cmp	w14, #1
	beq	L_aes_gcm_encrypt_arm64_crypto_eor3_192_start_1
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_192_done
L_aes_gcm_encrypt_arm64_crypto_eor3_192_start_2:
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w15, w15, #2
	mov	v15.16b, v13.16b
	rev	w20, w20
	rev	w16, w15
	mov	v14.s[3], w20
	mov	v15.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	subs	w14, w14, #2
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x0], #16
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	ld1	{v19.16b}, [x0], #16
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v11.16b
	eor	v15.16b, v15.16b, v12.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	st1	{v18.16b, v19.16b}, [x1], #32
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v19.1d, v22.1d
	pmull2	v29.1q, v19.2d, v22.2d
	ext	v31.16b, v19.16b, v19.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v21.1d
	pmull2	v26.1q, v23.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cbz	w14, L_aes_gcm_encrypt_arm64_crypto_eor3_192_done
L_aes_gcm_encrypt_arm64_crypto_eor3_192_start_1:
	add	w15, w15, #1
	mov	v14.16b, v13.16b
	rev	w16, w15
	mov	v14.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x0], #16
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	eor	v18.16b, v18.16b, v14.16b
	st1	{v18.16b}, [x1], #16
	rbit	v18.16b, v18.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_encrypt_arm64_crypto_eor3_192_done:
	ands	w14, w2, #15
	beq	L_aes_gcm_encrypt_arm64_crypto_eor3_192_partial_done
	eor	v16.16b, v16.16b, v16.16b
	mov	w19, w14
	st1	{v16.2d}, [x11]
	cmp	x19, #8
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_192_start_dw
	ldr	x17, [x0], #8
	sub	x19, x19, #8
	str	x17, [x11], #8
L_aes_gcm_encrypt_arm64_crypto_eor3_192_start_dw:
	cmp	x19, #4
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_192_start_sw
	ldr	w17, [x0], #4
	sub	x19, x19, #4
	str	w17, [x11], #4
L_aes_gcm_encrypt_arm64_crypto_eor3_192_start_sw:
	cmp	x19, #2
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_192_start_byte
	ldrh	w17, [x0], #2
	sub	x19, x19, #2
	strh	w17, [x11], #2
L_aes_gcm_encrypt_arm64_crypto_eor3_192_start_byte:
	cbz	x19, L_aes_gcm_encrypt_arm64_crypto_eor3_192_end_bytes
	ldrb	w17, [x0], #1
	subs	x19, x19, #1
	strb	w17, [x11], #1
	bne	L_aes_gcm_encrypt_arm64_crypto_eor3_192_start_byte
L_aes_gcm_encrypt_arm64_crypto_eor3_192_end_bytes:
	sub	x11, x11, x14
	ld1	{v16.2d}, [x11]
	add	w15, w15, #1
	mov	v14.16b, v13.16b
	rev	w16, w15
	mov	v14.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	eor	v16.16b, v16.16b, v14.16b
	st1	{v16.2d}, [x11]
	mov	w19, w14
	cmp	x19, #8
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_192_out_start_dw
	ldr	x17, [x11], #8
	sub	x19, x19, #8
	str	x17, [x1], #8
L_aes_gcm_encrypt_arm64_crypto_eor3_192_out_start_dw:
	cmp	x19, #4
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_192_out_start_sw
	ldr	w17, [x11], #4
	sub	x19, x19, #4
	str	w17, [x1], #4
L_aes_gcm_encrypt_arm64_crypto_eor3_192_out_start_sw:
	cmp	x19, #2
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_192_out_start_byte
	ldrh	w17, [x11], #2
	sub	x19, x19, #2
	strh	w17, [x1], #2
L_aes_gcm_encrypt_arm64_crypto_eor3_192_out_start_byte:
	cbz	x19, L_aes_gcm_encrypt_arm64_crypto_eor3_192_out_end_bytes
	ldrb	w17, [x11], #1
	subs	x19, x19, #1
	strb	w17, [x1], #1
	bne	L_aes_gcm_encrypt_arm64_crypto_eor3_192_out_start_byte
L_aes_gcm_encrypt_arm64_crypto_eor3_192_out_end_bytes:
	mov	x17, #16
	sub	x17, x17, x14
L_aes_gcm_encrypt_arm64_crypto_eor3_192_start_zero:
	subs	x17, x17, #1
	strb	wzr, [x11], #1
	bne	L_aes_gcm_encrypt_arm64_crypto_eor3_192_start_zero
	sub	x11, x11, #16
	ld1	{v14.2d}, [x11]
	rbit	v14.16b, v14.16b
	eor	v15.16b, v26.16b, v14.16b
	#   X  = C * H^1
	pmull	v28.1q, v15.1d, v22.1d
	pmull2	v29.1q, v15.2d, v22.2d
	ext	v31.16b, v15.16b, v15.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_encrypt_arm64_crypto_eor3_192_partial_done:
	ld1	{v14.2d}, [x12]
	lsl	x8, x8, #3
	rbit	x8, x8
	mov	v28.d[0], x8
	lsl	x2, x2, #3
	rbit	x2, x2
	mov	v28.d[1], x2
	eor	v26.16b, v26.16b, v28.16b
	pmull	v28.1q, v26.1d, v22.1d
	pmull2	v29.1q, v26.2d, v22.2d
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	ext	v31.16b, v26.16b, v26.16b, #8
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	mov	v28.d[1], v31.d[0]
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v28.16b, v30.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	rbit	v26.16b, v26.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	eor	v26.16b, v26.16b, v14.16b
	cmp	w6, #16
	bne	L_aes_gcm_encrypt_arm64_crypto_eor3_192_tag_partial
	st1	{v26.16b}, [x5]
	b	L_aes_gcm_encrypt_arm64_crypto_eor3_done
L_aes_gcm_encrypt_arm64_crypto_eor3_192_tag_partial:
	st1	{v26.16b}, [x11]
	cmp	w6, #8
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_192_tag_start_dw
	ldr	x16, [x11], #8
	sub	w6, w6, #8
	str	x16, [x5], #8
L_aes_gcm_encrypt_arm64_crypto_eor3_192_tag_start_dw:
	cmp	w6, #4
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_192_tag_start_sw
	ldr	w16, [x11], #4
	sub	w6, w6, #4
	str	w16, [x5], #4
L_aes_gcm_encrypt_arm64_crypto_eor3_192_tag_start_sw:
	cmp	w6, #2
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_192_tag_start_byte
	ldrh	w16, [x11], #2
	sub	w6, w6, #2
	strh	w16, [x5], #2
L_aes_gcm_encrypt_arm64_crypto_eor3_192_tag_start_byte:
	cbz	w6, L_aes_gcm_encrypt_arm64_crypto_eor3_192_tag_end_bytes
	ldrb	w16, [x11], #1
	subs	w6, w6, #1
	strb	w16, [x5], #1
	bne	L_aes_gcm_encrypt_arm64_crypto_eor3_192_tag_start_byte
L_aes_gcm_encrypt_arm64_crypto_eor3_192_tag_end_bytes:
#endif /* !NO_AES_192 */
	b	L_aes_gcm_encrypt_arm64_crypto_eor3_done
	# AES_GCM_256
L_aes_gcm_encrypt_arm64_crypto_eor3_start_256:
#ifndef NO_AES_256
	cmp	w14, #32
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_256_start_4
L_aes_gcm_encrypt_arm64_crypto_eor3_256_start_8:
	ldr	q12, [x9]
	add	w24, w15, #1
	mov	v14.16b, v13.16b
	add	w23, w15, #2
	mov	v15.16b, v13.16b
	add	w22, w15, #3
	mov	v16.16b, v13.16b
	add	w21, w15, #4
	mov	v17.16b, v13.16b
	add	w20, w15, #5
	mov	v8.16b, v13.16b
	add	w19, w15, #6
	mov	v9.16b, v13.16b
	add	w17, w15, #7
	mov	v10.16b, v13.16b
	add	w15, w15, #8
	mov	v11.16b, v13.16b
	rev	w24, w24
	rev	w23, w23
	rev	w22, w22
	rev	w21, w21
	rev	w20, w20
	rev	w19, w19
	rev	w17, w17
	rev	w16, w15
	mov	v14.s[3], w24
	mov	v15.s[3], w23
	mov	v16.s[3], w22
	mov	v17.s[3], w21
	mov	v8.s[3], w20
	mov	v9.s[3], w19
	mov	v10.s[3], w17
	mov	v11.s[3], w16
	ldr	q13, [x9, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w14, w14, #8
	ldr	q12, [x9, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b}, [x0], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v19.16b}, [x0], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v20.16b}, [x0], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ld1	{v21.16b}, [x0], #16
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #160]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	ld1	{v0.16b}, [x0], #16
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ld1	{v1.16b}, [x0], #16
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v2.16b}, [x0], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ld1	{v3.16b}, [x0], #16
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #176]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #192]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #208]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #224]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	eor	v0.16b, v0.16b, v8.16b
	eor	v1.16b, v1.16b, v9.16b
	eor	v2.16b, v2.16b, v10.16b
	eor	v3.16b, v3.16b, v11.16b
	ld1	{v13.2d}, [x12]
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x1], #0x40
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x1], #0x40
	cmp	w14, #8
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_256_end_8
L_aes_gcm_encrypt_arm64_crypto_eor3_256_both_8:
	ldr	q12, [x9]
	add	w24, w15, #1
	mov	v14.16b, v13.16b
	add	w23, w15, #2
	mov	v15.16b, v13.16b
	add	w22, w15, #3
	mov	v16.16b, v13.16b
	add	w21, w15, #4
	mov	v17.16b, v13.16b
	add	w20, w15, #5
	mov	v8.16b, v13.16b
	add	w19, w15, #6
	mov	v9.16b, v13.16b
	add	w17, w15, #7
	mov	v10.16b, v13.16b
	add	w15, w15, #8
	mov	v11.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w24, w24
	rbit	v19.16b, v19.16b
	rev	w23, w23
	rbit	v20.16b, v20.16b
	rev	w22, w22
	rbit	v21.16b, v21.16b
	rev	w21, w21
	rbit	v0.16b, v0.16b
	rev	w20, w20
	rbit	v1.16b, v1.16b
	rev	w19, w19
	rbit	v2.16b, v2.16b
	rev	w17, w17
	rbit	v3.16b, v3.16b
	rev	w16, w15
	mov	v14.s[3], w24
	mov	v15.s[3], w23
	mov	v16.s[3], w22
	mov	v17.s[3], w21
	mov	v8.s[3], w20
	mov	v9.s[3], w19
	mov	v10.s[3], w17
	mov	v11.s[3], w16
	ldr	q13, [x9, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v18.16b, v18.16b, v26.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ext	v31.16b, v3.16b, v3.16b, #8
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w14, w14, #8
	ldr	q12, [x9, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	mov	v28.d[1], v31.d[0]
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v28.16b, v30.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	# Done GHASH
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v18.16b}, [x0], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ld1	{v19.16b}, [x0], #16
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ld1	{v20.16b}, [x0], #16
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ld1	{v21.16b}, [x0], #16
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v0.16b}, [x0], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v1.16b}, [x0], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v2.16b}, [x0], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ld1	{v3.16b}, [x0], #16
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #160]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #176]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #192]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #208]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #224]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	ld1	{v13.2d}, [x12]
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x1], #0x40
	eor	v0.16b, v0.16b, v8.16b
	eor	v1.16b, v1.16b, v9.16b
	eor	v2.16b, v2.16b, v10.16b
	eor	v3.16b, v3.16b, v11.16b
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x1], #0x40
	cmp	w14, #8
	bge	L_aes_gcm_encrypt_arm64_crypto_eor3_256_both_8
L_aes_gcm_encrypt_arm64_crypto_eor3_256_end_8:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	rbit	v0.16b, v0.16b
	rbit	v1.16b, v1.16b
	rbit	v2.16b, v2.16b
	rbit	v3.16b, v3.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	ext	v31.16b, v3.16b, v3.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_encrypt_arm64_crypto_eor3_256_start_4:
	ld1	{v0.2d, v1.2d, v2.2d, v3.2d}, [x9], #0x40
	ld1	{v4.2d, v5.2d, v6.2d, v7.2d}, [x9], #0x40
	ld1	{v8.2d, v9.2d, v10.2d, v11.2d}, [x9], #0x40
	ld1	{v12.2d}, [x9], #16
	cmp	w14, #1
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_256_done
	beq	L_aes_gcm_encrypt_arm64_crypto_eor3_256_start_1
	cmp	w14, #4
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_256_start_2
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w19, w15, #2
	mov	v15.16b, v13.16b
	add	w17, w15, #3
	mov	v16.16b, v13.16b
	add	w15, w15, #4
	mov	v17.16b, v13.16b
	rev	w20, w20
	rev	w19, w19
	rev	w17, w17
	rev	w16, w15
	mov	v14.s[3], w20
	mov	v15.s[3], w19
	mov	v16.s[3], w17
	mov	v17.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w14, w14, #4
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x0], #16
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	ld1	{v19.16b}, [x0], #16
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	ld1	{v20.16b}, [x0], #16
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	ld1	{v21.16b}, [x0], #16
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v11.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v11.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v11.16b
	aesmc	v17.16b, v17.16b
	ld1	{v29.2d, v30.2d}, [x9]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	aese	v15.16b, v29.16b
	eor	v15.16b, v15.16b, v30.16b
	aese	v16.16b, v29.16b
	eor	v16.16b, v16.16b, v30.16b
	aese	v17.16b, v29.16b
	eor	v17.16b, v17.16b, v30.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	cmp	w14, #4
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x1], #0x40
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_256_end_4
L_aes_gcm_encrypt_arm64_crypto_eor3_256_both_4:
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w19, w15, #2
	mov	v15.16b, v13.16b
	add	w17, w15, #3
	mov	v16.16b, v13.16b
	add	w15, w15, #4
	mov	v17.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w20, w20
	rev	w19, w19
	rev	w17, w17
	rbit	v19.16b, v19.16b
	rev	w16, w15
	mov	v14.s[3], w20
	mov	v15.s[3], w19
	mov	v16.s[3], w17
	mov	v17.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	rbit	v20.16b, v20.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	rbit	v21.16b, v21.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	eor	v18.16b, v18.16b, v26.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	ext	v31.16b, v21.16b, v21.16b, #8
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w14, w14, #4
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	mov	v28.d[1], v31.d[0]
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	eor	v26.16b, v28.16b, v30.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	# Done GHASH
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x0], #0x40
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v11.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v11.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v11.16b
	aesmc	v17.16b, v17.16b
	ld1	{v29.2d, v30.2d}, [x9]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	aese	v15.16b, v29.16b
	eor	v15.16b, v15.16b, v30.16b
	aese	v16.16b, v29.16b
	eor	v16.16b, v16.16b, v30.16b
	aese	v17.16b, v29.16b
	eor	v17.16b, v17.16b, v30.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	cmp	w14, #4
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x1], #0x40
	bge	L_aes_gcm_encrypt_arm64_crypto_eor3_256_both_4
L_aes_gcm_encrypt_arm64_crypto_eor3_256_end_4:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cmp	w14, #1
	beq	L_aes_gcm_encrypt_arm64_crypto_eor3_256_start_1
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_256_done
L_aes_gcm_encrypt_arm64_crypto_eor3_256_start_2:
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w15, w15, #2
	mov	v15.16b, v13.16b
	rev	w20, w20
	rev	w16, w15
	mov	v14.s[3], w20
	mov	v15.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	subs	w14, w14, #2
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x0], #16
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	ld1	{v19.16b}, [x0], #16
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v11.16b
	aesmc	v15.16b, v15.16b
	ld1	{v29.2d, v30.2d}, [x9]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	aese	v15.16b, v29.16b
	eor	v15.16b, v15.16b, v30.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	st1	{v18.16b, v19.16b}, [x1], #32
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v19.1d, v22.1d
	pmull2	v29.1q, v19.2d, v22.2d
	ext	v31.16b, v19.16b, v19.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v21.1d
	pmull2	v26.1q, v23.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cbz	w14, L_aes_gcm_encrypt_arm64_crypto_eor3_256_done
L_aes_gcm_encrypt_arm64_crypto_eor3_256_start_1:
	add	w15, w15, #1
	mov	v14.16b, v13.16b
	rev	w16, w15
	mov	v14.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x0], #16
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	ldr	q29, [x9]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ldr	q30, [x9, #16]
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	eor	v18.16b, v18.16b, v14.16b
	st1	{v18.16b}, [x1], #16
	rbit	v18.16b, v18.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_encrypt_arm64_crypto_eor3_256_done:
	ands	w14, w2, #15
	beq	L_aes_gcm_encrypt_arm64_crypto_eor3_256_partial_done
	eor	v16.16b, v16.16b, v16.16b
	mov	w19, w14
	st1	{v16.2d}, [x11]
	cmp	x19, #8
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_256_start_dw
	ldr	x17, [x0], #8
	sub	x19, x19, #8
	str	x17, [x11], #8
L_aes_gcm_encrypt_arm64_crypto_eor3_256_start_dw:
	cmp	x19, #4
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_256_start_sw
	ldr	w17, [x0], #4
	sub	x19, x19, #4
	str	w17, [x11], #4
L_aes_gcm_encrypt_arm64_crypto_eor3_256_start_sw:
	cmp	x19, #2
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_256_start_byte
	ldrh	w17, [x0], #2
	sub	x19, x19, #2
	strh	w17, [x11], #2
L_aes_gcm_encrypt_arm64_crypto_eor3_256_start_byte:
	cbz	x19, L_aes_gcm_encrypt_arm64_crypto_eor3_256_end_bytes
	ldrb	w17, [x0], #1
	subs	x19, x19, #1
	strb	w17, [x11], #1
	bne	L_aes_gcm_encrypt_arm64_crypto_eor3_256_start_byte
L_aes_gcm_encrypt_arm64_crypto_eor3_256_end_bytes:
	sub	x11, x11, x14
	ld1	{v16.2d}, [x11]
	add	w15, w15, #1
	mov	v14.16b, v13.16b
	rev	w16, w15
	mov	v14.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	ldr	q29, [x9]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ldr	q30, [x9, #16]
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	eor	v16.16b, v16.16b, v14.16b
	st1	{v16.2d}, [x11]
	mov	w19, w14
	cmp	x19, #8
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_256_out_start_dw
	ldr	x17, [x11], #8
	sub	x19, x19, #8
	str	x17, [x1], #8
L_aes_gcm_encrypt_arm64_crypto_eor3_256_out_start_dw:
	cmp	x19, #4
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_256_out_start_sw
	ldr	w17, [x11], #4
	sub	x19, x19, #4
	str	w17, [x1], #4
L_aes_gcm_encrypt_arm64_crypto_eor3_256_out_start_sw:
	cmp	x19, #2
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_256_out_start_byte
	ldrh	w17, [x11], #2
	sub	x19, x19, #2
	strh	w17, [x1], #2
L_aes_gcm_encrypt_arm64_crypto_eor3_256_out_start_byte:
	cbz	x19, L_aes_gcm_encrypt_arm64_crypto_eor3_256_out_end_bytes
	ldrb	w17, [x11], #1
	subs	x19, x19, #1
	strb	w17, [x1], #1
	bne	L_aes_gcm_encrypt_arm64_crypto_eor3_256_out_start_byte
L_aes_gcm_encrypt_arm64_crypto_eor3_256_out_end_bytes:
	mov	x17, #16
	sub	x17, x17, x14
L_aes_gcm_encrypt_arm64_crypto_eor3_256_start_zero:
	subs	x17, x17, #1
	strb	wzr, [x11], #1
	bne	L_aes_gcm_encrypt_arm64_crypto_eor3_256_start_zero
	sub	x11, x11, #16
	ld1	{v14.2d}, [x11]
	rbit	v14.16b, v14.16b
	eor	v15.16b, v26.16b, v14.16b
	#   X  = C * H^1
	pmull	v28.1q, v15.1d, v22.1d
	pmull2	v29.1q, v15.2d, v22.2d
	ext	v31.16b, v15.16b, v15.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_encrypt_arm64_crypto_eor3_256_partial_done:
	ld1	{v14.2d}, [x12]
	lsl	x8, x8, #3
	rbit	x8, x8
	mov	v28.d[0], x8
	lsl	x2, x2, #3
	rbit	x2, x2
	mov	v28.d[1], x2
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v26.16b, v28.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	pmull	v28.1q, v26.1d, v22.1d
	pmull2	v29.1q, v26.2d, v22.2d
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	ext	v31.16b, v26.16b, v26.16b, #8
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	mov	v28.d[1], v31.d[0]
	ldr	q11, [x9, #-32]
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v28.16b, v30.16b
	ldr	q12, [x9, #-16]
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	ldr	q29, [x9]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	rbit	v26.16b, v26.16b
	ldr	q30, [x9, #16]
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	eor	v26.16b, v26.16b, v14.16b
	cmp	w6, #16
	bne	L_aes_gcm_encrypt_arm64_crypto_eor3_256_tag_partial
	st1	{v26.16b}, [x5]
	b	L_aes_gcm_encrypt_arm64_crypto_eor3_done
L_aes_gcm_encrypt_arm64_crypto_eor3_256_tag_partial:
	st1	{v26.16b}, [x11]
	cmp	w6, #8
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_256_tag_start_dw
	ldr	x16, [x11], #8
	sub	w6, w6, #8
	str	x16, [x5], #8
L_aes_gcm_encrypt_arm64_crypto_eor3_256_tag_start_dw:
	cmp	w6, #4
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_256_tag_start_sw
	ldr	w16, [x11], #4
	sub	w6, w6, #4
	str	w16, [x5], #4
L_aes_gcm_encrypt_arm64_crypto_eor3_256_tag_start_sw:
	cmp	w6, #2
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_256_tag_start_byte
	ldrh	w16, [x11], #2
	sub	w6, w6, #2
	strh	w16, [x5], #2
L_aes_gcm_encrypt_arm64_crypto_eor3_256_tag_start_byte:
	cbz	w6, L_aes_gcm_encrypt_arm64_crypto_eor3_256_tag_end_bytes
	ldrb	w16, [x11], #1
	subs	w6, w6, #1
	strb	w16, [x5], #1
	bne	L_aes_gcm_encrypt_arm64_crypto_eor3_256_tag_start_byte
L_aes_gcm_encrypt_arm64_crypto_eor3_256_tag_end_bytes:
#endif /* !NO_AES_256 */
	b	L_aes_gcm_encrypt_arm64_crypto_eor3_done
	# AES_GCM_128
L_aes_gcm_encrypt_arm64_crypto_eor3_start_128:
#ifndef NO_AES_128
	cmp	w14, #32
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_128_start_4
L_aes_gcm_encrypt_arm64_crypto_eor3_128_start_8:
	ldr	q12, [x9]
	add	w24, w15, #1
	mov	v14.16b, v13.16b
	add	w23, w15, #2
	mov	v15.16b, v13.16b
	add	w22, w15, #3
	mov	v16.16b, v13.16b
	add	w21, w15, #4
	mov	v17.16b, v13.16b
	add	w20, w15, #5
	mov	v8.16b, v13.16b
	add	w19, w15, #6
	mov	v9.16b, v13.16b
	add	w17, w15, #7
	mov	v10.16b, v13.16b
	add	w15, w15, #8
	mov	v11.16b, v13.16b
	rev	w24, w24
	rev	w23, w23
	rev	w22, w22
	rev	w21, w21
	rev	w20, w20
	rev	w19, w19
	rev	w17, w17
	rev	w16, w15
	mov	v14.s[3], w24
	mov	v15.s[3], w23
	mov	v16.s[3], w22
	mov	v17.s[3], w21
	mov	v8.s[3], w20
	mov	v9.s[3], w19
	mov	v10.s[3], w17
	mov	v11.s[3], w16
	ldr	q13, [x9, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w14, w14, #8
	ldr	q12, [x9, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b}, [x0], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v19.16b}, [x0], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v20.16b}, [x0], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ld1	{v21.16b}, [x0], #16
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #160]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	ld1	{v0.16b}, [x0], #16
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	ld1	{v1.16b}, [x0], #16
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	ld1	{v2.16b}, [x0], #16
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	ld1	{v3.16b}, [x0], #16
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	eor	v0.16b, v0.16b, v8.16b
	eor	v1.16b, v1.16b, v9.16b
	eor	v2.16b, v2.16b, v10.16b
	eor	v3.16b, v3.16b, v11.16b
	ld1	{v13.2d}, [x12]
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x1], #0x40
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x1], #0x40
	cmp	w14, #8
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_128_end_8
L_aes_gcm_encrypt_arm64_crypto_eor3_128_both_8:
	ldr	q12, [x9]
	add	w24, w15, #1
	mov	v14.16b, v13.16b
	add	w23, w15, #2
	mov	v15.16b, v13.16b
	add	w22, w15, #3
	mov	v16.16b, v13.16b
	add	w21, w15, #4
	mov	v17.16b, v13.16b
	add	w20, w15, #5
	mov	v8.16b, v13.16b
	add	w19, w15, #6
	mov	v9.16b, v13.16b
	add	w17, w15, #7
	mov	v10.16b, v13.16b
	add	w15, w15, #8
	mov	v11.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w24, w24
	rbit	v19.16b, v19.16b
	rev	w23, w23
	rbit	v20.16b, v20.16b
	rev	w22, w22
	rbit	v21.16b, v21.16b
	rev	w21, w21
	rbit	v0.16b, v0.16b
	rev	w20, w20
	rbit	v1.16b, v1.16b
	rev	w19, w19
	rbit	v2.16b, v2.16b
	rev	w17, w17
	rbit	v3.16b, v3.16b
	rev	w16, w15
	mov	v14.s[3], w24
	mov	v15.s[3], w23
	mov	v16.s[3], w22
	mov	v17.s[3], w21
	mov	v8.s[3], w20
	mov	v9.s[3], w19
	mov	v10.s[3], w17
	mov	v11.s[3], w16
	ldr	q13, [x9, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v18.16b, v18.16b, v26.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ext	v31.16b, v3.16b, v3.16b, #8
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w14, w14, #8
	ldr	q12, [x9, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	mov	v28.d[1], v31.d[0]
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v28.16b, v30.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	# Done GHASH
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v18.16b}, [x0], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ld1	{v19.16b}, [x0], #16
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ld1	{v20.16b}, [x0], #16
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ld1	{v21.16b}, [x0], #16
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v0.16b}, [x0], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v1.16b}, [x0], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v2.16b}, [x0], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ld1	{v3.16b}, [x0], #16
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #160]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	ld1	{v13.2d}, [x12]
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x1], #0x40
	eor	v0.16b, v0.16b, v8.16b
	eor	v1.16b, v1.16b, v9.16b
	eor	v2.16b, v2.16b, v10.16b
	eor	v3.16b, v3.16b, v11.16b
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x1], #0x40
	cmp	w14, #8
	bge	L_aes_gcm_encrypt_arm64_crypto_eor3_128_both_8
L_aes_gcm_encrypt_arm64_crypto_eor3_128_end_8:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	rbit	v0.16b, v0.16b
	rbit	v1.16b, v1.16b
	rbit	v2.16b, v2.16b
	rbit	v3.16b, v3.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	ext	v31.16b, v3.16b, v3.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_encrypt_arm64_crypto_eor3_128_start_4:
	ld1	{v0.2d, v1.2d, v2.2d, v3.2d}, [x9], #0x40
	ld1	{v4.2d, v5.2d, v6.2d, v7.2d}, [x9], #0x40
	ld1	{v8.2d, v9.2d}, [x9], #32
	ld1	{v10.2d}, [x9]
	cmp	w14, #1
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_128_done
	beq	L_aes_gcm_encrypt_arm64_crypto_eor3_128_start_1
	cmp	w14, #4
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_128_start_2
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w19, w15, #2
	mov	v15.16b, v13.16b
	add	w17, w15, #3
	mov	v16.16b, v13.16b
	add	w15, w15, #4
	mov	v17.16b, v13.16b
	rev	w20, w20
	rev	w19, w19
	rev	w17, w17
	rev	w16, w15
	mov	v14.s[3], w20
	mov	v15.s[3], w19
	mov	v16.s[3], w17
	mov	v17.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w14, w14, #4
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x0], #16
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	ld1	{v19.16b}, [x0], #16
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	ld1	{v20.16b}, [x0], #16
	aese	v15.16b, v9.16b
	eor	v15.16b, v15.16b, v10.16b
	ld1	{v21.16b}, [x0], #16
	aese	v16.16b, v9.16b
	eor	v16.16b, v16.16b, v10.16b
	aese	v17.16b, v9.16b
	eor	v17.16b, v17.16b, v10.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	cmp	w14, #4
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x1], #0x40
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_128_end_4
L_aes_gcm_encrypt_arm64_crypto_eor3_128_both_4:
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w19, w15, #2
	mov	v15.16b, v13.16b
	add	w17, w15, #3
	mov	v16.16b, v13.16b
	add	w15, w15, #4
	mov	v17.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w20, w20
	rev	w19, w19
	rev	w17, w17
	rbit	v19.16b, v19.16b
	rev	w16, w15
	mov	v14.s[3], w20
	mov	v15.s[3], w19
	mov	v16.s[3], w17
	mov	v17.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	rbit	v20.16b, v20.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	rbit	v21.16b, v21.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	eor	v18.16b, v18.16b, v26.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	ext	v31.16b, v21.16b, v21.16b, #8
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w14, w14, #4
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	mov	v28.d[1], v31.d[0]
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	eor	v26.16b, v28.16b, v30.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	# Done GHASH
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x0], #0x40
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	aese	v15.16b, v9.16b
	eor	v15.16b, v15.16b, v10.16b
	aese	v16.16b, v9.16b
	eor	v16.16b, v16.16b, v10.16b
	aese	v17.16b, v9.16b
	eor	v17.16b, v17.16b, v10.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	cmp	w14, #4
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x1], #0x40
	bge	L_aes_gcm_encrypt_arm64_crypto_eor3_128_both_4
L_aes_gcm_encrypt_arm64_crypto_eor3_128_end_4:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cmp	w14, #1
	beq	L_aes_gcm_encrypt_arm64_crypto_eor3_128_start_1
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_128_done
L_aes_gcm_encrypt_arm64_crypto_eor3_128_start_2:
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w15, w15, #2
	mov	v15.16b, v13.16b
	rev	w20, w20
	rev	w16, w15
	mov	v14.s[3], w20
	mov	v15.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	subs	w14, w14, #2
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x0], #16
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	ld1	{v19.16b}, [x0], #16
	aese	v15.16b, v9.16b
	eor	v15.16b, v15.16b, v10.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	st1	{v18.16b, v19.16b}, [x1], #32
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v19.1d, v22.1d
	pmull2	v29.1q, v19.2d, v22.2d
	ext	v31.16b, v19.16b, v19.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v21.1d
	pmull2	v26.1q, v23.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cbz	w14, L_aes_gcm_encrypt_arm64_crypto_eor3_128_done
L_aes_gcm_encrypt_arm64_crypto_eor3_128_start_1:
	add	w15, w15, #1
	mov	v14.16b, v13.16b
	rev	w16, w15
	mov	v14.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	ld1	{v18.16b}, [x0], #16
	eor	v18.16b, v18.16b, v14.16b
	st1	{v18.16b}, [x1], #16
	rbit	v18.16b, v18.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_encrypt_arm64_crypto_eor3_128_done:
	ands	w14, w2, #15
	beq	L_aes_gcm_encrypt_arm64_crypto_eor3_128_partial_done
	eor	v16.16b, v16.16b, v16.16b
	mov	w19, w14
	st1	{v16.2d}, [x11]
	cmp	x19, #8
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_128_start_dw
	ldr	x17, [x0], #8
	sub	x19, x19, #8
	str	x17, [x11], #8
L_aes_gcm_encrypt_arm64_crypto_eor3_128_start_dw:
	cmp	x19, #4
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_128_start_sw
	ldr	w17, [x0], #4
	sub	x19, x19, #4
	str	w17, [x11], #4
L_aes_gcm_encrypt_arm64_crypto_eor3_128_start_sw:
	cmp	x19, #2
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_128_start_byte
	ldrh	w17, [x0], #2
	sub	x19, x19, #2
	strh	w17, [x11], #2
L_aes_gcm_encrypt_arm64_crypto_eor3_128_start_byte:
	cbz	x19, L_aes_gcm_encrypt_arm64_crypto_eor3_128_end_bytes
	ldrb	w17, [x0], #1
	subs	x19, x19, #1
	strb	w17, [x11], #1
	bne	L_aes_gcm_encrypt_arm64_crypto_eor3_128_start_byte
L_aes_gcm_encrypt_arm64_crypto_eor3_128_end_bytes:
	sub	x11, x11, x14
	ld1	{v16.2d}, [x11]
	add	w15, w15, #1
	mov	v14.16b, v13.16b
	rev	w16, w15
	mov	v14.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	eor	v16.16b, v16.16b, v14.16b
	st1	{v16.2d}, [x11]
	mov	w19, w14
	cmp	x19, #8
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_128_out_start_dw
	ldr	x17, [x11], #8
	sub	x19, x19, #8
	str	x17, [x1], #8
L_aes_gcm_encrypt_arm64_crypto_eor3_128_out_start_dw:
	cmp	x19, #4
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_128_out_start_sw
	ldr	w17, [x11], #4
	sub	x19, x19, #4
	str	w17, [x1], #4
L_aes_gcm_encrypt_arm64_crypto_eor3_128_out_start_sw:
	cmp	x19, #2
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_128_out_start_byte
	ldrh	w17, [x11], #2
	sub	x19, x19, #2
	strh	w17, [x1], #2
L_aes_gcm_encrypt_arm64_crypto_eor3_128_out_start_byte:
	cbz	x19, L_aes_gcm_encrypt_arm64_crypto_eor3_128_out_end_bytes
	ldrb	w17, [x11], #1
	subs	x19, x19, #1
	strb	w17, [x1], #1
	bne	L_aes_gcm_encrypt_arm64_crypto_eor3_128_out_start_byte
L_aes_gcm_encrypt_arm64_crypto_eor3_128_out_end_bytes:
	mov	x17, #16
	sub	x17, x17, x14
L_aes_gcm_encrypt_arm64_crypto_eor3_128_start_zero:
	subs	x17, x17, #1
	strb	wzr, [x11], #1
	bne	L_aes_gcm_encrypt_arm64_crypto_eor3_128_start_zero
	sub	x11, x11, #16
	ld1	{v14.2d}, [x11]
	rbit	v14.16b, v14.16b
	eor	v15.16b, v26.16b, v14.16b
	#   X  = C * H^1
	pmull	v28.1q, v15.1d, v22.1d
	pmull2	v29.1q, v15.2d, v22.2d
	ext	v31.16b, v15.16b, v15.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_encrypt_arm64_crypto_eor3_128_partial_done:
	ld1	{v14.2d}, [x12]
	lsl	x8, x8, #3
	rbit	x8, x8
	mov	v28.d[0], x8
	lsl	x2, x2, #3
	rbit	x2, x2
	mov	v28.d[1], x2
	eor	v26.16b, v26.16b, v28.16b
	pmull	v28.1q, v26.1d, v22.1d
	pmull2	v29.1q, v26.2d, v22.2d
	ext	v31.16b, v26.16b, v26.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	mov	v28.d[1], v31.d[0]
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v28.16b, v30.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	rbit	v26.16b, v26.16b
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	eor	v26.16b, v26.16b, v14.16b
	cmp	w6, #16
	bne	L_aes_gcm_encrypt_arm64_crypto_eor3_128_tag_partial
	st1	{v26.16b}, [x5]
	b	L_aes_gcm_encrypt_arm64_crypto_eor3_done
L_aes_gcm_encrypt_arm64_crypto_eor3_128_tag_partial:
	st1	{v26.16b}, [x11]
	cmp	w6, #8
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_128_tag_start_dw
	ldr	x16, [x11], #8
	sub	w6, w6, #8
	str	x16, [x5], #8
L_aes_gcm_encrypt_arm64_crypto_eor3_128_tag_start_dw:
	cmp	w6, #4
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_128_tag_start_sw
	ldr	w16, [x11], #4
	sub	w6, w6, #4
	str	w16, [x5], #4
L_aes_gcm_encrypt_arm64_crypto_eor3_128_tag_start_sw:
	cmp	w6, #2
	blt	L_aes_gcm_encrypt_arm64_crypto_eor3_128_tag_start_byte
	ldrh	w16, [x11], #2
	sub	w6, w6, #2
	strh	w16, [x5], #2
L_aes_gcm_encrypt_arm64_crypto_eor3_128_tag_start_byte:
	cbz	w6, L_aes_gcm_encrypt_arm64_crypto_eor3_128_tag_end_bytes
	ldrb	w16, [x11], #1
	subs	w6, w6, #1
	strb	w16, [x5], #1
	bne	L_aes_gcm_encrypt_arm64_crypto_eor3_128_tag_start_byte
L_aes_gcm_encrypt_arm64_crypto_eor3_128_tag_end_bytes:
#endif /* !NO_AES_128 */
L_aes_gcm_encrypt_arm64_crypto_eor3_done:
	ldp	x17, x19, [x29, #24]
	ldp	x20, x21, [x29, #40]
	ldp	x22, x23, [x29, #56]
	ldr	x24, [x29, #72]
	ldp	d8, d9, [x29, #80]
	ldp	d10, d11, [x29, #96]
	ldp	d12, d13, [x29, #112]
	ldp	d14, d15, [x29, #128]
	ldp	x29, x30, [sp], #0x90
	ret
#ifndef __APPLE__
	.size	AES_GCM_encrypt_AARCH64_EOR3,.-AES_GCM_encrypt_AARCH64_EOR3
#endif /* __APPLE__ */
#ifdef HAVE_AES_DECRYPT
#ifndef __APPLE__
.text
.globl	AES_GCM_decrypt_AARCH64_EOR3
.type	AES_GCM_decrypt_AARCH64_EOR3,@function
.align	2
AES_GCM_decrypt_AARCH64_EOR3:
#else
.section	__TEXT,__text
.globl	_AES_GCM_decrypt_AARCH64_EOR3
.p2align	2
_AES_GCM_decrypt_AARCH64_EOR3:
#endif /* __APPLE__ */
	stp	x29, x30, [sp, #-144]!
	add	x29, sp, #0
	stp	x17, x19, [x29, #24]
	stp	x20, x21, [x29, #40]
	stp	x22, x23, [x29, #56]
	str	x24, [x29, #72]
	stp	d8, d9, [x29, #80]
	stp	d10, d11, [x29, #96]
	stp	d12, d13, [x29, #112]
	stp	d14, d15, [x29, #128]
	ldr	w8, [x29, #144]
	ldr	x9, [x29, #152]
	ldr	x10, [x29, #160]
	ldr	x11, [x29, #168]
	ldr	x12, [x29, #176]
	ldr	w13, [x29, #184]
	movi	v27.16b, #0x87
	eor	v26.16b, v26.16b, v26.16b
	ushr	v27.2d, v27.2d, #56
	ld1	{v22.2d}, [x10]
	cmp	w8, #0x40
	csetm	x16, lt
	cmp	w2, #32
	csetm	x17, lt
	ands	x16, x16, x17
	bne	L_aes_gcm_decrypt_arm64_crypto_eor3_h_done
	# Square H => H^2
	pmull2	v31.1q, v22.2d, v22.2d
	pmull	v30.1q, v22.1d, v22.1d
	pmull2	v28.1q, v31.2d, v27.2d
	ext	v29.16b, v30.16b, v31.16b, #8
	eor	v29.16b, v29.16b, v28.16b
	pmull2	v31.1q, v29.2d, v27.2d
	mov	v30.d[1], v29.d[0]
	eor	v23.16b, v30.16b, v31.16b
	cmp	w8, #0x100
	csetm	x16, lt
	cmp	w2, #0x40
	csetm	x17, lt
	ands	x16, x16, x17
	bne	L_aes_gcm_decrypt_arm64_crypto_eor3_h_done
	# Multiply H and H^2  => H^3
	pmull	v28.1q, v22.1d, v23.1d
	pmull2	v29.1q, v22.2d, v23.2d
	ext	v31.16b, v22.16b, v22.16b, #8
	pmull	v30.1q, v31.1d, v23.1d
	pmull2	v31.1q, v31.2d, v23.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v24.16b, v28.16b, v30.16b
	# Square H^2 => H^4
	pmull2	v31.1q, v23.2d, v23.2d
	pmull	v30.1q, v23.1d, v23.1d
	pmull2	v28.1q, v31.2d, v27.2d
	ext	v29.16b, v30.16b, v31.16b, #8
	eor	v29.16b, v29.16b, v28.16b
	pmull2	v31.1q, v29.2d, v27.2d
	mov	v30.d[1], v29.d[0]
	eor	v25.16b, v30.16b, v31.16b
	# Done
	cmp	w8, #0x400
	csetm	x16, lt
	cmp	w2, #0x200
	csetm	x17, lt
	ands	x16, x16, x17
	bne	L_aes_gcm_decrypt_arm64_crypto_eor3_h_done
	# Multiply H and H^4  => H^5
	pmull	v28.1q, v22.1d, v25.1d
	pmull2	v29.1q, v22.2d, v25.2d
	ext	v31.16b, v22.16b, v22.16b, #8
	pmull	v30.1q, v31.1d, v25.1d
	pmull2	v31.1q, v31.2d, v25.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v4.16b, v28.16b, v30.16b
	# Square H^3 => H^6
	pmull2	v31.1q, v24.2d, v24.2d
	pmull	v30.1q, v24.1d, v24.1d
	pmull2	v28.1q, v31.2d, v27.2d
	ext	v29.16b, v30.16b, v31.16b, #8
	eor	v29.16b, v29.16b, v28.16b
	pmull2	v31.1q, v29.2d, v27.2d
	mov	v30.d[1], v29.d[0]
	eor	v5.16b, v30.16b, v31.16b
	# Multiply H and H^6  => H^7
	pmull	v28.1q, v22.1d, v5.1d
	pmull2	v29.1q, v22.2d, v5.2d
	ext	v31.16b, v22.16b, v22.16b, #8
	pmull	v30.1q, v31.1d, v5.1d
	pmull2	v31.1q, v31.2d, v5.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v6.16b, v28.16b, v30.16b
	# Square H^4 => H^8
	pmull2	v31.1q, v25.2d, v25.2d
	pmull	v30.1q, v25.1d, v25.1d
	pmull2	v28.1q, v31.2d, v27.2d
	ext	v29.16b, v30.16b, v31.16b, #8
	eor	v29.16b, v29.16b, v28.16b
	pmull2	v31.1q, v29.2d, v27.2d
	mov	v30.d[1], v29.d[0]
	eor	v7.16b, v30.16b, v31.16b
	# Done
L_aes_gcm_decrypt_arm64_crypto_eor3_h_done:
	lsr	w14, w8, #4
	cmp	w14, #4
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_aad_start_1
	cmp	w14, #16
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_aad_start_2
	cmp	w14, #0x40
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_aad_start_4
L_aes_gcm_decrypt_arm64_crypto_eor3_aad_start_8:
	ld1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x7], #0x40
	ld1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x7], #0x40
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	rbit	v0.16b, v0.16b
	rbit	v1.16b, v1.16b
	rbit	v2.16b, v2.16b
	rbit	v3.16b, v3.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	ext	v31.16b, v3.16b, v3.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	sub	w14, w14, #8
	cmp	w14, #8
	bge	L_aes_gcm_decrypt_arm64_crypto_eor3_aad_start_8
	cmp	w14, #1
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_aad_done
	beq	L_aes_gcm_decrypt_arm64_crypto_eor3_aad_start_1
	cmp	w14, #16
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_aad_start_2
L_aes_gcm_decrypt_arm64_crypto_eor3_aad_start_4:
	ld1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x7], #0x40
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	sub	w14, w14, #4
	cmp	w14, #4
	bge	L_aes_gcm_decrypt_arm64_crypto_eor3_aad_start_4
	cmp	w14, #1
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_aad_done
	beq	L_aes_gcm_decrypt_arm64_crypto_eor3_aad_start_1
L_aes_gcm_decrypt_arm64_crypto_eor3_aad_start_2:
	ld1	{v18.16b, v19.16b}, [x7], #32
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v19.1d, v22.1d
	pmull2	v29.1q, v19.2d, v22.2d
	ext	v31.16b, v19.16b, v19.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v21.1d
	pmull2	v26.1q, v23.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	sub	w14, w14, #2
	cmp	w14, #1
	bgt	L_aes_gcm_decrypt_arm64_crypto_eor3_aad_start_2
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_aad_done
L_aes_gcm_decrypt_arm64_crypto_eor3_aad_start_1:
	cbz	w14, L_aes_gcm_decrypt_arm64_crypto_eor3_aad_done
L_aes_gcm_decrypt_arm64_crypto_eor3_aad_both_1:
	ld1	{v18.16b}, [x7], #16
	rbit	v18.16b, v18.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	subs	w14, w14, #1
	bne	L_aes_gcm_decrypt_arm64_crypto_eor3_aad_both_1
L_aes_gcm_decrypt_arm64_crypto_eor3_aad_done:
	and	w14, w8, #15
	cbz	w14, L_aes_gcm_decrypt_arm64_crypto_eor3_aad_partial_done
	eor	v28.16b, v28.16b, v28.16b
	mov	w20, w14
	st1	{v28.2d}, [x11]
	cmp	w20, #8
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_aad_start_dw
	ldr	x19, [x7], #8
	sub	w20, w20, #8
	str	x19, [x11], #8
L_aes_gcm_decrypt_arm64_crypto_eor3_aad_start_dw:
	cmp	w20, #4
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_aad_start_sw
	ldr	w19, [x7], #4
	sub	w20, w20, #4
	str	w19, [x11], #4
L_aes_gcm_decrypt_arm64_crypto_eor3_aad_start_sw:
	cmp	w20, #2
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_aad_start_byte
	ldrh	w19, [x7], #2
	sub	w20, w20, #2
	strh	w19, [x11], #2
L_aes_gcm_decrypt_arm64_crypto_eor3_aad_start_byte:
	cbz	w20, L_aes_gcm_decrypt_arm64_crypto_eor3_aad_end_bytes
	ldrb	w19, [x7], #1
	subs	w20, w20, #1
	strb	w19, [x11], #1
	bne	L_aes_gcm_decrypt_arm64_crypto_eor3_aad_start_byte
L_aes_gcm_decrypt_arm64_crypto_eor3_aad_end_bytes:
	sub	x11, x11, x14
	ld1	{v18.2d}, [x11]
	rbit	v18.16b, v18.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_decrypt_arm64_crypto_eor3_aad_partial_done:
	# Load Nonce
	cmp	w4, #12
	bne	L_aes_gcm_decrypt_arm64_crypto_eor3_ghash_nonce
	ldr	x16, [x3]
	movi	v13.4s, #1, lsl 24
	ldr	w17, [x3, #8]
	mov	v13.d[0], x16
	mov	v13.s[2], w17
	mov	w15, #1
	b	L_aes_gcm_decrypt_arm64_crypto_eor3_done_nonce
L_aes_gcm_decrypt_arm64_crypto_eor3_ghash_nonce:
	eor	v13.16b, v13.16b, v13.16b
	lsr	w14, w4, #4
	cbz	w14, L_aes_gcm_decrypt_arm64_crypto_eor3_nonce_done
L_aes_gcm_decrypt_arm64_crypto_eor3_nonce_start_1:
	ld1	{v18.16b}, [x3], #16
	rbit	v18.16b, v18.16b
	eor	v21.16b, v13.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v13.16b, v28.16b, v30.16b
	# Done GHASH
	subs	w14, w14, #1
	bne	L_aes_gcm_decrypt_arm64_crypto_eor3_nonce_start_1
L_aes_gcm_decrypt_arm64_crypto_eor3_nonce_done:
	and	w24, w4, #15
	cbz	x24, L_aes_gcm_decrypt_arm64_crypto_eor3_nonce_partial_done
	eor	v28.16b, v28.16b, v28.16b
	mov	w20, w24
	st1	{v28.2d}, [x11]
	cmp	w20, #8
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_nonce_start_dw
	ldr	x19, [x3], #8
	sub	w20, w20, #8
	str	x19, [x11], #8
L_aes_gcm_decrypt_arm64_crypto_eor3_nonce_start_dw:
	cmp	w20, #4
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_nonce_start_sw
	ldr	w19, [x3], #4
	sub	w20, w20, #4
	str	w19, [x11], #4
L_aes_gcm_decrypt_arm64_crypto_eor3_nonce_start_sw:
	cmp	w20, #2
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_nonce_start_byte
	ldrh	w19, [x3], #2
	sub	w20, w20, #2
	strh	w19, [x11], #2
L_aes_gcm_decrypt_arm64_crypto_eor3_nonce_start_byte:
	cbz	w20, L_aes_gcm_decrypt_arm64_crypto_eor3_nonce_end_bytes
	ldrb	w19, [x3], #1
	subs	w20, w20, #1
	strb	w19, [x11], #1
	bne	L_aes_gcm_decrypt_arm64_crypto_eor3_nonce_start_byte
L_aes_gcm_decrypt_arm64_crypto_eor3_nonce_end_bytes:
	sub	x11, x11, x24
	ld1	{v18.2d}, [x11]
	rbit	v18.16b, v18.16b
	eor	v21.16b, v13.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v13.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_decrypt_arm64_crypto_eor3_nonce_partial_done:
	eor	x14, x14, x14
	lsl	x24, x4, #3
	mov	v28.d[0], x14
	mov	v28.d[1], x24
	rev64	v28.16b, v28.16b
	rbit	v28.16b, v28.16b
	eor	v13.16b, v13.16b, v28.16b
	pmull	v28.1q, v13.1d, v22.1d
	pmull2	v29.1q, v13.2d, v22.2d
	ext	v31.16b, v13.16b, v13.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v13.16b, v28.16b, v30.16b
	rbit	v13.16b, v13.16b
	mov	w15, v13.s[3]
	rev	w15, w15
L_aes_gcm_decrypt_arm64_crypto_eor3_done_nonce:
	st1	{v13.2d}, [x12]
	lsr	w14, w2, #4
	cmp	w13, #12
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_start_128
	bgt	L_aes_gcm_decrypt_arm64_crypto_eor3_start_256
	# AES_GCM_192
#ifndef NO_AES_192
	cmp	w14, #32
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_192_start_4
L_aes_gcm_decrypt_arm64_crypto_eor3_192_start_8:
	ldr	q12, [x9]
	add	w24, w15, #1
	mov	v14.16b, v13.16b
	add	w23, w15, #2
	mov	v15.16b, v13.16b
	add	w22, w15, #3
	mov	v16.16b, v13.16b
	add	w21, w15, #4
	mov	v17.16b, v13.16b
	add	w20, w15, #5
	mov	v8.16b, v13.16b
	add	w19, w15, #6
	mov	v9.16b, v13.16b
	add	w17, w15, #7
	mov	v10.16b, v13.16b
	add	w15, w15, #8
	mov	v11.16b, v13.16b
	rev	w24, w24
	mov	v14.s[3], w24
	rev	w23, w23
	mov	v15.s[3], w23
	rev	w22, w22
	mov	v16.s[3], w22
	rev	w21, w21
	mov	v17.s[3], w21
	rev	w20, w20
	mov	v8.s[3], w20
	rev	w19, w19
	mov	v9.s[3], w19
	rev	w17, w17
	mov	v10.s[3], w17
	rev	w16, w15
	mov	v11.s[3], w16
	ldr	q13, [x9, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w14, w14, #8
	ldr	q12, [x9, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ld1	{v18.16b}, [x0], #16
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v19.16b}, [x0], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v20.16b}, [x0], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v21.16b}, [x0], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #160]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	ld1	{v0.16b}, [x0], #16
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	ld1	{v1.16b}, [x0], #16
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ld1	{v2.16b}, [x0], #16
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v3.16b}, [x0], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #176]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #192]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	eor	v8.16b, v8.16b, v0.16b
	eor	v9.16b, v9.16b, v1.16b
	eor	v10.16b, v10.16b, v2.16b
	eor	v11.16b, v11.16b, v3.16b
	ld1	{v13.2d}, [x12]
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x1], #0x40
	st1	{v8.16b, v9.16b, v10.16b, v11.16b}, [x1], #0x40
	cmp	w14, #8
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_192_end_8
L_aes_gcm_decrypt_arm64_crypto_eor3_192_both_8:
	ldr	q12, [x9]
	add	w24, w15, #1
	mov	v14.16b, v13.16b
	add	w23, w15, #2
	mov	v15.16b, v13.16b
	add	w22, w15, #3
	mov	v16.16b, v13.16b
	add	w21, w15, #4
	mov	v17.16b, v13.16b
	add	w20, w15, #5
	mov	v8.16b, v13.16b
	add	w19, w15, #6
	mov	v9.16b, v13.16b
	add	w17, w15, #7
	mov	v10.16b, v13.16b
	add	w15, w15, #8
	mov	v11.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w24, w24
	rbit	v19.16b, v19.16b
	mov	v14.s[3], w24
	rev	w23, w23
	rbit	v20.16b, v20.16b
	mov	v15.s[3], w23
	rev	w22, w22
	rbit	v21.16b, v21.16b
	mov	v16.s[3], w22
	rev	w21, w21
	rbit	v0.16b, v0.16b
	mov	v17.s[3], w21
	rev	w20, w20
	rbit	v1.16b, v1.16b
	mov	v8.s[3], w20
	rev	w19, w19
	rbit	v2.16b, v2.16b
	mov	v9.s[3], w19
	rev	w17, w17
	rbit	v3.16b, v3.16b
	mov	v10.s[3], w17
	rev	w16, w15
	eor	v18.16b, v18.16b, v26.16b
	mov	v11.s[3], w16
	ldr	q13, [x9, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ext	v31.16b, v3.16b, v3.16b, #8
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w14, w14, #8
	ldr	q12, [x9, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	mov	v28.d[1], v31.d[0]
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	eor	v26.16b, v28.16b, v30.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	# Done GHASH
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ld1	{v18.16b}, [x0], #16
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v19.16b}, [x0], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ld1	{v20.16b}, [x0], #16
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ld1	{v21.16b}, [x0], #16
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ld1	{v0.16b}, [x0], #16
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v1.16b}, [x0], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v2.16b}, [x0], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v3.16b}, [x0], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #160]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #176]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #192]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	ld1	{v13.2d}, [x12]
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x1], #0x40
	eor	v8.16b, v8.16b, v0.16b
	eor	v9.16b, v9.16b, v1.16b
	eor	v10.16b, v10.16b, v2.16b
	eor	v11.16b, v11.16b, v3.16b
	st1	{v8.16b, v9.16b, v10.16b, v11.16b}, [x1], #0x40
	cmp	w14, #8
	bge	L_aes_gcm_decrypt_arm64_crypto_eor3_192_both_8
L_aes_gcm_decrypt_arm64_crypto_eor3_192_end_8:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	rbit	v0.16b, v0.16b
	rbit	v1.16b, v1.16b
	rbit	v2.16b, v2.16b
	rbit	v3.16b, v3.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	ext	v31.16b, v3.16b, v3.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_decrypt_arm64_crypto_eor3_192_start_4:
	ld1	{v0.2d, v1.2d, v2.2d, v3.2d}, [x9], #0x40
	ld1	{v4.2d, v5.2d, v6.2d, v7.2d}, [x9], #0x40
	ld1	{v8.2d, v9.2d, v10.2d, v11.2d}, [x9], #0x40
	ld1	{v12.2d}, [x9]
	cmp	w14, #1
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_192_done
	beq	L_aes_gcm_decrypt_arm64_crypto_eor3_192_start_1
	cmp	w14, #4
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_192_start_2
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w19, w15, #2
	mov	v15.16b, v13.16b
	add	w17, w15, #3
	mov	v16.16b, v13.16b
	add	w15, w15, #4
	mov	v17.16b, v13.16b
	rev	w20, w20
	mov	v14.s[3], w20
	rev	w19, w19
	mov	v15.s[3], w19
	rev	w17, w17
	mov	v16.s[3], w17
	rev	w16, w15
	mov	v17.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w14, w14, #4
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b}, [x0], #16
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	ld1	{v19.16b}, [x0], #16
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	ld1	{v20.16b}, [x0], #16
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	ld1	{v21.16b}, [x0], #16
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v11.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v11.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v11.16b
	eor	v17.16b, v17.16b, v12.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	cmp	w14, #4
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x1], #0x40
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_192_end_4
L_aes_gcm_decrypt_arm64_crypto_eor3_192_both_4:
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w19, w15, #2
	mov	v15.16b, v13.16b
	add	w17, w15, #3
	mov	v16.16b, v13.16b
	add	w15, w15, #4
	mov	v17.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w20, w20
	rbit	v19.16b, v19.16b
	mov	v14.s[3], w20
	rev	w19, w19
	rbit	v20.16b, v20.16b
	mov	v15.s[3], w19
	rev	w17, w17
	rbit	v21.16b, v21.16b
	mov	v16.s[3], w17
	rev	w16, w15
	mov	v17.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	eor	v18.16b, v18.16b, v26.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	ext	v31.16b, v21.16b, v21.16b, #8
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w14, w14, #4
	mov	v28.d[1], v31.d[0]
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v28.16b, v30.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	# Done GHASH
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x0], #0x40
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v11.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v11.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v11.16b
	eor	v17.16b, v17.16b, v12.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	cmp	w14, #4
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x1], #0x40
	bge	L_aes_gcm_decrypt_arm64_crypto_eor3_192_both_4
L_aes_gcm_decrypt_arm64_crypto_eor3_192_end_4:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cmp	w14, #1
	beq	L_aes_gcm_decrypt_arm64_crypto_eor3_192_start_1
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_192_done
L_aes_gcm_decrypt_arm64_crypto_eor3_192_start_2:
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w15, w15, #2
	mov	v15.16b, v13.16b
	rev	w20, w20
	mov	v14.s[3], w20
	rev	w16, w15
	mov	v15.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	subs	w14, w14, #2
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x0], #16
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	ld1	{v19.16b}, [x0], #16
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v11.16b
	eor	v15.16b, v15.16b, v12.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	st1	{v14.16b, v15.16b}, [x1], #32
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v19.1d, v22.1d
	pmull2	v29.1q, v19.2d, v22.2d
	ext	v31.16b, v19.16b, v19.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v21.1d
	pmull2	v26.1q, v23.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cbz	w14, L_aes_gcm_decrypt_arm64_crypto_eor3_192_done
L_aes_gcm_decrypt_arm64_crypto_eor3_192_start_1:
	ld1	{v15.16b}, [x0], #16
	add	w15, w15, #1
	mov	v14.16b, v13.16b
	rbit	v15.16b, v15.16b
	rev	w16, w15
	mov	v14.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	eor	v16.16b, v26.16b, v15.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	#   X  = C * H^1
	pmull	v28.1q, v16.1d, v22.1d
	pmull2	v29.1q, v16.2d, v22.2d
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	ext	v31.16b, v16.16b, v16.16b, #8
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	mov	v28.d[1], v31.d[0]
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v28.16b, v30.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	# Done GHASH
	rbit	v15.16b, v15.16b
	eor	v14.16b, v14.16b, v15.16b
	st1	{v14.16b}, [x1], #16
L_aes_gcm_decrypt_arm64_crypto_eor3_192_done:
	ands	w14, w2, #15
	beq	L_aes_gcm_decrypt_arm64_crypto_eor3_192_partial_done
	eor	v15.16b, v15.16b, v15.16b
	mov	w19, w14
	st1	{v15.2d}, [x11]
	cmp	x19, #8
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_192_start_dw
	ldr	x17, [x0], #8
	sub	x19, x19, #8
	str	x17, [x11], #8
L_aes_gcm_decrypt_arm64_crypto_eor3_192_start_dw:
	cmp	x19, #4
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_192_start_sw
	ldr	w17, [x0], #4
	sub	x19, x19, #4
	str	w17, [x11], #4
L_aes_gcm_decrypt_arm64_crypto_eor3_192_start_sw:
	cmp	x19, #2
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_192_start_byte
	ldrh	w17, [x0], #2
	sub	x19, x19, #2
	strh	w17, [x11], #2
L_aes_gcm_decrypt_arm64_crypto_eor3_192_start_byte:
	cbz	x19, L_aes_gcm_decrypt_arm64_crypto_eor3_192_end_bytes
	ldrb	w17, [x0], #1
	subs	x19, x19, #1
	strb	w17, [x11], #1
	bne	L_aes_gcm_decrypt_arm64_crypto_eor3_192_start_byte
L_aes_gcm_decrypt_arm64_crypto_eor3_192_end_bytes:
	sub	x11, x11, x14
	ld1	{v15.2d}, [x11]
	add	w15, w15, #1
	mov	v14.16b, v13.16b
	rbit	v15.16b, v15.16b
	rev	w16, w15
	mov	v14.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	eor	v16.16b, v26.16b, v15.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	#   X  = C * H^1
	pmull	v28.1q, v16.1d, v22.1d
	pmull2	v29.1q, v16.2d, v22.2d
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	ext	v31.16b, v16.16b, v16.16b, #8
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	mov	v28.d[1], v31.d[0]
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v28.16b, v30.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	# Done GHASH
	rbit	v15.16b, v15.16b
	eor	v14.16b, v14.16b, v15.16b
	st1	{v14.2d}, [x11]
	cmp	w14, #8
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_192_out_start_dw
	ldr	x17, [x11], #8
	sub	w14, w14, #8
	str	x17, [x1], #8
L_aes_gcm_decrypt_arm64_crypto_eor3_192_out_start_dw:
	cmp	w14, #4
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_192_out_start_sw
	ldr	w17, [x11], #4
	sub	w14, w14, #4
	str	w17, [x1], #4
L_aes_gcm_decrypt_arm64_crypto_eor3_192_out_start_sw:
	cmp	w14, #2
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_192_out_start_byte
	ldrh	w17, [x11], #2
	sub	w14, w14, #2
	strh	w17, [x1], #2
L_aes_gcm_decrypt_arm64_crypto_eor3_192_out_start_byte:
	cbz	w14, L_aes_gcm_decrypt_arm64_crypto_eor3_192_out_end_bytes
	ldrb	w17, [x11], #1
	subs	w14, w14, #1
	strb	w17, [x1], #1
	bne	L_aes_gcm_decrypt_arm64_crypto_eor3_192_out_start_byte
L_aes_gcm_decrypt_arm64_crypto_eor3_192_out_end_bytes:
L_aes_gcm_decrypt_arm64_crypto_eor3_192_partial_done:
	ld1	{v14.2d}, [x12]
	lsl	x8, x8, #3
	rbit	x8, x8
	mov	v28.d[0], x8
	lsl	x2, x2, #3
	rbit	x2, x2
	mov	v28.d[1], x2
	eor	v26.16b, v26.16b, v28.16b
	pmull	v28.1q, v26.1d, v22.1d
	pmull2	v29.1q, v26.2d, v22.2d
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	ext	v31.16b, v26.16b, v26.16b, #8
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	mov	v28.d[1], v31.d[0]
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v28.16b, v30.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	rbit	v26.16b, v26.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	eor	v26.16b, v26.16b, v14.16b
	cmp	w6, #16
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_192_part_tag
	ld1	{v28.16b}, [x5]
	b	L_aes_gcm_decrypt_arm64_crypto_eor3_192_tag_loaded
L_aes_gcm_decrypt_arm64_crypto_eor3_192_part_tag:
	eor	v28.16b, v28.16b, v28.16b
	mov	x17, x6
	st1	{v28.2d}, [x11]
	cmp	x17, #8
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_192_tag_start_dw
	ldr	x16, [x5], #8
	sub	x17, x17, #8
	str	x16, [x11], #8
L_aes_gcm_decrypt_arm64_crypto_eor3_192_tag_start_dw:
	cmp	x17, #4
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_192_tag_start_sw
	ldr	w16, [x5], #4
	sub	x17, x17, #4
	str	w16, [x11], #4
L_aes_gcm_decrypt_arm64_crypto_eor3_192_tag_start_sw:
	cmp	x17, #2
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_192_tag_start_byte
	ldrh	w16, [x5], #2
	sub	x17, x17, #2
	strh	w16, [x11], #2
L_aes_gcm_decrypt_arm64_crypto_eor3_192_tag_start_byte:
	cbz	x17, L_aes_gcm_decrypt_arm64_crypto_eor3_192_tag_end_bytes
	ldrb	w16, [x5], #1
	subs	x17, x17, #1
	strb	w16, [x11], #1
	bne	L_aes_gcm_decrypt_arm64_crypto_eor3_192_tag_start_byte
L_aes_gcm_decrypt_arm64_crypto_eor3_192_tag_end_bytes:
	sub	x11, x11, x6
	ld1	{v28.2d}, [x11]
	mov	x17, #16
	st1	{v26.2d}, [x11]
	sub	x17, x17, x6
	add	x11, x11, x6
L_aes_gcm_decrypt_arm64_crypto_eor3_192_calc_tag_byte:
	strb	wzr, [x11], #1
	subs	x17, x17, #1
	bne	L_aes_gcm_decrypt_arm64_crypto_eor3_192_calc_tag_byte
	subs	x11, x11, #16
	ld1	{v26.2d}, [x11]
L_aes_gcm_decrypt_arm64_crypto_eor3_192_tag_loaded:
	eor	v28.16b, v28.16b, v26.16b
	mov	x16, v28.d[0]
	mov	x17, v28.d[1]
	mov	w19, #-180
	orr	x16, x16, x17
	cmp	x16, #0
	csetm	x0, ne
	and	x0, x0, x19
#endif /* !NO_AES_192 */
	b	L_aes_gcm_decrypt_arm64_crypto_eor3_done
	# AES_GCM_256
L_aes_gcm_decrypt_arm64_crypto_eor3_start_256:
#ifndef NO_AES_256
	cmp	w14, #32
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_256_start_4
L_aes_gcm_decrypt_arm64_crypto_eor3_256_start_8:
	ldr	q12, [x9]
	add	w24, w15, #1
	mov	v14.16b, v13.16b
	add	w23, w15, #2
	mov	v15.16b, v13.16b
	add	w22, w15, #3
	mov	v16.16b, v13.16b
	add	w21, w15, #4
	mov	v17.16b, v13.16b
	add	w20, w15, #5
	mov	v8.16b, v13.16b
	add	w19, w15, #6
	mov	v9.16b, v13.16b
	add	w17, w15, #7
	mov	v10.16b, v13.16b
	add	w15, w15, #8
	mov	v11.16b, v13.16b
	rev	w24, w24
	mov	v14.s[3], w24
	rev	w23, w23
	mov	v15.s[3], w23
	rev	w22, w22
	mov	v16.s[3], w22
	rev	w21, w21
	mov	v17.s[3], w21
	rev	w20, w20
	mov	v8.s[3], w20
	rev	w19, w19
	mov	v9.s[3], w19
	rev	w17, w17
	mov	v10.s[3], w17
	rev	w16, w15
	mov	v11.s[3], w16
	ldr	q13, [x9, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w14, w14, #8
	ldr	q12, [x9, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ld1	{v18.16b}, [x0], #16
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v19.16b}, [x0], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v20.16b}, [x0], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v21.16b}, [x0], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #160]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	ld1	{v0.16b}, [x0], #16
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	ld1	{v1.16b}, [x0], #16
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ld1	{v2.16b}, [x0], #16
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v3.16b}, [x0], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #176]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #192]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #208]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #224]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	eor	v8.16b, v8.16b, v0.16b
	eor	v9.16b, v9.16b, v1.16b
	eor	v10.16b, v10.16b, v2.16b
	eor	v11.16b, v11.16b, v3.16b
	ld1	{v13.2d}, [x12]
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x1], #0x40
	st1	{v8.16b, v9.16b, v10.16b, v11.16b}, [x1], #0x40
	cmp	w14, #8
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_256_end_8
L_aes_gcm_decrypt_arm64_crypto_eor3_256_both_8:
	ldr	q12, [x9]
	add	w24, w15, #1
	mov	v14.16b, v13.16b
	add	w23, w15, #2
	mov	v15.16b, v13.16b
	add	w22, w15, #3
	mov	v16.16b, v13.16b
	add	w21, w15, #4
	mov	v17.16b, v13.16b
	add	w20, w15, #5
	mov	v8.16b, v13.16b
	add	w19, w15, #6
	mov	v9.16b, v13.16b
	add	w17, w15, #7
	mov	v10.16b, v13.16b
	add	w15, w15, #8
	mov	v11.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w24, w24
	rbit	v19.16b, v19.16b
	mov	v14.s[3], w24
	rev	w23, w23
	rbit	v20.16b, v20.16b
	mov	v15.s[3], w23
	rev	w22, w22
	rbit	v21.16b, v21.16b
	mov	v16.s[3], w22
	rev	w21, w21
	rbit	v0.16b, v0.16b
	mov	v17.s[3], w21
	rev	w20, w20
	rbit	v1.16b, v1.16b
	mov	v8.s[3], w20
	rev	w19, w19
	rbit	v2.16b, v2.16b
	mov	v9.s[3], w19
	rev	w17, w17
	rbit	v3.16b, v3.16b
	mov	v10.s[3], w17
	rev	w16, w15
	eor	v18.16b, v18.16b, v26.16b
	mov	v11.s[3], w16
	ldr	q13, [x9, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ext	v31.16b, v3.16b, v3.16b, #8
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w14, w14, #8
	ldr	q12, [x9, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	mov	v28.d[1], v31.d[0]
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	eor	v26.16b, v28.16b, v30.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	# Done GHASH
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ld1	{v18.16b}, [x0], #16
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v19.16b}, [x0], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ld1	{v20.16b}, [x0], #16
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ld1	{v21.16b}, [x0], #16
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ld1	{v0.16b}, [x0], #16
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v1.16b}, [x0], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v2.16b}, [x0], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v3.16b}, [x0], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #160]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #176]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #192]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #208]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #224]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	ld1	{v13.2d}, [x12]
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x1], #0x40
	eor	v8.16b, v8.16b, v0.16b
	eor	v9.16b, v9.16b, v1.16b
	eor	v10.16b, v10.16b, v2.16b
	eor	v11.16b, v11.16b, v3.16b
	st1	{v8.16b, v9.16b, v10.16b, v11.16b}, [x1], #0x40
	cmp	w14, #8
	bge	L_aes_gcm_decrypt_arm64_crypto_eor3_256_both_8
L_aes_gcm_decrypt_arm64_crypto_eor3_256_end_8:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	rbit	v0.16b, v0.16b
	rbit	v1.16b, v1.16b
	rbit	v2.16b, v2.16b
	rbit	v3.16b, v3.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	ext	v31.16b, v3.16b, v3.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_decrypt_arm64_crypto_eor3_256_start_4:
	ld1	{v0.2d, v1.2d, v2.2d, v3.2d}, [x9], #0x40
	ld1	{v4.2d, v5.2d, v6.2d, v7.2d}, [x9], #0x40
	ld1	{v8.2d, v9.2d, v10.2d, v11.2d}, [x9], #0x40
	ld1	{v12.2d}, [x9], #16
	cmp	w14, #1
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_256_done
	beq	L_aes_gcm_decrypt_arm64_crypto_eor3_256_start_1
	cmp	w14, #4
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_256_start_2
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w19, w15, #2
	mov	v15.16b, v13.16b
	add	w17, w15, #3
	mov	v16.16b, v13.16b
	add	w15, w15, #4
	mov	v17.16b, v13.16b
	rev	w20, w20
	mov	v14.s[3], w20
	rev	w19, w19
	mov	v15.s[3], w19
	rev	w17, w17
	mov	v16.s[3], w17
	rev	w16, w15
	mov	v17.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w14, w14, #4
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b}, [x0], #16
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	ld1	{v19.16b}, [x0], #16
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	ld1	{v20.16b}, [x0], #16
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	ld1	{v21.16b}, [x0], #16
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v11.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v11.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v11.16b
	aesmc	v17.16b, v17.16b
	ld1	{v29.2d, v30.2d}, [x9]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	aese	v15.16b, v29.16b
	eor	v15.16b, v15.16b, v30.16b
	aese	v16.16b, v29.16b
	eor	v16.16b, v16.16b, v30.16b
	aese	v17.16b, v29.16b
	eor	v17.16b, v17.16b, v30.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	cmp	w14, #4
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x1], #0x40
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_256_end_4
L_aes_gcm_decrypt_arm64_crypto_eor3_256_both_4:
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w19, w15, #2
	mov	v15.16b, v13.16b
	add	w17, w15, #3
	mov	v16.16b, v13.16b
	add	w15, w15, #4
	mov	v17.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w20, w20
	rbit	v19.16b, v19.16b
	mov	v14.s[3], w20
	rev	w19, w19
	rbit	v20.16b, v20.16b
	mov	v15.s[3], w19
	rev	w17, w17
	rbit	v21.16b, v21.16b
	mov	v16.s[3], w17
	rev	w16, w15
	mov	v17.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	eor	v18.16b, v18.16b, v26.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	ext	v31.16b, v21.16b, v21.16b, #8
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w14, w14, #4
	mov	v28.d[1], v31.d[0]
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v28.16b, v30.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	# Done GHASH
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x0], #0x40
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v11.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v11.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v11.16b
	aesmc	v17.16b, v17.16b
	ld1	{v29.2d, v30.2d}, [x9]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	aese	v15.16b, v29.16b
	eor	v15.16b, v15.16b, v30.16b
	aese	v16.16b, v29.16b
	eor	v16.16b, v16.16b, v30.16b
	aese	v17.16b, v29.16b
	eor	v17.16b, v17.16b, v30.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	cmp	w14, #4
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x1], #0x40
	bge	L_aes_gcm_decrypt_arm64_crypto_eor3_256_both_4
L_aes_gcm_decrypt_arm64_crypto_eor3_256_end_4:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cmp	w14, #1
	beq	L_aes_gcm_decrypt_arm64_crypto_eor3_256_start_1
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_256_done
L_aes_gcm_decrypt_arm64_crypto_eor3_256_start_2:
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w15, w15, #2
	mov	v15.16b, v13.16b
	rev	w20, w20
	mov	v14.s[3], w20
	rev	w16, w15
	mov	v15.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	subs	w14, w14, #2
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x0], #16
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	ld1	{v19.16b}, [x0], #16
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v11.16b
	aesmc	v15.16b, v15.16b
	ld1	{v29.2d, v30.2d}, [x9]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	aese	v15.16b, v29.16b
	eor	v15.16b, v15.16b, v30.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	st1	{v14.16b, v15.16b}, [x1], #32
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v19.1d, v22.1d
	pmull2	v29.1q, v19.2d, v22.2d
	ext	v31.16b, v19.16b, v19.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v21.1d
	pmull2	v26.1q, v23.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cbz	w14, L_aes_gcm_decrypt_arm64_crypto_eor3_256_done
L_aes_gcm_decrypt_arm64_crypto_eor3_256_start_1:
	add	w15, w15, #1
	mov	v14.16b, v13.16b
	rev	w16, w15
	mov	v14.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x0], #16
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	ldr	q29, [x9]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ldr	q30, [x9, #16]
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	eor	v14.16b, v14.16b, v18.16b
	st1	{v14.16b}, [x1], #16
	rbit	v18.16b, v18.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_decrypt_arm64_crypto_eor3_256_done:
	ands	w14, w2, #15
	beq	L_aes_gcm_decrypt_arm64_crypto_eor3_256_partial_done
	eor	v15.16b, v15.16b, v15.16b
	mov	w19, w14
	st1	{v15.2d}, [x11]
	cmp	x19, #8
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_256_start_dw
	ldr	x17, [x0], #8
	sub	x19, x19, #8
	str	x17, [x11], #8
L_aes_gcm_decrypt_arm64_crypto_eor3_256_start_dw:
	cmp	x19, #4
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_256_start_sw
	ldr	w17, [x0], #4
	sub	x19, x19, #4
	str	w17, [x11], #4
L_aes_gcm_decrypt_arm64_crypto_eor3_256_start_sw:
	cmp	x19, #2
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_256_start_byte
	ldrh	w17, [x0], #2
	sub	x19, x19, #2
	strh	w17, [x11], #2
L_aes_gcm_decrypt_arm64_crypto_eor3_256_start_byte:
	cbz	x19, L_aes_gcm_decrypt_arm64_crypto_eor3_256_end_bytes
	ldrb	w17, [x0], #1
	subs	x19, x19, #1
	strb	w17, [x11], #1
	bne	L_aes_gcm_decrypt_arm64_crypto_eor3_256_start_byte
L_aes_gcm_decrypt_arm64_crypto_eor3_256_end_bytes:
	sub	x11, x11, x14
	ld1	{v15.2d}, [x11]
	add	w15, w15, #1
	mov	v14.16b, v13.16b
	rbit	v15.16b, v15.16b
	rev	w16, w15
	mov	v14.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	eor	v16.16b, v26.16b, v15.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	#   X  = C * H^1
	pmull	v28.1q, v16.1d, v22.1d
	pmull2	v29.1q, v16.2d, v22.2d
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	ext	v31.16b, v16.16b, v16.16b, #8
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	mov	v28.d[1], v31.d[0]
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v28.16b, v30.16b
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	ldr	q29, [x9]
	# Done GHASH
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ldr	q30, [x9, #16]
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	rbit	v15.16b, v15.16b
	eor	v14.16b, v14.16b, v15.16b
	st1	{v14.2d}, [x11]
	cmp	w14, #8
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_256_out_start_dw
	ldr	x17, [x11], #8
	sub	w14, w14, #8
	str	x17, [x1], #8
L_aes_gcm_decrypt_arm64_crypto_eor3_256_out_start_dw:
	cmp	w14, #4
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_256_out_start_sw
	ldr	w17, [x11], #4
	sub	w14, w14, #4
	str	w17, [x1], #4
L_aes_gcm_decrypt_arm64_crypto_eor3_256_out_start_sw:
	cmp	w14, #2
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_256_out_start_byte
	ldrh	w17, [x11], #2
	sub	w14, w14, #2
	strh	w17, [x1], #2
L_aes_gcm_decrypt_arm64_crypto_eor3_256_out_start_byte:
	cbz	w14, L_aes_gcm_decrypt_arm64_crypto_eor3_256_out_end_bytes
	ldrb	w17, [x11], #1
	subs	w14, w14, #1
	strb	w17, [x1], #1
	bne	L_aes_gcm_decrypt_arm64_crypto_eor3_256_out_start_byte
L_aes_gcm_decrypt_arm64_crypto_eor3_256_out_end_bytes:
L_aes_gcm_decrypt_arm64_crypto_eor3_256_partial_done:
	ld1	{v14.2d}, [x12]
	lsl	x8, x8, #3
	rbit	x8, x8
	mov	v28.d[0], x8
	lsl	x2, x2, #3
	rbit	x2, x2
	mov	v28.d[1], x2
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v26.16b, v28.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	pmull	v28.1q, v26.1d, v22.1d
	pmull2	v29.1q, v26.2d, v22.2d
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	ext	v31.16b, v26.16b, v26.16b, #8
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	mov	v28.d[1], v31.d[0]
	ldr	q11, [x9, #-32]
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v28.16b, v30.16b
	ldr	q12, [x9, #-16]
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	ldr	q29, [x9]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	rbit	v26.16b, v26.16b
	ldr	q30, [x9, #16]
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	eor	v26.16b, v26.16b, v14.16b
	cmp	w6, #16
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_256_part_tag
	ld1	{v28.16b}, [x5]
	b	L_aes_gcm_decrypt_arm64_crypto_eor3_256_tag_loaded
L_aes_gcm_decrypt_arm64_crypto_eor3_256_part_tag:
	eor	v28.16b, v28.16b, v28.16b
	mov	x17, x6
	st1	{v28.2d}, [x11]
	cmp	x17, #8
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_256_tag_start_dw
	ldr	x16, [x5], #8
	sub	x17, x17, #8
	str	x16, [x11], #8
L_aes_gcm_decrypt_arm64_crypto_eor3_256_tag_start_dw:
	cmp	x17, #4
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_256_tag_start_sw
	ldr	w16, [x5], #4
	sub	x17, x17, #4
	str	w16, [x11], #4
L_aes_gcm_decrypt_arm64_crypto_eor3_256_tag_start_sw:
	cmp	x17, #2
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_256_tag_start_byte
	ldrh	w16, [x5], #2
	sub	x17, x17, #2
	strh	w16, [x11], #2
L_aes_gcm_decrypt_arm64_crypto_eor3_256_tag_start_byte:
	cbz	x17, L_aes_gcm_decrypt_arm64_crypto_eor3_256_tag_end_bytes
	ldrb	w16, [x5], #1
	subs	x17, x17, #1
	strb	w16, [x11], #1
	bne	L_aes_gcm_decrypt_arm64_crypto_eor3_256_tag_start_byte
L_aes_gcm_decrypt_arm64_crypto_eor3_256_tag_end_bytes:
	sub	x11, x11, x6
	ld1	{v28.2d}, [x11]
	mov	x17, #16
	st1	{v26.2d}, [x11]
	sub	x17, x17, x6
	add	x11, x11, x6
L_aes_gcm_decrypt_arm64_crypto_eor3_256_calc_tag_byte:
	strb	wzr, [x11], #1
	subs	x17, x17, #1
	bne	L_aes_gcm_decrypt_arm64_crypto_eor3_256_calc_tag_byte
	subs	x11, x11, #16
	ld1	{v26.2d}, [x11]
L_aes_gcm_decrypt_arm64_crypto_eor3_256_tag_loaded:
	eor	v28.16b, v28.16b, v26.16b
	mov	x16, v28.d[0]
	mov	x17, v28.d[1]
	mov	w19, #-180
	orr	x16, x16, x17
	cmp	x16, #0
	csetm	x0, ne
	and	x0, x0, x19
#endif /* !NO_AES_256 */
	b	L_aes_gcm_decrypt_arm64_crypto_eor3_done
	# AES_GCM_128
L_aes_gcm_decrypt_arm64_crypto_eor3_start_128:
#ifndef NO_AES_128
	cmp	w14, #32
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_128_start_4
L_aes_gcm_decrypt_arm64_crypto_eor3_128_start_8:
	ldr	q12, [x9]
	add	w24, w15, #1
	mov	v14.16b, v13.16b
	add	w23, w15, #2
	mov	v15.16b, v13.16b
	add	w22, w15, #3
	mov	v16.16b, v13.16b
	add	w21, w15, #4
	mov	v17.16b, v13.16b
	add	w20, w15, #5
	mov	v8.16b, v13.16b
	add	w19, w15, #6
	mov	v9.16b, v13.16b
	add	w17, w15, #7
	mov	v10.16b, v13.16b
	add	w15, w15, #8
	mov	v11.16b, v13.16b
	rev	w24, w24
	mov	v14.s[3], w24
	rev	w23, w23
	mov	v15.s[3], w23
	rev	w22, w22
	mov	v16.s[3], w22
	rev	w21, w21
	mov	v17.s[3], w21
	rev	w20, w20
	mov	v8.s[3], w20
	rev	w19, w19
	mov	v9.s[3], w19
	rev	w17, w17
	mov	v10.s[3], w17
	rev	w16, w15
	mov	v11.s[3], w16
	ldr	q13, [x9, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w14, w14, #8
	ldr	q12, [x9, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ld1	{v18.16b}, [x0], #16
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v19.16b}, [x0], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v20.16b}, [x0], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v21.16b}, [x0], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #160]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	ld1	{v0.16b}, [x0], #16
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	ld1	{v1.16b}, [x0], #16
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	ld1	{v2.16b}, [x0], #16
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	ld1	{v3.16b}, [x0], #16
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	eor	v8.16b, v8.16b, v0.16b
	eor	v9.16b, v9.16b, v1.16b
	eor	v10.16b, v10.16b, v2.16b
	eor	v11.16b, v11.16b, v3.16b
	ld1	{v13.2d}, [x12]
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x1], #0x40
	st1	{v8.16b, v9.16b, v10.16b, v11.16b}, [x1], #0x40
	cmp	w14, #8
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_128_end_8
L_aes_gcm_decrypt_arm64_crypto_eor3_128_both_8:
	ldr	q12, [x9]
	add	w24, w15, #1
	mov	v14.16b, v13.16b
	add	w23, w15, #2
	mov	v15.16b, v13.16b
	add	w22, w15, #3
	mov	v16.16b, v13.16b
	add	w21, w15, #4
	mov	v17.16b, v13.16b
	add	w20, w15, #5
	mov	v8.16b, v13.16b
	add	w19, w15, #6
	mov	v9.16b, v13.16b
	add	w17, w15, #7
	mov	v10.16b, v13.16b
	add	w15, w15, #8
	mov	v11.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w24, w24
	rbit	v19.16b, v19.16b
	mov	v14.s[3], w24
	rev	w23, w23
	rbit	v20.16b, v20.16b
	mov	v15.s[3], w23
	rev	w22, w22
	rbit	v21.16b, v21.16b
	mov	v16.s[3], w22
	rev	w21, w21
	rbit	v0.16b, v0.16b
	mov	v17.s[3], w21
	rev	w20, w20
	rbit	v1.16b, v1.16b
	mov	v8.s[3], w20
	rev	w19, w19
	rbit	v2.16b, v2.16b
	mov	v9.s[3], w19
	rev	w17, w17
	rbit	v3.16b, v3.16b
	mov	v10.s[3], w17
	rev	w16, w15
	eor	v18.16b, v18.16b, v26.16b
	mov	v11.s[3], w16
	ldr	q13, [x9, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ext	v31.16b, v3.16b, v3.16b, #8
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w14, w14, #8
	ldr	q12, [x9, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	mov	v28.d[1], v31.d[0]
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	eor	v26.16b, v28.16b, v30.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	# Done GHASH
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ld1	{v18.16b}, [x0], #16
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v19.16b}, [x0], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ld1	{v20.16b}, [x0], #16
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x9, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ld1	{v21.16b}, [x0], #16
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ld1	{v0.16b}, [x0], #16
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v1.16b}, [x0], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v2.16b}, [x0], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v3.16b}, [x0], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x9, #160]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	ld1	{v13.2d}, [x12]
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x1], #0x40
	eor	v8.16b, v8.16b, v0.16b
	eor	v9.16b, v9.16b, v1.16b
	eor	v10.16b, v10.16b, v2.16b
	eor	v11.16b, v11.16b, v3.16b
	st1	{v8.16b, v9.16b, v10.16b, v11.16b}, [x1], #0x40
	cmp	w14, #8
	bge	L_aes_gcm_decrypt_arm64_crypto_eor3_128_both_8
L_aes_gcm_decrypt_arm64_crypto_eor3_128_end_8:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	rbit	v0.16b, v0.16b
	rbit	v1.16b, v1.16b
	rbit	v2.16b, v2.16b
	rbit	v3.16b, v3.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	ext	v31.16b, v3.16b, v3.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_decrypt_arm64_crypto_eor3_128_start_4:
	ld1	{v0.2d, v1.2d, v2.2d, v3.2d}, [x9], #0x40
	ld1	{v4.2d, v5.2d, v6.2d, v7.2d}, [x9], #0x40
	ld1	{v8.2d, v9.2d}, [x9], #32
	ld1	{v10.2d}, [x9]
	cmp	w14, #1
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_128_done
	beq	L_aes_gcm_decrypt_arm64_crypto_eor3_128_start_1
	cmp	w14, #4
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_128_start_2
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w19, w15, #2
	mov	v15.16b, v13.16b
	add	w17, w15, #3
	mov	v16.16b, v13.16b
	add	w15, w15, #4
	mov	v17.16b, v13.16b
	rev	w20, w20
	mov	v14.s[3], w20
	rev	w19, w19
	mov	v15.s[3], w19
	rev	w17, w17
	mov	v16.s[3], w17
	rev	w16, w15
	mov	v17.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w14, w14, #4
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b}, [x0], #16
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	ld1	{v19.16b}, [x0], #16
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	ld1	{v20.16b}, [x0], #16
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	ld1	{v21.16b}, [x0], #16
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	aese	v15.16b, v9.16b
	eor	v15.16b, v15.16b, v10.16b
	aese	v16.16b, v9.16b
	eor	v16.16b, v16.16b, v10.16b
	aese	v17.16b, v9.16b
	eor	v17.16b, v17.16b, v10.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	cmp	w14, #4
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x1], #0x40
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_128_end_4
L_aes_gcm_decrypt_arm64_crypto_eor3_128_both_4:
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w19, w15, #2
	mov	v15.16b, v13.16b
	add	w17, w15, #3
	mov	v16.16b, v13.16b
	add	w15, w15, #4
	mov	v17.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w20, w20
	rbit	v19.16b, v19.16b
	mov	v14.s[3], w20
	rev	w19, w19
	rbit	v20.16b, v20.16b
	mov	v15.s[3], w19
	rev	w17, w17
	rbit	v21.16b, v21.16b
	mov	v16.s[3], w17
	rev	w16, w15
	mov	v17.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	eor	v18.16b, v18.16b, v26.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	ext	v31.16b, v21.16b, v21.16b, #8
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w14, w14, #4
	mov	v28.d[1], v31.d[0]
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v28.16b, v30.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	# Done GHASH
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x0], #0x40
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	aese	v15.16b, v9.16b
	eor	v15.16b, v15.16b, v10.16b
	aese	v16.16b, v9.16b
	eor	v16.16b, v16.16b, v10.16b
	aese	v17.16b, v9.16b
	eor	v17.16b, v17.16b, v10.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	cmp	w14, #4
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x1], #0x40
	bge	L_aes_gcm_decrypt_arm64_crypto_eor3_128_both_4
L_aes_gcm_decrypt_arm64_crypto_eor3_128_end_4:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cmp	w14, #1
	beq	L_aes_gcm_decrypt_arm64_crypto_eor3_128_start_1
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_128_done
L_aes_gcm_decrypt_arm64_crypto_eor3_128_start_2:
	add	w20, w15, #1
	mov	v14.16b, v13.16b
	add	w15, w15, #2
	mov	v15.16b, v13.16b
	rev	w20, w20
	mov	v14.s[3], w20
	rev	w16, w15
	mov	v15.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	subs	w14, w14, #2
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x0], #16
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	ld1	{v19.16b}, [x0], #16
	aese	v15.16b, v9.16b
	eor	v15.16b, v15.16b, v10.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	st1	{v14.16b, v15.16b}, [x1], #32
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v19.1d, v22.1d
	pmull2	v29.1q, v19.2d, v22.2d
	ext	v31.16b, v19.16b, v19.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v21.1d
	pmull2	v26.1q, v23.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cbz	w14, L_aes_gcm_decrypt_arm64_crypto_eor3_128_done
L_aes_gcm_decrypt_arm64_crypto_eor3_128_start_1:
	add	w15, w15, #1
	mov	v14.16b, v13.16b
	rev	w16, w15
	mov	v14.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	ld1	{v18.16b}, [x0], #16
	eor	v14.16b, v14.16b, v18.16b
	st1	{v14.16b}, [x1], #16
	rbit	v18.16b, v18.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_decrypt_arm64_crypto_eor3_128_done:
	ands	w14, w2, #15
	beq	L_aes_gcm_decrypt_arm64_crypto_eor3_128_partial_done
	eor	v15.16b, v15.16b, v15.16b
	mov	w19, w14
	st1	{v15.2d}, [x11]
	cmp	x19, #8
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_128_start_dw
	ldr	x17, [x0], #8
	sub	x19, x19, #8
	str	x17, [x11], #8
L_aes_gcm_decrypt_arm64_crypto_eor3_128_start_dw:
	cmp	x19, #4
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_128_start_sw
	ldr	w17, [x0], #4
	sub	x19, x19, #4
	str	w17, [x11], #4
L_aes_gcm_decrypt_arm64_crypto_eor3_128_start_sw:
	cmp	x19, #2
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_128_start_byte
	ldrh	w17, [x0], #2
	sub	x19, x19, #2
	strh	w17, [x11], #2
L_aes_gcm_decrypt_arm64_crypto_eor3_128_start_byte:
	cbz	x19, L_aes_gcm_decrypt_arm64_crypto_eor3_128_end_bytes
	ldrb	w17, [x0], #1
	subs	x19, x19, #1
	strb	w17, [x11], #1
	bne	L_aes_gcm_decrypt_arm64_crypto_eor3_128_start_byte
L_aes_gcm_decrypt_arm64_crypto_eor3_128_end_bytes:
	sub	x11, x11, x14
	ld1	{v15.2d}, [x11]
	add	w15, w15, #1
	mov	v14.16b, v13.16b
	rbit	v15.16b, v15.16b
	rev	w16, w15
	mov	v14.s[3], w16
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	eor	v16.16b, v26.16b, v15.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	#   X  = C * H^1
	pmull	v28.1q, v16.1d, v22.1d
	pmull2	v29.1q, v16.2d, v22.2d
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	ext	v31.16b, v16.16b, v16.16b, #8
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	rbit	v15.16b, v15.16b
	eor	v14.16b, v14.16b, v15.16b
	st1	{v14.2d}, [x11]
	cmp	w14, #8
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_128_out_start_dw
	ldr	x17, [x11], #8
	sub	w14, w14, #8
	str	x17, [x1], #8
L_aes_gcm_decrypt_arm64_crypto_eor3_128_out_start_dw:
	cmp	w14, #4
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_128_out_start_sw
	ldr	w17, [x11], #4
	sub	w14, w14, #4
	str	w17, [x1], #4
L_aes_gcm_decrypt_arm64_crypto_eor3_128_out_start_sw:
	cmp	w14, #2
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_128_out_start_byte
	ldrh	w17, [x11], #2
	sub	w14, w14, #2
	strh	w17, [x1], #2
L_aes_gcm_decrypt_arm64_crypto_eor3_128_out_start_byte:
	cbz	w14, L_aes_gcm_decrypt_arm64_crypto_eor3_128_out_end_bytes
	ldrb	w17, [x11], #1
	subs	w14, w14, #1
	strb	w17, [x1], #1
	bne	L_aes_gcm_decrypt_arm64_crypto_eor3_128_out_start_byte
L_aes_gcm_decrypt_arm64_crypto_eor3_128_out_end_bytes:
L_aes_gcm_decrypt_arm64_crypto_eor3_128_partial_done:
	ld1	{v14.2d}, [x12]
	lsl	x8, x8, #3
	rbit	x8, x8
	mov	v28.d[0], x8
	lsl	x2, x2, #3
	rbit	x2, x2
	mov	v28.d[1], x2
	eor	v26.16b, v26.16b, v28.16b
	pmull	v28.1q, v26.1d, v22.1d
	pmull2	v29.1q, v26.2d, v22.2d
	ext	v31.16b, v26.16b, v26.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	mov	v28.d[1], v31.d[0]
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v28.16b, v30.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	rbit	v26.16b, v26.16b
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	eor	v26.16b, v26.16b, v14.16b
	cmp	w6, #16
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_128_part_tag
	ld1	{v28.16b}, [x5]
	b	L_aes_gcm_decrypt_arm64_crypto_eor3_128_tag_loaded
L_aes_gcm_decrypt_arm64_crypto_eor3_128_part_tag:
	eor	v28.16b, v28.16b, v28.16b
	mov	x17, x6
	st1	{v28.2d}, [x11]
	cmp	x17, #8
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_128_tag_start_dw
	ldr	x16, [x5], #8
	sub	x17, x17, #8
	str	x16, [x11], #8
L_aes_gcm_decrypt_arm64_crypto_eor3_128_tag_start_dw:
	cmp	x17, #4
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_128_tag_start_sw
	ldr	w16, [x5], #4
	sub	x17, x17, #4
	str	w16, [x11], #4
L_aes_gcm_decrypt_arm64_crypto_eor3_128_tag_start_sw:
	cmp	x17, #2
	blt	L_aes_gcm_decrypt_arm64_crypto_eor3_128_tag_start_byte
	ldrh	w16, [x5], #2
	sub	x17, x17, #2
	strh	w16, [x11], #2
L_aes_gcm_decrypt_arm64_crypto_eor3_128_tag_start_byte:
	cbz	x17, L_aes_gcm_decrypt_arm64_crypto_eor3_128_tag_end_bytes
	ldrb	w16, [x5], #1
	subs	x17, x17, #1
	strb	w16, [x11], #1
	bne	L_aes_gcm_decrypt_arm64_crypto_eor3_128_tag_start_byte
L_aes_gcm_decrypt_arm64_crypto_eor3_128_tag_end_bytes:
	sub	x11, x11, x6
	ld1	{v28.2d}, [x11]
	mov	x17, #16
	st1	{v26.2d}, [x11]
	sub	x17, x17, x6
	add	x11, x11, x6
L_aes_gcm_decrypt_arm64_crypto_eor3_128_calc_tag_byte:
	strb	wzr, [x11], #1
	subs	x17, x17, #1
	bne	L_aes_gcm_decrypt_arm64_crypto_eor3_128_calc_tag_byte
	subs	x11, x11, #16
	ld1	{v26.2d}, [x11]
L_aes_gcm_decrypt_arm64_crypto_eor3_128_tag_loaded:
	eor	v28.16b, v28.16b, v26.16b
	mov	x16, v28.d[0]
	mov	x17, v28.d[1]
	mov	w19, #-180
	orr	x16, x16, x17
	cmp	x16, #0
	csetm	x0, ne
	and	x0, x0, x19
#endif /* !NO_AES_128 */
L_aes_gcm_decrypt_arm64_crypto_eor3_done:
	ldp	x17, x19, [x29, #24]
	ldp	x20, x21, [x29, #40]
	ldp	x22, x23, [x29, #56]
	ldr	x24, [x29, #72]
	ldp	d8, d9, [x29, #80]
	ldp	d10, d11, [x29, #96]
	ldp	d12, d13, [x29, #112]
	ldp	d14, d15, [x29, #128]
	ldp	x29, x30, [sp], #0x90
	ret
#ifndef __APPLE__
	.size	AES_GCM_decrypt_AARCH64_EOR3,.-AES_GCM_decrypt_AARCH64_EOR3
#endif /* __APPLE__ */
#endif /* HAVE_AES_DECRYPT */
#endif /* !WOLFSSL_ARMASM_CRYPTO_SHA3 */
#ifdef WOLFSSL_AESGCM_STREAM
#ifndef __APPLE__
.text
.globl	AES_GCM_init_AARCH64
.type	AES_GCM_init_AARCH64,@function
.align	2
AES_GCM_init_AARCH64:
#else
.section	__TEXT,__text
.globl	_AES_GCM_init_AARCH64
.p2align	2
_AES_GCM_init_AARCH64:
#endif /* __APPLE__ */
	stp	x29, x30, [sp, #-48]!
	add	x29, sp, #0
	stp	d8, d9, [x29, #16]
	stp	d10, d11, [x29, #32]
	movi	v6.16b, #0x87
	ld1	{v5.2d}, [x4]
	ushr	v6.2d, v6.2d, #56
	# Load Nonce
	cmp	w3, #12
	bne	L_aes_gcm_init_arm64_crypto_ghash_nonce
	ldr	x9, [x2]
	movi	v4.4s, #1, lsl 24
	ldr	w10, [x2, #8]
	mov	v4.d[0], x9
	mov	v4.s[2], w10
	mov	w8, #1
	b	L_aes_gcm_init_arm64_crypto_done_nonce
L_aes_gcm_init_arm64_crypto_ghash_nonce:
	eor	v4.16b, v4.16b, v4.16b
	lsr	w7, w3, #4
	cbz	w7, L_aes_gcm_init_arm64_crypto_done
L_aes_gcm_init_arm64_crypto_start_1:
	ld1	{v0.16b}, [x2], #16
	rbit	v0.16b, v0.16b
	eor	v3.16b, v4.16b, v0.16b
	#   X  = C * H^1
	pmull	v7.1q, v3.1d, v5.1d
	pmull2	v8.1q, v3.2d, v5.2d
	ext	v10.16b, v3.16b, v3.16b, #8
	pmull	v9.1q, v10.1d, v5.1d
	pmull2	v10.1q, v10.2d, v5.2d
	eor	v9.16b, v9.16b, v10.16b
	#   Reduce
	ext	v10.16b, v7.16b, v8.16b, #8
	pmull2	v8.1q, v8.2d, v6.2d
	eor	v10.16b, v10.16b, v8.16b
	eor	v10.16b, v10.16b, v9.16b
	pmull2	v9.1q, v10.2d, v6.2d
	mov	v7.d[1], v10.d[0]
	eor	v4.16b, v7.16b, v9.16b
	# Done GHASH
	subs	w7, w7, #1
	bne	L_aes_gcm_init_arm64_crypto_start_1
L_aes_gcm_init_arm64_crypto_done:
	and	w13, w3, #15
	cbz	x13, L_aes_gcm_init_arm64_crypto_partial_done
	eor	v7.16b, v7.16b, v7.16b
	mov	w12, w13
	st1	{v7.2d}, [x6]
	cmp	w12, #8
	blt	L_aes_gcm_init_arm64_crypto_start_dw
	ldr	x11, [x2], #8
	sub	w12, w12, #8
	str	x11, [x6], #8
L_aes_gcm_init_arm64_crypto_start_dw:
	cmp	w12, #4
	blt	L_aes_gcm_init_arm64_crypto_start_sw
	ldr	w11, [x2], #4
	sub	w12, w12, #4
	str	w11, [x6], #4
L_aes_gcm_init_arm64_crypto_start_sw:
	cmp	w12, #2
	blt	L_aes_gcm_init_arm64_crypto_start_byte
	ldrh	w11, [x2], #2
	sub	w12, w12, #2
	strh	w11, [x6], #2
L_aes_gcm_init_arm64_crypto_start_byte:
	cbz	w12, L_aes_gcm_init_arm64_crypto_end_bytes
	ldrb	w11, [x2], #1
	subs	w12, w12, #1
	strb	w11, [x6], #1
	bne	L_aes_gcm_init_arm64_crypto_start_byte
L_aes_gcm_init_arm64_crypto_end_bytes:
	sub	x6, x6, x13
	ld1	{v0.2d}, [x6]
	rbit	v0.16b, v0.16b
	eor	v3.16b, v4.16b, v0.16b
	#   X  = C * H^1
	pmull	v7.1q, v3.1d, v5.1d
	pmull2	v8.1q, v3.2d, v5.2d
	ext	v10.16b, v3.16b, v3.16b, #8
	pmull	v9.1q, v10.1d, v5.1d
	pmull2	v10.1q, v10.2d, v5.2d
	eor	v9.16b, v9.16b, v10.16b
	#   Reduce
	ext	v10.16b, v7.16b, v8.16b, #8
	pmull2	v8.1q, v8.2d, v6.2d
	eor	v10.16b, v10.16b, v8.16b
	eor	v10.16b, v10.16b, v9.16b
	pmull2	v9.1q, v10.2d, v6.2d
	mov	v7.d[1], v10.d[0]
	eor	v4.16b, v7.16b, v9.16b
	# Done GHASH
L_aes_gcm_init_arm64_crypto_partial_done:
	eor	x7, x7, x7
	lsl	x13, x3, #3
	mov	v7.d[0], x7
	mov	v7.d[1], x13
	rev64	v7.16b, v7.16b
	rbit	v7.16b, v7.16b
	eor	v4.16b, v4.16b, v7.16b
	pmull	v7.1q, v4.1d, v5.1d
	pmull2	v8.1q, v4.2d, v5.2d
	ext	v10.16b, v4.16b, v4.16b, #8
	pmull	v9.1q, v10.1d, v5.1d
	pmull2	v10.1q, v10.2d, v5.2d
	eor	v9.16b, v9.16b, v10.16b
	ext	v10.16b, v7.16b, v8.16b, #8
	pmull2	v8.1q, v8.2d, v6.2d
	eor	v10.16b, v10.16b, v8.16b
	eor	v10.16b, v10.16b, v9.16b
	pmull2	v9.1q, v10.2d, v6.2d
	mov	v7.d[1], v10.d[0]
	eor	v4.16b, v7.16b, v9.16b
	rbit	v4.16b, v4.16b
	mov	w8, v4.s[3]
	rev	w8, w8
L_aes_gcm_init_arm64_crypto_done_nonce:
	st1	{v4.2d}, [x5]
	ld1	{v7.2d, v8.2d, v9.2d, v10.2d}, [x0], #0x40
	aese	v4.16b, v7.16b
	aesmc	v4.16b, v4.16b
	aese	v4.16b, v8.16b
	aesmc	v4.16b, v4.16b
	aese	v4.16b, v9.16b
	aesmc	v4.16b, v4.16b
	aese	v4.16b, v10.16b
	aesmc	v4.16b, v4.16b
	ld1	{v7.2d, v8.2d, v9.2d, v10.2d}, [x0], #0x40
	aese	v4.16b, v7.16b
	aesmc	v4.16b, v4.16b
	aese	v4.16b, v8.16b
	aesmc	v4.16b, v4.16b
	aese	v4.16b, v9.16b
	aesmc	v4.16b, v4.16b
	aese	v4.16b, v10.16b
	aesmc	v4.16b, v4.16b
	subs	w1, w1, #10
	ld1	{v7.2d, v8.2d}, [x0], #32
	aese	v4.16b, v7.16b
	aesmc	v4.16b, v4.16b
	aese	v4.16b, v8.16b
	beq	L_aes_gcm_init_arm64_crypto_round_done
	ld1	{v7.2d, v8.2d}, [x0], #32
	subs	w1, w1, #2
	aesmc	v4.16b, v4.16b
	aese	v4.16b, v7.16b
	aesmc	v4.16b, v4.16b
	aese	v4.16b, v8.16b
	beq	L_aes_gcm_init_arm64_crypto_round_done
	ld1	{v7.2d, v8.2d}, [x0], #32
	aesmc	v4.16b, v4.16b
	aese	v4.16b, v7.16b
	aesmc	v4.16b, v4.16b
	aese	v4.16b, v8.16b
L_aes_gcm_init_arm64_crypto_round_done:
	ld1	{v7.2d}, [x0]
	eor	v4.16b, v4.16b, v7.16b
	st1	{v4.2d}, [x6]
	ldp	d8, d9, [x29, #16]
	ldp	d10, d11, [x29, #32]
	ldp	x29, x30, [sp], #48
	ret
#ifndef __APPLE__
	.size	AES_GCM_init_AARCH64,.-AES_GCM_init_AARCH64
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	AES_GCM_ghash_block_AARCH64
.type	AES_GCM_ghash_block_AARCH64,@function
.align	2
AES_GCM_ghash_block_AARCH64:
#else
.section	__TEXT,__text
.globl	_AES_GCM_ghash_block_AARCH64
.p2align	2
_AES_GCM_ghash_block_AARCH64:
#endif /* __APPLE__ */
	stp	x29, x30, [sp, #-32]!
	add	x29, sp, #0
	stp	d8, d9, [x29, #16]
	ld1	{v6.2d}, [x1]
	movi	v7.16b, #0x87
	ld1	{v5.2d}, [x2]
	ushr	v7.2d, v7.2d, #56
	ld1	{v4.2d}, [x0]
	rbit	v4.16b, v4.16b
	eor	v8.16b, v6.16b, v4.16b
	#   X  = C * H^1
	pmull	v0.1q, v8.1d, v5.1d
	pmull2	v1.1q, v8.2d, v5.2d
	ext	v3.16b, v8.16b, v8.16b, #8
	pmull	v2.1q, v3.1d, v5.1d
	pmull2	v3.1q, v3.2d, v5.2d
	eor	v2.16b, v2.16b, v3.16b
	#   Reduce
	ext	v3.16b, v0.16b, v1.16b, #8
	pmull2	v1.1q, v1.2d, v7.2d
	eor	v3.16b, v3.16b, v1.16b
	eor	v3.16b, v3.16b, v2.16b
	pmull2	v2.1q, v3.2d, v7.2d
	mov	v0.d[1], v3.d[0]
	eor	v6.16b, v0.16b, v2.16b
	# Done GHASH
	st1	{v6.2d}, [x1]
	ldp	d8, d9, [x29, #16]
	ldp	x29, x30, [sp], #32
	ret
#ifndef __APPLE__
	.size	AES_GCM_ghash_block_AARCH64,.-AES_GCM_ghash_block_AARCH64
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	AES_GCM_aad_update_AARCH64
.type	AES_GCM_aad_update_AARCH64,@function
.align	2
AES_GCM_aad_update_AARCH64:
#else
.section	__TEXT,__text
.globl	_AES_GCM_aad_update_AARCH64
.p2align	2
_AES_GCM_aad_update_AARCH64:
#endif /* __APPLE__ */
	stp	x29, x30, [sp, #-80]!
	add	x29, sp, #0
	stp	d8, d9, [x29, #16]
	stp	d10, d11, [x29, #32]
	stp	d12, d13, [x29, #48]
	stp	d14, d15, [x29, #64]
	ld1	{v20.2d}, [x2]
	movi	v21.16b, #0x87
	ld1	{v12.2d}, [x3]
	ushr	v21.2d, v21.2d, #56
	cmp	x1, #0x40
	blt	L_aes_gcm_aad_update_arm64_crypto_h_done
	# Square H => H^2
	pmull2	v11.1q, v12.2d, v12.2d
	pmull	v10.1q, v12.1d, v12.1d
	pmull2	v8.1q, v11.2d, v21.2d
	ext	v9.16b, v10.16b, v11.16b, #8
	eor	v9.16b, v9.16b, v8.16b
	pmull2	v11.1q, v9.2d, v21.2d
	mov	v10.d[1], v9.d[0]
	eor	v13.16b, v10.16b, v11.16b
	cmp	x1, #0x100
	blt	L_aes_gcm_aad_update_arm64_crypto_h_done
	# Multiply H and H^2  => H^3
	pmull	v8.1q, v12.1d, v13.1d
	pmull2	v9.1q, v12.2d, v13.2d
	ext	v11.16b, v12.16b, v12.16b, #8
	pmull	v10.1q, v11.1d, v13.1d
	pmull2	v11.1q, v11.2d, v13.2d
	eor	v10.16b, v10.16b, v11.16b
	#   Reduce
	ext	v11.16b, v8.16b, v9.16b, #8
	pmull2	v9.1q, v9.2d, v21.2d
	eor	v11.16b, v11.16b, v9.16b
	eor	v11.16b, v11.16b, v10.16b
	pmull2	v10.1q, v11.2d, v21.2d
	mov	v8.d[1], v11.d[0]
	eor	v14.16b, v8.16b, v10.16b
	# Square H^2 => H^4
	pmull2	v11.1q, v13.2d, v13.2d
	pmull	v10.1q, v13.1d, v13.1d
	pmull2	v8.1q, v11.2d, v21.2d
	ext	v9.16b, v10.16b, v11.16b, #8
	eor	v9.16b, v9.16b, v8.16b
	pmull2	v11.1q, v9.2d, v21.2d
	mov	v10.d[1], v9.d[0]
	eor	v15.16b, v10.16b, v11.16b
	# Done
	cmp	x1, #0x400
	blt	L_aes_gcm_aad_update_arm64_crypto_h_done
	# Multiply H and H^4  => H^5
	pmull	v8.1q, v12.1d, v15.1d
	pmull2	v9.1q, v12.2d, v15.2d
	ext	v11.16b, v12.16b, v12.16b, #8
	pmull	v10.1q, v11.1d, v15.1d
	pmull2	v11.1q, v11.2d, v15.2d
	eor	v10.16b, v10.16b, v11.16b
	#   Reduce
	ext	v11.16b, v8.16b, v9.16b, #8
	pmull2	v9.1q, v9.2d, v21.2d
	eor	v11.16b, v11.16b, v9.16b
	eor	v11.16b, v11.16b, v10.16b
	pmull2	v10.1q, v11.2d, v21.2d
	mov	v8.d[1], v11.d[0]
	eor	v16.16b, v8.16b, v10.16b
	# Square H^3 => H^6
	pmull2	v11.1q, v14.2d, v14.2d
	pmull	v10.1q, v14.1d, v14.1d
	pmull2	v8.1q, v11.2d, v21.2d
	ext	v9.16b, v10.16b, v11.16b, #8
	eor	v9.16b, v9.16b, v8.16b
	pmull2	v11.1q, v9.2d, v21.2d
	mov	v10.d[1], v9.d[0]
	eor	v17.16b, v10.16b, v11.16b
	# Multiply H and H^6  => H^7
	pmull	v8.1q, v12.1d, v17.1d
	pmull2	v9.1q, v12.2d, v17.2d
	ext	v11.16b, v12.16b, v12.16b, #8
	pmull	v10.1q, v11.1d, v17.1d
	pmull2	v11.1q, v11.2d, v17.2d
	eor	v10.16b, v10.16b, v11.16b
	#   Reduce
	ext	v11.16b, v8.16b, v9.16b, #8
	pmull2	v9.1q, v9.2d, v21.2d
	eor	v11.16b, v11.16b, v9.16b
	eor	v11.16b, v11.16b, v10.16b
	pmull2	v10.1q, v11.2d, v21.2d
	mov	v8.d[1], v11.d[0]
	eor	v18.16b, v8.16b, v10.16b
	# Square H^4 => H^8
	pmull2	v11.1q, v15.2d, v15.2d
	pmull	v10.1q, v15.1d, v15.1d
	pmull2	v8.1q, v11.2d, v21.2d
	ext	v9.16b, v10.16b, v11.16b, #8
	eor	v9.16b, v9.16b, v8.16b
	pmull2	v11.1q, v9.2d, v21.2d
	mov	v10.d[1], v9.d[0]
	eor	v19.16b, v10.16b, v11.16b
	# Done
L_aes_gcm_aad_update_arm64_crypto_h_done:
	lsr	x1, x1, #4
	cmp	x1, #4
	blt	L_aes_gcm_aad_update_arm64_crypto_start_1
	cmp	x1, #16
	blt	L_aes_gcm_aad_update_arm64_crypto_start_2
	cmp	x1, #0x40
	blt	L_aes_gcm_aad_update_arm64_crypto_start_4
L_aes_gcm_aad_update_arm64_crypto_start_8:
	ld1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x0], #0x40
	ld1	{v4.16b, v5.16b, v6.16b, v7.16b}, [x0], #0x40
	rbit	v0.16b, v0.16b
	rbit	v1.16b, v1.16b
	rbit	v2.16b, v2.16b
	rbit	v3.16b, v3.16b
	rbit	v4.16b, v4.16b
	rbit	v5.16b, v5.16b
	rbit	v6.16b, v6.16b
	rbit	v7.16b, v7.16b
	eor	v0.16b, v0.16b, v20.16b
	#   X  = C * H^1
	pmull	v8.1q, v7.1d, v12.1d
	pmull2	v9.1q, v7.2d, v12.2d
	ext	v11.16b, v7.16b, v7.16b, #8
	pmull	v10.1q, v11.1d, v12.1d
	pmull2	v11.1q, v11.2d, v12.2d
	eor	v10.16b, v10.16b, v11.16b
	#   X += C * H^2
	pmull	v11.1q, v13.1d, v6.1d
	pmull2	v20.1q, v13.2d, v6.2d
	eor	v8.16b, v8.16b, v11.16b
	eor	v9.16b, v9.16b, v20.16b
	ext	v20.16b, v6.16b, v6.16b, #8
	pmull	v11.1q, v20.1d, v13.1d
	pmull2	v20.1q, v20.2d, v13.2d
	eor	v20.16b, v20.16b, v11.16b
	eor	v10.16b, v10.16b, v20.16b
	#   X += C * H^3
	pmull	v11.1q, v14.1d, v5.1d
	pmull2	v20.1q, v14.2d, v5.2d
	eor	v8.16b, v8.16b, v11.16b
	eor	v9.16b, v9.16b, v20.16b
	ext	v20.16b, v5.16b, v5.16b, #8
	pmull	v11.1q, v20.1d, v14.1d
	pmull2	v20.1q, v20.2d, v14.2d
	eor	v20.16b, v20.16b, v11.16b
	eor	v10.16b, v10.16b, v20.16b
	#   X += C * H^4
	pmull	v11.1q, v15.1d, v4.1d
	pmull2	v20.1q, v15.2d, v4.2d
	eor	v8.16b, v8.16b, v11.16b
	eor	v9.16b, v9.16b, v20.16b
	ext	v20.16b, v4.16b, v4.16b, #8
	pmull	v11.1q, v20.1d, v15.1d
	pmull2	v20.1q, v20.2d, v15.2d
	eor	v20.16b, v20.16b, v11.16b
	eor	v10.16b, v10.16b, v20.16b
	#   X += C * H^5
	pmull	v11.1q, v16.1d, v3.1d
	pmull2	v20.1q, v16.2d, v3.2d
	eor	v8.16b, v8.16b, v11.16b
	eor	v9.16b, v9.16b, v20.16b
	ext	v20.16b, v3.16b, v3.16b, #8
	pmull	v11.1q, v20.1d, v16.1d
	pmull2	v20.1q, v20.2d, v16.2d
	eor	v20.16b, v20.16b, v11.16b
	eor	v10.16b, v10.16b, v20.16b
	#   X += C * H^6
	pmull	v11.1q, v17.1d, v2.1d
	pmull2	v20.1q, v17.2d, v2.2d
	eor	v8.16b, v8.16b, v11.16b
	eor	v9.16b, v9.16b, v20.16b
	ext	v20.16b, v2.16b, v2.16b, #8
	pmull	v11.1q, v20.1d, v17.1d
	pmull2	v20.1q, v20.2d, v17.2d
	eor	v20.16b, v20.16b, v11.16b
	eor	v10.16b, v10.16b, v20.16b
	#   X += C * H^7
	pmull	v11.1q, v18.1d, v1.1d
	pmull2	v20.1q, v18.2d, v1.2d
	eor	v8.16b, v8.16b, v11.16b
	eor	v9.16b, v9.16b, v20.16b
	ext	v20.16b, v1.16b, v1.16b, #8
	pmull	v11.1q, v20.1d, v18.1d
	pmull2	v20.1q, v20.2d, v18.2d
	eor	v20.16b, v20.16b, v11.16b
	eor	v10.16b, v10.16b, v20.16b
	#   X += C * H^8
	pmull	v11.1q, v19.1d, v0.1d
	pmull2	v20.1q, v19.2d, v0.2d
	eor	v8.16b, v8.16b, v11.16b
	eor	v9.16b, v9.16b, v20.16b
	ext	v20.16b, v0.16b, v0.16b, #8
	pmull	v11.1q, v20.1d, v19.1d
	pmull2	v20.1q, v20.2d, v19.2d
	eor	v20.16b, v20.16b, v11.16b
	eor	v10.16b, v10.16b, v20.16b
	#   Reduce
	ext	v11.16b, v8.16b, v9.16b, #8
	pmull2	v9.1q, v9.2d, v21.2d
	eor	v11.16b, v11.16b, v9.16b
	eor	v11.16b, v11.16b, v10.16b
	pmull2	v10.1q, v11.2d, v21.2d
	mov	v8.d[1], v11.d[0]
	eor	v20.16b, v8.16b, v10.16b
	# Done GHASH
	sub	x1, x1, #8
	cmp	x1, #8
	bge	L_aes_gcm_aad_update_arm64_crypto_start_8
	cmp	x1, #1
	blt	L_aes_gcm_aad_update_arm64_crypto_done
	beq	L_aes_gcm_aad_update_arm64_crypto_start_1
	cmp	x1, #16
	blt	L_aes_gcm_aad_update_arm64_crypto_start_2
L_aes_gcm_aad_update_arm64_crypto_start_4:
	ld1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x0], #0x40
	rbit	v0.16b, v0.16b
	rbit	v1.16b, v1.16b
	rbit	v2.16b, v2.16b
	rbit	v3.16b, v3.16b
	eor	v0.16b, v0.16b, v20.16b
	#   X  = C * H^1
	pmull	v8.1q, v3.1d, v12.1d
	pmull2	v9.1q, v3.2d, v12.2d
	ext	v11.16b, v3.16b, v3.16b, #8
	pmull	v10.1q, v11.1d, v12.1d
	pmull2	v11.1q, v11.2d, v12.2d
	eor	v10.16b, v10.16b, v11.16b
	#   X += C * H^2
	pmull	v11.1q, v13.1d, v2.1d
	pmull2	v20.1q, v13.2d, v2.2d
	eor	v8.16b, v8.16b, v11.16b
	eor	v9.16b, v9.16b, v20.16b
	ext	v20.16b, v2.16b, v2.16b, #8
	pmull	v11.1q, v20.1d, v13.1d
	pmull2	v20.1q, v20.2d, v13.2d
	eor	v20.16b, v20.16b, v11.16b
	eor	v10.16b, v10.16b, v20.16b
	#   X += C * H^3
	pmull	v11.1q, v14.1d, v1.1d
	pmull2	v20.1q, v14.2d, v1.2d
	eor	v8.16b, v8.16b, v11.16b
	eor	v9.16b, v9.16b, v20.16b
	ext	v20.16b, v1.16b, v1.16b, #8
	pmull	v11.1q, v20.1d, v14.1d
	pmull2	v20.1q, v20.2d, v14.2d
	eor	v20.16b, v20.16b, v11.16b
	eor	v10.16b, v10.16b, v20.16b
	#   X += C * H^4
	pmull	v11.1q, v15.1d, v0.1d
	pmull2	v20.1q, v15.2d, v0.2d
	eor	v8.16b, v8.16b, v11.16b
	eor	v9.16b, v9.16b, v20.16b
	ext	v20.16b, v0.16b, v0.16b, #8
	pmull	v11.1q, v20.1d, v15.1d
	pmull2	v20.1q, v20.2d, v15.2d
	eor	v20.16b, v20.16b, v11.16b
	eor	v10.16b, v10.16b, v20.16b
	#   Reduce
	ext	v11.16b, v8.16b, v9.16b, #8
	pmull2	v9.1q, v9.2d, v21.2d
	eor	v11.16b, v11.16b, v9.16b
	eor	v11.16b, v11.16b, v10.16b
	pmull2	v10.1q, v11.2d, v21.2d
	mov	v8.d[1], v11.d[0]
	eor	v20.16b, v8.16b, v10.16b
	# Done GHASH
	sub	x1, x1, #4
	cmp	x1, #4
	bge	L_aes_gcm_aad_update_arm64_crypto_start_4
	cmp	x1, #1
	blt	L_aes_gcm_aad_update_arm64_crypto_done
	beq	L_aes_gcm_aad_update_arm64_crypto_start_1
L_aes_gcm_aad_update_arm64_crypto_start_2:
	ld1	{v0.16b, v1.16b}, [x0], #32
	rbit	v0.16b, v0.16b
	rbit	v1.16b, v1.16b
	eor	v3.16b, v20.16b, v0.16b
	#   X  = C * H^1
	pmull	v8.1q, v1.1d, v12.1d
	pmull2	v9.1q, v1.2d, v12.2d
	ext	v11.16b, v1.16b, v1.16b, #8
	pmull	v10.1q, v11.1d, v12.1d
	pmull2	v11.1q, v11.2d, v12.2d
	eor	v10.16b, v10.16b, v11.16b
	#   X += C * H^2
	pmull	v11.1q, v13.1d, v3.1d
	pmull2	v20.1q, v13.2d, v3.2d
	eor	v8.16b, v8.16b, v11.16b
	eor	v9.16b, v9.16b, v20.16b
	ext	v20.16b, v3.16b, v3.16b, #8
	pmull	v11.1q, v20.1d, v13.1d
	pmull2	v20.1q, v20.2d, v13.2d
	eor	v20.16b, v20.16b, v11.16b
	eor	v10.16b, v10.16b, v20.16b
	#   Reduce
	ext	v11.16b, v8.16b, v9.16b, #8
	pmull2	v9.1q, v9.2d, v21.2d
	eor	v11.16b, v11.16b, v9.16b
	eor	v11.16b, v11.16b, v10.16b
	pmull2	v10.1q, v11.2d, v21.2d
	mov	v8.d[1], v11.d[0]
	eor	v20.16b, v8.16b, v10.16b
	# Done GHASH
	sub	x1, x1, #2
	cmp	x1, #1
	bgt	L_aes_gcm_aad_update_arm64_crypto_start_2
	blt	L_aes_gcm_aad_update_arm64_crypto_done
L_aes_gcm_aad_update_arm64_crypto_start_1:
	cbz	x1, L_aes_gcm_aad_update_arm64_crypto_done
L_aes_gcm_aad_update_arm64_crypto_both_1:
	ld1	{v0.16b}, [x0], #16
	rbit	v0.16b, v0.16b
	eor	v3.16b, v20.16b, v0.16b
	#   X  = C * H^1
	pmull	v8.1q, v3.1d, v12.1d
	pmull2	v9.1q, v3.2d, v12.2d
	ext	v11.16b, v3.16b, v3.16b, #8
	pmull	v10.1q, v11.1d, v12.1d
	pmull2	v11.1q, v11.2d, v12.2d
	eor	v10.16b, v10.16b, v11.16b
	#   Reduce
	ext	v11.16b, v8.16b, v9.16b, #8
	pmull2	v9.1q, v9.2d, v21.2d
	eor	v11.16b, v11.16b, v9.16b
	eor	v11.16b, v11.16b, v10.16b
	pmull2	v10.1q, v11.2d, v21.2d
	mov	v8.d[1], v11.d[0]
	eor	v20.16b, v8.16b, v10.16b
	# Done GHASH
	subs	x1, x1, #1
	bne	L_aes_gcm_aad_update_arm64_crypto_both_1
L_aes_gcm_aad_update_arm64_crypto_done:
	st1	{v20.2d}, [x2]
	ldp	d8, d9, [x29, #16]
	ldp	d10, d11, [x29, #32]
	ldp	d12, d13, [x29, #48]
	ldp	d14, d15, [x29, #64]
	ldp	x29, x30, [sp], #0x50
	ret
#ifndef __APPLE__
	.size	AES_GCM_aad_update_AARCH64,.-AES_GCM_aad_update_AARCH64
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	AES_GCM_encrypt_block_AARCH64
.type	AES_GCM_encrypt_block_AARCH64,@function
.align	2
AES_GCM_encrypt_block_AARCH64:
#else
.section	__TEXT,__text
.globl	_AES_GCM_encrypt_block_AARCH64
.p2align	2
_AES_GCM_encrypt_block_AARCH64:
#endif /* __APPLE__ */
	ld1	{v5.2d}, [x4]
	ld1	{v4.2d}, [x3]
	mov	w5, v5.s[3]
	rev	w5, w5
	add	w5, w5, #1
	rev	w5, w5
	mov	v5.s[3], w5
	st1	{v5.2d}, [x4]
	ld1	{v0.2d, v1.2d, v2.2d, v3.2d}, [x0], #0x40
	aese	v5.16b, v0.16b
	aesmc	v5.16b, v5.16b
	aese	v5.16b, v1.16b
	aesmc	v5.16b, v5.16b
	aese	v5.16b, v2.16b
	aesmc	v5.16b, v5.16b
	aese	v5.16b, v3.16b
	aesmc	v5.16b, v5.16b
	ld1	{v0.2d, v1.2d, v2.2d, v3.2d}, [x0], #0x40
	aese	v5.16b, v0.16b
	aesmc	v5.16b, v5.16b
	aese	v5.16b, v1.16b
	aesmc	v5.16b, v5.16b
	aese	v5.16b, v2.16b
	aesmc	v5.16b, v5.16b
	aese	v5.16b, v3.16b
	aesmc	v5.16b, v5.16b
	subs	w1, w1, #10
	ld1	{v0.2d, v1.2d}, [x0], #32
	aese	v5.16b, v0.16b
	aesmc	v5.16b, v5.16b
	aese	v5.16b, v1.16b
	beq	L_aes_gcm_encrypt_block_arm64_crypto_round_done
	ld1	{v0.2d, v1.2d}, [x0], #32
	subs	w1, w1, #2
	aesmc	v5.16b, v5.16b
	aese	v5.16b, v0.16b
	aesmc	v5.16b, v5.16b
	aese	v5.16b, v1.16b
	beq	L_aes_gcm_encrypt_block_arm64_crypto_round_done
	ld1	{v0.2d, v1.2d}, [x0], #32
	aesmc	v5.16b, v5.16b
	aese	v5.16b, v0.16b
	aesmc	v5.16b, v5.16b
	aese	v5.16b, v1.16b
L_aes_gcm_encrypt_block_arm64_crypto_round_done:
	ld1	{v0.2d}, [x0]
	eor	v5.16b, v5.16b, v0.16b
	eor	v4.16b, v4.16b, v5.16b
	st1	{v4.2d}, [x2]
	ret
#ifndef __APPLE__
	.size	AES_GCM_encrypt_block_AARCH64,.-AES_GCM_encrypt_block_AARCH64
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	AES_GCM_encrypt_update_AARCH64
.type	AES_GCM_encrypt_update_AARCH64,@function
.align	2
AES_GCM_encrypt_update_AARCH64:
#else
.section	__TEXT,__text
.globl	_AES_GCM_encrypt_update_AARCH64
.p2align	2
_AES_GCM_encrypt_update_AARCH64:
#endif /* __APPLE__ */
	stp	x29, x30, [sp, #-96]!
	add	x29, sp, #0
	str	x17, [x29, #24]
	stp	d8, d9, [x29, #32]
	stp	d10, d11, [x29, #48]
	stp	d12, d13, [x29, #64]
	stp	d14, d15, [x29, #80]
	ld1	{v13.2d}, [x7]
	movi	v27.16b, #0x87
	ld1	{v26.2d}, [x5]
	ushr	v27.2d, v27.2d, #56
	ld1	{v22.2d}, [x6]
	mov	w9, v13.s[3]
	rev	w9, w9
	cmp	w4, #32
	blt	L_aes_gcm_encrypt_update_arm64_crypto_h_done
	# Square H => H^2
	pmull2	v31.1q, v22.2d, v22.2d
	pmull	v30.1q, v22.1d, v22.1d
	pmull2	v28.1q, v31.2d, v27.2d
	ext	v29.16b, v30.16b, v31.16b, #8
	eor	v29.16b, v29.16b, v28.16b
	pmull2	v31.1q, v29.2d, v27.2d
	mov	v30.d[1], v29.d[0]
	eor	v23.16b, v30.16b, v31.16b
	cmp	w4, #0x40
	blt	L_aes_gcm_encrypt_update_arm64_crypto_h_done
	# Multiply H and H^2  => H^3
	pmull	v28.1q, v22.1d, v23.1d
	pmull2	v29.1q, v22.2d, v23.2d
	ext	v31.16b, v22.16b, v22.16b, #8
	pmull	v30.1q, v31.1d, v23.1d
	pmull2	v31.1q, v31.2d, v23.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v24.16b, v28.16b, v30.16b
	# Square H^2 => H^4
	pmull2	v31.1q, v23.2d, v23.2d
	pmull	v30.1q, v23.1d, v23.1d
	pmull2	v28.1q, v31.2d, v27.2d
	ext	v29.16b, v30.16b, v31.16b, #8
	eor	v29.16b, v29.16b, v28.16b
	pmull2	v31.1q, v29.2d, v27.2d
	mov	v30.d[1], v29.d[0]
	eor	v25.16b, v30.16b, v31.16b
	# Done
	cmp	w4, #0x200
	blt	L_aes_gcm_encrypt_update_arm64_crypto_h_done
	# Multiply H and H^4  => H^5
	pmull	v28.1q, v22.1d, v25.1d
	pmull2	v29.1q, v22.2d, v25.2d
	ext	v31.16b, v22.16b, v22.16b, #8
	pmull	v30.1q, v31.1d, v25.1d
	pmull2	v31.1q, v31.2d, v25.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v4.16b, v28.16b, v30.16b
	# Square H^3 => H^6
	pmull2	v31.1q, v24.2d, v24.2d
	pmull	v30.1q, v24.1d, v24.1d
	pmull2	v28.1q, v31.2d, v27.2d
	ext	v29.16b, v30.16b, v31.16b, #8
	eor	v29.16b, v29.16b, v28.16b
	pmull2	v31.1q, v29.2d, v27.2d
	mov	v30.d[1], v29.d[0]
	eor	v5.16b, v30.16b, v31.16b
	# Multiply H and H^6  => H^7
	pmull	v28.1q, v22.1d, v5.1d
	pmull2	v29.1q, v22.2d, v5.2d
	ext	v31.16b, v22.16b, v22.16b, #8
	pmull	v30.1q, v31.1d, v5.1d
	pmull2	v31.1q, v31.2d, v5.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v6.16b, v28.16b, v30.16b
	# Square H^4 => H^8
	pmull2	v31.1q, v25.2d, v25.2d
	pmull	v30.1q, v25.1d, v25.1d
	pmull2	v28.1q, v31.2d, v27.2d
	ext	v29.16b, v30.16b, v31.16b, #8
	eor	v29.16b, v29.16b, v28.16b
	pmull2	v31.1q, v29.2d, v27.2d
	mov	v30.d[1], v29.d[0]
	eor	v7.16b, v30.16b, v31.16b
	# Done
L_aes_gcm_encrypt_update_arm64_crypto_h_done:
	lsr	w8, w4, #4
	cmp	x1, #12
	blt	L_aes_gcm_encrypt_update_arm64_crypto_start_128
	bgt	L_aes_gcm_encrypt_update_arm64_crypto_start_256
	# AES_GCM_192
#ifndef NO_AES_192
	cmp	w8, #32
	blt	L_aes_gcm_encrypt_update_arm64_crypto_192_start_4
L_aes_gcm_encrypt_update_arm64_crypto_192_start_8:
	ldr	q12, [x0]
	add	w17, w9, #1
	mov	v14.16b, v13.16b
	add	w16, w9, #2
	mov	v15.16b, v13.16b
	add	w15, w9, #3
	mov	v16.16b, v13.16b
	add	w14, w9, #4
	mov	v17.16b, v13.16b
	add	w13, w9, #5
	mov	v8.16b, v13.16b
	add	w12, w9, #6
	mov	v9.16b, v13.16b
	add	w11, w9, #7
	mov	v10.16b, v13.16b
	add	w9, w9, #8
	mov	v11.16b, v13.16b
	rev	w17, w17
	rev	w16, w16
	rev	w15, w15
	rev	w14, w14
	rev	w13, w13
	rev	w12, w12
	rev	w11, w11
	rev	w10, w9
	mov	v14.s[3], w17
	mov	v15.s[3], w16
	mov	v16.s[3], w15
	mov	v17.s[3], w14
	mov	v8.s[3], w13
	mov	v9.s[3], w12
	mov	v10.s[3], w11
	mov	v11.s[3], w10
	ldr	q13, [x0, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w8, w8, #8
	ldr	q12, [x0, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b}, [x3], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v19.16b}, [x3], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v20.16b}, [x3], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ld1	{v21.16b}, [x3], #16
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #160]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	ld1	{v0.16b}, [x3], #16
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ld1	{v1.16b}, [x3], #16
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v2.16b}, [x3], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ld1	{v3.16b}, [x3], #16
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #176]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #192]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	eor	v0.16b, v0.16b, v8.16b
	eor	v1.16b, v1.16b, v9.16b
	eor	v2.16b, v2.16b, v10.16b
	eor	v3.16b, v3.16b, v11.16b
	ld1	{v13.2d}, [x7]
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x2], #0x40
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x2], #0x40
	cmp	w8, #8
	blt	L_aes_gcm_encrypt_update_arm64_crypto_192_end_8
L_aes_gcm_encrypt_update_arm64_crypto_192_both_8:
	ldr	q12, [x0]
	add	w17, w9, #1
	mov	v14.16b, v13.16b
	add	w16, w9, #2
	mov	v15.16b, v13.16b
	add	w15, w9, #3
	mov	v16.16b, v13.16b
	add	w14, w9, #4
	mov	v17.16b, v13.16b
	add	w13, w9, #5
	mov	v8.16b, v13.16b
	add	w12, w9, #6
	mov	v9.16b, v13.16b
	add	w11, w9, #7
	mov	v10.16b, v13.16b
	add	w9, w9, #8
	mov	v11.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w17, w17
	rbit	v19.16b, v19.16b
	rev	w16, w16
	rbit	v20.16b, v20.16b
	rev	w15, w15
	rbit	v21.16b, v21.16b
	rev	w14, w14
	rbit	v0.16b, v0.16b
	rev	w13, w13
	rbit	v1.16b, v1.16b
	rev	w12, w12
	rbit	v2.16b, v2.16b
	rev	w11, w11
	rbit	v3.16b, v3.16b
	rev	w10, w9
	mov	v14.s[3], w17
	mov	v15.s[3], w16
	mov	v16.s[3], w15
	mov	v17.s[3], w14
	mov	v8.s[3], w13
	mov	v9.s[3], w12
	mov	v10.s[3], w11
	mov	v11.s[3], w10
	ldr	q13, [x0, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v18.16b, v18.16b, v26.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ext	v31.16b, v3.16b, v3.16b, #8
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w8, w8, #8
	ldr	q12, [x0, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v29.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	mov	v28.d[1], v31.d[0]
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v18.16b}, [x3], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ld1	{v19.16b}, [x3], #16
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ld1	{v20.16b}, [x3], #16
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ld1	{v21.16b}, [x3], #16
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v0.16b}, [x3], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v1.16b}, [x3], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v2.16b}, [x3], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ld1	{v3.16b}, [x3], #16
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #160]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #176]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #192]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	ld1	{v13.2d}, [x7]
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x2], #0x40
	eor	v0.16b, v0.16b, v8.16b
	eor	v1.16b, v1.16b, v9.16b
	eor	v2.16b, v2.16b, v10.16b
	eor	v3.16b, v3.16b, v11.16b
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x2], #0x40
	cmp	w8, #8
	bge	L_aes_gcm_encrypt_update_arm64_crypto_192_both_8
L_aes_gcm_encrypt_update_arm64_crypto_192_end_8:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	rbit	v0.16b, v0.16b
	rbit	v1.16b, v1.16b
	rbit	v2.16b, v2.16b
	rbit	v3.16b, v3.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	ext	v31.16b, v3.16b, v3.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_encrypt_update_arm64_crypto_192_start_4:
	ld1	{v0.2d, v1.2d, v2.2d, v3.2d}, [x0], #0x40
	ld1	{v4.2d, v5.2d, v6.2d, v7.2d}, [x0], #0x40
	ld1	{v8.2d, v9.2d, v10.2d, v11.2d}, [x0], #0x40
	ld1	{v12.2d}, [x0]
	cmp	w8, #1
	blt	L_aes_gcm_encrypt_update_arm64_crypto_192_done
	beq	L_aes_gcm_encrypt_update_arm64_crypto_192_start_1
	cmp	w8, #4
	blt	L_aes_gcm_encrypt_update_arm64_crypto_192_start_2
	add	w13, w9, #1
	mov	v14.16b, v13.16b
	add	w12, w9, #2
	mov	v15.16b, v13.16b
	add	w11, w9, #3
	mov	v16.16b, v13.16b
	add	w9, w9, #4
	mov	v17.16b, v13.16b
	rev	w13, w13
	rev	w12, w12
	rev	w11, w11
	rev	w10, w9
	mov	v14.s[3], w13
	mov	v15.s[3], w12
	mov	v16.s[3], w11
	mov	v17.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w8, w8, #4
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x3], #16
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	ld1	{v19.16b}, [x3], #16
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	ld1	{v20.16b}, [x3], #16
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	ld1	{v21.16b}, [x3], #16
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v11.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v11.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v11.16b
	eor	v17.16b, v17.16b, v12.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	cmp	w8, #4
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x2], #0x40
	blt	L_aes_gcm_encrypt_update_arm64_crypto_192_end_4
L_aes_gcm_encrypt_update_arm64_crypto_192_both_4:
	add	w13, w9, #1
	mov	v14.16b, v13.16b
	add	w12, w9, #2
	mov	v15.16b, v13.16b
	add	w11, w9, #3
	mov	v16.16b, v13.16b
	add	w9, w9, #4
	mov	v17.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w13, w13
	rev	w12, w12
	rev	w11, w11
	rbit	v19.16b, v19.16b
	rev	w10, w9
	mov	v14.s[3], w13
	mov	v15.s[3], w12
	mov	v16.s[3], w11
	mov	v17.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	rbit	v20.16b, v20.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	rbit	v21.16b, v21.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	eor	v18.16b, v18.16b, v26.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	ext	v31.16b, v21.16b, v21.16b, #8
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w8, w8, #4
	eor	v31.16b, v31.16b, v29.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	mov	v28.d[1], v31.d[0]
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x3], #0x40
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v11.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v11.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v11.16b
	eor	v17.16b, v17.16b, v12.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	cmp	w8, #4
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x2], #0x40
	bge	L_aes_gcm_encrypt_update_arm64_crypto_192_both_4
L_aes_gcm_encrypt_update_arm64_crypto_192_end_4:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cmp	w8, #1
	beq	L_aes_gcm_encrypt_update_arm64_crypto_192_start_1
	blt	L_aes_gcm_encrypt_update_arm64_crypto_192_done
L_aes_gcm_encrypt_update_arm64_crypto_192_start_2:
	add	w13, w9, #1
	mov	v14.16b, v13.16b
	add	w9, w9, #2
	mov	v15.16b, v13.16b
	rev	w13, w13
	rev	w10, w9
	mov	v14.s[3], w13
	mov	v15.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	subs	w8, w8, #2
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x3], #16
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	ld1	{v19.16b}, [x3], #16
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v11.16b
	eor	v15.16b, v15.16b, v12.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	st1	{v18.16b, v19.16b}, [x2], #32
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v19.1d, v22.1d
	pmull2	v29.1q, v19.2d, v22.2d
	ext	v31.16b, v19.16b, v19.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v21.1d
	pmull2	v26.1q, v23.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cbz	w8, L_aes_gcm_encrypt_update_arm64_crypto_192_done
L_aes_gcm_encrypt_update_arm64_crypto_192_start_1:
	add	w9, w9, #1
	mov	v14.16b, v13.16b
	rev	w10, w9
	mov	v14.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x3], #16
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	eor	v18.16b, v18.16b, v14.16b
	st1	{v18.16b}, [x2], #16
	rbit	v18.16b, v18.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_encrypt_update_arm64_crypto_192_done:
#endif /* !NO_AES_192 */
	b	L_aes_gcm_encrypt_update_arm64_crypto_done
	# AES_GCM_256
L_aes_gcm_encrypt_update_arm64_crypto_start_256:
#ifndef NO_AES_256
	cmp	w8, #32
	blt	L_aes_gcm_encrypt_update_arm64_crypto_256_start_4
L_aes_gcm_encrypt_update_arm64_crypto_256_start_8:
	ldr	q12, [x0]
	add	w17, w9, #1
	mov	v14.16b, v13.16b
	add	w16, w9, #2
	mov	v15.16b, v13.16b
	add	w15, w9, #3
	mov	v16.16b, v13.16b
	add	w14, w9, #4
	mov	v17.16b, v13.16b
	add	w13, w9, #5
	mov	v8.16b, v13.16b
	add	w12, w9, #6
	mov	v9.16b, v13.16b
	add	w11, w9, #7
	mov	v10.16b, v13.16b
	add	w9, w9, #8
	mov	v11.16b, v13.16b
	rev	w17, w17
	rev	w16, w16
	rev	w15, w15
	rev	w14, w14
	rev	w13, w13
	rev	w12, w12
	rev	w11, w11
	rev	w10, w9
	mov	v14.s[3], w17
	mov	v15.s[3], w16
	mov	v16.s[3], w15
	mov	v17.s[3], w14
	mov	v8.s[3], w13
	mov	v9.s[3], w12
	mov	v10.s[3], w11
	mov	v11.s[3], w10
	ldr	q13, [x0, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w8, w8, #8
	ldr	q12, [x0, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b}, [x3], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v19.16b}, [x3], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v20.16b}, [x3], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ld1	{v21.16b}, [x3], #16
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #160]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	ld1	{v0.16b}, [x3], #16
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ld1	{v1.16b}, [x3], #16
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v2.16b}, [x3], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ld1	{v3.16b}, [x3], #16
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #176]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #192]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #208]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #224]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	eor	v0.16b, v0.16b, v8.16b
	eor	v1.16b, v1.16b, v9.16b
	eor	v2.16b, v2.16b, v10.16b
	eor	v3.16b, v3.16b, v11.16b
	ld1	{v13.2d}, [x7]
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x2], #0x40
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x2], #0x40
	cmp	w8, #8
	blt	L_aes_gcm_encrypt_update_arm64_crypto_256_end_8
L_aes_gcm_encrypt_update_arm64_crypto_256_both_8:
	ldr	q12, [x0]
	add	w17, w9, #1
	mov	v14.16b, v13.16b
	add	w16, w9, #2
	mov	v15.16b, v13.16b
	add	w15, w9, #3
	mov	v16.16b, v13.16b
	add	w14, w9, #4
	mov	v17.16b, v13.16b
	add	w13, w9, #5
	mov	v8.16b, v13.16b
	add	w12, w9, #6
	mov	v9.16b, v13.16b
	add	w11, w9, #7
	mov	v10.16b, v13.16b
	add	w9, w9, #8
	mov	v11.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w17, w17
	rbit	v19.16b, v19.16b
	rev	w16, w16
	rbit	v20.16b, v20.16b
	rev	w15, w15
	rbit	v21.16b, v21.16b
	rev	w14, w14
	rbit	v0.16b, v0.16b
	rev	w13, w13
	rbit	v1.16b, v1.16b
	rev	w12, w12
	rbit	v2.16b, v2.16b
	rev	w11, w11
	rbit	v3.16b, v3.16b
	rev	w10, w9
	mov	v14.s[3], w17
	mov	v15.s[3], w16
	mov	v16.s[3], w15
	mov	v17.s[3], w14
	mov	v8.s[3], w13
	mov	v9.s[3], w12
	mov	v10.s[3], w11
	mov	v11.s[3], w10
	ldr	q13, [x0, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v18.16b, v18.16b, v26.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ext	v31.16b, v3.16b, v3.16b, #8
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w8, w8, #8
	ldr	q12, [x0, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v29.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	mov	v28.d[1], v31.d[0]
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v18.16b}, [x3], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ld1	{v19.16b}, [x3], #16
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ld1	{v20.16b}, [x3], #16
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ld1	{v21.16b}, [x3], #16
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v0.16b}, [x3], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v1.16b}, [x3], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v2.16b}, [x3], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ld1	{v3.16b}, [x3], #16
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #160]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #176]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #192]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #208]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #224]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	ld1	{v13.2d}, [x7]
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x2], #0x40
	eor	v0.16b, v0.16b, v8.16b
	eor	v1.16b, v1.16b, v9.16b
	eor	v2.16b, v2.16b, v10.16b
	eor	v3.16b, v3.16b, v11.16b
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x2], #0x40
	cmp	w8, #8
	bge	L_aes_gcm_encrypt_update_arm64_crypto_256_both_8
L_aes_gcm_encrypt_update_arm64_crypto_256_end_8:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	rbit	v0.16b, v0.16b
	rbit	v1.16b, v1.16b
	rbit	v2.16b, v2.16b
	rbit	v3.16b, v3.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	ext	v31.16b, v3.16b, v3.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_encrypt_update_arm64_crypto_256_start_4:
	ld1	{v0.2d, v1.2d, v2.2d, v3.2d}, [x0], #0x40
	ld1	{v4.2d, v5.2d, v6.2d, v7.2d}, [x0], #0x40
	ld1	{v8.2d, v9.2d, v10.2d, v11.2d}, [x0], #0x40
	ld1	{v12.2d}, [x0], #16
	cmp	w8, #1
	blt	L_aes_gcm_encrypt_update_arm64_crypto_256_done
	beq	L_aes_gcm_encrypt_update_arm64_crypto_256_start_1
	cmp	w8, #4
	blt	L_aes_gcm_encrypt_update_arm64_crypto_256_start_2
	add	w13, w9, #1
	mov	v14.16b, v13.16b
	add	w12, w9, #2
	mov	v15.16b, v13.16b
	add	w11, w9, #3
	mov	v16.16b, v13.16b
	add	w9, w9, #4
	mov	v17.16b, v13.16b
	rev	w13, w13
	rev	w12, w12
	rev	w11, w11
	rev	w10, w9
	mov	v14.s[3], w13
	mov	v15.s[3], w12
	mov	v16.s[3], w11
	mov	v17.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w8, w8, #4
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x3], #16
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	ld1	{v19.16b}, [x3], #16
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	ld1	{v20.16b}, [x3], #16
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	ld1	{v21.16b}, [x3], #16
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v11.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v11.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v11.16b
	aesmc	v17.16b, v17.16b
	ld1	{v29.2d, v30.2d}, [x0]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	aese	v15.16b, v29.16b
	eor	v15.16b, v15.16b, v30.16b
	aese	v16.16b, v29.16b
	eor	v16.16b, v16.16b, v30.16b
	aese	v17.16b, v29.16b
	eor	v17.16b, v17.16b, v30.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	cmp	w8, #4
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x2], #0x40
	blt	L_aes_gcm_encrypt_update_arm64_crypto_256_end_4
L_aes_gcm_encrypt_update_arm64_crypto_256_both_4:
	add	w13, w9, #1
	mov	v14.16b, v13.16b
	add	w12, w9, #2
	mov	v15.16b, v13.16b
	add	w11, w9, #3
	mov	v16.16b, v13.16b
	add	w9, w9, #4
	mov	v17.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w13, w13
	rev	w12, w12
	rev	w11, w11
	rbit	v19.16b, v19.16b
	rev	w10, w9
	mov	v14.s[3], w13
	mov	v15.s[3], w12
	mov	v16.s[3], w11
	mov	v17.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	rbit	v20.16b, v20.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	rbit	v21.16b, v21.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	eor	v18.16b, v18.16b, v26.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	ext	v31.16b, v21.16b, v21.16b, #8
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w8, w8, #4
	eor	v31.16b, v31.16b, v29.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	mov	v28.d[1], v31.d[0]
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x3], #0x40
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v11.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v11.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v11.16b
	aesmc	v17.16b, v17.16b
	ld1	{v29.2d, v30.2d}, [x0]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	aese	v15.16b, v29.16b
	eor	v15.16b, v15.16b, v30.16b
	aese	v16.16b, v29.16b
	eor	v16.16b, v16.16b, v30.16b
	aese	v17.16b, v29.16b
	eor	v17.16b, v17.16b, v30.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	cmp	w8, #4
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x2], #0x40
	bge	L_aes_gcm_encrypt_update_arm64_crypto_256_both_4
L_aes_gcm_encrypt_update_arm64_crypto_256_end_4:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cmp	w8, #1
	beq	L_aes_gcm_encrypt_update_arm64_crypto_256_start_1
	blt	L_aes_gcm_encrypt_update_arm64_crypto_256_done
L_aes_gcm_encrypt_update_arm64_crypto_256_start_2:
	add	w13, w9, #1
	mov	v14.16b, v13.16b
	add	w9, w9, #2
	mov	v15.16b, v13.16b
	rev	w13, w13
	rev	w10, w9
	mov	v14.s[3], w13
	mov	v15.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	subs	w8, w8, #2
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x3], #16
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	ld1	{v19.16b}, [x3], #16
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v11.16b
	aesmc	v15.16b, v15.16b
	ld1	{v29.2d, v30.2d}, [x0]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	aese	v15.16b, v29.16b
	eor	v15.16b, v15.16b, v30.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	st1	{v18.16b, v19.16b}, [x2], #32
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v19.1d, v22.1d
	pmull2	v29.1q, v19.2d, v22.2d
	ext	v31.16b, v19.16b, v19.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v21.1d
	pmull2	v26.1q, v23.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cbz	w8, L_aes_gcm_encrypt_update_arm64_crypto_256_done
L_aes_gcm_encrypt_update_arm64_crypto_256_start_1:
	add	w9, w9, #1
	mov	v14.16b, v13.16b
	rev	w10, w9
	mov	v14.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x3], #16
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	ldr	q29, [x0]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ldr	q30, [x0, #16]
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	eor	v18.16b, v18.16b, v14.16b
	st1	{v18.16b}, [x2], #16
	rbit	v18.16b, v18.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_encrypt_update_arm64_crypto_256_done:
#endif /* !NO_AES_256 */
	b	L_aes_gcm_encrypt_update_arm64_crypto_done
	# AES_GCM_128
L_aes_gcm_encrypt_update_arm64_crypto_start_128:
#ifndef NO_AES_128
	cmp	w8, #32
	blt	L_aes_gcm_encrypt_update_arm64_crypto_128_start_4
L_aes_gcm_encrypt_update_arm64_crypto_128_start_8:
	ldr	q12, [x0]
	add	w17, w9, #1
	mov	v14.16b, v13.16b
	add	w16, w9, #2
	mov	v15.16b, v13.16b
	add	w15, w9, #3
	mov	v16.16b, v13.16b
	add	w14, w9, #4
	mov	v17.16b, v13.16b
	add	w13, w9, #5
	mov	v8.16b, v13.16b
	add	w12, w9, #6
	mov	v9.16b, v13.16b
	add	w11, w9, #7
	mov	v10.16b, v13.16b
	add	w9, w9, #8
	mov	v11.16b, v13.16b
	rev	w17, w17
	rev	w16, w16
	rev	w15, w15
	rev	w14, w14
	rev	w13, w13
	rev	w12, w12
	rev	w11, w11
	rev	w10, w9
	mov	v14.s[3], w17
	mov	v15.s[3], w16
	mov	v16.s[3], w15
	mov	v17.s[3], w14
	mov	v8.s[3], w13
	mov	v9.s[3], w12
	mov	v10.s[3], w11
	mov	v11.s[3], w10
	ldr	q13, [x0, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w8, w8, #8
	ldr	q12, [x0, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b}, [x3], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v19.16b}, [x3], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v20.16b}, [x3], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ld1	{v21.16b}, [x3], #16
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #160]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	ld1	{v0.16b}, [x3], #16
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	ld1	{v1.16b}, [x3], #16
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	ld1	{v2.16b}, [x3], #16
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	ld1	{v3.16b}, [x3], #16
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	eor	v0.16b, v0.16b, v8.16b
	eor	v1.16b, v1.16b, v9.16b
	eor	v2.16b, v2.16b, v10.16b
	eor	v3.16b, v3.16b, v11.16b
	ld1	{v13.2d}, [x7]
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x2], #0x40
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x2], #0x40
	cmp	w8, #8
	blt	L_aes_gcm_encrypt_update_arm64_crypto_128_end_8
L_aes_gcm_encrypt_update_arm64_crypto_128_both_8:
	ldr	q12, [x0]
	add	w17, w9, #1
	mov	v14.16b, v13.16b
	add	w16, w9, #2
	mov	v15.16b, v13.16b
	add	w15, w9, #3
	mov	v16.16b, v13.16b
	add	w14, w9, #4
	mov	v17.16b, v13.16b
	add	w13, w9, #5
	mov	v8.16b, v13.16b
	add	w12, w9, #6
	mov	v9.16b, v13.16b
	add	w11, w9, #7
	mov	v10.16b, v13.16b
	add	w9, w9, #8
	mov	v11.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w17, w17
	rbit	v19.16b, v19.16b
	rev	w16, w16
	rbit	v20.16b, v20.16b
	rev	w15, w15
	rbit	v21.16b, v21.16b
	rev	w14, w14
	rbit	v0.16b, v0.16b
	rev	w13, w13
	rbit	v1.16b, v1.16b
	rev	w12, w12
	rbit	v2.16b, v2.16b
	rev	w11, w11
	rbit	v3.16b, v3.16b
	rev	w10, w9
	mov	v14.s[3], w17
	mov	v15.s[3], w16
	mov	v16.s[3], w15
	mov	v17.s[3], w14
	mov	v8.s[3], w13
	mov	v9.s[3], w12
	mov	v10.s[3], w11
	mov	v11.s[3], w10
	ldr	q13, [x0, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v18.16b, v18.16b, v26.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ext	v31.16b, v3.16b, v3.16b, #8
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w8, w8, #8
	ldr	q12, [x0, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v29.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	mov	v28.d[1], v31.d[0]
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v18.16b}, [x3], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ld1	{v19.16b}, [x3], #16
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ld1	{v20.16b}, [x3], #16
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ld1	{v21.16b}, [x3], #16
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v0.16b}, [x3], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v1.16b}, [x3], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v2.16b}, [x3], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ld1	{v3.16b}, [x3], #16
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #160]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	ld1	{v13.2d}, [x7]
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x2], #0x40
	eor	v0.16b, v0.16b, v8.16b
	eor	v1.16b, v1.16b, v9.16b
	eor	v2.16b, v2.16b, v10.16b
	eor	v3.16b, v3.16b, v11.16b
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x2], #0x40
	cmp	w8, #8
	bge	L_aes_gcm_encrypt_update_arm64_crypto_128_both_8
L_aes_gcm_encrypt_update_arm64_crypto_128_end_8:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	rbit	v0.16b, v0.16b
	rbit	v1.16b, v1.16b
	rbit	v2.16b, v2.16b
	rbit	v3.16b, v3.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	ext	v31.16b, v3.16b, v3.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_encrypt_update_arm64_crypto_128_start_4:
	ld1	{v0.2d, v1.2d, v2.2d, v3.2d}, [x0], #0x40
	ld1	{v4.2d, v5.2d, v6.2d, v7.2d}, [x0], #0x40
	ld1	{v8.2d, v9.2d}, [x0], #32
	ld1	{v10.2d}, [x0]
	cmp	w8, #1
	blt	L_aes_gcm_encrypt_update_arm64_crypto_128_done
	beq	L_aes_gcm_encrypt_update_arm64_crypto_128_start_1
	cmp	w8, #4
	blt	L_aes_gcm_encrypt_update_arm64_crypto_128_start_2
	add	w13, w9, #1
	mov	v14.16b, v13.16b
	add	w12, w9, #2
	mov	v15.16b, v13.16b
	add	w11, w9, #3
	mov	v16.16b, v13.16b
	add	w9, w9, #4
	mov	v17.16b, v13.16b
	rev	w13, w13
	rev	w12, w12
	rev	w11, w11
	rev	w10, w9
	mov	v14.s[3], w13
	mov	v15.s[3], w12
	mov	v16.s[3], w11
	mov	v17.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w8, w8, #4
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x3], #16
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	ld1	{v19.16b}, [x3], #16
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	ld1	{v20.16b}, [x3], #16
	aese	v15.16b, v9.16b
	eor	v15.16b, v15.16b, v10.16b
	ld1	{v21.16b}, [x3], #16
	aese	v16.16b, v9.16b
	eor	v16.16b, v16.16b, v10.16b
	aese	v17.16b, v9.16b
	eor	v17.16b, v17.16b, v10.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	cmp	w8, #4
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x2], #0x40
	blt	L_aes_gcm_encrypt_update_arm64_crypto_128_end_4
L_aes_gcm_encrypt_update_arm64_crypto_128_both_4:
	add	w13, w9, #1
	mov	v14.16b, v13.16b
	add	w12, w9, #2
	mov	v15.16b, v13.16b
	add	w11, w9, #3
	mov	v16.16b, v13.16b
	add	w9, w9, #4
	mov	v17.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w13, w13
	rev	w12, w12
	rev	w11, w11
	rbit	v19.16b, v19.16b
	rev	w10, w9
	mov	v14.s[3], w13
	mov	v15.s[3], w12
	mov	v16.s[3], w11
	mov	v17.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	rbit	v20.16b, v20.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	rbit	v21.16b, v21.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	eor	v18.16b, v18.16b, v26.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	ext	v31.16b, v21.16b, v21.16b, #8
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w8, w8, #4
	eor	v31.16b, v31.16b, v29.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	mov	v28.d[1], v31.d[0]
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x3], #0x40
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	aese	v15.16b, v9.16b
	eor	v15.16b, v15.16b, v10.16b
	aese	v16.16b, v9.16b
	eor	v16.16b, v16.16b, v10.16b
	aese	v17.16b, v9.16b
	eor	v17.16b, v17.16b, v10.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	cmp	w8, #4
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x2], #0x40
	bge	L_aes_gcm_encrypt_update_arm64_crypto_128_both_4
L_aes_gcm_encrypt_update_arm64_crypto_128_end_4:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cmp	w8, #1
	beq	L_aes_gcm_encrypt_update_arm64_crypto_128_start_1
	blt	L_aes_gcm_encrypt_update_arm64_crypto_128_done
L_aes_gcm_encrypt_update_arm64_crypto_128_start_2:
	add	w13, w9, #1
	mov	v14.16b, v13.16b
	add	w9, w9, #2
	mov	v15.16b, v13.16b
	rev	w13, w13
	rev	w10, w9
	mov	v14.s[3], w13
	mov	v15.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	subs	w8, w8, #2
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x3], #16
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	ld1	{v19.16b}, [x3], #16
	aese	v15.16b, v9.16b
	eor	v15.16b, v15.16b, v10.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	st1	{v18.16b, v19.16b}, [x2], #32
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v19.1d, v22.1d
	pmull2	v29.1q, v19.2d, v22.2d
	ext	v31.16b, v19.16b, v19.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v21.1d
	pmull2	v26.1q, v23.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cbz	w8, L_aes_gcm_encrypt_update_arm64_crypto_128_done
L_aes_gcm_encrypt_update_arm64_crypto_128_start_1:
	add	w9, w9, #1
	mov	v14.16b, v13.16b
	rev	w10, w9
	mov	v14.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	ld1	{v18.16b}, [x3], #16
	eor	v18.16b, v18.16b, v14.16b
	st1	{v18.16b}, [x2], #16
	rbit	v18.16b, v18.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_encrypt_update_arm64_crypto_128_done:
#endif /* !NO_AES_128 */
L_aes_gcm_encrypt_update_arm64_crypto_done:
	rev	w9, w9
	mov	v13.s[3], w9
	st1	{v26.2d}, [x5]
	st1	{v13.2d}, [x7]
	ldr	x17, [x29, #24]
	ldp	d8, d9, [x29, #32]
	ldp	d10, d11, [x29, #48]
	ldp	d12, d13, [x29, #64]
	ldp	d14, d15, [x29, #80]
	ldp	x29, x30, [sp], #0x60
	ret
#ifndef __APPLE__
	.size	AES_GCM_encrypt_update_AARCH64,.-AES_GCM_encrypt_update_AARCH64
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	AES_GCM_encrypt_final_AARCH64
.type	AES_GCM_encrypt_final_AARCH64,@function
.align	2
AES_GCM_encrypt_final_AARCH64:
#else
.section	__TEXT,__text
.globl	_AES_GCM_encrypt_final_AARCH64
.p2align	2
_AES_GCM_encrypt_final_AARCH64:
#endif /* __APPLE__ */
	ld1	{v5.2d}, [x0]
	movi	v6.16b, #0x87
	ld1	{v4.2d}, [x5]
	ushr	v6.2d, v6.2d, #56
	ld1	{v7.2d}, [x6]
	lsl	x4, x4, #3
	rbit	x4, x4
	mov	v0.d[0], x4
	lsl	x3, x3, #3
	rbit	x3, x3
	mov	v0.d[1], x3
	eor	v5.16b, v5.16b, v0.16b
	pmull	v0.1q, v5.1d, v4.1d
	pmull2	v1.1q, v5.2d, v4.2d
	ext	v3.16b, v5.16b, v5.16b, #8
	pmull	v2.1q, v3.1d, v4.1d
	pmull2	v3.1q, v3.2d, v4.2d
	eor	v2.16b, v2.16b, v3.16b
	#   Reduce
	ext	v3.16b, v0.16b, v1.16b, #8
	pmull2	v1.1q, v1.2d, v6.2d
	eor	v3.16b, v3.16b, v1.16b
	eor	v3.16b, v3.16b, v2.16b
	pmull2	v2.1q, v3.2d, v6.2d
	mov	v0.d[1], v3.d[0]
	eor	v5.16b, v0.16b, v2.16b
	rbit	v5.16b, v5.16b
	eor	v5.16b, v5.16b, v7.16b
	cmp	w2, #16
	bne	L_aes_gcm_encrypt_final_arm64_crypto_tag_partial
	st1	{v5.16b}, [x1]
	b	L_aes_gcm_encrypt_final_arm64_crypto_done
L_aes_gcm_encrypt_final_arm64_crypto_tag_partial:
	st1	{v5.16b}, [x0]
	cmp	w2, #8
	blt	L_aes_gcm_encrypt_final_arm64_crypto_tag_start_dw
	ldr	x8, [x0], #8
	sub	w2, w2, #8
	str	x8, [x1], #8
L_aes_gcm_encrypt_final_arm64_crypto_tag_start_dw:
	cmp	w2, #4
	blt	L_aes_gcm_encrypt_final_arm64_crypto_tag_start_sw
	ldr	w8, [x0], #4
	sub	w2, w2, #4
	str	w8, [x1], #4
L_aes_gcm_encrypt_final_arm64_crypto_tag_start_sw:
	cmp	w2, #2
	blt	L_aes_gcm_encrypt_final_arm64_crypto_tag_start_byte
	ldrh	w8, [x0], #2
	sub	w2, w2, #2
	strh	w8, [x1], #2
L_aes_gcm_encrypt_final_arm64_crypto_tag_start_byte:
	cbz	w2, L_aes_gcm_encrypt_final_arm64_crypto_tag_end_bytes
	ldrb	w8, [x0], #1
	subs	w2, w2, #1
	strb	w8, [x1], #1
	bne	L_aes_gcm_encrypt_final_arm64_crypto_tag_start_byte
L_aes_gcm_encrypt_final_arm64_crypto_tag_end_bytes:
L_aes_gcm_encrypt_final_arm64_crypto_done:
	ret
#ifndef __APPLE__
	.size	AES_GCM_encrypt_final_AARCH64,.-AES_GCM_encrypt_final_AARCH64
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	AES_GCM_decrypt_update_AARCH64
.type	AES_GCM_decrypt_update_AARCH64,@function
.align	2
AES_GCM_decrypt_update_AARCH64:
#else
.section	__TEXT,__text
.globl	_AES_GCM_decrypt_update_AARCH64
.p2align	2
_AES_GCM_decrypt_update_AARCH64:
#endif /* __APPLE__ */
	stp	x29, x30, [sp, #-96]!
	add	x29, sp, #0
	str	x17, [x29, #24]
	stp	d8, d9, [x29, #32]
	stp	d10, d11, [x29, #48]
	stp	d12, d13, [x29, #64]
	stp	d14, d15, [x29, #80]
	ld1	{v13.2d}, [x7]
	movi	v27.16b, #0x87
	ld1	{v26.2d}, [x5]
	ushr	v27.2d, v27.2d, #56
	ld1	{v22.2d}, [x6]
	mov	w9, v13.s[3]
	rev	w9, w9
	cmp	w4, #32
	blt	L_aes_gcm_decrypt_update_arm64_crypto_h_done
	# Square H => H^2
	pmull2	v31.1q, v22.2d, v22.2d
	pmull	v30.1q, v22.1d, v22.1d
	pmull2	v28.1q, v31.2d, v27.2d
	ext	v29.16b, v30.16b, v31.16b, #8
	eor	v29.16b, v29.16b, v28.16b
	pmull2	v31.1q, v29.2d, v27.2d
	mov	v30.d[1], v29.d[0]
	eor	v23.16b, v30.16b, v31.16b
	cmp	w4, #0x40
	blt	L_aes_gcm_decrypt_update_arm64_crypto_h_done
	# Multiply H and H^2  => H^3
	pmull	v28.1q, v22.1d, v23.1d
	pmull2	v29.1q, v22.2d, v23.2d
	ext	v31.16b, v22.16b, v22.16b, #8
	pmull	v30.1q, v31.1d, v23.1d
	pmull2	v31.1q, v31.2d, v23.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v24.16b, v28.16b, v30.16b
	# Square H^2 => H^4
	pmull2	v31.1q, v23.2d, v23.2d
	pmull	v30.1q, v23.1d, v23.1d
	pmull2	v28.1q, v31.2d, v27.2d
	ext	v29.16b, v30.16b, v31.16b, #8
	eor	v29.16b, v29.16b, v28.16b
	pmull2	v31.1q, v29.2d, v27.2d
	mov	v30.d[1], v29.d[0]
	eor	v25.16b, v30.16b, v31.16b
	# Done
	cmp	w4, #0x200
	blt	L_aes_gcm_decrypt_update_arm64_crypto_h_done
	# Multiply H and H^4  => H^5
	pmull	v28.1q, v22.1d, v25.1d
	pmull2	v29.1q, v22.2d, v25.2d
	ext	v31.16b, v22.16b, v22.16b, #8
	pmull	v30.1q, v31.1d, v25.1d
	pmull2	v31.1q, v31.2d, v25.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v4.16b, v28.16b, v30.16b
	# Square H^3 => H^6
	pmull2	v31.1q, v24.2d, v24.2d
	pmull	v30.1q, v24.1d, v24.1d
	pmull2	v28.1q, v31.2d, v27.2d
	ext	v29.16b, v30.16b, v31.16b, #8
	eor	v29.16b, v29.16b, v28.16b
	pmull2	v31.1q, v29.2d, v27.2d
	mov	v30.d[1], v29.d[0]
	eor	v5.16b, v30.16b, v31.16b
	# Multiply H and H^6  => H^7
	pmull	v28.1q, v22.1d, v5.1d
	pmull2	v29.1q, v22.2d, v5.2d
	ext	v31.16b, v22.16b, v22.16b, #8
	pmull	v30.1q, v31.1d, v5.1d
	pmull2	v31.1q, v31.2d, v5.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v6.16b, v28.16b, v30.16b
	# Square H^4 => H^8
	pmull2	v31.1q, v25.2d, v25.2d
	pmull	v30.1q, v25.1d, v25.1d
	pmull2	v28.1q, v31.2d, v27.2d
	ext	v29.16b, v30.16b, v31.16b, #8
	eor	v29.16b, v29.16b, v28.16b
	pmull2	v31.1q, v29.2d, v27.2d
	mov	v30.d[1], v29.d[0]
	eor	v7.16b, v30.16b, v31.16b
	# Done
L_aes_gcm_decrypt_update_arm64_crypto_h_done:
	lsr	w8, w4, #4
	cmp	x1, #12
	blt	L_aes_gcm_decrypt_update_arm64_crypto_start_128
	bgt	L_aes_gcm_decrypt_update_arm64_crypto_start_256
	# AES_GCM_192
#ifndef NO_AES_192
	cmp	w8, #32
	blt	L_aes_gcm_decrypt_update_arm64_crypto_192_start_4
L_aes_gcm_decrypt_update_arm64_crypto_192_start_8:
	ldr	q12, [x0]
	add	w17, w9, #1
	mov	v14.16b, v13.16b
	add	w16, w9, #2
	mov	v15.16b, v13.16b
	add	w15, w9, #3
	mov	v16.16b, v13.16b
	add	w14, w9, #4
	mov	v17.16b, v13.16b
	add	w13, w9, #5
	mov	v8.16b, v13.16b
	add	w12, w9, #6
	mov	v9.16b, v13.16b
	add	w11, w9, #7
	mov	v10.16b, v13.16b
	add	w9, w9, #8
	mov	v11.16b, v13.16b
	rev	w17, w17
	mov	v14.s[3], w17
	rev	w16, w16
	mov	v15.s[3], w16
	rev	w15, w15
	mov	v16.s[3], w15
	rev	w14, w14
	mov	v17.s[3], w14
	rev	w13, w13
	mov	v8.s[3], w13
	rev	w12, w12
	mov	v9.s[3], w12
	rev	w11, w11
	mov	v10.s[3], w11
	rev	w10, w9
	mov	v11.s[3], w10
	ldr	q13, [x0, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w8, w8, #8
	ldr	q12, [x0, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ld1	{v18.16b}, [x3], #16
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v19.16b}, [x3], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v20.16b}, [x3], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v21.16b}, [x3], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #160]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	ld1	{v0.16b}, [x3], #16
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	ld1	{v1.16b}, [x3], #16
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ld1	{v2.16b}, [x3], #16
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v3.16b}, [x3], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #176]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #192]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	eor	v8.16b, v8.16b, v0.16b
	eor	v9.16b, v9.16b, v1.16b
	eor	v10.16b, v10.16b, v2.16b
	eor	v11.16b, v11.16b, v3.16b
	ld1	{v13.2d}, [x7]
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x2], #0x40
	st1	{v8.16b, v9.16b, v10.16b, v11.16b}, [x2], #0x40
	cmp	w8, #8
	blt	L_aes_gcm_decrypt_update_arm64_crypto_192_end_8
L_aes_gcm_decrypt_update_arm64_crypto_192_both_8:
	ldr	q12, [x0]
	add	w17, w9, #1
	mov	v14.16b, v13.16b
	add	w16, w9, #2
	mov	v15.16b, v13.16b
	add	w15, w9, #3
	mov	v16.16b, v13.16b
	add	w14, w9, #4
	mov	v17.16b, v13.16b
	add	w13, w9, #5
	mov	v8.16b, v13.16b
	add	w12, w9, #6
	mov	v9.16b, v13.16b
	add	w11, w9, #7
	mov	v10.16b, v13.16b
	add	w9, w9, #8
	mov	v11.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w17, w17
	rbit	v19.16b, v19.16b
	mov	v14.s[3], w17
	rev	w16, w16
	rbit	v20.16b, v20.16b
	mov	v15.s[3], w16
	rev	w15, w15
	rbit	v21.16b, v21.16b
	mov	v16.s[3], w15
	rev	w14, w14
	rbit	v0.16b, v0.16b
	mov	v17.s[3], w14
	rev	w13, w13
	rbit	v1.16b, v1.16b
	mov	v8.s[3], w13
	rev	w12, w12
	rbit	v2.16b, v2.16b
	mov	v9.s[3], w12
	rev	w11, w11
	rbit	v3.16b, v3.16b
	mov	v10.s[3], w11
	rev	w10, w9
	eor	v18.16b, v18.16b, v26.16b
	mov	v11.s[3], w10
	ldr	q13, [x0, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ext	v31.16b, v3.16b, v3.16b, #8
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor	v31.16b, v31.16b, v29.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w8, w8, #8
	ldr	q12, [x0, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	mov	v28.d[1], v31.d[0]
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ld1	{v18.16b}, [x3], #16
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v19.16b}, [x3], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ld1	{v20.16b}, [x3], #16
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ld1	{v21.16b}, [x3], #16
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ld1	{v0.16b}, [x3], #16
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v1.16b}, [x3], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v2.16b}, [x3], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v3.16b}, [x3], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #160]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #176]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #192]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	ld1	{v13.2d}, [x7]
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x2], #0x40
	eor	v8.16b, v8.16b, v0.16b
	eor	v9.16b, v9.16b, v1.16b
	eor	v10.16b, v10.16b, v2.16b
	eor	v11.16b, v11.16b, v3.16b
	st1	{v8.16b, v9.16b, v10.16b, v11.16b}, [x2], #0x40
	cmp	w8, #8
	bge	L_aes_gcm_decrypt_update_arm64_crypto_192_both_8
L_aes_gcm_decrypt_update_arm64_crypto_192_end_8:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	rbit	v0.16b, v0.16b
	rbit	v1.16b, v1.16b
	rbit	v2.16b, v2.16b
	rbit	v3.16b, v3.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	ext	v31.16b, v3.16b, v3.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_decrypt_update_arm64_crypto_192_start_4:
	ld1	{v0.2d, v1.2d, v2.2d, v3.2d}, [x0], #0x40
	ld1	{v4.2d, v5.2d, v6.2d, v7.2d}, [x0], #0x40
	ld1	{v8.2d, v9.2d, v10.2d, v11.2d}, [x0], #0x40
	ld1	{v12.2d}, [x0]
	cmp	w8, #1
	blt	L_aes_gcm_decrypt_update_arm64_crypto_192_done
	beq	L_aes_gcm_decrypt_update_arm64_crypto_192_start_1
	cmp	w8, #4
	blt	L_aes_gcm_decrypt_update_arm64_crypto_192_start_2
	add	w13, w9, #1
	mov	v14.16b, v13.16b
	add	w12, w9, #2
	mov	v15.16b, v13.16b
	add	w11, w9, #3
	mov	v16.16b, v13.16b
	add	w9, w9, #4
	mov	v17.16b, v13.16b
	rev	w13, w13
	mov	v14.s[3], w13
	rev	w12, w12
	mov	v15.s[3], w12
	rev	w11, w11
	mov	v16.s[3], w11
	rev	w10, w9
	mov	v17.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w8, w8, #4
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b}, [x3], #16
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	ld1	{v19.16b}, [x3], #16
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	ld1	{v20.16b}, [x3], #16
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	ld1	{v21.16b}, [x3], #16
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v11.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v11.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v11.16b
	eor	v17.16b, v17.16b, v12.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	cmp	w8, #4
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x2], #0x40
	blt	L_aes_gcm_decrypt_update_arm64_crypto_192_end_4
L_aes_gcm_decrypt_update_arm64_crypto_192_both_4:
	add	w13, w9, #1
	mov	v14.16b, v13.16b
	add	w12, w9, #2
	mov	v15.16b, v13.16b
	add	w11, w9, #3
	mov	v16.16b, v13.16b
	add	w9, w9, #4
	mov	v17.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w13, w13
	rbit	v19.16b, v19.16b
	mov	v14.s[3], w13
	rev	w12, w12
	rbit	v20.16b, v20.16b
	mov	v15.s[3], w12
	rev	w11, w11
	rbit	v21.16b, v21.16b
	mov	v16.s[3], w11
	rev	w10, w9
	mov	v17.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	eor	v18.16b, v18.16b, v26.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	ext	v31.16b, v21.16b, v21.16b, #8
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	eor	v31.16b, v31.16b, v29.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w8, w8, #4
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	mov	v28.d[1], v31.d[0]
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x3], #0x40
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v11.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v11.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v11.16b
	eor	v17.16b, v17.16b, v12.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	cmp	w8, #4
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x2], #0x40
	bge	L_aes_gcm_decrypt_update_arm64_crypto_192_both_4
L_aes_gcm_decrypt_update_arm64_crypto_192_end_4:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cmp	w8, #1
	beq	L_aes_gcm_decrypt_update_arm64_crypto_192_start_1
	blt	L_aes_gcm_decrypt_update_arm64_crypto_192_done
L_aes_gcm_decrypt_update_arm64_crypto_192_start_2:
	add	w13, w9, #1
	mov	v14.16b, v13.16b
	add	w9, w9, #2
	mov	v15.16b, v13.16b
	rev	w13, w13
	mov	v14.s[3], w13
	rev	w10, w9
	mov	v15.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	subs	w8, w8, #2
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x3], #16
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	ld1	{v19.16b}, [x3], #16
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v11.16b
	eor	v15.16b, v15.16b, v12.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	st1	{v14.16b, v15.16b}, [x2], #32
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v19.1d, v22.1d
	pmull2	v29.1q, v19.2d, v22.2d
	ext	v31.16b, v19.16b, v19.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v21.1d
	pmull2	v26.1q, v23.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cbz	w8, L_aes_gcm_decrypt_update_arm64_crypto_192_done
L_aes_gcm_decrypt_update_arm64_crypto_192_start_1:
	ld1	{v15.16b}, [x3], #16
	add	w9, w9, #1
	mov	v14.16b, v13.16b
	rbit	v15.16b, v15.16b
	rev	w10, w9
	mov	v14.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	eor	v16.16b, v26.16b, v15.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	#   X  = C * H^1
	pmull	v28.1q, v16.1d, v22.1d
	pmull2	v29.1q, v16.2d, v22.2d
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	ext	v31.16b, v16.16b, v16.16b, #8
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v29.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	mov	v28.d[1], v31.d[0]
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	rbit	v15.16b, v15.16b
	eor	v14.16b, v14.16b, v15.16b
	st1	{v14.16b}, [x2], #16
L_aes_gcm_decrypt_update_arm64_crypto_192_done:
#endif /* !NO_AES_192 */
	b	L_aes_gcm_decrypt_update_arm64_crypto_done
	# AES_GCM_256
L_aes_gcm_decrypt_update_arm64_crypto_start_256:
#ifndef NO_AES_256
	cmp	w8, #32
	blt	L_aes_gcm_decrypt_update_arm64_crypto_256_start_4
L_aes_gcm_decrypt_update_arm64_crypto_256_start_8:
	ldr	q12, [x0]
	add	w17, w9, #1
	mov	v14.16b, v13.16b
	add	w16, w9, #2
	mov	v15.16b, v13.16b
	add	w15, w9, #3
	mov	v16.16b, v13.16b
	add	w14, w9, #4
	mov	v17.16b, v13.16b
	add	w13, w9, #5
	mov	v8.16b, v13.16b
	add	w12, w9, #6
	mov	v9.16b, v13.16b
	add	w11, w9, #7
	mov	v10.16b, v13.16b
	add	w9, w9, #8
	mov	v11.16b, v13.16b
	rev	w17, w17
	mov	v14.s[3], w17
	rev	w16, w16
	mov	v15.s[3], w16
	rev	w15, w15
	mov	v16.s[3], w15
	rev	w14, w14
	mov	v17.s[3], w14
	rev	w13, w13
	mov	v8.s[3], w13
	rev	w12, w12
	mov	v9.s[3], w12
	rev	w11, w11
	mov	v10.s[3], w11
	rev	w10, w9
	mov	v11.s[3], w10
	ldr	q13, [x0, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w8, w8, #8
	ldr	q12, [x0, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ld1	{v18.16b}, [x3], #16
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v19.16b}, [x3], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v20.16b}, [x3], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v21.16b}, [x3], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #160]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	ld1	{v0.16b}, [x3], #16
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	ld1	{v1.16b}, [x3], #16
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ld1	{v2.16b}, [x3], #16
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v3.16b}, [x3], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #176]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #192]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #208]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #224]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	eor	v8.16b, v8.16b, v0.16b
	eor	v9.16b, v9.16b, v1.16b
	eor	v10.16b, v10.16b, v2.16b
	eor	v11.16b, v11.16b, v3.16b
	ld1	{v13.2d}, [x7]
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x2], #0x40
	st1	{v8.16b, v9.16b, v10.16b, v11.16b}, [x2], #0x40
	cmp	w8, #8
	blt	L_aes_gcm_decrypt_update_arm64_crypto_256_end_8
L_aes_gcm_decrypt_update_arm64_crypto_256_both_8:
	ldr	q12, [x0]
	add	w17, w9, #1
	mov	v14.16b, v13.16b
	add	w16, w9, #2
	mov	v15.16b, v13.16b
	add	w15, w9, #3
	mov	v16.16b, v13.16b
	add	w14, w9, #4
	mov	v17.16b, v13.16b
	add	w13, w9, #5
	mov	v8.16b, v13.16b
	add	w12, w9, #6
	mov	v9.16b, v13.16b
	add	w11, w9, #7
	mov	v10.16b, v13.16b
	add	w9, w9, #8
	mov	v11.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w17, w17
	rbit	v19.16b, v19.16b
	mov	v14.s[3], w17
	rev	w16, w16
	rbit	v20.16b, v20.16b
	mov	v15.s[3], w16
	rev	w15, w15
	rbit	v21.16b, v21.16b
	mov	v16.s[3], w15
	rev	w14, w14
	rbit	v0.16b, v0.16b
	mov	v17.s[3], w14
	rev	w13, w13
	rbit	v1.16b, v1.16b
	mov	v8.s[3], w13
	rev	w12, w12
	rbit	v2.16b, v2.16b
	mov	v9.s[3], w12
	rev	w11, w11
	rbit	v3.16b, v3.16b
	mov	v10.s[3], w11
	rev	w10, w9
	eor	v18.16b, v18.16b, v26.16b
	mov	v11.s[3], w10
	ldr	q13, [x0, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ext	v31.16b, v3.16b, v3.16b, #8
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor	v31.16b, v31.16b, v29.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w8, w8, #8
	ldr	q12, [x0, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	mov	v28.d[1], v31.d[0]
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ld1	{v18.16b}, [x3], #16
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v19.16b}, [x3], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ld1	{v20.16b}, [x3], #16
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ld1	{v21.16b}, [x3], #16
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ld1	{v0.16b}, [x3], #16
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v1.16b}, [x3], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v2.16b}, [x3], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v3.16b}, [x3], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #160]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #176]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #192]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #208]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #224]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	ld1	{v13.2d}, [x7]
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x2], #0x40
	eor	v8.16b, v8.16b, v0.16b
	eor	v9.16b, v9.16b, v1.16b
	eor	v10.16b, v10.16b, v2.16b
	eor	v11.16b, v11.16b, v3.16b
	st1	{v8.16b, v9.16b, v10.16b, v11.16b}, [x2], #0x40
	cmp	w8, #8
	bge	L_aes_gcm_decrypt_update_arm64_crypto_256_both_8
L_aes_gcm_decrypt_update_arm64_crypto_256_end_8:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	rbit	v0.16b, v0.16b
	rbit	v1.16b, v1.16b
	rbit	v2.16b, v2.16b
	rbit	v3.16b, v3.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	ext	v31.16b, v3.16b, v3.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_decrypt_update_arm64_crypto_256_start_4:
	ld1	{v0.2d, v1.2d, v2.2d, v3.2d}, [x0], #0x40
	ld1	{v4.2d, v5.2d, v6.2d, v7.2d}, [x0], #0x40
	ld1	{v8.2d, v9.2d, v10.2d, v11.2d}, [x0], #0x40
	ld1	{v12.2d}, [x0], #16
	cmp	w8, #1
	blt	L_aes_gcm_decrypt_update_arm64_crypto_256_done
	beq	L_aes_gcm_decrypt_update_arm64_crypto_256_start_1
	cmp	w8, #4
	blt	L_aes_gcm_decrypt_update_arm64_crypto_256_start_2
	add	w13, w9, #1
	mov	v14.16b, v13.16b
	add	w12, w9, #2
	mov	v15.16b, v13.16b
	add	w11, w9, #3
	mov	v16.16b, v13.16b
	add	w9, w9, #4
	mov	v17.16b, v13.16b
	rev	w13, w13
	mov	v14.s[3], w13
	rev	w12, w12
	mov	v15.s[3], w12
	rev	w11, w11
	mov	v16.s[3], w11
	rev	w10, w9
	mov	v17.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w8, w8, #4
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b}, [x3], #16
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	ld1	{v19.16b}, [x3], #16
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	ld1	{v20.16b}, [x3], #16
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	ld1	{v21.16b}, [x3], #16
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v11.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v11.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v11.16b
	aesmc	v17.16b, v17.16b
	ld1	{v29.2d, v30.2d}, [x0]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	aese	v15.16b, v29.16b
	eor	v15.16b, v15.16b, v30.16b
	aese	v16.16b, v29.16b
	eor	v16.16b, v16.16b, v30.16b
	aese	v17.16b, v29.16b
	eor	v17.16b, v17.16b, v30.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	cmp	w8, #4
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x2], #0x40
	blt	L_aes_gcm_decrypt_update_arm64_crypto_256_end_4
L_aes_gcm_decrypt_update_arm64_crypto_256_both_4:
	add	w13, w9, #1
	mov	v14.16b, v13.16b
	add	w12, w9, #2
	mov	v15.16b, v13.16b
	add	w11, w9, #3
	mov	v16.16b, v13.16b
	add	w9, w9, #4
	mov	v17.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w13, w13
	rbit	v19.16b, v19.16b
	mov	v14.s[3], w13
	rev	w12, w12
	rbit	v20.16b, v20.16b
	mov	v15.s[3], w12
	rev	w11, w11
	rbit	v21.16b, v21.16b
	mov	v16.s[3], w11
	rev	w10, w9
	mov	v17.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	eor	v18.16b, v18.16b, v26.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	ext	v31.16b, v21.16b, v21.16b, #8
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	eor	v31.16b, v31.16b, v29.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w8, w8, #4
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	mov	v28.d[1], v31.d[0]
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x3], #0x40
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v11.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v11.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v11.16b
	aesmc	v17.16b, v17.16b
	ld1	{v29.2d, v30.2d}, [x0]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	aese	v15.16b, v29.16b
	eor	v15.16b, v15.16b, v30.16b
	aese	v16.16b, v29.16b
	eor	v16.16b, v16.16b, v30.16b
	aese	v17.16b, v29.16b
	eor	v17.16b, v17.16b, v30.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	cmp	w8, #4
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x2], #0x40
	bge	L_aes_gcm_decrypt_update_arm64_crypto_256_both_4
L_aes_gcm_decrypt_update_arm64_crypto_256_end_4:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cmp	w8, #1
	beq	L_aes_gcm_decrypt_update_arm64_crypto_256_start_1
	blt	L_aes_gcm_decrypt_update_arm64_crypto_256_done
L_aes_gcm_decrypt_update_arm64_crypto_256_start_2:
	add	w13, w9, #1
	mov	v14.16b, v13.16b
	add	w9, w9, #2
	mov	v15.16b, v13.16b
	rev	w13, w13
	mov	v14.s[3], w13
	rev	w10, w9
	mov	v15.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	subs	w8, w8, #2
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x3], #16
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	ld1	{v19.16b}, [x3], #16
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v11.16b
	aesmc	v15.16b, v15.16b
	ld1	{v29.2d, v30.2d}, [x0]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	aese	v15.16b, v29.16b
	eor	v15.16b, v15.16b, v30.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	st1	{v14.16b, v15.16b}, [x2], #32
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v19.1d, v22.1d
	pmull2	v29.1q, v19.2d, v22.2d
	ext	v31.16b, v19.16b, v19.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v21.1d
	pmull2	v26.1q, v23.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cbz	w8, L_aes_gcm_decrypt_update_arm64_crypto_256_done
L_aes_gcm_decrypt_update_arm64_crypto_256_start_1:
	add	w9, w9, #1
	mov	v14.16b, v13.16b
	rev	w10, w9
	mov	v14.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x3], #16
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	ldr	q29, [x0]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ldr	q30, [x0, #16]
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	eor	v14.16b, v14.16b, v18.16b
	st1	{v14.16b}, [x2], #16
	rbit	v18.16b, v18.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_decrypt_update_arm64_crypto_256_done:
#endif /* !NO_AES_256 */
	b	L_aes_gcm_decrypt_update_arm64_crypto_done
	# AES_GCM_128
L_aes_gcm_decrypt_update_arm64_crypto_start_128:
#ifndef NO_AES_128
	cmp	w8, #32
	blt	L_aes_gcm_decrypt_update_arm64_crypto_128_start_4
L_aes_gcm_decrypt_update_arm64_crypto_128_start_8:
	ldr	q12, [x0]
	add	w17, w9, #1
	mov	v14.16b, v13.16b
	add	w16, w9, #2
	mov	v15.16b, v13.16b
	add	w15, w9, #3
	mov	v16.16b, v13.16b
	add	w14, w9, #4
	mov	v17.16b, v13.16b
	add	w13, w9, #5
	mov	v8.16b, v13.16b
	add	w12, w9, #6
	mov	v9.16b, v13.16b
	add	w11, w9, #7
	mov	v10.16b, v13.16b
	add	w9, w9, #8
	mov	v11.16b, v13.16b
	rev	w17, w17
	mov	v14.s[3], w17
	rev	w16, w16
	mov	v15.s[3], w16
	rev	w15, w15
	mov	v16.s[3], w15
	rev	w14, w14
	mov	v17.s[3], w14
	rev	w13, w13
	mov	v8.s[3], w13
	rev	w12, w12
	mov	v9.s[3], w12
	rev	w11, w11
	mov	v10.s[3], w11
	rev	w10, w9
	mov	v11.s[3], w10
	ldr	q13, [x0, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w8, w8, #8
	ldr	q12, [x0, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ld1	{v18.16b}, [x3], #16
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v19.16b}, [x3], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v20.16b}, [x3], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v21.16b}, [x3], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #160]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	ld1	{v0.16b}, [x3], #16
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	ld1	{v1.16b}, [x3], #16
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	ld1	{v2.16b}, [x3], #16
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	ld1	{v3.16b}, [x3], #16
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	eor	v8.16b, v8.16b, v0.16b
	eor	v9.16b, v9.16b, v1.16b
	eor	v10.16b, v10.16b, v2.16b
	eor	v11.16b, v11.16b, v3.16b
	ld1	{v13.2d}, [x7]
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x2], #0x40
	st1	{v8.16b, v9.16b, v10.16b, v11.16b}, [x2], #0x40
	cmp	w8, #8
	blt	L_aes_gcm_decrypt_update_arm64_crypto_128_end_8
L_aes_gcm_decrypt_update_arm64_crypto_128_both_8:
	ldr	q12, [x0]
	add	w17, w9, #1
	mov	v14.16b, v13.16b
	add	w16, w9, #2
	mov	v15.16b, v13.16b
	add	w15, w9, #3
	mov	v16.16b, v13.16b
	add	w14, w9, #4
	mov	v17.16b, v13.16b
	add	w13, w9, #5
	mov	v8.16b, v13.16b
	add	w12, w9, #6
	mov	v9.16b, v13.16b
	add	w11, w9, #7
	mov	v10.16b, v13.16b
	add	w9, w9, #8
	mov	v11.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w17, w17
	rbit	v19.16b, v19.16b
	mov	v14.s[3], w17
	rev	w16, w16
	rbit	v20.16b, v20.16b
	mov	v15.s[3], w16
	rev	w15, w15
	rbit	v21.16b, v21.16b
	mov	v16.s[3], w15
	rev	w14, w14
	rbit	v0.16b, v0.16b
	mov	v17.s[3], w14
	rev	w13, w13
	rbit	v1.16b, v1.16b
	mov	v8.s[3], w13
	rev	w12, w12
	rbit	v2.16b, v2.16b
	mov	v9.s[3], w12
	rev	w11, w11
	rbit	v3.16b, v3.16b
	mov	v10.s[3], w11
	rev	w10, w9
	eor	v18.16b, v18.16b, v26.16b
	mov	v11.s[3], w10
	ldr	q13, [x0, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ext	v31.16b, v3.16b, v3.16b, #8
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor	v31.16b, v31.16b, v29.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w8, w8, #8
	ldr	q12, [x0, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	mov	v28.d[1], v31.d[0]
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ld1	{v18.16b}, [x3], #16
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v19.16b}, [x3], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ld1	{v20.16b}, [x3], #16
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ld1	{v21.16b}, [x3], #16
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ld1	{v0.16b}, [x3], #16
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v1.16b}, [x3], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v2.16b}, [x3], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v3.16b}, [x3], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #160]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	ld1	{v13.2d}, [x7]
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x2], #0x40
	eor	v8.16b, v8.16b, v0.16b
	eor	v9.16b, v9.16b, v1.16b
	eor	v10.16b, v10.16b, v2.16b
	eor	v11.16b, v11.16b, v3.16b
	st1	{v8.16b, v9.16b, v10.16b, v11.16b}, [x2], #0x40
	cmp	w8, #8
	bge	L_aes_gcm_decrypt_update_arm64_crypto_128_both_8
L_aes_gcm_decrypt_update_arm64_crypto_128_end_8:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	rbit	v0.16b, v0.16b
	rbit	v1.16b, v1.16b
	rbit	v2.16b, v2.16b
	rbit	v3.16b, v3.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	ext	v31.16b, v3.16b, v3.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_decrypt_update_arm64_crypto_128_start_4:
	ld1	{v0.2d, v1.2d, v2.2d, v3.2d}, [x0], #0x40
	ld1	{v4.2d, v5.2d, v6.2d, v7.2d}, [x0], #0x40
	ld1	{v8.2d, v9.2d}, [x0], #32
	ld1	{v10.2d}, [x0]
	cmp	w8, #1
	blt	L_aes_gcm_decrypt_update_arm64_crypto_128_done
	beq	L_aes_gcm_decrypt_update_arm64_crypto_128_start_1
	cmp	w8, #4
	blt	L_aes_gcm_decrypt_update_arm64_crypto_128_start_2
	add	w13, w9, #1
	mov	v14.16b, v13.16b
	add	w12, w9, #2
	mov	v15.16b, v13.16b
	add	w11, w9, #3
	mov	v16.16b, v13.16b
	add	w9, w9, #4
	mov	v17.16b, v13.16b
	rev	w13, w13
	mov	v14.s[3], w13
	rev	w12, w12
	mov	v15.s[3], w12
	rev	w11, w11
	mov	v16.s[3], w11
	rev	w10, w9
	mov	v17.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w8, w8, #4
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b}, [x3], #16
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	ld1	{v19.16b}, [x3], #16
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	ld1	{v20.16b}, [x3], #16
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	ld1	{v21.16b}, [x3], #16
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	aese	v15.16b, v9.16b
	eor	v15.16b, v15.16b, v10.16b
	aese	v16.16b, v9.16b
	eor	v16.16b, v16.16b, v10.16b
	aese	v17.16b, v9.16b
	eor	v17.16b, v17.16b, v10.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	cmp	w8, #4
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x2], #0x40
	blt	L_aes_gcm_decrypt_update_arm64_crypto_128_end_4
L_aes_gcm_decrypt_update_arm64_crypto_128_both_4:
	add	w13, w9, #1
	mov	v14.16b, v13.16b
	add	w12, w9, #2
	mov	v15.16b, v13.16b
	add	w11, w9, #3
	mov	v16.16b, v13.16b
	add	w9, w9, #4
	mov	v17.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w13, w13
	rbit	v19.16b, v19.16b
	mov	v14.s[3], w13
	rev	w12, w12
	rbit	v20.16b, v20.16b
	mov	v15.s[3], w12
	rev	w11, w11
	rbit	v21.16b, v21.16b
	mov	v16.s[3], w11
	rev	w10, w9
	mov	v17.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	eor	v18.16b, v18.16b, v26.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	ext	v31.16b, v21.16b, v21.16b, #8
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v26.16b, v31.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v26.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	eor	v31.16b, v31.16b, v29.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	eor	v31.16b, v31.16b, v30.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w8, w8, #4
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	mov	v28.d[1], v31.d[0]
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x3], #0x40
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	aese	v15.16b, v9.16b
	eor	v15.16b, v15.16b, v10.16b
	aese	v16.16b, v9.16b
	eor	v16.16b, v16.16b, v10.16b
	aese	v17.16b, v9.16b
	eor	v17.16b, v17.16b, v10.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	cmp	w8, #4
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x2], #0x40
	bge	L_aes_gcm_decrypt_update_arm64_crypto_128_both_4
L_aes_gcm_decrypt_update_arm64_crypto_128_end_4:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cmp	w8, #1
	beq	L_aes_gcm_decrypt_update_arm64_crypto_128_start_1
	blt	L_aes_gcm_decrypt_update_arm64_crypto_128_done
L_aes_gcm_decrypt_update_arm64_crypto_128_start_2:
	add	w13, w9, #1
	mov	v14.16b, v13.16b
	add	w9, w9, #2
	mov	v15.16b, v13.16b
	rev	w13, w13
	mov	v14.s[3], w13
	rev	w10, w9
	mov	v15.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	subs	w8, w8, #2
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x3], #16
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	ld1	{v19.16b}, [x3], #16
	aese	v15.16b, v9.16b
	eor	v15.16b, v15.16b, v10.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	st1	{v14.16b, v15.16b}, [x2], #32
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v19.1d, v22.1d
	pmull2	v29.1q, v19.2d, v22.2d
	ext	v31.16b, v19.16b, v19.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v21.1d
	pmull2	v26.1q, v23.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor	v26.16b, v26.16b, v31.16b
	eor	v30.16b, v30.16b, v26.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cbz	w8, L_aes_gcm_decrypt_update_arm64_crypto_128_done
L_aes_gcm_decrypt_update_arm64_crypto_128_start_1:
	add	w9, w9, #1
	mov	v14.16b, v13.16b
	rev	w10, w9
	mov	v14.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	ld1	{v18.16b}, [x3], #16
	eor	v14.16b, v14.16b, v18.16b
	st1	{v14.16b}, [x2], #16
	rbit	v18.16b, v18.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor	v31.16b, v31.16b, v29.16b
	eor	v31.16b, v31.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_decrypt_update_arm64_crypto_128_done:
#endif /* !NO_AES_128 */
L_aes_gcm_decrypt_update_arm64_crypto_done:
	rev	w9, w9
	mov	v13.s[3], w9
	st1	{v26.2d}, [x5]
	st1	{v13.2d}, [x7]
	ldr	x17, [x29, #24]
	ldp	d8, d9, [x29, #32]
	ldp	d10, d11, [x29, #48]
	ldp	d12, d13, [x29, #64]
	ldp	d14, d15, [x29, #80]
	ldp	x29, x30, [sp], #0x60
	ret
#ifndef __APPLE__
	.size	AES_GCM_decrypt_update_AARCH64,.-AES_GCM_decrypt_update_AARCH64
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	AES_GCM_decrypt_final_AARCH64
.type	AES_GCM_decrypt_final_AARCH64,@function
.align	2
AES_GCM_decrypt_final_AARCH64:
#else
.section	__TEXT,__text
.globl	_AES_GCM_decrypt_final_AARCH64
.p2align	2
_AES_GCM_decrypt_final_AARCH64:
#endif /* __APPLE__ */
	ld1	{v5.2d}, [x0]
	movi	v6.16b, #0x87
	ld1	{v4.2d}, [x5]
	ushr	v6.2d, v6.2d, #56
	ld1	{v7.2d}, [x6]
	lsl	x4, x4, #3
	rbit	x4, x4
	mov	v0.d[0], x4
	lsl	x3, x3, #3
	rbit	x3, x3
	mov	v0.d[1], x3
	eor	v5.16b, v5.16b, v0.16b
	pmull	v0.1q, v5.1d, v4.1d
	pmull2	v1.1q, v5.2d, v4.2d
	ext	v3.16b, v5.16b, v5.16b, #8
	pmull	v2.1q, v3.1d, v4.1d
	pmull2	v3.1q, v3.2d, v4.2d
	eor	v2.16b, v2.16b, v3.16b
	#   Reduce
	ext	v3.16b, v0.16b, v1.16b, #8
	pmull2	v1.1q, v1.2d, v6.2d
	eor	v3.16b, v3.16b, v1.16b
	eor	v3.16b, v3.16b, v2.16b
	pmull2	v2.1q, v3.2d, v6.2d
	mov	v0.d[1], v3.d[0]
	eor	v5.16b, v0.16b, v2.16b
	rbit	v5.16b, v5.16b
	eor	v5.16b, v5.16b, v7.16b
	cmp	w2, #16
	blt	L_aes_gcm_decrypt_final_arm64_crypto_part_tag
	ld1	{v0.16b}, [x1]
	b	L_aes_gcm_decrypt_final_arm64_crypto_tag_loaded
L_aes_gcm_decrypt_final_arm64_crypto_part_tag:
	eor	v0.16b, v0.16b, v0.16b
	mov	x10, x2
	st1	{v0.2d}, [x0]
	cmp	x10, #8
	blt	L_aes_gcm_decrypt_final_arm64_crypto_tag_start_dw
	ldr	x9, [x1], #8
	sub	x10, x10, #8
	str	x9, [x0], #8
L_aes_gcm_decrypt_final_arm64_crypto_tag_start_dw:
	cmp	x10, #4
	blt	L_aes_gcm_decrypt_final_arm64_crypto_tag_start_sw
	ldr	w9, [x1], #4
	sub	x10, x10, #4
	str	w9, [x0], #4
L_aes_gcm_decrypt_final_arm64_crypto_tag_start_sw:
	cmp	x10, #2
	blt	L_aes_gcm_decrypt_final_arm64_crypto_tag_start_byte
	ldrh	w9, [x1], #2
	sub	x10, x10, #2
	strh	w9, [x0], #2
L_aes_gcm_decrypt_final_arm64_crypto_tag_start_byte:
	cbz	x10, L_aes_gcm_decrypt_final_arm64_crypto_tag_end_bytes
	ldrb	w9, [x1], #1
	subs	x10, x10, #1
	strb	w9, [x0], #1
	bne	L_aes_gcm_decrypt_final_arm64_crypto_tag_start_byte
L_aes_gcm_decrypt_final_arm64_crypto_tag_end_bytes:
	sub	x0, x0, x2
	ld1	{v0.2d}, [x0]
	mov	x10, #16
	st1	{v5.2d}, [x0]
	sub	x10, x10, x2
	add	x0, x0, x2
L_aes_gcm_decrypt_final_arm64_crypto_calc_tag_byte:
	strb	wzr, [x0], #1
	subs	x10, x10, #1
	bne	L_aes_gcm_decrypt_final_arm64_crypto_calc_tag_byte
	subs	x0, x0, #16
	ld1	{v5.2d}, [x0]
L_aes_gcm_decrypt_final_arm64_crypto_tag_loaded:
	eor	v0.16b, v0.16b, v5.16b
	mov	x9, v0.d[0]
	mov	x10, v0.d[1]
	mov	w11, #-180
	orr	x9, x9, x10
	cmp	x9, #0
	csetm	x8, ne
	and	x8, x8, x11
	add	w8, w8, #0xb4
	str	w8, [x7]
	ret
#ifndef __APPLE__
	.size	AES_GCM_decrypt_final_AARCH64,.-AES_GCM_decrypt_final_AARCH64
#endif /* __APPLE__ */
#ifdef WOLFSSL_ARMASM_CRYPTO_SHA3
#ifndef __APPLE__
.text
.globl	AES_GCM_init_AARCH64_EOR3
.type	AES_GCM_init_AARCH64_EOR3,@function
.align	2
AES_GCM_init_AARCH64_EOR3:
#else
.section	__TEXT,__text
.globl	_AES_GCM_init_AARCH64_EOR3
.p2align	2
_AES_GCM_init_AARCH64_EOR3:
#endif /* __APPLE__ */
	stp	x29, x30, [sp, #-48]!
	add	x29, sp, #0
	stp	d8, d9, [x29, #16]
	stp	d10, d11, [x29, #32]
	movi	v6.16b, #0x87
	ld1	{v5.2d}, [x4]
	ushr	v6.2d, v6.2d, #56
	# Load Nonce
	cmp	w3, #12
	bne	L_aes_gcm_init_arm64_crypto_eor3_ghash_nonce
	ldr	x9, [x2]
	movi	v4.4s, #1, lsl 24
	ldr	w10, [x2, #8]
	mov	v4.d[0], x9
	mov	v4.s[2], w10
	mov	w8, #1
	b	L_aes_gcm_init_arm64_crypto_eor3_done_nonce
L_aes_gcm_init_arm64_crypto_eor3_ghash_nonce:
	eor	v4.16b, v4.16b, v4.16b
	lsr	w7, w3, #4
	cbz	w7, L_aes_gcm_init_arm64_crypto_eor3_done
L_aes_gcm_init_arm64_crypto_eor3_start_1:
	ld1	{v0.16b}, [x2], #16
	rbit	v0.16b, v0.16b
	eor	v3.16b, v4.16b, v0.16b
	#   X  = C * H^1
	pmull	v7.1q, v3.1d, v5.1d
	pmull2	v8.1q, v3.2d, v5.2d
	ext	v10.16b, v3.16b, v3.16b, #8
	pmull	v9.1q, v10.1d, v5.1d
	pmull2	v10.1q, v10.2d, v5.2d
	eor	v9.16b, v9.16b, v10.16b
	#   Reduce
	ext	v10.16b, v7.16b, v8.16b, #8
	pmull2	v8.1q, v8.2d, v6.2d
	eor3	v10.16b, v10.16b, v8.16b, v9.16b
	pmull2	v9.1q, v10.2d, v6.2d
	mov	v7.d[1], v10.d[0]
	eor	v4.16b, v7.16b, v9.16b
	# Done GHASH
	subs	w7, w7, #1
	bne	L_aes_gcm_init_arm64_crypto_eor3_start_1
L_aes_gcm_init_arm64_crypto_eor3_done:
	and	w13, w3, #15
	cbz	x13, L_aes_gcm_init_arm64_crypto_eor3_partial_done
	eor	v7.16b, v7.16b, v7.16b
	mov	w12, w13
	st1	{v7.2d}, [x6]
	cmp	w12, #8
	blt	L_aes_gcm_init_arm64_crypto_eor3_start_dw
	ldr	x11, [x2], #8
	sub	w12, w12, #8
	str	x11, [x6], #8
L_aes_gcm_init_arm64_crypto_eor3_start_dw:
	cmp	w12, #4
	blt	L_aes_gcm_init_arm64_crypto_eor3_start_sw
	ldr	w11, [x2], #4
	sub	w12, w12, #4
	str	w11, [x6], #4
L_aes_gcm_init_arm64_crypto_eor3_start_sw:
	cmp	w12, #2
	blt	L_aes_gcm_init_arm64_crypto_eor3_start_byte
	ldrh	w11, [x2], #2
	sub	w12, w12, #2
	strh	w11, [x6], #2
L_aes_gcm_init_arm64_crypto_eor3_start_byte:
	cbz	w12, L_aes_gcm_init_arm64_crypto_eor3_end_bytes
	ldrb	w11, [x2], #1
	subs	w12, w12, #1
	strb	w11, [x6], #1
	bne	L_aes_gcm_init_arm64_crypto_eor3_start_byte
L_aes_gcm_init_arm64_crypto_eor3_end_bytes:
	sub	x6, x6, x13
	ld1	{v0.2d}, [x6]
	rbit	v0.16b, v0.16b
	eor	v3.16b, v4.16b, v0.16b
	#   X  = C * H^1
	pmull	v7.1q, v3.1d, v5.1d
	pmull2	v8.1q, v3.2d, v5.2d
	ext	v10.16b, v3.16b, v3.16b, #8
	pmull	v9.1q, v10.1d, v5.1d
	pmull2	v10.1q, v10.2d, v5.2d
	eor	v9.16b, v9.16b, v10.16b
	#   Reduce
	ext	v10.16b, v7.16b, v8.16b, #8
	pmull2	v8.1q, v8.2d, v6.2d
	eor3	v10.16b, v10.16b, v8.16b, v9.16b
	pmull2	v9.1q, v10.2d, v6.2d
	mov	v7.d[1], v10.d[0]
	eor	v4.16b, v7.16b, v9.16b
	# Done GHASH
L_aes_gcm_init_arm64_crypto_eor3_partial_done:
	eor	x7, x7, x7
	lsl	x13, x3, #3
	mov	v7.d[0], x7
	mov	v7.d[1], x13
	rev64	v7.16b, v7.16b
	rbit	v7.16b, v7.16b
	eor	v4.16b, v4.16b, v7.16b
	pmull	v7.1q, v4.1d, v5.1d
	pmull2	v8.1q, v4.2d, v5.2d
	ext	v10.16b, v4.16b, v4.16b, #8
	pmull	v9.1q, v10.1d, v5.1d
	pmull2	v10.1q, v10.2d, v5.2d
	eor	v9.16b, v9.16b, v10.16b
	ext	v10.16b, v7.16b, v8.16b, #8
	pmull2	v8.1q, v8.2d, v6.2d
	eor3	v10.16b, v10.16b, v8.16b, v9.16b
	pmull2	v9.1q, v10.2d, v6.2d
	mov	v7.d[1], v10.d[0]
	eor	v4.16b, v7.16b, v9.16b
	rbit	v4.16b, v4.16b
	mov	w8, v4.s[3]
	rev	w8, w8
L_aes_gcm_init_arm64_crypto_eor3_done_nonce:
	st1	{v4.2d}, [x5]
	ld1	{v7.2d, v8.2d, v9.2d, v10.2d}, [x0], #0x40
	aese	v4.16b, v7.16b
	aesmc	v4.16b, v4.16b
	aese	v4.16b, v8.16b
	aesmc	v4.16b, v4.16b
	aese	v4.16b, v9.16b
	aesmc	v4.16b, v4.16b
	aese	v4.16b, v10.16b
	aesmc	v4.16b, v4.16b
	ld1	{v7.2d, v8.2d, v9.2d, v10.2d}, [x0], #0x40
	aese	v4.16b, v7.16b
	aesmc	v4.16b, v4.16b
	aese	v4.16b, v8.16b
	aesmc	v4.16b, v4.16b
	aese	v4.16b, v9.16b
	aesmc	v4.16b, v4.16b
	aese	v4.16b, v10.16b
	aesmc	v4.16b, v4.16b
	subs	w1, w1, #10
	ld1	{v7.2d, v8.2d}, [x0], #32
	aese	v4.16b, v7.16b
	aesmc	v4.16b, v4.16b
	aese	v4.16b, v8.16b
	beq	L_aes_gcm_init_arm64_crypto_eor3_round_done
	ld1	{v7.2d, v8.2d}, [x0], #32
	subs	w1, w1, #2
	aesmc	v4.16b, v4.16b
	aese	v4.16b, v7.16b
	aesmc	v4.16b, v4.16b
	aese	v4.16b, v8.16b
	beq	L_aes_gcm_init_arm64_crypto_eor3_round_done
	ld1	{v7.2d, v8.2d}, [x0], #32
	aesmc	v4.16b, v4.16b
	aese	v4.16b, v7.16b
	aesmc	v4.16b, v4.16b
	aese	v4.16b, v8.16b
L_aes_gcm_init_arm64_crypto_eor3_round_done:
	ld1	{v7.2d}, [x0]
	eor	v4.16b, v4.16b, v7.16b
	st1	{v4.2d}, [x6]
	ldp	d8, d9, [x29, #16]
	ldp	d10, d11, [x29, #32]
	ldp	x29, x30, [sp], #48
	ret
#ifndef __APPLE__
	.size	AES_GCM_init_AARCH64_EOR3,.-AES_GCM_init_AARCH64_EOR3
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	AES_GCM_ghash_block_AARCH64_EOR3
.type	AES_GCM_ghash_block_AARCH64_EOR3,@function
.align	2
AES_GCM_ghash_block_AARCH64_EOR3:
#else
.section	__TEXT,__text
.globl	_AES_GCM_ghash_block_AARCH64_EOR3
.p2align	2
_AES_GCM_ghash_block_AARCH64_EOR3:
#endif /* __APPLE__ */
	stp	x29, x30, [sp, #-32]!
	add	x29, sp, #0
	stp	d8, d9, [x29, #16]
	ld1	{v6.2d}, [x1]
	movi	v7.16b, #0x87
	ld1	{v5.2d}, [x2]
	ushr	v7.2d, v7.2d, #56
	ld1	{v4.2d}, [x0]
	rbit	v4.16b, v4.16b
	eor	v8.16b, v6.16b, v4.16b
	#   X  = C * H^1
	pmull	v0.1q, v8.1d, v5.1d
	pmull2	v1.1q, v8.2d, v5.2d
	ext	v3.16b, v8.16b, v8.16b, #8
	pmull	v2.1q, v3.1d, v5.1d
	pmull2	v3.1q, v3.2d, v5.2d
	eor	v2.16b, v2.16b, v3.16b
	#   Reduce
	ext	v3.16b, v0.16b, v1.16b, #8
	pmull2	v1.1q, v1.2d, v7.2d
	eor3	v3.16b, v3.16b, v1.16b, v2.16b
	pmull2	v2.1q, v3.2d, v7.2d
	mov	v0.d[1], v3.d[0]
	eor	v6.16b, v0.16b, v2.16b
	# Done GHASH
	st1	{v6.2d}, [x1]
	ldp	d8, d9, [x29, #16]
	ldp	x29, x30, [sp], #32
	ret
#ifndef __APPLE__
	.size	AES_GCM_ghash_block_AARCH64_EOR3,.-AES_GCM_ghash_block_AARCH64_EOR3
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	AES_GCM_aad_update_AARCH64_EOR3
.type	AES_GCM_aad_update_AARCH64_EOR3,@function
.align	2
AES_GCM_aad_update_AARCH64_EOR3:
#else
.section	__TEXT,__text
.globl	_AES_GCM_aad_update_AARCH64_EOR3
.p2align	2
_AES_GCM_aad_update_AARCH64_EOR3:
#endif /* __APPLE__ */
	stp	x29, x30, [sp, #-80]!
	add	x29, sp, #0
	stp	d8, d9, [x29, #16]
	stp	d10, d11, [x29, #32]
	stp	d12, d13, [x29, #48]
	stp	d14, d15, [x29, #64]
	ld1	{v20.2d}, [x2]
	movi	v21.16b, #0x87
	ld1	{v12.2d}, [x3]
	ushr	v21.2d, v21.2d, #56
	cmp	x1, #0x40
	blt	L_aes_gcm_aad_update_arm64_crypto_eor3_h_done
	# Square H => H^2
	pmull2	v11.1q, v12.2d, v12.2d
	pmull	v10.1q, v12.1d, v12.1d
	pmull2	v8.1q, v11.2d, v21.2d
	ext	v9.16b, v10.16b, v11.16b, #8
	eor	v9.16b, v9.16b, v8.16b
	pmull2	v11.1q, v9.2d, v21.2d
	mov	v10.d[1], v9.d[0]
	eor	v13.16b, v10.16b, v11.16b
	cmp	x1, #0x100
	blt	L_aes_gcm_aad_update_arm64_crypto_eor3_h_done
	# Multiply H and H^2  => H^3
	pmull	v8.1q, v12.1d, v13.1d
	pmull2	v9.1q, v12.2d, v13.2d
	ext	v11.16b, v12.16b, v12.16b, #8
	pmull	v10.1q, v11.1d, v13.1d
	pmull2	v11.1q, v11.2d, v13.2d
	eor	v10.16b, v10.16b, v11.16b
	#   Reduce
	ext	v11.16b, v8.16b, v9.16b, #8
	pmull2	v9.1q, v9.2d, v21.2d
	eor3	v11.16b, v11.16b, v9.16b, v10.16b
	pmull2	v10.1q, v11.2d, v21.2d
	mov	v8.d[1], v11.d[0]
	eor	v14.16b, v8.16b, v10.16b
	# Square H^2 => H^4
	pmull2	v11.1q, v13.2d, v13.2d
	pmull	v10.1q, v13.1d, v13.1d
	pmull2	v8.1q, v11.2d, v21.2d
	ext	v9.16b, v10.16b, v11.16b, #8
	eor	v9.16b, v9.16b, v8.16b
	pmull2	v11.1q, v9.2d, v21.2d
	mov	v10.d[1], v9.d[0]
	eor	v15.16b, v10.16b, v11.16b
	# Done
	cmp	x1, #0x400
	blt	L_aes_gcm_aad_update_arm64_crypto_eor3_h_done
	# Multiply H and H^4  => H^5
	pmull	v8.1q, v12.1d, v15.1d
	pmull2	v9.1q, v12.2d, v15.2d
	ext	v11.16b, v12.16b, v12.16b, #8
	pmull	v10.1q, v11.1d, v15.1d
	pmull2	v11.1q, v11.2d, v15.2d
	eor	v10.16b, v10.16b, v11.16b
	#   Reduce
	ext	v11.16b, v8.16b, v9.16b, #8
	pmull2	v9.1q, v9.2d, v21.2d
	eor3	v11.16b, v11.16b, v9.16b, v10.16b
	pmull2	v10.1q, v11.2d, v21.2d
	mov	v8.d[1], v11.d[0]
	eor	v16.16b, v8.16b, v10.16b
	# Square H^3 => H^6
	pmull2	v11.1q, v14.2d, v14.2d
	pmull	v10.1q, v14.1d, v14.1d
	pmull2	v8.1q, v11.2d, v21.2d
	ext	v9.16b, v10.16b, v11.16b, #8
	eor	v9.16b, v9.16b, v8.16b
	pmull2	v11.1q, v9.2d, v21.2d
	mov	v10.d[1], v9.d[0]
	eor	v17.16b, v10.16b, v11.16b
	# Multiply H and H^6  => H^7
	pmull	v8.1q, v12.1d, v17.1d
	pmull2	v9.1q, v12.2d, v17.2d
	ext	v11.16b, v12.16b, v12.16b, #8
	pmull	v10.1q, v11.1d, v17.1d
	pmull2	v11.1q, v11.2d, v17.2d
	eor	v10.16b, v10.16b, v11.16b
	#   Reduce
	ext	v11.16b, v8.16b, v9.16b, #8
	pmull2	v9.1q, v9.2d, v21.2d
	eor3	v11.16b, v11.16b, v9.16b, v10.16b
	pmull2	v10.1q, v11.2d, v21.2d
	mov	v8.d[1], v11.d[0]
	eor	v18.16b, v8.16b, v10.16b
	# Square H^4 => H^8
	pmull2	v11.1q, v15.2d, v15.2d
	pmull	v10.1q, v15.1d, v15.1d
	pmull2	v8.1q, v11.2d, v21.2d
	ext	v9.16b, v10.16b, v11.16b, #8
	eor	v9.16b, v9.16b, v8.16b
	pmull2	v11.1q, v9.2d, v21.2d
	mov	v10.d[1], v9.d[0]
	eor	v19.16b, v10.16b, v11.16b
	# Done
L_aes_gcm_aad_update_arm64_crypto_eor3_h_done:
	lsr	x1, x1, #4
	cmp	x1, #4
	blt	L_aes_gcm_aad_update_arm64_crypto_eor3_start_1
	cmp	x1, #16
	blt	L_aes_gcm_aad_update_arm64_crypto_eor3_start_2
	cmp	x1, #0x40
	blt	L_aes_gcm_aad_update_arm64_crypto_eor3_start_4
L_aes_gcm_aad_update_arm64_crypto_eor3_start_8:
	ld1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x0], #0x40
	ld1	{v4.16b, v5.16b, v6.16b, v7.16b}, [x0], #0x40
	rbit	v0.16b, v0.16b
	rbit	v1.16b, v1.16b
	rbit	v2.16b, v2.16b
	rbit	v3.16b, v3.16b
	rbit	v4.16b, v4.16b
	rbit	v5.16b, v5.16b
	rbit	v6.16b, v6.16b
	rbit	v7.16b, v7.16b
	eor	v0.16b, v0.16b, v20.16b
	#   X  = C * H^1
	pmull	v8.1q, v7.1d, v12.1d
	pmull2	v9.1q, v7.2d, v12.2d
	ext	v11.16b, v7.16b, v7.16b, #8
	pmull	v10.1q, v11.1d, v12.1d
	pmull2	v11.1q, v11.2d, v12.2d
	eor	v10.16b, v10.16b, v11.16b
	#   X += C * H^2
	pmull	v11.1q, v13.1d, v6.1d
	pmull2	v20.1q, v13.2d, v6.2d
	eor	v8.16b, v8.16b, v11.16b
	eor	v9.16b, v9.16b, v20.16b
	ext	v20.16b, v6.16b, v6.16b, #8
	pmull	v11.1q, v20.1d, v13.1d
	pmull2	v20.1q, v20.2d, v13.2d
	eor3	v10.16b, v10.16b, v20.16b, v11.16b
	#   X += C * H^3
	pmull	v11.1q, v14.1d, v5.1d
	pmull2	v20.1q, v14.2d, v5.2d
	eor	v8.16b, v8.16b, v11.16b
	eor	v9.16b, v9.16b, v20.16b
	ext	v20.16b, v5.16b, v5.16b, #8
	pmull	v11.1q, v20.1d, v14.1d
	pmull2	v20.1q, v20.2d, v14.2d
	eor3	v10.16b, v10.16b, v20.16b, v11.16b
	#   X += C * H^4
	pmull	v11.1q, v15.1d, v4.1d
	pmull2	v20.1q, v15.2d, v4.2d
	eor	v8.16b, v8.16b, v11.16b
	eor	v9.16b, v9.16b, v20.16b
	ext	v20.16b, v4.16b, v4.16b, #8
	pmull	v11.1q, v20.1d, v15.1d
	pmull2	v20.1q, v20.2d, v15.2d
	eor3	v10.16b, v10.16b, v20.16b, v11.16b
	#   X += C * H^5
	pmull	v11.1q, v16.1d, v3.1d
	pmull2	v20.1q, v16.2d, v3.2d
	eor	v8.16b, v8.16b, v11.16b
	eor	v9.16b, v9.16b, v20.16b
	ext	v20.16b, v3.16b, v3.16b, #8
	pmull	v11.1q, v20.1d, v16.1d
	pmull2	v20.1q, v20.2d, v16.2d
	eor3	v10.16b, v10.16b, v20.16b, v11.16b
	#   X += C * H^6
	pmull	v11.1q, v17.1d, v2.1d
	pmull2	v20.1q, v17.2d, v2.2d
	eor	v8.16b, v8.16b, v11.16b
	eor	v9.16b, v9.16b, v20.16b
	ext	v20.16b, v2.16b, v2.16b, #8
	pmull	v11.1q, v20.1d, v17.1d
	pmull2	v20.1q, v20.2d, v17.2d
	eor3	v10.16b, v10.16b, v20.16b, v11.16b
	#   X += C * H^7
	pmull	v11.1q, v18.1d, v1.1d
	pmull2	v20.1q, v18.2d, v1.2d
	eor	v8.16b, v8.16b, v11.16b
	eor	v9.16b, v9.16b, v20.16b
	ext	v20.16b, v1.16b, v1.16b, #8
	pmull	v11.1q, v20.1d, v18.1d
	pmull2	v20.1q, v20.2d, v18.2d
	eor3	v10.16b, v10.16b, v20.16b, v11.16b
	#   X += C * H^8
	pmull	v11.1q, v19.1d, v0.1d
	pmull2	v20.1q, v19.2d, v0.2d
	eor	v8.16b, v8.16b, v11.16b
	eor	v9.16b, v9.16b, v20.16b
	ext	v20.16b, v0.16b, v0.16b, #8
	pmull	v11.1q, v20.1d, v19.1d
	pmull2	v20.1q, v20.2d, v19.2d
	eor3	v10.16b, v10.16b, v20.16b, v11.16b
	#   Reduce
	ext	v11.16b, v8.16b, v9.16b, #8
	pmull2	v9.1q, v9.2d, v21.2d
	eor3	v11.16b, v11.16b, v9.16b, v10.16b
	pmull2	v10.1q, v11.2d, v21.2d
	mov	v8.d[1], v11.d[0]
	eor	v20.16b, v8.16b, v10.16b
	# Done GHASH
	sub	x1, x1, #8
	cmp	x1, #8
	bge	L_aes_gcm_aad_update_arm64_crypto_eor3_start_8
	cmp	x1, #1
	blt	L_aes_gcm_aad_update_arm64_crypto_eor3_done
	beq	L_aes_gcm_aad_update_arm64_crypto_eor3_start_1
	cmp	x1, #16
	blt	L_aes_gcm_aad_update_arm64_crypto_eor3_start_2
L_aes_gcm_aad_update_arm64_crypto_eor3_start_4:
	ld1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x0], #0x40
	rbit	v0.16b, v0.16b
	rbit	v1.16b, v1.16b
	rbit	v2.16b, v2.16b
	rbit	v3.16b, v3.16b
	eor	v0.16b, v0.16b, v20.16b
	#   X  = C * H^1
	pmull	v8.1q, v3.1d, v12.1d
	pmull2	v9.1q, v3.2d, v12.2d
	ext	v11.16b, v3.16b, v3.16b, #8
	pmull	v10.1q, v11.1d, v12.1d
	pmull2	v11.1q, v11.2d, v12.2d
	eor	v10.16b, v10.16b, v11.16b
	#   X += C * H^2
	pmull	v11.1q, v13.1d, v2.1d
	pmull2	v20.1q, v13.2d, v2.2d
	eor	v8.16b, v8.16b, v11.16b
	eor	v9.16b, v9.16b, v20.16b
	ext	v20.16b, v2.16b, v2.16b, #8
	pmull	v11.1q, v20.1d, v13.1d
	pmull2	v20.1q, v20.2d, v13.2d
	eor3	v10.16b, v10.16b, v20.16b, v11.16b
	#   X += C * H^3
	pmull	v11.1q, v14.1d, v1.1d
	pmull2	v20.1q, v14.2d, v1.2d
	eor	v8.16b, v8.16b, v11.16b
	eor	v9.16b, v9.16b, v20.16b
	ext	v20.16b, v1.16b, v1.16b, #8
	pmull	v11.1q, v20.1d, v14.1d
	pmull2	v20.1q, v20.2d, v14.2d
	eor3	v10.16b, v10.16b, v20.16b, v11.16b
	#   X += C * H^4
	pmull	v11.1q, v15.1d, v0.1d
	pmull2	v20.1q, v15.2d, v0.2d
	eor	v8.16b, v8.16b, v11.16b
	eor	v9.16b, v9.16b, v20.16b
	ext	v20.16b, v0.16b, v0.16b, #8
	pmull	v11.1q, v20.1d, v15.1d
	pmull2	v20.1q, v20.2d, v15.2d
	eor3	v10.16b, v10.16b, v20.16b, v11.16b
	#   Reduce
	ext	v11.16b, v8.16b, v9.16b, #8
	pmull2	v9.1q, v9.2d, v21.2d
	eor3	v11.16b, v11.16b, v9.16b, v10.16b
	pmull2	v10.1q, v11.2d, v21.2d
	mov	v8.d[1], v11.d[0]
	eor	v20.16b, v8.16b, v10.16b
	# Done GHASH
	sub	x1, x1, #4
	cmp	x1, #4
	bge	L_aes_gcm_aad_update_arm64_crypto_eor3_start_4
	cmp	x1, #1
	blt	L_aes_gcm_aad_update_arm64_crypto_eor3_done
	beq	L_aes_gcm_aad_update_arm64_crypto_eor3_start_1
L_aes_gcm_aad_update_arm64_crypto_eor3_start_2:
	ld1	{v0.16b, v1.16b}, [x0], #32
	rbit	v0.16b, v0.16b
	rbit	v1.16b, v1.16b
	eor	v3.16b, v20.16b, v0.16b
	#   X  = C * H^1
	pmull	v8.1q, v1.1d, v12.1d
	pmull2	v9.1q, v1.2d, v12.2d
	ext	v11.16b, v1.16b, v1.16b, #8
	pmull	v10.1q, v11.1d, v12.1d
	pmull2	v11.1q, v11.2d, v12.2d
	eor	v10.16b, v10.16b, v11.16b
	#   X += C * H^2
	pmull	v11.1q, v13.1d, v3.1d
	pmull2	v20.1q, v13.2d, v3.2d
	eor	v8.16b, v8.16b, v11.16b
	eor	v9.16b, v9.16b, v20.16b
	ext	v20.16b, v3.16b, v3.16b, #8
	pmull	v11.1q, v20.1d, v13.1d
	pmull2	v20.1q, v20.2d, v13.2d
	eor3	v10.16b, v10.16b, v20.16b, v11.16b
	#   Reduce
	ext	v11.16b, v8.16b, v9.16b, #8
	pmull2	v9.1q, v9.2d, v21.2d
	eor3	v11.16b, v11.16b, v9.16b, v10.16b
	pmull2	v10.1q, v11.2d, v21.2d
	mov	v8.d[1], v11.d[0]
	eor	v20.16b, v8.16b, v10.16b
	# Done GHASH
	sub	x1, x1, #2
	cmp	x1, #1
	bgt	L_aes_gcm_aad_update_arm64_crypto_eor3_start_2
	blt	L_aes_gcm_aad_update_arm64_crypto_eor3_done
L_aes_gcm_aad_update_arm64_crypto_eor3_start_1:
	cbz	x1, L_aes_gcm_aad_update_arm64_crypto_eor3_done
L_aes_gcm_aad_update_arm64_crypto_eor3_both_1:
	ld1	{v0.16b}, [x0], #16
	rbit	v0.16b, v0.16b
	eor	v3.16b, v20.16b, v0.16b
	#   X  = C * H^1
	pmull	v8.1q, v3.1d, v12.1d
	pmull2	v9.1q, v3.2d, v12.2d
	ext	v11.16b, v3.16b, v3.16b, #8
	pmull	v10.1q, v11.1d, v12.1d
	pmull2	v11.1q, v11.2d, v12.2d
	eor	v10.16b, v10.16b, v11.16b
	#   Reduce
	ext	v11.16b, v8.16b, v9.16b, #8
	pmull2	v9.1q, v9.2d, v21.2d
	eor3	v11.16b, v11.16b, v9.16b, v10.16b
	pmull2	v10.1q, v11.2d, v21.2d
	mov	v8.d[1], v11.d[0]
	eor	v20.16b, v8.16b, v10.16b
	# Done GHASH
	subs	x1, x1, #1
	bne	L_aes_gcm_aad_update_arm64_crypto_eor3_both_1
L_aes_gcm_aad_update_arm64_crypto_eor3_done:
	st1	{v20.2d}, [x2]
	ldp	d8, d9, [x29, #16]
	ldp	d10, d11, [x29, #32]
	ldp	d12, d13, [x29, #48]
	ldp	d14, d15, [x29, #64]
	ldp	x29, x30, [sp], #0x50
	ret
#ifndef __APPLE__
	.size	AES_GCM_aad_update_AARCH64_EOR3,.-AES_GCM_aad_update_AARCH64_EOR3
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	AES_GCM_encrypt_block_AARCH64_EOR3
.type	AES_GCM_encrypt_block_AARCH64_EOR3,@function
.align	2
AES_GCM_encrypt_block_AARCH64_EOR3:
#else
.section	__TEXT,__text
.globl	_AES_GCM_encrypt_block_AARCH64_EOR3
.p2align	2
_AES_GCM_encrypt_block_AARCH64_EOR3:
#endif /* __APPLE__ */
	ld1	{v5.2d}, [x4]
	ld1	{v4.2d}, [x3]
	mov	w5, v5.s[3]
	rev	w5, w5
	add	w5, w5, #1
	rev	w5, w5
	mov	v5.s[3], w5
	st1	{v5.2d}, [x4]
	ld1	{v0.2d, v1.2d, v2.2d, v3.2d}, [x0], #0x40
	aese	v5.16b, v0.16b
	aesmc	v5.16b, v5.16b
	aese	v5.16b, v1.16b
	aesmc	v5.16b, v5.16b
	aese	v5.16b, v2.16b
	aesmc	v5.16b, v5.16b
	aese	v5.16b, v3.16b
	aesmc	v5.16b, v5.16b
	ld1	{v0.2d, v1.2d, v2.2d, v3.2d}, [x0], #0x40
	aese	v5.16b, v0.16b
	aesmc	v5.16b, v5.16b
	aese	v5.16b, v1.16b
	aesmc	v5.16b, v5.16b
	aese	v5.16b, v2.16b
	aesmc	v5.16b, v5.16b
	aese	v5.16b, v3.16b
	aesmc	v5.16b, v5.16b
	subs	w1, w1, #10
	ld1	{v0.2d, v1.2d}, [x0], #32
	aese	v5.16b, v0.16b
	aesmc	v5.16b, v5.16b
	aese	v5.16b, v1.16b
	beq	L_aes_gcm_encrypt_block_arm64_crypto_eor3_round_done
	ld1	{v0.2d, v1.2d}, [x0], #32
	subs	w1, w1, #2
	aesmc	v5.16b, v5.16b
	aese	v5.16b, v0.16b
	aesmc	v5.16b, v5.16b
	aese	v5.16b, v1.16b
	beq	L_aes_gcm_encrypt_block_arm64_crypto_eor3_round_done
	ld1	{v0.2d, v1.2d}, [x0], #32
	aesmc	v5.16b, v5.16b
	aese	v5.16b, v0.16b
	aesmc	v5.16b, v5.16b
	aese	v5.16b, v1.16b
L_aes_gcm_encrypt_block_arm64_crypto_eor3_round_done:
	ld1	{v0.2d}, [x0]
	eor	v5.16b, v5.16b, v0.16b
	eor	v4.16b, v4.16b, v5.16b
	st1	{v4.2d}, [x2]
	ret
#ifndef __APPLE__
	.size	AES_GCM_encrypt_block_AARCH64_EOR3,.-AES_GCM_encrypt_block_AARCH64_EOR3
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	AES_GCM_encrypt_update_AARCH64_EOR3
.type	AES_GCM_encrypt_update_AARCH64_EOR3,@function
.align	2
AES_GCM_encrypt_update_AARCH64_EOR3:
#else
.section	__TEXT,__text
.globl	_AES_GCM_encrypt_update_AARCH64_EOR3
.p2align	2
_AES_GCM_encrypt_update_AARCH64_EOR3:
#endif /* __APPLE__ */
	stp	x29, x30, [sp, #-96]!
	add	x29, sp, #0
	str	x17, [x29, #24]
	stp	d8, d9, [x29, #32]
	stp	d10, d11, [x29, #48]
	stp	d12, d13, [x29, #64]
	stp	d14, d15, [x29, #80]
	ld1	{v13.2d}, [x7]
	movi	v27.16b, #0x87
	ld1	{v26.2d}, [x5]
	ushr	v27.2d, v27.2d, #56
	ld1	{v22.2d}, [x6]
	mov	w9, v13.s[3]
	rev	w9, w9
	cmp	w4, #32
	blt	L_aes_gcm_encrypt_update_arm64_crypto_eor3_h_done
	# Square H => H^2
	pmull2	v31.1q, v22.2d, v22.2d
	pmull	v30.1q, v22.1d, v22.1d
	pmull2	v28.1q, v31.2d, v27.2d
	ext	v29.16b, v30.16b, v31.16b, #8
	eor	v29.16b, v29.16b, v28.16b
	pmull2	v31.1q, v29.2d, v27.2d
	mov	v30.d[1], v29.d[0]
	eor	v23.16b, v30.16b, v31.16b
	cmp	w4, #0x40
	blt	L_aes_gcm_encrypt_update_arm64_crypto_eor3_h_done
	# Multiply H and H^2  => H^3
	pmull	v28.1q, v22.1d, v23.1d
	pmull2	v29.1q, v22.2d, v23.2d
	ext	v31.16b, v22.16b, v22.16b, #8
	pmull	v30.1q, v31.1d, v23.1d
	pmull2	v31.1q, v31.2d, v23.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v24.16b, v28.16b, v30.16b
	# Square H^2 => H^4
	pmull2	v31.1q, v23.2d, v23.2d
	pmull	v30.1q, v23.1d, v23.1d
	pmull2	v28.1q, v31.2d, v27.2d
	ext	v29.16b, v30.16b, v31.16b, #8
	eor	v29.16b, v29.16b, v28.16b
	pmull2	v31.1q, v29.2d, v27.2d
	mov	v30.d[1], v29.d[0]
	eor	v25.16b, v30.16b, v31.16b
	# Done
	cmp	w4, #0x200
	blt	L_aes_gcm_encrypt_update_arm64_crypto_eor3_h_done
	# Multiply H and H^4  => H^5
	pmull	v28.1q, v22.1d, v25.1d
	pmull2	v29.1q, v22.2d, v25.2d
	ext	v31.16b, v22.16b, v22.16b, #8
	pmull	v30.1q, v31.1d, v25.1d
	pmull2	v31.1q, v31.2d, v25.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v4.16b, v28.16b, v30.16b
	# Square H^3 => H^6
	pmull2	v31.1q, v24.2d, v24.2d
	pmull	v30.1q, v24.1d, v24.1d
	pmull2	v28.1q, v31.2d, v27.2d
	ext	v29.16b, v30.16b, v31.16b, #8
	eor	v29.16b, v29.16b, v28.16b
	pmull2	v31.1q, v29.2d, v27.2d
	mov	v30.d[1], v29.d[0]
	eor	v5.16b, v30.16b, v31.16b
	# Multiply H and H^6  => H^7
	pmull	v28.1q, v22.1d, v5.1d
	pmull2	v29.1q, v22.2d, v5.2d
	ext	v31.16b, v22.16b, v22.16b, #8
	pmull	v30.1q, v31.1d, v5.1d
	pmull2	v31.1q, v31.2d, v5.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v6.16b, v28.16b, v30.16b
	# Square H^4 => H^8
	pmull2	v31.1q, v25.2d, v25.2d
	pmull	v30.1q, v25.1d, v25.1d
	pmull2	v28.1q, v31.2d, v27.2d
	ext	v29.16b, v30.16b, v31.16b, #8
	eor	v29.16b, v29.16b, v28.16b
	pmull2	v31.1q, v29.2d, v27.2d
	mov	v30.d[1], v29.d[0]
	eor	v7.16b, v30.16b, v31.16b
	# Done
L_aes_gcm_encrypt_update_arm64_crypto_eor3_h_done:
	lsr	w8, w4, #4
	cmp	x1, #12
	blt	L_aes_gcm_encrypt_update_arm64_crypto_eor3_start_128
	bgt	L_aes_gcm_encrypt_update_arm64_crypto_eor3_start_256
	# AES_GCM_192
#ifndef NO_AES_192
	cmp	w8, #32
	blt	L_aes_gcm_encrypt_update_arm64_crypto_eor3_192_start_4
L_aes_gcm_encrypt_update_arm64_crypto_eor3_192_start_8:
	ldr	q12, [x0]
	add	w17, w9, #1
	mov	v14.16b, v13.16b
	add	w16, w9, #2
	mov	v15.16b, v13.16b
	add	w15, w9, #3
	mov	v16.16b, v13.16b
	add	w14, w9, #4
	mov	v17.16b, v13.16b
	add	w13, w9, #5
	mov	v8.16b, v13.16b
	add	w12, w9, #6
	mov	v9.16b, v13.16b
	add	w11, w9, #7
	mov	v10.16b, v13.16b
	add	w9, w9, #8
	mov	v11.16b, v13.16b
	rev	w17, w17
	rev	w16, w16
	rev	w15, w15
	rev	w14, w14
	rev	w13, w13
	rev	w12, w12
	rev	w11, w11
	rev	w10, w9
	mov	v14.s[3], w17
	mov	v15.s[3], w16
	mov	v16.s[3], w15
	mov	v17.s[3], w14
	mov	v8.s[3], w13
	mov	v9.s[3], w12
	mov	v10.s[3], w11
	mov	v11.s[3], w10
	ldr	q13, [x0, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w8, w8, #8
	ldr	q12, [x0, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b}, [x3], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v19.16b}, [x3], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v20.16b}, [x3], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ld1	{v21.16b}, [x3], #16
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #160]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	ld1	{v0.16b}, [x3], #16
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ld1	{v1.16b}, [x3], #16
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v2.16b}, [x3], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ld1	{v3.16b}, [x3], #16
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #176]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #192]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	eor	v0.16b, v0.16b, v8.16b
	eor	v1.16b, v1.16b, v9.16b
	eor	v2.16b, v2.16b, v10.16b
	eor	v3.16b, v3.16b, v11.16b
	ld1	{v13.2d}, [x7]
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x2], #0x40
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x2], #0x40
	cmp	w8, #8
	blt	L_aes_gcm_encrypt_update_arm64_crypto_eor3_192_end_8
L_aes_gcm_encrypt_update_arm64_crypto_eor3_192_both_8:
	ldr	q12, [x0]
	add	w17, w9, #1
	mov	v14.16b, v13.16b
	add	w16, w9, #2
	mov	v15.16b, v13.16b
	add	w15, w9, #3
	mov	v16.16b, v13.16b
	add	w14, w9, #4
	mov	v17.16b, v13.16b
	add	w13, w9, #5
	mov	v8.16b, v13.16b
	add	w12, w9, #6
	mov	v9.16b, v13.16b
	add	w11, w9, #7
	mov	v10.16b, v13.16b
	add	w9, w9, #8
	mov	v11.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w17, w17
	rbit	v19.16b, v19.16b
	rev	w16, w16
	rbit	v20.16b, v20.16b
	rev	w15, w15
	rbit	v21.16b, v21.16b
	rev	w14, w14
	rbit	v0.16b, v0.16b
	rev	w13, w13
	rbit	v1.16b, v1.16b
	rev	w12, w12
	rbit	v2.16b, v2.16b
	rev	w11, w11
	rbit	v3.16b, v3.16b
	rev	w10, w9
	mov	v14.s[3], w17
	mov	v15.s[3], w16
	mov	v16.s[3], w15
	mov	v17.s[3], w14
	mov	v8.s[3], w13
	mov	v9.s[3], w12
	mov	v10.s[3], w11
	mov	v11.s[3], w10
	ldr	q13, [x0, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v18.16b, v18.16b, v26.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ext	v31.16b, v3.16b, v3.16b, #8
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w8, w8, #8
	ldr	q12, [x0, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	mov	v28.d[1], v31.d[0]
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v28.16b, v30.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	# Done GHASH
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v18.16b}, [x3], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ld1	{v19.16b}, [x3], #16
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ld1	{v20.16b}, [x3], #16
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ld1	{v21.16b}, [x3], #16
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v0.16b}, [x3], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v1.16b}, [x3], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v2.16b}, [x3], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ld1	{v3.16b}, [x3], #16
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #160]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #176]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #192]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	ld1	{v13.2d}, [x7]
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x2], #0x40
	eor	v0.16b, v0.16b, v8.16b
	eor	v1.16b, v1.16b, v9.16b
	eor	v2.16b, v2.16b, v10.16b
	eor	v3.16b, v3.16b, v11.16b
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x2], #0x40
	cmp	w8, #8
	bge	L_aes_gcm_encrypt_update_arm64_crypto_eor3_192_both_8
L_aes_gcm_encrypt_update_arm64_crypto_eor3_192_end_8:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	rbit	v0.16b, v0.16b
	rbit	v1.16b, v1.16b
	rbit	v2.16b, v2.16b
	rbit	v3.16b, v3.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	ext	v31.16b, v3.16b, v3.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_encrypt_update_arm64_crypto_eor3_192_start_4:
	ld1	{v0.2d, v1.2d, v2.2d, v3.2d}, [x0], #0x40
	ld1	{v4.2d, v5.2d, v6.2d, v7.2d}, [x0], #0x40
	ld1	{v8.2d, v9.2d, v10.2d, v11.2d}, [x0], #0x40
	ld1	{v12.2d}, [x0]
	cmp	w8, #1
	blt	L_aes_gcm_encrypt_update_arm64_crypto_eor3_192_done
	beq	L_aes_gcm_encrypt_update_arm64_crypto_eor3_192_start_1
	cmp	w8, #4
	blt	L_aes_gcm_encrypt_update_arm64_crypto_eor3_192_start_2
	add	w13, w9, #1
	mov	v14.16b, v13.16b
	add	w12, w9, #2
	mov	v15.16b, v13.16b
	add	w11, w9, #3
	mov	v16.16b, v13.16b
	add	w9, w9, #4
	mov	v17.16b, v13.16b
	rev	w13, w13
	rev	w12, w12
	rev	w11, w11
	rev	w10, w9
	mov	v14.s[3], w13
	mov	v15.s[3], w12
	mov	v16.s[3], w11
	mov	v17.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w8, w8, #4
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x3], #16
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	ld1	{v19.16b}, [x3], #16
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	ld1	{v20.16b}, [x3], #16
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	ld1	{v21.16b}, [x3], #16
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v11.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v11.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v11.16b
	eor	v17.16b, v17.16b, v12.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	cmp	w8, #4
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x2], #0x40
	blt	L_aes_gcm_encrypt_update_arm64_crypto_eor3_192_end_4
L_aes_gcm_encrypt_update_arm64_crypto_eor3_192_both_4:
	add	w13, w9, #1
	mov	v14.16b, v13.16b
	add	w12, w9, #2
	mov	v15.16b, v13.16b
	add	w11, w9, #3
	mov	v16.16b, v13.16b
	add	w9, w9, #4
	mov	v17.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w13, w13
	rev	w12, w12
	rev	w11, w11
	rbit	v19.16b, v19.16b
	rev	w10, w9
	mov	v14.s[3], w13
	mov	v15.s[3], w12
	mov	v16.s[3], w11
	mov	v17.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	rbit	v20.16b, v20.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	rbit	v21.16b, v21.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	eor	v18.16b, v18.16b, v26.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	ext	v31.16b, v21.16b, v21.16b, #8
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w8, w8, #4
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	mov	v28.d[1], v31.d[0]
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	eor	v26.16b, v28.16b, v30.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	# Done GHASH
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x3], #0x40
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v11.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v11.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v11.16b
	eor	v17.16b, v17.16b, v12.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	cmp	w8, #4
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x2], #0x40
	bge	L_aes_gcm_encrypt_update_arm64_crypto_eor3_192_both_4
L_aes_gcm_encrypt_update_arm64_crypto_eor3_192_end_4:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cmp	w8, #1
	beq	L_aes_gcm_encrypt_update_arm64_crypto_eor3_192_start_1
	blt	L_aes_gcm_encrypt_update_arm64_crypto_eor3_192_done
L_aes_gcm_encrypt_update_arm64_crypto_eor3_192_start_2:
	add	w13, w9, #1
	mov	v14.16b, v13.16b
	add	w9, w9, #2
	mov	v15.16b, v13.16b
	rev	w13, w13
	rev	w10, w9
	mov	v14.s[3], w13
	mov	v15.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	subs	w8, w8, #2
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x3], #16
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	ld1	{v19.16b}, [x3], #16
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v11.16b
	eor	v15.16b, v15.16b, v12.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	st1	{v18.16b, v19.16b}, [x2], #32
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v19.1d, v22.1d
	pmull2	v29.1q, v19.2d, v22.2d
	ext	v31.16b, v19.16b, v19.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v21.1d
	pmull2	v26.1q, v23.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cbz	w8, L_aes_gcm_encrypt_update_arm64_crypto_eor3_192_done
L_aes_gcm_encrypt_update_arm64_crypto_eor3_192_start_1:
	add	w9, w9, #1
	mov	v14.16b, v13.16b
	rev	w10, w9
	mov	v14.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x3], #16
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	eor	v18.16b, v18.16b, v14.16b
	st1	{v18.16b}, [x2], #16
	rbit	v18.16b, v18.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_encrypt_update_arm64_crypto_eor3_192_done:
#endif /* !NO_AES_192 */
	b	L_aes_gcm_encrypt_update_arm64_crypto_eor3_done
	# AES_GCM_256
L_aes_gcm_encrypt_update_arm64_crypto_eor3_start_256:
#ifndef NO_AES_256
	cmp	w8, #32
	blt	L_aes_gcm_encrypt_update_arm64_crypto_eor3_256_start_4
L_aes_gcm_encrypt_update_arm64_crypto_eor3_256_start_8:
	ldr	q12, [x0]
	add	w17, w9, #1
	mov	v14.16b, v13.16b
	add	w16, w9, #2
	mov	v15.16b, v13.16b
	add	w15, w9, #3
	mov	v16.16b, v13.16b
	add	w14, w9, #4
	mov	v17.16b, v13.16b
	add	w13, w9, #5
	mov	v8.16b, v13.16b
	add	w12, w9, #6
	mov	v9.16b, v13.16b
	add	w11, w9, #7
	mov	v10.16b, v13.16b
	add	w9, w9, #8
	mov	v11.16b, v13.16b
	rev	w17, w17
	rev	w16, w16
	rev	w15, w15
	rev	w14, w14
	rev	w13, w13
	rev	w12, w12
	rev	w11, w11
	rev	w10, w9
	mov	v14.s[3], w17
	mov	v15.s[3], w16
	mov	v16.s[3], w15
	mov	v17.s[3], w14
	mov	v8.s[3], w13
	mov	v9.s[3], w12
	mov	v10.s[3], w11
	mov	v11.s[3], w10
	ldr	q13, [x0, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w8, w8, #8
	ldr	q12, [x0, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b}, [x3], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v19.16b}, [x3], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v20.16b}, [x3], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ld1	{v21.16b}, [x3], #16
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #160]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	ld1	{v0.16b}, [x3], #16
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ld1	{v1.16b}, [x3], #16
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v2.16b}, [x3], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ld1	{v3.16b}, [x3], #16
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #176]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #192]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #208]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #224]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	eor	v0.16b, v0.16b, v8.16b
	eor	v1.16b, v1.16b, v9.16b
	eor	v2.16b, v2.16b, v10.16b
	eor	v3.16b, v3.16b, v11.16b
	ld1	{v13.2d}, [x7]
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x2], #0x40
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x2], #0x40
	cmp	w8, #8
	blt	L_aes_gcm_encrypt_update_arm64_crypto_eor3_256_end_8
L_aes_gcm_encrypt_update_arm64_crypto_eor3_256_both_8:
	ldr	q12, [x0]
	add	w17, w9, #1
	mov	v14.16b, v13.16b
	add	w16, w9, #2
	mov	v15.16b, v13.16b
	add	w15, w9, #3
	mov	v16.16b, v13.16b
	add	w14, w9, #4
	mov	v17.16b, v13.16b
	add	w13, w9, #5
	mov	v8.16b, v13.16b
	add	w12, w9, #6
	mov	v9.16b, v13.16b
	add	w11, w9, #7
	mov	v10.16b, v13.16b
	add	w9, w9, #8
	mov	v11.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w17, w17
	rbit	v19.16b, v19.16b
	rev	w16, w16
	rbit	v20.16b, v20.16b
	rev	w15, w15
	rbit	v21.16b, v21.16b
	rev	w14, w14
	rbit	v0.16b, v0.16b
	rev	w13, w13
	rbit	v1.16b, v1.16b
	rev	w12, w12
	rbit	v2.16b, v2.16b
	rev	w11, w11
	rbit	v3.16b, v3.16b
	rev	w10, w9
	mov	v14.s[3], w17
	mov	v15.s[3], w16
	mov	v16.s[3], w15
	mov	v17.s[3], w14
	mov	v8.s[3], w13
	mov	v9.s[3], w12
	mov	v10.s[3], w11
	mov	v11.s[3], w10
	ldr	q13, [x0, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v18.16b, v18.16b, v26.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ext	v31.16b, v3.16b, v3.16b, #8
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w8, w8, #8
	ldr	q12, [x0, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	mov	v28.d[1], v31.d[0]
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v28.16b, v30.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	# Done GHASH
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v18.16b}, [x3], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ld1	{v19.16b}, [x3], #16
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ld1	{v20.16b}, [x3], #16
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ld1	{v21.16b}, [x3], #16
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v0.16b}, [x3], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v1.16b}, [x3], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v2.16b}, [x3], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ld1	{v3.16b}, [x3], #16
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #160]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #176]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #192]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #208]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #224]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	ld1	{v13.2d}, [x7]
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x2], #0x40
	eor	v0.16b, v0.16b, v8.16b
	eor	v1.16b, v1.16b, v9.16b
	eor	v2.16b, v2.16b, v10.16b
	eor	v3.16b, v3.16b, v11.16b
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x2], #0x40
	cmp	w8, #8
	bge	L_aes_gcm_encrypt_update_arm64_crypto_eor3_256_both_8
L_aes_gcm_encrypt_update_arm64_crypto_eor3_256_end_8:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	rbit	v0.16b, v0.16b
	rbit	v1.16b, v1.16b
	rbit	v2.16b, v2.16b
	rbit	v3.16b, v3.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	ext	v31.16b, v3.16b, v3.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_encrypt_update_arm64_crypto_eor3_256_start_4:
	ld1	{v0.2d, v1.2d, v2.2d, v3.2d}, [x0], #0x40
	ld1	{v4.2d, v5.2d, v6.2d, v7.2d}, [x0], #0x40
	ld1	{v8.2d, v9.2d, v10.2d, v11.2d}, [x0], #0x40
	ld1	{v12.2d}, [x0], #16
	cmp	w8, #1
	blt	L_aes_gcm_encrypt_update_arm64_crypto_eor3_256_done
	beq	L_aes_gcm_encrypt_update_arm64_crypto_eor3_256_start_1
	cmp	w8, #4
	blt	L_aes_gcm_encrypt_update_arm64_crypto_eor3_256_start_2
	add	w13, w9, #1
	mov	v14.16b, v13.16b
	add	w12, w9, #2
	mov	v15.16b, v13.16b
	add	w11, w9, #3
	mov	v16.16b, v13.16b
	add	w9, w9, #4
	mov	v17.16b, v13.16b
	rev	w13, w13
	rev	w12, w12
	rev	w11, w11
	rev	w10, w9
	mov	v14.s[3], w13
	mov	v15.s[3], w12
	mov	v16.s[3], w11
	mov	v17.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w8, w8, #4
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x3], #16
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	ld1	{v19.16b}, [x3], #16
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	ld1	{v20.16b}, [x3], #16
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	ld1	{v21.16b}, [x3], #16
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v11.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v11.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v11.16b
	aesmc	v17.16b, v17.16b
	ld1	{v29.2d, v30.2d}, [x0]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	aese	v15.16b, v29.16b
	eor	v15.16b, v15.16b, v30.16b
	aese	v16.16b, v29.16b
	eor	v16.16b, v16.16b, v30.16b
	aese	v17.16b, v29.16b
	eor	v17.16b, v17.16b, v30.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	cmp	w8, #4
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x2], #0x40
	blt	L_aes_gcm_encrypt_update_arm64_crypto_eor3_256_end_4
L_aes_gcm_encrypt_update_arm64_crypto_eor3_256_both_4:
	add	w13, w9, #1
	mov	v14.16b, v13.16b
	add	w12, w9, #2
	mov	v15.16b, v13.16b
	add	w11, w9, #3
	mov	v16.16b, v13.16b
	add	w9, w9, #4
	mov	v17.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w13, w13
	rev	w12, w12
	rev	w11, w11
	rbit	v19.16b, v19.16b
	rev	w10, w9
	mov	v14.s[3], w13
	mov	v15.s[3], w12
	mov	v16.s[3], w11
	mov	v17.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	rbit	v20.16b, v20.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	rbit	v21.16b, v21.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	eor	v18.16b, v18.16b, v26.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	ext	v31.16b, v21.16b, v21.16b, #8
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w8, w8, #4
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	mov	v28.d[1], v31.d[0]
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	eor	v26.16b, v28.16b, v30.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	# Done GHASH
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x3], #0x40
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v11.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v11.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v11.16b
	aesmc	v17.16b, v17.16b
	ld1	{v29.2d, v30.2d}, [x0]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	aese	v15.16b, v29.16b
	eor	v15.16b, v15.16b, v30.16b
	aese	v16.16b, v29.16b
	eor	v16.16b, v16.16b, v30.16b
	aese	v17.16b, v29.16b
	eor	v17.16b, v17.16b, v30.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	cmp	w8, #4
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x2], #0x40
	bge	L_aes_gcm_encrypt_update_arm64_crypto_eor3_256_both_4
L_aes_gcm_encrypt_update_arm64_crypto_eor3_256_end_4:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cmp	w8, #1
	beq	L_aes_gcm_encrypt_update_arm64_crypto_eor3_256_start_1
	blt	L_aes_gcm_encrypt_update_arm64_crypto_eor3_256_done
L_aes_gcm_encrypt_update_arm64_crypto_eor3_256_start_2:
	add	w13, w9, #1
	mov	v14.16b, v13.16b
	add	w9, w9, #2
	mov	v15.16b, v13.16b
	rev	w13, w13
	rev	w10, w9
	mov	v14.s[3], w13
	mov	v15.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	subs	w8, w8, #2
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x3], #16
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	ld1	{v19.16b}, [x3], #16
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v11.16b
	aesmc	v15.16b, v15.16b
	ld1	{v29.2d, v30.2d}, [x0]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	aese	v15.16b, v29.16b
	eor	v15.16b, v15.16b, v30.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	st1	{v18.16b, v19.16b}, [x2], #32
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v19.1d, v22.1d
	pmull2	v29.1q, v19.2d, v22.2d
	ext	v31.16b, v19.16b, v19.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v21.1d
	pmull2	v26.1q, v23.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cbz	w8, L_aes_gcm_encrypt_update_arm64_crypto_eor3_256_done
L_aes_gcm_encrypt_update_arm64_crypto_eor3_256_start_1:
	add	w9, w9, #1
	mov	v14.16b, v13.16b
	rev	w10, w9
	mov	v14.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x3], #16
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	ldr	q29, [x0]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ldr	q30, [x0, #16]
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	eor	v18.16b, v18.16b, v14.16b
	st1	{v18.16b}, [x2], #16
	rbit	v18.16b, v18.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_encrypt_update_arm64_crypto_eor3_256_done:
#endif /* !NO_AES_256 */
	b	L_aes_gcm_encrypt_update_arm64_crypto_eor3_done
	# AES_GCM_128
L_aes_gcm_encrypt_update_arm64_crypto_eor3_start_128:
#ifndef NO_AES_128
	cmp	w8, #32
	blt	L_aes_gcm_encrypt_update_arm64_crypto_eor3_128_start_4
L_aes_gcm_encrypt_update_arm64_crypto_eor3_128_start_8:
	ldr	q12, [x0]
	add	w17, w9, #1
	mov	v14.16b, v13.16b
	add	w16, w9, #2
	mov	v15.16b, v13.16b
	add	w15, w9, #3
	mov	v16.16b, v13.16b
	add	w14, w9, #4
	mov	v17.16b, v13.16b
	add	w13, w9, #5
	mov	v8.16b, v13.16b
	add	w12, w9, #6
	mov	v9.16b, v13.16b
	add	w11, w9, #7
	mov	v10.16b, v13.16b
	add	w9, w9, #8
	mov	v11.16b, v13.16b
	rev	w17, w17
	rev	w16, w16
	rev	w15, w15
	rev	w14, w14
	rev	w13, w13
	rev	w12, w12
	rev	w11, w11
	rev	w10, w9
	mov	v14.s[3], w17
	mov	v15.s[3], w16
	mov	v16.s[3], w15
	mov	v17.s[3], w14
	mov	v8.s[3], w13
	mov	v9.s[3], w12
	mov	v10.s[3], w11
	mov	v11.s[3], w10
	ldr	q13, [x0, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w8, w8, #8
	ldr	q12, [x0, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b}, [x3], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v19.16b}, [x3], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v20.16b}, [x3], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ld1	{v21.16b}, [x3], #16
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #160]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	ld1	{v0.16b}, [x3], #16
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	ld1	{v1.16b}, [x3], #16
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	ld1	{v2.16b}, [x3], #16
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	ld1	{v3.16b}, [x3], #16
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	eor	v0.16b, v0.16b, v8.16b
	eor	v1.16b, v1.16b, v9.16b
	eor	v2.16b, v2.16b, v10.16b
	eor	v3.16b, v3.16b, v11.16b
	ld1	{v13.2d}, [x7]
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x2], #0x40
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x2], #0x40
	cmp	w8, #8
	blt	L_aes_gcm_encrypt_update_arm64_crypto_eor3_128_end_8
L_aes_gcm_encrypt_update_arm64_crypto_eor3_128_both_8:
	ldr	q12, [x0]
	add	w17, w9, #1
	mov	v14.16b, v13.16b
	add	w16, w9, #2
	mov	v15.16b, v13.16b
	add	w15, w9, #3
	mov	v16.16b, v13.16b
	add	w14, w9, #4
	mov	v17.16b, v13.16b
	add	w13, w9, #5
	mov	v8.16b, v13.16b
	add	w12, w9, #6
	mov	v9.16b, v13.16b
	add	w11, w9, #7
	mov	v10.16b, v13.16b
	add	w9, w9, #8
	mov	v11.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w17, w17
	rbit	v19.16b, v19.16b
	rev	w16, w16
	rbit	v20.16b, v20.16b
	rev	w15, w15
	rbit	v21.16b, v21.16b
	rev	w14, w14
	rbit	v0.16b, v0.16b
	rev	w13, w13
	rbit	v1.16b, v1.16b
	rev	w12, w12
	rbit	v2.16b, v2.16b
	rev	w11, w11
	rbit	v3.16b, v3.16b
	rev	w10, w9
	mov	v14.s[3], w17
	mov	v15.s[3], w16
	mov	v16.s[3], w15
	mov	v17.s[3], w14
	mov	v8.s[3], w13
	mov	v9.s[3], w12
	mov	v10.s[3], w11
	mov	v11.s[3], w10
	ldr	q13, [x0, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v18.16b, v18.16b, v26.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ext	v31.16b, v3.16b, v3.16b, #8
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w8, w8, #8
	ldr	q12, [x0, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	mov	v28.d[1], v31.d[0]
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor	v26.16b, v28.16b, v30.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	# Done GHASH
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v18.16b}, [x3], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ld1	{v19.16b}, [x3], #16
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ld1	{v20.16b}, [x3], #16
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ld1	{v21.16b}, [x3], #16
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v0.16b}, [x3], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v1.16b}, [x3], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v2.16b}, [x3], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	ld1	{v3.16b}, [x3], #16
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #160]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	ld1	{v13.2d}, [x7]
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x2], #0x40
	eor	v0.16b, v0.16b, v8.16b
	eor	v1.16b, v1.16b, v9.16b
	eor	v2.16b, v2.16b, v10.16b
	eor	v3.16b, v3.16b, v11.16b
	st1	{v0.16b, v1.16b, v2.16b, v3.16b}, [x2], #0x40
	cmp	w8, #8
	bge	L_aes_gcm_encrypt_update_arm64_crypto_eor3_128_both_8
L_aes_gcm_encrypt_update_arm64_crypto_eor3_128_end_8:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	rbit	v0.16b, v0.16b
	rbit	v1.16b, v1.16b
	rbit	v2.16b, v2.16b
	rbit	v3.16b, v3.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	ext	v31.16b, v3.16b, v3.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_encrypt_update_arm64_crypto_eor3_128_start_4:
	ld1	{v0.2d, v1.2d, v2.2d, v3.2d}, [x0], #0x40
	ld1	{v4.2d, v5.2d, v6.2d, v7.2d}, [x0], #0x40
	ld1	{v8.2d, v9.2d}, [x0], #32
	ld1	{v10.2d}, [x0]
	cmp	w8, #1
	blt	L_aes_gcm_encrypt_update_arm64_crypto_eor3_128_done
	beq	L_aes_gcm_encrypt_update_arm64_crypto_eor3_128_start_1
	cmp	w8, #4
	blt	L_aes_gcm_encrypt_update_arm64_crypto_eor3_128_start_2
	add	w13, w9, #1
	mov	v14.16b, v13.16b
	add	w12, w9, #2
	mov	v15.16b, v13.16b
	add	w11, w9, #3
	mov	v16.16b, v13.16b
	add	w9, w9, #4
	mov	v17.16b, v13.16b
	rev	w13, w13
	rev	w12, w12
	rev	w11, w11
	rev	w10, w9
	mov	v14.s[3], w13
	mov	v15.s[3], w12
	mov	v16.s[3], w11
	mov	v17.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w8, w8, #4
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x3], #16
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	ld1	{v19.16b}, [x3], #16
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	ld1	{v20.16b}, [x3], #16
	aese	v15.16b, v9.16b
	eor	v15.16b, v15.16b, v10.16b
	ld1	{v21.16b}, [x3], #16
	aese	v16.16b, v9.16b
	eor	v16.16b, v16.16b, v10.16b
	aese	v17.16b, v9.16b
	eor	v17.16b, v17.16b, v10.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	cmp	w8, #4
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x2], #0x40
	blt	L_aes_gcm_encrypt_update_arm64_crypto_eor3_128_end_4
L_aes_gcm_encrypt_update_arm64_crypto_eor3_128_both_4:
	add	w13, w9, #1
	mov	v14.16b, v13.16b
	add	w12, w9, #2
	mov	v15.16b, v13.16b
	add	w11, w9, #3
	mov	v16.16b, v13.16b
	add	w9, w9, #4
	mov	v17.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w13, w13
	rev	w12, w12
	rev	w11, w11
	rbit	v19.16b, v19.16b
	rev	w10, w9
	mov	v14.s[3], w13
	mov	v15.s[3], w12
	mov	v16.s[3], w11
	mov	v17.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	rbit	v20.16b, v20.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	rbit	v21.16b, v21.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	eor	v18.16b, v18.16b, v26.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	ext	v31.16b, v21.16b, v21.16b, #8
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w8, w8, #4
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	mov	v28.d[1], v31.d[0]
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	eor	v26.16b, v28.16b, v30.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	# Done GHASH
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x3], #0x40
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	aese	v15.16b, v9.16b
	eor	v15.16b, v15.16b, v10.16b
	aese	v16.16b, v9.16b
	eor	v16.16b, v16.16b, v10.16b
	aese	v17.16b, v9.16b
	eor	v17.16b, v17.16b, v10.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	eor	v20.16b, v20.16b, v16.16b
	eor	v21.16b, v21.16b, v17.16b
	cmp	w8, #4
	st1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x2], #0x40
	bge	L_aes_gcm_encrypt_update_arm64_crypto_eor3_128_both_4
L_aes_gcm_encrypt_update_arm64_crypto_eor3_128_end_4:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cmp	w8, #1
	beq	L_aes_gcm_encrypt_update_arm64_crypto_eor3_128_start_1
	blt	L_aes_gcm_encrypt_update_arm64_crypto_eor3_128_done
L_aes_gcm_encrypt_update_arm64_crypto_eor3_128_start_2:
	add	w13, w9, #1
	mov	v14.16b, v13.16b
	add	w9, w9, #2
	mov	v15.16b, v13.16b
	rev	w13, w13
	rev	w10, w9
	mov	v14.s[3], w13
	mov	v15.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	subs	w8, w8, #2
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x3], #16
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	ld1	{v19.16b}, [x3], #16
	aese	v15.16b, v9.16b
	eor	v15.16b, v15.16b, v10.16b
	eor	v18.16b, v18.16b, v14.16b
	eor	v19.16b, v19.16b, v15.16b
	st1	{v18.16b, v19.16b}, [x2], #32
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v19.1d, v22.1d
	pmull2	v29.1q, v19.2d, v22.2d
	ext	v31.16b, v19.16b, v19.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v21.1d
	pmull2	v26.1q, v23.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cbz	w8, L_aes_gcm_encrypt_update_arm64_crypto_eor3_128_done
L_aes_gcm_encrypt_update_arm64_crypto_eor3_128_start_1:
	add	w9, w9, #1
	mov	v14.16b, v13.16b
	rev	w10, w9
	mov	v14.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v14.16b, v9.16b
	eor	v14.16b, v14.16b, v10.16b
	ld1	{v18.16b}, [x3], #16
	eor	v18.16b, v18.16b, v14.16b
	st1	{v18.16b}, [x2], #16
	rbit	v18.16b, v18.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_encrypt_update_arm64_crypto_eor3_128_done:
#endif /* !NO_AES_128 */
L_aes_gcm_encrypt_update_arm64_crypto_eor3_done:
	rev	w9, w9
	mov	v13.s[3], w9
	st1	{v26.2d}, [x5]
	st1	{v13.2d}, [x7]
	ldr	x17, [x29, #24]
	ldp	d8, d9, [x29, #32]
	ldp	d10, d11, [x29, #48]
	ldp	d12, d13, [x29, #64]
	ldp	d14, d15, [x29, #80]
	ldp	x29, x30, [sp], #0x60
	ret
#ifndef __APPLE__
	.size	AES_GCM_encrypt_update_AARCH64_EOR3,.-AES_GCM_encrypt_update_AARCH64_EOR3
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	AES_GCM_encrypt_final_AARCH64_EOR3
.type	AES_GCM_encrypt_final_AARCH64_EOR3,@function
.align	2
AES_GCM_encrypt_final_AARCH64_EOR3:
#else
.section	__TEXT,__text
.globl	_AES_GCM_encrypt_final_AARCH64_EOR3
.p2align	2
_AES_GCM_encrypt_final_AARCH64_EOR3:
#endif /* __APPLE__ */
	ld1	{v5.2d}, [x0]
	movi	v6.16b, #0x87
	ld1	{v4.2d}, [x5]
	ushr	v6.2d, v6.2d, #56
	ld1	{v7.2d}, [x6]
	lsl	x4, x4, #3
	rbit	x4, x4
	mov	v0.d[0], x4
	lsl	x3, x3, #3
	rbit	x3, x3
	mov	v0.d[1], x3
	eor	v5.16b, v5.16b, v0.16b
	pmull	v0.1q, v5.1d, v4.1d
	pmull2	v1.1q, v5.2d, v4.2d
	ext	v3.16b, v5.16b, v5.16b, #8
	pmull	v2.1q, v3.1d, v4.1d
	pmull2	v3.1q, v3.2d, v4.2d
	eor	v2.16b, v2.16b, v3.16b
	#   Reduce
	ext	v3.16b, v0.16b, v1.16b, #8
	pmull2	v1.1q, v1.2d, v6.2d
	eor3	v3.16b, v3.16b, v1.16b, v2.16b
	pmull2	v2.1q, v3.2d, v6.2d
	mov	v0.d[1], v3.d[0]
	eor	v5.16b, v0.16b, v2.16b
	rbit	v5.16b, v5.16b
	eor	v5.16b, v5.16b, v7.16b
	cmp	w2, #16
	bne	L_aes_gcm_encrypt_final_arm64_crypto_eor3_tag_partial
	st1	{v5.16b}, [x1]
	b	L_aes_gcm_encrypt_final_arm64_crypto_eor3_done
L_aes_gcm_encrypt_final_arm64_crypto_eor3_tag_partial:
	st1	{v5.16b}, [x0]
	cmp	w2, #8
	blt	L_aes_gcm_encrypt_final_arm64_crypto_eor3_tag_start_dw
	ldr	x8, [x0], #8
	sub	w2, w2, #8
	str	x8, [x1], #8
L_aes_gcm_encrypt_final_arm64_crypto_eor3_tag_start_dw:
	cmp	w2, #4
	blt	L_aes_gcm_encrypt_final_arm64_crypto_eor3_tag_start_sw
	ldr	w8, [x0], #4
	sub	w2, w2, #4
	str	w8, [x1], #4
L_aes_gcm_encrypt_final_arm64_crypto_eor3_tag_start_sw:
	cmp	w2, #2
	blt	L_aes_gcm_encrypt_final_arm64_crypto_eor3_tag_start_byte
	ldrh	w8, [x0], #2
	sub	w2, w2, #2
	strh	w8, [x1], #2
L_aes_gcm_encrypt_final_arm64_crypto_eor3_tag_start_byte:
	cbz	w2, L_aes_gcm_encrypt_final_arm64_crypto_eor3_tag_end_bytes
	ldrb	w8, [x0], #1
	subs	w2, w2, #1
	strb	w8, [x1], #1
	bne	L_aes_gcm_encrypt_final_arm64_crypto_eor3_tag_start_byte
L_aes_gcm_encrypt_final_arm64_crypto_eor3_tag_end_bytes:
L_aes_gcm_encrypt_final_arm64_crypto_eor3_done:
	ret
#ifndef __APPLE__
	.size	AES_GCM_encrypt_final_AARCH64_EOR3,.-AES_GCM_encrypt_final_AARCH64_EOR3
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	AES_GCM_decrypt_update_AARCH64_EOR3
.type	AES_GCM_decrypt_update_AARCH64_EOR3,@function
.align	2
AES_GCM_decrypt_update_AARCH64_EOR3:
#else
.section	__TEXT,__text
.globl	_AES_GCM_decrypt_update_AARCH64_EOR3
.p2align	2
_AES_GCM_decrypt_update_AARCH64_EOR3:
#endif /* __APPLE__ */
	stp	x29, x30, [sp, #-96]!
	add	x29, sp, #0
	str	x17, [x29, #24]
	stp	d8, d9, [x29, #32]
	stp	d10, d11, [x29, #48]
	stp	d12, d13, [x29, #64]
	stp	d14, d15, [x29, #80]
	ld1	{v13.2d}, [x7]
	movi	v27.16b, #0x87
	ld1	{v26.2d}, [x5]
	ushr	v27.2d, v27.2d, #56
	ld1	{v22.2d}, [x6]
	mov	w9, v13.s[3]
	rev	w9, w9
	cmp	w4, #32
	blt	L_aes_gcm_decrypt_update_arm64_crypto_eor3_h_done
	# Square H => H^2
	pmull2	v31.1q, v22.2d, v22.2d
	pmull	v30.1q, v22.1d, v22.1d
	pmull2	v28.1q, v31.2d, v27.2d
	ext	v29.16b, v30.16b, v31.16b, #8
	eor	v29.16b, v29.16b, v28.16b
	pmull2	v31.1q, v29.2d, v27.2d
	mov	v30.d[1], v29.d[0]
	eor	v23.16b, v30.16b, v31.16b
	cmp	w4, #0x40
	blt	L_aes_gcm_decrypt_update_arm64_crypto_eor3_h_done
	# Multiply H and H^2  => H^3
	pmull	v28.1q, v22.1d, v23.1d
	pmull2	v29.1q, v22.2d, v23.2d
	ext	v31.16b, v22.16b, v22.16b, #8
	pmull	v30.1q, v31.1d, v23.1d
	pmull2	v31.1q, v31.2d, v23.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v24.16b, v28.16b, v30.16b
	# Square H^2 => H^4
	pmull2	v31.1q, v23.2d, v23.2d
	pmull	v30.1q, v23.1d, v23.1d
	pmull2	v28.1q, v31.2d, v27.2d
	ext	v29.16b, v30.16b, v31.16b, #8
	eor	v29.16b, v29.16b, v28.16b
	pmull2	v31.1q, v29.2d, v27.2d
	mov	v30.d[1], v29.d[0]
	eor	v25.16b, v30.16b, v31.16b
	# Done
	cmp	w4, #0x200
	blt	L_aes_gcm_decrypt_update_arm64_crypto_eor3_h_done
	# Multiply H and H^4  => H^5
	pmull	v28.1q, v22.1d, v25.1d
	pmull2	v29.1q, v22.2d, v25.2d
	ext	v31.16b, v22.16b, v22.16b, #8
	pmull	v30.1q, v31.1d, v25.1d
	pmull2	v31.1q, v31.2d, v25.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v4.16b, v28.16b, v30.16b
	# Square H^3 => H^6
	pmull2	v31.1q, v24.2d, v24.2d
	pmull	v30.1q, v24.1d, v24.1d
	pmull2	v28.1q, v31.2d, v27.2d
	ext	v29.16b, v30.16b, v31.16b, #8
	eor	v29.16b, v29.16b, v28.16b
	pmull2	v31.1q, v29.2d, v27.2d
	mov	v30.d[1], v29.d[0]
	eor	v5.16b, v30.16b, v31.16b
	# Multiply H and H^6  => H^7
	pmull	v28.1q, v22.1d, v5.1d
	pmull2	v29.1q, v22.2d, v5.2d
	ext	v31.16b, v22.16b, v22.16b, #8
	pmull	v30.1q, v31.1d, v5.1d
	pmull2	v31.1q, v31.2d, v5.2d
	eor	v30.16b, v30.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v6.16b, v28.16b, v30.16b
	# Square H^4 => H^8
	pmull2	v31.1q, v25.2d, v25.2d
	pmull	v30.1q, v25.1d, v25.1d
	pmull2	v28.1q, v31.2d, v27.2d
	ext	v29.16b, v30.16b, v31.16b, #8
	eor	v29.16b, v29.16b, v28.16b
	pmull2	v31.1q, v29.2d, v27.2d
	mov	v30.d[1], v29.d[0]
	eor	v7.16b, v30.16b, v31.16b
	# Done
L_aes_gcm_decrypt_update_arm64_crypto_eor3_h_done:
	lsr	w8, w4, #4
	cmp	x1, #12
	blt	L_aes_gcm_decrypt_update_arm64_crypto_eor3_start_128
	bgt	L_aes_gcm_decrypt_update_arm64_crypto_eor3_start_256
	# AES_GCM_192
#ifndef NO_AES_192
	cmp	w8, #32
	blt	L_aes_gcm_decrypt_update_arm64_crypto_eor3_192_start_4
L_aes_gcm_decrypt_update_arm64_crypto_eor3_192_start_8:
	ldr	q12, [x0]
	add	w17, w9, #1
	mov	v14.16b, v13.16b
	add	w16, w9, #2
	mov	v15.16b, v13.16b
	add	w15, w9, #3
	mov	v16.16b, v13.16b
	add	w14, w9, #4
	mov	v17.16b, v13.16b
	add	w13, w9, #5
	mov	v8.16b, v13.16b
	add	w12, w9, #6
	mov	v9.16b, v13.16b
	add	w11, w9, #7
	mov	v10.16b, v13.16b
	add	w9, w9, #8
	mov	v11.16b, v13.16b
	rev	w17, w17
	mov	v14.s[3], w17
	rev	w16, w16
	mov	v15.s[3], w16
	rev	w15, w15
	mov	v16.s[3], w15
	rev	w14, w14
	mov	v17.s[3], w14
	rev	w13, w13
	mov	v8.s[3], w13
	rev	w12, w12
	mov	v9.s[3], w12
	rev	w11, w11
	mov	v10.s[3], w11
	rev	w10, w9
	mov	v11.s[3], w10
	ldr	q13, [x0, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w8, w8, #8
	ldr	q12, [x0, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ld1	{v18.16b}, [x3], #16
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v19.16b}, [x3], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v20.16b}, [x3], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v21.16b}, [x3], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #160]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	ld1	{v0.16b}, [x3], #16
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	ld1	{v1.16b}, [x3], #16
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ld1	{v2.16b}, [x3], #16
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v3.16b}, [x3], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #176]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #192]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	eor	v8.16b, v8.16b, v0.16b
	eor	v9.16b, v9.16b, v1.16b
	eor	v10.16b, v10.16b, v2.16b
	eor	v11.16b, v11.16b, v3.16b
	ld1	{v13.2d}, [x7]
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x2], #0x40
	st1	{v8.16b, v9.16b, v10.16b, v11.16b}, [x2], #0x40
	cmp	w8, #8
	blt	L_aes_gcm_decrypt_update_arm64_crypto_eor3_192_end_8
L_aes_gcm_decrypt_update_arm64_crypto_eor3_192_both_8:
	ldr	q12, [x0]
	add	w17, w9, #1
	mov	v14.16b, v13.16b
	add	w16, w9, #2
	mov	v15.16b, v13.16b
	add	w15, w9, #3
	mov	v16.16b, v13.16b
	add	w14, w9, #4
	mov	v17.16b, v13.16b
	add	w13, w9, #5
	mov	v8.16b, v13.16b
	add	w12, w9, #6
	mov	v9.16b, v13.16b
	add	w11, w9, #7
	mov	v10.16b, v13.16b
	add	w9, w9, #8
	mov	v11.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w17, w17
	rbit	v19.16b, v19.16b
	mov	v14.s[3], w17
	rev	w16, w16
	rbit	v20.16b, v20.16b
	mov	v15.s[3], w16
	rev	w15, w15
	rbit	v21.16b, v21.16b
	mov	v16.s[3], w15
	rev	w14, w14
	rbit	v0.16b, v0.16b
	mov	v17.s[3], w14
	rev	w13, w13
	rbit	v1.16b, v1.16b
	mov	v8.s[3], w13
	rev	w12, w12
	rbit	v2.16b, v2.16b
	mov	v9.s[3], w12
	rev	w11, w11
	rbit	v3.16b, v3.16b
	mov	v10.s[3], w11
	rev	w10, w9
	eor	v18.16b, v18.16b, v26.16b
	mov	v11.s[3], w10
	ldr	q13, [x0, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ext	v31.16b, v3.16b, v3.16b, #8
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w8, w8, #8
	ldr	q12, [x0, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	mov	v28.d[1], v31.d[0]
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	eor	v26.16b, v28.16b, v30.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	# Done GHASH
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ld1	{v18.16b}, [x3], #16
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v19.16b}, [x3], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ld1	{v20.16b}, [x3], #16
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ld1	{v21.16b}, [x3], #16
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ld1	{v0.16b}, [x3], #16
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v1.16b}, [x3], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v2.16b}, [x3], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v3.16b}, [x3], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #160]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #176]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #192]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	ld1	{v13.2d}, [x7]
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x2], #0x40
	eor	v8.16b, v8.16b, v0.16b
	eor	v9.16b, v9.16b, v1.16b
	eor	v10.16b, v10.16b, v2.16b
	eor	v11.16b, v11.16b, v3.16b
	st1	{v8.16b, v9.16b, v10.16b, v11.16b}, [x2], #0x40
	cmp	w8, #8
	bge	L_aes_gcm_decrypt_update_arm64_crypto_eor3_192_both_8
L_aes_gcm_decrypt_update_arm64_crypto_eor3_192_end_8:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	rbit	v0.16b, v0.16b
	rbit	v1.16b, v1.16b
	rbit	v2.16b, v2.16b
	rbit	v3.16b, v3.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	ext	v31.16b, v3.16b, v3.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_decrypt_update_arm64_crypto_eor3_192_start_4:
	ld1	{v0.2d, v1.2d, v2.2d, v3.2d}, [x0], #0x40
	ld1	{v4.2d, v5.2d, v6.2d, v7.2d}, [x0], #0x40
	ld1	{v8.2d, v9.2d, v10.2d, v11.2d}, [x0], #0x40
	ld1	{v12.2d}, [x0]
	cmp	w8, #1
	blt	L_aes_gcm_decrypt_update_arm64_crypto_eor3_192_done
	beq	L_aes_gcm_decrypt_update_arm64_crypto_eor3_192_start_1
	cmp	w8, #4
	blt	L_aes_gcm_decrypt_update_arm64_crypto_eor3_192_start_2
	add	w13, w9, #1
	mov	v14.16b, v13.16b
	add	w12, w9, #2
	mov	v15.16b, v13.16b
	add	w11, w9, #3
	mov	v16.16b, v13.16b
	add	w9, w9, #4
	mov	v17.16b, v13.16b
	rev	w13, w13
	mov	v14.s[3], w13
	rev	w12, w12
	mov	v15.s[3], w12
	rev	w11, w11
	mov	v16.s[3], w11
	rev	w10, w9
	mov	v17.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w8, w8, #4
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b}, [x3], #16
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	ld1	{v19.16b}, [x3], #16
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	ld1	{v20.16b}, [x3], #16
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	ld1	{v21.16b}, [x3], #16
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v11.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v11.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v11.16b
	eor	v17.16b, v17.16b, v12.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	cmp	w8, #4
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x2], #0x40
	blt	L_aes_gcm_decrypt_update_arm64_crypto_eor3_192_end_4
L_aes_gcm_decrypt_update_arm64_crypto_eor3_192_both_4:
	add	w13, w9, #1
	mov	v14.16b, v13.16b
	add	w12, w9, #2
	mov	v15.16b, v13.16b
	add	w11, w9, #3
	mov	v16.16b, v13.16b
	add	w9, w9, #4
	mov	v17.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w13, w13
	rbit	v19.16b, v19.16b
	mov	v14.s[3], w13
	rev	w12, w12
	rbit	v20.16b, v20.16b
	mov	v15.s[3], w12
	rev	w11, w11
	rbit	v21.16b, v21.16b
	mov	v16.s[3], w11
	rev	w10, w9
	mov	v17.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	eor	v18.16b, v18.16b, v26.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	ext	v31.16b, v21.16b, v21.16b, #8
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w8, w8, #4
	mov	v28.d[1], v31.d[0]
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v28.16b, v30.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	# Done GHASH
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b, v19.16b, v20.16b, v21.16b}, [x3], #0x40
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v11.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v11.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v11.16b
	eor	v17.16b, v17.16b, v12.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	cmp	w8, #4
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x2], #0x40
	bge	L_aes_gcm_decrypt_update_arm64_crypto_eor3_192_both_4
L_aes_gcm_decrypt_update_arm64_crypto_eor3_192_end_4:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v21.1d, v22.1d
	pmull2	v29.1q, v21.2d, v22.2d
	ext	v31.16b, v21.16b, v21.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v20.1d
	pmull2	v26.1q, v23.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v19.1d
	pmull2	v26.1q, v24.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v18.1d
	pmull2	v26.1q, v25.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cmp	w8, #1
	beq	L_aes_gcm_decrypt_update_arm64_crypto_eor3_192_start_1
	blt	L_aes_gcm_decrypt_update_arm64_crypto_eor3_192_done
L_aes_gcm_decrypt_update_arm64_crypto_eor3_192_start_2:
	add	w13, w9, #1
	mov	v14.16b, v13.16b
	add	w9, w9, #2
	mov	v15.16b, v13.16b
	rev	w13, w13
	mov	v14.s[3], w13
	rev	w10, w9
	mov	v15.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	subs	w8, w8, #2
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	ld1	{v18.16b}, [x3], #16
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	ld1	{v19.16b}, [x3], #16
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v11.16b
	eor	v15.16b, v15.16b, v12.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	st1	{v14.16b, v15.16b}, [x2], #32
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	eor	v21.16b, v26.16b, v18.16b
	#   X  = C * H^1
	pmull	v28.1q, v19.1d, v22.1d
	pmull2	v29.1q, v19.2d, v22.2d
	ext	v31.16b, v19.16b, v19.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v21.1d
	pmull2	v26.1q, v23.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
	cbz	w8, L_aes_gcm_decrypt_update_arm64_crypto_eor3_192_done
L_aes_gcm_decrypt_update_arm64_crypto_eor3_192_start_1:
	ld1	{v15.16b}, [x3], #16
	add	w9, w9, #1
	mov	v14.16b, v13.16b
	rbit	v15.16b, v15.16b
	rev	w10, w9
	mov	v14.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	eor	v16.16b, v26.16b, v15.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	#   X  = C * H^1
	pmull	v28.1q, v16.1d, v22.1d
	pmull2	v29.1q, v16.2d, v22.2d
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	ext	v31.16b, v16.16b, v16.16b, #8
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	mov	v28.d[1], v31.d[0]
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	eor	v26.16b, v28.16b, v30.16b
	aese	v14.16b, v11.16b
	eor	v14.16b, v14.16b, v12.16b
	# Done GHASH
	rbit	v15.16b, v15.16b
	eor	v14.16b, v14.16b, v15.16b
	st1	{v14.16b}, [x2], #16
L_aes_gcm_decrypt_update_arm64_crypto_eor3_192_done:
#endif /* !NO_AES_192 */
	b	L_aes_gcm_decrypt_update_arm64_crypto_eor3_done
	# AES_GCM_256
L_aes_gcm_decrypt_update_arm64_crypto_eor3_start_256:
#ifndef NO_AES_256
	cmp	w8, #32
	blt	L_aes_gcm_decrypt_update_arm64_crypto_eor3_256_start_4
L_aes_gcm_decrypt_update_arm64_crypto_eor3_256_start_8:
	ldr	q12, [x0]
	add	w17, w9, #1
	mov	v14.16b, v13.16b
	add	w16, w9, #2
	mov	v15.16b, v13.16b
	add	w15, w9, #3
	mov	v16.16b, v13.16b
	add	w14, w9, #4
	mov	v17.16b, v13.16b
	add	w13, w9, #5
	mov	v8.16b, v13.16b
	add	w12, w9, #6
	mov	v9.16b, v13.16b
	add	w11, w9, #7
	mov	v10.16b, v13.16b
	add	w9, w9, #8
	mov	v11.16b, v13.16b
	rev	w17, w17
	mov	v14.s[3], w17
	rev	w16, w16
	mov	v15.s[3], w16
	rev	w15, w15
	mov	v16.s[3], w15
	rev	w14, w14
	mov	v17.s[3], w14
	rev	w13, w13
	mov	v8.s[3], w13
	rev	w12, w12
	mov	v9.s[3], w12
	rev	w11, w11
	mov	v10.s[3], w11
	rev	w10, w9
	mov	v11.s[3], w10
	ldr	q13, [x0, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w8, w8, #8
	ldr	q12, [x0, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ld1	{v18.16b}, [x3], #16
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v19.16b}, [x3], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v20.16b}, [x3], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v21.16b}, [x3], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #160]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	ld1	{v0.16b}, [x3], #16
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	ld1	{v1.16b}, [x3], #16
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ld1	{v2.16b}, [x3], #16
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v3.16b}, [x3], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #176]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #192]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #208]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #224]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	eor	v8.16b, v8.16b, v0.16b
	eor	v9.16b, v9.16b, v1.16b
	eor	v10.16b, v10.16b, v2.16b
	eor	v11.16b, v11.16b, v3.16b
	ld1	{v13.2d}, [x7]
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x2], #0x40
	st1	{v8.16b, v9.16b, v10.16b, v11.16b}, [x2], #0x40
	cmp	w8, #8
	blt	L_aes_gcm_decrypt_update_arm64_crypto_eor3_256_end_8
L_aes_gcm_decrypt_update_arm64_crypto_eor3_256_both_8:
	ldr	q12, [x0]
	add	w17, w9, #1
	mov	v14.16b, v13.16b
	add	w16, w9, #2
	mov	v15.16b, v13.16b
	add	w15, w9, #3
	mov	v16.16b, v13.16b
	add	w14, w9, #4
	mov	v17.16b, v13.16b
	add	w13, w9, #5
	mov	v8.16b, v13.16b
	add	w12, w9, #6
	mov	v9.16b, v13.16b
	add	w11, w9, #7
	mov	v10.16b, v13.16b
	add	w9, w9, #8
	mov	v11.16b, v13.16b
	rbit	v18.16b, v18.16b
	rev	w17, w17
	rbit	v19.16b, v19.16b
	mov	v14.s[3], w17
	rev	w16, w16
	rbit	v20.16b, v20.16b
	mov	v15.s[3], w16
	rev	w15, w15
	rbit	v21.16b, v21.16b
	mov	v16.s[3], w15
	rev	w14, w14
	rbit	v0.16b, v0.16b
	mov	v17.s[3], w14
	rev	w13, w13
	rbit	v1.16b, v1.16b
	mov	v8.s[3], w13
	rev	w12, w12
	rbit	v2.16b, v2.16b
	mov	v9.s[3], w12
	rev	w11, w11
	rbit	v3.16b, v3.16b
	mov	v10.s[3], w11
	rev	w10, w9
	eor	v18.16b, v18.16b, v26.16b
	mov	v11.s[3], w10
	ldr	q13, [x0, #16]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ext	v31.16b, v3.16b, v3.16b, #8
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor	v30.16b, v30.16b, v31.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #32]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #48]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #64]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #80]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #96]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #112]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	pmull2	v29.1q, v29.2d, v27.2d
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	subs	w8, w8, #8
	ldr	q12, [x0, #128]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	pmull2	v30.1q, v31.2d, v27.2d
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	mov	v28.d[1], v31.d[0]
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	eor	v26.16b, v28.16b, v30.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	# Done GHASH
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	ld1	{v18.16b}, [x3], #16
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	ld1	{v19.16b}, [x3], #16
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	ld1	{v20.16b}, [x3], #16
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #144]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	ld1	{v21.16b}, [x3], #16
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	ld1	{v0.16b}, [x3], #16
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	ld1	{v1.16b}, [x3], #16
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	ld1	{v2.16b}, [x3], #16
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	ld1	{v3.16b}, [x3], #16
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #160]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #176]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #192]
	aese	v14.16b, v13.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v13.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v13.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v13.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v13.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v13.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v13.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v13.16b
	aesmc	v11.16b, v11.16b
	ldr	q13, [x0, #208]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v8.16b, v12.16b
	aesmc	v8.16b, v8.16b
	aese	v9.16b, v12.16b
	aesmc	v9.16b, v9.16b
	aese	v10.16b, v12.16b
	aesmc	v10.16b, v10.16b
	aese	v11.16b, v12.16b
	aesmc	v11.16b, v11.16b
	ldr	q12, [x0, #224]
	aese	v14.16b, v13.16b
	eor	v14.16b, v14.16b, v12.16b
	aese	v15.16b, v13.16b
	eor	v15.16b, v15.16b, v12.16b
	aese	v16.16b, v13.16b
	eor	v16.16b, v16.16b, v12.16b
	aese	v17.16b, v13.16b
	eor	v17.16b, v17.16b, v12.16b
	aese	v8.16b, v13.16b
	eor	v8.16b, v8.16b, v12.16b
	aese	v9.16b, v13.16b
	eor	v9.16b, v9.16b, v12.16b
	aese	v10.16b, v13.16b
	eor	v10.16b, v10.16b, v12.16b
	aese	v11.16b, v13.16b
	eor	v11.16b, v11.16b, v12.16b
	ld1	{v13.2d}, [x7]
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x2], #0x40
	eor	v8.16b, v8.16b, v0.16b
	eor	v9.16b, v9.16b, v1.16b
	eor	v10.16b, v10.16b, v2.16b
	eor	v11.16b, v11.16b, v3.16b
	st1	{v8.16b, v9.16b, v10.16b, v11.16b}, [x2], #0x40
	cmp	w8, #8
	bge	L_aes_gcm_decrypt_update_arm64_crypto_eor3_256_both_8
L_aes_gcm_decrypt_update_arm64_crypto_eor3_256_end_8:
	rbit	v18.16b, v18.16b
	rbit	v19.16b, v19.16b
	rbit	v20.16b, v20.16b
	rbit	v21.16b, v21.16b
	rbit	v0.16b, v0.16b
	rbit	v1.16b, v1.16b
	rbit	v2.16b, v2.16b
	rbit	v3.16b, v3.16b
	eor	v18.16b, v18.16b, v26.16b
	#   X  = C * H^1
	pmull	v28.1q, v3.1d, v22.1d
	pmull2	v29.1q, v3.2d, v22.2d
	ext	v31.16b, v3.16b, v3.16b, #8
	pmull	v30.1q, v31.1d, v22.1d
	pmull2	v31.1q, v31.2d, v22.2d
	eor	v30.16b, v30.16b, v31.16b
	#   X += C * H^2
	pmull	v31.1q, v23.1d, v2.1d
	pmull2	v26.1q, v23.2d, v2.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v2.16b, v2.16b, #8
	pmull	v31.1q, v26.1d, v23.1d
	pmull2	v26.1q, v26.2d, v23.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^3
	pmull	v31.1q, v24.1d, v1.1d
	pmull2	v26.1q, v24.2d, v1.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v1.16b, v1.16b, #8
	pmull	v31.1q, v26.1d, v24.1d
	pmull2	v26.1q, v26.2d, v24.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^4
	pmull	v31.1q, v25.1d, v0.1d
	pmull2	v26.1q, v25.2d, v0.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v0.16b, v0.16b, #8
	pmull	v31.1q, v26.1d, v25.1d
	pmull2	v26.1q, v26.2d, v25.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^5
	pmull	v31.1q, v4.1d, v21.1d
	pmull2	v26.1q, v4.2d, v21.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v21.16b, v21.16b, #8
	pmull	v31.1q, v26.1d, v4.1d
	pmull2	v26.1q, v26.2d, v4.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^6
	pmull	v31.1q, v5.1d, v20.1d
	pmull2	v26.1q, v5.2d, v20.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v20.16b, v20.16b, #8
	pmull	v31.1q, v26.1d, v5.1d
	pmull2	v26.1q, v26.2d, v5.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^7
	pmull	v31.1q, v6.1d, v19.1d
	pmull2	v26.1q, v6.2d, v19.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v19.16b, v19.16b, #8
	pmull	v31.1q, v26.1d, v6.1d
	pmull2	v26.1q, v26.2d, v6.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   X += C * H^8
	pmull	v31.1q, v7.1d, v18.1d
	pmull2	v26.1q, v7.2d, v18.2d
	eor	v28.16b, v28.16b, v31.16b
	eor	v29.16b, v29.16b, v26.16b
	ext	v26.16b, v18.16b, v18.16b, #8
	pmull	v31.1q, v26.1d, v7.1d
	pmull2	v26.1q, v26.2d, v7.2d
	eor3	v30.16b, v30.16b, v26.16b, v31.16b
	#   Reduce
	ext	v31.16b, v28.16b, v29.16b, #8
	pmull2	v29.1q, v29.2d, v27.2d
	eor3	v31.16b, v31.16b, v29.16b, v30.16b
	pmull2	v30.1q, v31.2d, v27.2d
	mov	v28.d[1], v31.d[0]
	eor	v26.16b, v28.16b, v30.16b
	# Done GHASH
L_aes_gcm_decrypt_update_arm64_crypto_eor3_256_start_4:
	ld1	{v0.2d, v1.2d, v2.2d, v3.2d}, [x0], #0x40
	ld1	{v4.2d, v5.2d, v6.2d, v7.2d}, [x0], #0x40
	ld1	{v8.2d, v9.2d, v10.2d, v11.2d}, [x0], #0x40
	ld1	{v12.2d}, [x0], #16
	cmp	w8, #1
	blt	L_aes_gcm_decrypt_update_arm64_crypto_eor3_256_done
	beq	L_aes_gcm_decrypt_update_arm64_crypto_eor3_256_start_1
	cmp	w8, #4
	blt	L_aes_gcm_decrypt_update_arm64_crypto_eor3_256_start_2
	add	w13, w9, #1
	mov	v14.16b, v13.16b
	add	w12, w9, #2
	mov	v15.16b, v13.16b
	add	w11, w9, #3
	mov	v16.16b, v13.16b
	add	w9, w9, #4
	mov	v17.16b, v13.16b
	rev	w13, w13
	mov	v14.s[3], w13
	rev	w12, w12
	mov	v15.s[3], w12
	rev	w11, w11
	mov	v16.s[3], w11
	rev	w10, w9
	mov	v17.s[3], w10
	aese	v14.16b, v0.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v0.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v0.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v0.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v1.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v1.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v1.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v1.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v2.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v2.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v2.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v2.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v3.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v3.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v3.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v3.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v4.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v4.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v4.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v4.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v5.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v5.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v5.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v5.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v6.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v6.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v6.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v6.16b
	aesmc	v17.16b, v17.16b
	subs	w8, w8, #4
	aese	v14.16b, v7.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v7.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v7.16b
	aesmc	v16.16b, v16.16b
	ld1	{v18.16b}, [x3], #16
	aese	v17.16b, v7.16b
	aesmc	v17.16b, v17.16b
	ld1	{v19.16b}, [x3], #16
	aese	v14.16b, v8.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v8.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v8.16b
	aesmc	v16.16b, v16.16b
	ld1	{v20.16b}, [x3], #16
	aese	v17.16b, v8.16b
	aesmc	v17.16b, v17.16b
	ld1	{v21.16b}, [x3], #16
	aese	v14.16b, v9.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v9.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v9.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v9.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v10.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v10.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v10.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v10.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v11.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v11.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v11.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v11.16b
	aesmc	v17.16b, v17.16b
	ld1	{v29.2d, v30.2d}, [x0]
	aese	v14.16b, v12.16b
	aesmc	v14.16b, v14.16b
	aese	v15.16b, v12.16b
	aesmc	v15.16b, v15.16b
	aese	v16.16b, v12.16b
	aesmc	v16.16b, v16.16b
	aese	v17.16b, v12.16b
	aesmc	v17.16b, v17.16b
	aese	v14.16b, v29.16b
	eor	v14.16b, v14.16b, v30.16b
	aese	v15.16b, v29.16b
	eor	v15.16b, v15.16b, v30.16b
	aese	v16.16b, v29.16b
	eor	v16.16b, v16.16b, v30.16b
	aese	v17.16b, v29.16b
	eor	v17.16b, v17.16b, v30.16b
	eor	v14.16b, v14.16b, v18.16b
	eor	v15.16b, v15.16b, v19.16b
	eor	v16.16b, v16.16b, v20.16b
	eor	v17.16b, v17.16b, v21.16b
	cmp	w8, #4
	st1	{v14.16b, v15.16b, v16.16b, v17.16b}, [x2], #0x40
	blt	L_aes_gcm_decrypt_update_arm64_crypto_eor3_256_end_4
L_aes_gcm_decrypt_update_arm64_crypto_eor3_256_both_4:
	add	w13, w9, #1
	mov	v14.16b, v13.16b
	add