/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.diff;

import javax.xml.transform.Source;
import org.xmlunit.diff.ComparisonFormatter;
import org.xmlunit.diff.DefaultComparisonFormatter;
import org.xmlunit.diff.Difference;

public class Diff {
    private final Iterable<Difference> differences;
    private final Source controlSource;
    private final Source testSource;
    private static final ComparisonFormatter DEFAULT_FORMATTER = new DefaultComparisonFormatter();

    public Diff(Source controlSource, Source testSource, Iterable<Difference> differences) {
        this.controlSource = controlSource;
        this.testSource = testSource;
        this.differences = differences;
    }

    public boolean hasDifferences() {
        return this.differences.iterator().hasNext();
    }

    public Iterable<Difference> getDifferences() {
        return this.differences;
    }

    public Source getControlSource() {
        return this.controlSource;
    }

    public Source getTestSource() {
        return this.testSource;
    }

    public String toString() {
        return this.toString(DEFAULT_FORMATTER);
    }

    public String toString(ComparisonFormatter formatter) {
        if (!this.hasDifferences()) {
            return "[identical]";
        }
        return this.getDifferences().iterator().next().getComparison().toString(formatter);
    }
}

