#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Contract Demon
# send your bug reports to contact@dotslashplay.it
###

script_version=20241216.1

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID='contract-demon'
GAME_NAME='Contract Demon'

ARCHIVE_BASE_2_NAME='contractdemon-2.2.7-pc.zip'
ARCHIVE_BASE_2_MD5='14639ade236d9b8661c7491aa8947e44'
ARCHIVE_BASE_2_SIZE='154330'
ARCHIVE_BASE_2_VERSION='2.2.7-itch.2024.02.27'
ARCHIVE_BASE_2_URL='https://nomnomnami.itch.io/contract-demon'

ARCHIVE_BASE_1_NAME='contractdemon-1.8.0-pc.zip'
ARCHIVE_BASE_1_MD5='269db9bdbf6f40c7362814de7c8f46da'
ARCHIVE_BASE_1_SIZE='200000'
ARCHIVE_BASE_1_VERSION='1.8.0-itch.2021.05.08'

ARCHIVE_BASE_0_NAME='contractdemon-1.7.1-pc.zip'
ARCHIVE_BASE_0_MD5='81de84b69550eae7ae13e019a4aec3bf'
ARCHIVE_BASE_0_SIZE='150000'
ARCHIVE_BASE_0_VERSION='1.7.1-itch'

CONTENT_PATH_DEFAULT='contractdemon-2.2.7-pc/game'
CONTENT_PATH_DEFAULT_1='contractdemon-1.8.0-pc/game'
CONTENT_PATH_DEFAULT_0='contractdemon-1.7.1-pc/game'
CONTENT_GAME_MAIN_FILES='
cache
tl
archive.rpa
script_version.txt'

APP_MAIN_TYPE='renpy'
APP_MAIN_ICON='../contractdemon.exe'

## Ensure easy upgrades from packages generated with pre-20240428.1 game scripts.
PKG_MAIN_PROVIDES="${PKG_MAIN_PROVIDES:-}
contract-demon-data"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons
content_inclusion_default

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
