//# Images.h: N-dimensional astronomical images
//# Copyright (C) 1998,1999
//# Associated Universities, Inc. Washington DC, USA.
//#
//# This library is free software; you can redistribute it and/or modify it
//# under the terms of the GNU Library General Public License as published by
//# the Free Software Foundation; either version 2 of the License, or (at your
//# option) any later version.
//#
//# This library is distributed in the hope that it will be useful, but WITHOUT
//# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
//# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
//# License for more details.
//#
//# You should have received a copy of the GNU Library General Public License
//# along with this library; if not, write to the Free Software Foundation,
//# Inc., 675 Massachusetts Ave, Cambridge, MA 02139, USA.
//#
//# Correspondence concerning AIPS++ should be addressed as follows:
//#        Internet email: casa-feedback@nrao.edu.
//#        Postal address: AIPS++ Project Office
//#                        National Radio Astronomy Observatory
//#                        520 Edgemont Road
//#                        Charlottesville, VA 22903-2475 USA

#ifndef IMAGES_IMAGES_H
#define IMAGES_IMAGES_H


#include <casacore/casa/aips.h>
#include <casacore/casa/Arrays/IPosition.h>
#include <casacore/casa/Arrays/Slice.h>
#include <casacore/casa/Arrays/Slicer.h>

namespace casacore { //# NAMESPACE CASACORE - BEGIN

//#include <casacore/casa/Arrays/ArrayLattice.h>
//#include <casacore/casa/Arrays/PagedArray.h>
//#include <casacore/casa/Arrays/TempLattice.h>
//#include <casacore/casa/Arrays/TiledShape.h>
//#include <casacore/casa/Arrays/LatticeIterator.h>
//#include <casacore/casa/Arrays/LatticeStepper.h>
//#include <casacore/casa/Arrays/TileStepper.h>
//#include <casacore/casa/Arrays/TiledLineStepper.h>

//#include <casacore/lattices/Lattices/SubLattice.h>
//#include <casacore/lattices/LEL/LatticeExpr.h>

//#include <casacore/lattices/LRegions/LatticeRegion.h>
//#include <casacore/lattices/LRegions/LCSlicer.h>
//#include <casacore/lattices/LRegions/LCBox.h>
//#include <casacore/lattices/LRegions/LCEllipsoid.h>
//#include <casacore/lattices/LRegions/LCPolygon.h>
//#include <casacore/lattices/LRegions/LCUnion.h>
//#include <casacore/lattices/LRegions/LCIntersection.h>
//#include <casacore/lattices/LRegions/LCDifference.h>
//#include <casacore/lattices/LRegions/LCConcatenation.h>
//#include <casacore/lattices/LRegions/LCComplement.h>
//#include <casacore/lattices/LRegions/LCExtension.h>


// <module>

// <summary>
// N-dimensional astronomical images
// </summary>

// <prerequisite>
//   <li> Programmers of new Image classes should understand Inheritance
//   <li> Users of the Image classes should understand Polymorphism.
//   <li> class <linkto class=Lattice>Lattice</linkto>
//   <li> class <linkto class=CoordinateSystem>CoordinateSystem</linkto>
// </prerequisite>

// <reviewed reviewer="UNKNOWN" date="before2004/08/25" demos="">
// </reviewed>

// <etymology>
// </etymology>

// <synopsis>
// </synopsis>

// <motivation>
// </motivation>

//# <todo asof="1998/11/02">
//# </todo>

// </module>


} //# NAMESPACE CASACORE - END

#endif
