
The following commands provide tools like
[manpage {CriTcl Application}] or similar with
deeper access to the package's internals.

[vset not_needed_for_critcl_script]

[list_begin definitions]

[comment ---------------------------------------------------------------------]
[call [cmd ::critcl::actualtarget]]

Returns the platform identifier for the target platform, i.e. the platform to
build for. Unlike [cmd ::critcl::targetplatform] this is the true target, with
any cross-compilation information resolved.

[comment ---------------------------------------------------------------------]
[call [cmd ::critcl::buildforpackage] [opt [arg flag]]]

Signals whether the next file is to be built for inclusion into a package. If
not specified the [arg flag] defaults to [const true], i.e. building for a
package. This disables a number of things in the backend, namely the linking of
that file into a shared library and the loading of that library. It is expected
that the build results are later wrapped into a larger collection.

[comment ---------------------------------------------------------------------]
[call [cmd ::critcl::cnothingtodo] [arg file]]

Checks whether there is anything to build for [arg file].

[comment ---------------------------------------------------------------------]
[call [cmd ::critcl::cresults] [opt [arg file]]]

Returns information about building [arg file], or [cmd {info script}] If
[arg file] is not provided.

The result in question is a dictionary containing the following items:

[list_begin definitions]
[def [const clibraries]]
A list of external shared libraries and/or directories needed to link
[arg file].

[def [const ldflags]]
A list of linker flags needed to link [arg file].

[def [const license]]
The text of the license for the package [arg file] is located in.

[def [const mintcl]]
The minimum version of Tcl required by the package [arg file]
is in to run successfully. A proper Tcl version number.

[def [const objects]]
A list of object files to link into [arg file].

[def [const preload]]
A list of libraries to be preloaded in order to sucessfully load and use
[arg file].

[def [const tk]]
[const true] if [arg file] requires Tk and [const false] otherwise.

[def [const tsources]]
A list of companion [file .tcl] files to source in order to load and use the
[term {CriTcl script}] [arg file].

[def [const log]]
The full build log generated by the compiler/linker, including command
line data from critcl, and other things.

[def [const exl]]
The raw build log generated by the compiler/linker. Contains the output
generated by the invoked applications.
[list_end]

[comment ---------------------------------------------------------------------]
[call [cmd ::critcl::crosscheck]]

Determines whether the package is configured for cross-compilation and prints a
message to the standard error channel if so.

[comment ---------------------------------------------------------------------]
[call [cmd ::critcl::error] [arg msg]]

Used to report internal errors. The default implementation simply returns the
error.  Tools like the [manpage {CriTcl Application}] are allowed to redefine
this procedure to perform their own way of error reporting. There is
one constraint they are not allowed to change: The procedure must
[emph {not return}] to the caller.

[comment ---------------------------------------------------------------------]
[call [cmd ::critcl::knowntargets]]

Returns a list of the identifiers of all targets
found during the last invocation of [cmd critcl::readconfig].

[comment ---------------------------------------------------------------------]
[call [cmd ::critcl::sharedlibext]]

Returns the file extension for shared libraries on the target platform.

[comment ---------------------------------------------------------------------]
[call [cmd ::critcl::targetconfig]]

Returns the identifier of the target to build for, as specified by either the
user or the system.

[comment ---------------------------------------------------------------------]
[call [cmd ::critcl::buildplatform]]

Returns the identifier of the build platform, i.e. where the package is running
on.

[comment ---------------------------------------------------------------------]
[call [cmd ::critcl::targetplatform]]

Returns the identifier of the target platform,
i.e. the platform to compile for. In contrast to
[cmd ::critcl::actualtarget] this may be the name of a
cross-compilation target.

[comment ---------------------------------------------------------------------]
[call [cmd ::critcl::cobjects] [opt [arg {glob pattern}]...]]

Like [cmd ::critcl::clibraries], but instead of matching libraries, each
[arg {glob pattern}] matches object files to be linked into the
shared object (at compile time, not runtime). If a [arg {glob pattern}] matches
nothing an error is returned.

Not listed in [sectref {Control & Interface}] because it is of no use to
package writers. Only tools like the [manpage {CriTcl Application}] need it.

[para] [vset relative_pattern]

[para] Calls to this command are cumulative.


[comment ---------------------------------------------------------------------]
[call [cmd ::critcl::scan] [arg path]]

The main entry point to CriTcl's static code scanner.  Used by tools to
implement processing modes like the assembly of a directory hierarchy
containing a TEA-lookalike buildystem, etc.

[para]
Scans [arg path] and returns a dictionary containing the following items:

[list_begin definitions]
[def version] Package version.
[def org] Author(ing organization).

[def files] List of the companion files, relative to the directory of the input
file.

[list_end]


[comment ---------------------------------------------------------------------]
[call [cmd ::critcl::name2c] [arg name]]

Given the Tcl-level identifier [arg name], returns a list containing the
following details of its conversion to C:

[list_begin itemized]
[item] Tcl namespace prefix
[item] C namespace prefix
[item] Tcl base name
[item] C base name
[list_end]

[para] For use by utilities that provide Tcl commands without going through
standard commands like [cmd critcl::ccommand] or [cmd critcl::cproc].
[package critcl::class] does this.

[list_end]
