/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.io.AlignFile;
import jalview.io.FileParse;
import jalview.util.Comparison;
import jalview.util.Format;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class MSFfile
extends AlignFile {
    public MSFfile() {
    }

    public MSFfile(String inFile, String type) throws IOException {
        super(inFile, type);
    }

    public MSFfile(FileParse source) throws IOException {
        super(source);
    }

    public void parse() throws IOException {
        int i = 0;
        boolean seqFlag = false;
        String key = new String();
        Vector<String> headers = new Vector<String>();
        Hashtable<String, StringBuffer> seqhash = new Hashtable<String, StringBuffer>();
        try {
            String line;
            while ((line = this.nextLine()) != null) {
                StringTokenizer str = new StringTokenizer(line);
                while (str.hasMoreTokens()) {
                    StringBuffer tempseq;
                    String inStr = str.nextToken();
                    if (inStr.indexOf("Name:") != -1) {
                        key = str.nextToken();
                        headers.addElement(key);
                    }
                    if (inStr.indexOf("//") != -1) {
                        seqFlag = true;
                    }
                    if (inStr.indexOf("//") != -1 || !seqFlag) continue;
                    key = inStr;
                    if (seqhash.containsKey(key)) {
                        tempseq = (StringBuffer)seqhash.get(key);
                    } else {
                        tempseq = new StringBuffer();
                        seqhash.put(key, tempseq);
                    }
                    while (str.hasMoreTokens()) {
                        tempseq.append(str.nextToken());
                    }
                }
            }
        }
        catch (IOException e) {
            System.err.println("Exception parsing MSFFile " + e);
            e.printStackTrace();
        }
        this.noSeqs = headers.size();
        for (i = 0; i < headers.size(); ++i) {
            if (seqhash.get(headers.elementAt(i)) != null) {
                String head = headers.elementAt(i).toString();
                String seq = seqhash.get(head).toString();
                if (this.maxLength < head.length()) {
                    this.maxLength = head.length();
                }
                seq = seq.replace('~', '-');
                Sequence newSeq = this.parseId(head);
                newSeq.setSequence(seq);
                this.seqs.addElement(newSeq);
                continue;
            }
            System.err.println("MSFFile Parser: Can't find sequence for " + headers.elementAt(i));
        }
    }

    public int checkSum(String seq) {
        int check = 0;
        String sequence = seq.toUpperCase();
        for (int i = 0; i < sequence.length(); ++i) {
            try {
                char value = sequence.charAt(i);
                if (value == '\uffffffff') continue;
                check += (i % 57 + 1) * value;
                continue;
            }
            catch (Exception e) {
                System.err.println("Exception during MSF Checksum calculation");
                e.printStackTrace();
            }
        }
        return check % 10000;
    }

    public String print(SequenceI[] seqs) {
        int i;
        boolean is_NA = Comparison.isNucleotide(seqs);
        SequenceI[] s = new SequenceI[seqs.length];
        StringBuffer out = new StringBuffer("!!" + (is_NA ? "NA" : "AA") + "_MULTIPLE_ALIGNMENT 1.0\n\n");
        int max = 0;
        int maxid = 0;
        for (i = 0; i < seqs.length && seqs[i] != null; ++i) {
            int ii;
            s[i] = new Sequence(seqs[i].getName(), seqs[i].getSequenceAsString().replace('-', '.'));
            StringBuffer sb = new StringBuffer();
            sb.append(s[i].getSequence());
            for (ii = 0; ii < sb.length() && sb.charAt(ii) == '.'; ++ii) {
                sb.setCharAt(ii, '~');
            }
            for (ii = sb.length() - 1; ii > 0 && sb.charAt(ii) == '.'; --ii) {
                sb.setCharAt(ii, '~');
            }
            s[i].setSequence(sb.toString());
            if (s[i].getSequence().length <= max) continue;
            max = s[i].getSequence().length;
        }
        Format maxLenpad = new Format("%" + new String("" + max).length() + "d");
        Format maxChkpad = new Format("%" + new String("1" + max).length() + "d");
        int bigChecksum = 0;
        int[] checksums = new int[s.length];
        for (i = 0; i < s.length; ++i) {
            checksums[i] = this.checkSum(s[i].getSequenceAsString());
            bigChecksum += checksums[i];
        }
        long maxNB = 0L;
        out.append("   MSF: " + s[0].getSequence().length + "   Type: " + (is_NA ? "N" : "P") + "    Check:  " + bigChecksum % 10000 + "   ..\n\n\n");
        String[] nameBlock = new String[s.length];
        String[] idBlock = new String[s.length];
        for (i = 0; i < s.length && s[i] != null; ++i) {
            nameBlock[i] = new String("  Name: " + this.printId(s[i]) + " ");
            idBlock[i] = new String("Len: " + maxLenpad.form(s[i].getSequence().length) + "  Check: " + maxChkpad.form(checksums[i]) + "  Weight: 1.00\n");
            if (s[i].getName().length() > maxid) {
                maxid = s[i].getName().length();
            }
            if ((long)nameBlock[i].length() <= maxNB) continue;
            maxNB = nameBlock[i].length();
        }
        if (maxid < 10) {
            maxid = 10;
        }
        if (maxNB < 15L) {
            maxNB = 15L;
        }
        Format nbFormat = new Format("%-" + maxNB + "s");
        for (i = 0; i < s.length && s[i] != null; ++i) {
            out.append(nbFormat.form(nameBlock[i]) + idBlock[i]);
        }
        ++maxid;
        out.append("\n\n//\n\n");
        int len = 50;
        int nochunks = max / len + 1;
        if (max % len == 0) {
            --nochunks;
        }
        for (i = 0; i < nochunks; ++i) {
            for (int j = 0; j < s.length && s[j] != null; ++j) {
                String name = this.printId(s[j]);
                out.append(new Format("%-" + maxid + "s").form(name + " "));
                for (int k = 0; k < 5; ++k) {
                    int start = i * 50 + k * 10;
                    int end = start + 10;
                    if (end < s[j].getSequence().length && start < s[j].getSequence().length) {
                        out.append(s[j].getSequence(start, end));
                        if (k < 4) {
                            out.append(" ");
                            continue;
                        }
                        out.append("\n");
                        continue;
                    }
                    if (start < s[j].getSequence().length) {
                        out.append(s[j].getSequenceAsString().substring(start));
                        out.append("\n");
                        continue;
                    }
                    if (k != 0) continue;
                    out.append("\n");
                }
            }
            out.append("\n");
        }
        return out.toString();
    }

    public String print() {
        return this.print(this.getSeqsAsArray());
    }
}

