!{\src2tex{textfont=tt}}
!!****m* etsf_gwdata/etsf_io_gwdata_put
!! NAME
!!  etsf_io_gwdata_put
!!
!! FUNCTION
!!    Write data related to the given group in an opened ETSF file (it must be in
!!    write mode, use etsf_io_low_set_write_mode() to change it).
!!    Only associated pointers of argument @folder will be accessed. If any errors
!!    occurs it returns with @lstat = .false..
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2010 (Damien Caliste)
!!  This file is distributed under the terms of the
!!  GNU Lesser General Public License, see the COPYING file
!!  or http://www.gnu.org/copyleft/lesser.txt .
!!
!! INPUTS
!! * ncid = 
!!     integer returned by an 'open' NetCDF call. The file can be 
!!     either in define or write mode. This status can be changed
!!     by the call.
!! * folder <type(etsf_gwdata)> = 
!!     an allocated structure with pointers on allocated areas in memory.
!!     These areas will be read or written if the pointer is associated, if
!!     not, the variable will be ignored. It is possible to access to specific
!!     dimensions of a variable using the <short_var_name>__kpoint_access or
!!     <short_var_name>__spin_access of this @folder structure. The 
!!     <short_var_name>__number_of_<something> can also been set if only a subpart
!!     in one dimension should be accessed (this is possible when the specifications
!!     have been declared with a max_number_of_<something>.
!! OUTPUT
!! * lstat = 
!!     return .true. if all the actions succeed, if not the status
!!     of the file is undefined.
!! * error_data <type(etsf_io_low_error)> = 
!!     contains the details of the error is @lstat is false.
!!
!! NOTES
!!  This file has been automatically generated by the autogen_subroutines.py
!!  script. Any change you would bring to it will systematically be
!!  overwritten.
!!
!! SOURCE
subroutine etsf_io_gwdata_put(ncid, folder, lstat, error_data)

  !Arguments ------------------------------------
  integer, intent(in) :: ncid
  type(etsf_gwdata), intent(in) :: folder
  logical, intent(out) :: lstat
  type(etsf_io_low_error), intent(out) :: error_data

  !Local variables-------------------------------
  character(len = *), parameter :: my_name = 'etsf_io_gwdata_put'
  integer,allocatable :: varid(:)
  integer,allocatable :: start(:)
  integer,allocatable :: count(:)
  integer :: len
  character(etsf_charlen) :: flag


  ! *************************************************************************

!DEBUG
!write (*,*) 'etsf_io_gwdata_put : enter'
!ENDDEBUG

  
  allocate(varid(4))
  ! Begin by putting the file in write mode.
  call etsf_io_low_set_write_mode(ncid, lstat, error_data = error_data)
  if (.not. lstat) then
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  
  if (etsf_io_low_var_associated(folder%gw_corrections)) then
    allocate(start(4), count(4))
    start(:) = 1
    count(:) = 0
    if (folder%gw_corrections__spin_access /= etsf_no_sub_access) then
      start(4) = folder%gw_corrections__spin_access
      count(4) = 1
    end if
    if (folder%gw_corrections__kpoint_access /= etsf_no_sub_access) then
      start(3) = folder%gw_corrections__kpoint_access
      count(3) = 1
    end if
    count(2) = folder%gw_corrections__number_of_states
    if (folder%gw_corrections__state_access /= etsf_no_sub_access) then
      start(2) = folder%gw_corrections__state_access
      count(2) = 1
    end if
    call etsf_io_low_write_var(ncid, "gw_corrections", &
                            & folder%gw_corrections, &
                            & lstat, ncvarid = varid(1), &
                            & error_data = error_data, start = start, count = count)
    deallocate(start, count)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (etsf_io_low_var_associated(folder%kb_formfactor_sign)) then
    allocate(start(3), count(3))
    start(:) = 1
    count(:) = 0
    count(2) = folder%kb_coeff_sig__number_of_angular_momenta
    count(1) = folder%kb_coeff_sig__number_of_projectors
    call etsf_io_low_write_var(ncid, "kb_formfactor_sign", &
                            & folder%kb_formfactor_sign, &
                            & lstat, ncvarid = varid(2), &
                            & error_data = error_data, start = start, count = count)
    deallocate(start, count)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (etsf_io_low_var_associated(folder%kb_formfactors)) then
    allocate(start(5), count(5))
    start(:) = 1
    count(:) = 0
    count(4) = folder%kb_coeff__number_of_angular_momenta
    count(3) = folder%kb_coeff__number_of_projectors
    if (folder%kb_coeff__kpoint_access /= etsf_no_sub_access) then
      start(2) = folder%kb_coeff__kpoint_access
      count(2) = 1
    end if
    count(1) = folder%kb_coeff__number_of_coefficients
    call etsf_io_low_write_var(ncid, "kb_formfactors", &
                            & folder%kb_formfactors, &
                            & lstat, ncvarid = varid(3), &
                            & error_data = error_data, start = start, count = count)
    deallocate(start, count)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (etsf_io_low_var_associated(folder%kb_formfactor_derivative)) then
    allocate(start(5), count(5))
    start(:) = 1
    count(:) = 0
    count(4) = folder%kb_coeff_der__number_of_angular_momenta
    count(3) = folder%kb_coeff_der__number_of_projectors
    if (folder%kb_coeff_der__kpoint_access /= etsf_no_sub_access) then
      start(2) = folder%kb_coeff_der__kpoint_access
      count(2) = 1
    end if
    count(1) = folder%kb_coeff_der__number_of_coefficients
    call etsf_io_low_write_var(ncid, "kb_formfactor_derivative", &
                            & folder%kb_formfactor_derivative, &
                            & lstat, ncvarid = varid(4), &
                            & error_data = error_data, start = start, count = count)
    deallocate(start, count)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  deallocate(varid)

!DEBUG
!write (*,*) 'etsf_io_gwdata_put : exit'
!ENDDEBUG

end subroutine etsf_io_gwdata_put
!!***
