// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file bitset_structTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#include "bitset_structTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>
#include "bitset_struct.hpp"


using namespace eprosima::fastdds::dds::xtypes;

void register_ColorBitset_type_identifier(
        TypeIdentifierPair& type_ids_ColorBitset)
{
    ReturnCode_t return_code_ColorBitset {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ColorBitset =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ColorBitset", type_ids_ColorBitset);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ColorBitset)
    {
        BitsetTypeFlag bitset_flags_ColorBitset = 0;
        QualifiedTypeName type_name_ColorBitset = "ColorBitset";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ColorBitset;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ColorBitset;
        CompleteTypeDetail detail_ColorBitset = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ColorBitset, ann_custom_ColorBitset, type_name_ColorBitset.to_string());
        CompleteBitsetHeader header_ColorBitset = TypeObjectUtils::build_complete_bitset_header(detail_ColorBitset);
        CompleteBitfieldSeq field_seq_ColorBitset;
        {
            uint16_t position_red = 0;
            BitsetMemberFlag flags_red = 0;
            uint8_t bitcount_red = 3;
            TypeKind holder_type_red = TK_UINT8;
            CommonBitfield common_red = TypeObjectUtils::build_common_bitfield(position_red, flags_red, bitcount_red, holder_type_red);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_red;
            ann_custom_ColorBitset.reset();
            MemberName name_red = "red";
            CompleteMemberDetail detail_red = TypeObjectUtils::build_complete_member_detail(name_red, member_ann_builtin_red, ann_custom_ColorBitset);
            CompleteBitfield bitfield_red = TypeObjectUtils::build_complete_bitfield(common_red, detail_red);
            TypeObjectUtils::add_complete_bitfield(field_seq_ColorBitset, bitfield_red);
        }
        {
            uint16_t position_green = 3;
            BitsetMemberFlag flags_green = 0;
            uint8_t bitcount_green = 1;
            TypeKind holder_type_green = TK_BOOLEAN;
            CommonBitfield common_green = TypeObjectUtils::build_common_bitfield(position_green, flags_green, bitcount_green, holder_type_green);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_green;
            ann_custom_ColorBitset.reset();
            MemberName name_green = "green";
            CompleteMemberDetail detail_green = TypeObjectUtils::build_complete_member_detail(name_green, member_ann_builtin_green, ann_custom_ColorBitset);
            CompleteBitfield bitfield_green = TypeObjectUtils::build_complete_bitfield(common_green, detail_green);
            TypeObjectUtils::add_complete_bitfield(field_seq_ColorBitset, bitfield_green);
        }
        {
            uint16_t position_blue = 8;
            BitsetMemberFlag flags_blue = 0;
            uint8_t bitcount_blue = 10;
            TypeKind holder_type_blue = TK_UINT16;
            CommonBitfield common_blue = TypeObjectUtils::build_common_bitfield(position_blue, flags_blue, bitcount_blue, holder_type_blue);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_blue;
            ann_custom_ColorBitset.reset();
            MemberName name_blue = "blue";
            CompleteMemberDetail detail_blue = TypeObjectUtils::build_complete_member_detail(name_blue, member_ann_builtin_blue, ann_custom_ColorBitset);
            CompleteBitfield bitfield_blue = TypeObjectUtils::build_complete_bitfield(common_blue, detail_blue);
            TypeObjectUtils::add_complete_bitfield(field_seq_ColorBitset, bitfield_blue);
        }
        {
            uint16_t position_yellow = 18;
            BitsetMemberFlag flags_yellow = 0;
            uint8_t bitcount_yellow = 12;
            TypeKind holder_type_yellow = TK_INT16;
            CommonBitfield common_yellow = TypeObjectUtils::build_common_bitfield(position_yellow, flags_yellow, bitcount_yellow, holder_type_yellow);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_yellow;
            ann_custom_ColorBitset.reset();
            MemberName name_yellow = "yellow";
            CompleteMemberDetail detail_yellow = TypeObjectUtils::build_complete_member_detail(name_yellow, member_ann_builtin_yellow, ann_custom_ColorBitset);
            CompleteBitfield bitfield_yellow = TypeObjectUtils::build_complete_bitfield(common_yellow, detail_yellow);
            TypeObjectUtils::add_complete_bitfield(field_seq_ColorBitset, bitfield_yellow);
        }
        CompleteBitsetType bitset_type_ColorBitset = TypeObjectUtils::build_complete_bitset_type(bitset_flags_ColorBitset, header_ColorBitset, field_seq_ColorBitset);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_bitset_type_object(bitset_type_ColorBitset,
                    type_name_ColorBitset.to_string(), type_ids_ColorBitset))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "ColorBitset already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_BitsetStruct_type_identifier(
        TypeIdentifierPair& type_ids_BitsetStruct)
{

    ReturnCode_t return_code_BitsetStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_BitsetStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "BitsetStruct", type_ids_BitsetStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_BitsetStruct)
    {
        StructTypeFlag struct_flags_BitsetStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_BitsetStruct = "BitsetStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_BitsetStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_BitsetStruct;
        AppliedAnnotationSeq tmp_ann_custom_BitsetStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_BitsetStruct;
        if (!tmp_ann_custom_BitsetStruct.empty())
        {
            ann_custom_BitsetStruct = tmp_ann_custom_BitsetStruct;
        }

        CompleteTypeDetail detail_BitsetStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_BitsetStruct, ann_custom_BitsetStruct, type_name_BitsetStruct.to_string());
        CompleteStructHeader header_BitsetStruct;
        header_BitsetStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_BitsetStruct);
        CompleteStructMemberSeq member_seq_BitsetStruct;
        {
            TypeIdentifierPair type_ids_my_bitset;
            ReturnCode_t return_code_my_bitset {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_bitset =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "ColorBitset", type_ids_my_bitset);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_bitset)
            {
            ::register_ColorBitset_type_identifier(type_ids_my_bitset);
            }
            StructMemberFlag member_flags_my_bitset = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_bitset = 0x00000000;
            bool common_my_bitset_ec {false};
            CommonStructMember common_my_bitset {TypeObjectUtils::build_common_struct_member(member_id_my_bitset, member_flags_my_bitset, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_bitset, common_my_bitset_ec))};
            if (!common_my_bitset_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_bitset member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_bitset = "my_bitset";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_bitset;
            ann_custom_BitsetStruct.reset();
            CompleteMemberDetail detail_my_bitset = TypeObjectUtils::build_complete_member_detail(name_my_bitset, member_ann_builtin_my_bitset, ann_custom_BitsetStruct);
            CompleteStructMember member_my_bitset = TypeObjectUtils::build_complete_struct_member(common_my_bitset, detail_my_bitset);
            TypeObjectUtils::add_complete_struct_member(member_seq_BitsetStruct, member_my_bitset);
        }
        CompleteStructType struct_type_BitsetStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_BitsetStruct, header_BitsetStruct, member_seq_BitsetStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_BitsetStruct, type_name_BitsetStruct.to_string(), type_ids_BitsetStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "BitsetStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
