# Filtlong supplementary scripts

This directory contains a script (`read_info_histograms.sh`) to assist with visualising read statistics. It uses a slightly modified version of the `histogram.py` file from the [data_hacks repo](https://github.com/bitly/data_hacks).

Importantly, this script uses Filtlong to generate the data for its histograms. That means the quality values visualised are the same ones that Filtlong will use for filtering. If you are planning to use Filtlong with Illumina reads as an external reference, run this script with Illumina reads as well, so the quality scores are consistent.



## Example output (without an external reference)

In this example, the qualities come from the FASTQ PHRED scores.

__Command__:
```
path/to/Filtlong/scripts/read_info_histograms.sh long_reads.fastq.gz
```

__Output__:
```
READ SET SUMMARY
----------------
number of reads: 62,313
number of bases: 498,400,580
N50 read length: 16,730


READ LENGTHS
------------
Each ∎ represents 1,044,446 bases
     0 -   3799 [45,923,686]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
  3799 -   7597 [73,111,261]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
  7597 -  11396 [63,135,675]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
 11396 -  15195 [49,558,377]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
 15195 -  18994 [40,910,839]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
 18994 -  22792 [34,441,187]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
 22792 -  26591 [28,738,160]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
 26591 -  30390 [24,738,026]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
 30390 -  34189 [22,096,602]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
 34189 -  37987 [18,985,609]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
 37987 -  41786 [15,406,318]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎
 41786 -  45585 [12,755,023]: ∎∎∎∎∎∎∎∎∎∎∎∎
 45585 -  49383 [12,919,019]: ∎∎∎∎∎∎∎∎∎∎∎∎
 49383 -  53182 [ 9,529,903]: ∎∎∎∎∎∎∎∎∎
 53182 -  56981 [ 7,744,484]: ∎∎∎∎∎∎∎
 56981 -  60780 [ 6,403,620]: ∎∎∎∎∎∎
 60780 -  64578 [ 5,626,494]: ∎∎∎∎∎
 64578 -  68377 [ 5,434,617]: ∎∎∎∎∎
 68377 -  72176 [ 3,851,906]: ∎∎∎
 72176 -  75974 [ 3,104,518]: ∎∎
 75974 -  79773 [ 2,723,174]: ∎∎
 79773 -  83572 [ 2,445,516]: ∎∎
 83572 -  87371 [ 1,622,746]: ∎
 87371 -  91169 [ 1,424,798]: ∎
 91169 -  94968 [ 1,018,819]: 
 94968 -  98767 [ 1,254,227]: ∎
 98767 - 102566 [ 1,000,129]: 
102566 - 106364 [   206,593]: 
106364 - 110163 [   217,310]: 
110163 - 113962 [   561,474]: 
113962 - 117760 [   233,150]: 
117760 - 121559 [   476,864]: 
121559 - 125358 [   248,209]: 
125358 - 129157 [         0]: 
129157 - 132955 [   262,547]: 
132955 - 136754 [         0]: 
136754 - 140553 [   137,751]: 
140553 - 144352 [         0]: 
144352 - 148150 [         0]: 
148150 - 151949 [   151,949]: 


MEAN QUALITIES
--------------
Each ∎ represents 984,822 bases
65.6 - 66.3 [     4,750]: 
66.3 - 67.1 [       533]: 
67.1 - 67.8 [    43,474]: 
67.8 - 68.6 [     1,568]: 
68.6 - 69.3 [    24,007]: 
69.3 - 70.1 [    33,284]: 
70.1 - 70.8 [    80,237]: 
70.8 - 71.6 [    74,948]: 
71.6 - 72.3 [   125,425]: 
72.3 - 73.1 [   193,567]: 
73.1 - 73.8 [   179,704]: 
73.8 - 74.5 [   337,987]: 
74.5 - 75.3 [   659,382]: 
75.3 - 76.0 [   715,250]: 
76.0 - 76.8 [   890,534]: 
76.8 - 77.5 [ 1,117,521]: ∎
77.5 - 78.3 [ 1,309,180]: ∎
78.3 - 79.0 [ 1,732,547]: ∎
79.0 - 79.8 [ 2,328,104]: ∎∎
79.8 - 80.5 [ 3,276,277]: ∎∎∎
80.5 - 81.3 [ 3,484,277]: ∎∎∎
81.3 - 82.0 [ 4,759,691]: ∎∎∎∎
82.0 - 82.7 [ 6,444,131]: ∎∎∎∎∎∎
82.7 - 83.5 [ 7,473,861]: ∎∎∎∎∎∎∎
83.5 - 84.2 [ 9,623,707]: ∎∎∎∎∎∎∎∎∎
84.2 - 85.0 [11,909,590]: ∎∎∎∎∎∎∎∎∎∎∎∎
85.0 - 85.7 [14,997,120]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
85.7 - 86.5 [19,717,703]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
86.5 - 87.2 [25,483,029]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
87.2 - 88.0 [29,508,578]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
88.0 - 88.7 [36,579,391]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
88.7 - 89.4 [44,757,036]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
89.4 - 90.2 [54,706,747]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
90.2 - 90.9 [64,024,337]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
90.9 - 91.7 [68,937,558]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
91.7 - 92.4 [54,405,581]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
92.4 - 93.2 [24,211,000]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
93.2 - 93.9 [ 3,607,372]: ∎∎∎
93.9 - 94.7 [   623,042]: 
94.7 - 95.4 [    18,550]: 


WINDOW QUALITIES
----------------
Each ∎ represents 512,055 bases
53.3 - 54.4 [    43,895]: 
54.4 - 55.4 [    32,903]: 
55.4 - 56.5 [    10,451]: 
56.5 - 57.5 [    93,358]: 
57.5 - 58.6 [   125,071]: 
58.6 - 59.6 [    61,604]: 
59.6 - 60.6 [   631,021]: ∎
60.6 - 61.7 [   770,097]: ∎
61.7 - 62.7 [ 1,088,376]: ∎∎
62.7 - 63.8 [ 1,288,929]: ∎∎
63.8 - 64.8 [ 1,557,672]: ∎∎∎
64.8 - 65.9 [ 3,623,305]: ∎∎∎∎∎∎∎
65.9 - 66.9 [ 3,870,845]: ∎∎∎∎∎∎∎
66.9 - 67.9 [ 5,679,487]: ∎∎∎∎∎∎∎∎∎∎∎
67.9 - 69.0 [ 7,660,899]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎
69.0 - 70.0 [10,257,283]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
70.0 - 71.1 [10,923,548]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
71.1 - 72.1 [12,823,586]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
72.1 - 73.2 [14,691,154]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
73.2 - 74.2 [17,058,927]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
74.2 - 75.3 [19,953,105]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
75.3 - 76.3 [21,729,076]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
76.3 - 77.3 [23,635,419]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
77.3 - 78.4 [24,208,910]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
78.4 - 79.4 [29,229,242]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
79.4 - 80.5 [30,320,254]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
80.5 - 81.5 [31,582,509]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
81.5 - 82.6 [34,303,771]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
82.6 - 83.6 [35,740,373]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
83.6 - 84.6 [35,843,870]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
84.6 - 85.7 [34,414,639]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
85.7 - 86.7 [31,090,589]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
86.7 - 87.8 [24,992,027]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
87.8 - 88.8 [16,361,297]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
88.8 - 89.9 [ 8,641,030]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
89.9 - 90.9 [ 2,927,227]: ∎∎∎∎∎
90.9 - 91.9 [   875,281]: ∎
91.9 - 93.0 [   204,049]: 
93.0 - 94.0 [    49,040]: 
94.0 - 95.1 [     6,461]: 
```

Based on the histograms, I might choose the following conservative quality thresholds: `--min_length 5000 --min_mean_q 80 --min_window_q 65`


<br><br><br>


## Example with Illumina reads as an external reference

This example uses the same dataset as the previous one, but the qualities now come from k-mer matches to Illumina reads. The qualities are therefore different but the read length information is unchanged.

__Command__:
```
path/to/Filtlong/scripts/read_info_histograms.sh long_reads.fastq.gz illumina_1.fastq.gz illumina_2.fastq.gz
```

__Output__:
```
READ SET SUMMARY
----------------
number of reads: 62,313
number of bases: 498,400,580
N50 read length: 16,730


READ LENGTHS
------------
Each ∎ represents 1,044,446 bases
     0 -   3799 [45,923,686]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
  3799 -   7597 [73,111,261]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
  7597 -  11396 [63,135,675]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
 11396 -  15195 [49,558,377]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
 15195 -  18994 [40,910,839]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
 18994 -  22792 [34,441,187]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
 22792 -  26591 [28,738,160]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
 26591 -  30390 [24,738,026]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
 30390 -  34189 [22,096,602]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
 34189 -  37987 [18,985,609]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
 37987 -  41786 [15,406,318]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎
 41786 -  45585 [12,755,023]: ∎∎∎∎∎∎∎∎∎∎∎∎
 45585 -  49383 [12,919,019]: ∎∎∎∎∎∎∎∎∎∎∎∎
 49383 -  53182 [ 9,529,903]: ∎∎∎∎∎∎∎∎∎
 53182 -  56981 [ 7,744,484]: ∎∎∎∎∎∎∎
 56981 -  60780 [ 6,403,620]: ∎∎∎∎∎∎
 60780 -  64578 [ 5,626,494]: ∎∎∎∎∎
 64578 -  68377 [ 5,434,617]: ∎∎∎∎∎
 68377 -  72176 [ 3,851,906]: ∎∎∎
 72176 -  75974 [ 3,104,518]: ∎∎
 75974 -  79773 [ 2,723,174]: ∎∎
 79773 -  83572 [ 2,445,516]: ∎∎
 83572 -  87371 [ 1,622,746]: ∎
 87371 -  91169 [ 1,424,798]: ∎
 91169 -  94968 [ 1,018,819]: 
 94968 -  98767 [ 1,254,227]: ∎
 98767 - 102566 [ 1,000,129]: 
102566 - 106364 [   206,593]: 
106364 - 110163 [   217,310]: 
110163 - 113962 [   561,474]: 
113962 - 117760 [   233,150]: 
117760 - 121559 [   476,864]: 
121559 - 125358 [   248,209]: 
125358 - 129157 [         0]: 
129157 - 132955 [   262,547]: 
132955 - 136754 [         0]: 
136754 - 140553 [   137,751]: 
140553 - 144352 [         0]: 
144352 - 148150 [         0]: 
148150 - 151949 [   151,949]: 


MEAN QUALITIES
--------------
Each ∎ represents 677,887 bases
 0.0 -  2.5 [    67,263]: 
 2.5 -  4.9 [    82,815]: 
 4.9 -  7.4 [   256,950]: 
 7.4 -  9.9 [   749,158]: ∎
 9.9 - 12.3 [ 1,152,658]: ∎
12.3 - 14.8 [ 1,754,082]: ∎∎
14.8 - 17.3 [ 3,059,964]: ∎∎∎∎
17.3 - 19.7 [ 5,408,847]: ∎∎∎∎∎∎∎
19.7 - 22.2 [ 7,510,681]: ∎∎∎∎∎∎∎∎∎∎∎
22.2 - 24.6 [ 4,006,337]: ∎∎∎∎∎
24.6 - 27.1 [ 2,801,778]: ∎∎∎∎
27.1 - 29.6 [ 2,502,685]: ∎∎∎
29.6 - 32.0 [ 3,258,647]: ∎∎∎∎
32.0 - 34.5 [ 3,435,155]: ∎∎∎∎∎
34.5 - 37.0 [ 4,278,777]: ∎∎∎∎∎∎
37.0 - 39.4 [ 4,983,333]: ∎∎∎∎∎∎∎
39.4 - 41.9 [ 6,439,521]: ∎∎∎∎∎∎∎∎∎
41.9 - 44.4 [ 7,588,641]: ∎∎∎∎∎∎∎∎∎∎∎
44.4 - 46.8 [ 8,908,943]: ∎∎∎∎∎∎∎∎∎∎∎∎∎
46.8 - 49.3 [10,001,462]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎
49.3 - 51.8 [12,713,431]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
51.8 - 54.2 [16,136,550]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
54.2 - 56.7 [18,115,381]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
56.7 - 59.1 [21,659,142]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
59.1 - 61.6 [23,166,427]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
61.6 - 64.1 [25,919,731]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
64.1 - 66.5 [31,712,427]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
66.5 - 69.0 [36,552,017]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
69.0 - 71.5 [41,159,323]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
71.5 - 73.9 [46,002,774]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
73.9 - 76.4 [47,452,136]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
76.4 - 78.9 [46,485,175]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
78.9 - 81.3 [32,871,399]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
81.3 - 83.8 [15,072,800]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
83.8 - 86.3 [ 3,755,240]: ∎∎∎∎∎
86.3 - 88.7 [   961,203]: ∎
88.7 - 91.2 [   370,319]: 
91.2 - 93.7 [    36,939]: 
93.7 - 96.1 [     8,536]: 
96.1 - 98.6 [     1,933]: 


WINDOW QUALITIES
----------------
Each ∎ represents 1,223,100 bases
 0.0 -  2.5 [85,617,025]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
 2.5 -  4.9 [ 4,646,208]: ∎∎∎
 4.9 -  7.4 [42,058,882]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
 7.4 -  9.9 [20,326,766]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
 9.9 - 12.3 [12,648,808]: ∎∎∎∎∎∎∎∎∎∎
12.3 - 14.8 [33,893,701]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
14.8 - 17.3 [24,865,373]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
17.3 - 19.8 [20,757,969]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
19.8 - 22.2 [24,508,676]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
22.2 - 24.7 [24,211,150]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
24.7 - 27.2 [22,883,942]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
27.2 - 29.6 [25,860,478]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
29.6 - 32.1 [21,054,189]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
32.1 - 34.6 [20,389,975]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎∎
34.6 - 37.0 [17,721,925]: ∎∎∎∎∎∎∎∎∎∎∎∎∎∎
37.0 - 39.5 [16,808,916]: ∎∎∎∎∎∎∎∎∎∎∎∎∎
39.5 - 42.0 [14,247,451]: ∎∎∎∎∎∎∎∎∎∎∎
42.0 - 44.5 [16,429,129]: ∎∎∎∎∎∎∎∎∎∎∎∎∎
44.5 - 46.9 [11,544,406]: ∎∎∎∎∎∎∎∎∎
46.9 - 49.4 [ 9,910,130]: ∎∎∎∎∎∎∎∎
49.4 - 51.9 [ 7,622,653]: ∎∎∎∎∎∎
51.9 - 54.3 [ 5,814,027]: ∎∎∎∎
54.3 - 56.8 [ 4,865,746]: ∎∎∎
56.8 - 59.3 [ 3,159,894]: ∎∎
59.3 - 61.8 [ 2,174,103]: ∎
61.8 - 64.2 [ 1,399,105]: ∎
64.2 - 66.7 [ 1,003,958]: 
66.7 - 69.2 [   637,184]: 
69.2 - 71.6 [   508,873]: 
71.6 - 74.1 [   255,636]: 
74.1 - 76.6 [   183,048]: 
76.6 - 79.0 [   145,158]: 
79.0 - 81.5 [    92,925]: 
81.5 - 84.0 [    61,294]: 
84.0 - 86.5 [    46,942]: 
86.5 - 88.9 [    20,743]: 
88.9 - 91.4 [    14,950]: 
91.4 - 93.9 [     5,187]: 
93.9 - 96.3 [     3,171]: 
96.3 - 98.8 [       884]:
```

There is an interesting bimodel distribution in the mean quality histogram. I hypothesise that the larger (higher quality) component is from real reads, while the smaller (lower quality) component is junk. To filter conservatively, I would perhaps just use `--min_mean_q 30`. To filter more aggressively, I would also use `--min_window_q 5`.
