// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package f3

import (
	"fmt"

	"code.forgejo.org/f3/gof3/v3/f3"
)

func NewTopicPath[T any](id T) Path {
	return NewPathFromString(NewTopicPathString(id))
}

func NewTopicPathString[T any](id T) string {
	return fmt.Sprintf("/forge/topics/%v", id)
}

func NewTopicReference[T any](id T) *f3.Reference {
	return f3.NewReference(NewTopicPathString(id))
}
