// Code generated by smithy-go-codegen DO NOT EDIT.

package pinpointemail

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/pinpointemail/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpCreateConfigurationSet struct {
}

func (*awsRestjson1_serializeOpCreateConfigurationSet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateConfigurationSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateConfigurationSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/configuration-sets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateConfigurationSetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateConfigurationSetInput(v *CreateConfigurationSetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateConfigurationSetInput(v *CreateConfigurationSetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConfigurationSetName != nil {
		ok := object.Key("ConfigurationSetName")
		ok.String(*v.ConfigurationSetName)
	}

	if v.DeliveryOptions != nil {
		ok := object.Key("DeliveryOptions")
		if err := awsRestjson1_serializeDocumentDeliveryOptions(v.DeliveryOptions, ok); err != nil {
			return err
		}
	}

	if v.ReputationOptions != nil {
		ok := object.Key("ReputationOptions")
		if err := awsRestjson1_serializeDocumentReputationOptions(v.ReputationOptions, ok); err != nil {
			return err
		}
	}

	if v.SendingOptions != nil {
		ok := object.Key("SendingOptions")
		if err := awsRestjson1_serializeDocumentSendingOptions(v.SendingOptions, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TrackingOptions != nil {
		ok := object.Key("TrackingOptions")
		if err := awsRestjson1_serializeDocumentTrackingOptions(v.TrackingOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateConfigurationSetEventDestination struct {
}

func (*awsRestjson1_serializeOpCreateConfigurationSetEventDestination) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateConfigurationSetEventDestination) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateConfigurationSetEventDestinationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/configuration-sets/{ConfigurationSetName}/event-destinations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateConfigurationSetEventDestinationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateConfigurationSetEventDestinationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateConfigurationSetEventDestinationInput(v *CreateConfigurationSetEventDestinationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConfigurationSetName == nil || len(*v.ConfigurationSetName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ConfigurationSetName must not be empty")}
	}
	if v.ConfigurationSetName != nil {
		if err := encoder.SetURI("ConfigurationSetName").String(*v.ConfigurationSetName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateConfigurationSetEventDestinationInput(v *CreateConfigurationSetEventDestinationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EventDestination != nil {
		ok := object.Key("EventDestination")
		if err := awsRestjson1_serializeDocumentEventDestinationDefinition(v.EventDestination, ok); err != nil {
			return err
		}
	}

	if v.EventDestinationName != nil {
		ok := object.Key("EventDestinationName")
		ok.String(*v.EventDestinationName)
	}

	return nil
}

type awsRestjson1_serializeOpCreateDedicatedIpPool struct {
}

func (*awsRestjson1_serializeOpCreateDedicatedIpPool) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateDedicatedIpPool) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDedicatedIpPoolInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/dedicated-ip-pools")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateDedicatedIpPoolInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateDedicatedIpPoolInput(v *CreateDedicatedIpPoolInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateDedicatedIpPoolInput(v *CreateDedicatedIpPoolInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PoolName != nil {
		ok := object.Key("PoolName")
		ok.String(*v.PoolName)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateDeliverabilityTestReport struct {
}

func (*awsRestjson1_serializeOpCreateDeliverabilityTestReport) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateDeliverabilityTestReport) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDeliverabilityTestReportInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/deliverability-dashboard/test")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateDeliverabilityTestReportInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateDeliverabilityTestReportInput(v *CreateDeliverabilityTestReportInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateDeliverabilityTestReportInput(v *CreateDeliverabilityTestReportInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Content != nil {
		ok := object.Key("Content")
		if err := awsRestjson1_serializeDocumentEmailContent(v.Content, ok); err != nil {
			return err
		}
	}

	if v.FromEmailAddress != nil {
		ok := object.Key("FromEmailAddress")
		ok.String(*v.FromEmailAddress)
	}

	if v.ReportName != nil {
		ok := object.Key("ReportName")
		ok.String(*v.ReportName)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateEmailIdentity struct {
}

func (*awsRestjson1_serializeOpCreateEmailIdentity) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateEmailIdentity) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateEmailIdentityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/identities")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateEmailIdentityInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateEmailIdentityInput(v *CreateEmailIdentityInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateEmailIdentityInput(v *CreateEmailIdentityInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EmailIdentity != nil {
		ok := object.Key("EmailIdentity")
		ok.String(*v.EmailIdentity)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteConfigurationSet struct {
}

func (*awsRestjson1_serializeOpDeleteConfigurationSet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteConfigurationSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteConfigurationSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/configuration-sets/{ConfigurationSetName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteConfigurationSetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteConfigurationSetInput(v *DeleteConfigurationSetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConfigurationSetName == nil || len(*v.ConfigurationSetName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ConfigurationSetName must not be empty")}
	}
	if v.ConfigurationSetName != nil {
		if err := encoder.SetURI("ConfigurationSetName").String(*v.ConfigurationSetName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteConfigurationSetEventDestination struct {
}

func (*awsRestjson1_serializeOpDeleteConfigurationSetEventDestination) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteConfigurationSetEventDestination) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteConfigurationSetEventDestinationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/configuration-sets/{ConfigurationSetName}/event-destinations/{EventDestinationName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteConfigurationSetEventDestinationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteConfigurationSetEventDestinationInput(v *DeleteConfigurationSetEventDestinationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConfigurationSetName == nil || len(*v.ConfigurationSetName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ConfigurationSetName must not be empty")}
	}
	if v.ConfigurationSetName != nil {
		if err := encoder.SetURI("ConfigurationSetName").String(*v.ConfigurationSetName); err != nil {
			return err
		}
	}

	if v.EventDestinationName == nil || len(*v.EventDestinationName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member EventDestinationName must not be empty")}
	}
	if v.EventDestinationName != nil {
		if err := encoder.SetURI("EventDestinationName").String(*v.EventDestinationName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteDedicatedIpPool struct {
}

func (*awsRestjson1_serializeOpDeleteDedicatedIpPool) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteDedicatedIpPool) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDedicatedIpPoolInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/dedicated-ip-pools/{PoolName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteDedicatedIpPoolInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteDedicatedIpPoolInput(v *DeleteDedicatedIpPoolInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.PoolName == nil || len(*v.PoolName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member PoolName must not be empty")}
	}
	if v.PoolName != nil {
		if err := encoder.SetURI("PoolName").String(*v.PoolName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteEmailIdentity struct {
}

func (*awsRestjson1_serializeOpDeleteEmailIdentity) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteEmailIdentity) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteEmailIdentityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/identities/{EmailIdentity}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteEmailIdentityInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteEmailIdentityInput(v *DeleteEmailIdentityInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.EmailIdentity == nil || len(*v.EmailIdentity) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member EmailIdentity must not be empty")}
	}
	if v.EmailIdentity != nil {
		if err := encoder.SetURI("EmailIdentity").String(*v.EmailIdentity); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetAccount struct {
}

func (*awsRestjson1_serializeOpGetAccount) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetAccount) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetAccountInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/account")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetAccountInput(v *GetAccountInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpGetBlacklistReports struct {
}

func (*awsRestjson1_serializeOpGetBlacklistReports) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetBlacklistReports) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBlacklistReportsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/deliverability-dashboard/blacklist-report")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetBlacklistReportsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetBlacklistReportsInput(v *GetBlacklistReportsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BlacklistItemNames != nil {
		for i := range v.BlacklistItemNames {
			encoder.AddQuery("BlacklistItemNames").String(v.BlacklistItemNames[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetConfigurationSet struct {
}

func (*awsRestjson1_serializeOpGetConfigurationSet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetConfigurationSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetConfigurationSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/configuration-sets/{ConfigurationSetName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetConfigurationSetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetConfigurationSetInput(v *GetConfigurationSetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConfigurationSetName == nil || len(*v.ConfigurationSetName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ConfigurationSetName must not be empty")}
	}
	if v.ConfigurationSetName != nil {
		if err := encoder.SetURI("ConfigurationSetName").String(*v.ConfigurationSetName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetConfigurationSetEventDestinations struct {
}

func (*awsRestjson1_serializeOpGetConfigurationSetEventDestinations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetConfigurationSetEventDestinations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetConfigurationSetEventDestinationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/configuration-sets/{ConfigurationSetName}/event-destinations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetConfigurationSetEventDestinationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetConfigurationSetEventDestinationsInput(v *GetConfigurationSetEventDestinationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConfigurationSetName == nil || len(*v.ConfigurationSetName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ConfigurationSetName must not be empty")}
	}
	if v.ConfigurationSetName != nil {
		if err := encoder.SetURI("ConfigurationSetName").String(*v.ConfigurationSetName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetDedicatedIp struct {
}

func (*awsRestjson1_serializeOpGetDedicatedIp) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetDedicatedIp) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDedicatedIpInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/dedicated-ips/{Ip}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetDedicatedIpInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetDedicatedIpInput(v *GetDedicatedIpInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Ip == nil || len(*v.Ip) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Ip must not be empty")}
	}
	if v.Ip != nil {
		if err := encoder.SetURI("Ip").String(*v.Ip); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetDedicatedIps struct {
}

func (*awsRestjson1_serializeOpGetDedicatedIps) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetDedicatedIps) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDedicatedIpsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/dedicated-ips")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetDedicatedIpsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetDedicatedIpsInput(v *GetDedicatedIpsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	if v.PageSize != nil {
		encoder.SetQuery("PageSize").Integer(*v.PageSize)
	}

	if v.PoolName != nil {
		encoder.SetQuery("PoolName").String(*v.PoolName)
	}

	return nil
}

type awsRestjson1_serializeOpGetDeliverabilityDashboardOptions struct {
}

func (*awsRestjson1_serializeOpGetDeliverabilityDashboardOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetDeliverabilityDashboardOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDeliverabilityDashboardOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/deliverability-dashboard")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetDeliverabilityDashboardOptionsInput(v *GetDeliverabilityDashboardOptionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpGetDeliverabilityTestReport struct {
}

func (*awsRestjson1_serializeOpGetDeliverabilityTestReport) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetDeliverabilityTestReport) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDeliverabilityTestReportInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/deliverability-dashboard/test-reports/{ReportId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetDeliverabilityTestReportInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetDeliverabilityTestReportInput(v *GetDeliverabilityTestReportInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ReportId == nil || len(*v.ReportId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ReportId must not be empty")}
	}
	if v.ReportId != nil {
		if err := encoder.SetURI("ReportId").String(*v.ReportId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetDomainDeliverabilityCampaign struct {
}

func (*awsRestjson1_serializeOpGetDomainDeliverabilityCampaign) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetDomainDeliverabilityCampaign) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDomainDeliverabilityCampaignInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/deliverability-dashboard/campaigns/{CampaignId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetDomainDeliverabilityCampaignInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetDomainDeliverabilityCampaignInput(v *GetDomainDeliverabilityCampaignInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CampaignId == nil || len(*v.CampaignId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member CampaignId must not be empty")}
	}
	if v.CampaignId != nil {
		if err := encoder.SetURI("CampaignId").String(*v.CampaignId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetDomainStatisticsReport struct {
}

func (*awsRestjson1_serializeOpGetDomainStatisticsReport) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetDomainStatisticsReport) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDomainStatisticsReportInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/deliverability-dashboard/statistics-report/{Domain}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetDomainStatisticsReportInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetDomainStatisticsReportInput(v *GetDomainStatisticsReportInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Domain == nil || len(*v.Domain) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Domain must not be empty")}
	}
	if v.Domain != nil {
		if err := encoder.SetURI("Domain").String(*v.Domain); err != nil {
			return err
		}
	}

	if v.EndDate != nil {
		encoder.SetQuery("EndDate").String(smithytime.FormatDateTime(*v.EndDate))
	}

	if v.StartDate != nil {
		encoder.SetQuery("StartDate").String(smithytime.FormatDateTime(*v.StartDate))
	}

	return nil
}

type awsRestjson1_serializeOpGetEmailIdentity struct {
}

func (*awsRestjson1_serializeOpGetEmailIdentity) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetEmailIdentity) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetEmailIdentityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/identities/{EmailIdentity}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetEmailIdentityInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetEmailIdentityInput(v *GetEmailIdentityInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.EmailIdentity == nil || len(*v.EmailIdentity) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member EmailIdentity must not be empty")}
	}
	if v.EmailIdentity != nil {
		if err := encoder.SetURI("EmailIdentity").String(*v.EmailIdentity); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListConfigurationSets struct {
}

func (*awsRestjson1_serializeOpListConfigurationSets) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListConfigurationSets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListConfigurationSetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/configuration-sets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListConfigurationSetsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListConfigurationSetsInput(v *ListConfigurationSetsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	if v.PageSize != nil {
		encoder.SetQuery("PageSize").Integer(*v.PageSize)
	}

	return nil
}

type awsRestjson1_serializeOpListDedicatedIpPools struct {
}

func (*awsRestjson1_serializeOpListDedicatedIpPools) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDedicatedIpPools) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDedicatedIpPoolsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/dedicated-ip-pools")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDedicatedIpPoolsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDedicatedIpPoolsInput(v *ListDedicatedIpPoolsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	if v.PageSize != nil {
		encoder.SetQuery("PageSize").Integer(*v.PageSize)
	}

	return nil
}

type awsRestjson1_serializeOpListDeliverabilityTestReports struct {
}

func (*awsRestjson1_serializeOpListDeliverabilityTestReports) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDeliverabilityTestReports) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDeliverabilityTestReportsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/deliverability-dashboard/test-reports")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDeliverabilityTestReportsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDeliverabilityTestReportsInput(v *ListDeliverabilityTestReportsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	if v.PageSize != nil {
		encoder.SetQuery("PageSize").Integer(*v.PageSize)
	}

	return nil
}

type awsRestjson1_serializeOpListDomainDeliverabilityCampaigns struct {
}

func (*awsRestjson1_serializeOpListDomainDeliverabilityCampaigns) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDomainDeliverabilityCampaigns) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDomainDeliverabilityCampaignsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/deliverability-dashboard/domains/{SubscribedDomain}/campaigns")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDomainDeliverabilityCampaignsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDomainDeliverabilityCampaignsInput(v *ListDomainDeliverabilityCampaignsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.EndDate != nil {
		encoder.SetQuery("EndDate").String(smithytime.FormatDateTime(*v.EndDate))
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	if v.PageSize != nil {
		encoder.SetQuery("PageSize").Integer(*v.PageSize)
	}

	if v.StartDate != nil {
		encoder.SetQuery("StartDate").String(smithytime.FormatDateTime(*v.StartDate))
	}

	if v.SubscribedDomain == nil || len(*v.SubscribedDomain) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SubscribedDomain must not be empty")}
	}
	if v.SubscribedDomain != nil {
		if err := encoder.SetURI("SubscribedDomain").String(*v.SubscribedDomain); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListEmailIdentities struct {
}

func (*awsRestjson1_serializeOpListEmailIdentities) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListEmailIdentities) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListEmailIdentitiesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/identities")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListEmailIdentitiesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListEmailIdentitiesInput(v *ListEmailIdentitiesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	if v.PageSize != nil {
		encoder.SetQuery("PageSize").Integer(*v.PageSize)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/tags")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn != nil {
		encoder.SetQuery("ResourceArn").String(*v.ResourceArn)
	}

	return nil
}

type awsRestjson1_serializeOpPutAccountDedicatedIpWarmupAttributes struct {
}

func (*awsRestjson1_serializeOpPutAccountDedicatedIpWarmupAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutAccountDedicatedIpWarmupAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutAccountDedicatedIpWarmupAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/account/dedicated-ips/warmup")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutAccountDedicatedIpWarmupAttributesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutAccountDedicatedIpWarmupAttributesInput(v *PutAccountDedicatedIpWarmupAttributesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutAccountDedicatedIpWarmupAttributesInput(v *PutAccountDedicatedIpWarmupAttributesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AutoWarmupEnabled {
		ok := object.Key("AutoWarmupEnabled")
		ok.Boolean(v.AutoWarmupEnabled)
	}

	return nil
}

type awsRestjson1_serializeOpPutAccountSendingAttributes struct {
}

func (*awsRestjson1_serializeOpPutAccountSendingAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutAccountSendingAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutAccountSendingAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/account/sending")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutAccountSendingAttributesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutAccountSendingAttributesInput(v *PutAccountSendingAttributesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutAccountSendingAttributesInput(v *PutAccountSendingAttributesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SendingEnabled {
		ok := object.Key("SendingEnabled")
		ok.Boolean(v.SendingEnabled)
	}

	return nil
}

type awsRestjson1_serializeOpPutConfigurationSetDeliveryOptions struct {
}

func (*awsRestjson1_serializeOpPutConfigurationSetDeliveryOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutConfigurationSetDeliveryOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutConfigurationSetDeliveryOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/configuration-sets/{ConfigurationSetName}/delivery-options")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutConfigurationSetDeliveryOptionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutConfigurationSetDeliveryOptionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutConfigurationSetDeliveryOptionsInput(v *PutConfigurationSetDeliveryOptionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConfigurationSetName == nil || len(*v.ConfigurationSetName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ConfigurationSetName must not be empty")}
	}
	if v.ConfigurationSetName != nil {
		if err := encoder.SetURI("ConfigurationSetName").String(*v.ConfigurationSetName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutConfigurationSetDeliveryOptionsInput(v *PutConfigurationSetDeliveryOptionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SendingPoolName != nil {
		ok := object.Key("SendingPoolName")
		ok.String(*v.SendingPoolName)
	}

	if len(v.TlsPolicy) > 0 {
		ok := object.Key("TlsPolicy")
		ok.String(string(v.TlsPolicy))
	}

	return nil
}

type awsRestjson1_serializeOpPutConfigurationSetReputationOptions struct {
}

func (*awsRestjson1_serializeOpPutConfigurationSetReputationOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutConfigurationSetReputationOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutConfigurationSetReputationOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/configuration-sets/{ConfigurationSetName}/reputation-options")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutConfigurationSetReputationOptionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutConfigurationSetReputationOptionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutConfigurationSetReputationOptionsInput(v *PutConfigurationSetReputationOptionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConfigurationSetName == nil || len(*v.ConfigurationSetName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ConfigurationSetName must not be empty")}
	}
	if v.ConfigurationSetName != nil {
		if err := encoder.SetURI("ConfigurationSetName").String(*v.ConfigurationSetName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutConfigurationSetReputationOptionsInput(v *PutConfigurationSetReputationOptionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ReputationMetricsEnabled {
		ok := object.Key("ReputationMetricsEnabled")
		ok.Boolean(v.ReputationMetricsEnabled)
	}

	return nil
}

type awsRestjson1_serializeOpPutConfigurationSetSendingOptions struct {
}

func (*awsRestjson1_serializeOpPutConfigurationSetSendingOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutConfigurationSetSendingOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutConfigurationSetSendingOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/configuration-sets/{ConfigurationSetName}/sending")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutConfigurationSetSendingOptionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutConfigurationSetSendingOptionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutConfigurationSetSendingOptionsInput(v *PutConfigurationSetSendingOptionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConfigurationSetName == nil || len(*v.ConfigurationSetName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ConfigurationSetName must not be empty")}
	}
	if v.ConfigurationSetName != nil {
		if err := encoder.SetURI("ConfigurationSetName").String(*v.ConfigurationSetName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutConfigurationSetSendingOptionsInput(v *PutConfigurationSetSendingOptionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SendingEnabled {
		ok := object.Key("SendingEnabled")
		ok.Boolean(v.SendingEnabled)
	}

	return nil
}

type awsRestjson1_serializeOpPutConfigurationSetTrackingOptions struct {
}

func (*awsRestjson1_serializeOpPutConfigurationSetTrackingOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutConfigurationSetTrackingOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutConfigurationSetTrackingOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/configuration-sets/{ConfigurationSetName}/tracking-options")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutConfigurationSetTrackingOptionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutConfigurationSetTrackingOptionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutConfigurationSetTrackingOptionsInput(v *PutConfigurationSetTrackingOptionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConfigurationSetName == nil || len(*v.ConfigurationSetName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ConfigurationSetName must not be empty")}
	}
	if v.ConfigurationSetName != nil {
		if err := encoder.SetURI("ConfigurationSetName").String(*v.ConfigurationSetName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutConfigurationSetTrackingOptionsInput(v *PutConfigurationSetTrackingOptionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomRedirectDomain != nil {
		ok := object.Key("CustomRedirectDomain")
		ok.String(*v.CustomRedirectDomain)
	}

	return nil
}

type awsRestjson1_serializeOpPutDedicatedIpInPool struct {
}

func (*awsRestjson1_serializeOpPutDedicatedIpInPool) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutDedicatedIpInPool) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutDedicatedIpInPoolInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/dedicated-ips/{Ip}/pool")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutDedicatedIpInPoolInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutDedicatedIpInPoolInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutDedicatedIpInPoolInput(v *PutDedicatedIpInPoolInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Ip == nil || len(*v.Ip) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Ip must not be empty")}
	}
	if v.Ip != nil {
		if err := encoder.SetURI("Ip").String(*v.Ip); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutDedicatedIpInPoolInput(v *PutDedicatedIpInPoolInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationPoolName != nil {
		ok := object.Key("DestinationPoolName")
		ok.String(*v.DestinationPoolName)
	}

	return nil
}

type awsRestjson1_serializeOpPutDedicatedIpWarmupAttributes struct {
}

func (*awsRestjson1_serializeOpPutDedicatedIpWarmupAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutDedicatedIpWarmupAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutDedicatedIpWarmupAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/dedicated-ips/{Ip}/warmup")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutDedicatedIpWarmupAttributesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutDedicatedIpWarmupAttributesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutDedicatedIpWarmupAttributesInput(v *PutDedicatedIpWarmupAttributesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Ip == nil || len(*v.Ip) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Ip must not be empty")}
	}
	if v.Ip != nil {
		if err := encoder.SetURI("Ip").String(*v.Ip); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutDedicatedIpWarmupAttributesInput(v *PutDedicatedIpWarmupAttributesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.WarmupPercentage != nil {
		ok := object.Key("WarmupPercentage")
		ok.Integer(*v.WarmupPercentage)
	}

	return nil
}

type awsRestjson1_serializeOpPutDeliverabilityDashboardOption struct {
}

func (*awsRestjson1_serializeOpPutDeliverabilityDashboardOption) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutDeliverabilityDashboardOption) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutDeliverabilityDashboardOptionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/deliverability-dashboard")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutDeliverabilityDashboardOptionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutDeliverabilityDashboardOptionInput(v *PutDeliverabilityDashboardOptionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutDeliverabilityDashboardOptionInput(v *PutDeliverabilityDashboardOptionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("DashboardEnabled")
		ok.Boolean(v.DashboardEnabled)
	}

	if v.SubscribedDomains != nil {
		ok := object.Key("SubscribedDomains")
		if err := awsRestjson1_serializeDocumentDomainDeliverabilityTrackingOptions(v.SubscribedDomains, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpPutEmailIdentityDkimAttributes struct {
}

func (*awsRestjson1_serializeOpPutEmailIdentityDkimAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutEmailIdentityDkimAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutEmailIdentityDkimAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/identities/{EmailIdentity}/dkim")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutEmailIdentityDkimAttributesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutEmailIdentityDkimAttributesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutEmailIdentityDkimAttributesInput(v *PutEmailIdentityDkimAttributesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.EmailIdentity == nil || len(*v.EmailIdentity) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member EmailIdentity must not be empty")}
	}
	if v.EmailIdentity != nil {
		if err := encoder.SetURI("EmailIdentity").String(*v.EmailIdentity); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutEmailIdentityDkimAttributesInput(v *PutEmailIdentityDkimAttributesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SigningEnabled {
		ok := object.Key("SigningEnabled")
		ok.Boolean(v.SigningEnabled)
	}

	return nil
}

type awsRestjson1_serializeOpPutEmailIdentityFeedbackAttributes struct {
}

func (*awsRestjson1_serializeOpPutEmailIdentityFeedbackAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutEmailIdentityFeedbackAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutEmailIdentityFeedbackAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/identities/{EmailIdentity}/feedback")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutEmailIdentityFeedbackAttributesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutEmailIdentityFeedbackAttributesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutEmailIdentityFeedbackAttributesInput(v *PutEmailIdentityFeedbackAttributesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.EmailIdentity == nil || len(*v.EmailIdentity) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member EmailIdentity must not be empty")}
	}
	if v.EmailIdentity != nil {
		if err := encoder.SetURI("EmailIdentity").String(*v.EmailIdentity); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutEmailIdentityFeedbackAttributesInput(v *PutEmailIdentityFeedbackAttributesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EmailForwardingEnabled {
		ok := object.Key("EmailForwardingEnabled")
		ok.Boolean(v.EmailForwardingEnabled)
	}

	return nil
}

type awsRestjson1_serializeOpPutEmailIdentityMailFromAttributes struct {
}

func (*awsRestjson1_serializeOpPutEmailIdentityMailFromAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutEmailIdentityMailFromAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutEmailIdentityMailFromAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/identities/{EmailIdentity}/mail-from")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutEmailIdentityMailFromAttributesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutEmailIdentityMailFromAttributesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutEmailIdentityMailFromAttributesInput(v *PutEmailIdentityMailFromAttributesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.EmailIdentity == nil || len(*v.EmailIdentity) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member EmailIdentity must not be empty")}
	}
	if v.EmailIdentity != nil {
		if err := encoder.SetURI("EmailIdentity").String(*v.EmailIdentity); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutEmailIdentityMailFromAttributesInput(v *PutEmailIdentityMailFromAttributesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.BehaviorOnMxFailure) > 0 {
		ok := object.Key("BehaviorOnMxFailure")
		ok.String(string(v.BehaviorOnMxFailure))
	}

	if v.MailFromDomain != nil {
		ok := object.Key("MailFromDomain")
		ok.String(*v.MailFromDomain)
	}

	return nil
}

type awsRestjson1_serializeOpSendEmail struct {
}

func (*awsRestjson1_serializeOpSendEmail) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSendEmail) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SendEmailInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/outbound-emails")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSendEmailInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSendEmailInput(v *SendEmailInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSendEmailInput(v *SendEmailInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConfigurationSetName != nil {
		ok := object.Key("ConfigurationSetName")
		ok.String(*v.ConfigurationSetName)
	}

	if v.Content != nil {
		ok := object.Key("Content")
		if err := awsRestjson1_serializeDocumentEmailContent(v.Content, ok); err != nil {
			return err
		}
	}

	if v.Destination != nil {
		ok := object.Key("Destination")
		if err := awsRestjson1_serializeDocumentDestination(v.Destination, ok); err != nil {
			return err
		}
	}

	if v.EmailTags != nil {
		ok := object.Key("EmailTags")
		if err := awsRestjson1_serializeDocumentMessageTagList(v.EmailTags, ok); err != nil {
			return err
		}
	}

	if v.FeedbackForwardingEmailAddress != nil {
		ok := object.Key("FeedbackForwardingEmailAddress")
		ok.String(*v.FeedbackForwardingEmailAddress)
	}

	if v.FromEmailAddress != nil {
		ok := object.Key("FromEmailAddress")
		ok.String(*v.FromEmailAddress)
	}

	if v.ReplyToAddresses != nil {
		ok := object.Key("ReplyToAddresses")
		if err := awsRestjson1_serializeDocumentEmailAddressList(v.ReplyToAddresses, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/tags")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/tags")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn != nil {
		encoder.SetQuery("ResourceArn").String(*v.ResourceArn)
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("TagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateConfigurationSetEventDestination struct {
}

func (*awsRestjson1_serializeOpUpdateConfigurationSetEventDestination) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateConfigurationSetEventDestination) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateConfigurationSetEventDestinationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/email/configuration-sets/{ConfigurationSetName}/event-destinations/{EventDestinationName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateConfigurationSetEventDestinationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateConfigurationSetEventDestinationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateConfigurationSetEventDestinationInput(v *UpdateConfigurationSetEventDestinationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConfigurationSetName == nil || len(*v.ConfigurationSetName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ConfigurationSetName must not be empty")}
	}
	if v.ConfigurationSetName != nil {
		if err := encoder.SetURI("ConfigurationSetName").String(*v.ConfigurationSetName); err != nil {
			return err
		}
	}

	if v.EventDestinationName == nil || len(*v.EventDestinationName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member EventDestinationName must not be empty")}
	}
	if v.EventDestinationName != nil {
		if err := encoder.SetURI("EventDestinationName").String(*v.EventDestinationName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateConfigurationSetEventDestinationInput(v *UpdateConfigurationSetEventDestinationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EventDestination != nil {
		ok := object.Key("EventDestination")
		if err := awsRestjson1_serializeDocumentEventDestinationDefinition(v.EventDestination, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBody(v *types.Body, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Html != nil {
		ok := object.Key("Html")
		if err := awsRestjson1_serializeDocumentContent(v.Html, ok); err != nil {
			return err
		}
	}

	if v.Text != nil {
		ok := object.Key("Text")
		if err := awsRestjson1_serializeDocumentContent(v.Text, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCloudWatchDestination(v *types.CloudWatchDestination, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DimensionConfigurations != nil {
		ok := object.Key("DimensionConfigurations")
		if err := awsRestjson1_serializeDocumentCloudWatchDimensionConfigurations(v.DimensionConfigurations, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCloudWatchDimensionConfiguration(v *types.CloudWatchDimensionConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DefaultDimensionValue != nil {
		ok := object.Key("DefaultDimensionValue")
		ok.String(*v.DefaultDimensionValue)
	}

	if v.DimensionName != nil {
		ok := object.Key("DimensionName")
		ok.String(*v.DimensionName)
	}

	if len(v.DimensionValueSource) > 0 {
		ok := object.Key("DimensionValueSource")
		ok.String(string(v.DimensionValueSource))
	}

	return nil
}

func awsRestjson1_serializeDocumentCloudWatchDimensionConfigurations(v []types.CloudWatchDimensionConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCloudWatchDimensionConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentContent(v *types.Content, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Charset != nil {
		ok := object.Key("Charset")
		ok.String(*v.Charset)
	}

	if v.Data != nil {
		ok := object.Key("Data")
		ok.String(*v.Data)
	}

	return nil
}

func awsRestjson1_serializeDocumentDeliveryOptions(v *types.DeliveryOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SendingPoolName != nil {
		ok := object.Key("SendingPoolName")
		ok.String(*v.SendingPoolName)
	}

	if len(v.TlsPolicy) > 0 {
		ok := object.Key("TlsPolicy")
		ok.String(string(v.TlsPolicy))
	}

	return nil
}

func awsRestjson1_serializeDocumentDestination(v *types.Destination, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BccAddresses != nil {
		ok := object.Key("BccAddresses")
		if err := awsRestjson1_serializeDocumentEmailAddressList(v.BccAddresses, ok); err != nil {
			return err
		}
	}

	if v.CcAddresses != nil {
		ok := object.Key("CcAddresses")
		if err := awsRestjson1_serializeDocumentEmailAddressList(v.CcAddresses, ok); err != nil {
			return err
		}
	}

	if v.ToAddresses != nil {
		ok := object.Key("ToAddresses")
		if err := awsRestjson1_serializeDocumentEmailAddressList(v.ToAddresses, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDomainDeliverabilityTrackingOption(v *types.DomainDeliverabilityTrackingOption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Domain != nil {
		ok := object.Key("Domain")
		ok.String(*v.Domain)
	}

	if v.InboxPlacementTrackingOption != nil {
		ok := object.Key("InboxPlacementTrackingOption")
		if err := awsRestjson1_serializeDocumentInboxPlacementTrackingOption(v.InboxPlacementTrackingOption, ok); err != nil {
			return err
		}
	}

	if v.SubscriptionStartDate != nil {
		ok := object.Key("SubscriptionStartDate")
		ok.Double(smithytime.FormatEpochSeconds(*v.SubscriptionStartDate))
	}

	return nil
}

func awsRestjson1_serializeDocumentDomainDeliverabilityTrackingOptions(v []types.DomainDeliverabilityTrackingOption, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDomainDeliverabilityTrackingOption(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentEmailAddressList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentEmailContent(v *types.EmailContent, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Raw != nil {
		ok := object.Key("Raw")
		if err := awsRestjson1_serializeDocumentRawMessage(v.Raw, ok); err != nil {
			return err
		}
	}

	if v.Simple != nil {
		ok := object.Key("Simple")
		if err := awsRestjson1_serializeDocumentMessage(v.Simple, ok); err != nil {
			return err
		}
	}

	if v.Template != nil {
		ok := object.Key("Template")
		if err := awsRestjson1_serializeDocumentTemplate(v.Template, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentEventDestinationDefinition(v *types.EventDestinationDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CloudWatchDestination != nil {
		ok := object.Key("CloudWatchDestination")
		if err := awsRestjson1_serializeDocumentCloudWatchDestination(v.CloudWatchDestination, ok); err != nil {
			return err
		}
	}

	if v.Enabled {
		ok := object.Key("Enabled")
		ok.Boolean(v.Enabled)
	}

	if v.KinesisFirehoseDestination != nil {
		ok := object.Key("KinesisFirehoseDestination")
		if err := awsRestjson1_serializeDocumentKinesisFirehoseDestination(v.KinesisFirehoseDestination, ok); err != nil {
			return err
		}
	}

	if v.MatchingEventTypes != nil {
		ok := object.Key("MatchingEventTypes")
		if err := awsRestjson1_serializeDocumentEventTypes(v.MatchingEventTypes, ok); err != nil {
			return err
		}
	}

	if v.PinpointDestination != nil {
		ok := object.Key("PinpointDestination")
		if err := awsRestjson1_serializeDocumentPinpointDestination(v.PinpointDestination, ok); err != nil {
			return err
		}
	}

	if v.SnsDestination != nil {
		ok := object.Key("SnsDestination")
		if err := awsRestjson1_serializeDocumentSnsDestination(v.SnsDestination, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentEventTypes(v []types.EventType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentInboxPlacementTrackingOption(v *types.InboxPlacementTrackingOption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Global {
		ok := object.Key("Global")
		ok.Boolean(v.Global)
	}

	if v.TrackedIsps != nil {
		ok := object.Key("TrackedIsps")
		if err := awsRestjson1_serializeDocumentIspNameList(v.TrackedIsps, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentIspNameList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentKinesisFirehoseDestination(v *types.KinesisFirehoseDestination, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeliveryStreamArn != nil {
		ok := object.Key("DeliveryStreamArn")
		ok.String(*v.DeliveryStreamArn)
	}

	if v.IamRoleArn != nil {
		ok := object.Key("IamRoleArn")
		ok.String(*v.IamRoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentMessage(v *types.Message, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Body != nil {
		ok := object.Key("Body")
		if err := awsRestjson1_serializeDocumentBody(v.Body, ok); err != nil {
			return err
		}
	}

	if v.Subject != nil {
		ok := object.Key("Subject")
		if err := awsRestjson1_serializeDocumentContent(v.Subject, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMessageTag(v *types.MessageTag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentMessageTagList(v []types.MessageTag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMessageTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPinpointDestination(v *types.PinpointDestination, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationArn != nil {
		ok := object.Key("ApplicationArn")
		ok.String(*v.ApplicationArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentRawMessage(v *types.RawMessage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Data != nil {
		ok := object.Key("Data")
		ok.Base64EncodeBytes(v.Data)
	}

	return nil
}

func awsRestjson1_serializeDocumentReputationOptions(v *types.ReputationOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LastFreshStart != nil {
		ok := object.Key("LastFreshStart")
		ok.Double(smithytime.FormatEpochSeconds(*v.LastFreshStart))
	}

	if v.ReputationMetricsEnabled {
		ok := object.Key("ReputationMetricsEnabled")
		ok.Boolean(v.ReputationMetricsEnabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentSendingOptions(v *types.SendingOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SendingEnabled {
		ok := object.Key("SendingEnabled")
		ok.Boolean(v.SendingEnabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentSnsDestination(v *types.SnsDestination, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TopicArn != nil {
		ok := object.Key("TopicArn")
		ok.String(*v.TopicArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentTag(v *types.Tag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentTagList(v []types.Tag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTemplate(v *types.Template, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TemplateArn != nil {
		ok := object.Key("TemplateArn")
		ok.String(*v.TemplateArn)
	}

	if v.TemplateData != nil {
		ok := object.Key("TemplateData")
		ok.String(*v.TemplateData)
	}

	return nil
}

func awsRestjson1_serializeDocumentTrackingOptions(v *types.TrackingOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomRedirectDomain != nil {
		ok := object.Key("CustomRedirectDomain")
		ok.String(*v.CustomRedirectDomain)
	}

	return nil
}
