// Code generated by smithy-go-codegen DO NOT EDIT.

package securityhub

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns the current finding aggregation configuration.
func (c *Client) GetFindingAggregator(ctx context.Context, params *GetFindingAggregatorInput, optFns ...func(*Options)) (*GetFindingAggregatorOutput, error) {
	if params == nil {
		params = &GetFindingAggregatorInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetFindingAggregator", params, optFns, c.addOperationGetFindingAggregatorMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetFindingAggregatorOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetFindingAggregatorInput struct {

	// The ARN of the finding aggregator to return details for. To obtain the ARN, use
	// ListFindingAggregators.
	//
	// This member is required.
	FindingAggregatorArn *string

	noSmithyDocumentSerde
}

type GetFindingAggregatorOutput struct {

	// The aggregation Region.
	FindingAggregationRegion *string

	// The ARN of the finding aggregator.
	FindingAggregatorArn *string

	// Indicates whether to link all Regions, all Regions except for a list of excluded
	// Regions, or a list of included Regions.
	RegionLinkingMode *string

	// The list of excluded Regions or included Regions.
	Regions []string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetFindingAggregatorMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetFindingAggregator{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetFindingAggregator{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetFindingAggregatorValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetFindingAggregator(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetFindingAggregator(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "securityhub",
		OperationName: "GetFindingAggregator",
	}
}
