//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/azuredata/armazuredata"
	"net/http"
	"net/url"
	"regexp"
)

// SQLServersServer is a fake server for instances of the armazuredata.SQLServersClient type.
type SQLServersServer struct {
	// CreateOrUpdate is the fake for method SQLServersClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, sqlServerRegistrationName string, sqlServerName string, parameters armazuredata.SQLServer, options *armazuredata.SQLServersClientCreateOrUpdateOptions) (resp azfake.Responder[armazuredata.SQLServersClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method SQLServersClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, sqlServerRegistrationName string, sqlServerName string, options *armazuredata.SQLServersClientDeleteOptions) (resp azfake.Responder[armazuredata.SQLServersClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method SQLServersClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, sqlServerRegistrationName string, sqlServerName string, options *armazuredata.SQLServersClientGetOptions) (resp azfake.Responder[armazuredata.SQLServersClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByResourceGroupPager is the fake for method SQLServersClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, sqlServerRegistrationName string, options *armazuredata.SQLServersClientListByResourceGroupOptions) (resp azfake.PagerResponder[armazuredata.SQLServersClientListByResourceGroupResponse])
}

// NewSQLServersServerTransport creates a new instance of SQLServersServerTransport with the provided implementation.
// The returned SQLServersServerTransport instance is connected to an instance of armazuredata.SQLServersClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSQLServersServerTransport(srv *SQLServersServer) *SQLServersServerTransport {
	return &SQLServersServerTransport{
		srv:                         srv,
		newListByResourceGroupPager: newTracker[azfake.PagerResponder[armazuredata.SQLServersClientListByResourceGroupResponse]](),
	}
}

// SQLServersServerTransport connects instances of armazuredata.SQLServersClient to instances of SQLServersServer.
// Don't use this type directly, use NewSQLServersServerTransport instead.
type SQLServersServerTransport struct {
	srv                         *SQLServersServer
	newListByResourceGroupPager *tracker[azfake.PagerResponder[armazuredata.SQLServersClientListByResourceGroupResponse]]
}

// Do implements the policy.Transporter interface for SQLServersServerTransport.
func (s *SQLServersServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SQLServersClient.CreateOrUpdate":
		resp, err = s.dispatchCreateOrUpdate(req)
	case "SQLServersClient.Delete":
		resp, err = s.dispatchDelete(req)
	case "SQLServersClient.Get":
		resp, err = s.dispatchGet(req)
	case "SQLServersClient.NewListByResourceGroupPager":
		resp, err = s.dispatchNewListByResourceGroupPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SQLServersServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AzureData/sqlServerRegistrations/(?P<sqlServerRegistrationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlServers/(?P<sqlServerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armazuredata.SQLServer](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	sqlServerRegistrationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sqlServerRegistrationName")])
	if err != nil {
		return nil, err
	}
	sqlServerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sqlServerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, sqlServerRegistrationNameParam, sqlServerNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SQLServer, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SQLServersServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if s.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AzureData/sqlServerRegistrations/(?P<sqlServerRegistrationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlServers/(?P<sqlServerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	sqlServerRegistrationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sqlServerRegistrationName")])
	if err != nil {
		return nil, err
	}
	sqlServerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sqlServerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Delete(req.Context(), resourceGroupNameParam, sqlServerRegistrationNameParam, sqlServerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SQLServersServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AzureData/sqlServerRegistrations/(?P<sqlServerRegistrationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlServers/(?P<sqlServerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	sqlServerRegistrationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sqlServerRegistrationName")])
	if err != nil {
		return nil, err
	}
	sqlServerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sqlServerName")])
	if err != nil {
		return nil, err
	}
	expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
	if err != nil {
		return nil, err
	}
	expandParam := getOptional(expandUnescaped)
	var options *armazuredata.SQLServersClientGetOptions
	if expandParam != nil {
		options = &armazuredata.SQLServersClientGetOptions{
			Expand: expandParam,
		}
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, sqlServerRegistrationNameParam, sqlServerNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SQLServer, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SQLServersServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := s.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AzureData/sqlServerRegistrations/(?P<sqlServerRegistrationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlServers`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		sqlServerRegistrationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sqlServerRegistrationName")])
		if err != nil {
			return nil, err
		}
		expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
		if err != nil {
			return nil, err
		}
		expandParam := getOptional(expandUnescaped)
		var options *armazuredata.SQLServersClientListByResourceGroupOptions
		if expandParam != nil {
			options = &armazuredata.SQLServersClientListByResourceGroupOptions{
				Expand: expandParam,
			}
		}
		resp := s.srv.NewListByResourceGroupPager(resourceGroupNameParam, sqlServerRegistrationNameParam, options)
		newListByResourceGroupPager = &resp
		s.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armazuredata.SQLServersClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		s.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}
