//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/logic/armlogic"
	"net/http"
	"net/url"
	"regexp"
)

// IntegrationServiceEnvironmentSKUsServer is a fake server for instances of the armlogic.IntegrationServiceEnvironmentSKUsClient type.
type IntegrationServiceEnvironmentSKUsServer struct {
	// NewListPager is the fake for method IntegrationServiceEnvironmentSKUsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroup string, integrationServiceEnvironmentName string, options *armlogic.IntegrationServiceEnvironmentSKUsClientListOptions) (resp azfake.PagerResponder[armlogic.IntegrationServiceEnvironmentSKUsClientListResponse])
}

// NewIntegrationServiceEnvironmentSKUsServerTransport creates a new instance of IntegrationServiceEnvironmentSKUsServerTransport with the provided implementation.
// The returned IntegrationServiceEnvironmentSKUsServerTransport instance is connected to an instance of armlogic.IntegrationServiceEnvironmentSKUsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewIntegrationServiceEnvironmentSKUsServerTransport(srv *IntegrationServiceEnvironmentSKUsServer) *IntegrationServiceEnvironmentSKUsServerTransport {
	return &IntegrationServiceEnvironmentSKUsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armlogic.IntegrationServiceEnvironmentSKUsClientListResponse]](),
	}
}

// IntegrationServiceEnvironmentSKUsServerTransport connects instances of armlogic.IntegrationServiceEnvironmentSKUsClient to instances of IntegrationServiceEnvironmentSKUsServer.
// Don't use this type directly, use NewIntegrationServiceEnvironmentSKUsServerTransport instead.
type IntegrationServiceEnvironmentSKUsServerTransport struct {
	srv          *IntegrationServiceEnvironmentSKUsServer
	newListPager *tracker[azfake.PagerResponder[armlogic.IntegrationServiceEnvironmentSKUsClientListResponse]]
}

// Do implements the policy.Transporter interface for IntegrationServiceEnvironmentSKUsServerTransport.
func (i *IntegrationServiceEnvironmentSKUsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "IntegrationServiceEnvironmentSKUsClient.NewListPager":
		resp, err = i.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (i *IntegrationServiceEnvironmentSKUsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if i.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := i.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroup>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Logic/integrationServiceEnvironments/(?P<integrationServiceEnvironmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/skus`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroup")])
		if err != nil {
			return nil, err
		}
		integrationServiceEnvironmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("integrationServiceEnvironmentName")])
		if err != nil {
			return nil, err
		}
		resp := i.srv.NewListPager(resourceGroupParam, integrationServiceEnvironmentNameParam, nil)
		newListPager = &resp
		i.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armlogic.IntegrationServiceEnvironmentSKUsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		i.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		i.newListPager.remove(req)
	}
	return resp, nil
}
