//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/network/armnetwork/v4"
	"net/http"
	"net/url"
	"regexp"
)

// PublicIPAddressesServer is a fake server for instances of the armnetwork.PublicIPAddressesClient type.
type PublicIPAddressesServer struct {
	// BeginCreateOrUpdate is the fake for method PublicIPAddressesClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, publicIPAddressName string, parameters armnetwork.PublicIPAddress, options *armnetwork.PublicIPAddressesClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armnetwork.PublicIPAddressesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDdosProtectionStatus is the fake for method PublicIPAddressesClient.BeginDdosProtectionStatus
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginDdosProtectionStatus func(ctx context.Context, resourceGroupName string, publicIPAddressName string, options *armnetwork.PublicIPAddressesClientBeginDdosProtectionStatusOptions) (resp azfake.PollerResponder[armnetwork.PublicIPAddressesClientDdosProtectionStatusResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method PublicIPAddressesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, publicIPAddressName string, options *armnetwork.PublicIPAddressesClientBeginDeleteOptions) (resp azfake.PollerResponder[armnetwork.PublicIPAddressesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method PublicIPAddressesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, publicIPAddressName string, options *armnetwork.PublicIPAddressesClientGetOptions) (resp azfake.Responder[armnetwork.PublicIPAddressesClientGetResponse], errResp azfake.ErrorResponder)

	// GetCloudServicePublicIPAddress is the fake for method PublicIPAddressesClient.GetCloudServicePublicIPAddress
	// HTTP status codes to indicate success: http.StatusOK
	GetCloudServicePublicIPAddress func(ctx context.Context, resourceGroupName string, cloudServiceName string, roleInstanceName string, networkInterfaceName string, ipConfigurationName string, publicIPAddressName string, options *armnetwork.PublicIPAddressesClientGetCloudServicePublicIPAddressOptions) (resp azfake.Responder[armnetwork.PublicIPAddressesClientGetCloudServicePublicIPAddressResponse], errResp azfake.ErrorResponder)

	// GetVirtualMachineScaleSetPublicIPAddress is the fake for method PublicIPAddressesClient.GetVirtualMachineScaleSetPublicIPAddress
	// HTTP status codes to indicate success: http.StatusOK
	GetVirtualMachineScaleSetPublicIPAddress func(ctx context.Context, resourceGroupName string, virtualMachineScaleSetName string, virtualmachineIndex string, networkInterfaceName string, ipConfigurationName string, publicIPAddressName string, options *armnetwork.PublicIPAddressesClientGetVirtualMachineScaleSetPublicIPAddressOptions) (resp azfake.Responder[armnetwork.PublicIPAddressesClientGetVirtualMachineScaleSetPublicIPAddressResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method PublicIPAddressesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, options *armnetwork.PublicIPAddressesClientListOptions) (resp azfake.PagerResponder[armnetwork.PublicIPAddressesClientListResponse])

	// NewListAllPager is the fake for method PublicIPAddressesClient.NewListAllPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListAllPager func(options *armnetwork.PublicIPAddressesClientListAllOptions) (resp azfake.PagerResponder[armnetwork.PublicIPAddressesClientListAllResponse])

	// NewListCloudServicePublicIPAddressesPager is the fake for method PublicIPAddressesClient.NewListCloudServicePublicIPAddressesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListCloudServicePublicIPAddressesPager func(resourceGroupName string, cloudServiceName string, options *armnetwork.PublicIPAddressesClientListCloudServicePublicIPAddressesOptions) (resp azfake.PagerResponder[armnetwork.PublicIPAddressesClientListCloudServicePublicIPAddressesResponse])

	// NewListCloudServiceRoleInstancePublicIPAddressesPager is the fake for method PublicIPAddressesClient.NewListCloudServiceRoleInstancePublicIPAddressesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListCloudServiceRoleInstancePublicIPAddressesPager func(resourceGroupName string, cloudServiceName string, roleInstanceName string, networkInterfaceName string, ipConfigurationName string, options *armnetwork.PublicIPAddressesClientListCloudServiceRoleInstancePublicIPAddressesOptions) (resp azfake.PagerResponder[armnetwork.PublicIPAddressesClientListCloudServiceRoleInstancePublicIPAddressesResponse])

	// NewListVirtualMachineScaleSetPublicIPAddressesPager is the fake for method PublicIPAddressesClient.NewListVirtualMachineScaleSetPublicIPAddressesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListVirtualMachineScaleSetPublicIPAddressesPager func(resourceGroupName string, virtualMachineScaleSetName string, options *armnetwork.PublicIPAddressesClientListVirtualMachineScaleSetPublicIPAddressesOptions) (resp azfake.PagerResponder[armnetwork.PublicIPAddressesClientListVirtualMachineScaleSetPublicIPAddressesResponse])

	// NewListVirtualMachineScaleSetVMPublicIPAddressesPager is the fake for method PublicIPAddressesClient.NewListVirtualMachineScaleSetVMPublicIPAddressesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListVirtualMachineScaleSetVMPublicIPAddressesPager func(resourceGroupName string, virtualMachineScaleSetName string, virtualmachineIndex string, networkInterfaceName string, ipConfigurationName string, options *armnetwork.PublicIPAddressesClientListVirtualMachineScaleSetVMPublicIPAddressesOptions) (resp azfake.PagerResponder[armnetwork.PublicIPAddressesClientListVirtualMachineScaleSetVMPublicIPAddressesResponse])

	// UpdateTags is the fake for method PublicIPAddressesClient.UpdateTags
	// HTTP status codes to indicate success: http.StatusOK
	UpdateTags func(ctx context.Context, resourceGroupName string, publicIPAddressName string, parameters armnetwork.TagsObject, options *armnetwork.PublicIPAddressesClientUpdateTagsOptions) (resp azfake.Responder[armnetwork.PublicIPAddressesClientUpdateTagsResponse], errResp azfake.ErrorResponder)
}

// NewPublicIPAddressesServerTransport creates a new instance of PublicIPAddressesServerTransport with the provided implementation.
// The returned PublicIPAddressesServerTransport instance is connected to an instance of armnetwork.PublicIPAddressesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPublicIPAddressesServerTransport(srv *PublicIPAddressesServer) *PublicIPAddressesServerTransport {
	return &PublicIPAddressesServerTransport{
		srv:                       srv,
		beginCreateOrUpdate:       newTracker[azfake.PollerResponder[armnetwork.PublicIPAddressesClientCreateOrUpdateResponse]](),
		beginDdosProtectionStatus: newTracker[azfake.PollerResponder[armnetwork.PublicIPAddressesClientDdosProtectionStatusResponse]](),
		beginDelete:               newTracker[azfake.PollerResponder[armnetwork.PublicIPAddressesClientDeleteResponse]](),
		newListPager:              newTracker[azfake.PagerResponder[armnetwork.PublicIPAddressesClientListResponse]](),
		newListAllPager:           newTracker[azfake.PagerResponder[armnetwork.PublicIPAddressesClientListAllResponse]](),
		newListCloudServicePublicIPAddressesPager:             newTracker[azfake.PagerResponder[armnetwork.PublicIPAddressesClientListCloudServicePublicIPAddressesResponse]](),
		newListCloudServiceRoleInstancePublicIPAddressesPager: newTracker[azfake.PagerResponder[armnetwork.PublicIPAddressesClientListCloudServiceRoleInstancePublicIPAddressesResponse]](),
		newListVirtualMachineScaleSetPublicIPAddressesPager:   newTracker[azfake.PagerResponder[armnetwork.PublicIPAddressesClientListVirtualMachineScaleSetPublicIPAddressesResponse]](),
		newListVirtualMachineScaleSetVMPublicIPAddressesPager: newTracker[azfake.PagerResponder[armnetwork.PublicIPAddressesClientListVirtualMachineScaleSetVMPublicIPAddressesResponse]](),
	}
}

// PublicIPAddressesServerTransport connects instances of armnetwork.PublicIPAddressesClient to instances of PublicIPAddressesServer.
// Don't use this type directly, use NewPublicIPAddressesServerTransport instead.
type PublicIPAddressesServerTransport struct {
	srv                                                   *PublicIPAddressesServer
	beginCreateOrUpdate                                   *tracker[azfake.PollerResponder[armnetwork.PublicIPAddressesClientCreateOrUpdateResponse]]
	beginDdosProtectionStatus                             *tracker[azfake.PollerResponder[armnetwork.PublicIPAddressesClientDdosProtectionStatusResponse]]
	beginDelete                                           *tracker[azfake.PollerResponder[armnetwork.PublicIPAddressesClientDeleteResponse]]
	newListPager                                          *tracker[azfake.PagerResponder[armnetwork.PublicIPAddressesClientListResponse]]
	newListAllPager                                       *tracker[azfake.PagerResponder[armnetwork.PublicIPAddressesClientListAllResponse]]
	newListCloudServicePublicIPAddressesPager             *tracker[azfake.PagerResponder[armnetwork.PublicIPAddressesClientListCloudServicePublicIPAddressesResponse]]
	newListCloudServiceRoleInstancePublicIPAddressesPager *tracker[azfake.PagerResponder[armnetwork.PublicIPAddressesClientListCloudServiceRoleInstancePublicIPAddressesResponse]]
	newListVirtualMachineScaleSetPublicIPAddressesPager   *tracker[azfake.PagerResponder[armnetwork.PublicIPAddressesClientListVirtualMachineScaleSetPublicIPAddressesResponse]]
	newListVirtualMachineScaleSetVMPublicIPAddressesPager *tracker[azfake.PagerResponder[armnetwork.PublicIPAddressesClientListVirtualMachineScaleSetVMPublicIPAddressesResponse]]
}

// Do implements the policy.Transporter interface for PublicIPAddressesServerTransport.
func (p *PublicIPAddressesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PublicIPAddressesClient.BeginCreateOrUpdate":
		resp, err = p.dispatchBeginCreateOrUpdate(req)
	case "PublicIPAddressesClient.BeginDdosProtectionStatus":
		resp, err = p.dispatchBeginDdosProtectionStatus(req)
	case "PublicIPAddressesClient.BeginDelete":
		resp, err = p.dispatchBeginDelete(req)
	case "PublicIPAddressesClient.Get":
		resp, err = p.dispatchGet(req)
	case "PublicIPAddressesClient.GetCloudServicePublicIPAddress":
		resp, err = p.dispatchGetCloudServicePublicIPAddress(req)
	case "PublicIPAddressesClient.GetVirtualMachineScaleSetPublicIPAddress":
		resp, err = p.dispatchGetVirtualMachineScaleSetPublicIPAddress(req)
	case "PublicIPAddressesClient.NewListPager":
		resp, err = p.dispatchNewListPager(req)
	case "PublicIPAddressesClient.NewListAllPager":
		resp, err = p.dispatchNewListAllPager(req)
	case "PublicIPAddressesClient.NewListCloudServicePublicIPAddressesPager":
		resp, err = p.dispatchNewListCloudServicePublicIPAddressesPager(req)
	case "PublicIPAddressesClient.NewListCloudServiceRoleInstancePublicIPAddressesPager":
		resp, err = p.dispatchNewListCloudServiceRoleInstancePublicIPAddressesPager(req)
	case "PublicIPAddressesClient.NewListVirtualMachineScaleSetPublicIPAddressesPager":
		resp, err = p.dispatchNewListVirtualMachineScaleSetPublicIPAddressesPager(req)
	case "PublicIPAddressesClient.NewListVirtualMachineScaleSetVMPublicIPAddressesPager":
		resp, err = p.dispatchNewListVirtualMachineScaleSetVMPublicIPAddressesPager(req)
	case "PublicIPAddressesClient.UpdateTags":
		resp, err = p.dispatchUpdateTags(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PublicIPAddressesServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if p.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := p.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/publicIPAddresses/(?P<publicIpAddressName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetwork.PublicIPAddress](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		publicIPAddressNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("publicIpAddressName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, publicIPAddressNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		p.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		p.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		p.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (p *PublicIPAddressesServerTransport) dispatchBeginDdosProtectionStatus(req *http.Request) (*http.Response, error) {
	if p.srv.BeginDdosProtectionStatus == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDdosProtectionStatus not implemented")}
	}
	beginDdosProtectionStatus := p.beginDdosProtectionStatus.get(req)
	if beginDdosProtectionStatus == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/publicIPAddresses/(?P<publicIpAddressName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/ddosProtectionStatus`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		publicIPAddressNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("publicIpAddressName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginDdosProtectionStatus(req.Context(), resourceGroupNameParam, publicIPAddressNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDdosProtectionStatus = &respr
		p.beginDdosProtectionStatus.add(req, beginDdosProtectionStatus)
	}

	resp, err := server.PollerResponderNext(beginDdosProtectionStatus, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		p.beginDdosProtectionStatus.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDdosProtectionStatus) {
		p.beginDdosProtectionStatus.remove(req)
	}

	return resp, nil
}

func (p *PublicIPAddressesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if p.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := p.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/publicIPAddresses/(?P<publicIpAddressName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		publicIPAddressNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("publicIpAddressName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginDelete(req.Context(), resourceGroupNameParam, publicIPAddressNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		p.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		p.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		p.beginDelete.remove(req)
	}

	return resp, nil
}

func (p *PublicIPAddressesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if p.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/publicIPAddresses/(?P<publicIpAddressName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	publicIPAddressNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("publicIpAddressName")])
	if err != nil {
		return nil, err
	}
	expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
	if err != nil {
		return nil, err
	}
	expandParam := getOptional(expandUnescaped)
	var options *armnetwork.PublicIPAddressesClientGetOptions
	if expandParam != nil {
		options = &armnetwork.PublicIPAddressesClientGetOptions{
			Expand: expandParam,
		}
	}
	respr, errRespr := p.srv.Get(req.Context(), resourceGroupNameParam, publicIPAddressNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PublicIPAddress, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PublicIPAddressesServerTransport) dispatchGetCloudServicePublicIPAddress(req *http.Request) (*http.Response, error) {
	if p.srv.GetCloudServicePublicIPAddress == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetCloudServicePublicIPAddress not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/cloudServices/(?P<cloudServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/roleInstances/(?P<roleInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkInterfaces/(?P<networkInterfaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/ipconfigurations/(?P<ipConfigurationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/publicipaddresses/(?P<publicIpAddressName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 7 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	cloudServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("cloudServiceName")])
	if err != nil {
		return nil, err
	}
	roleInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("roleInstanceName")])
	if err != nil {
		return nil, err
	}
	networkInterfaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkInterfaceName")])
	if err != nil {
		return nil, err
	}
	ipConfigurationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("ipConfigurationName")])
	if err != nil {
		return nil, err
	}
	publicIPAddressNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("publicIpAddressName")])
	if err != nil {
		return nil, err
	}
	expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
	if err != nil {
		return nil, err
	}
	expandParam := getOptional(expandUnescaped)
	var options *armnetwork.PublicIPAddressesClientGetCloudServicePublicIPAddressOptions
	if expandParam != nil {
		options = &armnetwork.PublicIPAddressesClientGetCloudServicePublicIPAddressOptions{
			Expand: expandParam,
		}
	}
	respr, errRespr := p.srv.GetCloudServicePublicIPAddress(req.Context(), resourceGroupNameParam, cloudServiceNameParam, roleInstanceNameParam, networkInterfaceNameParam, ipConfigurationNameParam, publicIPAddressNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PublicIPAddress, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PublicIPAddressesServerTransport) dispatchGetVirtualMachineScaleSetPublicIPAddress(req *http.Request) (*http.Response, error) {
	if p.srv.GetVirtualMachineScaleSetPublicIPAddress == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetVirtualMachineScaleSetPublicIPAddress not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachineScaleSets/(?P<virtualMachineScaleSetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualMachines/(?P<virtualmachineIndex>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkInterfaces/(?P<networkInterfaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/ipconfigurations/(?P<ipConfigurationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/publicipaddresses/(?P<publicIpAddressName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 7 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	virtualMachineScaleSetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualMachineScaleSetName")])
	if err != nil {
		return nil, err
	}
	virtualmachineIndexParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualmachineIndex")])
	if err != nil {
		return nil, err
	}
	networkInterfaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkInterfaceName")])
	if err != nil {
		return nil, err
	}
	ipConfigurationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("ipConfigurationName")])
	if err != nil {
		return nil, err
	}
	publicIPAddressNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("publicIpAddressName")])
	if err != nil {
		return nil, err
	}
	expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
	if err != nil {
		return nil, err
	}
	expandParam := getOptional(expandUnescaped)
	var options *armnetwork.PublicIPAddressesClientGetVirtualMachineScaleSetPublicIPAddressOptions
	if expandParam != nil {
		options = &armnetwork.PublicIPAddressesClientGetVirtualMachineScaleSetPublicIPAddressOptions{
			Expand: expandParam,
		}
	}
	respr, errRespr := p.srv.GetVirtualMachineScaleSetPublicIPAddress(req.Context(), resourceGroupNameParam, virtualMachineScaleSetNameParam, virtualmachineIndexParam, networkInterfaceNameParam, ipConfigurationNameParam, publicIPAddressNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PublicIPAddress, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PublicIPAddressesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := p.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/publicIPAddresses`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListPager(resourceGroupNameParam, nil)
		newListPager = &resp
		p.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armnetwork.PublicIPAddressesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		p.newListPager.remove(req)
	}
	return resp, nil
}

func (p *PublicIPAddressesServerTransport) dispatchNewListAllPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListAllPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListAllPager not implemented")}
	}
	newListAllPager := p.newListAllPager.get(req)
	if newListAllPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/publicIPAddresses`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := p.srv.NewListAllPager(nil)
		newListAllPager = &resp
		p.newListAllPager.add(req, newListAllPager)
		server.PagerResponderInjectNextLinks(newListAllPager, req, func(page *armnetwork.PublicIPAddressesClientListAllResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListAllPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListAllPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListAllPager) {
		p.newListAllPager.remove(req)
	}
	return resp, nil
}

func (p *PublicIPAddressesServerTransport) dispatchNewListCloudServicePublicIPAddressesPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListCloudServicePublicIPAddressesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListCloudServicePublicIPAddressesPager not implemented")}
	}
	newListCloudServicePublicIPAddressesPager := p.newListCloudServicePublicIPAddressesPager.get(req)
	if newListCloudServicePublicIPAddressesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/cloudServices/(?P<cloudServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/publicipaddresses`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		cloudServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("cloudServiceName")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListCloudServicePublicIPAddressesPager(resourceGroupNameParam, cloudServiceNameParam, nil)
		newListCloudServicePublicIPAddressesPager = &resp
		p.newListCloudServicePublicIPAddressesPager.add(req, newListCloudServicePublicIPAddressesPager)
		server.PagerResponderInjectNextLinks(newListCloudServicePublicIPAddressesPager, req, func(page *armnetwork.PublicIPAddressesClientListCloudServicePublicIPAddressesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListCloudServicePublicIPAddressesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListCloudServicePublicIPAddressesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListCloudServicePublicIPAddressesPager) {
		p.newListCloudServicePublicIPAddressesPager.remove(req)
	}
	return resp, nil
}

func (p *PublicIPAddressesServerTransport) dispatchNewListCloudServiceRoleInstancePublicIPAddressesPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListCloudServiceRoleInstancePublicIPAddressesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListCloudServiceRoleInstancePublicIPAddressesPager not implemented")}
	}
	newListCloudServiceRoleInstancePublicIPAddressesPager := p.newListCloudServiceRoleInstancePublicIPAddressesPager.get(req)
	if newListCloudServiceRoleInstancePublicIPAddressesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/cloudServices/(?P<cloudServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/roleInstances/(?P<roleInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkInterfaces/(?P<networkInterfaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/ipconfigurations/(?P<ipConfigurationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/publicipaddresses`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		cloudServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("cloudServiceName")])
		if err != nil {
			return nil, err
		}
		roleInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("roleInstanceName")])
		if err != nil {
			return nil, err
		}
		networkInterfaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkInterfaceName")])
		if err != nil {
			return nil, err
		}
		ipConfigurationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("ipConfigurationName")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListCloudServiceRoleInstancePublicIPAddressesPager(resourceGroupNameParam, cloudServiceNameParam, roleInstanceNameParam, networkInterfaceNameParam, ipConfigurationNameParam, nil)
		newListCloudServiceRoleInstancePublicIPAddressesPager = &resp
		p.newListCloudServiceRoleInstancePublicIPAddressesPager.add(req, newListCloudServiceRoleInstancePublicIPAddressesPager)
		server.PagerResponderInjectNextLinks(newListCloudServiceRoleInstancePublicIPAddressesPager, req, func(page *armnetwork.PublicIPAddressesClientListCloudServiceRoleInstancePublicIPAddressesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListCloudServiceRoleInstancePublicIPAddressesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListCloudServiceRoleInstancePublicIPAddressesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListCloudServiceRoleInstancePublicIPAddressesPager) {
		p.newListCloudServiceRoleInstancePublicIPAddressesPager.remove(req)
	}
	return resp, nil
}

func (p *PublicIPAddressesServerTransport) dispatchNewListVirtualMachineScaleSetPublicIPAddressesPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListVirtualMachineScaleSetPublicIPAddressesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListVirtualMachineScaleSetPublicIPAddressesPager not implemented")}
	}
	newListVirtualMachineScaleSetPublicIPAddressesPager := p.newListVirtualMachineScaleSetPublicIPAddressesPager.get(req)
	if newListVirtualMachineScaleSetPublicIPAddressesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachineScaleSets/(?P<virtualMachineScaleSetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/publicipaddresses`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		virtualMachineScaleSetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualMachineScaleSetName")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListVirtualMachineScaleSetPublicIPAddressesPager(resourceGroupNameParam, virtualMachineScaleSetNameParam, nil)
		newListVirtualMachineScaleSetPublicIPAddressesPager = &resp
		p.newListVirtualMachineScaleSetPublicIPAddressesPager.add(req, newListVirtualMachineScaleSetPublicIPAddressesPager)
		server.PagerResponderInjectNextLinks(newListVirtualMachineScaleSetPublicIPAddressesPager, req, func(page *armnetwork.PublicIPAddressesClientListVirtualMachineScaleSetPublicIPAddressesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListVirtualMachineScaleSetPublicIPAddressesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListVirtualMachineScaleSetPublicIPAddressesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListVirtualMachineScaleSetPublicIPAddressesPager) {
		p.newListVirtualMachineScaleSetPublicIPAddressesPager.remove(req)
	}
	return resp, nil
}

func (p *PublicIPAddressesServerTransport) dispatchNewListVirtualMachineScaleSetVMPublicIPAddressesPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListVirtualMachineScaleSetVMPublicIPAddressesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListVirtualMachineScaleSetVMPublicIPAddressesPager not implemented")}
	}
	newListVirtualMachineScaleSetVMPublicIPAddressesPager := p.newListVirtualMachineScaleSetVMPublicIPAddressesPager.get(req)
	if newListVirtualMachineScaleSetVMPublicIPAddressesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachineScaleSets/(?P<virtualMachineScaleSetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualMachines/(?P<virtualmachineIndex>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkInterfaces/(?P<networkInterfaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/ipconfigurations/(?P<ipConfigurationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/publicipaddresses`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		virtualMachineScaleSetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualMachineScaleSetName")])
		if err != nil {
			return nil, err
		}
		virtualmachineIndexParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualmachineIndex")])
		if err != nil {
			return nil, err
		}
		networkInterfaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkInterfaceName")])
		if err != nil {
			return nil, err
		}
		ipConfigurationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("ipConfigurationName")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListVirtualMachineScaleSetVMPublicIPAddressesPager(resourceGroupNameParam, virtualMachineScaleSetNameParam, virtualmachineIndexParam, networkInterfaceNameParam, ipConfigurationNameParam, nil)
		newListVirtualMachineScaleSetVMPublicIPAddressesPager = &resp
		p.newListVirtualMachineScaleSetVMPublicIPAddressesPager.add(req, newListVirtualMachineScaleSetVMPublicIPAddressesPager)
		server.PagerResponderInjectNextLinks(newListVirtualMachineScaleSetVMPublicIPAddressesPager, req, func(page *armnetwork.PublicIPAddressesClientListVirtualMachineScaleSetVMPublicIPAddressesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListVirtualMachineScaleSetVMPublicIPAddressesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListVirtualMachineScaleSetVMPublicIPAddressesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListVirtualMachineScaleSetVMPublicIPAddressesPager) {
		p.newListVirtualMachineScaleSetVMPublicIPAddressesPager.remove(req)
	}
	return resp, nil
}

func (p *PublicIPAddressesServerTransport) dispatchUpdateTags(req *http.Request) (*http.Response, error) {
	if p.srv.UpdateTags == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateTags not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/publicIPAddresses/(?P<publicIpAddressName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armnetwork.TagsObject](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	publicIPAddressNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("publicIpAddressName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.UpdateTags(req.Context(), resourceGroupNameParam, publicIPAddressNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PublicIPAddress, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
