//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armorbital_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/orbital/armorbital/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/orbital/resource-manager/Microsoft.Orbital/stable/2022-11-01/examples/SpacecraftsBySubscriptionList.json
func ExampleSpacecraftsClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armorbital.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSpacecraftsClient().NewListBySubscriptionPager(&armorbital.SpacecraftsClientListBySubscriptionOptions{Skiptoken: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SpacecraftListResult = armorbital.SpacecraftListResult{
		// 	Value: []*armorbital.Spacecraft{
		// 		{
		// 			Name: to.Ptr("CONTOSO_SAT"),
		// 			Type: to.Ptr("Microsoft.Orbital/spacecrafts"),
		// 			ID: to.Ptr("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.Orbital/spacecrafts/CONTOSO_SAT"),
		// 			Location: to.Ptr("eastus2"),
		// 			Properties: &armorbital.SpacecraftsProperties{
		// 				Links: []*armorbital.SpacecraftLink{
		// 					{
		// 						Name: to.Ptr("uplink_lhcp1"),
		// 						Authorizations: []*armorbital.AuthorizedGroundstation{
		// 							{
		// 								ExpirationDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2023-06-02"); return t}()),
		// 								GroundStation: to.Ptr("EASTUS2_0"),
		// 						}},
		// 						BandwidthMHz: to.Ptr[float32](2),
		// 						CenterFrequencyMHz: to.Ptr[float32](2250),
		// 						Direction: to.Ptr(armorbital.DirectionUplink),
		// 						Polarization: to.Ptr(armorbital.PolarizationLHCP),
		// 					},
		// 					{
		// 						Name: to.Ptr("downlink_rhcp1"),
		// 						Authorizations: []*armorbital.AuthorizedGroundstation{
		// 							{
		// 								ExpirationDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2023-06-02"); return t}()),
		// 								GroundStation: to.Ptr("EASTUS2_0"),
		// 						}},
		// 						BandwidthMHz: to.Ptr[float32](15),
		// 						CenterFrequencyMHz: to.Ptr[float32](8160),
		// 						Direction: to.Ptr(armorbital.DirectionDownlink),
		// 						Polarization: to.Ptr(armorbital.PolarizationRHCP),
		// 				}},
		// 				NoradID: to.Ptr("36411"),
		// 				ProvisioningState: to.Ptr(armorbital.SpacecraftsPropertiesProvisioningState("Succeeded")),
		// 				TitleLine: to.Ptr("CONTOSO_SAT"),
		// 				TleLine1: to.Ptr("1 27424U 02022A   22167.05119303  .00000638  00000+0  15103-3 0  9994"),
		// 				TleLine2: to.Ptr("2 27424  98.2477 108.9546 0000928  92.9194 327.0802 14.57300770 69982"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/orbital/resource-manager/Microsoft.Orbital/stable/2022-11-01/examples/SpacecraftsByResourceGroupList.json
func ExampleSpacecraftsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armorbital.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSpacecraftsClient().NewListPager("contoso-Rgp", &armorbital.SpacecraftsClientListOptions{Skiptoken: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SpacecraftListResult = armorbital.SpacecraftListResult{
		// 	Value: []*armorbital.Spacecraft{
		// 		{
		// 			Name: to.Ptr("CONTOSO_SAT"),
		// 			Type: to.Ptr("Microsoft.Orbital/spacecrafts"),
		// 			ID: to.Ptr("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.Orbital/spacecrafts/CONTOSO_SAT"),
		// 			Location: to.Ptr("eastus2"),
		// 			Properties: &armorbital.SpacecraftsProperties{
		// 				Links: []*armorbital.SpacecraftLink{
		// 					{
		// 						Name: to.Ptr("uplink_lhcp1"),
		// 						Authorizations: []*armorbital.AuthorizedGroundstation{
		// 							{
		// 								ExpirationDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2023-06-02"); return t}()),
		// 								GroundStation: to.Ptr("EASTUS2_0"),
		// 						}},
		// 						BandwidthMHz: to.Ptr[float32](2),
		// 						CenterFrequencyMHz: to.Ptr[float32](2250),
		// 						Direction: to.Ptr(armorbital.DirectionUplink),
		// 						Polarization: to.Ptr(armorbital.PolarizationLHCP),
		// 					},
		// 					{
		// 						Name: to.Ptr("downlink_rhcp1"),
		// 						Authorizations: []*armorbital.AuthorizedGroundstation{
		// 							{
		// 								ExpirationDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2023-06-02"); return t}()),
		// 								GroundStation: to.Ptr("EASTUS2_0"),
		// 						}},
		// 						BandwidthMHz: to.Ptr[float32](15),
		// 						CenterFrequencyMHz: to.Ptr[float32](8160),
		// 						Direction: to.Ptr(armorbital.DirectionDownlink),
		// 						Polarization: to.Ptr(armorbital.PolarizationRHCP),
		// 				}},
		// 				NoradID: to.Ptr("36411"),
		// 				ProvisioningState: to.Ptr(armorbital.SpacecraftsPropertiesProvisioningState("Succeeded")),
		// 				TitleLine: to.Ptr("CONTOSO_SAT"),
		// 				TleLine1: to.Ptr("1 27424U 02022A   22167.05119303  .00000638  00000+0  15103-3 0  9994"),
		// 				TleLine2: to.Ptr("2 27424  98.2477 108.9546 0000928  92.9194 327.0802 14.57300770 69982"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/orbital/resource-manager/Microsoft.Orbital/stable/2022-11-01/examples/SpacecraftGet.json
func ExampleSpacecraftsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armorbital.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSpacecraftsClient().Get(ctx, "contoso-Rgp", "CONTOSO_SAT", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Spacecraft = armorbital.Spacecraft{
	// 	Name: to.Ptr("CONTOSO_SAT"),
	// 	Type: to.Ptr("Microsoft.Orbital/spacecrafts"),
	// 	ID: to.Ptr("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.Orbital/spacecrafts/CONTOSO_SAT"),
	// 	Location: to.Ptr("eastus2"),
	// 	Properties: &armorbital.SpacecraftsProperties{
	// 		Links: []*armorbital.SpacecraftLink{
	// 			{
	// 				Name: to.Ptr("uplink_lhcp1"),
	// 				Authorizations: []*armorbital.AuthorizedGroundstation{
	// 					{
	// 						ExpirationDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2023-06-02"); return t}()),
	// 						GroundStation: to.Ptr("EASTUS2_0"),
	// 				}},
	// 				BandwidthMHz: to.Ptr[float32](2),
	// 				CenterFrequencyMHz: to.Ptr[float32](2250),
	// 				Direction: to.Ptr(armorbital.DirectionUplink),
	// 				Polarization: to.Ptr(armorbital.PolarizationLHCP),
	// 			},
	// 			{
	// 				Name: to.Ptr("downlink_rhcp1"),
	// 				Authorizations: []*armorbital.AuthorizedGroundstation{
	// 					{
	// 						ExpirationDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2023-06-02"); return t}()),
	// 						GroundStation: to.Ptr("EASTUS2_0"),
	// 				}},
	// 				BandwidthMHz: to.Ptr[float32](15),
	// 				CenterFrequencyMHz: to.Ptr[float32](8160),
	// 				Direction: to.Ptr(armorbital.DirectionDownlink),
	// 				Polarization: to.Ptr(armorbital.PolarizationRHCP),
	// 		}},
	// 		NoradID: to.Ptr("36411"),
	// 		ProvisioningState: to.Ptr(armorbital.SpacecraftsPropertiesProvisioningState("Succeeded")),
	// 		TitleLine: to.Ptr("CONTOSO_SAT"),
	// 		TleLine1: to.Ptr("1 27424U 02022A   22167.05119303  .00000638  00000+0  15103-3 0  9994"),
	// 		TleLine2: to.Ptr("2 27424  98.2477 108.9546 0000928  92.9194 327.0802 14.57300770 69982"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/orbital/resource-manager/Microsoft.Orbital/stable/2022-11-01/examples/SpacecraftCreate.json
func ExampleSpacecraftsClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armorbital.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSpacecraftsClient().BeginCreateOrUpdate(ctx, "contoso-Rgp", "CONTOSO_SAT", armorbital.Spacecraft{
		Location: to.Ptr("eastus2"),
		Properties: &armorbital.SpacecraftsProperties{
			Links: []*armorbital.SpacecraftLink{
				{
					Name:               to.Ptr("uplink_lhcp1"),
					BandwidthMHz:       to.Ptr[float32](2),
					CenterFrequencyMHz: to.Ptr[float32](2250),
					Direction:          to.Ptr(armorbital.DirectionUplink),
					Polarization:       to.Ptr(armorbital.PolarizationLHCP),
				},
				{
					Name:               to.Ptr("downlink_rhcp1"),
					BandwidthMHz:       to.Ptr[float32](15),
					CenterFrequencyMHz: to.Ptr[float32](8160),
					Direction:          to.Ptr(armorbital.DirectionDownlink),
					Polarization:       to.Ptr(armorbital.PolarizationRHCP),
				}},
			NoradID:   to.Ptr("36411"),
			TitleLine: to.Ptr("CONTOSO_SAT"),
			TleLine1:  to.Ptr("1 27424U 02022A   22167.05119303  .00000638  00000+0  15103-3 0  9994"),
			TleLine2:  to.Ptr("2 27424  98.2477 108.9546 0000928  92.9194 327.0802 14.57300770 69982"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Spacecraft = armorbital.Spacecraft{
	// 	Name: to.Ptr("CONTOSO_SAT"),
	// 	Type: to.Ptr("Microsoft.Orbital/spacecrafts"),
	// 	ID: to.Ptr("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.Orbital/spacecrafts/CONTOSO_SAT"),
	// 	Location: to.Ptr("eastus2"),
	// 	Properties: &armorbital.SpacecraftsProperties{
	// 		Links: []*armorbital.SpacecraftLink{
	// 			{
	// 				Name: to.Ptr("uplink_lhcp1"),
	// 				Authorizations: []*armorbital.AuthorizedGroundstation{
	// 					{
	// 						ExpirationDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2023-06-02"); return t}()),
	// 						GroundStation: to.Ptr("EASTUS2_0"),
	// 				}},
	// 				BandwidthMHz: to.Ptr[float32](2),
	// 				CenterFrequencyMHz: to.Ptr[float32](2250),
	// 				Direction: to.Ptr(armorbital.DirectionUplink),
	// 				Polarization: to.Ptr(armorbital.PolarizationLHCP),
	// 			},
	// 			{
	// 				Name: to.Ptr("downlink_rhcp1"),
	// 				Authorizations: []*armorbital.AuthorizedGroundstation{
	// 					{
	// 						ExpirationDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2023-06-02"); return t}()),
	// 						GroundStation: to.Ptr("EASTUS2_0"),
	// 				}},
	// 				BandwidthMHz: to.Ptr[float32](15),
	// 				CenterFrequencyMHz: to.Ptr[float32](8160),
	// 				Direction: to.Ptr(armorbital.DirectionDownlink),
	// 				Polarization: to.Ptr(armorbital.PolarizationRHCP),
	// 		}},
	// 		NoradID: to.Ptr("36411"),
	// 		ProvisioningState: to.Ptr(armorbital.SpacecraftsPropertiesProvisioningState("Succeeded")),
	// 		TitleLine: to.Ptr("CONTOSO_SAT"),
	// 		TleLine1: to.Ptr("1 27424U 02022A   22167.05119303  .00000638  00000+0  15103-3 0  9994"),
	// 		TleLine2: to.Ptr("2 27424  98.2477 108.9546 0000928  92.9194 327.0802 14.57300770 69982"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/orbital/resource-manager/Microsoft.Orbital/stable/2022-11-01/examples/SpacecraftDelete.json
func ExampleSpacecraftsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armorbital.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSpacecraftsClient().BeginDelete(ctx, "contoso-Rgp", "CONTOSO_SAT", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/orbital/resource-manager/Microsoft.Orbital/stable/2022-11-01/examples/SpacecraftUpdateTags.json
func ExampleSpacecraftsClient_BeginUpdateTags() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armorbital.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSpacecraftsClient().BeginUpdateTags(ctx, "contoso-Rgp", "CONTOSO_SAT", armorbital.TagsObject{
		Tags: map[string]*string{
			"tag1": to.Ptr("value1"),
			"tag2": to.Ptr("value2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Spacecraft = armorbital.Spacecraft{
	// 	Name: to.Ptr("CONTOSO_SAT"),
	// 	Type: to.Ptr("Microsoft.Orbital/spacecrafts"),
	// 	ID: to.Ptr("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.Orbital/spacecrafts/CONTOSO_SAT"),
	// 	Location: to.Ptr("eastus2"),
	// 	Tags: map[string]*string{
	// 		"tag1": to.Ptr("value1"),
	// 		"tag2": to.Ptr("value2"),
	// 	},
	// 	Properties: &armorbital.SpacecraftsProperties{
	// 		Links: []*armorbital.SpacecraftLink{
	// 			{
	// 				Name: to.Ptr("uplink_lhcp1"),
	// 				Authorizations: []*armorbital.AuthorizedGroundstation{
	// 					{
	// 						ExpirationDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2023-06-02"); return t}()),
	// 						GroundStation: to.Ptr("EASTUS2_0"),
	// 				}},
	// 				BandwidthMHz: to.Ptr[float32](2),
	// 				CenterFrequencyMHz: to.Ptr[float32](2250),
	// 				Direction: to.Ptr(armorbital.DirectionUplink),
	// 				Polarization: to.Ptr(armorbital.PolarizationLHCP),
	// 			},
	// 			{
	// 				Name: to.Ptr("downlink_rhcp1"),
	// 				Authorizations: []*armorbital.AuthorizedGroundstation{
	// 					{
	// 						ExpirationDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2023-06-02"); return t}()),
	// 						GroundStation: to.Ptr("EASTUS2_0"),
	// 				}},
	// 				BandwidthMHz: to.Ptr[float32](15),
	// 				CenterFrequencyMHz: to.Ptr[float32](8160),
	// 				Direction: to.Ptr(armorbital.DirectionDownlink),
	// 				Polarization: to.Ptr(armorbital.PolarizationRHCP),
	// 		}},
	// 		NoradID: to.Ptr("36411"),
	// 		ProvisioningState: to.Ptr(armorbital.SpacecraftsPropertiesProvisioningState("Succeeded")),
	// 		TitleLine: to.Ptr("CONTOSO_SAT"),
	// 		TleLine1: to.Ptr("1 27424U 02022A   22167.05119303  .00000638  00000+0  15103-3 0  9994"),
	// 		TleLine2: to.Ptr("2 27424  98.2477 108.9546 0000928  92.9194 327.0802 14.57300770 69982"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/orbital/resource-manager/Microsoft.Orbital/stable/2022-11-01/examples/AvailableContactsList.json
func ExampleSpacecraftsClient_BeginListAvailableContacts() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armorbital.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSpacecraftsClient().BeginListAvailableContacts(ctx, "contoso-Rgp", "CONTOSO_SAT", armorbital.ContactParameters{
		ContactProfile: &armorbital.ContactParametersContactProfile{
			ID: to.Ptr("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.Orbital/contactProfiles/CONTOSO-CP"),
		},
		EndTime:           to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-02T11:30:00.000Z"); return t }()),
		GroundStationName: to.Ptr("EASTUS2_0"),
		StartTime:         to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-01T11:30:00.000Z"); return t }()),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	for res.More() {
		page, err := res.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AvailableContactsListResult = armorbital.AvailableContactsListResult{
		// 	Value: []*armorbital.AvailableContacts{
		// 		{
		// 			GroundStationName: to.Ptr("EASTUS2_0"),
		// 			Properties: &armorbital.AvailableContactsProperties{
		// 				EndAzimuthDegrees: to.Ptr[float32](330.489627),
		// 				EndElevationDegrees: to.Ptr[float32](5.040625),
		// 				MaximumElevationDegrees: to.Ptr[float32](26.617297),
		// 				RxEndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-01T12:05:25.000Z"); return t}()),
		// 				RxStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-01T11:55:01.000Z"); return t}()),
		// 				StartAzimuthDegrees: to.Ptr[float32](201.340472),
		// 				StartElevationDegrees: to.Ptr[float32](5),
		// 				TxEndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-01T12:05:25.000Z"); return t}()),
		// 				TxStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-01T11:55:01.000Z"); return t}()),
		// 			},
		// 			Spacecraft: &armorbital.AvailableContactsSpacecraft{
		// 				ID: to.Ptr("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.Orbital/spacecrafts/CONTOSO_SAT"),
		// 			},
		// 		},
		// 		{
		// 			GroundStationName: to.Ptr("EASTUS2_0"),
		// 			Properties: &armorbital.AvailableContactsProperties{
		// 				EndAzimuthDegrees: to.Ptr[float32](345.848482),
		// 				EndElevationDegrees: to.Ptr[float32](5.048656),
		// 				MaximumElevationDegrees: to.Ptr[float32](85.9796),
		// 				RxEndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-02T11:10:45.000Z"); return t}()),
		// 				RxStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-02T10:58:30.000Z"); return t}()),
		// 				StartAzimuthDegrees: to.Ptr[float32](165.758896),
		// 				StartElevationDegrees: to.Ptr[float32](5),
		// 				TxEndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-02T11:10:45.000Z"); return t}()),
		// 				TxStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-02T10:58:30.000Z"); return t}()),
		// 			},
		// 			Spacecraft: &armorbital.AvailableContactsSpacecraft{
		// 				ID: to.Ptr("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.Orbital/spacecrafts/CONTOSO_SAT"),
		// 			},
		// 	}},
		// }
	}
}
