//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storsimple1200series/armstorsimple1200series"
	"net/http"
	"net/url"
	"regexp"
)

// FileServersServer is a fake server for instances of the armstorsimple1200series.FileServersClient type.
type FileServersServer struct {
	// BeginBackupNow is the fake for method FileServersClient.BeginBackupNow
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginBackupNow func(ctx context.Context, deviceName string, fileServerName string, resourceGroupName string, managerName string, options *armstorsimple1200series.FileServersClientBeginBackupNowOptions) (resp azfake.PollerResponder[armstorsimple1200series.FileServersClientBackupNowResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdate is the fake for method FileServersClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateOrUpdate func(ctx context.Context, deviceName string, fileServerName string, resourceGroupName string, managerName string, fileServer armstorsimple1200series.FileServer, options *armstorsimple1200series.FileServersClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armstorsimple1200series.FileServersClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method FileServersClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, deviceName string, fileServerName string, resourceGroupName string, managerName string, options *armstorsimple1200series.FileServersClientBeginDeleteOptions) (resp azfake.PollerResponder[armstorsimple1200series.FileServersClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method FileServersClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, deviceName string, fileServerName string, resourceGroupName string, managerName string, options *armstorsimple1200series.FileServersClientGetOptions) (resp azfake.Responder[armstorsimple1200series.FileServersClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByDevicePager is the fake for method FileServersClient.NewListByDevicePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByDevicePager func(deviceName string, resourceGroupName string, managerName string, options *armstorsimple1200series.FileServersClientListByDeviceOptions) (resp azfake.PagerResponder[armstorsimple1200series.FileServersClientListByDeviceResponse])

	// NewListByManagerPager is the fake for method FileServersClient.NewListByManagerPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByManagerPager func(resourceGroupName string, managerName string, options *armstorsimple1200series.FileServersClientListByManagerOptions) (resp azfake.PagerResponder[armstorsimple1200series.FileServersClientListByManagerResponse])

	// NewListMetricDefinitionPager is the fake for method FileServersClient.NewListMetricDefinitionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListMetricDefinitionPager func(deviceName string, fileServerName string, resourceGroupName string, managerName string, options *armstorsimple1200series.FileServersClientListMetricDefinitionOptions) (resp azfake.PagerResponder[armstorsimple1200series.FileServersClientListMetricDefinitionResponse])

	// NewListMetricsPager is the fake for method FileServersClient.NewListMetricsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListMetricsPager func(deviceName string, fileServerName string, resourceGroupName string, managerName string, options *armstorsimple1200series.FileServersClientListMetricsOptions) (resp azfake.PagerResponder[armstorsimple1200series.FileServersClientListMetricsResponse])
}

// NewFileServersServerTransport creates a new instance of FileServersServerTransport with the provided implementation.
// The returned FileServersServerTransport instance is connected to an instance of armstorsimple1200series.FileServersClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewFileServersServerTransport(srv *FileServersServer) *FileServersServerTransport {
	return &FileServersServerTransport{
		srv:                          srv,
		beginBackupNow:               newTracker[azfake.PollerResponder[armstorsimple1200series.FileServersClientBackupNowResponse]](),
		beginCreateOrUpdate:          newTracker[azfake.PollerResponder[armstorsimple1200series.FileServersClientCreateOrUpdateResponse]](),
		beginDelete:                  newTracker[azfake.PollerResponder[armstorsimple1200series.FileServersClientDeleteResponse]](),
		newListByDevicePager:         newTracker[azfake.PagerResponder[armstorsimple1200series.FileServersClientListByDeviceResponse]](),
		newListByManagerPager:        newTracker[azfake.PagerResponder[armstorsimple1200series.FileServersClientListByManagerResponse]](),
		newListMetricDefinitionPager: newTracker[azfake.PagerResponder[armstorsimple1200series.FileServersClientListMetricDefinitionResponse]](),
		newListMetricsPager:          newTracker[azfake.PagerResponder[armstorsimple1200series.FileServersClientListMetricsResponse]](),
	}
}

// FileServersServerTransport connects instances of armstorsimple1200series.FileServersClient to instances of FileServersServer.
// Don't use this type directly, use NewFileServersServerTransport instead.
type FileServersServerTransport struct {
	srv                          *FileServersServer
	beginBackupNow               *tracker[azfake.PollerResponder[armstorsimple1200series.FileServersClientBackupNowResponse]]
	beginCreateOrUpdate          *tracker[azfake.PollerResponder[armstorsimple1200series.FileServersClientCreateOrUpdateResponse]]
	beginDelete                  *tracker[azfake.PollerResponder[armstorsimple1200series.FileServersClientDeleteResponse]]
	newListByDevicePager         *tracker[azfake.PagerResponder[armstorsimple1200series.FileServersClientListByDeviceResponse]]
	newListByManagerPager        *tracker[azfake.PagerResponder[armstorsimple1200series.FileServersClientListByManagerResponse]]
	newListMetricDefinitionPager *tracker[azfake.PagerResponder[armstorsimple1200series.FileServersClientListMetricDefinitionResponse]]
	newListMetricsPager          *tracker[azfake.PagerResponder[armstorsimple1200series.FileServersClientListMetricsResponse]]
}

// Do implements the policy.Transporter interface for FileServersServerTransport.
func (f *FileServersServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "FileServersClient.BeginBackupNow":
		resp, err = f.dispatchBeginBackupNow(req)
	case "FileServersClient.BeginCreateOrUpdate":
		resp, err = f.dispatchBeginCreateOrUpdate(req)
	case "FileServersClient.BeginDelete":
		resp, err = f.dispatchBeginDelete(req)
	case "FileServersClient.Get":
		resp, err = f.dispatchGet(req)
	case "FileServersClient.NewListByDevicePager":
		resp, err = f.dispatchNewListByDevicePager(req)
	case "FileServersClient.NewListByManagerPager":
		resp, err = f.dispatchNewListByManagerPager(req)
	case "FileServersClient.NewListMetricDefinitionPager":
		resp, err = f.dispatchNewListMetricDefinitionPager(req)
	case "FileServersClient.NewListMetricsPager":
		resp, err = f.dispatchNewListMetricsPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (f *FileServersServerTransport) dispatchBeginBackupNow(req *http.Request) (*http.Response, error) {
	if f.srv.BeginBackupNow == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginBackupNow not implemented")}
	}
	beginBackupNow := f.beginBackupNow.get(req)
	if beginBackupNow == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/fileservers/(?P<fileServerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backup`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		fileServerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fileServerName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := f.srv.BeginBackupNow(req.Context(), deviceNameParam, fileServerNameParam, resourceGroupNameParam, managerNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginBackupNow = &respr
		f.beginBackupNow.add(req, beginBackupNow)
	}

	resp, err := server.PollerResponderNext(beginBackupNow, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		f.beginBackupNow.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginBackupNow) {
		f.beginBackupNow.remove(req)
	}

	return resp, nil
}

func (f *FileServersServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if f.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := f.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/fileservers/(?P<fileServerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armstorsimple1200series.FileServer](req)
		if err != nil {
			return nil, err
		}
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		fileServerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fileServerName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := f.srv.BeginCreateOrUpdate(req.Context(), deviceNameParam, fileServerNameParam, resourceGroupNameParam, managerNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		f.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		f.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		f.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (f *FileServersServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if f.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := f.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/fileservers/(?P<fileServerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		fileServerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fileServerName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := f.srv.BeginDelete(req.Context(), deviceNameParam, fileServerNameParam, resourceGroupNameParam, managerNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		f.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		f.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		f.beginDelete.remove(req)
	}

	return resp, nil
}

func (f *FileServersServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if f.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/fileservers/(?P<fileServerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
	if err != nil {
		return nil, err
	}
	fileServerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fileServerName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := f.srv.Get(req.Context(), deviceNameParam, fileServerNameParam, resourceGroupNameParam, managerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).FileServer, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (f *FileServersServerTransport) dispatchNewListByDevicePager(req *http.Request) (*http.Response, error) {
	if f.srv.NewListByDevicePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByDevicePager not implemented")}
	}
	newListByDevicePager := f.newListByDevicePager.get(req)
	if newListByDevicePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/fileservers`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		resp := f.srv.NewListByDevicePager(deviceNameParam, resourceGroupNameParam, managerNameParam, nil)
		newListByDevicePager = &resp
		f.newListByDevicePager.add(req, newListByDevicePager)
	}
	resp, err := server.PagerResponderNext(newListByDevicePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		f.newListByDevicePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByDevicePager) {
		f.newListByDevicePager.remove(req)
	}
	return resp, nil
}

func (f *FileServersServerTransport) dispatchNewListByManagerPager(req *http.Request) (*http.Response, error) {
	if f.srv.NewListByManagerPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByManagerPager not implemented")}
	}
	newListByManagerPager := f.newListByManagerPager.get(req)
	if newListByManagerPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/fileservers`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		resp := f.srv.NewListByManagerPager(resourceGroupNameParam, managerNameParam, nil)
		newListByManagerPager = &resp
		f.newListByManagerPager.add(req, newListByManagerPager)
	}
	resp, err := server.PagerResponderNext(newListByManagerPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		f.newListByManagerPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByManagerPager) {
		f.newListByManagerPager.remove(req)
	}
	return resp, nil
}

func (f *FileServersServerTransport) dispatchNewListMetricDefinitionPager(req *http.Request) (*http.Response, error) {
	if f.srv.NewListMetricDefinitionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListMetricDefinitionPager not implemented")}
	}
	newListMetricDefinitionPager := f.newListMetricDefinitionPager.get(req)
	if newListMetricDefinitionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/fileservers/(?P<fileServerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/metricsDefinitions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		fileServerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fileServerName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		resp := f.srv.NewListMetricDefinitionPager(deviceNameParam, fileServerNameParam, resourceGroupNameParam, managerNameParam, nil)
		newListMetricDefinitionPager = &resp
		f.newListMetricDefinitionPager.add(req, newListMetricDefinitionPager)
	}
	resp, err := server.PagerResponderNext(newListMetricDefinitionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		f.newListMetricDefinitionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListMetricDefinitionPager) {
		f.newListMetricDefinitionPager.remove(req)
	}
	return resp, nil
}

func (f *FileServersServerTransport) dispatchNewListMetricsPager(req *http.Request) (*http.Response, error) {
	if f.srv.NewListMetricsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListMetricsPager not implemented")}
	}
	newListMetricsPager := f.newListMetricsPager.get(req)
	if newListMetricsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/fileservers/(?P<fileServerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/metrics`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		deviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceName")])
		if err != nil {
			return nil, err
		}
		fileServerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fileServerName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armstorsimple1200series.FileServersClientListMetricsOptions
		if filterParam != nil {
			options = &armstorsimple1200series.FileServersClientListMetricsOptions{
				Filter: filterParam,
			}
		}
		resp := f.srv.NewListMetricsPager(deviceNameParam, fileServerNameParam, resourceGroupNameParam, managerNameParam, options)
		newListMetricsPager = &resp
		f.newListMetricsPager.add(req, newListMetricsPager)
	}
	resp, err := server.PagerResponderNext(newListMetricsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		f.newListMetricsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListMetricsPager) {
		f.newListMetricsPager.remove(req)
	}
	return resp, nil
}
