//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/vmwarecloudsimple/armvmwarecloudsimple"
	"net/http"
	"net/url"
	"regexp"
)

// CustomizationPoliciesServer is a fake server for instances of the armvmwarecloudsimple.CustomizationPoliciesClient type.
type CustomizationPoliciesServer struct {
	// Get is the fake for method CustomizationPoliciesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, regionID string, pcName string, customizationPolicyName string, options *armvmwarecloudsimple.CustomizationPoliciesClientGetOptions) (resp azfake.Responder[armvmwarecloudsimple.CustomizationPoliciesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method CustomizationPoliciesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(regionID string, pcName string, options *armvmwarecloudsimple.CustomizationPoliciesClientListOptions) (resp azfake.PagerResponder[armvmwarecloudsimple.CustomizationPoliciesClientListResponse])
}

// NewCustomizationPoliciesServerTransport creates a new instance of CustomizationPoliciesServerTransport with the provided implementation.
// The returned CustomizationPoliciesServerTransport instance is connected to an instance of armvmwarecloudsimple.CustomizationPoliciesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewCustomizationPoliciesServerTransport(srv *CustomizationPoliciesServer) *CustomizationPoliciesServerTransport {
	return &CustomizationPoliciesServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armvmwarecloudsimple.CustomizationPoliciesClientListResponse]](),
	}
}

// CustomizationPoliciesServerTransport connects instances of armvmwarecloudsimple.CustomizationPoliciesClient to instances of CustomizationPoliciesServer.
// Don't use this type directly, use NewCustomizationPoliciesServerTransport instead.
type CustomizationPoliciesServerTransport struct {
	srv          *CustomizationPoliciesServer
	newListPager *tracker[azfake.PagerResponder[armvmwarecloudsimple.CustomizationPoliciesClientListResponse]]
}

// Do implements the policy.Transporter interface for CustomizationPoliciesServerTransport.
func (c *CustomizationPoliciesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "CustomizationPoliciesClient.Get":
		resp, err = c.dispatchGet(req)
	case "CustomizationPoliciesClient.NewListPager":
		resp, err = c.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *CustomizationPoliciesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.VMwareCloudSimple/locations/(?P<regionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateClouds/(?P<pcName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/customizationPolicies/(?P<customizationPolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	regionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("regionId")])
	if err != nil {
		return nil, err
	}
	pcNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("pcName")])
	if err != nil {
		return nil, err
	}
	customizationPolicyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("customizationPolicyName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), regionIDParam, pcNameParam, customizationPolicyNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CustomizationPolicy, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CustomizationPoliciesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := c.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.VMwareCloudSimple/locations/(?P<regionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateClouds/(?P<pcName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/customizationPolicies`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		regionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("regionId")])
		if err != nil {
			return nil, err
		}
		pcNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("pcName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armvmwarecloudsimple.CustomizationPoliciesClientListOptions
		if filterParam != nil {
			options = &armvmwarecloudsimple.CustomizationPoliciesClientListOptions{
				Filter: filterParam,
			}
		}
		resp := c.srv.NewListPager(regionIDParam, pcNameParam, options)
		newListPager = &resp
		c.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armvmwarecloudsimple.CustomizationPoliciesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		c.newListPager.remove(req)
	}
	return resp, nil
}
