// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v5.27.2
// source: check.proto

// Package check represents an attestation validation policy.

package check

import (
	sevsnp "github.com/google/go-sev-guest/proto/sevsnp"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Policy is a representation of an attestation report validation policy.
// Each field corresponds to a field on validate.Options. This format
// is useful for providing programmatic inputs to the `check` CLI tool.
type Policy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MinimumGuestSvn uint32 `protobuf:"varint,1,opt,name=minimum_guest_svn,json=minimumGuestSvn,proto3" json:"minimum_guest_svn,omitempty"`
	// The component-wise maximum permissible guest policy, except
	// API version values, and SingleSocket are the minimum permissible.
	Policy                    uint64                  `protobuf:"varint,2,opt,name=policy,proto3" json:"policy,omitempty"`
	FamilyId                  []byte                  `protobuf:"bytes,3,opt,name=family_id,json=familyId,proto3" json:"family_id,omitempty"` // Should be 16 bytes long
	ImageId                   []byte                  `protobuf:"bytes,4,opt,name=image_id,json=imageId,proto3" json:"image_id,omitempty"`    // Should be 16 bytes long
	Vmpl                      *wrapperspb.UInt32Value `protobuf:"bytes,5,opt,name=vmpl,proto3" json:"vmpl,omitempty"`
	MinimumTcb                uint64                  `protobuf:"varint,6,opt,name=minimum_tcb,json=minimumTcb,proto3" json:"minimum_tcb,omitempty"`
	MinimumLaunchTcb          uint64                  `protobuf:"varint,7,opt,name=minimum_launch_tcb,json=minimumLaunchTcb,proto3" json:"minimum_launch_tcb,omitempty"`
	PlatformInfo              *wrapperspb.UInt64Value `protobuf:"bytes,8,opt,name=platform_info,json=platformInfo,proto3" json:"platform_info,omitempty"`
	RequireAuthorKey          bool                    `protobuf:"varint,9,opt,name=require_author_key,json=requireAuthorKey,proto3" json:"require_author_key,omitempty"`
	ReportData                []byte                  `protobuf:"bytes,10,opt,name=report_data,json=reportData,proto3" json:"report_data,omitempty"`   // Should be 64 bytes long
	Measurement               []byte                  `protobuf:"bytes,11,opt,name=measurement,proto3" json:"measurement,omitempty"`                   // Should be 48 bytes long
	HostData                  []byte                  `protobuf:"bytes,12,opt,name=host_data,json=hostData,proto3" json:"host_data,omitempty"`         // Should be 32 bytes long
	ReportId                  []byte                  `protobuf:"bytes,13,opt,name=report_id,json=reportId,proto3" json:"report_id,omitempty"`         // Should be 32 bytes long
	ReportIdMa                []byte                  `protobuf:"bytes,14,opt,name=report_id_ma,json=reportIdMa,proto3" json:"report_id_ma,omitempty"` // Should be 32 bytes long
	ChipId                    []byte                  `protobuf:"bytes,15,opt,name=chip_id,json=chipId,proto3" json:"chip_id,omitempty"`               // Should be 64 bytes long
	MinimumBuild              uint32                  `protobuf:"varint,16,opt,name=minimum_build,json=minimumBuild,proto3" json:"minimum_build,omitempty"`
	MinimumVersion            string                  `protobuf:"bytes,17,opt,name=minimum_version,json=minimumVersion,proto3" json:"minimum_version,omitempty"` // Should be "maj.min", both should be 0-255.
	PermitProvisionalFirmware bool                    `protobuf:"varint,18,opt,name=permit_provisional_firmware,json=permitProvisionalFirmware,proto3" json:"permit_provisional_firmware,omitempty"`
	RequireIdBlock            bool                    `protobuf:"varint,19,opt,name=require_id_block,json=requireIdBlock,proto3" json:"require_id_block,omitempty"`
	TrustedAuthorKeys         [][]byte                `protobuf:"bytes,20,rep,name=trusted_author_keys,json=trustedAuthorKeys,proto3" json:"trusted_author_keys,omitempty"`
	TrustedAuthorKeyHashes    [][]byte                `protobuf:"bytes,21,rep,name=trusted_author_key_hashes,json=trustedAuthorKeyHashes,proto3" json:"trusted_author_key_hashes,omitempty"`
	TrustedIdKeys             [][]byte                `protobuf:"bytes,22,rep,name=trusted_id_keys,json=trustedIdKeys,proto3" json:"trusted_id_keys,omitempty"`
	TrustedIdKeyHashes        [][]byte                `protobuf:"bytes,23,rep,name=trusted_id_key_hashes,json=trustedIdKeyHashes,proto3" json:"trusted_id_key_hashes,omitempty"`
	// The expected product that generated the attestation report. Stepping optional.
	Product *sevsnp.SevProduct `protobuf:"bytes,24,opt,name=product,proto3" json:"product,omitempty"`
}

func (x *Policy) Reset() {
	*x = Policy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_check_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Policy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Policy) ProtoMessage() {}

func (x *Policy) ProtoReflect() protoreflect.Message {
	mi := &file_check_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Policy.ProtoReflect.Descriptor instead.
func (*Policy) Descriptor() ([]byte, []int) {
	return file_check_proto_rawDescGZIP(), []int{0}
}

func (x *Policy) GetMinimumGuestSvn() uint32 {
	if x != nil {
		return x.MinimumGuestSvn
	}
	return 0
}

func (x *Policy) GetPolicy() uint64 {
	if x != nil {
		return x.Policy
	}
	return 0
}

func (x *Policy) GetFamilyId() []byte {
	if x != nil {
		return x.FamilyId
	}
	return nil
}

func (x *Policy) GetImageId() []byte {
	if x != nil {
		return x.ImageId
	}
	return nil
}

func (x *Policy) GetVmpl() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Vmpl
	}
	return nil
}

func (x *Policy) GetMinimumTcb() uint64 {
	if x != nil {
		return x.MinimumTcb
	}
	return 0
}

func (x *Policy) GetMinimumLaunchTcb() uint64 {
	if x != nil {
		return x.MinimumLaunchTcb
	}
	return 0
}

func (x *Policy) GetPlatformInfo() *wrapperspb.UInt64Value {
	if x != nil {
		return x.PlatformInfo
	}
	return nil
}

func (x *Policy) GetRequireAuthorKey() bool {
	if x != nil {
		return x.RequireAuthorKey
	}
	return false
}

func (x *Policy) GetReportData() []byte {
	if x != nil {
		return x.ReportData
	}
	return nil
}

func (x *Policy) GetMeasurement() []byte {
	if x != nil {
		return x.Measurement
	}
	return nil
}

func (x *Policy) GetHostData() []byte {
	if x != nil {
		return x.HostData
	}
	return nil
}

func (x *Policy) GetReportId() []byte {
	if x != nil {
		return x.ReportId
	}
	return nil
}

func (x *Policy) GetReportIdMa() []byte {
	if x != nil {
		return x.ReportIdMa
	}
	return nil
}

func (x *Policy) GetChipId() []byte {
	if x != nil {
		return x.ChipId
	}
	return nil
}

func (x *Policy) GetMinimumBuild() uint32 {
	if x != nil {
		return x.MinimumBuild
	}
	return 0
}

func (x *Policy) GetMinimumVersion() string {
	if x != nil {
		return x.MinimumVersion
	}
	return ""
}

func (x *Policy) GetPermitProvisionalFirmware() bool {
	if x != nil {
		return x.PermitProvisionalFirmware
	}
	return false
}

func (x *Policy) GetRequireIdBlock() bool {
	if x != nil {
		return x.RequireIdBlock
	}
	return false
}

func (x *Policy) GetTrustedAuthorKeys() [][]byte {
	if x != nil {
		return x.TrustedAuthorKeys
	}
	return nil
}

func (x *Policy) GetTrustedAuthorKeyHashes() [][]byte {
	if x != nil {
		return x.TrustedAuthorKeyHashes
	}
	return nil
}

func (x *Policy) GetTrustedIdKeys() [][]byte {
	if x != nil {
		return x.TrustedIdKeys
	}
	return nil
}

func (x *Policy) GetTrustedIdKeyHashes() [][]byte {
	if x != nil {
		return x.TrustedIdKeyHashes
	}
	return nil
}

func (x *Policy) GetProduct() *sevsnp.SevProduct {
	if x != nil {
		return x.Product
	}
	return nil
}

// RootOfTrust represents configuration for which hardware root of trust
// certificates to use for verifying attestation report signatures.
type RootOfTrust struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The expected AMD product the attestation was collected from. Default
	// "Milan".
	//
	// Deprecated: Marked as deprecated in check.proto.
	Product string `protobuf:"bytes,1,opt,name=product,proto3" json:"product,omitempty"`
	// Paths to CA bundles for the AMD product.
	// Must be in PEM format, AS[V]K, then ARK certificates.
	// This is for verifing a report's signature, as opposed to validating trust
	// in the report's ID key or author key.
	// If empty, uses the verification library's embedded certificates from AMD.
	CabundlePaths []string `protobuf:"bytes,2,rep,name=cabundle_paths,json=cabundlePaths,proto3" json:"cabundle_paths,omitempty"`
	// PEM format CA bundles for the AMD product. Combined with contents of cabundle_paths.
	Cabundles []string `protobuf:"bytes,3,rep,name=cabundles,proto3" json:"cabundles,omitempty"`
	// If true, download and check the CRL for revoked certificates.
	CheckCrl bool `protobuf:"varint,4,opt,name=check_crl,json=checkCrl,proto3" json:"check_crl,omitempty"`
	// If true, then check is not permitted to download necessary files for verification.
	DisallowNetwork bool `protobuf:"varint,5,opt,name=disallow_network,json=disallowNetwork,proto3" json:"disallow_network,omitempty"`
	// The expected AMD product line the attestation was collected from. Default "Milan".
	ProductLine string `protobuf:"bytes,6,opt,name=product_line,json=productLine,proto3" json:"product_line,omitempty"`
}

func (x *RootOfTrust) Reset() {
	*x = RootOfTrust{}
	if protoimpl.UnsafeEnabled {
		mi := &file_check_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RootOfTrust) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RootOfTrust) ProtoMessage() {}

func (x *RootOfTrust) ProtoReflect() protoreflect.Message {
	mi := &file_check_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RootOfTrust.ProtoReflect.Descriptor instead.
func (*RootOfTrust) Descriptor() ([]byte, []int) {
	return file_check_proto_rawDescGZIP(), []int{1}
}

// Deprecated: Marked as deprecated in check.proto.
func (x *RootOfTrust) GetProduct() string {
	if x != nil {
		return x.Product
	}
	return ""
}

func (x *RootOfTrust) GetCabundlePaths() []string {
	if x != nil {
		return x.CabundlePaths
	}
	return nil
}

func (x *RootOfTrust) GetCabundles() []string {
	if x != nil {
		return x.Cabundles
	}
	return nil
}

func (x *RootOfTrust) GetCheckCrl() bool {
	if x != nil {
		return x.CheckCrl
	}
	return false
}

func (x *RootOfTrust) GetDisallowNetwork() bool {
	if x != nil {
		return x.DisallowNetwork
	}
	return false
}

func (x *RootOfTrust) GetProductLine() string {
	if x != nil {
		return x.ProductLine
	}
	return ""
}

// Config is the overall message input for the check tool. This provides all
// the flags that configure the tool, including the validation policy.
type Config struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configures which hardware keys to trust. Default uses library-embedded
	// certificates.
	RootOfTrust *RootOfTrust `protobuf:"bytes,1,opt,name=root_of_trust,json=rootOfTrust,proto3" json:"root_of_trust,omitempty"`
	// The report validation policy.
	Policy *Policy `protobuf:"bytes,2,opt,name=policy,proto3" json:"policy,omitempty"`
}

func (x *Config) Reset() {
	*x = Config{}
	if protoimpl.UnsafeEnabled {
		mi := &file_check_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Config) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Config) ProtoMessage() {}

func (x *Config) ProtoReflect() protoreflect.Message {
	mi := &file_check_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Config.ProtoReflect.Descriptor instead.
func (*Config) Descriptor() ([]byte, []int) {
	return file_check_proto_rawDescGZIP(), []int{2}
}

func (x *Config) GetRootOfTrust() *RootOfTrust {
	if x != nil {
		return x.RootOfTrust
	}
	return nil
}

func (x *Config) GetPolicy() *Policy {
	if x != nil {
		return x.Policy
	}
	return nil
}

var File_check_proto protoreflect.FileDescriptor

var file_check_proto_rawDesc = []byte{
	0x0a, 0x0b, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x05, 0x63,
	0x68, 0x65, 0x63, 0x6b, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x0c, 0x73, 0x65, 0x76, 0x73, 0x6e, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xda, 0x07, 0x0a, 0x06, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x2a, 0x0a,
	0x11, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x67, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x73,
	0x76, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0f, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75,
	0x6d, 0x47, 0x75, 0x65, 0x73, 0x74, 0x53, 0x76, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x49, 0x64, 0x12, 0x19,
	0x0a, 0x08, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x07, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x64, 0x12, 0x30, 0x0a, 0x04, 0x76, 0x6d, 0x70,
	0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x04, 0x76, 0x6d, 0x70, 0x6c, 0x12, 0x1f, 0x0a, 0x0b, 0x6d,
	0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x74, 0x63, 0x62, 0x18, 0x06, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x0a, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x54, 0x63, 0x62, 0x12, 0x2c, 0x0a, 0x12,
	0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x6c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x5f, 0x74,
	0x63, 0x62, 0x18, 0x07, 0x20, 0x01, 0x28, 0x04, 0x52, 0x10, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75,
	0x6d, 0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x54, 0x63, 0x62, 0x12, 0x41, 0x0a, 0x0d, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x0c, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x2c, 0x0a,
	0x12, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x5f,
	0x6b, 0x65, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x72, 0x65, 0x71, 0x75, 0x69,
	0x72, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x4b, 0x65, 0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x72,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x20, 0x0a, 0x0b,
	0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x0b, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x1b, 0x0a, 0x09, 0x72,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08,
	0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x64, 0x12, 0x20, 0x0a, 0x0c, 0x72, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x5f, 0x69, 0x64, 0x5f, 0x6d, 0x61, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a,
	0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x64, 0x4d, 0x61, 0x12, 0x17, 0x0a, 0x07, 0x63, 0x68,
	0x69, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x63, 0x68, 0x69,
	0x70, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0c, 0x6d, 0x69, 0x6e, 0x69,
	0x6d, 0x75, 0x6d, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x6d, 0x69, 0x6e, 0x69,
	0x6d, 0x75, 0x6d, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x11, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0e, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x3e, 0x0a, 0x1b, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x66, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x18, 0x12, 0x20, 0x01, 0x28, 0x08, 0x52, 0x19, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x74, 0x50, 0x72,
	0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x46, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x12, 0x28, 0x0a, 0x10, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x5f, 0x69, 0x64, 0x5f,
	0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x13, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x72, 0x65, 0x71,
	0x75, 0x69, 0x72, 0x65, 0x49, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x2e, 0x0a, 0x13, 0x74,
	0x72, 0x75, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x5f, 0x6b, 0x65,
	0x79, 0x73, 0x18, 0x14, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x11, 0x74, 0x72, 0x75, 0x73, 0x74, 0x65,
	0x64, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x39, 0x0a, 0x19, 0x74,
	0x72, 0x75, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x5f, 0x6b, 0x65,
	0x79, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x65, 0x73, 0x18, 0x15, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x16,
	0x74, 0x72, 0x75, 0x73, 0x74, 0x65, 0x64, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x4b, 0x65, 0x79,
	0x48, 0x61, 0x73, 0x68, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x74, 0x72, 0x75, 0x73, 0x74, 0x65,
	0x64, 0x5f, 0x69, 0x64, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x16, 0x20, 0x03, 0x28, 0x0c, 0x52,
	0x0d, 0x74, 0x72, 0x75, 0x73, 0x74, 0x65, 0x64, 0x49, 0x64, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x31,
	0x0a, 0x15, 0x74, 0x72, 0x75, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x69, 0x64, 0x5f, 0x6b, 0x65, 0x79,
	0x5f, 0x68, 0x61, 0x73, 0x68, 0x65, 0x73, 0x18, 0x17, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x12, 0x74,
	0x72, 0x75, 0x73, 0x74, 0x65, 0x64, 0x49, 0x64, 0x4b, 0x65, 0x79, 0x48, 0x61, 0x73, 0x68, 0x65,
	0x73, 0x12, 0x2c, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x18, 0x18, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x12, 0x2e, 0x73, 0x65, 0x76, 0x73, 0x6e, 0x70, 0x2e, 0x53, 0x65, 0x76, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x22,
	0xdb, 0x01, 0x0a, 0x0b, 0x52, 0x6f, 0x6f, 0x74, 0x4f, 0x66, 0x54, 0x72, 0x75, 0x73, 0x74, 0x12,
	0x1c, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x12, 0x25, 0x0a,
	0x0e, 0x63, 0x61, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x61, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x50,
	0x61, 0x74, 0x68, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x61, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x63, 0x61, 0x62, 0x75, 0x6e, 0x64, 0x6c,
	0x65, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x5f, 0x63, 0x72, 0x6c, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x43, 0x72, 0x6c, 0x12,
	0x29, 0x0a, 0x10, 0x64, 0x69, 0x73, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x64, 0x69, 0x73, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x4c, 0x69, 0x6e, 0x65, 0x22, 0x67, 0x0a,
	0x06, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x36, 0x0a, 0x0d, 0x72, 0x6f, 0x6f, 0x74, 0x5f,
	0x6f, 0x66, 0x5f, 0x74, 0x72, 0x75, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12,
	0x2e, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x2e, 0x52, 0x6f, 0x6f, 0x74, 0x4f, 0x66, 0x54, 0x72, 0x75,
	0x73, 0x74, 0x52, 0x0b, 0x72, 0x6f, 0x6f, 0x74, 0x4f, 0x66, 0x54, 0x72, 0x75, 0x73, 0x74, 0x12,
	0x25, 0x0a, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x0d, 0x2e, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x06,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x2c, 0x5a, 0x2a, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x67, 0x6f, 0x2d, 0x73,
	0x65, 0x76, 0x2d, 0x67, 0x75, 0x65, 0x73, 0x74, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x63,
	0x68, 0x65, 0x63, 0x6b, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_check_proto_rawDescOnce sync.Once
	file_check_proto_rawDescData = file_check_proto_rawDesc
)

func file_check_proto_rawDescGZIP() []byte {
	file_check_proto_rawDescOnce.Do(func() {
		file_check_proto_rawDescData = protoimpl.X.CompressGZIP(file_check_proto_rawDescData)
	})
	return file_check_proto_rawDescData
}

var file_check_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_check_proto_goTypes = []interface{}{
	(*Policy)(nil),                 // 0: check.Policy
	(*RootOfTrust)(nil),            // 1: check.RootOfTrust
	(*Config)(nil),                 // 2: check.Config
	(*wrapperspb.UInt32Value)(nil), // 3: google.protobuf.UInt32Value
	(*wrapperspb.UInt64Value)(nil), // 4: google.protobuf.UInt64Value
	(*sevsnp.SevProduct)(nil),      // 5: sevsnp.SevProduct
}
var file_check_proto_depIdxs = []int32{
	3, // 0: check.Policy.vmpl:type_name -> google.protobuf.UInt32Value
	4, // 1: check.Policy.platform_info:type_name -> google.protobuf.UInt64Value
	5, // 2: check.Policy.product:type_name -> sevsnp.SevProduct
	1, // 3: check.Config.root_of_trust:type_name -> check.RootOfTrust
	0, // 4: check.Config.policy:type_name -> check.Policy
	5, // [5:5] is the sub-list for method output_type
	5, // [5:5] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_check_proto_init() }
func file_check_proto_init() {
	if File_check_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_check_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Policy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_check_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RootOfTrust); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_check_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Config); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_check_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_check_proto_goTypes,
		DependencyIndexes: file_check_proto_depIdxs,
		MessageInfos:      file_check_proto_msgTypes,
	}.Build()
	File_check_proto = out.File
	file_check_proto_rawDesc = nil
	file_check_proto_goTypes = nil
	file_check_proto_depIdxs = nil
}
