/*
 * Decompiled with CFR 0.152.
 */
package com.dsi.ant.plugins.antplus.pcc.controls.defines;

import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AudioVideoCommandNumber {
    PLAY(1, true, true, false),
    PAUSE(2, true, true, true),
    STOP(3, true, true, true),
    VOLUME_UP(4, true, true, true),
    VOLUME_DOWN(5, true, true, true),
    MUTE_UNMUTE(6, true, true, true),
    AHEAD(7, true, true, false),
    BACK(8, true, true, false),
    REPEAT_CURRENT_TRACK(9, true, false, false),
    REPEAT_ALL(10, true, false, false),
    REPEAT_OFF(11, true, false, false),
    SHUFFLE_TRACKS(12, true, false, false),
    SHUFFLE_ALBUMS(13, true, false, false),
    SHUFFLE_OFF(14, true, false, false),
    FAST_FORWARD(15, true, true, false),
    FAST_REWIND(16, true, true, false),
    CUSTOM_REPEAT(17, true, false, false),
    CUSTOM_SHUFFLE(18, true, false, false),
    RECORD(19, false, false, true),
    UNRECOGNIZED(-1, false, false, false);

    private int intValue;
    private boolean audioCommand;
    private boolean videoPlaybackCommand;
    private boolean videoRecorderCommand;

    private AudioVideoCommandNumber(int intValue, boolean audioCommand, boolean videoPlaybackCommand, boolean videoRecorderCommand) {
        this.intValue = intValue;
        this.audioCommand = audioCommand;
        this.videoPlaybackCommand = videoPlaybackCommand;
        this.videoRecorderCommand = videoRecorderCommand;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public boolean isAudioCommand() {
        return this.audioCommand;
    }

    public boolean isVideoPlaybackCommand() {
        return this.videoPlaybackCommand;
    }

    public boolean isVideoRecorderCommand() {
        return this.videoRecorderCommand;
    }

    public static AudioVideoCommandNumber getValueFromInt(int intValue) {
        for (AudioVideoCommandNumber cmd : AudioVideoCommandNumber.values()) {
            if (cmd.getIntValue() != intValue) continue;
            return cmd;
        }
        AudioVideoCommandNumber unrecognized = UNRECOGNIZED;
        return unrecognized;
    }

    public static ArrayList<AudioVideoCommandNumber> getAudioCommands() {
        ArrayList<AudioVideoCommandNumber> audioCommands = new ArrayList<AudioVideoCommandNumber>();
        AudioVideoCommandNumber[] allCommands = AudioVideoCommandNumber.values();
        for (int i = 0; i < allCommands.length; ++i) {
            if (!allCommands[i].isAudioCommand()) continue;
            audioCommands.add(allCommands[i]);
        }
        return audioCommands;
    }

    public static ArrayList<AudioVideoCommandNumber> getVideoPlaybackCommands() {
        ArrayList<AudioVideoCommandNumber> videoPlaybackCommands = new ArrayList<AudioVideoCommandNumber>();
        AudioVideoCommandNumber[] allCommands = AudioVideoCommandNumber.values();
        for (int i = 0; i < allCommands.length; ++i) {
            if (!allCommands[i].isVideoPlaybackCommand()) continue;
            videoPlaybackCommands.add(allCommands[i]);
        }
        return videoPlaybackCommands;
    }

    public static ArrayList<AudioVideoCommandNumber> getVideoRecorderCommands() {
        ArrayList<AudioVideoCommandNumber> videoRecorderCommands = new ArrayList<AudioVideoCommandNumber>();
        AudioVideoCommandNumber[] allCommands = AudioVideoCommandNumber.values();
        for (int i = 0; i < allCommands.length; ++i) {
            if (!allCommands[i].isVideoRecorderCommand()) continue;
            videoRecorderCommands.add(allCommands[i]);
        }
        return videoRecorderCommands;
    }
}

