/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.internal.html.docbook.editor;

import org.dbdoclet.service.StringServices;
import org.dbdoclet.tag.docbook.Anchor;
import org.dbdoclet.tag.docbook.DocBookElement;
import org.dbdoclet.tag.docbook.DocBookTagFactory;
import org.dbdoclet.tag.docbook.Link;
import org.dbdoclet.tag.docbook.Para;
import org.dbdoclet.tag.docbook.Simpara;
import org.dbdoclet.tag.docbook.ULink;
import org.dbdoclet.tag.docbook.Xref;
import org.dbdoclet.tag.html.A;
import org.dbdoclet.trafo.TrafoConstants;
import org.dbdoclet.trafo.html.EditorException;
import org.dbdoclet.trafo.html.EditorInstruction;
import org.dbdoclet.xiphias.dom.NodeImpl;

public class AEditor extends DocBookEditor {

	@Override
	public EditorInstruction edit(EditorInstruction values)
			throws EditorException {

		setValues(super.edit(values));
		DocBookTagFactory dbfactory = getTagFactory();

		NodeImpl ancestor;
		NodeImpl parent = getParent();

		traverse(true);

		ancestor = parent;

		if (parent instanceof DocBookElement) {
			
			DocBookElement dbParent = (DocBookElement) parent;
			
			if (dbParent.isSection()) {
				Para para = dbfactory.createPara();
				parent.appendChild(para);
				ancestor = para;
			}
		}
		
		A htmlA = (A) getHtmlElement();

		String name = htmlA.getName();
		String href = htmlA.getHref();

		if (name != null && name.length() > 0) {

			Anchor anchor = dbfactory.createAnchor();
			anchor.setId(getLinkManager().createUniqueId(name));

			boolean createXrefLabel = script.isParameterOn(
					TrafoConstants.SECTION_DOCBOOK,
					TrafoConstants.PARAM_CREATE_XREF_LABEL, true);

			if (createXrefLabel == true) {
				anchor.setXrefLabel(StringServices.replace(
						htmlA.getTextContent(), "\"", "&quot;"));
			}

			ancestor.appendChild(anchor);

		} else if (href != null && href.equals("#") == false
				&& href.startsWith("#")) {

			String label = htmlA.getTextContent();

			if ((label != null) && (label.length() > 0)) {

				Link link = dbfactory.createLink(getLinkManager().getUniqueId(
						href));
				link.setParentNode(ancestor);
				ancestor.appendChild(link);
				setCurrent(link);

			} else {

				Xref xref = dbfactory.createXref(getLinkManager().getUniqueId(
						href));

				xref.setParentNode(ancestor);
				ancestor.appendChild(xref);
				setCurrent(ancestor);
			}

		} else {

			DocBookElement linkElement;

			if (isDocBook5()) {

				Link link = dbfactory.createLink();
				link.setParentNode(ancestor);

				if (href != null) {
					link.setHref(href);
				} else {
					link.setHref("");
				}

				linkElement = link;

			} else {

				ULink ulink = dbfactory.createULink();
				ulink.setParentNode(ancestor);
				ulink.setUrl(href);// public Script getScript() {
				// return script;
				// }

				linkElement = ulink;
			}

			if (linkElement.isValidParent(script.getTransformPosition(), ancestor)) {

				setCurrent(linkElement);
				ancestor.appendChild(getCurrent());
				getLinkManager().addLink(linkElement);

			} else {

				Simpara candidate = dbfactory.createSimpara();
				candidate.setParentNode(ancestor);

				if (candidate.isValidParent(script.getTransformPosition(), ancestor)) {

					ancestor.appendChild(candidate);
					candidate.appendChild(ancestor);
				}
			}
		}

		return finalizeValues();
	}
}
