#=========================================================================
# Copyright (C) 2019 Intel Corporation
#
# Licensed under the Apache License,  Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# 	http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law  or agreed  to  in  writing,  software
# distributed under  the License  is  distributed  on  an  "AS IS"  BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the  specific  language  governing  permissions  and
# limitations under the License.
#=========================================================================

set(IPPCP_LIB64_REL_PATH  "lib")
set(IPPCP_LIB32_REL_PATH  "lib32")
set(IPPCP_BIN64_REL_PATH  "bin")
set(IPPCP_BIN32_REL_PATH  "bin32")
set(IPPCP_INC_REL_PATH    "include")

configure_file("${IPP_CRYPTO_DIR}/sources/cmake/ippcp-config.cmake.in" "${CMAKE_BINARY_DIR}/ippcp-config.cmake" @ONLY)
configure_file("${IPP_CRYPTO_DIR}/sources/cmake/ippcp-config-version.cmake.in" "${CMAKE_BINARY_DIR}/ippcp-config-version.cmake" @ONLY)

# Produce pkg-config files
include("${IPP_CRYPTO_DIR}/sources/cmake/ippcp-gen-pkg-config.cmake")

install(FILES
    "${CMAKE_BINARY_DIR}/ippcp-config.cmake"
    "${CMAKE_BINARY_DIR}/ippcp-config-version.cmake"
    DESTINATION "lib/cmake/ippcp")

# FIXME: temporary until infra migrates to a build structure generated by 'make install'
foreach( OUTPUTCONFIG ${CMAKE_CONFIGURATION_TYPES})
   string( TOUPPER ${OUTPUTCONFIG} OUTPUTCONFIG )
   file(COPY "${CMAKE_BINARY_DIR}/ippcp-config.cmake"
             "${CMAKE_BINARY_DIR}/ippcp-config-version.cmake"
        DESTINATION "${CMAKE_OUTPUT_DIR}/${OUTPUTCONFIG}/cmake")
endforeach( OUTPUTCONFIG CMAKE_CONFIGURATION_TYPES )
