Contributing to isort
========

Looking for a useful open source project to contribute to?
Want your contributions to be warmly welcomed and acknowledged?
Welcome! You have found the right place.

## Getting isort set up for local development
The first step when contributing to any project is getting it set up on your local machine. isort aims to make this as simple as possible.

Account Requirements:

- [A valid GitHub account](https://github.com/join)

Base System Requirements:

- Python3.10+
- uv
- bash or a bash compatible shell (should be auto-installed on Linux / Mac)
  - WSL users running Ubuntu may need to install Python's venv module even after installing Python.

Once you have verified that your system matches the base requirements you can start to get the project working by following these steps:

1. [Fork the project on GitHub](https://github.com/pycqa/isort/fork).
2. Clone your fork to your local file system:
    `git clone https://github.com/$GITHUB_ACCOUNT/isort.git`
3. `cd isort`
4. `uv sync --all-extras --frozen`
   * Optionally, isolate uv's installation from the rest of your system using the instructions on the uv site here: https://docs.astral.sh/uv/ 
5. `./scripts/test.sh` should yield Success: no issues found
6. `./scripts/clean.sh` should yield a report checking packages

**TIP**: `./scripts/done.sh` will run both clean and test in one step.

### Docker development

If you would instead like to develop using Docker, the only local requirement is docker.
See the [docker docs](https://docs.docker.com/get-started/) if you have not used docker before.

Once you have the docker daemon running and have cloned the repository, you can get started by following these steps:

1. `cd isort`
2. `./scripts/docker.sh`

A local test cycle might look like the following:

1. `docker build ./ -t isort:latest`
2. `docker run isort`
3. if #2 fails, debug, save, and goto #1
    * `docker run -it isort bash` will get you into the failed environment
    * `docker run -v $(git rev-parse --show-toplevel):/isort` will make changes made in the docker environment persist on your local checkout.
      **TIP**: combine both to get an interactive docker shell that loads changes made locally, even after build, to quickly rerun that pesky failing test
4. `./scripts/docker.sh`
5. if #4 fails, debug, save and goto #1; you may need to specify a different `--build-arg VERSION=$VER`
6. congrats! you are probably ready to push a contribution

## Making a contribution
Congrats! You're now ready to make a contribution! Use the following as a guide to help you reach a successful pull-request:

1. Check the [issues page](https://github.com/pycqa/isort/issues) on GitHub to see if the task you want to complete is listed there.
    - If it's listed there, write a comment letting others know you are working on it.
    - If it's not listed in GitHub issues, go ahead and log a new issue. Then add a comment letting everyone know you have it under control.
        - If you're not sure if it's something that is good for the main isort project and want immediate feedback, you can discuss it [here](https://github.com/PyCQA/isort/discussions).
2. Create an issue branch for your local work `git checkout -b issue/$ISSUE-NUMBER`.
3. Do your magic here.
4. Ensure your code matches the [HOPE-8 Coding Standard](https://github.com/hugapi/HOPE/blob/master/all/HOPE-8--Style-Guide-for-Hug-Code.md#hope-8----style-guide-for-hug-code) used by the project.
5. Run tests locally to make sure everything is still working
	`./scripts/done.sh`
	_Or if you are using Docker_
	`docker run isort:latest`
6. Submit a pull request to the main project repository via GitHub.

Thanks for the contribution! It will quickly get reviewed, and, once accepted, will result in your name being added to the acknowledgments list :).

## Thank you!
I can not tell you how thankful I am for the hard work done by isort contributors like *you*.

Thank you!

~Timothy Crosley

