/* ----- core/scale3sntrup653, derived from supercop/crypto_core/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *core_scale3sntrup653_checksums[] = {
  "faf8c33dcacc9a98f6e4e751c1b406ebd2e9251ccac159d66847cfdcc45d0c53",
  "6cb27323e7a868ff2eee421976f5b8fb9795c4b297f63fba3eee86bf559b98c2",
} ;

static void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
#define crypto_core_OUTPUTBYTES ntruprime_core_scale3sntrup653_OUTPUTBYTES
#define crypto_core_INPUTBYTES ntruprime_core_scale3sntrup653_INPUTBYTES
#define crypto_core_KEYBYTES ntruprime_core_scale3sntrup653_KEYBYTES
#define crypto_core_CONSTBYTES ntruprime_core_scale3sntrup653_CONSTBYTES

static void *storage_core_scale3sntrup653_h;
static unsigned char *test_core_scale3sntrup653_h;
static void *storage_core_scale3sntrup653_n;
static unsigned char *test_core_scale3sntrup653_n;
static void *storage_core_scale3sntrup653_k;
static unsigned char *test_core_scale3sntrup653_k;
static void *storage_core_scale3sntrup653_c;
static unsigned char *test_core_scale3sntrup653_c;
static void *storage_core_scale3sntrup653_h2;
static unsigned char *test_core_scale3sntrup653_h2;
static void *storage_core_scale3sntrup653_n2;
static unsigned char *test_core_scale3sntrup653_n2;
static void *storage_core_scale3sntrup653_k2;
static unsigned char *test_core_scale3sntrup653_k2;
static void *storage_core_scale3sntrup653_c2;
static unsigned char *test_core_scale3sntrup653_c2;

#define precomputed_core_scale3sntrup653_NUM 4

static const unsigned char precomputed_core_scale3sntrup653_h[precomputed_core_scale3sntrup653_NUM][crypto_core_OUTPUTBYTES] = {
  {153,202,3,210,94,109,162,37,252,208,167,159,205,210,149,216,127,247,34,201,13,64,251,5,41,68,96,227,150,72,41,92,94,208,115,111,138,3,127,101,89,69,59,116,68,111,74,37,70,110,16,49,211,1,27,70,114,229,9,58,4,7,71,1,151,118,175,93,53,3,221,3,215,203,83,111,24,251,40,252,20,191,20,2,233,71,240,109,239,6,64,228,159,234,232,31,180,203,106,105,68,28,6,0,13,108,164,11,185,163,115,47,218,107,186,112,17,210,251,99,139,228,36,242,254,251,141,2,166,225,195,241,11,22,247,36,124,253,15,215,90,79,43,173,83,253,175,177,165,203,126,202,220,4,22,254,89,55,50,254,3,231,137,224,65,188,222,240,210,82,254,8,226,210,152,232,96,55,54,49,57,209,216,0,106,227,4,90,20,171,141,66,71,212,251,8,35,239,173,187,53,9,252,23,16,223,165,45,232,64,109,48,239,3,135,101,18,240,21,199,85,163,1,57,52,102,185,180,190,255,229,88,194,249,9,90,104,101,121,57,150,212,123,21,100,197,196,214,229,28,209,87,240,180,176,62,100,37,24,103,99,45,91,93,120,178,56,5,45,110,106,209,117,220,138,246,187,157,29,90,48,161,243,163,107,238,185,230,132,172,179,237,29,15,99,4,89,77,250,224,113,246,99,239,18,161,113,14,205,21,57,65,166,33,61,179,190,61,247,80,217,203,105,254,107,85,210,11,194,14,216,237,119,104,35,197,165,254,195,21,210,68,80,43,213,76,177,93,65,73,239,36,57,117,131,182,218,192,151,253,178,218,207,162,158,73,142,56,99,217,208,228,44,42,65,8,149,236,203,254,214,248,188,46,214,165,69,245,67,225,108,41,109,85,55,232,95,187,14,71,181,246,7,41,41,167,121,82,195,251,161,94,192,212,165,193,246,214,211,12,164,225,137,238,133,70,117,193,120,240,95,220,162,233,68,25,81,14,94,34,69,98,216,231,188,28,57,92,115,99,80,73,244,228,89,72,190,5,196,30,207,182,68,28,238,179,152,42,72,1,84,173,173,102,177,111,232,164,23,249,171,229,80,7,217,64,218,39,145,56,117,32,163,244,15,24,191,111,88,8,177,45,25,169,215,4,248,116,151,101,154,96,27,82,6,37,230,95,100,251,156,109,109,248,1,76,40,84,5,227,206,191,41,211,81,247,94,241,7,206,169,179,98,213,140,160,127,48,83,91,139,8,102,42,83,72,219,255,135,186,93,226,244,68,192,230,249,108,116,253,23,66,244,250,181,6,22,69,70,43,171,169,73,2,91,204,212,102,165,217,65,217,232,43,33,108,62,196,80,105,85,235,24,73,65,69,234,253,240,226,248,54,147,5,164,115,123,236,134,156,192,56,187,254,189,222,112,0,187,46,204,7,53,48,240,4,12,3,147,189,65,171,54,232,211,111,230,188,221,77,53,31,30,101,14,108,120,101,191,78,170,249,87,32,238,57,31,118,69,255,46,202,88,195,55,35,194,157,51,30,254,231,238,183,246,86,134,0,159,177,185,254,223,254,88,4,49,234,153,3,102,220,114,63,146,209,102,197,164,242,66,229,21,98,118,219,107,237,139,251,131,248,136,204,64,237,2,157,100,155,91,108,145,90,6,203,159,11,225,74,70,108,60,86,217,246,191,111,187,69,30,252,13,177,215,4,194,42,131,4,136,178,79,162,194,249,226,169,75,225,9,250,255,250,108,172,65,0,218,214,138,246,184,155,137,88,200,242,18,69,124,229,86,186,76,178,15,91,38,71,61,63,44,7,201,157,91,63,195,241,38,192,102,247,183,107,64,214,47,197,178,169,143,255,19,167,37,209,15,1,57,94,136,78,207,68,29,27,244,28,248,157,59,171,249,101,12,7,82,255,240,117,174,100,47,87,88,70,200,6,92,84,85,171,82,28,241,188,189,186,186,68,37,2,252,33,116,48,143,78,201,15,94,246,57,16,247,224,6,225,18,18,51,41,191,186,250,4,126,222,186,30,47,255,33,103,253,84,51,199,145,199,218,211,67,11,19,231,135,210,82,167,211,78,174,0,155,49,163,95,219,3,213,201,65,97,23,225,30,237,212,15,249,47,138,36,21,248,12,5,40,5,132,7,108,1,50,1,142,254,74,68,146,0,208,100,89,93,101,110,57,47,108,52,133,157,72,82,213,7,128,7,198,2,156,231,174,204,107,232,116,82,146,231,179,37,226,83,52,241,85,206,107,251,23,61,241,250,114,74,41,56,100,194,139,157,103,242,104,221,88,105,28,233,22,6,249,225,79,60,156,80,134,32,55,109,118,174,11,53,8,28,68,190,136,17,200,218,135,156,85,82,116,100,147,69,205,198,171,78,28,175,170,0,114,6,17,2,236,34,216,158,0,250,39,233,85,195,7,103,25,63,128,177,8,191,166,184,153,14,246,186,2,212,203,33,229,204,42,101,38,206,13,5,223,81,152,250,73,15,211,211,200,107,86,221,159,8,149,78,71,64,74,50,182,249,240,218,57,225,71,173,162,38,123,159,82,205,241,36,159,247,7,252,51,247,61,196,223,188,9,105,85,241,220,108,229,250,215,69,103,12,126,171,35,191,62,172,110,217,163,84,7,228,185,185,116,35,231,62,26,57,199,189,120,159,74,7,120,243,73,167,177,68,217,84,92,15,232,230,168,69,221,29,224,247,140,44,97,180,72,101,230,164,115,37,215,176,41,254,144,239,216,178,9,251,219,71,253,108,110,32,227,72,86,172,241,63,33,27,177,34,208,253,79,157,16,33,142,55,182,63,114,250,120,57,50,6,230,92,255,53,118,66,99,88,225,229,47,22,222,1,129,100,123,247,243,155,67,248,181,247,184,169,238,205,136,199,172,28,248,3,17,248,163,159,107,3,105,209,143,76,177,243,116,240},
  {91,78,161,72,30,217,69,3,94,240,191,169,252,15,75,161,81,8,70,7,96,160,246,252,63,84,254,204,5,169,196,171,209,23,7,244,8,0,64,205,165,250,79,63,197,90,96,8,4,86,81,58,164,155,133,46,188,2,23,15,82,228,133,253,206,183,26,79,203,211,238,245,136,75,209,53,51,39,243,29,225,59,61,219,105,44,127,251,128,102,71,223,253,30,145,4,77,252,240,66,83,37,192,10,180,250,245,159,154,116,5,178,217,66,224,211,157,52,11,239,205,210,230,35,244,32,232,92,207,105,30,219,185,113,221,101,75,165,168,74,67,3,132,115,194,249,106,37,154,101,151,98,108,252,233,18,186,43,44,109,49,167,142,195,149,163,170,7,19,1,86,62,76,166,89,184,200,76,89,162,45,7,22,77,230,62,154,188,239,217,209,225,180,191,201,164,192,41,149,62,9,243,95,74,174,156,113,254,116,172,23,246,86,4,41,114,94,167,1,60,164,77,96,36,134,107,38,61,28,222,68,238,183,184,165,28,174,209,162,254,128,209,221,211,180,0,102,6,45,199,67,33,195,194,54,249,140,61,102,254,111,182,79,237,153,67,84,33,219,64,136,196,245,212,27,80,180,209,236,209,208,30,125,209,182,114,221,196,160,189,200,68,118,65,158,22,179,85,38,98,236,232,149,7,117,8,197,174,174,229,238,77,217,92,140,90,145,60,242,4,70,188,103,253,29,0,32,229,196,165,190,0,29,243,78,9,240,105,54,39,42,213,191,254,234,4,112,192,253,87,59,185,198,172,47,81,190,203,88,51,232,227,181,3,208,245,34,252,225,175,86,3,183,180,179,203,135,6,215,1,112,231,92,247,66,10,3,248,34,253,66,193,58,6,98,66,139,182,7,16,60,3,33,247,33,254,86,156,251,181,184,42,252,250,6,40,200,15,103,158,86,7,66,5,207,198,138,39,111,64,181,254,103,159,124,252,110,224,39,181,91,168,103,223,211,168,46,31,242,252,208,180,238,217,191,168,199,250,189,74,180,227,164,48,127,18,76,104,251,82,241,248,105,37,164,12,198,117,167,8,101,71,204,92,88,14,190,55,255,32,209,13,74,229,205,84,133,216,215,109,174,8,22,232,84,53,142,64,74,64,2,108,195,99,119,163,154,255,137,0,137,52,87,106,215,208,89,250,180,89,63,23,57,214,160,117,155,182,126,29,117,83,174,91,193,191,255,72,154,8,75,184,36,38,79,235,246,219,66,237,39,114,106,240,16,9,81,255,135,6,206,63,121,233,237,179,142,195,113,251,56,40,55,43,43,64,212,34,119,93,85,18,88,53,224,227,180,2,222,4,131,62,43,18,55,3,198,201,160,91,29,158,45,247,192,103,241,194,200,176,5,206,22,220,155,8,209,22,191,46,248,7,29,21,178,26,145,250,111,202,185,73,30,2,29,214,34,254,31,229,178,28,41,33,73,115,83,88,162,201,180,250,218,51,225,193,17,52,157,209,56,82,196,162,235,110,199,210,159,31,166,15,35,253,93,188,48,204,215,203,111,233,146,250,36,12,185,49,196,171,120,249,2,203,34,240,30,4,79,80,95,253,217,57,191,93,152,22,202,29,111,58,123,176,255,178,16,233,242,204,44,3,69,188,160,2,70,228,131,115,70,8,141,8,204,51,187,101,103,158,10,15,58,248,242,247,251,240,143,21,170,113,221,238,38,41,99,86,144,237,30,209,24,83,121,88,128,4,30,73,222,114,182,48,27,209,151,84,108,248,94,29,188,92,160,203,89,61,78,65,65,244,206,101,9,245,44,110,199,252,249,182,226,79,226,247,141,94,224,180,185,48,111,166,228,185,189,13,223,70,70,209,62,249,120,230,59,223,196,194,138,18,29,223,55,87,221,41,66,1,27,177,128,247,74,41,48,105,205,247,185,22,140,66,21,21,124,3,145,207,75,222,34,253,176,25,161,0,219,199,253,83,114,252,142,101,12,202,228,6,241,68,11,88,113,171,186,214,83,232,255,210,221,36,158,162,122,169,212,160,219,254,2,249,34,80,140,97,245,111,166,187,135,0,189,173,104,114,132,100,236,197,113,233,202,84,200,218,196,226,248,204,116,2,103,252,195,247,79,191,200,3,52,5,98,8,60,253,158,233,123,185,190,218,151,223,11,115,127,54,107,45,214,254,137,197,171,62,236,68,174,242,189,178,90,190,81,169,95,177,53,177,199,238,184,191,93,194,191,159,146,99,199,88,249,171,202,23,110,57,132,207,10,253,13,2,31,253,77,251,161,0,85,70,136,248,103,78,126,226,103,77,80,95,102,66,246,211,72,17,200,46,76,251,200,191,2,88,184,94,9,199,167,6,120,250,116,2,254,3,228,255,43,68,56,46,90,77,41,97,145,241,252,194,175,4,220,193,240,53,218,93,175,23,162,247,52,22,123,219,30,245,64,239,207,109,167,242,194,242,140,226,221,44,247,156,87,253,155,14,41,156,244,238,1,66,31,112,11,67,250,115,50,38,12,87,172,189,118,206,213,220,47,210,154,156,50,78,165,253,103,248,213,96,179,113,204,206,163,97,222,7,178,204,207,177,250,27,37,34,112,166,138,36,165,62,36,198,165,67,249,157,195,105,102,64,96,236,164,164,160,240,253,196,10,42,227,16,43,187,246,50,195,9,132,157,46,220,251,250,136,46,58,76,197,247,154,225,186,243,247,245,117,202,225,8,28,247,200,82,42,247,177,250,14,4,73,196,223,35,238,67,80,15,249,5,151,255,78,70,36,169,104,14,180,182,184,229,81,185,9,254,105,236,18,108,12,36,82,214,136,247,47,78,108,36,100,174,15,160,230,228,4,253,52,211,7,92,35,210,223,176,239,252,95,35,213,23,241,0,155,99,206,202,240,207,63,221,197,255,165,253,204,4,58,1},
  {54,219,215,21,171,187,182,97,27,2,152,8,86,198,219,108,37,58,71,61,236,21,24,177,227,187,254,234,232,7,180,8,77,244,241,38,157,197,82,106,127,200,216,84,207,74,29,235,216,194,178,8,204,21,118,6,149,96,147,94,206,1,202,184,92,76,23,3,202,250,45,14,220,22,183,17,87,247,160,63,214,53,135,82,87,220,172,37,235,1,251,64,150,4,179,187,56,182,65,87,247,33,241,105,189,6,170,101,191,74,224,230,54,65,88,56,242,73,245,88,123,222,67,12,128,61,111,26,162,199,81,101,219,56,224,247,164,172,5,209,132,221,24,79,96,4,227,68,169,62,235,71,23,10,13,17,111,57,130,188,181,12,63,7,55,116,183,219,0,115,59,61,0,249,37,247,116,218,157,212,240,2,115,250,250,13,237,51,229,95,167,8,196,8,200,173,93,73,176,61,203,93,191,62,66,194,81,32,68,187,86,22,138,68,64,103,188,158,3,118,159,250,6,68,100,28,71,28,26,249,133,186,169,171,21,224,177,224,197,176,251,239,208,108,10,225,81,255,94,38,87,221,226,47,216,255,188,170,222,36,219,9,36,11,47,206,47,9,112,49,157,231,64,81,130,50,253,35,142,251,185,172,34,245,46,201,60,74,251,2,99,182,236,96,202,108,78,40,191,5,107,171,83,201,151,65,21,62,39,8,43,31,80,27,4,209,74,204,104,210,242,184,111,13,115,5,133,84,38,155,114,206,58,106,222,110,146,254,212,74,134,28,228,8,208,176,18,24,189,251,180,22,235,202,169,232,173,43,23,36,22,92,6,105,67,166,117,92,148,183,224,208,195,242,220,191,249,9,109,54,237,253,47,14,197,255,227,93,235,54,122,253,104,183,7,27,204,255,153,68,171,86,229,26,179,3,247,41,164,45,46,84,178,94,154,5,92,242,153,237,176,215,77,95,95,73,215,64,209,71,23,186,51,216,85,48,193,46,205,253,152,186,185,52,180,173,15,50,222,156,203,48,208,185,41,30,109,15,43,24,137,0,18,38,34,27,200,26,202,190,95,232,157,31,78,249,85,209,140,2,228,90,49,247,10,248,19,54,20,254,188,253,162,157,167,99,197,10,156,253,167,157,173,0,45,250,119,25,137,234,195,215,36,87,147,25,251,241,187,180,31,250,92,1,104,160,2,31,125,181,254,156,38,207,169,61,143,4,4,109,56,180,83,0,153,101,139,163,180,204,20,222,2,1,61,4,103,117,99,240,138,235,184,2,194,214,162,40,225,52,116,8,92,83,22,0,114,70,112,255,218,102,163,57,83,64,203,86,155,10,197,2,22,7,190,94,88,227,42,82,252,231,2,254,99,97,184,63,47,8,147,5,53,49,161,104,31,171,2,252,109,241,106,157,123,249,110,249,186,187,89,234,227,167,210,215,112,89,74,196,242,198,127,104,35,4,202,13,30,61,139,191,196,69,98,83,33,218,155,202,92,177,157,8,63,110,216,66,87,198,64,242,124,158,63,252,141,43,143,116,50,171,107,43,93,3,186,184,27,247,231,5,12,7,109,2,52,220,106,186,200,239,85,255,236,7,185,215,221,219,38,66,106,6,113,29,233,220,12,79,226,2,0,7,75,45,16,27,161,73,242,97,153,191,7,115,71,193,22,251,30,26,168,218,212,60,217,2,33,57,73,255,165,182,201,200,23,85,186,236,68,81,204,240,123,91,94,240,246,217,34,229,8,107,210,111,120,12,162,0,215,250,68,13,179,229,171,69,42,163,153,186,182,18,171,184,170,72,197,196,207,193,83,63,205,11,80,58,53,168,92,96,8,174,175,249,21,4,68,114,157,40,136,0,213,229,87,102,128,171,101,10,129,181,189,160,96,199,177,253,82,63,187,86,158,229,146,254,14,1,218,2,111,75,53,8,129,103,221,29,212,0,48,202,143,188,230,96,36,80,58,250,119,97,252,106,166,167,36,168,225,180,37,4,10,212,213,1,77,251,67,239,183,7,13,90,84,188,255,246,68,239,193,20,63,246,95,8,109,75,112,240,15,224,180,114,237,6,83,117,9,5,150,206,245,108,86,40,150,1,205,251,91,228,224,228,0,195,9,105,196,175,78,2,229,254,36,21,146,2,94,19,26,165,127,195,186,36,225,182,199,31,169,209,20,181,102,97,209,176,84,155,252,100,162,239,233,173,255,4,124,5,91,105,187,195,207,194,77,4,220,250,222,7,76,38,186,170,104,37,68,102,234,253,185,173,14,43,76,175,65,254,223,62,218,234,59,96,119,118,95,199,85,0,111,183,141,73,83,40,171,22,104,230,107,249,254,111,126,214,236,255,165,40,27,4,159,55,154,81,59,231,222,25,150,54,168,252,123,201,114,49,183,20,219,199,174,253,235,19,178,88,144,21,28,254,15,165,212,100,190,3,228,65,234,184,102,250,249,86,213,52,7,57,8,190,229,51,56,56,214,20,232,41,195,253,237,245,201,104,137,22,150,254,215,202,156,30,224,12,202,247,251,255,29,20,91,255,225,248,87,8,209,18,226,206,189,172,253,211,18,49,240,41,226,81,6,33,15,52,212,70,58,62,9,227,79,108,204,177,12,8,207,1,143,235,141,1,79,41,222,118,162,252,69,156,41,36,78,198,174,211,172,11,127,5,214,104,106,80,222,195,110,100,234,212,19,12,7,174,76,82,49,84,128,8,230,234,142,221,135,182,182,228,27,18,85,158,47,18,158,250,2,69,95,255,29,205,8,44,14,87,142,69,97,222,116,13,22,248,27,88,66,229,232,4,204,101,102,68,139,248,141,185,90,14,157,53,121,176,203,213,44,214,169,242,57,240,23,253,135,0,233,49,0,24,181,205,114,2,72,254,5,33,159,2,54,16,99,235,192,166,45,33,100,105,0,251,2,19,192,216,255,4,171,30},
  {107,106,85,254,78,0,226,201,199,203,0,27,204,103,114,167,208,65,37,5,198,4,41,0,6,29,103,89,111,236,204,209,229,225,223,45,110,213,252,239,49,79,196,42,134,11,239,159,90,245,94,12,244,230,214,205,70,248,201,72,23,161,75,245,235,204,164,111,134,186,126,28,247,173,194,202,244,216,9,118,14,30,28,6,244,42,239,218,66,56,59,23,201,252,25,178,204,0,144,247,160,64,3,228,232,62,91,185,166,155,27,27,44,199,29,157,50,60,42,50,255,233,69,45,196,246,54,196,197,230,151,212,225,254,193,5,69,190,136,102,149,73,90,194,21,81,18,219,59,109,80,177,202,18,46,200,34,5,46,244,119,218,242,2,206,79,30,251,18,187,57,111,250,168,179,7,165,243,245,191,223,190,90,183,162,170,19,248,130,8,116,255,80,190,182,16,190,1,46,251,239,205,203,3,42,214,43,2,214,56,110,55,139,14,16,210,148,208,92,245,33,200,254,41,199,43,92,181,116,254,56,202,234,88,53,1,173,176,84,73,139,41,98,249,113,166,19,236,169,4,132,214,40,44,150,199,58,198,137,185,175,66,140,175,124,178,98,180,108,80,113,219,188,23,190,23,217,35,217,21,162,32,141,6,229,8,250,174,222,240,86,175,215,247,73,165,249,85,237,235,222,3,110,5,147,236,5,253,210,56,235,248,6,29,52,55,128,249,65,196,173,17,33,56,215,252,106,254,232,1,76,2,18,206,243,254,95,249,184,4,134,230,115,63,5,59,183,224,203,34,207,71,108,204,64,39,33,249,220,101,80,108,213,61,118,100,201,255,221,93,36,250,168,197,184,57,49,72,1,1,215,247,182,89,254,40,91,21,250,168,114,47,183,250,176,105,180,202,218,75,129,34,160,19,238,255,161,99,193,231,104,21,177,16,110,190,46,161,180,12,135,240,174,225,99,254,198,118,150,62,243,8,150,244,250,197,83,238,233,218,18,247,202,187,210,3,39,248,26,45,227,8,155,249,225,169,249,92,215,117,231,77,241,87,205,49,229,72,97,1,192,11,44,220,129,194,11,5,79,186,16,90,166,37,144,156,210,202,137,114,6,91,197,199,218,181,109,245,39,165,88,177,247,229,119,254,155,13,166,213,111,242,235,11,66,192,199,109,31,173,32,80,103,192,67,19,38,166,144,2,81,34,139,189,186,29,168,37,158,184,181,179,177,1,171,237,232,2,83,229,40,87,107,249,160,228,209,239,98,29,108,116,126,0,5,7,152,86,76,72,18,99,127,220,178,0,128,86,182,67,72,74,181,83,29,250,99,206,203,223,118,4,177,70,98,240,41,244,105,167,16,86,222,3,163,171,189,39,230,165,61,98,88,190,231,234,197,53,152,93,13,7,240,187,60,27,151,164,75,33,141,13,184,158,224,52,155,211,181,180,204,194,65,51,2,6,126,87,83,23,27,179,148,98,205,60,239,164,231,218,98,239,228,160,13,2,100,164,1,170,133,117,25,49,15,64,109,162,158,248,207,84,9,229,249,217,143,108,126,74,212,7,31,11,123,180,209,189,99,26,195,20,82,0,118,179,151,76,71,7,193,163,95,246,222,73,51,255,90,169,185,1,35,8,149,61,254,8,146,252,45,213,55,105,43,167,251,57,204,34,16,113,37,61,70,162,199,240,60,201,141,184,190,176,140,251,18,11,235,48,241,160,198,32,169,118,218,55,113,95,188,178,64,81,41,92,201,253,117,61,85,43,48,68,70,168,246,105,143,197,9,86,227,10,13,52,252,40,206,203,223,94,47,100,125,158,195,180,64,158,184,101,142,4,33,244,77,37,231,246,17,25,82,6,74,112,10,43,15,3,181,84,179,170,199,8,15,254,195,189,149,254,123,185,196,194,242,232,79,197,108,8,49,250,21,21,50,169,2,240,238,51,36,16,244,74,63,174,53,249,15,164,227,211,53,199,239,172,14,2,173,0,245,161,156,189,148,192,11,12,215,22,131,204,112,231,233,22,91,13,88,13,175,251,17,79,28,228,122,221,4,191,77,5,114,197,68,98,89,160,15,235,214,249,119,96,255,7,148,240,165,109,58,218,65,39,193,172,124,221,1,197,179,1,157,231,225,226,249,54,68,229,235,253,72,37,19,251,205,206,0,158,242,247,29,189,2,240,51,231,136,253,175,247,5,85,21,96,23,38,231,70,227,91,56,11,55,45,238,94,60,111,35,205,250,187,71,103,165,0,188,228,115,6,250,211,27,168,60,57,140,70,236,97,11,170,177,52,164,3,220,4,35,200,87,70,164,61,59,1,146,83,11,102,254,194,152,75,156,62,240,7,133,95,164,69,237,178,242,199,66,101,217,211,246,206,142,6,92,2,86,202,97,180,12,93,170,86,178,94,12,249,127,247,223,251,151,251,239,87,98,230,112,11,246,82,67,34,237,14,39,18,154,234,136,95,244,227,138,109,24,59,58,220,52,226,140,109,152,48,30,78,151,38,187,0,171,53,142,182,62,253,78,207,223,252,229,178,125,204,139,89,132,246,221,99,200,187,226,218,171,67,137,182,137,39,169,243,187,32,210,17,114,206,80,84,154,228,30,252,210,76,32,104,253,2,247,251,45,233,75,226,29,103,251,72,49,219,185,168,11,208,167,168,119,222,29,254,206,209,227,52,71,22,200,247,218,232,199,2,122,214,94,241,76,80,227,221,70,248,38,12,168,76,67,1,15,231,218,238,67,17,169,176,243,38,81,205,49,62,118,184,113,234,215,76,187,57,24,211,24,74,116,83,17,90,42,185,20,221,34,244,190,27,83,87,207,41,55,176,11,217,149,5,115,159,42,106,134,7,118,252,6,168,253,1,165,71,146,53,107,199,224,255,30,21,52,74,230,193,91,248,137,180,205,86,53,251,36,103,41,219,83,40,82,68},
} ;

static const unsigned char precomputed_core_scale3sntrup653_n[precomputed_core_scale3sntrup653_NUM][crypto_core_INPUTBYTES] = {
  {132,61,82,149,121,42,229,103,165,63,222,217,64,64,216,236,132,88,7,61,94,27,169,172,18,114,113,240,225,200,18,122,27,234,128,128,221,177,132,210,34,29,24,130,27,43,29,189,113,213,95,22,160,6,184,114,119,70,178,110,91,8,28,177,140,45,148,122,103,86,240,165,238,61,32,43,183,89,103,175,173,57,173,250,82,115,255,127,165,87,17,70,134,157,167,16,141,232,125,126,27,186,177,176,94,127,59,95,228,133,128,192,77,127,237,128,172,234,88,39,42,70,93,245,251,77,222,6,51,69,146,74,8,184,172,103,131,90,86,236,205,117,10,137,194,163,54,53,136,232,123,61,163,7,3,164,34,195,183,78,82,156,212,68,188,56,155,159,245,118,170,173,71,64,217,156,207,109,193,107,100,234,247,176,31,155,91,121,173,221,222,198,190,64,169,173,178,73,224,141,22,9,3,14,1,239,230,191,167,27,126,107,246,165,220,39,87,159,88,60,24,219,90,110,107,125,228,224,234,255,166,35,231,247,178,206,39,125,130,110,131,235,216,183,29,145,61,236,166,15,74,35,161,139,63,112,123,18,183,125,208,191,120,122,121,53,104,172,190,42,31,149,120,67,127,161,58,217,14,36,97,218,162,48,202,158,228,70,125,51,226,243,14,11,114,251,34,117,79,154,204,246,114,244,87,218,42,96,158,98,194,27,145,102,16,139,153,26,172,203,68,147,210,90,40,205,245,9,69,96,153,158,44,126,178,59,136,249,240,183,245,28,31,191,246,116,234,207,26,201,84,18,194,215,210,54,239,228,46,249,55,152,150,133,57,201,137,195,114,66,65,70,19,20,26,94,216,72,153,255,242,82,67,192,67,49,104,246,18,69,211,19,126,34,14,242,198,141,9,115,56,76,92,190,180,49,130,33,240,89,58,208,145,235,136,58,163,65,160,95,221,239,212,158,134,29,120,58,121,159,198,152,135,242,27,185,202,10,121,17,198,38,153,156,67,186,194,36,128,124,31,201,77,70,34,30,59,81,155,101,150,225,27,186,75,139,55,20,105,250,109,222,62,40,234,213,73,134,93,168,138,70,112,2,162,27,77,19,138,195,214,16,50,246,180,184,68,43,200,2,234,191,4,221,76,178,87,130,140,210,141,123,184,118,177,103,81,123,123,4,227,127,126,3,90,31,103,119,168,69,235,57,180,149,202,173,27,245,254,147,52,139,199,235,213,132,132,107,32,207,42,82,209,190,32,30,154,164,126,141,112,69,171,199,145,241,2,213,43,5,12,28,77,248,231,172,97,114,113,20,138,50,195,0,26,62,75,40,136,66,188,151,167,20,186,212,187,144,31,41,24,243,183,115,26,29,78,255,161,69,87,24,49,87,59,215,122,243,211,216,239,24,152,5,144,153,127,91,152,21,149,252,22,22,80,172,4,1,130,142,188,221,99,71,160,128,243,56,78,117,22,187,185,39,9,42,215,39,68,32,61,89,204,16,169,110,100,45,198,5,11,232,25,59,108,188,231,131,192,186,251,241,75,55,1,35,130,85,134,138,147,255,70,164,25,166,12,72,51,1,115,67,213,197,215,63,115,230,221,74,103,70,182,38,35,67,202,243,217,83,210,76,41,62,17,73,167,131,29,131,120,127,138,121,83,232,228,9,250,30,113,127,195,34,68,76,68,43,152,114,185,4,0,53,157,1,69,20,129,1,41,224,22,48,69,89,71,221,106,154,3,254,85,254,117,51,26,6,239,150,127,161,57,131,50,206,233,74,181,199,37,241,195,226,21,224,180,121,17,115,110,112,100,2,148,46,120,112,146,74,179,228,115,76,236,41,17,236,182,59,55,221,52,91,2,135,8,149,5,171,194,122,135,117,244,28,14,15,171,15,249,131,186,221,2,40,179,93,198,255,255,215,233,124,20,35,119,29,71,8,35,34,24,51,117,15,76,142,144,141,237,28,183,0,3,188,43,22,52,32,242,181,27,76,194,96,78,154,83,154,181,182,192,19,230,226,173,7,123,153,237,186,20,91,186,125,174,119,98,60,44,231,239,149,112,180,2,71,126,149,23,135,160,117,233,176,56,193,144,208,154,80,152,146,26,209,174,239,91,158,75,11,2,22,221,188,182,88,4,87,9,81,125,252,211,91,21,177,218,84,29,114,53,6,159,39,34,37,38,128,194,21,211,108,40,217,199,118,71,173,209,81,241,6,133,156,139,147,202,156,43,204,215,241,64,189,165,204,13,245,24,148,121,254,12,197,251,168,213,30,18,110,29,144,42,217,30,160,201,67,119,126,5,157,178,172,164,154,116,111,227,32,49,102,108,42,35,52,8,109,7,186,189,142,135,182,233,66,126,131,118,33,43,210,224,199,64,60,232,202,5,223,142,85,213,178,10,92,83,188,153,217,81,77,94,242,24,59,92,40,98,112,209,223,169,57,51,226,226,10,163,141,167,64,72,17,72,62,189,39,179,62,175,1,164,118,217,162,114,96,66,235,71,127,195,67,228,8,54,32,28,198,29,108,65,89,161,237,100,154,190,51,229,18,122,132,23,233,170,103,228,173,92,175,17,253,16,230,70,142,178,211,24,245,163,127,166,89,76,29,124,95,123,136,178,57,187,136,203,151,144,119,254,69,228,55,43,103,252,26,13,25,62,57,121,132,191,81,121,160,20,135,234,28,162,119,35,11,73,156,231,199,78,101,160,82,51,106,28,54,199,39,243,48,128,18,238,52,18,176,129,244,153,53,84,248,248,29,174,127,41,102,80,30,195,136,170,112,186,185,234,102,159,90,22,217,95,102,137,24,65,27,213,174,215,195,21,8,81,122,4,24,129,113,208,120,156,70,20,184,155,250,218,124,41,253,162,216,193,82,231,167,57,221,75,233,41,231,147,15,168,86,172,76,50,47,121,86,116,234,52,202,140,160,205,244},
  {120,117,58,30,91,66,198,177,27,74,230,135,3,182,106,218,202,8,194,87,113,47,82,84,196,204,251,232,168,135,61,51,74,99,254,245,88,85,17,233,136,77,116,112,70,36,32,88,91,205,202,110,221,45,134,21,148,171,12,11,23,70,40,249,235,225,13,203,234,149,75,161,135,116,74,109,192,189,0,16,250,25,16,67,210,20,38,163,47,40,190,153,174,101,219,86,30,90,255,198,32,189,239,94,141,77,248,217,141,215,168,138,162,113,241,149,142,23,170,73,64,64,81,103,171,187,167,207,244,211,91,152,66,129,78,125,106,134,231,30,18,251,219,129,150,168,125,18,141,210,140,209,117,163,82,12,237,105,19,213,12,135,43,59,216,133,142,2,2,165,33,112,21,220,196,140,71,202,196,218,190,93,97,202,81,112,47,142,246,151,236,239,141,228,148,219,239,19,54,112,84,160,36,116,139,131,42,176,205,136,174,246,33,178,18,44,27,135,90,111,59,117,207,188,49,127,17,197,5,68,189,158,142,55,230,100,139,234,54,170,209,63,240,149,141,79,209,178,96,60,112,102,146,229,18,83,51,197,209,90,118,225,22,73,226,113,203,187,248,112,41,230,248,64,184,32,141,234,245,63,159,101,208,63,65,44,240,144,49,57,71,114,129,198,57,184,64,205,17,124,245,156,54,179,120,167,232,222,139,70,169,202,162,207,51,36,138,111,247,80,19,142,30,249,95,85,177,155,61,49,234,170,176,245,201,179,255,211,193,189,95,150,149,255,253,92,33,58,174,120,186,55,147,51,20,33,59,147,119,108,73,155,231,171,65,161,7,78,156,52,195,165,142,139,226,61,45,2,76,177,33,71,197,161,197,94,176,88,101,90,103,58,190,172,37,28,42,140,92,11,195,177,186,173,92,249,195,216,250,139,151,105,165,77,177,104,71,11,30,132,114,2,103,166,150,145,221,189,212,112,150,5,30,47,131,175,203,68,94,54,26,50,30,239,66,50,105,16,247,248,65,54,75,237,230,220,156,89,238,30,141,240,59,22,132,97,115,211,88,204,251,82,210,103,59,10,241,215,141,173,38,115,243,36,119,181,153,24,4,17,74,181,191,155,158,119,40,66,76,213,139,167,3,242,203,23,137,27,29,198,5,42,240,209,206,133,47,79,131,85,50,194,204,126,238,148,34,4,235,35,196,13,100,65,143,130,218,54,217,15,214,33,233,121,60,143,4,201,222,2,106,55,187,18,22,243,163,152,103,158,188,214,31,74,95,94,108,164,45,2,73,27,36,157,160,224,43,59,204,77,23,190,108,20,104,27,75,188,44,37,118,97,119,194,241,69,235,6,249,92,48,112,104,97,108,92,147,146,143,36,176,46,96,76,239,125,76,144,233,52,168,62,3,238,56,94,74,184,68,192,249,81,14,13,149,185,44,248,118,61,66,201,185,6,176,150,101,5,6,241,149,15,18,17,114,44,32,206,135,146,235,174,77,23,156,58,10,194,48,149,23,204,61,48,168,213,62,64,228,101,145,96,178,163,112,227,97,147,238,61,118,242,53,4,187,180,66,193,61,51,121,162,167,61,7,74,10,172,116,203,117,84,162,110,68,37,55,184,157,186,212,110,122,223,166,53,1,157,247,232,19,7,104,227,143,177,19,70,48,215,19,82,47,88,243,193,152,210,30,132,93,96,109,3,85,3,250,244,52,13,61,129,240,158,17,105,208,34,129,158,91,234,183,33,130,35,128,1,185,115,249,214,65,22,90,234,140,119,36,168,121,186,67,122,49,147,34,197,201,27,188,160,73,125,84,246,19,128,156,175,164,225,165,32,71,247,222,122,241,224,66,22,118,49,157,226,238,95,164,29,19,149,187,247,121,241,186,153,61,144,221,182,176,153,108,120,78,105,22,171,90,138,47,3,29,105,191,211,64,247,66,184,51,28,182,183,37,251,44,63,106,153,182,169,63,185,58,6,154,60,174,204,119,163,137,210,85,61,251,178,170,199,8,206,204,221,143,65,194,156,166,149,78,18,219,218,207,135,237,132,248,90,5,89,101,203,51,209,86,43,51,227,126,79,144,222,39,44,219,124,245,59,204,71,157,119,233,66,61,240,249,232,205,250,124,175,65,253,22,143,152,86,13,81,199,252,101,78,219,71,122,226,59,152,46,239,8,215,132,109,40,21,161,5,212,59,232,26,83,114,139,245,144,53,111,57,108,50,198,223,184,223,62,244,57,143,112,229,230,217,53,39,156,35,164,136,157,184,41,25,125,148,93,90,0,80,6,249,111,254,58,6,118,29,135,3,124,117,123,69,124,202,31,123,209,198,163,64,199,11,71,192,21,163,233,57,5,206,151,37,84,60,60,8,215,174,124,171,89,7,76,85,104,199,23,192,205,31,18,209,44,245,165,229,148,7,69,229,255,23,77,37,148,184,229,173,107,13,122,152,91,246,17,159,244,127,222,74,231,74,213,154,78,106,78,46,110,78,56,96,180,216,77,244,90,113,100,43,8,199,173,44,21,104,179,205,53,57,35,148,152,67,182,234,47,46,21,32,136,78,205,82,246,208,64,129,149,233,144,38,74,173,55,62,150,138,173,100,102,17,33,220,221,188,230,26,93,145,230,113,164,46,240,211,209,112,113,243,221,48,49,74,80,230,93,105,80,182,10,227,1,23,240,179,125,46,11,238,169,83,135,21,109,31,70,3,47,69,143,160,78,161,120,61,156,167,5,247,71,204,95,76,140,77,9,178,20,230,164,188,169,28,31,11,164,166,46,79,201,114,93,50,39,96,141,225,57,241,108,226,3,170,116,243,181,212,179,188,23,236,216,167,20,32,211,188,29,52,86,47,243,240,91,90,13,235,92,207,178,234,70,138,84,90,36,103,246,13,76,250,56,39,235,146,161,148,102,238,151,170,230,175,68,172,109,6},
  {99,152,76,13,138,56,65,209,9,86,136,173,195,230,248,212,102,25,28,197,83,13,89,138,242,141,251,242,248,87,60,88,192,160,170,189,48,145,117,41,38,146,247,204,244,30,176,157,153,229,230,2,243,183,129,93,54,38,224,122,73,177,63,226,35,202,12,7,157,89,190,10,163,13,236,11,204,173,143,112,161,194,220,118,110,67,147,18,249,85,88,198,131,251,226,141,185,54,26,35,172,102,170,126,144,81,61,125,68,116,241,70,193,27,119,195,85,201,86,206,122,153,112,95,47,197,212,14,135,60,202,39,248,24,160,82,221,136,168,63,125,238,183,117,32,172,80,114,146,197,168,200,12,180,94,182,212,195,39,142,150,95,21,173,108,215,142,152,175,129,24,197,0,83,8,247,205,66,48,150,161,165,209,168,173,10,254,193,166,208,60,94,236,2,233,51,206,115,63,197,72,37,68,112,103,229,202,16,189,141,33,184,221,28,111,40,229,46,176,130,53,254,177,28,123,15,28,186,175,247,40,56,52,51,88,239,140,239,232,52,250,73,159,127,255,68,27,85,121,189,110,238,165,192,247,5,229,50,249,188,248,179,187,9,182,62,20,9,127,22,48,71,111,118,133,193,174,188,43,163,228,136,7,161,11,61,195,30,250,250,114,225,83,38,157,127,201,104,230,251,202,221,194,231,140,198,182,26,94,167,104,16,31,15,253,148,191,232,201,234,247,140,212,95,128,178,134,119,179,45,119,233,109,41,249,42,53,176,75,116,49,186,76,88,65,138,181,184,63,169,235,98,74,232,52,242,62,191,12,18,97,207,177,211,18,220,214,36,45,55,241,148,146,245,69,143,2,180,126,109,79,255,20,96,232,249,80,37,168,109,45,5,201,225,92,100,243,5,226,28,232,34,166,185,145,86,172,190,59,21,105,119,149,37,47,81,197,74,132,158,225,65,30,123,36,201,76,198,74,115,174,226,98,151,118,107,154,21,64,249,217,226,66,194,141,222,180,22,155,131,72,22,65,141,18,16,126,96,104,99,50,6,181,18,101,100,71,100,63,228,198,156,142,16,26,83,24,149,132,171,251,206,187,167,93,3,96,109,173,78,67,5,135,46,60,39,70,180,133,78,222,131,62,6,15,254,44,185,212,242,146,236,187,205,224,99,250,159,58,54,100,89,35,177,201,132,5,187,208,139,251,216,179,233,146,26,214,80,91,42,185,224,32,6,226,39,42,219,141,147,173,238,86,0,191,86,124,130,114,159,127,72,232,0,231,150,229,104,250,108,205,252,35,119,97,91,213,114,33,79,77,40,144,110,32,198,72,120,56,180,232,250,97,8,153,37,25,155,189,118,165,156,86,255,208,123,151,112,20,94,130,166,22,193,58,126,6,51,5,90,32,245,31,217,122,162,41,89,143,56,196,242,242,49,151,236,127,206,191,144,247,230,132,211,16,178,157,10,185,111,42,143,155,114,37,119,92,237,218,146,197,223,142,179,196,42,247,198,110,145,17,160,37,132,21,84,222,105,52,130,183,221,40,191,206,177,143,55,184,173,158,166,85,252,32,80,13,238,31,56,233,73,199,255,83,179,228,65,240,237,17,28,206,172,42,101,244,152,179,117,71,80,81,252,200,191,95,100,58,201,85,209,132,228,92,44,190,143,178,83,185,14,137,237,75,26,243,0,186,195,114,176,136,225,148,231,12,205,143,243,27,33,149,159,216,121,27,74,163,66,7,241,7,127,245,213,215,180,229,176,157,83,27,181,226,155,232,199,95,48,132,141,65,12,138,55,61,30,232,144,150,58,32,27,158,180,31,196,184,220,35,38,169,222,148,174,7,172,27,44,142,19,216,170,152,70,204,210,209,221,38,180,124,54,144,47,113,60,140,78,117,112,152,205,219,155,134,255,171,79,158,171,212,201,103,173,218,125,78,101,237,164,97,61,214,56,81,38,187,32,109,89,44,209,3,127,51,135,93,135,156,139,8,166,255,149,246,91,30,175,18,159,142,252,94,121,109,227,4,3,189,73,154,183,102,161,36,94,126,116,33,74,86,239,235,214,254,178,32,45,84,166,131,233,86,42,33,190,131,250,239,83,26,70,241,240,81,144,178,211,61,223,201,6,247,84,187,183,53,92,121,12,175,219,38,59,237,188,156,225,156,16,52,149,173,139,209,123,236,52,109,216,3,125,135,244,244,51,85,172,131,178,120,126,58,59,150,229,30,178,244,168,74,173,115,189,143,221,39,189,27,40,253,175,228,51,9,191,21,223,188,78,164,197,239,242,24,38,44,216,198,145,24,250,118,140,222,115,32,190,232,98,201,70,202,247,89,43,123,65,164,170,230,104,9,172,228,109,141,118,186,241,249,99,225,194,56,84,122,146,213,107,236,12,154,60,58,255,168,12,149,35,223,183,5,164,86,134,75,210,153,92,251,27,159,55,209,174,2,35,246,108,92,110,169,142,166,108,23,110,161,183,167,190,146,78,160,246,242,40,50,184,50,170,238,146,227,186,79,10,63,247,250,249,14,98,120,176,156,247,29,88,74,12,71,148,144,51,80,235,181,107,255,19,165,118,177,187,180,108,75,200,109,197,84,240,116,127,149,138,85,167,69,171,214,157,222,91,116,190,249,130,229,4,104,131,18,18,107,145,139,64,147,180,132,178,161,211,125,203,155,144,41,210,159,235,96,95,254,51,115,33,106,119,209,252,243,242,43,153,126,225,227,240,184,182,24,132,20,12,138,83,5,29,117,170,176,147,7,106,9,35,137,114,28,68,43,181,3,162,184,120,103,70,73,166,243,39,209,28,217,82,128,226,205,10,142,194,36,138,234,235,181,150,52,160,100,159,174,163,126,79,82,193,175,184,56,233,213,6,105,249,6,17,53,86,193,96,114,72,145,49,190,187,123,126,175,89,5,183,145,151,4,93,232,186},
  {40,212,24,164,107,79,71,61,62,147,175,185,243,125,119,220,159,198,183,1,66,172,180,164,177,15,124,206,118,243,149,234,72,69,164,106,203,235,165,244,106,32,155,105,49,95,246,217,111,246,121,95,77,156,67,233,194,82,242,200,174,47,106,246,74,62,59,43,211,226,217,100,78,137,231,146,77,66,178,130,9,16,180,172,171,105,246,66,197,24,24,99,242,4,4,224,68,0,223,173,143,27,82,155,167,197,26,141,51,131,184,185,181,145,176,131,21,26,189,22,166,242,198,191,61,76,99,59,232,70,46,150,75,170,235,1,104,57,135,125,54,201,111,229,182,203,87,152,24,213,193,223,157,97,11,146,101,178,11,246,206,66,85,92,73,203,10,169,87,56,194,213,79,50,226,81,136,160,248,57,70,228,111,140,135,221,177,82,214,2,205,249,193,142,65,182,153,6,186,83,246,147,234,165,95,65,104,177,161,195,41,195,136,181,1,64,45,234,197,75,92,231,89,105,156,20,197,139,205,78,185,146,253,120,184,79,224,52,203,115,136,190,118,168,204,134,2,158,227,86,125,65,103,191,131,60,15,60,212,55,148,113,213,137,37,224,199,224,211,32,204,237,67,99,153,184,162,188,162,98,229,16,128,81,166,179,79,52,155,159,195,137,76,3,20,49,2,120,160,72,155,80,122,172,130,243,87,84,245,24,74,162,177,15,107,24,128,168,188,144,62,97,186,24,76,90,125,5,248,85,21,80,87,233,162,249,198,247,232,86,211,70,128,112,6,111,142,239,72,188,244,29,117,147,111,104,92,162,163,210,31,42,246,111,129,39,148,164,78,37,187,174,137,230,151,110,106,115,252,164,157,82,65,121,89,190,120,98,79,50,213,21,142,77,63,41,141,61,77,31,218,102,143,12,250,255,58,39,60,71,39,13,234,96,203,142,11,133,235,180,126,159,139,154,208,90,241,130,225,26,0,9,131,75,79,145,194,158,244,66,6,253,63,227,151,80,13,168,13,21,80,94,56,89,156,50,2,37,76,45,252,31,170,120,158,22,166,115,28,165,239,9,181,152,124,229,170,251,22,56,95,121,145,18,129,131,151,61,50,44,177,121,232,145,239,139,32,161,94,134,25,53,78,241,125,255,56,181,51,65,118,245,168,180,103,143,156,42,6,137,15,118,30,58,112,12,179,134,129,165,202,102,42,57,237,15,231,103,219,140,56,139,140,250,138,158,248,0,194,155,103,120,40,89,49,70,236,73,37,101,211,44,217,176,6,179,55,120,115,115,181,209,38,238,230,170,47,120,65,199,199,30,150,204,95,83,114,233,234,153,210,86,234,114,199,244,180,160,116,220,95,205,249,177,50,51,238,189,243,219,110,209,25,228,158,157,70,109,55,37,175,87,161,56,195,185,46,134,200,187,222,95,57,132,79,194,218,149,56,54,149,229,26,23,5,8,217,205,32,99,90,224,139,209,158,111,246,48,158,237,199,73,157,47,94,177,29,134,252,135,134,130,98,22,180,112,32,48,219,76,244,204,84,70,164,66,52,42,217,30,156,2,100,180,122,139,236,227,208,14,240,12,23,250,35,139,140,31,28,179,60,219,198,246,249,115,192,5,111,50,228,79,97,173,54,197,89,94,53,90,96,150,108,126,10,135,88,25,243,102,95,214,102,26,19,48,62,74,101,146,128,55,59,138,51,175,181,9,168,107,76,218,241,16,146,45,77,195,42,123,229,138,111,118,18,122,242,175,214,111,118,20,191,28,19,50,1,212,214,59,178,34,80,180,94,23,3,105,235,61,164,37,20,210,208,46,146,139,17,132,151,210,43,166,92,75,30,189,158,161,10,185,198,172,29,214,93,20,86,80,150,119,226,50,156,179,180,90,146,142,54,176,122,226,61,144,247,156,22,145,211,8,106,89,182,183,183,135,167,244,169,108,187,96,171,201,102,137,22,89,86,219,242,149,184,145,246,136,171,250,62,6,248,47,133,142,45,58,8,10,76,184,210,232,33,71,82,184,120,10,119,10,54,163,10,203,5,70,207,67,253,142,111,172,119,230,27,124,196,132,86,72,67,77,44,38,4,94,45,74,230,127,15,152,26,19,60,222,37,153,252,144,226,79,48,71,156,69,2,195,189,155,74,249,199,103,2,163,64,148,81,217,247,161,176,227,167,244,98,156,135,90,54,247,6,205,182,208,12,104,252,114,80,207,23,95,108,106,169,37,195,213,178,147,79,227,28,211,55,0,229,240,34,252,79,235,90,135,195,195,51,200,83,209,170,50,234,108,59,7,163,7,178,60,204,114,59,197,186,79,53,119,8,40,251,58,55,31,227,26,161,252,134,208,59,29,160,53,247,145,197,39,68,235,163,233,137,93,35,92,195,146,28,54,179,207,61,120,149,37,4,83,38,247,164,4,221,83,84,35,199,70,127,180,1,119,112,17,254,10,188,182,47,72,135,208,77,155,221,127,183,25,15,238,13,240,51,213,55,22,185,202,140,189,233,170,232,23,43,140,106,84,107,148,164,175,72,224,208,232,136,206,125,161,78,39,233,141,71,152,232,113,212,54,50,19,52,75,152,187,245,11,119,233,31,34,47,70,10,84,245,116,15,126,174,177,253,83,96,242,106,69,14,211,88,30,12,67,228,220,170,148,222,220,206,238,95,255,235,63,80,194,28,184,233,161,239,156,237,0,207,150,27,245,115,203,242,67,194,82,17,10,231,116,193,85,86,156,239,158,112,182,52,138,0,19,108,62,106,197,35,226,204,242,76,202,152,110,89,64,183,30,43,119,10,36,95,226,173,67,7,246,153,100,32,35,244,19,14,138,170,151,54,93,34,47,189,126,49,179,35,78,83,135,174,6,230,29,53,109,202,145,241,249,185,183,107,201,243,143,26,162,212,224,158,205,22,175,187,125,180,237,32,190,117,199},
} ;

static const unsigned char precomputed_core_scale3sntrup653_k[precomputed_core_scale3sntrup653_NUM][crypto_core_KEYBYTES] = {
  {},
  {},
  {},
  {},
} ;

static const unsigned char precomputed_core_scale3sntrup653_c[precomputed_core_scale3sntrup653_NUM][crypto_core_CONSTBYTES] = {
  {},
  {},
  {},
  {},
} ;

static void test_core_scale3sntrup653_impl(long long impl)
{
  unsigned char *h = test_core_scale3sntrup653_h;
  unsigned char *n = test_core_scale3sntrup653_n;
  unsigned char *k = test_core_scale3sntrup653_k;
  unsigned char *c = test_core_scale3sntrup653_c;
  unsigned char *h2 = test_core_scale3sntrup653_h2;
  unsigned char *n2 = test_core_scale3sntrup653_n2;
  unsigned char *k2 = test_core_scale3sntrup653_k2;
  unsigned char *c2 = test_core_scale3sntrup653_c2;
  long long hlen = crypto_core_OUTPUTBYTES;
  long long nlen = crypto_core_INPUTBYTES;
  long long klen = crypto_core_KEYBYTES;
  long long clen = crypto_core_CONSTBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_core_scale3sntrup653_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_core = ntruprime_dispatch_core_scale3sntrup653(impl);
    printf("core_scale3sntrup653 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_scale3sntrup653_implementation(impl),ntruprime_dispatch_core_scale3sntrup653_compiler(impl));
  } else {
    crypto_core = ntruprime_core_scale3sntrup653;
    printf("core_scale3sntrup653 selected implementation %s compiler %s\n",ntruprime_core_scale3sntrup653_implementation(),ntruprime_core_scale3sntrup653_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 512;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(h2,h,hlen);
      input_prepare(n2,n,nlen);
      input_prepare(k2,k,klen);
      input_prepare(c2,c,clen);
      secret(n,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(h,n,k,c);
      public(n,nlen);
      public(k,klen);
      public(c,clen);
      public(h,hlen);
      checksum(h,hlen);
      output_compare(h2,h,hlen,"crypto_core");
      input_compare(n2,n,nlen,"crypto_core");
      input_compare(k2,k,klen,"crypto_core");
      input_compare(c2,c,clen,"crypto_core");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k2,klen);
      secret(c2,clen);
      crypto_core(h2,n2,k2,c2);
      public(n2,nlen);
      public(k2,klen);
      public(c2,clen);
      public(h2,hlen);
      if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_core is nondeterministic\n");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(n2,n2,k,c);
      public(n2,hlen);
      public(k,klen);
      public(c,clen);
      if (memcmp(n2,h,hlen) != 0) fail("failure: crypto_core does not handle n=h overlap\n");
      memcpy(n2,n,nlen);
      secret(n,nlen);
      secret(k2,klen);
      secret(c,clen);
      crypto_core(k2,n,k2,c);
      public(k2,hlen);
      public(n,nlen);
      public(c,clen);
      if (memcmp(k2,h,hlen) != 0) fail("failure: crypto_core does not handle k=h overlap\n");
      memcpy(k2,k,klen);
      secret(n,nlen);
      secret(k,klen);
      secret(c2,clen);
      crypto_core(c2,n,k,c2);
      public(c2,hlen);
      public(n,nlen);
      public(k,klen);
      if (memcmp(c2,h,hlen) != 0) fail("failure: crypto_core does not handle c=h overlap\n");
      memcpy(c2,c,clen);
    }
    checksum_expected(core_scale3sntrup653_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_core_scale3sntrup653_NUM;++precomp) {
    output_prepare(h2,h,crypto_core_OUTPUTBYTES);
    input_prepare(n2,n,crypto_core_INPUTBYTES);
    memcpy(n,precomputed_core_scale3sntrup653_n[precomp],crypto_core_INPUTBYTES);
    memcpy(n2,precomputed_core_scale3sntrup653_n[precomp],crypto_core_INPUTBYTES);
    input_prepare(k2,k,crypto_core_KEYBYTES);
    memcpy(k,precomputed_core_scale3sntrup653_k[precomp],crypto_core_KEYBYTES);
    memcpy(k2,precomputed_core_scale3sntrup653_k[precomp],crypto_core_KEYBYTES);
    input_prepare(c2,c,crypto_core_CONSTBYTES);
    memcpy(c,precomputed_core_scale3sntrup653_c[precomp],crypto_core_CONSTBYTES);
    memcpy(c2,precomputed_core_scale3sntrup653_c[precomp],crypto_core_CONSTBYTES);
    crypto_core(h,n,k,c);
    if (memcmp(h,precomputed_core_scale3sntrup653_h[precomp],crypto_core_OUTPUTBYTES)) {
      fail("failure: crypto_core fails precomputed test vectors\n");
      printf("expected h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",((unsigned char *) precomputed_core_scale3sntrup653_h[precomp])[pos]);
      printf("\n");
      printf("received h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",h[pos]);
      printf("\n");
    }
    output_compare(h2,h,crypto_core_OUTPUTBYTES,"crypto_core");
    input_compare(n2,n,crypto_core_INPUTBYTES,"crypto_core");
    input_compare(k2,k,crypto_core_KEYBYTES,"crypto_core");
    input_compare(c2,c,crypto_core_CONSTBYTES,"crypto_core");
  }
}

void test_core_scale3sntrup653(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"scale3sntrup653")) return;
  storage_core_scale3sntrup653_h = callocplus(crypto_core_OUTPUTBYTES);
  test_core_scale3sntrup653_h = aligned(storage_core_scale3sntrup653_h,crypto_core_OUTPUTBYTES);
  if (crypto_core_OUTPUTBYTES > maxalloc) maxalloc = crypto_core_OUTPUTBYTES;
  storage_core_scale3sntrup653_n = callocplus(crypto_core_INPUTBYTES);
  test_core_scale3sntrup653_n = aligned(storage_core_scale3sntrup653_n,crypto_core_INPUTBYTES);
  if (crypto_core_INPUTBYTES > maxalloc) maxalloc = crypto_core_INPUTBYTES;
  storage_core_scale3sntrup653_k = callocplus(crypto_core_KEYBYTES);
  test_core_scale3sntrup653_k = aligned(storage_core_scale3sntrup653_k,crypto_core_KEYBYTES);
  if (crypto_core_KEYBYTES > maxalloc) maxalloc = crypto_core_KEYBYTES;
  storage_core_scale3sntrup653_c = callocplus(crypto_core_CONSTBYTES);
  test_core_scale3sntrup653_c = aligned(storage_core_scale3sntrup653_c,crypto_core_CONSTBYTES);
  if (crypto_core_CONSTBYTES > maxalloc) maxalloc = crypto_core_CONSTBYTES;
  storage_core_scale3sntrup653_h2 = callocplus(maxalloc);
  test_core_scale3sntrup653_h2 = aligned(storage_core_scale3sntrup653_h2,crypto_core_OUTPUTBYTES);
  storage_core_scale3sntrup653_n2 = callocplus(maxalloc);
  test_core_scale3sntrup653_n2 = aligned(storage_core_scale3sntrup653_n2,crypto_core_INPUTBYTES);
  storage_core_scale3sntrup653_k2 = callocplus(maxalloc);
  test_core_scale3sntrup653_k2 = aligned(storage_core_scale3sntrup653_k2,crypto_core_KEYBYTES);
  storage_core_scale3sntrup653_c2 = callocplus(maxalloc);
  test_core_scale3sntrup653_c2 = aligned(storage_core_scale3sntrup653_c2,crypto_core_CONSTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("core_scale3sntrup653 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_core_scale3sntrup653();++impl)
      forked(test_core_scale3sntrup653_impl,impl);
    ++test_core_scale3sntrup653_h;
    ++test_core_scale3sntrup653_n;
    ++test_core_scale3sntrup653_k;
    ++test_core_scale3sntrup653_c;
    ++test_core_scale3sntrup653_h2;
    ++test_core_scale3sntrup653_n2;
    ++test_core_scale3sntrup653_k2;
    ++test_core_scale3sntrup653_c2;
  }
  free(storage_core_scale3sntrup653_c2);
  free(storage_core_scale3sntrup653_k2);
  free(storage_core_scale3sntrup653_n2);
  free(storage_core_scale3sntrup653_h2);
  free(storage_core_scale3sntrup653_c);
  free(storage_core_scale3sntrup653_k);
  free(storage_core_scale3sntrup653_n);
  free(storage_core_scale3sntrup653_h);
}
#undef crypto_core_OUTPUTBYTES
#undef crypto_core_INPUTBYTES
#undef crypto_core_KEYBYTES
#undef crypto_core_CONSTBYTES

