/*************************************************************************
 * odil - Copyright (C) Universite de Strasbourg
 * Distributed under the terms of the CeCILL-B license, as published by
 * the CEA-CNRS-INRIA. Refer to the LICENSE file or to
 * http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 * for details.
 ************************************************************************/

#include <map>
#include <string>
#include <tuple>

#include "odil/ElementsDictionary.h"
#include "odil/Tag.h"

namespace odil
{

namespace registry
{

void update_0040(
    ElementsDictionary & public_dictionary,
    std::map<std::string, odil::Tag> & public_tags)
{

    public_dictionary.emplace(Tag(0x0040, 0x0001), ElementsDictionaryEntry("Scheduled Station AE Title", "ScheduledStationAETitle",  "AE", "1-n"));
    public_dictionary.emplace(Tag(0x0040, 0x0002), ElementsDictionaryEntry("Scheduled Procedure Step Start Date", "ScheduledProcedureStepStartDate",  "DA", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0003), ElementsDictionaryEntry("Scheduled Procedure Step Start Time", "ScheduledProcedureStepStartTime",  "TM", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0004), ElementsDictionaryEntry("Scheduled Procedure Step End Date", "ScheduledProcedureStepEndDate",  "DA", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0005), ElementsDictionaryEntry("Scheduled Procedure Step End Time", "ScheduledProcedureStepEndTime",  "TM", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0006), ElementsDictionaryEntry("Scheduled Performing Physician's Name", "ScheduledPerformingPhysicianName",  "PN", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0007), ElementsDictionaryEntry("Scheduled Procedure Step Description", "ScheduledProcedureStepDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0008), ElementsDictionaryEntry("Scheduled Protocol Code Sequence", "ScheduledProtocolCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0009), ElementsDictionaryEntry("Scheduled Procedure Step ID", "ScheduledProcedureStepID",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x000a), ElementsDictionaryEntry("Stage Code Sequence", "StageCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x000b), ElementsDictionaryEntry("Scheduled Performing Physician Identification Sequence", "ScheduledPerformingPhysicianIdentificationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0010), ElementsDictionaryEntry("Scheduled Station Name", "ScheduledStationName",  "SH", "1-n"));
    public_dictionary.emplace(Tag(0x0040, 0x0011), ElementsDictionaryEntry("Scheduled Procedure Step Location", "ScheduledProcedureStepLocation",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0012), ElementsDictionaryEntry("Pre-Medication", "PreMedication",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0020), ElementsDictionaryEntry("Scheduled Procedure Step Status", "ScheduledProcedureStepStatus",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0026), ElementsDictionaryEntry("Order Placer Identifier Sequence", "OrderPlacerIdentifierSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0027), ElementsDictionaryEntry("Order Filler Identifier Sequence", "OrderFillerIdentifierSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0031), ElementsDictionaryEntry("Local Namespace Entity ID", "LocalNamespaceEntityID",  "UT", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0032), ElementsDictionaryEntry("Universal Entity ID", "UniversalEntityID",  "UT", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0033), ElementsDictionaryEntry("Universal Entity ID Type", "UniversalEntityIDType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0035), ElementsDictionaryEntry("Identifier Type Code", "IdentifierTypeCode",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0036), ElementsDictionaryEntry("Assigning Facility Sequence", "AssigningFacilitySequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0039), ElementsDictionaryEntry("Assigning Jurisdiction Code Sequence", "AssigningJurisdictionCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x003a), ElementsDictionaryEntry("Assigning Agency or Department Code Sequence", "AssigningAgencyOrDepartmentCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0100), ElementsDictionaryEntry("Scheduled Procedure Step Sequence", "ScheduledProcedureStepSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0220), ElementsDictionaryEntry("Referenced Non-Image Composite SOP Instance Sequence", "ReferencedNonImageCompositeSOPInstanceSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0241), ElementsDictionaryEntry("Performed Station AE Title", "PerformedStationAETitle",  "AE", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0242), ElementsDictionaryEntry("Performed Station Name", "PerformedStationName",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0243), ElementsDictionaryEntry("Performed Location", "PerformedLocation",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0244), ElementsDictionaryEntry("Performed Procedure Step Start Date", "PerformedProcedureStepStartDate",  "DA", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0245), ElementsDictionaryEntry("Performed Procedure Step Start Time", "PerformedProcedureStepStartTime",  "TM", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0250), ElementsDictionaryEntry("Performed Procedure Step End Date", "PerformedProcedureStepEndDate",  "DA", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0251), ElementsDictionaryEntry("Performed Procedure Step End Time", "PerformedProcedureStepEndTime",  "TM", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0252), ElementsDictionaryEntry("Performed Procedure Step Status", "PerformedProcedureStepStatus",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0253), ElementsDictionaryEntry("Performed Procedure Step ID", "PerformedProcedureStepID",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0254), ElementsDictionaryEntry("Performed Procedure Step Description", "PerformedProcedureStepDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0255), ElementsDictionaryEntry("Performed Procedure Type Description", "PerformedProcedureTypeDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0260), ElementsDictionaryEntry("Performed Protocol Code Sequence", "PerformedProtocolCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0261), ElementsDictionaryEntry("Performed Protocol Type", "PerformedProtocolType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0270), ElementsDictionaryEntry("Scheduled Step Attributes Sequence", "ScheduledStepAttributesSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0275), ElementsDictionaryEntry("Request Attributes Sequence", "RequestAttributesSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0280), ElementsDictionaryEntry("Comments on the Performed Procedure Step", "CommentsOnThePerformedProcedureStep",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0281), ElementsDictionaryEntry("Performed Procedure Step Discontinuation Reason Code Sequence", "PerformedProcedureStepDiscontinuationReasonCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0293), ElementsDictionaryEntry("Quantity Sequence", "QuantitySequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0294), ElementsDictionaryEntry("Quantity", "Quantity",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0295), ElementsDictionaryEntry("Measuring Units Sequence", "MeasuringUnitsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0296), ElementsDictionaryEntry("Billing Item Sequence", "BillingItemSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0300), ElementsDictionaryEntry("Total Time of Fluoroscopy", "TotalTimeOfFluoroscopy",  "US", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0301), ElementsDictionaryEntry("Total Number of Exposures", "TotalNumberOfExposures",  "US", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0302), ElementsDictionaryEntry("Entrance Dose", "EntranceDose",  "US", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0303), ElementsDictionaryEntry("Exposed Area", "ExposedArea",  "US", "1-2"));
    public_dictionary.emplace(Tag(0x0040, 0x0306), ElementsDictionaryEntry("Distance Source to Entrance", "DistanceSourceToEntrance",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0307), ElementsDictionaryEntry("Distance Source to Support", "DistanceSourceToSupport",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x030e), ElementsDictionaryEntry("Exposure Dose Sequence", "ExposureDoseSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0310), ElementsDictionaryEntry("Comments on Radiation Dose", "CommentsOnRadiationDose",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0312), ElementsDictionaryEntry("X-Ray Output", "XRayOutput",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0314), ElementsDictionaryEntry("Half Value Layer", "HalfValueLayer",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0316), ElementsDictionaryEntry("Organ Dose", "OrganDose",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0318), ElementsDictionaryEntry("Organ Exposed", "OrganExposed",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0320), ElementsDictionaryEntry("Billing Procedure Step Sequence", "BillingProcedureStepSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0321), ElementsDictionaryEntry("Film Consumption Sequence", "FilmConsumptionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0324), ElementsDictionaryEntry("Billing Supplies and Devices Sequence", "BillingSuppliesAndDevicesSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0330), ElementsDictionaryEntry("Referenced Procedure Step Sequence", "ReferencedProcedureStepSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0340), ElementsDictionaryEntry("Performed Series Sequence", "PerformedSeriesSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0400), ElementsDictionaryEntry("Comments on the Scheduled Procedure Step", "CommentsOnTheScheduledProcedureStep",  "LT", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0440), ElementsDictionaryEntry("Protocol Context Sequence", "ProtocolContextSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0441), ElementsDictionaryEntry("Content Item Modifier Sequence", "ContentItemModifierSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0500), ElementsDictionaryEntry("Scheduled Specimen Sequence", "ScheduledSpecimenSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x050a), ElementsDictionaryEntry("Specimen Accession Number", "SpecimenAccessionNumber",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0512), ElementsDictionaryEntry("Container Identifier", "ContainerIdentifier",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0513), ElementsDictionaryEntry("Issuer of the Container Identifier Sequence", "IssuerOfTheContainerIdentifierSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0515), ElementsDictionaryEntry("Alternate Container Identifier Sequence", "AlternateContainerIdentifierSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0518), ElementsDictionaryEntry("Container Type Code Sequence", "ContainerTypeCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x051a), ElementsDictionaryEntry("Container Description", "ContainerDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0520), ElementsDictionaryEntry("Container Component Sequence", "ContainerComponentSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0550), ElementsDictionaryEntry("Specimen Sequence", "SpecimenSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0551), ElementsDictionaryEntry("Specimen Identifier", "SpecimenIdentifier",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0552), ElementsDictionaryEntry("Specimen Description Sequence (Trial)", "SpecimenDescriptionSequenceTrial",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0553), ElementsDictionaryEntry("Specimen Description (Trial)", "SpecimenDescriptionTrial",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0554), ElementsDictionaryEntry("Specimen UID", "SpecimenUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0555), ElementsDictionaryEntry("Acquisition Context Sequence", "AcquisitionContextSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0556), ElementsDictionaryEntry("Acquisition Context Description", "AcquisitionContextDescription",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x059a), ElementsDictionaryEntry("Specimen Type Code Sequence", "SpecimenTypeCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0560), ElementsDictionaryEntry("Specimen Description Sequence", "SpecimenDescriptionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0562), ElementsDictionaryEntry("Issuer of the Specimen Identifier Sequence", "IssuerOfTheSpecimenIdentifierSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0600), ElementsDictionaryEntry("Specimen Short Description", "SpecimenShortDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0602), ElementsDictionaryEntry("Specimen Detailed Description", "SpecimenDetailedDescription",  "UT", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0610), ElementsDictionaryEntry("Specimen Preparation Sequence", "SpecimenPreparationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0612), ElementsDictionaryEntry("Specimen Preparation Step Content Item Sequence", "SpecimenPreparationStepContentItemSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0620), ElementsDictionaryEntry("Specimen Localization Content Item Sequence", "SpecimenLocalizationContentItemSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x06fa), ElementsDictionaryEntry("Slide Identifier", "SlideIdentifier",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x0710), ElementsDictionaryEntry("Whole Slide Microscopy Image Frame Type Sequence", "WholeSlideMicroscopyImageFrameTypeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x071a), ElementsDictionaryEntry("Image Center Point Coordinates Sequence", "ImageCenterPointCoordinatesSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x072a), ElementsDictionaryEntry("X Offset in Slide Coordinate System", "XOffsetInSlideCoordinateSystem",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x073a), ElementsDictionaryEntry("Y Offset in Slide Coordinate System", "YOffsetInSlideCoordinateSystem",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x074a), ElementsDictionaryEntry("Z Offset in Slide Coordinate System", "ZOffsetInSlideCoordinateSystem",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x08d8), ElementsDictionaryEntry("Pixel Spacing Sequence", "PixelSpacingSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x08da), ElementsDictionaryEntry("Coordinate System Axis Code Sequence", "CoordinateSystemAxisCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x08ea), ElementsDictionaryEntry("Measurement Units Code Sequence", "MeasurementUnitsCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x09f8), ElementsDictionaryEntry("Vital Stain Code Sequence (Trial)", "VitalStainCodeSequenceTrial",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x1001), ElementsDictionaryEntry("Requested Procedure ID", "RequestedProcedureID",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x1002), ElementsDictionaryEntry("Reason for the Requested Procedure", "ReasonForTheRequestedProcedure",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x1003), ElementsDictionaryEntry("Requested Procedure Priority", "RequestedProcedurePriority",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x1004), ElementsDictionaryEntry("Patient Transport Arrangements", "PatientTransportArrangements",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x1005), ElementsDictionaryEntry("Requested Procedure Location", "RequestedProcedureLocation",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x1006), ElementsDictionaryEntry("Placer Order Number / Procedure", "PlacerOrderNumberProcedure",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x1007), ElementsDictionaryEntry("Filler Order Number / Procedure", "FillerOrderNumberProcedure",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x1008), ElementsDictionaryEntry("Confidentiality Code", "ConfidentialityCode",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x1009), ElementsDictionaryEntry("Reporting Priority", "ReportingPriority",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x100a), ElementsDictionaryEntry("Reason for Requested Procedure Code Sequence", "ReasonForRequestedProcedureCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x1010), ElementsDictionaryEntry("Names of Intended Recipients of Results", "NamesOfIntendedRecipientsOfResults",  "PN", "1-n"));
    public_dictionary.emplace(Tag(0x0040, 0x1011), ElementsDictionaryEntry("Intended Recipients of Results Identification Sequence", "IntendedRecipientsOfResultsIdentificationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x1012), ElementsDictionaryEntry("Reason For Performed Procedure Code Sequence", "ReasonForPerformedProcedureCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x1060), ElementsDictionaryEntry("Requested Procedure Description (Trial)", "RequestedProcedureDescriptionTrial",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x1101), ElementsDictionaryEntry("Person Identification Code Sequence", "PersonIdentificationCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x1102), ElementsDictionaryEntry("Person's Address", "PersonAddress",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x1103), ElementsDictionaryEntry("Person's Telephone Numbers", "PersonTelephoneNumbers",  "LO", "1-n"));
    public_dictionary.emplace(Tag(0x0040, 0x1104), ElementsDictionaryEntry("Person's Telecom Information", "PersonTelecomInformation",  "LT", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x1400), ElementsDictionaryEntry("Requested Procedure Comments", "RequestedProcedureComments",  "LT", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x2001), ElementsDictionaryEntry("Reason for the Imaging Service Request", "ReasonForTheImagingServiceRequest",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x2004), ElementsDictionaryEntry("Issue Date of Imaging Service Request", "IssueDateOfImagingServiceRequest",  "DA", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x2005), ElementsDictionaryEntry("Issue Time of Imaging Service Request", "IssueTimeOfImagingServiceRequest",  "TM", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x2006), ElementsDictionaryEntry("Placer Order Number / Imaging Service Request (Retired)", "PlacerOrderNumberImagingServiceRequestRetired",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x2007), ElementsDictionaryEntry("Filler Order Number / Imaging Service Request (Retired)", "FillerOrderNumberImagingServiceRequestRetired",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x2008), ElementsDictionaryEntry("Order Entered By", "OrderEnteredBy",  "PN", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x2009), ElementsDictionaryEntry("Order Enterer's Location", "OrderEntererLocation",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x2010), ElementsDictionaryEntry("Order Callback Phone Number", "OrderCallbackPhoneNumber",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x2011), ElementsDictionaryEntry("Order Callback Telecom Information", "OrderCallbackTelecomInformation",  "LT", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x2016), ElementsDictionaryEntry("Placer Order Number / Imaging Service Request", "PlacerOrderNumberImagingServiceRequest",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x2017), ElementsDictionaryEntry("Filler Order Number / Imaging Service Request", "FillerOrderNumberImagingServiceRequest",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x2400), ElementsDictionaryEntry("Imaging Service Request Comments", "ImagingServiceRequestComments",  "LT", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x3001), ElementsDictionaryEntry("Confidentiality Constraint on Patient Data Description", "ConfidentialityConstraintOnPatientDataDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4001), ElementsDictionaryEntry("General Purpose Scheduled Procedure Step Status", "GeneralPurposeScheduledProcedureStepStatus",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4002), ElementsDictionaryEntry("General Purpose Performed Procedure Step Status", "GeneralPurposePerformedProcedureStepStatus",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4003), ElementsDictionaryEntry("General Purpose Scheduled Procedure Step Priority", "GeneralPurposeScheduledProcedureStepPriority",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4004), ElementsDictionaryEntry("Scheduled Processing Applications Code Sequence", "ScheduledProcessingApplicationsCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4005), ElementsDictionaryEntry("Scheduled Procedure Step Start DateTime", "ScheduledProcedureStepStartDateTime",  "DT", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4006), ElementsDictionaryEntry("Multiple Copies Flag", "MultipleCopiesFlag",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4007), ElementsDictionaryEntry("Performed Processing Applications Code Sequence", "PerformedProcessingApplicationsCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4008), ElementsDictionaryEntry("Scheduled Procedure Step Expiration DateTime", "ScheduledProcedureStepExpirationDateTime",  "DT", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4009), ElementsDictionaryEntry("Human Performer Code Sequence", "HumanPerformerCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4010), ElementsDictionaryEntry("Scheduled Procedure Step Modification DateTime", "ScheduledProcedureStepModificationDateTime",  "DT", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4011), ElementsDictionaryEntry("Expected Completion DateTime", "ExpectedCompletionDateTime",  "DT", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4015), ElementsDictionaryEntry("Resulting General Purpose Performed Procedure Steps Sequence", "ResultingGeneralPurposePerformedProcedureStepsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4016), ElementsDictionaryEntry("Referenced General Purpose Scheduled Procedure Step Sequence", "ReferencedGeneralPurposeScheduledProcedureStepSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4018), ElementsDictionaryEntry("Scheduled Workitem Code Sequence", "ScheduledWorkitemCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4019), ElementsDictionaryEntry("Performed Workitem Code Sequence", "PerformedWorkitemCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4020), ElementsDictionaryEntry("Input Availability Flag", "InputAvailabilityFlag",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4021), ElementsDictionaryEntry("Input Information Sequence", "InputInformationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4022), ElementsDictionaryEntry("Relevant Information Sequence", "RelevantInformationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4023), ElementsDictionaryEntry("Referenced General Purpose Scheduled Procedure Step Transaction UID", "ReferencedGeneralPurposeScheduledProcedureStepTransactionUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4025), ElementsDictionaryEntry("Scheduled Station Name Code Sequence", "ScheduledStationNameCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4026), ElementsDictionaryEntry("Scheduled Station Class Code Sequence", "ScheduledStationClassCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4027), ElementsDictionaryEntry("Scheduled Station Geographic Location Code Sequence", "ScheduledStationGeographicLocationCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4028), ElementsDictionaryEntry("Performed Station Name Code Sequence", "PerformedStationNameCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4029), ElementsDictionaryEntry("Performed Station Class Code Sequence", "PerformedStationClassCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4030), ElementsDictionaryEntry("Performed Station Geographic Location Code Sequence", "PerformedStationGeographicLocationCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4031), ElementsDictionaryEntry("Requested Subsequent Workitem Code Sequence", "RequestedSubsequentWorkitemCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4032), ElementsDictionaryEntry("Non-DICOM Output Code Sequence", "NonDICOMOutputCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4033), ElementsDictionaryEntry("Output Information Sequence", "OutputInformationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4034), ElementsDictionaryEntry("Scheduled Human Performers Sequence", "ScheduledHumanPerformersSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4035), ElementsDictionaryEntry("Actual Human Performers Sequence", "ActualHumanPerformersSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4036), ElementsDictionaryEntry("Human Performer's Organization", "HumanPerformerOrganization",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4037), ElementsDictionaryEntry("Human Performer's Name", "HumanPerformerName",  "PN", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4040), ElementsDictionaryEntry("Raw Data Handling", "RawDataHandling",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4041), ElementsDictionaryEntry("Input Readiness State", "InputReadinessState",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4050), ElementsDictionaryEntry("Performed Procedure Step Start DateTime", "PerformedProcedureStepStartDateTime",  "DT", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4051), ElementsDictionaryEntry("Performed Procedure Step End DateTime", "PerformedProcedureStepEndDateTime",  "DT", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4052), ElementsDictionaryEntry("Procedure Step Cancellation DateTime", "ProcedureStepCancellationDateTime",  "DT", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4070), ElementsDictionaryEntry("Output Destination Sequence", "OutputDestinationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4071), ElementsDictionaryEntry("DICOM Storage Sequence", "DICOMStorageSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4072), ElementsDictionaryEntry("STOW-RS Storage Sequence", "STOWRSStorageSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4073), ElementsDictionaryEntry("Storage URL", "StorageURL",  "UR", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x4074), ElementsDictionaryEntry("XDS Storage Sequence", "XDSStorageSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x8302), ElementsDictionaryEntry("Entrance Dose in mGy", "EntranceDoseInmGy",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x8303), ElementsDictionaryEntry("Entrance Dose Derivation", "EntranceDoseDerivation",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x9092), ElementsDictionaryEntry("Parametric Map Frame Type Sequence", "ParametricMapFrameTypeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x9094), ElementsDictionaryEntry("Referenced Image Real World Value Mapping Sequence", "ReferencedImageRealWorldValueMappingSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x9096), ElementsDictionaryEntry("Real World Value Mapping Sequence", "RealWorldValueMappingSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x9098), ElementsDictionaryEntry("Pixel Value Mapping Code Sequence", "PixelValueMappingCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x9210), ElementsDictionaryEntry("LUT Label", "LUTLabel",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x9211), ElementsDictionaryEntry("Real World Value Last Value Mapped", "RealWorldValueLastValueMapped",  "US or SS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x9212), ElementsDictionaryEntry("Real World Value LUT Data", "RealWorldValueLUTData",  "FD", "1-n"));
    public_dictionary.emplace(Tag(0x0040, 0x9213), ElementsDictionaryEntry("Double Float Real World Value Last Value Mapped", "DoubleFloatRealWorldValueLastValueMapped",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x9214), ElementsDictionaryEntry("Double Float Real World Value First Value Mapped", "DoubleFloatRealWorldValueFirstValueMapped",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x9216), ElementsDictionaryEntry("Real World Value First Value Mapped", "RealWorldValueFirstValueMapped",  "US or SS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x9220), ElementsDictionaryEntry("Quantity Definition Sequence", "QuantityDefinitionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x9224), ElementsDictionaryEntry("Real World Value Intercept", "RealWorldValueIntercept",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0040, 0x9225), ElementsDictionaryEntry("Real World Value Slope", "RealWorldValueSlope",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa007), ElementsDictionaryEntry("Findings Flag (Trial)", "FindingsFlagTrial",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa010), ElementsDictionaryEntry("Relationship Type", "RelationshipType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa020), ElementsDictionaryEntry("Findings Sequence (Trial)", "FindingsSequenceTrial",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa021), ElementsDictionaryEntry("Findings Group UID (Trial)", "FindingsGroupUIDTrial",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa022), ElementsDictionaryEntry("Referenced Findings Group UID (Trial)", "ReferencedFindingsGroupUIDTrial",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa023), ElementsDictionaryEntry("Findings Group Recording Date (Trial)", "FindingsGroupRecordingDateTrial",  "DA", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa024), ElementsDictionaryEntry("Findings Group Recording Time (Trial)", "FindingsGroupRecordingTimeTrial",  "TM", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa026), ElementsDictionaryEntry("Findings Source Category Code Sequence (Trial)", "FindingsSourceCategoryCodeSequenceTrial",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa027), ElementsDictionaryEntry("Verifying Organization", "VerifyingOrganization",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa028), ElementsDictionaryEntry("Documenting Organization Identifier Code Sequence (Trial)", "DocumentingOrganizationIdentifierCodeSequenceTrial",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa030), ElementsDictionaryEntry("Verification DateTime", "VerificationDateTime",  "DT", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa032), ElementsDictionaryEntry("Observation DateTime", "ObservationDateTime",  "DT", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa033), ElementsDictionaryEntry("Observation Start DateTime", "ObservationStartDateTime",  "DT", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa040), ElementsDictionaryEntry("Value Type", "ValueType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa043), ElementsDictionaryEntry("Concept Name Code Sequence", "ConceptNameCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa047), ElementsDictionaryEntry("Measurement Precision Description (Trial)", "MeasurementPrecisionDescriptionTrial",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa050), ElementsDictionaryEntry("Continuity Of Content", "ContinuityOfContent",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa057), ElementsDictionaryEntry("Urgency or Priority Alerts (Trial)", "UrgencyOrPriorityAlertsTrial",  "CS", "1-n"));
    public_dictionary.emplace(Tag(0x0040, 0xa060), ElementsDictionaryEntry("Sequencing Indicator (Trial)", "SequencingIndicatorTrial",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa066), ElementsDictionaryEntry("Document Identifier Code Sequence (Trial)", "DocumentIdentifierCodeSequenceTrial",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa067), ElementsDictionaryEntry("Document Author (Trial)", "DocumentAuthorTrial",  "PN", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa068), ElementsDictionaryEntry("Document Author Identifier Code Sequence (Trial)", "DocumentAuthorIdentifierCodeSequenceTrial",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa070), ElementsDictionaryEntry("Identifier Code Sequence (Trial)", "IdentifierCodeSequenceTrial",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa073), ElementsDictionaryEntry("Verifying Observer Sequence", "VerifyingObserverSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa074), ElementsDictionaryEntry("Object Binary Identifier (Trial)", "ObjectBinaryIdentifierTrial",  "OB", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa075), ElementsDictionaryEntry("Verifying Observer Name", "VerifyingObserverName",  "PN", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa076), ElementsDictionaryEntry("Documenting Observer Identifier Code Sequence (Trial)", "DocumentingObserverIdentifierCodeSequenceTrial",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa078), ElementsDictionaryEntry("Author Observer Sequence", "AuthorObserverSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa07a), ElementsDictionaryEntry("Participant Sequence", "ParticipantSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa07c), ElementsDictionaryEntry("Custodial Organization Sequence", "CustodialOrganizationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa080), ElementsDictionaryEntry("Participation Type", "ParticipationType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa082), ElementsDictionaryEntry("Participation DateTime", "ParticipationDateTime",  "DT", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa084), ElementsDictionaryEntry("Observer Type", "ObserverType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa085), ElementsDictionaryEntry("Procedure Identifier Code Sequence (Trial)", "ProcedureIdentifierCodeSequenceTrial",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa088), ElementsDictionaryEntry("Verifying Observer Identification Code Sequence", "VerifyingObserverIdentificationCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa089), ElementsDictionaryEntry("Object Directory Binary Identifier (Trial)", "ObjectDirectoryBinaryIdentifierTrial",  "OB", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa090), ElementsDictionaryEntry("Equivalent CDA Document Sequence", "EquivalentCDADocumentSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa0b0), ElementsDictionaryEntry("Referenced Waveform Channels", "ReferencedWaveformChannels",  "US", "2-2n"));
    public_dictionary.emplace(Tag(0x0040, 0xa110), ElementsDictionaryEntry("Date of Document or Verbal Transaction (Trial)", "DateOfDocumentOrVerbalTransactionTrial",  "DA", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa112), ElementsDictionaryEntry("Time of Document Creation or Verbal Transaction (Trial)", "TimeOfDocumentCreationOrVerbalTransactionTrial",  "TM", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa120), ElementsDictionaryEntry("DateTime", "DateTime",  "DT", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa121), ElementsDictionaryEntry("Date", "Date",  "DA", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa122), ElementsDictionaryEntry("Time", "Time",  "TM", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa123), ElementsDictionaryEntry("Person Name", "PersonName",  "PN", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa124), ElementsDictionaryEntry("UID", "UID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa125), ElementsDictionaryEntry("Report Status ID (Trial)", "ReportStatusIDTrial",  "CS", "2"));
    public_dictionary.emplace(Tag(0x0040, 0xa130), ElementsDictionaryEntry("Temporal Range Type", "TemporalRangeType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa132), ElementsDictionaryEntry("Referenced Sample Positions", "ReferencedSamplePositions",  "UL", "1-n"));
    public_dictionary.emplace(Tag(0x0040, 0xa136), ElementsDictionaryEntry("Referenced Frame Numbers", "ReferencedFrameNumbers",  "US", "1-n"));
    public_dictionary.emplace(Tag(0x0040, 0xa138), ElementsDictionaryEntry("Referenced Time Offsets", "ReferencedTimeOffsets",  "DS", "1-n"));
    public_dictionary.emplace(Tag(0x0040, 0xa13a), ElementsDictionaryEntry("Referenced DateTime", "ReferencedDateTime",  "DT", "1-n"));
    public_dictionary.emplace(Tag(0x0040, 0xa160), ElementsDictionaryEntry("Text Value", "TextValue",  "UT", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa161), ElementsDictionaryEntry("Floating Point Value", "FloatingPointValue",  "FD", "1-n"));
    public_dictionary.emplace(Tag(0x0040, 0xa162), ElementsDictionaryEntry("Rational Numerator Value", "RationalNumeratorValue",  "SL", "1-n"));
    public_dictionary.emplace(Tag(0x0040, 0xa163), ElementsDictionaryEntry("Rational Denominator Value", "RationalDenominatorValue",  "UL", "1-n"));
    public_dictionary.emplace(Tag(0x0040, 0xa167), ElementsDictionaryEntry("Observation Category Code Sequence (Trial)", "ObservationCategoryCodeSequenceTrial",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa168), ElementsDictionaryEntry("Concept Code Sequence", "ConceptCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa16a), ElementsDictionaryEntry("Bibliographic Citation (Trial)", "BibliographicCitationTrial",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa170), ElementsDictionaryEntry("Purpose of Reference Code Sequence", "PurposeOfReferenceCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa171), ElementsDictionaryEntry("Observation UID", "ObservationUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa172), ElementsDictionaryEntry("Referenced Observation UID (Trial)", "ReferencedObservationUIDTrial",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa173), ElementsDictionaryEntry("Referenced Observation Class (Trial)", "ReferencedObservationClassTrial",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa174), ElementsDictionaryEntry("Referenced Object Observation Class (Trial)", "ReferencedObjectObservationClassTrial",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa180), ElementsDictionaryEntry("Annotation Group Number", "AnnotationGroupNumber",  "US", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa192), ElementsDictionaryEntry("Observation Date (Trial)", "ObservationDateTrial",  "DA", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa193), ElementsDictionaryEntry("Observation Time (Trial)", "ObservationTimeTrial",  "TM", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa194), ElementsDictionaryEntry("Measurement Automation (Trial)", "MeasurementAutomationTrial",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa195), ElementsDictionaryEntry("Modifier Code Sequence", "ModifierCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa224), ElementsDictionaryEntry("Identification Description (Trial)", "IdentificationDescriptionTrial",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa290), ElementsDictionaryEntry("Coordinates Set Geometric Type (Trial)", "CoordinatesSetGeometricTypeTrial",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa296), ElementsDictionaryEntry("Algorithm Code Sequence (Trial)", "AlgorithmCodeSequenceTrial",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa297), ElementsDictionaryEntry("Algorithm Description (Trial)", "AlgorithmDescriptionTrial",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa29a), ElementsDictionaryEntry("Pixel Coordinates Set (Trial)", "PixelCoordinatesSetTrial",  "SL", "2-2n"));
    public_dictionary.emplace(Tag(0x0040, 0xa300), ElementsDictionaryEntry("Measured Value Sequence", "MeasuredValueSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa301), ElementsDictionaryEntry("Numeric Value Qualifier Code Sequence", "NumericValueQualifierCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa307), ElementsDictionaryEntry("Current Observer (Trial)", "CurrentObserverTrial",  "PN", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa30a), ElementsDictionaryEntry("Numeric Value", "NumericValue",  "DS", "1-n"));
    public_dictionary.emplace(Tag(0x0040, 0xa313), ElementsDictionaryEntry("Referenced Accession Sequence (Trial)", "ReferencedAccessionSequenceTrial",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa33a), ElementsDictionaryEntry("Report Status Comment (Trial)", "ReportStatusCommentTrial",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa340), ElementsDictionaryEntry("Procedure Context Sequence (Trial)", "ProcedureContextSequenceTrial",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa352), ElementsDictionaryEntry("Verbal Source (Trial)", "VerbalSourceTrial",  "PN", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa353), ElementsDictionaryEntry("Address (Trial)", "AddressTrial",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa354), ElementsDictionaryEntry("Telephone Number (Trial)", "TelephoneNumberTrial",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa358), ElementsDictionaryEntry("Verbal Source Identifier Code Sequence (Trial)", "VerbalSourceIdentifierCodeSequenceTrial",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa360), ElementsDictionaryEntry("Predecessor Documents Sequence", "PredecessorDocumentsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa370), ElementsDictionaryEntry("Referenced Request Sequence", "ReferencedRequestSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa372), ElementsDictionaryEntry("Performed Procedure Code Sequence", "PerformedProcedureCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa375), ElementsDictionaryEntry("Current Requested Procedure Evidence Sequence", "CurrentRequestedProcedureEvidenceSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa380), ElementsDictionaryEntry("Report Detail Sequence (Trial)", "ReportDetailSequenceTrial",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa385), ElementsDictionaryEntry("Pertinent Other Evidence Sequence", "PertinentOtherEvidenceSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa390), ElementsDictionaryEntry("HL7 Structured Document Reference Sequence", "HL7StructuredDocumentReferenceSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa402), ElementsDictionaryEntry("Observation Subject UID (Trial)", "ObservationSubjectUIDTrial",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa403), ElementsDictionaryEntry("Observation Subject Class (Trial)", "ObservationSubjectClassTrial",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa404), ElementsDictionaryEntry("Observation Subject Type Code Sequence (Trial)", "ObservationSubjectTypeCodeSequenceTrial",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa491), ElementsDictionaryEntry("Completion Flag", "CompletionFlag",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa492), ElementsDictionaryEntry("Completion Flag Description", "CompletionFlagDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa493), ElementsDictionaryEntry("Verification Flag", "VerificationFlag",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa494), ElementsDictionaryEntry("Archive Requested", "ArchiveRequested",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa496), ElementsDictionaryEntry("Preliminary Flag", "PreliminaryFlag",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa504), ElementsDictionaryEntry("Content Template Sequence", "ContentTemplateSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa525), ElementsDictionaryEntry("Identical Documents Sequence", "IdenticalDocumentsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa600), ElementsDictionaryEntry("Observation Subject Context Flag (Trial)", "ObservationSubjectContextFlagTrial",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa601), ElementsDictionaryEntry("Observer Context Flag (Trial)", "ObserverContextFlagTrial",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa603), ElementsDictionaryEntry("Procedure Context Flag (Trial)", "ProcedureContextFlagTrial",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa730), ElementsDictionaryEntry("Content Sequence", "ContentSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa731), ElementsDictionaryEntry("Relationship Sequence (Trial)", "RelationshipSequenceTrial",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa732), ElementsDictionaryEntry("Relationship Type Code Sequence (Trial)", "RelationshipTypeCodeSequenceTrial",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa744), ElementsDictionaryEntry("Language Code Sequence (Trial)", "LanguageCodeSequenceTrial",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa801), ElementsDictionaryEntry("Tabulated Values Sequence", "TabulatedValuesSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa802), ElementsDictionaryEntry("Number of Table Rows", "NumberOfTableRows",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa803), ElementsDictionaryEntry("Number of Table Columns", "NumberOfTableColumns",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa804), ElementsDictionaryEntry("Table Row Number", "TableRowNumber",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa805), ElementsDictionaryEntry("Table Column Number", "TableColumnNumber",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa806), ElementsDictionaryEntry("Table Row Definition Sequence", "TableRowDefinitionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa807), ElementsDictionaryEntry("Table Column Definition Sequence", "TableColumnDefinitionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa808), ElementsDictionaryEntry("Cell Values Sequence", "CellValuesSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xa992), ElementsDictionaryEntry("Uniform Resource Locator (Trial)", "UniformResourceLocatorTrial",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xb020), ElementsDictionaryEntry("Waveform Annotation Sequence", "WaveformAnnotationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xdb00), ElementsDictionaryEntry("Template Identifier", "TemplateIdentifier",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xdb06), ElementsDictionaryEntry("Template Version", "TemplateVersion",  "DT", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xdb07), ElementsDictionaryEntry("Template Local Version", "TemplateLocalVersion",  "DT", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xdb0b), ElementsDictionaryEntry("Template Extension Flag", "TemplateExtensionFlag",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xdb0c), ElementsDictionaryEntry("Template Extension Organization UID", "TemplateExtensionOrganizationUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xdb0d), ElementsDictionaryEntry("Template Extension Creator UID", "TemplateExtensionCreatorUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xdb73), ElementsDictionaryEntry("Referenced Content Item Identifier", "ReferencedContentItemIdentifier",  "UL", "1-n"));
    public_dictionary.emplace(Tag(0x0040, 0xe001), ElementsDictionaryEntry("HL7 Instance Identifier", "HL7InstanceIdentifier",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xe004), ElementsDictionaryEntry("HL7 Document Effective Time", "HL7DocumentEffectiveTime",  "DT", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xe006), ElementsDictionaryEntry("HL7 Document Type Code Sequence", "HL7DocumentTypeCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xe008), ElementsDictionaryEntry("Document Class Code Sequence", "DocumentClassCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xe010), ElementsDictionaryEntry("Retrieve URI", "RetrieveURI",  "UR", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xe011), ElementsDictionaryEntry("Retrieve Location UID", "RetrieveLocationUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xe020), ElementsDictionaryEntry("Type of Instances", "TypeOfInstances",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xe021), ElementsDictionaryEntry("DICOM Retrieval Sequence", "DICOMRetrievalSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xe022), ElementsDictionaryEntry("DICOM Media Retrieval Sequence", "DICOMMediaRetrievalSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xe023), ElementsDictionaryEntry("WADO Retrieval Sequence", "WADORetrievalSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xe024), ElementsDictionaryEntry("XDS Retrieval Sequence", "XDSRetrievalSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xe025), ElementsDictionaryEntry("WADO-RS Retrieval Sequence", "WADORSRetrievalSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xe030), ElementsDictionaryEntry("Repository Unique ID", "RepositoryUniqueID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0040, 0xe031), ElementsDictionaryEntry("Home Community ID", "HomeCommunityID",  "UI", "1"));

    public_tags.emplace("ScheduledStationAETitle", Tag(0x0040, 0x0001));
    public_tags.emplace("ScheduledProcedureStepStartDate", Tag(0x0040, 0x0002));
    public_tags.emplace("ScheduledProcedureStepStartTime", Tag(0x0040, 0x0003));
    public_tags.emplace("ScheduledProcedureStepEndDate", Tag(0x0040, 0x0004));
    public_tags.emplace("ScheduledProcedureStepEndTime", Tag(0x0040, 0x0005));
    public_tags.emplace("ScheduledPerformingPhysicianName", Tag(0x0040, 0x0006));
    public_tags.emplace("ScheduledProcedureStepDescription", Tag(0x0040, 0x0007));
    public_tags.emplace("ScheduledProtocolCodeSequence", Tag(0x0040, 0x0008));
    public_tags.emplace("ScheduledProcedureStepID", Tag(0x0040, 0x0009));
    public_tags.emplace("StageCodeSequence", Tag(0x0040, 0x000a));
    public_tags.emplace("ScheduledPerformingPhysicianIdentificationSequence", Tag(0x0040, 0x000b));
    public_tags.emplace("ScheduledStationName", Tag(0x0040, 0x0010));
    public_tags.emplace("ScheduledProcedureStepLocation", Tag(0x0040, 0x0011));
    public_tags.emplace("PreMedication", Tag(0x0040, 0x0012));
    public_tags.emplace("ScheduledProcedureStepStatus", Tag(0x0040, 0x0020));
    public_tags.emplace("OrderPlacerIdentifierSequence", Tag(0x0040, 0x0026));
    public_tags.emplace("OrderFillerIdentifierSequence", Tag(0x0040, 0x0027));
    public_tags.emplace("LocalNamespaceEntityID", Tag(0x0040, 0x0031));
    public_tags.emplace("UniversalEntityID", Tag(0x0040, 0x0032));
    public_tags.emplace("UniversalEntityIDType", Tag(0x0040, 0x0033));
    public_tags.emplace("IdentifierTypeCode", Tag(0x0040, 0x0035));
    public_tags.emplace("AssigningFacilitySequence", Tag(0x0040, 0x0036));
    public_tags.emplace("AssigningJurisdictionCodeSequence", Tag(0x0040, 0x0039));
    public_tags.emplace("AssigningAgencyOrDepartmentCodeSequence", Tag(0x0040, 0x003a));
    public_tags.emplace("ScheduledProcedureStepSequence", Tag(0x0040, 0x0100));
    public_tags.emplace("ReferencedNonImageCompositeSOPInstanceSequence", Tag(0x0040, 0x0220));
    public_tags.emplace("PerformedStationAETitle", Tag(0x0040, 0x0241));
    public_tags.emplace("PerformedStationName", Tag(0x0040, 0x0242));
    public_tags.emplace("PerformedLocation", Tag(0x0040, 0x0243));
    public_tags.emplace("PerformedProcedureStepStartDate", Tag(0x0040, 0x0244));
    public_tags.emplace("PerformedProcedureStepStartTime", Tag(0x0040, 0x0245));
    public_tags.emplace("PerformedProcedureStepEndDate", Tag(0x0040, 0x0250));
    public_tags.emplace("PerformedProcedureStepEndTime", Tag(0x0040, 0x0251));
    public_tags.emplace("PerformedProcedureStepStatus", Tag(0x0040, 0x0252));
    public_tags.emplace("PerformedProcedureStepID", Tag(0x0040, 0x0253));
    public_tags.emplace("PerformedProcedureStepDescription", Tag(0x0040, 0x0254));
    public_tags.emplace("PerformedProcedureTypeDescription", Tag(0x0040, 0x0255));
    public_tags.emplace("PerformedProtocolCodeSequence", Tag(0x0040, 0x0260));
    public_tags.emplace("PerformedProtocolType", Tag(0x0040, 0x0261));
    public_tags.emplace("ScheduledStepAttributesSequence", Tag(0x0040, 0x0270));
    public_tags.emplace("RequestAttributesSequence", Tag(0x0040, 0x0275));
    public_tags.emplace("CommentsOnThePerformedProcedureStep", Tag(0x0040, 0x0280));
    public_tags.emplace("PerformedProcedureStepDiscontinuationReasonCodeSequence", Tag(0x0040, 0x0281));
    public_tags.emplace("QuantitySequence", Tag(0x0040, 0x0293));
    public_tags.emplace("Quantity", Tag(0x0040, 0x0294));
    public_tags.emplace("MeasuringUnitsSequence", Tag(0x0040, 0x0295));
    public_tags.emplace("BillingItemSequence", Tag(0x0040, 0x0296));
    public_tags.emplace("TotalTimeOfFluoroscopy", Tag(0x0040, 0x0300));
    public_tags.emplace("TotalNumberOfExposures", Tag(0x0040, 0x0301));
    public_tags.emplace("EntranceDose", Tag(0x0040, 0x0302));
    public_tags.emplace("ExposedArea", Tag(0x0040, 0x0303));
    public_tags.emplace("DistanceSourceToEntrance", Tag(0x0040, 0x0306));
    public_tags.emplace("DistanceSourceToSupport", Tag(0x0040, 0x0307));
    public_tags.emplace("ExposureDoseSequence", Tag(0x0040, 0x030e));
    public_tags.emplace("CommentsOnRadiationDose", Tag(0x0040, 0x0310));
    public_tags.emplace("XRayOutput", Tag(0x0040, 0x0312));
    public_tags.emplace("HalfValueLayer", Tag(0x0040, 0x0314));
    public_tags.emplace("OrganDose", Tag(0x0040, 0x0316));
    public_tags.emplace("OrganExposed", Tag(0x0040, 0x0318));
    public_tags.emplace("BillingProcedureStepSequence", Tag(0x0040, 0x0320));
    public_tags.emplace("FilmConsumptionSequence", Tag(0x0040, 0x0321));
    public_tags.emplace("BillingSuppliesAndDevicesSequence", Tag(0x0040, 0x0324));
    public_tags.emplace("ReferencedProcedureStepSequence", Tag(0x0040, 0x0330));
    public_tags.emplace("PerformedSeriesSequence", Tag(0x0040, 0x0340));
    public_tags.emplace("CommentsOnTheScheduledProcedureStep", Tag(0x0040, 0x0400));
    public_tags.emplace("ProtocolContextSequence", Tag(0x0040, 0x0440));
    public_tags.emplace("ContentItemModifierSequence", Tag(0x0040, 0x0441));
    public_tags.emplace("ScheduledSpecimenSequence", Tag(0x0040, 0x0500));
    public_tags.emplace("SpecimenAccessionNumber", Tag(0x0040, 0x050a));
    public_tags.emplace("ContainerIdentifier", Tag(0x0040, 0x0512));
    public_tags.emplace("IssuerOfTheContainerIdentifierSequence", Tag(0x0040, 0x0513));
    public_tags.emplace("AlternateContainerIdentifierSequence", Tag(0x0040, 0x0515));
    public_tags.emplace("ContainerTypeCodeSequence", Tag(0x0040, 0x0518));
    public_tags.emplace("ContainerDescription", Tag(0x0040, 0x051a));
    public_tags.emplace("ContainerComponentSequence", Tag(0x0040, 0x0520));
    public_tags.emplace("SpecimenSequence", Tag(0x0040, 0x0550));
    public_tags.emplace("SpecimenIdentifier", Tag(0x0040, 0x0551));
    public_tags.emplace("SpecimenDescriptionSequenceTrial", Tag(0x0040, 0x0552));
    public_tags.emplace("SpecimenDescriptionTrial", Tag(0x0040, 0x0553));
    public_tags.emplace("SpecimenUID", Tag(0x0040, 0x0554));
    public_tags.emplace("AcquisitionContextSequence", Tag(0x0040, 0x0555));
    public_tags.emplace("AcquisitionContextDescription", Tag(0x0040, 0x0556));
    public_tags.emplace("SpecimenTypeCodeSequence", Tag(0x0040, 0x059a));
    public_tags.emplace("SpecimenDescriptionSequence", Tag(0x0040, 0x0560));
    public_tags.emplace("IssuerOfTheSpecimenIdentifierSequence", Tag(0x0040, 0x0562));
    public_tags.emplace("SpecimenShortDescription", Tag(0x0040, 0x0600));
    public_tags.emplace("SpecimenDetailedDescription", Tag(0x0040, 0x0602));
    public_tags.emplace("SpecimenPreparationSequence", Tag(0x0040, 0x0610));
    public_tags.emplace("SpecimenPreparationStepContentItemSequence", Tag(0x0040, 0x0612));
    public_tags.emplace("SpecimenLocalizationContentItemSequence", Tag(0x0040, 0x0620));
    public_tags.emplace("SlideIdentifier", Tag(0x0040, 0x06fa));
    public_tags.emplace("WholeSlideMicroscopyImageFrameTypeSequence", Tag(0x0040, 0x0710));
    public_tags.emplace("ImageCenterPointCoordinatesSequence", Tag(0x0040, 0x071a));
    public_tags.emplace("XOffsetInSlideCoordinateSystem", Tag(0x0040, 0x072a));
    public_tags.emplace("YOffsetInSlideCoordinateSystem", Tag(0x0040, 0x073a));
    public_tags.emplace("ZOffsetInSlideCoordinateSystem", Tag(0x0040, 0x074a));
    public_tags.emplace("PixelSpacingSequence", Tag(0x0040, 0x08d8));
    public_tags.emplace("CoordinateSystemAxisCodeSequence", Tag(0x0040, 0x08da));
    public_tags.emplace("MeasurementUnitsCodeSequence", Tag(0x0040, 0x08ea));
    public_tags.emplace("VitalStainCodeSequenceTrial", Tag(0x0040, 0x09f8));
    public_tags.emplace("RequestedProcedureID", Tag(0x0040, 0x1001));
    public_tags.emplace("ReasonForTheRequestedProcedure", Tag(0x0040, 0x1002));
    public_tags.emplace("RequestedProcedurePriority", Tag(0x0040, 0x1003));
    public_tags.emplace("PatientTransportArrangements", Tag(0x0040, 0x1004));
    public_tags.emplace("RequestedProcedureLocation", Tag(0x0040, 0x1005));
    public_tags.emplace("PlacerOrderNumberProcedure", Tag(0x0040, 0x1006));
    public_tags.emplace("FillerOrderNumberProcedure", Tag(0x0040, 0x1007));
    public_tags.emplace("ConfidentialityCode", Tag(0x0040, 0x1008));
    public_tags.emplace("ReportingPriority", Tag(0x0040, 0x1009));
    public_tags.emplace("ReasonForRequestedProcedureCodeSequence", Tag(0x0040, 0x100a));
    public_tags.emplace("NamesOfIntendedRecipientsOfResults", Tag(0x0040, 0x1010));
    public_tags.emplace("IntendedRecipientsOfResultsIdentificationSequence", Tag(0x0040, 0x1011));
    public_tags.emplace("ReasonForPerformedProcedureCodeSequence", Tag(0x0040, 0x1012));
    public_tags.emplace("RequestedProcedureDescriptionTrial", Tag(0x0040, 0x1060));
    public_tags.emplace("PersonIdentificationCodeSequence", Tag(0x0040, 0x1101));
    public_tags.emplace("PersonAddress", Tag(0x0040, 0x1102));
    public_tags.emplace("PersonTelephoneNumbers", Tag(0x0040, 0x1103));
    public_tags.emplace("PersonTelecomInformation", Tag(0x0040, 0x1104));
    public_tags.emplace("RequestedProcedureComments", Tag(0x0040, 0x1400));
    public_tags.emplace("ReasonForTheImagingServiceRequest", Tag(0x0040, 0x2001));
    public_tags.emplace("IssueDateOfImagingServiceRequest", Tag(0x0040, 0x2004));
    public_tags.emplace("IssueTimeOfImagingServiceRequest", Tag(0x0040, 0x2005));
    public_tags.emplace("PlacerOrderNumberImagingServiceRequestRetired", Tag(0x0040, 0x2006));
    public_tags.emplace("FillerOrderNumberImagingServiceRequestRetired", Tag(0x0040, 0x2007));
    public_tags.emplace("OrderEnteredBy", Tag(0x0040, 0x2008));
    public_tags.emplace("OrderEntererLocation", Tag(0x0040, 0x2009));
    public_tags.emplace("OrderCallbackPhoneNumber", Tag(0x0040, 0x2010));
    public_tags.emplace("OrderCallbackTelecomInformation", Tag(0x0040, 0x2011));
    public_tags.emplace("PlacerOrderNumberImagingServiceRequest", Tag(0x0040, 0x2016));
    public_tags.emplace("FillerOrderNumberImagingServiceRequest", Tag(0x0040, 0x2017));
    public_tags.emplace("ImagingServiceRequestComments", Tag(0x0040, 0x2400));
    public_tags.emplace("ConfidentialityConstraintOnPatientDataDescription", Tag(0x0040, 0x3001));
    public_tags.emplace("GeneralPurposeScheduledProcedureStepStatus", Tag(0x0040, 0x4001));
    public_tags.emplace("GeneralPurposePerformedProcedureStepStatus", Tag(0x0040, 0x4002));
    public_tags.emplace("GeneralPurposeScheduledProcedureStepPriority", Tag(0x0040, 0x4003));
    public_tags.emplace("ScheduledProcessingApplicationsCodeSequence", Tag(0x0040, 0x4004));
    public_tags.emplace("ScheduledProcedureStepStartDateTime", Tag(0x0040, 0x4005));
    public_tags.emplace("MultipleCopiesFlag", Tag(0x0040, 0x4006));
    public_tags.emplace("PerformedProcessingApplicationsCodeSequence", Tag(0x0040, 0x4007));
    public_tags.emplace("ScheduledProcedureStepExpirationDateTime", Tag(0x0040, 0x4008));
    public_tags.emplace("HumanPerformerCodeSequence", Tag(0x0040, 0x4009));
    public_tags.emplace("ScheduledProcedureStepModificationDateTime", Tag(0x0040, 0x4010));
    public_tags.emplace("ExpectedCompletionDateTime", Tag(0x0040, 0x4011));
    public_tags.emplace("ResultingGeneralPurposePerformedProcedureStepsSequence", Tag(0x0040, 0x4015));
    public_tags.emplace("ReferencedGeneralPurposeScheduledProcedureStepSequence", Tag(0x0040, 0x4016));
    public_tags.emplace("ScheduledWorkitemCodeSequence", Tag(0x0040, 0x4018));
    public_tags.emplace("PerformedWorkitemCodeSequence", Tag(0x0040, 0x4019));
    public_tags.emplace("InputAvailabilityFlag", Tag(0x0040, 0x4020));
    public_tags.emplace("InputInformationSequence", Tag(0x0040, 0x4021));
    public_tags.emplace("RelevantInformationSequence", Tag(0x0040, 0x4022));
    public_tags.emplace("ReferencedGeneralPurposeScheduledProcedureStepTransactionUID", Tag(0x0040, 0x4023));
    public_tags.emplace("ScheduledStationNameCodeSequence", Tag(0x0040, 0x4025));
    public_tags.emplace("ScheduledStationClassCodeSequence", Tag(0x0040, 0x4026));
    public_tags.emplace("ScheduledStationGeographicLocationCodeSequence", Tag(0x0040, 0x4027));
    public_tags.emplace("PerformedStationNameCodeSequence", Tag(0x0040, 0x4028));
    public_tags.emplace("PerformedStationClassCodeSequence", Tag(0x0040, 0x4029));
    public_tags.emplace("PerformedStationGeographicLocationCodeSequence", Tag(0x0040, 0x4030));
    public_tags.emplace("RequestedSubsequentWorkitemCodeSequence", Tag(0x0040, 0x4031));
    public_tags.emplace("NonDICOMOutputCodeSequence", Tag(0x0040, 0x4032));
    public_tags.emplace("OutputInformationSequence", Tag(0x0040, 0x4033));
    public_tags.emplace("ScheduledHumanPerformersSequence", Tag(0x0040, 0x4034));
    public_tags.emplace("ActualHumanPerformersSequence", Tag(0x0040, 0x4035));
    public_tags.emplace("HumanPerformerOrganization", Tag(0x0040, 0x4036));
    public_tags.emplace("HumanPerformerName", Tag(0x0040, 0x4037));
    public_tags.emplace("RawDataHandling", Tag(0x0040, 0x4040));
    public_tags.emplace("InputReadinessState", Tag(0x0040, 0x4041));
    public_tags.emplace("PerformedProcedureStepStartDateTime", Tag(0x0040, 0x4050));
    public_tags.emplace("PerformedProcedureStepEndDateTime", Tag(0x0040, 0x4051));
    public_tags.emplace("ProcedureStepCancellationDateTime", Tag(0x0040, 0x4052));
    public_tags.emplace("OutputDestinationSequence", Tag(0x0040, 0x4070));
    public_tags.emplace("DICOMStorageSequence", Tag(0x0040, 0x4071));
    public_tags.emplace("STOWRSStorageSequence", Tag(0x0040, 0x4072));
    public_tags.emplace("StorageURL", Tag(0x0040, 0x4073));
    public_tags.emplace("XDSStorageSequence", Tag(0x0040, 0x4074));
    public_tags.emplace("EntranceDoseInmGy", Tag(0x0040, 0x8302));
    public_tags.emplace("EntranceDoseDerivation", Tag(0x0040, 0x8303));
    public_tags.emplace("ParametricMapFrameTypeSequence", Tag(0x0040, 0x9092));
    public_tags.emplace("ReferencedImageRealWorldValueMappingSequence", Tag(0x0040, 0x9094));
    public_tags.emplace("RealWorldValueMappingSequence", Tag(0x0040, 0x9096));
    public_tags.emplace("PixelValueMappingCodeSequence", Tag(0x0040, 0x9098));
    public_tags.emplace("LUTLabel", Tag(0x0040, 0x9210));
    public_tags.emplace("RealWorldValueLastValueMapped", Tag(0x0040, 0x9211));
    public_tags.emplace("RealWorldValueLUTData", Tag(0x0040, 0x9212));
    public_tags.emplace("DoubleFloatRealWorldValueLastValueMapped", Tag(0x0040, 0x9213));
    public_tags.emplace("DoubleFloatRealWorldValueFirstValueMapped", Tag(0x0040, 0x9214));
    public_tags.emplace("RealWorldValueFirstValueMapped", Tag(0x0040, 0x9216));
    public_tags.emplace("QuantityDefinitionSequence", Tag(0x0040, 0x9220));
    public_tags.emplace("RealWorldValueIntercept", Tag(0x0040, 0x9224));
    public_tags.emplace("RealWorldValueSlope", Tag(0x0040, 0x9225));
    public_tags.emplace("FindingsFlagTrial", Tag(0x0040, 0xa007));
    public_tags.emplace("RelationshipType", Tag(0x0040, 0xa010));
    public_tags.emplace("FindingsSequenceTrial", Tag(0x0040, 0xa020));
    public_tags.emplace("FindingsGroupUIDTrial", Tag(0x0040, 0xa021));
    public_tags.emplace("ReferencedFindingsGroupUIDTrial", Tag(0x0040, 0xa022));
    public_tags.emplace("FindingsGroupRecordingDateTrial", Tag(0x0040, 0xa023));
    public_tags.emplace("FindingsGroupRecordingTimeTrial", Tag(0x0040, 0xa024));
    public_tags.emplace("FindingsSourceCategoryCodeSequenceTrial", Tag(0x0040, 0xa026));
    public_tags.emplace("VerifyingOrganization", Tag(0x0040, 0xa027));
    public_tags.emplace("DocumentingOrganizationIdentifierCodeSequenceTrial", Tag(0x0040, 0xa028));
    public_tags.emplace("VerificationDateTime", Tag(0x0040, 0xa030));
    public_tags.emplace("ObservationDateTime", Tag(0x0040, 0xa032));
    public_tags.emplace("ObservationStartDateTime", Tag(0x0040, 0xa033));
    public_tags.emplace("ValueType", Tag(0x0040, 0xa040));
    public_tags.emplace("ConceptNameCodeSequence", Tag(0x0040, 0xa043));
    public_tags.emplace("MeasurementPrecisionDescriptionTrial", Tag(0x0040, 0xa047));
    public_tags.emplace("ContinuityOfContent", Tag(0x0040, 0xa050));
    public_tags.emplace("UrgencyOrPriorityAlertsTrial", Tag(0x0040, 0xa057));
    public_tags.emplace("SequencingIndicatorTrial", Tag(0x0040, 0xa060));
    public_tags.emplace("DocumentIdentifierCodeSequenceTrial", Tag(0x0040, 0xa066));
    public_tags.emplace("DocumentAuthorTrial", Tag(0x0040, 0xa067));
    public_tags.emplace("DocumentAuthorIdentifierCodeSequenceTrial", Tag(0x0040, 0xa068));
    public_tags.emplace("IdentifierCodeSequenceTrial", Tag(0x0040, 0xa070));
    public_tags.emplace("VerifyingObserverSequence", Tag(0x0040, 0xa073));
    public_tags.emplace("ObjectBinaryIdentifierTrial", Tag(0x0040, 0xa074));
    public_tags.emplace("VerifyingObserverName", Tag(0x0040, 0xa075));
    public_tags.emplace("DocumentingObserverIdentifierCodeSequenceTrial", Tag(0x0040, 0xa076));
    public_tags.emplace("AuthorObserverSequence", Tag(0x0040, 0xa078));
    public_tags.emplace("ParticipantSequence", Tag(0x0040, 0xa07a));
    public_tags.emplace("CustodialOrganizationSequence", Tag(0x0040, 0xa07c));
    public_tags.emplace("ParticipationType", Tag(0x0040, 0xa080));
    public_tags.emplace("ParticipationDateTime", Tag(0x0040, 0xa082));
    public_tags.emplace("ObserverType", Tag(0x0040, 0xa084));
    public_tags.emplace("ProcedureIdentifierCodeSequenceTrial", Tag(0x0040, 0xa085));
    public_tags.emplace("VerifyingObserverIdentificationCodeSequence", Tag(0x0040, 0xa088));
    public_tags.emplace("ObjectDirectoryBinaryIdentifierTrial", Tag(0x0040, 0xa089));
    public_tags.emplace("EquivalentCDADocumentSequence", Tag(0x0040, 0xa090));
    public_tags.emplace("ReferencedWaveformChannels", Tag(0x0040, 0xa0b0));
    public_tags.emplace("DateOfDocumentOrVerbalTransactionTrial", Tag(0x0040, 0xa110));
    public_tags.emplace("TimeOfDocumentCreationOrVerbalTransactionTrial", Tag(0x0040, 0xa112));
    public_tags.emplace("DateTime", Tag(0x0040, 0xa120));
    public_tags.emplace("Date", Tag(0x0040, 0xa121));
    public_tags.emplace("Time", Tag(0x0040, 0xa122));
    public_tags.emplace("PersonName", Tag(0x0040, 0xa123));
    public_tags.emplace("UID", Tag(0x0040, 0xa124));
    public_tags.emplace("ReportStatusIDTrial", Tag(0x0040, 0xa125));
    public_tags.emplace("TemporalRangeType", Tag(0x0040, 0xa130));
    public_tags.emplace("ReferencedSamplePositions", Tag(0x0040, 0xa132));
    public_tags.emplace("ReferencedFrameNumbers", Tag(0x0040, 0xa136));
    public_tags.emplace("ReferencedTimeOffsets", Tag(0x0040, 0xa138));
    public_tags.emplace("ReferencedDateTime", Tag(0x0040, 0xa13a));
    public_tags.emplace("TextValue", Tag(0x0040, 0xa160));
    public_tags.emplace("FloatingPointValue", Tag(0x0040, 0xa161));
    public_tags.emplace("RationalNumeratorValue", Tag(0x0040, 0xa162));
    public_tags.emplace("RationalDenominatorValue", Tag(0x0040, 0xa163));
    public_tags.emplace("ObservationCategoryCodeSequenceTrial", Tag(0x0040, 0xa167));
    public_tags.emplace("ConceptCodeSequence", Tag(0x0040, 0xa168));
    public_tags.emplace("BibliographicCitationTrial", Tag(0x0040, 0xa16a));
    public_tags.emplace("PurposeOfReferenceCodeSequence", Tag(0x0040, 0xa170));
    public_tags.emplace("ObservationUID", Tag(0x0040, 0xa171));
    public_tags.emplace("ReferencedObservationUIDTrial", Tag(0x0040, 0xa172));
    public_tags.emplace("ReferencedObservationClassTrial", Tag(0x0040, 0xa173));
    public_tags.emplace("ReferencedObjectObservationClassTrial", Tag(0x0040, 0xa174));
    public_tags.emplace("AnnotationGroupNumber", Tag(0x0040, 0xa180));
    public_tags.emplace("ObservationDateTrial", Tag(0x0040, 0xa192));
    public_tags.emplace("ObservationTimeTrial", Tag(0x0040, 0xa193));
    public_tags.emplace("MeasurementAutomationTrial", Tag(0x0040, 0xa194));
    public_tags.emplace("ModifierCodeSequence", Tag(0x0040, 0xa195));
    public_tags.emplace("IdentificationDescriptionTrial", Tag(0x0040, 0xa224));
    public_tags.emplace("CoordinatesSetGeometricTypeTrial", Tag(0x0040, 0xa290));
    public_tags.emplace("AlgorithmCodeSequenceTrial", Tag(0x0040, 0xa296));
    public_tags.emplace("AlgorithmDescriptionTrial", Tag(0x0040, 0xa297));
    public_tags.emplace("PixelCoordinatesSetTrial", Tag(0x0040, 0xa29a));
    public_tags.emplace("MeasuredValueSequence", Tag(0x0040, 0xa300));
    public_tags.emplace("NumericValueQualifierCodeSequence", Tag(0x0040, 0xa301));
    public_tags.emplace("CurrentObserverTrial", Tag(0x0040, 0xa307));
    public_tags.emplace("NumericValue", Tag(0x0040, 0xa30a));
    public_tags.emplace("ReferencedAccessionSequenceTrial", Tag(0x0040, 0xa313));
    public_tags.emplace("ReportStatusCommentTrial", Tag(0x0040, 0xa33a));
    public_tags.emplace("ProcedureContextSequenceTrial", Tag(0x0040, 0xa340));
    public_tags.emplace("VerbalSourceTrial", Tag(0x0040, 0xa352));
    public_tags.emplace("AddressTrial", Tag(0x0040, 0xa353));
    public_tags.emplace("TelephoneNumberTrial", Tag(0x0040, 0xa354));
    public_tags.emplace("VerbalSourceIdentifierCodeSequenceTrial", Tag(0x0040, 0xa358));
    public_tags.emplace("PredecessorDocumentsSequence", Tag(0x0040, 0xa360));
    public_tags.emplace("ReferencedRequestSequence", Tag(0x0040, 0xa370));
    public_tags.emplace("PerformedProcedureCodeSequence", Tag(0x0040, 0xa372));
    public_tags.emplace("CurrentRequestedProcedureEvidenceSequence", Tag(0x0040, 0xa375));
    public_tags.emplace("ReportDetailSequenceTrial", Tag(0x0040, 0xa380));
    public_tags.emplace("PertinentOtherEvidenceSequence", Tag(0x0040, 0xa385));
    public_tags.emplace("HL7StructuredDocumentReferenceSequence", Tag(0x0040, 0xa390));
    public_tags.emplace("ObservationSubjectUIDTrial", Tag(0x0040, 0xa402));
    public_tags.emplace("ObservationSubjectClassTrial", Tag(0x0040, 0xa403));
    public_tags.emplace("ObservationSubjectTypeCodeSequenceTrial", Tag(0x0040, 0xa404));
    public_tags.emplace("CompletionFlag", Tag(0x0040, 0xa491));
    public_tags.emplace("CompletionFlagDescription", Tag(0x0040, 0xa492));
    public_tags.emplace("VerificationFlag", Tag(0x0040, 0xa493));
    public_tags.emplace("ArchiveRequested", Tag(0x0040, 0xa494));
    public_tags.emplace("PreliminaryFlag", Tag(0x0040, 0xa496));
    public_tags.emplace("ContentTemplateSequence", Tag(0x0040, 0xa504));
    public_tags.emplace("IdenticalDocumentsSequence", Tag(0x0040, 0xa525));
    public_tags.emplace("ObservationSubjectContextFlagTrial", Tag(0x0040, 0xa600));
    public_tags.emplace("ObserverContextFlagTrial", Tag(0x0040, 0xa601));
    public_tags.emplace("ProcedureContextFlagTrial", Tag(0x0040, 0xa603));
    public_tags.emplace("ContentSequence", Tag(0x0040, 0xa730));
    public_tags.emplace("RelationshipSequenceTrial", Tag(0x0040, 0xa731));
    public_tags.emplace("RelationshipTypeCodeSequenceTrial", Tag(0x0040, 0xa732));
    public_tags.emplace("LanguageCodeSequenceTrial", Tag(0x0040, 0xa744));
    public_tags.emplace("TabulatedValuesSequence", Tag(0x0040, 0xa801));
    public_tags.emplace("NumberOfTableRows", Tag(0x0040, 0xa802));
    public_tags.emplace("NumberOfTableColumns", Tag(0x0040, 0xa803));
    public_tags.emplace("TableRowNumber", Tag(0x0040, 0xa804));
    public_tags.emplace("TableColumnNumber", Tag(0x0040, 0xa805));
    public_tags.emplace("TableRowDefinitionSequence", Tag(0x0040, 0xa806));
    public_tags.emplace("TableColumnDefinitionSequence", Tag(0x0040, 0xa807));
    public_tags.emplace("CellValuesSequence", Tag(0x0040, 0xa808));
    public_tags.emplace("UniformResourceLocatorTrial", Tag(0x0040, 0xa992));
    public_tags.emplace("WaveformAnnotationSequence", Tag(0x0040, 0xb020));
    public_tags.emplace("TemplateIdentifier", Tag(0x0040, 0xdb00));
    public_tags.emplace("TemplateVersion", Tag(0x0040, 0xdb06));
    public_tags.emplace("TemplateLocalVersion", Tag(0x0040, 0xdb07));
    public_tags.emplace("TemplateExtensionFlag", Tag(0x0040, 0xdb0b));
    public_tags.emplace("TemplateExtensionOrganizationUID", Tag(0x0040, 0xdb0c));
    public_tags.emplace("TemplateExtensionCreatorUID", Tag(0x0040, 0xdb0d));
    public_tags.emplace("ReferencedContentItemIdentifier", Tag(0x0040, 0xdb73));
    public_tags.emplace("HL7InstanceIdentifier", Tag(0x0040, 0xe001));
    public_tags.emplace("HL7DocumentEffectiveTime", Tag(0x0040, 0xe004));
    public_tags.emplace("HL7DocumentTypeCodeSequence", Tag(0x0040, 0xe006));
    public_tags.emplace("DocumentClassCodeSequence", Tag(0x0040, 0xe008));
    public_tags.emplace("RetrieveURI", Tag(0x0040, 0xe010));
    public_tags.emplace("RetrieveLocationUID", Tag(0x0040, 0xe011));
    public_tags.emplace("TypeOfInstances", Tag(0x0040, 0xe020));
    public_tags.emplace("DICOMRetrievalSequence", Tag(0x0040, 0xe021));
    public_tags.emplace("DICOMMediaRetrievalSequence", Tag(0x0040, 0xe022));
    public_tags.emplace("WADORetrievalSequence", Tag(0x0040, 0xe023));
    public_tags.emplace("XDSRetrievalSequence", Tag(0x0040, 0xe024));
    public_tags.emplace("WADORSRetrievalSequence", Tag(0x0040, 0xe025));
    public_tags.emplace("RepositoryUniqueID", Tag(0x0040, 0xe030));
    public_tags.emplace("HomeCommunityID", Tag(0x0040, 0xe031));
}

}

}