/*
 * ECDH Test data automatically generated from
 * http://csrc.nist.gov/groups/STM/cavp/documents/components/ecccdhtestvectors.zip
 * KAS_ECC_CDH_PrimitiveTest.txt
 */
/* [P-192] */
/* COUNT = 0 */
static const uint8_t nist_kas_ecc_cdh_testvector_1_public_x[] = {
/* QCAVSx */
	0x42, 0xea, 0x6d, 0xd9, 0x96, 0x9d, 0xd2, 0xa6, 0x1f, 0xea, 0x1a, 0xac,
	0x7f, 0x8e, 0x98, 0xed, 0xcc, 0x89, 0x6c, 0x6e, 0x55, 0x85, 0x7c, 0xc0
};
static const uint8_t nist_kas_ecc_cdh_testvector_1_public_y[] = {
/* QCAVSy */
	0xdf, 0xbe, 0x5d, 0x7c, 0x61, 0xfa, 0xc8, 0x8b, 0x11, 0x81, 0x1b, 0xde,
	0x32, 0x8e, 0x8a, 0x0d, 0x12, 0xbf, 0x01, 0xa9, 0xd2, 0x04, 0xb5, 0x23
};
static const uint8_t nist_kas_ecc_cdh_testvector_1_private[] = {
/* dIUT */
	0xf1, 0x7d, 0x3f, 0xea, 0x36, 0x7b, 0x74, 0xd3, 0x40, 0x85, 0x1c, 0xa4,
	0x27, 0x0d, 0xcb, 0x24, 0xc2, 0x71, 0xf4, 0x45, 0xbe, 0xd9, 0xd5, 0x27
};
/* QIUTx = b15053401f57285637ec324c1cd2139e3a67de3739234b37 */
/* QIUTy = f269c158637482aad644cd692dd1d3ef2c8a7c49e389f7f6 */
static const uint8_t nist_kas_ecc_cdh_testvector_1_out[] = {
/* ZIUT */
	0x80, 0x3d, 0x8a, 0xb2, 0xe5, 0xb6, 0xe6, 0xfc, 0xa7, 0x15, 0x73, 0x7c,
	0x3a, 0x82, 0xf7, 0xce, 0x3c, 0x78, 0x31, 0x24, 0xf6, 0xd5, 0x1c, 0xd0
};
/* COUNT = 1 */
static const uint8_t nist_kas_ecc_cdh_testvector_2_public_x[] = {
/* QCAVSx */
	0xde, 0xb5, 0x71, 0x2f, 0xa0, 0x27, 0xac, 0x8d, 0x2f, 0x22, 0xc4, 0x55,
	0xcc, 0xb7, 0x3a, 0x91, 0xe1, 0x7b, 0x65, 0x12, 0xb5, 0xe0, 0x30, 0xe7
};
static const uint8_t nist_kas_ecc_cdh_testvector_2_public_y[] = {
/* QCAVSy */
	0x7e, 0x26, 0x90, 0xa0, 0x2c, 0xc9, 0xb2, 0x87, 0x08, 0x43, 0x1a, 0x29,
	0xfb, 0x54, 0xb8, 0x7b, 0x1f, 0x0c, 0x14, 0xe0, 0x11, 0xac, 0x21, 0x25
};
static const uint8_t nist_kas_ecc_cdh_testvector_2_private[] = {
/* dIUT */
	0x56, 0xe8, 0x53, 0x34, 0x9d, 0x96, 0xfe, 0x4c, 0x44, 0x24, 0x48, 0xda,
	0xcb, 0x7c, 0xf9, 0x2b, 0xb7, 0xa9, 0x5d, 0xcf, 0x57, 0x4a, 0x9b, 0xd5
};
/* QIUTx = c00d435716ffea53fd8c162792414c37665187e582716539 */
/* QIUTy = ab711c62aa71a5a18e8a3c48f89dc6fa52fac0108e52a8a0 */
static const uint8_t nist_kas_ecc_cdh_testvector_2_out[] = {
/* ZIUT */
	0xc2, 0x08, 0x84, 0x75, 0x68, 0xb9, 0x88, 0x35, 0xd7, 0x31, 0x2c, 0xef,
	0x1f, 0x97, 0xf7, 0xaa, 0x29, 0x82, 0x83, 0x15, 0x23, 0x13, 0xc2, 0x9d
};
/* COUNT = 2 */
static const uint8_t nist_kas_ecc_cdh_testvector_3_public_x[] = {
/* QCAVSx */
	0x4e, 0xda, 0xa8, 0xef, 0xc5, 0xa0, 0xf4, 0x0f, 0x84, 0x36, 0x63, 0xec,
	0x58, 0x15, 0xe7, 0x76, 0x2d, 0xdd, 0xc0, 0x08, 0xe6, 0x63, 0xc2, 0x0f
};
static const uint8_t nist_kas_ecc_cdh_testvector_3_public_y[] = {
/* QCAVSy */
	0x0a, 0x9f, 0x8d, 0xc6, 0x7a, 0x3e, 0x60, 0xef, 0x6d, 0x64, 0xb5, 0x22,
	0x18, 0x5d, 0x03, 0xdf, 0x1f, 0xc0, 0xad, 0xfd, 0x42, 0x47, 0x82, 0x79
};
static const uint8_t nist_kas_ecc_cdh_testvector_3_private[] = {
/* dIUT */
	0xc6, 0xef, 0x61, 0xfe, 0x12, 0xe8, 0x0b, 0xf5, 0x6f, 0x2d, 0x3f, 0x7d,
	0x0b, 0xb7, 0x57, 0x39, 0x45, 0x19, 0x90, 0x6d, 0x55, 0x50, 0x09, 0x49
};
/* QIUTx = e184bc182482f3403c8787b83842477467fcd011db0f6c64 */
/* QIUTy = f9d1c14142f40de8639db97d51a63d2cce1007ccf773cdcb */
static const uint8_t nist_kas_ecc_cdh_testvector_3_out[] = {
/* ZIUT */
	0x87, 0x22, 0x91, 0x07, 0x04, 0x7a, 0x3b, 0x61, 0x19, 0x20, 0xd6, 0xe3,
	0xb2, 0xc0, 0xc8, 0x9b, 0xea, 0x4f, 0x49, 0x41, 0x22, 0x60, 0xb8, 0xdd
};
/* COUNT = 3 */
static const uint8_t nist_kas_ecc_cdh_testvector_4_public_x[] = {
/* QCAVSx */
	0x88, 0x87, 0xc2, 0x76, 0xed, 0xee, 0xd3, 0xe9, 0xe8, 0x66, 0xb4, 0x6d,
	0x58, 0xd8, 0x95, 0xc7, 0x3f, 0xbd, 0x80, 0xb6, 0x3e, 0x38, 0x2e, 0x88
};
static const uint8_t nist_kas_ecc_cdh_testvector_4_public_y[] = {
/* QCAVSy */
	0x04, 0xc5, 0x09, 0x7b, 0xa6, 0x64, 0x5e, 0x16, 0x20, 0x6c, 0xfb, 0x70,
	0xf7, 0x05, 0x26, 0x55, 0x94, 0x7d, 0xd4, 0x4a, 0x17, 0xf1, 0xf9, 0xd5
};
static const uint8_t nist_kas_ecc_cdh_testvector_4_private[] = {
/* dIUT */
	0xe6, 0x74, 0x7b, 0x9c, 0x23, 0xba, 0x70, 0x44, 0xf3, 0x8f, 0xf7, 0xe6,
	0x2c, 0x35, 0xe4, 0x03, 0x89, 0x20, 0xf5, 0xa0, 0x16, 0x3d, 0x3c, 0xda
};
/* QIUTx = 2b838dbe73735f37a39a78d3195783d26991e86ff4d92d1a */
/* QIUTy = 60d344942274489f98903b2e7f93f8d197fc9ae60a0ed53a */
static const uint8_t nist_kas_ecc_cdh_testvector_4_out[] = {
/* ZIUT */
	0xee, 0xc0, 0xbe, 0xd8, 0xfc, 0x55, 0xe1, 0xfe, 0xdd, 0xc8, 0x21, 0x58,
	0xfd, 0x6d, 0xc0, 0xd4, 0x8a, 0x4d, 0x79, 0x6a, 0xaf, 0x47, 0xd4, 0x6c
};
/* COUNT = 4 */
static const uint8_t nist_kas_ecc_cdh_testvector_5_public_x[] = {
/* QCAVSx */
	0x0d, 0x04, 0x5f, 0x30, 0x25, 0x4a, 0xdc, 0x1f, 0xce, 0xfa, 0x8a, 0x5b,
	0x1f, 0x31, 0xbf, 0x4e, 0x73, 0x9d, 0xd3, 0x27, 0xcd, 0x18, 0xd5, 0x94
};
static const uint8_t nist_kas_ecc_cdh_testvector_5_public_y[] = {
/* QCAVSy */
	0x54, 0x2c, 0x31, 0x4e, 0x41, 0x42, 0x7c, 0x08, 0x27, 0x8a, 0x08, 0xce,
	0x8d, 0x73, 0x05, 0xf3, 0xb5, 0xb8, 0x49, 0xc7, 0x2d, 0x8a, 0xff, 0x73
};
static const uint8_t nist_kas_ecc_cdh_testvector_5_private[] = {
/* dIUT */
	0xbe, 0xab, 0xed, 0xd0, 0x15, 0x4a, 0x1a, 0xfc, 0xfc, 0x85, 0xd5, 0x21,
	0x81, 0xc1, 0x0f, 0x5e, 0xb4, 0x7a, 0xdc, 0x51, 0xf6, 0x55, 0x04, 0x7d
};
/* QIUTx = 1f65cf6e8978e1c1bc10bb61a7db311de310088c8cf9768b */
/* QIUTy = f7d438168e7f42ab14b16af53a7a2f646ff40b53d74cbcc7 */
static const uint8_t nist_kas_ecc_cdh_testvector_5_out[] = {
/* ZIUT */
	0x71, 0x6e, 0x74, 0x3b, 0x1b, 0x37, 0xa2, 0xcd, 0x84, 0x79, 0xf0, 0xa3,
	0xd5, 0xa7, 0x4c, 0x10, 0xba, 0x25, 0x99, 0xbe, 0x18, 0xd7, 0xe2, 0xf4
};
/* COUNT = 5 */
static const uint8_t nist_kas_ecc_cdh_testvector_6_public_x[] = {
/* QCAVSx */
	0xfb, 0x35, 0xca, 0x20, 0xd2, 0xe9, 0x66, 0x65, 0xc5, 0x1b, 0x98, 0xe8,
	0xf6, 0xeb, 0x3d, 0x79, 0x11, 0x35, 0x08, 0xd8, 0xbc, 0xcd, 0x45, 0x16
};
static const uint8_t nist_kas_ecc_cdh_testvector_6_public_y[] = {
/* QCAVSy */
	0x36, 0x8e, 0xec, 0x0d, 0x5b, 0xfb, 0x84, 0x77, 0x21, 0xdf, 0x6a, 0xaf,
	0xf0, 0xe5, 0xd4, 0x8c, 0x44, 0x4f, 0x74, 0xbf, 0x9c, 0xd8, 0xa5, 0xa7
};
static const uint8_t nist_kas_ecc_cdh_testvector_6_private[] = {
/* dIUT */
	0xcf, 0x70, 0x35, 0x42, 0x26, 0x66, 0x73, 0x21, 0xd6, 0xe2, 0xba, 0xf4,
	0x09, 0x99, 0xe2, 0xfd, 0x74, 0xc7, 0xa0, 0xf7, 0x93, 0xfa, 0x86, 0x99
};
/* QIUTx = 5f4844ffcce61005d24f737db98675e92f7b6543aeb6106c */
/* QIUTy = 5424f598139215d389b6b12b86d58014857f2ddadb540f51 */
static const uint8_t nist_kas_ecc_cdh_testvector_6_out[] = {
/* ZIUT */
	0xf6, 0x70, 0x53, 0xb9, 0x34, 0x45, 0x99, 0x85, 0xa3, 0x15, 0xcb, 0x01,
	0x7b, 0xf0, 0x30, 0x28, 0x91, 0x79, 0x8d, 0x45, 0xd0, 0xe1, 0x95, 0x08
};
/* COUNT = 6 */
static const uint8_t nist_kas_ecc_cdh_testvector_7_public_x[] = {
/* QCAVSx */
	0x82, 0x47, 0x52, 0x96, 0x0c, 0x13, 0x07, 0xe5, 0xf1, 0x3a, 0x83, 0xda,
	0x21, 0xc7, 0x99, 0x8c, 0xa8, 0xb5, 0xb0, 0x0b, 0x95, 0x49, 0xf6, 0xd0
};
static const uint8_t nist_kas_ecc_cdh_testvector_7_public_y[] = {
/* QCAVSy */
	0xbc, 0x52, 0xd9, 0x1e, 0x23, 0x43, 0x63, 0xbc, 0x32, 0xee, 0x0b, 0x67,
	0x78, 0xf2, 0x5c, 0xd8, 0xc1, 0x84, 0x75, 0x10, 0xf4, 0x34, 0x8b, 0x94
};
static const uint8_t nist_kas_ecc_cdh_testvector_7_private[] = {
/* dIUT */
	0xfe, 0x94, 0x25, 0x15, 0x23, 0x7f, 0xff, 0xdd, 0x7b, 0x4e, 0xb5, 0xc6,
	0x49, 0x09, 0xee, 0xe4, 0x85, 0x6a, 0x07, 0x6c, 0xdf, 0x12, 0xba, 0xe2
};
/* QIUTx = e6369df79b207b8b8679f7c869cfc264859d1ab55aa401e8 */
/* QIUTy = 1f99c71f801a30b52f74da6e5e6dbb62ee4c5da1090cc020 */
static const uint8_t nist_kas_ecc_cdh_testvector_7_out[] = {
/* ZIUT */
	0x75, 0x82, 0x29, 0x71, 0x19, 0x3e, 0xdd, 0x47, 0x2b, 0xf3, 0x01, 0x51,
	0xa7, 0x82, 0x61, 0x9c, 0x55, 0xad, 0x0b, 0x27, 0x9c, 0x93, 0x03, 0xdd
};
/* COUNT = 7 */
static const uint8_t nist_kas_ecc_cdh_testvector_8_public_x[] = {
/* QCAVSx */
	0x10, 0xbb, 0x57, 0x02, 0x02, 0x91, 0x14, 0x19, 0x81, 0xf8, 0x33, 0xb4,
	0x74, 0x9e, 0x56, 0x11, 0x03, 0x4b, 0x30, 0x8e, 0x84, 0x01, 0x1d, 0x21
};
static const uint8_t nist_kas_ecc_cdh_testvector_8_public_y[] = {
/* QCAVSy */
	0xe1, 0xca, 0xcd, 0x6b, 0x7b, 0xd1, 0x7e, 0xd8, 0xdd, 0xb5, 0x0b, 0x6a,
	0xee, 0x06, 0x54, 0xc3, 0x5f, 0x2d, 0x0e, 0xdd, 0xc1, 0xcf, 0xfc, 0xf6
};
static const uint8_t nist_kas_ecc_cdh_testvector_8_private[] = {
/* dIUT */
	0x33, 0xfe, 0xd1, 0x04, 0x92, 0xaf, 0xa5, 0xbe, 0xa0, 0x33, 0x3c, 0x0a,
	0xf1, 0x2c, 0xac, 0x94, 0x0c, 0x4d, 0x22, 0x24, 0x55, 0xbc, 0xd0, 0xfe
};
/* QIUTx = ef0b28afc41637d737f42e4c8aaceadc84ba2e0b849ca18c */
/* QIUTy = 57797942e552173bba17f73278e029f42335068bd770ddf2 */
static const uint8_t nist_kas_ecc_cdh_testvector_8_out[] = {
/* ZIUT */
	0x67, 0xcb, 0xa2, 0xcb, 0xb6, 0x9e, 0xe7, 0x8b, 0xf1, 0xab, 0xaf, 0xb0,
	0xe6, 0xfb, 0xe3, 0x3f, 0xa2, 0x09, 0x4c, 0x12, 0x8d, 0x59, 0x65, 0x2d
};
/* COUNT = 8 */
static const uint8_t nist_kas_ecc_cdh_testvector_9_public_x[] = {
/* QCAVSx */
	0x51, 0x92, 0xfc, 0xe4, 0x18, 0x5a, 0x77, 0x58, 0xea, 0x1b, 0xc5, 0x6e,
	0x0e, 0x4f, 0x4e, 0x8b, 0x2d, 0xce, 0x32, 0x34, 0x8d, 0x0d, 0xce, 0xd1
};
static const uint8_t nist_kas_ecc_cdh_testvector_9_public_y[] = {
/* QCAVSy */
	0x20, 0x98, 0x99, 0x81, 0xbe, 0xaa, 0xf0, 0x00, 0x6d, 0x88, 0xa9, 0x6e,
	0x79, 0x71, 0xa2, 0xfa, 0x3a, 0x33, 0xba, 0x46, 0x04, 0x7f, 0xc7, 0xba
};
static const uint8_t nist_kas_ecc_cdh_testvector_9_private[] = {
/* dIUT */
	0xf3, 0x55, 0x7c, 0x5d, 0x70, 0xb4, 0xc7, 0x95, 0x49, 0x60, 0xc3, 0x35,
	0x68, 0x77, 0x6a, 0xdb, 0xe8, 0xe4, 0x36, 0x19, 0xab, 0xe2, 0x6b, 0x13
};
/* QIUTx = d70112c5f0f0844386494ac1ad99dce2214134176ebfb9af */
/* QIUTy = d3c187a038510ab31d459e2b7af1a380dd7576af06267548 */
static const uint8_t nist_kas_ecc_cdh_testvector_9_out[] = {
/* ZIUT */
	0xcf, 0x99, 0xa2, 0x77, 0x0a, 0x38, 0x6c, 0xa0, 0x13, 0x7d, 0x1e, 0xca,
	0x0a, 0x22, 0x6e, 0x48, 0x42, 0x97, 0xac, 0x3c, 0x51, 0x3f, 0x36, 0x31
};
/* COUNT = 9 */
static const uint8_t nist_kas_ecc_cdh_testvector_10_public_x[] = {
/* QCAVSx */
	0x26, 0xd0, 0x19, 0xdb, 0xe2, 0x79, 0xea, 0xd0, 0x1e, 0xed, 0x14, 0x3a,
	0x91, 0x60, 0x1a, 0xda, 0x26, 0xe2, 0xf4, 0x22, 0x25, 0xb1, 0xc6, 0x2b
};
static const uint8_t nist_kas_ecc_cdh_testvector_10_public_y[] = {
/* QCAVSy */
	0x6c, 0xa6, 0x53, 0xf0, 0x82, 0x72, 0xe0, 0x38, 0x6f, 0xc9, 0x42, 0x1f,
	0xbd, 0x58, 0x00, 0x93, 0xd7, 0xae, 0x63, 0x01, 0xbc, 0xa9, 0x44, 0x76
};
static const uint8_t nist_kas_ecc_cdh_testvector_10_private[] = {
/* dIUT */
	0x58, 0x6c, 0xfb, 0xa1, 0xc6, 0xe8, 0x17, 0x66, 0xed, 0x52, 0x82, 0x8f,
	0x17, 0x7b, 0x1b, 0xe1, 0x4e, 0xbb, 0xc5, 0xb8, 0x33, 0x48, 0xc3, 0x11
};
/* QIUTx = 58b3c63e56bec9d696bf9a88df2873738391f76368aa2b49 */
/* QIUTy = 5776773b261faf7ba2fdc4fe43b92c0b1c7a2fd054a43650 */
static const uint8_t nist_kas_ecc_cdh_testvector_10_out[] = {
/* ZIUT */
	0x57, 0x63, 0x31, 0xe2, 0xb4, 0xfb, 0x38, 0xa1, 0x12, 0x81, 0x0e, 0x15,
	0x29, 0x83, 0x4d, 0xe8, 0x30, 0x7f, 0xb0, 0xa0, 0xd2, 0x75, 0x68, 0x77
};
/* COUNT = 10 */
static const uint8_t nist_kas_ecc_cdh_testvector_11_public_x[] = {
/* QCAVSx */
	0x53, 0x9b, 0xc4, 0x0f, 0xe2, 0x0a, 0x0f, 0xb2, 0x67, 0x88, 0x8b, 0x64,
	0x7b, 0x03, 0xea, 0xaf, 0x6e, 0xc2, 0x0c, 0x02, 0xa1, 0xe1, 0xf8, 0xc8
};
static const uint8_t nist_kas_ecc_cdh_testvector_11_public_y[] = {
/* QCAVSy */
	0x69, 0x09, 0x5e, 0x5b, 0xb7, 0xb4, 0xd4, 0x4c, 0x32, 0x78, 0xa7, 0xee,
	0x6b, 0xec, 0xa3, 0x97, 0xc4, 0x52, 0x46, 0xda, 0x9a, 0x34, 0xc8, 0xbe
};
static const uint8_t nist_kas_ecc_cdh_testvector_11_private[] = {
/* dIUT */
	0xca, 0xd8, 0x10, 0x06, 0x03, 0xa4, 0xf6, 0x5b, 0xe0, 0x8d, 0x8f, 0xc8,
	0xa1, 0xb7, 0xe8, 0x84, 0xc5, 0xff, 0x65, 0xde, 0xb3, 0xc9, 0x6d, 0x99
};
/* QIUTx = b7fcc0f52c7a411edbed39e10bf02b6ae0f26614c6b325a2 */
/* QIUTy = 47483b26eb67776de2b93ab7119d5447573739e3d55e72fb */
static const uint8_t nist_kas_ecc_cdh_testvector_11_out[] = {
/* ZIUT */
	0x90, 0x2f, 0x45, 0x01, 0x91, 0x6a, 0x0d, 0xd9, 0x45, 0x55, 0x4c, 0x3a,
	0x37, 0xb3, 0xd7, 0x80, 0xd3, 0x75, 0xa6, 0xda, 0x71, 0x31, 0x97, 0xc4
};
/* COUNT = 11 */
static const uint8_t nist_kas_ecc_cdh_testvector_12_public_x[] = {
/* QCAVSx */
	0x5d, 0x34, 0x3d, 0xdb, 0x96, 0x31, 0x8f, 0xb4, 0x79, 0x4d, 0x10, 0xf6,
	0xc5, 0x73, 0xf9, 0x9f, 0xee, 0x5d, 0x0d, 0x57, 0xb9, 0x96, 0x25, 0x0f
};
static const uint8_t nist_kas_ecc_cdh_testvector_12_public_y[] = {
/* QCAVSy */
	0x99, 0xfb, 0xdf, 0x9d, 0x97, 0xdd, 0x88, 0xad, 0x41, 0x02, 0x35, 0xda,
	0xc3, 0x6e, 0x5b, 0x92, 0xce, 0x28, 0x24, 0xb8, 0xe5, 0x87, 0xa8, 0x2c
};
static const uint8_t nist_kas_ecc_cdh_testvector_12_private[] = {
/* dIUT */
	0x1e, 0xdd, 0x87, 0x9c, 0xc5, 0xc7, 0x96, 0x19, 0xca, 0xe6, 0xc7, 0x3a,
	0x69, 0x1b, 0xd5, 0xa0, 0x39, 0x5c, 0x0e, 0xf3, 0xb3, 0x56, 0xfc, 0xd2
};
/* QIUTx = 6ce6adb2c30808f590048c33dffad4524ebf7a5fd39b747b */
/* QIUTy = 4966bd2f3d00569b4d4c0409fbd7a2db752f6d09bca8c25f */
static const uint8_t nist_kas_ecc_cdh_testvector_12_out[] = {
/* ZIUT */
	0x46, 0xe4, 0xde, 0x33, 0x50, 0x54, 0xd4, 0x29, 0x86, 0x32, 0x18, 0xae,
	0x33, 0x63, 0x6f, 0xc9, 0xb8, 0x9c, 0x62, 0x8b, 0x64, 0xb5, 0x06, 0xc7
};
/* COUNT = 12 */
static const uint8_t nist_kas_ecc_cdh_testvector_13_public_x[] = {
/* QCAVSx */
	0x8d, 0x3d, 0xb9, 0xbd, 0xce, 0x13, 0x7f, 0xfb, 0xfb, 0x89, 0x13, 0x88,
	0xc3, 0x7d, 0xf6, 0xc0, 0xcb, 0xc9, 0x0a, 0xa5, 0xe5, 0x37, 0x62, 0x20
};
static const uint8_t nist_kas_ecc_cdh_testvector_13_public_y[] = {
/* QCAVSy */
	0x13, 0x5d, 0x30, 0xb5, 0xcb, 0x66, 0x0e, 0xef, 0x87, 0x64, 0xff, 0xc7,
	0x44, 0xf1, 0x5c, 0x1b, 0x5d, 0x6d, 0xc0, 0x6b, 0xa4, 0x41, 0x6d, 0x37
};
static const uint8_t nist_kas_ecc_cdh_testvector_13_private[] = {
/* dIUT */
	0x46, 0x0e, 0x45, 0x22, 0x73, 0xfe, 0x18, 0x27, 0x60, 0x21, 0x87, 0xad,
	0x3b, 0xeb, 0xee, 0x65, 0xcb, 0x84, 0x42, 0x3b, 0xb4, 0xf4, 0x75, 0x37
};
/* QIUTx = d1bd3a3efabf4767fe6380bdf0dbf49d52d4cf0cbb89404c */
/* QIUTy = c150c2b4c8b3aa35f765f847e4f7f8fd8704d241a181ee99 */
static const uint8_t nist_kas_ecc_cdh_testvector_13_out[] = {
/* ZIUT */
	0x1b, 0xfe, 0x9e, 0x5a, 0x20, 0xac, 0x7a, 0x38, 0xd8, 0xf6, 0x05, 0xb4,
	0x25, 0xbb, 0x90, 0x30, 0xbe, 0x31, 0xef, 0x97, 0xc1, 0x01, 0xc7, 0x6c
};
/* COUNT = 13 */
static const uint8_t nist_kas_ecc_cdh_testvector_14_public_x[] = {
/* QCAVSx */
	0x9e, 0x0a, 0x69, 0x49, 0x51, 0x9c, 0x7f, 0x5b, 0xe6, 0x8c, 0x04, 0x33,
	0xc5, 0xfd, 0xf1, 0x30, 0x64, 0xaa, 0x13, 0xfb, 0x29, 0x48, 0x3d, 0xc3
};
static const uint8_t nist_kas_ecc_cdh_testvector_14_public_y[] = {
/* QCAVSy */
	0xe1, 0xc8, 0xba, 0x63, 0xe1, 0xf4, 0x71, 0xdb, 0x23, 0x18, 0x5f, 0x50,
	0xd9, 0xc8, 0x71, 0xed, 0xea, 0x21, 0x25, 0x5b, 0x3a, 0x63, 0xb4, 0xb7
};
static const uint8_t nist_kas_ecc_cdh_testvector_14_private[] = {
/* dIUT */
	0xb9, 0x70, 0x36, 0x50, 0x08, 0x45, 0x6f, 0x87, 0x58, 0xec, 0xc5, 0xa3,
	0xb3, 0x3c, 0xf3, 0xae, 0x6a, 0x8d, 0x56, 0x81, 0x07, 0xa5, 0x21, 0x67
};
/* QIUTx = c1b8610c8c63f8d4abda093b9a11a566044bf65c6faa8999 */
/* QIUTy = a5bc4b3ca095382e9738aee95fe9479b17879b3ad5295559 */
static const uint8_t nist_kas_ecc_cdh_testvector_14_out[] = {
/* ZIUT */
	0x0e, 0x8c, 0x49, 0x3a, 0x4a, 0xdc, 0x44, 0x5d, 0xc9, 0x28, 0x8a, 0x3b,
	0x9b, 0x27, 0x25, 0x99, 0x22, 0x40, 0x54, 0x59, 0x2d, 0x72, 0x65, 0xb3
};
/* COUNT = 14 */
static const uint8_t nist_kas_ecc_cdh_testvector_15_public_x[] = {
/* QCAVSx */
	0xbe, 0x08, 0x82, 0x38, 0x90, 0x2e, 0x99, 0x39, 0xb3, 0xd0, 0x54, 0xee,
	0xeb, 0x84, 0x92, 0xda, 0xf4, 0xbd, 0xcf, 0x09, 0xa2, 0xab, 0x77, 0xf1
};
static const uint8_t nist_kas_ecc_cdh_testvector_15_public_y[] = {
/* QCAVSy */
	0x58, 0xd6, 0x74, 0x9a, 0x3a, 0x92, 0x3d, 0xc8, 0x04, 0x40, 0xf2, 0x66,
	0x1f, 0xd3, 0x5b, 0x65, 0x16, 0x17, 0xe6, 0x52, 0x94, 0xb4, 0x63, 0x75
};
static const uint8_t nist_kas_ecc_cdh_testvector_15_private[] = {
/* dIUT */
	0x59, 0xc1, 0x5b, 0x8a, 0x24, 0x64, 0xe4, 0x1d, 0xfe, 0x43, 0x71, 0xc7,
	0xf7, 0xda, 0xdf, 0x47, 0x0a, 0xe4, 0x25, 0x54, 0x4f, 0x81, 0x13, 0xbd
};
/* QIUTx = 1fe776f73567b6ac0b0d6764164de6c5be751ba8d1ff455e */
/* QIUTy = 4c160bf38afb2b71f684261664115ce874553e8b059432d2 */
static const uint8_t nist_kas_ecc_cdh_testvector_15_out[] = {
/* ZIUT */
	0x0f, 0x19, 0x91, 0x08, 0x6b, 0x45, 0x5d, 0xed, 0x6a, 0x1c, 0x41, 0x46,
	0xf7, 0xbf, 0x59, 0xfe, 0x9b, 0x49, 0x5d, 0xe5, 0x66, 0xeb, 0xc6, 0xbf
};
/* COUNT = 15 */
static const uint8_t nist_kas_ecc_cdh_testvector_16_public_x[] = {
/* QCAVSx */
	0xbf, 0x5a, 0xe0, 0x50, 0x25, 0xe1, 0xbe, 0x61, 0x7e, 0x66, 0x6d, 0x87,
	0xa4, 0x16, 0x83, 0x63, 0x87, 0x3d, 0x57, 0x61, 0xb3, 0x76, 0xb5, 0x03
};
static const uint8_t nist_kas_ecc_cdh_testvector_16_public_y[] = {
/* QCAVSy */
	0xe1, 0xe6, 0xe3, 0x8b, 0x37, 0x2b, 0x6b, 0xee, 0x0f, 0xf5, 0xb3, 0x50,
	0x2d, 0x83, 0x73, 0x5e, 0x3b, 0x2c, 0x26, 0x82, 0x5e, 0x4f, 0x0f, 0xcc
};
static const uint8_t nist_kas_ecc_cdh_testvector_16_private[] = {
/* dIUT */
	0xa6, 0xe9, 0xb8, 0x85, 0xc6, 0x6b, 0x95, 0x9d, 0x1f, 0xc2, 0x70, 0x8d,
	0x59, 0x1b, 0x6d, 0x32, 0x28, 0xe4, 0x9e, 0xb9, 0x8f, 0x72, 0x6d, 0x61
};
/* QIUTx = 632bb7651dbf49dde9dd125d13fb234e06617723beed3d1b */
/* QIUTy = f4ad5209638488397c5f44f994dd7479807e79f4887d2e71 */
static const uint8_t nist_kas_ecc_cdh_testvector_16_out[] = {
/* ZIUT */
	0xb3, 0x0f, 0x21, 0x27, 0xc3, 0x4d, 0xf3, 0x5a, 0xaa, 0x91, 0xdb, 0xf0,
	0xbb, 0xe1, 0x57, 0x98, 0xe7, 0x99, 0xa0, 0x3e, 0xd1, 0x16, 0x98, 0xc1
};
/* COUNT = 16 */
static const uint8_t nist_kas_ecc_cdh_testvector_17_public_x[] = {
/* QCAVSx */
	0x6c, 0xc4, 0xfe, 0xed, 0x84, 0xc7, 0xab, 0x0d, 0x09, 0x00, 0x5d, 0x66,
	0x0e, 0xd3, 0x4d, 0xe6, 0x95, 0x5a, 0x94, 0x61, 0xc4, 0x13, 0x8d, 0x11
};
static const uint8_t nist_kas_ecc_cdh_testvector_17_public_y[] = {
/* QCAVSy */
	0x31, 0x22, 0x5f, 0x33, 0x86, 0x4e, 0xd4, 0x8d, 0xa0, 0x6f, 0xa4, 0x5a,
	0x91, 0x3b, 0x46, 0xcf, 0x42, 0x55, 0x77, 0x42, 0xe3, 0x50, 0x85, 0xe6
};
static const uint8_t nist_kas_ecc_cdh_testvector_17_private[] = {
/* dIUT */
	0xbd, 0xb7, 0x54, 0x09, 0x6f, 0xfb, 0xfb, 0xd8, 0xb0, 0xf3, 0xcb, 0x04,
	0x6c, 0xcb, 0x7c, 0xa1, 0x49, 0xc4, 0xe7, 0x19, 0x20, 0x67, 0xa3, 0xee
};
/* QIUTx = d9c098d421d741f6faab116f3e4731d28c5558e19fe112a1 */
/* QIUTy = 38d4dc48ccdb1d3ed8d31fd06784a4f87a68aec1cbd5b08f */
static const uint8_t nist_kas_ecc_cdh_testvector_17_out[] = {
/* ZIUT */
	0x64, 0xa5, 0xc2, 0x46, 0x59, 0x9d, 0x3e, 0x81, 0x77, 0xa2, 0x40, 0x2a,
	0x11, 0x10, 0xeb, 0x81, 0xe6, 0xc4, 0x56, 0xab, 0x4e, 0xdb, 0x51, 0x27
};
/* COUNT = 17 */
static const uint8_t nist_kas_ecc_cdh_testvector_18_public_x[] = {
/* QCAVSx */
	0x36, 0x15, 0x73, 0x15, 0xbe, 0xe7, 0xaf, 0xed, 0xde, 0xd5, 0x8c, 0x4e,
	0x8b, 0xa1, 0x4d, 0x34, 0x21, 0xc4, 0x01, 0xe5, 0x11, 0x35, 0xbc, 0xc9
};
static const uint8_t nist_kas_ecc_cdh_testvector_18_public_y[] = {
/* QCAVSy */
	0x37, 0xc2, 0x97, 0xca, 0x70, 0x3f, 0x77, 0xc5, 0x2b, 0xb0, 0x62, 0xd8,
	0xce, 0x97, 0x1d, 0xb8, 0x40, 0x97, 0xba, 0x0c, 0x75, 0x3a, 0x41, 0x8f
};
static const uint8_t nist_kas_ecc_cdh_testvector_18_private[] = {
/* dIUT */
	0xd5, 0xbc, 0xf2, 0x53, 0x4d, 0xaf, 0xc3, 0xd9, 0x99, 0x64, 0xc7, 0xbd,
	0x63, 0xab, 0x7b, 0xd1, 0x59, 0x99, 0xfe, 0x56, 0xdd, 0x96, 0x9c, 0x42
};
/* QIUTx = fda1d5d28d6fe0e7909d6a8bafa7824db5572ab92ffe7de6 */
/* QIUTy = 134a297c1d9c8bbab249abacd951ed11e5a99f92e7991572 */
static const uint8_t nist_kas_ecc_cdh_testvector_18_out[] = {
/* ZIUT */
	0x01, 0x7b, 0x8c, 0xa5, 0x3c, 0x82, 0xfa, 0xb1, 0x63, 0xda, 0x2a, 0xb7,
	0x83, 0x96, 0x6a, 0x39, 0xe0, 0x61, 0xb3, 0x2c, 0x8c, 0xfa, 0x33, 0x4d
};
/* COUNT = 18 */
static const uint8_t nist_kas_ecc_cdh_testvector_19_public_x[] = {
/* QCAVSx */
	0x98, 0x46, 0x4d, 0x47, 0xf0, 0x25, 0x6f, 0x82, 0x92, 0xe0, 0x27, 0xe8,
	0xc9, 0x25, 0x82, 0xea, 0x77, 0xcf, 0x90, 0x51, 0xf5, 0xce, 0x8e, 0x5d
};
static const uint8_t nist_kas_ecc_cdh_testvector_19_public_y[] = {
/* QCAVSy */
	0x44, 0x95, 0x52, 0xef, 0x75, 0x78, 0xbe, 0x96, 0x23, 0x6f, 0xe5, 0xed,
	0x9d, 0x06, 0x43, 0xc0, 0xbb, 0x6c, 0x5a, 0x91, 0x34, 0xb0, 0x10, 0x8d
};
static const uint8_t nist_kas_ecc_cdh_testvector_19_private[] = {
/* dIUT */
	0x43, 0xd4, 0xb9, 0xdf, 0x10, 0x53, 0xbe, 0x5b, 0x42, 0x68, 0x10, 0x4c,
	0x02, 0x24, 0x4d, 0x3b, 0xf9, 0x59, 0x4b, 0x01, 0x0b, 0x46, 0xa8, 0xb2
};
/* QIUTx = c3020b7091463d788f1f1d76f7cfeec82ecdb3b7d99c345c */
/* QIUTy = 9a7710d5179591d8f3df0aa122301768ae7db7eee2d7f583 */
static const uint8_t nist_kas_ecc_cdh_testvector_19_out[] = {
/* ZIUT */
	0x34, 0x0e, 0xf3, 0xdb, 0x3d, 0xbe, 0xbd, 0xd9, 0x1c, 0x62, 0xc3, 0xd4,
	0xe1, 0xa3, 0xda, 0x2c, 0x7c, 0x52, 0xa3, 0x33, 0x8b, 0x86, 0x52, 0x59
};
/* COUNT = 19 */
static const uint8_t nist_kas_ecc_cdh_testvector_20_public_x[] = {
/* QCAVSx */
	0x56, 0x3e, 0xb6, 0x6c, 0x33, 0x4c, 0xf6, 0xf1, 0x23, 0xbf, 0x04, 0xc7,
	0x80, 0x3b, 0x48, 0xa3, 0x11, 0x02, 0x14, 0x23, 0x7e, 0x98, 0x3b, 0xf5
};
static const uint8_t nist_kas_ecc_cdh_testvector_20_public_y[] = {
/* QCAVSy */
	0x0f, 0x35, 0x11, 0x04, 0x81, 0x91, 0x99, 0xef, 0x07, 0xc9, 0xa6, 0x05,
	0x1d, 0x20, 0x75, 0x8f, 0x3a, 0xf7, 0x90, 0x27, 0xea, 0x66, 0xa5, 0x3f
};
static const uint8_t nist_kas_ecc_cdh_testvector_20_private[] = {
/* dIUT */
	0x94, 0xca, 0xc2, 0xc2, 0xca, 0x71, 0x47, 0x46, 0x40, 0x16, 0x70, 0xd9,
	0x4e, 0xdb, 0xf3, 0xf6, 0x77, 0x86, 0x7b, 0x5a, 0x03, 0xbe, 0xe7, 0xad
};
/* QIUTx = b18554a2e743ef0aa2f040987c4c451004e096df3d80ddae */
/* QIUTy = 6e3e2c618f896e36ba620077684b70a05ffb79bf5e6c7640 */
static const uint8_t nist_kas_ecc_cdh_testvector_20_out[] = {
/* ZIUT */
	0x21, 0x62, 0x14, 0x49, 0x21, 0xdf, 0x51, 0x03, 0xd0, 0xe6, 0xa6, 0x50,
	0xfb, 0x13, 0xfd, 0x24, 0x6f, 0x47, 0x38, 0xd0, 0x89, 0x6c, 0xe9, 0x2f
};
/* COUNT = 20 */
static const uint8_t nist_kas_ecc_cdh_testvector_21_public_x[] = {
/* QCAVSx */
	0x86, 0x82, 0x8c, 0x4a, 0xc9, 0x2b, 0x55, 0x07, 0x61, 0x8a, 0xec, 0x78,
	0x73, 0xa1, 0xd4, 0xfc, 0x65, 0x43, 0xc5, 0xbe, 0x33, 0xcf, 0x30, 0x78
};
static const uint8_t nist_kas_ecc_cdh_testvector_21_public_y[] = {
/* QCAVSy */
	0xb2, 0x2c, 0xa7, 0x24, 0x37, 0x54, 0x5e, 0x10, 0xd6, 0xd4, 0xf0, 0x52,
	0x42, 0x2e, 0xb8, 0x98, 0xb7, 0x37, 0xa4, 0xb8, 0x54, 0x3e, 0xe5, 0x50
};
static const uint8_t nist_kas_ecc_cdh_testvector_21_private[] = {
/* dIUT */
	0x2a, 0x3a, 0x9e, 0x33, 0xc8, 0xcc, 0x31, 0x07, 0xa9, 0xf9, 0x26, 0x5c,
	0x3b, 0xde, 0xa1, 0x20, 0x65, 0x70, 0xe8, 0x6f, 0x92, 0xac, 0x70, 0x14
};
/* QIUTx = a7ba38be1bc669dd23ccfcee0645b1f0db8cf942deafaeb6 */
/* QIUTy = b82db79d80cd0e37f28d4163adc389dee8fc7797b5c9831b */
static const uint8_t nist_kas_ecc_cdh_testvector_21_out[] = {
/* ZIUT */
	0x4c, 0x69, 0xe7, 0xfe, 0xed, 0x4b, 0x11, 0x15, 0x9a, 0xdf, 0xc1, 0x6a,
	0x60, 0x47, 0xa9, 0x25, 0x72, 0xea, 0x44, 0xe0, 0x74, 0x0b, 0x23, 0xaf
};
/* COUNT = 21 */
static const uint8_t nist_kas_ecc_cdh_testvector_22_public_x[] = {
/* QCAVSx */
	0x67, 0x00, 0xa1, 0x02, 0x43, 0x77, 0x81, 0xa9, 0x58, 0x1d, 0xa2, 0xbc,
	0x25, 0xce, 0xd5, 0xab, 0xf4, 0x19, 0xda, 0x91, 0xd3, 0xc8, 0x03, 0xdf
};
static const uint8_t nist_kas_ecc_cdh_testvector_22_public_y[] = {
/* QCAVSy */
	0x71, 0x39, 0x6c, 0x9c, 0xf0, 0x8b, 0xcd, 0x91, 0x85, 0x4e, 0x3e, 0x6e,
	0x42, 0xd8, 0xc6, 0x57, 0xce, 0x0f, 0x27, 0xab, 0x77, 0xa9, 0xdc, 0x4b
};
static const uint8_t nist_kas_ecc_cdh_testvector_22_private[] = {
/* dIUT */
	0x4a, 0x6b, 0x78, 0xa9, 0x8a, 0xc9, 0x8f, 0xa8, 0xe9, 0x9a, 0x8e, 0xce,
	0x08, 0xec, 0x02, 0x51, 0x12, 0x5f, 0x85, 0xc6, 0xfd, 0x0e, 0x28, 0x9b
};
/* QIUTx = e769dbbcd5ce2d83514b768d3d2d5aa0bcd8f66af15f5500 */
/* QIUTy = 2fc6d0b039e0f28f74fbeffe9e883d4dd72296e4e95cae71 */
static const uint8_t nist_kas_ecc_cdh_testvector_22_out[] = {
/* ZIUT */
	0x46, 0x07, 0x2a, 0xce, 0xfd, 0x67, 0xbf, 0xf5, 0x0d, 0xe3, 0x55, 0xca,
	0x7a, 0x31, 0xfa, 0x6b, 0xe5, 0x9f, 0x26, 0xe4, 0x67, 0x58, 0x72, 0x59
};
/* COUNT = 22 */
static const uint8_t nist_kas_ecc_cdh_testvector_23_public_x[] = {
/* QCAVSx */
	0xa8, 0x2f, 0x35, 0x4c, 0xf9, 0x7b, 0xee, 0x5d, 0x22, 0xdc, 0x6c, 0x07,
	0x9f, 0x29, 0x02, 0xea, 0xd4, 0x4d, 0x96, 0xa8, 0xf6, 0x14, 0xf1, 0x78
};
static const uint8_t nist_kas_ecc_cdh_testvector_23_public_y[] = {
/* QCAVSy */
	0xa6, 0x54, 0xa9, 0xaa, 0x8a, 0x1a, 0x08, 0x02, 0xf2, 0xce, 0x0e, 0xe8,
	0xa0, 0xf4, 0xeb, 0xe9, 0x6d, 0xee, 0x1b, 0x37, 0x46, 0x4b, 0x1f, 0xf2
};
static const uint8_t nist_kas_ecc_cdh_testvector_23_private[] = {
/* dIUT */
	0xc5, 0xa6, 0x49, 0x1d, 0x78, 0x84, 0x4d, 0x66, 0x17, 0xef, 0x33, 0xbe,
	0x6b, 0x8b, 0xd5, 0x4d, 0xa2, 0x21, 0x45, 0x08, 0x85, 0xd5, 0x95, 0x0f
};
/* QIUTx = db1b24f7466bc154e9d7d2c3ca52dcfe0bfc9563c5fdb6f3 */
/* QIUTy = 1c74fbbf5bd99921f1a9a744f8e1cf770bd6a76a772b3003 */
static const uint8_t nist_kas_ecc_cdh_testvector_23_out[] = {
/* ZIUT */
	0xec, 0x55, 0x80, 0xea, 0xbc, 0xa9, 0xf3, 0x38, 0x9d, 0x2b, 0x42, 0x7d,
	0xdf, 0x6e, 0x49, 0xe2, 0x6d, 0x62, 0x9a, 0xfd, 0x03, 0xfa, 0x76, 0x6e
};
/* COUNT = 23 */
static const uint8_t nist_kas_ecc_cdh_testvector_24_public_x[] = {
/* QCAVSx */
	0x3c, 0xec, 0x21, 0xb2, 0x86, 0x68, 0xa1, 0x2a, 0x2c, 0xf7, 0x8e, 0x1a,
	0x8e, 0x55, 0xd0, 0xef, 0xe0, 0x65, 0x15, 0x2f, 0xff, 0xc3, 0x47, 0x18
};
static const uint8_t nist_kas_ecc_cdh_testvector_24_public_y[] = {
/* QCAVSy */
	0x10, 0x29, 0x55, 0x7b, 0xeb, 0xa4, 0xff, 0x19, 0x92, 0xbd, 0x21, 0xc2,
	0x3c, 0xb4, 0x82, 0x5f, 0x6d, 0xae, 0x70, 0xe3, 0x31, 0x8f, 0xd1, 0xca
};
static const uint8_t nist_kas_ecc_cdh_testvector_24_private[] = {
/* dIUT */
	0x2b, 0xa2, 0x70, 0x3c, 0x5e, 0x23, 0xf6, 0x46, 0x3c, 0x5b, 0x88, 0xdc,
	0x37, 0x29, 0x2f, 0xab, 0xd3, 0x39, 0x9b, 0x5e, 0x1f, 0xb6, 0x7c, 0x05
};
/* QIUTx = 7543148906cef9b37a71a7c08363cdd3bba50142d65241aa */
/* QIUTy = 8b3a6973de8dc271e27c1ead1e962fdaae3710c724daac38 */
static const uint8_t nist_kas_ecc_cdh_testvector_24_out[] = {
/* ZIUT */
	0x7f, 0x39, 0x29, 0xdd, 0x3c, 0xbf, 0x76, 0x73, 0xbc, 0x30, 0xd8, 0x59,
	0xd9, 0x0b, 0x88, 0x03, 0x07, 0x47, 0x5f, 0x80, 0x06, 0x60, 0xea, 0x32
};
/* COUNT = 24 */
static const uint8_t nist_kas_ecc_cdh_testvector_25_public_x[] = {
/* QCAVSx */
	0x70, 0x82, 0x64, 0x47, 0x15, 0xb8, 0xb7, 0x31, 0xf8, 0x22, 0x8b, 0x51,
	0x18, 0xe7, 0x27, 0x0d, 0x34, 0xd1, 0x81, 0xf3, 0x61, 0xa2, 0x21, 0xfc
};
static const uint8_t nist_kas_ecc_cdh_testvector_25_public_y[] = {
/* QCAVSy */
	0x46, 0x46, 0x49, 0xd6, 0xc8, 0x8c, 0xa8, 0x96, 0x14, 0x48, 0x8a, 0x1c,
	0xc7, 0xb8, 0x44, 0x2b, 0xb4, 0x2f, 0x9f, 0xb3, 0x02, 0x0a, 0x3d, 0x76
};
static const uint8_t nist_kas_ecc_cdh_testvector_25_private[] = {
/* dIUT */
	0x83, 0x61, 0x18, 0xc6, 0x24, 0x8f, 0x88, 0x2e, 0x91, 0x47, 0x97, 0x6f,
	0x76, 0x48, 0x26, 0xc1, 0xa2, 0x87, 0x55, 0xa6, 0x10, 0x29, 0x77, 0xd5
};
/* QIUTx = fcd345a976c720caaa97de6697226825615e1287a9eff67e */
/* QIUTy = 58ea42edbeeafca9ff44cfd7f29abd2cbde7626d79e422c9 */
static const uint8_t nist_kas_ecc_cdh_testvector_25_out[] = {
/* ZIUT */
	0x72, 0xe8, 0x8f, 0x3e, 0xa6, 0x7d, 0x46, 0xd4, 0x6d, 0xbf, 0x83, 0x92,
	0x6e, 0x7e, 0x2a, 0x6b, 0x85, 0xb5, 0x45, 0x36, 0x74, 0x1e, 0x6d, 0x2c
};
/* [P-224] */
/* COUNT = 0 */
static const uint8_t nist_kas_ecc_cdh_testvector_26_public_x[] = {
/* QCAVSx */
	0xaf, 0x33, 0xcd, 0x06, 0x29, 0xbc, 0x7e, 0x99, 0x63, 0x20, 0xa3, 0xf4,
	0x03, 0x68, 0xf7, 0x4d, 0xe8, 0x70, 0x4f, 0xa3, 0x7b, 0x8f, 0xab, 0x69,
	0xab, 0xaa, 0xe2, 0x80
};
static const uint8_t nist_kas_ecc_cdh_testvector_26_public_y[] = {
/* QCAVSy */
	0x88, 0x20, 0x92, 0xcc, 0xbb, 0xa7, 0x93, 0x0f, 0x41, 0x9a, 0x8a, 0x4f,
	0x9b, 0xb1, 0x69, 0x78, 0xbb, 0xc3, 0x83, 0x87, 0x29, 0x99, 0x25, 0x59,
	0xa6, 0xf2, 0xe2, 0xd7
};
static const uint8_t nist_kas_ecc_cdh_testvector_26_private[] = {
/* dIUT */
	0x83, 0x46, 0xa6, 0x0f, 0xc6, 0xf2, 0x93, 0xca, 0x5a, 0x0d, 0x2a, 0xf6,
	0x8b, 0xa7, 0x1d, 0x1d, 0xd3, 0x89, 0xe5, 0xe4, 0x08, 0x37, 0x94, 0x2d,
	0xf3, 0xe4, 0x3c, 0xbd
};
/* QIUTx = 8de2e26adf72c582d6568ef638c4fd59b18da171bdf501f1d929e048 */
/* QIUTy = 4a68a1c2b0fb22930d120555c1ece50ea98dea8407f71be36efac0de */
static const uint8_t nist_kas_ecc_cdh_testvector_26_out[] = {
/* ZIUT */
	0x7d, 0x96, 0xf9, 0xa3, 0xbd, 0x3c, 0x05, 0xcf, 0x5c, 0xc3, 0x7f, 0xeb,
	0x8b, 0x9d, 0x52, 0x09, 0xd5, 0xc2, 0x59, 0x74, 0x64, 0xde, 0xc3, 0xe9,
	0x98, 0x37, 0x43, 0xe8
};
/* COUNT = 1 */
static const uint8_t nist_kas_ecc_cdh_testvector_27_public_x[] = {
/* QCAVSx */
	0x13, 0xbf, 0xcd, 0x4f, 0x8e, 0x94, 0x42, 0x39, 0x3c, 0xab, 0x8f, 0xb4,
	0x6b, 0x9f, 0x05, 0x66, 0xc2, 0x26, 0xb2, 0x2b, 0x37, 0x07, 0x69, 0x76,
	0xf0, 0x61, 0x7a, 0x46
};
static const uint8_t nist_kas_ecc_cdh_testvector_27_public_y[] = {
/* QCAVSy */
	0xee, 0xb2, 0x42, 0x75, 0x29, 0xb2, 0x88, 0xc6, 0x3c, 0x2f, 0x89, 0x63,
	0xc1, 0xe4, 0x73, 0xdf, 0x2f, 0xca, 0x6c, 0xaa, 0x90, 0xd5, 0x2e, 0x2f,
	0x8d, 0xb5, 0x6d, 0xd4
};
static const uint8_t nist_kas_ecc_cdh_testvector_27_private[] = {
/* dIUT */
	0x04, 0x3c, 0xb2, 0x16, 0xf4, 0xb7, 0x2c, 0xdf, 0x76, 0x29, 0xd6, 0x37,
	0x20, 0xa5, 0x4a, 0xee, 0x0c, 0x99, 0xeb, 0x32, 0xd7, 0x44, 0x77, 0xda,
	0xc0, 0xc2, 0xf7, 0x3d
};
/* QIUTx = 2f90f5c8eac9c7decdbb97b6c2f715ab725e4fe40fe6d746efbf4e1b */
/* QIUTy = 66897351454f927a309b269c5a6d31338be4c19a5acfc32cf656f45c */
static const uint8_t nist_kas_ecc_cdh_testvector_27_out[] = {
/* ZIUT */
	0xee, 0x93, 0xce, 0x06, 0xb8, 0x9f, 0xf7, 0x20, 0x09, 0xe8, 0x58, 0xc6,
	0x8e, 0xb7, 0x08, 0xe7, 0xbc, 0x79, 0xee, 0x03, 0x00, 0xf7, 0x3b, 0xed,
	0x69, 0xbb, 0xca, 0x09
};
/* COUNT = 2 */
static const uint8_t nist_kas_ecc_cdh_testvector_28_public_x[] = {
/* QCAVSx */
	0x75, 0x6d, 0xd8, 0x06, 0xb9, 0xd9, 0xc3, 0x4d, 0x89, 0x96, 0x91, 0xec,
	0xb4, 0x5b, 0x77, 0x1a, 0xf4, 0x68, 0xec, 0x00, 0x44, 0x86, 0xa0, 0xfd,
	0xd2, 0x83, 0x41, 0x1e
};
static const uint8_t nist_kas_ecc_cdh_testvector_28_public_y[] = {
/* QCAVSy */
	0x4d, 0x02, 0xc2, 0xca, 0x61, 0x7b, 0xb2, 0xc5, 0xd9, 0x61, 0x3f, 0x25,
	0xdd, 0x72, 0x41, 0x3d, 0x22, 0x9f, 0xd2, 0x90, 0x15, 0x13, 0xaa, 0x29,
	0x50, 0x4e, 0xee, 0xfb
};
static const uint8_t nist_kas_ecc_cdh_testvector_28_private[] = {
/* dIUT */
	0x5a, 0xd0, 0xdd, 0x6d, 0xba, 0xbb, 0x4f, 0x3c, 0x2e, 0xa5, 0xfe, 0x32,
	0xe5, 0x61, 0xb2, 0xca, 0x55, 0x08, 0x14, 0x86, 0xdf, 0x2c, 0x7c, 0x15,
	0xc9, 0x62, 0x2b, 0x08
};
/* QIUTx = 005bca45d793e7fe99a843704ed838315ab14a5f6277507e9bc37531 */
/* QIUTy = 43e9d421e1486ae5893bfd23c210e5c140d7c6b1ada59d842c9a98de */
static const uint8_t nist_kas_ecc_cdh_testvector_28_out[] = {
/* ZIUT */
	0x3f, 0xcc, 0x01, 0xe3, 0x4d, 0x44, 0x49, 0xda, 0x2a, 0x97, 0x4b, 0x23,
	0xfc, 0x36, 0xf9, 0x56, 0x67, 0x54, 0x25, 0x9d, 0x39, 0x14, 0x97, 0x90,
	0xcf, 0xa1, 0xeb, 0xd3
};
/* COUNT = 3 */
static const uint8_t nist_kas_ecc_cdh_testvector_29_public_x[] = {
/* QCAVSx */
	0x0f, 0x53, 0x7b, 0xf1, 0xc1, 0x12, 0x2c, 0x55, 0x65, 0x6d, 0x25, 0xe8,
	0xaa, 0x84, 0x17, 0xe0, 0xb4, 0x4b, 0x15, 0x26, 0xae, 0x05, 0x23, 0x14,
	0x4f, 0x99, 0x21, 0xc4
};
static const uint8_t nist_kas_ecc_cdh_testvector_29_public_y[] = {
/* QCAVSy */
	0xf7, 0x9b, 0x26, 0xd3, 0x0e, 0x49, 0x1a, 0x77, 0x36, 0x96, 0xcc, 0x2c,
	0x79, 0xb4, 0xf0, 0x59, 0x6b, 0xc5, 0xb9, 0xee, 0xba, 0xf3, 0x94, 0xd1,
	0x62, 0xfb, 0x86, 0x84
};
static const uint8_t nist_kas_ecc_cdh_testvector_29_private[] = {
/* dIUT */
	0x0a, 0xa6, 0xff, 0x55, 0xa5, 0xd8, 0x20, 0xef, 0xcb, 0x4e, 0x7d, 0x10,
	0xb8, 0x45, 0xea, 0x3c, 0x9f, 0x9b, 0xc5, 0xdf, 0xf8, 0x61, 0x06, 0xdb,
	0x85, 0x31, 0x8e, 0x22
};
/* QIUTx = 2f96754131e0968198aa78fbe8c201dc5f3581c792de487340d32448 */
/* QIUTy = 61e8a5cd79615203b6d89e9496f9e236fe3b6be8731e743d615519c6 */
static const uint8_t nist_kas_ecc_cdh_testvector_29_out[] = {
/* ZIUT */
	0x49, 0x12, 0x96, 0x28, 0xb2, 0x3a, 0xfc, 0xef, 0x48, 0x13, 0x9a, 0x3f,
	0x6f, 0x59, 0xff, 0x5e, 0x98, 0x11, 0xaa, 0x74, 0x6a, 0xa4, 0xff, 0x33,
	0xc2, 0x4b, 0xb9, 0x40
};
/* COUNT = 4 */
static const uint8_t nist_kas_ecc_cdh_testvector_30_public_x[] = {
/* QCAVSx */
	0x2b, 0x36, 0x31, 0xd2, 0xb0, 0x61, 0x79, 0xb3, 0x17, 0x4a, 0x10, 0x0f,
	0x7f, 0x57, 0x13, 0x1e, 0xee, 0xa8, 0x94, 0x7b, 0xe0, 0x78, 0x6c, 0x3d,
	0xc6, 0x4b, 0x22, 0x39
};
static const uint8_t nist_kas_ecc_cdh_testvector_30_public_y[] = {
/* QCAVSy */
	0x83, 0xde, 0x29, 0xae, 0x3d, 0xad, 0x31, 0xad, 0xc0, 0x23, 0x6c, 0x6d,
	0xe7, 0xf1, 0x45, 0x61, 0xca, 0x2e, 0xa0, 0x83, 0xc5, 0x27, 0x0c, 0x78,
	0xa2, 0xe6, 0xcb, 0xc0
};
static const uint8_t nist_kas_ecc_cdh_testvector_30_private[] = {
/* dIUT */
	0xef, 0xe6, 0xe6, 0xe2, 0x5a, 0xff, 0xaf, 0x54, 0xc9, 0x8d, 0x00, 0x2a,
	0xbb, 0xc6, 0x32, 0x8d, 0xa1, 0x59, 0x40, 0x5a, 0x1b, 0x75, 0x2e, 0x32,
	0xdc, 0x23, 0x95, 0x0a
};
/* QIUTx = 355e962920bde043695f6bffb4b355c63da6f5de665ed46f2ec817e2 */
/* QIUTy = 748e095368f62e1d364edd461719793b404adbdaacbcadd88922ff37 */
static const uint8_t nist_kas_ecc_cdh_testvector_30_out[] = {
/* ZIUT */
	0xfc, 0xdc, 0x69, 0xa4, 0x05, 0x01, 0xd3, 0x08, 0xa6, 0x83, 0x96, 0x53,
	0xa8, 0xf0, 0x43, 0x09, 0xec, 0x00, 0x23, 0x39, 0x49, 0x52, 0x29, 0x02,
	0xff, 0xa5, 0xea, 0xc6
};
/* COUNT = 5 */
static const uint8_t nist_kas_ecc_cdh_testvector_31_public_x[] = {
/* QCAVSx */
	0x45, 0x11, 0x40, 0x3d, 0xe2, 0x90, 0x59, 0xf6, 0x9a, 0x47, 0x5c, 0x5a,
	0x6a, 0x5f, 0x6c, 0xab, 0xed, 0x5d, 0x9f, 0x01, 0x44, 0x36, 0xa8, 0xcb,
	0x70, 0xa0, 0x23, 0x38
};
static const uint8_t nist_kas_ecc_cdh_testvector_31_public_y[] = {
/* QCAVSy */
	0x7d, 0x2d, 0x1b, 0x62, 0xaa, 0x04, 0x6d, 0xf9, 0x34, 0x0f, 0x9c, 0x37,
	0xa0, 0x87, 0xa0, 0x6b, 0x32, 0xcf, 0x7f, 0x08, 0xa2, 0x23, 0xf9, 0x92,
	0x81, 0x2a, 0x82, 0x8b
};
static const uint8_t nist_kas_ecc_cdh_testvector_31_private[] = {
/* dIUT */
	0x61, 0xcb, 0x29, 0x32, 0x52, 0x40, 0x01, 0xe5, 0xe9, 0xee, 0xed, 0x6d,
	0xf7, 0xd9, 0xc8, 0x93, 0x5e, 0xe3, 0x32, 0x20, 0x29, 0xed, 0xd7, 0xaa,
	0x8a, 0xcb, 0xfd, 0x51
};
/* QIUTx = d50e4adabfd989d7dbc7cf4052546cc7c447a97630436997ad4b9536 */
/* QIUTy = 5bea503473c5eaef9552d42c40b1f2f7ca292733b255b9bbe1b12337 */
static const uint8_t nist_kas_ecc_cdh_testvector_31_out[] = {
/* ZIUT */
	0x82, 0x7e, 0x90, 0x25, 0xcb, 0x62, 0xe0, 0xe8, 0x37, 0xc5, 0x96, 0x06,
	0x3f, 0x3b, 0x9b, 0x5a, 0x0f, 0x7a, 0xfd, 0x8d, 0x87, 0x83, 0x20, 0x00,
	0x86, 0xd6, 0x1e, 0xc1
};
/* COUNT = 6 */
static const uint8_t nist_kas_ecc_cdh_testvector_32_public_x[] = {
/* QCAVSx */
	0x31, 0x4a, 0x0b, 0x26, 0xdd, 0x31, 0xc2, 0x48, 0x84, 0x5d, 0x7c, 0xc1,
	0x7b, 0x61, 0xca, 0xd4, 0x60, 0x82, 0x59, 0xbe, 0xd8, 0x5a, 0x58, 0xd1,
	0xf1, 0xff, 0xd3, 0x78
};
static const uint8_t nist_kas_ecc_cdh_testvector_32_public_y[] = {
/* QCAVSy */
	0x66, 0xe4, 0xb3, 0x50, 0x35, 0x2e, 0x11, 0x9e, 0xec, 0xad, 0xa3, 0x82,
	0x90, 0x7f, 0x36, 0x19, 0xfd, 0x74, 0x8e, 0xa7, 0x3a, 0xe4, 0x89, 0x9d,
	0xfd, 0x49, 0x63, 0x02
};
static const uint8_t nist_kas_ecc_cdh_testvector_32_private[] = {
/* dIUT */
	0x8c, 0x7a, 0xce, 0x34, 0x71, 0x71, 0xf9, 0x2d, 0xef, 0x98, 0xd8, 0x45,
	0x47, 0x5f, 0xc8, 0x2e, 0x1d, 0x14, 0x96, 0xda, 0x81, 0xee, 0x58, 0xf5,
	0x05, 0xb9, 0x85, 0xfa
};
/* QIUTx = b1a8dcac89aca2799320b451df1c7ff4d97567abb68141c0d95fc2aa */
/* QIUTy = 3524950902b1510bdc987d860afc27ad871ceaea66935abd3c0a99a8 */
static const uint8_t nist_kas_ecc_cdh_testvector_32_out[] = {
/* ZIUT */
	0x33, 0x5b, 0xa5, 0x12, 0x28, 0xd9, 0x4a, 0xcb, 0xed, 0x85, 0x1c, 0xa7,
	0x82, 0x1c, 0x80, 0x1d, 0x5c, 0xb1, 0xc7, 0x97, 0x5d, 0x7a, 0xa9, 0x0a,
	0x71, 0x59, 0xf8, 0xfa
};
/* COUNT = 7 */
static const uint8_t nist_kas_ecc_cdh_testvector_33_public_x[] = {
/* QCAVSx */
	0xab, 0xe6, 0x84, 0x3b, 0xee, 0xc2, 0xfd, 0x9e, 0x5f, 0xb6, 0x47, 0x30,
	0xd0, 0xbe, 0x4d, 0x16, 0x54, 0x38, 0xce, 0x92, 0x2e, 0xd7, 0x5d, 0xd8,
	0x0b, 0x46, 0x03, 0xe5
};
static const uint8_t nist_kas_ecc_cdh_testvector_33_public_y[] = {
/* QCAVSy */
	0x6a, 0xfe, 0x86, 0x73, 0xa9, 0x6c, 0x4b, 0xa9, 0x90, 0x0a, 0xd8, 0x59,
	0x95, 0xe6, 0x31, 0xe4, 0x36, 0xc6, 0xcc, 0x88, 0xa2, 0xc2, 0xb4, 0x7b,
	0x7c, 0x48, 0x86, 0xb8
};
static const uint8_t nist_kas_ecc_cdh_testvector_33_private[] = {
/* dIUT */
	0x38, 0x2f, 0xeb, 0x9b, 0x9b, 0xa1, 0x0f, 0x18, 0x9d, 0x99, 0xe7, 0x1a,
	0x89, 0xcd, 0xfe, 0x44, 0xcb, 0x55, 0x4c, 0xec, 0x13, 0xa2, 0x12, 0x84,
	0x09, 0x77, 0xfb, 0x68
};
/* QIUTx = abb6f1e3773ff8fc73aea2a0b107809ce70adcefed6e41fc5cb43045 */
/* QIUTy = a963897ae906c10a055eeadb97ffdd6f748d3e5621e5fff304e48ba7 */
static const uint8_t nist_kas_ecc_cdh_testvector_33_out[] = {
/* ZIUT */
	0x8c, 0x2e, 0x62, 0x75, 0x94, 0x20, 0x6b, 0x34, 0xf7, 0x35, 0x6d, 0x34,
	0x26, 0xeb, 0x3d, 0x79, 0xf5, 0x18, 0xef, 0x84, 0x3f, 0xbe, 0x94, 0x01,
	0x4c, 0xce, 0xac, 0xe3
};
/* COUNT = 8 */
static const uint8_t nist_kas_ecc_cdh_testvector_34_public_x[] = {
/* QCAVSx */
	0x13, 0xcf, 0x9d, 0x6d, 0x2c, 0x9a, 0xae, 0x82, 0x74, 0xc2, 0x7d, 0x44,
	0x6a, 0xfd, 0x0c, 0x88, 0x8f, 0xfd, 0xd5, 0x2a, 0xe2, 0x99, 0xa3, 0x59,
	0x84, 0xd4, 0xf5, 0x27
};
static const uint8_t nist_kas_ecc_cdh_testvector_34_public_y[] = {
/* QCAVSy */
	0xdc, 0xbe, 0xe7, 0x5b, 0x51, 0x57, 0x51, 0xf8, 0xee, 0x2a, 0xe3, 0x55,
	0xe8, 0xaf, 0xd5, 0xde, 0x21, 0xc6, 0x2a, 0x93, 0x9a, 0x65, 0x07, 0xb5,
	0x38, 0xcb, 0xc4, 0xaf
};
static const uint8_t nist_kas_ecc_cdh_testvector_34_private[] = {
/* dIUT */
	0xe0, 0xd6, 0x20, 0x35, 0x10, 0x1e, 0xf4, 0x87, 0xc4, 0x85, 0xc6, 0x0f,
	0xb4, 0x50, 0x0e, 0xeb, 0xe6, 0xa3, 0x2e, 0xc6, 0x4d, 0xbe, 0x97, 0xdb,
	0xe0, 0x23, 0x2c, 0x46
};
/* QIUTx = 88537735e9b23e3e0e076f135a82d33f9bffb465f3abce8322a62a62 */
/* QIUTy = b4c8c123673197875c0bd14ed097606d330fba2b9200ef65a44764d3 */
static const uint8_t nist_kas_ecc_cdh_testvector_34_out[] = {
/* ZIUT */
	0x63, 0x2a, 0xbb, 0x66, 0x27, 0x28, 0xdb, 0xc9, 0x94, 0x50, 0x88, 0x73,
	0xd5, 0xc5, 0x27, 0xca, 0x5e, 0xf9, 0x23, 0xc0, 0xd3, 0x1f, 0xa6, 0xc4,
	0x7e, 0xf4, 0xc8, 0x25
};
/* COUNT = 9 */
static const uint8_t nist_kas_ecc_cdh_testvector_35_public_x[] = {
/* QCAVSx */
	0x96, 0x5b, 0x63, 0x7c, 0x0d, 0xfb, 0xc0, 0xcf, 0x95, 0x40, 0x35, 0x68,
	0x6d, 0x70, 0xf7, 0xec, 0x30, 0x92, 0x9e, 0x66, 0x4e, 0x52, 0x1d, 0xba,
	0xa2, 0x28, 0x06, 0x59
};
static const uint8_t nist_kas_ecc_cdh_testvector_35_public_y[] = {
/* QCAVSy */
	0x82, 0xa5, 0x8f, 0xf6, 0x1b, 0xc9, 0x00, 0x19, 0xbb, 0xcb, 0xb5, 0x87,
	0x5d, 0x38, 0x63, 0xdb, 0x0b, 0xc2, 0xa1, 0xfa, 0x34, 0xb0, 0xad, 0x4d,
	0xe1, 0xa8, 0x3f, 0x99
};
static const uint8_t nist_kas_ecc_cdh_testvector_35_private[] = {
/* dIUT */
	0xb9, 0x6a, 0xde, 0x5b, 0x73, 0xba, 0x72, 0xaa, 0x8b, 0x6e, 0x4d, 0x74,
	0xd7, 0xbf, 0x9c, 0x58, 0xe9, 0x62, 0xff, 0x78, 0xeb, 0x54, 0x22, 0x87,
	0xc7, 0xb4, 0x4b, 0xa2
};
/* QIUTx = 37682926a54f70a4c1748f54d50d5b00138a055f924f2c65e5b0bbe4 */
/* QIUTy = 596afefcdd640d29635015b89bdddd1f8c2723686d332e7a06ca8799 */
static const uint8_t nist_kas_ecc_cdh_testvector_35_out[] = {
/* ZIUT */
	0x34, 0x64, 0x11, 0x41, 0xaa, 0xb0, 0x5e, 0xf5, 0x8b, 0xd3, 0x76, 0xd6,
	0x09, 0x34, 0x59, 0x01, 0xfb, 0x8f, 0x63, 0x47, 0x7c, 0x6b, 0xe9, 0x09,
	0x7f, 0x03, 0x7f, 0x1f
};
/* COUNT = 10 */
static const uint8_t nist_kas_ecc_cdh_testvector_36_public_x[] = {
/* QCAVSx */
	0x73, 0xcc, 0x64, 0x53, 0x72, 0xca, 0x2e, 0x71, 0x63, 0x7c, 0xda, 0x94,
	0x3d, 0x81, 0x48, 0xf3, 0x38, 0x2a, 0xb6, 0xdd, 0x0f, 0x2e, 0x1a, 0x49,
	0xda, 0x94, 0xe1, 0x34
};
static const uint8_t nist_kas_ecc_cdh_testvector_36_public_y[] = {
/* QCAVSy */
	0xdf, 0x5c, 0x35, 0x5c, 0x23, 0xe6, 0xe2, 0x32, 0xeb, 0xc3, 0xbe, 0xe2,
	0xab, 0x18, 0x73, 0xee, 0x0d, 0x83, 0xe3, 0x38, 0x2f, 0x8e, 0x6f, 0xe6,
	0x13, 0xf6, 0x34, 0x3c
};
static const uint8_t nist_kas_ecc_cdh_testvector_36_private[] = {
/* dIUT */
	0xa4, 0x0d, 0x7e, 0x12, 0x04, 0x9c, 0x71, 0xe6, 0x52, 0x2c, 0x7f, 0xf2,
	0x38, 0x42, 0x24, 0x06, 0x1c, 0x3a, 0x45, 0x70, 0x58, 0xb3, 0x10, 0x55,
	0x76, 0x55, 0xb8, 0x54
};
/* QIUTx = 399801243bfe0c2da9b0a53c8ca57f2eee87aaa94a8e4d5e029f42ca */
/* QIUTy = aa49e6d4b47cee7a5c4ab71d5a67da84e0b9b425ce3e70da68c889e7 */
static const uint8_t nist_kas_ecc_cdh_testvector_36_out[] = {
/* ZIUT */
	0x4f, 0x74, 0xac, 0x85, 0x07, 0x50, 0x1a, 0x32, 0xbf, 0xc5, 0xa7, 0x8d,
	0x82, 0x71, 0xc2, 0x00, 0xe8, 0x35, 0x96, 0x6e, 0x18, 0x7e, 0x8d, 0x00,
	0x01, 0x1a, 0x8c, 0x75
};
/* COUNT = 11 */
static const uint8_t nist_kas_ecc_cdh_testvector_37_public_x[] = {
/* QCAVSx */
	0x54, 0x65, 0x78, 0x21, 0x62, 0x50, 0x35, 0x4e, 0x44, 0x9e, 0x21, 0x54,
	0x6d, 0xd1, 0x1c, 0xd1, 0xc5, 0x17, 0x42, 0x36, 0x73, 0x9a, 0xca, 0xd9,
	0xce, 0x0f, 0x45, 0x12
};
static const uint8_t nist_kas_ecc_cdh_testvector_37_public_y[] = {
/* QCAVSy */
	0xd2, 0xa2, 0x2f, 0xcd, 0x66, 0xd1, 0xab, 0xed, 0xc7, 0x67, 0x66, 0x83,
	0x27, 0xc5, 0xcb, 0x9c, 0x59, 0x90, 0x43, 0x27, 0x62, 0x39, 0xcf, 0x3c,
	0x85, 0x16, 0xaf, 0x24
};
static const uint8_t nist_kas_ecc_cdh_testvector_37_private[] = {
/* dIUT */
	0xad, 0x25, 0x19, 0xbc, 0x72, 0x4d, 0x48, 0x4e, 0x02, 0xa6, 0x9f, 0x05,
	0x14, 0x9b, 0xb0, 0x47, 0x71, 0x4b, 0xf0, 0xf5, 0x98, 0x6f, 0xac, 0x2e,
	0x22, 0x2c, 0xd9, 0x46
};
/* QIUTx = df9c1e0ef15e53b9f626e2be1cbe893639c06f3e0439ee95d7d4b1e3 */
/* QIUTy = 7a52a7386adda243efdf8941085c84e31239cab92b8017336748965e */
static const uint8_t nist_kas_ecc_cdh_testvector_37_out[] = {
/* ZIUT */
	0xad, 0x09, 0xc9, 0xae, 0x4d, 0x23, 0x24, 0xea, 0x81, 0xbb, 0x55, 0x5b,
	0x20, 0x0d, 0x3c, 0x00, 0x3e, 0x22, 0xa6, 0x87, 0x0e, 0xe0, 0x3b, 0x52,
	0xdf, 0x49, 0xe4, 0xde
};
/* COUNT = 12 */
static const uint8_t nist_kas_ecc_cdh_testvector_38_public_x[] = {
/* QCAVSx */
	0x1d, 0x46, 0xb1, 0xdc, 0x3a, 0x28, 0x12, 0x3c, 0xb5, 0x13, 0x46, 0xe6,
	0x7b, 0xae, 0xc5, 0x64, 0x04, 0x86, 0x86, 0x78, 0xfa, 0xf7, 0xd0, 0xe8,
	0xb2, 0xaf, 0xa2, 0x2a
};
static const uint8_t nist_kas_ecc_cdh_testvector_38_public_y[] = {
/* QCAVSy */
	0x0e, 0xc9, 0xe6, 0x5e, 0xc9, 0x7e, 0x21, 0x83, 0x73, 0xe7, 0xfc, 0x11,
	0x5c, 0x22, 0x74, 0xd5, 0xb8, 0x29, 0xa6, 0x0d, 0x93, 0xf7, 0x1e, 0x01,
	0xd5, 0x81, 0x36, 0xc3
};
static const uint8_t nist_kas_ecc_cdh_testvector_38_private[] = {
/* dIUT */
	0x3d, 0x31, 0x2a, 0x9b, 0x9d, 0x8e, 0xd0, 0x91, 0x40, 0x90, 0x0b, 0xba,
	0xc1, 0xe0, 0x95, 0x52, 0x7e, 0xbc, 0x9e, 0x3c, 0x64, 0x93, 0xbc, 0xf3,
	0x66, 0x6e, 0x3a, 0x29
};
/* QIUTx = b4a0198dc8810e884425b750928b0c960c31f7a99663400b01a179df */
/* QIUTy = 812b601bfc0738242c6f86f830f27acd632ca618a0b5280c9d5769f7 */
static const uint8_t nist_kas_ecc_cdh_testvector_38_out[] = {
/* ZIUT */
	0xef, 0x02, 0x9c, 0x28, 0xc6, 0x80, 0x64, 0xb8, 0xab, 0xd2, 0x96, 0x5a,
	0x38, 0xc4, 0x04, 0xfb, 0x5e, 0x94, 0x4a, 0xce, 0x57, 0xe8, 0x63, 0x8d,
	0xab, 0xa9, 0xd3, 0xcd
};
/* COUNT = 13 */
static const uint8_t nist_kas_ecc_cdh_testvector_39_public_x[] = {
/* QCAVSx */
	0x26, 0x6d, 0x03, 0x8c, 0xc7, 0xa4, 0xfe, 0x21, 0xf6, 0xc9, 0x76, 0x31,
	0x8e, 0x82, 0x7b, 0x82, 0xbb, 0x5b, 0x8f, 0x74, 0x43, 0xa5, 0x52, 0x98,
	0x13, 0x65, 0x06, 0xe0
};
static const uint8_t nist_kas_ecc_cdh_testvector_39_public_y[] = {
/* QCAVSy */
	0xdf, 0x12, 0x3d, 0x98, 0xa7, 0xa2, 0x0b, 0xbd, 0xf3, 0x94, 0x3d, 0xf2,
	0xe3, 0x56, 0x34, 0x22, 0xf8, 0xc0, 0xcf, 0x74, 0xd5, 0x3a, 0xaa, 0xbd,
	0xd7, 0xc9, 0x73, 0xba
};
static const uint8_t nist_kas_ecc_cdh_testvector_39_private[] = {
/* dIUT */
	0x8c, 0xe0, 0x82, 0x2d, 0xc2, 0x4c, 0x15, 0x39, 0x95, 0x75, 0x5a, 0xc3,
	0x50, 0x73, 0x7e, 0xf5, 0x06, 0x64, 0x1c, 0x7d, 0x75, 0x2b, 0x4f, 0x93,
	0x00, 0xc6, 0x12, 0xed
};
/* QIUTx = 00dfc7ec137690cd6d12fdb2fd0b8c5314582108769c2b722ffb3958 */
/* QIUTy = 5eef3da4ba458127346bb64023868bddb7558a2ecfc813645f4ce9fe */
static const uint8_t nist_kas_ecc_cdh_testvector_39_out[] = {
/* ZIUT */
	0xf8, 0x3c, 0x16, 0x66, 0x1d, 0xfc, 0xba, 0xd0, 0x21, 0xcc, 0x3b, 0x5a,
	0x5a, 0xf5, 0x1d, 0x9a, 0x18, 0xdb, 0x46, 0x53, 0x86, 0x6b, 0x3f, 0xf9,
	0x07, 0x87, 0xce, 0x3e
};
/* COUNT = 14 */
static const uint8_t nist_kas_ecc_cdh_testvector_40_public_x[] = {
/* QCAVSx */
	0xeb, 0x0a, 0x09, 0xf7, 0xa1, 0xc2, 0x36, 0xa6, 0x1f, 0x59, 0x58, 0x09,
	0xec, 0x56, 0x70, 0xef, 0xd9, 0x2e, 0x45, 0x98, 0xd5, 0xe6, 0x13, 0xe0,
	0x92, 0xcd, 0xfd, 0xca
};
static const uint8_t nist_kas_ecc_cdh_testvector_40_public_y[] = {
/* QCAVSy */
	0x50, 0x78, 0x7a, 0xe2, 0xf2, 0xf1, 0x5b, 0x88, 0xbc, 0x10, 0xf7, 0xb5,
	0xf0, 0xae, 0xe1, 0x41, 0x83, 0x73, 0xf1, 0x61, 0x53, 0xae, 0xbd, 0x1f,
	0xba, 0x54, 0x28, 0x8d
};
static const uint8_t nist_kas_ecc_cdh_testvector_40_private[] = {
/* dIUT */
	0x0f, 0xf9, 0xb4, 0x85, 0x32, 0x5a, 0xb7, 0x7f, 0x29, 0xe7, 0xbc, 0x37,
	0x9f, 0xed, 0x74, 0xbf, 0xac, 0x85, 0x94, 0x82, 0xda, 0x0d, 0xee, 0x75,
	0x28, 0xc1, 0x9d, 0xb2
};
/* QIUTx = 7e603e6976db83c36011508fa695d1b515249e2e54b48fcbcfb90247 */
/* QIUTy = 0179a600ce86adfca9b1b931fa5173d618da09e841803d19b0264286 */
static const uint8_t nist_kas_ecc_cdh_testvector_40_out[] = {
/* ZIUT */
	0xf5, 0x12, 0x58, 0xc6, 0x3f, 0x23, 0x2e, 0x55, 0xa6, 0x6a, 0xa2, 0x5e,
	0xbd, 0x59, 0x7b, 0x20, 0x18, 0xd1, 0x05, 0x2c, 0x02, 0xee, 0xb6, 0x38,
	0x66, 0x75, 0x80, 0x05
};
/* COUNT = 15 */
static const uint8_t nist_kas_ecc_cdh_testvector_41_public_x[] = {
/* QCAVSx */
	0x6b, 0x2f, 0x6b, 0x18, 0xa5, 0x87, 0xf5, 0x62, 0xff, 0xc6, 0x1b, 0xd9,
	0xb0, 0x04, 0x73, 0x22, 0x28, 0x69, 0x86, 0xa7, 0x8f, 0x1f, 0xd1, 0x39,
	0xb8, 0x4f, 0x7c, 0x24
};
static const uint8_t nist_kas_ecc_cdh_testvector_41_public_y[] = {
/* QCAVSy */
	0x70, 0x96, 0x90, 0x8e, 0x46, 0x15, 0x26, 0x6b, 0xe5, 0x9a, 0x53, 0xcd,
	0x65, 0x55, 0x15, 0x05, 0x6f, 0xf9, 0x23, 0x70, 0xa6, 0x27, 0x1a, 0x5d,
	0x38, 0x23, 0xd7, 0x04
};
static const uint8_t nist_kas_ecc_cdh_testvector_41_private[] = {
/* dIUT */
	0x19, 0xcf, 0x5f, 0xf6, 0x30, 0x64, 0x67, 0xf2, 0x8b, 0x9f, 0xe0, 0x67,
	0x5a, 0x43, 0xc0, 0x58, 0x25, 0x52, 0xc8, 0xc1, 0x2e, 0x59, 0xce, 0x7c,
	0x38, 0xf2, 0x92, 0xb1
};
/* QIUTx = fc20e906e609c112cfc2e0fea6303882c5db94e87e022373ab2c082a */
/* QIUTy = aecdf1daa71782bc5a26bbbd8d7e8a76490e26abc17dffc774bd7341 */
static const uint8_t nist_kas_ecc_cdh_testvector_41_out[] = {
/* ZIUT */
	0x7f, 0xdc, 0x96, 0x9a, 0x18, 0x6f, 0xf1, 0x84, 0x29, 0xf2, 0xa2, 0x76,
	0xda, 0xc4, 0x3b, 0xee, 0xa2, 0x11, 0x82, 0xd8, 0x2c, 0xe2, 0xe5, 0xa0,
	0x87, 0x65, 0x52, 0xb1
};
/* COUNT = 16 */
static const uint8_t nist_kas_ecc_cdh_testvector_42_public_x[] = {
/* QCAVSx */
	0x32, 0x81, 0x01, 0xba, 0x82, 0x6a, 0xcd, 0x75, 0xff, 0x9f, 0x34, 0xd5,
	0x57, 0x4c, 0xe0, 0xdb, 0xc9, 0x2f, 0x70, 0x9b, 0xad, 0x8d, 0x7a, 0x33,
	0xc4, 0x79, 0x40, 0xc1
};
static const uint8_t nist_kas_ecc_cdh_testvector_42_public_y[] = {
/* QCAVSy */
	0xdf, 0x39, 0xf1, 0xea, 0x88, 0x48, 0x8c, 0x55, 0xd5, 0x53, 0x81, 0x60,
	0x87, 0x8b, 0x9c, 0xed, 0x18, 0xa8, 0x87, 0xea, 0x26, 0x1d, 0xd7, 0x12,
	0xd1, 0x40, 0x24, 0xff
};
static const uint8_t nist_kas_ecc_cdh_testvector_42_private[] = {
/* dIUT */
	0x90, 0xa1, 0x53, 0x68, 0xe3, 0x53, 0x2c, 0x0b, 0x1e, 0x51, 0xe5, 0x5d,
	0x13, 0x94, 0x47, 0xc2, 0xc8, 0x9b, 0xc1, 0x60, 0x71, 0x9d, 0x69, 0x72,
	0x91, 0xea, 0x7c, 0x14
};
/* QIUTx = c6837d506e976da7db3ad1267c359dff2ea6fb0b7f7f8e77024c59e9 */
/* QIUTy = 67eb491d2fc8a530c46525d2a8b2d7c1df5fba1ae740a4649c683ee6 */
static const uint8_t nist_kas_ecc_cdh_testvector_42_out[] = {
/* ZIUT */
	0x3d, 0x60, 0xab, 0x6d, 0xb2, 0xb3, 0xff, 0xe2, 0xd2, 0x9c, 0xcf, 0xf4,
	0x6d, 0x05, 0x6e, 0x54, 0x23, 0x0c, 0xf3, 0x49, 0x82, 0xe2, 0x41, 0x55,
	0x6e, 0xd2, 0x92, 0x0c
};
/* COUNT = 17 */
static const uint8_t nist_kas_ecc_cdh_testvector_43_public_x[] = {
/* QCAVSx */
	0x00, 0x81, 0xe3, 0x42, 0x70, 0x87, 0x1e, 0x2e, 0xbb, 0xd9, 0x41, 0x83,
	0xf6, 0x17, 0xb4, 0xae, 0x15, 0xf0, 0x41, 0x6d, 0xd6, 0x34, 0xfe, 0x6e,
	0x93, 0x4c, 0xf3, 0xc0
};
static const uint8_t nist_kas_ecc_cdh_testvector_43_public_y[] = {
/* QCAVSy */
	0x3a, 0x1e, 0x9f, 0x38, 0xa7, 0xb9, 0x0b, 0x73, 0x17, 0xd2, 0x6b, 0x9f,
	0x63, 0x11, 0x06, 0x3a, 0xb5, 0x8b, 0x26, 0x8c, 0xf4, 0x89, 0xb2, 0xe5,
	0x03, 0x86, 0xd5, 0xd6
};
static const uint8_t nist_kas_ecc_cdh_testvector_43_private[] = {
/* dIUT */
	0x8e, 0x08, 0x38, 0xe0, 0x5e, 0x17, 0x21, 0x49, 0x10, 0x67, 0xe1, 0xca,
	0xbc, 0x2e, 0x80, 0x51, 0xb2, 0x90, 0xe2, 0x61, 0x6e, 0xec, 0x42, 0x7b,
	0x71, 0x21, 0x89, 0x7d
};
/* QIUTx = e9150f770075626019e18f95473b71e6828041791d3f08d3faeeaa2b */
/* QIUTy = 475f70735eaae52308a3b763dc88efe18ab590ebafa035f6e08b001c */
static const uint8_t nist_kas_ecc_cdh_testvector_43_out[] = {
/* ZIUT */
	0x91, 0x16, 0xd7, 0x27, 0x86, 0xf4, 0xdb, 0x5d, 0xf7, 0xa8, 0xb4, 0x30,
	0x78, 0xc6, 0xab, 0x91, 0x60, 0xd4, 0x23, 0x51, 0x3d, 0x35, 0xea, 0x5e,
	0x25, 0x59, 0x30, 0x6d
};
/* COUNT = 18 */
static const uint8_t nist_kas_ecc_cdh_testvector_44_public_x[] = {
/* QCAVSx */
	0x26, 0x23, 0x63, 0x2f, 0xdf, 0x0b, 0xd8, 0x56, 0x80, 0x5a, 0x69, 0xaa,
	0x18, 0x6d, 0x41, 0x33, 0xef, 0x59, 0x04, 0xe1, 0xf6, 0x55, 0xa9, 0x72,
	0xd6, 0x6c, 0xce, 0x07
};
static const uint8_t nist_kas_ecc_cdh_testvector_44_public_y[] = {
/* QCAVSy */
	0x2c, 0xef, 0x97, 0x28, 0xdd, 0x06, 0xfb, 0x8b, 0x50, 0x15, 0x0f, 0x52,
	0x9b, 0x69, 0x50, 0x76, 0xd4, 0x50, 0x79, 0x83, 0x91, 0x25, 0x85, 0xc8,
	0x9b, 0xd0, 0x68, 0x2e
};
static const uint8_t nist_kas_ecc_cdh_testvector_44_private[] = {
/* dIUT */
	0x38, 0x10, 0x6e, 0x93, 0xf1, 0x6a, 0x38, 0x1a, 0xdb, 0x1d, 0x72, 0xce,
	0xe3, 0xda, 0x66, 0xae, 0x46, 0x2a, 0xd4, 0xbb, 0xfe, 0xa9, 0xec, 0xdf,
	0x35, 0xd0, 0x81, 0x4e
};
/* QIUTx = 7be6c4c917829ab657dd79e8637d7aefd2f81f0de7654d957e97658d */
/* QIUTy = 430d22d9e8438310f61e0d43f25fa3e34585f432baad27db3021bf0d */
static const uint8_t nist_kas_ecc_cdh_testvector_44_out[] = {
/* ZIUT */
	0x20, 0x7c, 0x53, 0xdc, 0xef, 0xac, 0x78, 0x9a, 0xaa, 0x02, 0x76, 0xd9,
	0x20, 0x0b, 0x3a, 0x94, 0x0c, 0xe5, 0xf2, 0x29, 0x6f, 0x4c, 0xb2, 0xe8,
	0x1a, 0x18, 0x5d, 0x3d
};
/* COUNT = 19 */
static const uint8_t nist_kas_ecc_cdh_testvector_45_public_x[] = {
/* QCAVSx */
	0x8e, 0xe4, 0xd1, 0xdc, 0xc3, 0x1d, 0xee, 0x4b, 0xf6, 0xfe, 0x21, 0xca,
	0x8a, 0x58, 0x77, 0x21, 0xd9, 0x10, 0xac, 0xfb, 0x12, 0x2c, 0x16, 0xc2,
	0xa7, 0x7a, 0x81, 0x52
};
static const uint8_t nist_kas_ecc_cdh_testvector_45_public_y[] = {
/* QCAVSy */
	0x4e, 0xbf, 0x32, 0x3f, 0xff, 0x04, 0xeb, 0x47, 0x70, 0x69, 0xa0, 0xac,
	0x68, 0xb3, 0x45, 0xf6, 0xb1, 0xae, 0x13, 0x4e, 0xfc, 0x31, 0x94, 0x0e,
	0x51, 0x3c, 0xb9, 0x9f
};
static const uint8_t nist_kas_ecc_cdh_testvector_45_private[] = {
/* dIUT */
	0xe5, 0xd1, 0x71, 0x84, 0x31, 0xcf, 0x50, 0xf6, 0xcb, 0xd1, 0xbc, 0x80,
	0x19, 0xfa, 0x16, 0x76, 0x2d, 0xfa, 0x12, 0xc9, 0x89, 0xe5, 0x99, 0x99,
	0x77, 0xfb, 0x4e, 0xa2
};
/* QIUTx = 2ea4966e7f92ed7f5cc61fde792045f63b731d6e7d0de2577f2d8ece */
/* QIUTy = 1c4a7b1ede6f839162292df424be78e8176fb6f942a3c02391700f31 */
static const uint8_t nist_kas_ecc_cdh_testvector_45_out[] = {
/* ZIUT */
	0x10, 0xe4, 0x67, 0xda, 0x34, 0xf4, 0x8a, 0xd7, 0x07, 0x20, 0x05, 0xbc,
	0xcd, 0x6d, 0xa1, 0xb2, 0xba, 0x3f, 0x71, 0xea, 0xfa, 0x1c, 0x39, 0x38,
	0x42, 0xf9, 0x1d, 0x74
};
/* COUNT = 20 */
static const uint8_t nist_kas_ecc_cdh_testvector_46_public_x[] = {
/* QCAVSx */
	0x97, 0xdc, 0xbe, 0x6d, 0x28, 0x33, 0x58, 0x82, 0xa6, 0xd1, 0x93, 0xcc,
	0x54, 0xa1, 0x06, 0x3d, 0xd0, 0x77, 0x5d, 0xc3, 0x28, 0x56, 0x53, 0x00,
	0xbb, 0x99, 0xe6, 0x91
};
static const uint8_t nist_kas_ecc_cdh_testvector_46_public_y[] = {
/* QCAVSy */
	0xda, 0xd1, 0x1d, 0xd5, 0xec, 0xe8, 0xcf, 0xd9, 0xf9, 0x7c, 0x9a, 0x52,
	0x6e, 0x4a, 0x15, 0x06, 0xe6, 0x35, 0x59, 0x69, 0xee, 0x87, 0x82, 0x6f,
	0xc3, 0x8b, 0xcd, 0x24
};
static const uint8_t nist_kas_ecc_cdh_testvector_46_private[] = {
/* dIUT */
	0x3d, 0x63, 0x56, 0x91, 0xb6, 0x2a, 0x9a, 0x92, 0x7c, 0x63, 0x39, 0x51,
	0xc9, 0x36, 0x9c, 0x88, 0x62, 0xbd, 0x21, 0x19, 0xd3, 0x09, 0x70, 0xc2,
	0x64, 0x47, 0x27, 0xd6
};
/* QIUTx = 438bbb980517afb20be1d674e3ac2b31cef07a9b23fb8f6e38e0d6c0 */
/* QIUTy = 0be5f1c47d58d21b6ed28423b32f5a94750da47edcef33ea79942afd */
static const uint8_t nist_kas_ecc_cdh_testvector_46_out[] = {
/* ZIUT */
	0x82, 0xfd, 0x2f, 0x9c, 0x60, 0xc4, 0xf9, 0x99, 0xac, 0x00, 0xbb, 0xe6,
	0x4b, 0xfc, 0x11, 0xda, 0x8f, 0xf8, 0xcd, 0xa2, 0xe4, 0x99, 0xfc, 0xed,
	0x65, 0x23, 0x0b, 0xb1
};
/* COUNT = 21 */
static const uint8_t nist_kas_ecc_cdh_testvector_47_public_x[] = {
/* QCAVSx */
	0xce, 0x91, 0x26, 0xdd, 0x53, 0x97, 0x2d, 0xea, 0x1d, 0xe1, 0xd1, 0x1e,
	0xfe, 0xf9, 0x00, 0xde, 0x34, 0xb6, 0x61, 0x85, 0x9c, 0x46, 0x48, 0xc5,
	0xc0, 0xe5, 0x34, 0xf7
};
static const uint8_t nist_kas_ecc_cdh_testvector_47_public_y[] = {
/* QCAVSy */
	0xe1, 0x13, 0xb6, 0xf2, 0xc1, 0x65, 0x9d, 0x07, 0xf2, 0x71, 0x6e, 0x64,
	0xa8, 0x3c, 0x18, 0xbb, 0xce, 0x34, 0x4d, 0xd2, 0x12, 0x1f, 0xe8, 0x51,
	0x68, 0xea, 0xe0, 0x85
};
static const uint8_t nist_kas_ecc_cdh_testvector_47_private[] = {
/* dIUT */
	0xac, 0xf3, 0xc8, 0x5b, 0xbd, 0xc3, 0x79, 0xf0, 0x2f, 0x5e, 0xa3, 0x6e,
	0x7f, 0x0f, 0x53, 0x09, 0x5a, 0x9e, 0x70, 0x46, 0xa2, 0x86, 0x85, 0xa8,
	0x65, 0x9b, 0xf7, 0x98
};
/* QIUTx = ff7511215c71d796bd646e8474be4416b91684ce0d269ef6f422013b */
/* QIUTy = b7bf5e79b5a9393bb9ea42c0bdb2d3c2dc806e1a7306aa58e4fdbea5 */
static const uint8_t nist_kas_ecc_cdh_testvector_47_out[] = {
/* ZIUT */
	0x53, 0x0f, 0x7e, 0x7f, 0xc9, 0x32, 0x61, 0x3b, 0x29, 0xc9, 0x81, 0xf2,
	0x61, 0xcb, 0x03, 0x6c, 0xba, 0x3f, 0x1d, 0xf3, 0x86, 0x4e, 0x0e, 0x1c,
	0xba, 0x26, 0x85, 0xa2
};
/* COUNT = 22 */
static const uint8_t nist_kas_ecc_cdh_testvector_48_public_x[] = {
/* QCAVSx */
	0x84, 0x41, 0x99, 0x67, 0xd6, 0xcf, 0xad, 0x41, 0xe7, 0x5a, 0x02, 0xb6,
	0xda, 0x60, 0x5a, 0x97, 0x94, 0x9a, 0x18, 0x3a, 0x97, 0xc3, 0x06, 0xc4,
	0xb4, 0x6e, 0x66, 0xa5
};
static const uint8_t nist_kas_ecc_cdh_testvector_48_public_y[] = {
/* QCAVSy */
	0x5c, 0xc9, 0xb2, 0x59, 0x71, 0x8b, 0x1b, 0xc8, 0xb1, 0x44, 0xfd, 0xe6,
	0x33, 0xa8, 0x94, 0x61, 0x6f, 0xfd, 0x59, 0xa3, 0xa6, 0xd5, 0xd8, 0xe9,
	0x42, 0xc7, 0xcb, 0xb7
};
static const uint8_t nist_kas_ecc_cdh_testvector_48_private[] = {
/* dIUT */
	0xcf, 0xfd, 0x62, 0xcb, 0x00, 0xa0, 0xe3, 0x16, 0x3f, 0xbf, 0x2c, 0x39,
	0x7f, 0xad, 0xc9, 0x61, 0x82, 0x10, 0xf8, 0x6b, 0x4f, 0x54, 0xa6, 0x75,
	0x28, 0x73, 0x05, 0xf0
};
/* QIUTx = 04bf4d948f4430d18b4ed6c96dbaf981fa11a403ed16887f06754981 */
/* QIUTy = 7c1326a9cef51f79d4e78303d6064b459f612584ac2fdf593d7d5d84 */
static const uint8_t nist_kas_ecc_cdh_testvector_48_out[] = {
/* ZIUT */
	0x49, 0xf6, 0xfd, 0x01, 0x39, 0x24, 0x8e, 0xf4, 0xdf, 0x2d, 0xb0, 0x5d,
	0x13, 0x19, 0xbd, 0x5b, 0x14, 0x89, 0xe2, 0x49, 0x82, 0x7a, 0x45, 0xa8,
	0xa5, 0xf1, 0x24, 0x27
};
/* COUNT = 23 */
static const uint8_t nist_kas_ecc_cdh_testvector_49_public_x[] = {
/* QCAVSx */
	0x7c, 0x9c, 0xac, 0x35, 0x76, 0x80, 0x63, 0xc2, 0x82, 0x7f, 0x60, 0xa7,
	0xf5, 0x13, 0x88, 0xf2, 0xa8, 0xf4, 0xb7, 0xf8, 0xcd, 0x73, 0x6b, 0xd6,
	0xbc, 0x33, 0x74, 0x77
};
static const uint8_t nist_kas_ecc_cdh_testvector_49_public_y[] = {
/* QCAVSy */
	0x29, 0xee, 0x6b, 0x84, 0x9c, 0x60, 0x25, 0xd5, 0x77, 0xdb, 0xcc, 0x55,
	0xfb, 0xd1, 0x70, 0x18, 0xf4, 0xed, 0xbc, 0x2e, 0xf1, 0x05, 0xb0, 0x04,
	0xd6, 0x25, 0x7b, 0xcd
};
static const uint8_t nist_kas_ecc_cdh_testvector_49_private[] = {
/* dIUT */
	0x85, 0xf9, 0x03, 0xe4, 0x39, 0x43, 0xd1, 0x3c, 0x68, 0x93, 0x2e, 0x71,
	0x0e, 0x80, 0xde, 0x52, 0xcb, 0xc0, 0xb8, 0xf1, 0xa1, 0x41, 0x8e, 0xa4,
	0xda, 0x07, 0x92, 0x99
};
/* QIUTx = 970a4a7e01d4188497ceb46955eb1b842d9085819a9b925c84529d3d */
/* QIUTy = dfa2526480f833ea0edbd204e4e365fef3472888fe7d9691c3ebc09f */
static const uint8_t nist_kas_ecc_cdh_testvector_49_out[] = {
/* ZIUT */
	0x8f, 0x7e, 0x34, 0xe5, 0x97, 0xae, 0x80, 0x93, 0xb9, 0x82, 0x70, 0xa7,
	0x4a, 0x8d, 0xfc, 0xdb, 0xed, 0x45, 0x7f, 0x42, 0xf4, 0x3d, 0xf4, 0x87,
	0xc5, 0x48, 0x71, 0x61
};
/* COUNT = 24 */
static const uint8_t nist_kas_ecc_cdh_testvector_50_public_x[] = {
/* QCAVSx */
	0x08, 0x5a, 0x76, 0x42, 0xad, 0x8e, 0x59, 0xb1, 0xa3, 0xe8, 0x72, 0x6a,
	0x75, 0x47, 0xaf, 0xbe, 0xcf, 0xfd, 0xac, 0x1d, 0xab, 0x7e, 0x57, 0x23,
	0x0c, 0x6a, 0x9d, 0xf4
};
static const uint8_t nist_kas_ecc_cdh_testvector_50_public_y[] = {
/* QCAVSy */
	0xf9, 0x1c, 0x36, 0xd8, 0x81, 0xfe, 0x9b, 0x80, 0x47, 0xa3, 0x53, 0x07,
	0x13, 0x55, 0x4a, 0x1a, 0xf4, 0xc2, 0x5c, 0x5a, 0x8e, 0x65, 0x4d, 0xcd,
	0xcf, 0x68, 0x9f, 0x2e
};
static const uint8_t nist_kas_ecc_cdh_testvector_50_private[] = {
/* dIUT */
	0xcc, 0xe6, 0x48, 0x91, 0xa3, 0xd0, 0x12, 0x9f, 0xee, 0x0d, 0x4a, 0x96,
	0xcf, 0xbe, 0x7a, 0xc4, 0x70, 0xb8, 0x5e, 0x96, 0x75, 0x29, 0x05, 0x7c,
	0xfa, 0x31, 0xa1, 0xd9
};
/* QIUTx = a6b29632db94da2125dc1cf80e03702687b2acc1122022fa2174765a */
/* QIUTy = 61723edd73e10daed73775278f1958ba56f1fc9d085ebc2b64c84fe5 */
static const uint8_t nist_kas_ecc_cdh_testvector_50_out[] = {
/* ZIUT */
	0x71, 0x95, 0x4e, 0x22, 0x61, 0xe8, 0x51, 0x0b, 0xe1, 0xa0, 0x60, 0x73,
	0x36, 0x71, 0xd2, 0xe9, 0xd0, 0xa2, 0xd0, 0x12, 0xeb, 0x4e, 0x09, 0x55,
	0x6d, 0x69, 0x7d, 0x2a
};
/* [P-256] */
/* COUNT = 0 */
static const uint8_t nist_kas_ecc_cdh_testvector_51_public_x[] = {
/* QCAVSx */
	0x70, 0x0c, 0x48, 0xf7, 0x7f, 0x56, 0x58, 0x4c, 0x5c, 0xc6, 0x32, 0xca,
	0x65, 0x64, 0x0d, 0xb9, 0x1b, 0x6b, 0xac, 0xce, 0x3a, 0x4d, 0xf6, 0xb4,
	0x2c, 0xe7, 0xcc, 0x83, 0x88, 0x33, 0xd2, 0x87
};
static const uint8_t nist_kas_ecc_cdh_testvector_51_public_y[] = {
/* QCAVSy */
	0xdb, 0x71, 0xe5, 0x09, 0xe3, 0xfd, 0x9b, 0x06, 0x0d, 0xdb, 0x20, 0xba,
	0x5c, 0x51, 0xdc, 0xc5, 0x94, 0x8d, 0x46, 0xfb, 0xf6, 0x40, 0xdf, 0xe0,
	0x44, 0x17, 0x82, 0xca, 0xb8, 0x5f, 0xa4, 0xac
};
static const uint8_t nist_kas_ecc_cdh_testvector_51_private[] = {
/* dIUT */
	0x7d, 0x7d, 0xc5, 0xf7, 0x1e, 0xb2, 0x9d, 0xda, 0xf8, 0x0d, 0x62, 0x14,
	0x63, 0x2e, 0xea, 0xe0, 0x3d, 0x90, 0x58, 0xaf, 0x1f, 0xb6, 0xd2, 0x2e,
	0xd8, 0x0b, 0xad, 0xb6, 0x2b, 0xc1, 0xa5, 0x34
};
/* QIUTx = ead218590119e8876b29146ff89ca61770c4edbbf97d38ce385ed281d8a6b230 */
/* QIUTy = 28af61281fd35e2fa7002523acc85a429cb06ee6648325389f59edfce1405141 */
static const uint8_t nist_kas_ecc_cdh_testvector_51_out[] = {
/* ZIUT */
	0x46, 0xfc, 0x62, 0x10, 0x64, 0x20, 0xff, 0x01, 0x2e, 0x54, 0xa4, 0x34,
	0xfb, 0xdd, 0x2d, 0x25, 0xcc, 0xc5, 0x85, 0x20, 0x60, 0x56, 0x1e, 0x68,
	0x04, 0x0d, 0xd7, 0x77, 0x89, 0x97, 0xbd, 0x7b
};
/* COUNT = 1 */
static const uint8_t nist_kas_ecc_cdh_testvector_52_public_x[] = {
/* QCAVSx */
	0x80, 0x9f, 0x04, 0x28, 0x9c, 0x64, 0x34, 0x8c, 0x01, 0x51, 0x5e, 0xb0,
	0x3d, 0x5c, 0xe7, 0xac, 0x1a, 0x8c, 0xb9, 0x49, 0x8f, 0x5c, 0xaa, 0x50,
	0x19, 0x7e, 0x58, 0xd4, 0x3a, 0x86, 0xa7, 0xae
};
static const uint8_t nist_kas_ecc_cdh_testvector_52_public_y[] = {
/* QCAVSy */
	0xb2, 0x9d, 0x84, 0xe8, 0x11, 0x19, 0x7f, 0x25, 0xeb, 0xa8, 0xf5, 0x19,
	0x40, 0x92, 0xcb, 0x6f, 0xf4, 0x40, 0xe2, 0x6d, 0x44, 0x21, 0x01, 0x13,
	0x72, 0x46, 0x1f, 0x57, 0x92, 0x71, 0xcd, 0xa3
};
static const uint8_t nist_kas_ecc_cdh_testvector_52_private[] = {
/* dIUT */
	0x38, 0xf6, 0x5d, 0x6d, 0xce, 0x47, 0x67, 0x60, 0x44, 0xd5, 0x8c, 0xe5,
	0x13, 0x95, 0x82, 0xd5, 0x68, 0xf6, 0x4b, 0xb1, 0x60, 0x98, 0xd1, 0x79,
	0xdb, 0xab, 0x07, 0x74, 0x1d, 0xd5, 0xca, 0xf5
};
/* QIUTx = 119f2f047902782ab0c9e27a54aff5eb9b964829ca99c06b02ddba95b0a3f6d0 */
/* QIUTy = 8f52b726664cac366fc98ac7a012b2682cbd962e5acb544671d41b9445704d1d */
static const uint8_t nist_kas_ecc_cdh_testvector_52_out[] = {
/* ZIUT */
	0x05, 0x7d, 0x63, 0x60, 0x96, 0xcb, 0x80, 0xb6, 0x7a, 0x8c, 0x03, 0x8c,
	0x89, 0x0e, 0x88, 0x7d, 0x1a, 0xdf, 0xa4, 0x19, 0x5e, 0x9b, 0x3c, 0xe2,
	0x41, 0xc8, 0xa7, 0x78, 0xc5, 0x9c, 0xda, 0x67
};
/* COUNT = 2 */
static const uint8_t nist_kas_ecc_cdh_testvector_53_public_x[] = {
/* QCAVSx */
	0xa2, 0x33, 0x9c, 0x12, 0xd4, 0xa0, 0x3c, 0x33, 0x54, 0x6d, 0xe5, 0x33,
	0x26, 0x8b, 0x4a, 0xd6, 0x67, 0xde, 0xbf, 0x45, 0x8b, 0x46, 0x4d, 0x77,
	0x44, 0x36, 0x36, 0x44, 0x0e, 0xe7, 0xfe, 0xc3
};
static const uint8_t nist_kas_ecc_cdh_testvector_53_public_y[] = {
/* QCAVSy */
	0xef, 0x48, 0xa3, 0xab, 0x26, 0xe2, 0x02, 0x20, 0xbc, 0xda, 0x2c, 0x18,
	0x51, 0x07, 0x68, 0x39, 0xda, 0xe8, 0x8e, 0xae, 0x96, 0x28, 0x69, 0xa4,
	0x97, 0xbf, 0x73, 0xcb, 0x66, 0xfa, 0xf5, 0x36
};
static const uint8_t nist_kas_ecc_cdh_testvector_53_private[] = {
/* dIUT */
	0x1a, 0xcc, 0xfa, 0xf1, 0xb9, 0x77, 0x12, 0xb8, 0x5a, 0x6f, 0x54, 0xb1,
	0x48, 0x98, 0x5a, 0x1b, 0xdc, 0x4c, 0x9b, 0xec, 0x0b, 0xd2, 0x58, 0xca,
	0xd4, 0xb3, 0xd6, 0x03, 0xf4, 0x9f, 0x32, 0xc8
};
/* QIUTx = d9f2b79c172845bfdb560bbb01447ca5ecc0470a09513b6126902c6b4f8d1051 */
/* QIUTy = f815ef5ec32128d3487834764678702e64e164ff7315185e23aff5facd96d7bc */
static const uint8_t nist_kas_ecc_cdh_testvector_53_out[] = {
/* ZIUT */
	0x2d, 0x45, 0x7b, 0x78, 0xb4, 0x61, 0x41, 0x32, 0x47, 0x76, 0x18, 0xa5,
	0xb0, 0x77, 0x96, 0x5e, 0xc9, 0x07, 0x30, 0xa8, 0xc8, 0x1a, 0x1c, 0x75,
	0xd6, 0xd4, 0xec, 0x68, 0x00, 0x5d, 0x67, 0xec
};
/* COUNT = 3 */
static const uint8_t nist_kas_ecc_cdh_testvector_54_public_x[] = {
/* QCAVSx */
	0xdf, 0x39, 0x89, 0xb9, 0xfa, 0x55, 0x49, 0x57, 0x19, 0xb3, 0xcf, 0x46,
	0xdc, 0xcd, 0x28, 0xb5, 0x15, 0x3f, 0x78, 0x08, 0x19, 0x1d, 0xd5, 0x18,
	0xef, 0xf0, 0xc3, 0xcf, 0xf2, 0xb7, 0x05, 0xed
};
static const uint8_t nist_kas_ecc_cdh_testvector_54_public_y[] = {
/* QCAVSy */
	0x42, 0x22, 0x94, 0xff, 0x46, 0x00, 0x34, 0x29, 0xd7, 0x39, 0xa3, 0x32,
	0x06, 0xc8, 0x75, 0x25, 0x52, 0xc8, 0xba, 0x54, 0xa2, 0x70, 0xde, 0xfc,
	0x06, 0xe2, 0x21, 0xe0, 0xfe, 0xaf, 0x6a, 0xc4
};
static const uint8_t nist_kas_ecc_cdh_testvector_54_private[] = {
/* dIUT */
	0x20, 0x7c, 0x43, 0xa7, 0x9b, 0xfe, 0xe0, 0x3d, 0xb6, 0xf4, 0xb9, 0x44,
	0xf5, 0x3d, 0x2f, 0xb7, 0x6c, 0xc4, 0x9e, 0xf1, 0xc9, 0xc4, 0xd3, 0x4d,
	0x51, 0xb6, 0xc6, 0x5c, 0x4d, 0xb6, 0x93, 0x2d
};
/* QIUTx = 24277c33f450462dcb3d4801d57b9ced05188f16c28eda873258048cd1607e0d */
/* QIUTy = c4789753e2b1f63b32ff014ec42cd6a69fac81dfe6d0d6fd4af372ae27c46f88 */
static const uint8_t nist_kas_ecc_cdh_testvector_54_out[] = {
/* ZIUT */
	0x96, 0x44, 0x12, 0x59, 0x53, 0x4b, 0x80, 0xf6, 0xae, 0xe3, 0xd2, 0x87,
	0xa6, 0xbb, 0x17, 0xb5, 0x09, 0x4d, 0xd4, 0x27, 0x7d, 0x9e, 0x29, 0x4f,
	0x8f, 0xe7, 0x3e, 0x48, 0xbf, 0x2a, 0x00, 0x24
};
/* COUNT = 4 */
static const uint8_t nist_kas_ecc_cdh_testvector_55_public_x[] = {
/* QCAVSx */
	0x41, 0x19, 0x2d, 0x28, 0x13, 0xe7, 0x95, 0x61, 0xe6, 0xa1, 0xd6, 0xf5,
	0x3c, 0x8b, 0xc1, 0xa4, 0x33, 0xa1, 0x99, 0xc8, 0x35, 0xe1, 0x41, 0xb0,
	0x5a, 0x74, 0xa9, 0x7b, 0x0f, 0xae, 0xb9, 0x22
};
static const uint8_t nist_kas_ecc_cdh_testvector_55_public_y[] = {
/* QCAVSy */
	0x1a, 0xf9, 0x8c, 0xc4, 0x5e, 0x98, 0xa7, 0xe0, 0x41, 0xb0, 0x1c, 0xf3,
	0x5f, 0x46, 0x2b, 0x75, 0x62, 0x28, 0x13, 0x51, 0xc8, 0xeb, 0xf3, 0xff,
	0xa0, 0x2e, 0x33, 0xa0, 0x72, 0x2a, 0x13, 0x28
};
static const uint8_t nist_kas_ecc_cdh_testvector_55_private[] = {
/* dIUT */
	0x59, 0x13, 0x7e, 0x38, 0x15, 0x23, 0x50, 0xb1, 0x95, 0xc9, 0x71, 0x8d,
	0x39, 0x67, 0x3d, 0x51, 0x98, 0x38, 0x05, 0x5a, 0xd9, 0x08, 0xdd, 0x47,
	0x57, 0x15, 0x2f, 0xd8, 0x25, 0x5c, 0x09, 0xbf
};
/* QIUTx = a8c5fdce8b62c5ada598f141adb3b26cf254c280b2857a63d2ad783a73115f6b */
/* QIUTy = 806e1aafec4af80a0d786b3de45375b517a7e5b51ffb2c356537c9e6ef227d4a */
static const uint8_t nist_kas_ecc_cdh_testvector_55_out[] = {
/* ZIUT */
	0x19, 0xd4, 0x4c, 0x8d, 0x63, 0xe8, 0xe8, 0xdd, 0x12, 0xc2, 0x2a, 0x87,
	0xb8, 0xcd, 0x4e, 0xce, 0x27, 0xac, 0xdd, 0xe0, 0x4d, 0xbf, 0x47, 0xf7,
	0xf2, 0x75, 0x37, 0xa6, 0x99, 0x9a, 0x8e, 0x62
};
/* COUNT = 5 */
static const uint8_t nist_kas_ecc_cdh_testvector_56_public_x[] = {
/* QCAVSx */
	0x33, 0xe8, 0x20, 0x92, 0xa0, 0xf1, 0xfb, 0x38, 0xf5, 0x64, 0x9d, 0x58,
	0x67, 0xfb, 0xa2, 0x8b, 0x50, 0x31, 0x72, 0xb7, 0x03, 0x55, 0x74, 0xbf,
	0x8e, 0x5b, 0x71, 0x00, 0xa3, 0x05, 0x27, 0x92
};
static const uint8_t nist_kas_ecc_cdh_testvector_56_public_y[] = {
/* QCAVSy */
	0xf2, 0xcf, 0x6b, 0x60, 0x1e, 0x0a, 0x05, 0x94, 0x5e, 0x33, 0x55, 0x50,
	0xbf, 0x64, 0x8d, 0x78, 0x2f, 0x46, 0x18, 0x6c, 0x77, 0x2c, 0x0f, 0x20,
	0xd3, 0xcd, 0x0d, 0x6b, 0x8c, 0xa1, 0x4b, 0x2f
};
static const uint8_t nist_kas_ecc_cdh_testvector_56_private[] = {
/* dIUT */
	0xf5, 0xf8, 0xe0, 0x17, 0x46, 0x10, 0xa6, 0x61, 0x27, 0x79, 0x79, 0xb5,
	0x8c, 0xe5, 0xc9, 0x0f, 0xee, 0x6c, 0x9b, 0x3b, 0xb3, 0x46, 0xa9, 0x0a,
	0x71, 0x96, 0x25, 0x5e, 0x40, 0xb1, 0x32, 0xef
};
/* QIUTx = 7b861dcd2844a5a8363f6b8ef8d493640f55879217189d80326aad9480dfc149 */
/* QIUTy = c4675b45eeb306405f6c33c38bc69eb2bdec9b75ad5af4706aab84543b9cc63a */
static const uint8_t nist_kas_ecc_cdh_testvector_56_out[] = {
/* ZIUT */
	0x66, 0x4e, 0x45, 0xd5, 0xbb, 0xa4, 0xac, 0x93, 0x1c, 0xd6, 0x5d, 0x52,
	0x01, 0x7e, 0x4b, 0xe9, 0xb1, 0x9a, 0x51, 0x5f, 0x66, 0x9b, 0xea, 0x47,
	0x03, 0x54, 0x2a, 0x2c, 0x52, 0x5c, 0xd3, 0xd3
};
/* COUNT = 6 */
static const uint8_t nist_kas_ecc_cdh_testvector_57_public_x[] = {
/* QCAVSx */
	0x6a, 0x9e, 0x0c, 0x3f, 0x91, 0x6e, 0x4e, 0x31, 0x5c, 0x91, 0x14, 0x7b,
	0xe5, 0x71, 0x68, 0x6d, 0x90, 0x46, 0x4e, 0x8b, 0xf9, 0x81, 0xd3, 0x4a,
	0x90, 0xb6, 0x35, 0x3b, 0xca, 0x6e, 0xeb, 0xa7
};
static const uint8_t nist_kas_ecc_cdh_testvector_57_public_y[] = {
/* QCAVSy */
	0x40, 0xf9, 0xbe, 0xad, 0x39, 0xc2, 0xf2, 0xbc, 0xc2, 0x60, 0x2f, 0x75,
	0xb8, 0xa7, 0x3e, 0xc7, 0xbd, 0xff, 0xcb, 0xce, 0xad, 0x15, 0x9d, 0x01,
	0x74, 0xc6, 0xc4, 0xd3, 0xc5, 0x35, 0x7f, 0x05
};
static const uint8_t nist_kas_ecc_cdh_testvector_57_private[] = {
/* dIUT */
	0x3b, 0x58, 0x9a, 0xf7, 0xdb, 0x03, 0x45, 0x9c, 0x23, 0x06, 0x8b, 0x64,
	0xf6, 0x3f, 0x28, 0xd3, 0xc3, 0xc6, 0xbc, 0x25, 0xb5, 0xbf, 0x76, 0xac,
	0x05, 0xf3, 0x54, 0x82, 0x88, 0x8b, 0x51, 0x90
};
/* QIUTx = 9fb38e2d58ea1baf7622e96720101cae3cde4ba6c1e9fa26d9b1de0899102863 */
/* QIUTy = d5561b900406edf50802dd7d73e89395f8aed72fba0e1d1b61fe1d22302260f0 */
static const uint8_t nist_kas_ecc_cdh_testvector_57_out[] = {
/* ZIUT */
	0xca, 0x34, 0x2d, 0xaa, 0x50, 0xdc, 0x09, 0xd6, 0x1b, 0xe7, 0xc1, 0x96,
	0xc8, 0x5e, 0x60, 0xa8, 0x0c, 0x5c, 0xb0, 0x49, 0x31, 0x74, 0x68, 0x20,
	0xbe, 0x54, 0x8c, 0xdd, 0xe0, 0x55, 0x67, 0x9d
};
/* COUNT = 7 */
static const uint8_t nist_kas_ecc_cdh_testvector_58_public_x[] = {
/* QCAVSx */
	0xa9, 0xc0, 0xac, 0xad, 0xe5, 0x5c, 0x2a, 0x73, 0xea, 0xd1, 0xa8, 0x6f,
	0xb0, 0xa9, 0x71, 0x32, 0x23, 0xc8, 0x24, 0x75, 0x79, 0x1c, 0xd0, 0xe2,
	0x10, 0xb0, 0x46, 0x41, 0x2c, 0xe2, 0x24, 0xbb
};
static const uint8_t nist_kas_ecc_cdh_testvector_58_public_y[] = {
/* QCAVSy */
	0xf6, 0xde, 0x0a, 0xfa, 0x20, 0xe9, 0x3e, 0x07, 0x84, 0x67, 0xc0, 0x53,
	0xd2, 0x41, 0x90, 0x3e, 0xda, 0xd7, 0x34, 0xc6, 0xb4, 0x03, 0xba, 0x75,
	0x8c, 0x2b, 0x5f, 0xf0, 0x4c, 0x9d, 0x42, 0x29
};
static const uint8_t nist_kas_ecc_cdh_testvector_58_private[] = {
/* dIUT */
	0xd8, 0xbf, 0x92, 0x9a, 0x20, 0xea, 0x74, 0x36, 0xb2, 0x46, 0x1b, 0x54,
	0x1a, 0x11, 0xc8, 0x0e, 0x61, 0xd8, 0x26, 0xc0, 0xa4, 0xc9, 0xd3, 0x22,
	0xb3, 0x1d, 0xd5, 0x4e, 0x7f, 0x58, 0xb9, 0xc8
};
/* QIUTx = 20f07631e4a6512a89ad487c4e9d63039e579cb0d7a556cb9e661cd59c1e7fa4 */
/* QIUTy = 6de91846b3eee8a5ec09c2ab1f41e21bd83620ccdd1bdce3ab7ea6e02dd274f5 */
static const uint8_t nist_kas_ecc_cdh_testvector_58_out[] = {
/* ZIUT */
	0x35, 0xaa, 0x9b, 0x52, 0x53, 0x6a, 0x46, 0x1b, 0xfd, 0xe4, 0xe8, 0x5f,
	0xc7, 0x56, 0xbe, 0x92, 0x8c, 0x7d, 0xe9, 0x79, 0x23, 0xf0, 0x41, 0x6c,
	0x7a, 0x3a, 0xc8, 0xf8, 0x8b, 0x3d, 0x44, 0x89
};
/* COUNT = 8 */
static const uint8_t nist_kas_ecc_cdh_testvector_59_public_x[] = {
/* QCAVSx */
	0x94, 0xe9, 0x4f, 0x16, 0xa9, 0x82, 0x55, 0xff, 0xf2, 0xb9, 0xac, 0x0c,
	0x95, 0x98, 0xaa, 0xc3, 0x54, 0x87, 0xb3, 0x23, 0x2d, 0x32, 0x31, 0xbd,
	0x93, 0xb7, 0xdb, 0x7d, 0xf3, 0x6f, 0x9e, 0xb9
};
static const uint8_t nist_kas_ecc_cdh_testvector_59_public_y[] = {
/* QCAVSy */
	0xd8, 0x04, 0x9a, 0x43, 0x57, 0x9c, 0xfa, 0x90, 0xb8, 0x09, 0x3a, 0x94,
	0x41, 0x6c, 0xbe, 0xfb, 0xf9, 0x33, 0x86, 0xf1, 0x5b, 0x3f, 0x6e, 0x19,
	0x0b, 0x6e, 0x34, 0x55, 0xfe, 0xdf, 0xe6, 0x9a
};
static const uint8_t nist_kas_ecc_cdh_testvector_59_private[] = {
/* dIUT */
	0x0f, 0x98, 0x83, 0xba, 0x0e, 0xf3, 0x2e, 0xe7, 0x5d, 0xed, 0x0d, 0x8b,
	0xda, 0x39, 0xa5, 0x14, 0x6a, 0x29, 0xf1, 0xf2, 0x50, 0x7b, 0x3b, 0xd4,
	0x58, 0xdb, 0xea, 0x0b, 0x2b, 0xb0, 0x5b, 0x4d
};
/* QIUTx = abb61b423be5d6c26e21c605832c9142dc1dfe5a5fff28726737936e6fbf516d */
/* QIUTy = 733d2513ef58beab202090586fac91bf0fee31e80ab33473ab23a2d89e58fad6 */
static const uint8_t nist_kas_ecc_cdh_testvector_59_out[] = {
/* ZIUT */
	0x60, 0x5c, 0x16, 0x17, 0x8a, 0x9b, 0xc8, 0x75, 0xdc, 0xbf, 0xf5, 0x4d,
	0x63, 0xfe, 0x00, 0xdf, 0x69, 0x9c, 0x03, 0xe8, 0xa8, 0x88, 0xe9, 0xe9,
	0x4d, 0xfb, 0xab, 0x90, 0xb2, 0x5f, 0x39, 0xb4
};
/* COUNT = 9 */
static const uint8_t nist_kas_ecc_cdh_testvector_60_public_x[] = {
/* QCAVSx */
	0xe0, 0x99, 0xbf, 0x2a, 0x4d, 0x55, 0x74, 0x60, 0xb5, 0x54, 0x44, 0x30,
	0xbb, 0xf6, 0xda, 0x11, 0x00, 0x4d, 0x12, 0x7c, 0xb5, 0xd6, 0x7f, 0x64,
	0xab, 0x07, 0xc9, 0x4f, 0xcd, 0xf5, 0x27, 0x4f
};
static const uint8_t nist_kas_ecc_cdh_testvector_60_public_y[] = {
/* QCAVSy */
	0xd9, 0xc5, 0x0d, 0xbe, 0x70, 0xd7, 0x14, 0xed, 0xb5, 0xe2, 0x21, 0xf4,
	0xe0, 0x20, 0x61, 0x0e, 0xeb, 0x62, 0x70, 0x51, 0x7e, 0x68, 0x8c, 0xa6,
	0x4f, 0xb0, 0xe9, 0x8c, 0x7e, 0xf8, 0xc1, 0xc5
};
static const uint8_t nist_kas_ecc_cdh_testvector_60_private[] = {
/* dIUT */
	0x2b, 0xee, 0xdb, 0x04, 0xb0, 0x5c, 0x69, 0x88, 0xf6, 0xa6, 0x75, 0x00,
	0xbb, 0x81, 0x3f, 0xaf, 0x2c, 0xae, 0x0d, 0x58, 0x0c, 0x92, 0x53, 0xb6,
	0x33, 0x9e, 0x4a, 0x33, 0x37, 0xbb, 0x6c, 0x08
};
/* QIUTx = 3d63e429cb5fa895a9247129bf4e48e89f35d7b11de8158efeb3e106a2a87395 */
/* QIUTy = 0cae9e477ef41e7c8c1064379bb7b554ddcbcae79f9814281f1e50f0403c61f3 */
static const uint8_t nist_kas_ecc_cdh_testvector_60_out[] = {
/* ZIUT */
	0xf9, 0x6e, 0x40, 0xa1, 0xb7, 0x28, 0x40, 0x85, 0x4b, 0xb6, 0x2b, 0xc1,
	0x3c, 0x40, 0xcc, 0x27, 0x95, 0xe3, 0x73, 0xd4, 0xe7, 0x15, 0x98, 0x0b,
	0x26, 0x14, 0x76, 0x83, 0x5a, 0x09, 0x2e, 0x0b
};
/* COUNT = 10 */
static const uint8_t nist_kas_ecc_cdh_testvector_61_public_x[] = {
/* QCAVSx */
	0xf7, 0x5a, 0x5f, 0xe5, 0x6b, 0xda, 0x34, 0xf3, 0xc1, 0x39, 0x62, 0x96,
	0x62, 0x6e, 0xf0, 0x12, 0xdc, 0x07, 0xe4, 0x82, 0x58, 0x38, 0x77, 0x8a,
	0x64, 0x5c, 0x82, 0x48, 0xcf, 0xf0, 0x16, 0x58
};
static const uint8_t nist_kas_ecc_cdh_testvector_61_public_y[] = {
/* QCAVSy */
	0x33, 0xbb, 0xdf, 0x1b, 0x17, 0x72, 0xd8, 0x05, 0x9d, 0xf5, 0x68, 0xb0,
	0x61, 0xf3, 0xf1, 0x12, 0x2f, 0x28, 0xa8, 0xd8, 0x19, 0x16, 0x7c, 0x97,
	0xbe, 0x44, 0x8e, 0x3d, 0xc3, 0xfb, 0x0c, 0x3c
};
static const uint8_t nist_kas_ecc_cdh_testvector_61_private[] = {
/* dIUT */
	0x77, 0xc1, 0x5d, 0xcf, 0x44, 0x61, 0x0e, 0x41, 0x69, 0x6b, 0xab, 0x75,
	0x89, 0x43, 0xef, 0xf1, 0x40, 0x93, 0x33, 0xe4, 0xd5, 0xa1, 0x1b, 0xbe,
	0x72, 0xc8, 0xf6, 0xc3, 0x95, 0xe9, 0xf8, 0x48
};
/* QIUTx = ad5d13c3db508ddcd38457e5991434a251bed49cf5ddcb59cdee73865f138c9f */
/* QIUTy = 62cec1e70588aa4fdfc7b9a09daa678081c04e1208b9d662b8a2214bf8e81a21 */
static const uint8_t nist_kas_ecc_cdh_testvector_61_out[] = {
/* ZIUT */
	0x83, 0x88, 0xfa, 0x79, 0xc4, 0xba, 0xbd, 0xca, 0x02, 0xa8, 0xe8, 0xa3,
	0x4f, 0x9e, 0x43, 0x55, 0x49, 0x76, 0xe4, 0x20, 0xa4, 0xad, 0x27, 0x3c,
	0x81, 0xb2, 0x6e, 0x42, 0x28, 0xe9, 0xd3, 0xa3
};
/* COUNT = 11 */
static const uint8_t nist_kas_ecc_cdh_testvector_62_public_x[] = {
/* QCAVSx */
	0x2d, 0xb4, 0x54, 0x0d, 0x50, 0x23, 0x07, 0x56, 0x15, 0x8a, 0xbf, 0x61,
	0xd9, 0x83, 0x57, 0x12, 0xb6, 0x48, 0x6c, 0x74, 0x31, 0x21, 0x83, 0xcc,
	0xef, 0xca, 0xef, 0x27, 0x97, 0xb7, 0x67, 0x4d
};
static const uint8_t nist_kas_ecc_cdh_testvector_62_public_y[] = {
/* QCAVSy */
	0x62, 0xf5, 0x7f, 0x31, 0x4e, 0x3f, 0x34, 0x95, 0xdc, 0x4e, 0x09, 0x90,
	0x12, 0xf5, 0xe0, 0xba, 0x71, 0x77, 0x0f, 0x96, 0x60, 0xa1, 0xea, 0xda,
	0x54, 0x10, 0x4c, 0xdf, 0xde, 0x77, 0x24, 0x3e
};
static const uint8_t nist_kas_ecc_cdh_testvector_62_private[] = {
/* dIUT */
	0x42, 0xa8, 0x3b, 0x98, 0x50, 0x11, 0xd1, 0x23, 0x03, 0xdb, 0x1a, 0x80,
	0x0f, 0x26, 0x10, 0xf7, 0x4a, 0xa7, 0x1c, 0xdf, 0x19, 0xc6, 0x7d, 0x54,
	0xce, 0x6c, 0x9e, 0xd9, 0x51, 0xe9, 0x09, 0x3e
};
/* QIUTx = ab48caa61ea35f13f8ed07ffa6a13e8db224dfecfae1a7df8b1bb6ebaf0cb97d */
/* QIUTy = 1274530ca2c385a3218bddfbcbf0b4024c9badd5243bff834ebff24a8618dccb */
static const uint8_t nist_kas_ecc_cdh_testvector_62_out[] = {
/* ZIUT */
	0x72, 0x87, 0x7c, 0xea, 0x33, 0xcc, 0xc4, 0x71, 0x50, 0x38, 0xd4, 0xbc,
	0xbd, 0xfe, 0x0e, 0x43, 0xf4, 0x2a, 0x9e, 0x2c, 0x0c, 0x3b, 0x01, 0x7f,
	0xc2, 0x37, 0x0f, 0x4b, 0x9a, 0xcb, 0xda, 0x4a
};
/* COUNT = 12 */
static const uint8_t nist_kas_ecc_cdh_testvector_63_public_x[] = {
/* QCAVSx */
	0xcd, 0x94, 0xfc, 0x94, 0x97, 0xe8, 0x99, 0x07, 0x50, 0x30, 0x9e, 0x9a,
	0x85, 0x34, 0xfd, 0x11, 0x4b, 0x0a, 0x6e, 0x54, 0xda, 0x89, 0xc4, 0x79,
	0x61, 0x01, 0x89, 0x70, 0x41, 0xd1, 0x4e, 0xcb
};
static const uint8_t nist_kas_ecc_cdh_testvector_63_public_y[] = {
/* QCAVSy */
	0xc3, 0xde, 0xf4, 0xb5, 0xfe, 0x04, 0xfa, 0xee, 0x0a, 0x11, 0x93, 0x22,
	0x29, 0xff, 0xf5, 0x63, 0x63, 0x7b, 0xfd, 0xee, 0x0e, 0x79, 0xc6, 0xde,
	0xea, 0xf4, 0x49, 0xf8, 0x54, 0x01, 0xc5, 0xc4
};
static const uint8_t nist_kas_ecc_cdh_testvector_63_private[] = {
/* dIUT */
	0xce, 0xed, 0x35, 0x50, 0x7b, 0x5c, 0x93, 0xea, 0xd5, 0x98, 0x91, 0x19,
	0xb9, 0xba, 0x34, 0x2c, 0xfe, 0x38, 0xe6, 0xe6, 0x38, 0xba, 0x6e, 0xea,
	0x34, 0x3a, 0x55, 0x47, 0x5d, 0xe2, 0x80, 0x0b
};
/* QIUTx = 9a8cd9bd72e71752df91440f77c547509a84df98114e7de4f26cdb39234a625d */
/* QIUTy = d07cfc84c8e144fab2839f5189bb1d7c88631d579bbc58012ed9a2327da52f62 */
static const uint8_t nist_kas_ecc_cdh_testvector_63_out[] = {
/* ZIUT */
	0xe4, 0xe7, 0x40, 0x8d, 0x85, 0xff, 0x0e, 0x0e, 0x9c, 0x83, 0x80, 0x03,
	0xf2, 0x8c, 0xdb, 0xd5, 0x24, 0x7c, 0xdc, 0xe3, 0x1f, 0x32, 0xf6, 0x24,
	0x94, 0xb7, 0x0e, 0x5f, 0x1b, 0xc3, 0x63, 0x07
};
/* COUNT = 13 */
static const uint8_t nist_kas_ecc_cdh_testvector_64_public_x[] = {
/* QCAVSx */
	0x15, 0xb9, 0xe4, 0x67, 0xaf, 0x4d, 0x29, 0x0c, 0x41, 0x74, 0x02, 0xe0,
	0x40, 0x42, 0x6f, 0xe4, 0xcf, 0x23, 0x6b, 0xae, 0x72, 0xba, 0xa3, 0x92,
	0xed, 0x89, 0x78, 0x0d, 0xfc, 0xcd, 0xb4, 0x71
};
static const uint8_t nist_kas_ecc_cdh_testvector_64_public_y[] = {
/* QCAVSy */
	0xcd, 0xf4, 0xe9, 0x17, 0x0f, 0xb9, 0x04, 0x30, 0x2b, 0x8f, 0xd9, 0x3a,
	0x82, 0x0b, 0xa8, 0xcc, 0x7e, 0xd4, 0xef, 0xd3, 0xa6, 0xf2, 0xd6, 0xb0,
	0x5b, 0x80, 0xb2, 0xff, 0x2a, 0xee, 0x4e, 0x77
};
static const uint8_t nist_kas_ecc_cdh_testvector_64_private[] = {
/* dIUT */
	0x43, 0xe0, 0xe9, 0xd9, 0x5a, 0xf4, 0xdc, 0x36, 0x48, 0x3c, 0xdd, 0x19,
	0x68, 0xd2, 0xb7, 0xee, 0xb8, 0x61, 0x1f, 0xcc, 0xe7, 0x7f, 0x3a, 0x4e,
	0x7d, 0x05, 0x9a, 0xe4, 0x3e, 0x50, 0x96, 0x04
};
/* QIUTx = f989cf8ee956a82e7ebd9881cdbfb2fd946189b08db53559bc8cfdd48071eb14 */
/* QIUTy = 5eff28f1a18a616b04b7d337868679f6dd84f9a7b3d7b6f8af276c19611a541d */
static const uint8_t nist_kas_ecc_cdh_testvector_64_out[] = {
/* ZIUT */
	0xed, 0x56, 0xbc, 0xf6, 0x95, 0xb7, 0x34, 0x14, 0x2c, 0x24, 0xec, 0xb1,
	0xfc, 0x1b, 0xb6, 0x4d, 0x08, 0xf1, 0x75, 0xeb, 0x24, 0x3a, 0x31, 0xf3,
	0x7b, 0x3d, 0x9b, 0xb4, 0x40, 0x7f, 0x3b, 0x96
};
/* COUNT = 14 */
static const uint8_t nist_kas_ecc_cdh_testvector_65_public_x[] = {
/* QCAVSx */
	0x49, 0xc5, 0x03, 0xba, 0x6c, 0x4f, 0xa6, 0x05, 0x18, 0x2e, 0x18, 0x6b,
	0x5e, 0x81, 0x11, 0x3f, 0x07, 0x5b, 0xc1, 0x1d, 0xcf, 0xd5, 0x1c, 0x93,
	0x2f, 0xb2, 0x1e, 0x95, 0x1e, 0xee, 0x2f, 0xa1
};
static const uint8_t nist_kas_ecc_cdh_testvector_65_public_y[] = {
/* QCAVSy */
	0x8a, 0xf7, 0x06, 0xff, 0x09, 0x22, 0xd8, 0x7b, 0x3f, 0x0c, 0x5e, 0x4e,
	0x31, 0xd8, 0xb2, 0x59, 0xae, 0xb2, 0x60, 0xa9, 0x26, 0x96, 0x43, 0xed,
	0x52, 0x0a, 0x13, 0xbb, 0x25, 0xda, 0x59, 0x24
};
static const uint8_t nist_kas_ecc_cdh_testvector_65_private[] = {
/* dIUT */
	0xb2, 0xf3, 0x60, 0x0d, 0xf3, 0x36, 0x8e, 0xf8, 0xa0, 0xbb, 0x85, 0xab,
	0x22, 0xf4, 0x1f, 0xc0, 0xe5, 0xf4, 0xfd, 0xd5, 0x4b, 0xe8, 0x16, 0x7a,
	0x5c, 0x3c, 0xd4, 0xb0, 0x8d, 0xb0, 0x49, 0x03
};
/* QIUTx = 69c627625b36a429c398b45c38677cb35d8beb1cf78a571e40e99fe4eac1cd4e */
/* QIUTy = 81690112b0a88f20f7136b28d7d47e5fbc2ada3c8edd87589bc19ec9590637bd */
static const uint8_t nist_kas_ecc_cdh_testvector_65_out[] = {
/* ZIUT */
	0xbc, 0x5c, 0x70, 0x55, 0x08, 0x9f, 0xc9, 0xd6, 0xc8, 0x9f, 0x83, 0xc1,
	0xea, 0x1a, 0xda, 0x87, 0x9d, 0x99, 0x34, 0xb2, 0xea, 0x28, 0xfc, 0xf4,
	0xe4, 0xa7, 0xe9, 0x84, 0xb2, 0x8a, 0xd2, 0xcf
};
/* COUNT = 15 */
static const uint8_t nist_kas_ecc_cdh_testvector_66_public_x[] = {
/* QCAVSx */
	0x19, 0xb3, 0x8d, 0xe3, 0x9f, 0xdd, 0x2f, 0x70, 0xf7, 0x09, 0x16, 0x31,
	0xa4, 0xf7, 0x5d, 0x19, 0x93, 0x74, 0x0b, 0xa9, 0x42, 0x91, 0x62, 0xc2,
	0xa4, 0x53, 0x12, 0x40, 0x16, 0x36, 0xb2, 0x9c
};
static const uint8_t nist_kas_ecc_cdh_testvector_66_public_y[] = {
/* QCAVSy */
	0x09, 0xae, 0xd7, 0x23, 0x2b, 0x28, 0xe0, 0x60, 0x94, 0x17, 0x41, 0xb6,
	0x82, 0x8b, 0xcd, 0xfa, 0x2b, 0xc4, 0x9c, 0xc8, 0x44, 0xf3, 0x77, 0x36,
	0x11, 0x50, 0x4f, 0x82, 0xa3, 0x90, 0xa5, 0xae
};
static const uint8_t nist_kas_ecc_cdh_testvector_66_private[] = {
/* dIUT */
	0x40, 0x02, 0x53, 0x43, 0x07, 0xf8, 0xb6, 0x2a, 0x9b, 0xf6, 0x7f, 0xf6,
	0x41, 0xdd, 0xc6, 0x0f, 0xef, 0x59, 0x3b, 0x17, 0xc3, 0x34, 0x12, 0x39,
	0xe9, 0x5b, 0xdb, 0x3e, 0x57, 0x9b, 0xfd, 0xc8
};
/* QIUTx = 5fe964671315a18aa68a2a6e3dd1fde7e23b8ce7181471cfac43c99e1ae80262 */
/* QIUTy = d5827be282e62c84de531b963884ba832db5d6b2c3a256f0e604fe7e6b8a7f72 */
static const uint8_t nist_kas_ecc_cdh_testvector_66_out[] = {
/* ZIUT */
	0x9a, 0x4e, 0x8e, 0x65, 0x7f, 0x6b, 0x0e, 0x09, 0x7f, 0x47, 0x95, 0x4a,
	0x63, 0xc7, 0x5d, 0x74, 0xfc, 0xba, 0x71, 0xa3, 0x0d, 0x83, 0x65, 0x1e,
	0x3e, 0x5a, 0x91, 0xaa, 0x7c, 0xcd, 0x83, 0x43
};
/* COUNT = 16 */
static const uint8_t nist_kas_ecc_cdh_testvector_67_public_x[] = {
/* QCAVSx */
	0x2c, 0x91, 0xc6, 0x1f, 0x33, 0xad, 0xfe, 0x93, 0x11, 0xc9, 0x42, 0xfd,
	0xbf, 0xf6, 0xba, 0x47, 0x02, 0x0f, 0xef, 0xf4, 0x16, 0xb7, 0xbb, 0x63,
	0xce, 0xc1, 0x3f, 0xaf, 0x9b, 0x09, 0x99, 0x54
};
static const uint8_t nist_kas_ecc_cdh_testvector_67_public_y[] = {
/* QCAVSy */
	0x6c, 0xab, 0x31, 0xb0, 0x64, 0x19, 0xe5, 0x22, 0x1f, 0xca, 0x01, 0x4f,
	0xb8, 0x4e, 0xc8, 0x70, 0x62, 0x2a, 0x1b, 0x12, 0xba, 0xb5, 0xae, 0x43,
	0x68, 0x2a, 0xa7, 0xea, 0x73, 0xea, 0x08, 0xd0
};
static const uint8_t nist_kas_ecc_cdh_testvector_67_private[] = {
/* dIUT */
	0x4d, 0xfa, 0x12, 0xde, 0xfc, 0x60, 0x31, 0x90, 0x21, 0xb6, 0x81, 0xb3,
	0xff, 0x84, 0xa1, 0x0a, 0x51, 0x19, 0x58, 0xc8, 0x50, 0x93, 0x9e, 0xd4,
	0x56, 0x35, 0x93, 0x4b, 0xa4, 0x97, 0x91, 0x47
};
/* QIUTx = c9b2b8496f1440bd4a2d1e52752fd372835b364885e154a7dac49295f281ec7c */
/* QIUTy = fbe6b926a8a4de26ccc83b802b1212400754be25d9f3eeaf008b09870ae76321 */
static const uint8_t nist_kas_ecc_cdh_testvector_67_out[] = {
/* ZIUT */
	0x3c, 0xa1, 0xfc, 0x7a, 0xd8, 0x58, 0xfb, 0x1a, 0x6a, 0xba, 0x23, 0x25,
	0x42, 0xf3, 0xe2, 0xa7, 0x49, 0xff, 0xc7, 0x20, 0x3a, 0x23, 0x74, 0xa3,
	0xf3, 0xd3, 0x26, 0x7f, 0x1f, 0xc9, 0x7b, 0x78
};
/* COUNT = 17 */
static const uint8_t nist_kas_ecc_cdh_testvector_68_public_x[] = {
/* QCAVSx */
	0xa2, 0x8a, 0x2e, 0xdf, 0x58, 0x02, 0x56, 0x68, 0xf7, 0x24, 0xaa, 0xf8,
	0x3a, 0x50, 0x95, 0x6b, 0x7a, 0xc1, 0xcf, 0xbb, 0xff, 0x79, 0xb0, 0x8c,
	0x3b, 0xf8, 0x7d, 0xfd, 0x28, 0x28, 0xd7, 0x67
};
static const uint8_t nist_kas_ecc_cdh_testvector_68_public_y[] = {
/* QCAVSy */
	0xdf, 0xa7, 0xbf, 0xff, 0xd4, 0xc7, 0x66, 0xb8, 0x6a, 0xbe, 0xaf, 0x5c,
	0x99, 0xb6, 0xe5, 0x0c, 0xb9, 0xcc, 0xc9, 0xd9, 0xd0, 0x0b, 0x7f, 0xfc,
	0x78, 0x04, 0xb0, 0x49, 0x1b, 0x67, 0xbc, 0x03
};
static const uint8_t nist_kas_ecc_cdh_testvector_68_private[] = {
/* dIUT */
	0x13, 0x31, 0xf6, 0xd8, 0x74, 0xa4, 0xed, 0x3b, 0xc4, 0xa2, 0xc6, 0xe9,
	0xc7, 0x43, 0x31, 0xd3, 0x03, 0x97, 0x96, 0x31, 0x4b, 0xee, 0xe3, 0xb7,
	0x15, 0x2f, 0xcd, 0xba, 0x55, 0x56, 0x30, 0x4e
};
/* QIUTx = 59e1e101521046ad9cf1d082e9d2ec7dd22530cce064991f1e55c5bcf5fcb591 */
/* QIUTy = 482f4f673176c8fdaa0bb6e59b15a3e47454e3a04297d3863c9338d98add1f37 */
static const uint8_t nist_kas_ecc_cdh_testvector_68_out[] = {
/* ZIUT */
	0x1a, 0xaa, 0xbe, 0x7e, 0xe6, 0xe4, 0xa6, 0xfa, 0x73, 0x22, 0x91, 0x20,
	0x24, 0x33, 0xa2, 0x37, 0xdf, 0x1b, 0x49, 0xbc, 0x53, 0x86, 0x6b, 0xfb,
	0xe0, 0x0d, 0xb9, 0x6a, 0x0f, 0x58, 0x22, 0x4f
};
/* COUNT = 18 */
static const uint8_t nist_kas_ecc_cdh_testvector_69_public_x[] = {
/* QCAVSx */
	0xa2, 0xef, 0x85, 0x7a, 0x08, 0x1f, 0x9d, 0x6e, 0xb2, 0x06, 0xa8, 0x1c,
	0x4c, 0xf7, 0x8a, 0x80, 0x2b, 0xdf, 0x59, 0x8a, 0xe3, 0x80, 0xc8, 0x88,
	0x6e, 0xcd, 0x85, 0xfd, 0xc1, 0xed, 0x76, 0x44
};
static const uint8_t nist_kas_ecc_cdh_testvector_69_public_y[] = {
/* QCAVSy */
	0x56, 0x3c, 0x4c, 0x20, 0x41, 0x9f, 0x07, 0xbc, 0x17, 0xd0, 0x53, 0x9f,
	0xad, 0xe1, 0x85, 0x5e, 0x34, 0x83, 0x95, 0x15, 0xb8, 0x92, 0xc0, 0xf5,
	0xd2, 0x65, 0x61, 0xf9, 0x7f, 0xa0, 0x4d, 0x1a
};
static const uint8_t nist_kas_ecc_cdh_testvector_69_private[] = {
/* dIUT */
	0xdd, 0x5e, 0x9f, 0x70, 0xae, 0x74, 0x00, 0x73, 0xca, 0x02, 0x04, 0xdf,
	0x60, 0x76, 0x3f, 0xb6, 0x03, 0x6c, 0x45, 0x70, 0x9b, 0xf4, 0xa7, 0xbb,
	0x4e, 0x67, 0x14, 0x12, 0xfa, 0xd6, 0x5d, 0xa3
};
/* QIUTx = 30b9db2e2e977bcdc98cb87dd736cbd8e78552121925cf16e1933657c2fb2314 */
/* QIUTy = 6a45028800b81291bce5c2e1fed7ded650620ebbe6050c6f3a7f0dfb4673ab5c */
static const uint8_t nist_kas_ecc_cdh_testvector_69_out[] = {
/* ZIUT */
	0x43, 0x0e, 0x6a, 0x4f, 0xba, 0x44, 0x49, 0xd7, 0x00, 0xd2, 0x73, 0x3e,
	0x55, 0x7f, 0x66, 0xa3, 0xbf, 0x3d, 0x50, 0x51, 0x7c, 0x12, 0x71, 0xb1,
	0xdd, 0xae, 0x11, 0x61, 0xb7, 0xac, 0x79, 0x8c
};
/* COUNT = 19 */
static const uint8_t nist_kas_ecc_cdh_testvector_70_public_x[] = {
/* QCAVSx */
	0xcc, 0xd8, 0xa2, 0xd8, 0x6b, 0xc9, 0x2f, 0x2e, 0x01, 0xbc, 0xe4, 0xd6,
	0x92, 0x2c, 0xf7, 0xfe, 0x16, 0x26, 0xae, 0xd0, 0x44, 0x68, 0x5e, 0x95,
	0xe2, 0xee, 0xbd, 0x46, 0x45, 0x05, 0xf0, 0x1f
};
static const uint8_t nist_kas_ecc_cdh_testvector_70_public_y[] = {
/* QCAVSy */
	0xe9, 0xdd, 0xd5, 0x83, 0xa9, 0x63, 0x5a, 0x66, 0x77, 0x77, 0xd5, 0xb8,
	0xa8, 0xf3, 0x1b, 0x0f, 0x79, 0xeb, 0xa1, 0x2c, 0x75, 0x02, 0x34, 0x10,
	0xb5, 0x4b, 0x85, 0x67, 0xdd, 0xdc, 0x0f, 0x38
};
static const uint8_t nist_kas_ecc_cdh_testvector_70_private[] = {
/* dIUT */
	0x5a, 0xe0, 0x26, 0xcf, 0xc0, 0x60, 0xd5, 0x56, 0x00, 0x71, 0x7e, 0x55,
	0xb8, 0xa1, 0x2e, 0x11, 0x6d, 0x1d, 0x0d, 0xf3, 0x4a, 0xf8, 0x31, 0x97,
	0x90, 0x57, 0x60, 0x7c, 0x2d, 0x9c, 0x2f, 0x76
};
/* QIUTx = 46c9ebd1a4a3c8c0b6d572b5dcfba12467603208a9cb5d2acfbb733c40cf6391 */
/* QIUTy = 46c913a27d044185d38b467ace011e04d4d9bbbb8cb9ae25fa92aaf15a595e86 */
static const uint8_t nist_kas_ecc_cdh_testvector_70_out[] = {
/* ZIUT */
	0x1c, 0xe9, 0xe6, 0x74, 0x05, 0x29, 0x49, 0x9f, 0x98, 0xd1, 0xf1, 0xd7,
	0x13, 0x29, 0x14, 0x7a, 0x33, 0xdf, 0x1d, 0x05, 0xe4, 0x76, 0x5b, 0x53,
	0x9b, 0x11, 0xcf, 0x61, 0x5d, 0x69, 0x74, 0xd3
};
/* COUNT = 20 */
static const uint8_t nist_kas_ecc_cdh_testvector_71_public_x[] = {
/* QCAVSx */
	0xc1, 0x88, 0xff, 0xc8, 0x94, 0x7f, 0x73, 0x01, 0xfb, 0x7b, 0x53, 0xe3,
	0x67, 0x46, 0x09, 0x7c, 0x21, 0x34, 0xbf, 0x9c, 0xc9, 0x81, 0xba, 0x74,
	0xb4, 0xe9, 0xc4, 0x36, 0x1f, 0x59, 0x5e, 0x4e
};
static const uint8_t nist_kas_ecc_cdh_testvector_71_public_y[] = {
/* QCAVSy */
	0xbf, 0x7d, 0x2f, 0x20, 0x56, 0xe7, 0x24, 0x21, 0xef, 0x39, 0x3f, 0x0c,
	0x0f, 0x2b, 0x0e, 0x00, 0x13, 0x0e, 0x3c, 0xac, 0x4a, 0xbb, 0xcc, 0x00,
	0x28, 0x61, 0x68, 0xe8, 0x5e, 0xc5, 0x50, 0x51
};
static const uint8_t nist_kas_ecc_cdh_testvector_71_private[] = {
/* dIUT */
	0xb6, 0x01, 0xac, 0x42, 0x5d, 0x5d, 0xbf, 0x9e, 0x17, 0x35, 0xc5, 0xe2,
	0xd5, 0xbd, 0xb7, 0x9c, 0xa9, 0x8b, 0x3d, 0x5b, 0xe4, 0xa2, 0xcf, 0xd6,
	0xf2, 0x27, 0x3f, 0x15, 0x0e, 0x06, 0x4d, 0x9d
};
/* QIUTx = 7c9e950841d26c8dde8994398b8f5d475a022bc63de7773fcf8d552e01f1ba0a */
/* QIUTy = cc42b9885c9b3bee0f8d8c57d3a8f6355016c019c4062fa22cff2f209b5cc2e1 */
static const uint8_t nist_kas_ecc_cdh_testvector_71_out[] = {
/* ZIUT */
	0x46, 0x90, 0xe3, 0x74, 0x3c, 0x07, 0xd6, 0x43, 0xf1, 0xbc, 0x18, 0x36,
	0x36, 0xab, 0x2a, 0x9c, 0xb9, 0x36, 0xa6, 0x0a, 0x80, 0x21, 0x13, 0xc4,
	0x9b, 0xb1, 0xb3, 0xf2, 0xd0, 0x66, 0x16, 0x60
};
/* COUNT = 21 */
static const uint8_t nist_kas_ecc_cdh_testvector_72_public_x[] = {
/* QCAVSx */
	0x31, 0x7e, 0x10, 0x20, 0xff, 0x53, 0xfc, 0xce, 0xf1, 0x8b, 0xf4, 0x7b,
	0xb7, 0xf2, 0xdd, 0x77, 0x07, 0xfb, 0x7b, 0x7a, 0x75, 0x78, 0xe0, 0x4f,
	0x35, 0xb3, 0xbe, 0xed, 0x22, 0x2a, 0x0e, 0xb6
};
static const uint8_t nist_kas_ecc_cdh_testvector_72_public_y[] = {
/* QCAVSy */
	0x09, 0x42, 0x0c, 0xe5, 0xa1, 0x9d, 0x77, 0xc6, 0xfe, 0x1e, 0xe5, 0x87,
	0xe6, 0xa4, 0x9f, 0xba, 0xf8, 0xf2, 0x80, 0xe8, 0xdf, 0x03, 0x3d, 0x75,
	0x40, 0x33, 0x02, 0xe5, 0xa2, 0x7d, 0xb2, 0xae
};
static const uint8_t nist_kas_ecc_cdh_testvector_72_private[] = {
/* dIUT */
	0xfe, 0xfb, 0x1d, 0xda, 0x18, 0x45, 0x31, 0x2b, 0x5f, 0xce, 0x6b, 0x81,
	0xb2, 0xbe, 0x20, 0x5a, 0xf2, 0xf3, 0xa2, 0x74, 0xf5, 0xa2, 0x12, 0xf6,
	0x6c, 0x0d, 0x9f, 0xc3, 0x3d, 0x7a, 0xe5, 0x35
};
/* QIUTx = 38b54db85500cb20c61056edd3d88b6a9dc26780a047f213a6e1b900f76596eb */
/* QIUTy = 6387e4e5781571e4eb8ae62991a33b5dc33301c5bc7e125d53794a39160d8fd0 */
static const uint8_t nist_kas_ecc_cdh_testvector_72_out[] = {
/* ZIUT */
	0x30, 0xc2, 0x26, 0x1b, 0xd0, 0x00, 0x4e, 0x61, 0xfe, 0xda, 0x2c, 0x16,
	0xaa, 0x5e, 0x21, 0xff, 0xa8, 0xd7, 0xe7, 0xf7, 0xdb, 0xf6, 0xec, 0x37,
	0x9a, 0x43, 0xb4, 0x8e, 0x4b, 0x36, 0xae, 0xb0
};
/* COUNT = 22 */
static const uint8_t nist_kas_ecc_cdh_testvector_73_public_x[] = {
/* QCAVSx */
	0x45, 0xfb, 0x02, 0xb2, 0xce, 0xb9, 0xd7, 0xc7, 0x9d, 0x9c, 0x2f, 0xa9,
	0x3e, 0x9c, 0x79, 0x67, 0xc2, 0xfa, 0x4d, 0xf5, 0x78, 0x9f, 0x96, 0x40,
	0xb2, 0x42, 0x64, 0xb1, 0xe5, 0x24, 0xfc, 0xb1
};
static const uint8_t nist_kas_ecc_cdh_testvector_73_public_y[] = {
/* QCAVSy */
	0x5c, 0x6e, 0x8e, 0xcf, 0x1f, 0x7d, 0x30, 0x23, 0x89, 0x3b, 0x7b, 0x1c,
	0xa1, 0xe4, 0xd1, 0x78, 0x97, 0x2e, 0xe2, 0xa2, 0x30, 0x75, 0x7d, 0xdc,
	0x56, 0x4f, 0xfe, 0x37, 0xf5, 0xc5, 0xa3, 0x21
};
static const uint8_t nist_kas_ecc_cdh_testvector_73_private[] = {
/* dIUT */
	0x33, 0x4a, 0xe0, 0xc4, 0x69, 0x3d, 0x23, 0x93, 0x5a, 0x7e, 0x8e, 0x04,
	0x3e, 0xbb, 0xde, 0x21, 0xe1, 0x68, 0xa7, 0xcb, 0xa3, 0xfa, 0x50, 0x7c,
	0x9b, 0xe4, 0x1d, 0x76, 0x81, 0xe0, 0x49, 0xce
};
/* QIUTx = 3f2bf1589abf3047bf3e54ac9a95379bff95f8f55405f64eca36a7eebe8ffca7 */
/* QIUTy = 5212a94e66c5ae9a8991872f66a72723d80ec5b2e925745c456f5371943b3a06 */
static const uint8_t nist_kas_ecc_cdh_testvector_73_out[] = {
/* ZIUT */
	0x2a, 0xda, 0xe4, 0xa1, 0x38, 0xa2, 0x39, 0xdc, 0xd9, 0x3c, 0x24, 0x3a,
	0x38, 0x03, 0xc3, 0xe4, 0xcf, 0x96, 0xe3, 0x7f, 0xe1, 0x4e, 0x6a, 0x9b,
	0x71, 0x7b, 0xe9, 0x59, 0x99, 0x59, 0xb1, 0x1c
};
/* COUNT = 23 */
static const uint8_t nist_kas_ecc_cdh_testvector_74_public_x[] = {
/* QCAVSx */
	0xa1, 0x9e, 0xf7, 0xbf, 0xf9, 0x8a, 0xda, 0x78, 0x18, 0x42, 0xfb, 0xfc,
	0x51, 0xa4, 0x7a, 0xff, 0x39, 0xb5, 0x93, 0x5a, 0x1c, 0x7d, 0x96, 0x25,
	0xc8, 0xd3, 0x23, 0xd5, 0x11, 0xc9, 0x2d, 0xe6
};
static const uint8_t nist_kas_ecc_cdh_testvector_74_public_y[] = {
/* QCAVSy */
	0xe9, 0xc1, 0x84, 0xdf, 0x75, 0xc9, 0x55, 0xe0, 0x2e, 0x02, 0xe4, 0x00,
	0xff, 0xe4, 0x5f, 0x78, 0xf3, 0x39, 0xe1, 0xaf, 0xe6, 0xd0, 0x56, 0xfb,
	0x32, 0x45, 0xf4, 0x70, 0x0c, 0xe6, 0x06, 0xef
};
static const uint8_t nist_kas_ecc_cdh_testvector_74_private[] = {
/* dIUT */
	0x2c, 0x4b, 0xde, 0x40, 0x21, 0x4f, 0xcc, 0x3b, 0xfc, 0x47, 0xd4, 0xcf,
	0x43, 0x4b, 0x62, 0x9a, 0xcb, 0xe9, 0x15, 0x7f, 0x8f, 0xd0, 0x28, 0x25,
	0x40, 0x33, 0x1d, 0xe7, 0x94, 0x2c, 0xf0, 0x9d
};
/* QIUTx = 29c0807f10cbc42fb45c9989da50681eead716daa7b9e91fd32e062f5eb92ca0 */
/* QIUTy = ff1d6d1955d7376b2da24fe1163a271659136341bc2eb1195fc706dc62e7f34d */
static const uint8_t nist_kas_ecc_cdh_testvector_74_out[] = {
/* ZIUT */
	0x2e, 0x27, 0x7e, 0xc3, 0x0f, 0x5e, 0xa0, 0x7d, 0x6c, 0xe5, 0x13, 0x14,
	0x9b, 0x94, 0x79, 0xb9, 0x6e, 0x07, 0xf4, 0xb6, 0x91, 0x3b, 0x1b, 0x5c,
	0x11, 0x30, 0x5c, 0x14, 0x44, 0xa1, 0xbc, 0x0b
};
/* COUNT = 24 */
static const uint8_t nist_kas_ecc_cdh_testvector_75_public_x[] = {
/* QCAVSx */
	0x35, 0x6c, 0x5a, 0x44, 0x4c, 0x04, 0x9a, 0x52, 0xfe, 0xe0, 0xad, 0xeb,
	0x7e, 0x5d, 0x82, 0xae, 0x5a, 0xa8, 0x30, 0x30, 0xbf, 0xff, 0x31, 0xbb,
	0xf8, 0xce, 0x20, 0x96, 0xcf, 0x16, 0x1c, 0x4b
};
static const uint8_t nist_kas_ecc_cdh_testvector_75_public_y[] = {
/* QCAVSy */
	0x57, 0xd1, 0x28, 0xde, 0x8b, 0x2a, 0x57, 0xa0, 0x94, 0xd1, 0xa0, 0x01,
	0xe5, 0x72, 0x17, 0x3f, 0x96, 0xe8, 0x86, 0x6a, 0xe3, 0x52, 0xbf, 0x29,
	0xcd, 0xda, 0xf9, 0x2f, 0xc8, 0x5b, 0x2f, 0x92
};
static const uint8_t nist_kas_ecc_cdh_testvector_75_private[] = {
/* dIUT */
	0x85, 0xa2, 0x68, 0xf9, 0xd7, 0x77, 0x2f, 0x99, 0x0c, 0x36, 0xb4, 0x2b,
	0x0a, 0x33, 0x1a, 0xdc, 0x92, 0xb5, 0x94, 0x1d, 0xe0, 0xb8, 0x62, 0xd5,
	0xd8, 0x9a, 0x34, 0x7c, 0xbf, 0x8f, 0xaa, 0xb0
};
/* QIUTx = 9cf4b98581ca1779453cc816ff28b4100af56cf1bf2e5bc312d83b6b1b21d333 */
/* QIUTy = 7a5504fcac5231a0d12d658218284868229c844a04a3450d6c7381abe080bf3b */
static const uint8_t nist_kas_ecc_cdh_testvector_75_out[] = {
/* ZIUT */
	0x1e, 0x51, 0x37, 0x3b, 0xd2, 0xc6, 0x04, 0x4c, 0x12, 0x9c, 0x43, 0x6e,
	0x74, 0x2a, 0x55, 0xbe, 0x2a, 0x66, 0x8a, 0x85, 0xae, 0x08, 0x44, 0x1b,
	0x67, 0x56, 0x44, 0x5d, 0xf5, 0x49, 0x38, 0x57
};
/* [P-384] */
/* COUNT = 0 */
static const uint8_t nist_kas_ecc_cdh_testvector_76_public_x[] = {
/* QCAVSx */
	0xa7, 0xc7, 0x6b, 0x97, 0x0c, 0x3b, 0x5f, 0xe8, 0xb0, 0x5d, 0x28, 0x38,
	0xae, 0x04, 0xab, 0x47, 0x69, 0x7b, 0x9e, 0xaf, 0x52, 0xe7, 0x64, 0x59,
	0x2e, 0xfd, 0xa2, 0x7f, 0xe7, 0x51, 0x32, 0x72, 0x73, 0x44, 0x66, 0xb4,
	0x00, 0x09, 0x1a, 0xdb, 0xf2, 0xd6, 0x8c, 0x58, 0xe0, 0xc5, 0x00, 0x66
};
static const uint8_t nist_kas_ecc_cdh_testvector_76_public_y[] = {
/* QCAVSy */
	0xac, 0x68, 0xf1, 0x9f, 0x2e, 0x1c, 0xb8, 0x79, 0xae, 0xd4, 0x3a, 0x99,
	0x69, 0xb9, 0x1a, 0x08, 0x39, 0xc4, 0xc3, 0x8a, 0x49, 0x74, 0x9b, 0x66,
	0x1e, 0xfe, 0xdf, 0x24, 0x34, 0x51, 0x91, 0x5e, 0xd0, 0x90, 0x5a, 0x32,
	0xb0, 0x60, 0x99, 0x2b, 0x46, 0x8c, 0x64, 0x76, 0x6f, 0xc8, 0x43, 0x7a
};
static const uint8_t nist_kas_ecc_cdh_testvector_76_private[] = {
/* dIUT */
	0x3c, 0xc3, 0x12, 0x2a, 0x68, 0xf0, 0xd9, 0x50, 0x27, 0xad, 0x38, 0xc0,
	0x67, 0x91, 0x6b, 0xa0, 0xeb, 0x8c, 0x38, 0x89, 0x4d, 0x22, 0xe1, 0xb1,
	0x56, 0x18, 0xb6, 0x81, 0x8a, 0x66, 0x17, 0x74, 0xad, 0x46, 0x3b, 0x20,
	0x5d, 0xa8, 0x8c, 0xf6, 0x99, 0xab, 0x4d, 0x43, 0xc9, 0xcf, 0x98, 0xa1
};
/* QIUTx = 9803807f2f6d2fd966cdd0290bd410c0190352fbec7ff6247de1302df86f25d34fe4a97bef60cff548355c015dbb3e5f */
/* QIUTy = ba26ca69ec2f5b5d9dad20cc9da711383a9dbe34ea3fa5a2af75b46502629ad54dd8b7d73a8abb06a3a3be47d650cc99 */
static const uint8_t nist_kas_ecc_cdh_testvector_76_out[] = {
/* ZIUT */
	0x5f, 0x9d, 0x29, 0xdc, 0x5e, 0x31, 0xa1, 0x63, 0x06, 0x03, 0x56, 0x21,
	0x36, 0x69, 0xc8, 0xce, 0x13, 0x2e, 0x22, 0xf5, 0x7c, 0x9a, 0x04, 0xf4,
	0x0b, 0xa7, 0xfc, 0xea, 0xd4, 0x93, 0xb4, 0x57, 0xe5, 0x62, 0x1e, 0x76,
	0x6c, 0x40, 0xa2, 0xe3, 0xd4, 0xd6, 0xa0, 0x4b, 0x25, 0xe5, 0x33, 0xf1
};
/* COUNT = 1 */
static const uint8_t nist_kas_ecc_cdh_testvector_77_public_x[] = {
/* QCAVSx */
	0x30, 0xf4, 0x3f, 0xcf, 0x2b, 0x6b, 0x00, 0xde, 0x53, 0xf6, 0x24, 0xf1,
	0x54, 0x30, 0x90, 0x68, 0x18, 0x39, 0x71, 0x7d, 0x53, 0xc7, 0xc9, 0x55,
	0xd1, 0xd6, 0x9e, 0xfa, 0xf0, 0x34, 0x9b, 0x73, 0x63, 0xac, 0xb4, 0x47,
	0x24, 0x01, 0x01, 0xcb, 0xb3, 0xaf, 0x66, 0x41, 0xce, 0x4b, 0x88, 0xe0
};
static const uint8_t nist_kas_ecc_cdh_testvector_77_public_y[] = {
/* QCAVSy */
	0x25, 0xe4, 0x6c, 0x0c, 0x54, 0xf0, 0x16, 0x2a, 0x77, 0xef, 0xcc, 0x27,
	0xb6, 0xea, 0x79, 0x20, 0x02, 0xae, 0x2b, 0xa8, 0x27, 0x14, 0x29, 0x9c,
	0x86, 0x08, 0x57, 0xa6, 0x81, 0x53, 0xab, 0x62, 0xe5, 0x25, 0xec, 0x05,
	0x30, 0xd8, 0x1b, 0x5a, 0xa1, 0x58, 0x97, 0x98, 0x1e, 0x85, 0x87, 0x57
};
static const uint8_t nist_kas_ecc_cdh_testvector_77_private[] = {
/* dIUT */
	0x92, 0x86, 0x0c, 0x21, 0xbd, 0xe0, 0x61, 0x65, 0xf8, 0xe9, 0x00, 0xc6,
	0x87, 0xf8, 0xef, 0x0a, 0x05, 0xd1, 0x4f, 0x29, 0x0b, 0x3f, 0x07, 0xd8,
	0xb3, 0xa8, 0xcc, 0x64, 0x04, 0x36, 0x6e, 0x5d, 0x51, 0x19, 0xcd, 0x6d,
	0x03, 0xfb, 0x12, 0xdc, 0x58, 0xe8, 0x9f, 0x13, 0xdf, 0x9c, 0xd7, 0x83
};
/* QIUTx = ea4018f5a307c379180bf6a62fd2ceceebeeb7d4df063a66fb838aa35243419791f7e2c9d4803c9319aa0eb03c416b66 */
/* QIUTy = 68835a91484f05ef028284df6436fb88ffebabcdd69ab0133e6735a1bcfb37203d10d340a8328a7b68770ca75878a1a6 */
static const uint8_t nist_kas_ecc_cdh_testvector_77_out[] = {
/* ZIUT */
	0xa2, 0x37, 0x42, 0xa2, 0xc2, 0x67, 0xd7, 0x42, 0x5f, 0xda, 0x94, 0xb9,
	0x3f, 0x93, 0xbb, 0xcc, 0x24, 0x79, 0x1a, 0xc5, 0x1c, 0xd8, 0xfd, 0x50,
	0x1a, 0x23, 0x8d, 0x40, 0x81, 0x2f, 0x4c, 0xbf, 0xc5, 0x9a, 0xac, 0x95,
	0x20, 0xd7, 0x58, 0xcf, 0x78, 0x9c, 0x76, 0x30, 0x0c, 0x69, 0xd2, 0xff
};
/* COUNT = 2 */
static const uint8_t nist_kas_ecc_cdh_testvector_78_public_x[] = {
/* QCAVSx */
	0x1a, 0xef, 0xbf, 0xa2, 0xc6, 0xc8, 0xc8, 0x55, 0xa1, 0xa2, 0x16, 0x77,
	0x45, 0x50, 0xb7, 0x9a, 0x24, 0xcd, 0xa3, 0x76, 0x07, 0xbb, 0x1f, 0x7c,
	0xc9, 0x06, 0x65, 0x0e, 0xe4, 0xb3, 0x81, 0x6d, 0x68, 0xf6, 0xa9, 0xc7,
	0x5d, 0xa6, 0xe4, 0x24, 0x2c, 0xeb, 0xfb, 0x66, 0x52, 0xf6, 0x51, 0x80
};
static const uint8_t nist_kas_ecc_cdh_testvector_78_public_y[] = {
/* QCAVSy */
	0x41, 0x9d, 0x28, 0xb7, 0x23, 0xeb, 0xad, 0xb7, 0x65, 0x8f, 0xce, 0xbb,
	0x9a, 0xd9, 0xb7, 0xad, 0xea, 0x67, 0x4f, 0x1d, 0xa3, 0xdc, 0x6b, 0x63,
	0x97, 0xb5, 0x5d, 0xa0, 0xf6, 0x1a, 0x3e, 0xdd, 0xac, 0xb4, 0xac, 0xdb,
	0x14, 0x44, 0x1c, 0xb2, 0x14, 0xb0, 0x4a, 0x08, 0x44, 0xc0, 0x2f, 0xa3
};
static const uint8_t nist_kas_ecc_cdh_testvector_78_private[] = {
/* dIUT */
	0x12, 0xcf, 0x6a, 0x22, 0x3a, 0x72, 0x35, 0x25, 0x43, 0x83, 0x0f, 0x3f,
	0x18, 0x53, 0x0d, 0x5c, 0xb3, 0x7f, 0x26, 0x88, 0x0a, 0x0b, 0x29, 0x44,
	0x82, 0xc8, 0xa8, 0xef, 0x8a, 0xfa, 0xd0, 0x9a, 0xa7, 0x8b, 0x7d, 0xc2,
	0xf2, 0x78, 0x9a, 0x78, 0xc6, 0x6a, 0xf5, 0xd1, 0xcc, 0x55, 0x38, 0x53
};
/* QIUTx = fcfcea085e8cf74d0dced1620ba8423694f903a219bbf901b0b59d6ac81baad316a242ba32bde85cb248119b852fab66 */
/* QIUTy = 972e3c68c7ab402c5836f2a16ed451a33120a7750a6039f3ff15388ee622b7065f7122bf6d51aefbc29b37b03404581b */
static const uint8_t nist_kas_ecc_cdh_testvector_78_out[] = {
/* ZIUT */
	0x3d, 0x2e, 0x64, 0x0f, 0x35, 0x08, 0x05, 0xee, 0xd1, 0xff, 0x43, 0xb4,
	0x0a, 0x72, 0xb2, 0xab, 0xed, 0x0a, 0x51, 0x8b, 0xce, 0xbe, 0x8f, 0x2d,
	0x15, 0xb1, 0x11, 0xb6, 0x77, 0x32, 0x23, 0xda, 0x3c, 0x34, 0x89, 0x12,
	0x1d, 0xb1, 0x73, 0xd4, 0x14, 0xb5, 0xbd, 0x5a, 0xd7, 0x15, 0x34, 0x35
};
/* COUNT = 3 */
static const uint8_t nist_kas_ecc_cdh_testvector_79_public_x[] = {
/* QCAVSx */
	0x8b, 0xc0, 0x89, 0x32, 0x6e, 0xc5, 0x5b, 0x9c, 0xf5, 0x9b, 0x34, 0xf0,
	0xeb, 0x75, 0x4d, 0x93, 0x59, 0x6c, 0xa2, 0x90, 0xfc, 0xb3, 0x44, 0x4c,
	0x83, 0xd4, 0xde, 0x3a, 0x56, 0x07, 0x03, 0x7e, 0xc3, 0x97, 0x68, 0x3f,
	0x8c, 0xef, 0x07, 0xea, 0xb2, 0xfe, 0x35, 0x7e, 0xae, 0x36, 0xc4, 0x49
};
static const uint8_t nist_kas_ecc_cdh_testvector_79_public_y[] = {
/* QCAVSy */
	0xd9, 0xd1, 0x6c, 0xe8, 0xac, 0x85, 0xb3, 0xf1, 0xe9, 0x45, 0x68, 0x52,
	0x1a, 0xae, 0x53, 0x4e, 0x67, 0x13, 0x9e, 0x31, 0x0e, 0xc7, 0x26, 0x93,
	0x52, 0x6a, 0xa2, 0xe9, 0x27, 0xb5, 0xb3, 0x22, 0xc9, 0x5a, 0x1a, 0x03,
	0x3c, 0x22, 0x9c, 0xb6, 0x77, 0x0c, 0x95, 0x7c, 0xd3, 0x14, 0x8d, 0xd7
};
static const uint8_t nist_kas_ecc_cdh_testvector_79_private[] = {
/* dIUT */
	0x8d, 0xd4, 0x80, 0x63, 0xa3, 0xa0, 0x58, 0xc3, 0x34, 0xb5, 0xcc, 0x7a,
	0x4c, 0xe0, 0x7d, 0x02, 0xe5, 0xee, 0x6d, 0x8f, 0x1f, 0x3c, 0x51, 0xa1,
	0x60, 0x09, 0x62, 0xcb, 0xab, 0x46, 0x26, 0x90, 0xae, 0x3c, 0xd9, 0x74,
	0xfb, 0x39, 0xe4, 0x0b, 0x0e, 0x84, 0x3d, 0xaa, 0x0f, 0xd3, 0x2d, 0xe1
};
/* QIUTx = e38c9846248123c3421861ea4d32669a7b5c3c08376ad28104399494c84ff5efa3894adb2c6cbe8c3c913ef2eec5bd3c */
/* QIUTy = 9fa84024a1028796df84021f7b6c9d02f0f4bd1a612a03cbf75a0beea43fef8ae84b48c60172aadf09c1ad016d0bf3ce */
static const uint8_t nist_kas_ecc_cdh_testvector_79_out[] = {
/* ZIUT */
	0x6a, 0x42, 0xcf, 0xc3, 0x92, 0xab, 0xa0, 0xbf, 0xd3, 0xd1, 0x7b, 0x7c,
	0xcf, 0x06, 0x2b, 0x91, 0xfc, 0x09, 0xbb, 0xf3, 0x41, 0x76, 0x12, 0xd0,
	0x2a, 0x90, 0xbd, 0xde, 0x62, 0xae, 0x40, 0xc5, 0x4b, 0xb2, 0xe5, 0x6e,
	0x16, 0x7d, 0x6b, 0x70, 0xdb, 0x67, 0x00, 0x97, 0xeb, 0x8d, 0xb8, 0x54
};
/* COUNT = 4 */
static const uint8_t nist_kas_ecc_cdh_testvector_80_public_x[] = {
/* QCAVSx */
	0xeb, 0x95, 0x2e, 0x2d, 0x9a, 0xc0, 0xc2, 0x0c, 0x6c, 0xc4, 0x8f, 0xb2,
	0x25, 0xc2, 0xad, 0x15, 0x4f, 0x53, 0xc8, 0x75, 0x0b, 0x00, 0x3f, 0xd3,
	0xb4, 0xed, 0x8e, 0xd1, 0xdc, 0x0d, 0xef, 0xac, 0x61, 0xbc, 0xdd, 0xe0,
	0x2a, 0x2b, 0xcf, 0xee, 0x70, 0x67, 0xd7, 0x5d, 0x34, 0x2e, 0xd2, 0xb0
};
static const uint8_t nist_kas_ecc_cdh_testvector_80_public_y[] = {
/* QCAVSy */
	0xf1, 0x82, 0x82, 0x05, 0xba, 0xec, 0xe8, 0x2d, 0x1b, 0x26, 0x7d, 0x0d,
	0x7f, 0xf2, 0xf9, 0xc9, 0xe1, 0x5b, 0x69, 0xa7, 0x2d, 0xf4, 0x70, 0x58,
	0xa9, 0x7f, 0x38, 0x91, 0x00, 0x5d, 0x1f, 0xb3, 0x88, 0x58, 0xf5, 0x60,
	0x3d, 0xe8, 0x40, 0xe5, 0x91, 0xdf, 0xa4, 0xf6, 0xe7, 0xd4, 0x89, 0xe1
};
static const uint8_t nist_kas_ecc_cdh_testvector_80_private[] = {
/* dIUT */
	0x84, 0xec, 0xe6, 0xcc, 0x34, 0x29, 0x30, 0x9b, 0xd5, 0xb2, 0x3e, 0x95,
	0x97, 0x93, 0xed, 0x2b, 0x11, 0x1e, 0xc5, 0xcb, 0x43, 0xb6, 0xc1, 0x80,
	0x85, 0xfc, 0xae, 0xa9, 0xef, 0xa0, 0x68, 0x5d, 0x98, 0xa6, 0x26, 0x2e,
	0xe0, 0xd3, 0x30, 0xee, 0x25, 0x0b, 0xc8, 0xa6, 0x7d, 0x0e, 0x73, 0x3f
};
/* QIUTx = 3222063a2997b302ee60ee1961108ff4c7acf1c0ef1d5fb0d164b84bce71c431705cb9aea9a45f5d73806655a058bee3 */
/* QIUTy = e61fa9e7fbe7cd43abf99596a3d3a039e99fa9dc93b0bdd9cad81966d17eeaf557068afa7c78466bb5b22032d1100fa6 */
static const uint8_t nist_kas_ecc_cdh_testvector_80_out[] = {
/* ZIUT */
	0xce, 0x7b, 0xa4, 0x54, 0xd4, 0x41, 0x27, 0x29, 0xa3, 0x2b, 0xb8, 0x33,
	0xa2, 0xd1, 0xfd, 0x2a, 0xe6, 0x12, 0xd4, 0x66, 0x7c, 0x3a, 0x90, 0x0e,
	0x06, 0x92, 0x14, 0x81, 0x86, 0x13, 0x44, 0x7d, 0xf8, 0xc6, 0x11, 0xde,
	0x66, 0xda, 0x20, 0x0d, 0xb7, 0xc3, 0x75, 0xcf, 0x91, 0x3e, 0x44, 0x05
};
/* COUNT = 5 */
static const uint8_t nist_kas_ecc_cdh_testvector_81_public_x[] = {
/* QCAVSx */
	0x44, 0x1d, 0x02, 0x9e, 0x24, 0x4e, 0xb7, 0x16, 0x8d, 0x64, 0x7d, 0x4d,
	0xf5, 0x0d, 0xb5, 0xf4, 0xe4, 0x97, 0x4a, 0xb3, 0xfd, 0xaf, 0x02, 0x2a,
	0xff, 0x05, 0x8b, 0x36, 0x95, 0xd0, 0xb8, 0xc8, 0x14, 0xcc, 0x88, 0xda,
	0x62, 0x85, 0xdc, 0x6d, 0xf1, 0xac, 0x55, 0xc5, 0x53, 0x88, 0x50, 0x03
};
static const uint8_t nist_kas_ecc_cdh_testvector_81_public_y[] = {
/* QCAVSy */
	0xe8, 0x02, 0x5a, 0xc2, 0x3a, 0x41, 0xd4, 0xb1, 0xea, 0x2a, 0xa4, 0x6c,
	0x50, 0xc6, 0xe4, 0x79, 0x94, 0x6b, 0x59, 0xb6, 0xd7, 0x64, 0x97, 0xcd,
	0x92, 0x49, 0x97, 0x7e, 0x0b, 0xfe, 0x4a, 0x62, 0x62, 0x62, 0x2f, 0x13,
	0xd4, 0x2a, 0x3c, 0x43, 0xd6, 0x6b, 0xdb, 0xb3, 0x04, 0x03, 0xc3, 0x45
};
static const uint8_t nist_kas_ecc_cdh_testvector_81_private[] = {
/* dIUT */
	0x68, 0xfc, 0xe2, 0x12, 0x1d, 0xc3, 0xa1, 0xe3, 0x7b, 0x10, 0xf1, 0xdd,
	0xe3, 0x09, 0xf9, 0xe2, 0xe1, 0x8f, 0xac, 0x47, 0xcd, 0x17, 0x70, 0x95,
	0x14, 0x51, 0xc3, 0x48, 0x4c, 0xdb, 0x77, 0xcb, 0x13, 0x6d, 0x00, 0xe7,
	0x31, 0x26, 0x05, 0x97, 0xcc, 0x28, 0x59, 0x60, 0x1c, 0x01, 0xa2, 0x5b
};
/* QIUTx = 868be0e694841830e424d913d8e7d86b84ee1021d82b0ecf523f09fe89a76c0c95c49f2dfbcf829c1e39709d55efbb3b */
/* QIUTy = 9195eb183675b40fd92f51f37713317e4a9b4f715c8ab22e0773b1bc71d3a219f05b8116074658ee86b52e36f3897116 */
static const uint8_t nist_kas_ecc_cdh_testvector_81_out[] = {
/* ZIUT */
	0xba, 0x69, 0xf0, 0xac, 0xdf, 0x3e, 0x1c, 0xa9, 0x5c, 0xaa, 0xac, 0x4e,
	0xca, 0xf4, 0x75, 0xbb, 0xe5, 0x1b, 0x54, 0x77, 0x7e, 0xfc, 0xe0, 0x1c,
	0xa3, 0x81, 0xf4, 0x53, 0x70, 0xe4, 0x86, 0xfe, 0x87, 0xf9, 0xf4, 0x19,
	0xb1, 0x50, 0xc6, 0x1e, 0x32, 0x9a, 0x28, 0x6d, 0x1a, 0xa2, 0x65, 0xec
};
/* COUNT = 6 */
static const uint8_t nist_kas_ecc_cdh_testvector_82_public_x[] = {
/* QCAVSx */
	0x3d, 0x4e, 0x6b, 0xf0, 0x8a, 0x73, 0x40, 0x4a, 0xcc, 0xc1, 0x62, 0x98,
	0x73, 0x46, 0x8e, 0x42, 0x69, 0xe8, 0x2d, 0x90, 0xd8, 0x32, 0xe5, 0x8a,
	0xd7, 0x21, 0x42, 0x63, 0x9b, 0x5a, 0x05, 0x6a, 0xd8, 0xd3, 0x5c, 0x66,
	0xc6, 0x0e, 0x81, 0x49, 0xfa, 0xc0, 0xc7, 0x97, 0xbc, 0xeb, 0x7c, 0x2f
};
static const uint8_t nist_kas_ecc_cdh_testvector_82_public_y[] = {
/* QCAVSy */
	0x9b, 0x03, 0x08, 0xdc, 0x7f, 0x0e, 0x6d, 0x29, 0xf8, 0xc2, 0x77, 0xac,
	0xbc, 0x65, 0xa2, 0x1e, 0x5a, 0xdb, 0x83, 0xd1, 0x1e, 0x68, 0x73, 0xbc,
	0x0a, 0x07, 0xfd, 0xa0, 0x99, 0x7f, 0x48, 0x25, 0x04, 0x60, 0x2f, 0x59,
	0xe1, 0x0b, 0xc5, 0xcb, 0x47, 0x6b, 0x83, 0xd0, 0xa4, 0xf7, 0x5e, 0x71
};
static const uint8_t nist_kas_ecc_cdh_testvector_82_private[] = {
/* dIUT */
	0xb1, 0x76, 0x4c, 0x54, 0x89, 0x7e, 0x7a, 0xae, 0x6d, 0xe9, 0xe7, 0x75,
	0x1f, 0x2f, 0x37, 0xde, 0x84, 0x92, 0x91, 0xf8, 0x8f, 0x0f, 0x91, 0x09,
	0x31, 0x55, 0xb8, 0x58, 0xd1, 0xcc, 0x32, 0xa3, 0xa8, 0x79, 0x80, 0xf7,
	0x06, 0xb8, 0x6c, 0xc8, 0x3f, 0x92, 0x7b, 0xdf, 0xdb, 0xea, 0xe0, 0xbd
};
/* QIUTx = c371222feaa6770c6f3ea3e0dac9740def4fcf821378b7f91ff937c21e0470f70f3a31d5c6b2912195f10926942b48ae */
/* QIUTy = 047d6b4d765123563f81116bc665b7b8cc6207830d805fd84da7cb805a65baa7c12fd592d1b5b5e3e65d9672a9ef7662 */
static const uint8_t nist_kas_ecc_cdh_testvector_82_out[] = {
/* ZIUT */
	0x1a, 0x66, 0x88, 0xee, 0x1d, 0x6e, 0x59, 0x86, 0x5d, 0x8e, 0x3a, 0xda,
	0x37, 0x78, 0x1d, 0x36, 0xbb, 0x0c, 0x27, 0x17, 0xee, 0xf9, 0x2e, 0x61,
	0x96, 0x4d, 0x39, 0x27, 0xcb, 0x76, 0x5c, 0x29, 0x65, 0xea, 0x80, 0xf7,
	0xf6, 0x3e, 0x58, 0xc3, 0x22, 0xba, 0x03, 0x97, 0xfa, 0xea, 0xf6, 0x2b
};
/* COUNT = 7 */
static const uint8_t nist_kas_ecc_cdh_testvector_83_public_x[] = {
/* QCAVSx */
	0xf5, 0xf6, 0xbe, 0xf1, 0xd1, 0x10, 0xda, 0x03, 0xbe, 0x00, 0x17, 0xea,
	0xc7, 0x60, 0xcc, 0x34, 0xb2, 0x4d, 0x09, 0x2f, 0x73, 0x6f, 0x23, 0x7b,
	0xc7, 0x05, 0x4b, 0x38, 0x65, 0x31, 0x2a, 0x81, 0x3b, 0xcb, 0x62, 0xd2,
	0x97, 0xfb, 0x10, 0xa4, 0xf7, 0xab, 0xf5, 0x47, 0x08, 0xfe, 0x2d, 0x3d
};
static const uint8_t nist_kas_ecc_cdh_testvector_83_public_y[] = {
/* QCAVSy */
	0x06, 0xfd, 0xf8, 0xd7, 0xdc, 0x03, 0x2f, 0x4e, 0x10, 0x01, 0x0b, 0xf1,
	0x9c, 0xbf, 0x61, 0x59, 0x32, 0x12, 0x52, 0xff, 0x41, 0x5f, 0xb9, 0x19,
	0x20, 0xd4, 0x38, 0xf2, 0x4e, 0x67, 0xe6, 0x0c, 0x2e, 0xb0, 0x46, 0x32,
	0x04, 0x67, 0x9f, 0xa3, 0x56, 0xaf, 0x44, 0xce, 0xa9, 0xc9, 0xeb, 0xf5
};
static const uint8_t nist_kas_ecc_cdh_testvector_83_private[] = {
/* dIUT */
	0xf0, 0xf7, 0xa9, 0x6e, 0x70, 0xd9, 0x8f, 0xd5, 0xa3, 0x0a, 0xd6, 0x40,
	0x6c, 0xf5, 0x6e, 0xb5, 0xb7, 0x2a, 0x51, 0x0e, 0x9f, 0x19, 0x2f, 0x50,
	0xe1, 0xf8, 0x45, 0x24, 0xdb, 0xf3, 0xd2, 0x43, 0x9f, 0x72, 0x87, 0xbb,
	0x36, 0xf5, 0xaa, 0x91, 0x2a, 0x79, 0xde, 0xaa, 0xb4, 0xad, 0xea, 0x82
};
/* QIUTx = 99c8c41cb1ab5e0854a346e4b08a537c1706a61553387c8d94943ab15196d40dbaa55b8210a77a5d00915f2c4ea69eab */
/* QIUTy = 5531065bdcf17bfb3cb55a02e41a57c7f694c383ad289f900fbd656c2233a93c92e933e7a26f54cbb56f0ad875c51bb0 */
static const uint8_t nist_kas_ecc_cdh_testvector_83_out[] = {
/* ZIUT */
	0xd0, 0x6a, 0x56, 0x8b, 0xf2, 0x33, 0x6b, 0x90, 0xcb, 0xac, 0x32, 0x51,
	0x61, 0xbe, 0x76, 0x95, 0xea, 0xcb, 0x22, 0x95, 0xf5, 0x99, 0x50, 0x0d,
	0x78, 0x7f, 0x07, 0x26, 0x12, 0xac, 0xa3, 0x13, 0xee, 0x5d, 0x87, 0x4f,
	0x80, 0x7d, 0xde, 0xf6, 0xc1, 0xf0, 0x23, 0xfe, 0x2b, 0x6e, 0x7c, 0xd0
};
/* COUNT = 8 */
static const uint8_t nist_kas_ecc_cdh_testvector_84_public_x[] = {
/* QCAVSx */
	0x7c, 0xde, 0xc7, 0x7e, 0x07, 0x37, 0xea, 0x37, 0xc6, 0x7b, 0x89, 0xb7,
	0x13, 0x7f, 0xe3, 0x88, 0x18, 0x01, 0x0f, 0x44, 0x64, 0x43, 0x8e, 0xe4,
	0xd1, 0xd3, 0x5a, 0x0c, 0x48, 0x8c, 0xad, 0x3f, 0xde, 0x2f, 0x37, 0xd0,
	0x08, 0x85, 0xd3, 0x6d, 0x3b, 0x79, 0x5b, 0x9f, 0x93, 0xd2, 0x3a, 0x67
};
static const uint8_t nist_kas_ecc_cdh_testvector_84_public_y[] = {
/* QCAVSy */
	0x28, 0xc4, 0x2e, 0xe8, 0xd6, 0x02, 0x7c, 0x56, 0xcf, 0x97, 0x9b, 0xa4,
	0xc2, 0x29, 0xfd, 0xb0, 0x1d, 0x23, 0x49, 0x44, 0xf8, 0xac, 0x43, 0x36,
	0x50, 0x11, 0x2c, 0x3c, 0xf0, 0xf0, 0x28, 0x44, 0xe8, 0x88, 0xa3, 0x56,
	0x9d, 0xfe, 0xf7, 0x82, 0x8a, 0x8a, 0x88, 0x45, 0x89, 0xaa, 0x05, 0x5e
};
static const uint8_t nist_kas_ecc_cdh_testvector_84_private[] = {
/* dIUT */
	0x9e, 0xfb, 0x87, 0xdd, 0xc6, 0x1d, 0x43, 0xc4, 0x82, 0xba, 0x66, 0xe1,
	0xb1, 0x43, 0xae, 0xf6, 0x78, 0xfb, 0xd0, 0xd1, 0xbe, 0xbc, 0x20, 0x00,
	0x94, 0x1f, 0xab, 0xe6, 0x77, 0xfe, 0x5b, 0x70, 0x6b, 0xf7, 0x8f, 0xce,
	0x36, 0xd1, 0x00, 0xb1, 0x7c, 0xc7, 0x87, 0xea, 0xd7, 0x4b, 0xbc, 0xa2
};
/* QIUTx = 4c34efee8f0c95565d2065d1bbac2a2dd25ae964320eb6bccedc5f3a9b42a881a1afca1bb6b880584fa27b01c193cd92 */
/* QIUTy = d8fb01dbf7cd0a3868c26b951f393c3c56c2858cee901f7793ff5d271925d13a41f8e52409f4eba1990f33acb0bac669 */
static const uint8_t nist_kas_ecc_cdh_testvector_84_out[] = {
/* ZIUT */
	0xbb, 0x3b, 0x1e, 0xda, 0x9c, 0x65, 0x60, 0xd8, 0x2f, 0xf5, 0xbe, 0xe4,
	0x03, 0x33, 0x9f, 0x1e, 0x80, 0x34, 0x23, 0x38, 0xa9, 0x91, 0x34, 0x48,
	0x53, 0xb5, 0x6b, 0x24, 0xf1, 0x09, 0xa4, 0xd9, 0x4b, 0x92, 0xf6, 0x54,
	0xf0, 0x42, 0x5e, 0xdd, 0x4c, 0x20, 0x59, 0x03, 0xd7, 0x58, 0x61, 0x04
};
/* COUNT = 9 */
static const uint8_t nist_kas_ecc_cdh_testvector_85_public_x[] = {
/* QCAVSx */
	0x8e, 0xee, 0xa3, 0xa3, 0x19, 0xc8, 0xdf, 0x99, 0xfb, 0xc2, 0x9c, 0xb5,
	0x5f, 0x24, 0x3a, 0x72, 0x0d, 0x95, 0x50, 0x95, 0x15, 0xee, 0x5c, 0xc5,
	0x87, 0xa5, 0xc5, 0xae, 0x22, 0xfb, 0xbd, 0x00, 0x9e, 0x62, 0x6d, 0xb3,
	0xe9, 0x11, 0xde, 0xf0, 0xb9, 0x9a, 0x4f, 0x7a, 0xe3, 0x04, 0xb1, 0xba
};
static const uint8_t nist_kas_ecc_cdh_testvector_85_public_y[] = {
/* QCAVSy */
	0x73, 0x87, 0x7d, 0xc9, 0x4d, 0xb9, 0xad, 0xdd, 0xc0, 0xd9, 0xa4, 0xb2,
	0x4e, 0x89, 0x76, 0xc2, 0x2d, 0x73, 0xc8, 0x44, 0x37, 0x0e, 0x1e, 0xe8,
	0x57, 0xf8, 0xd1, 0xb1, 0x29, 0xa3, 0xbd, 0x5f, 0x63, 0xf4, 0x0c, 0xaf,
	0x3b, 0xd0, 0x53, 0x3e, 0x38, 0xa5, 0xf5, 0x77, 0x70, 0x74, 0xff, 0x9e
};
static const uint8_t nist_kas_ecc_cdh_testvector_85_private[] = {
/* dIUT */
	0xd7, 0x87, 0xa5, 0x7f, 0xde, 0x22, 0xec, 0x65, 0x6a, 0x0a, 0x52, 0x5c,
	0xf3, 0xc7, 0x38, 0xb3, 0x0d, 0x73, 0xaf, 0x61, 0xe7, 0x43, 0xea, 0x90,
	0x89, 0x3e, 0xcb, 0x2d, 0x7b, 0x62, 0x2a, 0xdd, 0x2f, 0x94, 0xee, 0x25,
	0xc2, 0x17, 0x14, 0x67, 0xaf, 0xb0, 0x93, 0xf3, 0xf8, 0x4d, 0x00, 0x18
};
/* QIUTx = 171546923b87b2cbbad664f01ce932bf09d6a6118168678446bfa9f0938608cb4667a98f4ec8ac1462285c2508f74862 */
/* QIUTy = fa41cb4db68ae71f1f8a3e8939dc52c2dec61a83c983beb2a02baf29ec49278088882ed0cf56c74b5c173b552ccf63cf */
static const uint8_t nist_kas_ecc_cdh_testvector_85_out[] = {
/* ZIUT */
	0x1e, 0x97, 0xb6, 0x0a, 0xdd, 0x7c, 0xb3, 0x5c, 0x74, 0x03, 0xdd, 0x88,
	0x4c, 0x0a, 0x75, 0x79, 0x5b, 0x76, 0x83, 0xff, 0xf8, 0xb4, 0x9f, 0x9d,
	0x86, 0x72, 0xa8, 0x20, 0x6b, 0xfd, 0xcf, 0x0a, 0x10, 0x6b, 0x87, 0x68,
	0xf9, 0x83, 0x25, 0x8c, 0x74, 0x16, 0x74, 0x22, 0xe4, 0x4e, 0x4d, 0x14
};
/* COUNT = 10 */
static const uint8_t nist_kas_ecc_cdh_testvector_86_public_x[] = {
/* QCAVSx */
	0xa7, 0x21, 0xf6, 0xa2, 0xd4, 0x52, 0x74, 0x11, 0x83, 0x4b, 0x13, 0xd4,
	0xd3, 0xa3, 0x3c, 0x29, 0xbe, 0xb8, 0x3a, 0xb7, 0x68, 0x24, 0x65, 0xc6,
	0xcb, 0xaf, 0x66, 0x24, 0xac, 0xa6, 0xea, 0x58, 0xc3, 0x0e, 0xb0, 0xf2,
	0x9d, 0xd8, 0x42, 0x88, 0x66, 0x95, 0x40, 0x0d, 0x72, 0x54, 0xf2, 0x0f
};
static const uint8_t nist_kas_ecc_cdh_testvector_86_public_y[] = {
/* QCAVSy */
	0x14, 0xba, 0x6e, 0x26, 0x35, 0x51, 0x09, 0xad, 0x35, 0x12, 0x93, 0x66,
	0xd5, 0xe3, 0xa6, 0x40, 0xae, 0x79, 0x85, 0x05, 0xa7, 0xfa, 0x55, 0xa9,
	0x6a, 0x36, 0xb5, 0xda, 0xd3, 0x3d, 0xe0, 0x04, 0x74, 0xf6, 0x67, 0x0f,
	0x52, 0x22, 0x14, 0xdd, 0x79, 0x52, 0x14, 0x0a, 0xb0, 0xa7, 0xeb, 0x68
};
static const uint8_t nist_kas_ecc_cdh_testvector_86_private[] = {
/* dIUT */
	0x83, 0xd7, 0x0f, 0x7b, 0x16, 0x4d, 0x9f, 0x4c, 0x22, 0x7c, 0x76, 0x70,
	0x46, 0xb2, 0x0e, 0xb3, 0x4d, 0xfc, 0x77, 0x8f, 0x53, 0x87, 0xe3, 0x2e,
	0x83, 0x4b, 0x1e, 0x6d, 0xae, 0xc2, 0x0e, 0xdb, 0x8c, 0xa5, 0xbb, 0x41,
	0x92, 0x09, 0x3f, 0x54, 0x3b, 0x68, 0xe6, 0xae, 0xb7, 0xce, 0x78, 0x8b
};
/* QIUTx = 57cd770f3bbcbe0c78c770eab0b169bc45e139f86378ffae1c2b16966727c2f2eb724572b8f3eb228d130db4ff862c63 */
/* QIUTy = 7ec5c8813b685558d83e924f14bc719f6eb7ae0cbb2c474227c5bda88637a4f26c64817929af999592da6f787490332f */
static const uint8_t nist_kas_ecc_cdh_testvector_86_out[] = {
/* ZIUT */
	0x10, 0x23, 0x47, 0x88, 0x40, 0xe5, 0x47, 0x75, 0xbf, 0xc6, 0x92, 0x93,
	0xa3, 0xcf, 0x97, 0xf5, 0xbc, 0x91, 0x47, 0x26, 0x45, 0x5c, 0x66, 0x53,
	0x8e, 0xb5, 0x62, 0x3e, 0x21, 0x8f, 0xee, 0xf7, 0xdf, 0x4b, 0xef, 0xa2,
	0x3e, 0x09, 0xd7, 0x71, 0x45, 0xad, 0x57, 0x7d, 0xb3, 0x2b, 0x41, 0xf9
};
/* COUNT = 11 */
static const uint8_t nist_kas_ecc_cdh_testvector_87_public_x[] = {
/* QCAVSx */
	0xd8, 0x82, 0xa8, 0x50, 0x5c, 0x2d, 0x5c, 0xb9, 0xb8, 0x85, 0x1f, 0xc6,
	0x76, 0x67, 0x7b, 0xb0, 0x08, 0x76, 0x81, 0xad, 0x53, 0xfa, 0xce, 0xba,
	0x17, 0x38, 0x28, 0x6b, 0x45, 0x82, 0x75, 0x61, 0xe7, 0xda, 0x37, 0xb8,
	0x80, 0x27, 0x6c, 0x65, 0x6c, 0xfc, 0x38, 0xb3, 0x2a, 0xde, 0x84, 0x7e
};
static const uint8_t nist_kas_ecc_cdh_testvector_87_public_y[] = {
/* QCAVSy */
	0x34, 0xb3, 0x14, 0xbd, 0xc1, 0x34, 0x57, 0x56, 0x54, 0x57, 0x3c, 0xff,
	0xaf, 0x40, 0x44, 0x5d, 0xa2, 0xe6, 0xaa, 0xf9, 0x87, 0xf7, 0xe9, 0x13,
	0xcd, 0x4c, 0x30, 0x91, 0x52, 0x30, 0x58, 0x98, 0x4a, 0x25, 0xd8, 0xf2,
	0x1d, 0xa8, 0x32, 0x61, 0x92, 0x45, 0x6c, 0x6a, 0x0f, 0xa5, 0xf6, 0x0c
};
static const uint8_t nist_kas_ecc_cdh_testvector_87_private[] = {
/* dIUT */
	0x8f, 0x55, 0x8e, 0x05, 0x81, 0x8b, 0x88, 0xed, 0x38, 0x3d, 0x5f, 0xca,
	0x96, 0x2e, 0x53, 0x41, 0x3d, 0xb1, 0xa0, 0xe4, 0x63, 0x7e, 0xda, 0x19,
	0x4f, 0x76, 0x19, 0x44, 0xcb, 0xea, 0x11, 0x4a, 0xb9, 0xd5, 0xda, 0x17,
	0x5a, 0x7d, 0x57, 0x88, 0x25, 0x50, 0xb0, 0xe4, 0x32, 0xf3, 0x95, 0xa9
};
/* QIUTx = 9a2f57f4867ce753d72b0d95195df6f96c1fae934f602efd7b6a54582f556cfa539d89005ca2edac08ad9b72dd1f60ba */
/* QIUTy = d9b94ee82da9cc601f346044998ba387aee56404dc6ecc8ab2b590443319d0b2b6176f9d0eac2d44678ed561607d09a9 */
static const uint8_t nist_kas_ecc_cdh_testvector_87_out[] = {
/* ZIUT */
	0x6a, 0xd6, 0xb9, 0xdc, 0x8a, 0x6c, 0xf0, 0xd3, 0x69, 0x1c, 0x50, 0x1c,
	0xbb, 0x96, 0x78, 0x67, 0xf6, 0xe4, 0xbb, 0xb7, 0x64, 0xb6, 0x0d, 0xbf,
	0xf8, 0xfc, 0xff, 0x3e, 0xd4, 0x2d, 0xbb, 0xa3, 0x9d, 0x63, 0xcf, 0x32,
	0x5b, 0x4b, 0x40, 0x78, 0x85, 0x84, 0x95, 0xdd, 0xee, 0x75, 0xf9, 0x54
};
/* COUNT = 12 */
static const uint8_t nist_kas_ecc_cdh_testvector_88_public_x[] = {
/* QCAVSx */
	0x81, 0x5c, 0x9d, 0x77, 0x3d, 0xbf, 0x5f, 0xb6, 0xa1, 0xb8, 0x67, 0x99,
	0x96, 0x62, 0x47, 0xf4, 0x00, 0x6a, 0x23, 0xc9, 0x2e, 0x68, 0xc5, 0x5e,
	0x9e, 0xaa, 0x99, 0x8b, 0x17, 0xd8, 0x83, 0x2d, 0xd4, 0xd8, 0x4d, 0x92,
	0x7d, 0x83, 0x1d, 0x4f, 0x68, 0xda, 0xc6, 0x7c, 0x64, 0x88, 0x21, 0x9f
};
static const uint8_t nist_kas_ecc_cdh_testvector_88_public_y[] = {
/* QCAVSy */
	0xe7, 0x92, 0x69, 0x94, 0x8b, 0x26, 0x11, 0x48, 0x45, 0x60, 0xfd, 0x49,
	0x0f, 0xee, 0xc8, 0x87, 0xcb, 0x55, 0xef, 0x99, 0xa4, 0xb5, 0x24, 0x88,
	0x0f, 0xa7, 0x49, 0x9d, 0x6a, 0x07, 0x28, 0x3a, 0xae, 0x2a, 0xfa, 0x33,
	0xfe, 0xab, 0x97, 0xde, 0xca, 0x40, 0xbc, 0x60, 0x6c, 0x4d, 0x87, 0x64
};
static const uint8_t nist_kas_ecc_cdh_testvector_88_private[] = {
/* dIUT */
	0x0f, 0x5d, 0xee, 0x0a, 0xff, 0xa7, 0xbb, 0xf2, 0x39, 0xd5, 0xdf, 0xf3,
	0x29, 0x87, 0xeb, 0xb7, 0xcf, 0x84, 0xfc, 0xce, 0xed, 0x64, 0x3e, 0x1d,
	0x3c, 0x62, 0xd0, 0xb3, 0x35, 0x2a, 0xec, 0x23, 0xb6, 0xe5, 0xac, 0x7f,
	0xa4, 0x10, 0x5c, 0x8c, 0xb2, 0x61, 0x26, 0xad, 0x2d, 0x18, 0x92, 0xcb
};
/* QIUTx = 23346bdfbc9d7c7c736e02bdf607671ff6082fdd27334a8bc75f3b23681ebe614d0597dd614fae58677c835a9f0b273b */
/* QIUTy = 82ba36290d2f94db41479eb45ab4eaf67928a2315138d59eecc9b5285dfddd6714f77557216ea44cc6fc119d8243efaf */
static const uint8_t nist_kas_ecc_cdh_testvector_88_out[] = {
/* ZIUT */
	0xcc, 0x9e, 0x06, 0x35, 0x66, 0xd4, 0x6b, 0x35, 0x7b, 0x3f, 0xca, 0xe2,
	0x18, 0x27, 0x37, 0x73, 0x31, 0xe5, 0xe2, 0x90, 0xa3, 0x6e, 0x60, 0xcd,
	0x7c, 0x39, 0x10, 0x2b, 0x82, 0x8a, 0xe0, 0xb9, 0x18, 0xdc, 0x5a, 0x02,
	0x21, 0x6b, 0x07, 0xfe, 0x6f, 0x19, 0x58, 0xd8, 0x34, 0xe4, 0x24, 0x37
};
/* COUNT = 13 */
static const uint8_t nist_kas_ecc_cdh_testvector_89_public_x[] = {
/* QCAVSx */
	0x1c, 0x0e, 0xed, 0xa7, 0xa2, 0xbe, 0x00, 0x0c, 0x5b, 0xdc, 0xda, 0x04,
	0x78, 0xae, 0xd4, 0xdb, 0x73, 0x3d, 0x2a, 0x9e, 0x34, 0x12, 0x24, 0x37,
	0x91, 0x23, 0xad, 0x84, 0x70, 0x30, 0xf2, 0x9e, 0x3b, 0x16, 0x8f, 0xa1,
	0x8e, 0x89, 0xa3, 0xc0, 0xfb, 0xa2, 0xa6, 0xce, 0x1c, 0x28, 0xfc, 0x3b
};
static const uint8_t nist_kas_ecc_cdh_testvector_89_public_y[] = {
/* QCAVSy */
	0xec, 0x8c, 0x1c, 0x83, 0xc1, 0x18, 0xc4, 0xdb, 0xea, 0x94, 0x27, 0x18,
	0x69, 0xf2, 0xd8, 0x68, 0xeb, 0x65, 0xe8, 0xb4, 0x4e, 0x21, 0xe6, 0xf1,
	0x4b, 0x0f, 0x4d, 0x9b, 0x38, 0xc0, 0x68, 0xda, 0xef, 0xa2, 0x71, 0x14,
	0x25, 0x5b, 0x9a, 0x41, 0xd0, 0x84, 0xcc, 0x4a, 0x1a, 0xd8, 0x54, 0x56
};
static const uint8_t nist_kas_ecc_cdh_testvector_89_private[] = {
/* dIUT */
	0x03, 0x7b, 0x63, 0x3b, 0x5b, 0x8b, 0xa8, 0x57, 0xc0, 0xfc, 0x85, 0x65,
	0x68, 0x68, 0x23, 0x2e, 0x2f, 0xeb, 0xf5, 0x95, 0x78, 0x71, 0x83, 0x91,
	0xb8, 0x1d, 0xa8, 0x54, 0x1a, 0x00, 0xbf, 0xe5, 0x3c, 0x30, 0xae, 0x04,
	0x15, 0x18, 0x47, 0xf2, 0x74, 0x99, 0xf8, 0xd7, 0xab, 0xad, 0x8c, 0xf4
};
/* QIUTx = 8878ac8a947f7d5cb2b47aad24fbb8210d86126585399a2871f84aa9c5fde3074ae540c6bf82275ca822d0feb862bc74 */
/* QIUTy = 632f5cd2f900c2711c32f8930728eb647d31edd8d650f9654e7d33e5ed1b475489d08daa30d8cbcba6bfc3b60d9b5a37 */
static const uint8_t nist_kas_ecc_cdh_testvector_89_out[] = {
/* ZIUT */
	0xde, 0xff, 0x7f, 0x03, 0xbd, 0x09, 0x86, 0x5b, 0xaf, 0x94, 0x5e, 0x73,
	0xed, 0xff, 0x6d, 0x51, 0x22, 0xc0, 0x3f, 0xb5, 0x61, 0xdb, 0x87, 0xde,
	0xc8, 0x66, 0x2e, 0x09, 0xbe, 0xd4, 0x34, 0x0b, 0x28, 0xa9, 0xef, 0xe1,
	0x18, 0x33, 0x7b, 0xb7, 0xd3, 0xd4, 0xf7, 0xf5, 0x68, 0x63, 0x5f, 0xf9
};
/* COUNT = 14 */
static const uint8_t nist_kas_ecc_cdh_testvector_90_public_x[] = {
/* QCAVSx */
	0xc9, 0x5c, 0x18, 0x5e, 0x25, 0x6b, 0xf9, 0x97, 0xf3, 0x0b, 0x31, 0x15,
	0x48, 0xae, 0x7f, 0x76, 0x8a, 0x38, 0xde, 0xe4, 0x3e, 0xee, 0xef, 0x43,
	0x08, 0x3f, 0x30, 0x77, 0xbe, 0x70, 0xe2, 0xbf, 0x39, 0xac, 0x1d, 0x4d,
	0xaf, 0x36, 0x0c, 0x51, 0x4c, 0x8c, 0x6b, 0xe6, 0x23, 0x44, 0x3d, 0x1a
};
static const uint8_t nist_kas_ecc_cdh_testvector_90_public_y[] = {
/* QCAVSy */
	0x3e, 0x63, 0xa6, 0x63, 0xea, 0xf7, 0x5d, 0x8a, 0x76, 0x5a, 0xb2, 0xb9,
	0xa3, 0x55, 0x13, 0xd7, 0x93, 0x3f, 0xa5, 0xe2, 0x64, 0x20, 0xa5, 0x24,
	0x45, 0x50, 0xec, 0x6c, 0x3b, 0x6f, 0x03, 0x3b, 0x96, 0xdb, 0x2a, 0xca,
	0x3d, 0x6a, 0xc6, 0xaa, 0xb0, 0x52, 0xce, 0x92, 0x95, 0x95, 0xae, 0xa5
};
static const uint8_t nist_kas_ecc_cdh_testvector_90_private[] = {
/* dIUT */
	0xe3, 0xd0, 0x71, 0x06, 0xbe, 0xdc, 0xc0, 0x96, 0xe7, 0xd9, 0x16, 0x30,
	0xff, 0xd3, 0x09, 0x4d, 0xf2, 0xc7, 0x85, 0x9d, 0xb8, 0xd7, 0xed, 0xbb,
	0x2e, 0x37, 0xb4, 0xac, 0x47, 0xf4, 0x29, 0xa6, 0x37, 0xd0, 0x6a, 0x67,
	0xd2, 0xfb, 0xa3, 0x38, 0x38, 0x76, 0x4e, 0xf2, 0x03, 0x46, 0x49, 0x91
};
/* QIUTx = e74a1a2b85f1cbf8dbbdf050cf1aff8acb02fda2fb6591f9d3cfe4e79d0ae938a9c1483e7b75f8db24505d65065cdb18 */
/* QIUTy = 1773ee591822f7abaa856a1a60bc0a5203548dbd1cb5025466eff8481bd07614eaa04a16c3db76905913e972a5b6b59d */
static const uint8_t nist_kas_ecc_cdh_testvector_90_out[] = {
/* ZIUT */
	0xc8, 0xb1, 0x03, 0x8f, 0x73, 0x5a, 0xd3, 0xbb, 0x3e, 0x46, 0x37, 0xc3,
	0xe4, 0x7e, 0xab, 0x48, 0x76, 0x37, 0x91, 0x1a, 0x6b, 0x79, 0x50, 0xa4,
	0xe4, 0x61, 0x94, 0x83, 0x29, 0xd3, 0x92, 0x3b, 0x96, 0x9e, 0x5d, 0xb6,
	0x63, 0x67, 0x56, 0x23, 0x61, 0x1a, 0x45, 0x7f, 0xcd, 0xa3, 0x5a, 0x71
};
/* COUNT = 15 */
static const uint8_t nist_kas_ecc_cdh_testvector_91_public_x[] = {
/* QCAVSx */
	0x34, 0x97, 0x23, 0x8a, 0x7e, 0x6a, 0xd1, 0x66, 0xdf, 0x2d, 0xac, 0x03,
	0x9a, 0xa4, 0xda, 0xc8, 0xd1, 0x7a, 0xa9, 0x25, 0xe7, 0xc7, 0x63, 0x1e,
	0xb3, 0xb5, 0x6e, 0x3a, 0xaa, 0x1c, 0x54, 0x5f, 0xcd, 0x54, 0xd2, 0xe5,
	0x98, 0x58, 0x07, 0x91, 0x0f, 0xb2, 0x02, 0xb1, 0xfc, 0x19, 0x1d, 0x2a
};
static const uint8_t nist_kas_ecc_cdh_testvector_91_public_y[] = {
/* QCAVSy */
	0xa4, 0x9e, 0x5c, 0x48, 0x7d, 0xcc, 0x7a, 0xa4, 0x0a, 0x8f, 0x23, 0x4c,
	0x97, 0x94, 0x46, 0x04, 0x0d, 0x91, 0x74, 0xe3, 0xad, 0x35, 0x7d, 0x40,
	0x4d, 0x77, 0x65, 0x18, 0x31, 0x95, 0xae, 0xd3, 0xf9, 0x13, 0x64, 0x1b,
	0x90, 0xc8, 0x1a, 0x30, 0x6e, 0xbf, 0x0d, 0x89, 0x13, 0x86, 0x13, 0x16
};
static const uint8_t nist_kas_ecc_cdh_testvector_91_private[] = {
/* dIUT */
	0xf3, 0xf9, 0xb0, 0xc6, 0x5a, 0x49, 0xa5, 0x06, 0x63, 0x2c, 0x8a, 0x45,
	0xb1, 0x0f, 0x66, 0xb5, 0x31, 0x6f, 0x9e, 0xeb, 0x06, 0xfa, 0xe2, 0x18,
	0xf2, 0xda, 0x62, 0x33, 0x3f, 0x99, 0x90, 0x51, 0x17, 0xb1, 0x41, 0xc7,
	0x60, 0xe8, 0x97, 0x4e, 0xfc, 0x4a, 0xf1, 0x05, 0x70, 0x63, 0x57, 0x91
};
/* QIUTx = a4ad77aa7d86e5361118a6b921710c820721210712f4c347985fdee58aa4effa1e28be80a17b120b139f96300f89b49b */
/* QIUTy = 1ddf22e07e03f1560d8f45a480094560dba9fae7f9531130c1b57ebb95982496524f31d3797793396fa823f22bdb4328 */
static const uint8_t nist_kas_ecc_cdh_testvector_91_out[] = {
/* ZIUT */
	0xd3, 0x37, 0xea, 0xa3, 0x2b, 0x9f, 0x71, 0x6b, 0x87, 0x47, 0xb0, 0x05,
	0xb9, 0x7a, 0x55, 0x3c, 0x59, 0xda, 0xb0, 0xc5, 0x1d, 0xf4, 0x1a, 0x2d,
	0x49, 0x03, 0x9c, 0xda, 0xe7, 0x05, 0xaa, 0x75, 0xc7, 0xb9, 0xe7, 0xbc,
	0x0b, 0x6a, 0x0e, 0x8c, 0x57, 0x8c, 0x90, 0x2b, 0xc4, 0xff, 0xf2, 0x3e
};
/* COUNT = 16 */
static const uint8_t nist_kas_ecc_cdh_testvector_92_public_x[] = {
/* QCAVSx */
	0x90, 0xa3, 0x47, 0x37, 0xd4, 0x5b, 0x1a, 0xa6, 0x5f, 0x74, 0xe0, 0xbd,
	0x06, 0x59, 0xbc, 0x11, 0x8f, 0x8e, 0x4b, 0x77, 0x4b, 0x76, 0x19, 0x44,
	0xff, 0xa6, 0x57, 0x3c, 0x6d, 0xf4, 0xf4, 0x1d, 0xec, 0x0d, 0x11, 0xb6,
	0x97, 0xab, 0xd9, 0x34, 0xd3, 0x90, 0x87, 0x1d, 0x4b, 0x45, 0x32, 0x40
};
static const uint8_t nist_kas_ecc_cdh_testvector_92_public_y[] = {
/* QCAVSy */
	0x9b, 0x59, 0x07, 0x19, 0xbb, 0x33, 0x07, 0xc1, 0x49, 0xa7, 0x81, 0x7b,
	0xe3, 0x55, 0xd6, 0x84, 0x89, 0x3a, 0x30, 0x77, 0x64, 0xb5, 0x12, 0xee,
	0xff, 0xe0, 0x7c, 0xb6, 0x99, 0xed, 0xb5, 0xa6, 0xff, 0xbf, 0x8d, 0x60,
	0x32, 0xe6, 0xc7, 0x9d, 0x5e, 0x93, 0xe9, 0x42, 0x12, 0xc2, 0xaa, 0x4e
};
static const uint8_t nist_kas_ecc_cdh_testvector_92_private[] = {
/* dIUT */
	0x59, 0xfc, 0xe7, 0xfa, 0xd7, 0xde, 0x28, 0xba, 0xc0, 0x23, 0x06, 0x90,
	0xc9, 0x57, 0x10, 0xc7, 0x20, 0xe5, 0x28, 0xf9, 0xa4, 0xe5, 0x4d, 0x3a,
	0x6a, 0x8c, 0xd5, 0xfc, 0x5c, 0x5f, 0x21, 0x63, 0x70, 0x31, 0xce, 0x1c,
	0x5b, 0x4e, 0x3d, 0x39, 0x64, 0x7d, 0x8d, 0xcb, 0x9b, 0x79, 0x46, 0x64
};
/* QIUTx = 9c43bf971edf09402876ee742095381f78b1bd3aa39b5132af75dbfe7e98bd78bde10fe2e903c2b6379e1deee175a1b0 */
/* QIUTy = a6c58ecea5a477bb01bd543b339f1cc49f1371a2cda4d46eb4e53e250597942351a99665a122ffea9bde0636c375daf2 */
static const uint8_t nist_kas_ecc_cdh_testvector_92_out[] = {
/* ZIUT */
	0x32, 0xd2, 0x92, 0xb6, 0x95, 0xa4, 0x48, 0x8e, 0x42, 0xa7, 0xb7, 0x92,
	0x2e, 0x1a, 0xe5, 0x37, 0xd7, 0x6a, 0x3d, 0x21, 0xa0, 0xb2, 0xe3, 0x68,
	0x75, 0xf6, 0x0e, 0x9f, 0x6d, 0x3e, 0x87, 0x79, 0xc2, 0xaf, 0xb3, 0xa4,
	0x13, 0xb9, 0xdd, 0x79, 0xae, 0x18, 0xe7, 0x0b, 0x47, 0xd3, 0x37, 0xc1
};
/* COUNT = 17 */
static const uint8_t nist_kas_ecc_cdh_testvector_93_public_x[] = {
/* QCAVSx */
	0xdd, 0xa5, 0x46, 0xac, 0xfc, 0x8f, 0x90, 0x3d, 0x11, 0xe2, 0xe3, 0x92,
	0x06, 0x69, 0x63, 0x6d, 0x44, 0xb2, 0x06, 0x8a, 0xeb, 0x66, 0xff, 0x07,
	0xaa, 0x26, 0x6f, 0x00, 0x30, 0xe1, 0x53, 0x5b, 0x0e, 0xd0, 0x20, 0x3c,
	0xb8, 0xa4, 0x60, 0xac, 0x99, 0x0f, 0x13, 0x94, 0xfa, 0xf2, 0x2f, 0x1d
};
static const uint8_t nist_kas_ecc_cdh_testvector_93_public_y[] = {
/* QCAVSy */
	0x15, 0xbb, 0xb2, 0x59, 0x79, 0x13, 0x03, 0x5f, 0xaa, 0xdf, 0x41, 0x34,
	0x76, 0xf4, 0xc7, 0x0f, 0x72, 0x79, 0x76, 0x9a, 0x40, 0xc9, 0x86, 0xf4,
	0x70, 0xc4, 0x27, 0xb4, 0xee, 0x49, 0x62, 0xab, 0xdf, 0x81, 0x73, 0xbb,
	0xad, 0x81, 0x87, 0x47, 0x72, 0x92, 0x5f, 0xd3, 0x2f, 0x0b, 0x15, 0x9f
};
static const uint8_t nist_kas_ecc_cdh_testvector_93_private[] = {
/* dIUT */
	0x3e, 0x49, 0xfb, 0xf9, 0x50, 0xa4, 0x24, 0xc5, 0xd8, 0x02, 0x28, 0xdc,
	0x4b, 0xc3, 0x5e, 0x9f, 0x6c, 0x6c, 0x0c, 0x1d, 0x04, 0x44, 0x09, 0x98,
	0xda, 0x0a, 0x60, 0x9a, 0x87, 0x75, 0x75, 0xdb, 0xe4, 0x37, 0xd6, 0xa5,
	0xce, 0xda, 0xa2, 0xdd, 0xd2, 0xa1, 0xa1, 0x7f, 0xd1, 0x12, 0xad, 0xed
};
/* QIUTx = 5a949594228b1a3d6f599eb3db0d06070fbc551c657b58234ba164ce3fe415fa5f3eb823c08dc29b8c341219c77b6b3d */
/* QIUTy = 2baad447c8c290cfed25edd9031c41d0b76921457327f42db31122b81f337bbf0b1039ec830ce9061a3761953c75e4a8 */
static const uint8_t nist_kas_ecc_cdh_testvector_93_out[] = {
/* ZIUT */
	0x12, 0x20, 0xe7, 0xe6, 0xca, 0xd7, 0xb2, 0x5d, 0xf9, 0x8e, 0x5b, 0xbd,
	0xcc, 0x6c, 0x0b, 0x65, 0xca, 0x6c, 0x2a, 0x50, 0xc5, 0xff, 0x6c, 0x41,
	0xdc, 0xa7, 0x1e, 0x47, 0x56, 0x46, 0xfd, 0x48, 0x96, 0x15, 0x97, 0x9c,
	0xa9, 0x2f, 0xb4, 0x38, 0x9a, 0xea, 0xde, 0xfd, 0xe7, 0x9a, 0x24, 0xf1
};
/* COUNT = 18 */
static const uint8_t nist_kas_ecc_cdh_testvector_94_public_x[] = {
/* QCAVSx */
	0x78, 0x8b, 0xe2, 0x33, 0x6c, 0x52, 0xf4, 0x45, 0x4d, 0x63, 0xee, 0x94,
	0x4b, 0x1e, 0x49, 0xbf, 0xb6, 0x19, 0xa0, 0x83, 0x71, 0x04, 0x8e, 0x6d,
	0xa9, 0x2e, 0x58, 0x4e, 0xae, 0x70, 0xbd, 0xe1, 0xf1, 0x71, 0xc4, 0xdf,
	0x37, 0x8b, 0xd1, 0xf3, 0xc0, 0xab, 0x03, 0x04, 0x8a, 0x23, 0x78, 0x02
};
static const uint8_t nist_kas_ecc_cdh_testvector_94_public_y[] = {
/* QCAVSy */
	0x46, 0x73, 0xeb, 0xd8, 0xdb, 0x60, 0x4e, 0xaf, 0x41, 0x71, 0x17, 0x48,
	0xba, 0xb2, 0x96, 0x8a, 0x23, 0xca, 0x44, 0x76, 0xce, 0x14, 0x4e, 0x72,
	0x82, 0x47, 0xf0, 0x8a, 0xf7, 0x52, 0x92, 0x91, 0x57, 0xb5, 0x83, 0x0f,
	0x1e, 0x26, 0x06, 0x74, 0x66, 0xbd, 0xfa, 0x8b, 0x65, 0x14, 0x5a, 0x33
};
static const uint8_t nist_kas_ecc_cdh_testvector_94_private[] = {
/* dIUT */
	0x50, 0xcc, 0xc1, 0xf7, 0x07, 0x6e, 0x92, 0xf4, 0x63, 0x8e, 0x85, 0xf2,
	0xdb, 0x98, 0xe0, 0xb4, 0x83, 0xe6, 0xe2, 0x20, 0x4c, 0x92, 0xbd, 0xd4,
	0x40, 0xa6, 0xde, 0xea, 0x04, 0xe3, 0x7a, 0x07, 0xc6, 0xe7, 0x27, 0x91,
	0xc1, 0x90, 0xad, 0x4e, 0x4e, 0x86, 0xe0, 0x1e, 0xfb, 0xa8, 0x42, 0x69
};
/* QIUTx = 756c07df0ce32c839dac9fb4733c9c28b70113a676a7057c38d223f22a3a9095a8d564653af528e04c7e1824be4a6512 */
/* QIUTy = 17c2ce6962cbd2a2e066297b39d57dd9bb4680f0191d390f70b4e461419b2972ce68ad46127fdda6c39195774ea86df3 */
static const uint8_t nist_kas_ecc_cdh_testvector_94_out[] = {
/* ZIUT */
	0x79, 0x3b, 0xb9, 0xcd, 0x22, 0xa9, 0x3c, 0xf4, 0x68, 0xfa, 0xf8, 0x04,
	0xa3, 0x8d, 0x12, 0xb7, 0x8c, 0xb1, 0x21, 0x89, 0xec, 0x67, 0x9d, 0xdd,
	0x2e, 0x9a, 0xa2, 0x1f, 0xa9, 0xa5, 0xa0, 0xb0, 0x49, 0xab, 0x16, 0xa2,
	0x35, 0x74, 0xfe, 0x04, 0xc1, 0xc3, 0xc0, 0x23, 0x43, 0xb9, 0x1b, 0xeb
};
/* COUNT = 19 */
static const uint8_t nist_kas_ecc_cdh_testvector_95_public_x[] = {
/* QCAVSx */
	0xd0, 0x9b, 0xb8, 0x22, 0xeb, 0x99, 0xe3, 0x80, 0x60, 0x95, 0x47, 0x47,
	0xc8, 0x2b, 0xb3, 0x27, 0x8c, 0xf9, 0x6b, 0xbf, 0x36, 0xfe, 0xce, 0x34,
	0x00, 0xf4, 0xc8, 0x73, 0x83, 0x8a, 0x40, 0xc1, 0x35, 0xeb, 0x3b, 0xab,
	0xb9, 0x29, 0x3b, 0xd1, 0x00, 0x1b, 0xf3, 0xec, 0xde, 0xe7, 0xbf, 0x26
};
static const uint8_t nist_kas_ecc_cdh_testvector_95_public_y[] = {
/* QCAVSy */
	0xd4, 0x16, 0xdb, 0x6e, 0x1b, 0x87, 0xbb, 0xb7, 0x42, 0x77, 0x88, 0xa3,
	0xb6, 0xc7, 0xa7, 0xab, 0x2c, 0x16, 0x5b, 0x1e, 0x36, 0x6f, 0x96, 0x08,
	0xdf, 0x51, 0x20, 0x37, 0x58, 0x4f, 0x21, 0x3a, 0x64, 0x8d, 0x47, 0xf1,
	0x6a, 0xc3, 0x26, 0xe1, 0x9a, 0xae, 0x97, 0x2f, 0x63, 0xfd, 0x76, 0xc9
};
static const uint8_t nist_kas_ecc_cdh_testvector_95_private[] = {
/* dIUT */
	0x06, 0xf1, 0x32, 0xb7, 0x1f, 0x74, 0xd8, 0x7b, 0xf9, 0x98, 0x57, 0xe1,
	0xe4, 0x35, 0x0a, 0x59, 0x4e, 0x5f, 0xe3, 0x55, 0x33, 0xb8, 0x88, 0x55,
	0x2c, 0xec, 0xcb, 0xc0, 0xd8, 0x92, 0x3c, 0x90, 0x2e, 0x36, 0x14, 0x1d,
	0x76, 0x91, 0xe2, 0x86, 0x31, 0xb8, 0xbc, 0x9b, 0xaf, 0xe5, 0xe0, 0x64
};
/* QIUTx = 2a3cc6b8ff5cde926e7e3a189a1bd029c9b586351af8838f4f201cb8f4b70ef3b0da06d352c80fc26baf8f42b784459e */
/* QIUTy = bf9985960176da6d23c7452a2954ffcbbcb24249b43019a2a023e0b3dabd461f19ad3e775c364f3f11ad49f3099400d3 */
static const uint8_t nist_kas_ecc_cdh_testvector_95_out[] = {
/* ZIUT */
	0x01, 0x2d, 0x19, 0x1c, 0xf7, 0x40, 0x4a, 0x52, 0x36, 0x78, 0xc6, 0xfc,
	0x07, 0x5d, 0xe8, 0x28, 0x5b, 0x24, 0x37, 0x20, 0xa9, 0x03, 0x04, 0x77,
	0x08, 0xbb, 0x33, 0xe5, 0x01, 0xe0, 0xdb, 0xee, 0x5b, 0xcc, 0x40, 0xd7,
	0xc3, 0xef, 0x6c, 0x6d, 0xa3, 0x9e, 0xa2, 0x4d, 0x83, 0x0d, 0xa1, 0xe8
};
/* COUNT = 20 */
static const uint8_t nist_kas_ecc_cdh_testvector_96_public_x[] = {
/* QCAVSx */
	0x13, 0x74, 0x12, 0x62, 0xed, 0xe5, 0x86, 0x1d, 0xad, 0x71, 0x06, 0x3d,
	0xfd, 0x20, 0x4b, 0x91, 0xea, 0x1d, 0x3b, 0x7c, 0x63, 0x1d, 0xf6, 0x8e,
	0xb9, 0x49, 0x96, 0x95, 0x27, 0xd7, 0x9a, 0x1d, 0xc5, 0x92, 0x95, 0xef,
	0x7d, 0x2b, 0xca, 0x67, 0x43, 0xe8, 0xcd, 0x77, 0xb0, 0x4d, 0x1b, 0x58
};
static const uint8_t nist_kas_ecc_cdh_testvector_96_public_y[] = {
/* QCAVSy */
	0x0b, 0xaa, 0xea, 0xdc, 0x7e, 0x19, 0xd7, 0x4a, 0x8a, 0x04, 0x45, 0x1a,
	0x13, 0x5f, 0x1b, 0xe1, 0xb0, 0x2f, 0xe2, 0x99, 0xf9, 0xdc, 0x00, 0xbf,
	0xdf, 0x20, 0x1e, 0x83, 0xd9, 0x95, 0xc6, 0x95, 0x0b, 0xcc, 0x1c, 0xb8,
	0x9d, 0x6f, 0x7b, 0x30, 0xbf, 0x54, 0x65, 0x6b, 0x9a, 0x4d, 0xa5, 0x86
};
static const uint8_t nist_kas_ecc_cdh_testvector_96_private[] = {
/* dIUT */
	0x12, 0x04, 0x8e, 0xbb, 0x43, 0x31, 0xec, 0x19, 0xa1, 0xe2, 0x3f, 0x1a,
	0x2c, 0x77, 0x3b, 0x66, 0x4c, 0xcf, 0xe9, 0x0a, 0x28, 0xbf, 0xb8, 0x46,
	0xfc, 0x12, 0xf8, 0x1d, 0xff, 0x44, 0xb7, 0x44, 0x3c, 0x77, 0x64, 0x71,
	0x64, 0xbf, 0x1e, 0x9e, 0x67, 0xfd, 0x2c, 0x07, 0xa6, 0x76, 0x62, 0x41
};
/* QIUTx = bc18836bc7a9fdf54b5352f37d7528ab8fa8ec544a8c6180511cbfdd49cce377c39e34c031b5240dc9980503ed2f262c */
/* QIUTy = 8086cbe338191080f0b7a16c7afc4c7b0326f9ac66f58552ef4bb9d24de3429ed5d3277ed58fcf48f2b5f61326bec6c6 */
static const uint8_t nist_kas_ecc_cdh_testvector_96_out[] = {
/* ZIUT */
	0xad, 0x0f, 0xd3, 0xdd, 0xff, 0xe8, 0x88, 0x4b, 0x92, 0x63, 0xf3, 0xc1,
	0x5f, 0xe1, 0xf0, 0x7f, 0x2a, 0x5a, 0x22, 0xff, 0xdc, 0x7e, 0x96, 0x70,
	0x85, 0xee, 0xa4, 0x5f, 0x0c, 0xd9, 0x59, 0xf2, 0x0f, 0x18, 0xf5, 0x22,
	0x76, 0x3e, 0x28, 0xbc, 0xc9, 0x25, 0xe4, 0x96, 0xa5, 0x2d, 0xda, 0x98
};
/* COUNT = 21 */
static const uint8_t nist_kas_ecc_cdh_testvector_97_public_x[] = {
/* QCAVSx */
	0x9e, 0x22, 0xcb, 0xc1, 0x86, 0x57, 0xf5, 0x16, 0xa8, 0x64, 0xb3, 0x7b,
	0x78, 0x33, 0x48, 0xb6, 0x6f, 0x1a, 0xa9, 0x62, 0x6c, 0xd6, 0x31, 0xf4,
	0xfa, 0x1b, 0xd3, 0x2a, 0xd8, 0x8c, 0xf1, 0x1d, 0xb5, 0x20, 0x57, 0xc6,
	0x60, 0x86, 0x0d, 0x39, 0xd1, 0x1f, 0xbf, 0x02, 0x4f, 0xab, 0xd4, 0x44
};
static const uint8_t nist_kas_ecc_cdh_testvector_97_public_y[] = {
/* QCAVSy */
	0x6b, 0x0d, 0x53, 0xc7, 0x96, 0x81, 0xc2, 0x81, 0x16, 0xdf, 0x71, 0xe9,
	0xce, 0xe7, 0x4f, 0xd5, 0x6c, 0x8b, 0x7f, 0x04, 0xb3, 0x9f, 0x11, 0x98,
	0xcc, 0x72, 0x28, 0x4e, 0x98, 0xbe, 0x95, 0x62, 0xe3, 0x59, 0x26, 0xfb,
	0x4f, 0x48, 0xa9, 0xfb, 0xec, 0xaf, 0xe7, 0x29, 0x30, 0x9e, 0x8b, 0x6f
};
static const uint8_t nist_kas_ecc_cdh_testvector_97_private[] = {
/* dIUT */
	0x34, 0xd6, 0x1a, 0x69, 0x9c, 0xa5, 0x76, 0x16, 0x9f, 0xcd, 0xc0, 0xcc,
	0x7e, 0x44, 0xe4, 0xe1, 0x22, 0x1d, 0xb0, 0xfe, 0x63, 0xd1, 0x68, 0x50,
	0xc8, 0x10, 0x40, 0x29, 0xf7, 0xd4, 0x84, 0x49, 0x71, 0x4b, 0x98, 0x84,
	0x32, 0x8c, 0xae, 0x18, 0x99, 0x78, 0x75, 0x4a, 0xb4, 0x60, 0xb4, 0x86
};
/* QIUTx = 867f81104ccd6b163a7902b670ef406042cb0cce7dcdc63d1dfc91b2c40e3cdf7595834bf9eceb79849f1636fc8462fc */
/* QIUTy = 9d4bde8e875ec49697d258d1d59465f8431c6f5531e1c59e9f9ebe3cf164a8d9ce10a12f1979283a959bad244dd83863 */
static const uint8_t nist_kas_ecc_cdh_testvector_97_out[] = {
/* ZIUT */
	0xdc, 0x4c, 0xa3, 0x92, 0xdc, 0x15, 0xe2, 0x01, 0x85, 0xf2, 0xc6, 0xa8,
	0xea, 0x5e, 0xc3, 0x1d, 0xfc, 0x96, 0xf5, 0x61, 0x53, 0xa4, 0x73, 0x94,
	0xb3, 0x07, 0x2b, 0x13, 0xd0, 0x01, 0x5f, 0x5d, 0x4a, 0xe1, 0x3b, 0xeb,
	0x3b, 0xed, 0x54, 0xd6, 0x58, 0x48, 0xf9, 0xb8, 0x38, 0x3e, 0x6c, 0x95
};
/* COUNT = 22 */
static const uint8_t nist_kas_ecc_cdh_testvector_98_public_x[] = {
/* QCAVSx */
	0x2d, 0xb5, 0xda, 0x5f, 0x94, 0x0e, 0xaa, 0x88, 0x4f, 0x4d, 0xb5, 0xec,
	0x21, 0x39, 0xb0, 0x46, 0x9f, 0x38, 0xe4, 0xe6, 0xfb, 0xbc, 0xc5, 0x2d,
	0xf1, 0x5c, 0x0f, 0x7c, 0xf7, 0xfc, 0xb1, 0x80, 0x8c, 0x74, 0x97, 0x64,
	0xb6, 0xbe, 0x85, 0xd2, 0xfd, 0xc5, 0xb1, 0x6f, 0x58, 0xad, 0x5d, 0xc0
};
static const uint8_t nist_kas_ecc_cdh_testvector_98_public_y[] = {
/* QCAVSy */
	0x22, 0xe8, 0xb0, 0x2d, 0xcf, 0x33, 0xe1, 0xb5, 0xa0, 0x83, 0x84, 0x95,
	0x45, 0xf8, 0x4a, 0xd5, 0xe4, 0x3f, 0x77, 0xcb, 0x71, 0x54, 0x6d, 0xbb,
	0xac, 0x0d, 0x11, 0xbd, 0xb2, 0xee, 0x20, 0x2e, 0x9d, 0x38, 0x72, 0xe8,
	0xd0, 0x28, 0xc0, 0x89, 0x90, 0x74, 0x6c, 0x5e, 0x1d, 0xde, 0x99, 0x89
};
static const uint8_t nist_kas_ecc_cdh_testvector_98_private[] = {
/* dIUT */
	0xdc, 0x60, 0xfa, 0x87, 0x36, 0xd7, 0x02, 0x13, 0x5f, 0xf1, 0x6a, 0xab,
	0x99, 0x2b, 0xb8, 0x8e, 0xac, 0x39, 0x7f, 0x59, 0x72, 0x45, 0x6c, 0x72,
	0xec, 0x44, 0x73, 0x74, 0xd0, 0xd8, 0xce, 0x61, 0x15, 0x38, 0x31, 0xbf,
	0xc8, 0x6a, 0xd5, 0xa6, 0xeb, 0x5b, 0x60, 0xbf, 0xb9, 0x6a, 0x86, 0x2c
};
/* QIUTx = b69beede85d0f829fec1b893ccb9c3e052ff692e13b974537bc5b0f9feaf7b22e84f03231629b24866bdb4b8cf908914 */
/* QIUTy = 66f85e2bfcaba2843285b0e14ebc07ef7dafff8b424416fee647b59897b619f20eed95a632e6a4206bf7da429c04c560 */
static const uint8_t nist_kas_ecc_cdh_testvector_98_out[] = {
/* ZIUT */
	0xd7, 0x65, 0xb2, 0x08, 0x11, 0x2d, 0x2b, 0x9e, 0xd5, 0xad, 0x10, 0xc4,
	0x04, 0x6e, 0x2e, 0x3b, 0x0d, 0xbf, 0x57, 0xc4, 0x69, 0x32, 0x95, 0x19,
	0xe2, 0x39, 0xac, 0x28, 0xb2, 0x5c, 0x7d, 0x85, 0x2b, 0xf7, 0x57, 0xd5,
	0xde, 0x0e, 0xe2, 0x71, 0xca, 0xdd, 0x02, 0x1d, 0x86, 0xcf, 0xd3, 0x47
};
/* COUNT = 23 */
static const uint8_t nist_kas_ecc_cdh_testvector_99_public_x[] = {
/* QCAVSx */
	0x32, 0x96, 0x47, 0xba, 0xa3, 0x54, 0x22, 0x4e, 0xb4, 0x41, 0x48, 0x29,
	0xc5, 0x36, 0x8c, 0x82, 0xd7, 0x89, 0x3b, 0x39, 0x80, 0x4e, 0x08, 0xcb,
	0xb2, 0x18, 0x0f, 0x45, 0x9b, 0xef, 0xc4, 0xb3, 0x47, 0xa3, 0x89, 0xa7,
	0x0c, 0x91, 0xa2, 0x3b, 0xd9, 0xd3, 0x0c, 0x83, 0xbe, 0x52, 0x95, 0xd3
};
static const uint8_t nist_kas_ecc_cdh_testvector_99_public_y[] = {
/* QCAVSy */
	0xcc, 0x8f, 0x61, 0x92, 0x3f, 0xad, 0x2a, 0xa8, 0xe5, 0x05, 0xd6, 0xcf,
	0xa1, 0x26, 0xb9, 0xfa, 0xbd, 0x5a, 0xf9, 0xdc, 0xe2, 0x90, 0xb7, 0x56,
	0x60, 0xef, 0x06, 0xd1, 0xca, 0xa7, 0x36, 0x81, 0xd0, 0x60, 0x89, 0xc3,
	0x3b, 0xc4, 0x24, 0x6b, 0x3a, 0xa3, 0x0d, 0xbc, 0xd2, 0x43, 0x5b, 0x12
};
static const uint8_t nist_kas_ecc_cdh_testvector_99_private[] = {
/* dIUT */
	0x6f, 0xa6, 0xa1, 0xc7, 0x04, 0x73, 0x09, 0x87, 0xaa, 0x63, 0x4b, 0x05,
	0x16, 0xa8, 0x26, 0xab, 0xa8, 0xc6, 0xd6, 0x41, 0x1d, 0x3a, 0x4c, 0x89,
	0x77, 0x2d, 0x7a, 0x62, 0x61, 0x02, 0x56, 0xa2, 0xe2, 0xf2, 0x89, 0xf5,
	0xc3, 0x44, 0x0b, 0x0e, 0xc1, 0xe7, 0x0f, 0xa3, 0x39, 0xe2, 0x51, 0xce
};
/* QIUTx = 53de1fc1328e8de14aecab29ad8a40d6b13768f86f7d298433d20fec791f86f8bc73f358098b256a298bb488de257bf4 */
/* QIUTy = ac28944fd27f17b82946c04c66c41f0053d3692f275da55cd8739a95bd8cd3af2f96e4de959ea8344d8945375905858b */
static const uint8_t nist_kas_ecc_cdh_testvector_99_out[] = {
/* ZIUT */
	0xd3, 0x77, 0x88, 0x50, 0xae, 0xb5, 0x88, 0x04, 0xfb, 0xe9, 0xdf, 0xe6,
	0xf3, 0x8b, 0x9f, 0xa8, 0xe2, 0x0c, 0x2c, 0xa4, 0xe0, 0xde, 0xc3, 0x35,
	0xaa, 0xfc, 0xec, 0xa0, 0x33, 0x3e, 0x3f, 0x24, 0x90, 0xb5, 0x3c, 0x0c,
	0x1a, 0x14, 0xa8, 0x31, 0xba, 0x37, 0xc4, 0xb9, 0xd7, 0x4b, 0xe0, 0xf2
};
/* COUNT = 24 */
static const uint8_t nist_kas_ecc_cdh_testvector_100_public_x[] = {
/* QCAVSx */
	0x29, 0xd8, 0xa3, 0x6d, 0x22, 0x20, 0x0a, 0x75, 0xb7, 0xae, 0xa1, 0xbb,
	0x47, 0xcd, 0xfc, 0xb1, 0xb7, 0xfd, 0x66, 0xde, 0x96, 0x70, 0x41, 0x43,
	0x47, 0x28, 0xab, 0x5d, 0x53, 0x3a, 0x06, 0x0d, 0xf7, 0x32, 0x13, 0x06,
	0x00, 0xfe, 0x6f, 0x75, 0x85, 0x2a, 0x87, 0x1f, 0xb2, 0x93, 0x8e, 0x39
};
static const uint8_t nist_kas_ecc_cdh_testvector_100_public_y[] = {
/* QCAVSy */
	0xe1, 0x9b, 0x53, 0xdb, 0x52, 0x83, 0x95, 0xde, 0x89, 0x7a, 0x45, 0x10,
	0x89, 0x67, 0x71, 0x5e, 0xb8, 0xcb, 0x55, 0xc3, 0xfc, 0xbf, 0x23, 0x37,
	0x93, 0x72, 0xc0, 0x87, 0x3a, 0x05, 0x8d, 0x57, 0x54, 0x4b, 0x10, 0x2e,
	0xcc, 0xe7, 0x22, 0xb2, 0xcc, 0xab, 0xb1, 0xa6, 0x03, 0x77, 0x4f, 0xd5
};
static const uint8_t nist_kas_ecc_cdh_testvector_100_private[] = {
/* dIUT */
	0x74, 0xad, 0x83, 0x86, 0xc1, 0xcb, 0x2c, 0xa0, 0xfc, 0xde, 0xb3, 0x1e,
	0x08, 0x69, 0xbb, 0x3f, 0x48, 0xc0, 0x36, 0xaf, 0xe2, 0xef, 0x11, 0x0c,
	0xa3, 0x02, 0xbc, 0x8b, 0x91, 0x0f, 0x62, 0x1c, 0x9f, 0xcc, 0x54, 0xce,
	0xc3, 0x2b, 0xb8, 0x9e, 0xc7, 0xca, 0xa8, 0x4c, 0x7b, 0x8e, 0x54, 0xa8
};
/* QIUTx = 27a3e83cfb9d5122e73129d801615857da7cc089cccc9c54ab3032a19e0a0a9f677346e37f08a0b3ed8da6e5dd691063 */
/* QIUTy = 8d60e44aa5e0fd30c918456796af37f0e41957901645e5c596c6d989f5859b03a0bd7d1f4e77936fff3c74d204e5388e */
static const uint8_t nist_kas_ecc_cdh_testvector_100_out[] = {
/* ZIUT */
	0x81, 0xe1, 0xe7, 0x15, 0x75, 0xbb, 0x45, 0x05, 0x49, 0x8d, 0xe0, 0x97,
	0x35, 0x01, 0x86, 0x43, 0x0a, 0x62, 0x42, 0xfa, 0x6c, 0x57, 0xb8, 0x5a,
	0x5f, 0x98, 0x4a, 0x23, 0x37, 0x11, 0x23, 0xd2, 0xd1, 0x42, 0x4e, 0xef,
	0xbf, 0x80, 0x42, 0x58, 0x39, 0x2b, 0xc7, 0x23, 0xe4, 0xef, 0x1e, 0x35
};
/* [P-521] */
/* COUNT = 0 */
static const uint8_t nist_kas_ecc_cdh_testvector_101_public_x[] = {
/* QCAVSx */
	0x00, 0x68, 0x5a, 0x48, 0xe8, 0x6c, 0x79, 0xf0, 0xf0, 0x87, 0x5f, 0x7b,
	0xc1, 0x8d, 0x25, 0xeb, 0x5f, 0xc8, 0xc0, 0xb0, 0x7e, 0x5d, 0xa4, 0xf4,
	0x37, 0x0f, 0x3a, 0x94, 0x90, 0x34, 0x08, 0x54, 0x33, 0x4b, 0x1e, 0x1b,
	0x87, 0xfa, 0x39, 0x54, 0x64, 0xc6, 0x06, 0x26, 0x12, 0x4a, 0x4e, 0x70,
	0xd0, 0xf7, 0x85, 0x60, 0x1d, 0x37, 0xc0, 0x98, 0x70, 0xeb, 0xf1, 0x76,
	0x66, 0x68, 0x77, 0xa2, 0x04, 0x6d
};
static const uint8_t nist_kas_ecc_cdh_testvector_101_public_y[] = {
/* QCAVSy */
	0x01, 0xba, 0x52, 0xc5, 0x6f, 0xc8, 0x77, 0x6d, 0x9e, 0x8f, 0x5d, 0xb4,
	0xf0, 0xcc, 0x27, 0x63, 0x6d, 0x0b, 0x74, 0x1b, 0xbe, 0x05, 0x40, 0x06,
	0x97, 0x94, 0x2e, 0x80, 0xb7, 0x39, 0x88, 0x4a, 0x83, 0xbd, 0xe9, 0x9e,
	0x0f, 0x67, 0x16, 0x93, 0x9e, 0x63, 0x2b, 0xc8, 0x98, 0x6f, 0xa1, 0x8d,
	0xcc, 0xd4, 0x43, 0xa3, 0x48, 0xb6, 0xc3, 0xe5, 0x22, 0x49, 0x79, 0x55,
	0xa4, 0xf3, 0xc3, 0x02, 0xf6, 0x76
};
static const uint8_t nist_kas_ecc_cdh_testvector_101_private[] = {
/* dIUT */
	0x01, 0x7e, 0xec, 0xc0, 0x7a, 0xb4, 0xb3, 0x29, 0x06, 0x8f, 0xba, 0x65,
	0xe5, 0x6a, 0x1f, 0x88, 0x90, 0xaa, 0x93, 0x5e, 0x57, 0x13, 0x4a, 0xe0,
	0xff, 0xcc, 0xe8, 0x02, 0x73, 0x51, 0x51, 0xf4, 0xea, 0xc6, 0x56, 0x4f,
	0x6e, 0xe9, 0x97, 0x4c, 0x5e, 0x68, 0x87, 0xa1, 0xfe, 0xfe, 0xe5, 0x74,
	0x3a, 0xe2, 0x24, 0x1b, 0xfe, 0xb9, 0x5d, 0x5c, 0xe3, 0x1d, 0xdc, 0xb6,
	0xf9, 0xed, 0xb4, 0xd6, 0xfc, 0x47
};
/* QIUTx = 000000602f9d0cf9e526b29e22381c203c48a886c2b0673033366314f1ffbcba240ba42f4ef38a76174635f91e6b4ed34275eb01c8467d05ca80315bf1a7bbd945f550a5 */
/* QIUTy = 000001b7c85f26f5d4b2d7355cf6b02117659943762b6d1db5ab4f1dbc44ce7b2946eb6c7de342962893fd387d1b73d7a8672d1f236961170b7eb3579953ee5cdc88cd2d */
static const uint8_t nist_kas_ecc_cdh_testvector_101_out[] = {
/* ZIUT */
	0x00, 0x5f, 0xc7, 0x04, 0x77, 0xc3, 0xe6, 0x3b, 0xc3, 0x95, 0x4b, 0xd0,
	0xdf, 0x3e, 0xa0, 0xd1, 0xf4, 0x1e, 0xe2, 0x17, 0x46, 0xed, 0x95, 0xfc,
	0x5e, 0x1f, 0xdf, 0x90, 0x93, 0x0d, 0x5e, 0x13, 0x66, 0x72, 0xd7, 0x2c,
	0xc7, 0x70, 0x74, 0x2d, 0x17, 0x11, 0xc3, 0xc3, 0xa4, 0xc3, 0x34, 0xa0,
	0xad, 0x97, 0x59, 0x43, 0x6a, 0x4d, 0x3c, 0x5b, 0xf6, 0xe7, 0x4b, 0x95,
	0x78, 0xfa, 0xc1, 0x48, 0xc8, 0x31
};
/* COUNT = 1 */
static const uint8_t nist_kas_ecc_cdh_testvector_102_public_x[] = {
/* QCAVSx */
	0x01, 0xdf, 0x27, 0x7c, 0x15, 0x21, 0x08, 0x34, 0x9b, 0xc3, 0x4d, 0x53,
	0x9e, 0xe0, 0xcf, 0x06, 0xb2, 0x4f, 0x5d, 0x35, 0x00, 0x67, 0x7b, 0x44,
	0x45, 0x45, 0x3c, 0xcc, 0x21, 0x40, 0x94, 0x53, 0xaa, 0xfb, 0x8a, 0x72,
	0xa0, 0xbe, 0x9e, 0xbe, 0x54, 0xd1, 0x22, 0x70, 0xaa, 0x51, 0xb3, 0xab,
	0x7f, 0x31, 0x6a, 0xa5, 0xe7, 0x4a, 0x95, 0x1c, 0x5e, 0x53, 0xf7, 0x4c,
	0xd9, 0x5f, 0xc2, 0x9a, 0xee, 0x7a
};
static const uint8_t nist_kas_ecc_cdh_testvector_102_public_y[] = {
/* QCAVSy */
	0x01, 0x3d, 0x52, 0xf3, 0x3a, 0x9f, 0x3c, 0x14, 0x38, 0x4d, 0x15, 0x87,
	0xfa, 0x8a, 0xbe, 0x7a, 0xed, 0x74, 0xbc, 0x33, 0x74, 0x9a, 0xd9, 0xc5,
	0x70, 0xb4, 0x71, 0x77, 0x64, 0x22, 0xc7, 0xd4, 0x50, 0x5d, 0x9b, 0x0a,
	0x96, 0xb3, 0xbf, 0xac, 0x04, 0x1e, 0x4c, 0x6a, 0x69, 0x90, 0xae, 0x7f,
	0x70, 0x0e, 0x5b, 0x4a, 0x66, 0x40, 0x22, 0x91, 0x12, 0xde, 0xaf, 0xa0,
	0xcd, 0x8b, 0xb0, 0xd0, 0x89, 0xb0
};
static const uint8_t nist_kas_ecc_cdh_testvector_102_private[] = {
/* dIUT */
	0x00, 0x81, 0x6f, 0x19, 0xc1, 0xfb, 0x10, 0xef, 0x94, 0xd4, 0xa1, 0xd8,
	0x1c, 0x15, 0x6e, 0xc3, 0xd1, 0xde, 0x08, 0xb6, 0x67, 0x61, 0xf0, 0x3f,
	0x06, 0xee, 0x4b, 0xb9, 0xdc, 0xeb, 0xbb, 0xfe, 0x1e, 0xaa, 0x1e, 0xd4,
	0x9a, 0x6a, 0x99, 0x08, 0x38, 0xd8, 0xed, 0x31, 0x8c, 0x14, 0xd7, 0x4c,
	0xc8, 0x72, 0xf9, 0x5d, 0x05, 0xd0, 0x7a, 0xd5, 0x0f, 0x62, 0x1c, 0xeb,
	0x62, 0x0c, 0xd9, 0x05, 0xcf, 0xb8
};
/* QIUTx = 000000d45615ed5d37fde699610a62cd43ba76bedd8f85ed31005fe00d6450fbbd101291abd96d4945a8b57bc73b3fe9f4671105309ec9b6879d0551d930dac8ba45d255 */
/* QIUTy = 000001425332844e592b440c0027972ad1526431c06732df19cd46a242172d4dd67c2c8c99dfc22e49949a56cf90c6473635ce82f25b33682fb19bc33bd910ed8ce3a7fa */
static const uint8_t nist_kas_ecc_cdh_testvector_102_out[] = {
/* ZIUT */
	0x00, 0x0b, 0x39, 0x20, 0xac, 0x83, 0x0a, 0xde, 0x81, 0x2c, 0x8f, 0x96,
	0x80, 0x5d, 0xa2, 0x23, 0x6e, 0x00, 0x2a, 0xcb, 0xbf, 0x13, 0x59, 0x6a,
	0x9a, 0xb2, 0x54, 0xd4, 0x4d, 0x0e, 0x91, 0xb6, 0x25, 0x5e, 0xbf, 0x12,
	0x29, 0xf3, 0x66, 0xfb, 0x5a, 0x05, 0xc5, 0x88, 0x4e, 0xf4, 0x60, 0x32,
	0xc2, 0x6d, 0x42, 0x18, 0x92, 0x73, 0xca, 0x4e, 0xfa, 0x4c, 0x3d, 0xb6,
	0xbd, 0x12, 0xa6, 0x85, 0x37, 0x59
};
/* COUNT = 2 */
static const uint8_t nist_kas_ecc_cdh_testvector_103_public_x[] = {
/* QCAVSx */
	0x00, 0x92, 0xdb, 0x31, 0x42, 0x56, 0x4d, 0x27, 0xa5, 0xf0, 0x00, 0x6f,
	0x81, 0x99, 0x08, 0xfb, 0xa1, 0xb8, 0x50, 0x38, 0xa5, 0xbc, 0x25, 0x09,
	0x90, 0x6a, 0x49, 0x7d, 0xaa, 0xc6, 0x7f, 0xd7, 0xae, 0xe0, 0xfc, 0x2d,
	0xab, 0xa4, 0xe4, 0x33, 0x4e, 0xea, 0xef, 0x0e, 0x00, 0x19, 0x20, 0x4b,
	0x47, 0x1c, 0xd8, 0x80, 0x24, 0xf8, 0x21, 0x15, 0xd8, 0x14, 0x9c, 0xc0,
	0xcf, 0x4f, 0x7c, 0xe1, 0xa4, 0xd5
};
static const uint8_t nist_kas_ecc_cdh_testvector_103_public_y[] = {
/* QCAVSy */
	0x01, 0x6b, 0xad, 0x06, 0x23, 0xf5, 0x17, 0xb1, 0x58, 0xd9, 0x88, 0x18,
	0x41, 0xd2, 0x57, 0x1e, 0xfb, 0xad, 0x63, 0xf8, 0x5c, 0xbe, 0x2e, 0x58,
	0x19, 0x60, 0xc5, 0xd6, 0x70, 0x60, 0x1a, 0x67, 0x60, 0x27, 0x26, 0x75,
	0xa5, 0x48, 0x99, 0x62, 0x17, 0xe4, 0xab, 0x2b, 0x8e, 0xbc, 0xe3, 0x1d,
	0x71, 0xfc, 0xa6, 0x3f, 0xcc, 0x3c, 0x08, 0xe9, 0x1c, 0x1d, 0x8e, 0xdd,
	0x91, 0xcf, 0x6f, 0xe8, 0x45, 0xf8
};
static const uint8_t nist_kas_ecc_cdh_testvector_103_private[] = {
/* dIUT */
	0x01, 0x2f, 0x2e, 0x0c, 0x6d, 0x9e, 0x9d, 0x11, 0x7c, 0xeb, 0x97, 0x23,
	0xbc, 0xed, 0x02, 0xeb, 0x3d, 0x4e, 0xeb, 0xf5, 0xfe, 0xea, 0xf8, 0xee,
	0x01, 0x13, 0xcc, 0xd8, 0x05, 0x7b, 0x13, 0xdd, 0xd4, 0x16, 0xe0, 0xb7,
	0x42, 0x80, 0xc2, 0xd0, 0xba, 0x8e, 0xd2, 0x91, 0xc4, 0x43, 0xbc, 0x1b,
	0x14, 0x1c, 0xaf, 0x8a, 0xfb, 0x3a, 0x71, 0xf9, 0x7f, 0x57, 0xc2, 0x25,
	0xc0, 0x3e, 0x1e, 0x4d, 0x42, 0xb0
};
/* QIUTx = 000000717fcb3d4a40d103871ede044dc803db508aaa4ae74b70b9fb8d8dfd84bfecfad17871879698c292d2fd5e17b4f9343636c531a4fac68a35a93665546b9a878679 */
/* QIUTy = 000000f3d96a8637036993ab5d244500fff9d2772112826f6436603d3eb234a44d5c4e5c577234679c4f9df725ee5b9118f23d8a58d0cc01096daf70e8dfec0128bdc2e8 */
static const uint8_t nist_kas_ecc_cdh_testvector_103_out[] = {
/* ZIUT */
	0x00, 0x6b, 0x38, 0x0a, 0x6e, 0x95, 0x67, 0x92, 0x77, 0xcf, 0xee, 0x4e,
	0x83, 0x53, 0xbf, 0x96, 0xef, 0x2a, 0x1e, 0xbd, 0xd0, 0x60, 0x74, 0x9f,
	0x2f, 0x04, 0x6f, 0xe5, 0x71, 0x05, 0x37, 0x40, 0xbb, 0xcc, 0x9a, 0x0b,
	0x55, 0x79, 0x0b, 0xc9, 0xab, 0x56, 0xc3, 0x20, 0x8a, 0xa0, 0x5d, 0xdf,
	0x74, 0x6a, 0x10, 0xa3, 0xad, 0x69, 0x4d, 0xaa, 0xe0, 0x0d, 0x98, 0x0d,
	0x94, 0x4a, 0xab, 0xc6, 0xa0, 0x8f
};
/* COUNT = 3 */
static const uint8_t nist_kas_ecc_cdh_testvector_104_public_x[] = {
/* QCAVSx */
	0x00, 0xfd, 0xd4, 0x0d, 0x9e, 0x9d, 0x97, 0x40, 0x27, 0xcb, 0x3b, 0xae,
	0x68, 0x21, 0x62, 0xea, 0xc1, 0x32, 0x8a, 0xd6, 0x1b, 0xc4, 0x35, 0x3c,
	0x45, 0xbf, 0x5a, 0xfe, 0x76, 0xbf, 0x60, 0x7d, 0x28, 0x94, 0xc8, 0xcc,
	0xe2, 0x36, 0x95, 0xd9, 0x20, 0xf2, 0x46, 0x4f, 0xda, 0x47, 0x73, 0xd4,
	0x69, 0x3b, 0xe4, 0xb3, 0x77, 0x35, 0x84, 0x69, 0x1b, 0xdb, 0x03, 0x29,
	0xb7, 0xf4, 0xc8, 0x6c, 0xc2, 0x99
};
static const uint8_t nist_kas_ecc_cdh_testvector_104_public_y[] = {
/* QCAVSy */
	0x00, 0x34, 0xce, 0xac, 0x6a, 0x3f, 0xef, 0x1c, 0x3e, 0x1c, 0x49, 0x4b,
	0xfe, 0x8d, 0x87, 0x2b, 0x18, 0x38, 0x32, 0x21, 0x9a, 0x7e, 0x14, 0xda,
	0x41, 0x4d, 0x4e, 0x34, 0x74, 0x57, 0x36, 0x71, 0xec, 0x19, 0xb0, 0x33,
	0xbe, 0x83, 0x1b, 0x91, 0x54, 0x35, 0x90, 0x59, 0x25, 0xb4, 0x49, 0x47,
	0xc5, 0x92, 0x95, 0x99, 0x45, 0xb4, 0xeb, 0x7c, 0x95, 0x1c, 0x3b, 0x9c,
	0x8c, 0xf5, 0x25, 0x30, 0xba, 0x23
};
static const uint8_t nist_kas_ecc_cdh_testvector_104_private[] = {
/* dIUT */
	0x00, 0xe5, 0x48, 0xa7, 0x9d, 0x8b, 0x05, 0xf9, 0x23, 0xb9, 0x82, 0x5d,
	0x11, 0xb6, 0x56, 0xf2, 0x22, 0xe8, 0xcb, 0x98, 0xb0, 0xf8, 0x9d, 0xe1,
	0xd3, 0x17, 0x18, 0x4d, 0xc5, 0xa6, 0x98, 0xf7, 0xc7, 0x11, 0x61, 0xee,
	0x7d, 0xc1, 0x1c, 0xd3, 0x1f, 0x4f, 0x4f, 0x8a, 0xe3, 0xa9, 0x81, 0xe1,
	0xa3, 0xe7, 0x8b, 0xde, 0xbb, 0x97, 0xd7, 0xc2, 0x04, 0xb9, 0x26, 0x1b,
	0x4e, 0xf9, 0x2e, 0x09, 0x18, 0xe0
};
/* QIUTx = 0000000ce800217ed243dd10a79ad73df578aa8a3f9194af528cd1094bbfee27a3b5481ad5862c8876c0c3f91294c0ab3aa806d9020cbaa2ed72b7fecdc5a09a6dad6f32 */
/* QIUTy = 000001543c9ab45b12469232918e21d5a351f9a4b9cbf9efb2afcc402fa9b31650bec2d641a05c440d35331c0893d11fb13151335988b303341301a73dc5f61d574e67d9 */
static const uint8_t nist_kas_ecc_cdh_testvector_104_out[] = {
/* ZIUT */
	0x00, 0xfb, 0xbc, 0xd0, 0xb8, 0xd0, 0x53, 0x31, 0xfe, 0xf6, 0x08, 0x6f,
	0x22, 0xa6, 0xcc, 0xe4, 0xd3, 0x57, 0x24, 0xab, 0x7a, 0x2f, 0x49, 0xdd,
	0x84, 0x58, 0xd0, 0xbf, 0xd5, 0x7a, 0x0b, 0x8b, 0x70, 0xf2, 0x46, 0xc1,
	0x7c, 0x44, 0x68, 0xc0, 0x76, 0x87, 0x4b, 0x0d, 0xff, 0x7a, 0x03, 0x36,
	0x82, 0x3b, 0x19, 0xe9, 0x8b, 0xf1, 0xce, 0xc0, 0x5e, 0x4b, 0xef, 0xfb,
	0x05, 0x91, 0xf9, 0x77, 0x13, 0xc6
};
/* COUNT = 4 */
static const uint8_t nist_kas_ecc_cdh_testvector_105_public_x[] = {
/* QCAVSx */
	0x00, 0x98, 0xd9, 0x9d, 0xee, 0x08, 0x16, 0x55, 0x0e, 0x84, 0xdb, 0xfc,
	0xed, 0x7e, 0x88, 0x13, 0x7f, 0xdd, 0xcf, 0x58, 0x1a, 0x72, 0x5a, 0x45,
	0x50, 0x21, 0x11, 0x5f, 0xe4, 0x9f, 0x8d, 0xc3, 0xcf, 0x23, 0x3c, 0xd9,
	0xea, 0x0e, 0x6f, 0x03, 0x9d, 0xc7, 0x91, 0x9d, 0xa9, 0x73, 0xcd, 0xce,
	0xac, 0xa2, 0x05, 0xda, 0x39, 0xe0, 0xbd, 0x98, 0xc8, 0x06, 0x25, 0x36,
	0xc4, 0x7f, 0x25, 0x8f, 0x44, 0xb5
};
static const uint8_t nist_kas_ecc_cdh_testvector_105_public_y[] = {
/* QCAVSy */
	0x00, 0xcd, 0x22, 0x5c, 0x87, 0x97, 0x37, 0x1b, 0xe0, 0xc4, 0x29, 0x7d,
	0x2b, 0x45, 0x77, 0x40, 0x10, 0x0c, 0x77, 0x41, 0x41, 0xd8, 0xf2, 0x14,
	0xc2, 0x3b, 0x61, 0xaa, 0x2b, 0x6c, 0xd4, 0x80, 0x6b, 0x9b, 0x70, 0x72,
	0x2a, 0xa4, 0x96, 0x5f, 0xb6, 0x22, 0xf4, 0x2b, 0x73, 0x91, 0xe2, 0x7e,
	0x5e, 0xc2, 0x1c, 0x56, 0x79, 0xc5, 0xb0, 0x6b, 0x59, 0x12, 0x73, 0x72,
	0x99, 0x7d, 0x42, 0x1a, 0xdc, 0x1e
};
static const uint8_t nist_kas_ecc_cdh_testvector_105_private[] = {
/* dIUT */
	0x01, 0xc8, 0xaa, 0xe9, 0x4b, 0xb1, 0x0b, 0x8c, 0xa4, 0xf7, 0xbe, 0x57,
	0x7b, 0x4f, 0xb3, 0x2b, 0xb2, 0x38, 0x10, 0x32, 0xc4, 0x94, 0x2c, 0x24,
	0xfc, 0x2d, 0x75, 0x3e, 0x7c, 0xc5, 0xe4, 0x7b, 0x48, 0x33, 0x89, 0xd9,
	0xf3, 0xb9, 0x56, 0xd2, 0x0e, 0xe9, 0x00, 0x1b, 0x1e, 0xef, 0x9f, 0x23,
	0x54, 0x5f, 0x72, 0xc5, 0x60, 0x21, 0x40, 0x04, 0x68, 0x39, 0xe9, 0x63,
	0x31, 0x3c, 0x3d, 0xec, 0xc8, 0x64
};
/* QIUTx = 00000106a14e2ee8ff970aa8ab0c79b97a33bba2958e070b75b94736b77bbe3f777324fa52872771aa88a63a9e8490c3378df4dc760cd14d62be700779dd1a4377943656 */
/* QIUTy = 0000002366ce3941e0b284b1aa81215d0d3b9778fce23c8cd1e4ed6fa0abf62156c91d4b3eb55999c3471bed275e9e60e5aa9d690d310bfb15c9c5bbd6f5e9eb39682b74 */
static const uint8_t nist_kas_ecc_cdh_testvector_105_out[] = {
/* ZIUT */
	0x01, 0x45, 0xcf, 0xa3, 0x8f, 0x25, 0x94, 0x35, 0x16, 0xc9, 0x6a, 0x5f,
	0xd4, 0xbf, 0xeb, 0xb2, 0xf6, 0x45, 0xd1, 0x05, 0x20, 0x11, 0x7a, 0xa5,
	0x19, 0x71, 0xef, 0xf4, 0x42, 0x80, 0x8a, 0x23, 0xb4, 0xe2, 0x3c, 0x18,
	0x7e, 0x63, 0x9f, 0xf9, 0x28, 0xc3, 0x72, 0x5f, 0xbd, 0x1c, 0x0c, 0x2a,
	0xd0, 0xd4, 0xae, 0xb2, 0x07, 0xbc, 0x1a, 0x6f, 0xb6, 0xcb, 0x6d, 0x46,
	0x78, 0x88, 0xdc, 0x04, 0x4b, 0x3c
};
/* COUNT = 5 */
static const uint8_t nist_kas_ecc_cdh_testvector_106_public_x[] = {
/* QCAVSx */
	0x00, 0x7a, 0xe1, 0x15, 0xad, 0xaa, 0xf0, 0x41, 0x69, 0x1a, 0xb6, 0xb7,
	0xfb, 0x8c, 0x92, 0x1f, 0x99, 0xd8, 0xed, 0x32, 0xd2, 0x83, 0xd6, 0x70,
	0x84, 0xe8, 0x0b, 0x9a, 0xd9, 0xc4, 0x0c, 0x56, 0xcd, 0x98, 0x38, 0x9f,
	0xb0, 0xa8, 0x49, 0xd9, 0xec, 0xf7, 0x26, 0x8c, 0x29, 0x7b, 0x6f, 0x93,
	0x40, 0x61, 0x19, 0xf4, 0x0e, 0x32, 0xb5, 0x77, 0x3e, 0xd2, 0x5a, 0x28,
	0xa9, 0xa8, 0x5c, 0x4a, 0x75, 0x88
};
static const uint8_t nist_kas_ecc_cdh_testvector_106_public_y[] = {
/* QCAVSy */
	0x01, 0xa2, 0x8e, 0x00, 0x4e, 0x37, 0xee, 0xae, 0xfe, 0x1f, 0x4d, 0xbb,
	0x71, 0xf1, 0x87, 0x86, 0x96, 0x14, 0x1a, 0xf3, 0xa1, 0x0a, 0x96, 0x91,
	0xc4, 0xed, 0x93, 0x48, 0x72, 0x14, 0x64, 0x3b, 0x76, 0x1f, 0xa4, 0xb0,
	0xfb, 0xee, 0xb2, 0x47, 0xcf, 0x6d, 0x3f, 0xba, 0x7a, 0x60, 0x69, 0x75,
	0x36, 0xad, 0x03, 0xf4, 0x9b, 0x80, 0xa9, 0xd1, 0xcb, 0x07, 0x96, 0x73,
	0x65, 0x49, 0x77, 0xc5, 0xfa, 0x94
};
static const uint8_t nist_kas_ecc_cdh_testvector_106_private[] = {
/* dIUT */
	0x00, 0x9b, 0x0a, 0xf1, 0x37, 0xc9, 0x69, 0x6c, 0x75, 0xb7, 0xe6, 0xdf,
	0x7b, 0x73, 0x15, 0x6b, 0xb2, 0xd4, 0x5f, 0x48, 0x2e, 0x5a, 0x42, 0x17,
	0x32, 0x4f, 0x47, 0x8b, 0x10, 0xce, 0xb7, 0x6a, 0xf0, 0x97, 0x24, 0xcf,
	0x86, 0xaf, 0xa3, 0x16, 0xe7, 0xf8, 0x99, 0x18, 0xd3, 0x1d, 0x54, 0x82,
	0x4a, 0x5c, 0x33, 0x10, 0x7a, 0x48, 0x3c, 0x15, 0xc1, 0x5b, 0x96, 0xed,
	0xc6, 0x61, 0x34, 0x0b, 0x1c, 0x0e
};
/* QIUTx = 000000748cdbb875d35f4bccb62abe20e82d32e4c14dc2feb5b87da2d0ccb11c9b6d4b7737b6c46f0dfb4d896e2db92fcf53cdbbae2a404c0babd564ad7adeac6273efa3 */
/* QIUTy = 000001984acab8d8f173323de0bb60274b228871609373bb22a17287e9dec7495873abc09a8915b54c8455c8e02f654f602e23a2bbd7a9ebb74f3009bd65ecc650814cc0 */
static const uint8_t nist_kas_ecc_cdh_testvector_106_out[] = {
/* ZIUT */
	0x00, 0x5c, 0x57, 0x21, 0xe9, 0x6c, 0x27, 0x33, 0x19, 0xfd, 0x60, 0xec,
	0xc4, 0x6b, 0x59, 0x62, 0xf6, 0x98, 0xe9, 0x74, 0xb4, 0x29, 0xf2, 0x8f,
	0xe6, 0x96, 0x2f, 0x4a, 0xc6, 0x56, 0xbe, 0x2e, 0xb8, 0x67, 0x4c, 0x4a,
	0xaf, 0xc0, 0x37, 0xea, 0xb4, 0x8e, 0xce, 0x61, 0x29, 0x53, 0xb1, 0xe8,
	0xd8, 0x61, 0x01, 0x6b, 0x6a, 0xd0, 0xc7, 0x98, 0x05, 0x78, 0x4c, 0x67,
	0xf7, 0x3a, 0xda, 0x96, 0xf3, 0x51
};
/* COUNT = 6 */
static const uint8_t nist_kas_ecc_cdh_testvector_107_public_x[] = {
/* QCAVSx */
	0x01, 0x25, 0x88, 0x11, 0x5e, 0x6f, 0x7f, 0x7b, 0xdc, 0xfd, 0xf5, 0x7f,
	0x03, 0xb1, 0x69, 0xb4, 0x79, 0x75, 0x8b, 0xaa, 0xfd, 0xaf, 0x56, 0x9d,
	0x04, 0x13, 0x59, 0x87, 0xb2, 0xce, 0x61, 0x64, 0xc0, 0x2a, 0x57, 0x68,
	0x5e, 0xb5, 0x27, 0x6b, 0x5d, 0xae, 0x62, 0x95, 0xd3, 0xfe, 0x90, 0x62,
	0x0f, 0x38, 0xb5, 0x53, 0x5c, 0x6d, 0x22, 0x60, 0xc1, 0x73, 0xe6, 0x1e,
	0xb8, 0x88, 0xca, 0x92, 0x02, 0x03
};
static const uint8_t nist_kas_ecc_cdh_testvector_107_public_y[] = {
/* QCAVSy */
	0x01, 0x54, 0x2c, 0x16, 0x9c, 0xf9, 0x7c, 0x25, 0x96, 0xfe, 0x2d, 0xdd,
	0x84, 0x8a, 0x22, 0x2e, 0x36, 0x7c, 0x5f, 0x7e, 0x62, 0x67, 0xeb, 0xc1,
	0xbc, 0xd9, 0xab, 0x5d, 0xcf, 0x49, 0x15, 0x8f, 0x1a, 0x48, 0xe4, 0xaf,
	0x29, 0xa8, 0x97, 0xb7, 0xe6, 0xa8, 0x20, 0x91, 0xc2, 0xdb, 0x87, 0x4d,
	0x8e, 0x7a, 0xbf, 0x0f, 0x58, 0x06, 0x46, 0x91, 0x34, 0x41, 0x54, 0xf3,
	0x96, 0xdb, 0xae, 0xd1, 0x88, 0xb6
};
static const uint8_t nist_kas_ecc_cdh_testvector_107_private[] = {
/* dIUT */
	0x01, 0xe4, 0x8f, 0xaa, 0xce, 0xe6, 0xde, 0xc8, 0x3f, 0xfc, 0xde, 0x94,
	0x4c, 0xf6, 0xbd, 0xf4, 0xce, 0x4b, 0xae, 0x72, 0x74, 0x78, 0x88, 0xeb,
	0xaf, 0xee, 0x45, 0x5b, 0x1e, 0x91, 0x58, 0x49, 0x71, 0xef, 0xb4, 0x91,
	0x27, 0x97, 0x6a, 0x52, 0xf4, 0x14, 0x29, 0x52, 0xf7, 0xc2, 0x07, 0xec,
	0x02, 0x65, 0xf2, 0xb7, 0x18, 0xcf, 0x3e, 0xad, 0x96, 0xea, 0x4f, 0x62,
	0xc7, 0x52, 0xe4, 0xf7, 0xac, 0xd3
};
/* QIUTx = 0000010eb1b4d9172bcc23f4f20cc9560fc54928c3f34ea61c00391dc766c76ed9fa608449377d1e4fadd1236025417330b4b91086704ace3e4e6484c606e2a943478c86 */
/* QIUTy = 00000149413864069825ee1d0828da9f4a97713005e9bd1adbc3b38c5b946900721a960fe96ad2c1b3a44fe3de9156136d44cb17cbc2415729bb782e16bfe2deb3069e43 */
static const uint8_t nist_kas_ecc_cdh_testvector_107_out[] = {
/* ZIUT */
	0x01, 0x73, 0x6d, 0x97, 0x17, 0x42, 0x9b, 0x4f, 0x41, 0x2e, 0x90, 0x3f,
	0xeb, 0xe2, 0xf9, 0xe0, 0xff, 0xfd, 0x81, 0x35, 0x5d, 0x6c, 0xe2, 0xc0,
	0x6f, 0xf3, 0xf6, 0x6a, 0x3b, 0xe1, 0x5c, 0xee, 0xc6, 0xe6, 0x5e, 0x30,
	0x83, 0x47, 0x59, 0x3f, 0x00, 0xd7, 0xf3, 0x35, 0x91, 0xda, 0x40, 0x43,
	0xc3, 0x07, 0x63, 0xd7, 0x27, 0x49, 0xf7, 0x2c, 0xdc, 0xee, 0xbe, 0x82,
	0x5e, 0x4b, 0x34, 0xec, 0xd5, 0x70
};
/* COUNT = 7 */
static const uint8_t nist_kas_ecc_cdh_testvector_108_public_x[] = {
/* QCAVSx */
	0x01, 0x69, 0x49, 0x1d, 0x55, 0xbd, 0x09, 0x04, 0x9f, 0xdf, 0x4c, 0x2a,
	0x53, 0xa6, 0x60, 0x48, 0x0f, 0xee, 0x4c, 0x03, 0xa0, 0x53, 0x86, 0x75,
	0xd1, 0xcd, 0x09, 0xb5, 0xbb, 0xa7, 0x8d, 0xac, 0x48, 0x54, 0x3e, 0xf1,
	0x18, 0xa1, 0x17, 0x3b, 0x3f, 0xbf, 0x8b, 0x20, 0xe3, 0x9c, 0xe0, 0xe6,
	0xb8, 0x90, 0xa1, 0x63, 0xc5, 0x0f, 0x96, 0x45, 0xb3, 0xd2, 0x1d, 0x1c,
	0xbb, 0x3b, 0x60, 0xa6, 0xff, 0xf4
};
static const uint8_t nist_kas_ecc_cdh_testvector_108_public_y[] = {
/* QCAVSy */
	0x00, 0x83, 0x49, 0x4b, 0x2e, 0xba, 0x76, 0x91, 0x0f, 0xed, 0x33, 0xc7,
	0x61, 0x80, 0x45, 0x15, 0x01, 0x1f, 0xab, 0x50, 0xe3, 0xb3, 0x77, 0xab,
	0xd8, 0xa8, 0xa0, 0x45, 0xd8, 0x86, 0xd2, 0x23, 0x8d, 0x2c, 0x26, 0x8a,
	0xc1, 0xb6, 0xec, 0x88, 0xbd, 0x71, 0xb7, 0xba, 0x78, 0xe2, 0xc3, 0x3c,
	0x15, 0x2e, 0x4b, 0xf7, 0xda, 0x5d, 0x56, 0x5e, 0x4a, 0xcb, 0xec, 0xf5,
	0xe9, 0x2c, 0x7a, 0xd6, 0x62, 0xbb
};
static const uint8_t nist_kas_ecc_cdh_testvector_108_private[] = {
/* dIUT */
	0x00, 0xc2, 0x9a, 0xa2, 0x23, 0xea, 0x8d, 0x64, 0xb4, 0xa1, 0xed, 0xa2,
	0x7f, 0x39, 0xd3, 0xbc, 0x98, 0xea, 0x01, 0x48, 0xdd, 0x98, 0xc1, 0xcb,
	0xe5, 0x95, 0xf8, 0xfd, 0x2b, 0xfb, 0xde, 0x11, 0x9c, 0x9e, 0x01, 0x7a,
	0x50, 0xf5, 0xd1, 0xfc, 0x12, 0x1c, 0x08, 0xc1, 0xce, 0xf3, 0x1b, 0x75,
	0x88, 0x59, 0x55, 0x6e, 0xb3, 0xe0, 0xe0, 0x42, 0xd8, 0xdd, 0x6a, 0xaa,
	0xc5, 0x7a, 0x05, 0xca, 0x61, 0xe3
};
/* QIUTx = 0000001511c848ef60d5419a98d10204db0fe58224124370061bcfa4e9249d50618c56bf3722471b259f38263bb7b280d23caf2a1ee8737f9371cdb2732cdc958369930c */
/* QIUTy = 000001d461681ae6d8c49b4c5f4d6016143fb1bd7491573e3ed0e6c48b82e821644f87f82f0e5f08fd16f1f98fa17586200ab02ed8c627b35c3f27617ec5fd92f456203f */
static const uint8_t nist_kas_ecc_cdh_testvector_108_out[] = {
/* ZIUT */
	0x01, 0x8f, 0x2a, 0xe9, 0x47, 0x6c, 0x77, 0x17, 0x26, 0xa7, 0x77, 0x80,
	0x20, 0x8d, 0xed, 0xfe, 0xfa, 0x20, 0x54, 0x88, 0x99, 0x6b, 0x18, 0xfe,
	0xcc, 0x50, 0xbf, 0xd4, 0xc1, 0x32, 0x75, 0x3f, 0x57, 0x66, 0xb2, 0xcd,
	0x74, 0x4a, 0xfa, 0x99, 0x18, 0x60, 0x6d, 0xe2, 0xe0, 0x16, 0xef, 0xfc,
	0x63, 0x62, 0x2e, 0x90, 0x29, 0xe7, 0x6d, 0xc6, 0xe3, 0xf0, 0xc6, 0x9f,
	0x7a, 0xec, 0xed, 0x56, 0x5c, 0x2c
};
/* COUNT = 8 */
static const uint8_t nist_kas_ecc_cdh_testvector_109_public_x[] = {
/* QCAVSx */
	0x00, 0x84, 0x15, 0xf5, 0xbb, 0xd0, 0xee, 0xe3, 0x87, 0xd6, 0xc0, 0x9d,
	0x0e, 0xf8, 0xac, 0xaf, 0x29, 0xc6, 0x6d, 0xb4, 0x5d, 0x6b, 0xa1, 0x01,
	0x86, 0x0a, 0xe4, 0x5d, 0x3c, 0x60, 0xe1, 0xe0, 0xe3, 0xf7, 0x24, 0x7a,
	0x46, 0x26, 0xa6, 0x0f, 0xdd, 0x40, 0x49, 0x65, 0xc3, 0x56, 0x6c, 0x79,
	0xf6, 0x44, 0x9e, 0x85, 0x6c, 0xe0, 0xbf, 0x94, 0x61, 0x9f, 0x97, 0xda,
	0x8d, 0xa2, 0x4b, 0xd2, 0xcf, 0xb6
};
static const uint8_t nist_kas_ecc_cdh_testvector_109_public_y[] = {
/* QCAVSy */
	0x00, 0xfd, 0xd7, 0xc5, 0x9c, 0x58, 0xc3, 0x61, 0xbc, 0x50, 0xa7, 0xa5,
	0xd0, 0xd3, 0x6f, 0x72, 0x3b, 0x17, 0xc4, 0xf2, 0xad, 0x2b, 0x03, 0xc2,
	0x4d, 0x42, 0xdc, 0x50, 0xf7, 0x4a, 0x8c, 0x46, 0x5a, 0x0a, 0xfc, 0x46,
	0x83, 0xf1, 0x0f, 0xab, 0x84, 0x65, 0x2d, 0xfe, 0x9e, 0x92, 0x8c, 0x26,
	0x26, 0xb5, 0x45, 0x64, 0x53, 0xe1, 0x57, 0x3f, 0xf6, 0x0b, 0xe1, 0x50,
	0x74, 0x67, 0xd4, 0x31, 0xfb, 0xb2
};
static const uint8_t nist_kas_ecc_cdh_testvector_109_private[] = {
/* dIUT */
	0x00, 0x28, 0x69, 0x2b, 0xe2, 0xbf, 0x5c, 0x4b, 0x48, 0x93, 0x98, 0x46,
	0xfb, 0x3d, 0x5b, 0xce, 0x74, 0x65, 0x4b, 0xb2, 0x64, 0x6e, 0x15, 0xf8,
	0x38, 0x9e, 0x23, 0x70, 0x8a, 0x1a, 0xfa, 0xdf, 0x56, 0x15, 0x11, 0xea,
	0x0d, 0x99, 0x57, 0xd0, 0xb5, 0x34, 0x53, 0x81, 0x9d, 0x60, 0xfb, 0xa8,
	0xf6, 0x5a, 0x18, 0xf7, 0xb2, 0x9d, 0xf0, 0x21, 0xb1, 0xbb, 0x01, 0xcd,
	0x16, 0x32, 0x93, 0xac, 0xc3, 0xcc
};
/* QIUTx = 000001cfdc10c799f5c79cb6930a65fba351748e07567993e5e410ef4cacc4cd8a25784991eb4674e41050f930c7190ac812b9245f48a7973b658daf408822fe5b85f668 */
/* QIUTy = 00000180d9ddfc9af77b9c4a6f02a834db15e535e0b3845b2cce30388301b51cecbe3276307ef439b5c9e6a72dc2d94d879bc395052dbb4a5787d06efb280210fb8be037 */
static const uint8_t nist_kas_ecc_cdh_testvector_109_out[] = {
/* ZIUT */
	0x01, 0x05, 0xa3, 0x46, 0x98, 0x8b, 0x92, 0xed, 0x8c, 0x7a, 0x25, 0xce,
	0x4d, 0x79, 0xd2, 0x1b, 0xc8, 0x6c, 0xfc, 0xc7, 0xf9, 0x9c, 0x6c, 0xd1,
	0x9d, 0xbb, 0x4a, 0x39, 0xf4, 0x8a, 0xb9, 0x43, 0xb7, 0x9e, 0x4f, 0x06,
	0x47, 0x34, 0x8d, 0xa0, 0xb8, 0x0b, 0xd8, 0x64, 0xb8, 0x5c, 0x6b, 0x8d,
	0x92, 0x53, 0x6d, 0x6a, 0xa5, 0x44, 0xdc, 0x75, 0x37, 0xa0, 0x0c, 0x85,
	0x8f, 0x8b, 0x66, 0x31, 0x9e, 0x25
};
/* COUNT = 9 */
static const uint8_t nist_kas_ecc_cdh_testvector_110_public_x[] = {
/* QCAVSx */
	0x01, 0xc7, 0x21, 0xee, 0xa8, 0x05, 0xa5, 0xcb, 0xa2, 0x9f, 0x34, 0xba,
	0x57, 0x58, 0x77, 0x5b, 0xe0, 0xcf, 0x61, 0x60, 0xe6, 0xc0, 0x87, 0x23,
	0xf5, 0xab, 0x17, 0xbf, 0x96, 0xa1, 0xff, 0x2b, 0xd9, 0x42, 0x79, 0x61,
	0xa4, 0xf3, 0x4b, 0x07, 0xfc, 0x0b, 0x14, 0xca, 0x4b, 0x2b, 0xf6, 0x84,
	0x5d, 0xeb, 0xd5, 0xa8, 0x69, 0xf1, 0x24, 0xeb, 0xfa, 0x7a, 0xa7, 0x2f,
	0xe5, 0x65, 0x05, 0x0b, 0x7f, 0x18
};
static const uint8_t nist_kas_ecc_cdh_testvector_110_public_y[] = {
/* QCAVSy */
	0x00, 0xb6, 0xe8, 0x9e, 0xb0, 0xe1, 0xdc, 0xf1, 0x81, 0x23, 0x6f, 0x7c,
	0x54, 0x8f, 0xd1, 0xa8, 0xc1, 0x6b, 0x25, 0x8b, 0x52, 0xc1, 0xa9, 0xbf,
	0xd3, 0xfe, 0x8f, 0x22, 0x84, 0x1b, 0x26, 0x76, 0x32, 0x65, 0xf0, 0x74,
	0xc4, 0xcc, 0xf2, 0xd6, 0x34, 0xae, 0x97, 0xb7, 0x01, 0x95, 0x6f, 0x67,
	0xa1, 0x10, 0x06, 0xc5, 0x2d, 0x97, 0x19, 0x7d, 0x92, 0xf5, 0x85, 0xf5,
	0x74, 0x8b, 0xc2, 0x67, 0x2e, 0xeb
};
static const uint8_t nist_kas_ecc_cdh_testvector_110_private[] = {
/* dIUT */
	0x01, 0x19, 0x4d, 0x1e, 0xe6, 0x13, 0xf5, 0x36, 0x6c, 0xbc, 0x44, 0xb5,
	0x04, 0xd2, 0x1a, 0x0c, 0xf6, 0x71, 0x5e, 0x20, 0x9c, 0xd3, 0x58, 0xf2,
	0xdd, 0x5f, 0x3e, 0x71, 0xcc, 0x0d, 0x67, 0xd0, 0xe9, 0x64, 0x16, 0x8c,
	0x42, 0xa0, 0x84, 0xeb, 0xda, 0x74, 0x6f, 0x98, 0x63, 0xa8, 0x6b, 0xac,
	0xff, 0xc8, 0x19, 0xf1, 0xed, 0xf1, 0xb8, 0xc7, 0x27, 0xcc, 0xfb, 0x30,
	0x47, 0x24, 0x0a, 0x57, 0xc4, 0x35
};
/* QIUTx = 0000016bd15c8a58d366f7f2b2f298cc87b7485e9ee70d11d12448b8377c0a82c7626f67aff7f97be7a3546bf417eeeddf75a93c130191c84108042ea2fca17fd3f80d14 */
/* QIUTy = 000001560502d04b74fce1743aab477a9d1eac93e5226981fdb97a7478ce4ce566ff7243931284fad850b0c2bcae0ddd2d97790160c1a2e77c3ed6c95ecc44b89e2637fc */
static const uint8_t nist_kas_ecc_cdh_testvector_110_out[] = {
/* ZIUT */
	0x00, 0x45, 0x31, 0xb3, 0xd2, 0xc6, 0xcd, 0x12, 0xf2, 0x16, 0x04, 0xc8,
	0x61, 0x0e, 0x67, 0x23, 0xdb, 0xf4, 0xda, 0xf8, 0x0b, 0x5a, 0x45, 0x9d,
	0x6b, 0xa5, 0x81, 0x43, 0x97, 0xd1, 0xc1, 0xf7, 0xa2, 0x1d, 0x7c, 0x11,
	0x4b, 0xe9, 0x64, 0xe2, 0x73, 0x76, 0xaa, 0xeb, 0xe3, 0xa7, 0xbc, 0x3d,
	0x6a, 0xf7, 0xa7, 0xf8, 0xc7, 0xbe, 0xfb, 0x61, 0x1a, 0xfe, 0x48, 0x7f,
	0xf0, 0x32, 0x92, 0x1f, 0x75, 0x0f
};
/* COUNT = 10 */
static const uint8_t nist_kas_ecc_cdh_testvector_111_public_x[] = {
/* QCAVSx */
	0x01, 0xc3, 0x58, 0x23, 0xe4, 0x40, 0xa9, 0x36, 0x3a, 0xb9, 0x8d, 0x9f,
	0xc7, 0xa7, 0xbc, 0x0c, 0x05, 0x32, 0xdc, 0x79, 0x77, 0xa7, 0x91, 0x65,
	0x59, 0x9b, 0xf1, 0xa9, 0xcc, 0x64, 0xc0, 0x0f, 0xb3, 0x87, 0xb4, 0x2c,
	0xca, 0x36, 0x52, 0x86, 0xe8, 0x43, 0x03, 0x60, 0xbf, 0xad, 0x36, 0x43,
	0xbc, 0x31, 0x35, 0x4e, 0xda, 0x50, 0xdc, 0x93, 0x6c, 0x32, 0x9e, 0xcd,
	0xb6, 0x09, 0x05, 0xc4, 0x0f, 0xcb
};
static const uint8_t nist_kas_ecc_cdh_testvector_111_public_y[] = {
/* QCAVSy */
	0x00, 0xd9, 0xe7, 0xf4, 0x33, 0x53, 0x1e, 0x44, 0xdf, 0x4f, 0x6d, 0x51,
	0x42, 0x01, 0xcb, 0xaa, 0xbb, 0x06, 0xba, 0xdd, 0x67, 0x83, 0xe0, 0x11,
	0x11, 0x72, 0x6d, 0x81, 0x55, 0x31, 0xd2, 0x33, 0xc5, 0xcd, 0xb7, 0x22,
	0x89, 0x3f, 0xfb, 0xb2, 0x02, 0x72, 0x59, 0xd5, 0x94, 0xde, 0x77, 0x43,
	0x88, 0x09, 0x73, 0x81, 0x20, 0xc6, 0xf7, 0x83, 0x93, 0x4f, 0x92, 0x6c,
	0x3f, 0xb6, 0x9b, 0x40, 0xc4, 0x09
};
static const uint8_t nist_kas_ecc_cdh_testvector_111_private[] = {
/* dIUT */
	0x01, 0xfd, 0x90, 0xe3, 0xe4, 0x16, 0xe9, 0x8a, 0xa3, 0xf2, 0xb6, 0xaf,
	0xa7, 0xf3, 0xbf, 0x36, 0x8e, 0x45, 0x1a, 0xd9, 0xca, 0x5b, 0xd5, 0x4b,
	0x5b, 0x14, 0xae, 0xe2, 0xed, 0x67, 0x23, 0xdd, 0xe5, 0x18, 0x1f, 0x50,
	0x85, 0xb6, 0x81, 0x69, 0xb0, 0x9f, 0xbe, 0xc7, 0x21, 0x37, 0x2c, 0xcf,
	0x6b, 0x28, 0x47, 0x13, 0xf9, 0xa6, 0x35, 0x6b, 0x8d, 0x56, 0x0a, 0x8f,
	0xf7, 0x8c, 0xa3, 0x73, 0x7c, 0x88
};
/* QIUTx = 000001ebea1b10d3e3b971b7efb69fc878de11c7f472e4e4d384c31b8d6288d8071517acade9b39796c7af5163bcf71aeda777533f382c6cf0a4d9bbb938c85f44b78037 */
/* QIUTy = 0000016b0e3e19c2996b2cbd1ff64730e7ca90edca1984f9b2951333535e5748baa34a99f61ff4d5f812079e0f01e87789f34efdad8098015ee74a4f846dd190d16dc6e1 */
static const uint8_t nist_kas_ecc_cdh_testvector_111_out[] = {
/* ZIUT */
	0x01, 0x00, 0xc8, 0x93, 0x59, 0x69, 0x07, 0x7b, 0xae, 0x0b, 0xa8, 0x9e,
	0xf0, 0xdf, 0x81, 0x61, 0xd9, 0x75, 0xec, 0x58, 0x70, 0xac, 0x81, 0x1a,
	0xe7, 0xe6, 0x5c, 0xa5, 0x39, 0x4e, 0xfb, 0xa4, 0xf0, 0x63, 0x3d, 0x41,
	0xbf, 0x79, 0xea, 0x5e, 0x5b, 0x94, 0x96, 0xbb, 0xd7, 0xaa, 0xe0, 0x00,
	0xb0, 0x59, 0x4b, 0xaa, 0x82, 0xef, 0x8f, 0x24, 0x4e, 0x69, 0x84, 0xae,
	0x87, 0xae, 0x1e, 0xd1, 0x24, 0xb7
};
/* COUNT = 11 */
static const uint8_t nist_kas_ecc_cdh_testvector_112_public_x[] = {
/* QCAVSx */
	0x00, 0x09, 0x30, 0x57, 0xfb, 0x86, 0x2f, 0x2a, 0xd2, 0xe8, 0x2e, 0x58,
	0x1b, 0xae, 0xb3, 0x32, 0x4e, 0x7b, 0x32, 0x94, 0x6f, 0x2b, 0xa8, 0x45,
	0xa9, 0xbe, 0xee, 0xd8, 0x7d, 0x69, 0x95, 0xf5, 0x49, 0x18, 0xec, 0x66,
	0x19, 0xb9, 0x93, 0x19, 0x55, 0xd5, 0xa8, 0x9d, 0x4d, 0x74, 0xad, 0xf1,
	0x04, 0x6b, 0xb3, 0x62, 0x19, 0x2f, 0x2e, 0xf6, 0xbd, 0x3e, 0x3d, 0x2d,
	0x04, 0xdd, 0x1f, 0x87, 0x05, 0x4a
};
static const uint8_t nist_kas_ecc_cdh_testvector_112_public_y[] = {
/* QCAVSy */
	0x00, 0xaa, 0x3f, 0xb2, 0x44, 0x83, 0x35, 0xf6, 0x94, 0xe3, 0xcd, 0xa4,
	0xae, 0x0c, 0xc7, 0x1b, 0x1b, 0x2f, 0x2a, 0x20, 0x6f, 0xa8, 0x02, 0xd7,
	0x26, 0x2f, 0x19, 0x98, 0x3c, 0x44, 0x67, 0x4f, 0xe1, 0x53, 0x27, 0xac,
	0xaa, 0xc1, 0xfa, 0x40, 0x42, 0x4c, 0x39, 0x5a, 0x65, 0x56, 0xcb, 0x81,
	0x67, 0x31, 0x25, 0x27, 0xfa, 0xe5, 0x86, 0x5e, 0xcf, 0xfc, 0x14, 0xbb,
	0xdc, 0x17, 0xda, 0x78, 0xcd, 0xcf
};
static const uint8_t nist_kas_ecc_cdh_testvector_112_private[] = {
/* dIUT */
	0x00, 0x90, 0x12, 0xec, 0xfd, 0xad, 0xc8, 0x5c, 0xed, 0x63, 0x0a, 0xfe,
	0xa5, 0x34, 0xcd, 0xc8, 0xe9, 0xd1, 0xab, 0x8b, 0xe5, 0xf3, 0x75, 0x3d,
	0xcf, 0x5f, 0x2b, 0x09, 0xb4, 0x0e, 0xda, 0x66, 0xfc, 0x68, 0x58, 0x54,
	0x9b, 0xc3, 0x6e, 0x6f, 0x8d, 0xf5, 0x59, 0x98, 0xcf, 0xa9, 0xa0, 0x70,
	0x3a, 0xec, 0xf6, 0xc4, 0x27, 0x99, 0xc2, 0x45, 0x01, 0x10, 0x64, 0xf5,
	0x30, 0xc0, 0x9d, 0xb9, 0x83, 0x69
};
/* QIUTx = 000000234e32be0a907131d2d128a6477e0caceb86f02479745e0fe245cb332de631c078871160482eeef584e274df7fa412cea3e1e91f71ecba8781d9205d48386341ad */
/* QIUTy = 000001cf86455b09b1c005cffba8d76289a3759628c874beea462f51f30bd581e3803134307dedbb771b3334ee15be2e242cd79c3407d2f58935456c6941dd9b6d155a46 */
static const uint8_t nist_kas_ecc_cdh_testvector_112_out[] = {
/* ZIUT */
	0x01, 0x7f, 0x36, 0xaf, 0x19, 0x30, 0x38, 0x41, 0xd1, 0x3a, 0x38, 0x9d,
	0x95, 0xec, 0x0b, 0x80, 0x1c, 0x7f, 0x9a, 0x67, 0x9a, 0x82, 0x31, 0x46,
	0xc7, 0x5c, 0x17, 0xbc, 0x44, 0x25, 0x6e, 0x9a, 0xd4, 0x22, 0xa4, 0xf8,
	0xb3, 0x1f, 0x14, 0x64, 0x7b, 0x2c, 0x7d, 0x31, 0x7b, 0x93, 0x3f, 0x7c,
	0x29, 0x46, 0xc4, 0xb8, 0xab, 0xd1, 0xd5, 0x6d, 0x62, 0x0f, 0xab, 0x1b,
	0x5f, 0xf1, 0xa3, 0xad, 0xc7, 0x1f
};
/* COUNT = 12 */
static const uint8_t nist_kas_ecc_cdh_testvector_113_public_x[] = {
/* QCAVSx */
	0x00, 0x83, 0x19, 0x2e, 0xd0, 0xb1, 0xcb, 0x31, 0xf7, 0x58, 0x17, 0x79,
	0x49, 0x37, 0xf6, 0x6a, 0xd9, 0x1c, 0xf7, 0x45, 0x52, 0xcd, 0x51, 0x0c,
	0xed, 0xb9, 0xfd, 0x64, 0x13, 0x10, 0x42, 0x2a, 0xf5, 0xd0, 0x9f, 0x22,
	0x1c, 0xad, 0x24, 0x9e, 0xe8, 0x14, 0xd1, 0x6d, 0xd7, 0xac, 0x84, 0xde,
	0xd9, 0xea, 0xcd, 0xc2, 0x83, 0x40, 0xfc, 0xfc, 0x9c, 0x0c, 0x06, 0xab,
	0xe3, 0x0a, 0x2f, 0xc2, 0x8c, 0xd8
};
static const uint8_t nist_kas_ecc_cdh_testvector_113_public_y[] = {
/* QCAVSy */
	0x00, 0x22, 0x12, 0xed, 0x86, 0x8c, 0x9b, 0xa0, 0xfb, 0x2c, 0x91, 0xe2,
	0xc3, 0x9b, 0xa9, 0x39, 0x96, 0xa3, 0xe4, 0xeb, 0xf4, 0x5f, 0x28, 0x52,
	0xd0, 0x92, 0x8c, 0x48, 0x93, 0x0e, 0x87, 0x5c, 0xc7, 0xb4, 0x28, 0xd0,
	0xe7, 0xf3, 0xf4, 0xd5, 0x03, 0xe5, 0xd6, 0x0c, 0x68, 0xcb, 0x49, 0xb1,
	0x3c, 0x24, 0x80, 0xcd, 0x48, 0x6b, 0xed, 0x92, 0x00, 0xca, 0xdd, 0xad,
	0xdf, 0xe4, 0xff, 0x8e, 0x35, 0x62
};
static const uint8_t nist_kas_ecc_cdh_testvector_113_private[] = {
/* dIUT */
	0x01, 0xb5, 0xff, 0x84, 0x7f, 0x8e, 0xff, 0x20, 0xb8, 0x8c, 0xfa, 0xd4,
	0x2c, 0x06, 0xe5, 0x8c, 0x37, 0x42, 0xf2, 0xf8, 0xf1, 0xfd, 0xfd, 0x64,
	0xb5, 0x39, 0xba, 0x48, 0xc2, 0x59, 0x26, 0x92, 0x6b, 0xd5, 0xe3, 0x32,
	0xb4, 0x56, 0x49, 0xc0, 0xb1, 0x84, 0xf7, 0x72, 0x55, 0xe9, 0xd5, 0x8f,
	0xe8, 0xaf, 0xa1, 0xa6, 0xd9, 0x68, 0xe2, 0xcb, 0x1d, 0x46, 0x37, 0x77,
	0x71, 0x20, 0xc7, 0x65, 0xc1, 0x28
};
/* QIUTx = 000001de3dc9263bc8c4969dc684be0eec54befd9a9f3dba194d8658a789341bf0d78d84da6735227cafaf09351951691197573c8c360a11e5285712b8bbdf5ac91b977c */
/* QIUTy = 000000812de58cd095ec2e5a9b247eb3ed41d8bef6aeace194a7a05b65aa5d289fbc9b1770ec84bb6be0c2c64cc37c1d54a7f5d71377a9adbe20f26f6f2b544a821ea831 */
static const uint8_t nist_kas_ecc_cdh_testvector_113_out[] = {
/* ZIUT */
	0x00, 0x06, 0x2f, 0x9f, 0xc2, 0x9a, 0xe1, 0xa6, 0x8b, 0x2e, 0xe0, 0xdc,
	0xf9, 0x56, 0xcb, 0xd3, 0x8c, 0x88, 0xae, 0x5f, 0x64, 0x5e, 0xaa, 0x54,
	0x6b, 0x00, 0xeb, 0xe8, 0x7a, 0x72, 0x60, 0xbf, 0x72, 0x4b, 0xe2, 0x0d,
	0x34, 0xb9, 0xd0, 0x20, 0x76, 0x65, 0x5c, 0x93, 0x3d, 0x05, 0x6b, 0x21,
	0xe3, 0x04, 0xc2, 0x4d, 0xdb, 0x1d, 0xed, 0xf1, 0xdd, 0x76, 0xde, 0x61,
	0x1f, 0xc4, 0xa2, 0x34, 0x03, 0x36
};
/* COUNT = 13 */
static const uint8_t nist_kas_ecc_cdh_testvector_114_public_x[] = {
/* QCAVSx */
	0x01, 0xa8, 0x9b, 0x63, 0x6a, 0x93, 0xe5, 0xd2, 0xba, 0x6c, 0x22, 0x92,
	0xbf, 0x23, 0x03, 0x3a, 0x84, 0xf0, 0x6a, 0x3a, 0xc1, 0x22, 0x0e, 0xa7,
	0x1e, 0x80, 0x6a, 0xfb, 0xe0, 0x97, 0xa8, 0x04, 0xcc, 0x67, 0xe9, 0xba,
	0xa5, 0x14, 0xcf, 0xb6, 0xc1, 0x2c, 0x91, 0x94, 0xbe, 0x30, 0x21, 0x2b,
	0xf7, 0xaa, 0xe7, 0xfd, 0xf6, 0xd3, 0x76, 0xc2, 0x12, 0xf0, 0x55, 0x4e,
	0x65, 0x64, 0x63, 0xff, 0xab, 0x7e
};
static const uint8_t nist_kas_ecc_cdh_testvector_114_public_y[] = {
/* QCAVSy */
	0x01, 0x82, 0xef, 0xca, 0xf7, 0x0f, 0xc4, 0x12, 0xd3, 0x36, 0x60, 0x2e,
	0x01, 0x4d, 0xa4, 0x72, 0x56, 0xa0, 0xb6, 0x06, 0xf2, 0xad, 0xdc, 0xce,
	0x80, 0x53, 0xbf, 0x81, 0x7a, 0xc8, 0x65, 0x6b, 0xb4, 0xe4, 0x2f, 0x14,
	0xc8, 0xcb, 0xf2, 0xa6, 0x8f, 0x48, 0x8a, 0xb3, 0x5d, 0xcd, 0xf6, 0x40,
	0x56, 0x27, 0x1d, 0xee, 0x1f, 0x60, 0x6a, 0x44, 0x0b, 0xa4, 0xbd, 0x4e,
	0x5a, 0x11, 0xb8, 0xb8, 0xe5, 0x4f
};
static const uint8_t nist_kas_ecc_cdh_testvector_114_private[] = {
/* dIUT */
	0x01, 0x1a, 0x63, 0x47, 0xd4, 0xe8, 0x01, 0xc9, 0x19, 0x23, 0x48, 0x83,
	0x54, 0xcc, 0x53, 0x3e, 0x7e, 0x35, 0xfd, 0xdf, 0x81, 0xff, 0x0f, 0xb7,
	0xf5, 0x6b, 0xb0, 0x72, 0x6e, 0x0c, 0x29, 0xee, 0x5d, 0xcd, 0xc5, 0xf3,
	0x94, 0xba, 0x54, 0xcf, 0x57, 0x26, 0x90, 0x48, 0xaa, 0xb6, 0xe0, 0x55,
	0x89, 0x5c, 0x8d, 0xa2, 0x4b, 0x8b, 0x06, 0x39, 0xa7, 0x42, 0x31, 0x43,
	0x90, 0xcc, 0x04, 0x19, 0x0e, 0xd6
};
/* QIUTx = 000000fe30267f33ba5cdefc25cbb3c9320dad9ccb1d7d376644620ca4fadee5626a3cede25ad254624def727a7048f7145f76162aa98042f9b123b2076f8e8cf59b3fdf */
/* QIUTy = 0000001145dc6631953b6e2945e94301d6cbb098fe4b04f7ee9b09411df104dc82d7d79ec46a01ed0f2d3e7db6eb680694bdeb107c1078aec6cabd9ebee3d342fe7e54df */
static const uint8_t nist_kas_ecc_cdh_testvector_114_out[] = {
/* ZIUT */
	0x01, 0x28, 0xab, 0x09, 0xbf, 0xec, 0x54, 0x06, 0x79, 0x9e, 0x61, 0x0f,
	0x77, 0x2b, 0xa1, 0x7e, 0x89, 0x22, 0x49, 0xfa, 0x8e, 0x0e, 0x7b, 0x18,
	0xa0, 0x4b, 0x91, 0x97, 0x03, 0x4b, 0x25, 0x0b, 0x48, 0x29, 0x4f, 0x18,
	0x67, 0xfb, 0x96, 0x41, 0x51, 0x8f, 0x92, 0x76, 0x60, 0x66, 0xa0, 0x7a,
	0x8b, 0x91, 0x7b, 0x0e, 0x76, 0x87, 0x9e, 0x10, 0x11, 0xe5, 0x1c, 0xcb,
	0xd9, 0xf5, 0x40, 0xc5, 0x4d, 0x4f
};
/* COUNT = 14 */
static const uint8_t nist_kas_ecc_cdh_testvector_115_public_x[] = {
/* QCAVSx */
	0x01, 0x72, 0x00, 0xb3, 0xf1, 0x6a, 0x68, 0xcb, 0xae, 0xd2, 0xbf, 0x78,
	0xba, 0x8c, 0xdd, 0xfb, 0x6c, 0xff, 0xac, 0x26, 0x2b, 0xba, 0x00, 0xfb,
	0xc2, 0x5f, 0x9d, 0xc7, 0x2a, 0x07, 0xce, 0x59, 0x37, 0x29, 0x04, 0x89,
	0x9f, 0x36, 0x4c, 0x44, 0xcb, 0x26, 0x4c, 0x09, 0x7b, 0x64, 0x7d, 0x44,
	0x12, 0xbe, 0xe3, 0xe5, 0x19, 0x89, 0x2d, 0x53, 0x4d, 0x91, 0x29, 0xf8,
	0xa2, 0x8f, 0x75, 0x00, 0xfe, 0xe7
};
static const uint8_t nist_kas_ecc_cdh_testvector_115_public_y[] = {
/* QCAVSy */
	0x00, 0xba, 0xba, 0x8d, 0x67, 0x2a, 0x4f, 0x4a, 0x3b, 0x63, 0xde, 0x48,
	0xb9, 0x6f, 0x56, 0xe1, 0x8d, 0xf5, 0xd6, 0x8f, 0x7d, 0x70, 0xd5, 0x10,
	0x98, 0x33, 0xf4, 0x37, 0x70, 0xd6, 0x73, 0x2e, 0x06, 0xb3, 0x9a, 0xd6,
	0x0d, 0x93, 0xe5, 0xb4, 0x3d, 0xb8, 0x78, 0x9f, 0x1e, 0xc0, 0xab, 0xa4,
	0x72, 0x86, 0xa3, 0x9e, 0xa5, 0x84, 0x23, 0x5a, 0xce, 0xa7, 0x57, 0xdb,
	0xf1, 0x3d, 0x53, 0xb5, 0x83, 0x64
};
static const uint8_t nist_kas_ecc_cdh_testvector_115_private[] = {
/* dIUT */
	0x00, 0x22, 0xb6, 0xd2, 0xa2, 0x2d, 0x71, 0xdf, 0xaa, 0x81, 0x1d, 0x2d,
	0x9f, 0x9f, 0x31, 0xfb, 0xed, 0x27, 0xf2, 0xe1, 0xf3, 0xd2, 0x39, 0x53,
	0x8d, 0xdf, 0x3e, 0x4c, 0xc8, 0xc3, 0x9a, 0x33, 0x02, 0x66, 0xdb, 0x25,
	0xb7, 0xbc, 0x0a, 0x97, 0x04, 0xf1, 0x7b, 0xde, 0x7f, 0x35, 0x92, 0xbf,
	0x5f, 0x1f, 0x2d, 0x4b, 0x56, 0x01, 0x3a, 0xac, 0xc3, 0xd8, 0xd1, 0xbc,
	0x02, 0xf0, 0x0d, 0x31, 0x46, 0xcc
};
/* QIUTx = 000000ba38cfbf9fd2518a3f61d43549e7a6a6d28b2be57ffd3e0faceb636b34ed17e044a9f249dae8fc132e937e2d9349cd2ed77bb1049ceb692a2ec5b17ad61502a64c */
/* QIUTy = 0000001ec91d3058573fa6c0564a02a1a010160c313bc7c73510dc983e5461682b5be00dbce7e2c682ad73f29ca822cdc111f68fabe33a7b384a648342c3cdb9f050bcdb */
static const uint8_t nist_kas_ecc_cdh_testvector_115_out[] = {
/* ZIUT */
	0x01, 0x01, 0xe4, 0x62, 0xe9, 0xd9, 0x15, 0x99, 0x68, 0xf6, 0x44, 0x0e,
	0x95, 0x6f, 0x11, 0xdc, 0xf2, 0x22, 0x7a, 0xe4, 0xae, 0xa8, 0x16, 0x67,
	0x12, 0x2b, 0x6a, 0xf9, 0x23, 0x9a, 0x29, 0x1e, 0xb5, 0xd6, 0xcf, 0x5a,
	0x40, 0x87, 0xf3, 0x58, 0x52, 0x5f, 0xca, 0xcf, 0xa4, 0x6b, 0xb2, 0xdb,
	0x01, 0xa7, 0x5a, 0xf1, 0xba, 0x51, 0x9b, 0x2d, 0x31, 0xda, 0x33, 0xed,
	0xa8, 0x7a, 0x9d, 0x56, 0x57, 0x48
};
/* COUNT = 15 */
static const uint8_t nist_kas_ecc_cdh_testvector_116_public_x[] = {
/* QCAVSx */
	0x00, 0x4e, 0xfd, 0x5d, 0xbd, 0x2f, 0x97, 0x9e, 0x38, 0x31, 0xce, 0x98,
	0xf8, 0x23, 0x55, 0xd6, 0xca, 0x14, 0xa5, 0x75, 0x78, 0x42, 0x87, 0x58,
	0x82, 0x99, 0x0a, 0xb8, 0x5a, 0xb9, 0xb7, 0x35, 0x2d, 0xd6, 0xb9, 0xb2,
	0xf4, 0xea, 0x9a, 0x1e, 0x95, 0xc3, 0x88, 0x0d, 0x65, 0xd1, 0xf3, 0x60,
	0x2f, 0x9c, 0xa6, 0x53, 0xdc, 0x34, 0x6f, 0xac, 0x85, 0x86, 0x58, 0xd7,
	0x56, 0x26, 0xf4, 0xd4, 0xfb, 0x08
};
static const uint8_t nist_kas_ecc_cdh_testvector_116_public_y[] = {
/* QCAVSy */
	0x00, 0x61, 0xcf, 0x15, 0xdb, 0xda, 0xa7, 0xf3, 0x15, 0x89, 0xc9, 0x84,
	0x00, 0x37, 0x3d, 0xa2, 0x84, 0x50, 0x6d, 0x70, 0xc8, 0x9f, 0x07, 0x4e,
	0xd2, 0x62, 0xa9, 0xe2, 0x81, 0x40, 0x79, 0x6b, 0x72, 0x36, 0xc2, 0xee,
	0xf9, 0x90, 0x16, 0x08, 0x5e, 0x71, 0x55, 0x2f, 0xf4, 0x88, 0xc7, 0x2b,
	0x73, 0x39, 0xfe, 0xfb, 0x79, 0x15, 0xc3, 0x84, 0x59, 0xcb, 0x20, 0xab,
	0x85, 0xae, 0xc4, 0xe4, 0x50, 0x52
};
static const uint8_t nist_kas_ecc_cdh_testvector_116_private[] = {
/* dIUT */
	0x00, 0x5b, 0xac, 0xff, 0xf2, 0x68, 0xac, 0xf6, 0x55, 0x3c, 0x3c, 0x58,
	0x3b, 0x46, 0x4e, 0xa3, 0x6a, 0x1d, 0x35, 0xe2, 0xb2, 0x57, 0xa5, 0xd4,
	0x9e, 0xb3, 0x41, 0x9d, 0x5a, 0x09, 0x50, 0x87, 0xc2, 0xfb, 0x4d, 0x15,
	0xcf, 0x5b, 0xf5, 0xaf, 0x81, 0x6d, 0x0f, 0x3f, 0xf7, 0x58, 0x64, 0x90,
	0xcc, 0xd3, 0xdd, 0xc1, 0xa9, 0x8b, 0x39, 0xce, 0x63, 0x74, 0x9c, 0x62,
	0x88, 0xce, 0x0d, 0xbd, 0xac, 0x7d
};
/* QIUTx = 00000036e488da7581472a9d8e628c58d6ad727311b7e6a3f6ae33a8544f34b09280249020be7196916fafd90e2ec54b66b5468d2361b99b56fa00d7ac37abb8c6f16653 */
/* QIUTy = 0000011edb9fb8adb6a43f4f5f5fdc1421c9fe04fc8ba46c9b66334e3af927c8befb4307104f299acec4e30f812d9345c9720d19869dbfffd4ca3e7d2713eb5fc3f42615 */
static const uint8_t nist_kas_ecc_cdh_testvector_116_out[] = {
/* ZIUT */
	0x01, 0x41, 0xd6, 0xa4, 0xb7, 0x19, 0xab, 0x67, 0xea, 0xf0, 0x4a, 0x92,
	0xc0, 0xa4, 0x1e, 0x2d, 0xda, 0x78, 0xf4, 0x35, 0x4f, 0xb9, 0x0b, 0xdc,
	0x35, 0x20, 0x2c, 0xc7, 0x69, 0x9b, 0x9b, 0x04, 0xd4, 0x96, 0x16, 0xf8,
	0x22, 0x55, 0xde, 0xbf, 0x7b, 0xbe, 0xc0, 0x45, 0xae, 0x58, 0xf9, 0x82,
	0xa6, 0x69, 0x05, 0xfc, 0xfa, 0xe6, 0x9d, 0x68, 0x97, 0x85, 0xe3, 0x8c,
	0x86, 0x8e, 0xb4, 0xa2, 0x7e, 0x7b
};
/* COUNT = 16 */
static const uint8_t nist_kas_ecc_cdh_testvector_117_public_x[] = {
/* QCAVSx */
	0x01, 0x29, 0x89, 0x1d, 0xe0, 0xcf, 0x3c, 0xf8, 0x2e, 0x8c, 0x2c, 0xf1,
	0xbf, 0x90, 0xbb, 0x29, 0x6f, 0xe0, 0x0a, 0xb0, 0x8c, 0xa4, 0x5b, 0xb7,
	0x89, 0x2e, 0x0e, 0x22, 0x7a, 0x50, 0x4f, 0xdd, 0x05, 0xd2, 0x38, 0x1a,
	0x44, 0x48, 0xb6, 0x8a, 0xdf, 0xf9, 0xc4, 0x15, 0x3c, 0x87, 0xea, 0xcb,
	0x78, 0x33, 0x0d, 0x8b, 0xd5, 0x25, 0x15, 0xf9, 0xf9, 0xa0, 0xb5, 0x8e,
	0x85, 0xf4, 0x46, 0xbb, 0x4e, 0x10
};
static const uint8_t nist_kas_ecc_cdh_testvector_117_public_y[] = {
/* QCAVSy */
	0x00, 0x9e, 0xdd, 0x67, 0x96, 0x96, 0xd3, 0xd1, 0xd0, 0xef, 0x32, 0x7f,
	0x20, 0x03, 0x83, 0x25, 0x3f, 0x64, 0x13, 0x68, 0x3d, 0x9e, 0x4f, 0xcc,
	0x87, 0xbb, 0x35, 0xf1, 0x12, 0xc2, 0xf1, 0x10, 0x09, 0x8d, 0x15, 0xe5,
	0x70, 0x1d, 0x7c, 0xee, 0xe4, 0x16, 0x29, 0x1f, 0xf5, 0xfe, 0xd8, 0x5e,
	0x68, 0x7f, 0x72, 0x73, 0x88, 0xb9, 0xaf, 0xe2, 0x6a, 0x4f, 0x6f, 0xee,
	0xd5, 0x60, 0xb2, 0x18, 0xe6, 0xbb
};
static const uint8_t nist_kas_ecc_cdh_testvector_117_private[] = {
/* dIUT */
	0x00, 0x8e, 0x2c, 0x93, 0xc5, 0x42, 0x38, 0x76, 0x22, 0x3a, 0x63, 0x7c,
	0xad, 0x36, 0x7c, 0x85, 0x89, 0xda, 0x69, 0xa2, 0xd0, 0xfc, 0x68, 0x61,
	0x2f, 0x31, 0x92, 0x3a, 0xe5, 0x02, 0x19, 0xdf, 0x24, 0x52, 0xe7, 0xcc,
	0x92, 0x61, 0x5b, 0x67, 0xf1, 0x7b, 0x57, 0xff, 0xd2, 0xf5, 0x2b, 0x19,
	0x15, 0x4b, 0xb4, 0x0d, 0x77, 0x15, 0x33, 0x64, 0x20, 0xfd, 0xe2, 0xe8,
	0x9f, 0xee, 0x24, 0x4f, 0x59, 0xdc
};
/* QIUTx = 000000fa3b35118d6c422570f724a26f90b2833b19239174cea081c53133f64db60d6940ea1261299c04c1f4587cdb0c4c39616479c1bb0c146799a118032dcf98f899c0 */
/* QIUTy = 00000069f040229006151fa32b51f679c8816f7c17506b403809dc77cd58a2aec430d94d13b6c916de99f355aa45fcfbc6853d686c71be496a067d24bfaea4818fc51f75 */
static const uint8_t nist_kas_ecc_cdh_testvector_117_out[] = {
/* ZIUT */
	0x00, 0x34, 0x5e, 0x26, 0xe0, 0xab, 0xb1, 0xaa, 0xc1, 0x2b, 0x75, 0xf3,
	0xa9, 0xcf, 0x41, 0xef, 0xe1, 0xc3, 0x36, 0x39, 0x6d, 0xff, 0xa4, 0xa0,
	0x67, 0xa4, 0xc2, 0xcf, 0xeb, 0x87, 0x8c, 0x68, 0xb2, 0xb0, 0x45, 0xfa,
	0xa4, 0xe5, 0xb4, 0xe6, 0xfa, 0x46, 0x78, 0xf5, 0xb6, 0x03, 0xc3, 0x51,
	0x90, 0x3b, 0x14, 0xbf, 0x9a, 0x6a, 0x70, 0xc4, 0x39, 0x25, 0x71, 0x99,
	0xa6, 0x40, 0x89, 0x0b, 0x61, 0xd1
};
/* COUNT = 17 */
static const uint8_t nist_kas_ecc_cdh_testvector_118_public_x[] = {
/* QCAVSx */
	0x01, 0xa3, 0xc2, 0x02, 0x40, 0xe5, 0x9f, 0x5b, 0x7a, 0x3e, 0x17, 0xc2,
	0x75, 0xd2, 0x31, 0x4b, 0xa1, 0x74, 0x12, 0x10, 0xad, 0x58, 0xb7, 0x10,
	0x36, 0xf8, 0xc8, 0x3c, 0xc1, 0xf6, 0xb0, 0xf4, 0x09, 0xdf, 0xdd, 0x91,
	0x13, 0xe9, 0x4b, 0x67, 0xec, 0x39, 0xc3, 0x29, 0x14, 0x26, 0xc2, 0x3f,
	0xfc, 0xc4, 0x47, 0x05, 0x46, 0x70, 0xd2, 0x90, 0x8f, 0xf8, 0xfe, 0x67,
	0xdc, 0x23, 0x06, 0x03, 0x4c, 0x5c
};
static const uint8_t nist_kas_ecc_cdh_testvector_118_public_y[] = {
/* QCAVSy */
	0x01, 0xd2, 0x82, 0x5b, 0xfd, 0x3a, 0xf8, 0xb1, 0xe1, 0x32, 0x05, 0x78,
	0x0c, 0x13, 0x7f, 0xe9, 0x38, 0xf8, 0x4f, 0xde, 0x40, 0x18, 0x8e, 0x61,
	0xea, 0x02, 0xce, 0xad, 0x81, 0xba, 0xdf, 0xdb, 0x42, 0x5c, 0x29, 0xf7,
	0xd7, 0xfb, 0x03, 0x24, 0xde, 0xba, 0xdc, 0x10, 0xbb, 0xb9, 0x3d, 0xe6,
	0x8f, 0x62, 0xc3, 0x50, 0x69, 0x26, 0x82, 0x83, 0xf5, 0x26, 0x58, 0x65,
	0xdb, 0x57, 0xa7, 0x9f, 0x7b, 0xf7
};
static const uint8_t nist_kas_ecc_cdh_testvector_118_private[] = {
/* dIUT */
	0x00, 0x04, 0xd4, 0x9d, 0x39, 0xd4, 0x0d, 0x81, 0x11, 0xbf, 0x16, 0xd2,
	0x8c, 0x59, 0x36, 0x55, 0x43, 0x26, 0xb1, 0x97, 0x35, 0x3e, 0xeb, 0xbc,
	0xf4, 0x75, 0x45, 0x39, 0x3b, 0xc8, 0xd3, 0xaa, 0xf9, 0x8f, 0x14, 0xf5,
	0xbe, 0x70, 0x74, 0xbf, 0xb3, 0x8e, 0x6c, 0xc9, 0x7b, 0x98, 0x97, 0x54,
	0x07, 0x4d, 0xad, 0xdb, 0x30, 0x45, 0xf4, 0xe4, 0xce, 0x74, 0x56, 0x69,
	0xfd, 0xb3, 0xec, 0x0d, 0x5f, 0xa8
};
/* QIUTx = 0000012ec226d050ce07c79b3df4d0f0891f9f7adf462e8c98dbc1a2a14f5e53a3f5ad894433587cc429a8be9ea1d84fa33b1803690dae04da7218d30026157fc995cf52 */
/* QIUTy = 0000004837dfbf3426f57b5c793269130abb9a38f618532211931154db4eeb9aede88e57290f842ea0f2ea9a5f74c6203a3920fe4e305f6118f676b154e1d75b9cb5eb88 */
static const uint8_t nist_kas_ecc_cdh_testvector_118_out[] = {
/* ZIUT */
	0x00, 0x6f, 0xe9, 0xde, 0x6f, 0xb8, 0xe6, 0x72, 0xe7, 0xfd, 0x15, 0x0f,
	0xdc, 0x5e, 0x61, 0x7f, 0xab, 0xb0, 0xd4, 0x39, 0x06, 0x35, 0x4c, 0xcf,
	0xd2, 0x24, 0x75, 0x7c, 0x72, 0x76, 0xf7, 0xa1, 0x01, 0x00, 0x91, 0xb1,
	0x7e, 0xd0, 0x72, 0x07, 0x4f, 0x8d, 0x10, 0xa5, 0xec, 0x97, 0x1e, 0xb3,
	0x5a, 0x5c, 0xb7, 0x07, 0x66, 0x03, 0xb7, 0xbc, 0x38, 0xd4, 0x32, 0xcb,
	0xc0, 0x59, 0xf8, 0x0f, 0x94, 0x88
};
/* COUNT = 18 */
static const uint8_t nist_kas_ecc_cdh_testvector_119_public_x[] = {
/* QCAVSx */
	0x00, 0x7e, 0x2d, 0x13, 0x8f, 0x28, 0x32, 0xe3, 0x45, 0xae, 0x8f, 0xf6,
	0x59, 0x57, 0xe4, 0x0e, 0x5e, 0xc7, 0x16, 0x3f, 0x01, 0x6b, 0xdf, 0x6d,
	0x24, 0xa2, 0x24, 0x3d, 0xaa, 0x63, 0x1d, 0x87, 0x8a, 0x4a, 0x16, 0x78,
	0x39, 0x90, 0xc7, 0x22, 0x38, 0x21, 0x30, 0xf9, 0xe5, 0x1f, 0x0c, 0x1b,
	0xd6, 0xff, 0x5a, 0xc9, 0x67, 0x80, 0xe4, 0x8b, 0x68, 0xf5, 0xde, 0xc9,
	0x5f, 0x42, 0xe6, 0x14, 0x4b, 0xb5
};
static const uint8_t nist_kas_ecc_cdh_testvector_119_public_y[] = {
/* QCAVSy */
	0x00, 0xb0, 0xde, 0x5c, 0x89, 0x67, 0x91, 0xf5, 0x28, 0x86, 0xb0, 0xf0,
	0x99, 0x13, 0xe2, 0x6e, 0x78, 0xdd, 0x0b, 0x69, 0x79, 0x8f, 0xc4, 0xdf,
	0x6d, 0x95, 0xe3, 0xca, 0x70, 0x8e, 0xcb, 0xcb, 0xcc, 0xe1, 0xc1, 0x89,
	0x5f, 0x55, 0x61, 0xbb, 0xab, 0xaa, 0xe3, 0x72, 0xe9, 0xe6, 0x7e, 0x6e,
	0x1a, 0x3b, 0xe6, 0x0e, 0x19, 0xb4, 0x70, 0xcd, 0xf6, 0x73, 0xec, 0x1f,
	0xc3, 0x93, 0xd3, 0x42, 0x6e, 0x20
};
static const uint8_t nist_kas_ecc_cdh_testvector_119_private[] = {
/* dIUT */
	0x01, 0x1a, 0x5d, 0x1c, 0xc7, 0x9c, 0xd2, 0xbf, 0x73, 0xea, 0x10, 0x6f,
	0x0e, 0x60, 0xa5, 0xac, 0xe2, 0x20, 0x81, 0x3b, 0x53, 0xe2, 0x7b, 0x73,
	0x98, 0x64, 0x33, 0x4a, 0x07, 0xc0, 0x33, 0x67, 0xef, 0xda, 0x7a, 0x46,
	0x19, 0xfa, 0x6e, 0xef, 0x3a, 0x97, 0x46, 0x49, 0x22, 0x83, 0xb3, 0xc4,
	0x45, 0x61, 0x0a, 0x02, 0x3a, 0x9c, 0xc4, 0x9b, 0xf4, 0x59, 0x11, 0x40,
	0x38, 0x4f, 0xca, 0x5c, 0x8b, 0xb5
};
/* QIUTx = 000000eb07c7332eedb7d3036059d35f7d2288d4377d5f42337ad3964079fb120ccd4c8bd384b585621055217023acd9a94fcb3b965bfb394675e788ade41a1de73e620c */
/* QIUTy = 000000491a835de2e6e7deb7e090f4a11f2c460c0b1f3d5e94ee8d751014dc720784fd3b54500c86ebaef18429f09e8e876d5d1538968a030d7715dde99f0d8f06e29d59 */
static const uint8_t nist_kas_ecc_cdh_testvector_119_out[] = {
/* ZIUT */
	0x01, 0xe4, 0xe7, 0x59, 0xec, 0xed, 0xce, 0x10, 0x13, 0xba, 0xf7, 0x3e,
	0x6f, 0xcc, 0x0b, 0x92, 0x45, 0x1d, 0x03, 0xbd, 0xd5, 0x04, 0x89, 0xb7,
	0x88, 0x71, 0xc3, 0x33, 0x11, 0x49, 0x90, 0xc9, 0xba, 0x6a, 0x9b, 0x2f,
	0xc7, 0xb1, 0xa2, 0xd9, 0xa1, 0x79, 0x4c, 0x1b, 0x60, 0xd9, 0x27, 0x9a,
	0xf6, 0xf1, 0x46, 0xf0, 0xbb, 0xfb, 0x06, 0x83, 0x14, 0x04, 0x03, 0xbf,
	0xa4, 0xcc, 0xdb, 0x52, 0x4a, 0x29
};
/* COUNT = 19 */
static const uint8_t nist_kas_ecc_cdh_testvector_120_public_x[] = {
/* QCAVSx */
	0x00, 0x11, 0x8c, 0x36, 0x02, 0x22, 0x09, 0xb1, 0xaf, 0x8e, 0xba, 0xd1,
	0xa1, 0x2b, 0x56, 0x6f, 0xc4, 0x87, 0x44, 0x57, 0x6e, 0x11, 0x99, 0xfe,
	0x80, 0xde, 0x1c, 0xdf, 0x85, 0x1c, 0xdf, 0x03, 0xe5, 0xb9, 0x09, 0x1a,
	0x8f, 0x7e, 0x07, 0x9e, 0x83, 0xb7, 0xf8, 0x27, 0x25, 0x9b, 0x69, 0x1d,
	0x0c, 0x22, 0xee, 0x29, 0xd6, 0xbd, 0xf7, 0x3e, 0xc7, 0xbb, 0xfd, 0x74,
	0x6f, 0x2c, 0xd9, 0x7a, 0x35, 0x7d
};
static const uint8_t nist_kas_ecc_cdh_testvector_120_public_y[] = {
/* QCAVSy */
	0x00, 0xda, 0x5f, 0xf4, 0x90, 0x45, 0x48, 0xa3, 0x42, 0xe2, 0xe7, 0xba,
	0x6a, 0x1f, 0x4e, 0xe5, 0xf8, 0x40, 0x41, 0x1a, 0x96, 0xcf, 0x63, 0xe6,
	0xfe, 0x62, 0x2f, 0x22, 0xc1, 0x3e, 0x61, 0x4e, 0x0a, 0x84, 0x7c, 0x11,
	0xa1, 0xab, 0x3f, 0x1d, 0x12, 0xcc, 0x85, 0x0c, 0x32, 0xe0, 0x95, 0x61,
	0x4c, 0xa8, 0xf7, 0xe2, 0x72, 0x14, 0x77, 0xb4, 0x86, 0xe9, 0xff, 0x40,
	0x37, 0x29, 0x77, 0xc3, 0xf6, 0x5c
};
static const uint8_t nist_kas_ecc_cdh_testvector_120_private[] = {
/* dIUT */
	0x01, 0x0c, 0x90, 0x8c, 0xaf, 0x1b, 0xe7, 0x4c, 0x61, 0x6b, 0x62, 0x5f,
	0xc8, 0xc1, 0xf5, 0x14, 0x44, 0x6a, 0x6a, 0xec, 0x83, 0xb5, 0x93, 0x71,
	0x41, 0xd6, 0xaf, 0xbb, 0x0a, 0x8c, 0x76, 0x66, 0xa7, 0x74, 0x6f, 0xa1,
	0xf7, 0xa6, 0x66, 0x4a, 0x21, 0x23, 0xe8, 0xcd, 0xf6, 0xcd, 0x8b, 0xf8,
	0x36, 0xc5, 0x6d, 0x3c, 0x0e, 0xbd, 0xcc, 0x98, 0x0e, 0x43, 0xa1, 0x86,
	0xf9, 0x38, 0xf3, 0xa7, 0x8a, 0xe7
};
/* QIUTx = 00000031890f4c7abec3f723362285d77d2636f876817db3bbc88b01e773597b969ff6f013ea470c854ab4a7739004eb8cbea69b82ddf36acadd406871798ecb2ac3aa7f */
/* QIUTy = 000000d8b429ae3250266b9643c0c765a60dc10155bc2531cf8627296f4978b6640a9e600e19d0037d58503fa80799546a814d7478a550aa90e5ebeb052527faaeae5d08 */
static const uint8_t nist_kas_ecc_cdh_testvector_120_out[] = {
/* ZIUT */
	0x01, 0x63, 0xc9, 0x19, 0x1d, 0x65, 0x10, 0x39, 0xa5, 0xfe, 0x98, 0x5a,
	0x0e, 0xea, 0x1e, 0xba, 0x01, 0x8a, 0x40, 0xab, 0x19, 0x37, 0xfc, 0xd2,
	0xb6, 0x12, 0x20, 0x82, 0x0e, 0xe8, 0xf2, 0x30, 0x2e, 0x97, 0x99, 0xf6,
	0xed, 0xfc, 0x3f, 0x51, 0x74, 0xf3, 0x69, 0xd6, 0x72, 0xd3, 0x77, 0xea,
	0x89, 0x54, 0xa8, 0xd0, 0xc8, 0xb8, 0x51, 0xe8, 0x1a, 0x56, 0xfd, 0xa9,
	0x52, 0x12, 0xa6, 0x57, 0x8f, 0x0e
};
/* COUNT = 20 */
static const uint8_t nist_kas_ecc_cdh_testvector_121_public_x[] = {
/* QCAVSx */
	0x01, 0x78, 0x0e, 0xdf, 0xf1, 0xca, 0x1c, 0x03, 0xcf, 0xbe, 0x59, 0x3e,
	0xdc, 0x6c, 0x04, 0x9b, 0xcb, 0x28, 0x60, 0x29, 0x4a, 0x92, 0xc3, 0x55,
	0x48, 0x9d, 0x9a, 0xfb, 0x2e, 0x70, 0x20, 0x75, 0xad, 0xe1, 0xc9, 0x53,
	0x89, 0x5a, 0x45, 0x62, 0x30, 0xa0, 0xcd, 0xe9, 0x05, 0xde, 0x4a, 0x3f,
	0x38, 0x57, 0x3d, 0xbf, 0xcc, 0xcd, 0x67, 0xad, 0x6e, 0x7e, 0x93, 0xf0,
	0xb5, 0x58, 0x1e, 0x92, 0x6a, 0x5d
};
static const uint8_t nist_kas_ecc_cdh_testvector_121_public_y[] = {
/* QCAVSy */
	0x00, 0xa5, 0x48, 0x19, 0x62, 0xc9, 0x16, 0x29, 0x62, 0xe7, 0xf0, 0xeb,
	0xde, 0xc9, 0x36, 0x93, 0x5d, 0x0e, 0xaa, 0x81, 0x3e, 0x82, 0x26, 0xd4,
	0x0d, 0x7f, 0x61, 0x19, 0xbf, 0xd9, 0x40, 0x60, 0x23, 0x80, 0xc8, 0x67,
	0x21, 0xe6, 0x1d, 0xb1, 0x83, 0x0f, 0x51, 0xe1, 0x39, 0xf2, 0x10, 0x00,
	0x0b, 0xce, 0xc0, 0xd8, 0xed, 0xd3, 0x9e, 0x54, 0xd7, 0x3a, 0x9a, 0x12,
	0x9f, 0x95, 0xcd, 0x5f, 0xa9, 0x79
};
static const uint8_t nist_kas_ecc_cdh_testvector_121_private[] = {
/* dIUT */
	0x01, 0xb3, 0x7d, 0x6b, 0x72, 0x88, 0xde, 0x67, 0x13, 0x60, 0x42, 0x5d,
	0x3e, 0x5a, 0xc1, 0xcc, 0xb2, 0x18, 0x15, 0x07, 0x9d, 0x8d, 0x73, 0x43,
	0x1e, 0x9b, 0x74, 0xa6, 0xf0, 0xe7, 0xae, 0x00, 0x4a, 0x35, 0x75, 0x75,
	0xb1, 0x1a, 0xd6, 0x66, 0x42, 0xce, 0x8b, 0x77, 0x55, 0x93, 0xeb, 0xa9,
	0xd9, 0x8b, 0xf2, 0x5c, 0x75, 0xef, 0x0b, 0x4d, 0x3a, 0x20, 0x98, 0xbb,
	0xc6, 0x41, 0xf5, 0x9a, 0x2b, 0x77
};
/* QIUTx = 000000189a5ee34de7e35aefeaeef9220c18071b4c29a4c3bd9d954458bd3e82a7a34da34cff5579b8101c065b1f2f527cf4581501e28ef5671873e65267733d003520af */
/* QIUTy = 000001eb4bc50a7b4d4599d7e3fa773ddb9eb252c9b3422872e544bdf75c7bf60f5166ddc11eb08fa7c30822dabaee373ab468eb2d922e484e2a527fff2ebb804b7d9a37 */
static const uint8_t nist_kas_ecc_cdh_testvector_121_out[] = {
/* ZIUT */
	0x01, 0x5d, 0x61, 0x3e, 0x26, 0x7a, 0x36, 0x34, 0x2e, 0x0d, 0x12, 0x5c,
	0xda, 0xd6, 0x43, 0xd8, 0x0d, 0x97, 0xed, 0x06, 0x00, 0xaf, 0xb9, 0xe6,
	0xb9, 0x54, 0x5c, 0x9e, 0x64, 0xa9, 0x8c, 0xc6, 0xda, 0x7c, 0x5a, 0xaa,
	0x3a, 0x8d, 0xa0, 0xbd, 0xd9, 0xdd, 0x3b, 0x97, 0xe9, 0x78, 0x82, 0x18,
	0xa8, 0x0a, 0xba, 0xfc, 0x10, 0x6e, 0xf0, 0x65, 0xc8, 0xf1, 0xc4, 0xe1,
	0x11, 0x9e, 0xf5, 0x8d, 0x29, 0x8b
};
/* COUNT = 21 */
static const uint8_t nist_kas_ecc_cdh_testvector_122_public_x[] = {
/* QCAVSx */
	0x01, 0x6d, 0xac, 0xff, 0xa1, 0x83, 0xe5, 0x30, 0x30, 0x83, 0xa3, 0x34,
	0xf7, 0x65, 0xde, 0x72, 0x4e, 0xc5, 0xec, 0x94, 0x02, 0x02, 0x6d, 0x47,
	0x97, 0x88, 0x4a, 0x98, 0x28, 0xa0, 0xd3, 0x21, 0xa8, 0xcf, 0xac, 0x74,
	0xab, 0x73, 0x7f, 0xe2, 0x0a, 0x7d, 0x6b, 0xef, 0xcf, 0xc7, 0x3b, 0x6a,
	0x35, 0xc1, 0xc7, 0xb0, 0x1d, 0x37, 0x3e, 0x31, 0xab, 0xc1, 0x92, 0xd4,
	0x8a, 0x42, 0x41, 0xa3, 0x58, 0x03
};
static const uint8_t nist_kas_ecc_cdh_testvector_122_public_y[] = {
/* QCAVSy */
	0x01, 0x1e, 0x53, 0x27, 0xca, 0xc2, 0x2d, 0x30, 0x5e, 0x71, 0x56, 0xe5,
	0x59, 0x17, 0x6e, 0x19, 0xbe, 0xe7, 0xe4, 0xf2, 0xf5, 0x9e, 0x86, 0xf1,
	0xa9, 0xd0, 0xb6, 0x60, 0x3b, 0x6a, 0x7d, 0xf1, 0x06, 0x9b, 0xde, 0x63,
	0x87, 0xfe, 0xb7, 0x15, 0x87, 0xb8, 0xff, 0xce, 0x5b, 0x26, 0x6e, 0x1b,
	0xae, 0x86, 0xde, 0x29, 0x37, 0x8a, 0x34, 0xe5, 0xc7, 0x4b, 0x67, 0x24,
	0xc4, 0xd4, 0x0a, 0x71, 0x99, 0x23
};
static const uint8_t nist_kas_ecc_cdh_testvector_122_private[] = {
/* dIUT */
	0x00, 0xf2, 0x66, 0x1a, 0xc7, 0x62, 0xf6, 0x0c, 0x5f, 0xff, 0x23, 0xbe,
	0x5d, 0x96, 0x9c, 0xcd, 0x4e, 0xc6, 0xf9, 0x8e, 0x4e, 0x72, 0x61, 0x8d,
	0x12, 0xbd, 0xcd, 0xb9, 0xb4, 0x10, 0x21, 0x62, 0x33, 0x37, 0x88, 0xc0,
	0xba, 0xe5, 0x9f, 0x91, 0xcd, 0xfc, 0x17, 0x2c, 0x7a, 0x16, 0x81, 0xee,
	0x44, 0xd9, 0x6a, 0xb2, 0x13, 0x5a, 0x6e, 0x5f, 0x34, 0x15, 0xeb, 0xbc,
	0xd5, 0x51, 0x65, 0xb1, 0xaf, 0xb0
};
/* QIUTx = 000000a8e25a6902d687b4787cdc94c364ac7cecc5c495483ed363dc0aa95ee2bd739c4c4d46b17006c728b076350d7d7e54c6822f52f47162a25109aaaba690cab696ec */
/* QIUTy = 00000168d2f08fe19e4dc9ee7a195b03c9f7fe6676f9f520b6270557504e72ca4394a2c6918625e15ac0c51b8f95cd560123653fb8e8ee6db961e2c4c62cc54e92e2a2a9 */
static const uint8_t nist_kas_ecc_cdh_testvector_122_out[] = {
/* ZIUT */
	0x01, 0x4d, 0x60, 0x82, 0xa3, 0xb5, 0xce, 0xd1, 0xab, 0x8c, 0xa2, 0x65,
	0xa8, 0x10, 0x6f, 0x30, 0x21, 0x46, 0xc4, 0xac, 0xb8, 0xc3, 0x0b, 0xb1,
	0x4a, 0x4c, 0x99, 0x1e, 0x3c, 0x82, 0xa9, 0x73, 0x12, 0x88, 0xbd, 0xb9,
	0x1e, 0x0e, 0x85, 0xbd, 0xa3, 0x13, 0x91, 0x2d, 0x06, 0x38, 0x4f, 0xc4,
	0x4f, 0x21, 0x53, 0xfb, 0x13, 0x50, 0x6f, 0xa9, 0xcf, 0x43, 0xc9, 0xaa,
	0xb5, 0x75, 0x09, 0x88, 0xc9, 0x43
};
/* COUNT = 22 */
static const uint8_t nist_kas_ecc_cdh_testvector_123_public_x[] = {
/* QCAVSx */
	0x00, 0xa0, 0x91, 0x42, 0x1d, 0x37, 0x03, 0xe3, 0xb3, 0x41, 0xe9, 0xf1,
	0xe7, 0xd5, 0x8f, 0x8c, 0xf7, 0xbd, 0xbd, 0x17, 0x98, 0xd0, 0x01, 0x96,
	0x7b, 0x80, 0x1d, 0x1c, 0xec, 0x27, 0xe6, 0x05, 0xc5, 0x80, 0xb2, 0x38,
	0x7c, 0x1c, 0xb4, 0x64, 0xf5, 0x5c, 0xe7, 0xac, 0x80, 0x33, 0x41, 0x02,
	0xab, 0x03, 0xcf, 0xb8, 0x6d, 0x88, 0xaf, 0x76, 0xc9, 0xf4, 0x12, 0x9c,
	0x01, 0xbe, 0xdd, 0x3b, 0xbf, 0xc4
};
static const uint8_t nist_kas_ecc_cdh_testvector_123_public_y[] = {
/* QCAVSy */
	0x00, 0x8c, 0x9c, 0x57, 0x7a, 0x8e, 0x6f, 0xc4, 0x46, 0x81, 0x5e, 0x9d,
	0x40, 0xba, 0xa6, 0x60, 0x25, 0xf1, 0x5d, 0xae, 0x28, 0x5f, 0x19, 0xeb,
	0x66, 0x8e, 0xe6, 0x0a, 0xe9, 0xc9, 0x8e, 0x7e, 0xcd, 0xbf, 0x2b, 0x2a,
	0x68, 0xe2, 0x29, 0x28, 0x05, 0x9f, 0x67, 0xdb, 0x18, 0x80, 0x07, 0x16,
	0x1d, 0x3e, 0xcf, 0x39, 0x7e, 0x08, 0x83, 0xf0, 0xc4, 0xeb, 0x7e, 0xaf,
	0x78, 0x27, 0xa6, 0x22, 0x05, 0xcc
};
static const uint8_t nist_kas_ecc_cdh_testvector_123_private[] = {
/* dIUT */
	0x00, 0xf4, 0x30, 0xca, 0x12, 0x61, 0xf0, 0x96, 0x81, 0xa9, 0x28, 0x2e,
	0x9e, 0x97, 0x0a, 0x92, 0x34, 0x22, 0x7b, 0x1d, 0x5e, 0x58, 0xd5, 0x58,
	0xc3, 0xcc, 0x6e, 0xff, 0x44, 0xd1, 0xbd, 0xf5, 0x3d, 0xe1, 0x6a, 0xd5,
	0xee, 0x2b, 0x18, 0xb9, 0x2d, 0x62, 0xfc, 0x79, 0x58, 0x61, 0x16, 0xb0,
	0xef, 0xc1, 0x5f, 0x79, 0x34, 0x0f, 0xb7, 0xea, 0xf5, 0xce, 0x6c, 0x44,
	0x34, 0x1d, 0xcf, 0x8d, 0xde, 0x27
};
/* QIUTx = 0000006c1d9b5eca87de1fb871a0a32f807c725adccde9b3967453a71347d608f0c030cd09e338cdecbf4a02015bc8a6e8d3e2595fe773ffc2fc4e4a55d0b1a2cc00323b */
/* QIUTy = 000001141b2109e7f4981c952aa818a2b9f6f5c41feccdb7a7a45b9b4b672937771b008cae5f934dfe3fed10d383ab1f38769c92ce88d9be5414817ecb073a31ab368ccb */
static const uint8_t nist_kas_ecc_cdh_testvector_123_out[] = {
/* ZIUT */
	0x00, 0x20, 0xc0, 0x07, 0x47, 0xcb, 0x8d, 0x49, 0x2f, 0xd4, 0x97, 0xe0,
	0xfe, 0xc5, 0x46, 0x44, 0xbf, 0x02, 0x7d, 0x41, 0x8a, 0xb6, 0x86, 0x38,
	0x1f, 0x10, 0x97, 0x12, 0xa9, 0x9c, 0xab, 0xe3, 0x28, 0xb9, 0x74, 0x3d,
	0x22, 0x25, 0x83, 0x6f, 0x9a, 0xd6, 0x6e, 0x5d, 0x7f, 0xed, 0x1d, 0xe2,
	0x47, 0xe0, 0xda, 0x92, 0xf6, 0x0d, 0x5b, 0x31, 0xf9, 0xe4, 0x76, 0x72,
	0xe5, 0x7f, 0x71, 0x05, 0x98, 0xf4
};
/* COUNT = 23 */
static const uint8_t nist_kas_ecc_cdh_testvector_124_public_x[] = {
/* QCAVSx */
	0x00, 0x4f, 0x38, 0x81, 0x66, 0x81, 0x77, 0x12, 0x89, 0xce, 0x0c, 0xb8,
	0x3a, 0x5e, 0x29, 0xa1, 0xab, 0x06, 0xfc, 0x91, 0xf7, 0x86, 0x99, 0x4b,
	0x23, 0x70, 0x8f, 0xf0, 0x8a, 0x08, 0xa0, 0xf6, 0x75, 0xb8, 0x09, 0xae,
	0x99, 0xe9, 0xf9, 0x96, 0x7e, 0xb1, 0xa4, 0x9f, 0x19, 0x60, 0x57, 0xd6,
	0x9e, 0x50, 0xd6, 0xde, 0xdb, 0x4d, 0xd2, 0xd9, 0xa8, 0x1c, 0x02, 0xbd,
	0xcc, 0x8f, 0x7f, 0x51, 0x84, 0x60
};
static const uint8_t nist_kas_ecc_cdh_testvector_124_public_y[] = {
/* QCAVSy */
	0x00, 0x9e, 0xfb, 0x24, 0x4c, 0x8b, 0x91, 0x08, 0x7d, 0xe1, 0xee, 0xd7,
	0x66, 0x50, 0x0f, 0x0e, 0x81, 0x53, 0x07, 0x52, 0xd4, 0x69, 0x25, 0x6e,
	0xf7, 0x9f, 0x6b, 0x96, 0x5d, 0x8a, 0x22, 0x32, 0xa0, 0xc2, 0xdb, 0xc4,
	0xe8, 0xe1, 0xd0, 0x92, 0x14, 0xba, 0xb3, 0x84, 0x85, 0xbe, 0x6e, 0x35,
	0x7c, 0x42, 0x00, 0xd0, 0x73, 0xb5, 0x2f, 0x04, 0xe4, 0xa1, 0x6f, 0xc6,
	0xf5, 0x24, 0x71, 0x87, 0xae, 0xcb
};
static const uint8_t nist_kas_ecc_cdh_testvector_124_private[] = {
/* dIUT */
	0x00, 0x5d, 0xc3, 0x3a, 0xed, 0xa0, 0x3c, 0x2e, 0xb2, 0x33, 0x01, 0x4e,
	0xe4, 0x68, 0xdf, 0xf7, 0x53, 0xb7, 0x2f, 0x73, 0xb0, 0x09, 0x91, 0x04,
	0x3e, 0xa3, 0x53, 0x82, 0x8a, 0xe6, 0x9d, 0x4c, 0xd0, 0xfa, 0xde, 0xda,
	0x7b, 0xb2, 0x78, 0xb5, 0x35, 0xd7, 0xc5, 0x74, 0x06, 0xff, 0x2e, 0x6e,
	0x47, 0x3a, 0x5a, 0x4f, 0xf9, 0x8e, 0x90, 0xf9, 0x0d, 0x6d, 0xad, 0xd2,
	0x51, 0x00, 0xe8, 0xd8, 0x56, 0x66
};
/* QIUTx = 000000c825ba307373cec8dd2498eef82e21fd9862168dbfeb83593980ca9f82875333899fe94f137daf1c4189eb502937c3a367ea7951ed8b0f3377fcdf2922021d46a5 */
/* QIUTy = 0000016b8a2540d5e65493888bc337249e67c0a68774f3e8d81e3b4574a0125165f0bd58b8af9de74b35832539f95c3cd9f1b759408560aa6851ae3ac7555347b0d3b13b */
static const uint8_t nist_kas_ecc_cdh_testvector_124_out[] = {
/* ZIUT */
	0x00, 0xc2, 0xbf, 0xaf, 0xcd, 0x7f, 0xbd, 0x3e, 0x2f, 0xd1, 0xc7, 0x50,
	0xfd, 0xea, 0x61, 0xe7, 0x0b, 0xd4, 0x78, 0x7a, 0x7e, 0x68, 0x46, 0x8c,
	0x57, 0x4e, 0xe9, 0x9e, 0xbc, 0x47, 0xee, 0xde, 0xf0, 0x64, 0xe8, 0x94,
	0x4a, 0x73, 0xbc, 0xb7, 0x91, 0x3d, 0xba, 0xb5, 0xd9, 0x3d, 0xca, 0x66,
	0x0d, 0x21, 0x6c, 0x55, 0x36, 0x22, 0x36, 0x27, 0x94, 0xf7, 0xa2, 0xac,
	0xc7, 0x10, 0x22, 0xbd, 0xb1, 0x6f
};
/* COUNT = 24 */
static const uint8_t nist_kas_ecc_cdh_testvector_125_public_x[] = {
/* QCAVSx */
	0x01, 0xa3, 0x20, 0x99, 0xb0, 0x2c, 0x0b, 0xd8, 0x53, 0x71, 0xf6, 0x0b,
	0x0d, 0xd2, 0x08, 0x90, 0xe6, 0xc7, 0xaf, 0x04, 0x8c, 0x81, 0x79, 0x89,
	0x0f, 0xda, 0x30, 0x8b, 0x35, 0x9d, 0xbb, 0xc2, 0xb7, 0xa8, 0x32, 0xbb,
	0x8c, 0x65, 0x26, 0xc4, 0xaf, 0x99, 0xa7, 0xea, 0x3f, 0x0b, 0x3c, 0xb9,
	0x6a, 0xe1, 0xeb, 0x76, 0x84, 0x13, 0x27, 0x95, 0xc4, 0x78, 0xad, 0x6f,
	0x96, 0x2e, 0x4a, 0x6f, 0x44, 0x6d
};
static const uint8_t nist_kas_ecc_cdh_testvector_125_public_y[] = {
/* QCAVSy */
	0x01, 0x76, 0x27, 0x35, 0x7b, 0x39, 0xe9, 0xd7, 0x63, 0x2a, 0x13, 0x70,
	0xb3, 0xe9, 0x3c, 0x1a, 0xfb, 0x5c, 0x85, 0x1b, 0x91, 0x0e, 0xb4, 0xea,
	0xd0, 0xc9, 0xd3, 0x87, 0xdf, 0x67, 0xcd, 0xe8, 0x50, 0x03, 0xe0, 0xe4,
	0x27, 0x55, 0x2f, 0x1c, 0xd0, 0x90, 0x59, 0xaa, 0xd0, 0x26, 0x2e, 0x23,
	0x5c, 0xce, 0x5f, 0xba, 0x8c, 0xed, 0xc4, 0xfd, 0xc1, 0x46, 0x3d, 0xa7,
	0x6d, 0xcd, 0x4b, 0x6d, 0x1a, 0x46
};
static const uint8_t nist_kas_ecc_cdh_testvector_125_private[] = {
/* dIUT */
	0x00, 0xdf, 0x14, 0xb1, 0xf1, 0x43, 0x2a, 0x7b, 0x0f, 0xb0, 0x53, 0x96,
	0x5f, 0xd8, 0x64, 0x3a, 0xfe, 0xe2, 0x6b, 0x24, 0x51, 0xec, 0xb6, 0xa8,
	0xa5, 0x3a, 0x65, 0x5d, 0x5f, 0xbe, 0x16, 0xe4, 0xc6, 0x4c, 0xe8, 0x64,
	0x72, 0x25, 0xeb, 0x11, 0xe7, 0xfd, 0xcb, 0x23, 0x62, 0x74, 0x71, 0xdf,
	0xfc, 0x5c, 0x25, 0x23, 0xbd, 0x2a, 0xe8, 0x99, 0x57, 0xcb, 0xa3, 0xa5,
	0x7a, 0x23, 0x93, 0x3e, 0x5a, 0x78
};
/* QIUTx = 0000004e8583bbbb2ecd93f0714c332dff5ab3bc6396e62f3c560229664329baa5138c3bb1c36428abd4e23d17fcb7a2cfcc224b2e734c8941f6f121722d7b6b94154576 */
/* QIUTy = 000001cf0874f204b0363f020864672fadbf87c8811eb147758b254b74b14fae742159f0f671a018212bbf25b8519e126d4cad778cfff50d288fd39ceb0cac635b175ec0 */
static const uint8_t nist_kas_ecc_cdh_testvector_125_out[] = {
/* ZIUT */
	0x01, 0xaa, 0xf2, 0x4e, 0x5d, 0x47, 0xe4, 0x08, 0x0c, 0x18, 0xc5, 0x5e,
	0xa3, 0x55, 0x81, 0xcd, 0x8d, 0xa3, 0x0f, 0x1a, 0x07, 0x95, 0x65, 0x04,
	0x5d, 0x20, 0x08, 0xd5, 0x1b, 0x12, 0xd0, 0xab, 0xb4, 0x41, 0x1c, 0xda,
	0x7a, 0x07, 0x85, 0xb1, 0x5d, 0x14, 0x9e, 0xd3, 0x01, 0xa3, 0x69, 0x70,
	0x62, 0xf4, 0x2d, 0xa2, 0x37, 0xaa, 0x7f, 0x07, 0xe0, 0xaf, 0x3f, 0xd0,
	0x0e, 0xb1, 0x80, 0x0d, 0x9c, 0x41
};
/* [K-163] - GP NOT SUPPORTED */
/* COUNT = 0 */
static const uint8_t nist_kas_ecc_cdh_testvector_126_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x05, 0x74, 0x23, 0x6f, 0x14, 0x28, 0xc4, 0x32, 0x13,
	0x09, 0x46, 0x78, 0x3a, 0x5b, 0x3a, 0xab, 0xb6, 0xc2, 0x7e, 0xa5, 0xd6
};
static const uint8_t nist_kas_ecc_cdh_testvector_126_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x07, 0x90, 0x8c, 0x25, 0x1b, 0x8d, 0xa0, 0x21, 0xcb,
	0xac, 0x28, 0x1f, 0x12, 0x3f, 0x7a, 0xf4, 0xfa, 0xc5, 0xb3, 0xdb, 0xb8
};
static const uint8_t nist_kas_ecc_cdh_testvector_126_private[] = {
/* dIUT */
	0x66, 0x53, 0xb6, 0x07, 0x73, 0x98, 0xfa, 0xdc, 0x7b, 0xf5, 0xe6, 0x01,
	0x58, 0x17, 0x01, 0x48, 0xc3, 0xdc, 0x45, 0x27
};
/* QIUTx = 000000071f8b2877d6027d9c1ade4244f2dea12692ef23d5 */
/* QIUTy = 00000005c15ee776221c72b84b347ce383f38067b89c3e9a */
static const uint8_t nist_kas_ecc_cdh_testvector_126_out[] = {
/* ZIUT */
	0x04, 0x32, 0x5b, 0xff, 0x38, 0xf1, 0xb0, 0xc8, 0x3c, 0x27, 0xf5, 0x54,
	0xa6, 0xc9, 0x72, 0xa8, 0x0f, 0x14, 0xbc, 0x23, 0xbc
};
/* COUNT = 1 */
static const uint8_t nist_kas_ecc_cdh_testvector_127_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x01, 0x69, 0x97, 0x44, 0x09, 0x2f, 0xe2, 0xb5, 0xfe,
	0x7e, 0xcb, 0xf6, 0x98, 0x7b, 0x7a, 0xea, 0x0a, 0x06, 0xfd, 0x2c, 0xb0
};
static const uint8_t nist_kas_ecc_cdh_testvector_127_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x03, 0x5d, 0xe4, 0x41, 0xdf, 0x94, 0x08, 0xd9, 0x1f,
	0x0e, 0x02, 0x1d, 0xf8, 0xf0, 0x52, 0x6b, 0x80, 0x63, 0x03, 0x14, 0x95
};
static const uint8_t nist_kas_ecc_cdh_testvector_127_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x03, 0xae, 0xf4, 0x47, 0x54, 0xd0, 0xca, 0x97, 0xd4,
	0x2b, 0x4e, 0x97, 0xaa, 0x92, 0x15, 0x62, 0x63, 0xc0, 0xe0, 0x78, 0xf6
};
/* QIUTx = 00000001b0108c786bf4d340f0505bdfc7d45b514611ad94 */
/* QIUTy = 000000022c9c39d5fb9456b8a2221cea4f058f6a8d2cd84a */
static const uint8_t nist_kas_ecc_cdh_testvector_127_out[] = {
/* ZIUT */
	0x05, 0xf9, 0xac, 0x3a, 0x3d, 0xd8, 0x84, 0x29, 0x60, 0x09, 0x58, 0x38,
	0x6c, 0x55, 0xbe, 0xf4, 0xb1, 0xaa, 0x5f, 0x0c, 0x24
};
/* COUNT = 2 */
static const uint8_t nist_kas_ecc_cdh_testvector_128_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x02, 0x96, 0x5d, 0xb1, 0x59, 0x17, 0x1f, 0x5c, 0xb7,
	0xe7, 0xa1, 0xbc, 0xc6, 0x16, 0x11, 0xae, 0xac, 0xa8, 0xc5, 0x2c, 0x9b
};
static const uint8_t nist_kas_ecc_cdh_testvector_128_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x06, 0x87, 0x1d, 0x1e, 0x9c, 0x1f, 0xe8, 0x45, 0x26,
	0x80, 0x76, 0xa9, 0x95, 0x80, 0x3a, 0x6d, 0x49, 0xcd, 0x07, 0x55, 0x54
};
static const uint8_t nist_kas_ecc_cdh_testvector_128_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x03, 0x11, 0x72, 0x34, 0x2e, 0x6d, 0x37, 0xcc, 0x1e,
	0x06, 0x2a, 0x44, 0x94, 0xc3, 0x9c, 0xba, 0x48, 0xf9, 0xad, 0x9a, 0x8c
};
/* QIUTx = 00000003a27ecaec2b66feac2040f6890128bd0058d31924 */
/* QIUTy = 000000014007e3209b6d7127b0f393e5e58b1590b9f40be2 */
static const uint8_t nist_kas_ecc_cdh_testvector_128_out[] = {
/* ZIUT */
	0x02, 0x2e, 0x02, 0x90, 0xed, 0xa5, 0xd3, 0x48, 0x89, 0x41, 0x29, 0xf7,
	0x45, 0x5d, 0x1c, 0x76, 0x6d, 0x32, 0xd5, 0xc2, 0xc2
};
/* COUNT = 3 */
static const uint8_t nist_kas_ecc_cdh_testvector_129_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x05, 0x5b, 0x68, 0xc0, 0xc2, 0xc2, 0x46, 0xfe, 0x0f,
	0x2c, 0xd5, 0x48, 0x4b, 0x58, 0x81, 0x4c, 0x65, 0x21, 0x3e, 0xa5, 0x41
};
static const uint8_t nist_kas_ecc_cdh_testvector_129_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x05, 0x39, 0xc1, 0x1d, 0x25, 0x92, 0xa2, 0xf6, 0x39,
	0x3b, 0x6e, 0x86, 0xc5, 0x4d, 0xf9, 0x09, 0xb9, 0x5f, 0xe0, 0xd5, 0xa8
};
static const uint8_t nist_kas_ecc_cdh_testvector_129_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x03, 0x2a, 0x51, 0x1c, 0xdc, 0xd4, 0xbf, 0xc5, 0x67,
	0xce, 0xac, 0x8c, 0x24, 0xed, 0x04, 0xe8, 0x89, 0x4d, 0xf7, 0x8d, 0xdf
};
/* QIUTx = 00000006978dacaa47d8f3bc90b41ec7f4f8ac79a86ddd07 */
/* QIUTy = 00000007f8b0ef4270760376bc2d5faed83da7872631d09f */
static const uint8_t nist_kas_ecc_cdh_testvector_129_out[] = {
/* ZIUT */
	0x03, 0x7f, 0x65, 0x9f, 0x43, 0x00, 0x09, 0xfc, 0xda, 0xe4, 0xe9, 0xf6,
	0xe6, 0x31, 0x6b, 0x0f, 0x5d, 0xbb, 0x26, 0x82, 0x12
};
/* COUNT = 4 */
static const uint8_t nist_kas_ecc_cdh_testvector_130_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x06, 0xb8, 0xef, 0x5a, 0x62, 0xd3, 0xb6, 0x36, 0xa5,
	0xa7, 0x6b, 0xfe, 0xb1, 0xef, 0x8f, 0xf4, 0xd8, 0xb3, 0xd9, 0xe2, 0xfc
};
static const uint8_t nist_kas_ecc_cdh_testvector_130_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x06, 0x75, 0xa7, 0x57, 0x26, 0x67, 0x18, 0x39, 0x8d,
	0x8a, 0xf6, 0x6d, 0x29, 0x71, 0x79, 0x84, 0x78, 0xe2, 0xf3, 0x7d, 0x28
};
static const uint8_t nist_kas_ecc_cdh_testvector_130_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x02, 0xc6, 0xf6, 0x4f, 0xe6, 0x09, 0xeb, 0x8e, 0xeb,
	0x5b, 0x53, 0xfa, 0xb6, 0x30, 0x88, 0x98, 0xe6, 0x3f, 0xf2, 0xe3, 0xf6
};
/* QIUTx = 0000000549e1a82ec284bf77d528627e52d832e236c92ad3 */
/* QIUTy = 000000019883aa9b458b35bd544d6882812150c1497d31d4 */
static const uint8_t nist_kas_ecc_cdh_testvector_130_out[] = {
/* ZIUT */
	0x00, 0x50, 0x3b, 0xbb, 0x9b, 0x62, 0xf5, 0x0a, 0xe7, 0xa8, 0xdf, 0xd7,
	0x4a, 0x17, 0x41, 0x82, 0x6f, 0x09, 0x29, 0x06, 0x51
};
/* COUNT = 5 */
static const uint8_t nist_kas_ecc_cdh_testvector_131_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x05, 0x6c, 0x4a, 0x35, 0x86, 0xac, 0xb0, 0x30, 0x99,
	0xd5, 0x2b, 0x2c, 0xd4, 0xac, 0x59, 0x26, 0x9c, 0xf5, 0x1b, 0x87, 0x30
};
static const uint8_t nist_kas_ecc_cdh_testvector_131_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x02, 0x42, 0x65, 0x61, 0xcb, 0xd9, 0xda, 0x1b, 0x23,
	0xa6, 0x00, 0x3d, 0xe0, 0xe5, 0xf7, 0xc4, 0xa0, 0x65, 0xa5, 0xc2, 0xb8
};
static const uint8_t nist_kas_ecc_cdh_testvector_131_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x02, 0x6a, 0x56, 0x86, 0x75, 0x13, 0xdd, 0xd8, 0xca,
	0x94, 0xd7, 0x92, 0x3b, 0xaa, 0x1f, 0x7f, 0xb0, 0x0d, 0xaa, 0x38, 0xfa
};
/* QIUTx = 00000006c28a40dc4e5503d2c4b8ab0b6b7046e8e25ac09f */
/* QIUTy = 0000000121911654a5836005d8036d976585ff1d831e587b */
static const uint8_t nist_kas_ecc_cdh_testvector_131_out[] = {
/* ZIUT */
	0x01, 0x2c, 0xf1, 0x77, 0x99, 0xfd, 0xef, 0xa2, 0x94, 0x0b, 0x18, 0xd5,
	0x6e, 0x80, 0xd4, 0x44, 0x14, 0xc5, 0xb1, 0x38, 0x84
};
/* COUNT = 6 */
static const uint8_t nist_kas_ecc_cdh_testvector_132_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x07, 0x41, 0xc6, 0x9a, 0x4e, 0xdb, 0x38, 0x6c, 0x94,
	0xf8, 0x19, 0xd1, 0xb5, 0xdd, 0xd0, 0x28, 0x1e, 0x4f, 0xf2, 0x97, 0x65
};
static const uint8_t nist_kas_ecc_cdh_testvector_132_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x00, 0xd3, 0x2f, 0x97, 0x2a, 0xba, 0xc9, 0x1b, 0xe8,
	0x5a, 0x70, 0x9e, 0xba, 0x07, 0xf5, 0xd1, 0x62, 0x15, 0xae, 0x60, 0x2d
};
static const uint8_t nist_kas_ecc_cdh_testvector_132_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x03, 0x86, 0x81, 0x10, 0x79, 0xc8, 0x02, 0x1c, 0x2d,
	0x79, 0xf4, 0xde, 0x95, 0x2c, 0xb2, 0xe5, 0x99, 0xc4, 0x2e, 0x19, 0xed
};
/* QIUTx = 000000060aa42a62e21eea37e362b4d3de837f0c49d3ac13 */
/* QIUTy = 000000069b20d6fd16d13b1883df05629ac7d1b82386b344 */
static const uint8_t nist_kas_ecc_cdh_testvector_132_out[] = {
/* ZIUT */
	0x06, 0x2a, 0x2f, 0x92, 0x6a, 0xb4, 0x35, 0xac, 0x14, 0xe0, 0x5d, 0x44,
	0xc2, 0x7b, 0x46, 0xb6, 0x82, 0x0b, 0x71, 0x3a, 0xee
};
/* COUNT = 7 */
static const uint8_t nist_kas_ecc_cdh_testvector_133_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x01, 0xef, 0x47, 0x79, 0x5f, 0xb0, 0xe3, 0x80, 0x40,
	0x5a, 0xb5, 0xe8, 0x8d, 0xef, 0xc3, 0xce, 0xd9, 0xa9, 0x25, 0x14, 0xa6
};
static const uint8_t nist_kas_ecc_cdh_testvector_133_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x00, 0xbe, 0x61, 0x81, 0xd7, 0xfc, 0x03, 0xca, 0x8b,
	0xfd, 0xf1, 0x18, 0x69, 0xce, 0xa2, 0x8c, 0xfa, 0x0e, 0x5f, 0x5f, 0x64
};
static const uint8_t nist_kas_ecc_cdh_testvector_133_private[] = {
/* dIUT */
	0xe4, 0x6e, 0x9c, 0x96, 0x52, 0x68, 0x64, 0x7f, 0x20, 0x48, 0x47, 0x4c,
	0x7b, 0x1a, 0x54, 0xdf, 0xfe, 0x72, 0x8f, 0x1f
};
/* QIUTx = 00000007a984ead440310cef2e1338972ff2dddb65cac3d2 */
/* QIUTy = 0000000333c1a93427fe6ac502760b7778898a8bb6a40ad9 */
static const uint8_t nist_kas_ecc_cdh_testvector_133_out[] = {
/* ZIUT */
	0x03, 0x99, 0xb9, 0x29, 0x4e, 0x89, 0x54, 0x86, 0xbd, 0xef, 0xba, 0xad,
	0x7a, 0x72, 0x93, 0x53, 0xce, 0x09, 0x58, 0x63, 0x57
};
/* COUNT = 8 */
static const uint8_t nist_kas_ecc_cdh_testvector_134_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x03, 0x74, 0xd7, 0xf9, 0xba, 0x8c, 0xda, 0x8a, 0x68,
	0xde, 0x72, 0x79, 0xd3, 0xff, 0x86, 0x74, 0x03, 0x2f, 0xd4, 0x7c, 0x02
};
static const uint8_t nist_kas_ecc_cdh_testvector_134_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x03, 0xed, 0xe9, 0x95, 0xc3, 0xa4, 0xe8, 0xa6, 0xfe,
	0x21, 0xcd, 0x1e, 0x4c, 0xd4, 0xca, 0x38, 0x12, 0xc0, 0xd6, 0x92, 0xa5
};
static const uint8_t nist_kas_ecc_cdh_testvector_134_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x02, 0x73, 0x34, 0x97, 0x14, 0x05, 0xb0, 0x46, 0x1c,
	0x3e, 0xde, 0x67, 0xf2, 0xba, 0x33, 0x67, 0x34, 0x45, 0x1a, 0x83, 0x78
};
/* QIUTx = 0000000767c31ee9303b1b2cd3059f81507ef304ebd3102c */
/* QIUTy = 0000000251e0d430dc3f63f3a37bab1e7a957652cf67e22c */
static const uint8_t nist_kas_ecc_cdh_testvector_134_out[] = {
/* ZIUT */
	0x02, 0x23, 0x25, 0xa9, 0xa7, 0x69, 0xa9, 0x02, 0xc2, 0xe6, 0x4c, 0x80,
	0xa1, 0xd3, 0x54, 0x29, 0xce, 0xd4, 0x2a, 0xe0, 0xa4
};
/* COUNT = 9 */
static const uint8_t nist_kas_ecc_cdh_testvector_135_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x06, 0x57, 0x7d, 0xf5, 0x4e, 0x11, 0xc7, 0xe7, 0x62,
	0x02, 0xf9, 0x4f, 0x56, 0x4e, 0x61, 0x37, 0xb2, 0x3c, 0xe6, 0xe4, 0x41
};
static const uint8_t nist_kas_ecc_cdh_testvector_135_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x06, 0x89, 0x36, 0x60, 0x0a, 0xad, 0xcb, 0x25, 0xfd,
	0x40, 0x24, 0xed, 0x3e, 0x84, 0x5b, 0x2b, 0xbf, 0x80, 0x72, 0x80, 0xe6
};
static const uint8_t nist_kas_ecc_cdh_testvector_135_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x01, 0x9b, 0xb4, 0x80, 0x73, 0x90, 0x11, 0x23, 0x5c,
	0x6d, 0x5c, 0x6e, 0x74, 0xd6, 0xa7, 0xbb, 0x4f, 0x20, 0xf6, 0x1b, 0x7a
};
/* QIUTx = 0000000093549075704d79dae772317dd65244fa772569eb */
/* QIUTy = 00000002a8a2821dd39d7e7653ca71cfc1a9ed857801a39b */
static const uint8_t nist_kas_ecc_cdh_testvector_135_out[] = {
/* ZIUT */
	0x05, 0x13, 0x92, 0xd5, 0x37, 0x70, 0x16, 0x35, 0x84, 0x05, 0x03, 0x0b,
	0x48, 0x74, 0x40, 0x03, 0xdb, 0x66, 0x44, 0x0a, 0x2d
};
/* COUNT = 10 */
static const uint8_t nist_kas_ecc_cdh_testvector_136_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x02, 0x61, 0xd1, 0x53, 0x45, 0xce, 0xb4, 0x92, 0x22,
	0x9a, 0x8d, 0x74, 0x59, 0x7e, 0x7d, 0xfd, 0x19, 0xae, 0xb6, 0x84, 0x8a
};
static const uint8_t nist_kas_ecc_cdh_testvector_136_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x01, 0x14, 0xa1, 0x22, 0xce, 0x28, 0xca, 0x15, 0x62,
	0x0f, 0x7b, 0x40, 0xa1, 0xf2, 0x6b, 0x42, 0x34, 0xc9, 0x56, 0xbd, 0xc1
};
static const uint8_t nist_kas_ecc_cdh_testvector_136_private[] = {
/* dIUT */
	0xf4, 0xed, 0xb5, 0x8b, 0xcc, 0x3d, 0x6e, 0x9d, 0x31, 0x72, 0x29, 0x42,
	0x0a, 0x73, 0x32, 0x81, 0xec, 0xcf, 0xf1, 0xcf
};
/* QIUTx = 000000027183609b7593b1845365c081d45ff66c9ab5e370 */
/* QIUTy = 000000069b981236fe930947b6b77f374282a18e4be993cb */
static const uint8_t nist_kas_ecc_cdh_testvector_136_out[] = {
/* ZIUT */
	0x04, 0x5d, 0xac, 0x07, 0x6e, 0x79, 0xde, 0x2f, 0xc6, 0x31, 0x31, 0x54,
	0x65, 0xd3, 0xef, 0x62, 0x45, 0xf2, 0x66, 0x47, 0xe5
};
/* COUNT = 11 */
static const uint8_t nist_kas_ecc_cdh_testvector_137_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x07, 0x0e, 0x38, 0x0f, 0x49, 0x37, 0x0a, 0x00, 0x27,
	0x95, 0x4a, 0x4e, 0xa8, 0x80, 0xbc, 0x19, 0x29, 0xb2, 0x8c, 0x53, 0x29
};
static const uint8_t nist_kas_ecc_cdh_testvector_137_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x04, 0x6f, 0xe3, 0xb4, 0x54, 0xaf, 0x94, 0x20, 0xa8,
	0x11, 0xf1, 0xe1, 0x5f, 0x77, 0x4d, 0xa5, 0xae, 0x1a, 0x40, 0xb4, 0x59
};
static const uint8_t nist_kas_ecc_cdh_testvector_137_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x01, 0xb9, 0x90, 0x49, 0x1a, 0x12, 0xfd, 0xee, 0x23,
	0x1a, 0xa2, 0xa1, 0x16, 0xe1, 0xe3, 0xc1, 0xc9, 0x1d, 0x0f, 0xd4, 0x78
};
/* QIUTx = 00000003da869d09c4e4545ac1689fc72316012632d0abd9 */
/* QIUTy = 00000002c820f40310e5ffd2f8bf439fba879bb2ef621b2a */
static const uint8_t nist_kas_ecc_cdh_testvector_137_out[] = {
/* ZIUT */
	0x01, 0x4f, 0x7a, 0x46, 0x84, 0x7e, 0xd6, 0xa7, 0xff, 0x60, 0x5b, 0x0e,
	0x52, 0xc6, 0x16, 0xe4, 0xad, 0x3f, 0x0d, 0x50, 0x29
};
/* COUNT = 12 */
static const uint8_t nist_kas_ecc_cdh_testvector_138_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x06, 0xe6, 0x0a, 0xf7, 0x74, 0x19, 0xb9, 0xfe, 0x0f,
	0xc5, 0xc7, 0x9c, 0xa1, 0xa2, 0x2a, 0x10, 0x11, 0x40, 0x24, 0x05, 0xb6
};
static const uint8_t nist_kas_ecc_cdh_testvector_138_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x06, 0x9b, 0xca, 0x34, 0x00, 0x5b, 0x57, 0x8c, 0xd7,
	0xa7, 0xa6, 0x92, 0x9b, 0xd3, 0xf6, 0xce, 0x29, 0x94, 0x3b, 0x5e, 0xd9
};
static const uint8_t nist_kas_ecc_cdh_testvector_138_private[] = {
/* dIUT */
	0xe8, 0x29, 0xb9, 0x94, 0x2f, 0xd9, 0x64, 0x87, 0xf6, 0x01, 0x29, 0x08,
	0xfe, 0x04, 0xf6, 0xd8, 0xea, 0xaf, 0x19, 0x66
};
/* QIUTx = 00000005ab2074c04df57160167735f7fc2d8f629d34ff18 */
/* QIUTy = 000000012e9da6d05bb3e2acbe5ba4afb4a0dd72db07d6ac */
static const uint8_t nist_kas_ecc_cdh_testvector_138_out[] = {
/* ZIUT */
	0x00, 0xea, 0xca, 0xbc, 0x34, 0x55, 0x59, 0x56, 0x99, 0x56, 0x23, 0xe6,
	0x04, 0x82, 0xe5, 0xc1, 0x18, 0xe3, 0x4e, 0x20, 0x94
};
/* COUNT = 13 */
static const uint8_t nist_kas_ecc_cdh_testvector_139_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x04, 0xf7, 0x50, 0xe2, 0x75, 0x00, 0xe1, 0x0f, 0x0a,
	0x17, 0x6b, 0x83, 0xf1, 0x4b, 0xc2, 0x6d, 0x6b, 0xd7, 0x1e, 0xbd, 0x74
};
static const uint8_t nist_kas_ecc_cdh_testvector_139_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x03, 0x9e, 0x50, 0x09, 0x06, 0x7c, 0x0e, 0xe2, 0xc8,
	0xf5, 0x5b, 0x7e, 0x84, 0xda, 0x7a, 0x39, 0x1f, 0x08, 0xaf, 0x75, 0x04
};
static const uint8_t nist_kas_ecc_cdh_testvector_139_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x01, 0x57, 0xce, 0x8f, 0x0b, 0x6c, 0xe9, 0x2e, 0x42,
	0x6e, 0xc9, 0x9f, 0x22, 0x3a, 0xd8, 0x27, 0x63, 0xe4, 0xbd, 0x3f, 0xf3
};
/* QIUTx = 00000005d3989cca4ae732de93672b25c9260861b4c0dce3 */
/* QIUTy = 0000000436a331ead24f2807b55260f9dc3de668cfbfebb7 */
static const uint8_t nist_kas_ecc_cdh_testvector_139_out[] = {
/* ZIUT */
	0x04, 0x14, 0xa6, 0x22, 0x64, 0x51, 0x07, 0xf1, 0x15, 0x57, 0x6f, 0x51,
	0xcd, 0xf3, 0x9d, 0x13, 0x93, 0xa2, 0xd7, 0x85, 0x1f
};
/* COUNT = 14 */
static const uint8_t nist_kas_ecc_cdh_testvector_140_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x02, 0xab, 0x9f, 0x5b, 0xa9, 0x41, 0x02, 0xd2, 0x1a,
	0x70, 0x67, 0x61, 0xea, 0xc0, 0x09, 0x21, 0x90, 0xf1, 0xcd, 0xad, 0x04
};
static const uint8_t nist_kas_ecc_cdh_testvector_140_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x04, 0xad, 0xdd, 0x77, 0xe1, 0x99, 0xc1, 0x32, 0xd1,
	0x8a, 0xc5, 0x41, 0xb1, 0x17, 0x74, 0x8d, 0x23, 0x19, 0xdb, 0x7f, 0xe5
};
static const uint8_t nist_kas_ecc_cdh_testvector_140_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x03, 0x79, 0x88, 0x5f, 0x45, 0xf2, 0xd7, 0x07, 0xbe,
	0x1c, 0x11, 0xd8, 0x6c, 0x41, 0xba, 0xda, 0x49, 0x3b, 0x2a, 0x56, 0x03
};
/* QIUTx = 00000005ae31cb29b31d24f5f94c30e9c02f07f38bff0ac8 */
/* QIUTy = 00000004d8d8e39bf87f058543dc8990a91214da416cc558 */
static const uint8_t nist_kas_ecc_cdh_testvector_140_out[] = {
/* ZIUT */
	0x05, 0x6b, 0xe0, 0x02, 0xda, 0xff, 0x11, 0xc4, 0x06, 0x6e, 0x10, 0xac,
	0xd0, 0x46, 0xa8, 0x5e, 0x17, 0x0f, 0xa4, 0xc1, 0x22
};
/* COUNT = 15 */
static const uint8_t nist_kas_ecc_cdh_testvector_141_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x04, 0x3d, 0x25, 0xd2, 0xde, 0x92, 0x93, 0xb8, 0x4d,
	0x35, 0x1a, 0x33, 0xcb, 0x1a, 0x52, 0xf5, 0x93, 0x0a, 0x4c, 0x8b, 0x76
};
static const uint8_t nist_kas_ecc_cdh_testvector_141_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x03, 0xd2, 0x59, 0xd8, 0x23, 0x6e, 0x9c, 0x8d, 0x64,
	0x37, 0xf4, 0x1e, 0x6d, 0x54, 0x61, 0x1c, 0x52, 0x23, 0x8f, 0xe2, 0xd5
};
static const uint8_t nist_kas_ecc_cdh_testvector_141_private[] = {
/* dIUT */
	0xba, 0x8c, 0x58, 0x64, 0xdb, 0x3e, 0xfd, 0x76, 0x8b, 0x93, 0x76, 0xfc,
	0x2b, 0x6c, 0x1f, 0x85, 0xf4, 0x6f, 0x6a, 0xf2
};
/* QIUTx = 000000062f622149823f255b4f86906666f3a3556af080ea */
/* QIUTy = 0000000274ca32c10f9add61a026d20ad3ad56b17fb06a46 */
static const uint8_t nist_kas_ecc_cdh_testvector_141_out[] = {
/* ZIUT */
	0x02, 0x1f, 0xef, 0x8e, 0x47, 0x3d, 0xae, 0xda, 0x8e, 0xf6, 0xbf, 0x07,
	0x81, 0x4d, 0x7b, 0x9b, 0x61, 0x3e, 0x30, 0x76, 0xa3
};
/* COUNT = 16 */
static const uint8_t nist_kas_ecc_cdh_testvector_142_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x00, 0x56, 0x0e, 0x1a, 0x42, 0x18, 0x65, 0x11, 0x8b,
	0xea, 0x16, 0xcd, 0xad, 0x6b, 0x67, 0xab, 0xa3, 0x84, 0xef, 0x38, 0x7b
};
static const uint8_t nist_kas_ecc_cdh_testvector_142_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x05, 0x8b, 0x21, 0x3e, 0xc2, 0xab, 0x39, 0x42, 0xf8,
	0xf6, 0xad, 0x60, 0xa9, 0x56, 0x95, 0x5b, 0x58, 0x90, 0x66, 0xb8, 0x56
};
static const uint8_t nist_kas_ecc_cdh_testvector_142_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x03, 0xe5, 0x08, 0x04, 0x84, 0xd3, 0x73, 0x0b, 0x22,
	0x48, 0xcc, 0xc4, 0x82, 0x60, 0xd4, 0xbd, 0x18, 0x57, 0x60, 0x5a, 0xd1
};
/* QIUTx = 000000058aea6e40b8cb25e6622a7be4ff01b79c92de72a5 */
/* QIUTy = 000000043f6776b6deff3d29b4c703899d705c7fecf525c4 */
static const uint8_t nist_kas_ecc_cdh_testvector_142_out[] = {
/* ZIUT */
	0x03, 0xa2, 0x87, 0xfd, 0x1c, 0xca, 0x68, 0xdb, 0x47, 0xa3, 0xc7, 0x4c,
	0x12, 0x62, 0x7f, 0xc3, 0x72, 0x85, 0x68, 0xdd, 0x66
};
/* COUNT = 17 */
static const uint8_t nist_kas_ecc_cdh_testvector_143_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x03, 0x8e, 0x48, 0x5d, 0xe9, 0x2e, 0x41, 0xf1, 0xca,
	0xca, 0x6c, 0x0e, 0xb9, 0xd8, 0x11, 0xa5, 0xac, 0xa8, 0x9b, 0xf3, 0x45
};
static const uint8_t nist_kas_ecc_cdh_testvector_143_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x03, 0x31, 0xa1, 0x67, 0x7c, 0x46, 0xa6, 0x8e, 0x96,
	0x48, 0x11, 0xa9, 0xcc, 0x5e, 0x4e, 0x53, 0xea, 0x71, 0xe2, 0x31, 0x29
};
static const uint8_t nist_kas_ecc_cdh_testvector_143_private[] = {
/* dIUT */
	0x5d, 0x05, 0x2b, 0xa1, 0xab, 0xea, 0x72, 0x49, 0x78, 0xca, 0xef, 0x18,
	0x79, 0x24, 0x56, 0x72, 0xd5, 0xae, 0xf8, 0x91
};
/* QIUTx = 000000036b84a77337a9de5c1dd7ae3c899381382f0fffa4 */
/* QIUTy = 000000056d4ac39fe881fdb8e60d4559658aaade45663ee5 */
static const uint8_t nist_kas_ecc_cdh_testvector_143_out[] = {
/* ZIUT */
	0x02, 0x95, 0x58, 0xb4, 0x1b, 0x8b, 0x92, 0x38, 0x7b, 0xc2, 0x2c, 0x86,
	0x8f, 0x51, 0xbb, 0x7a, 0xcb, 0x6e, 0x4e, 0xe2, 0xe3
};
/* COUNT = 18 */
static const uint8_t nist_kas_ecc_cdh_testvector_144_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x06, 0x42, 0x59, 0xe5, 0x00, 0x47, 0x6d, 0xda, 0x3e,
	0x97, 0xe2, 0x5e, 0x49, 0x1d, 0x46, 0x6c, 0x2b, 0x79, 0x58, 0xbd, 0x49
};
static const uint8_t nist_kas_ecc_cdh_testvector_144_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x03, 0xc2, 0xe5, 0x32, 0x81, 0x39, 0x36, 0x41, 0xa5,
	0x18, 0xd1, 0xdc, 0xef, 0xfa, 0xbe, 0xe8, 0xb2, 0x9b, 0xde, 0x14, 0x02
};
static const uint8_t nist_kas_ecc_cdh_testvector_144_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x03, 0x91, 0x80, 0x18, 0x7a, 0x9e, 0xdd, 0xcf, 0x38,
	0xdc, 0x26, 0x4f, 0x05, 0x5b, 0x07, 0xd2, 0x0b, 0x9f, 0x9a, 0x8b, 0xc4
};
/* QIUTx = 00000004b292d1fa09dfc5e6a3ad99fd02feb74d480e34f2 */
/* QIUTy = 00000006e1888009a0a0491c0be6abfac943d377f0b4863b */
static const uint8_t nist_kas_ecc_cdh_testvector_144_out[] = {
/* ZIUT */
	0x05, 0x30, 0x02, 0x0c, 0x8f, 0x63, 0x62, 0x31, 0x2b, 0xfb, 0xe5, 0xc1,
	0xc6, 0x05, 0xb4, 0x0d, 0xc2, 0xe0, 0x32, 0xe8, 0x1c
};
/* COUNT = 19 */
static const uint8_t nist_kas_ecc_cdh_testvector_145_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x03, 0x71, 0x42, 0x76, 0x99, 0x7b, 0x44, 0x78, 0xe2,
	0xd8, 0xb5, 0x9a, 0xf5, 0xf2, 0xe6, 0x3e, 0x22, 0xbc, 0x4c, 0x31, 0xe4
};
static const uint8_t nist_kas_ecc_cdh_testvector_145_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x06, 0x73, 0xf2, 0x8d, 0x96, 0x2a, 0xbf, 0xed, 0xee,
	0x62, 0xea, 0xb4, 0x7c, 0x3b, 0x45, 0x79, 0xa1, 0xe5, 0x16, 0x83, 0x36
};
static const uint8_t nist_kas_ecc_cdh_testvector_145_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x01, 0x6d, 0x37, 0x86, 0x2b, 0x19, 0x57, 0x63, 0xc6,
	0xa0, 0x1d, 0x5e, 0x39, 0xb9, 0x45, 0x9a, 0x32, 0x50, 0x7c, 0x2b, 0x21
};
/* QIUTx = 000000033440e460c475f2058a767ec466ca18bce41f830e */
/* QIUTy = 0000000372aee323d063fa89acbffbf55024ae24e4929f19 */
static const uint8_t nist_kas_ecc_cdh_testvector_145_out[] = {
/* ZIUT */
	0x05, 0x21, 0x67, 0x30, 0x06, 0xa1, 0xd9, 0x60, 0x89, 0x11, 0xd5, 0x45,
	0x36, 0xe1, 0x22, 0xd8, 0x09, 0xe9, 0x19, 0xd8, 0x04
};
/* COUNT = 20 */
static const uint8_t nist_kas_ecc_cdh_testvector_146_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x02, 0x75, 0xec, 0x15, 0xf2, 0x7d, 0xd2, 0xda, 0x6e,
	0x44, 0xdf, 0xe6, 0x23, 0x54, 0x72, 0xd5, 0xbd, 0x3a, 0x25, 0x02, 0xf8
};
static const uint8_t nist_kas_ecc_cdh_testvector_146_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x05, 0x8f, 0xd0, 0x22, 0x62, 0xb2, 0x7c, 0x18, 0x5d,
	0xde, 0x26, 0xb2, 0xc7, 0x7d, 0x5a, 0x4f, 0x4d, 0x50, 0xdc, 0x99, 0x28
};
static const uint8_t nist_kas_ecc_cdh_testvector_146_private[] = {
/* dIUT */
	0x6c, 0x65, 0x87, 0x94, 0xb0, 0x39, 0xc8, 0x20, 0xa8, 0xb0, 0x33, 0x00,
	0x8f, 0xa8, 0xac, 0x75, 0x56, 0xbc, 0xae, 0xc3
};
/* QIUTx = 00000004cbfb286691e415081a1785ec6b0aacdb1d231d1d */
/* QIUTy = 00000005dd6acfe91d68a8ec23686478c0ee8c89277aef14 */
static const uint8_t nist_kas_ecc_cdh_testvector_146_out[] = {
/* ZIUT */
	0x04, 0x60, 0x57, 0x9b, 0xec, 0xa1, 0x6c, 0xcc, 0xce, 0x31, 0x4f, 0xf3,
	0x04, 0x0d, 0xe4, 0x78, 0x53, 0x36, 0xfc, 0x35, 0x8c
};
/* COUNT = 21 */
static const uint8_t nist_kas_ecc_cdh_testvector_147_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x02, 0x33, 0xaf, 0x36, 0x10, 0x30, 0x39, 0x22, 0x6f,
	0x41, 0x6d, 0xd2, 0x2e, 0x1a, 0x26, 0xb7, 0x3f, 0x90, 0x93, 0xd3, 0x8a
};
static const uint8_t nist_kas_ecc_cdh_testvector_147_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x07, 0x34, 0x25, 0x8a, 0x17, 0x5c, 0x97, 0x76, 0x8a,
	0x9f, 0x72, 0xb8, 0x24, 0xb9, 0x9a, 0x91, 0xf5, 0xcf, 0x8e, 0x3d, 0x96
};
static const uint8_t nist_kas_ecc_cdh_testvector_147_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x01, 0x69, 0xc8, 0xda, 0x22, 0xc3, 0x5a, 0x85, 0x54,
	0x95, 0x04, 0x7a, 0x10, 0x4b, 0xe0, 0x0b, 0x15, 0x75, 0xb6, 0x52, 0xab
};
/* QIUTx = 000000045efed9c8bd2a4e429588f344f49d1e63e668bd01 */
/* QIUTy = 000000025d1af85ac21d59822d7df8f0e4bebadf3b5d4401 */
static const uint8_t nist_kas_ecc_cdh_testvector_147_out[] = {
/* ZIUT */
	0x05, 0xba, 0x66, 0x96, 0x44, 0x83, 0xfe, 0x47, 0x3c, 0xcb, 0xd0, 0x0c,
	0x37, 0xad, 0x3b, 0xa4, 0x0c, 0xc5, 0x96, 0x9f, 0x62
};
/* COUNT = 22 */
static const uint8_t nist_kas_ecc_cdh_testvector_148_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x06, 0xd0, 0x32, 0x15, 0x22, 0x40, 0xf2, 0x8b, 0xe7,
	0xf7, 0x4d, 0xf8, 0xf6, 0xd2, 0xa4, 0x50, 0xc1, 0x22, 0x9a, 0x5a, 0x95
};
static const uint8_t nist_kas_ecc_cdh_testvector_148_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x07, 0xaa, 0xda, 0xc7, 0x7c, 0xc4, 0x44, 0x89, 0x85,
	0xd1, 0x79, 0x46, 0x36, 0xbc, 0x1d, 0x58, 0x2f, 0x3d, 0x10, 0x1a, 0x33
};
static const uint8_t nist_kas_ecc_cdh_testvector_148_private[] = {
/* dIUT */
	0x03, 0x2f, 0xc7, 0x90, 0x86, 0x46, 0x32, 0x63, 0x0c, 0x49, 0xa2, 0x9e,
	0x9a, 0xd0, 0xfb, 0x6d, 0x10, 0xf2, 0xb5, 0x8c
};
/* QIUTx = 0000000779cfb3e17c902a2584ed3382a8bed8262db98424 */
/* QIUTy = 000000004af273875f8a2ab9a94ac0d1e4a23390b2bb505c */
static const uint8_t nist_kas_ecc_cdh_testvector_148_out[] = {
/* ZIUT */
	0x02, 0x77, 0xc4, 0xa7, 0x6e, 0x16, 0x13, 0xb2, 0xed, 0xe6, 0x99, 0xa6,
	0x75, 0xc1, 0x64, 0x5a, 0x78, 0x60, 0x75, 0x00, 0x9e
};
/* COUNT = 23 */
static const uint8_t nist_kas_ecc_cdh_testvector_149_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x01, 0xf8, 0x58, 0x1e, 0xc6, 0x1d, 0xf1, 0x40, 0x92,
	0x27, 0xaa, 0xb7, 0xa0, 0x15, 0xf2, 0xc7, 0x1d, 0x29, 0xe3, 0x71, 0x6c
};
static const uint8_t nist_kas_ecc_cdh_testvector_149_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x01, 0xc1, 0xf5, 0x1c, 0xc4, 0x18, 0x5b, 0x68, 0xa2,
	0x60, 0xe3, 0x1b, 0x4b, 0x00, 0xc0, 0x3a, 0x44, 0x03, 0xf6, 0x5c, 0x25
};
static const uint8_t nist_kas_ecc_cdh_testvector_149_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x03, 0xc1, 0xde, 0x5b, 0xb4, 0x0e, 0x70, 0x93, 0x3e,
	0xd7, 0xdb, 0x84, 0xce, 0x2c, 0xb4, 0x68, 0xcb, 0xba, 0x29, 0x9b, 0x3a
};
/* QIUTx = 00000005ffe0f16018bd4bdee5f73bfdad04d713f2216f50 */
/* QIUTy = 000000042361c881f0081cb0544efab0c3b34f59eaadeec4 */
static const uint8_t nist_kas_ecc_cdh_testvector_149_out[] = {
/* ZIUT */
	0x03, 0xc6, 0x48, 0x1d, 0xac, 0x38, 0x7a, 0xf3, 0x9e, 0x8c, 0x09, 0xa5,
	0x53, 0x06, 0x8a, 0xc4, 0x96, 0xee, 0xa0, 0x36, 0x91
};
/* COUNT = 24 */
static const uint8_t nist_kas_ecc_cdh_testvector_150_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x02, 0xba, 0x22, 0xfb, 0xda, 0xaa, 0xa8, 0x06, 0xc8,
	0x57, 0x0f, 0x14, 0xad, 0x4c, 0x88, 0x2a, 0x61, 0x0c, 0xcb, 0x8d, 0x84
};
static const uint8_t nist_kas_ecc_cdh_testvector_150_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x06, 0xd4, 0x43, 0x8e, 0x52, 0x8c, 0xa8, 0x87, 0xb0,
	0x5b, 0xd2, 0x56, 0x4d, 0xf9, 0x3b, 0xef, 0x9b, 0xf6, 0x60, 0xda, 0x78
};
static const uint8_t nist_kas_ecc_cdh_testvector_150_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x03, 0x88, 0x12, 0x75, 0xba, 0x48, 0xbe, 0xa0, 0xbe,
	0xcc, 0x02, 0x11, 0x90, 0x34, 0x67, 0xf5, 0xd0, 0xaa, 0xe3, 0x21, 0xaa
};
/* QIUTx = 0000000776e40fe7149985337ef1b6c9b830cb3608752aa6 */
/* QIUTy = 000000058e6ecbb27b0b2d3cd0e3a7ba538de3576fd5b9f6 */
static const uint8_t nist_kas_ecc_cdh_testvector_150_out[] = {
/* ZIUT */
	0x07, 0xb5, 0xd0, 0x96, 0xd0, 0x6d, 0x41, 0xc3, 0xad, 0x64, 0x58, 0xcc,
	0x93, 0x41, 0x7e, 0x6f, 0xac, 0xc9, 0x9b, 0xc7, 0xb8
};
/* [K-233] - GP NOT SUPPORTED */
/* COUNT = 0 */
static const uint8_t nist_kas_ecc_cdh_testvector_151_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x01, 0xf4, 0x0e, 0x34, 0xb3, 0xed, 0x4a, 0x1b, 0x2d, 0x40,
	0xc0, 0x56, 0xfb, 0x75, 0xf2, 0xad, 0x54, 0x3c, 0x89, 0x7c, 0xfd, 0x82,
	0xf5, 0x42, 0xcf, 0x74, 0x6a, 0x0f, 0x20, 0x2f
};
static const uint8_t nist_kas_ecc_cdh_testvector_151_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0xc1, 0x30, 0xa1, 0xab, 0xe9, 0x2b, 0xc4, 0xc9, 0x77,
	0xc8, 0x00, 0x77, 0x79, 0x96, 0xcc, 0xc5, 0x0b, 0x90, 0xdf, 0x99, 0x1a,
	0x2e, 0x81, 0xdd, 0x51, 0x5c, 0x18, 0x85, 0x99
};
static const uint8_t nist_kas_ecc_cdh_testvector_151_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x13, 0x5a, 0x5b, 0x8c, 0x3c, 0xe0, 0x47, 0xfb, 0xc5,
	0xdf, 0x26, 0x27, 0x7d, 0x3b, 0xf8, 0x3a, 0xc3, 0x3d, 0xda, 0xdb, 0x5c,
	0xf4, 0xa0, 0x50, 0xca, 0x82, 0xbe, 0x48, 0xf0
};
/* QIUTx = 000001a53e5c138b3d83905d563aa1db01274633c986b52f78225a92e33e7952 */
/* QIUTy = 000000ecabd3e2e26729a965604e560ed4498a22b31c39642e1cf99b1dde3ec7 */
static const uint8_t nist_kas_ecc_cdh_testvector_151_out[] = {
/* ZIUT */
	0x00, 0xa8, 0x22, 0xb1, 0x41, 0xca, 0x1f, 0x5a, 0xd3, 0x28, 0x99, 0xe6,
	0x8c, 0x54, 0xd1, 0xfe, 0xc3, 0xdf, 0x81, 0x00, 0xdf, 0x48, 0x5e, 0xbf,
	0x1c, 0x58, 0x68, 0xa9, 0xac, 0x89
};
/* COUNT = 1 */
static const uint8_t nist_kas_ecc_cdh_testvector_152_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0xc8, 0x64, 0xc2, 0xa4, 0x62, 0xa9, 0x36, 0x3a, 0x4a,
	0xc3, 0xd8, 0x18, 0x21, 0x1b, 0xca, 0x03, 0x69, 0x47, 0x2d, 0x18, 0x62,
	0x88, 0xa2, 0x75, 0x67, 0x43, 0x3b, 0xda, 0x45
};
static const uint8_t nist_kas_ecc_cdh_testvector_152_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x68, 0x9d, 0x4d, 0x00, 0x06, 0xeb, 0xa0, 0x54, 0xdc,
	0x69, 0xfc, 0xc0, 0x78, 0x67, 0x80, 0xfb, 0x5f, 0x74, 0xd3, 0x98, 0x92,
	0x13, 0x50, 0x4e, 0x2f, 0x6e, 0x66, 0x69, 0x80
};
static const uint8_t nist_kas_ecc_cdh_testvector_152_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x51, 0xbe, 0x6f, 0xbc, 0xd4, 0x87, 0x8c, 0x55, 0x43,
	0x9b, 0x0b, 0xcb, 0xbe, 0x5e, 0xa8, 0xe8, 0x4b, 0xc9, 0xdb, 0x89, 0xe7,
	0x0a, 0x8e, 0x8e, 0xbf, 0x34, 0x78, 0x2d, 0xa8
};
/* QIUTx = 000001c5a1e5d3ee516e3ede723fa2d5cd3456b116326303c5ee49273a5604c4 */
/* QIUTy = 000000568d0fe7130295541bfa265074147546e9733736ba007559d716d8e094 */
static const uint8_t nist_kas_ecc_cdh_testvector_152_out[] = {
/* ZIUT */
	0x01, 0x66, 0x26, 0x82, 0xbe, 0xc2, 0xdf, 0xae, 0x05, 0xe3, 0x85, 0x87,
	0xc8, 0xe6, 0xa4, 0xd1, 0x8a, 0xef, 0x4c, 0xb3, 0x41, 0x69, 0x89, 0xc4,
	0x7c, 0x11, 0xbb, 0xe2, 0x81, 0x0f
};
/* COUNT = 2 */
static const uint8_t nist_kas_ecc_cdh_testvector_153_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x01, 0x78, 0x2d, 0x82, 0xfc, 0xd2, 0x11, 0xc0, 0x24, 0x7c,
	0x87, 0xe6, 0x57, 0xef, 0xcc, 0x5d, 0x2f, 0xf6, 0xb0, 0x5e, 0xb9, 0x35,
	0x33, 0x0a, 0x53, 0x90, 0x3f, 0xb3, 0xbf, 0xa3
};
static const uint8_t nist_kas_ecc_cdh_testvector_153_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0xcc, 0xe8, 0x30, 0xa5, 0x15, 0xd6, 0x90, 0xab, 0x98,
	0x14, 0x95, 0x79, 0xad, 0x34, 0x81, 0x38, 0x48, 0x59, 0xe5, 0x65, 0xd0,
	0x7f, 0xa6, 0x1f, 0x50, 0xeb, 0xd6, 0x69, 0xa2
};
static const uint8_t nist_kas_ecc_cdh_testvector_153_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x2e, 0xcc, 0xa5, 0x95, 0xe5, 0x5e, 0x6c, 0x85, 0xc5,
	0xaf, 0x78, 0xc5, 0x95, 0x40, 0xfd, 0xb7, 0x49, 0x00, 0x3f, 0xf4, 0xec,
	0x36, 0x1c, 0x38, 0xb4, 0x8e, 0x7d, 0xa6, 0xbc
};
/* QIUTx = 0000005a48fac476c31cad0c68e64e65e687ae4418fb5d3b4bb2abb990dd0de4 */
/* QIUTy = 0000002d9add706626f2859ece110df2dde89faf3e8aac433e2595e23c274082 */
static const uint8_t nist_kas_ecc_cdh_testvector_153_out[] = {
/* ZIUT */
	0x00, 0x21, 0x5d, 0x51, 0x1c, 0xb9, 0x5e, 0x0e, 0x07, 0x3e, 0xe9, 0x99,
	0x90, 0x8a, 0x7a, 0x84, 0x4a, 0xfd, 0x75, 0xc9, 0xac, 0xb7, 0xa9, 0xd7,
	0x24, 0xf7, 0xfd, 0x32, 0x2b, 0x01
};
/* COUNT = 3 */
static const uint8_t nist_kas_ecc_cdh_testvector_154_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x8d, 0x80, 0x0d, 0x37, 0x67, 0xab, 0xf5, 0x73, 0x16,
	0x95, 0x75, 0x4e, 0xe8, 0x82, 0x9b, 0x85, 0x8f, 0xf4, 0xeb, 0x60, 0x4a,
	0x44, 0x8a, 0xd6, 0x64, 0x90, 0xb4, 0x9c, 0x19
};
static const uint8_t nist_kas_ecc_cdh_testvector_154_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x01, 0xbc, 0x0f, 0x03, 0x39, 0x64, 0x9a, 0xd4, 0xd7, 0xb7,
	0xcf, 0xf3, 0xfc, 0xa9, 0xe9, 0x65, 0xa3, 0x86, 0x25, 0xe8, 0xf4, 0x5b,
	0xc9, 0x60, 0x2a, 0x33, 0xc0, 0x79, 0x8a, 0x33
};
static const uint8_t nist_kas_ecc_cdh_testvector_154_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x6a, 0x7c, 0x03, 0x89, 0x2d, 0xf1, 0x84, 0xd5, 0x6c,
	0xdc, 0xcb, 0x9d, 0x5e, 0x9a, 0x16, 0x48, 0x3a, 0x6c, 0x93, 0x88, 0xae,
	0x21, 0x2a, 0xa9, 0x26, 0xc8, 0xfd, 0xfb, 0x5e
};
/* QIUTx = 0000014aaf880e81db69aba2b403bbda7f361e3339b483ce2699f30bf5281ead */
/* QIUTy = 000001b71559bd7d9384e517b87f1138a696fbceb3510d8c41c2158d4aa3e5b2 */
static const uint8_t nist_kas_ecc_cdh_testvector_154_out[] = {
/* ZIUT */
	0x01, 0x39, 0x4e, 0x02, 0xc7, 0x01, 0x04, 0xf2, 0xa5, 0x30, 0x8b, 0x2d,
	0x10, 0x1b, 0x02, 0xc7, 0x0e, 0xf2, 0xd1, 0x35, 0x40, 0x60, 0x2b, 0x8e,
	0x8f, 0x82, 0xdc, 0x6d, 0x56, 0x9f
};
/* COUNT = 4 */
static const uint8_t nist_kas_ecc_cdh_testvector_155_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x01, 0x4a, 0x3e, 0x12, 0x1a, 0xdd, 0x7a, 0x52, 0x67, 0xf5,
	0xca, 0xd2, 0x04, 0xb3, 0xf4, 0x92, 0x15, 0x08, 0x47, 0x86, 0xb2, 0x3f,
	0x8d, 0x94, 0xd9, 0xfd, 0xa0, 0x2e, 0x0f, 0x19
};
static const uint8_t nist_kas_ecc_cdh_testvector_155_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x39, 0x4f, 0xea, 0x17, 0x5d, 0xad, 0x9b, 0x34, 0xd5,
	0x25, 0x43, 0x46, 0x54, 0xd0, 0xc8, 0x66, 0x37, 0x92, 0x6c, 0xac, 0x3a,
	0x32, 0x92, 0xa2, 0xe4, 0xa5, 0x14, 0xb5, 0xf5
};
static const uint8_t nist_kas_ecc_cdh_testvector_155_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x2e, 0x2f, 0xf8, 0x79, 0x1b, 0xc6, 0x4c, 0x00, 0xf3,
	0xb0, 0xf1, 0xd5, 0xd5, 0xcf, 0xb9, 0xdd, 0xb3, 0xb1, 0x93, 0x81, 0x45,
	0x99, 0xf7, 0xdb, 0xdd, 0xed, 0xef, 0xcf, 0xa3
};
/* QIUTx = 0000018045cc9e65f6e275e322a62c18efe2d00cf93995feb53561273a3f1306 */
/* QIUTy = 00000164e0073c0d4b3e12e22f837bd3fec421e3bb09e0c0dd997422830f6403 */
static const uint8_t nist_kas_ecc_cdh_testvector_155_out[] = {
/* ZIUT */
	0x00, 0x85, 0x56, 0xa4, 0xc3, 0xa8, 0x90, 0x6d, 0xdb, 0xcb, 0x94, 0x60,
	0x99, 0xca, 0x5d, 0xbe, 0x7b, 0xdb, 0x6c, 0xd8, 0xf3, 0x7f, 0xbb, 0x50,
	0xc9, 0x6f, 0xce, 0xfe, 0xd3, 0x2d
};
/* COUNT = 5 */
static const uint8_t nist_kas_ecc_cdh_testvector_156_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x89, 0x66, 0x78, 0x88, 0xf8, 0x42, 0x5c, 0x5a, 0x62,
	0x31, 0x34, 0x62, 0x2f, 0x1e, 0xa9, 0xd9, 0xaf, 0x36, 0xdf, 0x97, 0x72,
	0xc4, 0x10, 0xd6, 0xe3, 0x1f, 0x2b, 0x4d, 0xb8
};
static const uint8_t nist_kas_ecc_cdh_testvector_156_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x84, 0x43, 0x0f, 0xa4, 0x71, 0x64, 0xd1, 0xc0, 0xeb,
	0x97, 0x04, 0x2a, 0x44, 0xcb, 0xef, 0x40, 0x0b, 0xbb, 0x54, 0x5f, 0xae,
	0xa4, 0xef, 0x49, 0xba, 0x5e, 0x3b, 0xef, 0x42
};
static const uint8_t nist_kas_ecc_cdh_testvector_156_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x66, 0x97, 0x2e, 0x71, 0x56, 0x67, 0x46, 0xf2, 0xf7,
	0x6c, 0x87, 0x79, 0x37, 0x74, 0x05, 0x4e, 0xa2, 0x75, 0xe2, 0xa7, 0xe2,
	0x7a, 0xb7, 0xc2, 0xd0, 0x5c, 0x5f, 0x24, 0x12
};
/* QIUTx = 00000020226dd73e318e4fc8d49dd43e59e260193d1bb248cbe4c06b4d6b8389 */
/* QIUTy = 000000ed12a4f389696ab31c93ea3ec4d8eaf18be097fc9152e2c42b73ff4528 */
static const uint8_t nist_kas_ecc_cdh_testvector_156_out[] = {
/* ZIUT */
	0x00, 0x4e, 0xa6, 0xe0, 0xe3, 0x4e, 0xc7, 0xc9, 0xbb, 0xad, 0x47, 0xf0,
	0xf6, 0xf8, 0xec, 0x06, 0x08, 0xe7, 0x36, 0xd9, 0x1e, 0x0e, 0x56, 0xcf,
	0x3e, 0x5c, 0xff, 0xe8, 0xc3, 0x70
};
/* COUNT = 6 */
static const uint8_t nist_kas_ecc_cdh_testvector_157_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x01, 0x64, 0xda, 0x09, 0x92, 0x25, 0xeb, 0x3c, 0x64, 0x1f,
	0xc8, 0x3c, 0x77, 0x20, 0x4a, 0x39, 0x6e, 0xab, 0x94, 0x95, 0xb1, 0x2a,
	0x22, 0xf6, 0x8e, 0x7a, 0x4b, 0x83, 0x99, 0xd5
};
static const uint8_t nist_kas_ecc_cdh_testvector_157_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0xcd, 0x98, 0xf2, 0x70, 0x4c, 0x74, 0x94, 0xe6, 0xd2,
	0x03, 0x75, 0xe7, 0x45, 0x28, 0xc8, 0xf5, 0x6f, 0x86, 0x7e, 0x9d, 0xd7,
	0x63, 0x29, 0x81, 0x42, 0xea, 0x01, 0x72, 0x4b
};
static const uint8_t nist_kas_ecc_cdh_testvector_157_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x1e, 0x53, 0xba, 0xa1, 0x6b, 0xc0, 0x26, 0x2b, 0x53,
	0x29, 0xa7, 0x11, 0xb0, 0xeb, 0x18, 0x8a, 0x1b, 0xca, 0x7e, 0xf4, 0xb5,
	0xc8, 0x50, 0x61, 0x22, 0x5d, 0x41, 0xd4, 0xa9
};
/* QIUTx = 0000007d6d785fa323174eb9cde5b705428e4019244835bc94702f280c25ffe5 */
/* QIUTy = 0000019aa0ef433074c484d14e611372f03ef8912f1a8246ceb1e90c817db3db */
static const uint8_t nist_kas_ecc_cdh_testvector_157_out[] = {
/* ZIUT */
	0x01, 0x60, 0xd0, 0xb9, 0xb9, 0x2a, 0x4a, 0xcd, 0x08, 0x97, 0x38, 0xfd,
	0x48, 0x9a, 0xe3, 0x97, 0x34, 0x55, 0x1e, 0x88, 0x8f, 0xd0, 0x5a, 0x02,
	0x0c, 0xe2, 0x64, 0x98, 0x27, 0x0a
};
/* COUNT = 7 */
static const uint8_t nist_kas_ecc_cdh_testvector_158_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x33, 0xa8, 0xb0, 0x8a, 0x3c, 0x33, 0xc3, 0x43, 0x03,
	0x2c, 0xed, 0x1c, 0x0f, 0x5e, 0x82, 0x6f, 0x93, 0x2d, 0xee, 0x87, 0x9e,
	0xc1, 0x60, 0x7a, 0x2a, 0xf5, 0xd4, 0x62, 0x98
};
static const uint8_t nist_kas_ecc_cdh_testvector_158_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x6c, 0x4f, 0x27, 0xa4, 0x9b, 0x51, 0xa8, 0x9f, 0x6d,
	0x09, 0x60, 0x16, 0x0b, 0xa5, 0xb8, 0xfe, 0xc0, 0x8d, 0xd2, 0xcd, 0x4b,
	0xc9, 0x09, 0xa4, 0x90, 0xae, 0xbe, 0x4f, 0x7b
};
static const uint8_t nist_kas_ecc_cdh_testvector_158_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x42, 0xa8, 0x03, 0x2a, 0x11, 0xd1, 0x65, 0x77, 0x55,
	0xc4, 0x9e, 0x47, 0x70, 0x33, 0xb0, 0xd3, 0x41, 0xda, 0x2f, 0xe9, 0x93,
	0xa4, 0x57, 0x7b, 0x41, 0xa4, 0x0c, 0xee, 0x1a
};
/* QIUTx = 000001f6629697da620d597fc1f51c83374213f37e952fc117ee65a9e766aefb */
/* QIUTy = 0000002b36dedc787ac951d2879d72414da2e7575a6cd7c42e0fa20b32d461f7 */
static const uint8_t nist_kas_ecc_cdh_testvector_158_out[] = {
/* ZIUT */
	0x00, 0x38, 0x38, 0x1b, 0x34, 0x2e, 0xfa, 0xa7, 0x0b, 0xb7, 0x9a, 0xdb,
	0x76, 0xce, 0xb7, 0x75, 0xde, 0x5f, 0x45, 0xf8, 0x63, 0x55, 0x9e, 0xca,
	0xee, 0x1d, 0xdb, 0xbd, 0x03, 0x13
};
/* COUNT = 8 */
static const uint8_t nist_kas_ecc_cdh_testvector_159_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0xcf, 0xe1, 0x5f, 0x86, 0x1a, 0xa0, 0x15, 0x34, 0x85,
	0xf3, 0x8a, 0xc0, 0x33, 0xdf, 0x9c, 0x8d, 0x81, 0x2a, 0xfd, 0xe1, 0x67,
	0xb8, 0x91, 0x8b, 0xb9, 0x4a, 0x08, 0xd9, 0x63
};
static const uint8_t nist_kas_ecc_cdh_testvector_159_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x01, 0xbe, 0xbf, 0x06, 0x7f, 0x85, 0x12, 0x6d, 0x11, 0x49,
	0x32, 0x16, 0x21, 0x64, 0x20, 0x1b, 0x13, 0x74, 0xbf, 0x18, 0x40, 0xaa,
	0x11, 0xd5, 0xe2, 0x50, 0x63, 0x9d, 0x06, 0x08
};
static const uint8_t nist_kas_ecc_cdh_testvector_159_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x43, 0xe5, 0x77, 0x09, 0x78, 0x19, 0x5f, 0x91, 0x71,
	0x52, 0xf0, 0x57, 0xba, 0x1f, 0xb0, 0x15, 0x6d, 0x89, 0x4d, 0x32, 0xe8,
	0xbb, 0x54, 0xc7, 0xf6, 0x2f, 0x73, 0x40, 0xa6
};
/* QIUTx = 000001487d1fdabccd7d89da25685b042980ab170aee3c11f31180e3b7c50a4a */
/* QIUTy = 0000017e383dd65a1ec8a409007f75035e5b161335d9c7756ed970490fbd171a */
static const uint8_t nist_kas_ecc_cdh_testvector_159_out[] = {
/* ZIUT */
	0x01, 0x22, 0x16, 0x9f, 0x1d, 0xff, 0x44, 0x5e, 0xc6, 0x63, 0x27, 0x03,
	0x75, 0xdf, 0xe9, 0x14, 0x01, 0x6c, 0x38, 0xce, 0x6c, 0x2d, 0x40, 0xd0,
	0xb8, 0x09, 0x8a, 0xbc, 0x60, 0xac
};
/* COUNT = 9 */
static const uint8_t nist_kas_ecc_cdh_testvector_160_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x76, 0x3e, 0x28, 0x6b, 0xe5, 0x07, 0x40, 0xb7, 0xf8,
	0xbd, 0x78, 0xfa, 0x70, 0xbc, 0xac, 0x88, 0x0d, 0xf3, 0xd7, 0x37, 0x1e,
	0xb3, 0x3f, 0xda, 0x24, 0x53, 0xb3, 0xed, 0x23
};
static const uint8_t nist_kas_ecc_cdh_testvector_160_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x57, 0xbe, 0x6c, 0x5f, 0x7d, 0x99, 0x0b, 0x75, 0x43,
	0x98, 0x68, 0x33, 0x9a, 0xe3, 0x27, 0xaf, 0x04, 0xa0, 0x49, 0xb3, 0x8b,
	0x92, 0x33, 0x2b, 0x9c, 0xb8, 0xcb, 0x27, 0xd9
};
static const uint8_t nist_kas_ecc_cdh_testvector_160_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x4c, 0x67, 0xc6, 0x10, 0x3e, 0x62, 0x12, 0x46, 0x00,
	0xa0, 0xd9, 0xe9, 0x23, 0xdc, 0x21, 0x7a, 0x02, 0x2f, 0x57, 0xc6, 0xfe,
	0xb2, 0x19, 0xc7, 0x03, 0x33, 0x4f, 0xf3, 0x39
};
/* QIUTx = 0000002352fe9341e62c609fc1538e0270405e7001d747b87500e644a112c5d9 */
/* QIUTy = 00000041f3b15b714a6f7ef647e23665ea530efcbe19b0740436cda812e83939 */
static const uint8_t nist_kas_ecc_cdh_testvector_160_out[] = {
/* ZIUT */
	0x00, 0x54, 0xd4, 0x7c, 0x9d, 0x0a, 0x9f, 0xee, 0x25, 0x81, 0x22, 0x32,
	0x6b, 0xe2, 0x5d, 0xaf, 0x35, 0xf0, 0xba, 0x0b, 0x84, 0x49, 0xe1, 0x6b,
	0x46, 0x23, 0xa8, 0xc0, 0xfd, 0x7e
};
/* COUNT = 10 */
static const uint8_t nist_kas_ecc_cdh_testvector_161_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0xbc, 0x8a, 0x71, 0xad, 0x4c, 0x11, 0x34, 0xde, 0xf0,
	0x26, 0xe4, 0x72, 0x3e, 0x31, 0x02, 0x23, 0xfb, 0x2c, 0x58, 0x59, 0xbc,
	0x75, 0x94, 0x05, 0x4c, 0x89, 0x4d, 0xa5, 0x52
};
static const uint8_t nist_kas_ecc_cdh_testvector_161_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0xc3, 0x65, 0x05, 0x63, 0x50, 0x55, 0x35, 0x03, 0x3c,
	0x7a, 0x6c, 0x44, 0x8d, 0x73, 0xbf, 0xa0, 0x8f, 0xb8, 0x37, 0x02, 0x34,
	0xc7, 0xfd, 0xba, 0xc1, 0xb3, 0x4d, 0xaa, 0x22
};
static const uint8_t nist_kas_ecc_cdh_testvector_161_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x19, 0xe5, 0x4d, 0xa8, 0x72, 0x99, 0x5e, 0xb3, 0xdc,
	0xdc, 0xcc, 0x50, 0x41, 0x8e, 0xc3, 0x51, 0x40, 0x08, 0x89, 0xfa, 0xe7,
	0x5a, 0x0b, 0xa4, 0xdc, 0xff, 0x25, 0xf1, 0xf9
};
/* QIUTx = 0000015e67eaebe52ba37f5b73a199d950812cec1012fd410581444bbf23e0c8 */
/* QIUTy = 00000022055ef821df33042fb8316ddad76485dbd2590e2f5498a914e4f0ad39 */
static const uint8_t nist_kas_ecc_cdh_testvector_161_out[] = {
/* ZIUT */
	0x00, 0x71, 0xae, 0xd3, 0x9f, 0x5c, 0x44, 0xa7, 0xff, 0x72, 0xdb, 0x3e,
	0x0f, 0x82, 0x84, 0xda, 0x39, 0xdf, 0xb2, 0xd8, 0x94, 0xf2, 0x78, 0xd2,
	0x00, 0x6f, 0x9d, 0x26, 0x86, 0xe3
};
/* COUNT = 11 */
static const uint8_t nist_kas_ecc_cdh_testvector_162_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x01, 0x6c, 0xc1, 0xae, 0x13, 0xfb, 0x34, 0x82, 0x52, 0x49,
	0x30, 0x21, 0xcd, 0x61, 0x46, 0xd5, 0x31, 0xf0, 0xb7, 0x22, 0x84, 0x2a,
	0x44, 0xc7, 0x97, 0x96, 0x89, 0xf1, 0xff, 0x38
};
static const uint8_t nist_kas_ecc_cdh_testvector_162_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x01, 0x8c, 0x09, 0x63, 0xff, 0x0e, 0xa3, 0x70, 0x48, 0xc9,
	0xf6, 0xf4, 0x76, 0x44, 0xf2, 0xa7, 0xc8, 0xc5, 0x03, 0x86, 0x3c, 0x27,
	0xcf, 0x21, 0xee, 0x6e, 0x0a, 0x32, 0x24, 0xea
};
static const uint8_t nist_kas_ecc_cdh_testvector_162_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x13, 0xa5, 0xff, 0xc9, 0xa0, 0xf7, 0x06, 0x9c, 0x1c,
	0x66, 0x14, 0x86, 0x99, 0x61, 0x2e, 0x5c, 0xfa, 0xb7, 0xe2, 0xbf, 0x7b,
	0x32, 0x55, 0xf1, 0x81, 0xa0, 0x22, 0x71, 0x92
};
/* QIUTx = 0000018de4dc4f6a4de5c3638ebba24dc7064983b159f55b139c7680a1cb90d1 */
/* QIUTy = 00000135532d8148af3e227d4a8960e768c565f72c1ac0a1c9a7bd185cf994d0 */
static const uint8_t nist_kas_ecc_cdh_testvector_162_out[] = {
/* ZIUT */
	0x01, 0xca, 0x68, 0xea, 0xd4, 0xed, 0xdc, 0x88, 0x47, 0xa3, 0xa6, 0x61,
	0xcc, 0x66, 0x28, 0xe0, 0x76, 0xbd, 0xd4, 0xb4, 0x50, 0x47, 0xec, 0xe7,
	0x22, 0x45, 0xd0, 0x94, 0xdd, 0x3b
};
/* COUNT = 12 */
static const uint8_t nist_kas_ecc_cdh_testvector_163_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0xe4, 0x9e, 0x18, 0x2a, 0xc5, 0xd9, 0x32, 0xbe, 0x8b,
	0x05, 0xfe, 0x34, 0x0e, 0x8c, 0xb7, 0x2d, 0xf3, 0x56, 0x47, 0xde, 0xcd,
	0x67, 0x9a, 0x8c, 0x59, 0xb5, 0xd8, 0xfb, 0xfa
};
static const uint8_t nist_kas_ecc_cdh_testvector_163_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x01, 0x81, 0xb9, 0x5a, 0x96, 0x5a, 0xbd, 0x16, 0xec, 0x24,
	0x30, 0xc2, 0x6d, 0xd0, 0x71, 0x98, 0x4e, 0x85, 0x4a, 0x96, 0x7f, 0xf1,
	0x14, 0xee, 0x78, 0x31, 0xbd, 0x31, 0x4b, 0x2a
};
static const uint8_t nist_kas_ecc_cdh_testvector_163_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x2f, 0x5d, 0x2a, 0x7e, 0x08, 0x77, 0xa4, 0xc9, 0x90,
	0x73, 0x73, 0x23, 0x86, 0xe8, 0xd5, 0x97, 0x34, 0xa2, 0x3d, 0xd7, 0xf0,
	0xdf, 0x7f, 0xcd, 0x54, 0xd9, 0x41, 0xe7, 0x60
};
/* QIUTx = 0000014798094680cbd32fb1ee9dcaa6b8739a556305235933fb27157d319e57 */
/* QIUTy = 000001c855f0d453c1ffb5f668b32a8b3e309e0e8101bc39b6dbe7de214015e3 */
static const uint8_t nist_kas_ecc_cdh_testvector_163_out[] = {
/* ZIUT */
	0x01, 0x7a, 0x89, 0x3b, 0x2e, 0x09, 0x07, 0x80, 0xff, 0x8d, 0xaa, 0xf3,
	0x58, 0x8f, 0x9d, 0xfc, 0x0a, 0xc4, 0xdf, 0xe1, 0xf1, 0xe2, 0x63, 0x69,
	0x7a, 0x9d, 0x1f, 0x39, 0x8a, 0xb3
};
/* COUNT = 13 */
static const uint8_t nist_kas_ecc_cdh_testvector_164_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x01, 0x59, 0x8b, 0x2f, 0xdb, 0x5b, 0xf1, 0xa3, 0x95, 0x1f,
	0xb9, 0xec, 0x01, 0x6e, 0xcb, 0x4d, 0x28, 0xf6, 0x6c, 0x2e, 0x9d, 0x13,
	0x59, 0x67, 0x86, 0x59, 0x35, 0x85, 0xd7, 0x19
};
static const uint8_t nist_kas_ecc_cdh_testvector_164_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x01, 0xef, 0x65, 0xca, 0xf1, 0x57, 0x95, 0xd1, 0x4a, 0x0b,
	0xe8, 0x9c, 0xac, 0x7c, 0x68, 0x03, 0x23, 0xbc, 0x59, 0x80, 0x3b, 0xa8,
	0x74, 0xcb, 0x29, 0x68, 0x67, 0x2c, 0xb8, 0xa9
};
static const uint8_t nist_kas_ecc_cdh_testvector_164_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x65, 0x2a, 0x11, 0xf6, 0xc3, 0x11, 0x7f, 0x13, 0x26,
	0xfa, 0x68, 0x77, 0x40, 0x5c, 0xec, 0x73, 0x31, 0xc4, 0xf1, 0x46, 0xa9,
	0x7f, 0x74, 0xab, 0x0c, 0x44, 0xde, 0x01, 0xb7
};
/* QIUTx = 0000002cd6d4c1d2cc5e34205eadb94f4cfd35bb569da722c4d9b19b8d5cc2de */
/* QIUTy = 000000ea3004e5b0930df7f8bda314c8bc1145463eb60022cd2dcf6c0c824e50 */
static const uint8_t nist_kas_ecc_cdh_testvector_164_out[] = {
/* ZIUT */
	0x00, 0x41, 0xfa, 0x5f, 0xdf, 0x49, 0x5b, 0x88, 0x56, 0x99, 0x24, 0x9b,
	0x77, 0x46, 0x33, 0x4b, 0x76, 0xc5, 0x9e, 0x1c, 0x91, 0x7b, 0xfc, 0x1a,
	0xe3, 0x71, 0xb9, 0x69, 0x41, 0xf4
};
/* COUNT = 14 */
static const uint8_t nist_kas_ecc_cdh_testvector_165_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x01, 0xb6, 0xcf, 0xf3, 0xb7, 0xfa, 0x21, 0x5e, 0x37, 0x86,
	0x05, 0xc9, 0x3f, 0x86, 0xf5, 0xcd, 0x38, 0x45, 0xf4, 0x5f, 0xbd, 0xe8,
	0xbe, 0x07, 0x9d, 0xec, 0x29, 0xbc, 0x88, 0x62
};
static const uint8_t nist_kas_ecc_cdh_testvector_165_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x01, 0x66, 0x22, 0x2e, 0xfa, 0x5d, 0xba, 0x9e, 0x85, 0x8c,
	0x24, 0x5d, 0xbb, 0x5d, 0xa6, 0x68, 0x23, 0x9a, 0xb5, 0xba, 0x72, 0x86,
	0x18, 0xfb, 0x85, 0xa9, 0x0d, 0xdc, 0x76, 0x0a
};
static const uint8_t nist_kas_ecc_cdh_testvector_165_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x2a, 0xd5, 0xf7, 0x1c, 0x63, 0x84, 0xaf, 0x62, 0x68,
	0x9b, 0x35, 0xc2, 0x4c, 0x4d, 0xdf, 0xb3, 0x5a, 0xcf, 0x81, 0x06, 0xcb,
	0x0c, 0x19, 0x50, 0x2c, 0x2c, 0xa1, 0x84, 0xaf
};
/* QIUTx = 000000fe1b52408a712841bd62f0ee51307f26331d402bcc3a5ab0405d1c5e80 */
/* QIUTy = 0000010a731a7d6a6a4f5b40b2eaa810c1902db27b28d297bc05f3714cacafc0 */
static const uint8_t nist_kas_ecc_cdh_testvector_165_out[] = {
/* ZIUT */
	0x01, 0x5f, 0x5a, 0xdb, 0xa5, 0x9d, 0x1e, 0xe0, 0x16, 0x96, 0xce, 0xcc,
	0xe4, 0xb6, 0x3e, 0x78, 0xe6, 0x85, 0x08, 0x30, 0x3e, 0xe4, 0x96, 0xff,
	0x5a, 0xbc, 0xea, 0x25, 0xad, 0x3b
};
/* COUNT = 15 */
static const uint8_t nist_kas_ecc_cdh_testvector_166_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0xcf, 0x40, 0x2a, 0xeb, 0xc3, 0xe4, 0x24, 0x7a, 0x9a,
	0xb4, 0x3d, 0xa9, 0x75, 0x51, 0x76, 0xa8, 0x10, 0xe0, 0x11, 0xf9, 0xfd,
	0x97, 0x7d, 0xe1, 0xbe, 0x2f, 0xd5, 0x34, 0xfb
};
static const uint8_t nist_kas_ecc_cdh_testvector_166_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x01, 0xba, 0xc4, 0x5f, 0xa4, 0x2d, 0x60, 0x5a, 0xd3, 0x47,
	0x9c, 0x7c, 0x43, 0xe7, 0x24, 0x91, 0x07, 0x16, 0x73, 0x79, 0x53, 0xcc,
	0x85, 0x04, 0xaf, 0x14, 0xf3, 0x31, 0xd3, 0x4f
};
static const uint8_t nist_kas_ecc_cdh_testvector_166_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x6f, 0x01, 0xcb, 0x54, 0x78, 0x1c, 0xbd, 0xa6, 0xd8,
	0x8d, 0xeb, 0x59, 0x84, 0x3a, 0xe0, 0x83, 0x6b, 0x1a, 0xf6, 0x83, 0xef,
	0xc7, 0x56, 0x50, 0xbe, 0x84, 0xf2, 0x08, 0xa7
};
/* QIUTx = 0000004d00a8f0820da9097fe50e8e7defdac29607dd4cb1dd881d4e61f1e78b */
/* QIUTy = 0000008a4a8e9c811b444367952752ab8c2a5198efb28fbedbf3fbd701a857a9 */
static const uint8_t nist_kas_ecc_cdh_testvector_166_out[] = {
/* ZIUT */
	0x00, 0x3d, 0x5c, 0x29, 0xb3, 0x75, 0x3e, 0x89, 0xce, 0x50, 0x64, 0x57,
	0x53, 0x93, 0x39, 0x2b, 0x37, 0x7c, 0xa6, 0x57, 0xa0, 0xb7, 0x38, 0x72,
	0xc8, 0x21, 0x65, 0xfc, 0x43, 0xae
};
/* COUNT = 16 */
static const uint8_t nist_kas_ecc_cdh_testvector_167_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0xf3, 0x8c, 0xcc, 0xcf, 0x08, 0xe5, 0xbd, 0xff, 0x3b,
	0xb3, 0x5f, 0x7e, 0x75, 0xbd, 0xce, 0xd6, 0x8d, 0x37, 0x91, 0xdc, 0xf7,
	0x84, 0x3c, 0xa8, 0x8f, 0xf0, 0x92, 0x13, 0x6d
};
static const uint8_t nist_kas_ecc_cdh_testvector_167_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x01, 0x5e, 0xd7, 0x69, 0x7a, 0x4b, 0x8c, 0x99, 0xd0, 0x14,
	0x78, 0x28, 0xf6, 0xc8, 0x61, 0xff, 0xc9, 0xcf, 0xb0, 0xf3, 0x3d, 0xce,
	0x9d, 0x14, 0xb0, 0x73, 0x1e, 0x1d, 0xa2, 0x62
};
static const uint8_t nist_kas_ecc_cdh_testvector_167_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x5d, 0xc1, 0xba, 0x18, 0x39, 0xf5, 0xd1, 0xfe, 0xa8,
	0x5a, 0xb3, 0x61, 0x4c, 0x55, 0xa9, 0xc5, 0xfe, 0x60, 0x08, 0x53, 0xc7,
	0x1a, 0x61, 0x98, 0x3c, 0x7d, 0xc8, 0x2d, 0xe2
};
/* QIUTx = 000000b6cb6ffa4e2eabcf7b987ebb520165a8ec9a22a6f9ffb100f38172a0fb */
/* QIUTy = 000000d39814e1852476e56e89ce8cdd64372840c01570a86940ace24bb9cf6a */
static const uint8_t nist_kas_ecc_cdh_testvector_167_out[] = {
/* ZIUT */
	0x00, 0x7c, 0x01, 0xf9, 0x06, 0xca, 0xa5, 0x90, 0x89, 0x8a, 0x09, 0xf4,
	0x6b, 0x6f, 0x53, 0x83, 0x65, 0x8e, 0x7f, 0xee, 0x65, 0x6a, 0xca, 0x0f,
	0x11, 0x1f, 0x22, 0x93, 0x99, 0x60
};
/* COUNT = 17 */
static const uint8_t nist_kas_ecc_cdh_testvector_168_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x01, 0xe3, 0x28, 0x57, 0x1d, 0xf9, 0x33, 0xac, 0xfd, 0x4c,
	0x96, 0xf3, 0xc4, 0xbd, 0xe7, 0x1e, 0x91, 0x75, 0xcb, 0xcd, 0x62, 0xae,
	0xec, 0xd7, 0x63, 0x84, 0x74, 0x4a, 0x0f, 0x3f
};
static const uint8_t nist_kas_ecc_cdh_testvector_168_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x01, 0x9f, 0xf4, 0x8a, 0xae, 0x0c, 0x25, 0x2e, 0xda, 0x8d,
	0x34, 0x0b, 0x25, 0xc4, 0xdd, 0xa0, 0x1a, 0x2f, 0x21, 0xaa, 0xa3, 0x5d,
	0x39, 0xba, 0xf0, 0x36, 0x69, 0x6a, 0x11, 0x01
};
static const uint8_t nist_kas_ecc_cdh_testvector_168_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x24, 0x1e, 0x1d, 0xf5, 0x58, 0x70, 0x31, 0xdd, 0xda,
	0xe1, 0x96, 0x89, 0x1c, 0x28, 0x82, 0x1c, 0xc7, 0x87, 0x9a, 0xd3, 0x58,
	0x32, 0xae, 0x71, 0x8f, 0x6e, 0x79, 0x2e, 0x66
};
/* QIUTx = 000001c172cee2b76503eb4d90b39ddace825b23c32375cb68eaecd7348490a3 */
/* QIUTy = 000000c246ef9c6e2fadac77c73ee9dd5adee828b7918417395b5997be1a0278 */
static const uint8_t nist_kas_ecc_cdh_testvector_168_out[] = {
/* ZIUT */
	0x01, 0x9e, 0xec, 0xe7, 0xd3, 0xfa, 0xfc, 0x92, 0x74, 0xd3, 0x61, 0xc6,
	0xfa, 0xfd, 0x9e, 0xfd, 0x9e, 0xe4, 0x85, 0xcb, 0xac, 0xb3, 0xba, 0xaf,
	0x68, 0x34, 0xfe, 0xb4, 0xdf, 0x6a
};
/* COUNT = 18 */
static const uint8_t nist_kas_ecc_cdh_testvector_169_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0xf4, 0xaa, 0x7f, 0x93, 0x40, 0xa9, 0xda, 0x46, 0xc4,
	0xf0, 0x67, 0x28, 0x75, 0x3a, 0x4a, 0xdc, 0x5a, 0xf5, 0x3a, 0x4d, 0xcb,
	0x46, 0x7f, 0x70, 0xb4, 0x87, 0x3d, 0xa7, 0x85
};
static const uint8_t nist_kas_ecc_cdh_testvector_169_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x7f, 0x32, 0x1e, 0x2b, 0xc4, 0xe2, 0x9a, 0x68, 0xac,
	0x23, 0xc7, 0x7c, 0xed, 0xd3, 0xbb, 0xcd, 0xe0, 0xbf, 0x7b, 0x92, 0xa2,
	0x7f, 0xfa, 0x76, 0x49, 0x69, 0x88, 0x98, 0x1d
};
static const uint8_t nist_kas_ecc_cdh_testvector_169_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x04, 0x4a, 0xc5, 0x5a, 0x91, 0x3a, 0x8c, 0x7f, 0x7e,
	0xd7, 0xfc, 0x56, 0x79, 0xf5, 0x2f, 0x47, 0xcb, 0xb9, 0x73, 0x03, 0x25,
	0xbe, 0x21, 0xb7, 0x99, 0x37, 0x79, 0xd1, 0x87
};
/* QIUTx = 0000009794861017b3debeff302e425327fe269d78753b73bc1bfb3a77f716dc */
/* QIUTy = 00000002581a49c1269f5ec868dc6d7f5c2d8e749632d47ab6d9e68dbad985f0 */
static const uint8_t nist_kas_ecc_cdh_testvector_169_out[] = {
/* ZIUT */
	0x01, 0xe4, 0xb7, 0xe8, 0x9f, 0xb1, 0xb5, 0x11, 0x79, 0xb8, 0x79, 0x2f,
	0x5c, 0xd5, 0x81, 0xc3, 0x91, 0x7e, 0x11, 0x24, 0x6d, 0x38, 0x46, 0xf6,
	0x34, 0x4e, 0xe8, 0x2e, 0xed, 0x66
};
/* COUNT = 19 */
static const uint8_t nist_kas_ecc_cdh_testvector_170_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x68, 0xd9, 0xe5, 0x5e, 0x7a, 0x10, 0x5b, 0x7b, 0xb4,
	0x4b, 0x21, 0xd6, 0x69, 0xbb, 0x0e, 0xf6, 0x57, 0xa9, 0x14, 0x37, 0xad,
	0x84, 0xbf, 0x6d, 0x58, 0x53, 0x27, 0x0c, 0x98
};
static const uint8_t nist_kas_ecc_cdh_testvector_170_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x14, 0x3c, 0x8b, 0xed, 0xb5, 0x4d, 0xb0, 0x7d, 0xf8,
	0xf6, 0x70, 0x83, 0xc5, 0x9a, 0x0a, 0xa7, 0xcd, 0x8a, 0x0e, 0xfa, 0x42,
	0xf4, 0x2f, 0xd6, 0x2e, 0x44, 0x2e, 0x0b, 0x62
};
static const uint8_t nist_kas_ecc_cdh_testvector_170_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x2b, 0xc1, 0x36, 0x77, 0x85, 0x31, 0x08, 0x9d, 0xa5,
	0xc2, 0xfa, 0xb3, 0xca, 0xee, 0xc2, 0x56, 0xc5, 0x4b, 0x0b, 0x35, 0xfc,
	0x2c, 0x65, 0xf7, 0xb8, 0xee, 0x61, 0x61, 0xc3
};
/* QIUTx = 000001fb258a31d166bef9cd664cd7b66cd8c186e7025c77f0bae731587e9ef6 */
/* QIUTy = 00000060dfd4e475e92805d1935d0382dc1767067915cc00ed3b24f65382d21a */
static const uint8_t nist_kas_ecc_cdh_testvector_170_out[] = {
/* ZIUT */
	0x01, 0x45, 0x71, 0x0c, 0x3a, 0xb0, 0x78, 0x0e, 0xc2, 0x33, 0x42, 0x4d,
	0x4e, 0x28, 0xb3, 0x8d, 0x29, 0xf8, 0x86, 0x96, 0x5b, 0xbc, 0xac, 0x49,
	0xfa, 0x30, 0x0e, 0x1e, 0xd8, 0x86
};
/* COUNT = 20 */
static const uint8_t nist_kas_ecc_cdh_testvector_171_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x99, 0xeb, 0x91, 0xcd, 0xa9, 0x86, 0x20, 0x10, 0x3c,
	0x32, 0x05, 0xd6, 0x48, 0x9e, 0x68, 0xad, 0x7e, 0x57, 0xd0, 0xa5, 0x1d,
	0xc5, 0x02, 0xd6, 0xe3, 0x05, 0x88, 0xf4, 0x18
};
static const uint8_t nist_kas_ecc_cdh_testvector_171_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x3f, 0xbf, 0x82, 0x99, 0x29, 0xed, 0xd2, 0x8e, 0x90,
	0x6f, 0x58, 0xf8, 0x7a, 0xbe, 0xd6, 0xd6, 0xd1, 0x77, 0xf4, 0x36, 0xf0,
	0xdd, 0x94, 0x0d, 0xda, 0x25, 0xea, 0xf1, 0x88
};
static const uint8_t nist_kas_ecc_cdh_testvector_171_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x0d, 0x56, 0x59, 0x54, 0x71, 0x43, 0x5d, 0x95, 0xfe,
	0xc3, 0x7d, 0xf6, 0x22, 0xf1, 0x8e, 0xe7, 0xda, 0xbb, 0x24, 0x37, 0x9c,
	0x82, 0xbb, 0xf7, 0x14, 0xc5, 0xab, 0xc5, 0xe3
};
/* QIUTx = 000001a52940a452aaf420b37b5f32c2c337306894a882feea7addadc01927ee */
/* QIUTy = 000000771b9f62a2a6fa892503225275490388b8bfc2df77df3e806bedba7d88 */
static const uint8_t nist_kas_ecc_cdh_testvector_171_out[] = {
/* ZIUT */
	0x00, 0x69, 0x41, 0xa2, 0xa5, 0x31, 0x08, 0x35, 0x63, 0xdd, 0x88, 0x6b,
	0x06, 0xc0, 0x86, 0x07, 0x70, 0xa4, 0x72, 0x4b, 0xb0, 0x4a, 0x4e, 0xbb,
	0x2a, 0xfb, 0x1b, 0xa2, 0x63, 0x6b
};
/* COUNT = 21 */
static const uint8_t nist_kas_ecc_cdh_testvector_172_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0xdc, 0xca, 0xa2, 0x2b, 0x43, 0x39, 0x1d, 0xc0, 0x52,
	0x59, 0x7a, 0xe3, 0xbd, 0x07, 0xc6, 0xe5, 0xf0, 0x21, 0xf3, 0x9e, 0x98,
	0x77, 0x56, 0xf6, 0x54, 0x81, 0x71, 0xee, 0x94
};
static const uint8_t nist_kas_ecc_cdh_testvector_172_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x01, 0x28, 0xef, 0xd4, 0x9a, 0xf3, 0xa6, 0xb3, 0x2d, 0xc1,
	0x67, 0x97, 0xa9, 0x78, 0xf0, 0xad, 0x4a, 0xb0, 0xdb, 0x66, 0xab, 0xab,
	0xd6, 0xad, 0x56, 0x72, 0xf4, 0xf8, 0x12, 0xc9
};
static const uint8_t nist_kas_ecc_cdh_testvector_172_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x19, 0xc8, 0xab, 0x2b, 0x32, 0xf2, 0xee, 0x93, 0xbf,
	0x2f, 0xf6, 0xbc, 0x44, 0x37, 0x8b, 0x60, 0x87, 0x2b, 0xda, 0xeb, 0x6b,
	0xa5, 0x6b, 0x51, 0x4c, 0x8f, 0x38, 0x8b, 0xa7
};
/* QIUTx = 00000083530fa3df315a8740ac52f4d394b80c4a5f210baba0b6dc2205e12493 */
/* QIUTy = 00000037b9d02ed43e9d41d0dbb8403b9021b4d2c1bd360ee53c31c27b492005 */
static const uint8_t nist_kas_ecc_cdh_testvector_172_out[] = {
/* ZIUT */
	0x00, 0x1d, 0x75, 0x4e, 0xe5, 0x35, 0x1d, 0x45, 0x82, 0x97, 0x47, 0x34,
	0x07, 0x2a, 0xba, 0xc2, 0x33, 0x76, 0xe2, 0x43, 0x48, 0x37, 0x09, 0x34,
	0xe7, 0xb8, 0x64, 0xdb, 0x0f, 0x52
};
/* COUNT = 22 */
static const uint8_t nist_kas_ecc_cdh_testvector_173_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x01, 0x70, 0x91, 0x7b, 0x33, 0xb3, 0x7b, 0x8e, 0xaf, 0xf2,
	0x46, 0x1e, 0x5f, 0x9e, 0xb8, 0xf0, 0x79, 0x7b, 0x13, 0xaa, 0xbd, 0x91,
	0x5a, 0x60, 0x70, 0x6c, 0xd4, 0xf3, 0x2c, 0xb6
};
static const uint8_t nist_kas_ecc_cdh_testvector_173_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x76, 0x51, 0xe0, 0x74, 0x2c, 0x0d, 0x83, 0xd4, 0xb6,
	0x85, 0x52, 0xe9, 0xb7, 0xab, 0xec, 0x36, 0x44, 0xba, 0x97, 0x55, 0xcf,
	0xfe, 0x6d, 0x4e, 0x56, 0x94, 0x3a, 0x6b, 0x9b
};
static const uint8_t nist_kas_ecc_cdh_testvector_173_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x50, 0x31, 0x60, 0x10, 0x4d, 0x88, 0xa0, 0xc0, 0xf6,
	0x39, 0x56, 0xe7, 0xc3, 0xbb, 0xa7, 0x02, 0x96, 0x3f, 0x9f, 0x1b, 0x53,
	0xfc, 0x11, 0x9a, 0x59, 0x2e, 0xee, 0xa4, 0xf5
};
/* QIUTx = 000001463c78e498abf34033ec3e1d973dc12509e2d234fb91403715e42f61f7 */
/* QIUTy = 000000ade7abb98a0308886696353aad33c05bab5cf3c0d4e969cbf4c4ceec93 */
static const uint8_t nist_kas_ecc_cdh_testvector_173_out[] = {
/* ZIUT */
	0x01, 0x13, 0x46, 0xb8, 0x37, 0x91, 0xe4, 0xbe, 0xa7, 0xf6, 0xba, 0x6b,
	0x12, 0x65, 0xe5, 0x05, 0x08, 0x95, 0xd8, 0x40, 0x27, 0xc1, 0x06, 0xf7,
	0x73, 0x53, 0x41, 0x8f, 0x75, 0xd7
};
/* COUNT = 23 */
static const uint8_t nist_kas_ecc_cdh_testvector_174_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0xd8, 0xed, 0x31, 0x83, 0x82, 0xb8, 0x5c, 0x25, 0x25,
	0xa0, 0x2c, 0x22, 0xc6, 0x7f, 0x5b, 0xf3, 0x66, 0x33, 0x5d, 0x94, 0x76,
	0x7e, 0xb5, 0xcb, 0x45, 0x73, 0x96, 0x64, 0xc5
};
static const uint8_t nist_kas_ecc_cdh_testvector_174_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x01, 0x7d, 0x8f, 0xde, 0x7b, 0xbc, 0x56, 0x8f, 0xdc, 0x80,
	0x2a, 0x3e, 0x34, 0x55, 0xf3, 0xcf, 0x35, 0x60, 0x2d, 0xf7, 0x06, 0x84,
	0xc8, 0xac, 0xdd, 0xa1, 0x65, 0xa0, 0x26, 0x56
};
static const uint8_t nist_kas_ecc_cdh_testvector_174_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x45, 0x47, 0xea, 0xf9, 0xbe, 0x1c, 0xe5, 0xaf, 0x13,
	0x86, 0xe3, 0x11, 0x04, 0x6e, 0xc8, 0x32, 0x60, 0xb8, 0x4a, 0x2c, 0xa9,
	0x10, 0x55, 0xf6, 0x06, 0x68, 0xb9, 0x46, 0xe0
};
/* QIUTx = 000001504938c167680afb8b6d5858cfaa191c40196fc4e500c662c5346ecc90 */
/* QIUTy = 00000137d1ba942228dae68c450b1a033a2c810a995971f01c24089e4a6fdcc5 */
static const uint8_t nist_kas_ecc_cdh_testvector_174_out[] = {
/* ZIUT */
	0x00, 0xb4, 0x93, 0x8e, 0xd1, 0xed, 0x01, 0x2a, 0x9a, 0x53, 0x89, 0x2e,
	0xd9, 0x94, 0x93, 0x97, 0xcd, 0xc4, 0xe4, 0xa6, 0x12, 0xd5, 0x4d, 0xcf,
	0x80, 0xcd, 0xb0, 0x39, 0xf4, 0x7b
};
/* COUNT = 24 */
static const uint8_t nist_kas_ecc_cdh_testvector_175_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x01, 0x7f, 0x87, 0xf1, 0x3f, 0x6d, 0xfe, 0xe6, 0x08, 0x1b,
	0xb5, 0xcc, 0xa5, 0x32, 0xfe, 0x26, 0x8c, 0x27, 0x1d, 0x27, 0x56, 0xb3,
	0x1b, 0xdf, 0x64, 0x32, 0x97, 0xcf, 0x69, 0x5b
};
static const uint8_t nist_kas_ecc_cdh_testvector_175_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0xf3, 0xa7, 0x46, 0x95, 0x5e, 0x12, 0xdd, 0x0b, 0x71,
	0x91, 0x9e, 0xdb, 0xf2, 0x3b, 0x23, 0x22, 0xca, 0xb3, 0x28, 0xdd, 0x09,
	0xbd, 0xf8, 0x7b, 0xca, 0xfd, 0xcd, 0x28, 0x84
};
static const uint8_t nist_kas_ecc_cdh_testvector_175_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x42, 0xfb, 0xe5, 0x54, 0x86, 0x2f, 0x35, 0x95, 0x18,
	0x4a, 0x45, 0x51, 0x0c, 0xa5, 0x3d, 0xf9, 0x7c, 0x45, 0x17, 0x55, 0x84,
	0xb5, 0xd2, 0xde, 0x04, 0x27, 0x23, 0x35, 0x8e
};
/* QIUTx = 00000131b8d61b9cfb0536c588214e45888ebe48391eeecb4d7fb5be8eff4acf */
/* QIUTy = 00000165da49557a0aa9d45dd378d5f899272cc697682276ae91d2c0b675c469 */
static const uint8_t nist_kas_ecc_cdh_testvector_175_out[] = {
/* ZIUT */
	0x01, 0xb3, 0xd2, 0x57, 0x8b, 0xde, 0x30, 0x66, 0xa2, 0x53, 0xdb, 0x53,
	0x22, 0xc8, 0x5c, 0xf9, 0x48, 0x7c, 0xe7, 0x7b, 0x67, 0xec, 0xe9, 0x55,
	0xe2, 0x81, 0xb0, 0xd7, 0xd0, 0xe7
};
/* [K-283] - GP NOT SUPPORTED */
/* COUNT = 0 */
static const uint8_t nist_kas_ecc_cdh_testvector_176_public_x[] = {
/* QCAVSx */
	0x03, 0xf0, 0x75, 0xc2, 0x4c, 0x35, 0xa9, 0xdc, 0x99, 0x52, 0xbe, 0x6f,
	0xd3, 0x2b, 0x76, 0x1d, 0xce, 0x63, 0xf4, 0x72, 0x0a, 0x22, 0x40, 0x8e,
	0x3a, 0x14, 0xbb, 0xd0, 0x97, 0xe0, 0x12, 0xb5, 0x69, 0x4c, 0x22, 0xa0
};
static const uint8_t nist_kas_ecc_cdh_testvector_176_public_y[] = {
/* QCAVSy */
	0x06, 0x75, 0x82, 0x5b, 0x40, 0x20, 0x2e, 0x95, 0xbe, 0x7d, 0xab, 0x5a,
	0x82, 0x61, 0x47, 0xe0, 0x4b, 0x8c, 0x51, 0xa0, 0x9b, 0x00, 0x34, 0x57,
	0x7c, 0x1f, 0x31, 0xf8, 0xc1, 0x6a, 0x70, 0xc8, 0xe1, 0xc8, 0x5b, 0x89
};
static const uint8_t nist_kas_ecc_cdh_testvector_176_private[] = {
/* dIUT */
	0x01, 0x5f, 0xde, 0x49, 0xb8, 0x02, 0x54, 0x2a, 0x52, 0xc7, 0x0b, 0x23,
	0xa0, 0xb1, 0x78, 0x4e, 0x5f, 0x87, 0x80, 0xb5, 0x68, 0x53, 0xf9, 0xa5,
	0xf8, 0xc3, 0xa5, 0x26, 0x6e, 0x87, 0x27, 0xdc, 0xe9, 0x7d, 0x4a, 0x17
};
/* QIUTx = 0611edc045dbe43ecc4ef6b324cd51f70fe3d7ddf877ec68b798909c3c4561756aa30e5f */
/* QIUTy = 00833b25511704af09b62d9f7cbac59814e75bbb9c735f55538491dbfa60c1e0115efe42 */
static const uint8_t nist_kas_ecc_cdh_testvector_176_out[] = {
/* ZIUT */
	0x07, 0x45, 0x55, 0x28, 0x17, 0xb5, 0xd7, 0x29, 0x31, 0x0b, 0x7d, 0xbe,
	0xba, 0xe6, 0x87, 0x64, 0x87, 0x14, 0xa9, 0xae, 0x69, 0x5d, 0xad, 0x20,
	0xca, 0x1a, 0xb6, 0x11, 0x1c, 0x3d, 0x05, 0x46, 0x70, 0xf2, 0x11, 0x32
};
/* COUNT = 1 */
static const uint8_t nist_kas_ecc_cdh_testvector_177_public_x[] = {
/* QCAVSx */
	0x07, 0x99, 0xb4, 0x30, 0xe9, 0x23, 0x20, 0xff, 0xea, 0xbf, 0x2d, 0x6c,
	0xc8, 0x73, 0x99, 0xe3, 0x0c, 0x0a, 0xa8, 0x44, 0x20, 0xff, 0x8e, 0xba,
	0x23, 0x09, 0xb9, 0x94, 0x87, 0xb7, 0x42, 0xd7, 0x22, 0xe8, 0xb7, 0xa5
};
static const uint8_t nist_kas_ecc_cdh_testvector_177_public_y[] = {
/* QCAVSy */
	0x02, 0x17, 0x36, 0x28, 0x01, 0xfd, 0x6d, 0x2d, 0x28, 0x6e, 0x5c, 0xdf,
	0x37, 0x5c, 0xd0, 0xae, 0x56, 0x9b, 0x70, 0x00, 0x05, 0x31, 0x2e, 0x37,
	0xe8, 0xe3, 0x5b, 0x15, 0x92, 0xef, 0xb9, 0xb5, 0xea, 0xf4, 0x7b, 0x3a
};
static const uint8_t nist_kas_ecc_cdh_testvector_177_private[] = {
/* dIUT */
	0x01, 0x3b, 0x91, 0x1f, 0x62, 0xf3, 0xaa, 0x88, 0x43, 0x54, 0x63, 0x45,
	0x47, 0xee, 0x62, 0x28, 0x07, 0xd5, 0xd1, 0x06, 0x02, 0x03, 0x30, 0xae,
	0x2b, 0x97, 0x98, 0xc0, 0xc4, 0xcd, 0x0e, 0xad, 0xb1, 0x0b, 0xa9, 0x48
};
/* QIUTx = 078d2ecd4d902332b6b3c7bd4ba7d200fc34c45eda30998b6025ed47b1f4f8e68f328624 */
/* QIUTy = 04d5e53647dddf2fccc8816dac8bc70c29807622cc95539a72aa3a9b230ca1d25ee7b516 */
static const uint8_t nist_kas_ecc_cdh_testvector_177_out[] = {
/* ZIUT */
	0x02, 0xeb, 0x0c, 0x1c, 0xeb, 0x61, 0x79, 0x23, 0x2e, 0x91, 0xcf, 0xf9,
	0x1f, 0xc8, 0xa3, 0x05, 0x53, 0xc6, 0xed, 0x7e, 0x0a, 0x71, 0xde, 0xb1,
	0xbd, 0xa0, 0xa1, 0x07, 0x35, 0xa8, 0x45, 0x93, 0xdd, 0x90, 0x36, 0x36
};
/* COUNT = 2 */
static const uint8_t nist_kas_ecc_cdh_testvector_178_public_x[] = {
/* QCAVSx */
	0x00, 0xce, 0x47, 0xa7, 0x43, 0xd4, 0x8b, 0x86, 0xfe, 0xfd, 0x6b, 0x5c,
	0x02, 0xf2, 0xa9, 0x7b, 0x27, 0x62, 0xa2, 0xfe, 0x57, 0xe0, 0xbd, 0xf8,
	0x5c, 0x1d, 0x6a, 0x29, 0xde, 0x88, 0x62, 0xc4, 0xc9, 0x9e, 0xd5, 0x3a
};
static const uint8_t nist_kas_ecc_cdh_testvector_178_public_y[] = {
/* QCAVSy */
	0x03, 0x22, 0xe5, 0x96, 0x06, 0x9f, 0x91, 0x65, 0x68, 0xca, 0x24, 0x8c,
	0xed, 0x57, 0xef, 0xe9, 0x05, 0x34, 0xaf, 0x4a, 0x9f, 0x90, 0xa4, 0xf4,
	0x0f, 0x79, 0x7e, 0x45, 0x29, 0x67, 0x03, 0x17, 0x26, 0xbf, 0x41, 0xd7
};
static const uint8_t nist_kas_ecc_cdh_testvector_178_private[] = {
/* dIUT */
	0x01, 0x77, 0x63, 0x2b, 0x69, 0xe7, 0xed, 0xda, 0x3c, 0xf0, 0x07, 0x30,
	0x75, 0x04, 0x34, 0x3c, 0xc2, 0x16, 0x23, 0x26, 0xf6, 0x20, 0x17, 0xcb,
	0xdd, 0xf3, 0x60, 0xa8, 0x76, 0xdc, 0x93, 0xb8, 0x1f, 0x04, 0xc5, 0x8e
};
/* QIUTx = 03815ab6480e4ad24a6628275ef2ee0ce7d58699239dbce23338842bc58c42cca94d2412 */
/* QIUTy = 02de833cc664cac90d30fbeac603efbbce9276d4f16ab1c46e7e11c81a9aa9e25c82969a */
static const uint8_t nist_kas_ecc_cdh_testvector_178_out[] = {
/* ZIUT */
	0x04, 0xa9, 0xdd, 0x2c, 0xf5, 0x07, 0x68, 0x14, 0xe5, 0x32, 0x9c, 0x51,
	0x8c, 0x4f, 0x27, 0xb4, 0x29, 0xdb, 0xe0, 0x1d, 0x46, 0x68, 0x2d, 0x47,
	0x6e, 0x7e, 0x78, 0x88, 0x0d, 0xe3, 0x68, 0xb0, 0x64, 0x23, 0x6b, 0xa9
};
/* COUNT = 3 */
static const uint8_t nist_kas_ecc_cdh_testvector_179_public_x[] = {
/* QCAVSx */
	0x07, 0x28, 0x97, 0x58, 0x39, 0xb4, 0x2c, 0x62, 0x03, 0x6a, 0x7a, 0xff,
	0xfa, 0xdd, 0xef, 0xc3, 0x02, 0x4b, 0x72, 0x58, 0x40, 0x7b, 0xed, 0x56,
	0x5c, 0xae, 0xa9, 0x39, 0xbe, 0x33, 0xd1, 0x6a, 0xc9, 0x44, 0x45, 0xc7
};
static const uint8_t nist_kas_ecc_cdh_testvector_179_public_y[] = {
/* QCAVSy */
	0x07, 0x71, 0x26, 0x30, 0x79, 0x0b, 0x05, 0xae, 0x04, 0xd8, 0xd7, 0xd9,
	0xf2, 0x36, 0x5d, 0xae, 0x9a, 0xd2, 0x4c, 0x4c, 0x61, 0xb3, 0xeb, 0x20,
	0xc0, 0xa7, 0x98, 0x7e, 0x6a, 0x4c, 0x4b, 0x0f, 0x59, 0x8c, 0x37, 0x1f
};
static const uint8_t nist_kas_ecc_cdh_testvector_179_private[] = {
/* dIUT */
	0x00, 0x3b, 0xfe, 0x9a, 0x1c, 0x98, 0x53, 0x86, 0xe5, 0xba, 0x2b, 0x31,
	0x55, 0x3a, 0x55, 0x15, 0x1e, 0x78, 0xdd, 0xc3, 0x8f, 0x07, 0x43, 0x2b,
	0x5c, 0x42, 0xa1, 0xcd, 0x2d, 0xa2, 0x78, 0xfd, 0x0b, 0x68, 0xe0, 0x47
};
/* QIUTx = 01d9c3337da95ec6e5a4bff1cc92783989b66c9230107870d4a578699338e38eb2d92eff */
/* QIUTy = 00cdaad7d0eb0f445aa763a5dfb8f38f55355777ce24f753b5ad3d3cbab125f491698d56 */
static const uint8_t nist_kas_ecc_cdh_testvector_179_out[] = {
/* ZIUT */
	0x04, 0x4e, 0x2c, 0xd2, 0xbc, 0x16, 0x4d, 0x21, 0xcf, 0x4b, 0x98, 0x33,
	0xc0, 0xaa, 0x62, 0xed, 0x05, 0x92, 0x82, 0xe6, 0x2b, 0x82, 0xf4, 0x50,
	0x0a, 0xeb, 0x42, 0x2d, 0x17, 0xe1, 0xf6, 0xe7, 0xe8, 0xbb, 0xd5, 0x00
};
/* COUNT = 4 */
static const uint8_t nist_kas_ecc_cdh_testvector_180_public_x[] = {
/* QCAVSx */
	0x05, 0x56, 0x72, 0xd7, 0x39, 0x98, 0x45, 0x10, 0x89, 0xe2, 0xb7, 0xc7,
	0x10, 0x4b, 0x42, 0x24, 0x7d, 0xdd, 0xd1, 0x32, 0xd4, 0x0a, 0xd0, 0x87,
	0xb5, 0x88, 0xd6, 0xa3, 0x85, 0xda, 0x64, 0xf5, 0xa2, 0xf4, 0x68, 0x38
};
static const uint8_t nist_kas_ecc_cdh_testvector_180_public_y[] = {
/* QCAVSy */
	0x02, 0xb4, 0xcb, 0x15, 0x81, 0xf9, 0xe2, 0xb3, 0x78, 0xeb, 0x7a, 0x4f,
	0x64, 0xf5, 0xa7, 0xd4, 0x32, 0x0b, 0x2c, 0xa3, 0xd3, 0x47, 0x47, 0x26,
	0xf6, 0x70, 0xc3, 0x88, 0x3b, 0xb8, 0xda, 0x47, 0xf3, 0xd7, 0x45, 0xbe
};
static const uint8_t nist_kas_ecc_cdh_testvector_180_private[] = {
/* dIUT */
	0x00, 0xd9, 0x5a, 0xf5, 0x2a, 0x70, 0x8e, 0x69, 0x2d, 0x02, 0x67, 0x7b,
	0x21, 0x03, 0x2f, 0x7a, 0xea, 0xd6, 0x00, 0x3f, 0x12, 0x4e, 0x72, 0x01,
	0x3f, 0x37, 0xc0, 0x6e, 0x0b, 0xbc, 0x20, 0xe3, 0x53, 0x2b, 0x3c, 0xea
};
/* QIUTx = 06e487f91e73bdd344fb8bc8f4c1f476e727fb2671e9d6c8fbd775f1aaa24caf2e9a36f5 */
/* QIUTy = 0663e1cff8099757bb9ff1b87890283aa49cff0f7b12fe184ed2a428375d2796cd81de91 */
static const uint8_t nist_kas_ecc_cdh_testvector_180_out[] = {
/* ZIUT */
	0x04, 0xd4, 0xf0, 0x4d, 0x2f, 0xcf, 0x1b, 0xcd, 0x81, 0x50, 0xea, 0xde,
	0xd9, 0x0e, 0x46, 0x7d, 0x3d, 0x38, 0xf7, 0x53, 0xb6, 0xfb, 0x54, 0xee,
	0xd8, 0xf9, 0xd2, 0x9c, 0xd3, 0xdc, 0xc7, 0xbe, 0x2c, 0x83, 0xde, 0x11
};
/* COUNT = 5 */
static const uint8_t nist_kas_ecc_cdh_testvector_181_public_x[] = {
/* QCAVSx */
	0x02, 0xcc, 0x28, 0xa4, 0xcb, 0x76, 0xd1, 0x47, 0xd9, 0x8d, 0xfa, 0x67,
	0x7d, 0xca, 0x14, 0xe1, 0x77, 0x13, 0x47, 0xb9, 0x68, 0x1c, 0x65, 0xcd,
	0xb5, 0x40, 0xf2, 0x2c, 0x90, 0x76, 0x13, 0xfd, 0xcc, 0xb0, 0xc8, 0xda
};
static const uint8_t nist_kas_ecc_cdh_testvector_181_public_y[] = {
/* QCAVSy */
	0x07, 0xd4, 0x06, 0x5f, 0x99, 0x0c, 0x8f, 0xc3, 0x7d, 0x10, 0x0e, 0xce,
	0x38, 0xfb, 0xf5, 0x74, 0xce, 0x44, 0x4d, 0xc3, 0x73, 0x55, 0xe0, 0x70,
	0x2b, 0x80, 0xd1, 0xeb, 0x1b, 0xdd, 0x67, 0x09, 0x97, 0xe8, 0xf2, 0x71
};
static const uint8_t nist_kas_ecc_cdh_testvector_181_private[] = {
/* dIUT */
	0x00, 0xc7, 0x33, 0xd9, 0x09, 0x40, 0x32, 0xcc, 0x7a, 0xed, 0x6c, 0x54,
	0xa8, 0xce, 0xd7, 0x53, 0xea, 0xf2, 0xa4, 0x88, 0x82, 0x28, 0x5a, 0x3b,
	0x4c, 0x7e, 0x60, 0x21, 0xf2, 0x6b, 0xec, 0xe0, 0x72, 0x28, 0x40, 0xad
};
/* QIUTx = 026896b039d7068d98a326710ebb7a978bd47661154645ae30cd83d60535067e05151ccb */
/* QIUTy = 00d83a263bdbd8c8abf0310bfbfc83917a86b0d8c4be0b155ab7b9e2c705605628bbcdd9 */
static const uint8_t nist_kas_ecc_cdh_testvector_181_out[] = {
/* ZIUT */
	0x01, 0xc3, 0x43, 0x54, 0x05, 0x41, 0x60, 0x4f, 0x68, 0xdd, 0xbd, 0x63,
	0xc4, 0x83, 0x76, 0x0d, 0x82, 0x4d, 0xed, 0x5c, 0x18, 0xbe, 0x7e, 0x56,
	0xe6, 0xd3, 0x6a, 0x9a, 0xc6, 0xd2, 0x57, 0x72, 0xaf, 0xb0, 0xa9, 0x0a
};
/* COUNT = 6 */
static const uint8_t nist_kas_ecc_cdh_testvector_182_public_x[] = {
/* QCAVSx */
	0x06, 0x38, 0x80, 0xeb, 0x53, 0x8c, 0x72, 0x75, 0xec, 0xba, 0x4d, 0xb5,
	0x3d, 0x9b, 0x68, 0xc2, 0x87, 0xfb, 0x37, 0x78, 0xbe, 0xf5, 0x14, 0x97,
	0x4d, 0x1e, 0x7e, 0x31, 0xa9, 0xae, 0x36, 0x5a, 0x21, 0x81, 0x41, 0x5f
};
static const uint8_t nist_kas_ecc_cdh_testvector_182_public_y[] = {
/* QCAVSy */
	0x04, 0xaf, 0x9f, 0x2c, 0xf9, 0x25, 0x42, 0xe1, 0xff, 0x8f, 0xf2, 0x8f,
	0x8e, 0x7c, 0x8e, 0x80, 0x95, 0x84, 0xe2, 0x43, 0xa4, 0x90, 0x29, 0x49,
	0xa7, 0x65, 0xa2, 0x84, 0x98, 0x6c, 0x75, 0x0b, 0x1b, 0x06, 0xc8, 0x9a
};
static const uint8_t nist_kas_ecc_cdh_testvector_182_private[] = {
/* dIUT */
	0x00, 0xdb, 0x39, 0xd7, 0x53, 0x60, 0x72, 0xdc, 0x34, 0x48, 0xcd, 0x7d,
	0x21, 0x60, 0xe5, 0x0c, 0x81, 0x1f, 0x64, 0x83, 0x58, 0xeb, 0x0d, 0xb1,
	0xd5, 0x42, 0x8e, 0x81, 0xaa, 0x7a, 0x68, 0x6b, 0x78, 0x65, 0xad, 0xfd
};
/* QIUTx = 03a721906ad13dc15c311fd4e552f3bc87b7d92ceeedbb0c316a952785ba4689fc0ba270 */
/* QIUTy = 029514f3873bbc3b9e217061f7a6261fdc6268685f9656f1d5eea472cc2db5a8c162e6e9 */
static const uint8_t nist_kas_ecc_cdh_testvector_182_out[] = {
/* ZIUT */
	0x05, 0xe3, 0x80, 0x79, 0x81, 0x54, 0x77, 0xb8, 0xa7, 0x90, 0x96, 0xce,
	0x33, 0x9c, 0x4a, 0x25, 0x5f, 0x8b, 0x21, 0x3b, 0xe7, 0x47, 0x15, 0xea,
	0x61, 0xef, 0x7d, 0xd0, 0xc0, 0xb5, 0xf1, 0x61, 0xd9, 0xde, 0x75, 0x21
};
/* COUNT = 7 */
static const uint8_t nist_kas_ecc_cdh_testvector_183_public_x[] = {
/* QCAVSx */
	0x05, 0xbf, 0xd2, 0x89, 0x5a, 0x2e, 0x66, 0x36, 0x6d, 0xb7, 0xa8, 0x37,
	0x88, 0xc7, 0x2b, 0xce, 0x48, 0xf7, 0x9b, 0x5c, 0x95, 0x24, 0xa0, 0x8a,
	0xe2, 0x73, 0xc7, 0x8c, 0xeb, 0x39, 0xae, 0x97, 0x55, 0x9d, 0x5a, 0xc3
};
static const uint8_t nist_kas_ecc_cdh_testvector_183_public_y[] = {
/* QCAVSy */
	0x04, 0xa2, 0xb0, 0xa5, 0x5f, 0x80, 0x15, 0x5a, 0x1a, 0x33, 0x0f, 0xde,
	0x6c, 0xb6, 0xd9, 0x7e, 0xdd, 0xb0, 0xa9, 0xdc, 0xb6, 0x6c, 0x49, 0xb3,
	0x92, 0x90, 0x4a, 0xbe, 0x8b, 0x38, 0x1f, 0x91, 0x09, 0x0d, 0xbb, 0x21
};
static const uint8_t nist_kas_ecc_cdh_testvector_183_private[] = {
/* dIUT */
	0x00, 0x66, 0x49, 0xbf, 0xd6, 0x41, 0xda, 0xbf, 0x1b, 0x9d, 0x49, 0x9d,
	0x4f, 0xb0, 0x4b, 0xeb, 0x09, 0x94, 0x75, 0xd0, 0xaa, 0x15, 0xd5, 0xef,
	0x68, 0x48, 0xb7, 0x34, 0xd2, 0xd4, 0x13, 0x00, 0x8b, 0x60, 0x43, 0x08
};
/* QIUTx = 008f6576d62affc71836d19adbbc3d504210f12efb61c42057824515290c502f2e09b6d8 */
/* QIUTy = 0021643be87ae6e549b0d5fbb558c1303d14b1ccd77703ec74f9602f35ca8d7a5139bce7 */
static const uint8_t nist_kas_ecc_cdh_testvector_183_out[] = {
/* ZIUT */
	0x05, 0x31, 0xcc, 0xf5, 0x1d, 0x10, 0x96, 0x98, 0x2f, 0x7c, 0x2e, 0xc5,
	0x13, 0xa9, 0x2b, 0xf5, 0x1c, 0x7a, 0xc5, 0x06, 0x9c, 0xb1, 0x5c, 0x5e,
	0x2a, 0x05, 0x3c, 0xea, 0xe7, 0xe5, 0x55, 0x09, 0x08, 0xa1, 0x91, 0x01
};
/* COUNT = 8 */
static const uint8_t nist_kas_ecc_cdh_testvector_184_public_x[] = {
/* QCAVSx */
	0x06, 0x35, 0x47, 0xf7, 0x57, 0x0b, 0xd6, 0x95, 0x97, 0x33, 0xc0, 0x3d,
	0x2e, 0x6c, 0x4c, 0x88, 0x97, 0x1f, 0x31, 0x4a, 0xdc, 0xf2, 0x8b, 0xc8,
	0x51, 0xdc, 0x52, 0xed, 0x4e, 0x8c, 0x1a, 0x4e, 0xa0, 0x6f, 0x87, 0x02
};
static const uint8_t nist_kas_ecc_cdh_testvector_184_public_y[] = {
/* QCAVSy */
	0x01, 0x22, 0xd3, 0x77, 0x3b, 0x09, 0x34, 0xe9, 0x00, 0xfb, 0xa7, 0xeb,
	0xfe, 0x1a, 0xd5, 0xed, 0x5b, 0xec, 0x0f, 0xb1, 0xa9, 0xdd, 0xcf, 0x4e,
	0xeb, 0x61, 0xcb, 0xed, 0x04, 0x00, 0x74, 0x31, 0x3c, 0x0b, 0x31, 0x70
};
static const uint8_t nist_kas_ecc_cdh_testvector_184_private[] = {
/* dIUT */
	0x00, 0x81, 0x86, 0x0a, 0x65, 0x3d, 0x6d, 0x94, 0x44, 0x6d, 0x77, 0x66,
	0x16, 0x4f, 0xf9, 0x2c, 0x6c, 0x5c, 0x15, 0x45, 0xc7, 0x35, 0x30, 0x4b,
	0x3a, 0xd4, 0xd5, 0x17, 0x8c, 0x8b, 0x14, 0xd0, 0x18, 0x1e, 0x94, 0x71
};
/* QIUTx = 06b68815bb83691d16749c4be16125e2a6d6dae94252739ba7bf0db0d50198ea2fe43ddf */
/* QIUTy = 039e0d93018a46125620f6ffaca5a0668343c57025a60c31a9d6e51191cab338993b46b5 */
static const uint8_t nist_kas_ecc_cdh_testvector_184_out[] = {
/* ZIUT */
	0x06, 0xff, 0xe7, 0x9d, 0x2b, 0x76, 0x64, 0xee, 0x2d, 0x83, 0x03, 0xff,
	0xe0, 0xce, 0xca, 0x8c, 0x49, 0xa5, 0x81, 0xfc, 0xdb, 0x49, 0xc4, 0xaf,
	0x6a, 0x06, 0x0f, 0xf2, 0x04, 0xee, 0xa7, 0x4f, 0x4c, 0xf3, 0x9c, 0xef
};
/* COUNT = 9 */
static const uint8_t nist_kas_ecc_cdh_testvector_185_public_x[] = {
/* QCAVSx */
	0x00, 0x90, 0x47, 0xf7, 0xd7, 0x73, 0x97, 0xdb, 0x70, 0xe3, 0x9f, 0xe9,
	0xe4, 0xba, 0x9d, 0x97, 0xa9, 0x95, 0xa7, 0xee, 0x06, 0x6e, 0xcf, 0x53,
	0x81, 0x79, 0xe9, 0x37, 0xac, 0x86, 0xca, 0xcd, 0xac, 0x51, 0x09, 0x50
};
static const uint8_t nist_kas_ecc_cdh_testvector_185_public_y[] = {
/* QCAVSy */
	0x00, 0x7c, 0xd8, 0x75, 0x16, 0x7f, 0x06, 0xa2, 0xfb, 0x9a, 0x81, 0x9e,
	0x2c, 0xbd, 0xac, 0xef, 0xc1, 0x6c, 0xae, 0x0e, 0xef, 0x2c, 0xbb, 0x0b,
	0x2d, 0x49, 0xbe, 0xae, 0x10, 0x9d, 0xb7, 0x53, 0xc9, 0x50, 0x61, 0x70
};
static const uint8_t nist_kas_ecc_cdh_testvector_185_private[] = {
/* dIUT */
	0x00, 0x22, 0x43, 0xe8, 0x91, 0x9b, 0xd7, 0xa9, 0x7c, 0xef, 0x0e, 0x9c,
	0xde, 0x63, 0xc7, 0x6d, 0x4e, 0x10, 0x71, 0x50, 0x29, 0x4f, 0xcf, 0x8d,
	0xd7, 0x67, 0x64, 0x51, 0xca, 0x3b, 0xfa, 0x5c, 0x5e, 0xdb, 0x96, 0x4c
};
/* QIUTx = 03e439e3ebdfa7a23a9deb09de141905c653c4f202edf2cf5f09faef88ba3113701e49f0 */
/* QIUTy = 071d071b86ed0f468fc6019de23fe4ba2cb3b50032be35e92d2e5af40de706ab524e82ab */
static const uint8_t nist_kas_ecc_cdh_testvector_185_out[] = {
/* ZIUT */
	0x03, 0x11, 0xc4, 0x30, 0xdb, 0x78, 0xb6, 0x20, 0x3e, 0x27, 0xb5, 0x29,
	0x88, 0xe1, 0xe9, 0xda, 0xe8, 0x90, 0xc6, 0x55, 0xda, 0xc4, 0xac, 0xef,
	0xa7, 0xee, 0x96, 0x12, 0xbe, 0xc3, 0x2e, 0x3e, 0x5f, 0x52, 0xbe, 0x55
};
/* COUNT = 10 */
static const uint8_t nist_kas_ecc_cdh_testvector_186_public_x[] = {
/* QCAVSx */
	0x04, 0xbd, 0xec, 0x19, 0x30, 0x0c, 0x8a, 0xfd, 0xee, 0xd8, 0x64, 0x99,
	0xd2, 0x70, 0x39, 0x22, 0xdf, 0x57, 0xb2, 0xff, 0xec, 0x37, 0xe4, 0x5c,
	0x03, 0xa5, 0xe2, 0x90, 0x9d, 0xe3, 0xc3, 0x33, 0xbd, 0x06, 0xa5, 0xe1
};
static const uint8_t nist_kas_ecc_cdh_testvector_186_public_y[] = {
/* QCAVSy */
	0x01, 0xaa, 0x4f, 0x40, 0x84, 0x4f, 0x24, 0x13, 0xf1, 0xfc, 0xbd, 0xed,
	0x00, 0x3b, 0x1d, 0x15, 0xc9, 0xf1, 0xdf, 0x75, 0x48, 0xde, 0x2a, 0x2b,
	0xbf, 0x71, 0xb5, 0x16, 0x65, 0x7a, 0xd8, 0xd8, 0xc7, 0x7c, 0xf7, 0x2d
};
static const uint8_t nist_kas_ecc_cdh_testvector_186_private[] = {
/* dIUT */
	0x00, 0x51, 0x2a, 0x42, 0x84, 0x1e, 0x12, 0x27, 0xfc, 0x9f, 0xed, 0x51,
	0xc2, 0x26, 0x87, 0x31, 0x68, 0x41, 0x36, 0xf2, 0x25, 0xcf, 0xbf, 0x45,
	0x64, 0x89, 0x87, 0xe2, 0x45, 0x3a, 0x71, 0x86, 0xf6, 0xa7, 0xed, 0xef
};
/* QIUTx = 022f76e5ab714fdf78571e84c2b6ea3a17f12999be483bc67e1b843d209bdfec0347a43e */
/* QIUTy = 02eec1fc0e85f330c53dad7bff4862d8afff8aa14f94756e95b8f01fd7eeb8fc54527787 */
static const uint8_t nist_kas_ecc_cdh_testvector_186_out[] = {
/* ZIUT */
	0x07, 0x01, 0xd9, 0x2e, 0xd8, 0x68, 0x71, 0x38, 0x01, 0x4b, 0x43, 0x79,
	0xf1, 0xc3, 0x46, 0x77, 0xe1, 0x74, 0x4f, 0x6a, 0xe8, 0xc8, 0x99, 0x58,
	0xa5, 0x96, 0x2f, 0x14, 0x40, 0x8d, 0x58, 0x7b, 0x95, 0x47, 0x2d, 0xb3
};
/* COUNT = 11 */
static const uint8_t nist_kas_ecc_cdh_testvector_187_public_x[] = {
/* QCAVSx */
	0x06, 0x11, 0xf5, 0x3a, 0xf4, 0xb4, 0x88, 0x99, 0x0e, 0x7a, 0x52, 0xe5,
	0xc7, 0x38, 0x56, 0xa1, 0xe7, 0x42, 0x79, 0xbb, 0x0f, 0x36, 0xd3, 0xab,
	0x19, 0x89, 0xb2, 0xcc, 0xd9, 0x93, 0x91, 0xb6, 0xc6, 0xb3, 0xa1, 0x3d
};
static const uint8_t nist_kas_ecc_cdh_testvector_187_public_y[] = {
/* QCAVSy */
	0x05, 0x4e, 0xa9, 0x5a, 0x23, 0x4f, 0x65, 0x89, 0x71, 0x95, 0xbc, 0x97,
	0xb0, 0x3f, 0xa6, 0xd2, 0x46, 0xea, 0x5a, 0xb5, 0xf4, 0x1d, 0xa2, 0x2c,
	0x08, 0xed, 0x81, 0x7a, 0xa7, 0xc0, 0x4a, 0xdf, 0x37, 0x29, 0x82, 0xb3
};
static const uint8_t nist_kas_ecc_cdh_testvector_187_private[] = {
/* dIUT */
	0x00, 0x2a, 0x8a, 0xf4, 0x97, 0xd1, 0xa3, 0xda, 0xc0, 0x73, 0x2a, 0x39,
	0x3d, 0xed, 0xf7, 0x53, 0x94, 0xa3, 0xf5, 0x19, 0xce, 0x07, 0xfa, 0xed,
	0x3f, 0x77, 0xdc, 0x0e, 0x66, 0x9f, 0x3a, 0x1b, 0x1c, 0x6d, 0xda, 0xdb
};
/* QIUTx = 0571f0c87f88888ec0738961834021765cc4f5c8db2b1f9ea9b8fe9847f8964349fdc44f */
/* QIUTy = 04ef7c8044a609694746ccaafe87fc7f9f1a78d00f8354f5da7ee2f5da7235ac1ad4b57c */
static const uint8_t nist_kas_ecc_cdh_testvector_187_out[] = {
/* ZIUT */
	0x04, 0xf2, 0x30, 0x1e, 0xd8, 0x5a, 0x5c, 0x91, 0xc3, 0x1a, 0x7f, 0xd1,
	0x25, 0x85, 0x49, 0x04, 0x34, 0x0a, 0x55, 0xe3, 0x49, 0x76, 0xa2, 0x07,
	0x43, 0xbd, 0x33, 0xd9, 0x5e, 0x47, 0x64, 0x50, 0xf3, 0x01, 0xee, 0x62
};
/* COUNT = 12 */
static const uint8_t nist_kas_ecc_cdh_testvector_188_public_x[] = {
/* QCAVSx */
	0x01, 0x27, 0x06, 0xec, 0x0a, 0x0e, 0x76, 0x42, 0x5d, 0x8a, 0xb4, 0xe0,
	0xd5, 0x59, 0x30, 0xa4, 0x41, 0x6e, 0x4d, 0xd0, 0xa1, 0xaf, 0x6d, 0x97,
	0x98, 0x72, 0x52, 0x98, 0x8d, 0xa0, 0xac, 0x96, 0x27, 0x57, 0x7c, 0xbe
};
static const uint8_t nist_kas_ecc_cdh_testvector_188_public_y[] = {
/* QCAVSy */
	0x04, 0x21, 0x5e, 0x87, 0x15, 0x12, 0x9c, 0xc7, 0x63, 0x01, 0x79, 0x17,
	0x01, 0xdc, 0x5f, 0xe1, 0xab, 0xcd, 0x67, 0x2b, 0x6a, 0xa1, 0x9b, 0xa4,
	0xc7, 0xe5, 0x32, 0xee, 0x7a, 0x91, 0x3e, 0xea, 0x60, 0xdb, 0xc9, 0xd0
};
static const uint8_t nist_kas_ecc_cdh_testvector_188_private[] = {
/* dIUT */
	0x01, 0xde, 0x9f, 0xba, 0x4a, 0xb2, 0x4d, 0x06, 0xe7, 0x4a, 0xe5, 0xad,
	0x36, 0xae, 0x19, 0x5c, 0x23, 0x60, 0xc7, 0x28, 0xeb, 0x38, 0xc5, 0x0e,
	0xf5, 0x33, 0x32, 0x9e, 0x70, 0xc5, 0xae, 0x19, 0xf4, 0x89, 0xb6, 0xd5
};
/* QIUTx = 048d61e0b9b8064bcca8ce40d4f9e68b23684137726a44ea75c8f2f8850f0333fbe985e6 */
/* QIUTy = 05fcaba38d51e2112b6b9f34e6779c10c0c559c3ecd156022966cf92a8c7f65020a79ebd */
static const uint8_t nist_kas_ecc_cdh_testvector_188_out[] = {
/* ZIUT */
	0x06, 0x43, 0x90, 0x0f, 0x33, 0x7e, 0xd3, 0x62, 0x81, 0x5f, 0x18, 0x1e,
	0x06, 0x28, 0xed, 0x51, 0x84, 0xda, 0xd3, 0xe6, 0x6a, 0x1f, 0x03, 0x0e,
	0x94, 0x7f, 0x11, 0x66, 0x96, 0x31, 0x2d, 0x83, 0x5f, 0x7f, 0x6e, 0x7b
};
/* COUNT = 13 */
static const uint8_t nist_kas_ecc_cdh_testvector_189_public_x[] = {
/* QCAVSx */
	0x05, 0xbb, 0x20, 0xbe, 0xa4, 0xfd, 0x85, 0xd0, 0x16, 0x26, 0x89, 0xc5,
	0x50, 0x05, 0x40, 0x01, 0x40, 0x9b, 0x6c, 0x71, 0x2d, 0x35, 0x6a, 0x52,
	0xf7, 0x93, 0xd7, 0x8a, 0xa2, 0xd8, 0x26, 0x1a, 0x43, 0xc5, 0xb6, 0xde
};
static const uint8_t nist_kas_ecc_cdh_testvector_189_public_y[] = {
/* QCAVSy */
	0x03, 0x1b, 0xe5, 0xca, 0xfc, 0x8a, 0xae, 0xf1, 0x9b, 0x86, 0x15, 0x03,
	0x41, 0x3a, 0x7b, 0x73, 0xb6, 0x0b, 0x37, 0xb0, 0x18, 0x04, 0x93, 0xd8,
	0x2e, 0x94, 0x26, 0xf4, 0x7b, 0x65, 0x87, 0x39, 0x3d, 0x08, 0xde, 0x08
};
static const uint8_t nist_kas_ecc_cdh_testvector_189_private[] = {
/* dIUT */
	0x01, 0x5d, 0x3a, 0x22, 0x2d, 0x57, 0x09, 0xcb, 0x33, 0x9d, 0x93, 0xcd,
	0x29, 0x65, 0x06, 0x64, 0xf3, 0x9b, 0xf3, 0x20, 0x1c, 0x5d, 0x1e, 0x86,
	0xd3, 0xae, 0xf8, 0xf7, 0x95, 0xb9, 0xfd, 0xdf, 0x47, 0xd8, 0xc4, 0xa8
};
/* QIUTx = 01e2b88de3772b09c63d036e0dbba435246987497b6283dab8ccf1002486de0730277b43 */
/* QIUTy = 03ce182b7f0cea21a06a1d4de8722cbfc59b9d9d79bc760b9d17d85671561aeaadd54941 */
static const uint8_t nist_kas_ecc_cdh_testvector_189_out[] = {
/* ZIUT */
	0x06, 0x3b, 0x1a, 0x3d, 0xb3, 0x31, 0xf9, 0x1a, 0xbd, 0x0a, 0xf8, 0x37,
	0xdb, 0x9d, 0x5f, 0x04, 0x06, 0x20, 0xd1, 0xdd, 0xd7, 0xfc, 0xcf, 0x8b,
	0x58, 0xe0, 0xdf, 0x43, 0x69, 0x83, 0x51, 0xea, 0x19, 0x42, 0x54, 0x8e
};
/* COUNT = 14 */
static const uint8_t nist_kas_ecc_cdh_testvector_190_public_x[] = {
/* QCAVSx */
	0x01, 0x0a, 0x3c, 0xa2, 0x43, 0x5b, 0x13, 0x5f, 0xfe, 0xa0, 0x87, 0x92,
	0xb7, 0xf1, 0x9b, 0x4e, 0xe1, 0x81, 0x20, 0x7c, 0x29, 0xbe, 0x1c, 0xe1,
	0xfd, 0xea, 0xcd, 0xb6, 0x9a, 0x66, 0x9f, 0x9c, 0xdd, 0xe9, 0x18, 0x1a
};
static const uint8_t nist_kas_ecc_cdh_testvector_190_public_y[] = {
/* QCAVSy */
	0x02, 0x49, 0x08, 0x27, 0x4b, 0x1e, 0x98, 0xc6, 0xd1, 0x97, 0xed, 0x27,
	0x83, 0xc3, 0xc9, 0x53, 0xc1, 0xb3, 0xb3, 0x4f, 0xa4, 0x3a, 0x8b, 0x2f,
	0x57, 0x42, 0x58, 0x4e, 0x37, 0xfe, 0xa4, 0x07, 0x26, 0x9b, 0x43, 0xbf
};
static const uint8_t nist_kas_ecc_cdh_testvector_190_private[] = {
/* dIUT */
	0x00, 0x98, 0xc5, 0x70, 0x66, 0x67, 0x92, 0xef, 0xda, 0x65, 0xfc, 0x9e,
	0x79, 0x09, 0x93, 0x11, 0x58, 0xdf, 0xd4, 0x47, 0x7b, 0xe9, 0x33, 0x32,
	0xe4, 0x93, 0xd6, 0x98, 0x66, 0xb6, 0x60, 0x2c, 0x49, 0x51, 0xde, 0x6f
};
/* QIUTx = 04dc6774fe46ab0ed2768d379e7564a37c6bb1dd1bfc555727ad94c20f4732cabf2a2c82 */
/* QIUTy = 06c6cf0f421f91fca22b4871216a9f1fe3878f07914e96ae94ac770b6762f9dce08ffa2d */
static const uint8_t nist_kas_ecc_cdh_testvector_190_out[] = {
/* ZIUT */
	0x05, 0x16, 0xda, 0x1d, 0x64, 0xbc, 0x4b, 0x25, 0xce, 0x47, 0x63, 0xe6,
	0x43, 0x82, 0x57, 0xd6, 0x2f, 0xb1, 0xff, 0xde, 0xae, 0x16, 0xd6, 0x87,
	0x01, 0xd6, 0x3b, 0x60, 0x3a, 0xd5, 0x3e, 0x85, 0x87, 0x92, 0x76, 0x69
};
/* COUNT = 15 */
static const uint8_t nist_kas_ecc_cdh_testvector_191_public_x[] = {
/* QCAVSx */
	0x05, 0x3a, 0x0d, 0xd6, 0x13, 0x5e, 0x43, 0xa1, 0x14, 0xe5, 0x00, 0x0a,
	0xec, 0x40, 0xba, 0x27, 0x09, 0xb3, 0xa6, 0x13, 0x73, 0x0f, 0x1c, 0xc2,
	0x00, 0x6b, 0x44, 0x69, 0x35, 0xe2, 0x37, 0xbf, 0xcc, 0xc3, 0x94, 0xd8
};
static const uint8_t nist_kas_ecc_cdh_testvector_191_public_y[] = {
/* QCAVSy */
	0x03, 0xb6, 0x6c, 0xe6, 0xcf, 0x01, 0x50, 0x7d, 0x46, 0x2e, 0xee, 0xff,
	0xf6, 0x21, 0x1b, 0xd4, 0xc5, 0x60, 0x70, 0x11, 0x6c, 0x69, 0x07, 0x46,
	0x8f, 0x7c, 0x76, 0xfe, 0x01, 0x14, 0x0b, 0xf0, 0xd5, 0xfb, 0x7b, 0x79
};
static const uint8_t nist_kas_ecc_cdh_testvector_191_private[] = {
/* dIUT */
	0x00, 0xf4, 0xb6, 0xdb, 0x4a, 0x87, 0xcd, 0xd3, 0x00, 0x29, 0xcc, 0x3b,
	0xe8, 0x9e, 0x40, 0xb9, 0xbc, 0xb0, 0x14, 0xd0, 0x10, 0xa9, 0x1a, 0x25,
	0x2c, 0x56, 0xcb, 0x28, 0x67, 0x1f, 0x35, 0x4a, 0x80, 0x4c, 0xb4, 0xd8
};
/* QIUTx = 066ddf04831fd1c72bc48b709061c1aeaaad19c9da3d8c1506fa775d4f5a5412eee0286d */
/* QIUTy = 03aa1d13146ff192792b74a5c64ad3150fae344fa830e0f44733d867f4e0ae053526c62b */
static const uint8_t nist_kas_ecc_cdh_testvector_191_out[] = {
/* ZIUT */
	0x04, 0x9c, 0x68, 0xc3, 0x33, 0xb9, 0x67, 0x05, 0xee, 0xe4, 0xa3, 0xde,
	0xf0, 0xd5, 0x68, 0xb0, 0xd4, 0xfa, 0xf2, 0x4d, 0xf2, 0xfc, 0x2f, 0x1b,
	0xf4, 0x0d, 0xa0, 0xaf, 0x09, 0x46, 0x24, 0x0c, 0x38, 0xe9, 0x7f, 0x74
};
/* COUNT = 16 */
static const uint8_t nist_kas_ecc_cdh_testvector_192_public_x[] = {
/* QCAVSx */
	0x06, 0xd4, 0xa6, 0xf3, 0xe8, 0x7b, 0x6d, 0x8c, 0x49, 0xcb, 0xe5, 0x17,
	0xa9, 0x75, 0xd2, 0xab, 0x8c, 0x63, 0x39, 0x13, 0x55, 0x96, 0xd6, 0xb3,
	0x0c, 0xc6, 0x5c, 0xc8, 0x0c, 0x12, 0x84, 0x50, 0x8f, 0x49, 0x78, 0x9b
};
static const uint8_t nist_kas_ecc_cdh_testvector_192_public_y[] = {
/* QCAVSy */
	0x02, 0x96, 0x3b, 0x35, 0x6f, 0x24, 0x34, 0xec, 0x24, 0x9b, 0xcb, 0x65,
	0x89, 0xed, 0xe4, 0xde, 0x36, 0xce, 0xcd, 0x34, 0x50, 0xe6, 0xf5, 0xe4,
	0x77, 0xbf, 0xcd, 0xc2, 0x9a, 0xda, 0x4a, 0xef, 0x0f, 0x45, 0xac, 0x53
};
static const uint8_t nist_kas_ecc_cdh_testvector_192_private[] = {
/* dIUT */
	0x01, 0xab, 0x82, 0xc5, 0xa6, 0x2a, 0xe4, 0x7e, 0xcb, 0xcc, 0xf6, 0x66,
	0xcc, 0x33, 0x23, 0xb3, 0x51, 0x28, 0xc5, 0x2d, 0x17, 0xbe, 0x11, 0xba,
	0xf3, 0xbd, 0xb5, 0x60, 0x06, 0xe5, 0xd5, 0x68, 0xba, 0xad, 0x8b, 0xbc
};
/* QIUTx = 00a04ad7a583666a40437f968b02cac7946745b4ca949021c5443deb70183f88e1778fe0 */
/* QIUTy = 02bb591c32f0db3430342f0e37c45449c293c54f6b7df6f797c0992c2829858b680f2bdc */
static const uint8_t nist_kas_ecc_cdh_testvector_192_out[] = {
/* ZIUT */
	0x04, 0xdd, 0x44, 0xc1, 0xa3, 0x0e, 0xda, 0xc2, 0xe3, 0x9a, 0x5b, 0xc9,
	0x90, 0x26, 0x25, 0x88, 0x0a, 0x18, 0x51, 0x63, 0x85, 0xc9, 0x0a, 0x9c,
	0xc6, 0xb9, 0x4c, 0x4f, 0x11, 0x1e, 0x02, 0x60, 0x86, 0x3c, 0xca, 0xb2
};
/* COUNT = 17 */
static const uint8_t nist_kas_ecc_cdh_testvector_193_public_x[] = {
/* QCAVSx */
	0x07, 0x64, 0x52, 0xe1, 0x9d, 0x7a, 0x10, 0xb8, 0x85, 0x12, 0x3d, 0x50,
	0x3f, 0x5d, 0x04, 0x33, 0xe1, 0x63, 0xdf, 0x13, 0x4f, 0xff, 0xb8, 0x55,
	0x8f, 0x8a, 0xc2, 0x6c, 0xfb, 0x30, 0x62, 0x9f, 0x8c, 0xfb, 0x09, 0x3e
};
static const uint8_t nist_kas_ecc_cdh_testvector_193_public_y[] = {
/* QCAVSy */
	0x06, 0xb3, 0xa2, 0x4b, 0x2a, 0x4b, 0x07, 0x77, 0x70, 0xd3, 0x96, 0xbb,
	0xf1, 0x54, 0xaf, 0x41, 0xee, 0xe3, 0x50, 0x35, 0x73, 0xa6, 0xde, 0x9a,
	0xfe, 0x0f, 0x6d, 0x18, 0xb0, 0x2f, 0xc9, 0x76, 0x1c, 0xa1, 0x64, 0x3d
};
static const uint8_t nist_kas_ecc_cdh_testvector_193_private[] = {
/* dIUT */
	0x00, 0x12, 0x54, 0xaf, 0x17, 0x91, 0xcc, 0x75, 0x69, 0x4c, 0xe5, 0x90,
	0xbb, 0x51, 0x8a, 0x77, 0x0a, 0x75, 0x04, 0x46, 0x17, 0x1a, 0x30, 0xed,
	0xd6, 0xc0, 0x38, 0x2a, 0x17, 0xe6, 0x88, 0x0a, 0x1a, 0xea, 0x5b, 0x81
};
/* QIUTx = 02b766c993b398d2426a7a0a49e9d001079d0fc32197181c56eac1805e4f87c9df055dea */
/* QIUTy = 036e7bbd3be9139d4d43a8655ef7d51a062d9947d1a48010ef1ea10eedeb27f0d1ffe765 */
static const uint8_t nist_kas_ecc_cdh_testvector_193_out[] = {
/* ZIUT */
	0x00, 0x49, 0xc1, 0x65, 0x33, 0x9e, 0x9a, 0xeb, 0x2b, 0x51, 0x66, 0x84,
	0xb4, 0x42, 0x92, 0x1f, 0x1f, 0xef, 0x30, 0x91, 0xcf, 0x78, 0x1e, 0x03,
	0xfb, 0x3f, 0x56, 0xe9, 0x3a, 0xf1, 0xf3, 0xd6, 0xe5, 0x00, 0xc8, 0x1f
};
/* COUNT = 18 */
static const uint8_t nist_kas_ecc_cdh_testvector_194_public_x[] = {
/* QCAVSx */
	0x01, 0x8e, 0x0b, 0xb7, 0x51, 0x6d, 0x2c, 0x42, 0xe9, 0xdd, 0x96, 0xca,
	0xaf, 0xf5, 0xf2, 0x0b, 0xfd, 0xdf, 0x3e, 0x86, 0x23, 0xfc, 0x94, 0x7d,
	0x4d, 0x70, 0x49, 0x15, 0x36, 0x79, 0x0b, 0x87, 0x41, 0xcd, 0xd3, 0x72
};
static const uint8_t nist_kas_ecc_cdh_testvector_194_public_y[] = {
/* QCAVSy */
	0x03, 0x2c, 0x0f, 0xff, 0xbd, 0xa2, 0xfa, 0x86, 0x3c, 0xb9, 0xd1, 0x5c,
	0x36, 0x54, 0x50, 0x20, 0xd5, 0xbb, 0x24, 0xd9, 0x30, 0xda, 0xf2, 0xfe,
	0xa4, 0x55, 0x5f, 0x7c, 0x24, 0xd6, 0xae, 0xfb, 0xb2, 0xc0, 0x1d, 0x92
};
static const uint8_t nist_kas_ecc_cdh_testvector_194_private[] = {
/* dIUT */
	0x01, 0x20, 0x17, 0xb9, 0xa0, 0x59, 0x9f, 0xbf, 0x13, 0xce, 0xe1, 0x08,
	0x50, 0xa8, 0xf8, 0xbd, 0x06, 0xcc, 0xc0, 0x0b, 0xd2, 0x9a, 0xc6, 0x77,
	0x9f, 0x1b, 0xd9, 0x33, 0x46, 0xb2, 0x2c, 0x98, 0x32, 0x7e, 0x0f, 0xa7
};
/* QIUTx = 0421c62dcab54ba800eafac232fc730ce70f6d5cc53ff53d371269cf046daeaf451b33e7 */
/* QIUTy = 03d635f55233da3c490a959c6e63a94fcdbe471fbfca19d2c5a3fd12b04db380c3c895cc */
static const uint8_t nist_kas_ecc_cdh_testvector_194_out[] = {
/* ZIUT */
	0x06, 0x45, 0xd7, 0xf4, 0xc5, 0x47, 0x9b, 0xaf, 0xf5, 0xbc, 0x0c, 0xba,
	0x65, 0x4a, 0x3d, 0xcf, 0xda, 0x56, 0xc0, 0xe9, 0xd1, 0x9f, 0x50, 0xf9,
	0xd8, 0xd8, 0xc6, 0x35, 0x7c, 0x09, 0xa1, 0x40, 0xef, 0xfb, 0xf2, 0x23
};
/* COUNT = 19 */
static const uint8_t nist_kas_ecc_cdh_testvector_195_public_x[] = {
/* QCAVSx */
	0x02, 0x4a, 0xbb, 0x15, 0x5e, 0x49, 0x12, 0x42, 0x82, 0xea, 0x32, 0xe5,
	0xb5, 0x44, 0x62, 0x1a, 0xe9, 0xb5, 0x13, 0xaa, 0x04, 0x76, 0xda, 0x3b,
	0xdd, 0xb7, 0x52, 0x60, 0xd5, 0xf5, 0xfa, 0x2e, 0x7b, 0x89, 0x89, 0x87
};
static const uint8_t nist_kas_ecc_cdh_testvector_195_public_y[] = {
/* QCAVSy */
	0x01, 0xbd, 0xfb, 0x0a, 0x07, 0x9a, 0x55, 0xbc, 0xfc, 0xe1, 0xca, 0x8b,
	0xce, 0x30, 0x19, 0xcb, 0xca, 0xe6, 0x16, 0x40, 0x03, 0x38, 0x41, 0x66,
	0xeb, 0xbb, 0x0b, 0xb7, 0x33, 0x53, 0x95, 0x65, 0xad, 0xc4, 0x46, 0xf3
};
static const uint8_t nist_kas_ecc_cdh_testvector_195_private[] = {
/* dIUT */
	0x00, 0x4f, 0x19, 0x7c, 0x85, 0x43, 0x2c, 0xb4, 0x2a, 0x17, 0x77, 0x24,
	0x9a, 0xe4, 0x11, 0xef, 0x4b, 0xb2, 0x65, 0x7b, 0xa4, 0xba, 0xd3, 0x5a,
	0xe5, 0x38, 0x63, 0x5a, 0x15, 0x1c, 0x8d, 0x6a, 0x56, 0x4f, 0x9c, 0xca
};
/* QIUTx = 040c88924d5a24a853fae408aea5b3bc827d7315fbb58e6ea1f6a65677dd4c4d304bd75f */
/* QIUTy = 054b82869ada4433f7208f8570f24f06cb64046e8ac086ac57d3707fc882c6352733dff6 */
static const uint8_t nist_kas_ecc_cdh_testvector_195_out[] = {
/* ZIUT */
	0x02, 0x80, 0x17, 0xc2, 0xa0, 0x24, 0x0f, 0xd7, 0x46, 0xee, 0x72, 0xa0,
	0xbc, 0xae, 0x1e, 0x53, 0xe0, 0x5b, 0x7a, 0xf2, 0x54, 0x29, 0x80, 0x94,
	0xc3, 0x81, 0xe7, 0x35, 0x52, 0x38, 0x54, 0xea, 0x5f, 0xdd, 0x4f, 0x5c
};
/* COUNT = 20 */
static const uint8_t nist_kas_ecc_cdh_testvector_196_public_x[] = {
/* QCAVSx */
	0x07, 0x52, 0x75, 0x12, 0xbc, 0x93, 0x49, 0x38, 0xcc, 0x52, 0x40, 0xce,
	0x70, 0xef, 0x65, 0x22, 0x2d, 0xb8, 0x5c, 0x13, 0xc9, 0x61, 0xc1, 0xf3,
	0x1f, 0x91, 0x42, 0x05, 0x06, 0x7d, 0x64, 0xb1, 0xa4, 0xc8, 0x53, 0x14
};
static const uint8_t nist_kas_ecc_cdh_testvector_196_public_y[] = {
/* QCAVSy */
	0x02, 0xaa, 0xbd, 0xb8, 0x1f, 0xfe, 0xd2, 0xc0, 0x01, 0xac, 0xbb, 0x4d,
	0x0b, 0x7b, 0xe5, 0x39, 0x30, 0x4e, 0x32, 0xe4, 0x31, 0xe0, 0x2d, 0xf8,
	0xb1, 0x92, 0xad, 0x74, 0xed, 0x1b, 0x4b, 0x06, 0x06, 0xbf, 0xc9, 0x0b
};
static const uint8_t nist_kas_ecc_cdh_testvector_196_private[] = {
/* dIUT */
	0x01, 0x4e, 0x89, 0x34, 0x83, 0xd1, 0xd8, 0xb7, 0x62, 0x1c, 0xf4, 0x8b,
	0xd2, 0x4b, 0xc8, 0xa1, 0xb9, 0x5b, 0xb4, 0x0a, 0x08, 0xc1, 0x6c, 0x32,
	0x87, 0x4a, 0x65, 0x2b, 0x59, 0xa2, 0x25, 0x21, 0x39, 0x42, 0x8d, 0xac
};
/* QIUTx = 01574e17ce26311c40abf3243f4889a2eae74a8341aa7838551056f4395b8f02bdc327be */
/* QIUTy = 0086e59f985348f3f8d7953800b1d75e141521249c43fe0616913db5d1d4bd5400abce55 */
static const uint8_t nist_kas_ecc_cdh_testvector_196_out[] = {
/* ZIUT */
	0x02, 0x60, 0x3c, 0x00, 0x99, 0x8d, 0xeb, 0xa5, 0x2d, 0xb1, 0x28, 0x14,
	0xb1, 0xf7, 0x7b, 0x21, 0x20, 0xcb, 0xc1, 0xdc, 0xa5, 0x90, 0x09, 0xc0,
	0xd6, 0xea, 0x40, 0xdc, 0xbc, 0xab, 0xca, 0x32, 0xc5, 0x03, 0x80, 0xd8
};
/* COUNT = 21 */
static const uint8_t nist_kas_ecc_cdh_testvector_197_public_x[] = {
/* QCAVSx */
	0x07, 0xec, 0x29, 0xda, 0x2f, 0x30, 0x4c, 0xeb, 0xa8, 0xd5, 0xe2, 0x49,
	0xeb, 0x60, 0x54, 0xa4, 0xe4, 0xf5, 0x95, 0x34, 0xee, 0x59, 0xd2, 0x5c,
	0x1d, 0xc0, 0xe1, 0x2c, 0xc3, 0x8f, 0x76, 0x8b, 0x83, 0xda, 0xff, 0xee
};
static const uint8_t nist_kas_ecc_cdh_testvector_197_public_y[] = {
/* QCAVSy */
	0x01, 0x12, 0xc7, 0xd4, 0xa3, 0x7f, 0xec, 0x84, 0x22, 0x71, 0xa0, 0xa8,
	0x22, 0xd3, 0x76, 0x37, 0xe6, 0xed, 0x55, 0x19, 0x07, 0x13, 0x00, 0x1a,
	0xef, 0xe1, 0x1b, 0x06, 0xf7, 0xe1, 0xd3, 0x4e, 0x00, 0xfc, 0xde, 0xcb
};
static const uint8_t nist_kas_ecc_cdh_testvector_197_private[] = {
/* dIUT */
	0x01, 0xeb, 0x6f, 0x6c, 0x91, 0xa8, 0x80, 0xa5, 0x46, 0x21, 0x85, 0xc6,
	0xa7, 0x00, 0xe8, 0x63, 0x7b, 0x8f, 0x44, 0x7d, 0x09, 0xd1, 0xb2, 0x51,
	0x46, 0x0f, 0xe5, 0x7f, 0x1b, 0xf4, 0x62, 0xef, 0xdd, 0xdd, 0xae, 0xc0
};
/* QIUTx = 031b3026104388374cfb7c7b4ef64211a47e20b9561a3bbca53516040b7bda2837309454 */
/* QIUTy = 024f8aeb23a35e1c22225967c7911868c84efdd873dbbccbc763ead67e72a2324aa4c6f2 */
static const uint8_t nist_kas_ecc_cdh_testvector_197_out[] = {
/* ZIUT */
	0x02, 0x6a, 0x71, 0x9b, 0xff, 0x31, 0xda, 0x4b, 0x4e, 0xba, 0xed, 0x7b,
	0xd0, 0x43, 0x06, 0x4f, 0x9c, 0x39, 0x30, 0xb5, 0x77, 0x4c, 0x4a, 0x99,
	0x80, 0x93, 0x32, 0xc8, 0x08, 0xaa, 0xcb, 0xa4, 0xb9, 0xe3, 0x73, 0x3a
};
/* COUNT = 22 */
static const uint8_t nist_kas_ecc_cdh_testvector_198_public_x[] = {
/* QCAVSx */
	0x06, 0x1e, 0xf5, 0x93, 0x89, 0xed, 0xf8, 0xf8, 0x27, 0x3a, 0x66, 0x2a,
	0x41, 0x95, 0x41, 0x1e, 0x94, 0x48, 0xbb, 0x1b, 0x77, 0xfb, 0x08, 0x00,
	0xbe, 0x52, 0x5e, 0xb5, 0xa6, 0xa0, 0x3b, 0x19, 0x66, 0x57, 0x19, 0xa9
};
static const uint8_t nist_kas_ecc_cdh_testvector_198_public_y[] = {
/* QCAVSy */
	0x02, 0x96, 0x86, 0xf8, 0x47, 0x7f, 0xb5, 0xc7, 0x69, 0xef, 0xb0, 0x82,
	0xcb, 0x3f, 0x1a, 0x0c, 0x79, 0xdb, 0x55, 0xcb, 0x26, 0x4e, 0x21, 0x12,
	0xc0, 0xe7, 0x79, 0xe7, 0xb5, 0x58, 0xf7, 0x00, 0x45, 0x81, 0x6a, 0x10
};
static const uint8_t nist_kas_ecc_cdh_testvector_198_private[] = {
/* dIUT */
	0x01, 0x47, 0xbe, 0x4e, 0x38, 0x66, 0x7e, 0x32, 0xa6, 0xa6, 0x1a, 0xb9,
	0x80, 0xce, 0xd9, 0x2e, 0x42, 0x69, 0x59, 0x25, 0xb1, 0x13, 0xc6, 0x94,
	0xa7, 0x96, 0x0a, 0xed, 0xea, 0x2e, 0x1d, 0x57, 0x1a, 0x42, 0xd3, 0xde
};
/* QIUTx = 06f599f0c149457a32f1a2ffabd4dff916259382912b6402b50cdf5c235fdd1b790e5eaf */
/* QIUTy = 04ccf1d8a4bfeb77ff3290e65ac601ee5b97fc1b1869a2eb9f0b76277e8066c086776c40 */
static const uint8_t nist_kas_ecc_cdh_testvector_198_out[] = {
/* ZIUT */
	0x04, 0x8c, 0x48, 0xc9, 0x93, 0x04, 0x06, 0x19, 0x53, 0x6f, 0x45, 0x48,
	0x2c, 0x49, 0x4a, 0x39, 0xb3, 0x2e, 0x75, 0xfe, 0x69, 0xe4, 0x78, 0xba,
	0x06, 0xe3, 0x76, 0x22, 0x8b, 0x79, 0xeb, 0x83, 0xd3, 0xff, 0x91, 0x68
};
/* COUNT = 23 */
static const uint8_t nist_kas_ecc_cdh_testvector_199_public_x[] = {
/* QCAVSx */
	0x07, 0x9d, 0x57, 0x60, 0xee, 0x6e, 0xf9, 0x78, 0x51, 0x8b, 0xbc, 0xe5,
	0x36, 0xb0, 0x31, 0xc6, 0x55, 0xa8, 0xac, 0xf5, 0x60, 0x44, 0x97, 0xba,
	0x43, 0xde, 0x0b, 0xeb, 0x68, 0x77, 0xa5, 0x47, 0xc3, 0xed, 0xd4, 0x58
};
static const uint8_t nist_kas_ecc_cdh_testvector_199_public_y[] = {
/* QCAVSy */
	0x04, 0x21, 0xb3, 0x05, 0x1d, 0xd3, 0x63, 0x96, 0xd2, 0x0f, 0xfc, 0xd7,
	0xcf, 0x34, 0xfc, 0xa0, 0x22, 0x51, 0x6d, 0xd4, 0xbf, 0xfa, 0xc7, 0x3f,
	0xc9, 0x95, 0xae, 0x9e, 0xa8, 0x14, 0xce, 0x0e, 0x40, 0x27, 0xf7, 0xc6
};
static const uint8_t nist_kas_ecc_cdh_testvector_199_private[] = {
/* dIUT */
	0x01, 0xe1, 0x90, 0x0b, 0xe6, 0x1a, 0xdb, 0x7e, 0x55, 0x55, 0x9d, 0x99,
	0xa0, 0xb7, 0xd9, 0x35, 0x44, 0x56, 0xf5, 0x15, 0x1e, 0x2f, 0xd7, 0xb8,
	0x3c, 0x00, 0x5b, 0x10, 0xb1, 0x60, 0x04, 0xeb, 0xe8, 0x76, 0xc0, 0x68
};
/* QIUTx = 042ecc99ff48b53f6619b484af8fa59b234a981c9c3e9107bbd1cdaacce81885d06e02a9 */
/* QIUTy = 0183da0d7fee7f3e70e117f0e8a4a742cad10aefcdc4aab9bb31458237686afb4facf3a9 */
static const uint8_t nist_kas_ecc_cdh_testvector_199_out[] = {
/* ZIUT */
	0x05, 0xd8, 0x5b, 0x16, 0xbb, 0x2a, 0x0d, 0x32, 0xc7, 0x3d, 0x14, 0x02,
	0x83, 0x8b, 0xdf, 0xa5, 0x12, 0xd7, 0x44, 0xfa, 0x88, 0xc7, 0x4d, 0x3d,
	0x90, 0xcf, 0x71, 0x4c, 0x24, 0x80, 0xe0, 0x33, 0x63, 0xd5, 0xc6, 0xec
};
/* COUNT = 24 */
static const uint8_t nist_kas_ecc_cdh_testvector_200_public_x[] = {
/* QCAVSx */
	0x02, 0x47, 0x84, 0xd3, 0xd3, 0xd5, 0xe8, 0x02, 0x1f, 0xfe, 0xd8, 0xa2,
	0x70, 0x9a, 0x9f, 0x54, 0xd5, 0x39, 0x5d, 0x98, 0xfa, 0x44, 0x2a, 0x65,
	0x5a, 0x05, 0xdd, 0x94, 0x26, 0x2b, 0x60, 0x35, 0x96, 0xf8, 0xbf, 0xf1
};
static const uint8_t nist_kas_ecc_cdh_testvector_200_public_y[] = {
/* QCAVSy */
	0x03, 0xe8, 0xe3, 0x9e, 0x08, 0xcc, 0xe5, 0x5e, 0x1b, 0xed, 0x2d, 0xfe,
	0x0d, 0x2f, 0x8c, 0x14, 0x1b, 0x06, 0x40, 0x1d, 0xba, 0x03, 0x7e, 0xcb,
	0x38, 0x47, 0x44, 0x93, 0x0c, 0x81, 0x78, 0xd1, 0x46, 0x41, 0x63, 0x24
};
static const uint8_t nist_kas_ecc_cdh_testvector_200_private[] = {
/* dIUT */
	0x00, 0x77, 0xe4, 0x1a, 0xb2, 0xd0, 0x9c, 0x34, 0xc5, 0x88, 0xab, 0xc7,
	0x6d, 0x43, 0x12, 0x60, 0x2e, 0x71, 0xf6, 0x00, 0x19, 0x02, 0x7b, 0x98,
	0x6e, 0x0d, 0xed, 0x37, 0x25, 0x35, 0xc2, 0xb6, 0xa9, 0x33, 0xa5, 0x33
};
/* QIUTx = 02923323f170074222d3a6a287adafd3d1fe12715d57b91b1ff476a2b4fcc385de261ecc */
/* QIUTy = 04cc498d67c6267cc7c4c2d40a56cdc2a6e715edd8b2a9614eeb33d0b6fd162cbb85a714 */
static const uint8_t nist_kas_ecc_cdh_testvector_200_out[] = {
/* ZIUT */
	0x06, 0x6a, 0xbb, 0x83, 0x8b, 0x5f, 0x12, 0xb6, 0xfc, 0x15, 0xce, 0xb7,
	0x45, 0x60, 0x06, 0x86, 0xbc, 0x2d, 0x57, 0x73, 0xe5, 0x34, 0x69, 0xc2,
	0xee, 0x92, 0x0c, 0xfb, 0xa5, 0x45, 0x9a, 0x1c, 0xab, 0x20, 0xd1, 0x53
};
/* [K-409] - GP NOT SUPPORTED */
/* COUNT = 0 */
static const uint8_t nist_kas_ecc_cdh_testvector_201_public_x[] = {
/* QCAVSx */
	0x01, 0x77, 0xf7, 0x36, 0xf6, 0x11, 0x63, 0x20, 0xca, 0xfb, 0xb5, 0xb4,
	0xde, 0xc2, 0x02, 0xd4, 0x05, 0x08, 0x18, 0x2f, 0xe0, 0x11, 0x18, 0x9b,
	0x81, 0xe1, 0xf3, 0x99, 0x8f, 0x54, 0x08, 0x60, 0x7a, 0x46, 0xbb, 0x15,
	0x0a, 0xc4, 0x7b, 0xca, 0xaa, 0xfd, 0xe4, 0x7b, 0x8a, 0x7b, 0x72, 0xf4,
	0x78, 0xbc, 0x22, 0xd2
};
static const uint8_t nist_kas_ecc_cdh_testvector_201_public_y[] = {
/* QCAVSy */
	0x01, 0xdf, 0x4e, 0xf4, 0xb3, 0x7e, 0x01, 0x24, 0xe5, 0x5b, 0x67, 0xf3,
	0x58, 0x6d, 0xe2, 0x4a, 0x88, 0xa6, 0xc5, 0xd9, 0x88, 0x54, 0x00, 0x7d,
	0x4b, 0x0c, 0x4b, 0x4c, 0xcd, 0x68, 0xd5, 0x1f, 0xaf, 0xa7, 0x63, 0x8b,
	0xbe, 0x55, 0x5d, 0x60, 0xb7, 0x4d, 0xef, 0x21, 0x7c, 0x6a, 0x63, 0xc5,
	0xb4, 0x06, 0x8f, 0xb7
};
static const uint8_t nist_kas_ecc_cdh_testvector_201_private[] = {
/* dIUT */
	0x00, 0x08, 0x4b, 0x71, 0x1e, 0x3c, 0x60, 0x82, 0x2e, 0x70, 0xfa, 0x68,
	0x28, 0xb5, 0xab, 0xfb, 0x0e, 0x44, 0x88, 0x88, 0xb3, 0x5b, 0x0c, 0x8b,
	0xb0, 0x9f, 0x80, 0x66, 0x16, 0xdc, 0x1e, 0xcf, 0x22, 0xdd, 0x86, 0x23,
	0x7d, 0x93, 0x7c, 0x1b, 0xfd, 0xe6, 0x2b, 0x75, 0xae, 0x65, 0x59, 0x53,
	0xfc, 0x6b, 0x2f, 0x7e
};
/* QIUTx = 0068a3f8b12e02d10e2f52095526bc4048b8f6ac3a84531772870789938f1aeff813e05e509ea9587d2b7e4aa14344bac3ec46f0 */
/* QIUTy = 00d1ceb40c7d5f3297e2955f0f3eb1422b3e6bbbfbf7eb518b9c17ae8d40feb84aaf36f5e5bd96075b2b4dbe538ac011962ac705 */
static const uint8_t nist_kas_ecc_cdh_testvector_201_out[] = {
/* ZIUT */
	0x01, 0x76, 0xbc, 0x5c, 0x40, 0x36, 0xce, 0x51, 0x25, 0x49, 0x3a, 0x58,
	0xdd, 0x26, 0x5f, 0x04, 0xd1, 0x90, 0xf0, 0x28, 0x36, 0x6f, 0x77, 0x99,
	0xf7, 0x0a, 0xed, 0xf2, 0x9a, 0xc6, 0x7b, 0x5b, 0x37, 0xc3, 0x72, 0x38,
	0x59, 0x33, 0x77, 0xa4, 0x79, 0x44, 0xf5, 0xb6, 0x39, 0xf4, 0x38, 0x56,
	0xdb, 0xd5, 0x60, 0xec
};
/* COUNT = 1 */
static const uint8_t nist_kas_ecc_cdh_testvector_202_public_x[] = {
/* QCAVSx */
	0x01, 0x0c, 0x4c, 0x68, 0xa9, 0xf1, 0xa6, 0x2a, 0x32, 0x65, 0x56, 0xb6,
	0xd9, 0x77, 0xa7, 0x9c, 0xd9, 0xc4, 0x47, 0x6c, 0x05, 0xb1, 0xad, 0xd4,
	0xa2, 0xcf, 0xd3, 0x06, 0x82, 0x49, 0xa3, 0xc3, 0x92, 0x38, 0x22, 0x42,
	0x8d, 0x35, 0x2c, 0x5d, 0x74, 0xe5, 0xd6, 0x4a, 0xcc, 0xee, 0xdb, 0xda,
	0xa6, 0xef, 0xbe, 0x4c
};
static const uint8_t nist_kas_ecc_cdh_testvector_202_public_y[] = {
/* QCAVSy */
	0x00, 0x86, 0x6a, 0xe9, 0x40, 0xdd, 0x31, 0xb5, 0xe6, 0xe3, 0xf2, 0x0b,
	0x3b, 0x4d, 0x87, 0xa6, 0xa0, 0x2c, 0x78, 0x17, 0x3c, 0x80, 0xaa, 0x51,
	0x0a, 0x6e, 0xdf, 0xf8, 0x52, 0xc6, 0x29, 0xe6, 0x06, 0x4d, 0xf5, 0xd7,
	0xc6, 0x00, 0xfd, 0x98, 0xe5, 0x8e, 0x8e, 0x8c, 0x66, 0x2b, 0xb4, 0xb9,
	0x6c, 0x8b, 0xa9, 0x05
};
static const uint8_t nist_kas_ecc_cdh_testvector_202_private[] = {
/* dIUT */
	0x00, 0x65, 0x18, 0x8b, 0xb7, 0x79, 0x6e, 0x45, 0x1f, 0x44, 0x72, 0x7a,
	0x1a, 0x06, 0x74, 0x44, 0x0d, 0xd3, 0x3d, 0x25, 0x8a, 0xd2, 0xfd, 0xc7,
	0xb9, 0x8f, 0xaf, 0x64, 0xb1, 0x1e, 0x7e, 0x8c, 0xe5, 0xe8, 0xc2, 0x1e,
	0x79, 0x9f, 0x1f, 0xf2, 0xfd, 0x29, 0xd4, 0xc9, 0x4a, 0xa1, 0x58, 0x96,
	0x20, 0x68, 0xa5, 0x9f
};
/* QIUTx = 0032c5768452f3c1f3bc54879379ad420891267742b37fb096ee7b8c21ceed0041e9470cec3bedcb799e90bdbb31192083ff0344 */
/* QIUTy = 00f9c6122927fb824246d1dc1ce0fde71a6849a82d41065da1d85256a9b1979bf7f286366fc8b324893ebe34e59c046007399414 */
static const uint8_t nist_kas_ecc_cdh_testvector_202_out[] = {
/* ZIUT */
	0x00, 0x57, 0x5d, 0x9e, 0x7f, 0x70, 0xa4, 0xa1, 0xc5, 0xc8, 0x07, 0xb6,
	0xb5, 0xd6, 0xb7, 0x33, 0x0b, 0xdd, 0x76, 0x4d, 0xb2, 0xaa, 0x60, 0xf3,
	0xbf, 0xe4, 0x97, 0xe6, 0xbf, 0xe9, 0x0f, 0x03, 0x8f, 0xb4, 0xf6, 0xac,
	0xf7, 0xac, 0x06, 0xef, 0xc3, 0xd1, 0x57, 0xc3, 0xdc, 0x90, 0x7b, 0x2a,
	0xe0, 0x93, 0xc6, 0xa2
};
/* COUNT = 2 */
static const uint8_t nist_kas_ecc_cdh_testvector_203_public_x[] = {
/* QCAVSx */
	0x01, 0xe4, 0xd5, 0x80, 0xd5, 0xe9, 0xad, 0x81, 0x67, 0x1c, 0x6c, 0xd6,
	0x62, 0xd5, 0x56, 0x9b, 0xaf, 0xe4, 0xd7, 0x5a, 0xa4, 0xf4, 0x49, 0xae,
	0xd5, 0x6b, 0xd8, 0x00, 0x61, 0x95, 0x20, 0xc9, 0xf3, 0x2c, 0x4e, 0x23,
	0x0c, 0x4d, 0x91, 0xb1, 0xc4, 0x11, 0xf9, 0x08, 0x6d, 0x52, 0x91, 0xba,
	0x13, 0x70, 0x14, 0xa2
};
static const uint8_t nist_kas_ecc_cdh_testvector_203_public_y[] = {
/* QCAVSy */
	0x00, 0x0c, 0x8f, 0xfb, 0x42, 0x39, 0x2f, 0xf3, 0x97, 0xbb, 0xd4, 0x67,
	0x97, 0x2f, 0x3e, 0xd2, 0x51, 0xd5, 0xa0, 0x79, 0x96, 0x5d, 0xa0, 0xb1,
	0xd2, 0xa3, 0xcc, 0x16, 0xc3, 0x1d, 0x25, 0x5d, 0xce, 0x98, 0x86, 0x93,
	0x7b, 0x2d, 0xc9, 0x41, 0xea, 0xb0, 0xd8, 0xbe, 0x8b, 0xbc, 0xd1, 0x5a,
	0xa6, 0xed, 0x96, 0xd6
};
static const uint8_t nist_kas_ecc_cdh_testvector_203_private[] = {
/* dIUT */
	0x00, 0x6c, 0xb1, 0x7c, 0x3f, 0xc2, 0x1a, 0xb4, 0x8e, 0x5c, 0x37, 0x17,
	0xc7, 0x91, 0x11, 0x8d, 0x47, 0x61, 0xe2, 0xc5, 0x19, 0x86, 0xbf, 0x14,
	0x79, 0x42, 0x55, 0x4d, 0xc5, 0xa1, 0x8b, 0xf9, 0xbb, 0x6c, 0x67, 0xbd,
	0xbb, 0xa9, 0x08, 0xa1, 0xe8, 0xba, 0x8e, 0x77, 0x90, 0xf5, 0x9a, 0x39,
	0x71, 0x34, 0xf6, 0x83
};
/* QIUTx = 002b890418afc5797c9746a44ca059367ae0663bcf058156860c613ee05e11da3f2f799c70a68fe72fd5dac2469daa18107029de */
/* QIUTy = 01356904b197bf9e0657f4349d252bbb375c66206fc0d8312599bdbefee8608ec948dce486807baa535ed06adac9c797634711ab */
static const uint8_t nist_kas_ecc_cdh_testvector_203_out[] = {
/* ZIUT */
	0x00, 0xce, 0x87, 0xaa, 0x5e, 0x77, 0x00, 0x38, 0x4d, 0xf5, 0x9d, 0x3f,
	0x10, 0x75, 0xd2, 0x82, 0xc1, 0xaa, 0x51, 0x13, 0x91, 0xc4, 0x2e, 0xf6,
	0x09, 0xb8, 0xde, 0x12, 0x64, 0xec, 0xa8, 0xf7, 0x73, 0x7d, 0xf9, 0x15,
	0x65, 0xc7, 0x3e, 0xe8, 0x84, 0xea, 0x88, 0x2d, 0x47, 0xc5, 0x6d, 0x97,
	0x91, 0x41, 0xf0, 0xf2
};
/* COUNT = 3 */
static const uint8_t nist_kas_ecc_cdh_testvector_204_public_x[] = {
/* QCAVSx */
	0x00, 0xb7, 0xd1, 0x93, 0x54, 0xca, 0xdc, 0xc9, 0x47, 0x08, 0x26, 0x7a,
	0xed, 0x8b, 0x23, 0xe4, 0x84, 0xe3, 0x2a, 0x03, 0x81, 0x4b, 0x02, 0x6a,
	0x80, 0x0f, 0x5b, 0xa0, 0x1e, 0x92, 0x04, 0xc4, 0x30, 0x52, 0xe4, 0xd4,
	0x7c, 0x6f, 0xcd, 0x92, 0x32, 0x96, 0x54, 0xe0, 0xe9, 0x01, 0x5b, 0x01,
	0x2f, 0x79, 0x34, 0x4a
};
static const uint8_t nist_kas_ecc_cdh_testvector_204_public_y[] = {
/* QCAVSy */
	0x01, 0x79, 0x95, 0xc1, 0x57, 0x96, 0xc5, 0xae, 0x93, 0xe0, 0xa2, 0x07,
	0xa2, 0x70, 0x70, 0x04, 0xfb, 0xb1, 0xa4, 0x9a, 0x0d, 0x47, 0xfd, 0x40,
	0x4f, 0x12, 0xd5, 0x78, 0x49, 0xd8, 0x39, 0x7c, 0xd4, 0xd2, 0xc6, 0xd2,
	0xb4, 0xb9, 0x0f, 0x86, 0x44, 0x03, 0xd4, 0xac, 0xd1, 0x6a, 0x32, 0xb7,
	0xff, 0x48, 0x77, 0xb4
};
static const uint8_t nist_kas_ecc_cdh_testvector_204_private[] = {
/* dIUT */
	0x00, 0x11, 0xd4, 0x3b, 0xc0, 0x8d, 0xa9, 0xce, 0x5d, 0xef, 0xc9, 0x4b,
	0x4e, 0xf9, 0x0d, 0x93, 0x24, 0xde, 0x08, 0x03, 0x47, 0xff, 0x4d, 0xf8,
	0x66, 0x45, 0xd3, 0x25, 0x60, 0x3a, 0x2d, 0xff, 0xd2, 0x8e, 0xca, 0xf0,
	0x77, 0x5e, 0xc5, 0x3c, 0xaf, 0x5a, 0x55, 0x4e, 0xaf, 0x8b, 0x68, 0x48,
	0x7d, 0xf8, 0x86, 0x54
};
/* QIUTx = 01257b6abd470d294b59ddaedacd545dcf43808af890f576288803342fc61eb396f560af74342e10bb94d224c24d8e5900e5b972 */
/* QIUTy = 01dccad97ecef4387a1cf512b16dd5bc7ab615fbc5087ac19d5fc2762f615b4904ea39343bbb185db64a19f7f70ecf0d557b15e8 */
static const uint8_t nist_kas_ecc_cdh_testvector_204_out[] = {
/* ZIUT */
	0x00, 0x69, 0x1d, 0xd6, 0xb5, 0x17, 0x77, 0x02, 0xd6, 0xa0, 0xb1, 0xf8,
	0xb0, 0x7f, 0x3b, 0x01, 0x84, 0x78, 0x68, 0x0d, 0xe7, 0xee, 0x07, 0x92,
	0x72, 0xff, 0x75, 0x65, 0x93, 0x35, 0xc9, 0x6a, 0xfc, 0xea, 0x76, 0x50,
	0xca, 0xa0, 0x1f, 0x99, 0x6a, 0xa3, 0x79, 0x46, 0xb7, 0x8e, 0x14, 0xa8,
	0x3e, 0x57, 0x9f, 0xb4
};
/* COUNT = 4 */
static const uint8_t nist_kas_ecc_cdh_testvector_205_public_x[] = {
/* QCAVSx */
	0x00, 0xf2, 0xa1, 0x1c, 0xcd, 0x3a, 0x53, 0xc9, 0x5e, 0xa9, 0x8f, 0x31,
	0x44, 0xfb, 0x77, 0xd4, 0xa6, 0x84, 0xf9, 0xa1, 0xf4, 0x23, 0xeb, 0x81,
	0xe3, 0xa8, 0xbf, 0xbe, 0x22, 0xb6, 0x80, 0xf2, 0x18, 0x70, 0xf5, 0x8c,
	0xae, 0xb6, 0x94, 0x6c, 0x6b, 0x3b, 0x87, 0x36, 0x99, 0xcf, 0xfd, 0x31,
	0x40, 0x63, 0xf4, 0x08
};
static const uint8_t nist_kas_ecc_cdh_testvector_205_public_y[] = {
/* QCAVSy */
	0x00, 0xfd, 0xf2, 0x6e, 0xed, 0xe6, 0xcb, 0xa7, 0x24, 0x82, 0x40, 0x72,
	0x09, 0x06, 0xce, 0x07, 0x6c, 0xc4, 0x32, 0x2d, 0x18, 0xbc, 0x76, 0x83,
	0xd2, 0x24, 0x0b, 0xa6, 0x84, 0x76, 0xce, 0x79, 0x02, 0x27, 0x80, 0xb2,
	0xfa, 0x54, 0xe0, 0xf7, 0xc7, 0x65, 0x28, 0xb7, 0x7f, 0xa6, 0x31, 0xfe,
	0x5a, 0xbb, 0x5b, 0x95
};
static const uint8_t nist_kas_ecc_cdh_testvector_205_private[] = {
/* dIUT */
	0x00, 0x0d, 0x6b, 0x25, 0x96, 0x56, 0xd5, 0x26, 0x77, 0x7d, 0xed, 0xb5,
	0x24, 0x6a, 0x19, 0x2f, 0x0c, 0x05, 0xc7, 0x27, 0x0a, 0x3b, 0x4e, 0x64,
	0xa9, 0xd6, 0xc8, 0x77, 0xcd, 0x06, 0xd2, 0x96, 0x2a, 0x1a, 0xc8, 0x4e,
	0xc2, 0xd8, 0x97, 0x65, 0xf9, 0x67, 0xf6, 0x04, 0x4f, 0x2d, 0xfa, 0x56,
	0x90, 0x31, 0x07, 0xf3
};
/* QIUTx = 0193afa13bd1e081cee5df1286fe44a293b7d1b10c290a5f2ae7be2d02736009a26d83aaaa9017a8c8bf60efa15fcead07767d48 */
/* QIUTy = 01d02fd66a7806c4c8445fa615254ff32bb9c1d85a3904f939c1061e250d3eb6413130a2a5570994795310e96dc3aff3b8218ad3 */
static const uint8_t nist_kas_ecc_cdh_testvector_205_out[] = {
/* ZIUT */
	0x01, 0x36, 0xf5, 0xc0, 0x4c, 0xf9, 0xa5, 0x6d, 0xb2, 0x4a, 0xd9, 0x9b,
	0xd2, 0x86, 0xfe, 0xb8, 0x00, 0xae, 0xa3, 0x8d, 0x44, 0xf8, 0x19, 0xbe,
	0x1c, 0x2a, 0x9d, 0xba, 0x15, 0xc6, 0x35, 0xc4, 0xe1, 0x22, 0x89, 0x35,
	0x70, 0x23, 0x3a, 0x4c, 0x57, 0x54, 0xa4, 0x14, 0x99, 0xea, 0xfa, 0x39,
	0xa3, 0x5a, 0xa5, 0x7e
};
/* COUNT = 5 */
static const uint8_t nist_kas_ecc_cdh_testvector_206_public_x[] = {
/* QCAVSx */
	0x01, 0x17, 0x44, 0x9f, 0xbe, 0xa6, 0xb2, 0xd5, 0xf4, 0xe8, 0xe4, 0xd3,
	0x9a, 0x72, 0x28, 0x42, 0x4c, 0xf0, 0x6f, 0x45, 0x6b, 0xf3, 0xae, 0x39,
	0xbc, 0x1f, 0xb2, 0xa9, 0x9e, 0x41, 0x83, 0xb7, 0x16, 0xe1, 0x94, 0xfc,
	0x50, 0x74, 0x65, 0x66, 0x4d, 0x00, 0x9d, 0x5b, 0xce, 0xe3, 0xa4, 0x26,
	0xba, 0x93, 0x2c, 0x10
};
static const uint8_t nist_kas_ecc_cdh_testvector_206_public_y[] = {
/* QCAVSy */
	0x01, 0x14, 0x6d, 0x32, 0xb7, 0x0f, 0x09, 0xe6, 0x5f, 0xcf, 0x69, 0xeb,
	0x9a, 0xe6, 0x61, 0x62, 0xd1, 0x0b, 0xd0, 0x43, 0x69, 0xde, 0x8e, 0x81,
	0x87, 0xfa, 0x9c, 0x3d, 0x1b, 0x5d, 0xda, 0x26, 0xf1, 0x0b, 0x46, 0x9c,
	0xd4, 0x92, 0x5c, 0xa3, 0x7e, 0x09, 0x94, 0x41, 0x57, 0x57, 0xe6, 0x89,
	0x5e, 0x58, 0x81, 0x45
};
static const uint8_t nist_kas_ecc_cdh_testvector_206_private[] = {
/* dIUT */
	0x00, 0x4b, 0xf7, 0x35, 0x1b, 0x19, 0x58, 0x75, 0xd0, 0x1f, 0x63, 0x06,
	0xca, 0x12, 0x7d, 0xb8, 0xa1, 0xa5, 0xf5, 0x97, 0x71, 0x9c, 0x0d, 0x10,
	0xe1, 0xd6, 0x8f, 0x5d, 0x48, 0x55, 0xbf, 0x07, 0x60, 0x57, 0x90, 0x69,
	0x1f, 0xcd, 0x0d, 0x8b, 0x5d, 0xb1, 0x37, 0xd3, 0xfc, 0x26, 0x79, 0xde,
	0x75, 0xa0, 0x67, 0x81
};
/* QIUTx = 01d386645aaa48e2fd0950e6a9ace9dff62c8f5e94cdba45bd73c6be6bf7b763a2c9a807846312da3ab821c049ac0861f82337f0 */
/* QIUTy = 002a6436ef8a1261aecc38c821da774a391fdcc7750c9437d9dfe64c823350813999f0fd4f07f1d6d98074098612bc52044249d4 */
static const uint8_t nist_kas_ecc_cdh_testvector_206_out[] = {
/* ZIUT */
	0x00, 0x4f, 0x68, 0x4f, 0x9d, 0x55, 0x9d, 0x16, 0x48, 0x5f, 0x00, 0x23,
	0xbf, 0x01, 0x20, 0x06, 0x26, 0x5e, 0xd8, 0x1f, 0x06, 0xfb, 0xc1, 0x44,
	0x13, 0x34, 0xa5, 0x59, 0xe5, 0x50, 0x0a, 0x3f, 0x77, 0x60, 0x35, 0x65,
	0x01, 0x36, 0x94, 0x02, 0x3e, 0x0d, 0x8f, 0x44, 0xfd, 0x12, 0xdc, 0xf6,
	0x9e, 0xb8, 0xd6, 0x54
};
/* COUNT = 6 */
static const uint8_t nist_kas_ecc_cdh_testvector_207_public_x[] = {
/* QCAVSx */
	0x01, 0x19, 0x98, 0x0f, 0x11, 0x14, 0x9d, 0xee, 0x5e, 0x2c, 0x2d, 0x00,
	0x56, 0x1d, 0x3c, 0x26, 0xa4, 0x2a, 0x5a, 0x44, 0xe8, 0x74, 0x76, 0x5d,
	0xdd, 0xa4, 0xd8, 0x18, 0xea, 0x70, 0x4e, 0xdb, 0xba, 0x23, 0xab, 0xed,
	0x5e, 0x08, 0xbe, 0x92, 0xd6, 0x55, 0xd7, 0x9e, 0x55, 0xc5, 0xbc, 0x54,
	0x78, 0x7b, 0x4d, 0xd4
};
static const uint8_t nist_kas_ecc_cdh_testvector_207_public_y[] = {
/* QCAVSy */
	0x01, 0x36, 0x6b, 0x3d, 0xda, 0x3e, 0x98, 0x79, 0xc4, 0x48, 0x1d, 0xdc,
	0x36, 0x7e, 0x51, 0xc1, 0xc0, 0x54, 0x19, 0x45, 0x96, 0x46, 0x36, 0xd5,
	0x02, 0x16, 0x87, 0xc2, 0x85, 0xc4, 0x7d, 0x40, 0xe7, 0x9f, 0xf7, 0xf0,
	0xbb, 0x56, 0xa9, 0x3a, 0xc5, 0x60, 0xbe, 0x8d, 0xcb, 0x97, 0x0f, 0x58,
	0xb2, 0x3b, 0x10, 0xa7
};
static const uint8_t nist_kas_ecc_cdh_testvector_207_private[] = {
/* dIUT */
	0x00, 0x69, 0xda, 0x65, 0x90, 0x10, 0x34, 0x5c, 0x69, 0x00, 0xfd, 0xec,
	0xb3, 0x1d, 0xf9, 0xba, 0xbe, 0xdb, 0xe4, 0x25, 0x33, 0x98, 0x29, 0x0b,
	0x34, 0x01, 0x2f, 0xb1, 0x34, 0xbc, 0x59, 0x14, 0x75, 0x72, 0xe6, 0x2a,
	0x60, 0xf5, 0xca, 0xcc, 0xed, 0x87, 0xb0, 0xf8, 0xd1, 0xff, 0x7c, 0x04,
	0x9d, 0xfe, 0x96, 0x92
};
/* QIUTx = 0038687019f7c219ddd9567b20f5ea1e8a50451dd40bf5b65f7b2e133de6f36e4a3f8fa2f977efe920f845d176c8a57023cc55c2 */
/* QIUTy = 0149397fbc42bacf85c59e04535df1d52715761eea997d4ff87204866cdc3d4a54c2425ad214a7a0dd592f4a991ab768c8f404be */
static const uint8_t nist_kas_ecc_cdh_testvector_207_out[] = {
/* ZIUT */
	0x00, 0x13, 0x78, 0x94, 0xf6, 0x37, 0x46, 0x0a, 0x63, 0x57, 0x68, 0x24,
	0x53, 0x69, 0x44, 0xcd, 0xdb, 0x42, 0xdf, 0xe6, 0x31, 0x69, 0xc8, 0x40,
	0x40, 0xa0, 0x34, 0x5a, 0xd7, 0x51, 0x6e, 0xc4, 0xf1, 0xad, 0x00, 0xbb,
	0x4d, 0xe2, 0x0e, 0xa6, 0xea, 0x43, 0x82, 0x4b, 0x9b, 0x0f, 0x74, 0xdf,
	0xa6, 0x88, 0x1c, 0xfc
};
/* COUNT = 7 */
static const uint8_t nist_kas_ecc_cdh_testvector_208_public_x[] = {
/* QCAVSx */
	0x01, 0xfa, 0x39, 0xb5, 0xd3, 0x37, 0x5d, 0x43, 0x24, 0x7a, 0xc9, 0x50,
	0x00, 0x61, 0xeb, 0xff, 0x7a, 0x0c, 0x15, 0xb8, 0xc5, 0xdf, 0xe9, 0xc7,
	0x51, 0x78, 0x43, 0x86, 0xc9, 0x81, 0x86, 0x0d, 0xe6, 0xe1, 0xb9, 0x58,
	0x4d, 0xa0, 0xf4, 0x21, 0x19, 0x41, 0x7f, 0x32, 0x33, 0x82, 0x90, 0x91,
	0x0a, 0x9a, 0x25, 0x9e
};
static const uint8_t nist_kas_ecc_cdh_testvector_208_public_y[] = {
/* QCAVSy */
	0x00, 0x2b, 0xde, 0xcd, 0x50, 0x2b, 0xa6, 0x4a, 0x6f, 0x21, 0xd0, 0x8f,
	0xa4, 0x25, 0x03, 0x89, 0xd4, 0x27, 0x03, 0x24, 0x45, 0x6e, 0x94, 0x41,
	0x65, 0x74, 0x95, 0xc7, 0x2a, 0xd7, 0x60, 0xfb, 0x34, 0x83, 0x25, 0xf8,
	0x9b, 0x7a, 0x54, 0x04, 0xa2, 0xc2, 0x1c, 0x2a, 0xa0, 0x77, 0x11, 0xbc,
	0xf5, 0xf3, 0x04, 0x12
};
static const uint8_t nist_kas_ecc_cdh_testvector_208_private[] = {
/* dIUT */
	0x00, 0x06, 0xdf, 0xda, 0xb3, 0xca, 0x1b, 0x2a, 0x28, 0x21, 0xce, 0xfd,
	0xb5, 0x87, 0x2b, 0xb9, 0x5f, 0x02, 0x31, 0x61, 0xae, 0x4e, 0x2d, 0x54,
	0x9d, 0x0f, 0xb1, 0xf3, 0x82, 0x56, 0x34, 0x13, 0x58, 0x44, 0x91, 0x65,
	0x7d, 0xb1, 0x01, 0xc3, 0x23, 0x51, 0x48, 0x32, 0xc3, 0x63, 0xf6, 0x36,
	0xa9, 0xe6, 0x9e, 0x83
};
/* QIUTx = 003e9a9b5f282066e233870dcb00c4aed2d73a331f79d49c8d5c2d93908b0ef5e72b748814d1b8840642d75b7a9a55301b1e7c82 */
/* QIUTy = 01085f57691e04afac6e884e2fdbd8df802f4d435bce611231ab3274761ead5e2e6a344a53f33c0fa156e3132062f72bcda3fc0c */
static const uint8_t nist_kas_ecc_cdh_testvector_208_out[] = {
/* ZIUT */
	0x00, 0xf0, 0x3b, 0x0b, 0x43, 0xa3, 0x51, 0x31, 0x16, 0x89, 0xeb, 0x1d,
	0x3f, 0xc4, 0x57, 0x01, 0x3f, 0x29, 0x4a, 0x7d, 0x02, 0xad, 0x85, 0x0c,
	0x72, 0xe4, 0xff, 0x9b, 0x64, 0xce, 0x68, 0xa4, 0x7b, 0xeb, 0x49, 0xbc,
	0x5b, 0xcb, 0xdc, 0x82, 0x85, 0x34, 0xf8, 0xc8, 0xa5, 0xe1, 0x3d, 0xe5,
	0xfe, 0x52, 0x2e, 0xb0
};
/* COUNT = 8 */
static const uint8_t nist_kas_ecc_cdh_testvector_209_public_x[] = {
/* QCAVSx */
	0x01, 0xb2, 0x55, 0xd5, 0xbb, 0x75, 0xd2, 0x59, 0x70, 0x30, 0x1d, 0xe9,
	0xe0, 0xe3, 0x95, 0x9a, 0x12, 0x20, 0x5d, 0x51, 0x1f, 0x8e, 0x64, 0xf0,
	0x42, 0xa0, 0x1c, 0x95, 0x0d, 0xb4, 0x71, 0xb1, 0xd6, 0xd5, 0x84, 0x7f,
	0x75, 0x66, 0x9e, 0xeb, 0x0b, 0xf1, 0x87, 0xf1, 0x55, 0x9d, 0xb3, 0xb2,
	0x2a, 0xee, 0xc0, 0x96
};
static const uint8_t nist_kas_ecc_cdh_testvector_209_public_y[] = {
/* QCAVSy */
	0x01, 0x7e, 0x59, 0x0c, 0xfa, 0x85, 0x53, 0x49, 0x13, 0x61, 0x98, 0xc2,
	0xdd, 0xd8, 0xa5, 0x21, 0x08, 0x82, 0x47, 0x3c, 0x9d, 0xd5, 0x91, 0xc0,
	0x2e, 0x20, 0x2c, 0xa0, 0x40, 0x4b, 0xbc, 0x9f, 0x63, 0x91, 0xd7, 0x3a,
	0xe0, 0x11, 0xda, 0xc9, 0x96, 0x51, 0x55, 0xd2, 0x65, 0x01, 0x39, 0xfe,
	0x2e, 0x54, 0xec, 0x67
};
static const uint8_t nist_kas_ecc_cdh_testvector_209_private[] = {
/* dIUT */
	0x00, 0x29, 0xb2, 0xfc, 0xb3, 0x08, 0x59, 0x6a, 0x97, 0x5c, 0x5b, 0x4c,
	0xd1, 0xe7, 0x52, 0x67, 0xc5, 0x42, 0x4e, 0x00, 0x77, 0x41, 0x14, 0xec,
	0x20, 0x51, 0xa5, 0x71, 0xb2, 0x99, 0x76, 0x61, 0x89, 0xfa, 0xd2, 0x4e,
	0x92, 0xf9, 0x6e, 0x3d, 0x52, 0x77, 0x36, 0xea, 0x48, 0x03, 0x67, 0xbd,
	0xbd, 0xd0, 0x53, 0x0e
};
/* QIUTx = 014c757399be201e08afd8b4a671e7d3b6d7f8844498ab592e1bf69315347ce82dbd785d45922660d4d0d27fa2b0ac62e707fcec */
/* QIUTy = 0098f0773d3efe9c290a992eca05875d3463f0736b2dfef4affd9ff00f96ade53399917dea074c798fc535738f0c5689a2447f86 */
static const uint8_t nist_kas_ecc_cdh_testvector_209_out[] = {
/* ZIUT */
	0x01, 0x8f, 0x55, 0xb8, 0x1f, 0x15, 0xf8, 0x62, 0xae, 0xd0, 0x42, 0xf3,
	0x74, 0x33, 0x05, 0x0a, 0xc6, 0x17, 0x18, 0xc9, 0x93, 0x9d, 0x43, 0x2b,
	0x2a, 0x20, 0xe1, 0x2d, 0x64, 0x7f, 0x99, 0x75, 0x3b, 0x8d, 0xd5, 0x12,
	0x7c, 0xf8, 0x96, 0x32, 0x47, 0xfe, 0x7e, 0x1d, 0x5a, 0xde, 0x14, 0x42,
	0x22, 0x9b, 0xc6, 0x46
};
/* COUNT = 9 */
static const uint8_t nist_kas_ecc_cdh_testvector_210_public_x[] = {
/* QCAVSx */
	0x00, 0xec, 0xf7, 0x06, 0x4f, 0x52, 0x8f, 0xad, 0xae, 0x38, 0x0c, 0xb3,
	0x82, 0x98, 0x48, 0x11, 0x04, 0x7a, 0x0d, 0x7d, 0xd9, 0xa8, 0xde, 0x8e,
	0x76, 0xf8, 0x17, 0x8a, 0xa6, 0x00, 0x69, 0xe7, 0x7a, 0x94, 0x8a, 0xcf,
	0xa7, 0x4d, 0x2c, 0x77, 0xa7, 0x68, 0x51, 0x65, 0x9a, 0x98, 0x19, 0x70,
	0x54, 0xda, 0x8d, 0x44
};
static const uint8_t nist_kas_ecc_cdh_testvector_210_public_y[] = {
/* QCAVSy */
	0x00, 0xb9, 0x8e, 0x13, 0x49, 0x7f, 0x77, 0x60, 0x72, 0x71, 0x1c, 0x42,
	0xc1, 0x8d, 0xbf, 0xc8, 0xeb, 0x8c, 0x85, 0x23, 0xff, 0x63, 0x3a, 0xf9,
	0x88, 0xa1, 0xf2, 0x42, 0xed, 0x3c, 0x3c, 0x56, 0x5d, 0x18, 0xcf, 0x22,
	0x4f, 0x87, 0x51, 0xf2, 0x94, 0x2e, 0x36, 0x0b, 0xa1, 0x6e, 0x0f, 0x58,
	0x30, 0x95, 0x29, 0x19
};
static const uint8_t nist_kas_ecc_cdh_testvector_210_private[] = {
/* dIUT */
	0x00, 0x1b, 0x98, 0x01, 0x5c, 0x02, 0x02, 0xea, 0x16, 0x41, 0x79, 0x71,
	0xa3, 0x73, 0x04, 0x25, 0x08, 0x39, 0xbd, 0x6a, 0x6e, 0x5d, 0x83, 0x49,
	0x7f, 0x7f, 0x93, 0xf0, 0xf7, 0x47, 0x2a, 0x21, 0xfc, 0xe4, 0xbe, 0x5b,
	0xe7, 0x76, 0xe9, 0x09, 0x59, 0xdb, 0xc4, 0x1a, 0x0e, 0x85, 0xed, 0x22,
	0x58, 0x37, 0xe8, 0xd5
};
/* QIUTx = 01fec09f94571614e7cd8e958ebcd7a2fcd8c248d408cdba359630545c31383922774d3b24e20591d8b41e954e16654fe85cbaca */
/* QIUTy = 0031e0eb1dd1ce467a8b78d10d25b9de92cfdc2773831e6e28a152d02ae2a5a510994cc010462254441ea41121c0677fb4178bda */
static const uint8_t nist_kas_ecc_cdh_testvector_210_out[] = {
/* ZIUT */
	0x00, 0x2b, 0x56, 0x0d, 0x19, 0x49, 0x29, 0x7d, 0xc7, 0xe1, 0xbb, 0xe8,
	0xce, 0x49, 0xa5, 0x95, 0x76, 0x29, 0x24, 0xaf, 0xcf, 0x02, 0x71, 0xe9,
	0xc4, 0x93, 0xc1, 0x8a, 0xd5, 0xcb, 0xfc, 0xea, 0x5f, 0x39, 0x00, 0xc7,
	0xb7, 0x93, 0xae, 0x5d, 0xd4, 0x4f, 0x48, 0x88, 0x4b, 0x0b, 0xc3, 0xb5,
	0x2c, 0x66, 0xe0, 0x5a
};
/* COUNT = 10 */
static const uint8_t nist_kas_ecc_cdh_testvector_211_public_x[] = {
/* QCAVSx */
	0x00, 0x4e, 0x05, 0xc3, 0x4d, 0xac, 0x44, 0xe6, 0xe1, 0xb0, 0x8c, 0xdf,
	0xae, 0x63, 0x57, 0xc2, 0x0d, 0xb7, 0xa5, 0x44, 0xdc, 0x25, 0x3d, 0xff,
	0x1c, 0x23, 0xd4, 0xdb, 0xa8, 0x71, 0xb9, 0x67, 0x81, 0xb6, 0xa6, 0x16,
	0x38, 0xd7, 0x38, 0x65, 0xda, 0xfe, 0x0a, 0x94, 0x43, 0xc3, 0xec, 0x32,
	0x88, 0x57, 0xd2, 0x3e
};
static const uint8_t nist_kas_ecc_cdh_testvector_211_public_y[] = {
/* QCAVSy */
	0x01, 0x22, 0x6c, 0x42, 0x77, 0x78, 0xbb, 0x22, 0x46, 0x24, 0xcd, 0x21,
	0x54, 0x93, 0xd7, 0xa4, 0xf3, 0x2a, 0x4f, 0x14, 0x19, 0x79, 0x23, 0x64,
	0x09, 0x50, 0x5d, 0x8c, 0xf5, 0x8d, 0x81, 0xdf, 0xd3, 0xc7, 0x93, 0xe5,
	0x95, 0x43, 0xa7, 0x80, 0x31, 0x4f, 0x3c, 0xd8, 0xee, 0x17, 0x66, 0x4d,
	0xc2, 0xe4, 0x63, 0x9e
};
static const uint8_t nist_kas_ecc_cdh_testvector_211_private[] = {
/* dIUT */
	0x00, 0x47, 0x3b, 0xce, 0xcb, 0x13, 0x77, 0x11, 0xe5, 0xe8, 0x97, 0x63,
	0xa4, 0x0f, 0x77, 0xdb, 0xe2, 0xea, 0x8c, 0x25, 0x09, 0xd2, 0x09, 0x06,
	0x4e, 0x39, 0xcf, 0x90, 0x5a, 0xfa, 0xa9, 0x01, 0x08, 0x5f, 0x8e, 0x79,
	0x5c, 0x9b, 0x80, 0x17, 0xc9, 0xa5, 0xd0, 0xa1, 0xb9, 0x68, 0x12, 0xc1,
	0x24, 0xa3, 0xff, 0xbf
};
/* QIUTx = 01c8e9adc4816e6606ffff5e1a7d48a7854c35aaf055d31833f0cabde8bbc4d2458e3cd3c82a4af80745f595b3ba12f8b5c0ce90 */
/* QIUTy = 00fc43f193b5589aee62985735e3628374dd45a86a61baaf78c21fa6e787856ea6b8b88316540571825865ce6b8578add5faa69f */
static const uint8_t nist_kas_ecc_cdh_testvector_211_out[] = {
/* ZIUT */
	0x00, 0x0b, 0x43, 0xcb, 0x53, 0x9b, 0xb4, 0xbb, 0x42, 0xf1, 0x95, 0xff,
	0xdb, 0xcd, 0xeb, 0x48, 0x2b, 0x69, 0x30, 0x1c, 0x01, 0x55, 0xa8, 0x40,
	0xcd, 0x38, 0x1f, 0x55, 0xc4, 0x65, 0xa8, 0xe5, 0x7e, 0xc5, 0x1d, 0x65,
	0x55, 0x87, 0x15, 0x37, 0xb5, 0x6b, 0xf8, 0x4a, 0x15, 0x44, 0xca, 0xe2,
	0xb2, 0xb8, 0xeb, 0x38
};
/* COUNT = 11 */
static const uint8_t nist_kas_ecc_cdh_testvector_212_public_x[] = {
/* QCAVSx */
	0x01, 0x6f, 0x69, 0x60, 0xfd, 0x23, 0x57, 0xd2, 0xf7, 0x0b, 0x5f, 0x77,
	0x8b, 0xe5, 0xe0, 0xaa, 0x71, 0x55, 0x6b, 0x9d, 0x2f, 0x4c, 0xce, 0xb1,
	0x4f, 0x78, 0x12, 0xda, 0x85, 0x8a, 0xb8, 0x72, 0x81, 0x8b, 0x46, 0x10,
	0xd4, 0x1a, 0x8f, 0x66, 0x20, 0x0b, 0x43, 0x43, 0x42, 0x22, 0x27, 0xd9,
	0xfd, 0xdf, 0x71, 0x2e
};
static const uint8_t nist_kas_ecc_cdh_testvector_212_public_y[] = {
/* QCAVSy */
	0x00, 0xaa, 0xf5, 0x92, 0xa7, 0x25, 0xe7, 0x73, 0x83, 0x88, 0x89, 0x6b,
	0x9b, 0xe9, 0xf7, 0x8c, 0x1c, 0x3d, 0x69, 0x72, 0xb9, 0xf9, 0x90, 0x34,
	0xd0, 0x2c, 0xc0, 0xf9, 0x77, 0x6a, 0x9f, 0x6c, 0x2f, 0x9b, 0x7d, 0x50,
	0x1f, 0x75, 0xbe, 0x18, 0x59, 0x9b, 0x08, 0x8c, 0x4c, 0x58, 0x81, 0xc6,
	0x61, 0x46, 0xe5, 0xb9
};
static const uint8_t nist_kas_ecc_cdh_testvector_212_private[] = {
/* dIUT */
	0x00, 0x20, 0xdd, 0xdd, 0x67, 0x13, 0x4a, 0x41, 0x83, 0x78, 0xba, 0xa0,
	0xdd, 0xfc, 0x91, 0x11, 0xc0, 0xa2, 0xed, 0x49, 0x2b, 0x28, 0x95, 0x69,
	0xdd, 0x00, 0x61, 0xbf, 0x12, 0x26, 0xd2, 0x35, 0xbd, 0xaa, 0x52, 0x03,
	0xd3, 0xef, 0xa2, 0xbd, 0x01, 0x41, 0xd2, 0xac, 0xe2, 0x7c, 0x3a, 0xe8,
	0xe6, 0xda, 0xf1, 0x1f
};
/* QIUTx = 0167d577b2a43cc1a7d88a6be883c28dbf48c3e1fbf21ad83e7a7e3d753fb0b6d3f80cd1376fd98be260f494757cdc063256d5b2 */
/* QIUTy = 015ed7003b7d2bd5e0359303660add090049039cf7df396989ea18c702f704c45cf6fde7ad072d31253d1d5295e9c5d1d5c62c3b */
static const uint8_t nist_kas_ecc_cdh_testvector_212_out[] = {
/* ZIUT */
	0x01, 0x13, 0xdd, 0x2c, 0xf8, 0x73, 0x2c, 0xeb, 0x8a, 0x89, 0x3e, 0x14,
	0x9f, 0x13, 0xd5, 0x20, 0x26, 0xe5, 0xd8, 0x29, 0x32, 0x2d, 0x0f, 0x12,
	0x33, 0xa6, 0x24, 0xfd, 0x6b, 0x74, 0xd5, 0x6e, 0x7e, 0x63, 0x74, 0xd7,
	0x09, 0x42, 0xa2, 0x51, 0x52, 0xce, 0x50, 0x73, 0x83, 0x16, 0x60, 0x33,
	0x3f, 0xb3, 0xe0, 0x70
};
/* COUNT = 12 */
static const uint8_t nist_kas_ecc_cdh_testvector_213_public_x[] = {
/* QCAVSx */
	0x00, 0xf5, 0x49, 0xc4, 0x7d, 0xc8, 0xe9, 0x2f, 0xec, 0xd3, 0x8b, 0x57,
	0x50, 0x89, 0x58, 0x80, 0xe4, 0x49, 0xf1, 0xe3, 0x1a, 0xbe, 0x0b, 0xb1,
	0xea, 0xcc, 0x84, 0x29, 0x8f, 0x83, 0x61, 0x08, 0xe5, 0xa3, 0x08, 0xcc,
	0xb9, 0x57, 0x8d, 0xcb, 0xd4, 0xbe, 0x61, 0x77, 0x75, 0x2e, 0xb2, 0x31,
	0xe7, 0x8f, 0x01, 0x1c
};
static const uint8_t nist_kas_ecc_cdh_testvector_213_public_y[] = {
/* QCAVSy */
	0x00, 0x93, 0x66, 0x3e, 0xc3, 0xfc, 0xb5, 0x4d, 0x67, 0x68, 0x97, 0xbf,
	0xc9, 0x5d, 0xb5, 0xe5, 0x4a, 0xd6, 0xee, 0xa1, 0xec, 0x7b, 0x46, 0xca,
	0x4b, 0xf3, 0xd2, 0x53, 0x58, 0x39, 0xf1, 0x01, 0xcb, 0x3e, 0x6d, 0x5f,
	0x11, 0xb6, 0xa3, 0x6b, 0xf4, 0x03, 0x63, 0xc3, 0x1c, 0x9f, 0x88, 0x13,
	0x78, 0x62, 0x67, 0x4f
};
static const uint8_t nist_kas_ecc_cdh_testvector_213_private[] = {
/* dIUT */
	0x00, 0x60, 0x7a, 0x5a, 0x65, 0x32, 0x17, 0x7b, 0x52, 0xf2, 0x34, 0x92,
	0x71, 0x7d, 0xd0, 0xa7, 0xb2, 0xaf, 0x98, 0xe0, 0x48, 0x84, 0xf7, 0x70,
	0x75, 0xe4, 0x60, 0x44, 0x10, 0xc5, 0x04, 0x4a, 0x08, 0x46, 0x1e, 0xcf,
	0x37, 0xc4, 0xef, 0xa3, 0xed, 0xc2, 0xcb, 0x66, 0x7c, 0x84, 0xb8, 0x64,
	0x15, 0x93, 0x6b, 0x70
};
/* QIUTx = 000a5677ac6c00d2646054dbebfc536db0a9b351a2408a73e083ad62d182fb87cb80322c539553ecdbc213ce84c66ddf8dc1d234 */
/* QIUTy = 01327a0a3769240fda45f94bb07361c74aa8c8d119414a7b5666e25a3ab6881975396325a77f541a1ba268012a82c5110d2a49e2 */
static const uint8_t nist_kas_ecc_cdh_testvector_213_out[] = {
/* ZIUT */
	0x00, 0xc8, 0xe6, 0x2a, 0xc2, 0x5c, 0x11, 0xe8, 0x6b, 0x98, 0x64, 0x2e,
	0x4e, 0xc7, 0xad, 0xde, 0x9d, 0x94, 0x36, 0xf9, 0x33, 0x73, 0x69, 0xfb,
	0x06, 0x5a, 0xbc, 0x9e, 0xa7, 0x84, 0xf9, 0x0b, 0x8b, 0x8b, 0xeb, 0xae,
	0x35, 0xda, 0x92, 0x18, 0x54, 0x86, 0x19, 0x1d, 0xd9, 0xf4, 0x93, 0x70,
	0xb1, 0x14, 0x8c, 0xe6
};
/* COUNT = 13 */
static const uint8_t nist_kas_ecc_cdh_testvector_214_public_x[] = {
/* QCAVSx */
	0x00, 0x41, 0x1e, 0x5d, 0x4c, 0x96, 0xe3, 0x5d, 0xe9, 0xb5, 0x41, 0xda,
	0x5f, 0xac, 0x69, 0x13, 0x36, 0x46, 0x2c, 0x88, 0x2d, 0x8e, 0x8c, 0xe4,
	0xd6, 0xeb, 0x71, 0x21, 0x41, 0x7e, 0x70, 0x95, 0x0c, 0x4d, 0x95, 0x02,
	0xf6, 0x45, 0x65, 0xd5, 0xa6, 0xcf, 0xa7, 0x35, 0xc9, 0x0e, 0xef, 0x83,
	0xc7, 0xb8, 0x61, 0xe2
};
static const uint8_t nist_kas_ecc_cdh_testvector_214_public_y[] = {
/* QCAVSy */
	0x00, 0x96, 0xb9, 0x04, 0xe3, 0x7c, 0xa1, 0xc2, 0xdb, 0x59, 0xa5, 0x46,
	0x15, 0x62, 0x7e, 0x1c, 0x33, 0x56, 0x16, 0x0f, 0xe1, 0x75, 0x28, 0x4a,
	0xad, 0xc3, 0xb2, 0xfa, 0x06, 0xba, 0x0b, 0x30, 0xaa, 0xa0, 0x7c, 0x84,
	0xe6, 0x4e, 0x48, 0x65, 0x2e, 0x5f, 0xeb, 0x30, 0x35, 0x95, 0x06, 0x6e,
	0x0f, 0x84, 0x68, 0xf7
};
static const uint8_t nist_kas_ecc_cdh_testvector_214_private[] = {
/* dIUT */
	0x00, 0x34, 0xda, 0x9a, 0x45, 0x37, 0x11, 0xf0, 0x4a, 0x0b, 0x1e, 0xa1,
	0xb9, 0xaf, 0x70, 0x1e, 0x0d, 0xc3, 0xa5, 0x5c, 0xdd, 0x58, 0x5e, 0x43,
	0xe3, 0xec, 0xf4, 0x1e, 0x93, 0x4e, 0xca, 0xf8, 0x80, 0xff, 0x16, 0x14,
	0xdc, 0xe5, 0xcc, 0x99, 0x2a, 0x69, 0xad, 0xdf, 0xc4, 0x08, 0xda, 0xe1,
	0xb0, 0x9b, 0x8d, 0x05
};
/* QIUTx = 01f7bff435547a89516d017d1bdac4cda36041a0d3dfd03258562b2e28f40cd64f6ae2b70457773f9675cffc40c021e4702b08d6 */
/* QIUTy = 0013c59a72f0c83f5bb90a0bfee798952fb91ee329c98c4b5914f445ae7c8483767052b5f529974621545ddcd6377f5e387d573c */
static const uint8_t nist_kas_ecc_cdh_testvector_214_out[] = {
/* ZIUT */
	0x01, 0x25, 0x05, 0x74, 0x6f, 0x1a, 0x40, 0xef, 0x75, 0xf9, 0x50, 0x59,
	0x52, 0x11, 0xce, 0x04, 0xf8, 0x7f, 0x1d, 0xaf, 0xff, 0xfd, 0xf8, 0xc1,
	0x26, 0x00, 0xa9, 0xe2, 0x99, 0x4c, 0x8c, 0x1d, 0x8b, 0x19, 0xc0, 0xe0,
	0x55, 0x9a, 0xdf, 0x9a, 0x94, 0x76, 0x2c, 0xb9, 0x83, 0x56, 0x9d, 0xe6,
	0xd0, 0xd8, 0xba, 0xca
};
/* COUNT = 14 */
static const uint8_t nist_kas_ecc_cdh_testvector_215_public_x[] = {
/* QCAVSx */
	0x00, 0x0f, 0xa8, 0x24, 0x3f, 0x00, 0x0a, 0x33, 0x98, 0x80, 0x8a, 0x1f,
	0x88, 0xff, 0xc5, 0xa3, 0x42, 0x96, 0x8f, 0xee, 0x5c, 0x7b, 0x26, 0xa9,
	0xe1, 0xff, 0xa2, 0x6e, 0xfa, 0x88, 0x5e, 0x74, 0xe1, 0xc5, 0x62, 0x02,
	0x7d, 0x95, 0xdb, 0x08, 0xcc, 0x15, 0xbd, 0x25, 0xa3, 0xfc, 0x11, 0xab,
	0x4d, 0xc1, 0x3c, 0xa2
};
static const uint8_t nist_kas_ecc_cdh_testvector_215_public_y[] = {
/* QCAVSy */
	0x00, 0xfe, 0xd6, 0x87, 0xc7, 0x19, 0x7f, 0xf1, 0xae, 0xb9, 0x80, 0xe7,
	0x2a, 0x3a, 0x7c, 0x31, 0x81, 0x42, 0x05, 0x2c, 0x23, 0x89, 0xb0, 0x86,
	0x6d, 0xb3, 0xb8, 0x7e, 0x5c, 0x80, 0x25, 0xe7, 0x9b, 0xb4, 0xf4, 0xf9,
	0x96, 0xfa, 0x63, 0x52, 0xab, 0x9c, 0xb2, 0x01, 0x72, 0xef, 0x78, 0xd6,
	0xff, 0xca, 0x90, 0x6f
};
static const uint8_t nist_kas_ecc_cdh_testvector_215_private[] = {
/* dIUT */
	0x00, 0x31, 0x41, 0xaf, 0xbb, 0xa8, 0xb4, 0xd9, 0xf0, 0xcb, 0xe8, 0x29,
	0x7f, 0x36, 0x58, 0x73, 0x19, 0x67, 0x39, 0x46, 0x5e, 0x3e, 0x20, 0xa8,
	0x9a, 0xf9, 0xfd, 0xf8, 0xb0, 0x1d, 0x19, 0x5a, 0xa1, 0x05, 0x2e, 0x61,
	0x76, 0xb5, 0xfa, 0xd8, 0x56, 0x13, 0x6b, 0x6b, 0x32, 0x0e, 0xeb, 0xfc,
	0x08, 0xc1, 0xcd, 0x01
};
/* QIUTx = 01805ffc576e8a45f06297b2335d03abc8adfd15ad37e76d80d3b4180d5f72efc90f3f2b036acd817f40fd49064aa25ea383c82e */
/* QIUTy = 01f22da6b50ac5628943f05b141493cacc0f02bcdf3bffdb43582343b68615761a180bd7d1ab1ddc15f5374a8f665d13b4b91272 */
static const uint8_t nist_kas_ecc_cdh_testvector_215_out[] = {
/* ZIUT */
	0x01, 0x9a, 0x71, 0xab, 0x57, 0x65, 0x46, 0xe2, 0x35, 0x1a, 0xa9, 0x2b,
	0x60, 0x75, 0xe8, 0x22, 0x98, 0x13, 0xe6, 0xa2, 0xcb, 0x36, 0x47, 0x14,
	0x7b, 0x19, 0x2b, 0x45, 0x97, 0xf1, 0x21, 0x72, 0x23, 0xe7, 0x19, 0x7d,
	0x84, 0x6c, 0x0d, 0x65, 0xea, 0x0d, 0x4a, 0xa4, 0xc5, 0x03, 0xbd, 0x00,
	0x0b, 0xa3, 0x12, 0xba
};
/* COUNT = 15 */
static const uint8_t nist_kas_ecc_cdh_testvector_216_public_x[] = {
/* QCAVSx */
	0x00, 0xbe, 0x7d, 0x58, 0x04, 0x32, 0x63, 0xab, 0x2f, 0x42, 0x25, 0x2d,
	0x41, 0xb5, 0x82, 0xd8, 0x62, 0xc2, 0xb2, 0x43, 0xce, 0x18, 0x57, 0x60,
	0x81, 0xbd, 0x6e, 0xdd, 0x2f, 0x63, 0xf0, 0x16, 0x4f, 0x36, 0x5c, 0xae,
	0x67, 0x26, 0x8d, 0x22, 0x7f, 0x39, 0x44, 0x67, 0x7e, 0x1c, 0x14, 0x6a,
	0xf8, 0x64, 0xb8, 0xae
};
static const uint8_t nist_kas_ecc_cdh_testvector_216_public_y[] = {
/* QCAVSy */
	0x01, 0xa4, 0xbc, 0xbc, 0x64, 0x16, 0xd8, 0x65, 0x97, 0xa1, 0x48, 0xca,
	0x4d, 0x61, 0x0e, 0xe6, 0x56, 0xa0, 0x00, 0x26, 0xce, 0x60, 0x47, 0xbd,
	0x9f, 0xbd, 0x40, 0xd8, 0x95, 0x30, 0x19, 0x6a, 0x46, 0x93, 0xae, 0x59,
	0x5d, 0x69, 0x95, 0x65, 0x03, 0xb9, 0xd2, 0xab, 0x4a, 0xab, 0xe7, 0xc9,
	0x58, 0xa1, 0x4c, 0x69
};
static const uint8_t nist_kas_ecc_cdh_testvector_216_private[] = {
/* dIUT */
	0x00, 0x4e, 0x51, 0x77, 0x96, 0xca, 0xc9, 0xd7, 0xc7, 0x53, 0x16, 0xeb,
	0x5e, 0x68, 0x96, 0x3f, 0xe6, 0x32, 0x47, 0x81, 0xfa, 0xb9, 0x86, 0xe9,
	0x40, 0x20, 0x0e, 0x71, 0x1d, 0xdb, 0xf9, 0x88, 0x2d, 0x99, 0xa6, 0x20,
	0xa9, 0x76, 0x35, 0x2e, 0x24, 0x96, 0x74, 0x8c, 0xfb, 0x61, 0xdc, 0xcb,
	0xf6, 0xd6, 0x59, 0xcc
};
/* QIUTx = 0056a452fb1d558079c3e91bf22f86884ca89788806fe7d6d6ca40b5485079d77dc43e466a71259792c65ff6ab7204066c0e67a8 */
/* QIUTy = 01f29b723d9f7d4de6ccc2f9708079c5d30ae5d960e62a7c4f6dc98bfc95b4f531f197c39486705432594203c25147156dfd5b5c */
static const uint8_t nist_kas_ecc_cdh_testvector_216_out[] = {
/* ZIUT */
	0x01, 0x4f, 0x4b, 0x7e, 0xa9, 0x3c, 0x9d, 0xd8, 0x46, 0xd2, 0x22, 0x8c,
	0x2b, 0x6a, 0x8d, 0xfe, 0x61, 0x60, 0x57, 0x23, 0x2b, 0x7a, 0xf8, 0x45,
	0xa5, 0x70, 0xcb, 0x6c, 0xac, 0xf9, 0xfe, 0xef, 0x2d, 0x8e, 0xf4, 0xfa,
	0xfb, 0x28, 0x5b, 0x38, 0xe6, 0x3c, 0xce, 0x0a, 0x09, 0xb4, 0xd8, 0x2d,
	0xbe, 0x43, 0xa3, 0x90
};
/* COUNT = 16 */
static const uint8_t nist_kas_ecc_cdh_testvector_217_public_x[] = {
/* QCAVSx */
	0x01, 0x1f, 0xea, 0x58, 0xd9, 0xe3, 0x6c, 0xf8, 0xed, 0x4e, 0xf3, 0xb4,
	0x2f, 0x77, 0xcc, 0xea, 0x93, 0xbf, 0x54, 0x2a, 0xc9, 0x21, 0x41, 0xdc,
	0x2c, 0x09, 0x40, 0x61, 0x98, 0x5f, 0x3d, 0xf7, 0x86, 0xd1, 0x92, 0xa5,
	0x7b, 0xee, 0x07, 0x25, 0x50, 0xb3, 0x02, 0x58, 0x3f, 0x0f, 0x94, 0x28,
	0x30, 0x1b, 0x1b, 0x76
};
static const uint8_t nist_kas_ecc_cdh_testvector_217_public_y[] = {
/* QCAVSy */
	0x01, 0xb3, 0xdc, 0xc1, 0xb8, 0xa3, 0x54, 0x52, 0x64, 0x42, 0x73, 0x86,
	0x32, 0x9e, 0xb8, 0x1f, 0xe9, 0x92, 0x65, 0x40, 0x40, 0x69, 0x47, 0x81,
	0xc0, 0xd8, 0xb2, 0x7c, 0x1e, 0x49, 0x44, 0x2b, 0x99, 0xba, 0xb9, 0x3e,
	0xf9, 0x66, 0x6f, 0xea, 0x14, 0xd4, 0x84, 0x3e, 0xe4, 0xbc, 0x5b, 0x04,
	0x5a, 0xc5, 0x0c, 0x11
};
static const uint8_t nist_kas_ecc_cdh_testvector_217_private[] = {
/* dIUT */
	0x00, 0x1c, 0x80, 0xb6, 0x4d, 0x51, 0xe8, 0x02, 0x56, 0x99, 0xe7, 0xbe,
	0x2c, 0x4b, 0x98, 0x3c, 0xfa, 0x4b, 0x7e, 0x91, 0xb1, 0x12, 0xe2, 0xec,
	0xa5, 0xf9, 0xd0, 0xcb, 0x7e, 0x3d, 0x4f, 0x85, 0xaf, 0xf7, 0xb3, 0x3a,
	0x92, 0x1e, 0xaa, 0x12, 0x4c, 0xb7, 0x00, 0x2e, 0xab, 0x62, 0x97, 0x3d,
	0x65, 0xe1, 0x6b, 0xc9
};
/* QIUTx = 01fd0e4eafb26c08c9f8e747d4991f468c76b4864166e37642b583db285a4bc4c33979917d9129a91cb0a75c1aee7cd4fbab73ce */
/* QIUTy = 00468efabcf448fcce821f3de81e994d79a7d99ea989ac81fa135f7ac88b154c767909c681f7e48c00b2e66bbaeb8f8688f44672 */
static const uint8_t nist_kas_ecc_cdh_testvector_217_out[] = {
/* ZIUT */
	0x00, 0x1f, 0xe2, 0xed, 0x30, 0xad, 0x41, 0x43, 0xc5, 0xee, 0xb0, 0xb7,
	0x62, 0x2e, 0x6a, 0xa4, 0x9e, 0x4e, 0x4d, 0x51, 0xc1, 0xdd, 0xc4, 0x67,
	0xb3, 0xfc, 0x54, 0x21, 0x5d, 0xae, 0x93, 0x1b, 0xe0, 0xb6, 0xb6, 0x44,
	0x3e, 0x71, 0x68, 0x95, 0xac, 0xb6, 0x57, 0x0c, 0xdc, 0x21, 0xfc, 0xbd,
	0xae, 0x46, 0xe5, 0xd6
};
/* COUNT = 17 */
static const uint8_t nist_kas_ecc_cdh_testvector_218_public_x[] = {
/* QCAVSx */
	0x00, 0xca, 0x80, 0x93, 0x40, 0xbd, 0x13, 0x35, 0x4b, 0x60, 0x71, 0xd0,
	0x73, 0xe6, 0x5b, 0x9b, 0x0d, 0x2b, 0xac, 0x82, 0xe2, 0x2a, 0xbf, 0xca,
	0xc7, 0xe7, 0x0a, 0xfd, 0x9d, 0x22, 0x48, 0x52, 0xf0, 0xe2, 0x12, 0x97,
	0x6e, 0x5e, 0xc8, 0x23, 0xeb, 0x89, 0x50, 0xe0, 0x2b, 0xc7, 0x59, 0xec,
	0xf5, 0x6f, 0x79, 0xa8
};
static const uint8_t nist_kas_ecc_cdh_testvector_218_public_y[] = {
/* QCAVSy */
	0x00, 0x31, 0x28, 0x1e, 0x89, 0x76, 0x40, 0x1a, 0xab, 0x58, 0xfa, 0x8e,
	0xaf, 0x86, 0x36, 0xfe, 0xb0, 0x13, 0x17, 0x0b, 0xca, 0xb5, 0x78, 0x1b,
	0xe0, 0xa2, 0x8d, 0x27, 0x33, 0x9e, 0x94, 0x70, 0xe1, 0x66, 0xc7, 0xf6,
	0x85, 0xf2, 0xea, 0x91, 0x43, 0x31, 0x0d, 0xca, 0x1b, 0x3a, 0xb8, 0xe1,
	0xc8, 0xe6, 0x05, 0x92
};
static const uint8_t nist_kas_ecc_cdh_testvector_218_private[] = {
/* dIUT */
	0x00, 0x43, 0xc9, 0x6c, 0x32, 0xcf, 0x64, 0x8b, 0x03, 0x61, 0x12, 0x42,
	0x1a, 0xdb, 0xaa, 0x92, 0x5c, 0xd5, 0x41, 0x75, 0xab, 0xad, 0x39, 0xe5,
	0x68, 0x1b, 0xfc, 0x9e, 0xb4, 0xb1, 0xb6, 0x49, 0xae, 0xc1, 0xc8, 0x76,
	0xec, 0x1e, 0xc4, 0x61, 0x0f, 0x1b, 0x3b, 0x06, 0x51, 0x4a, 0x48, 0xe6,
	0xea, 0x7a, 0x4a, 0x25
};
/* QIUTx = 00de181e81b9e7776d474694a2d124d0b876d9548f20ee3386304945d9131f90457d9b938df098b035bedaaf80ed6d979404fc70 */
/* QIUTy = 0181a3516dbea9da97d6ececdb10f96d54469d273ab366e89a40fdcedcf1bda837d5c14bd10c0b6a2a9c8a47810125c764dd35ef */
static const uint8_t nist_kas_ecc_cdh_testvector_218_out[] = {
/* ZIUT */
	0x01, 0x61, 0x0e, 0xfb, 0x48, 0xfd, 0x22, 0x26, 0x19, 0x21, 0xf7, 0x48,
	0x4e, 0xd6, 0x38, 0x2f, 0xce, 0xb6, 0xbd, 0xf2, 0x8f, 0x3b, 0xc2, 0x34,
	0x0a, 0x17, 0x5b, 0x79, 0x71, 0xb9, 0x3e, 0xd5, 0xff, 0x35, 0x7e, 0xd5,
	0x5e, 0x53, 0x07, 0xbb, 0xf4, 0x2e, 0x40, 0xa5, 0xb3, 0xfa, 0xbd, 0xae,
	0xd0, 0xce, 0x19, 0xa2
};
/* COUNT = 18 */
static const uint8_t nist_kas_ecc_cdh_testvector_219_public_x[] = {
/* QCAVSx */
	0x00, 0x74, 0x79, 0x5b, 0x0a, 0x9c, 0xa0, 0x70, 0x49, 0x1f, 0xb5, 0x4a,
	0x3b, 0xc2, 0x49, 0x98, 0x1d, 0xef, 0xbe, 0xc0, 0x37, 0xe4, 0x04, 0x0f,
	0x76, 0x65, 0x64, 0x28, 0xb1, 0x53, 0x8b, 0x97, 0x85, 0x03, 0xf8, 0x1f,
	0x80, 0xad, 0x9e, 0xf9, 0x7c, 0x5e, 0x12, 0x7b, 0xa5, 0x1e, 0xc0, 0x40,
	0x58, 0x4b, 0x9a, 0x20
};
static const uint8_t nist_kas_ecc_cdh_testvector_219_public_y[] = {
/* QCAVSy */
	0x00, 0x3e, 0xce, 0x27, 0xf3, 0xda, 0xef, 0xe7, 0xbd, 0xff, 0xdf, 0xa7,
	0x27, 0xb2, 0xaf, 0x95, 0xaf, 0x85, 0x91, 0xaf, 0x94, 0x6c, 0xdd, 0xfe,
	0x37, 0xe8, 0x56, 0x43, 0xb8, 0xd1, 0x79, 0xca, 0x8b, 0x95, 0x29, 0x10,
	0x6f, 0x9c, 0x5f, 0x3a, 0x95, 0xa8, 0x81, 0x92, 0x25, 0xf9, 0xd7, 0xd4,
	0xa7, 0x30, 0xfd, 0x22
};
static const uint8_t nist_kas_ecc_cdh_testvector_219_private[] = {
/* dIUT */
	0x00, 0x36, 0x36, 0x85, 0x4b, 0x8e, 0xe0, 0x25, 0x4b, 0xb2, 0xd0, 0xeb,
	0xed, 0xc7, 0x20, 0xb6, 0x6b, 0x20, 0x12, 0x9a, 0x21, 0xf1, 0xa4, 0xfe,
	0x39, 0x11, 0x8c, 0xfd, 0xd4, 0xd1, 0x37, 0xdb, 0xe5, 0xe5, 0x70, 0xeb,
	0xe2, 0xc4, 0x8a, 0x7f, 0x9a, 0xc2, 0x1c, 0xff, 0x3e, 0x5a, 0xdf, 0x47,
	0x43, 0x46, 0x97, 0xdb
};
/* QIUTx = 01efc0cd1a86ce7544f25f44e63a0913c11fd6b08bc09ad8cd82f3af7e32a7a7ecacd56e25526589313879d4a7fd4382d4114e4a */
/* QIUTy = 005a34ef7403599c2f83f3e83299524893f2418ff95d6c2fdc0a3db970e62fddcf4cda182aa78b54fd8c2e818fb1ee2dd2776763 */
static const uint8_t nist_kas_ecc_cdh_testvector_219_out[] = {
/* ZIUT */
	0x00, 0x8d, 0x99, 0x09, 0x82, 0xaa, 0xc8, 0xd5, 0x37, 0x1b, 0x86, 0x7d,
	0xe2, 0x1e, 0x09, 0x06, 0x4f, 0xef, 0x30, 0xe7, 0x33, 0x21, 0x33, 0x7d,
	0xc2, 0x4f, 0x19, 0xad, 0x5d, 0xdb, 0x6c, 0x4a, 0xd2, 0x17, 0x13, 0x6b,
	0x7c, 0x61, 0xe3, 0x60, 0xa7, 0x3f, 0xa7, 0x57, 0x1d, 0x52, 0x6c, 0x8f,
	0x51, 0x4a, 0x06, 0xd4
};
/* COUNT = 19 */
static const uint8_t nist_kas_ecc_cdh_testvector_220_public_x[] = {
/* QCAVSx */
	0x01, 0x1e, 0xb6, 0x4e, 0xd4, 0x24, 0x9e, 0x11, 0x95, 0xb2, 0xd1, 0x30,
	0x7a, 0x35, 0xa5, 0x14, 0xd6, 0x6d, 0x29, 0xba, 0x6f, 0x90, 0x44, 0xf9,
	0xc0, 0x2b, 0x4b, 0x2d, 0x3c, 0xb3, 0xe3, 0xd4, 0xc0, 0xcd, 0xc5, 0x48,
	0x9c, 0xdd, 0xfb, 0x96, 0x22, 0x6c, 0x9c, 0xe3, 0xe3, 0x6f, 0xb8, 0xff,
	0x2e, 0xef, 0x20, 0x8c
};
static const uint8_t nist_kas_ecc_cdh_testvector_220_public_y[] = {
/* QCAVSy */
	0x00, 0x99, 0x88, 0x0b, 0x0d, 0x0d, 0x43, 0xc5, 0xc5, 0x79, 0xad, 0x77,
	0xdd, 0xae, 0x68, 0xf2, 0xc9, 0x17, 0xf4, 0xb0, 0x62, 0xea, 0x8d, 0x77,
	0x7b, 0x9c, 0xdf, 0x46, 0x5c, 0xbb, 0x59, 0x10, 0x7e, 0x70, 0x99, 0x27,
	0x14, 0xe8, 0xcb, 0xfa, 0xc7, 0x62, 0x96, 0xd5, 0xed, 0xe9, 0x9c, 0x48,
	0xd3, 0x8a, 0x89, 0x73
};
static const uint8_t nist_kas_ecc_cdh_testvector_220_private[] = {
/* dIUT */
	0x00, 0x49, 0x98, 0xa0, 0x62, 0xa3, 0x21, 0x70, 0xbb, 0x35, 0x89, 0x54,
	0xd2, 0xc2, 0x49, 0x6d, 0xa8, 0x86, 0x20, 0x08, 0x27, 0xfa, 0x13, 0x56,
	0x68, 0x36, 0xae, 0x26, 0xe3, 0x8d, 0x51, 0x92, 0x6c, 0xa3, 0xd2, 0x02,
	0x58, 0x9f, 0x7b, 0xfa, 0x27, 0xea, 0x22, 0xd3, 0x99, 0x97, 0x3d, 0xb6,
	0xf9, 0xfd, 0xe9, 0xf4
};
/* QIUTx = 00f71590b04290b5f3cd9ba0e394a3be5a1514f45e53497f6cdedbf839728e0288135d769e4b28932c875823fe256e891997c476 */
/* QIUTy = 009d16ba726a5a9e09103bc94a09d8079ac8edf23410c8469f79f55f3355cfb3ad703624ec6d75eceae3881da20903c71de1f5ac */
static const uint8_t nist_kas_ecc_cdh_testvector_220_out[] = {
/* ZIUT */
	0x01, 0x55, 0xdc, 0x98, 0x72, 0x9c, 0x8c, 0x1b, 0xc6, 0x5e, 0xb8, 0xa3,
	0xec, 0x09, 0x13, 0x5f, 0x46, 0xbf, 0xa3, 0x13, 0xbf, 0x56, 0xaa, 0x31,
	0x69, 0xe3, 0x12, 0xdb, 0x89, 0x91, 0xab, 0xda, 0x33, 0x8f, 0x8a, 0xc7,
	0xa7, 0x5b, 0xce, 0x42, 0x88, 0x40, 0x68, 0xef, 0xb7, 0xe6, 0xe6, 0x25,
	0x93, 0x9d, 0x2b, 0x88
};
/* COUNT = 20 */
static const uint8_t nist_kas_ecc_cdh_testvector_221_public_x[] = {
/* QCAVSx */
	0x00, 0xa1, 0x5e, 0x96, 0xa7, 0x76, 0xea, 0xdb, 0x8f, 0x8a, 0x0b, 0x61,
	0x36, 0x03, 0x35, 0xcb, 0x50, 0x17, 0xd7, 0xd9, 0x71, 0x16, 0x48, 0x93,
	0x41, 0xe9, 0x95, 0x15, 0x7f, 0x1a, 0xdf, 0x17, 0x8e, 0x56, 0x28, 0xba,
	0xd3, 0xe8, 0x30, 0xbe, 0xe5, 0x44, 0x33, 0x11, 0x91, 0x64, 0x88, 0x6d,
	0xb5, 0xc3, 0x46, 0x54
};
static const uint8_t nist_kas_ecc_cdh_testvector_221_public_y[] = {
/* QCAVSy */
	0x00, 0x55, 0x1c, 0xa5, 0x60, 0x5e, 0x4a, 0xe0, 0x53, 0x45, 0x34, 0xa0,
	0xab, 0x34, 0x3d, 0x03, 0x9a, 0x3b, 0xa7, 0xa1, 0xcc, 0xe8, 0x32, 0xc4,
	0xd6, 0x5e, 0x26, 0xba, 0xe7, 0xab, 0x8e, 0x5f, 0x9c, 0x74, 0xb3, 0xd4,
	0x21, 0xa5, 0x28, 0xe5, 0x59, 0x77, 0x8a, 0xb2, 0x7b, 0x59, 0xaa, 0xe1,
	0xa9, 0x16, 0xd4, 0xeb
};
static const uint8_t nist_kas_ecc_cdh_testvector_221_private[] = {
/* dIUT */
	0x00, 0x5a, 0x3f, 0x80, 0x5f, 0xe3, 0xc3, 0x26, 0x6f, 0xeb, 0x3e, 0x0b,
	0xb7, 0xda, 0x67, 0x61, 0xbb, 0x11, 0x76, 0x18, 0xbc, 0x57, 0xaf, 0x35,
	0x7b, 0x53, 0xf1, 0x99, 0xe6, 0xe4, 0xcb, 0xc1, 0x28, 0x19, 0x75, 0x32,
	0x14, 0x03, 0xea, 0x6d, 0xe6, 0x18, 0xec, 0x32, 0xe8, 0x6b, 0x8c, 0xa1,
	0xe1, 0x0d, 0x7c, 0x43
};
/* QIUTx = 01ae460e1248504d33d67ed750f1d618e53728d55e390dfc18d94b56dbb3d3c0bdc96c92ca1eca9f44fb8a58cf36dcfcc0588cbe */
/* QIUTy = 00f7011fc321ef6258dcfc1fdc2c0a4e54c86ec939bc9ceca6c291750c1ff540b34a418793842a2c5cab6061dbbe9b5be3fa6115 */
static const uint8_t nist_kas_ecc_cdh_testvector_221_out[] = {
/* ZIUT */
	0x01, 0x09, 0xe8, 0x5c, 0x68, 0x4d, 0x02, 0x7a, 0x62, 0x5e, 0xc5, 0xe6,
	0xdf, 0x95, 0x2e, 0x2f, 0x20, 0xa1, 0x4e, 0xd5, 0xb0, 0x92, 0xd1, 0xb1,
	0xb3, 0x84, 0x35, 0x25, 0x13, 0x03, 0x84, 0x4d, 0x23, 0x0f, 0xff, 0xc5,
	0x3d, 0x84, 0xb9, 0x23, 0x55, 0x5e, 0x1e, 0x1c, 0xbe, 0xbe, 0x20, 0xb5,
	0xd6, 0x8c, 0x3b, 0xc6
};
/* COUNT = 21 */
static const uint8_t nist_kas_ecc_cdh_testvector_222_public_x[] = {
/* QCAVSx */
	0x01, 0x64, 0x27, 0xe7, 0x2b, 0xc5, 0x7d, 0x26, 0xa9, 0x10, 0xa6, 0x72,
	0x2e, 0xac, 0x2c, 0x78, 0xfb, 0xa8, 0xab, 0xff, 0xcc, 0xbc, 0x11, 0xa9,
	0xf8, 0x37, 0x7b, 0xfe, 0x21, 0x3e, 0xd9, 0xad, 0x64, 0xbd, 0xe2, 0xae,
	0x86, 0x87, 0xf8, 0xff, 0x1d, 0xfd, 0xb2, 0x9b, 0x5d, 0xce, 0xcd, 0x02,
	0x26, 0x98, 0x28, 0xc2
};
static const uint8_t nist_kas_ecc_cdh_testvector_222_public_y[] = {
/* QCAVSy */
	0x00, 0xad, 0x4f, 0x9a, 0xbc, 0x21, 0xda, 0x0d, 0x31, 0xf1, 0x96, 0x59,
	0xcd, 0x3b, 0x0c, 0x18, 0x55, 0x81, 0x43, 0x6a, 0xc0, 0x8b, 0x15, 0xc0,
	0xb4, 0x8a, 0x7a, 0xc3, 0x9e, 0xed, 0x03, 0xe0, 0xee, 0x97, 0xe1, 0x64,
	0xcf, 0xaa, 0x5a, 0xbc, 0x77, 0x44, 0x12, 0xcb, 0xff, 0xf9, 0x4a, 0x9e,
	0xa2, 0xa9, 0x63, 0x6a
};
static const uint8_t nist_kas_ecc_cdh_testvector_222_private[] = {
/* dIUT */
	0x00, 0x55, 0x90, 0x1e, 0x9b, 0x65, 0x86, 0xb7, 0xf3, 0x37, 0x26, 0x60,
	0xeb, 0xcf, 0xe9, 0x02, 0x49, 0x90, 0x0c, 0x90, 0x2d, 0x7c, 0x63, 0x2a,
	0x8d, 0x17, 0xfa, 0xe2, 0x1d, 0x3f, 0xde, 0x30, 0x37, 0x32, 0x5b, 0x57,
	0x75, 0xea, 0xc5, 0xa1, 0x74, 0xa1, 0xee, 0x2b, 0x3f, 0xf2, 0xbc, 0x5c,
	0xe6, 0x9d, 0x8c, 0xc1
};
/* QIUTx = 00ba952233531b6a6c7ade6f338d24fc65777b5d305297e66d32cb1bc506c5bca2287d3acd33fe19653d6c88a06eca3712ce9caa */
/* QIUTy = 00716beb14f02233630f34603e309bf6e2572f0b791dfa4c582af6a37abcdd64e8d785a95ddff59bbc6fbe1b7fc735725efcf0ba */
static const uint8_t nist_kas_ecc_cdh_testvector_222_out[] = {
/* ZIUT */
	0x01, 0xae, 0x81, 0x4e, 0x02, 0xc4, 0x68, 0x4c, 0x21, 0xdd, 0x7e, 0x58,
	0xa6, 0x5e, 0xc5, 0x1e, 0xc6, 0x8c, 0x37, 0xe5, 0x9e, 0x29, 0x9c, 0xe6,
	0x56, 0x08, 0x18, 0x6c, 0x0a, 0xcc, 0xe0, 0x8e, 0x41, 0xc8, 0x32, 0x0b,
	0x19, 0x41, 0xa6, 0x11, 0xfe, 0x66, 0xb1, 0x92, 0x1b, 0x55, 0x8d, 0x7f,
	0x40, 0x2d, 0x0e, 0xb0
};
/* COUNT = 22 */
static const uint8_t nist_kas_ecc_cdh_testvector_223_public_x[] = {
/* QCAVSx */
	0x01, 0x2e, 0x89, 0xdc, 0xcd, 0xf9, 0x75, 0x85, 0x1a, 0xcc, 0xf0, 0x29,
	0x4c, 0xf4, 0xbd, 0xe1, 0x25, 0x9c, 0x90, 0x7a, 0x6d, 0x3a, 0xce, 0xf6,
	0x9f, 0x19, 0x39, 0xb5, 0x58, 0xc4, 0xd2, 0x11, 0x52, 0x2e, 0x4e, 0xaa,
	0xc6, 0x13, 0xe3, 0xac, 0x84, 0x91, 0xc9, 0x3d, 0xeb, 0x6d, 0x34, 0x4a,
	0x9f, 0x87, 0xac, 0xbe
};
static const uint8_t nist_kas_ecc_cdh_testvector_223_public_y[] = {
/* QCAVSy */
	0x01, 0xa5, 0x26, 0x08, 0xea, 0xd0, 0x9d, 0x2d, 0xb1, 0x23, 0xa0, 0xdc,
	0x78, 0x2a, 0xb2, 0x0d, 0xdb, 0x79, 0x3d, 0x5b, 0xb7, 0x0a, 0xc9, 0x5c,
	0x58, 0xe6, 0x21, 0x46, 0xbe, 0xb6, 0x2b, 0xb6, 0x68, 0xfd, 0x57, 0xf9,
	0x20, 0x38, 0xe4, 0x58, 0x5c, 0xde, 0x1f, 0x91, 0xee, 0x8c, 0x52, 0x52,
	0x6a, 0xfe, 0xb1, 0xb5
};
static const uint8_t nist_kas_ecc_cdh_testvector_223_private[] = {
/* dIUT */
	0x00, 0x04, 0x4a, 0xe4, 0x3b, 0xd2, 0x47, 0xe7, 0x5a, 0xfa, 0x7b, 0xd8,
	0xdc, 0x28, 0xe7, 0x5b, 0xdb, 0x9d, 0xdd, 0x99, 0xdf, 0x56, 0x66, 0x8c,
	0x83, 0x14, 0x54, 0xdc, 0x28, 0xf3, 0xe9, 0xa4, 0x4e, 0xcf, 0xd4, 0x7b,
	0xa8, 0x42, 0x0a, 0x28, 0x6f, 0x1e, 0xf3, 0x72, 0xfd, 0x29, 0xb3, 0x65,
	0xdf, 0x9b, 0x82, 0xf1
};
/* QIUTx = 00202694f378d70965d42828ad5f37137bf8b63cec2c0d158e5ba94cab1f8e61e5a300986ba349b3adf3efc05e65670af88cd3d6 */
/* QIUTy = 00baf0da4aedb972f88a215dfbff64e4290fadc25da3f0d83f35e65bc4177d3025d71d8eeb9c41470f3c719e00ef1fb7552e6a89 */
static const uint8_t nist_kas_ecc_cdh_testvector_223_out[] = {
/* ZIUT */
	0x01, 0x40, 0xe7, 0xdb, 0x3f, 0x64, 0x15, 0xd8, 0x84, 0x82, 0x2c, 0xcc,
	0x73, 0x16, 0xa3, 0x29, 0xdf, 0xed, 0x17, 0x7b, 0x76, 0xc0, 0x11, 0x7a,
	0xbd, 0x72, 0x2f, 0xec, 0xa8, 0x89, 0xbe, 0xe4, 0xe1, 0x4e, 0x65, 0xd2,
	0x6c, 0x6c, 0xc9, 0x35, 0xc0, 0xe9, 0x42, 0x05, 0xf0, 0x5f, 0xc1, 0xa7,
	0xab, 0xfb, 0x03, 0x48
};
/* COUNT = 23 */
static const uint8_t nist_kas_ecc_cdh_testvector_224_public_x[] = {
/* QCAVSx */
	0x00, 0xab, 0xa9, 0x3a, 0xe1, 0xd1, 0x55, 0x28, 0x80, 0xb3, 0x1f, 0x50,
	0x3f, 0xc4, 0xbe, 0x9f, 0x91, 0xd1, 0x02, 0x47, 0xf1, 0x4c, 0x81, 0x60,
	0x15, 0xff, 0xb2, 0xba, 0xd2, 0x9a, 0xb8, 0x18, 0x0e, 0x7b, 0x50, 0xa2,
	0x71, 0x44, 0xe0, 0x1c, 0x21, 0xe6, 0x3c, 0x3d, 0xaf, 0xcd, 0x25, 0x13,
	0x08, 0xba, 0xc7, 0x68
};
static const uint8_t nist_kas_ecc_cdh_testvector_224_public_y[] = {
/* QCAVSy */
	0x00, 0xe4, 0xab, 0x66, 0xe5, 0x14, 0xbd, 0x02, 0xab, 0xea, 0xe1, 0xc7,
	0x12, 0x37, 0x88, 0xa6, 0x92, 0x58, 0x4d, 0xdb, 0x4a, 0x90, 0x9a, 0x21,
	0x7f, 0xb3, 0x5d, 0xe6, 0x65, 0x88, 0x23, 0x3d, 0xad, 0xef, 0x70, 0x36,
	0xff, 0x9d, 0x9f, 0x24, 0xeb, 0xa3, 0x77, 0x2e, 0x2f, 0xa3, 0x03, 0x7b,
	0xba, 0xe6, 0x3c, 0xfe
};
static const uint8_t nist_kas_ecc_cdh_testvector_224_private[] = {
/* dIUT */
	0x00, 0x56, 0xd7, 0x37, 0x30, 0x75, 0x3a, 0xda, 0x70, 0xfd, 0x80, 0x1c,
	0x74, 0x9c, 0x2f, 0x1f, 0x1a, 0x61, 0xef, 0x5b, 0xd6, 0xec, 0xb7, 0x96,
	0xa9, 0xe1, 0x5e, 0xfe, 0x9b, 0xbe, 0x61, 0x58, 0xf6, 0x69, 0x54, 0x27,
	0x87, 0x35, 0x0f, 0x4d, 0x64, 0x3b, 0xda, 0x6f, 0x3e, 0x8c, 0x64, 0x23,
	0xb8, 0x17, 0xb5, 0x30
};
/* QIUTx = 0025a06b71a0ae252f2f905221983ebfce21ad96121a5c0dcc5ef0d0fec301ec77ef4b915818fedcda7f3fd733c7f9e529079cb6 */
/* QIUTy = 00026890d5303b619c7f81f60fb82b26b0b98d8f24c45cab41a44eeb3a3a312944e889b4035e04360b305043e30d0cb9041a89de */
static const uint8_t nist_kas_ecc_cdh_testvector_224_out[] = {
/* ZIUT */
	0x00, 0x2e, 0xc4, 0xde, 0xac, 0x3e, 0x83, 0xd6, 0x0a, 0xd3, 0x99, 0x69,
	0xf2, 0xf9, 0x3b, 0x49, 0xf3, 0x18, 0x75, 0x83, 0x1e, 0xcd, 0x51, 0xea,
	0x5c, 0x37, 0xca, 0x48, 0xde, 0x08, 0x1c, 0x0c, 0x8c, 0xc6, 0x60, 0xed,
	0xc5, 0x3a, 0x22, 0x2f, 0x30, 0x43, 0x44, 0x7f, 0x9c, 0xb7, 0x52, 0x76,
	0x3b, 0xe7, 0x49, 0x4a
};
/* COUNT = 24 */
static const uint8_t nist_kas_ecc_cdh_testvector_225_public_x[] = {
/* QCAVSx */
	0x00, 0xaa, 0x4e, 0xb8, 0x98, 0x44, 0x3c, 0xce, 0x3e, 0xd2, 0xc0, 0x72,
	0xd8, 0x58, 0x77, 0x5a, 0xc2, 0x21, 0xc2, 0x4e, 0x33, 0xec, 0xa6, 0xf3,
	0x15, 0x79, 0x66, 0x35, 0x44, 0xbb, 0x33, 0xa4, 0xa0, 0x68, 0xa8, 0x6d,
	0x13, 0xf1, 0x67, 0xb6, 0x53, 0x04, 0xc5, 0xf7, 0xf2, 0x5f, 0x89, 0x5f,
	0x65, 0xb2, 0xf4, 0x28
};
static const uint8_t nist_kas_ecc_cdh_testvector_225_public_y[] = {
/* QCAVSy */
	0x00, 0x83, 0xcd, 0xed, 0x30, 0x21, 0x1b, 0x66, 0xf1, 0xad, 0xf1, 0x73,
	0x18, 0xb6, 0xde, 0x50, 0xd7, 0x72, 0x4c, 0x05, 0x84, 0x99, 0x5e, 0x06,
	0x8b, 0x72, 0x47, 0x03, 0xae, 0x08, 0xed, 0x71, 0xa3, 0x2b, 0x33, 0x49,
	0x87, 0xa7, 0xb3, 0x1d, 0x6c, 0x26, 0x37, 0x15, 0x29, 0x17, 0x32, 0x7d,
	0x37, 0xac, 0xcd, 0x33
};
static const uint8_t nist_kas_ecc_cdh_testvector_225_private[] = {
/* dIUT */
	0x00, 0x62, 0xb0, 0x26, 0xd4, 0x97, 0x20, 0x66, 0x0c, 0xf6, 0xa4, 0xf5,
	0x69, 0xbe, 0x98, 0xdf, 0xa1, 0x08, 0xc8, 0xeb, 0xa0, 0x82, 0x34, 0xae,
	0x9a, 0x87, 0xf3, 0xc8, 0x8b, 0x6c, 0x65, 0x93, 0x4b, 0x99, 0x68, 0x15,
	0x32, 0x2a, 0x16, 0xf9, 0xaa, 0xbe, 0xd1, 0x33, 0x17, 0xbf, 0x77, 0x25,
	0xbe, 0xa5, 0x80, 0x8e
};
/* QIUTx = 000f52925394cb52bc330e06390c0c0a2e10ed9797149fbcc88d80fbcaec173e24a05daef98401d5e47f3b765bedbb8246312856 */
/* QIUTy = 013d99c1710805d5fc7db7259ac9e134b411d00d73fb0762e3d211cdc56bf7f714512d04a630c8732551ee734287476cf511e836 */
static const uint8_t nist_kas_ecc_cdh_testvector_225_out[] = {
/* ZIUT */
	0x01, 0xc9, 0xcc, 0x05, 0xd1, 0x9f, 0x96, 0xc4, 0xd2, 0x33, 0x03, 0x9c,
	0xfb, 0xc4, 0x3a, 0xb6, 0x8d, 0x65, 0x7b, 0xb5, 0x07, 0xf4, 0x6a, 0x35,
	0x30, 0x91, 0xfe, 0x98, 0xfc, 0x0f, 0x42, 0x2a, 0x8e, 0x75, 0x93, 0xc1,
	0x95, 0xd3, 0x26, 0x97, 0x7a, 0x2b, 0xe6, 0xbb, 0xd2, 0xcb, 0x44, 0xeb,
	0x1f, 0xe8, 0x16, 0x50
};
/* [K-571] - GP NOT SUPPORTED */
/* COUNT = 0 */
static const uint8_t nist_kas_ecc_cdh_testvector_226_public_x[] = {
/* QCAVSx */
	0x03, 0x10, 0x6a, 0x5c, 0x1d, 0x92, 0x3a, 0x09, 0x90, 0xea, 0x8c, 0x60,
	0x08, 0xc3, 0x6c, 0x36, 0x6b, 0x53, 0xe5, 0x62, 0x2b, 0x98, 0x46, 0x40,
	0x44, 0x74, 0x1f, 0xbc, 0x78, 0x40, 0x28, 0x4d, 0xb8, 0xbb, 0xf6, 0x02,
	0x86, 0x6c, 0x30, 0xcc, 0xbf, 0x5f, 0x9b, 0x7e, 0x59, 0xcc, 0x1d, 0x9b,
	0xfc, 0xc5, 0xb9, 0x70, 0xfa, 0x62, 0x4d, 0xa9, 0xb1, 0x5f, 0x6c, 0xb3,
	0x36, 0xf5, 0xdd, 0xa7, 0xe6, 0xb9, 0x92, 0x4d, 0x5d, 0xce, 0x45, 0x43
};
static const uint8_t nist_kas_ecc_cdh_testvector_226_public_y[] = {
/* QCAVSy */
	0x00, 0x5c, 0x5c, 0x7b, 0xbd, 0x5a, 0x78, 0x9a, 0xc4, 0xc6, 0x28, 0x3d,
	0xeb, 0x0d, 0x0d, 0x37, 0xc4, 0x85, 0x2b, 0xaa, 0x57, 0xd6, 0xbc, 0x2b,
	0x0a, 0xc6, 0x33, 0x7f, 0xeb, 0x09, 0x70, 0x4c, 0x44, 0xd1, 0xb3, 0x85,
	0xb7, 0x0c, 0xc3, 0x94, 0xfa, 0x23, 0x5d, 0x83, 0xe6, 0xe7, 0x11, 0x17,
	0x87, 0xe5, 0x7d, 0x09, 0x02, 0xc0, 0xcb, 0x13, 0x2a, 0x19, 0x0a, 0x6e,
	0x62, 0xf3, 0x98, 0x51, 0x1c, 0x0c, 0x2c, 0x4c, 0xd5, 0x0d, 0x45, 0x70
};
static const uint8_t nist_kas_ecc_cdh_testvector_226_private[] = {
/* dIUT */
	0x01, 0x73, 0xcd, 0x16, 0x31, 0xe1, 0x8e, 0xce, 0x01, 0xb7, 0x3b, 0x35,
	0x72, 0xff, 0xaa, 0x74, 0x95, 0xc4, 0xbc, 0x81, 0xf4, 0x07, 0x8a, 0xe5,
	0x0d, 0x69, 0xcb, 0x1e, 0x33, 0x8a, 0xcf, 0x13, 0x46, 0x91, 0x17, 0x11,
	0x29, 0x21, 0x16, 0x6d, 0xdf, 0x2d, 0x29, 0xf3, 0xa9, 0xf8, 0xe1, 0x0c,
	0x67, 0xe8, 0x8c, 0x9a, 0x99, 0x20, 0x3a, 0x83, 0x45, 0x65, 0xbe, 0x76,
	0xac, 0x59, 0x12, 0x64, 0x36, 0x73, 0x9a, 0x6a, 0xfa, 0x02, 0x9c, 0xc5
};
/* QIUTx = 03fbfbbcfba609157f68a23126d805f7c75efb19befb595e3a975e08ff46bd34c8b87b9645c0e86ea0ad915465d5c856c69bb9b722b0d17bf97ad95c4602dea17c6b512054cb22d8 */
/* QIUTy = 071c16df71e1b71b4bd3d9938827d3959093b9db1ff86bed73944a42dcb67cc33102e28c1d0e9804a6450656f4bf33ad72ecf7bb83bd282cde4bc15d4e48064aa8ad2f02979f5f3f */
static const uint8_t nist_kas_ecc_cdh_testvector_226_out[] = {
/* ZIUT */
	0x00, 0x31, 0x98, 0xa6, 0xb5, 0xd6, 0xcc, 0xe8, 0x47, 0xe2, 0x43, 0x48,
	0xa6, 0xa6, 0xce, 0xff, 0x7a, 0x89, 0xed, 0x37, 0x94, 0xd7, 0xac, 0xed,
	0xc4, 0xe8, 0x58, 0xc8, 0x0a, 0xd0, 0x4a, 0x74, 0xdb, 0xc0, 0x2c, 0x70,
	0x38, 0xe0, 0x5a, 0xb2, 0x6b, 0x2a, 0x29, 0x9e, 0xc9, 0x2e, 0xe0, 0xd2,
	0xc7, 0xe6, 0x6a, 0x81, 0x87, 0x2a, 0x51, 0x57, 0xfb, 0xc5, 0xd4, 0xd3,
	0x7a, 0xd5, 0x98, 0xd6, 0xdd, 0xee, 0x99, 0x5e, 0xd2, 0x8a, 0x2d, 0x74
};
/* COUNT = 1 */
static const uint8_t nist_kas_ecc_cdh_testvector_227_public_x[] = {
/* QCAVSx */
	0x02, 0x11, 0x22, 0x3c, 0x4b, 0x72, 0x9b, 0x20, 0x6b, 0xe0, 0x1f, 0x80,
	0x85, 0xa9, 0x97, 0xe1, 0xdd, 0xe5, 0xcd, 0xb2, 0x7c, 0x04, 0x89, 0x25,
	0xa2, 0x73, 0x69, 0xbc, 0xca, 0x6a, 0x3e, 0x2f, 0xbf, 0xc6, 0x56, 0x37,
	0xf1, 0xec, 0xeb, 0x13, 0x3b, 0xe7, 0x49, 0x67, 0x9a, 0x17, 0xb1, 0xce,
	0x58, 0x82, 0x1f, 0x46, 0xbd, 0x18, 0x44, 0xa8, 0x9c, 0xf0, 0x04, 0x2c,
	0x80, 0x43, 0xcb, 0x10, 0x5e, 0x01, 0xa3, 0xfc, 0x94, 0x8d, 0x26, 0x63
};
static const uint8_t nist_kas_ecc_cdh_testvector_227_public_y[] = {
/* QCAVSy */
	0x02, 0xb1, 0xec, 0x2e, 0x6e, 0x2c, 0x23, 0x75, 0xb4, 0x64, 0xb0, 0xa5,
	0x02, 0xc5, 0x05, 0x3b, 0x5b, 0x34, 0x8b, 0xd0, 0x81, 0x78, 0xc7, 0x2c,
	0x60, 0x31, 0x05, 0xd0, 0x46, 0x81, 0x96, 0xa4, 0x69, 0x5d, 0xc2, 0x67,
	0xd6, 0xe1, 0x09, 0xf1, 0xb1, 0x27, 0x44, 0x53, 0xb6, 0xef, 0xf1, 0x4d,
	0xdf, 0x37, 0x83, 0x96, 0x9e, 0x88, 0x25, 0x64, 0x8d, 0xeb, 0xc2, 0x16,
	0xaf, 0xff, 0x92, 0x58, 0xf6, 0x44, 0xd7, 0x7e, 0xcd, 0x99, 0x11, 0xcf
};
static const uint8_t nist_kas_ecc_cdh_testvector_227_private[] = {
/* dIUT */
	0x00, 0x93, 0x7e, 0xdb, 0x3a, 0xa2, 0x95, 0x63, 0xd2, 0x24, 0x85, 0x91,
	0xc9, 0xfb, 0x44, 0x89, 0x85, 0x09, 0x5f, 0x91, 0x3a, 0x74, 0x58, 0x31,
	0x55, 0x93, 0xcf, 0xce, 0x87, 0xe6, 0x8f, 0xb0, 0xf1, 0xa5, 0x25, 0xb7,
	0x31, 0x0a, 0x10, 0x11, 0x76, 0xe3, 0x4d, 0x45, 0xc1, 0x00, 0x45, 0x38,
	0x95, 0x4e, 0x20, 0x44, 0x54, 0x38, 0x17, 0xca, 0xb0, 0xd5, 0x63, 0xdf,
	0x6c, 0xb0, 0xd5, 0xe8, 0x61, 0x7b, 0xbb, 0xa1, 0x50, 0xe7, 0x55, 0xe1
};
/* QIUTx = 02363cc5624b06df1956befa597d4c757cc2b1001a3e1544d24408290f694877455ba92e56088462f0ffacbd393cf835b56b7046a15d4b724dc6c3573cb156c0df298aa8b1255cb8 */
/* QIUTy = 0409f773b98d5edc2734d835953281b82ac0e15d902d887a7c6ba75629a37671b101d18ddfdc4193d98b18551414c49173004530f7976d27c273a73ddbb898fcb5fade9c0bb7883f */
static const uint8_t nist_kas_ecc_cdh_testvector_227_out[] = {
/* ZIUT */
	0x00, 0x57, 0x71, 0x47, 0x45, 0x92, 0x62, 0xe5, 0xad, 0x42, 0xf2, 0x22,
	0x82, 0x7f, 0x20, 0xed, 0x57, 0x4b, 0x21, 0x18, 0x92, 0x42, 0x05, 0xbc,
	0xdb, 0xd3, 0x39, 0xce, 0x20, 0xcf, 0xb0, 0x85, 0xd0, 0x72, 0xfd, 0x70,
	0xf4, 0xca, 0x1f, 0x57, 0x68, 0xfa, 0xfa, 0xeb, 0x57, 0x10, 0xf7, 0xcc,
	0xbe, 0xa4, 0xfc, 0x2a, 0xe5, 0x37, 0x7b, 0x0c, 0xff, 0x20, 0xa8, 0x89,
	0xa2, 0x20, 0x17, 0x39, 0x13, 0x9b, 0xf7, 0x88, 0xa9, 0xbf, 0x2d, 0x7d
};
/* COUNT = 2 */
static const uint8_t nist_kas_ecc_cdh_testvector_228_public_x[] = {
/* QCAVSx */
	0x00, 0x4d, 0x48, 0xbe, 0x59, 0x9e, 0xbb, 0x1e, 0xd6, 0x02, 0x47, 0x2d,
	0x7a, 0x87, 0xf4, 0xcd, 0x20, 0x80, 0xf4, 0x4e, 0xc2, 0x88, 0x55, 0xfe,
	0xcc, 0x3a, 0x9c, 0xdd, 0xe2, 0x55, 0x51, 0x78, 0x7a, 0xbd, 0x27, 0xcc,
	0x1d, 0xa7, 0xe7, 0x78, 0x17, 0xe9, 0x4c, 0x9c, 0x02, 0x89, 0xc0, 0x05,
	0xa0, 0xe3, 0x6e, 0x3b, 0xcf, 0xb0, 0xd3, 0x81, 0xe8, 0xcc, 0x96, 0x84,
	0xb6, 0xf7, 0xdd, 0x05, 0x17, 0x7f, 0x16, 0xf6, 0x3f, 0x87, 0x21, 0xca
};
static const uint8_t nist_kas_ecc_cdh_testvector_228_public_y[] = {
/* QCAVSy */
	0x06, 0x2c, 0xf7, 0x1a, 0xf0, 0xa2, 0xf8, 0xe3, 0x5c, 0x4d, 0x7f, 0x93,
	0x12, 0xbd, 0x34, 0xa8, 0x46, 0xa3, 0x80, 0xf6, 0x3f, 0x0d, 0xc7, 0x29,
	0x4c, 0x18, 0x87, 0x71, 0x03, 0x35, 0x7e, 0x20, 0xd1, 0xf0, 0xee, 0xff,
	0x31, 0x2a, 0x99, 0x3d, 0xeb, 0x2a, 0x1e, 0xcf, 0xc8, 0x0a, 0xea, 0x06,
	0xa5, 0xb7, 0x1e, 0x4f, 0x8b, 0x9c, 0xef, 0xae, 0xbc, 0xd3, 0x26, 0x26,
	0x91, 0x90, 0x64, 0xf8, 0x8a, 0xf4, 0x16, 0xd8, 0x6e, 0x3e, 0x7a, 0xf3
};
static const uint8_t nist_kas_ecc_cdh_testvector_228_private[] = {
/* dIUT */
	0x00, 0x34, 0x09, 0x9b, 0x07, 0x73, 0xf0, 0x21, 0xee, 0x0d, 0x3d, 0xd1,
	0x85, 0xc7, 0x04, 0xb5, 0x15, 0x8a, 0x94, 0x32, 0x8d, 0xaa, 0x09, 0x76,
	0x8f, 0xad, 0x58, 0x04, 0xdf, 0x1d, 0xa2, 0xfc, 0x06, 0x71, 0x90, 0xcf,
	0x10, 0x28, 0xc3, 0x02, 0x37, 0xbf, 0x2a, 0x48, 0xda, 0x13, 0xab, 0xae,
	0x35, 0xa2, 0x5c, 0x3e, 0x63, 0x87, 0xd3, 0x99, 0x3f, 0x9b, 0x56, 0x83,
	0x05, 0xb8, 0xbf, 0x08, 0x18, 0xff, 0x52, 0x7d, 0xd8, 0x20, 0x5d, 0xf4
};
/* QIUTx = 0674dcc4f755c44fdabdc078488107bb64a460ba932c7e185484ccd27fa870031107e9955204b0630b9b4d3608d9aa931d7c766cc2e45878eb6d8cd96bdf711b2fe8b47b8d233ed5 */
/* QIUTy = 05d96be6b7e2ba74c8032af19ca2f2b39d2fd4e8c89b156b6b25c2ea4f71f74a02ca7da2a463acd7605d5350fd16a9c9052534e7e81d648e4060a2b01c459c260cb6567da1fc5314 */
static const uint8_t nist_kas_ecc_cdh_testvector_228_out[] = {
/* ZIUT */
	0x01, 0x46, 0x62, 0xb2, 0x61, 0xd0, 0xbc, 0x21, 0x68, 0x64, 0x2b, 0xfa,
	0x4f, 0x80, 0xc4, 0xb3, 0xfe, 0x81, 0x76, 0xf6, 0x04, 0xad, 0x37, 0x03,
	0xf4, 0x43, 0xec, 0x7a, 0xaa, 0x3d, 0xcf, 0x3c, 0x54, 0x65, 0xb8, 0x69,
	0xa8, 0xfc, 0xea, 0x60, 0xb8, 0xf5, 0x5c, 0xe7, 0x11, 0x88, 0x06, 0xc5,
	0xd2, 0x8a, 0x04, 0x84, 0x8b, 0xd9, 0x61, 0xdb, 0x00, 0x61, 0x20, 0x9b,
	0x59, 0xbc, 0x02, 0x97, 0x9a, 0xcc, 0xe9, 0x32, 0x4d, 0x7c, 0x0c, 0x31
};
/* COUNT = 3 */
static const uint8_t nist_kas_ecc_cdh_testvector_229_public_x[] = {
/* QCAVSx */
	0x06, 0xbf, 0x25, 0x2e, 0x62, 0xc9, 0x96, 0x91, 0x71, 0xa9, 0x71, 0x76,
	0x71, 0xda, 0x0f, 0x70, 0x32, 0xe9, 0x52, 0x0a, 0x49, 0x7e, 0xc8, 0x31,
	0xf4, 0xdc, 0x77, 0x6a, 0xc8, 0x7e, 0x01, 0x94, 0xaf, 0x99, 0x54, 0x6c,
	0x41, 0xd0, 0x80, 0x48, 0xea, 0x06, 0xda, 0x92, 0x35, 0xcf, 0x13, 0x69,
	0xc3, 0xea, 0x53, 0xe6, 0xb8, 0xcb, 0xb7, 0xa7, 0xfd, 0x42, 0x96, 0x35,
	0x45, 0x48, 0xd4, 0x4e, 0xdf, 0x46, 0x3f, 0x77, 0xad, 0x34, 0x1b, 0x02
};
static const uint8_t nist_kas_ecc_cdh_testvector_229_public_y[] = {
/* QCAVSy */
	0x02, 0x94, 0xd5, 0xf7, 0xe7, 0x36, 0xdc, 0xd8, 0x99, 0x01, 0x98, 0xe4,
	0xe0, 0xf0, 0xb3, 0x98, 0xb8, 0xac, 0x6a, 0x87, 0x76, 0x4a, 0xf6, 0x01,
	0x59, 0x62, 0x34, 0xa2, 0xe1, 0x62, 0xc9, 0xc6, 0x67, 0xe4, 0x7e, 0xb3,
	0xd9, 0x87, 0xef, 0xba, 0xeb, 0x03, 0xb5, 0xe3, 0x69, 0x9a, 0x38, 0xef,
	0x95, 0x3c, 0x74, 0xfb, 0x28, 0xfd, 0x7d, 0x8a, 0x4e, 0xc5, 0xa3, 0x63,
	0x19, 0xcc, 0xc4, 0x4a, 0x19, 0xaa, 0x88, 0x20, 0x1d, 0xda, 0xcb, 0xf8
};
static const uint8_t nist_kas_ecc_cdh_testvector_229_private[] = {
/* dIUT */
	0x00, 0x15, 0x47, 0x43, 0x8d, 0xf7, 0x6f, 0xcb, 0x5e, 0x2a, 0xe6, 0x92,
	0x58, 0x45, 0xbb, 0xfb, 0x03, 0xb4, 0xfb, 0xe8, 0x25, 0x56, 0x16, 0xec,
	0x7f, 0xbd, 0x97, 0xb4, 0x8f, 0x11, 0x26, 0x92, 0x21, 0x9f, 0x4f, 0x12,
	0x75, 0xe6, 0xd2, 0x45, 0x3d, 0x5b, 0xcf, 0x3b, 0xac, 0x41, 0x06, 0xf0,
	0x16, 0x1b, 0x81, 0x19, 0xf4, 0x87, 0xd8, 0x8b, 0x5f, 0x8c, 0x8e, 0x08,
	0xb3, 0xaa, 0x17, 0xb8, 0x3f, 0xe0, 0x11, 0x02, 0xd7, 0x63, 0x92, 0xd3
};
/* QIUTx = 0427e2dc11ee5223bd9c3d9418c79114682f91dda06e7d88c339a7e56e0dfb636b6e63fde8a381146ecb705ca202d2b73df408451763c5166066a97ff4e4f32f0b4cc942344b0b2d */
/* QIUTy = 0760c8a388e2eea27ef6838c7d45052e38cbee2096cbe89f774774134076658df90c62c7dc0e3fde995d7a99090993009ab6c535677dbdb376f183eb5092d2cb6a8837b6bea35dcd */
static const uint8_t nist_kas_ecc_cdh_testvector_229_out[] = {
/* ZIUT */
	0x05, 0x1e, 0xc4, 0xdb, 0x06, 0x22, 0xb7, 0xb1, 0xc7, 0x98, 0x36, 0x64,
	0x53, 0xc7, 0x0f, 0x95, 0x93, 0x76, 0xea, 0x39, 0x42, 0xae, 0xd2, 0xe9,
	0x31, 0xff, 0x62, 0xa4, 0x01, 0x9e, 0xb1, 0x2b, 0xa5, 0xff, 0x11, 0x92,
	0x14, 0xc8, 0xbf, 0xd8, 0xbd, 0xb6, 0x6e, 0x62, 0xb5, 0x62, 0x40, 0x0f,
	0x2d, 0x3d, 0x48, 0xa8, 0x4b, 0x1b, 0x3b, 0xaa, 0xd3, 0x66, 0x7f, 0x73,
	0x5a, 0xd4, 0xd0, 0xf1, 0x83, 0xbd, 0xb9, 0x1a, 0xae, 0xdc, 0xf1, 0xf1
};
/* COUNT = 4 */
static const uint8_t nist_kas_ecc_cdh_testvector_230_public_x[] = {
/* QCAVSx */
	0x05, 0x70, 0x1e, 0x63, 0xb0, 0x1c, 0x16, 0xc4, 0xeb, 0x19, 0x93, 0x82,
	0x65, 0xba, 0x13, 0x4c, 0xac, 0x73, 0x16, 0x27, 0x8e, 0x2f, 0x1e, 0xb4,
	0x0a, 0x04, 0x77, 0x54, 0x48, 0xbd, 0xed, 0x97, 0xe7, 0xa3, 0x7d, 0x01,
	0xfe, 0xd8, 0xa4, 0xe0, 0xb4, 0x3f, 0xf4, 0xdb, 0xa2, 0x1a, 0x47, 0x75,
	0x9c, 0xcd, 0x45, 0xbf, 0x96, 0x71, 0xdd, 0x22, 0xee, 0xc6, 0x5b, 0x4a,
	0xff, 0x8b, 0x8d, 0xb8, 0x9d, 0xfe, 0x3e, 0x49, 0x0c, 0x0a, 0xc9, 0xd6
};
static const uint8_t nist_kas_ecc_cdh_testvector_230_public_y[] = {
/* QCAVSy */
	0x02, 0xdd, 0x97, 0xb6, 0x41, 0x5a, 0xee, 0x2b, 0x01, 0xcf, 0xeb, 0x3c,
	0xd2, 0xa0, 0x35, 0x78, 0xab, 0xfe, 0xd9, 0xca, 0x87, 0xbe, 0x9a, 0x26,
	0xd8, 0x99, 0x59, 0x5a, 0x87, 0xbc, 0xbd, 0x97, 0x27, 0x48, 0xfa, 0x6a,
	0x0b, 0xe4, 0xeb, 0x55, 0x7e, 0x69, 0xc6, 0xd2, 0x8e, 0x2b, 0xba, 0x15,
	0x80, 0xdc, 0x74, 0xe2, 0x75, 0x1d, 0x7c, 0xcd, 0x91, 0x8c, 0x46, 0xb4,
	0xbe, 0x68, 0x75, 0xa4, 0xe4, 0xc2, 0x90, 0xd9, 0x59, 0xc2, 0x3c, 0x12
};
static const uint8_t nist_kas_ecc_cdh_testvector_230_private[] = {
/* dIUT */
	0x00, 0xc7, 0xb4, 0x25, 0x2c, 0xa9, 0xb1, 0x92, 0xc5, 0xfe, 0xaa, 0x9a,
	0x21, 0x0f, 0xd8, 0x4e, 0x2e, 0x48, 0x32, 0x02, 0x71, 0xf1, 0x0f, 0x67,
	0xea, 0x9e, 0xb3, 0x0b, 0x0d, 0xe8, 0x08, 0x6d, 0x59, 0xda, 0xe0, 0x42,
	0x59, 0xfd, 0x12, 0xb0, 0x86, 0xd8, 0x90, 0xe2, 0x2d, 0x45, 0xd2, 0x7d,
	0x7c, 0x84, 0x55, 0xdc, 0xf7, 0xad, 0xa7, 0x96, 0xe3, 0x5e, 0x3a, 0x31,
	0x38, 0x34, 0x2c, 0xc7, 0x36, 0xbc, 0x3e, 0xd3, 0x78, 0x1c, 0x41, 0x19
};
/* QIUTx = 0325623838e8b18d81b68060734254eb02b8ebb2264556fc9850c36d3035449aa764f351dbaf7bbca9b9adb11f27cc88a1ac6fb71aa10ef8d0d09392b0ca7eaa7a5cc14078cc18bb */
/* QIUTy = 0098fc7656d9de3a51923dba290ecbe413ef8d951f24e9248cb552309f97127fb9429ecf6dd07b6de894e16ab60e33b4ee73024ccbe866de5e17f1b478dc7727a1bb42371820b12d */
static const uint8_t nist_kas_ecc_cdh_testvector_230_out[] = {
/* ZIUT */
	0x05, 0xb3, 0x55, 0xeb, 0x5c, 0x47, 0xd8, 0x02, 0x7b, 0x6c, 0x53, 0x01,
	0xd2, 0x46, 0x3b, 0x99, 0xc6, 0x36, 0xdb, 0x20, 0x77, 0x92, 0xe2, 0x97,
	0x5a, 0xb1, 0xa5, 0x3c, 0x1c, 0xbb, 0x13, 0x12, 0x80, 0x28, 0x84, 0x32,
	0xa7, 0x9a, 0x3b, 0x47, 0x27, 0x1d, 0x6a, 0x2b, 0xd7, 0x77, 0x29, 0x8b,
	0xaf, 0x8a, 0x67, 0x5f, 0x66, 0xbe, 0x9d, 0xc7, 0x2c, 0x35, 0x88, 0xd2,
	0x99, 0xdf, 0x8b, 0x52, 0xe7, 0x84, 0x03, 0x22, 0xb4, 0x3c, 0x20, 0x71
};
/* COUNT = 5 */
static const uint8_t nist_kas_ecc_cdh_testvector_231_public_x[] = {
/* QCAVSx */
	0x03, 0x2f, 0xa1, 0x81, 0x6f, 0xd2, 0x31, 0x7c, 0x16, 0xb5, 0xb1, 0x9a,
	0x25, 0xd4, 0x6f, 0xa5, 0xe4, 0x5a, 0xb1, 0x5e, 0xe9, 0xf2, 0xb1, 0xd1,
	0x27, 0x4c, 0x2a, 0x06, 0x02, 0x39, 0x94, 0xdb, 0x30, 0x9f, 0xad, 0x56,
	0xf6, 0x0b, 0x3c, 0xe5, 0x7f, 0x32, 0xdf, 0xc7, 0xd0, 0x45, 0xa8, 0x4b,
	0x7d, 0x80, 0x52, 0x32, 0xbe, 0x34, 0xc7, 0xe7, 0x59, 0x51, 0x4c, 0x30,
	0xa2, 0x52, 0x07, 0xba, 0x80, 0x02, 0x15, 0xb2, 0x06, 0x0f, 0x04, 0xc2
};
static const uint8_t nist_kas_ecc_cdh_testvector_231_public_y[] = {
/* QCAVSy */
	0x04, 0x14, 0x69, 0x59, 0x3d, 0x57, 0x48, 0x07, 0x2b, 0x9a, 0xc8, 0xfd,
	0xe0, 0x23, 0x09, 0x52, 0x89, 0xbc, 0xdf, 0x65, 0xab, 0x1b, 0xfc, 0x08,
	0x56, 0xf8, 0x3e, 0x9a, 0xe0, 0x6c, 0x89, 0x73, 0x03, 0xbd, 0x16, 0xf5,
	0xe4, 0x58, 0x23, 0xd6, 0x5f, 0xec, 0x83, 0x10, 0xfd, 0x43, 0x32, 0xb6,
	0x5c, 0xff, 0x47, 0xa7, 0x99, 0xaf, 0x4f, 0x7c, 0x86, 0x38, 0xe2, 0xd7,
	0xf8, 0x59, 0x48, 0xc4, 0x3f, 0x10, 0x53, 0x4c, 0x98, 0x0c, 0xcb, 0x62
};
static const uint8_t nist_kas_ecc_cdh_testvector_231_private[] = {
/* dIUT */
	0x00, 0x66, 0xcc, 0x51, 0x98, 0x0d, 0x38, 0x51, 0xb4, 0x88, 0xc2, 0xc1,
	0x81, 0x49, 0x6c, 0x83, 0x50, 0x5f, 0xb9, 0x57, 0xb1, 0xec, 0x4a, 0x84,
	0xdf, 0x1e, 0x10, 0x5e, 0x30, 0xd0, 0x02, 0xbc, 0xb9, 0x78, 0xb6, 0xd0,
	0xbd, 0xc3, 0xb7, 0x64, 0x4e, 0xd3, 0xdf, 0xbc, 0x33, 0xca, 0x6b, 0xfe,
	0x43, 0x62, 0xcd, 0x8c, 0xc5, 0x41, 0x74, 0x0b, 0x0d, 0xe8, 0xcf, 0x2e,
	0xdc, 0xce, 0x45, 0x92, 0xe3, 0x4f, 0xa1, 0x1a, 0xc2, 0x6e, 0xc9, 0x22
};
/* QIUTx = 0771fa29e5930d6dfd36d3a9e7159675fd23d0b5e1fd9ae6454aca9e8127f1e7e3f5322b5c16b095573b3266d08f0dc33043ffb3d7b08e4e052ed3f0349a329025ea6ff3e1668547 */
/* QIUTy = 022f994f9974692dbb6e58cc7ae5f90652ee231e0a3961569dc646d114522a3777410c1b352d668079f80010bb540e4c28408665810fe61fd60e70d30c688eab8fde04364dee5c9b */
static const uint8_t nist_kas_ecc_cdh_testvector_231_out[] = {
/* ZIUT */
	0x05, 0x2b, 0xd7, 0x8b, 0xf1, 0x32, 0x6c, 0x6d, 0x91, 0x84, 0x0a, 0x35,
	0x1d, 0x48, 0x74, 0xd3, 0x6b, 0x14, 0x71, 0x39, 0x88, 0x23, 0x56, 0xc5,
	0x95, 0xb8, 0x60, 0x7f, 0x99, 0x98, 0x77, 0x30, 0x92, 0xa9, 0x9a, 0xdf,
	0x70, 0xad, 0xee, 0xd1, 0x9e, 0x12, 0x2d, 0x4d, 0x2f, 0xec, 0x16, 0x28,
	0x5f, 0x00, 0x01, 0x61, 0x14, 0x51, 0x35, 0xd9, 0x63, 0x55, 0xcb, 0xa0,
	0x39, 0xa9, 0x63, 0x35, 0xe7, 0x71, 0x67, 0x24, 0xc2, 0x49, 0xf8, 0x8b
};
/* COUNT = 6 */
static const uint8_t nist_kas_ecc_cdh_testvector_232_public_x[] = {
/* QCAVSx */
	0x03, 0xe6, 0x3d, 0xd4, 0xc9, 0x8c, 0x15, 0x13, 0x61, 0xc9, 0x90, 0x2b,
	0x76, 0x3a, 0xe3, 0x2f, 0x2d, 0x6d, 0xe7, 0x59, 0x53, 0xfa, 0x3d, 0x68,
	0x38, 0xc1, 0xd6, 0x13, 0xd4, 0x48, 0xfc, 0xa7, 0x3b, 0xf3, 0x02, 0xd3,
	0x02, 0x12, 0xa9, 0x6d, 0x32, 0xb9, 0x54, 0x9e, 0x17, 0xc5, 0xcf, 0x39,
	0x5c, 0x56, 0x51, 0x91, 0xf6, 0xa2, 0x2d, 0xac, 0x4d, 0xa7, 0xc1, 0xe1,
	0xa9, 0xd9, 0xba, 0xe8, 0x6e, 0xbf, 0xb7, 0x2c, 0x82, 0xea, 0x19, 0x9a
};
static const uint8_t nist_kas_ecc_cdh_testvector_232_public_y[] = {
/* QCAVSy */
	0x04, 0x16, 0x09, 0xab, 0x9c, 0x12, 0xc1, 0x5e, 0x51, 0x27, 0x00, 0x5e,
	0xbe, 0xff, 0x6f, 0xd1, 0xf7, 0x3b, 0x69, 0x12, 0xed, 0x07, 0x0a, 0xf8,
	0x7f, 0x5f, 0xfc, 0x21, 0xdf, 0x90, 0x3d, 0xde, 0x1d, 0x71, 0x55, 0x82,
	0xdd, 0x2f, 0x69, 0x90, 0x40, 0x20, 0x00, 0x45, 0xcd, 0xba, 0x9e, 0xcd,
	0x75, 0x8a, 0xc4, 0xd0, 0x84, 0xd4, 0xc8, 0xd7, 0x82, 0x19, 0xf6, 0xfa,
	0xd9, 0x4d, 0x34, 0x1a, 0xd7, 0x7d, 0xac, 0xcd, 0xab, 0xb5, 0x4a, 0x2b
};
static const uint8_t nist_kas_ecc_cdh_testvector_232_private[] = {
/* dIUT */
	0x01, 0x99, 0x0d, 0x15, 0xfa, 0x2c, 0xc9, 0x0e, 0x78, 0x3d, 0x43, 0x22,
	0x01, 0x78, 0x4b, 0xab, 0x56, 0xb6, 0xd2, 0x9d, 0x1f, 0x26, 0x65, 0xa7,
	0x6c, 0xd0, 0x13, 0xeb, 0x96, 0xf6, 0x30, 0x0e, 0xd8, 0xf7, 0x62, 0xb7,
	0x8a, 0x55, 0x96, 0xac, 0x7e, 0x8c, 0x1e, 0x76, 0x16, 0x7f, 0x10, 0x7c,
	0x20, 0x44, 0x3b, 0x1a, 0xc7, 0x32, 0x10, 0x1e, 0x9f, 0x0a, 0xca, 0x12,
	0x55, 0x1a, 0x53, 0x6d, 0x15, 0x2d, 0xf2, 0xb3, 0xdb, 0x0f, 0x20, 0xde
};
/* QIUTx = 076c3d72f0e715f2491bc9d99278a8ef3c390b3a96e9997b37e5b7bd8a5f07af68f8e0ee3892b63ff112a73a849f0e84a782d4fb426eb5f2f15adacce9e5476a6daccf3a7fa9a291 */
/* QIUTy = 0540a763823599e0c86027bacc8cbb30e3a2467276fc4f7e5fd4ed385dfc6f883fed7bca69df21a0668b55ebd292da8fd6356a3ec5cd1c762c01473aa067004cacedad564fe06910 */
static const uint8_t nist_kas_ecc_cdh_testvector_232_out[] = {
/* ZIUT */
	0x02, 0x26, 0xc2, 0x8e, 0x5a, 0x6b, 0xc7, 0x35, 0x93, 0x5f, 0x9d, 0xf2,
	0xc1, 0xb0, 0x2d, 0x09, 0x6d, 0x4d, 0xee, 0x41, 0xff, 0xb9, 0x5a, 0x67,
	0x90, 0x5a, 0xab, 0x8d, 0xe1, 0xb2, 0xd8, 0xc6, 0x6e, 0x2b, 0xb4, 0x71,
	0x29, 0x30, 0x91, 0x43, 0x8d, 0x3f, 0x05, 0xdf, 0x7e, 0x48, 0x00, 0x3e,
	0x58, 0xa9, 0x58, 0xb7, 0x2f, 0x83, 0x9f, 0x7f, 0x2e, 0x2c, 0x54, 0x28,
	0x7f, 0xa3, 0xca, 0xdc, 0xd4, 0x1a, 0x25, 0x42, 0xae, 0x4e, 0xc0, 0x3a
};
/* COUNT = 7 */
static const uint8_t nist_kas_ecc_cdh_testvector_233_public_x[] = {
/* QCAVSx */
	0x06, 0xf9, 0x1a, 0x7c, 0xe1, 0x1b, 0xa9, 0xbf, 0x2d, 0xe1, 0xfe, 0x07,
	0x0f, 0x9d, 0xc8, 0x43, 0xbb, 0x71, 0x7c, 0x30, 0x6d, 0x9c, 0x63, 0xb5,
	0x07, 0x8d, 0x2a, 0x11, 0x32, 0x3f, 0x20, 0xc9, 0xc0, 0xd7, 0xb7, 0x74,
	0x3d, 0x31, 0x1d, 0xda, 0xcd, 0xcf, 0x5d, 0xd0, 0x0f, 0x49, 0x8b, 0x19,
	0x96, 0x72, 0xc7, 0x8a, 0xe2, 0x5e, 0x68, 0x64, 0xd6, 0x2b, 0xdc, 0x16,
	0x93, 0x5d, 0x6f, 0xb8, 0xda, 0xd2, 0x08, 0x2d, 0x36, 0x76, 0xeb, 0xf3
};
static const uint8_t nist_kas_ecc_cdh_testvector_233_public_y[] = {
/* QCAVSy */
	0x04, 0x59, 0x3c, 0x5b, 0xad, 0x12, 0xc3, 0xd6, 0x55, 0xc6, 0x61, 0x1c,
	0x7c, 0xa9, 0x71, 0x1f, 0x9e, 0x32, 0xa2, 0x8f, 0xee, 0x54, 0xb3, 0xb8,
	0x24, 0x39, 0x62, 0xa3, 0xc5, 0x5d, 0x41, 0xf2, 0xc1, 0x85, 0xe4, 0xc5,
	0x8b, 0x7a, 0x29, 0x98, 0xe9, 0x78, 0x02, 0x1b, 0x95, 0xb7, 0x24, 0x63,
	0x5d, 0xac, 0xcb, 0xd7, 0xfc, 0x30, 0xd2, 0x07, 0x20, 0x79, 0x7b, 0xc2,
	0x91, 0x36, 0x2c, 0x55, 0xb0, 0x24, 0xac, 0xb2, 0xbd, 0xcf, 0x3d, 0x59
};
static const uint8_t nist_kas_ecc_cdh_testvector_233_private[] = {
/* dIUT */
	0x00, 0x2b, 0x09, 0x37, 0xe7, 0x31, 0xf5, 0x9d, 0xdd, 0xdf, 0x0e, 0x94,
	0xfb, 0xa9, 0x2b, 0xb1, 0xa6, 0xce, 0xb8, 0x19, 0xe7, 0x65, 0x9b, 0xcf,
	0x6e, 0xdd, 0x4b, 0x4a, 0xf4, 0x9c, 0x2e, 0xf2, 0x5c, 0x5b, 0x60, 0x39,
	0x25, 0x6f, 0x92, 0x83, 0x63, 0xe1, 0x84, 0x04, 0xb1, 0x65, 0x3d, 0x39,
	0x98, 0x05, 0x4c, 0x2c, 0x25, 0xa3, 0xf8, 0x3a, 0x0c, 0x55, 0x48, 0xa1,
	0x39, 0xe3, 0xe6, 0xa1, 0x80, 0x75, 0x67, 0x46, 0xcd, 0x34, 0xee, 0x29
};
/* QIUTx = 0270c4c00de2709010c7cf047a0ce69b87f41dca48d35b71fba4b258886d73ae42defb8653951c1bd3eb4ce0e6175a946c67afa67753475c51fd525b0fd9f5a26dafca319faa5e15 */
/* QIUTy = 06680bbdc281505f5d3fbe29744a999e07ff612576993f6f8be3113db1ee6cf23799867bbc80a140376a9b6327451f98bf8fd1db46f9d9cc05e88704d5712d4567e1df40d39e99ef */
static const uint8_t nist_kas_ecc_cdh_testvector_233_out[] = {
/* ZIUT */
	0x05, 0x1a, 0x3d, 0xeb, 0x05, 0x2d, 0x3e, 0x99, 0xbb, 0x6a, 0xb6, 0xc6,
	0xb2, 0x84, 0xdb, 0x2c, 0x99, 0x8e, 0x9b, 0xee, 0x54, 0x3e, 0x02, 0xe5,
	0x7f, 0x1b, 0x13, 0xfe, 0x9f, 0xaf, 0xbf, 0xe5, 0x3a, 0x89, 0x65, 0x8c,
	0x58, 0xeb, 0x94, 0x7d, 0xbd, 0x17, 0x8a, 0xea, 0x2f, 0x6c, 0xb2, 0x8e,
	0x30, 0x5c, 0x98, 0x67, 0xbd, 0x65, 0xbb, 0x26, 0xf7, 0x17, 0x93, 0xf9,
	0x0c, 0x98, 0x4c, 0xa1, 0x11, 0x13, 0xe1, 0xa8, 0xdb, 0xc8, 0xf7, 0xd1
};
/* COUNT = 8 */
static const uint8_t nist_kas_ecc_cdh_testvector_234_public_x[] = {
/* QCAVSx */
	0x05, 0xab, 0x2a, 0x7f, 0x10, 0xac, 0x89, 0xf9, 0x8c, 0x40, 0x95, 0x80,
	0xab, 0xc1, 0x1a, 0xd9, 0x0c, 0x93, 0x36, 0x0e, 0x6a, 0xb2, 0x82, 0x92,
	0x0b, 0x59, 0xd3, 0x16, 0xca, 0x9f, 0x2b, 0x23, 0xae, 0xb5, 0x08, 0x76,
	0xcb, 0x1b, 0xcb, 0xe8, 0xee, 0x9a, 0xe6, 0xb5, 0x53, 0x3f, 0xdc, 0xd1,
	0x1a, 0xd4, 0xf8, 0x6d, 0x89, 0x18, 0xd6, 0x63, 0x89, 0xda, 0x87, 0xc9,
	0x8b, 0xf1, 0xd6, 0x32, 0x3b, 0xd0, 0x94, 0x7d, 0x80, 0x99, 0x08, 0x3b
};
static const uint8_t nist_kas_ecc_cdh_testvector_234_public_y[] = {
/* QCAVSy */
	0x06, 0x89, 0xe1, 0x94, 0x72, 0x76, 0x79, 0x1d, 0xcb, 0x95, 0x27, 0x18,
	0x3e, 0x32, 0xa0, 0x80, 0x72, 0xb7, 0xe0, 0x3d, 0xca, 0xd1, 0x75, 0xfe,
	0x3c, 0xfd, 0x7b, 0xee, 0xfc, 0x84, 0x8d, 0xce, 0xf4, 0x83, 0x38, 0x0c,
	0x60, 0x05, 0x41, 0x13, 0x85, 0xc7, 0x02, 0x7c, 0x9a, 0x52, 0xb6, 0x0a,
	0x6e, 0x53, 0x7a, 0x87, 0x53, 0x80, 0xd2, 0x5b, 0xc4, 0x7c, 0x7b, 0xf2,
	0x36, 0x4d, 0xd6, 0x8a, 0x66, 0xf2, 0x1d, 0x0f, 0x57, 0x86, 0x6a, 0x42
};
static const uint8_t nist_kas_ecc_cdh_testvector_234_private[] = {
/* dIUT */
	0x01, 0xcd, 0x41, 0xcf, 0xf7, 0x62, 0x40, 0x2a, 0x83, 0x4e, 0x7e, 0x0a,
	0xb9, 0x08, 0xfc, 0x54, 0x94, 0x0f, 0x69, 0x7b, 0x50, 0x02, 0x2a, 0x4d,
	0xfe, 0xd8, 0xcf, 0x0b, 0x13, 0xd7, 0xe0, 0xee, 0x52, 0x3f, 0xbf, 0x33,
	0xee, 0x96, 0x93, 0x89, 0x5f, 0x91, 0x8d, 0x94, 0xe1, 0x5b, 0x08, 0x46,
	0x55, 0xd6, 0x1b, 0x22, 0x94, 0xca, 0x51, 0xc4, 0x12, 0x3f, 0xe5, 0xe0,
	0x86, 0x8e, 0x9d, 0x0d, 0x1c, 0xac, 0x21, 0x38, 0xf0, 0x57, 0x7a, 0x17
};
/* QIUTx = 0610797bbc6d9131180ae54ab66e6780849258369741470e076cf05e0785bb4e7900b908d38d8dab3b9427b952add20efb758cff80aeb641c4dde1eeda5509f386d5658559609cef */
/* QIUTy = 068d2515f425a0e3037547342f1b6ff931763f5052e536ea4f78377b5c941459c8c2201482afcf3cda7390e9e5d319451864ca03683541ab2cd77a9d88fd7a610ca845ee5cd3d498 */
static const uint8_t nist_kas_ecc_cdh_testvector_234_out[] = {
/* ZIUT */
	0x00, 0x69, 0x7c, 0x75, 0x1d, 0xdb, 0xca, 0x70, 0x34, 0xfb, 0x4d, 0x3f,
	0xc1, 0xb2, 0x61, 0x8d, 0xaf, 0x78, 0xcd, 0xae, 0x46, 0x4e, 0x83, 0x32,
	0xd1, 0x21, 0x50, 0x20, 0xc8, 0xf8, 0x96, 0xf4, 0x86, 0x4c, 0x7a, 0x6f,
	0x2c, 0x61, 0xa3, 0x63, 0xf7, 0x30, 0xf5, 0x8f, 0xd3, 0xbd, 0xb4, 0xf7,
	0x8a, 0x90, 0xb4, 0x0a, 0xeb, 0x83, 0xb4, 0xfb, 0xc1, 0xd8, 0xd3, 0x7c,
	0xf6, 0xa2, 0x7a, 0x6f, 0x72, 0x2c, 0x68, 0xa8, 0x29, 0x79, 0xfa, 0x16
};
/* COUNT = 9 */
static const uint8_t nist_kas_ecc_cdh_testvector_235_public_x[] = {
/* QCAVSx */
	0x00, 0x34, 0x09, 0x1c, 0x3a, 0xc6, 0xfc, 0x52, 0x99, 0xdf, 0x18, 0xf1,
	0x62, 0xea, 0xf7, 0xa2, 0x07, 0xfc, 0x15, 0x43, 0xaa, 0x49, 0x8e, 0x72,
	0x72, 0xe1, 0x5a, 0x92, 0x77, 0x2f, 0x57, 0x77, 0x22, 0x29, 0x06, 0x94,
	0x56, 0xe2, 0x19, 0xc9, 0xc2, 0x87, 0x2b, 0xd5, 0x37, 0x83, 0xb0, 0xfb,
	0x13, 0x45, 0xf5, 0xe8, 0x46, 0x74, 0xc4, 0x34, 0x41, 0x29, 0xa3, 0x14,
	0x14, 0x6b, 0x70, 0x30, 0xfc, 0x75, 0x19, 0x7a, 0x20, 0xc5, 0x88, 0xaa
};
static const uint8_t nist_kas_ecc_cdh_testvector_235_public_y[] = {
/* QCAVSy */
	0x04, 0x9e, 0x3a, 0x3f, 0x5e, 0xe6, 0x58, 0x75, 0xe1, 0x40, 0x10, 0x89,
	0x97, 0x06, 0x38, 0xb8, 0x07, 0xdf, 0x97, 0x56, 0x8a, 0x59, 0x95, 0xc8,
	0xfe, 0x2f, 0x50, 0x24, 0x73, 0xb8, 0x3f, 0x58, 0xc5, 0x56, 0xc5, 0xf2,
	0x14, 0xed, 0x6f, 0x03, 0xef, 0x8e, 0xce, 0x01, 0x40, 0x1a, 0x21, 0x34,
	0xbc, 0x04, 0x1f, 0x66, 0x92, 0x2f, 0xcc, 0x4e, 0x39, 0x38, 0xe0, 0xc6,
	0xd3, 0x02, 0xeb, 0x42, 0x20, 0x06, 0x78, 0xa9, 0x71, 0x39, 0xf2, 0x91
};
static const uint8_t nist_kas_ecc_cdh_testvector_235_private[] = {
/* dIUT */
	0x01, 0x9d, 0xff, 0x0d, 0x72, 0xa8, 0xb0, 0x42, 0xc4, 0xe9, 0x2f, 0x1d,
	0xae, 0x74, 0x07, 0xbf, 0x4a, 0x10, 0x6c, 0xda, 0x56, 0x4d, 0xb7, 0x50,
	0x8e, 0x5a, 0x76, 0xb0, 0x31, 0x30, 0xc9, 0x1d, 0x5e, 0x5c, 0xbc, 0xf2,
	0xf5, 0x78, 0xc2, 0xe9, 0xde, 0xe4, 0x38, 0x49, 0xf9, 0x11, 0xd7, 0x77,
	0x3d, 0x4c, 0x26, 0x7e, 0x28, 0x2c, 0x27, 0x7b, 0x73, 0x1f, 0x88, 0xa6,
	0xef, 0x0e, 0xed, 0xdd, 0x52, 0x0f, 0x57, 0xe7, 0x43, 0xeb, 0xf9, 0x65
};
/* QIUTx = 05bb60a5fe8e3b173cf8413eaf413a3286a5a7aa378f21446c61057696012746d02d10a831f785c9c96561ffc6ad4f9ecdf4937fffd8e698408e660fe896f7ed44af6b3b42ea849f */
/* QIUTy = 037e3a35e48aa66bd851c59f851d4a1ff334e0e589dac30986acd06d6eb8ce236f2a9688f278a14dcfe0660b5fa0e97ecfcebbf5b40d3d3f5150a5545acba6239c00419ac72dc2cc */
static const uint8_t nist_kas_ecc_cdh_testvector_235_out[] = {
/* ZIUT */
	0x03, 0x22, 0x51, 0x7d, 0xa3, 0x0e, 0x01, 0x0a, 0xea, 0xa2, 0xec, 0x9b,
	0xad, 0x27, 0x45, 0xd8, 0xe6, 0x7f, 0x90, 0x62, 0x94, 0xec, 0xd6, 0xb1,
	0xd1, 0x68, 0x08, 0xbe, 0x38, 0x37, 0xf7, 0x90, 0x70, 0xd0, 0xe1, 0xbb,
	0xbd, 0x61, 0x7f, 0x4b, 0x8b, 0x03, 0x1d, 0x3b, 0x51, 0xea, 0x2a, 0xcc,
	0x59, 0xde, 0x40, 0x8a, 0x13, 0x01, 0x38, 0xc7, 0x85, 0x71, 0xf8, 0x80,
	0x0f, 0xa9, 0x07, 0xca, 0xf5, 0x50, 0xd2, 0x33, 0x23, 0xd1, 0xc8, 0x18
};
/* COUNT = 10 */
static const uint8_t nist_kas_ecc_cdh_testvector_236_public_x[] = {
/* QCAVSx */
	0x05, 0x7b, 0x7c, 0x65, 0xbc, 0x51, 0xe8, 0x7b, 0xda, 0xd3, 0x7c, 0x2b,
	0x4d, 0xae, 0x67, 0xfb, 0x00, 0x8c, 0xe7, 0x1f, 0xd3, 0x07, 0x2e, 0x41,
	0xb7, 0x7c, 0x56, 0x2d, 0x7c, 0x41, 0x74, 0x88, 0x72, 0xa2, 0x0b, 0xef,
	0x85, 0x17, 0xba, 0x4b, 0xe8, 0x96, 0x37, 0xdd, 0xe9, 0x8e, 0x2b, 0xa1,
	0xb3, 0xb0, 0x1f, 0x63, 0x94, 0x07, 0x13, 0xe2, 0x82, 0x3d, 0x8d, 0xab,
	0x68, 0xa5, 0xcc, 0x78, 0x56, 0x1d, 0xe1, 0x40, 0x85, 0xe4, 0xcf, 0x87
};
static const uint8_t nist_kas_ecc_cdh_testvector_236_public_y[] = {
/* QCAVSy */
	0x00, 0xba, 0x77, 0x43, 0x0a, 0x55, 0x60, 0x08, 0x9d, 0xfa, 0xc4, 0xf6,
	0x8b, 0x4f, 0x34, 0x93, 0x7a, 0x38, 0x4d, 0xd6, 0x07, 0xbc, 0xbb, 0x5f,
	0xab, 0x56, 0x77, 0xa7, 0xfa, 0xe0, 0x9e, 0xd0, 0x7c, 0xfa, 0xde, 0x39,
	0x9e, 0x87, 0xce, 0x9f, 0xdd, 0x93, 0x97, 0xc6, 0x81, 0xaa, 0x33, 0x78,
	0xce, 0x3b, 0xc8, 0x2b, 0x00, 0x7f, 0x6d, 0xe4, 0xf7, 0xcb, 0x96, 0xda,
	0xdf, 0x55, 0xa4, 0xc8, 0x73, 0x4a, 0x37, 0xf3, 0x9a, 0x5c, 0x2f, 0x25
};
static const uint8_t nist_kas_ecc_cdh_testvector_236_private[] = {
/* dIUT */
	0x01, 0xe1, 0x41, 0x6d, 0x42, 0x99, 0x26, 0xca, 0xbe, 0xa5, 0x47, 0xbb,
	0x27, 0x76, 0x71, 0x0a, 0x52, 0xf7, 0x13, 0x03, 0x93, 0x08, 0x10, 0x20,
	0x31, 0x2b, 0x39, 0x62, 0x19, 0x5e, 0xb6, 0xed, 0x17, 0xc6, 0xd4, 0x36,
	0xbc, 0x46, 0xa5, 0xb4, 0x7a, 0x7a, 0xaa, 0xcf, 0x8f, 0x81, 0x17, 0xfe,
	0xa3, 0xca, 0xfa, 0x16, 0x66, 0x5c, 0xc1, 0x84, 0x5b, 0x0e, 0xc9, 0x4f,
	0xaf, 0x68, 0x75, 0x79, 0xb1, 0xc1, 0x16, 0xba, 0x18, 0x3e, 0x82, 0x5f
};
/* QIUTx = 065660a58688a16588a9c16b8272040a30afe3150630676023fe165686dfbda64fc85995ddc18c9c5b029bffbd4dffa8f62989c639a68623eca78009cb088ee1cb42c4855b79d302 */
/* QIUTy = 0492c3867f137bf2787a7ab0568d3079b8d9a1e0b0ba5d29d0c7ba616d0bb27725da2ca6bc67bf084fab52599ed42b0ef48743423cbc6f4135692c309ae2630cc4a5390be93f274b */
static const uint8_t nist_kas_ecc_cdh_testvector_236_out[] = {
/* ZIUT */
	0x00, 0x09, 0x11, 0xec, 0x1c, 0xf8, 0x2a, 0x22, 0xc8, 0x49, 0xb4, 0x01,
	0xdf, 0xe5, 0x64, 0x53, 0xa0, 0x6f, 0x4a, 0xf3, 0x26, 0x44, 0xea, 0x8b,
	0x63, 0x13, 0x5b, 0x68, 0xa9, 0x79, 0x23, 0x6d, 0x05, 0x96, 0x8e, 0xea,
	0xdc, 0xa7, 0xf0, 0xcd, 0x33, 0x9d, 0x29, 0x5c, 0xc5, 0x89, 0x67, 0xa7,
	0xf3, 0x8c, 0xfa, 0xd6, 0xe9, 0x47, 0xa7, 0x12, 0x95, 0x73, 0x3e, 0x42,
	0xca, 0x3c, 0x1b, 0xa9, 0xb4, 0xff, 0x61, 0x95, 0x60, 0x7b, 0xb5, 0x30
};
/* COUNT = 11 */
static const uint8_t nist_kas_ecc_cdh_testvector_237_public_x[] = {
/* QCAVSx */
	0x06, 0xfa, 0x74, 0x77, 0xed, 0xec, 0x5f, 0x1e, 0x74, 0x28, 0x81, 0xf8,
	0xd7, 0xb2, 0xaf, 0x56, 0x37, 0x51, 0x13, 0xe9, 0x92, 0xb7, 0x97, 0xfd,
	0x38, 0x7e, 0xb5, 0xb5, 0x3c, 0x33, 0xc6, 0xba, 0x72, 0x36, 0x41, 0x7b,
	0x2c, 0x7e, 0x6e, 0x34, 0x62, 0x67, 0xf1, 0xb8, 0xc6, 0xd7, 0x85, 0x7d,
	0x6e, 0x08, 0xf9, 0xa6, 0x0e, 0x86, 0xde, 0x23, 0xda, 0x4b, 0x36, 0x84,
	0x24, 0xfb, 0x00, 0x3f, 0x96, 0xb4, 0xc8, 0x9f, 0x5d, 0x24, 0x4a, 0x74
};
static const uint8_t nist_kas_ecc_cdh_testvector_237_public_y[] = {
/* QCAVSy */
	0x07, 0x3e, 0x1f, 0xed, 0xf6, 0x2e, 0x8c, 0x81, 0x28, 0x36, 0x22, 0xb5,
	0x3e, 0xb2, 0xcd, 0xb2, 0x7b, 0x64, 0xc3, 0xc1, 0xdd, 0x78, 0xda, 0x0c,
	0x90, 0xdd, 0x6c, 0x3c, 0x77, 0x6a, 0xd1, 0x46, 0x30, 0x2e, 0x43, 0xab,
	0xa5, 0x41, 0x37, 0x9b, 0xc8, 0xf3, 0xbd, 0xdc, 0x2e, 0x19, 0xff, 0x15,
	0xd9, 0x66, 0x64, 0xce, 0x2d, 0x09, 0xeb, 0x6f, 0xb5, 0xb1, 0x38, 0x48,
	0xa8, 0x2b, 0x31, 0xb4, 0x52, 0xd8, 0xe8, 0x4d, 0xa3, 0xb8, 0x53, 0x18
};
static const uint8_t nist_kas_ecc_cdh_testvector_237_private[] = {
/* dIUT */
	0x01, 0x96, 0x36, 0x3e, 0xef, 0x1a, 0x0e, 0x5b, 0xe9, 0x7d, 0x8f, 0x76,
	0x01, 0xfe, 0x40, 0xff, 0x40, 0x10, 0xf4, 0x94, 0x9f, 0x01, 0x69, 0x08,
	0xa9, 0x06, 0xed, 0x5c, 0xda, 0xf1, 0x22, 0x1d, 0x3a, 0x59, 0x3b, 0x3a,
	0x46, 0x76, 0xbe, 0xaf, 0xd1, 0xfa, 0x14, 0xbc, 0x0f, 0x7c, 0x53, 0x3b,
	0x17, 0x08, 0x6f, 0x20, 0x7f, 0x9c, 0x48, 0x4c, 0xfc, 0x2f, 0xbc, 0x3d,
	0xb2, 0xbe, 0x41, 0x23, 0xa8, 0xe8, 0x6f, 0x3b, 0x49, 0x11, 0xcc, 0xe3
};
/* QIUTx = 01b12e38914ee0075a888d6d61cdc7570c511d90a9e3a0e2738c3a9981ab9aba9a6c61460bad079a28429a5207d2c801af2fdceda366440a11686765e9ba77f7a6bc55012d4c9510 */
/* QIUTy = 070ede5877665fd636adcfd07220d745ed7ac0a9b0202159f450c9f6c1b837192a69ee6ad955327eb9cd326a0588b59723db4e8fd258b11db888a53eb14f2be08512688329059892 */
static const uint8_t nist_kas_ecc_cdh_testvector_237_out[] = {
/* ZIUT */
	0x07, 0x24, 0xc9, 0x79, 0xaf, 0xfb, 0x3a, 0xb8, 0xd3, 0x07, 0x52, 0x97,
	0x59, 0xba, 0xe5, 0xfa, 0x67, 0x31, 0x9d, 0x44, 0x18, 0x51, 0xe5, 0x81,
	0x7f, 0xef, 0x01, 0x43, 0x50, 0xe3, 0x01, 0x4e, 0x06, 0x84, 0x28, 0xc9,
	0xda, 0xc3, 0x95, 0xc5, 0xe7, 0xb9, 0xe5, 0xb8, 0x87, 0x74, 0x57, 0xb3,
	0xe4, 0x62, 0x5e, 0xf4, 0x9e, 0xde, 0x4a, 0xe3, 0x62, 0x67, 0x55, 0xee,
	0xfc, 0x3f, 0xb3, 0xcf, 0x09, 0xc2, 0x3e, 0x8a, 0x5a, 0x9f, 0x8c, 0x25
};
/* COUNT = 12 */
static const uint8_t nist_kas_ecc_cdh_testvector_238_public_x[] = {
/* QCAVSx */
	0x01, 0x8b, 0xb6, 0xcb, 0xfc, 0xbf, 0xba, 0xed, 0x46, 0x85, 0x64, 0xb3,
	0x68, 0xf0, 0xb0, 0xab, 0xc3, 0xfb, 0xca, 0x47, 0xdc, 0xc1, 0x9f, 0x2c,
	0x84, 0x6b, 0xfa, 0x28, 0x73, 0x70, 0xe1, 0xb9, 0x12, 0xf6, 0xb7, 0x0e,
	0x08, 0x51, 0x9f, 0x57, 0x7f, 0x0c, 0xac, 0x32, 0x5b, 0x79, 0xfd, 0x66,
	0xb6, 0xb2, 0x3a, 0xa1, 0xe2, 0xae, 0x26, 0x2b, 0xcd, 0x2e, 0x7a, 0x8b,
	0x2c, 0x2d, 0x98, 0xd9, 0xed, 0x77, 0xa5, 0x4c, 0x72, 0x95, 0xf9, 0x8d
};
static const uint8_t nist_kas_ecc_cdh_testvector_238_public_y[] = {
/* QCAVSy */
	0x05, 0xbe, 0x9b, 0xbd, 0x91, 0x77, 0x2b, 0xb4, 0x22, 0x66, 0xab, 0xa9,
	0xc8, 0x93, 0xe5, 0x66, 0x70, 0xcf, 0xb6, 0x6c, 0xaf, 0xbe, 0x44, 0x01,
	0xca, 0x2c, 0xb5, 0x76, 0x5b, 0x46, 0x95, 0x04, 0x84, 0x85, 0x97, 0xc7,
	0xf4, 0x46, 0xe9, 0x98, 0x14, 0x74, 0x67, 0x87, 0x15, 0x8a, 0x83, 0xeb,
	0xf8, 0xe3, 0x79, 0x68, 0x57, 0x36, 0x3a, 0x8e, 0x04, 0xf8, 0x74, 0x2a,
	0x09, 0xd7, 0xec, 0xa1, 0x63, 0x86, 0xd6, 0x0f, 0xd7, 0xc8, 0x58, 0xdf
};
static const uint8_t nist_kas_ecc_cdh_testvector_238_private[] = {
/* dIUT */
	0x00, 0xa1, 0x9a, 0x0e, 0xdf, 0x50, 0x83, 0x47, 0xf4, 0x40, 0x2c, 0xec,
	0xbc, 0xe1, 0x27, 0xdc, 0x64, 0x10, 0xb1, 0x96, 0x7d, 0x3f, 0x89, 0xe6,
	0xb3, 0xba, 0x08, 0xb4, 0x8a, 0xad, 0x08, 0xcd, 0x6c, 0xa5, 0xe5, 0xd1,
	0x22, 0x8c, 0xdc, 0xc4, 0x1a, 0x1c, 0x38, 0x0f, 0x2a, 0xe9, 0x05, 0x2d,
	0x73, 0xdb, 0x75, 0x50, 0xe7, 0xa3, 0xc1, 0xd8, 0x57, 0x05, 0x6c, 0x98,
	0x94, 0x7f, 0x5b, 0x2c, 0x71, 0xc3, 0x3c, 0x4e, 0xeb, 0xc1, 0x21, 0x0c
};
/* QIUTx = 0629f70558308708e6929b1ad0fe3128a8af7f96591b47cb8ea2c3454120a6d393ed989d13231c661966a378b967efa64d3c0938e9c0b8b16c99d7349bdd59e2d44804f8fee1fb47 */
/* QIUTy = 06a5e50fd5024d8953e32242823250e998ca602b52599405129735a874e833b3bd73d7a9dc53adea092ba8d24207f5ea5657a29919b88a6d63fd0a943b56dde4c8478481b57723e4 */
static const uint8_t nist_kas_ecc_cdh_testvector_238_out[] = {
/* ZIUT */
	0x00, 0x5a, 0x52, 0x65, 0x88, 0xa3, 0xa2, 0xce, 0x08, 0xb2, 0x09, 0x25,
	0xe8, 0x39, 0x87, 0xeb, 0x0a, 0x1e, 0x68, 0xf9, 0x97, 0x10, 0x2d, 0xf7,
	0xf9, 0xaf, 0x83, 0x82, 0x3a, 0xc8, 0xe0, 0x6a, 0xbb, 0xd2, 0x9c, 0x04,
	0xcb, 0x1f, 0x97, 0x4b, 0xa9, 0xc9, 0xac, 0x49, 0xb4, 0x8b, 0x5a, 0xf3,
	0x76, 0x79, 0xa3, 0x9b, 0x53, 0x2d, 0x35, 0x9c, 0xde, 0xc3, 0xd4, 0x1b,
	0x3f, 0x80, 0xa1, 0xee, 0x12, 0xc8, 0x02, 0x76, 0x25, 0x6b, 0x73, 0x8d
};
/* COUNT = 13 */
static const uint8_t nist_kas_ecc_cdh_testvector_239_public_x[] = {
/* QCAVSx */
	0x03, 0x21, 0x84, 0xb6, 0x86, 0x3e, 0x2c, 0xb5, 0xbc, 0x71, 0xba, 0xff,
	0x5b, 0x6b, 0x57, 0xa1, 0x05, 0x94, 0x83, 0x1c, 0xc1, 0x1a, 0x9e, 0x5e,
	0xed, 0xec, 0x48, 0x04, 0xe2, 0x01, 0x6e, 0x3d, 0xd0, 0x64, 0xcf, 0xfd,
	0x12, 0xa1, 0xee, 0xa0, 0xf6, 0x93, 0x29, 0x11, 0xde, 0xd3, 0x45, 0xac,
	0xe5, 0xc1, 0xff, 0x25, 0x0b, 0x96, 0x48, 0xd9, 0x3b, 0x95, 0x33, 0x86,
	0xda, 0xe9, 0xb5, 0x62, 0x8c, 0x3c, 0x62, 0x52, 0x7b, 0x89, 0x05, 0x19
};
static const uint8_t nist_kas_ecc_cdh_testvector_239_public_y[] = {
/* QCAVSy */
	0x07, 0xf7, 0x83, 0xe0, 0x34, 0x1a, 0x87, 0x1e, 0x62, 0x56, 0xda, 0x34,
	0x9e, 0xbb, 0x53, 0x9f, 0x88, 0x76, 0x7d, 0x7d, 0xac, 0x15, 0x11, 0xe3,
	0xc3, 0xe4, 0xd4, 0x3b, 0x0f, 0xd3, 0x1d, 0x5d, 0xd2, 0xc2, 0xf0, 0xf1,
	0x76, 0xea, 0xc5, 0x44, 0xa8, 0x71, 0xf4, 0x2b, 0x98, 0x3f, 0x8f, 0xba,
	0x4d, 0xf6, 0x7a, 0xb6, 0xa2, 0x39, 0xb7, 0xdf, 0x99, 0x72, 0x26, 0x30,
	0x4b, 0x73, 0x16, 0x5d, 0x96, 0x2f, 0x4e, 0x1d, 0x2d, 0x18, 0xde, 0x9f
};
static const uint8_t nist_kas_ecc_cdh_testvector_239_private[] = {
/* dIUT */
	0x00, 0x4c, 0xac, 0x3f, 0xcc, 0x00, 0x73, 0x44, 0x42, 0xcd, 0xd8, 0x0e,
	0xaf, 0x82, 0x44, 0x12, 0xc2, 0x0e, 0xa9, 0xee, 0xb0, 0x3d, 0x43, 0xb9,
	0x99, 0xd4, 0x9d, 0xe6, 0x18, 0x73, 0x60, 0x20, 0x20, 0xa2, 0xb3, 0xc4,
	0x79, 0x65, 0xf6, 0xf4, 0x53, 0xb9, 0x1b, 0x7a, 0x2c, 0x1d, 0x93, 0xe1,
	0x3a, 0x89, 0x54, 0x45, 0x33, 0xe3, 0x5a, 0x12, 0x2c, 0xfc, 0x86, 0x12,
	0xc8, 0x69, 0x0b, 0x69, 0xbb, 0x7a, 0x55, 0x78, 0x75, 0xf9, 0x60, 0xb2
};
/* QIUTx = 03e211c3b4986927c4388d1680cb4770dee6c78266724582c66ccc50c6cb28239474d521facc7206af6bb29cced733edbbc0d20b9264ce63d9437188e3d31c0e0bc3e9f9d88429e4 */
/* QIUTy = 037a7c59012a82d59cc1e2f0fd4fd751e5737acb77f2a0799e0af38996ab5e11090a6396cc480e6f2aabd8fad44611691e5822115fd49d2a000c9b49d1f4964e24d43fbb81fa879f */
static const uint8_t nist_kas_ecc_cdh_testvector_239_out[] = {
/* ZIUT */
	0x04, 0x9d, 0xb6, 0x8d, 0xc9, 0xfb, 0x4c, 0xfb, 0xad, 0x82, 0x47, 0xca,
	0x4f, 0xe7, 0xc5, 0x73, 0xc0, 0x64, 0x0a, 0xbe, 0xad, 0x8f, 0x31, 0x91,
	0x94, 0xd6, 0x65, 0xec, 0xaf, 0x4f, 0x04, 0xb6, 0x1f, 0x84, 0xf5, 0xdf,
	0x0d, 0x8a, 0x63, 0x86, 0xf6, 0xdf, 0x04, 0xca, 0x1a, 0x68, 0x5a, 0x73,
	0x94, 0x56, 0x7e, 0xba, 0x5d, 0xeb, 0x9f, 0x73, 0x9b, 0x1e, 0x62, 0x3e,
	0xd6, 0x50, 0x70, 0x21, 0x59, 0x3f, 0x0e, 0x22, 0xe2, 0xdf, 0xc3, 0xf6
};
/* COUNT = 14 */
static const uint8_t nist_kas_ecc_cdh_testvector_240_public_x[] = {
/* QCAVSx */
	0x07, 0x1e, 0x16, 0x7e, 0x59, 0xe2, 0xa7, 0x09, 0xeb, 0xf4, 0xbe, 0x3d,
	0x83, 0xfb, 0x9d, 0xc6, 0x9e, 0xd7, 0x49, 0xe3, 0xab, 0x8a, 0x54, 0xe2,
	0x02, 0xc3, 0x5f, 0x8d, 0x45, 0xde, 0xaa, 0x2b, 0xda, 0x86, 0xc2, 0xaf,
	0xa1, 0xb0, 0xa0, 0x47, 0x54, 0xd1, 0x88, 0x98, 0xfc, 0xdd, 0x9b, 0x18,
	0x5f, 0x1d, 0x8b, 0xa2, 0xe1, 0x80, 0xa4, 0x7a, 0xc2, 0x91, 0xbb, 0x4a,
	0xad, 0x8f, 0x99, 0x7f, 0x73, 0xb1, 0x42, 0x3b, 0xcd, 0x7e, 0x9b, 0x92
};
static const uint8_t nist_kas_ecc_cdh_testvector_240_public_y[] = {
/* QCAVSy */
	0x05, 0x71, 0x19, 0x08, 0x5b, 0xc7, 0xcb, 0x20, 0x23, 0xd2, 0x3f, 0x88,
	0x10, 0x14, 0x20, 0xf9, 0xf5, 0x08, 0xf0, 0xdb, 0x94, 0xf8, 0xdf, 0xbe,
	0xdd, 0x5c, 0xbe, 0x88, 0xce, 0xc8, 0x0a, 0x9d, 0xc7, 0x08, 0xdf, 0x6c,
	0xcc, 0xdf, 0x81, 0x5d, 0x75, 0xb1, 0x46, 0x28, 0x0d, 0x7c, 0xd2, 0xeb,
	0x97, 0xcf, 0x1a, 0x7d, 0xd5, 0x50, 0xbe, 0x52, 0x38, 0x24, 0xf9, 0x32,
	0xa7, 0x77, 0x67, 0x9f, 0x2e, 0xe9, 0xf6, 0x6d, 0x42, 0x58, 0xdd, 0xa6
};
static const uint8_t nist_kas_ecc_cdh_testvector_240_private[] = {
/* dIUT */
	0x00, 0xd5, 0x14, 0x14, 0x4d, 0x45, 0x48, 0xbc, 0xfc, 0xbc, 0xf5, 0x70,
	0x09, 0xf7, 0xe8, 0xee, 0x10, 0x4b, 0x15, 0x45, 0x6f, 0x49, 0x18, 0x26,
	0xbd, 0xfd, 0x9b, 0xa6, 0x7e, 0x87, 0x1f, 0xdb, 0xd8, 0xfc, 0x84, 0x90,
	0xec, 0xbc, 0xb2, 0x69, 0x09, 0x1f, 0xc7, 0x52, 0x9e, 0x5e, 0x55, 0x71,
	0x3a, 0x81, 0xde, 0x20, 0xc0, 0xed, 0x01, 0xec, 0xb3, 0x15, 0x9a, 0xe6,
	0x14, 0x24, 0xbd, 0xbc, 0x56, 0x53, 0x73, 0x25, 0x87, 0xd1, 0xe9, 0x4f
};
/* QIUTx = 03ee5f877b737dae40baf91e0cc581dfe8d291f8c451d5bfc0b690df7025875d9569d52021b3b6890e01a2ba95899e2928a902cd5dc8143c07ea26749a9c94068b5c34c596b0943e */
/* QIUTy = 058e1ba516a818cae9b37086287e088083e2b421fef0b59ba816ab031375d09d7af7d57866744687be3bb41ce2276d3a38f97bbb9fb59f24a92f0085b04ee5ed1ac0efa671394f73 */
static const uint8_t nist_kas_ecc_cdh_testvector_240_out[] = {
/* ZIUT */
	0x03, 0x43, 0xc4, 0x5d, 0xaa, 0xb4, 0xf9, 0x1e, 0x02, 0xef, 0x9b, 0xd6,
	0xe1, 0xcd, 0x15, 0x7b, 0x00, 0xab, 0x0a, 0xb0, 0xa3, 0xe0, 0xd9, 0x73,
	0x49, 0x18, 0xa1, 0xd8, 0x96, 0xcd, 0xf7, 0xcc, 0x12, 0x12, 0xbf, 0x74,
	0xd7, 0xbb, 0x9b, 0xf9, 0x6b, 0xd4, 0xab, 0xf4, 0x2d, 0xf3, 0x25, 0x75,
	0x6c, 0x40, 0x72, 0x17, 0xf4, 0x4a, 0x59, 0x50, 0xc2, 0xb6, 0x6a, 0xf8,
	0x20, 0x69, 0x27, 0x42, 0xed, 0x7e, 0xbe, 0x14, 0xe4, 0x8d, 0x2d, 0x88
};
/* COUNT = 15 */
static const uint8_t nist_kas_ecc_cdh_testvector_241_public_x[] = {
/* QCAVSx */
	0x07, 0x4f, 0x1a, 0x7b, 0x5c, 0xfb, 0x0e, 0xee, 0xf1, 0xe1, 0x5e, 0x63,
	0x51, 0x2c, 0x73, 0x18, 0x8d, 0xaf, 0xbe, 0x88, 0xe8, 0xe9, 0xc4, 0x20,
	0x73, 0xb2, 0xb6, 0x52, 0xb9, 0xf0, 0x28, 0x21, 0x4f, 0x0b, 0xec, 0x79,
	0x14, 0x2d, 0x88, 0x89, 0x41, 0x6a, 0xbf, 0x7a, 0x83, 0xe2, 0x9f, 0x47,
	0x9e, 0x7b, 0xc3, 0xca, 0x65, 0x7e, 0xf0, 0xa1, 0x0c, 0x2e, 0xa3, 0xad,
	0xe3, 0x11, 0x7c, 0x0d, 0x36, 0x9d, 0xac, 0xc2, 0x33, 0x9d, 0x1c, 0x12
};
static const uint8_t nist_kas_ecc_cdh_testvector_241_public_y[] = {
/* QCAVSy */
	0x00, 0xe8, 0x99, 0x2a, 0x54, 0x07, 0x67, 0x53, 0x02, 0x9f, 0x2c, 0x0e,
	0x9d, 0x8c, 0x16, 0x6e, 0x6b, 0xa8, 0x48, 0x96, 0xa4, 0x78, 0x5f, 0xff,
	0xf5, 0x98, 0xc4, 0x82, 0x3e, 0x54, 0x61, 0xff, 0x00, 0x54, 0x90, 0xbb,
	0x7f, 0xb6, 0xd8, 0x78, 0xac, 0x34, 0xf4, 0x27, 0xfd, 0x9d, 0xb4, 0x8c,
	0xbd, 0xf1, 0x2e, 0xb9, 0x82, 0x6d, 0x68, 0xfd, 0x2c, 0xf1, 0x71, 0xd4,
	0xd6, 0x1c, 0x3f, 0x27, 0x5d, 0x44, 0x94, 0x7d, 0x4d, 0xf4, 0xc7, 0x52
};
static const uint8_t nist_kas_ecc_cdh_testvector_241_private[] = {
/* dIUT */
	0x00, 0xcc, 0xc6, 0xdc, 0xa5, 0xa9, 0x85, 0x58, 0x3c, 0xe0, 0x08, 0x12,
	0xc3, 0xd0, 0x78, 0x22, 0xf6, 0x34, 0x1c, 0x79, 0xd7, 0x8c, 0x16, 0xb2,
	0xe7, 0xae, 0x4b, 0xbf, 0x5b, 0xff, 0xac, 0x1a, 0xcd, 0x9d, 0xea, 0xb6,
	0x78, 0x19, 0x3f, 0x8f, 0x89, 0xb0, 0xe2, 0xaa, 0xe5, 0x2e, 0x30, 0x31,
	0x14, 0x44, 0xdd, 0x11, 0x25, 0x3f, 0x96, 0xd6, 0x2d, 0xb3, 0xab, 0xfb,
	0x17, 0xe4, 0x23, 0xf0, 0xdd, 0xf0, 0xe9, 0x91, 0x08, 0x11, 0x54, 0xc3
};
/* QIUTx = 03826215343cfd4ad968d572bab2dee2279f9e8effa0ff80b0df5dd2ea822b502274e507c87d2429dd8bbdba6eb8ab433b1ee1cad3a97c7d244194fd9a43f3e1ff33144e2db80864 */
/* QIUTy = 070f4508ae391ce24154b38873af0082d95895ac92fd1aa321ba93beef404a63f7b1afa1feec997885523a6688ada94dd45eb32ca7f1bb87e63c4de97493196c3b53cf83d218dc37 */
static const uint8_t nist_kas_ecc_cdh_testvector_241_out[] = {
/* ZIUT */
	0x04, 0xa5, 0x65, 0xcb, 0x3e, 0x15, 0x23, 0x6a, 0x7f, 0x6c, 0x41, 0x3a,
	0xfe, 0xb4, 0x19, 0xc0, 0x82, 0x42, 0x7b, 0x10, 0xa6, 0xd0, 0x7f, 0xf8,
	0x7e, 0x81, 0x74, 0x07, 0x16, 0x43, 0x3c, 0x06, 0xb3, 0x25, 0x44, 0x14,
	0x38, 0x1e, 0x4f, 0xf9, 0x86, 0x03, 0x40, 0xdd, 0x62, 0x01, 0xab, 0x66,
	0x21, 0xd1, 0x62, 0xcd, 0x12, 0x04, 0x7a, 0x55, 0x15, 0xab, 0x1d, 0x65,
	0xf2, 0x0c, 0x97, 0xeb, 0x3d, 0x71, 0x32, 0x64, 0x2f, 0x8a, 0xd5, 0x8a
};
/* COUNT = 16 */
static const uint8_t nist_kas_ecc_cdh_testvector_242_public_x[] = {
/* QCAVSx */
	0x00, 0x4b, 0x54, 0xb3, 0xce, 0xfd, 0x41, 0x5f, 0x5e, 0xaa, 0xca, 0x4a,
	0xe4, 0xe5, 0xda, 0xcf, 0xbc, 0xe2, 0x0c, 0xba, 0x19, 0x32, 0xa2, 0xf5,
	0x05, 0x49, 0xbc, 0xd3, 0x16, 0x30, 0x01, 0x7a, 0xd2, 0x14, 0x75, 0xdf,
	0x15, 0x4f, 0xf3, 0x7b, 0xe1, 0x3c, 0xa6, 0x1a, 0x4c, 0x60, 0x33, 0x6b,
	0x33, 0xd0, 0xff, 0xc7, 0x62, 0xaa, 0x9e, 0x9e, 0x9f, 0xc6, 0xe6, 0xfd,
	0x17, 0x25, 0x0b, 0x5e, 0x40, 0x22, 0xb5, 0x51, 0x41, 0xd2, 0x3f, 0xbf
};
static const uint8_t nist_kas_ecc_cdh_testvector_242_public_y[] = {
/* QCAVSy */
	0x05, 0x6f, 0x7c, 0x8d, 0x65, 0xc5, 0x68, 0xde, 0x95, 0xbd, 0x16, 0x64,
	0xff, 0xf7, 0x14, 0x29, 0xec, 0x73, 0x89, 0x87, 0x69, 0x7f, 0x21, 0x7d,
	0xe5, 0xad, 0xf3, 0x6d, 0x14, 0xa8, 0x0b, 0x6f, 0xe5, 0x85, 0xe4, 0x68,
	0x5e, 0x03, 0xc8, 0x18, 0x38, 0xab, 0xed, 0xfd, 0xc0, 0x5a, 0x1e, 0x01,
	0x40, 0x7a, 0xf4, 0xab, 0x98, 0x9f, 0xc1, 0xd1, 0x27, 0x3b, 0xa8, 0xa1,
	0x82, 0xc4, 0x61, 0x85, 0x6d, 0x5e, 0xff, 0xe7, 0x05, 0xd7, 0xdf, 0xe5
};
static const uint8_t nist_kas_ecc_cdh_testvector_242_private[] = {
/* dIUT */
	0x01, 0x88, 0x62, 0x13, 0x65, 0x8b, 0xd1, 0x7e, 0x7d, 0xc3, 0x34, 0xdd,
	0x80, 0x03, 0x92, 0x6a, 0x44, 0x7c, 0x34, 0xa1, 0x97, 0xee, 0x5d, 0x6d,
	0x0b, 0xbc, 0x46, 0xe8, 0x5e, 0xc1, 0xcf, 0xa6, 0x80, 0x28, 0x58, 0xd1,
	0xc3, 0x67, 0x27, 0x6c, 0xa5, 0x72, 0xba, 0x27, 0xaa, 0x7a, 0x5d, 0x1e,
	0x21, 0x69, 0x02, 0x41, 0x6b, 0x48, 0xaf, 0x6e, 0x42, 0x77, 0x94, 0x5e,
	0x46, 0x5d, 0x7d, 0x84, 0x0d, 0xff, 0x14, 0x38, 0x54, 0x3c, 0xaa, 0x46
};
/* QIUTx = 047f6cc42107c40c168dc679a864f969b53f756257113b7502796efa54cdcce704b9344ee4bf964752d68910262bd26ab6b347084404b28306ca3425f29894ce6fd4293c5973522f */
/* QIUTy = 060cfdb5467675a789923be973c6645dbe26d00a39d4e81255217291a3882cfa8f91f4aa8214d3524c95ef6a24e47b3b9d0ef55f670756ae4a4d9c65f075f4170b2d18aafbca0265 */
static const uint8_t nist_kas_ecc_cdh_testvector_242_out[] = {
/* ZIUT */
	0x04, 0x72, 0x65, 0x83, 0x1f, 0x1f, 0x58, 0x9b, 0x5f, 0x30, 0x80, 0x6e,
	0x2f, 0xb8, 0x0a, 0xa7, 0x84, 0x4c, 0xbf, 0x32, 0xb6, 0x99, 0x33, 0x84,
	0xbe, 0xaa, 0xc7, 0xd9, 0x92, 0xb3, 0x27, 0xb9, 0x7d, 0xfd, 0x0b, 0xb8,
	0x9c, 0xa0, 0x9e, 0x71, 0x15, 0x07, 0xe8, 0x46, 0xed, 0x4a, 0xd0, 0x03,
	0xe7, 0x11, 0x5f, 0xa8, 0x84, 0x3b, 0x23, 0xd3, 0x8f, 0x32, 0x0e, 0x43,
	0xb5, 0xeb, 0x50, 0x6b, 0xde, 0x48, 0xfb, 0xd7, 0xaf, 0x49, 0x83, 0xb9
};
/* COUNT = 17 */
static const uint8_t nist_kas_ecc_cdh_testvector_243_public_x[] = {
/* QCAVSx */
	0x07, 0xec, 0x71, 0xbe, 0xa0, 0x81, 0x19, 0x0a, 0x9c, 0x4c, 0xdf, 0xf8,
	0x09, 0xed, 0x2b, 0x65, 0xa7, 0x78, 0x00, 0xcd, 0x1b, 0x3b, 0xef, 0xfd,
	0x1e, 0x40, 0x04, 0xd1, 0x26, 0xac, 0x35, 0x2d, 0x24, 0x23, 0x5c, 0x79,
	0x7a, 0x5a, 0x56, 0x7d, 0xae, 0xf7, 0x39, 0x3d, 0x27, 0x66, 0x38, 0x13,
	0x2e, 0xa7, 0xf0, 0xf6, 0x1e, 0x55, 0x0d, 0xc2, 0x51, 0xd3, 0x41, 0xf6,
	0x61, 0x02, 0xf9, 0x6c, 0x2a, 0xbf, 0x7e, 0xe3, 0x7c, 0x0f, 0xc9, 0xed
};
static const uint8_t nist_kas_ecc_cdh_testvector_243_public_y[] = {
/* QCAVSy */
	0x00, 0xef, 0xc2, 0xac, 0x87, 0x05, 0xb2, 0xf9, 0xc9, 0xc0, 0x6a, 0x91,
	0x0a, 0x30, 0x4c, 0x42, 0xb1, 0xad, 0x53, 0x10, 0x1a, 0xeb, 0x0d, 0x14,
	0x63, 0x19, 0xdc, 0x24, 0x81, 0x5c, 0x7c, 0xc1, 0x98, 0x3b, 0x1c, 0xad,
	0x91, 0xd5, 0xf9, 0xc6, 0xd5, 0xee, 0xf1, 0x67, 0x7a, 0x1f, 0x2d, 0x2b,
	0xdd, 0x75, 0xa1, 0xfb, 0x4c, 0x57, 0x96, 0xa4, 0xc5, 0x69, 0x64, 0xaa,
	0x3e, 0x43, 0xf3, 0xda, 0x26, 0xc7, 0x37, 0xed, 0xd9, 0xcb, 0x09, 0x10
};
static const uint8_t nist_kas_ecc_cdh_testvector_243_private[] = {
/* dIUT */
	0x00, 0x4c, 0x0d, 0xd3, 0x71, 0x5e, 0x88, 0x88, 0xdc, 0x22, 0x22, 0x06,
	0x9e, 0x7f, 0x61, 0x18, 0x01, 0x68, 0x51, 0x40, 0x30, 0x3e, 0x16, 0xb8,
	0xb4, 0x43, 0x43, 0x3d, 0x5e, 0x18, 0xa4, 0xb1, 0x80, 0x3d, 0x56, 0x80,
	0x41, 0x6a, 0xeb, 0xda, 0x7a, 0xe7, 0xe9, 0x44, 0x91, 0x54, 0xbe, 0x34,
	0x6a, 0x7d, 0xcb, 0x36, 0xc1, 0xdb, 0x22, 0x74, 0x46, 0x73, 0xfb, 0x3b,
	0x24, 0x5e, 0x58, 0x44, 0x07, 0x87, 0xed, 0x3d, 0xec, 0x6d, 0x3d, 0xb5
};
/* QIUTx = 02fb241eb2c28a1b0675b5760fe5663efa603eb0590842f455973f0573e148a47e63f97e8df9a570b0655d5afc42019fe95fe44fdb02a68271d82df580010f91dff0cb3d9bda8992 */
/* QIUTy = 033f93a9dc39d87403b6a94dc0632dec6757842d0aaf8ad8c41ebb637058bfc11c19a3a9abddf204201ef4f96fe9629233a5070a08794d14470091e30cdd876aaf65407627233234 */
static const uint8_t nist_kas_ecc_cdh_testvector_243_out[] = {
/* ZIUT */
	0x05, 0x9b, 0x62, 0xc2, 0x5c, 0x96, 0x95, 0x5b, 0x8f, 0xb4, 0xde, 0xdd,
	0xcf, 0x90, 0xeb, 0xe6, 0x84, 0x5e, 0xe7, 0x1e, 0xa3, 0x57, 0x73, 0x92,
	0x73, 0xd6, 0xd6, 0x7f, 0x21, 0xa0, 0xc4, 0x7d, 0x15, 0x4a, 0xdd, 0x9d,
	0x5d, 0x4d, 0x2b, 0x65, 0x7f, 0xe1, 0x98, 0x8a, 0xd6, 0x14, 0xb0, 0xb4,
	0x90, 0x2f, 0xaa, 0x92, 0xfe, 0x99, 0x9a, 0xbd, 0x75, 0x4a, 0xd3, 0x3c,
	0xd6, 0xb9, 0x2f, 0xe2, 0xf6, 0xa6, 0x8a, 0x6f, 0x2c, 0x1e, 0xeb, 0x27
};
/* COUNT = 18 */
static const uint8_t nist_kas_ecc_cdh_testvector_244_public_x[] = {
/* QCAVSx */
	0x06, 0x70, 0x86, 0x86, 0xb4, 0xf5, 0xad, 0x2f, 0xec, 0x45, 0x7a, 0xad,
	0x5a, 0xc4, 0xa3, 0xdc, 0x48, 0x67, 0xa4, 0x77, 0xeb, 0x54, 0xfc, 0x0d,
	0x49, 0x35, 0x11, 0xb5, 0x56, 0x1e, 0xa1, 0x51, 0xdd, 0x4c, 0xaf, 0x5d,
	0x43, 0x11, 0x98, 0x35, 0x00, 0xb4, 0x8c, 0x80, 0x43, 0xaf, 0x09, 0xe3,
	0xf4, 0x04, 0x2d, 0x5a, 0x07, 0xeb, 0xf0, 0x50, 0xa4, 0xe8, 0x01, 0xda,
	0xee, 0xf3, 0x31, 0x7b, 0xe0, 0x93, 0x95, 0x50, 0x20, 0x45, 0x2b, 0x29
};
static const uint8_t nist_kas_ecc_cdh_testvector_244_public_y[] = {
/* QCAVSy */
	0x05, 0x25, 0xc8, 0x68, 0x25, 0x83, 0xb5, 0x5f, 0x7e, 0xce, 0xc5, 0x9b,
	0x92, 0x08, 0x46, 0xf7, 0x5d, 0x11, 0xd0, 0x21, 0xe9, 0xff, 0xb2, 0x00,
	0x18, 0x63, 0x9f, 0x6a, 0xb9, 0x30, 0x22, 0x47, 0x2c, 0x19, 0x2d, 0x39,
	0x8e, 0x15, 0x0c, 0xdc, 0x63, 0x0a, 0x11, 0xfc, 0xf9, 0x42, 0xe5, 0xd2,
	0x38, 0xcd, 0x6c, 0x14, 0xb3, 0x0f, 0x44, 0xa2, 0x4d, 0x2f, 0x84, 0x3e,
	0xc5, 0xd1, 0x35, 0xdd, 0xc7, 0xab, 0xda, 0x56, 0x04, 0x7a, 0xbc, 0x21
};
static const uint8_t nist_kas_ecc_cdh_testvector_244_private[] = {
/* dIUT */
	0x00, 0x7d, 0x54, 0x19, 0x4f, 0xc2, 0x26, 0xcc, 0x39, 0xf6, 0x40, 0xd3,
	0xd1, 0x7b, 0x9b, 0x95, 0xb7, 0x0b, 0x51, 0xf9, 0x8a, 0xd5, 0xca, 0x19,
	0x91, 0x56, 0x61, 0x08, 0xd8, 0x39, 0xe3, 0x77, 0xe2, 0x1b, 0xa4, 0x8c,
	0xbf, 0x44, 0x15, 0x30, 0xb3, 0x34, 0x1d, 0xdc, 0x61, 0xb0, 0xa5, 0x81,
	0x41, 0xaa, 0xa6, 0x65, 0x30, 0x24, 0x1f, 0xa5, 0x29, 0x50, 0x5d, 0x70,
	0x80, 0x4b, 0x25, 0x60, 0xc5, 0xbe, 0x48, 0x13, 0x10, 0xb9, 0x96, 0x2d
};
/* QIUTx = 02ed5f3a2efa4ab0f9db5fced7b1300de4d457a9ad0827457e5e1c4bc15ebd183775de4b73c1f820dd4033366100e48b4164d04e9fb6cf1a4bdb55122a86005fbd0bd2cddbc95fa7 */
/* QIUTy = 0327fe654ef68563cc8888acca85163c2b154fb70b0f4a2b58c36388a0c25f80a4c887977d46000dc4d86e95cfd8f9065c00eb28653c8fb477bbb5c63dd47b83ca5e0f871e9eed3d */
static const uint8_t nist_kas_ecc_cdh_testvector_244_out[] = {
/* ZIUT */
	0x02, 0x77, 0x7c, 0x72, 0x85, 0x3b, 0x76, 0xb2, 0x9f, 0x69, 0xd3, 0xaa,
	0x27, 0xa1, 0x65, 0x97, 0x89, 0xa0, 0x25, 0xaf, 0x06, 0x33, 0xd8, 0x33,
	0xb2, 0x2b, 0x57, 0xbf, 0x32, 0x8d, 0x23, 0x1e, 0xbd, 0x12, 0x8b, 0xf9,
	0x6a, 0x4c, 0x8a, 0x7f, 0xfd, 0x2e, 0xe7, 0xa5, 0x1e, 0x5e, 0xbb, 0x7a,
	0x8e, 0x5b, 0xca, 0x20, 0xe4, 0xad, 0x49, 0x67, 0x1a, 0x21, 0x23, 0xdf,
	0xbc, 0x0d, 0x6c, 0x40, 0x59, 0x4e, 0x04, 0x76, 0x51, 0x86, 0xde, 0x06
};
/* COUNT = 19 */
static const uint8_t nist_kas_ecc_cdh_testvector_245_public_x[] = {
/* QCAVSx */
	0x07, 0xce, 0x76, 0x74, 0x40, 0x3d, 0xfc, 0x62, 0x89, 0x5d, 0x71, 0xe2,
	0xab, 0x58, 0x7c, 0xe7, 0x35, 0xf2, 0x79, 0xf1, 0x2f, 0x7d, 0xf3, 0x16,
	0x13, 0x35, 0xbe, 0x43, 0xfc, 0x29, 0x08, 0xea, 0x73, 0x6f, 0x6f, 0x58,
	0xb9, 0x32, 0xd7, 0x93, 0xaf, 0xf6, 0x6f, 0x33, 0x27, 0x35, 0xd4, 0xd3,
	0x8f, 0x05, 0xcb, 0x03, 0xcf, 0x27, 0x5c, 0xa0, 0xe0, 0x0d, 0xa1, 0xf5,
	0x73, 0x81, 0xe0, 0x8b, 0xfe, 0xb5, 0x01, 0x78, 0x77, 0x34, 0x22, 0x72
};
static const uint8_t nist_kas_ecc_cdh_testvector_245_public_y[] = {
/* QCAVSy */
	0x07, 0xd6, 0x64, 0x9f, 0x3d, 0x91, 0xe7, 0xbf, 0x5f, 0x8d, 0xe6, 0x11,
	0xbd, 0x97, 0x18, 0x18, 0x10, 0x6d, 0xf2, 0xe3, 0x79, 0x35, 0xbb, 0x46,
	0x4c, 0xd9, 0xe7, 0x46, 0x96, 0x29, 0xc6, 0xae, 0x7e, 0x7f, 0x2b, 0x22,
	0x40, 0x27, 0x6c, 0xb0, 0xee, 0xdb, 0x7a, 0x26, 0xd0, 0xc7, 0xd3, 0x77,
	0xf4, 0x00, 0x9a, 0x1d, 0xd4, 0x8a, 0x79, 0x3c, 0xc9, 0x93, 0xfb, 0x0d,
	0x4a, 0x04, 0xdb, 0x1d, 0xba, 0xd4, 0x49, 0x33, 0x04, 0xbc, 0x5c, 0x0e
};
static const uint8_t nist_kas_ecc_cdh_testvector_245_private[] = {
/* dIUT */
	0x01, 0x07, 0x40, 0xb9, 0x58, 0x28, 0x52, 0x42, 0x04, 0x5c, 0xd5, 0x35,
	0x8d, 0x7f, 0xf9, 0x23, 0x2b, 0x7d, 0x7d, 0x41, 0x3a, 0xf7, 0xe2, 0x05,
	0xc2, 0x85, 0xf8, 0x84, 0x92, 0xef, 0x27, 0xa2, 0xfb, 0x85, 0x0e, 0x05,
	0x67, 0xec, 0x24, 0xc4, 0x80, 0xc7, 0x5a, 0xd3, 0x2f, 0x70, 0x34, 0x20,
	0x25, 0xc8, 0x62, 0x67, 0xdb, 0xe4, 0xff, 0x80, 0xa2, 0xc5, 0x09, 0xe5,
	0xb9, 0xa4, 0x51, 0x30, 0xe9, 0x9e, 0x7c, 0x7c, 0xc8, 0xcc, 0x6e, 0xce
};
/* QIUTx = 03f3f585cafd46a663b6cf8b8323ef9159d5195d3118f3edf38732ca0ff73b2d065d9e69ae1e3978b2ce6dc61500f7b8bbf6f6a70b47bb64cc4fd195bba6ac932b70beafe174148a */
/* QIUTy = 00b1566fe619f2cc00aba05e24a6cccbc91338b2eef553da0d477d6c8c0ac4c656e134dbcf31ffb15c67d589bd2918f1174909e5428c71c90e38c4e11b56236abfa1de6a8579eb4d */
static const uint8_t nist_kas_ecc_cdh_testvector_245_out[] = {
/* ZIUT */
	0x02, 0xc2, 0xec, 0x16, 0x32, 0xe8, 0x34, 0x16, 0x18, 0x2a, 0x9a, 0x43,
	0x8f, 0x73, 0x60, 0xb8, 0x80, 0x61, 0xba, 0xb8, 0x4f, 0x5b, 0xde, 0xd3,
	0xdd, 0x8a, 0x0c, 0x87, 0xba, 0xf4, 0x45, 0x07, 0xdf, 0x94, 0xfd, 0xcf,
	0x99, 0x35, 0x3b, 0x10, 0x7e, 0x61, 0xcf, 0xcf, 0xc8, 0xaf, 0x07, 0x1b,
	0x3a, 0xa8, 0xce, 0xc7, 0xb3, 0x4a, 0x54, 0x2b, 0xf2, 0xab, 0x8e, 0xa0,
	0xbd, 0x9d, 0xb6, 0x7d, 0x66, 0xb4, 0x28, 0xc9, 0xa6, 0xc1, 0x44, 0x58
};
/* COUNT = 20 */
static const uint8_t nist_kas_ecc_cdh_testvector_246_public_x[] = {
/* QCAVSx */
	0x04, 0x83, 0xad, 0x73, 0x82, 0xe3, 0x48, 0xaf, 0xc7, 0xf2, 0x71, 0xd5,
	0x0d, 0x8d, 0x39, 0xb8, 0x14, 0xb7, 0xd6, 0xdc, 0x0c, 0x56, 0x2a, 0x6b,
	0xa5, 0x56, 0x56, 0x80, 0x45, 0xbd, 0x2d, 0x62, 0x09, 0x06, 0xab, 0x11,
	0x06, 0xf9, 0x13, 0x7f, 0xf7, 0x25, 0x89, 0x2e, 0x84, 0x36, 0xa8, 0xcd,
	0x7b, 0x88, 0x89, 0x2a, 0x32, 0xf1, 0x9a, 0xb2, 0x69, 0xe2, 0xad, 0x30,
	0xd7, 0xf0, 0xec, 0x00, 0xe3, 0xa0, 0x52, 0xfb, 0xbc, 0x46, 0x63, 0x07
};
static const uint8_t nist_kas_ecc_cdh_testvector_246_public_y[] = {
/* QCAVSy */
	0x04, 0x1c, 0xc4, 0xb0, 0xf1, 0x95, 0xdc, 0x73, 0xc4, 0xa8, 0xe1, 0x06,
	0x05, 0xf2, 0xa3, 0x82, 0x92, 0x3a, 0xbd, 0x23, 0x81, 0xf2, 0x4e, 0x4a,
	0xbb, 0xd4, 0x01, 0xe0, 0x87, 0xc5, 0x0d, 0x18, 0xf6, 0xda, 0xb0, 0x1a,
	0x25, 0xdb, 0x7e, 0x89, 0xdf, 0xff, 0x68, 0xc6, 0x63, 0x49, 0x4f, 0xb4,
	0xd0, 0x87, 0xa8, 0x16, 0xb8, 0x54, 0x44, 0xd8, 0x82, 0xbe, 0xc2, 0xac,
	0x25, 0xe4, 0x2f, 0xde, 0x78, 0xeb, 0xcc, 0xa7, 0x9a, 0x6f, 0xdd, 0xf0
};
static const uint8_t nist_kas_ecc_cdh_testvector_246_private[] = {
/* dIUT */
	0x00, 0xc8, 0x5e, 0x5d, 0x2d, 0xed, 0x5b, 0xc3, 0xb6, 0xb5, 0x53, 0xfe,
	0x0a, 0x02, 0x31, 0x1b, 0x72, 0xbc, 0x5c, 0xdc, 0x8e, 0x96, 0xdf, 0x17,
	0x9c, 0xe5, 0x75, 0x11, 0xc2, 0x6a, 0xc9, 0xe8, 0x73, 0xfc, 0x1f, 0x76,
	0xcd, 0xde, 0x9a, 0x7d, 0x8e, 0x52, 0xa7, 0xe9, 0xbe, 0x5c, 0x77, 0x53,
	0x62, 0x03, 0x31, 0xe8, 0x97, 0x7a, 0x98, 0x90, 0x2b, 0x48, 0xae, 0x98,
	0x99, 0xce, 0x8a, 0x6a, 0x66, 0x36, 0x61, 0x12, 0x76, 0xae, 0x23, 0x83
};
/* QIUTx = 0289aa5209fe7b1ad7b9c5e0e630ba5e02929ea1b1f114d30a0648012bf029e066453f2d28e1d503665dd0833f0ba37e4583b434dd9956100a1ae6e54f96d9347d806741d3a76e31 */
/* QIUTy = 033afe87b29edef447ff5a02e63f64905b5f53ac856cfd7755ad542812ecdd568e8ae1f9d32fea0f02018dcfd0e16d6a6a2797b7e3dc855bfdb6b0d0b2525e143678d539bf8c0672 */
static const uint8_t nist_kas_ecc_cdh_testvector_246_out[] = {
/* ZIUT */
	0x07, 0xe1, 0xd2, 0x02, 0xa5, 0x4d, 0x34, 0x02, 0x09, 0x39, 0xf7, 0xae,
	0xd5, 0x69, 0x31, 0xf2, 0x1b, 0x20, 0x67, 0x61, 0xe4, 0xfc, 0x79, 0xb9,
	0xa7, 0xb3, 0x20, 0xf8, 0x10, 0x77, 0xbe, 0x32, 0x2a, 0xe7, 0x80, 0x94,
	0x46, 0xb5, 0xb3, 0xea, 0x70, 0x16, 0x18, 0xec, 0xdb, 0x0a, 0x17, 0x96,
	0xab, 0x80, 0x40, 0x7a, 0x28, 0x1b, 0xdb, 0xcb, 0x4d, 0x58, 0x01, 0x31,
	0xb6, 0x1f, 0x87, 0x43, 0xbf, 0xef, 0x7a, 0x4d, 0x9c, 0x59, 0x41, 0xf1
};
/* COUNT = 21 */
static const uint8_t nist_kas_ecc_cdh_testvector_247_public_x[] = {
/* QCAVSx */
	0x07, 0xa5, 0xe8, 0xeb, 0x49, 0x68, 0x49, 0x7a, 0x11, 0xb9, 0x0c, 0x60,
	0xe1, 0x3d, 0x5f, 0x3c, 0x61, 0xc6, 0x86, 0x85, 0x73, 0xa6, 0xb6, 0xdb,
	0x7c, 0x20, 0x8a, 0x85, 0x6d, 0x54, 0xe7, 0x4f, 0x43, 0x68, 0xe2, 0x81,
	0x00, 0xb9, 0xe0, 0xbf, 0x49, 0xfc, 0x31, 0x04, 0xe1, 0x46, 0xfb, 0xda,
	0x78, 0x46, 0x23, 0xa3, 0x6d, 0x9f, 0x01, 0xf2, 0x3e, 0xba, 0xdf, 0xab,
	0x04, 0xd7, 0xf4, 0x8f, 0xf6, 0x65, 0x06, 0xc6, 0x98, 0xbe, 0xdd, 0x11
};
static const uint8_t nist_kas_ecc_cdh_testvector_247_public_y[] = {
/* QCAVSy */
	0x01, 0x3d, 0xb9, 0x68, 0xfc, 0x7c, 0xd3, 0x38, 0xcb, 0x8e, 0x30, 0x42,
	0xa1, 0x71, 0xfa, 0x30, 0x6f, 0x9a, 0xb6, 0xf6, 0xc8, 0x65, 0xdd, 0xc5,
	0xba, 0x5f, 0xe9, 0x94, 0xa3, 0x0d, 0x8f, 0xc1, 0xfa, 0x12, 0x71, 0x91,
	0xf0, 0x8e, 0x4e, 0x14, 0xb9, 0xaa, 0x08, 0x6a, 0x52, 0xfb, 0xca, 0xa4,
	0x6d, 0x22, 0x10, 0x7f, 0xd6, 0xdf, 0x53, 0x10, 0x8b, 0x53, 0xfe, 0x0b,
	0xb9, 0x6b, 0xc9, 0x74, 0xc0, 0x3a, 0x8c, 0x65, 0x28, 0xf9, 0x79, 0x2d
};
static const uint8_t nist_kas_ecc_cdh_testvector_247_private[] = {
/* dIUT */
	0x00, 0x53, 0xa4, 0x8c, 0xfd, 0xa8, 0xee, 0x23, 0x2c, 0xea, 0x35, 0x49,
	0x92, 0x7b, 0x22, 0xf3, 0x75, 0xd6, 0x09, 0x65, 0x60, 0x02, 0x5e, 0x21,
	0x31, 0x61, 0xd4, 0x3e, 0xed, 0x02, 0xd0, 0x73, 0x65, 0xd9, 0xed, 0xe7,
	0xc9, 0x3d, 0x45, 0x7e, 0xa5, 0x1e, 0xa2, 0x36, 0x9e, 0x87, 0x46, 0x3e,
	0xdd, 0xbf, 0x25, 0xa0, 0x6b, 0xb1, 0xf0, 0x80, 0xfb, 0x47, 0x63, 0x07,
	0x4a, 0x82, 0x83, 0xdd, 0x3d, 0x69, 0xf1, 0xde, 0x86, 0x52, 0x95, 0xe3
};
/* QIUTx = 04790f9db600b9a0a57e03d274a3d23a55aa0d86b2d6fa07fafe3c9d4c3393771dde89c70a6470a31bad105c21d4844cd7bfc3b59738f9d6c528c414d524f88e0c862e4e17aff454 */
/* QIUTy = 05dc12db04e2489db8a46cdeff9f8d9d2e00d024f656c781eb4d2db167624b3a70addaaa158ca00601d4cad065917bebe766912faba9987fcc5fc8a78dd21643aa650e6a4a7e2061 */
static const uint8_t nist_kas_ecc_cdh_testvector_247_out[] = {
/* ZIUT */
	0x07, 0xf4, 0x9e, 0xe5, 0xd8, 0x22, 0xb1, 0x7e, 0x3f, 0x1e, 0xc9, 0x94,
	0x6f, 0xad, 0x8d, 0x0a, 0x0a, 0x6b, 0x32, 0x72, 0x42, 0xaf, 0xe6, 0x75,
	0x80, 0x6b, 0x3e, 0x6b, 0x75, 0x41, 0x74, 0x5e, 0x21, 0xcd, 0x1b, 0x70,
	0xdf, 0x92, 0x6a, 0xf0, 0x57, 0xa9, 0xf8, 0xde, 0xae, 0x4c, 0xb9, 0xa1,
	0xed, 0xc7, 0x82, 0x01, 0x44, 0x26, 0x15, 0x2e, 0x8a, 0xa4, 0xcf, 0x6a,
	0x40, 0x80, 0xda, 0xd4, 0x67, 0x8d, 0xc8, 0xff, 0x0d, 0x9e, 0x1a, 0xf9
};
/* COUNT = 22 */
static const uint8_t nist_kas_ecc_cdh_testvector_248_public_x[] = {
/* QCAVSx */
	0x01, 0x3c, 0xaa, 0xf8, 0xce, 0x2e, 0x23, 0x21, 0xcf, 0x25, 0x6f, 0x2b,
	0x64, 0xaa, 0x89, 0xad, 0xd6, 0x96, 0x8c, 0x29, 0x86, 0x24, 0xa2, 0x2b,
	0xd3, 0x8e, 0xf9, 0x4d, 0xeb, 0x3a, 0x70, 0xea, 0x44, 0xce, 0x87, 0xa9,
	0x48, 0xea, 0x56, 0xbf, 0x0e, 0xe9, 0x40, 0x71, 0x34, 0xf8, 0xc9, 0x7b,
	0x17, 0xb1, 0xf5, 0x45, 0x61, 0xff, 0x77, 0x47, 0xe3, 0xf6, 0xb6, 0x56,
	0xf8, 0x0d, 0x60, 0x77, 0x8d, 0x05, 0xb8, 0xc4, 0xcb, 0xbb, 0xcf, 0x3c
};
static const uint8_t nist_kas_ecc_cdh_testvector_248_public_y[] = {
/* QCAVSy */
	0x00, 0x47, 0xa2, 0xdc, 0xa3, 0xeb, 0x67, 0x54, 0xb0, 0xa9, 0xfd, 0x16,
	0xb0, 0x81, 0xfc, 0xa4, 0x97, 0xb2, 0x9d, 0xd2, 0xec, 0x9e, 0x6a, 0x75,
	0x96, 0xd0, 0x6b, 0x05, 0x9c, 0x2a, 0xb1, 0x89, 0x00, 0xfc, 0xc5, 0x87,
	0x15, 0x24, 0x72, 0x76, 0xe3, 0x90, 0xdf, 0x1d, 0xba, 0xb2, 0x6b, 0xa8,
	0x12, 0x35, 0xa4, 0xdc, 0x67, 0x38, 0x23, 0x7f, 0xce, 0xfd, 0x38, 0x12,
	0xb7, 0xab, 0x43, 0x6c, 0x92, 0x6c, 0x50, 0xc6, 0x00, 0xe6, 0xe9, 0x07
};
static const uint8_t nist_kas_ecc_cdh_testvector_248_private[] = {
/* dIUT */
	0x01, 0x5a, 0x5e, 0x59, 0x46, 0xfe, 0x2c, 0x9c, 0xae, 0x6d, 0x41, 0x2c,
	0x61, 0x8c, 0x1b, 0xd0, 0x77, 0x24, 0x43, 0x2b, 0x2f, 0x1d, 0xed, 0xb1,
	0x32, 0x7d, 0x8a, 0x99, 0xce, 0x83, 0x0e, 0x6b, 0x03, 0x0f, 0x40, 0x25,
	0xc1, 0x4b, 0x4e, 0x3d, 0x19, 0x12, 0xea, 0x9a, 0x78, 0x29, 0x0a, 0x1c,
	0xfc, 0x7d, 0x01, 0x89, 0xa3, 0x0c, 0x61, 0x40, 0x10, 0xc8, 0x73, 0x14,
	0x6a, 0x18, 0x2f, 0x63, 0x91, 0x93, 0xa2, 0x91, 0x2e, 0xdc, 0xd0, 0x4a
};
/* QIUTx = 03140887e87039797869f5d9db50d91ba69d0bfdc5a677c700610562f680d951a5e0517cb2f966367d48e423b046db4e68bc1c4b3183dc80bee126e89014994cdf83c4312a3e5ea7 */
/* QIUTy = 07b8d706962cb192f0ed14c4da710d1b1b073fd8ca497a94379a7454c9c3d4ce6e5fd2e6386852a77c5435abb23536dcc83986cedd4512752f295ca500f055f462763c29fb678caa */
static const uint8_t nist_kas_ecc_cdh_testvector_248_out[] = {
/* ZIUT */
	0x05, 0x8c, 0xd5, 0x60, 0x8d, 0xd9, 0xd6, 0x4d, 0x4d, 0x82, 0x2b, 0xae,
	0xca, 0x12, 0x33, 0x58, 0xa4, 0xd7, 0xe5, 0x6d, 0x37, 0x77, 0xec, 0xdf,
	0x56, 0x9a, 0x14, 0x9c, 0x2f, 0x85, 0xed, 0x35, 0x47, 0x9e, 0xae, 0xaa,
	0xba, 0xbd, 0x0b, 0x02, 0x6d, 0xc3, 0xb5, 0x6a, 0xed, 0xaf, 0xed, 0xfc,
	0x84, 0x91, 0x04, 0x04, 0x13, 0xf8, 0x5b, 0x66, 0x9d, 0x85, 0x12, 0xa3,
	0xef, 0x7b, 0xc8, 0xfe, 0x87, 0x06, 0xb5, 0xc7, 0x58, 0x53, 0x70, 0xaa
};
/* COUNT = 23 */
static const uint8_t nist_kas_ecc_cdh_testvector_249_public_x[] = {
/* QCAVSx */
	0x07, 0x43, 0xb3, 0xc9, 0x65, 0xa8, 0x3e, 0xe9, 0xf6, 0xbd, 0xb9, 0x90,
	0x1a, 0x1d, 0xcc, 0x1f, 0x78, 0x19, 0x65, 0x44, 0xa8, 0x8b, 0x9c, 0xf8,
	0x11, 0x7f, 0x89, 0xed, 0x15, 0x74, 0xe5, 0xc5, 0xd8, 0x04, 0xfc, 0x45,
	0x11, 0x12, 0xc2, 0x57, 0x87, 0x7e, 0x12, 0xb0, 0xa6, 0x6c, 0x69, 0x3c,
	0x66, 0x55, 0xc1, 0x2b, 0xba, 0x45, 0x35, 0xd9, 0x9d, 0x62, 0x40, 0x5f,
	0x4a, 0x9d, 0xce, 0xbc, 0x05, 0x6d, 0x8b, 0x7c, 0xbb, 0xad, 0xa1, 0x20
};
static const uint8_t nist_kas_ecc_cdh_testvector_249_public_y[] = {
/* QCAVSy */
	0x03, 0xef, 0xa5, 0x8a, 0xa3, 0xa8, 0xc6, 0xa2, 0x4f, 0x43, 0xc5, 0x58,
	0x1f, 0xec, 0x04, 0x14, 0x42, 0xae, 0x95, 0x52, 0x75, 0xdb, 0xc1, 0xd4,
	0x6d, 0x10, 0x15, 0x60, 0x59, 0xd2, 0x63, 0x7b, 0x9a, 0x82, 0x99, 0x4b,
	0x02, 0x4a, 0x24, 0x7d, 0x2a, 0x66, 0x72, 0x4b, 0xa9, 0x0d, 0x02, 0x78,
	0x7b, 0x16, 0x8b, 0x1f, 0xa1, 0xf4, 0xb6, 0x74, 0x96, 0x45, 0x40, 0x6c,
	0x43, 0x8f, 0x8d, 0x31, 0x6d, 0x67, 0x0f, 0x1e, 0x0d, 0x8b, 0x03, 0x01
};
static const uint8_t nist_kas_ecc_cdh_testvector_249_private[] = {
/* dIUT */
	0x00, 0xbd, 0x58, 0xe1, 0x9c, 0x05, 0xdf, 0x7e, 0x99, 0xbd, 0x96, 0x20,
	0x70, 0xe0, 0xb4, 0xc7, 0x57, 0x60, 0x42, 0x85, 0x84, 0x47, 0xe0, 0x23,
	0xb4, 0x1b, 0xb2, 0x97, 0x45, 0xa8, 0x9a, 0x48, 0x74, 0xdf, 0xe3, 0x25,
	0xa1, 0x5d, 0x38, 0xd2, 0xfb, 0x9e, 0x87, 0x0f, 0x41, 0x9d, 0xd1, 0x5f,
	0x4a, 0xaa, 0xc6, 0x5d, 0xbb, 0xc5, 0xac, 0x2c, 0x54, 0x0f, 0x57, 0xcd,
	0xb0, 0xe4, 0x5b, 0xc8, 0x66, 0x21, 0x72, 0x6d, 0x92, 0x2d, 0x14, 0xaa
};
/* QIUTx = 01e4b2a277ddd78f2f119c05b6ae1ea7a2a744961e08940f6569ee8808c53bc7a12138064ed5c8c222eef2774e70c28bce3a6c05f3a654e121006ab62bc94381d01ca0d1b08234d6 */
/* QIUTy = 07eed8cd7a8a3549b0d9ef8786879efdc9c0f4ce90b3991a33cbbb1d3704db93513138b19a50ecac880e578de21046f03a200048180884bc42cf9aafe58cc1eaf536d6d25f1541d8 */
static const uint8_t nist_kas_ecc_cdh_testvector_249_out[] = {
/* ZIUT */
	0x03, 0xbf, 0x7a, 0x59, 0xbb, 0xdd, 0x68, 0x86, 0x82, 0xc4, 0x56, 0x64,
	0xd2, 0x0c, 0x19, 0xcb, 0x2d, 0x24, 0xfc, 0xca, 0x67, 0x72, 0x12, 0x0c,
	0xbe, 0xed, 0x1c, 0xde, 0x76, 0x2d, 0x44, 0x9e, 0xbf, 0x22, 0x85, 0x56,
	0x27, 0xeb, 0x6b, 0x2b, 0xe6, 0xe7, 0xf7, 0xc0, 0xf0, 0x03, 0x4d, 0x02,
	0x68, 0x6f, 0x2a, 0x44, 0x88, 0x54, 0x9f, 0x8c, 0xb1, 0x98, 0xe0, 0x2b,
	0x46, 0x97, 0x2b, 0xcb, 0x88, 0x91, 0x4b, 0xea, 0x66, 0xdd, 0x64, 0x00
};
/* COUNT = 24 */
static const uint8_t nist_kas_ecc_cdh_testvector_250_public_x[] = {
/* QCAVSx */
	0x07, 0x22, 0xf1, 0xe7, 0xa0, 0x60, 0x77, 0x50, 0xda, 0xe2, 0xd6, 0x2c,
	0x5d, 0x3d, 0x47, 0x0f, 0x00, 0x6c, 0x32, 0x54, 0x55, 0x8e, 0xaa, 0xa2,
	0x94, 0xee, 0xed, 0xbc, 0xa8, 0xd3, 0x0b, 0xf4, 0xab, 0xb9, 0x55, 0xde,
	0xb6, 0x2e, 0x41, 0x79, 0x92, 0x5f, 0x6c, 0xba, 0xdf, 0x3b, 0xf8, 0x77,
	0x6f, 0x15, 0xdc, 0xae, 0x35, 0x56, 0xad, 0xdf, 0x79, 0x71, 0x05, 0xa7,
	0x7b, 0x7f, 0x6f, 0x71, 0x20, 0x6c, 0xa0, 0xe6, 0xea, 0x91, 0xe1, 0x88
};
static const uint8_t nist_kas_ecc_cdh_testvector_250_public_y[] = {
/* QCAVSy */
	0x03, 0x5d, 0x10, 0x8c, 0xa0, 0xd6, 0x20, 0xca, 0xb9, 0x6b, 0x7c, 0xbf,
	0x61, 0x7d, 0x1b, 0x5a, 0xc0, 0x6e, 0x37, 0x79, 0x26, 0x29, 0x88, 0x65,
	0x64, 0xfd, 0x14, 0x7c, 0x58, 0xe5, 0x5e, 0x42, 0x33, 0x44, 0xff, 0x4f,
	0x1f, 0xba, 0x4a, 0xf0, 0xfe, 0x34, 0x15, 0x2b, 0x38, 0x4b, 0x76, 0x85,
	0xca, 0xad, 0x15, 0xd3, 0xbc, 0x27, 0x0e, 0x43, 0x42, 0x2a, 0xd8, 0x74,
	0xe7, 0x1e, 0x40, 0x8a, 0x71, 0xa6, 0xc8, 0xa9, 0x0d, 0x2a, 0xd9, 0x78
};
static const uint8_t nist_kas_ecc_cdh_testvector_250_private[] = {
/* dIUT */
	0x01, 0x14, 0x63, 0x07, 0x0f, 0xcb, 0x4a, 0x28, 0xbe, 0x4e, 0x2a, 0x67,
	0xc2, 0x9c, 0x7f, 0xa4, 0x8a, 0x4c, 0x58, 0x5a, 0x30, 0x74, 0x05, 0xd0,
	0x6a, 0x1a, 0x06, 0x78, 0xe9, 0x09, 0xdd, 0x6e, 0xaf, 0xb8, 0x98, 0x66,
	0x2c, 0xdd, 0x8b, 0xcc, 0x01, 0x9d, 0xeb, 0x14, 0xe5, 0xd9, 0x2d, 0x17,
	0x2b, 0xa1, 0xc4, 0x38, 0xef, 0x0f, 0x64, 0xd8, 0x01, 0x07, 0xc7, 0xe8,
	0xe6, 0x80, 0x29, 0xf4, 0xe0, 0xaa, 0x81, 0x4a, 0x10, 0x99, 0xca, 0x38
};
/* QIUTx = 00939398e463886f0dbb48a74f573a1215000668e10b57989dc300b2f9a8c08cd43d6cbb7f46ec77c1c294b23f86299027d2b93fd6eb18210a8230bf46e3921f182c9260c30847ab */
/* QIUTy = 03d48ec633b9da1650ea762656b3e31f26aec07e7ca6aafc1ed7cb466eaaf3993e0467048c967bb1e9b4ae073a230c1e2f74e2e618666cf56a06f2b65ec3955b6ffbb06a908cf616 */
static const uint8_t nist_kas_ecc_cdh_testvector_250_out[] = {
/* ZIUT */
	0x06, 0xd4, 0x10, 0xe9, 0xba, 0x6b, 0x8b, 0x87, 0xb0, 0x0d, 0x0f, 0x67,
	0x6d, 0xe8, 0xba, 0x27, 0xf6, 0xaf, 0xe7, 0xe3, 0x08, 0xc2, 0xe9, 0x92,
	0xf3, 0x18, 0xfc, 0x14, 0xcb, 0xa0, 0xa4, 0x47, 0x31, 0x6a, 0xd8, 0x6e,
	0x8e, 0x6c, 0x1d, 0x33, 0x45, 0xd8, 0xe4, 0x03, 0x57, 0x35, 0x23, 0x2c,
	0x2c, 0x59, 0x7e, 0x76, 0x0b, 0x88, 0x00, 0xa8, 0x9a, 0x52, 0x15, 0x67,
	0xb0, 0x94, 0x08, 0xf9, 0xc7, 0xbe, 0x27, 0x9c, 0x13, 0x7c, 0x96, 0x3f
};
/* [B-163] - GP NOT SUPPORTED */
/* COUNT = 0 */
static const uint8_t nist_kas_ecc_cdh_testvector_251_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x03, 0xa6, 0x47, 0xba, 0x32, 0xda, 0xc7, 0x1e, 0xc6,
	0x78, 0x0b, 0x06, 0x38, 0xa7, 0x0c, 0xd2, 0x4f, 0xc3, 0xbd, 0x4c, 0x8e
};
static const uint8_t nist_kas_ecc_cdh_testvector_251_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x02, 0xe6, 0x9e, 0x96, 0x15, 0x41, 0x84, 0x4a, 0x4a,
	0xa3, 0x37, 0x69, 0xa7, 0xbc, 0xe7, 0x10, 0xf6, 0x64, 0x0a, 0x56, 0x0c
};
static const uint8_t nist_kas_ecc_cdh_testvector_251_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x03, 0xed, 0xae, 0x17, 0x3d, 0xe8, 0xfa, 0x0c, 0xf0,
	0x41, 0x2d, 0x6a, 0x7b, 0xdc, 0x81, 0xfd, 0xbd, 0x06, 0x17, 0xad, 0xf8
};
/* QIUTx = 000000035466701d0b0030d098b6ed2343d355c24c907271 */
/* QIUTy = 00000000d8bc02f341d261860dfb65f0cb7f0b488d8296cc */
static const uint8_t nist_kas_ecc_cdh_testvector_251_out[] = {
/* ZIUT */
	0x01, 0x00, 0xfb, 0x42, 0xd1, 0x77, 0xff, 0xe6, 0xc3, 0x13, 0x78, 0xe2,
	0xe0, 0x4e, 0x0d, 0xa7, 0x37, 0x6f, 0xfe, 0x87, 0x65
};
/* COUNT = 1 */
static const uint8_t nist_kas_ecc_cdh_testvector_252_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x01, 0x28, 0x28, 0x98, 0x93, 0x64, 0x86, 0xdc, 0x2e,
	0x3c, 0xd1, 0x58, 0x5f, 0x32, 0xd5, 0x54, 0x42, 0x64, 0xe1, 0x91, 0xe4
};
static const uint8_t nist_kas_ecc_cdh_testvector_252_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x05, 0xe9, 0xe9, 0x8b, 0xb7, 0x49, 0x9b, 0xf8, 0x95,
	0xf7, 0x7f, 0x8f, 0xc8, 0x30, 0x1d, 0x6e, 0x1c, 0x7a, 0x9f, 0x61, 0x91
};
static const uint8_t nist_kas_ecc_cdh_testvector_252_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x01, 0x78, 0xdc, 0xc8, 0x21, 0x64, 0x25, 0xd4, 0xbf,
	0x71, 0xc8, 0xf2, 0x92, 0x5d, 0xd1, 0xaf, 0x86, 0xdc, 0x04, 0xa2, 0x68
};
/* QIUTx = 000000011e49430cdd06f2e765b8f2cc067cd424e2e75485 */
/* QIUTy = 0000000083af15b22cd7dfd1dff7396bf3f3038f50524991 */
static const uint8_t nist_kas_ecc_cdh_testvector_252_out[] = {
/* ZIUT */
	0x06, 0x81, 0xc9, 0xe5, 0x9e, 0xb7, 0xeb, 0xa7, 0x69, 0xf5, 0xb6, 0xf2,
	0xb0, 0x6d, 0xdf, 0x1e, 0xfd, 0x12, 0x99, 0x79, 0x95
};
/* COUNT = 2 */
static const uint8_t nist_kas_ecc_cdh_testvector_253_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x05, 0x87, 0x4f, 0xcc, 0x8c, 0x48, 0x4c, 0x01, 0x41,
	0x73, 0x10, 0x2d, 0xcb, 0x70, 0xc6, 0x24, 0xee, 0x61, 0x08, 0xd3, 0x1d
};
static const uint8_t nist_kas_ecc_cdh_testvector_253_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x00, 0x49, 0x69, 0x3f, 0x4e, 0xdc, 0x71, 0x4b, 0x0d,
	0x0b, 0xaa, 0x5b, 0xfc, 0x5d, 0x8b, 0xc6, 0xac, 0x04, 0x08, 0x9d, 0xe4
};
static const uint8_t nist_kas_ecc_cdh_testvector_253_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x03, 0xea, 0x1e, 0x79, 0xe5, 0x2a, 0x07, 0x08, 0x98,
	0xd6, 0xa3, 0xc4, 0xe7, 0x48, 0xe9, 0x5a, 0xc8, 0x71, 0x0d, 0x77, 0xf6
};
/* QIUTx = 0000000137860ba3458af13c22af8225f561e01331cd87a8 */
/* QIUTy = 00000007720356e15dc73f9fee7a1c021feca97cd41204e3 */
static const uint8_t nist_kas_ecc_cdh_testvector_253_out[] = {
/* ZIUT */
	0x01, 0xe0, 0x74, 0x9a, 0x21, 0xfc, 0x50, 0x8f, 0x76, 0xda, 0xde, 0x85,
	0x43, 0x5b, 0xbb, 0xe1, 0x2c, 0x44, 0x8b, 0xd8, 0xc4
};
/* COUNT = 3 */
static const uint8_t nist_kas_ecc_cdh_testvector_254_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x00, 0x37, 0x48, 0xd7, 0x98, 0xf1, 0x40, 0x26, 0x8f,
	0x1e, 0x71, 0x8b, 0x3b, 0x23, 0xaa, 0x2a, 0xcc, 0x03, 0x33, 0xc0, 0x74
};
static const uint8_t nist_kas_ecc_cdh_testvector_254_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x00, 0xc4, 0x2a, 0x92, 0x7a, 0xb5, 0x79, 0x69, 0x61,
	0x23, 0x09, 0x55, 0x75, 0xac, 0x94, 0x9b, 0x07, 0xa7, 0xd1, 0xd4, 0xbc
};
static const uint8_t nist_kas_ecc_cdh_testvector_254_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x01, 0xad, 0x5c, 0xa9, 0xab, 0xc8, 0xbc, 0xdc, 0xc4,
	0x82, 0x99, 0x5a, 0xd1, 0xa9, 0x77, 0xe4, 0x72, 0x71, 0x50, 0xbb, 0x36
};
/* QIUTx = 000000025ae78311b0fcf369566a319f89849546aeaec305 */
/* QIUTy = 0000000640eb0fdf520480afbeb9f2674feb1d6df482d7f5 */
static const uint8_t nist_kas_ecc_cdh_testvector_254_out[] = {
/* ZIUT */
	0x03, 0x20, 0x39, 0x8f, 0x7a, 0xcf, 0x79, 0x1e, 0x0d, 0x60, 0x2d, 0x7b,
	0x94, 0x74, 0x2c, 0xce, 0x58, 0xe9, 0xfd, 0xdb, 0xac
};
/* COUNT = 4 */
static const uint8_t nist_kas_ecc_cdh_testvector_255_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x03, 0x80, 0xdb, 0x3d, 0xf2, 0xb1, 0xc0, 0x15, 0x4a,
	0x8e, 0x8c, 0xb3, 0x04, 0xae, 0xcd, 0x58, 0x1d, 0x35, 0xf3, 0x15, 0xcd
};
static const uint8_t nist_kas_ecc_cdh_testvector_255_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x07, 0x15, 0x34, 0xec, 0x2e, 0x8b, 0x35, 0x7d, 0x9e,
	0x06, 0x9d, 0x7f, 0x1f, 0xa9, 0x8b, 0xd4, 0x4e, 0xd8, 0xb0, 0x68, 0x26
};
static const uint8_t nist_kas_ecc_cdh_testvector_255_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x02, 0xd2, 0x8a, 0x8a, 0xa1, 0xd8, 0x9f, 0xa3, 0xe5,
	0xe5, 0x96, 0xff, 0xd1, 0x80, 0x82, 0x54, 0xee, 0x17, 0xa0, 0xd0, 0xfa
};
/* QIUTx = 00000006e6c52494ab63c89c9788556f716677f3b48042a0 */
/* QIUTy = 00000004e98258b9c56f02d3edb4ca5b0aeeaa9daaa6fe0f */
static const uint8_t nist_kas_ecc_cdh_testvector_255_out[] = {
/* ZIUT */
	0x03, 0xe4, 0xde, 0x43, 0xde, 0x85, 0x22, 0x3d, 0x81, 0x8e, 0x5b, 0xe6,
	0x54, 0x9c, 0x29, 0xcd, 0xfa, 0x1a, 0xfe, 0x17, 0x82
};
/* COUNT = 5 */
static const uint8_t nist_kas_ecc_cdh_testvector_256_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x01, 0x36, 0xe0, 0xd0, 0x5b, 0x4f, 0x39, 0x8b, 0x82,
	0x7e, 0x19, 0x80, 0x46, 0x14, 0x8b, 0x2f, 0x41, 0x57, 0x3f, 0xc0, 0x7c
};
static const uint8_t nist_kas_ecc_cdh_testvector_256_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x07, 0x39, 0x93, 0x4c, 0xec, 0x10, 0x57, 0x28, 0x52,
	0xe1, 0xf6, 0x19, 0x22, 0x2e, 0x2f, 0x5e, 0xc4, 0xe0, 0xfa, 0x5a, 0xa6
};
static const uint8_t nist_kas_ecc_cdh_testvector_256_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x02, 0xe1, 0x70, 0xf7, 0xf4, 0xdc, 0x15, 0x2f, 0xe4,
	0x70, 0x6f, 0x99, 0xd9, 0xbe, 0x22, 0x9e, 0x13, 0x17, 0xd8, 0x2b, 0xbd
};
/* QIUTx = 00000007900dac251de8a944cf0a1bf2eb2efeee14676e9b */
/* QIUTy = 0000000091e7df67f77622729d59b7e34b947127e7fa2e5d */
static const uint8_t nist_kas_ecc_cdh_testvector_256_out[] = {
/* ZIUT */
	0x03, 0x7b, 0x17, 0x8a, 0xab, 0x01, 0x4d, 0x5a, 0xba, 0xb3, 0x05, 0xe3,
	0x7d, 0xee, 0xd7, 0xf4, 0x79, 0x8c, 0xdb, 0x86, 0x2c
};
/* COUNT = 6 */
static const uint8_t nist_kas_ecc_cdh_testvector_257_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x07, 0x6c, 0x3a, 0xe4, 0xa7, 0x81, 0x67, 0x36, 0x27,
	0xd0, 0xe9, 0xbc, 0xb6, 0x15, 0xf6, 0x26, 0xa1, 0x60, 0xa5, 0x5d, 0xda
};
static const uint8_t nist_kas_ecc_cdh_testvector_257_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x05, 0x8c, 0x0e, 0xc8, 0xf2, 0x64, 0x9c, 0x2d, 0xdc,
	0xd9, 0xc2, 0x4b, 0x64, 0x34, 0x33, 0xb1, 0x4d, 0x90, 0x7c, 0x59, 0x03
};
static const uint8_t nist_kas_ecc_cdh_testvector_257_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x02, 0x92, 0x3d, 0x2c, 0x80, 0x2c, 0xec, 0x42, 0xde,
	0xf2, 0x63, 0x3d, 0xeb, 0xdc, 0xa7, 0x59, 0xd5, 0x97, 0x44, 0xd3, 0xe8
};
/* QIUTx = 00000002cdcb4f91ed7d17768db80be2b3ac9e0956b1d971 */
/* QIUTy = 000000032433f455a6cd253e91582d2f6f5a712655da1d69 */
static const uint8_t nist_kas_ecc_cdh_testvector_257_out[] = {
/* ZIUT */
	0x00, 0x95, 0x8b, 0x2a, 0xaa, 0x60, 0x61, 0x22, 0x2d, 0xd2, 0x48, 0xa6,
	0xb9, 0x70, 0x0f, 0xb6, 0x83, 0x9d, 0xac, 0xdc, 0x99
};
/* COUNT = 7 */
static const uint8_t nist_kas_ecc_cdh_testvector_258_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x00, 0xd6, 0x5f, 0x05, 0x16, 0xc1, 0xb3, 0xee, 0xd9,
	0x22, 0x0e, 0x59, 0xb3, 0xd0, 0x49, 0xdd, 0x11, 0x53, 0x17, 0x9a, 0xc5
};
static const uint8_t nist_kas_ecc_cdh_testvector_258_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x02, 0x0b, 0xfe, 0x10, 0x7a, 0x89, 0xa7, 0x36, 0x0c,
	0xd2, 0xe2, 0x17, 0x53, 0x4d, 0x6d, 0xf2, 0x98, 0xcc, 0x4b, 0xc4, 0x58
};
static const uint8_t nist_kas_ecc_cdh_testvector_258_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x02, 0x5b, 0x17, 0xbd, 0x6e, 0x42, 0x07, 0xd9, 0xfb,
	0x1a, 0x3a, 0xf0, 0x2f, 0xd5, 0xdb, 0x26, 0xaf, 0x83, 0x48, 0xae, 0xb0
};
/* QIUTx = 00000006f6f5b1f3b18f45db4fb3777e6840fb5a5b61a914 */
/* QIUTy = 0000000737ce14aeb24e0591585a7417b89256749f461de6 */
static const uint8_t nist_kas_ecc_cdh_testvector_258_out[] = {
/* ZIUT */
	0x03, 0x93, 0x38, 0x7e, 0x1d, 0xab, 0x35, 0x74, 0x8f, 0x20, 0xd5, 0x06,
	0xa0, 0xe2, 0xb4, 0xdc, 0x0e, 0xe6, 0xc3, 0xff, 0x39
};
/* COUNT = 8 */
static const uint8_t nist_kas_ecc_cdh_testvector_259_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x04, 0x0d, 0x90, 0x3c, 0xe2, 0xb3, 0x0f, 0x70, 0xa6,
	0xa0, 0x38, 0x49, 0xb0, 0xe1, 0x75, 0x8f, 0xef, 0x88, 0x87, 0xbd, 0x31
};
static const uint8_t nist_kas_ecc_cdh_testvector_259_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x04, 0xab, 0xd8, 0xbd, 0xb7, 0xc1, 0x32, 0x7c, 0x99,
	0xb3, 0x38, 0x20, 0xdb, 0xe1, 0x8a, 0xe1, 0x14, 0xfb, 0x43, 0x59, 0x49
};
static const uint8_t nist_kas_ecc_cdh_testvector_259_private[] = {
/* dIUT */
	0x13, 0x7e, 0x81, 0x32, 0xad, 0x28, 0x89, 0x23, 0xe6, 0x48, 0x11, 0xe9,
	0x22, 0x98, 0xf5, 0xc0, 0xdc, 0xc9, 0x57, 0x05
};
/* QIUTx = 00000006f2cdd1d630dd731ed77f901c7b0e735515e26d4e */
/* QIUTy = 00000001062f2f715c4d2af97bb1be8b6cfa2e3ee314253e */
static const uint8_t nist_kas_ecc_cdh_testvector_259_out[] = {
/* ZIUT */
	0x02, 0x12, 0x35, 0x8d, 0x3f, 0x8b, 0xce, 0x69, 0xb6, 0x62, 0x44, 0x73,
	0x33, 0xb3, 0xed, 0xbb, 0xc9, 0xb2, 0xf7, 0xe8, 0x05
};
/* COUNT = 9 */
static const uint8_t nist_kas_ecc_cdh_testvector_260_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x02, 0x2e, 0xd2, 0x46, 0x43, 0xf0, 0xce, 0xc6, 0x8c,
	0x8e, 0x4a, 0xd1, 0xaa, 0x2c, 0x43, 0x69, 0xd8, 0xaa, 0x03, 0xf5, 0x94
};
static const uint8_t nist_kas_ecc_cdh_testvector_260_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x05, 0xcc, 0xca, 0x62, 0xb6, 0xdd, 0x1d, 0x31, 0x6d,
	0xed, 0xbd, 0x0f, 0x1d, 0x53, 0x0b, 0xed, 0x6e, 0x55, 0x6b, 0x3a, 0xd8
};
static const uint8_t nist_kas_ecc_cdh_testvector_260_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x01, 0xc4, 0x8c, 0x50, 0xb7, 0xd3, 0xec, 0xdf, 0x3b,
	0x90, 0x1b, 0xad, 0x0e, 0xef, 0xc3, 0xe3, 0x82, 0x6e, 0x3c, 0xea, 0x9f
};
/* QIUTx = 000000019175573117dd851e6eebfd9fb1e5a884ebfefee5 */
/* QIUTy = 00000003adf37e4ded52573fa57c8cb2bfca6c65c3674462 */
static const uint8_t nist_kas_ecc_cdh_testvector_260_out[] = {
/* ZIUT */
	0x02, 0x34, 0x72, 0xfa, 0x59, 0x84, 0x6f, 0x7b, 0xe0, 0x7c, 0xf0, 0x60,
	0xcd, 0xd6, 0x9a, 0x9f, 0xbb, 0x27, 0xd4, 0xfe, 0x44
};
/* COUNT = 10 */
static const uint8_t nist_kas_ecc_cdh_testvector_261_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x07, 0x93, 0xf4, 0xb3, 0x11, 0x72, 0xee, 0xe6, 0x6f,
	0x27, 0x69, 0xeb, 0x30, 0x5d, 0x03, 0xb5, 0xc3, 0xf7, 0xcf, 0xff, 0x8b
};
static const uint8_t nist_kas_ecc_cdh_testvector_261_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x01, 0xf3, 0xec, 0xec, 0x6b, 0xbd, 0xa9, 0xbd, 0xe8,
	0xa4, 0xda, 0x14, 0xdb, 0x3e, 0x5f, 0xf9, 0x34, 0xb9, 0x83, 0x5b, 0x17
};
static const uint8_t nist_kas_ecc_cdh_testvector_261_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x01, 0x16, 0x2d, 0x9e, 0xd3, 0xa6, 0x60, 0x45, 0x5e,
	0x8c, 0x01, 0x5d, 0x1e, 0x45, 0xd1, 0x51, 0x57, 0x49, 0xa3, 0xdc, 0xd2
};
/* QIUTx = 00000004283eb0e5085d198b378fc95f6fb4c3198b4d3c78 */
/* QIUTy = 0000000107a1168f2f47b963e4b3a9024e0c357a5ebdf92c */
static const uint8_t nist_kas_ecc_cdh_testvector_261_out[] = {
/* ZIUT */
	0x01, 0x73, 0xa0, 0x56, 0xc4, 0xc9, 0xef, 0x67, 0x07, 0xcd, 0x23, 0x92,
	0x89, 0x99, 0xc4, 0x68, 0x0f, 0x42, 0xb7, 0x1f, 0x7c
};
/* COUNT = 11 */
static const uint8_t nist_kas_ecc_cdh_testvector_262_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x02, 0xea, 0x7a, 0x50, 0x83, 0x46, 0x02, 0xf1, 0x12,
	0xf6, 0xdd, 0x0e, 0x6d, 0x25, 0xf0, 0x64, 0xf9, 0xd0, 0x5e, 0xff, 0x26
};
static const uint8_t nist_kas_ecc_cdh_testvector_262_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x01, 0xbf, 0x3f, 0x69, 0xd1, 0x4a, 0xcc, 0x83, 0x33,
	0x53, 0x3a, 0x88, 0xc2, 0xe8, 0x82, 0x48, 0x63, 0xa4, 0x7a, 0xe0, 0x27
};
static const uint8_t nist_kas_ecc_cdh_testvector_262_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x01, 0x9a, 0x1d, 0x16, 0xf4, 0xa5, 0x72, 0xf3, 0xc1,
	0xb5, 0x1e, 0xa2, 0xac, 0xe6, 0x92, 0x80, 0xe7, 0x13, 0x7b, 0x8f, 0x8c
};
/* QIUTx = 00000005cede96a70f714cd68963f2d6ca236269a938f311 */
/* QIUTy = 00000006cdadd54b6f733c80934787e28c2ccf58b1227bc0 */
static const uint8_t nist_kas_ecc_cdh_testvector_262_out[] = {
/* ZIUT */
	0x03, 0xd3, 0x4f, 0x41, 0x1a, 0x29, 0x7d, 0x7c, 0x99, 0x0f, 0xa4, 0xa8,
	0x3b, 0x5f, 0x54, 0x75, 0x96, 0x07, 0xf9, 0xd3, 0x3f
};
/* COUNT = 12 */
static const uint8_t nist_kas_ecc_cdh_testvector_263_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x06, 0xdd, 0x13, 0x05, 0x34, 0x9e, 0x8a, 0xa0, 0x80,
	0x20, 0x07, 0x3a, 0x0d, 0xe5, 0xaf, 0xc5, 0xdc, 0x1b, 0x6a, 0x62, 0xd3
};
static const uint8_t nist_kas_ecc_cdh_testvector_263_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x03, 0x49, 0x7e, 0xb7, 0xbf, 0x40, 0x89, 0xef, 0x02,
	0xcd, 0x0a, 0x5d, 0xd0, 0xf8, 0x6b, 0xd8, 0x79, 0x8a, 0x44, 0xc5, 0x6c
};
static const uint8_t nist_kas_ecc_cdh_testvector_263_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x02, 0xef, 0xd4, 0x40, 0x0d, 0xad, 0x3c, 0xfa, 0xd8,
	0xd1, 0x63, 0x7f, 0xa9, 0x29, 0x0c, 0x4b, 0x75, 0x8a, 0x30, 0x15, 0xb6
};
/* QIUTx = 0000000513131b4bcb72ef68ab043ee84fc8cb03b6d8f187 */
/* QIUTy = 0000000120b7d5772bbb17ecb1c9e80c36f808fd54a93aae */
static const uint8_t nist_kas_ecc_cdh_testvector_263_out[] = {
/* ZIUT */
	0x06, 0x12, 0x0a, 0xed, 0x8d, 0x4c, 0x1e, 0x50, 0x67, 0x10, 0xe2, 0xcf,
	0xb9, 0x8c, 0xa2, 0x02, 0x2e, 0x64, 0x2c, 0xa8, 0x9f
};
/* COUNT = 13 */
static const uint8_t nist_kas_ecc_cdh_testvector_264_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x05, 0xa0, 0xe3, 0x41, 0x11, 0x8e, 0x69, 0x82, 0x7d,
	0x6a, 0x7f, 0x82, 0x82, 0xfb, 0xf0, 0xb9, 0x44, 0x00, 0xf0, 0x82, 0x40
};
static const uint8_t nist_kas_ecc_cdh_testvector_264_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x04, 0x23, 0xb9, 0x93, 0xd4, 0x36, 0x7f, 0xbf, 0x4f,
	0x65, 0x04, 0xd9, 0xe0, 0x9a, 0x64, 0x12, 0x3a, 0x3b, 0x53, 0xd1, 0x28
};
static const uint8_t nist_kas_ecc_cdh_testvector_264_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x01, 0x2b, 0x0d, 0x64, 0x97, 0x7c, 0xfc, 0x13, 0xb4,
	0x83, 0x45, 0xef, 0x70, 0x72, 0xd1, 0xa3, 0x89, 0x0e, 0xaf, 0xb9, 0x5b
};
/* QIUTx = 00000001b9363cf48735676878d80ce1481b8588683f7444 */
/* QIUTy = 0000000768fa7327cd7252c8f696ed4947868915ada1fb5d */
static const uint8_t nist_kas_ecc_cdh_testvector_264_out[] = {
/* ZIUT */
	0x02, 0x1a, 0x58, 0x08, 0x79, 0x68, 0xc5, 0xdf, 0x57, 0xaf, 0xd7, 0xc3,
	0x43, 0xa4, 0xcf, 0xa2, 0xee, 0x8e, 0x70, 0x73, 0xf1
};
/* COUNT = 14 */
static const uint8_t nist_kas_ecc_cdh_testvector_265_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x00, 0x1a, 0x92, 0x3d, 0x61, 0x91, 0x63, 0x43, 0x06,
	0x12, 0x4c, 0x1e, 0x26, 0x73, 0x09, 0xb0, 0x7d, 0xba, 0x32, 0xde, 0xcb
};
static const uint8_t nist_kas_ecc_cdh_testvector_265_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x05, 0xa3, 0x51, 0x7f, 0x54, 0x26, 0xa3, 0x41, 0x1a,
	0x72, 0x7e, 0xdd, 0xc2, 0x9a, 0x3e, 0xc2, 0x29, 0x55, 0x83, 0x68, 0xd1
};
static const uint8_t nist_kas_ecc_cdh_testvector_265_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x03, 0x3a, 0xc9, 0x53, 0x80, 0x3d, 0x04, 0x46, 0xb3,
	0xcd, 0xa4, 0xeb, 0xd0, 0x71, 0xb4, 0xeb, 0x02, 0x7c, 0x11, 0xbf, 0xd8
};
/* QIUTx = 00000005c446e9896ca44cca733e9f4e5b64afddc0537211 */
/* QIUTy = 00000006bad1b2522692f970b38be6935dc7d1c09dcd206f */
static const uint8_t nist_kas_ecc_cdh_testvector_265_out[] = {
/* ZIUT */
	0x03, 0xda, 0x9c, 0x08, 0x79, 0x21, 0x9e, 0x48, 0xc3, 0xdf, 0x56, 0x17,
	0x48, 0x98, 0xfa, 0xb9, 0xee, 0x5b, 0x0a, 0x6b, 0xcd
};
/* COUNT = 15 */
static const uint8_t nist_kas_ecc_cdh_testvector_266_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x02, 0xfa, 0x8b, 0xaf, 0x0d, 0x61, 0x28, 0xad, 0xd9,
	0xb9, 0x02, 0xaa, 0x18, 0x1c, 0x81, 0xe2, 0x42, 0x98, 0x45, 0x1e, 0x2e
};
static const uint8_t nist_kas_ecc_cdh_testvector_266_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x02, 0xb9, 0x3d, 0x1f, 0x69, 0x13, 0x91, 0x4f, 0xfe,
	0x15, 0x59, 0xc7, 0xc1, 0x14, 0xc6, 0x31, 0xbb, 0x6b, 0x29, 0x61, 0x7e
};
static const uint8_t nist_kas_ecc_cdh_testvector_266_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x01, 0xbd, 0x79, 0x14, 0x5a, 0xe7, 0xf4, 0x2c, 0x6b,
	0x25, 0xd1, 0xc3, 0x89, 0x65, 0xec, 0x08, 0xfd, 0x27, 0x53, 0x3a, 0x7a
};
/* QIUTx = 00000000e9d8fc3a026925c8add508f920fa2e5ff5282688 */
/* QIUTy = 00000005b7bf631259ac7d36936c130ff206d820b13bde81 */
static const uint8_t nist_kas_ecc_cdh_testvector_266_out[] = {
/* ZIUT */
	0x05, 0xb3, 0x3f, 0xe3, 0x87, 0x4d, 0x32, 0xae, 0xd9, 0x99, 0x19, 0x26,
	0x5c, 0xc0, 0x07, 0x49, 0x02, 0xe5, 0x38, 0xfe, 0x54
};
/* COUNT = 16 */
static const uint8_t nist_kas_ecc_cdh_testvector_267_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x03, 0x53, 0xe2, 0xda, 0x45, 0xab, 0x7c, 0x49, 0x30,
	0x28, 0x0c, 0x3e, 0xdb, 0x4b, 0xa9, 0x00, 0x12, 0xd5, 0x6d, 0xf6, 0x2f
};
static const uint8_t nist_kas_ecc_cdh_testvector_267_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x02, 0x69, 0x31, 0xe3, 0x0b, 0x97, 0xff, 0x5e, 0xf7,
	0xba, 0xcc, 0x0d, 0xe4, 0xd9, 0x49, 0x07, 0x08, 0x52, 0x2e, 0x3b, 0x2b
};
static const uint8_t nist_kas_ecc_cdh_testvector_267_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x03, 0x30, 0xca, 0x1f, 0x5a, 0xd7, 0x7d, 0x7a, 0x66,
	0xd8, 0x74, 0x23, 0x32, 0x80, 0x20, 0xc9, 0x1e, 0xc7, 0x9f, 0x37, 0x64
};
/* QIUTx = 00000005ba37d36997c4f2abe603dfe042232738e82b0b3a */
/* QIUTy = 000000073c8cd950044972a005c6f1af8e4306e0ccefb946 */
static const uint8_t nist_kas_ecc_cdh_testvector_267_out[] = {
/* ZIUT */
	0x05, 0x3d, 0xbc, 0xe9, 0x82, 0x6a, 0xf4, 0xd2, 0x90, 0x03, 0x6f, 0xeb,
	0x46, 0x87, 0x5e, 0x97, 0x5b, 0x78, 0x48, 0xa9, 0xc4
};
/* COUNT = 17 */
static const uint8_t nist_kas_ecc_cdh_testvector_268_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x07, 0x21, 0x67, 0x08, 0x84, 0xda, 0xa8, 0xcd, 0x62,
	0x76, 0x38, 0xec, 0x90, 0xf3, 0x44, 0x8e, 0xfb, 0x0f, 0x24, 0x89, 0xba
};
static const uint8_t nist_kas_ecc_cdh_testvector_268_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x04, 0xf8, 0x4a, 0x98, 0x3b, 0xec, 0x6b, 0x28, 0x89,
	0xc8, 0x21, 0x1b, 0xf2, 0x31, 0x14, 0x9b, 0x5b, 0xeb, 0xcc, 0x75, 0xe0
};
static const uint8_t nist_kas_ecc_cdh_testvector_268_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x02, 0xd2, 0x31, 0x40, 0x07, 0x4d, 0x6e, 0xdd, 0xd5,
	0xbc, 0x09, 0x9b, 0x17, 0xde, 0x12, 0xaf, 0xb9, 0xdd, 0xf2, 0xec, 0xbe
};
/* QIUTx = 00000006e06cc7c30f5ed7e686c3a75a1d44257770601cb2 */
/* QIUTy = 000000030dc414c4afb390ed467af471aa9bd2b75f32dfd8 */
static const uint8_t nist_kas_ecc_cdh_testvector_268_out[] = {
/* ZIUT */
	0x00, 0xd4, 0x9b, 0x97, 0x1c, 0xab, 0x93, 0x7f, 0x40, 0x90, 0x89, 0x13,
	0xfe, 0x25, 0x98, 0x49, 0x67, 0x9c, 0xa0, 0x76, 0xd9
};
/* COUNT = 18 */
static const uint8_t nist_kas_ecc_cdh_testvector_269_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x01, 0xd6, 0x31, 0x9e, 0xc2, 0xdc, 0x5c, 0x08, 0xf0,
	0x26, 0x1a, 0xed, 0x02, 0x31, 0x41, 0x8d, 0x6d, 0xc3, 0xd0, 0xcd, 0xa7
};
static const uint8_t nist_kas_ecc_cdh_testvector_269_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x03, 0x8e, 0x64, 0x95, 0x3f, 0x7c, 0xda, 0xc7, 0x1d,
	0x05, 0x2e, 0x55, 0x85, 0x57, 0x46, 0xb4, 0x3d, 0x44, 0x18, 0x1b, 0x91
};
static const uint8_t nist_kas_ecc_cdh_testvector_269_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x02, 0x44, 0x9c, 0x1b, 0x9f, 0xf0, 0x9e, 0x7a, 0x9a,
	0x03, 0xb1, 0x7f, 0x5f, 0xf4, 0x61, 0x11, 0x5f, 0x5f, 0x3f, 0x1a, 0x7f
};
/* QIUTx = 000000073f9ddddc4650933deccc9546d392a35dbbc66a76 */
/* QIUTy = 00000004de7558dde649f72322b39e31c8e29ce6f599485e */
static const uint8_t nist_kas_ecc_cdh_testvector_269_out[] = {
/* ZIUT */
	0x04, 0x83, 0xad, 0x0b, 0x7f, 0x8a, 0x71, 0x62, 0x73, 0xf6, 0x24, 0xb8,
	0x97, 0x9c, 0x19, 0x12, 0x67, 0x05, 0x26, 0x6e, 0x4b
};
/* COUNT = 19 */
static const uint8_t nist_kas_ecc_cdh_testvector_270_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x04, 0xf1, 0x67, 0x90, 0x7b, 0xf4, 0xb9, 0x8e, 0x86,
	0x96, 0xd8, 0x1d, 0xa7, 0xd2, 0xc1, 0x05, 0x6e, 0xfa, 0x0d, 0xc1, 0x4c
};
static const uint8_t nist_kas_ecc_cdh_testvector_270_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x06, 0xcb, 0x9a, 0xb6, 0x51, 0x43, 0x83, 0x2b, 0x9c,
	0xef, 0xd5, 0xd9, 0xce, 0x69, 0xec, 0x4d, 0xb2, 0xed, 0xd0, 0x67, 0xaa
};
static const uint8_t nist_kas_ecc_cdh_testvector_270_private[] = {
/* dIUT */
	0xd0, 0x8b, 0x95, 0xd9, 0xa4, 0xce, 0x72, 0x4e, 0xc4, 0x62, 0xcc, 0xe1,
	0x27, 0x01, 0xfd, 0x8c, 0x3d, 0x53, 0xfd, 0xcd
};
/* QIUTx = 0000000026a770d86e1c89ba7a86aef649ba7ea86fc7d5b2 */
/* QIUTy = 00000001db1020e0f764df54a53c23c938cec98d9a77ad1d */
static const uint8_t nist_kas_ecc_cdh_testvector_270_out[] = {
/* ZIUT */
	0x00, 0xf6, 0x9d, 0xcb, 0x54, 0x71, 0x19, 0xfc, 0x9b, 0x8c, 0x45, 0x43,
	0x35, 0xaa, 0xb1, 0x84, 0xc3, 0xad, 0xa5, 0xf1, 0xc6
};
/* COUNT = 20 */
static const uint8_t nist_kas_ecc_cdh_testvector_271_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x07, 0x9b, 0x6d, 0x14, 0xc7, 0x43, 0x27, 0x14, 0x02,
	0xd1, 0x32, 0x36, 0x03, 0x21, 0x5f, 0xeb, 0x3c, 0x68, 0xb1, 0x44, 0x55
};
static const uint8_t nist_kas_ecc_cdh_testvector_271_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x04, 0xe3, 0x90, 0x56, 0x86, 0xa5, 0x38, 0xc2, 0x5a,
	0x02, 0xbe, 0xa9, 0x2f, 0x42, 0x18, 0x40, 0x21, 0xb5, 0xea, 0x25, 0x93
};
static const uint8_t nist_kas_ecc_cdh_testvector_271_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x03, 0x80, 0x8e, 0xfe, 0x6a, 0xd5, 0x0d, 0x25, 0x0d,
	0x87, 0x19, 0x2e, 0x16, 0x49, 0x9c, 0xe3, 0x25, 0x94, 0x28, 0xf3, 0xb8
};
/* QIUTx = 0000000013a02e25fc927875afa557bd673f65870459e671 */
/* QIUTy = 00000004038dbae5c5e54084708a24bc3fd072e769c12377 */
static const uint8_t nist_kas_ecc_cdh_testvector_271_out[] = {
/* ZIUT */
	0x01, 0xbc, 0x5e, 0xe5, 0x26, 0x1b, 0x2b, 0xba, 0x55, 0xb1, 0x0c, 0xba,
	0xa6, 0xcc, 0x3c, 0x97, 0xb9, 0x8d, 0x00, 0xff, 0xea
};
/* COUNT = 21 */
static const uint8_t nist_kas_ecc_cdh_testvector_272_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x07, 0x72, 0xf4, 0x2d, 0x27, 0x2a, 0x05, 0x7d, 0xe0,
	0xff, 0x92, 0x6c, 0x9f, 0x94, 0x60, 0x5c, 0x66, 0x75, 0xd2, 0x15, 0x26
};
static const uint8_t nist_kas_ecc_cdh_testvector_272_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x06, 0x02, 0xe7, 0xe5, 0x32, 0x55, 0xde, 0x9b, 0xf5,
	0x8c, 0x05, 0x7e, 0xef, 0xb7, 0x9b, 0xce, 0x43, 0x1b, 0x5c, 0x38, 0x08
};
static const uint8_t nist_kas_ecc_cdh_testvector_272_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x02, 0xad, 0x23, 0x2a, 0x7a, 0x41, 0xe6, 0xcc, 0x24,
	0x95, 0x53, 0x8d, 0x87, 0xb0, 0x23, 0xcd, 0xec, 0x7b, 0x6e, 0x1f, 0x23
};
/* QIUTx = 0000000549e30780d93f796fdcf691905575d85c66453bdb */
/* QIUTy = 00000002162a885bea31344543f5d06191369dec6e70e967 */
static const uint8_t nist_kas_ecc_cdh_testvector_272_out[] = {
/* ZIUT */
	0x00, 0x85, 0x74, 0xd8, 0x38, 0xd3, 0xde, 0x87, 0x96, 0x5f, 0xc1, 0xb4,
	0x34, 0x3f, 0xe4, 0xf0, 0x78, 0x58, 0x8c, 0x4e, 0xa1
};
/* COUNT = 22 */
static const uint8_t nist_kas_ecc_cdh_testvector_273_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x05, 0x0b, 0x24, 0x29, 0x46, 0x09, 0x71, 0x73, 0x9a,
	0x9d, 0x6d, 0x56, 0x70, 0xbc, 0x6d, 0x75, 0x9e, 0x56, 0x56, 0x76, 0x8b
};
static const uint8_t nist_kas_ecc_cdh_testvector_273_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x04, 0x92, 0xbc, 0x2d, 0x3f, 0x63, 0x8d, 0x49, 0x78,
	0xe4, 0xca, 0x58, 0xca, 0x5a, 0x4e, 0xf1, 0x9c, 0x5e, 0xcc, 0xea, 0x8d
};
static const uint8_t nist_kas_ecc_cdh_testvector_273_private[] = {
/* dIUT */
	0xdc, 0x99, 0xb1, 0x9f, 0x3d, 0x88, 0x47, 0x87, 0x51, 0x90, 0xe9, 0x58,
	0x8b, 0x2b, 0xbd, 0x83, 0x0d, 0xbd, 0x3a, 0x95
};
/* QIUTx = 00000000f65d984d71dcc18bf172abe4d3993ce0f7cf324c */
/* QIUTy = 000000001b49e6a2cf1173aadac3af6c09e966f31141abd9 */
static const uint8_t nist_kas_ecc_cdh_testvector_273_out[] = {
/* ZIUT */
	0x04, 0x57, 0x9b, 0x47, 0x7a, 0x92, 0xed, 0x96, 0x1c, 0xfd, 0xb2, 0x01,
	0x44, 0x07, 0xe8, 0x8e, 0x77, 0x16, 0x45, 0x2a, 0x4b
};
/* COUNT = 23 */
static const uint8_t nist_kas_ecc_cdh_testvector_274_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x01, 0x7d, 0x52, 0x11, 0x6f, 0x0c, 0x95, 0x58, 0x7f,
	0x1b, 0x7b, 0x06, 0xc7, 0x6e, 0x98, 0xd9, 0x9c, 0x82, 0xdc, 0xf2, 0x0c
};
static const uint8_t nist_kas_ecc_cdh_testvector_274_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x02, 0x4e, 0xa2, 0x2b, 0xdd, 0x99, 0x0b, 0xd7, 0x9e,
	0x63, 0xe7, 0x35, 0xb2, 0x12, 0x82, 0xae, 0x1b, 0x5e, 0xa6, 0x66, 0x48
};
static const uint8_t nist_kas_ecc_cdh_testvector_274_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x03, 0x56, 0xab, 0x85, 0xb0, 0x4d, 0x08, 0x51, 0xb8,
	0xf6, 0x6b, 0x4a, 0x79, 0x65, 0x26, 0xd3, 0xf3, 0xe3, 0x88, 0x28, 0x44
};
/* QIUTx = 0000000776a2e1af932d74519070bfa941eaa93e9ff5e97a */
/* QIUTy = 00000005abe9ed46245fd0146250d2a563c46ebf7acd2342 */
static const uint8_t nist_kas_ecc_cdh_testvector_274_out[] = {
/* ZIUT */
	0x03, 0x5a, 0x8c, 0x10, 0xe6, 0x44, 0x03, 0xc5, 0x2e, 0xf8, 0xd1, 0x7c,
	0x5f, 0x4d, 0xea, 0xd0, 0xdf, 0x81, 0xfb, 0x1f, 0x21
};
/* COUNT = 24 */
static const uint8_t nist_kas_ecc_cdh_testvector_275_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x03, 0xa7, 0xea, 0x10, 0xba, 0x1d, 0x6a, 0xa5, 0x45,
	0x70, 0x0b, 0x40, 0xb7, 0x37, 0x95, 0x1a, 0x9e, 0x73, 0x6d, 0xfa, 0x0c
};
static const uint8_t nist_kas_ecc_cdh_testvector_275_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x04, 0xf9, 0x35, 0x2f, 0xb2, 0xac, 0x24, 0x44, 0xe9,
	0x28, 0x75, 0x4e, 0x36, 0x55, 0xfd, 0x62, 0xe3, 0xa4, 0x25, 0x64, 0xe8
};
static const uint8_t nist_kas_ecc_cdh_testvector_275_private[] = {
/* dIUT */
	0x7a, 0x7b, 0x54, 0x75, 0x50, 0xc7, 0x58, 0xa9, 0xde, 0x7f, 0x06, 0xe2,
	0xf3, 0x8e, 0x55, 0xf5, 0xe9, 0xe4, 0x4c, 0xe6
};
/* QIUTx = 000000045952c0b517e685cab09470327f9d4b212751b049 */
/* QIUTy = 000000044a429a6efb04bcea0240ab5805de740aa61f994e */
static const uint8_t nist_kas_ecc_cdh_testvector_275_out[] = {
/* ZIUT */
	0x00, 0x01, 0x42, 0x61, 0x5e, 0x36, 0x07, 0xac, 0x14, 0x8c, 0x4d, 0xe8,
	0xf3, 0x34, 0xbe, 0x84, 0x92, 0x35, 0xd0, 0x1c, 0xdb
};
/* [B-233] - GP NOT SUPPORTED */
/* COUNT = 0 */
static const uint8_t nist_kas_ecc_cdh_testvector_276_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x47, 0x56, 0xba, 0xdd, 0xef, 0xc3, 0xdc, 0x33, 0x7a,
	0xb2, 0x7b, 0x54, 0x52, 0xeb, 0x10, 0xaf, 0xfd, 0x9e, 0x31, 0xf5, 0xb5,
	0x5c, 0x33, 0x0e, 0x90, 0xf0, 0xf6, 0x86, 0xa2
};
static const uint8_t nist_kas_ecc_cdh_testvector_276_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x01, 0x2a, 0x79, 0xf6, 0x52, 0x32, 0x30, 0x8a, 0x21, 0xc9,
	0x8c, 0x01, 0x55, 0x5c, 0xca, 0xfc, 0x7d, 0xce, 0x15, 0xc8, 0xfe, 0xd3,
	0x02, 0x5a, 0x76, 0x0c, 0xbd, 0x6c, 0x23, 0x27
};
static const uint8_t nist_kas_ecc_cdh_testvector_276_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x3c, 0x3e, 0xe4, 0x74, 0xac, 0x0d, 0x0b, 0xc1, 0xdf,
	0x56, 0x7e, 0x3c, 0x35, 0xf5, 0xf7, 0x66, 0xc5, 0x33, 0x2b, 0x2d, 0x67,
	0x30, 0xff, 0x0e, 0x4d, 0x8e, 0x75, 0xae, 0xdb
};
/* QIUTx = 00000061e8a9b517fd05a026ec376616229fd8639a1fa76defe5398022f9d9c8 */
/* QIUTy = 000000706b5cb08738a94552fee584b1372fead4af79040909fcf6f50084bbfa */
static const uint8_t nist_kas_ecc_cdh_testvector_276_out[] = {
/* ZIUT */
	0x00, 0xe9, 0xf3, 0xd8, 0xc4, 0xf1, 0xbe, 0xc0, 0xf9, 0x20, 0xe7, 0x63,
	0xea, 0x1b, 0xb7, 0x41, 0x58, 0x99, 0xf0, 0x17, 0x34, 0x60, 0x9e, 0x75,
	0x47, 0xdc, 0x42, 0x5e, 0xc9, 0x46
};
/* COUNT = 1 */
static const uint8_t nist_kas_ecc_cdh_testvector_277_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x01, 0x18, 0x6a, 0x02, 0x8f, 0x9a, 0x18, 0xdb, 0x92, 0x7f,
	0x63, 0x25, 0x3c, 0x20, 0x3e, 0xb2, 0x6a, 0xa3, 0xab, 0xa0, 0xd4, 0x0b,
	0x1a, 0x3a, 0xbc, 0x64, 0xe4, 0x7a, 0x22, 0xad
};
static const uint8_t nist_kas_ecc_cdh_testvector_277_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0xcb, 0xd8, 0xb9, 0x5f, 0x89, 0xe4, 0x21, 0x12, 0x8b,
	0xc7, 0x3a, 0x43, 0xc5, 0xcc, 0x25, 0x4e, 0x38, 0x67, 0x09, 0x6a, 0xb8,
	0x9d, 0x78, 0x8b, 0x2e, 0xd3, 0xb9, 0x0a, 0x96
};
static const uint8_t nist_kas_ecc_cdh_testvector_277_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0xaa, 0x41, 0xa5, 0xa0, 0x1a, 0x4e, 0x66, 0xa6, 0x79,
	0x97, 0xb0, 0xbe, 0x16, 0xf5, 0x6b, 0x16, 0x0b, 0x05, 0x61, 0xad, 0x07,
	0xf3, 0xaf, 0x29, 0x64, 0x38, 0x64, 0x61, 0xd0
};
/* QIUTx = 0000002d91402446557068c40fc075dee93916b0f1a9392e47e56b747125ae1f */
/* QIUTy = 0000013ab0915e4acf779516826fa1dc1885a06abc5d0809c92240ccf9c3d8a4 */
static const uint8_t nist_kas_ecc_cdh_testvector_277_out[] = {
/* ZIUT */
	0x00, 0xf1, 0xfb, 0xec, 0xfa, 0xdb, 0x15, 0x8d, 0x62, 0xeb, 0x11, 0x09,
	0xc0, 0x85, 0x12, 0x4f, 0xad, 0x67, 0xa8, 0x79, 0x5b, 0x58, 0x81, 0x5e,
	0xb3, 0x96, 0xc9, 0x5d, 0xb4, 0xb9
};
/* COUNT = 2 */
static const uint8_t nist_kas_ecc_cdh_testvector_278_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x93, 0xbf, 0x85, 0x62, 0x16, 0x02, 0x23, 0x8e, 0x98,
	0xd0, 0x9c, 0x98, 0x82, 0x8d, 0x51, 0xa4, 0x94, 0x60, 0x36, 0x2c, 0x23,
	0xc5, 0x14, 0x1d, 0x3d, 0x1b, 0x23, 0x52, 0x96
};
static const uint8_t nist_kas_ecc_cdh_testvector_278_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x84, 0x97, 0x15, 0x21, 0x87, 0xa8, 0xb3, 0xb2, 0x95,
	0x8a, 0x1d, 0x0a, 0x2e, 0xec, 0xff, 0x44, 0x92, 0x25, 0x18, 0x07, 0xcb,
	0xfd, 0x03, 0xd5, 0xf2, 0x68, 0x5b, 0xca, 0x37
};
static const uint8_t nist_kas_ecc_cdh_testvector_278_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0xc6, 0x67, 0x7c, 0x28, 0x06, 0x8b, 0x46, 0x2e, 0x34,
	0x86, 0x2c, 0xe6, 0xc9, 0xd8, 0xad, 0x8c, 0x1b, 0x3c, 0x7e, 0xfe, 0x80,
	0xcb, 0xab, 0x41, 0xda, 0x41, 0x92, 0x78, 0xe4
};
/* QIUTx = 00000042cb311dcff2482a2cece696c1eb64c69ac2aa599209a5c18763a3150a */
/* QIUTy = 000001b0329f36c135d002f08be3e3ffa9da18c5d6a70c360f4f871f12bf3f95 */
static const uint8_t nist_kas_ecc_cdh_testvector_278_out[] = {
/* ZIUT */
	0x01, 0x9e, 0xa8, 0x31, 0xc5, 0x1d, 0x88, 0xa7, 0xcf, 0x75, 0x44, 0x95,
	0xa1, 0xc4, 0x74, 0x08, 0x2e, 0xd4, 0x81, 0xc8, 0xeb, 0x83, 0x19, 0x0a,
	0x77, 0xde, 0xfb, 0x09, 0xd4, 0x79
};
/* COUNT = 3 */
static const uint8_t nist_kas_ecc_cdh_testvector_279_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x45, 0x49, 0x64, 0x86, 0x92, 0xaf, 0x95, 0xd8, 0x8e,
	0x4e, 0x1d, 0x49, 0x14, 0xd8, 0xc9, 0x76, 0x9a, 0xad, 0xac, 0x5a, 0x0f,
	0x75, 0x78, 0x32, 0x65, 0xf3, 0xeb, 0x96, 0x57
};
static const uint8_t nist_kas_ecc_cdh_testvector_279_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x01, 0xb0, 0x94, 0xb4, 0x80, 0x2f, 0x39, 0x76, 0x63, 0xd0,
	0xe6, 0x82, 0xfa, 0xbf, 0x1c, 0x94, 0xc4, 0xe2, 0x14, 0xe4, 0x83, 0x27,
	0xb9, 0x5e, 0xef, 0xcb, 0x92, 0xb7, 0x71, 0xfd
};
static const uint8_t nist_kas_ecc_cdh_testvector_279_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x9c, 0x61, 0x02, 0x4b, 0x3d, 0xff, 0x21, 0x9b, 0x37,
	0xf1, 0xbe, 0x67, 0x01, 0x80, 0x4a, 0xdf, 0x24, 0x74, 0x14, 0x44, 0x8d,
	0xd0, 0xf0, 0xdc, 0x51, 0x29, 0x3a, 0xc9, 0x13
};
/* QIUTx = 000000124120d8409850e71e33c9e2d9c40ea32bed11d77804786e9b076892ab */
/* QIUTy = 0000006dae1ba4817296ff63073bac9ce065d4331ba1a5c899cc1c07405dae3e */
static const uint8_t nist_kas_ecc_cdh_testvector_279_out[] = {
/* ZIUT */
	0x00, 0x08, 0x84, 0x25, 0xfb, 0x04, 0xc2, 0xce, 0x40, 0x8f, 0x08, 0xd8,
	0x13, 0x85, 0xa3, 0x22, 0x70, 0x3a, 0x07, 0x7b, 0xf0, 0x0b, 0xa0, 0x79,
	0x1e, 0x4e, 0x79, 0xb8, 0x04, 0x19
};
/* COUNT = 4 */
static const uint8_t nist_kas_ecc_cdh_testvector_280_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x73, 0xc5, 0xcf, 0x4a, 0x01, 0xd0, 0x9e, 0x3b, 0x41,
	0xb5, 0xe7, 0x77, 0x8c, 0x6b, 0x9b, 0xa5, 0x2d, 0xaf, 0x88, 0xfc, 0x40,
	0x4f, 0x8e, 0x2f, 0xd0, 0x9d, 0xb4, 0x02, 0x7e
};
static const uint8_t nist_kas_ecc_cdh_testvector_280_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x70, 0x39, 0x1e, 0xda, 0xa7, 0x6f, 0x0e, 0x39, 0x70,
	0x39, 0x4c, 0xac, 0x03, 0x38, 0x06, 0x10, 0x58, 0x85, 0x8c, 0x3c, 0x73,
	0xd5, 0xcb, 0x51, 0x2e, 0x53, 0x26, 0x30, 0x4f
};
static const uint8_t nist_kas_ecc_cdh_testvector_280_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x6e, 0x69, 0xd0, 0x64, 0xdb, 0xd9, 0xa7, 0x94, 0xf6,
	0x8e, 0x69, 0x9a, 0x0e, 0x94, 0x1b, 0xdd, 0xa6, 0xa5, 0x3a, 0x1c, 0xec,
	0xa3, 0xb3, 0xdb, 0x82, 0x92, 0x5b, 0x6f, 0x8b
};
/* QIUTx = 000000c57d61fcb1fee90d5d8c97cbf188c8ef8259b0ae2587ecf1ff8cd2e2fa */
/* QIUTy = 000000b8ad86c6805a4ab44513dbba2f5098b9e9c1e05b679f52937aece2b182 */
static const uint8_t nist_kas_ecc_cdh_testvector_280_out[] = {
/* ZIUT */
	0x01, 0x9b, 0x5e, 0xfb, 0x23, 0xbc, 0x18, 0xa4, 0xf1, 0x8c, 0x22, 0xfe,
	0x2f, 0xd5, 0xcd, 0xbd, 0x02, 0x37, 0x2c, 0xab, 0xde, 0x5e, 0x5c, 0x9f,
	0x4b, 0x4f, 0x9a, 0x49, 0x43, 0x8f
};
/* COUNT = 5 */
static const uint8_t nist_kas_ecc_cdh_testvector_281_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x01, 0x23, 0xa6, 0xb0, 0x81, 0xa7, 0x61, 0xe8, 0x6c, 0x04,
	0x2e, 0x19, 0x14, 0xaf, 0x47, 0xf0, 0x93, 0xb2, 0x65, 0x55, 0x43, 0xe5,
	0x64, 0x58, 0x4b, 0x60, 0x64, 0x25, 0x39, 0xa9
};
static const uint8_t nist_kas_ecc_cdh_testvector_281_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x51, 0x8e, 0xe3, 0xc1, 0xae, 0x54, 0x64, 0x04, 0xdf,
	0x1e, 0xcc, 0xd6, 0x9a, 0xa6, 0x85, 0x64, 0x31, 0xd1, 0xc8, 0x88, 0x1c,
	0xf0, 0x57, 0x8c, 0xff, 0x4e, 0xb8, 0xc1, 0x1b
};
static const uint8_t nist_kas_ecc_cdh_testvector_281_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x5a, 0xe5, 0xde, 0x30, 0xc7, 0xc3, 0x17, 0x18, 0x13,
	0xa2, 0xdd, 0x3e, 0x3e, 0xa2, 0xc5, 0xce, 0xaa, 0x04, 0x73, 0xc3, 0x94,
	0x57, 0xe9, 0x92, 0x90, 0x71, 0xe1, 0xa4, 0x20
};
/* QIUTx = 0000017cf9fca05d4a55e4b68fee7a3bd43f047303f2a266d81bb5e1ec7e2558 */
/* QIUTy = 0000003b0af43de05003397de1d4b27827ad2fcd675cbf61a445a1ec40a569b6 */
static const uint8_t nist_kas_ecc_cdh_testvector_281_out[] = {
/* ZIUT */
	0x01, 0xf3, 0x6d, 0x95, 0x19, 0xc3, 0xd4, 0x7f, 0x03, 0x0e, 0xea, 0xc3,
	0x33, 0x8d, 0xb5, 0x83, 0xb9, 0x6f, 0xef, 0xa5, 0x51, 0xa4, 0xb5, 0x6c,
	0xc5, 0x56, 0x7f, 0x2d, 0x9d, 0x7a
};
/* COUNT = 6 */
static const uint8_t nist_kas_ecc_cdh_testvector_282_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x01, 0x41, 0xfb, 0xbf, 0x2b, 0x36, 0x1c, 0x2c, 0x8c, 0xe5,
	0xed, 0xab, 0xfa, 0x22, 0xaa, 0x47, 0x55, 0x58, 0x1e, 0x5b, 0x1a, 0x66,
	0x60, 0x03, 0x62, 0xa0, 0xee, 0x7b, 0xc5, 0x74
};
static const uint8_t nist_kas_ecc_cdh_testvector_282_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x01, 0xae, 0xa3, 0xca, 0xc2, 0x03, 0xf8, 0xc7, 0x80, 0x47,
	0x5a, 0x26, 0x09, 0xb2, 0x97, 0x0c, 0xc8, 0x6f, 0x96, 0xea, 0x40, 0x11,
	0xc3, 0x48, 0xda, 0x82, 0x62, 0xb3, 0x34, 0xaa
};
static const uint8_t nist_kas_ecc_cdh_testvector_282_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0xc6, 0x87, 0x96, 0x95, 0x5b, 0x68, 0xb5, 0xf8, 0x82,
	0x7e, 0x38, 0xac, 0x07, 0x82, 0xb1, 0xac, 0x2c, 0x45, 0x52, 0xca, 0xef,
	0x0c, 0x60, 0x95, 0x84, 0x67, 0xcd, 0x85, 0xc1
};
/* QIUTx = 00000034789fbc60f1086034c8f2ce86fd4aa335194c9146890357dc475699e4 */
/* QIUTy = 000001d37f796327f71ec31510468463d0b2905488a4a60267870dfee567c250 */
static const uint8_t nist_kas_ecc_cdh_testvector_282_out[] = {
/* ZIUT */
	0x00, 0xe5, 0x4b, 0x1c, 0x91, 0x6f, 0xf3, 0xba, 0x1a, 0xa0, 0xb2, 0xb9,
	0x9f, 0x0e, 0xbd, 0xe4, 0xf1, 0xa4, 0xcc, 0x6a, 0x10, 0xd9, 0x59, 0xbb,
	0x2f, 0x7f, 0x4c, 0x77, 0x7b, 0x84
};
/* COUNT = 7 */
static const uint8_t nist_kas_ecc_cdh_testvector_283_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x96, 0xa0, 0xd3, 0xf3, 0x6e, 0x8f, 0x75, 0x37, 0x91,
	0x07, 0x4c, 0xea, 0x69, 0x7b, 0x24, 0x71, 0x62, 0x7e, 0x0c, 0x9e, 0x7a,
	0x29, 0x4a, 0x02, 0x9a, 0x9d, 0x3b, 0x94, 0x29
};
static const uint8_t nist_kas_ecc_cdh_testvector_283_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0xb7, 0x67, 0x17, 0x4a, 0x29, 0x20, 0xb6, 0x2f, 0x1f,
	0x02, 0xfa, 0x79, 0x09, 0x78, 0x45, 0xd5, 0x1d, 0x93, 0xe0, 0xc8, 0x10,
	0x44, 0x10, 0x83, 0x1a, 0x2d, 0xd5, 0x5c, 0x3c
};
static const uint8_t nist_kas_ecc_cdh_testvector_283_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x74, 0x24, 0x5c, 0xc9, 0x7d, 0xd4, 0x50, 0x93, 0x56,
	0x89, 0xea, 0x3f, 0xca, 0x7b, 0x0b, 0x30, 0xc1, 0xd6, 0x7c, 0xe6, 0xe8,
	0xbe, 0x17, 0xcb, 0x11, 0x92, 0x57, 0x5c, 0xaf
};
/* QIUTx = 000001e1c570acc653c706fd7740194a554de7f3799a12b820d6a941197f761d */
/* QIUTy = 000001e2225e8d0d41c808f6ead7af320fb25fed29a99098a0f0e11cd869e53c */
static const uint8_t nist_kas_ecc_cdh_testvector_283_out[] = {
/* ZIUT */
	0x00, 0xbc, 0x0d, 0xcf, 0x75, 0x85, 0x75, 0x3c, 0xc7, 0x9a, 0xa4, 0x12,
	0xd2, 0x74, 0x0b, 0x4b, 0x2d, 0x1c, 0x64, 0x4f, 0xc9, 0x75, 0x5c, 0xb0,
	0x55, 0x02, 0x86, 0xbc, 0xf6, 0x8e
};
/* COUNT = 8 */
static const uint8_t nist_kas_ecc_cdh_testvector_284_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x01, 0x66, 0xbe, 0x24, 0x26, 0xb3, 0xbf, 0x8e, 0x6d, 0x05,
	0xa2, 0x4d, 0x7d, 0x1f, 0x2c, 0x0e, 0x32, 0x9e, 0x41, 0x20, 0xcf, 0xc8,
	0xe6, 0xff, 0x52, 0x48, 0x6f, 0x09, 0x55, 0x86
};
static const uint8_t nist_kas_ecc_cdh_testvector_284_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x73, 0x71, 0xe2, 0x88, 0x14, 0x5f, 0xc2, 0x5a, 0x5a,
	0x9c, 0xb5, 0xf2, 0xa3, 0x86, 0x03, 0x4f, 0x2f, 0x32, 0x8c, 0x6e, 0xaa,
	0x24, 0xc8, 0xb0, 0x96, 0xe8, 0xab, 0x1f, 0x0c
};
static const uint8_t nist_kas_ecc_cdh_testvector_284_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x97, 0xbe, 0xed, 0x4b, 0x73, 0x8a, 0x62, 0x05, 0xcc,
	0x9e, 0xa0, 0x46, 0xb4, 0x48, 0xb5, 0x23, 0x12, 0x8b, 0x93, 0x10, 0x1a,
	0x02, 0xd9, 0x64, 0x43, 0x5e, 0xb1, 0x78, 0x06
};
/* QIUTx = 0000018358da94079a700a10b20a2325d33d80e95eb4fc4a98101c312635939c */
/* QIUTy = 0000000c4f442d0071c7bd1d217cf235fd031dec309e85ea2014e68b50fc2ba0 */
static const uint8_t nist_kas_ecc_cdh_testvector_284_out[] = {
/* ZIUT */
	0x01, 0xb7, 0xef, 0x31, 0x48, 0xbe, 0x33, 0x11, 0x15, 0x32, 0x1b, 0x1c,
	0x2a, 0x68, 0x83, 0x2f, 0xdf, 0xb9, 0x91, 0xb2, 0x62, 0x24, 0xa6, 0x0d,
	0xdd, 0xce, 0x3e, 0x06, 0x0d, 0x27
};
/* COUNT = 9 */
static const uint8_t nist_kas_ecc_cdh_testvector_285_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x01, 0x81, 0xf3, 0xbb, 0x0b, 0x09, 0x77, 0x13, 0x27, 0x7c,
	0x5f, 0x3b, 0x46, 0xce, 0xf0, 0x2a, 0xa9, 0xcb, 0xe2, 0x9a, 0xb9, 0x5c,
	0x76, 0xe9, 0xb6, 0x0a, 0x1f, 0x7a, 0x51, 0xe5
};
static const uint8_t nist_kas_ecc_cdh_testvector_285_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0x2e, 0x2f, 0xb6, 0x72, 0xd7, 0x2b, 0xf7, 0x8f, 0x7c,
	0xfe, 0xdc, 0x40, 0xd3, 0x72, 0x6c, 0x6b, 0x4f, 0xb5, 0x85, 0x41, 0x7c,
	0x74, 0x76, 0xb6, 0x55, 0xe3, 0x2b, 0xbd, 0x3b
};
static const uint8_t nist_kas_ecc_cdh_testvector_285_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x75, 0x9c, 0x55, 0xda, 0x55, 0xe1, 0xfd, 0xb5, 0xba,
	0x7f, 0x8b, 0x89, 0x3a, 0xba, 0xae, 0x59, 0x25, 0xb9, 0xb0, 0x81, 0x84,
	0xa3, 0xd5, 0x54, 0x95, 0x7a, 0xcf, 0x3e, 0xc0
};
/* QIUTx = 0000002af25f810e18a81b69da254a65b8a6c7ab80ddc27c85622e2348add132 */
/* QIUTy = 00000128b753e4b21a8c3acf85aab92a9aa6a7b33f2cb69d7024baf8e8b07142 */
static const uint8_t nist_kas_ecc_cdh_testvector_285_out[] = {
/* ZIUT */
	0x00, 0x41, 0x24, 0x98, 0x65, 0xc9, 0x13, 0xb2, 0x87, 0xa2, 0x53, 0x15,
	0x0b, 0x20, 0x7e, 0x26, 0x82, 0xef, 0xd9, 0x60, 0x57, 0xcb, 0x07, 0x09,
	0xe9, 0xbb, 0xb4, 0x8c, 0x0f, 0xc9
};
/* COUNT = 10 */
static const uint8_t nist_kas_ecc_cdh_testvector_286_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x65, 0xaa, 0x41, 0x15, 0xe5, 0x9e, 0x60, 0x45, 0xaa,
	0xf9, 0x9e, 0xe1, 0xbe, 0xca, 0x1f, 0xab, 0x92, 0x3b, 0xbd, 0xc9, 0x19,
	0x20, 0x6e, 0x09, 0x31, 0x62, 0x0b, 0xa9, 0x96
};
static const uint8_t nist_kas_ecc_cdh_testvector_286_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x01, 0x28, 0xd0, 0x0b, 0x77, 0x58, 0x99, 0xa5, 0x8a, 0x59,
	0xbc, 0xb2, 0xab, 0x79, 0xd6, 0x09, 0xe2, 0xdc, 0xda, 0x98, 0xe6, 0x52,
	0x3b, 0xb6, 0x71, 0x68, 0x55, 0x4f, 0x84, 0xe6
};
static const uint8_t nist_kas_ecc_cdh_testvector_286_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0xee, 0x63, 0x9d, 0x89, 0xf0, 0xe4, 0x33, 0xc0, 0x75,
	0xe2, 0xef, 0x57, 0xcc, 0x24, 0x35, 0x81, 0xe9, 0x5b, 0x26, 0x1f, 0x8a,
	0x93, 0xb8, 0xef, 0x6f, 0x5e, 0xbf, 0x80, 0x15
};
/* QIUTx = 00000006638f6bcd85043395d01d767ff77e9d677f37ef400f2e16fee86dbaf2 */
/* QIUTy = 0000006c12496266debb1d8343b9684e27c5f7129c17024a8e6704672a5f3d63 */
static const uint8_t nist_kas_ecc_cdh_testvector_286_out[] = {
/* ZIUT */
	0x01, 0xcf, 0x48, 0x0f, 0xbc, 0x2b, 0xe2, 0xc2, 0xc4, 0x44, 0x8c, 0x88,
	0x89, 0x09, 0x72, 0xc7, 0xff, 0x9c, 0xbe, 0x08, 0xa7, 0x5e, 0x26, 0xc3,
	0x80, 0x95, 0x96, 0xb8, 0xb5, 0xc0
};
/* COUNT = 11 */
static const uint8_t nist_kas_ecc_cdh_testvector_287_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x01, 0x35, 0x76, 0xe7, 0x00, 0xf3, 0x63, 0x67, 0xfb, 0x74,
	0x18, 0x42, 0xf2, 0x31, 0x88, 0x9f, 0x36, 0x82, 0x2a, 0xab, 0x29, 0x33,
	0xc2, 0x45, 0xee, 0xd5, 0x7b, 0x9d, 0xac, 0xad
};
static const uint8_t nist_kas_ecc_cdh_testvector_287_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x01, 0x79, 0x10, 0xe9, 0x07, 0x1a, 0x3e, 0x42, 0xe7, 0xf2,
	0x1b, 0x36, 0x3f, 0x0e, 0x68, 0x7d, 0x28, 0x98, 0x10, 0xa4, 0xec, 0x29,
	0xc3, 0x6e, 0xce, 0x14, 0x85, 0x4e, 0x1d, 0xd1
};
static const uint8_t nist_kas_ecc_cdh_testvector_287_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x92, 0x9b, 0x09, 0xb6, 0x7b, 0x29, 0xaa, 0x4f, 0xf1,
	0x5d, 0x67, 0x79, 0xa1, 0x73, 0x30, 0x65, 0x04, 0x9f, 0xae, 0xb2, 0xc2,
	0x27, 0x01, 0x2c, 0x49, 0xf2, 0x77, 0xed, 0x51
};
/* QIUTx = 000000ca0403d95d85f0cb0ae4d2aeae18e187b79c201ed68c14ad24ed003922 */
/* QIUTy = 000000cf6b0a502b290d0aeee820661accf6ea597687c45c7f93a773d25f62a6 */
static const uint8_t nist_kas_ecc_cdh_testvector_287_out[] = {
/* ZIUT */
	0x01, 0xce, 0x8a, 0xbf, 0x3c, 0x8c, 0xcf, 0xa3, 0x0e, 0x5f, 0x35, 0xdd,
	0xb7, 0x5f, 0x5e, 0x10, 0x6a, 0xab, 0x1e, 0x67, 0x08, 0x61, 0x56, 0xa1,
	0xed, 0xed, 0xa1, 0x71, 0x7b, 0x77
};
/* COUNT = 12 */
static const uint8_t nist_kas_ecc_cdh_testvector_288_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0xe9, 0xfb, 0xa7, 0x1a, 0x64, 0xab, 0xb1, 0x77, 0xfa,
	0x43, 0x6c, 0xb9, 0x73, 0x9c, 0x9f, 0x68, 0xc0, 0x15, 0x5a, 0xdc, 0x89,
	0x71, 0x39, 0xc1, 0xbf, 0x3d, 0xf9, 0x9a, 0x53
};
static const uint8_t nist_kas_ecc_cdh_testvector_288_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x01, 0x9a, 0xf1, 0x13, 0x1b, 0xe4, 0x7d, 0xe0, 0x88, 0x70,
	0x83, 0x5d, 0xa1, 0x49, 0x46, 0xfe, 0xd7, 0x30, 0x34, 0x17, 0x9f, 0x80,
	0x92, 0x98, 0xd0, 0x14, 0x9b, 0x16, 0xdd, 0x36
};
static const uint8_t nist_kas_ecc_cdh_testvector_288_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0xe2, 0x7a, 0xf0, 0x4e, 0xfe, 0x2d, 0x86, 0xff, 0xed,
	0x6e, 0xcd, 0xf7, 0x18, 0xfc, 0x0b, 0x8e, 0x04, 0x9e, 0xd2, 0x22, 0xe7,
	0x60, 0x0c, 0x3c, 0xe3, 0x1c, 0xe4, 0xe9, 0x7a
};
/* QIUTx = 00000145ec0db5fe62b92547792012268af21ba928a8fd98d0a1dee3d8fb2559 */
/* QIUTy = 0000010a031cea56b183e93093008ab705cc9099e5b65c5cb4407324b96fee90 */
static const uint8_t nist_kas_ecc_cdh_testvector_288_out[] = {
/* ZIUT */
	0x00, 0x25, 0xdf, 0x75, 0x9a, 0x20, 0x31, 0x23, 0x61, 0xb9, 0xf6, 0x76,
	0x7e, 0xfe, 0x8e, 0x8d, 0x69, 0x97, 0x9e, 0x34, 0x63, 0x94, 0x69, 0xa9,
	0x1f, 0xed, 0x9f, 0xce, 0x04, 0xf8
};
/* COUNT = 13 */
static const uint8_t nist_kas_ecc_cdh_testvector_289_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x01, 0x1f, 0x99, 0x4a, 0x41, 0x6c, 0xc1, 0x99, 0x0b, 0x8c,
	0x61, 0x76, 0x7a, 0x3d, 0x68, 0xfb, 0xea, 0x73, 0xaf, 0x7b, 0x48, 0xb6,
	0x55, 0xe4, 0x74, 0x70, 0xfc, 0xcc, 0x79, 0x1f
};
static const uint8_t nist_kas_ecc_cdh_testvector_289_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x01, 0x5d, 0xe9, 0x88, 0x83, 0x5d, 0x68, 0x12, 0xf0, 0xbd,
	0xd7, 0x00, 0x7a, 0x89, 0x59, 0x71, 0xe1, 0xa0, 0x6f, 0x4d, 0x22, 0xce,
	0x13, 0x03, 0xc9, 0xf5, 0x5e, 0xfe, 0x64, 0x7c
};
static const uint8_t nist_kas_ecc_cdh_testvector_289_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x1a, 0x72, 0x6d, 0x7b, 0x99, 0x28, 0x69, 0x1e, 0xb0,
	0x14, 0x9c, 0xa8, 0xf0, 0xed, 0xee, 0x47, 0xbd, 0x0c, 0x73, 0x41, 0x13,
	0xab, 0x60, 0x03, 0x24, 0x1e, 0xe1, 0x93, 0xde
};
/* QIUTx = 0000007426bfa8878fe59b16a9b8c63910a1e2fbc6b07ba995ba04c31402112e */
/* QIUTy = 000000944e9616676cb2fc7fa0f9e1b87a358748243e80fb62264284645a6a4d */
static const uint8_t nist_kas_ecc_cdh_testvector_289_out[] = {
/* ZIUT */
	0x00, 0x43, 0x7a, 0xb4, 0xa5, 0x37, 0x56, 0xff, 0x67, 0x8a, 0x1f, 0x58,
	0x0c, 0x0f, 0xd1, 0xf3, 0x3b, 0x23, 0x02, 0x1d, 0x62, 0x06, 0x08, 0x08,
	0x45, 0x3b, 0x4a, 0xab, 0xe6, 0x27
};
/* COUNT = 14 */
static const uint8_t nist_kas_ecc_cdh_testvector_290_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x01, 0x05, 0x13, 0x62, 0x0a, 0xee, 0x0d, 0x04, 0x78, 0x87,
	0x24, 0x38, 0xe9, 0x9b, 0x23, 0xea, 0x49, 0x00, 0x15, 0x3f, 0x93, 0x66,
	0xeb, 0x17, 0xd6, 0x1b, 0xdf, 0x35, 0xaa, 0x19
};
static const uint8_t nist_kas_ecc_cdh_testvector_290_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x01, 0x13, 0x6d, 0xfb, 0xc8, 0x40, 0x1b, 0xbd, 0xa0, 0xd6,
	0x75, 0xca, 0x06, 0xa0, 0xcf, 0xf6, 0xbd, 0xd4, 0x67, 0xc0, 0xac, 0x9a,
	0x97, 0x82, 0x93, 0x30, 0x07, 0x28, 0xe7, 0xdc
};
static const uint8_t nist_kas_ecc_cdh_testvector_290_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0xf4, 0x59, 0xc7, 0x67, 0x21, 0x69, 0xc1, 0x25, 0x9e,
	0x4e, 0x19, 0x93, 0x33, 0x96, 0x4c, 0x1f, 0xff, 0xbc, 0xe7, 0x5a, 0xd3,
	0x0d, 0xde, 0x12, 0x64, 0xf5, 0xcb, 0x86, 0xd1
};
/* QIUTx = 000001b44a81895d2105fa16a6e09526c09ae7f6cbdbce210870f4e33db8b6f4 */
/* QIUTy = 000000b1e072c62a2642975f06c687c6467da295ef93f04d1c5494a624683c80 */
static const uint8_t nist_kas_ecc_cdh_testvector_290_out[] = {
/* ZIUT */
	0x01, 0xeb, 0xd5, 0x58, 0x23, 0xc5, 0x7d, 0x1f, 0xc7, 0xb3, 0x6c, 0xf1,
	0xed, 0x20, 0x51, 0xea, 0xd6, 0x4d, 0xb6, 0xd1, 0x14, 0x01, 0x4d, 0x34,
	0x07, 0x18, 0x6f, 0x50, 0xd9, 0x57
};
/* COUNT = 15 */
static const uint8_t nist_kas_ecc_cdh_testvector_291_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x35, 0xdf, 0xfe, 0xc9, 0x11, 0x7e, 0xd7, 0x16, 0x76,
	0x27, 0xa2, 0x4a, 0x3e, 0xbd, 0xdd, 0x49, 0xa3, 0xf4, 0x5d, 0x91, 0xad,
	0x18, 0x40, 0x1d, 0x3d, 0x44, 0x9b, 0x2f, 0xef
};
static const uint8_t nist_kas_ecc_cdh_testvector_291_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x01, 0x93, 0x17, 0x54, 0xce, 0x5c, 0xf5, 0x57, 0xa1, 0xc1,
	0xac, 0xed, 0xfe, 0x5e, 0x9a, 0x7b, 0x0b, 0x91, 0xf8, 0x16, 0x43, 0xda,
	0x85, 0x86, 0xa6, 0x86, 0x58, 0x85, 0xf0, 0x42
};
static const uint8_t nist_kas_ecc_cdh_testvector_291_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x65, 0x6a, 0x47, 0xb8, 0x77, 0x2b, 0x08, 0xb1, 0xd9,
	0x07, 0xc8, 0x23, 0xfb, 0x6c, 0x45, 0xc6, 0x5f, 0x9f, 0x18, 0xf8, 0xb4,
	0x3f, 0x3a, 0x61, 0xe6, 0xc7, 0x46, 0x11, 0xe1
};
/* QIUTx = 00000153cdbad92eb8d20da0c1c7aad46d08336cbc976e8d6f83947e4f4d6616 */
/* QIUTy = 000001c977b97a5e1205ca66545df3a526b6e325e087c0e070839fe7ec1ee788 */
static const uint8_t nist_kas_ecc_cdh_testvector_291_out[] = {
/* ZIUT */
	0x00, 0x6d, 0x07, 0xf6, 0xe0, 0x8b, 0x11, 0xa0, 0x60, 0xcc, 0xec, 0x43,
	0xb0, 0x7c, 0xa7, 0xd9, 0xea, 0xf6, 0xc3, 0xec, 0xe0, 0x6f, 0x47, 0x85,
	0x51, 0x92, 0x84, 0xbf, 0x6f, 0x0a
};
/* COUNT = 16 */
static const uint8_t nist_kas_ecc_cdh_testvector_292_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x48, 0x45, 0xce, 0x66, 0x1b, 0x1e, 0xae, 0x34, 0xc1,
	0x69, 0x9f, 0x1b, 0xfe, 0x38, 0xdc, 0x87, 0xef, 0x28, 0xb8, 0xb0, 0xa7,
	0x77, 0x1f, 0xf3, 0x66, 0xdc, 0x21, 0xd8, 0x63
};
static const uint8_t nist_kas_ecc_cdh_testvector_292_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x01, 0x09, 0x6b, 0x19, 0x54, 0xb0, 0x6e, 0xaa, 0x70, 0x73,
	0xed, 0x93, 0x98, 0x01, 0xaa, 0x29, 0x74, 0xda, 0x1d, 0x60, 0xd6, 0x6e,
	0x97, 0xc3, 0x1d, 0xf0, 0xf6, 0x87, 0x6f, 0xaf
};
static const uint8_t nist_kas_ecc_cdh_testvector_292_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0xf1, 0x4f, 0x5e, 0xc4, 0xef, 0xaf, 0x86, 0xe4, 0x3f,
	0xec, 0xe6, 0x5f, 0x17, 0xff, 0x91, 0xb1, 0xa8, 0xd6, 0x1b, 0xe3, 0x41,
	0x6e, 0xee, 0xb8, 0x84, 0xf4, 0xe2, 0xd1, 0x4e
};
/* QIUTx = 000001d9f8c01e9c20f6150ec7620a75e39e96f9247bece137b0365bec54254c */
/* QIUTy = 0000006008373b9e087805294dadae00894667fdb9f6b8a4d16295e5b9d21a6d */
static const uint8_t nist_kas_ecc_cdh_testvector_292_out[] = {
/* ZIUT */
	0x00, 0xae, 0xa5, 0x94, 0xf0, 0x92, 0xb4, 0x05, 0x2f, 0x75, 0x64, 0xb2,
	0xe5, 0x65, 0x1b, 0xcf, 0x43, 0xef, 0x7e, 0x33, 0x6a, 0x06, 0x4d, 0x6b,
	0xfb, 0x1a, 0x89, 0xcf, 0x5e, 0x51
};
/* COUNT = 17 */
static const uint8_t nist_kas_ecc_cdh_testvector_293_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x01, 0x47, 0x34, 0x19, 0x21, 0x65, 0xc9, 0x6f, 0xbd, 0xb7,
	0x94, 0xca, 0xb1, 0xe2, 0xd1, 0xef, 0x11, 0x1e, 0x1a, 0x20, 0xa7, 0x20,
	0x5d, 0xb0, 0x1a, 0xa8, 0x03, 0xa0, 0x32, 0xa2
};
static const uint8_t nist_kas_ecc_cdh_testvector_293_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x01, 0xec, 0xdf, 0xc3, 0x94, 0x0b, 0x7d, 0x06, 0x18, 0xcd,
	0x63, 0x15, 0x44, 0x17, 0x51, 0xf6, 0x63, 0xdf, 0x74, 0xd3, 0x56, 0x49,
	0x2e, 0xf9, 0x34, 0xb4, 0xba, 0x2b, 0x2a, 0xd1
};
static const uint8_t nist_kas_ecc_cdh_testvector_293_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x1f, 0xa5, 0xcb, 0xd8, 0x8a, 0x14, 0x6f, 0x6c, 0xcf,
	0x5f, 0x79, 0xdf, 0xbc, 0x70, 0x86, 0x8f, 0xd9, 0xbb, 0x4c, 0x81, 0x15,
	0x97, 0x6c, 0x96, 0x27, 0x0f, 0xf7, 0xbc, 0x5e
};
/* QIUTx = 0000014d276f4281cb50a26b29ec81fced96d0e909994b2285433855256d58db */
/* QIUTy = 000000ac4792af62a0dc4fd4eec384fbf3fbb82c8347486bc1eb1338bc7f3ab0 */
static const uint8_t nist_kas_ecc_cdh_testvector_293_out[] = {
/* ZIUT */
	0x00, 0x99, 0xd6, 0xd0, 0x76, 0xe1, 0x4c, 0xcf, 0xee, 0x15, 0xed, 0x7e,
	0x7e, 0xf3, 0x84, 0xbf, 0xee, 0x12, 0xde, 0xba, 0x8c, 0x9a, 0xe8, 0xf6,
	0xcc, 0xa3, 0x48, 0x6a, 0x14, 0x94
};
/* COUNT = 18 */
static const uint8_t nist_kas_ecc_cdh_testvector_294_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x7e, 0x1f, 0x32, 0x51, 0xe2, 0xa0, 0xaa, 0x6d, 0xe1,
	0xf8, 0xdf, 0x86, 0xb8, 0x5e, 0xd9, 0xd1, 0x1d, 0xa5, 0xeb, 0x71, 0x36,
	0xad, 0xd4, 0x5e, 0xa7, 0xd2, 0x5c, 0x86, 0x7c
};
static const uint8_t nist_kas_ecc_cdh_testvector_294_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0xd9, 0x62, 0x81, 0xe0, 0x75, 0x6d, 0xe9, 0xda, 0xa5,
	0x5d, 0x2e, 0xf6, 0x57, 0x3b, 0xb2, 0xfe, 0x2d, 0xd0, 0x9b, 0x71, 0xd9,
	0x11, 0x91, 0xa5, 0xa0, 0x43, 0xba, 0xe0, 0xf3
};
static const uint8_t nist_kas_ecc_cdh_testvector_294_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0xf5, 0x86, 0x84, 0xea, 0x14, 0xa6, 0x8f, 0xef, 0xb8,
	0xcc, 0x26, 0xb2, 0x67, 0xa1, 0x34, 0x19, 0xc6, 0x2d, 0x72, 0x61, 0xba,
	0xd1, 0x4e, 0x53, 0x68, 0xa9, 0x81, 0x9a, 0x18
};
/* QIUTx = 0000009a65a85394070fe0e5a108164eb289cc3d77ed0848fd57f384e62caa20 */
/* QIUTy = 000000e7f56f2c27be4faeb20e274c2604c6dc2d88597030ad2164fad03cb904 */
static const uint8_t nist_kas_ecc_cdh_testvector_294_out[] = {
/* ZIUT */
	0x01, 0xb1, 0xe9, 0x77, 0xc4, 0x3a, 0xfd, 0x20, 0x31, 0x32, 0xc0, 0x85,
	0xb9, 0x5d, 0xb0, 0xe2, 0x04, 0x6a, 0x4b, 0x6a, 0xc2, 0xc0, 0x46, 0xee,
	0x9a, 0xd6, 0x65, 0x05, 0x05, 0x78
};
/* COUNT = 19 */
static const uint8_t nist_kas_ecc_cdh_testvector_295_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0xbe, 0x1e, 0xe7, 0x50, 0xf2, 0x71, 0x2b, 0x2a, 0xcb,
	0x20, 0xc4, 0x5e, 0x97, 0x35, 0x7c, 0x50, 0xdb, 0x3b, 0xe8, 0x95, 0xb3,
	0x3f, 0x83, 0x0c, 0x71, 0xbc, 0x9f, 0x4f, 0x3d
};
static const uint8_t nist_kas_ecc_cdh_testvector_295_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x01, 0x5f, 0xec, 0x81, 0x0c, 0xdb, 0x17, 0x9f, 0xcd, 0x1c,
	0xe8, 0xe4, 0xdc, 0x1a, 0x24, 0x99, 0xe4, 0x0d, 0xe8, 0xa4, 0xa4, 0x9a,
	0x94, 0x20, 0xf0, 0x0e, 0x56, 0x11, 0x0c, 0xf4
};
static const uint8_t nist_kas_ecc_cdh_testvector_295_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0xee, 0xfb, 0x24, 0x78, 0x9b, 0x32, 0xb4, 0x36, 0xce,
	0x39, 0x62, 0x2c, 0x11, 0x4c, 0x39, 0xa6, 0xcd, 0x1e, 0x58, 0xec, 0x94,
	0x43, 0xc8, 0x87, 0x0e, 0x5e, 0xe2, 0xf8, 0x01
};
/* QIUTx = 0000013fb1ca9ed709bb386fba02cc7862fd6c64e1087be5f61ea733946c1634 */
/* QIUTy = 000001cb4097e44a730700debfe8143fbf9bca3a3d6c46985a27cd5043b2ca5a */
static const uint8_t nist_kas_ecc_cdh_testvector_295_out[] = {
/* ZIUT */
	0x00, 0x0e, 0x4c, 0xb7, 0x04, 0x35, 0x5c, 0xba, 0x1b, 0x40, 0xce, 0xe3,
	0xda, 0x10, 0x2c, 0xb0, 0x48, 0x51, 0x9a, 0x91, 0xb4, 0xc7, 0x89, 0xb3,
	0x75, 0x7c, 0xfd, 0xd9, 0x33, 0xaa
};
/* COUNT = 20 */
static const uint8_t nist_kas_ecc_cdh_testvector_296_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x01, 0x5c, 0x2e, 0x2c, 0xe0, 0xbc, 0x72, 0x2c, 0xea, 0x4c,
	0xbc, 0x7c, 0x33, 0x52, 0xcb, 0xe0, 0xd2, 0x8b, 0x5b, 0x00, 0x2e, 0x44,
	0xd9, 0x37, 0x05, 0x89, 0x5d, 0x79, 0x1a, 0xfc
};
static const uint8_t nist_kas_ecc_cdh_testvector_296_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x01, 0x4f, 0x61, 0x69, 0x83, 0xad, 0x08, 0xe7, 0x45, 0x31,
	0x5c, 0x47, 0x67, 0xb0, 0xae, 0x21, 0xa6, 0xfd, 0x8a, 0x62, 0x9c, 0x25,
	0x8c, 0xe7, 0xae, 0xfa, 0x4c, 0x17, 0xa8, 0xe0
};
static const uint8_t nist_kas_ecc_cdh_testvector_296_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x17, 0x52, 0x4d, 0x50, 0x66, 0x16, 0xbd, 0x20, 0x5c,
	0xb3, 0x97, 0x8b, 0xc7, 0x5e, 0x3a, 0x34, 0x76, 0x23, 0x3e, 0x49, 0xb6,
	0xdc, 0x20, 0x6f, 0x97, 0x11, 0x69, 0x75, 0x57
};
/* QIUTx = 00000150a17327845e7bc79d8ece12930dc2b77654caa1082b57b0cf8e05b1ac */
/* QIUTy = 000000151c76822d8df5effd8c6943395b6a8d538431d42e846e9ff8de7eaee6 */
static const uint8_t nist_kas_ecc_cdh_testvector_296_out[] = {
/* ZIUT */
	0x00, 0xd8, 0xc1, 0x3b, 0xc5, 0xe8, 0x19, 0xc6, 0x10, 0x1d, 0xae, 0xf3,
	0xf6, 0xfb, 0x5b, 0xe6, 0xbc, 0xce, 0xcf, 0x23, 0x3c, 0x4b, 0x7f, 0xc6,
	0x50, 0x54, 0xe8, 0xe8, 0xd3, 0xbc
};
/* COUNT = 21 */
static const uint8_t nist_kas_ecc_cdh_testvector_297_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0xba, 0xfa, 0x9b, 0xba, 0x92, 0x72, 0x5e, 0xef, 0x0c,
	0x4a, 0x0a, 0xfc, 0xbd, 0x42, 0x63, 0xe5, 0x5f, 0x51, 0x55, 0x64, 0x5b,
	0x5c, 0x58, 0xa9, 0x6b, 0xc3, 0xe9, 0xe9, 0x65
};
static const uint8_t nist_kas_ecc_cdh_testvector_297_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0xd1, 0xb3, 0xd0, 0xe3, 0x5d, 0x61, 0x7e, 0x09, 0xe0,
	0x78, 0xc5, 0x71, 0xa5, 0xf4, 0x1e, 0xa2, 0x2d, 0xfd, 0x11, 0x2d, 0x67,
	0xa9, 0x4d, 0x8d, 0xfb, 0xba, 0x66, 0xe9, 0xa9
};
static const uint8_t nist_kas_ecc_cdh_testvector_297_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0xa6, 0xb0, 0x5d, 0x30, 0xa7, 0x03, 0xf1, 0x17, 0x9a,
	0x80, 0xf8, 0xa8, 0x64, 0xb3, 0x4c, 0xa1, 0x5c, 0x45, 0x3e, 0x82, 0x80,
	0x8a, 0x10, 0x95, 0xe4, 0x35, 0xe9, 0xba, 0xcb
};
/* QIUTx = 00000093b3252251fd9d6d9c81d78cf1f134cdd554d63c2a1e2f1afa14e2d4e4 */
/* QIUTy = 0000008aeb0a8ab3ff5e4fb023f7e1917f0108890af11abca7da027fadacc3b4 */
static const uint8_t nist_kas_ecc_cdh_testvector_297_out[] = {
/* ZIUT */
	0x01, 0x29, 0xaf, 0x50, 0xfa, 0x08, 0x51, 0x33, 0x77, 0x17, 0x53, 0xf2,
	0x97, 0xa3, 0x13, 0xbb, 0xa0, 0xd2, 0xf5, 0x88, 0x2e, 0x76, 0x34, 0xb7,
	0xef, 0x5a, 0xdc, 0xe7, 0x60, 0xff
};
/* COUNT = 22 */
static const uint8_t nist_kas_ecc_cdh_testvector_298_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x79, 0x8b, 0xf5, 0xab, 0x76, 0x1b, 0xb6, 0xac, 0xfe,
	0xd0, 0xce, 0xf1, 0xcd, 0x71, 0xb3, 0xef, 0x46, 0xf2, 0x50, 0x43, 0x23,
	0xca, 0xfc, 0x40, 0x81, 0x59, 0x2d, 0xd6, 0xf6
};
static const uint8_t nist_kas_ecc_cdh_testvector_298_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x01, 0x62, 0x77, 0xae, 0xb3, 0xe1, 0xca, 0xc0, 0x12, 0x1b,
	0x07, 0xd9, 0x37, 0x8a, 0x3a, 0x0c, 0xbc, 0x65, 0x67, 0xb4, 0x84, 0x23,
	0x92, 0x9e, 0x36, 0xdc, 0x85, 0x5e, 0x9d, 0x1a
};
static const uint8_t nist_kas_ecc_cdh_testvector_298_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x16, 0x8d, 0x09, 0x80, 0x9e, 0xb9, 0xf6, 0xac, 0xf3,
	0x11, 0x34, 0xeb, 0x5e, 0xb1, 0xaf, 0x96, 0x6e, 0x21, 0x2b, 0x9b, 0x6b,
	0xe6, 0x8c, 0xfd, 0x22, 0x40, 0x14, 0x25, 0xe9
};
/* QIUTx = 000001710a05f02b5505729516b1ac73d45f3cf08f1c5134d2f73d12570243c9 */
/* QIUTy = 0000018611b10dab507583f2be10fd4296f537d4af09576f96979f1eadfe291c */
static const uint8_t nist_kas_ecc_cdh_testvector_298_out[] = {
/* ZIUT */
	0x00, 0x77, 0xc4, 0xea, 0x10, 0x95, 0xfa, 0xdc, 0x4c, 0xb4, 0x19, 0x0a,
	0x3f, 0xd5, 0x30, 0xc7, 0xd1, 0x53, 0x25, 0xe5, 0xd7, 0x9b, 0x8e, 0x8a,
	0x2b, 0x70, 0x8e, 0x23, 0x44, 0xcf
};
/* COUNT = 23 */
static const uint8_t nist_kas_ecc_cdh_testvector_299_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x01, 0x5f, 0x72, 0x3d, 0xa9, 0xa3, 0x8c, 0x2d, 0xa5, 0x06,
	0x2c, 0x17, 0xd0, 0xb8, 0x37, 0x52, 0x2f, 0x7c, 0x69, 0xc7, 0x93, 0xf7,
	0x9c, 0x17, 0xfb, 0x69, 0x65, 0xd4, 0x4a, 0x03
};
static const uint8_t nist_kas_ecc_cdh_testvector_299_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x01, 0x32, 0xb1, 0x77, 0x60, 0xac, 0x2e, 0x2b, 0xb9, 0xf8,
	0x13, 0xed, 0x77, 0x90, 0xc5, 0xcd, 0x3a, 0xa0, 0xd3, 0x8a, 0xb6, 0x4e,
	0x2e, 0x27, 0x2d, 0xdf, 0x4a, 0x4c, 0x2c, 0x1a
};
static const uint8_t nist_kas_ecc_cdh_testvector_299_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x38, 0x24, 0xf7, 0x1e, 0xc3, 0x25, 0x5b, 0xbd, 0x03,
	0x64, 0x2d, 0x78, 0x2c, 0xc6, 0x79, 0x4e, 0x1e, 0x54, 0xaa, 0x8f, 0xa5,
	0xf2, 0xa3, 0x31, 0xee, 0x13, 0xf7, 0x84, 0x50
};
/* QIUTx = 000001a4e35a8c32717f2aaa3eeef177848e580e0fed6c8096868f6acc4e1c09 */
/* QIUTy = 0000013727604e81d3a9d93d243fe79e2db8a442334a8ea1852b9f83cae1bc3e */
static const uint8_t nist_kas_ecc_cdh_testvector_299_out[] = {
/* ZIUT */
	0x00, 0xd9, 0xeb, 0x3c, 0x79, 0xcf, 0x44, 0x25, 0x95, 0xda, 0xd0, 0x3e,
	0xd4, 0xa3, 0x8d, 0xaf, 0x35, 0x8b, 0x97, 0xd5, 0xdf, 0xc0, 0x1c, 0xb6,
	0x1f, 0xf2, 0x00, 0xa4, 0x79, 0x58
};
/* COUNT = 24 */
static const uint8_t nist_kas_ecc_cdh_testvector_300_public_x[] = {
/* QCAVSx */
	0x00, 0x00, 0x00, 0x51, 0xb7, 0x0b, 0xb8, 0xb8, 0xe2, 0x34, 0x1b, 0x86,
	0x82, 0x1d, 0x54, 0xb9, 0x74, 0xb6, 0x96, 0xbd, 0xa4, 0x43, 0xac, 0xb7,
	0xea, 0x65, 0x96, 0x5d, 0x27, 0xd2, 0xac, 0x70
};
static const uint8_t nist_kas_ecc_cdh_testvector_300_public_y[] = {
/* QCAVSy */
	0x00, 0x00, 0x00, 0xc7, 0x78, 0x4e, 0xef, 0x88, 0x9c, 0x47, 0x1c, 0x9d,
	0x26, 0xb3, 0xe0, 0xde, 0x24, 0xad, 0x2b, 0x4b, 0xf8, 0xbb, 0xba, 0x6f,
	0xe1, 0x8f, 0x51, 0xa4, 0x12, 0x18, 0x80, 0x58
};
static const uint8_t nist_kas_ecc_cdh_testvector_300_private[] = {
/* dIUT */
	0x00, 0x00, 0x00, 0x90, 0xad, 0xc0, 0xb2, 0x07, 0xda, 0xe3, 0x81, 0x62,
	0x2c, 0xf9, 0x2e, 0x04, 0xbc, 0xe7, 0x47, 0x91, 0x80, 0xec, 0x6e, 0x17,
	0x71, 0x66, 0x2f, 0x5c, 0x31, 0x79, 0xbd, 0x99
};
/* QIUTx = 00000106adbf9bbfdb3083598a7f6db2e91d2e7c174f705fc216631b7d05edf2 */
/* QIUTy = 00000190d84ca6f4695fdbca40d26a74998a05c3d761dbf08981b645c0ea239e */
static const uint8_t nist_kas_ecc_cdh_testvector_300_out[] = {
/* ZIUT */
	0x01, 0x24, 0xc1, 0x9c, 0xff, 0xc0, 0xb9, 0x54, 0x9b, 0xfa, 0x37, 0x8a,
	0x54, 0x8e, 0x8c, 0xe1, 0x1e, 0xe7, 0xfc, 0xa2, 0x8d, 0x2d, 0x89, 0x8d,
	0xe4, 0x9a, 0xe1, 0xf2, 0xff, 0x61
};
/* [B-283] - GP NOT SUPPORTED */
/* COUNT = 0 */
static const uint8_t nist_kas_ecc_cdh_testvector_301_public_x[] = {
/* QCAVSx */
	0x02, 0x50, 0x4e, 0x1a, 0x17, 0x81, 0x9d, 0x39, 0xf0, 0x10, 0xa4, 0xa6,
	0x9a, 0x05, 0x68, 0x29, 0x94, 0x02, 0xb5, 0x8f, 0x94, 0x4a, 0x38, 0x4c,
	0x7d, 0x1a, 0x62, 0xc9, 0xc9, 0x3e, 0xa4, 0xd1, 0xff, 0x30, 0x0e, 0x13
};
static const uint8_t nist_kas_ecc_cdh_testvector_301_public_y[] = {
/* QCAVSy */
	0x02, 0x65, 0x13, 0x2f, 0x7b, 0x4c, 0x64, 0xb7, 0x4b, 0x91, 0x79, 0xed,
	0x0f, 0x2e, 0x21, 0x1f, 0x43, 0x28, 0xd6, 0x25, 0x40, 0x50, 0x22, 0xf5,
	0x54, 0x17, 0x0d, 0xa9, 0x32, 0xb8, 0x0f, 0xdf, 0x7c, 0x1a, 0xab, 0x12
};
static const uint8_t nist_kas_ecc_cdh_testvector_301_private[] = {
/* dIUT */
	0x02, 0xf4, 0x34, 0x55, 0x84, 0x22, 0x46, 0xa2, 0xcc, 0x8e, 0xc0, 0x68,
	0xe9, 0xd6, 0xc6, 0xe4, 0x16, 0x0f, 0x6b, 0xa4, 0xe3, 0xb5, 0xd8, 0x31,
	0xd9, 0x3c, 0x1d, 0xaa, 0x8f, 0xd3, 0xd5, 0xa9, 0x66, 0x0c, 0x7b, 0xb1
};
/* QIUTx = 0561e495563018169804d4c8e2435b4afd85da376d914b69d39246f8e06113aa32e642d2 */
/* QIUTy = 0781a7f59de7f42f5f9d6c3481f33fc5deb357c6ecf4c758e370d2435de3d8ee737703f4 */
static const uint8_t nist_kas_ecc_cdh_testvector_301_out[] = {
/* ZIUT */
	0x06, 0x51, 0x94, 0xe2, 0x60, 0x90, 0xe7, 0x40, 0x47, 0xee, 0x75, 0xf1,
	0x3f, 0x97, 0x69, 0xd2, 0x0e, 0x1b, 0x52, 0x18, 0x96, 0x50, 0x01, 0x1e,
	0x28, 0x3d, 0xaa, 0x09, 0x07, 0x32, 0xcc, 0x53, 0x75, 0x5d, 0xc3, 0x66
};
/* COUNT = 1 */
static const uint8_t nist_kas_ecc_cdh_testvector_302_public_x[] = {
/* QCAVSx */
	0x01, 0x62, 0x3a, 0x96, 0x75, 0xe8, 0xc4, 0x03, 0x66, 0xe2, 0x61, 0x31,
	0xe4, 0x7b, 0x1a, 0xf0, 0x6c, 0x8b, 0x33, 0xac, 0xf5, 0xe9, 0x2f, 0x54,
	0x64, 0x48, 0x16, 0xdc, 0xb8, 0x44, 0x38, 0x2c, 0x94, 0x4c, 0xc2, 0x1f
};
static const uint8_t nist_kas_ecc_cdh_testvector_302_public_y[] = {
/* QCAVSy */
	0x02, 0x9d, 0x28, 0x0f, 0x4d, 0x4c, 0x0c, 0x5f, 0xd7, 0x0f, 0x7e, 0x24,
	0x09, 0x59, 0x50, 0x12, 0x8b, 0xea, 0x3c, 0xae, 0x3c, 0xa4, 0x6f, 0x6a,
	0x5f, 0x70, 0xb7, 0x39, 0xfe, 0x1a, 0x99, 0x02, 0x68, 0x80, 0x4e, 0x38
};
static const uint8_t nist_kas_ecc_cdh_testvector_302_private[] = {
/* dIUT */
	0x02, 0xb9, 0x41, 0xe6, 0x92, 0xe0, 0xa9, 0x84, 0xc5, 0xff, 0xa8, 0x83,
	0xc9, 0xf9, 0xf8, 0x25, 0x6a, 0x43, 0xab, 0x1f, 0xd1, 0xad, 0x97, 0x82,
	0xa4, 0x2e, 0x42, 0x9a, 0x94, 0xe9, 0x10, 0xe4, 0x82, 0xb9, 0x1c, 0x23
};
/* QIUTx = 07b90af116b737d9008e4c18f6ad539d29ee1790008a1daf2e856fa672eca4aafc96ca63 */
/* QIUTy = 06aaf78d0f20657b77b97cca30eab79b679a3aaa90b10907f979cde988ce718491010c2a */
static const uint8_t nist_kas_ecc_cdh_testvector_302_out[] = {
/* ZIUT */
	0x07, 0x5c, 0x53, 0x5c, 0xc7, 0x0d, 0xe1, 0x9c, 0x92, 0xd7, 0x31, 0x4a,
	0xfa, 0x2f, 0x33, 0x20, 0x09, 0x03, 0x43, 0x1f, 0x69, 0x90, 0xad, 0x40,
	0xac, 0x31, 0xda, 0xda, 0xf4, 0xe4, 0x92, 0xa7, 0x99, 0xb7, 0x5b, 0x05
};
/* COUNT = 2 */
static const uint8_t nist_kas_ecc_cdh_testvector_303_public_x[] = {
/* QCAVSx */
	0x07, 0xb8, 0x36, 0x97, 0x28, 0x43, 0x2f, 0x75, 0x28, 0xd3, 0xee, 0xc8,
	0xa6, 0x78, 0x8e, 0x69, 0xcd, 0x2e, 0xb8, 0x81, 0x62, 0xc4, 0x75, 0x12,
	0x74, 0x2e, 0xe0, 0xf0, 0x27, 0xcc, 0xb4, 0x15, 0x7a, 0x28, 0xa2, 0x23
};
static const uint8_t nist_kas_ecc_cdh_testvector_303_public_y[] = {
/* QCAVSy */
	0x05, 0x98, 0x6e, 0xb7, 0xf1, 0x09, 0xaa, 0x1f, 0x85, 0x56, 0xeb, 0xa2,
	0xbd, 0xc8, 0x8e, 0x49, 0x13, 0xb6, 0x5e, 0xff, 0xb9, 0x44, 0xea, 0xe6,
	0x39, 0x63, 0x6c, 0xba, 0x7e, 0x01, 0xdc, 0x37, 0x18, 0xbc, 0xb3, 0x61
};
static const uint8_t nist_kas_ecc_cdh_testvector_303_private[] = {
/* dIUT */
	0x02, 0x87, 0xde, 0x17, 0x2b, 0xa5, 0x0f, 0x32, 0x7b, 0xfc, 0x7d, 0x5a,
	0x8c, 0x01, 0x56, 0xd2, 0x5a, 0x1f, 0x0b, 0x9f, 0x71, 0xd3, 0x89, 0x85,
	0x2f, 0x2e, 0x3b, 0x58, 0x74, 0x06, 0xcb, 0x74, 0xef, 0x3b, 0xd0, 0x41
};
/* QIUTx = 00a03490765fc90c23553c0e2b79dfa232b51a73f21554e5eb18da4c994d925f8ed2bbef */
/* QIUTy = 0304ffd41c5b0ab2a70b82188e8f1578d6ab7d3ce3ce34fa45dcc32207f163e91c5d6814 */
static const uint8_t nist_kas_ecc_cdh_testvector_303_out[] = {
/* ZIUT */
	0x02, 0x95, 0x6f, 0x63, 0xd4, 0x8a, 0x49, 0xa3, 0x30, 0xe2, 0x06, 0x89,
	0x55, 0xcc, 0x28, 0x86, 0xdb, 0xfd, 0x5b, 0xf7, 0x2a, 0x81, 0xb1, 0x0e,
	0xd8, 0x3f, 0x2d, 0x75, 0x8d, 0xd3, 0x15, 0xec, 0xa1, 0x72, 0x92, 0x7d
};
/* COUNT = 3 */
static const uint8_t nist_kas_ecc_cdh_testvector_304_public_x[] = {
/* QCAVSx */
	0x07, 0x3b, 0x09, 0x2a, 0x2a, 0x4d, 0x7c, 0x9a, 0x17, 0xbb, 0x88, 0xe7,
	0x5b, 0x40, 0xa9, 0xe4, 0xe4, 0x3b, 0x99, 0x81, 0x3c, 0xf6, 0x16, 0x82,
	0xd4, 0x9b, 0x92, 0x90, 0x5c, 0x2d, 0xd6, 0x06, 0x79, 0x0a, 0xed, 0x39
};
static const uint8_t nist_kas_ecc_cdh_testvector_304_public_y[] = {
/* QCAVSy */
	0x05, 0x66, 0xad, 0x45, 0x2a, 0x2d, 0x8e, 0xf0, 0xa3, 0x27, 0xce, 0x8e,
	0x28, 0x56, 0x14, 0x6f, 0xec, 0xaf, 0x09, 0xe4, 0x43, 0x1c, 0xcc, 0x04,
	0x25, 0x6a, 0x07, 0x7f, 0x60, 0x70, 0x1c, 0xe4, 0x47, 0x6b, 0x6d, 0xac
};
static const uint8_t nist_kas_ecc_cdh_testvector_304_private[] = {
/* dIUT */
	0x01, 0x53, 0xbb, 0xb8, 0xa3, 0xce, 0x4a, 0x1b, 0x99, 0x96, 0x0f, 0x56,
	0x18, 0x6a, 0xb5, 0x02, 0x07, 0xf5, 0x88, 0xf3, 0x0c, 0x94, 0xbe, 0xef,
	0x28, 0x40, 0x84, 0x23, 0xba, 0x44, 0xfc, 0x87, 0x5f, 0xaf, 0x38, 0xd8
};
/* QIUTx = 04f2c2454899623af13b65820aba145738407f77186abafa52d24b35bfdf5808ffeae076 */
/* QIUTy = 0111f448460ad2430aaec788de291548475a1e5836dac520d8e493c9f601275e70ea29d2 */
static const uint8_t nist_kas_ecc_cdh_testvector_304_out[] = {
/* ZIUT */
	0x06, 0x8a, 0x3f, 0x69, 0x38, 0xc4, 0x4b, 0x79, 0x75, 0x24, 0x37, 0x75,
	0x08, 0x58, 0x58, 0x42, 0xc6, 0xa7, 0xf1, 0xaf, 0x5f, 0xfe, 0x91, 0x31,
	0xdd, 0x3f, 0xf7, 0x86, 0xae, 0x56, 0xe1, 0x73, 0x93, 0x45, 0xd3, 0xd7
};
/* COUNT = 4 */
static const uint8_t nist_kas_ecc_cdh_testvector_305_public_x[] = {
/* QCAVSx */
	0x04, 0x55, 0xe8, 0x7b, 0xc2, 0x30, 0xce, 0x7f, 0xc5, 0x86, 0x31, 0x2d,
	0xd2, 0x07, 0xc5, 0x29, 0xe4, 0x7e, 0x3c, 0x74, 0xcc, 0x0c, 0xe5, 0xd0,
	0x73, 0xfb, 0xf4, 0xb1, 0xc9, 0x57, 0xf8, 0xcb, 0xbd, 0x91, 0x13, 0xbc
};
static const uint8_t nist_kas_ecc_cdh_testvector_305_public_y[] = {
/* QCAVSy */
	0x02, 0x1f, 0xfb, 0xf6, 0x2f, 0xb2, 0x53, 0x1d, 0xb3, 0x9e, 0xf2, 0xd0,
	0xbd, 0xce, 0x0d, 0x9c, 0x14, 0x1c, 0x92, 0xe9, 0xcd, 0xca, 0x62, 0x7c,
	0xaa, 0x39, 0xb5, 0x93, 0xfc, 0x4a, 0x02, 0x10, 0xe8, 0xee, 0x48, 0x1f
};
static const uint8_t nist_kas_ecc_cdh_testvector_305_private[] = {
/* dIUT */
	0x03, 0x2a, 0xc0, 0xdc, 0xb9, 0xaa, 0x39, 0x72, 0x40, 0x1f, 0x9f, 0x58,
	0x84, 0x5e, 0xd7, 0x65, 0xda, 0x36, 0xb7, 0xd6, 0xf7, 0x73, 0x55, 0x77,
	0x9b, 0xfb, 0x24, 0x39, 0x82, 0x7f, 0xf3, 0x55, 0x6a, 0x75, 0x78, 0x1c
};
/* QIUTx = 07159c86b9c6adb2160c28d86118f84564a90c149ede28329463677a4c87729f897c2f98 */
/* QIUTy = 008a78167e1690625992b0efc2e0ef6f6d61e81837c8ecdfdab51d15340e37e7d8d05120 */
static const uint8_t nist_kas_ecc_cdh_testvector_305_out[] = {
/* ZIUT */
	0x01, 0x9b, 0x48, 0xd5, 0xee, 0xae, 0xb0, 0x5b, 0x58, 0x80, 0x1a, 0xe8,
	0xf3, 0x45, 0xad, 0x9b, 0xac, 0xb9, 0x1d, 0xaa, 0xc8, 0x85, 0xe5, 0x06,
	0x94, 0x9b, 0x84, 0x9e, 0xbc, 0x67, 0xbc, 0xbf, 0xa3, 0x08, 0xaa, 0xb7
};
/* COUNT = 5 */
static const uint8_t nist_kas_ecc_cdh_testvector_306_public_x[] = {
/* QCAVSx */
	0x06, 0x52, 0xcc, 0xc8, 0x92, 0x1f, 0x43, 0x9a, 0xf4, 0x2a, 0x23, 0x01,
	0x23, 0x6b, 0x58, 0x43, 0xa4, 0x2f, 0x1f, 0xd9, 0x9e, 0xcf, 0xe1, 0xb4,
	0x13, 0x4c, 0x3d, 0xe0, 0x14, 0xcd, 0xc7, 0x60, 0x35, 0x34, 0x7c, 0xc0
};
static const uint8_t nist_kas_ecc_cdh_testvector_306_public_y[] = {
/* QCAVSy */
	0x03, 0x34, 0x1d, 0x80, 0x74, 0x9f, 0x1a, 0x5e, 0xc9, 0xf7, 0xac, 0x62,
	0x52, 0x38, 0x4f, 0xef, 0xd3, 0x8b, 0x6f, 0x2b, 0xbc, 0xdc, 0x18, 0xfe,
	0xbe, 0x86, 0xc1, 0x60, 0xf5, 0xe7, 0x8c, 0x00, 0x3f, 0x06, 0x6e, 0x06
};
static const uint8_t nist_kas_ecc_cdh_testvector_306_private[] = {
/* dIUT */
	0x02, 0x68, 0x9b, 0xf2, 0x14, 0x75, 0xd3, 0x2f, 0xe7, 0x1a, 0x73, 0x55,
	0xef, 0xd9, 0xa7, 0x78, 0x7c, 0xaa, 0x95, 0x45, 0xeb, 0xeb, 0x85, 0x3e,
	0x51, 0x84, 0xce, 0x42, 0x15, 0x24, 0x29, 0x05, 0x1f, 0x40, 0xcb, 0xc4
};
/* QIUTx = 00d7e5bcfac578fcd728180645176d7e088b68d330a209f18b968662fed16342b3921a20 */
/* QIUTy = 06f750b3b5e98e0099b695965aa1d16475d1074f9231127ed703e2696d4b56afdebbceaa */
static const uint8_t nist_kas_ecc_cdh_testvector_306_out[] = {
/* ZIUT */
	0x06, 0x1b, 0x3b, 0xef, 0x17, 0x66, 0x46, 0x0f, 0x62, 0x96, 0xed, 0x47,
	0xd3, 0x9e, 0xbf, 0x5a, 0x71, 0x0d, 0x20, 0x2d, 0x2b, 0x7e, 0x7c, 0xac,
	0x0f, 0x0d, 0x3b, 0x23, 0x54, 0x05, 0xee, 0xce, 0x99, 0xaa, 0x30, 0xd7
};
/* COUNT = 6 */
static const uint8_t nist_kas_ecc_cdh_testvector_307_public_x[] = {
/* QCAVSx */
	0x06, 0x23, 0x31, 0xb9, 0x33, 0xaf, 0xb4, 0x38, 0x4f, 0xa3, 0xa4, 0xd2,
	0x24, 0x55, 0x1a, 0xe8, 0x12, 0x0b, 0xc5, 0x5f, 0xc7, 0xea, 0x73, 0xf2,
	0xbe, 0x74, 0x9e, 0x21, 0x7a, 0xfc, 0x4e, 0x1b, 0xa7, 0x9e, 0x76, 0x0f
};
static const uint8_t nist_kas_ecc_cdh_testvector_307_public_y[] = {
/* QCAVSy */
	0x02, 0xbf, 0x51, 0xc4, 0x4f, 0x83, 0x61, 0xc3, 0x05, 0x4c, 0xad, 0x64,
	0x0f, 0x92, 0x44, 0x6f, 0xe3, 0x82, 0x0b, 0x06, 0x3c, 0xf4, 0xbb, 0x22,
	0xca, 0x17, 0xc0, 0xa2, 0x74, 0xfd, 0x46, 0xf5, 0x05, 0x04, 0xfb, 0xec
};
static const uint8_t nist_kas_ecc_cdh_testvector_307_private[] = {
/* dIUT */
	0x01, 0x05, 0x20, 0x42, 0x98, 0x8d, 0xdd, 0xf4, 0x70, 0xd0, 0xa2, 0xe3,
	0x6f, 0xff, 0x5b, 0x93, 0xec, 0x69, 0xf4, 0xd2, 0x40, 0xa8, 0xe3, 0x7c,
	0x06, 0x4c, 0xc4, 0xd5, 0x99, 0x46, 0x7b, 0xa2, 0x7a, 0xf3, 0xc9, 0xf1
};
/* QIUTx = 00c7c9ff77e018b8801bddf886702556b126a6d9a1831a1f60f35872e524c134d553e4a4 */
/* QIUTy = 0035d767b58b499d9fb54562c3830411af59e7088a4a3333d5dc7fe5b0f7f1e1c5e3ac2b */
static const uint8_t nist_kas_ecc_cdh_testvector_307_out[] = {
/* ZIUT */
	0x05, 0x5d, 0x57, 0x94, 0x58, 0x86, 0x0a, 0x3d, 0xd9, 0x2a, 0xc6, 0x57,
	0x08, 0x47, 0x63, 0x2f, 0x04, 0x46, 0x07, 0x55, 0xc2, 0x2a, 0x4c, 0x43,
	0x2c, 0xf4, 0xdd, 0xe9, 0x61, 0x1d, 0x2c, 0xe1, 0x60, 0x8c, 0xa1, 0x85
};
/* COUNT = 7 */
static const uint8_t nist_kas_ecc_cdh_testvector_308_public_x[] = {
/* QCAVSx */
	0x02, 0x1e, 0x82, 0xd6, 0xaf, 0x6d, 0x32, 0x11, 0x98, 0x17, 0x6f, 0xf8,
	0x98, 0x6c, 0x2b, 0xc7, 0x86, 0xa0, 0x08, 0x13, 0x26, 0xcc, 0x85, 0xf0,
	0x26, 0xb7, 0x1b, 0x32, 0xac, 0x06, 0xc0, 0xba, 0xe6, 0xb4, 0xcb, 0xa2
};
static const uint8_t nist_kas_ecc_cdh_testvector_308_public_y[] = {
/* QCAVSy */
	0x01, 0xe9, 0x73, 0x3f, 0xa9, 0xd2, 0x99, 0x61, 0x26, 0x94, 0x20, 0xdb,
	0x24, 0xed, 0xc0, 0xd5, 0xae, 0x28, 0x5d, 0x78, 0xc9, 0xae, 0x14, 0xb3,
	0x8b, 0x10, 0x19, 0xf1, 0x36, 0x52, 0xf1, 0x90, 0x27, 0x7d, 0xc4, 0x7f
};
static const uint8_t nist_kas_ecc_cdh_testvector_308_private[] = {
/* dIUT */
	0x03, 0xbb, 0x9a, 0xd5, 0xfa, 0x55, 0x2d, 0x38, 0xd1, 0xa7, 0x7c, 0xb5,
	0x53, 0xc6, 0x31, 0xe2, 0xd0, 0x94, 0x0d, 0xb6, 0xb0, 0x4f, 0x0b, 0xd7,
	0x01, 0x1e, 0xa7, 0x35, 0xbe, 0x50, 0xd0, 0x45, 0xda, 0x9a, 0x9c, 0x1d
};
/* QIUTx = 0687071805c25a7d0b1739f7cf681b2f295c4f9d8937351d21d1d43f634e9a57105bf127 */
/* QIUTy = 0633ba21872e379c50e448372b1c0e65e85d07edd712d7dc06fa69a299f6037dece660dc */
static const uint8_t nist_kas_ecc_cdh_testvector_308_out[] = {
/* ZIUT */
	0x05, 0x4f, 0xa7, 0xc6, 0xc8, 0x4f, 0xb8, 0x9e, 0x58, 0x92, 0xd9, 0x19,
	0x45, 0x40, 0x86, 0x0e, 0xa3, 0x1a, 0xe2, 0xb6, 0xe3, 0x7a, 0x86, 0x97,
	0x13, 0x44, 0x23, 0x0e, 0xa5, 0x12, 0xa3, 0xf6, 0xc0, 0x56, 0x92, 0x16
};
/* COUNT = 8 */
static const uint8_t nist_kas_ecc_cdh_testvector_309_public_x[] = {
/* QCAVSx */
	0x04, 0x5d, 0x62, 0xd0, 0x1d, 0xb5, 0xef, 0x17, 0x3d, 0x0c, 0xff, 0x31,
	0x5a, 0x92, 0xa9, 0xa1, 0x05, 0xd1, 0xad, 0x78, 0x4f, 0xf9, 0xb0, 0x8e,
	0x72, 0x1f, 0x35, 0x80, 0xe0, 0x62, 0x65, 0xff, 0x53, 0x8a, 0x19, 0x4b
};
static const uint8_t nist_kas_ecc_cdh_testvector_309_public_y[] = {
/* QCAVSy */
	0x06, 0xb7, 0x64, 0xc1, 0xff, 0x76, 0x98, 0x54, 0x96, 0xb9, 0x44, 0x51,
	0xb7, 0x56, 0xc4, 0xf3, 0x0f, 0xdf, 0xc6, 0x38, 0xd8, 0x99, 0x03, 0x12,
	0xbb, 0xec, 0xcb, 0xfb, 0xd7, 0x3e, 0x8c, 0x5a, 0x85, 0x5a, 0xdb, 0x75
};
static const uint8_t nist_kas_ecc_cdh_testvector_309_private[] = {
/* dIUT */
	0x01, 0x33, 0xaa, 0x44, 0x5d, 0xc8, 0x0d, 0x7d, 0x5a, 0x09, 0x7d, 0x1d,
	0xa1, 0x1d, 0x51, 0x0e, 0x65, 0x71, 0xa7, 0x83, 0xb4, 0xfb, 0x23, 0x54,
	0x02, 0x71, 0x7d, 0x68, 0xba, 0x8f, 0xd1, 0x45, 0x4e, 0x6b, 0x31, 0x9f
};
/* QIUTx = 02d26e46a6ed9fcf1d2f89c63d80e0172dedb4f5aeddff092836aac8599094885557ead9 */
/* QIUTy = 07d6713974701c160aedec8f94e6446bf7d3c790cbff8702cc7840a7818e5b626271f723 */
static const uint8_t nist_kas_ecc_cdh_testvector_309_out[] = {
/* ZIUT */
	0x03, 0x53, 0xff, 0x03, 0xaf, 0xda, 0x37, 0x72, 0x98, 0x4a, 0xad, 0xc4,
	0x00, 0x0e, 0x12, 0x75, 0x65, 0x66, 0x07, 0x15, 0x4b, 0x06, 0xc3, 0xa5,
	0x9c, 0x66, 0x49, 0x45, 0xfa, 0x6f, 0xde, 0x1c, 0x25, 0x5f, 0xfa, 0x86
};
/* COUNT = 9 */
static const uint8_t nist_kas_ecc_cdh_testvector_310_public_x[] = {
/* QCAVSx */
	0x04, 0xa5, 0x61, 0xb5, 0x18, 0x4a, 0xde, 0xd9, 0xc7, 0xbd, 0x98, 0x68,
	0xf3, 0x04, 0x3b, 0x5e, 0x2d, 0xe5, 0x19, 0x08, 0xf9, 0xc0, 0x3d, 0x5e,
	0x6b, 0x08, 0xa3, 0x08, 0x8b, 0xcc, 0x50, 0xee, 0x32, 0x03, 0xe2, 0x63
};
static const uint8_t nist_kas_ecc_cdh_testvector_310_public_y[] = {
/* QCAVSy */
	0x05, 0x81, 0x5b, 0x57, 0x9f, 0xf5, 0xde, 0xc6, 0xfa, 0xc9, 0x77, 0xba,
	0x70, 0x88, 0xb3, 0x33, 0xbf, 0x4c, 0x02, 0x31, 0xda, 0x02, 0x18, 0x74,
	0xee, 0x00, 0xd7, 0x1f, 0xe2, 0x5d, 0x3f, 0x4d, 0x50, 0xa5, 0x7a, 0xc3
};
static const uint8_t nist_kas_ecc_cdh_testvector_310_private[] = {
/* dIUT */
	0x00, 0x46, 0x61, 0xf1, 0x07, 0xa9, 0xb5, 0x70, 0x04, 0x5d, 0xdb, 0xb0,
	0x73, 0x8a, 0xb6, 0x9b, 0x1c, 0x17, 0xa9, 0xac, 0xc1, 0x1d, 0xa5, 0xda,
	0xc7, 0xfd, 0x86, 0x4b, 0x3d, 0xfc, 0x36, 0xa2, 0x52, 0x82, 0xd6, 0xaa
};
/* QIUTx = 061babbefee5211c4917506ce5f9f9e3d1e52b2506f38ca096e1b653ca9fb69f46105702 */
/* QIUTy = 0014bfd2ef228b5a03e26230c1e897ad081a704013cee55166ca46de395fc52f5d21203a */
static const uint8_t nist_kas_ecc_cdh_testvector_310_out[] = {
/* ZIUT */
	0x05, 0x07, 0x95, 0xba, 0x09, 0x3d, 0x2e, 0x02, 0x39, 0x8c, 0x35, 0x89,
	0x51, 0xf2, 0x0c, 0x9e, 0x3b, 0x4f, 0x60, 0x62, 0x8a, 0x96, 0xa4, 0xd0,
	0xc4, 0x6c, 0xb8, 0xfc, 0x00, 0x05, 0xe5, 0x33, 0x1b, 0x38, 0xa0, 0x9a
};
/* COUNT = 10 */
static const uint8_t nist_kas_ecc_cdh_testvector_311_public_x[] = {
/* QCAVSx */
	0x01, 0xd7, 0xd7, 0x53, 0x6c, 0xd8, 0x38, 0x3e, 0x1c, 0x0b, 0x1b, 0x8a,
	0xae, 0x02, 0xba, 0xa9, 0xfd, 0x2c, 0x4e, 0x68, 0xb2, 0x18, 0x08, 0xc1,
	0x75, 0x4d, 0x0b, 0x15, 0x13, 0x61, 0x15, 0x7f, 0x81, 0x24, 0x59, 0x30
};
static const uint8_t nist_kas_ecc_cdh_testvector_311_public_y[] = {
/* QCAVSy */
	0x07, 0x30, 0x34, 0xda, 0x41, 0x67, 0x97, 0xda, 0x95, 0xa3, 0x83, 0x6e,
	0xef, 0x27, 0xb1, 0xfa, 0x27, 0x1f, 0x59, 0xa4, 0x34, 0x84, 0x8e, 0x98,
	0x0b, 0xad, 0x2f, 0xdd, 0x53, 0xff, 0xd1, 0xe3, 0x66, 0xff, 0x69, 0x17
};
static const uint8_t nist_kas_ecc_cdh_testvector_311_private[] = {
/* dIUT */
	0x00, 0x36, 0xbd, 0x21, 0xf8, 0x4a, 0xb9, 0xdb, 0x6f, 0x4b, 0xdd, 0xc9,
	0x46, 0x35, 0xf1, 0x9f, 0x80, 0xac, 0xb2, 0x81, 0x3d, 0xa5, 0x39, 0x9e,
	0x07, 0x77, 0x83, 0x2c, 0x2f, 0xeb, 0xdc, 0x71, 0x86, 0x2a, 0xbe, 0x33
};
/* QIUTx = 068ee3245754d51df7780046af39acb407c4998c620bff94fb374faf4b498006eea0cf88 */
/* QIUTy = 0366a449f09ecfbaecc49d880307f57246c11c5bea00af42718677a8def15e5926da1822 */
static const uint8_t nist_kas_ecc_cdh_testvector_311_out[] = {
/* ZIUT */
	0x02, 0xab, 0x08, 0xd6, 0x3c, 0xdb, 0x4b, 0xe2, 0x50, 0x25, 0x58, 0xe6,
	0x7e, 0xab, 0x27, 0x57, 0x0f, 0x2d, 0x02, 0x9e, 0x7f, 0x98, 0x1d, 0x15,
	0x3b, 0x97, 0x30, 0x80, 0x58, 0x5d, 0x01, 0xe4, 0x2f, 0x71, 0x87, 0xd9
};
/* COUNT = 11 */
static const uint8_t nist_kas_ecc_cdh_testvector_312_public_x[] = {
/* QCAVSx */
	0x02, 0x04, 0x2f, 0x5a, 0x3f, 0xe5, 0xe3, 0xd3, 0x33, 0x5b, 0xb7, 0xbc,
	0xdb, 0x9d, 0xcb, 0xd8, 0x71, 0x6e, 0xd1, 0x8d, 0x7f, 0xc2, 0xff, 0x42,
	0x97, 0xbc, 0x1f, 0xeb, 0x7c, 0xca, 0x31, 0x00, 0x22, 0xe2, 0x21, 0x3d
};
static const uint8_t nist_kas_ecc_cdh_testvector_312_public_y[] = {
/* QCAVSy */
	0x07, 0xbe, 0xbb, 0x6c, 0x0e, 0x04, 0x6d, 0x5a, 0xfd, 0xbf, 0xa8, 0x7e,
	0xa9, 0x8c, 0xa7, 0xf5, 0x5e, 0x9c, 0xdb, 0xb0, 0x55, 0xd0, 0xcc, 0x54,
	0x9b, 0x44, 0x58, 0xd6, 0x99, 0x8b, 0xdb, 0xb3, 0x45, 0x17, 0x73, 0x88
};
static const uint8_t nist_kas_ecc_cdh_testvector_312_private[] = {
/* dIUT */
	0x01, 0x65, 0x97, 0xae, 0x6e, 0x49, 0xe7, 0x9d, 0x06, 0x90, 0x34, 0x97,
	0x2a, 0x63, 0x52, 0x5a, 0x3c, 0x3e, 0x2d, 0x2c, 0x25, 0x3b, 0x9e, 0x1d,
	0xd3, 0xf3, 0x78, 0x16, 0x81, 0x2c, 0xf5, 0x4a, 0xd6, 0x5c, 0x54, 0x6a
};
/* QIUTx = 050ea073522dbe51408f85f0a6086bd4c8efe572f80aadadd7e70ebb4b728bfdbfd4f1bc */
/* QIUTy = 07da520017c7ad2916a2719b8558958f77c712d352cff9c0ad99fbc98a0e065eb7ac7feb */
static const uint8_t nist_kas_ecc_cdh_testvector_312_out[] = {
/* ZIUT */
	0x05, 0x99, 0x75, 0x7e, 0x3f, 0xfe, 0xb4, 0x84, 0xb3, 0x2d, 0x3b, 0x47,
	0x82, 0x8b, 0x68, 0x23, 0xd4, 0x67, 0x86, 0xd3, 0x54, 0x77, 0x08, 0x2c,
	0xea, 0xcf, 0x3a, 0x5a, 0x11, 0x55, 0x23, 0x94, 0xfe, 0x58, 0xf5, 0x3b
};
/* COUNT = 12 */
static const uint8_t nist_kas_ecc_cdh_testvector_313_public_x[] = {
/* QCAVSx */
	0x06, 0x7a, 0xfd, 0xf7, 0x88, 0xf8, 0xf4, 0x83, 0x1c, 0x3c, 0x7d, 0x76,
	0x04, 0xd0, 0x7a, 0x5b, 0xdc, 0x59, 0xda, 0x42, 0xd9, 0x32, 0x73, 0x1f,
	0xaf, 0x5e, 0xaf, 0x07, 0x53, 0x28, 0x09, 0x66, 0xab, 0x69, 0x37, 0x90
};
static const uint8_t nist_kas_ecc_cdh_testvector_313_public_y[] = {
/* QCAVSy */
	0x00, 0x1b, 0x39, 0xd1, 0xd8, 0x72, 0xb6, 0x5e, 0x31, 0x25, 0x1c, 0x1f,
	0x58, 0x4e, 0x4f, 0xe3, 0xed, 0x75, 0xd5, 0x3a, 0xd9, 0x0e, 0x83, 0x6f,
	0xe9, 0x0c, 0x8d, 0xb9, 0x4f, 0xe7, 0x7c, 0xef, 0x0b, 0xca, 0x72, 0x04
};
static const uint8_t nist_kas_ecc_cdh_testvector_313_private[] = {
/* dIUT */
	0x01, 0x5e, 0xa8, 0x56, 0x7c, 0x7b, 0x82, 0xb4, 0x83, 0xfa, 0x36, 0x5e,
	0x8e, 0x68, 0x1c, 0x0a, 0x63, 0x5f, 0x56, 0x3a, 0x1c, 0x81, 0x47, 0x0b,
	0x4d, 0xfe, 0x44, 0xf1, 0x94, 0xfa, 0x91, 0xeb, 0x78, 0x42, 0x18, 0x1e
};
/* QIUTx = 07afe2b22b54fe895c242c20c054989fa804e591970dda8a7ce109d6bd31b6daa8f2fc74 */
/* QIUTy = 060733bd5a4ea9b5ea7090acfee918106b7f25272f3f7cb36eda38bacd21375610cde928 */
static const uint8_t nist_kas_ecc_cdh_testvector_313_out[] = {
/* ZIUT */
	0x00, 0x5e, 0x33, 0x1a, 0xf5, 0x5e, 0x96, 0x15, 0x3d, 0x8a, 0x7b, 0x90,
	0x6a, 0x4a, 0x19, 0x01, 0x6a, 0x26, 0x38, 0x19, 0x77, 0xb4, 0x9f, 0x80,
	0xb9, 0xd7, 0x0d, 0xb0, 0x99, 0x05, 0x3c, 0x6a, 0x3b, 0x8e, 0x80, 0xd5
};
/* COUNT = 13 */
static const uint8_t nist_kas_ecc_cdh_testvector_314_public_x[] = {
/* QCAVSx */
	0x01, 0x88, 0x66, 0xa4, 0xfa, 0x2f, 0x7c, 0x25, 0x34, 0xe5, 0x63, 0xa2,
	0x91, 0xde, 0x87, 0x1a, 0x8b, 0x30, 0x52, 0xa6, 0x74, 0xf5, 0xdb, 0xc2,
	0x3b, 0x9d, 0xea, 0x0e, 0x8c, 0xef, 0xda, 0x06, 0xab, 0xc3, 0x2c, 0x8f
};
static const uint8_t nist_kas_ecc_cdh_testvector_314_public_y[] = {
/* QCAVSy */
	0x05, 0x8d, 0xc4, 0xcf, 0x1b, 0xf9, 0x85, 0xd1, 0xb5, 0x66, 0x97, 0x08,
	0x47, 0xcb, 0xa6, 0xb8, 0xa4, 0xf4, 0x0c, 0x7e, 0x62, 0xa5, 0x80, 0x8b,
	0x07, 0x20, 0xbb, 0xb8, 0xcd, 0xf3, 0xb4, 0x53, 0x1e, 0x38, 0x0b, 0xe7
};
static const uint8_t nist_kas_ecc_cdh_testvector_314_private[] = {
/* dIUT */
	0x00, 0x29, 0x11, 0xd9, 0x38, 0xd9, 0x50, 0x8a, 0xec, 0xcb, 0x98, 0x77,
	0xe1, 0x27, 0xd1, 0xb1, 0x46, 0x1a, 0xcd, 0xae, 0xd0, 0x35, 0xf2, 0x0e,
	0x0f, 0x74, 0x4c, 0x77, 0x4f, 0x1c, 0x72, 0x70, 0x3b, 0x5c, 0x4b, 0x49
};
/* QIUTx = 0386bfdfe60373be114b417c4dceb443223fde67c0fef29ed0f867b5a15f5ea0ccb4dcca */
/* QIUTy = 02fac38ec8494cf7576233ec8282de384b67f0ca8048084201039d194c8bda4f6e0aff3e */
static const uint8_t nist_kas_ecc_cdh_testvector_314_out[] = {
/* ZIUT */
	0x07, 0xe1, 0x32, 0xea, 0x71, 0xa1, 0x6c, 0x7c, 0xc2, 0x61, 0xb9, 0xd6,
	0xff, 0x6f, 0xc5, 0x2c, 0xc4, 0x90, 0xda, 0x61, 0x6b, 0x07, 0xd9, 0x2f,
	0x9e, 0x59, 0x1f, 0xc1, 0xe6, 0x30, 0xd3, 0x44, 0x25, 0x72, 0x33, 0x8f
};
/* COUNT = 14 */
static const uint8_t nist_kas_ecc_cdh_testvector_315_public_x[] = {
/* QCAVSx */
	0x00, 0x05, 0x71, 0xd7, 0xbe, 0xf0, 0x56, 0x08, 0x91, 0x72, 0xf1, 0x34,
	0x23, 0xa5, 0x85, 0xab, 0x97, 0x9f, 0x4b, 0x8f, 0x77, 0xe7, 0x52, 0xc0,
	0x42, 0xc0, 0xc6, 0x52, 0x63, 0xb4, 0x76, 0x98, 0x1e, 0x5f, 0x31, 0x57
};
static const uint8_t nist_kas_ecc_cdh_testvector_315_public_y[] = {
/* QCAVSy */
	0x04, 0x4b, 0xca, 0x69, 0x3e, 0x9d, 0x3b, 0x1a, 0x7f, 0xa6, 0xad, 0x42,
	0xdb, 0x7f, 0x36, 0xb1, 0xa6, 0x57, 0x12, 0xd0, 0x9e, 0xf3, 0xbb, 0x71,
	0x5e, 0x26, 0x40, 0xa1, 0x82, 0xf4, 0x36, 0x62, 0x06, 0x86, 0xc0, 0xa4
};
static const uint8_t nist_kas_ecc_cdh_testvector_315_private[] = {
/* dIUT */
	0x01, 0x66, 0x2f, 0x55, 0x48, 0x56, 0xc0, 0x20, 0x8a, 0x31, 0xb1, 0x95,
	0x14, 0x8f, 0x82, 0x8e, 0x0b, 0x5c, 0x92, 0xa4, 0xea, 0x4c, 0x03, 0x32,
	0x48, 0xbe, 0xbf, 0x95, 0x7b, 0x58, 0x6b, 0x40, 0x9e, 0xd5, 0x98, 0x50
};
/* QIUTx = 07055264c3de3a622d26fe7ad700bdea045d4b3ce718f4e6ae44cf376c3a96a2650b3221 */
/* QIUTy = 00f45cc1138668adc8150d37c072bb4245660c18785683c7b17aa1fb8591ba6cda23657a */
static const uint8_t nist_kas_ecc_cdh_testvector_315_out[] = {
/* ZIUT */
	0x01, 0x0f, 0x26, 0x81, 0x70, 0x98, 0xce, 0x1b, 0xbd, 0x67, 0x43, 0x78,
	0x4d, 0x6f, 0xb6, 0x5e, 0x60, 0x69, 0x9c, 0x14, 0x93, 0x3a, 0x2c, 0x8d,
	0x85, 0x40, 0x27, 0xaa, 0x58, 0xb5, 0x8d, 0xb9, 0xe6, 0x6a, 0x53, 0xa7
};
/* COUNT = 15 */
static const uint8_t nist_kas_ecc_cdh_testvector_316_public_x[] = {
/* QCAVSx */
	0x01, 0x6e, 0xb4, 0xbb, 0xb3, 0xc3, 0x86, 0xe0, 0xf4, 0x2f, 0xb0, 0x37,
	0xbe, 0xe4, 0x78, 0xc4, 0xc0, 0xdb, 0xfb, 0xe5, 0x5c, 0xc6, 0x8e, 0x33,
	0xfd, 0xb0, 0x29, 0xb9, 0xe5, 0xe7, 0x24, 0xaf, 0xf4, 0xfd, 0x8b, 0xf6
};
static const uint8_t nist_kas_ecc_cdh_testvector_316_public_y[] = {
/* QCAVSy */
	0x02, 0x51, 0x43, 0x2f, 0x84, 0x56, 0x8a, 0x44, 0x97, 0x1e, 0x86, 0xab,
	0x71, 0x5d, 0x38, 0x79, 0xe6, 0x14, 0xe1, 0x07, 0x25, 0x73, 0x5e, 0xf8,
	0xfb, 0x66, 0x52, 0xd0, 0x79, 0xc7, 0x90, 0x8f, 0x11, 0xbd, 0x1f, 0x01
};
static const uint8_t nist_kas_ecc_cdh_testvector_316_private[] = {
/* dIUT */
	0x01, 0x2c, 0x01, 0x00, 0xa9, 0x96, 0x3e, 0xe1, 0x7d, 0x7a, 0xcf, 0x4d,
	0xdf, 0x8e, 0x02, 0xd8, 0xae, 0x75, 0xf3, 0xb9, 0x91, 0x14, 0xf5, 0x36,
	0x6a, 0xfb, 0x4a, 0x00, 0xad, 0xe9, 0xa3, 0xc0, 0xee, 0x39, 0xa8, 0x87
};
/* QIUTx = 07794fa19c6b10d399e0f52d36f483c7851848e62bacf95b5af51eca09ad445ee19ef34d */
/* QIUTy = 06140d2ee16cd0a6cb1960509a7ccc664be97644a95ae16f4a173d9a867015f0837f0560 */
static const uint8_t nist_kas_ecc_cdh_testvector_316_out[] = {
/* ZIUT */
	0x00, 0xbd, 0xd8, 0xcc, 0xd1, 0xb4, 0x0c, 0x5b, 0xc2, 0xef, 0xc1, 0xc1,
	0x05, 0x99, 0x93, 0x50, 0xfe, 0xfa, 0xf7, 0x84, 0x71, 0x09, 0x14, 0xff,
	0x63, 0x95, 0x82, 0xf1, 0x27, 0x76, 0x78, 0x69, 0x94, 0x91, 0x14, 0x0c
};
/* COUNT = 16 */
static const uint8_t nist_kas_ecc_cdh_testvector_317_public_x[] = {
/* QCAVSx */
	0x02, 0x41, 0x7c, 0x65, 0x69, 0x4d, 0x85, 0x0c, 0x7c, 0x86, 0x6f, 0x7e,
	0x11, 0x63, 0x9a, 0x5f, 0x87, 0x18, 0xca, 0x9a, 0xab, 0xb3, 0x92, 0xfa,
	0x86, 0x10, 0xe2, 0xd5, 0xd7, 0xdd, 0xa3, 0x37, 0x5a, 0x60, 0x7f, 0x9b
};
static const uint8_t nist_kas_ecc_cdh_testvector_317_public_y[] = {
/* QCAVSy */
	0x05, 0x13, 0x39, 0x38, 0xdc, 0x99, 0x14, 0x4d, 0x16, 0xea, 0x75, 0x25,
	0xc3, 0xfe, 0x4e, 0x32, 0xe3, 0x20, 0xed, 0x07, 0x5b, 0x96, 0x52, 0x7e,
	0x13, 0xb2, 0xa9, 0x9c, 0x9f, 0x27, 0xad, 0xe9, 0xef, 0x9e, 0xdc, 0xb6
};
static const uint8_t nist_kas_ecc_cdh_testvector_317_private[] = {
/* dIUT */
	0x03, 0x45, 0xc2, 0x76, 0xb0, 0x5e, 0xce, 0x9e, 0x7c, 0x86, 0x81, 0x1f,
	0x8c, 0x8a, 0xf4, 0x8b, 0x22, 0xdb, 0x41, 0xd4, 0x06, 0x62, 0x75, 0x00,
	0x96, 0x11, 0xb8, 0x80, 0xd7, 0xd2, 0xce, 0xf3, 0x29, 0xc5, 0x0e, 0x82
};
/* QIUTx = 007afffcfa31c110aab3bb394530a41c416af566bfba8f159f984437e799dddaaf8cdfd2 */
/* QIUTy = 065fb3c68446a74068bab7e36ab80e984707e39a4a143f5a46d646342f9f12f26a32291b */
static const uint8_t nist_kas_ecc_cdh_testvector_317_out[] = {
/* ZIUT */
	0x01, 0x4a, 0x83, 0xe7, 0x47, 0xc9, 0x0a, 0xec, 0x61, 0x01, 0xc0, 0xa7,
	0x52, 0xd9, 0x2e, 0xef, 0x74, 0x75, 0xb0, 0x00, 0x51, 0xec, 0xad, 0x3d,
	0x7c, 0x2e, 0x50, 0xcf, 0x4e, 0xba, 0x1e, 0xf3, 0xc8, 0x0b, 0x8c, 0x94
};
/* COUNT = 17 */
static const uint8_t nist_kas_ecc_cdh_testvector_318_public_x[] = {
/* QCAVSx */
	0x00, 0xc5, 0xd6, 0x14, 0x9f, 0x87, 0x17, 0x4b, 0xa3, 0x7f, 0x4c, 0x1c,
	0x6f, 0x67, 0xf6, 0x90, 0x5a, 0xbb, 0x31, 0x9f, 0x52, 0x6b, 0x7a, 0xa1,
	0xbe, 0x1d, 0xd2, 0x05, 0xdf, 0x93, 0x0a, 0xb1, 0xc9, 0x1b, 0xb1, 0xf8
};
static const uint8_t nist_kas_ecc_cdh_testvector_318_public_y[] = {
/* QCAVSy */
	0x00, 0xc2, 0xe2, 0x1e, 0x12, 0x06, 0xcd, 0x4b, 0xb5, 0xb6, 0x22, 0xab,
	0xe9, 0x7c, 0xa3, 0xf2, 0x52, 0xcb, 0xc6, 0x8d, 0x05, 0x4a, 0x77, 0xf8,
	0xeb, 0xab, 0xad, 0x59, 0x3f, 0xb1, 0x86, 0x33, 0x06, 0x92, 0x8b, 0xf7
};
static const uint8_t nist_kas_ecc_cdh_testvector_318_private[] = {
/* dIUT */
	0x03, 0xaf, 0xd5, 0xaf, 0xfa, 0x34, 0x6b, 0x52, 0x59, 0x69, 0x7d, 0x92,
	0x17, 0x95, 0x2a, 0xfc, 0xd0, 0x3d, 0xdf, 0xec, 0x04, 0x63, 0x1b, 0xd9,
	0x95, 0xc1, 0x0a, 0xc2, 0x58, 0x3b, 0x0c, 0xa8, 0xd2, 0x46, 0x1f, 0x5d
};
/* QIUTx = 06b4c2c3615b266543de189c896cff77b5557c782c215961ac7324185fc9a81098f2ebea */
/* QIUTy = 047fef1960739ae0aee39a3ffdb82e890d4236fc22dad395d490bc3a5eea58e8cd03edbb */
static const uint8_t nist_kas_ecc_cdh_testvector_318_out[] = {
/* ZIUT */
	0x00, 0xaf, 0xd2, 0x9e, 0x35, 0x27, 0x79, 0xa3, 0x90, 0x21, 0x53, 0x6e,
	0xa5, 0x0c, 0x24, 0xfa, 0x26, 0x4c, 0x59, 0x9f, 0x8f, 0x8f, 0xe8, 0xf2,
	0xcc, 0xf0, 0x61, 0x5a, 0x65, 0x47, 0xa0, 0x64, 0xd7, 0xc1, 0xa1, 0x50
};
/* COUNT = 18 */
static const uint8_t nist_kas_ecc_cdh_testvector_319_public_x[] = {
/* QCAVSx */
	0x01, 0x73, 0x04, 0x4e, 0x5b, 0xe6, 0x39, 0x97, 0xd7, 0x92, 0x5e, 0x43,
	0x1b, 0xbf, 0x00, 0x4c, 0xf0, 0xf0, 0xba, 0x85, 0xaa, 0x29, 0x5a, 0x34,
	0x1e, 0x8f, 0x58, 0x57, 0xa1, 0x20, 0xbe, 0x89, 0xd7, 0x76, 0x53, 0xe9
};
static const uint8_t nist_kas_ecc_cdh_testvector_319_public_y[] = {
/* QCAVSy */
	0x07, 0x37, 0xcc, 0x04, 0x96, 0x90, 0xf9, 0x70, 0x82, 0x4a, 0x7b, 0x0c,
	0x20, 0x22, 0x43, 0x96, 0x82, 0xc9, 0xd8, 0x2f, 0x4f, 0x23, 0xe4, 0x8e,
	0x5f, 0x07, 0xfe, 0xa9, 0x62, 0x67, 0xca, 0x3b, 0xd4, 0xd7, 0x30, 0xa5
};
static const uint8_t nist_kas_ecc_cdh_testvector_319_private[] = {
/* dIUT */
	0x03, 0xd5, 0x77, 0x1f, 0x84, 0x85, 0xc3, 0xb8, 0xbe, 0x62, 0xa5, 0x6f,
	0x39, 0x36, 0x51, 0x3e, 0x3b, 0x63, 0x1a, 0x56, 0x1a, 0x94, 0x26, 0x13,
	0xdf, 0x95, 0x14, 0x0f, 0x47, 0x32, 0x14, 0xdf, 0x61, 0x7c, 0x4c, 0x4e
};
/* QIUTx = 05906cc4529b220228efbb0545bf55ec03c86f87e2f4e3a3cbf404e07b73a5b1a5f528cd */
/* QIUTy = 016588e480c4856cd2ee9aaf1e302812fbc0b33f527c29b77ce0f4878ea089d025a440c0 */
static const uint8_t nist_kas_ecc_cdh_testvector_319_out[] = {
/* ZIUT */
	0x04, 0x77, 0x99, 0x0f, 0x17, 0xd6, 0x55, 0x89, 0x28, 0x9c, 0x28, 0xe5,
	0x4a, 0x56, 0xa8, 0x3b, 0xc0, 0x5e, 0xf4, 0xea, 0x68, 0x63, 0xc5, 0xeb,
	0xe8, 0x40, 0x92, 0x5c, 0x9f, 0xbe, 0xf6, 0x4c, 0xcd, 0x6e, 0x69, 0xa4
};
/* COUNT = 19 */
static const uint8_t nist_kas_ecc_cdh_testvector_320_public_x[] = {
/* QCAVSx */
	0x06, 0x85, 0x87, 0xe6, 0x9d, 0xed, 0xdf, 0x4b, 0x55, 0xac, 0x51, 0xf2,
	0xa1, 0x7d, 0xd8, 0xbf, 0xd6, 0xf9, 0x4e, 0x72, 0x10, 0x03, 0x21, 0x42,
	0x15, 0xbf, 0xb2, 0x4b, 0x24, 0x82, 0x81, 0xe7, 0x5a, 0x3c, 0x65, 0x94
};
static const uint8_t nist_kas_ecc_cdh_testvector_320_public_y[] = {
/* QCAVSy */
	0x04, 0x4e, 0xee, 0x9c, 0x70, 0x2b, 0xc4, 0xc1, 0xe2, 0x10, 0xc7, 0xcc,
	0x21, 0x45, 0x24, 0x59, 0x25, 0x68, 0xac, 0x0f, 0x9f, 0xd6, 0x7d, 0x6e,
	0xa0, 0x2b, 0x4d, 0xc3, 0xef, 0xb4, 0x2c, 0xfb, 0xb2, 0x26, 0x3d, 0xac
};
static const uint8_t nist_kas_ecc_cdh_testvector_320_private[] = {
/* dIUT */
	0x00, 0xe2, 0xc0, 0xc6, 0x02, 0xfb, 0x13, 0x23, 0x99, 0xee, 0x9f, 0x31,
	0x00, 0x83, 0x65, 0xea, 0x22, 0xcc, 0x12, 0x60, 0xf7, 0x9f, 0xe3, 0xae,
	0x61, 0x08, 0x9b, 0x8a, 0x6f, 0xa4, 0x55, 0x9c, 0xac, 0x91, 0xae, 0xc8
};
/* QIUTx = 06e6e318c0c4c0b661dfd3e722090ecd32fdc9ca3d168d9c7174c1d40adbb2ce672d9252 */
/* QIUTy = 040bdc1dbc7b163f7c9551f47daa8294ac2dc4fe0d472c4e2f2cfefc95d523ff59e0e880 */
static const uint8_t nist_kas_ecc_cdh_testvector_320_out[] = {
/* ZIUT */
	0x06, 0x7a, 0x66, 0x13, 0x46, 0xfe, 0x05, 0x2c, 0xa2, 0x7f, 0x3f, 0x03,
	0xe7, 0x5b, 0xbd, 0xfc, 0x8f, 0xe6, 0xd0, 0xd8, 0x5c, 0x62, 0xc8, 0xf7,
	0x95, 0x25, 0x25, 0x2a, 0xa2, 0x41, 0xae, 0x9d, 0xe9, 0x7d, 0x56, 0xc3
};
/* COUNT = 20 */
static const uint8_t nist_kas_ecc_cdh_testvector_321_public_x[] = {
/* QCAVSx */
	0x03, 0xf1, 0x22, 0x6d, 0x80, 0x2c, 0x57, 0x5f, 0x87, 0x1a, 0x21, 0x3b,
	0x81, 0x50, 0xf7, 0x81, 0x8b, 0xbd, 0x62, 0x56, 0x63, 0xb7, 0x3e, 0x72,
	0x0a, 0x73, 0x7f, 0x07, 0x18, 0x96, 0x08, 0x6d, 0xa0, 0xb1, 0x4c, 0xd9
};
static const uint8_t nist_kas_ecc_cdh_testvector_321_public_y[] = {
/* QCAVSy */
	0x07, 0xd1, 0xcb, 0x0c, 0xe1, 0x9c, 0x98, 0xa6, 0x3a, 0xaf, 0x7b, 0x31,
	0x4f, 0x1f, 0x57, 0x20, 0xe3, 0x28, 0x87, 0x05, 0x33, 0x84, 0xac, 0x0f,
	0x5e, 0xb6, 0x9b, 0x6c, 0x47, 0x1a, 0x8e, 0x3d, 0x3d, 0x16, 0xe7, 0x6f
};
static const uint8_t nist_kas_ecc_cdh_testvector_321_private[] = {
/* dIUT */
	0x03, 0x2d, 0x57, 0x3f, 0xde, 0xb8, 0x5a, 0x4d, 0xa2, 0x29, 0x78, 0x96,
	0x63, 0x14, 0x14, 0x51, 0x8d, 0x4b, 0xa0, 0x7d, 0xc4, 0xdd, 0x72, 0xf7,
	0x31, 0x72, 0x88, 0x90, 0xd0, 0xb4, 0x4d, 0x36, 0xf2, 0x30, 0x9c, 0x0e
};
/* QIUTx = 06f6ffea0a87bd9eeb539c48a3fcbf388159862259c7f7840e64809fbedb01a83812c0c6 */
/* QIUTy = 07c795b8f2847fc39fa56c2de1e6cbbf4945087cb2e3b919dc776b4cc1c83e4b1c79b8ba */
static const uint8_t nist_kas_ecc_cdh_testvector_321_out[] = {
/* ZIUT */
	0x06, 0x47, 0x6b, 0x06, 0x20, 0xee, 0xf1, 0x65, 0x94, 0x1a, 0x45, 0x07,
	0xe6, 0xd7, 0x98, 0xd6, 0xf1, 0x50, 0xab, 0x29, 0x33, 0x3c, 0x05, 0x52,
	0x28, 0x1b, 0x62, 0x91, 0x70, 0xd3, 0x29, 0x1b, 0x2f, 0x9b, 0x3f, 0x41
};
/* COUNT = 21 */
static const uint8_t nist_kas_ecc_cdh_testvector_322_public_x[] = {
/* QCAVSx */
	0x02, 0xa9, 0x11, 0xe7, 0xe6, 0xd2, 0xfc, 0x77, 0x0d, 0x1e, 0xab, 0xc7,
	0xdf, 0x70, 0x1b, 0xb1, 0x19, 0x08, 0x4a, 0x68, 0x59, 0x00, 0xd2, 0x2d,
	0x52, 0xd5, 0x98, 0xfe, 0x1d, 0x28, 0xfc, 0x89, 0x1b, 0x31, 0xb4, 0x87
};
static const uint8_t nist_kas_ecc_cdh_testvector_322_public_y[] = {
/* QCAVSy */
	0x01, 0xb8, 0xdc, 0x67, 0x13, 0xca, 0x45, 0x3e, 0x91, 0xb2, 0xec, 0x4e,
	0x4d, 0x1f, 0x83, 0x4b, 0x08, 0xee, 0xbc, 0x7e, 0x88, 0x86, 0xc3, 0xa4,
	0x58, 0xe7, 0x09, 0x25, 0x24, 0x2c, 0x4b, 0x22, 0xbf, 0x0b, 0x20, 0x53
};
static const uint8_t nist_kas_ecc_cdh_testvector_322_private[] = {
/* dIUT */
	0x00, 0xa6, 0xaa, 0xcb, 0x5d, 0xd3, 0xe8, 0x35, 0x81, 0x4f, 0x45, 0x2d,
	0x82, 0x07, 0xd1, 0x5a, 0x53, 0x36, 0x38, 0xf7, 0x0e, 0x94, 0xf8, 0x7c,
	0x06, 0x19, 0x6e, 0xff, 0x88, 0x38, 0xd4, 0x8e, 0xed, 0x2e, 0x26, 0x74
};
/* QIUTx = 02dd0093a8d419831f34bac6c60a570c51d08e699b181c964b667d0d17ed72a49119acd9 */
/* QIUTy = 01a91976be5d5e037f22350d67ab7bfab51bbc4fa6026d347d28fb4407bccc40dd10a00e */
static const uint8_t nist_kas_ecc_cdh_testvector_322_out[] = {
/* ZIUT */
	0x07, 0x46, 0x71, 0x9f, 0x2a, 0xd0, 0x8f, 0x8a, 0x8d, 0x6d, 0x6f, 0xbf,
	0x15, 0x72, 0x3f, 0x33, 0x62, 0x85, 0xce, 0x75, 0xd3, 0xa2, 0xfc, 0xbd,
	0x5a, 0x0c, 0x54, 0xc5, 0x77, 0x51, 0x7a, 0x22, 0xbc, 0x26, 0x41, 0x61
};
/* COUNT = 22 */
static const uint8_t nist_kas_ecc_cdh_testvector_323_public_x[] = {
/* QCAVSx */
	0x07, 0x54, 0x1a, 0xa5, 0x1d, 0x73, 0x02, 0xe2, 0xbb, 0x55, 0x7c, 0x27,
	0xec, 0x15, 0xd7, 0xf9, 0xc3, 0xae, 0x3b, 0x76, 0xec, 0x2f, 0x86, 0xcb,
	0x95, 0xe8, 0xde, 0xad, 0x7f, 0xa0, 0x6b, 0x57, 0x83, 0x97, 0xf1, 0xf1
};
static const uint8_t nist_kas_ecc_cdh_testvector_323_public_y[] = {
/* QCAVSy */
	0x01, 0x7e, 0xa2, 0x2f, 0x6b, 0x54, 0x74, 0xf0, 0xf5, 0xf0, 0xf4, 0xea,
	0xd5, 0x41, 0x72, 0x06, 0x40, 0x51, 0x53, 0x8d, 0x3e, 0x23, 0x2a, 0x53,
	0x0d, 0xfc, 0xa5, 0xf2, 0xa0, 0xdc, 0x67, 0x74, 0x6c, 0x8b, 0xb1, 0xda
};
static const uint8_t nist_kas_ecc_cdh_testvector_323_private[] = {
/* dIUT */
	0x00, 0x11, 0x2f, 0xb2, 0xab, 0x56, 0x44, 0x37, 0x65, 0x67, 0x6a, 0x1e,
	0x41, 0xb3, 0xcb, 0x91, 0xeb, 0x1a, 0x67, 0x90, 0xe9, 0x64, 0xee, 0x90,
	0x0c, 0xfc, 0x92, 0x95, 0x63, 0x6b, 0xa4, 0xc6, 0xfa, 0x87, 0xaa, 0xd2
};
/* QIUTx = 03f507d99cc2498e2c7f54fb3c9c032f382548e2e3168fa140125a526048568f3bb3e5a1 */
/* QIUTy = 05270df77efc7d6c55f9259bc82273c9b6bdf3676e13c3601b1b3022b962de1129cb3b14 */
static const uint8_t nist_kas_ecc_cdh_testvector_323_out[] = {
/* ZIUT */
	0x03, 0xcd, 0xa4, 0xb5, 0xf4, 0x4b, 0x5d, 0x3d, 0xc2, 0x48, 0x31, 0x0f,
	0x99, 0x44, 0x19, 0xfb, 0xcb, 0xd6, 0x65, 0x11, 0x5d, 0x18, 0x76, 0x04,
	0x66, 0x52, 0x25, 0x1a, 0xd4, 0xae, 0xeb, 0x1d, 0xcf, 0x18, 0x42, 0x88
};
/* COUNT = 23 */
static const uint8_t nist_kas_ecc_cdh_testvector_324_public_x[] = {
/* QCAVSx */
	0x02, 0x1f, 0xb1, 0x4e, 0x52, 0xcd, 0x42, 0x43, 0xa5, 0x20, 0xf6, 0x30,
	0x22, 0x9b, 0x1d, 0xd6, 0x96, 0x1c, 0x49, 0xbd, 0x96, 0xf4, 0x3f, 0xa9,
	0xca, 0xe3, 0x7a, 0xdd, 0x84, 0xda, 0x7a, 0xe7, 0x2d, 0xc3, 0x07, 0x8e
};
static const uint8_t nist_kas_ecc_cdh_testvector_324_public_y[] = {
/* QCAVSy */
	0x00, 0xdd, 0x63, 0x8b, 0xf9, 0x05, 0x3f, 0xad, 0x6a, 0xa4, 0xff, 0x2d,
	0x33, 0x0b, 0x8a, 0x4a, 0x20, 0xbf, 0xe3, 0x02, 0x0f, 0x40, 0xb9, 0x69,
	0x23, 0x02, 0xd0, 0xb0, 0xa3, 0xc2, 0xd8, 0x77, 0x85, 0x6e, 0xc4, 0x6a
};
static const uint8_t nist_kas_ecc_cdh_testvector_324_private[] = {
/* dIUT */
	0x03, 0xe4, 0xf1, 0xc4, 0xf3, 0x0e, 0x2a, 0x8d, 0x6f, 0xd5, 0x59, 0xf7,
	0xfe, 0x88, 0x20, 0xe8, 0x86, 0x94, 0x9d, 0xe8, 0x7c, 0x01, 0xd8, 0xeb,
	0x64, 0xc7, 0xb4, 0x0f, 0x15, 0x48, 0xcb, 0x61, 0x7a, 0x92, 0x60, 0x33
};
/* QIUTx = 05e3fc56ec162885c1291e4ae9c19c8eb2bb559eb7ecd5817549b5a2ea3a66d951880aa6 */
/* QIUTy = 04c004f2ae4db4f748b437bc115e06ea2017a87798298dd6004616fcffdcc7ec2dfd6db9 */
static const uint8_t nist_kas_ecc_cdh_testvector_324_out[] = {
/* ZIUT */
	0x01, 0x5c, 0x89, 0x2f, 0x95, 0x76, 0x8a, 0x96, 0xab, 0x5a, 0x4f, 0x95,
	0x23, 0xb7, 0xfd, 0x46, 0x6e, 0x10, 0x1f, 0x63, 0xb8, 0x8a, 0xd8, 0xf1,
	0xfe, 0xcb, 0x30, 0x27, 0xcd, 0x70, 0xaa, 0x00, 0x73, 0x5d, 0xcc, 0x90
};
/* COUNT = 24 */
static const uint8_t nist_kas_ecc_cdh_testvector_325_public_x[] = {
/* QCAVSx */
	0x00, 0xd0, 0x8e, 0xd3, 0x85, 0x6a, 0xbe, 0xf7, 0xd4, 0xa6, 0x22, 0x43,
	0xc9, 0x2d, 0x6e, 0x67, 0x0c, 0xeb, 0x3a, 0xf3, 0x23, 0x57, 0xfd, 0xb9,
	0xd3, 0x9c, 0x19, 0x17, 0x5a, 0x10, 0xd1, 0xcb, 0xab, 0x36, 0xce, 0x78
};
static const uint8_t nist_kas_ecc_cdh_testvector_325_public_y[] = {
/* QCAVSy */
	0x05, 0xdb, 0x9f, 0xad, 0x7f, 0xc8, 0xaf, 0xe7, 0x9c, 0x8b, 0x9c, 0xe4,
	0x8e, 0x62, 0xff, 0xa0, 0xd4, 0x6b, 0x80, 0x5a, 0x9e, 0x58, 0x21, 0xe2,
	0x76, 0x1c, 0x25, 0xc0, 0xed, 0xba, 0x92, 0xb1, 0x20, 0xb0, 0x63, 0xf2
};
static const uint8_t nist_kas_ecc_cdh_testvector_325_private[] = {
/* dIUT */
	0x00, 0xae, 0x7e, 0xb3, 0xd4, 0x03, 0x54, 0xf9, 0xf8, 0xfe, 0xd1, 0x8f,
	0x21, 0x62, 0xde, 0xe3, 0x81, 0x56, 0xca, 0xe0, 0x53, 0x5b, 0x55, 0x37,
	0x0d, 0xa3, 0x63, 0x8f, 0x01, 0x66, 0x8a, 0xec, 0xf9, 0x70, 0x8b, 0xe6
};
/* QIUTx = 061e8858e368d9c917f129d932ddc4cca521ff419f1d74230e8aa5b1b3e9ce67f41c4b4c */
/* QIUTy = 02b0d7fbdc636a3bc34bbdd2a89291b567b0fb2af32383868bd40d4ba4cac9880c2540b8 */
static const uint8_t nist_kas_ecc_cdh_testvector_325_out[] = {
/* ZIUT */
	0x01, 0xad, 0xf5, 0xa9, 0x63, 0x58, 0xe1, 0x8d, 0x69, 0xfd, 0x38, 0x3b,
	0x4d, 0xc7, 0xb2, 0x0d, 0xd6, 0x46, 0xb6, 0x8a, 0x5c, 0x9f, 0x14, 0x17,
	0xbc, 0xf4, 0x26, 0x24, 0x0c, 0xa2, 0x2b, 0x8f, 0x32, 0xbd, 0xf1, 0xa4
};
/* [B-409] - GP NOT SUPPORTED */
/* COUNT = 0 */
static const uint8_t nist_kas_ecc_cdh_testvector_326_public_x[] = {
/* QCAVSx */
	0x01, 0x46, 0x98, 0x9a, 0x50, 0x29, 0x7b, 0xe3, 0x73, 0xdd, 0x66, 0x5c,
	0x45, 0x45, 0x5a, 0x2a, 0xe4, 0xc2, 0x21, 0xda, 0x5c, 0xd4, 0x24, 0x00,
	0x7b, 0xd9, 0x7f, 0x9e, 0x8e, 0x84, 0x6f, 0x96, 0x74, 0x0f, 0x3f, 0xa5,
	0x8c, 0x3c, 0x94, 0x12, 0x96, 0x71, 0xcd, 0xd4, 0xd7, 0xea, 0x65, 0x0a,
	0x2a, 0xad, 0xe9, 0xd7
};
static const uint8_t nist_kas_ecc_cdh_testvector_326_public_y[] = {
/* QCAVSy */
	0x01, 0xb4, 0x2b, 0xff, 0xda, 0x84, 0x39, 0x46, 0xa1, 0x4a, 0xd6, 0x08,
	0x0f, 0x95, 0xb8, 0xfc, 0x6b, 0x7e, 0x17, 0x35, 0x28, 0xd0, 0x8e, 0xd3,
	0x6f, 0xe6, 0x40, 0xaa, 0xf8, 0x5a, 0xa0, 0x0f, 0xb5, 0xed, 0xd5, 0x90,
	0x5a, 0x38, 0xb3, 0xc7, 0x96, 0x1b, 0x77, 0x22, 0xb7, 0x7b, 0x8d, 0xcb,
	0x44, 0xbb, 0x25, 0xf5
};
static const uint8_t nist_kas_ecc_cdh_testvector_326_private[] = {
/* dIUT */
	0x00, 0xac, 0xe9, 0x21, 0x03, 0xff, 0xe2, 0x62, 0xac, 0x17, 0xad, 0x42,
	0xa4, 0x6d, 0x43, 0x66, 0xf4, 0xcb, 0x4c, 0x58, 0x0e, 0xff, 0x3a, 0xb1,
	0xdd, 0xe6, 0xbd, 0xdf, 0xdb, 0xb7, 0x37, 0x48, 0x11, 0xd5, 0x2b, 0x1f,
	0xa9, 0x93, 0x20, 0xb4, 0xaf, 0x5d, 0x4e, 0x92, 0x08, 0xc1, 0x4e, 0xb8,
	0xef, 0xa8, 0x91, 0x6c
};
/* QIUTx = 004ebc4d4acf9b404dabc3af3e8cbea8b88b32999d3ecb7f367b12eb3a6280b840038e22681637a7d16436e014f69616abf72e45 */
/* QIUTy = 009e24109541c8024217e9ab2c963fa9e373640095a6c25a26eefac58e4342c0c85448b2709592a12402fe2b68a793c558ce8cd6 */
static const uint8_t nist_kas_ecc_cdh_testvector_326_out[] = {
/* ZIUT */
	0x01, 0xd4, 0x8a, 0x58, 0x6b, 0xe9, 0x28, 0x5f, 0xa3, 0x8d, 0xd3, 0xe7,
	0x0b, 0x03, 0x30, 0xb0, 0xff, 0xeb, 0xd3, 0x27, 0xce, 0xef, 0xef, 0x88,
	0xfd, 0xc1, 0x52, 0x1e, 0xf2, 0xfd, 0x61, 0xcb, 0xc9, 0x12, 0x4e, 0x03,
	0xb0, 0xc9, 0x26, 0xe7, 0x0f, 0xa5, 0x6a, 0xcb, 0x3e, 0xdb, 0x54, 0xc3,
	0xc4, 0x8f, 0xab, 0x2b
};
/* COUNT = 1 */
static const uint8_t nist_kas_ecc_cdh_testvector_327_public_x[] = {
/* QCAVSx */
	0x01, 0x7e, 0x9f, 0x01, 0xb1, 0xd6, 0xe5, 0x70, 0x23, 0x28, 0x33, 0x0d,
	0x23, 0x2a, 0x1d, 0xd3, 0xf2, 0xc5, 0x92, 0xcc, 0x40, 0x9f, 0x6c, 0xae,
	0xf0, 0x70, 0x84, 0x40, 0x83, 0x7f, 0x35, 0x97, 0x51, 0x0f, 0x11, 0x19,
	0x54, 0xaa, 0x51, 0xe5, 0x64, 0x6c, 0xcf, 0x47, 0xef, 0xf1, 0xf0, 0x7a,
	0x4f, 0x8a, 0xe1, 0xcb
};
static const uint8_t nist_kas_ecc_cdh_testvector_327_public_y[] = {
/* QCAVSy */
	0x00, 0x37, 0x14, 0xf6, 0xea, 0x1f, 0xd1, 0x43, 0xce, 0x75, 0x1e, 0x2d,
	0x85, 0xba, 0xf5, 0x4c, 0x55, 0x23, 0x97, 0x61, 0x08, 0xed, 0x48, 0x2f,
	0xd6, 0xae, 0x10, 0x37, 0x43, 0x13, 0x1c, 0xa7, 0x16, 0x02, 0x6b, 0x16,
	0xa1, 0xe4, 0x96, 0x23, 0x1f, 0x99, 0x1c, 0xdc, 0x8f, 0x6d, 0xb4, 0x47,
	0xf5, 0xf9, 0x5f, 0x8e
};
static const uint8_t nist_kas_ecc_cdh_testvector_327_private[] = {
/* dIUT */
	0x00, 0x3f, 0xf2, 0x2f, 0x7d, 0x7c, 0x04, 0x99, 0x89, 0xa4, 0x3e, 0x0e,
	0xa3, 0xf5, 0xd6, 0x17, 0x98, 0x15, 0x9c, 0x17, 0x8a, 0xa7, 0x92, 0xd7,
	0x9d, 0x1f, 0xfe, 0xbf, 0xf8, 0xdb, 0x70, 0xee, 0x1f, 0xde, 0x04, 0x0a,
	0x4b, 0x5f, 0x1e, 0xd3, 0x3f, 0xb3, 0xff, 0x23, 0xc4, 0x4e, 0x7c, 0x6b,
	0x21, 0xb0, 0x62, 0x3b
};
/* QIUTx = 01d5c9260e73ea36e4deaaa4b8f4541f678066b690771a86f0dadc580fdb895981e6dd02dd264ed9f9c1763bd54a6052a2d3dba7 */
/* QIUTy = 011a706826365ece28e38b33620bca016d2d9338518dfd6868370476dacb41e3b947465769ebe81b620731673576f77451d0fe14 */
static const uint8_t nist_kas_ecc_cdh_testvector_327_out[] = {
/* ZIUT */
	0x01, 0x85, 0x6c, 0x92, 0xb4, 0x6d, 0x67, 0x1d, 0x8a, 0x7f, 0x6c, 0xc4,
	0x68, 0xef, 0xb6, 0x0a, 0x61, 0x09, 0x3d, 0x00, 0x6c, 0x95, 0xbb, 0x93,
	0x1c, 0x1f, 0xcc, 0xc3, 0x36, 0xd4, 0xa8, 0x49, 0x0f, 0xe1, 0x7f, 0xe1,
	0x63, 0xc9, 0x72, 0xba, 0xc3, 0x9f, 0xe7, 0x28, 0xf2, 0x45, 0x34, 0xa0,
	0xc3, 0x4d, 0x2d, 0x21
};
/* COUNT = 2 */
static const uint8_t nist_kas_ecc_cdh_testvector_328_public_x[] = {
/* QCAVSx */
	0x01, 0x83, 0xee, 0x35, 0x5a, 0x93, 0xcd, 0x13, 0xaf, 0xf1, 0x75, 0x6a,
	0x08, 0xe5, 0x8e, 0x21, 0x95, 0xa8, 0x26, 0x29, 0x8d, 0x43, 0xf6, 0xd0,
	0x7b, 0xb1, 0xc3, 0x82, 0xb4, 0xe5, 0x68, 0xd0, 0x08, 0x09, 0x39, 0x26,
	0x00, 0x09, 0xc6, 0xaf, 0xcb, 0xed, 0x0f, 0x23, 0x25, 0x2e, 0x01, 0xd6,
	0xd1, 0x4c, 0x6d, 0x8f
};
static const uint8_t nist_kas_ecc_cdh_testvector_328_public_y[] = {
/* QCAVSy */
	0x01, 0xb2, 0x30, 0x9b, 0x38, 0x19, 0xc2, 0x45, 0x4a, 0x48, 0xad, 0x25,
	0x3a, 0xc9, 0x7b, 0xce, 0x3c, 0x79, 0xb5, 0x1f, 0x50, 0xed, 0x68, 0x03,
	0xcf, 0x05, 0x46, 0x4b, 0x74, 0xa5, 0xa1, 0xde, 0x22, 0x11, 0x3e, 0x23,
	0xc0, 0x18, 0xc5, 0xce, 0xd9, 0x18, 0x6d, 0xdb, 0x98, 0x1c, 0x62, 0x9e,
	0x2e, 0x9d, 0xb3, 0xee
};
static const uint8_t nist_kas_ecc_cdh_testvector_328_private[] = {
/* dIUT */
	0x00, 0x96, 0xde, 0x2c, 0x39, 0x29, 0xc4, 0x08, 0x5f, 0x9c, 0xc1, 0xd3,
	0x77, 0x8c, 0x2d, 0xbf, 0x3d, 0xb7, 0xf0, 0xf7, 0x7e, 0x7b, 0xa7, 0xbb,
	0xc4, 0xe4, 0x08, 0xc7, 0xd6, 0x5e, 0x2c, 0x8b, 0x88, 0xb0, 0x75, 0x5f,
	0x16, 0x0b, 0xad, 0xb5, 0x24, 0xe7, 0x69, 0x7c, 0x50, 0xe6, 0x0c, 0x8d,
	0x99, 0xe5, 0x6d, 0xa4
};
/* QIUTx = 019c47d79914c8bdae754ec5ec1e81c8ff329a938e6971eee3c945c4ebf489e14b15e6135616c898c80b7b06b8af67061c769ab5 */
/* QIUTy = 000088022b4fb0e754ec4fab8cf4fc636255426755fa99b56805c15eac04325155dccbfa4145e161c40f189bdbaa3dd3e0c3d6c9 */
static const uint8_t nist_kas_ecc_cdh_testvector_328_out[] = {
/* ZIUT */
	0x01, 0x97, 0x2e, 0x22, 0x5e, 0x08, 0xb4, 0x75, 0x12, 0xe9, 0x2c, 0x0d,
	0xa9, 0xa1, 0xbd, 0xdd, 0xb1, 0x80, 0x2b, 0xe4, 0x02, 0x22, 0x2c, 0xac,
	0x57, 0x88, 0xb3, 0x22, 0xe1, 0x01, 0xfe, 0xeb, 0x06, 0xb6, 0x6b, 0x2f,
	0xe7, 0x26, 0xc1, 0xcd, 0x8a, 0xec, 0x92, 0xe0, 0x2f, 0x37, 0xd1, 0x5f,
	0x4c, 0x97, 0xe6, 0x4d
};
/* COUNT = 3 */
static const uint8_t nist_kas_ecc_cdh_testvector_329_public_x[] = {
/* QCAVSx */
	0x00, 0xe8, 0x5d, 0xe9, 0xd6, 0x3e, 0x34, 0xe5, 0xc7, 0xbb, 0xa6, 0xff,
	0x9b, 0x16, 0xf4, 0xc8, 0x4d, 0x95, 0xf1, 0x1d, 0xfe, 0x92, 0x10, 0x7b,
	0x1f, 0xbe, 0xca, 0xe9, 0x8c, 0xe6, 0xef, 0xf3, 0xdb, 0x96, 0xd8, 0x69,
	0x00, 0xbf, 0xd2, 0x2c, 0xd4, 0x23, 0xdb, 0xce, 0x1e, 0x57, 0x26, 0xbe,
	0x8e, 0x59, 0x79, 0x33
};
static const uint8_t nist_kas_ecc_cdh_testvector_329_public_y[] = {
/* QCAVSy */
	0x00, 0xb7, 0x14, 0x17, 0x71, 0xf7, 0xc8, 0x16, 0xd5, 0x5e, 0xc8, 0xc5,
	0x38, 0x22, 0xd2, 0xe7, 0xa1, 0x92, 0xfa, 0x54, 0xa1, 0x7e, 0x5b, 0x99,
	0xb2, 0xd9, 0x09, 0x61, 0xb5, 0x4a, 0x99, 0xfe, 0xd5, 0x3a, 0xba, 0x4b,
	0xda, 0x1a, 0x40, 0x74, 0xad, 0x3d, 0x23, 0xf9, 0xc9, 0x11, 0x20, 0x57,
	0x95, 0xb5, 0x45, 0x0b
};
static const uint8_t nist_kas_ecc_cdh_testvector_329_private[] = {
/* dIUT */
	0x00, 0xab, 0xd5, 0xd6, 0x1c, 0xde, 0x31, 0x18, 0x03, 0x01, 0xc2, 0x69,
	0xd5, 0x2a, 0xf8, 0x56, 0xba, 0xa3, 0x9b, 0x89, 0xf5, 0xef, 0x45, 0x36,
	0x7f, 0x55, 0x19, 0x21, 0x0c, 0x71, 0xd7, 0x7b, 0x31, 0x8d, 0x05, 0x3e,
	0xc0, 0xc2, 0xf4, 0x9b, 0xf4, 0x6d, 0xe0, 0x5c, 0xab, 0xf2, 0x3c, 0x7d,
	0x2b, 0xd7, 0xd2, 0x3f
};
/* QIUTx = 01a7ef3d17c301e8661ba66c1cdee82a9b44d716909e3663b423dc06ef6be4f616cd179321ce7a572da4bca2e89b768edc8459b3 */
/* QIUTy = 00df743849a20bc3026062b420d3942f18e2d6c5307e6e1955e33b09d5951dc59b31a2b1d58c233e2c896e2d9ccaa8eeb8e8f113 */
static const uint8_t nist_kas_ecc_cdh_testvector_329_out[] = {
/* ZIUT */
	0x00, 0xb6, 0x66, 0x1a, 0x86, 0x6a, 0xbb, 0xf1, 0x84, 0x3d, 0xea, 0x8f,
	0x22, 0x0e, 0x36, 0x0f, 0xe7, 0xcd, 0x7d, 0x9e, 0x85, 0xc3, 0x16, 0x13,
	0x8f, 0xd2, 0x53, 0x2a, 0x57, 0xd7, 0xd2, 0xa6, 0xbf, 0xe6, 0xe5, 0x51,
	0x80, 0x19, 0xc6, 0x03, 0xa2, 0xd0, 0xe3, 0x38, 0xac, 0x6a, 0x86, 0x90,
	0x09, 0x3c, 0x28, 0x83
};
/* COUNT = 4 */
static const uint8_t nist_kas_ecc_cdh_testvector_330_public_x[] = {
/* QCAVSx */
	0x00, 0xca, 0x87, 0x0a, 0xcb, 0xe4, 0xeb, 0x3a, 0xe6, 0x5e, 0xdd, 0x95,
	0xd6, 0x94, 0x4e, 0xb0, 0x90, 0xe0, 0xe5, 0x50, 0x71, 0x2b, 0xe3, 0xb1,
	0x36, 0x9e, 0x47, 0x32, 0x03, 0xf5, 0x2b, 0x18, 0x38, 0x65, 0x4f, 0x7a,
	0x43, 0x42, 0xbd, 0x83, 0x09, 0x70, 0x4f, 0xed, 0x69, 0x33, 0xae, 0x9d,
	0x16, 0x2c, 0xcd, 0x7d
};
static const uint8_t nist_kas_ecc_cdh_testvector_330_public_y[] = {
/* QCAVSy */
	0x01, 0x79, 0x6c, 0xc2, 0x86, 0xbf, 0x3d, 0x53, 0xad, 0x63, 0x69, 0x77,
	0x37, 0x4f, 0x83, 0x56, 0xe4, 0x57, 0x30, 0xb7, 0xaa, 0x43, 0x80, 0x5f,
	0xb5, 0x28, 0x01, 0xf7, 0x3b, 0xe3, 0xe9, 0xb3, 0x28, 0x08, 0x98, 0x4a,
	0xae, 0xbb, 0xed, 0x7b, 0xe5, 0xe3, 0x9e, 0x51, 0x33, 0x5b, 0x0d, 0xff,
	0x34, 0x78, 0x29, 0x48
};
static const uint8_t nist_kas_ecc_cdh_testvector_330_private[] = {
/* dIUT */
	0x00, 0xf3, 0x23, 0xc8, 0xee, 0x43, 0x3c, 0x9b, 0xa1, 0x5d, 0x37, 0x08,
	0x06, 0x98, 0x34, 0xac, 0xc4, 0xd9, 0x37, 0xbe, 0x50, 0x17, 0xe1, 0xd1,
	0x82, 0xec, 0x76, 0x46, 0x6a, 0xba, 0x28, 0x2c, 0x73, 0xb5, 0xe3, 0xe9,
	0x6f, 0xe1, 0x06, 0x14, 0x36, 0x41, 0x40, 0x2c, 0x72, 0xc6, 0x24, 0x84,
	0xba, 0x1f, 0x12, 0xf2
};
/* QIUTx = 00b74f52520119fc08536cea584220de9b062401e64ff6359305c2e6b0c04a95f77baf53e23c326aee76211495c30b2c150b9275 */
/* QIUTy = 01540588e2fd5688d1b35763908c1f823eeeca8942f6216ce04cef66ed6991df6a22fb74411b13d06513a65b64e62815ee020697 */
static const uint8_t nist_kas_ecc_cdh_testvector_330_out[] = {
/* ZIUT */
	0x01, 0x08, 0x89, 0x03, 0x7c, 0x70, 0x7d, 0x90, 0xb8, 0x33, 0xd0, 0x32,
	0x56, 0xff, 0x2e, 0x8a, 0x5f, 0xfc, 0xe1, 0x6f, 0xb3, 0x61, 0x34, 0x86,
	0x22, 0x14, 0x94, 0xa4, 0xfe, 0xe8, 0x2e, 0x74, 0x62, 0x5a, 0x93, 0xd9,
	0x66, 0xc2, 0x02, 0x8d, 0x09, 0x30, 0x11, 0x54, 0x94, 0xf9, 0x45, 0x6c,
	0xec, 0x4d, 0x2b, 0x6d
};
/* COUNT = 5 */
static const uint8_t nist_kas_ecc_cdh_testvector_331_public_x[] = {
/* QCAVSx */
	0x00, 0x7e, 0xb6, 0x1d, 0xfd, 0xdf, 0xc3, 0xc0, 0xd0, 0x83, 0xfe, 0x22,
	0x13, 0x96, 0x79, 0x86, 0x38, 0x1d, 0x9e, 0x30, 0xe6, 0x84, 0xaf, 0xdf,
	0x2b, 0xac, 0x8f, 0x1a, 0x36, 0x2e, 0x8c, 0x6d, 0x63, 0x58, 0xdf, 0x95,
	0x93, 0x06, 0x00, 0x42, 0x7d, 0xfc, 0x1e, 0xb1, 0x41, 0x18, 0xfd, 0x12,
	0x39, 0xb6, 0x7b, 0x69
};
static const uint8_t nist_kas_ecc_cdh_testvector_331_public_y[] = {
/* QCAVSy */
	0x01, 0x5b, 0xa8, 0x7f, 0x98, 0x11, 0x4c, 0xec, 0x8b, 0x2c, 0xb4, 0x5b,
	0xba, 0x3d, 0xcf, 0x00, 0x6b, 0x28, 0x7e, 0x07, 0xe3, 0xbe, 0xf1, 0xda,
	0x27, 0xce, 0x08, 0xda, 0x9e, 0x4f, 0x48, 0xbd, 0x24, 0x1f, 0x59, 0xa1,
	0xf9, 0xc9, 0x3c, 0x83, 0x78, 0x84, 0x71, 0x57, 0x50, 0xf4, 0x08, 0x5f,
	0x91, 0x3f, 0x4f, 0x7a
};
static const uint8_t nist_kas_ecc_cdh_testvector_331_private[] = {
/* dIUT */
	0x00, 0x13, 0x3d, 0xa2, 0xba, 0x54, 0xb3, 0x62, 0x44, 0xc8, 0x04, 0x2f,
	0x0e, 0x2d, 0xa3, 0x71, 0x8e, 0x56, 0xdb, 0xd2, 0x84, 0x8e, 0xf4, 0x27,
	0xbd, 0xdb, 0x24, 0x17, 0x7f, 0x62, 0x44, 0x75, 0xb5, 0x34, 0x00, 0xaf,
	0xdc, 0xb1, 0x88, 0x79, 0xe8, 0xfe, 0x6b, 0x46, 0x09, 0xa4, 0xf7, 0xbb,
	0xc2, 0x15, 0x2b, 0x13
};
/* QIUTx = 00e3a2f4e63cfbc1ee844745ab3e1e5be573204609aece5e28b8fb8ab8ae06898467a95a7b59c0898a414abff2703ccbcdc09209 */
/* QIUTy = 010d73c43b630170395104acad6c1a563d3296632332a1481ddc2c31836bd1a3ee1a7364d7f5b8295db95a3745b4bbbeb8095bc2 */
static const uint8_t nist_kas_ecc_cdh_testvector_331_out[] = {
/* ZIUT */
	0x01, 0x0a, 0x8a, 0xaf, 0xbb, 0x24, 0x3f, 0xc9, 0x46, 0x6b, 0xf3, 0x81,
	0xea, 0xe1, 0x73, 0xc0, 0x1b, 0xe9, 0x5d, 0x88, 0xa9, 0xc1, 0x31, 0xb0,
	0x7e, 0xd5, 0x4d, 0x2f, 0x11, 0x7c, 0xd3, 0xaf, 0x40, 0x19, 0xff, 0xb1,
	0x96, 0xeb, 0xe8, 0x29, 0x0b, 0x12, 0x69, 0x62, 0x2f, 0x9d, 0xf2, 0x67,
	0x63, 0xff, 0xa2, 0x11
};
/* COUNT = 6 */
static const uint8_t nist_kas_ecc_cdh_testvector_332_public_x[] = {
/* QCAVSx */
	0x00, 0x82, 0xf1, 0x48, 0xec, 0x34, 0xd1, 0xd0, 0x8b, 0x26, 0xe7, 0x9e,
	0x37, 0x72, 0xe1, 0x2d, 0x65, 0x95, 0x98, 0xb7, 0x3b, 0x6f, 0xff, 0x0b,
	0xab, 0x18, 0x45, 0xe9, 0xa5, 0xb5, 0x07, 0x14, 0x49, 0xef, 0x27, 0x59,
	0xfe, 0xd6, 0x3a, 0xa8, 0x06, 0x24, 0xb8, 0x3a, 0x6b, 0x2e, 0x9d, 0x73,
	0x9b, 0x83, 0xf6, 0xdb
};
static const uint8_t nist_kas_ecc_cdh_testvector_332_public_y[] = {
/* QCAVSy */
	0x01, 0x09, 0xce, 0xa0, 0x48, 0xa7, 0x20, 0xba, 0x74, 0x9f, 0xc5, 0x22,
	0xc8, 0x5a, 0xf5, 0xfe, 0x78, 0x37, 0x51, 0xc3, 0x9f, 0xe8, 0xd0, 0x51,
	0x5b, 0xa0, 0xf0, 0xd3, 0xdc, 0xd1, 0x9f, 0x18, 0xc2, 0x2d, 0xa3, 0x90,
	0x9f, 0x02, 0xd7, 0x87, 0x35, 0xaa, 0x11, 0xb2, 0xfe, 0xba, 0x0f, 0x8d,
	0x33, 0x0c, 0x57, 0x03
};
static const uint8_t nist_kas_ecc_cdh_testvector_332_private[] = {
/* dIUT */
	0x00, 0xdf, 0x75, 0x54, 0xc0, 0x13, 0x2f, 0xd4, 0xe4, 0xa2, 0xb9, 0x21,
	0x78, 0x75, 0xf9, 0x92, 0x4a, 0x55, 0xca, 0xb3, 0x19, 0xb7, 0x6a, 0x7c,
	0x17, 0x9c, 0xf0, 0x22, 0x29, 0x37, 0x57, 0x99, 0x96, 0xcf, 0x94, 0x92,
	0x0b, 0xaf, 0xd4, 0x53, 0xe5, 0x2f, 0x5d, 0x2f, 0xc4, 0x80, 0x01, 0x32,
	0x9f, 0xbd, 0x78, 0xc4
};
/* QIUTx = 0160851cff947ce72a118aab4dad4ce2c3ce9bc330ce1d06efad7f630e45bbcf37097d94051d9d310abffa8d96ed22a847cbe693 */
/* QIUTy = 0079a3ddde636bc62af41e6ec0e073fe6462e38ad4b9e3a36ecc8113a2c6394ced21abdc8ec5969e58e009ea13dbe929a96709ca */
static const uint8_t nist_kas_ecc_cdh_testvector_332_out[] = {
/* ZIUT */
	0x01, 0xe1, 0x7b, 0x88, 0x44, 0xc4, 0xc7, 0x57, 0x55, 0x3a, 0x62, 0x8d,
	0x6f, 0x4c, 0x48, 0xf3, 0xa3, 0x37, 0xed, 0x2b, 0xbb, 0x6e, 0x40, 0x47,
	0xdb, 0xfc, 0xfb, 0xfd, 0x02, 0xbb, 0x81, 0xc6, 0xe0, 0x96, 0xf8, 0xcc,
	0xbb, 0x7f, 0x2e, 0x5d, 0x10, 0xee, 0x9c, 0xbc, 0xc9, 0x60, 0xe3, 0xa9,
	0x9e, 0x79, 0xbd, 0x09
};
/* COUNT = 7 */
static const uint8_t nist_kas_ecc_cdh_testvector_333_public_x[] = {
/* QCAVSx */
	0x00, 0x83, 0xca, 0x04, 0xdf, 0x84, 0x58, 0xe5, 0xe6, 0xce, 0x6e, 0x13,
	0xb9, 0x37, 0xda, 0xb4, 0x98, 0x52, 0x1d, 0x82, 0x6f, 0xb9, 0x54, 0x12,
	0x34, 0x56, 0x7e, 0x99, 0x5f, 0x06, 0x83, 0xc8, 0x0f, 0x43, 0x85, 0x16,
	0xee, 0xff, 0x0c, 0xf8, 0x91, 0x8a, 0x5f, 0x8b, 0x52, 0x62, 0xcc, 0xdc,
	0xa3, 0x99, 0x74, 0x17
};
static const uint8_t nist_kas_ecc_cdh_testvector_333_public_y[] = {
/* QCAVSy */
	0x00, 0x5f, 0x8b, 0x3c, 0x20, 0xe3, 0xfe, 0x25, 0x59, 0xef, 0xe0, 0xe8,
	0x5a, 0x12, 0x27, 0x6d, 0xf9, 0x22, 0xef, 0x0f, 0x42, 0x57, 0xfe, 0x70,
	0x3b, 0xe2, 0x52, 0x9f, 0x6e, 0xff, 0xb6, 0xf2, 0x99, 0xa1, 0xa2, 0x51,
	0xc0, 0x1e, 0x38, 0xd4, 0x3c, 0xa6, 0xca, 0x57, 0x6e, 0xf1, 0xe0, 0xbe,
	0xb6, 0xc9, 0x12, 0x1e
};
static const uint8_t nist_kas_ecc_cdh_testvector_333_private[] = {
/* dIUT */
	0x00, 0x32, 0x73, 0x5d, 0xd7, 0xf1, 0x18, 0xd2, 0x9f, 0x9f, 0x3c, 0xab,
	0x3a, 0x07, 0x2d, 0xb8, 0xc8, 0x86, 0xd4, 0x2f, 0xa5, 0xde, 0x7b, 0xea,
	0x65, 0x03, 0x6e, 0xd3, 0xc8, 0xd4, 0x4a, 0x11, 0xe8, 0xf9, 0x6f, 0x4e,
	0x1a, 0x6f, 0x25, 0x48, 0x88, 0xca, 0xb2, 0x14, 0x30, 0x51, 0x91, 0xa2,
	0x6d, 0xd1, 0xda, 0xd1
};
/* QIUTx = 002d39e0f89fb875151ee3b354f8ea159e7fba6f23f8a764d49e07ef43f18d3cf86e1baaae0ad79d4000709a50252f1ce3603135 */
/* QIUTy = 00ce44a9b775b03cf42b310249660794c25e0422b03ad9babaa23610613251fe0e54046e04f9210436dd376003d18f98dfdae189 */
static const uint8_t nist_kas_ecc_cdh_testvector_333_out[] = {
/* ZIUT */
	0x01, 0x16, 0x7e, 0xdf, 0x7a, 0x3c, 0x50, 0xe1, 0x3b, 0xe1, 0x26, 0xeb,
	0x2c, 0xaf, 0x6b, 0x5f, 0x8f, 0x76, 0x1c, 0xc8, 0xdb, 0xa4, 0x13, 0x24,
	0x64, 0x23, 0xb8, 0x77, 0xdf, 0x74, 0xa3, 0xaa, 0x3f, 0x48, 0x14, 0x4b,
	0x44, 0xcd, 0x13, 0x3a, 0xd9, 0xf2, 0xd0, 0x5e, 0xf9, 0x7a, 0x08, 0xf7,
	0xca, 0x51, 0x1d, 0x7f
};
/* COUNT = 8 */
static const uint8_t nist_kas_ecc_cdh_testvector_334_public_x[] = {
/* QCAVSx */
	0x01, 0x31, 0x15, 0x36, 0xa9, 0x74, 0x5b, 0x74, 0x75, 0xe6, 0xc2, 0xfd,
	0x72, 0x4c, 0x23, 0xd9, 0xea, 0x66, 0x80, 0x3a, 0x13, 0x9b, 0x47, 0xe3,
	0xae, 0x26, 0x3b, 0x0f, 0xb7, 0xe4, 0x2e, 0x33, 0x16, 0x27, 0x9b, 0xbf,
	0x62, 0x2a, 0xe2, 0x62, 0x53, 0x1b, 0x2e, 0x22, 0x83, 0xec, 0xc1, 0xa6,
	0x12, 0x7c, 0x9b, 0x09
};
static const uint8_t nist_kas_ecc_cdh_testvector_334_public_y[] = {
/* QCAVSy */
	0x01, 0xd4, 0x8c, 0xcc, 0x78, 0x1f, 0x0b, 0xde, 0xc3, 0x13, 0x09, 0x10,
	0x04, 0x4b, 0x76, 0x90, 0x9a, 0x9a, 0xbd, 0x7f, 0xcb, 0x18, 0x40, 0x7d,
	0xc4, 0x2f, 0x63, 0x91, 0x2f, 0xa2, 0x66, 0x72, 0x08, 0x00, 0x3a, 0xb2,
	0xd2, 0x81, 0x02, 0xad, 0xcf, 0xb9, 0x3d, 0xdc, 0x05, 0x37, 0x60, 0xe5,
	0x3c, 0x2d, 0xaa, 0x78
};
static const uint8_t nist_kas_ecc_cdh_testvector_334_private[] = {
/* dIUT */
	0x00, 0xb0, 0x4f, 0x33, 0xb6, 0x87, 0x99, 0x63, 0x0d, 0x62, 0xf4, 0x43,
	0x37, 0xc7, 0x7c, 0x5a, 0x6b, 0x6e, 0x0f, 0x76, 0x06, 0xb5, 0xc8, 0x72,
	0x44, 0xaa, 0x4e, 0x7d, 0xa6, 0x98, 0xcc, 0x8f, 0xf1, 0xd3, 0x31, 0x1b,
	0x48, 0xee, 0x7c, 0x9a, 0x68, 0x12, 0xba, 0xf9, 0x05, 0x43, 0x79, 0xae,
	0xb6, 0x1c, 0x0c, 0x13
};
/* QIUTx = 01c5940c2de2b3735824ae2994c15086fa958750e4d83123af047e9b3c264746c9b5d919da215355d8c28b2808a37d0cc5f2f6a1 */
/* QIUTy = 000abfe6f1510a182eff78dd802e9ba21e668aea5732c732ddfc5df9301f5899f02bae80f8282601ef3eefe414ef2c726fe00258 */
static const uint8_t nist_kas_ecc_cdh_testvector_334_out[] = {
/* ZIUT */
	0x01, 0x5c, 0x0d, 0x20, 0x2b, 0xfd, 0xee, 0x2d, 0xfb, 0xd4, 0xbe, 0x91,
	0x62, 0x51, 0x71, 0x99, 0x2e, 0x6c, 0x6b, 0x1a, 0x1d, 0x06, 0xcc, 0x1b,
	0x2b, 0x66, 0xed, 0x64, 0xc9, 0xd9, 0x28, 0xbd, 0x4f, 0x06, 0x29, 0x12,
	0x90, 0x0d, 0x3f, 0x89, 0x04, 0x5c, 0x71, 0x90, 0xf5, 0x13, 0xd3, 0xb0,
	0x19, 0xa6, 0x34, 0xf5
};
/* COUNT = 9 */
static const uint8_t nist_kas_ecc_cdh_testvector_335_public_x[] = {
/* QCAVSx */
	0x01, 0x0c, 0x27, 0x35, 0x30, 0xf5, 0x4f, 0xe1, 0x74, 0xbb, 0xbd, 0x5c,
	0x27, 0x71, 0xa5, 0x5a, 0x42, 0xe6, 0x40, 0x50, 0xc3, 0xbf, 0x25, 0x23,
	0xe6, 0x08, 0x2a, 0xf4, 0x76, 0xeb, 0x02, 0x57, 0x87, 0x69, 0x6e, 0xdf,
	0x6e, 0x43, 0x8d, 0xd0, 0x56, 0xb5, 0x98, 0xf5, 0x00, 0x06, 0x33, 0xc2,
	0x64, 0xfd, 0x7b, 0xa5
};
static const uint8_t nist_kas_ecc_cdh_testvector_335_public_y[] = {
/* QCAVSy */
	0x00, 0x44, 0x3e, 0x72, 0xda, 0x93, 0xb0, 0xc7, 0x82, 0x5f, 0x42, 0x23,
	0xc7, 0x96, 0x82, 0x6f, 0xd1, 0x32, 0x23, 0x45, 0xea, 0x25, 0xad, 0xf3,
	0xdf, 0x1a, 0x2c, 0x69, 0x58, 0x90, 0x8c, 0x0f, 0xd9, 0xb1, 0x3e, 0x93,
	0xcc, 0x00, 0x5f, 0x4e, 0xcb, 0x15, 0x5a, 0x2f, 0xff, 0x7a, 0xc5, 0x4f,
	0xa8, 0x18, 0x07, 0x85
};
static const uint8_t nist_kas_ecc_cdh_testvector_335_private[] = {
/* dIUT */
	0x00, 0xd4, 0xeb, 0xc3, 0x1c, 0x9a, 0x65, 0xee, 0x3b, 0x1a, 0xbd, 0x9d,
	0x6e, 0x64, 0x95, 0x78, 0x0c, 0x54, 0xe6, 0x33, 0xf5, 0xa2, 0xa9, 0xf6,
	0x1c, 0x84, 0x08, 0xd7, 0x67, 0xd0, 0x91, 0x6d, 0x91, 0xcb, 0x54, 0xcf,
	0xcd, 0x93, 0x75, 0x38, 0xdf, 0x92, 0xcf, 0xc4, 0x59, 0x38, 0xe3, 0x3b,
	0x77, 0xd7, 0x24, 0xf2
};
/* QIUTx = 014dfaaa70518f367cdfca89795a0db374bb7b407a58caac24ba46824dce78501067d7e0467d30b9e1fdbb0a7eace15fb0c208cf */
/* QIUTy = 019d62be2b12a17a78f6c9f7e703669765f763c6235fe7af78f25044e99c4b1b90653640b3f0ae481a55d47d1eb17b86c5bada1b */
static const uint8_t nist_kas_ecc_cdh_testvector_335_out[] = {
/* ZIUT */
	0x00, 0x7c, 0x32, 0x38, 0x3a, 0xae, 0x80, 0xe1, 0x11, 0x12, 0x07, 0x89,
	0x4c, 0x8c, 0xc5, 0xbe, 0x66, 0xfe, 0x53, 0x8a, 0xf4, 0xa1, 0x91, 0x95,
	0x74, 0x2a, 0x94, 0xa4, 0xc3, 0xf5, 0xc7, 0x65, 0xd9, 0x77, 0x6a, 0x56,
	0x17, 0x7c, 0x48, 0x5d, 0xdb, 0x53, 0xc0, 0x38, 0xb7, 0x04, 0x78, 0x95,
	0x9d, 0x37, 0x46, 0x27
};
/* COUNT = 10 */
static const uint8_t nist_kas_ecc_cdh_testvector_336_public_x[] = {
/* QCAVSx */
	0x01, 0x3b, 0xeb, 0x8d, 0x36, 0xd1, 0xe7, 0xf5, 0x3d, 0x80, 0xbe, 0xea,
	0x33, 0xef, 0xc3, 0xe0, 0x09, 0x8d, 0xea, 0xea, 0xa1, 0x79, 0x77, 0xda,
	0x8f, 0x9a, 0xae, 0x9c, 0x57, 0x6e, 0x79, 0x20, 0xe8, 0xf6, 0xda, 0x55,
	0xa2, 0x09, 0x30, 0xce, 0x60, 0xfd, 0x49, 0x0b, 0x4f, 0xb0, 0x15, 0x4d,
	0x49, 0x27, 0x7d, 0x99
};
static const uint8_t nist_kas_ecc_cdh_testvector_336_public_y[] = {
/* QCAVSy */
	0x01, 0x1d, 0xc1, 0xd8, 0x7f, 0x35, 0x2e, 0x12, 0xbd, 0xb4, 0x1a, 0x1b,
	0x7a, 0x1f, 0x1e, 0x51, 0x66, 0x29, 0xed, 0x32, 0x3c, 0x5d, 0x5b, 0x26,
	0x3f, 0xf0, 0x36, 0xf0, 0x23, 0xf0, 0xff, 0x5f, 0x72, 0x2d, 0x05, 0x6c,
	0x24, 0xa4, 0x11, 0xf5, 0x3b, 0x34, 0x7d, 0x07, 0x86, 0xd8, 0x4f, 0x7b,
	0xe8, 0x79, 0x10, 0x5a
};
static const uint8_t nist_kas_ecc_cdh_testvector_336_private[] = {
/* dIUT */
	0x00, 0x26, 0x17, 0x6a, 0xaf, 0x98, 0xa6, 0x43, 0x35, 0x66, 0xf1, 0xdc,
	0xc1, 0x91, 0x9e, 0x94, 0x45, 0x3e, 0x9c, 0xbf, 0x3c, 0x97, 0xe0, 0x69,
	0xb4, 0xa1, 0x74, 0x26, 0x44, 0x91, 0x67, 0xf6, 0xa1, 0x08, 0x9a, 0xc1,
	0x6a, 0x10, 0x2a, 0x4b, 0x3e, 0x43, 0x2a, 0x97, 0x8b, 0xfb, 0x46, 0x25,
	0x5d, 0xc4, 0x3d, 0x1a
};
/* QIUTx = 01535fc949b49030308bc0da9793d57088766ac8cf22e8d6c276d8f3f7650f30135e1f6c00300c1344e2f0306ea0e270b09a80af */
/* QIUTy = 00b8fc3fa61dc22c55501f2a6b2944946d99f7bbfefbec7acf4fb200c1002e322c39172ec0a2b6ce0807f1e3ebb1ea3400353143 */
static const uint8_t nist_kas_ecc_cdh_testvector_336_out[] = {
/* ZIUT */
	0x01, 0x16, 0x61, 0x07, 0xab, 0x98, 0xdb, 0x1d, 0xbe, 0x22, 0xc5, 0x88,
	0x8a, 0x70, 0xc9, 0x92, 0xaf, 0x4f, 0xaf, 0x46, 0x23, 0xef, 0x59, 0x38,
	0x02, 0xae, 0xdf, 0xe4, 0x33, 0x80, 0x9c, 0x53, 0xef, 0x4a, 0xb0, 0xb2,
	0xdc, 0x4d, 0xc2, 0x54, 0x64, 0x88, 0xb3, 0x56, 0xef, 0x32, 0x65, 0x35,
	0x60, 0x55, 0xd8, 0xf5
};
/* COUNT = 11 */
static const uint8_t nist_kas_ecc_cdh_testvector_337_public_x[] = {
/* QCAVSx */
	0x01, 0x69, 0x0c, 0x74, 0x64, 0x9e, 0x92, 0xe1, 0xc1, 0x00, 0x4f, 0x43,
	0xfd, 0x6e, 0x46, 0x90, 0xbe, 0x59, 0x59, 0x04, 0xc5, 0x6d, 0x2a, 0xcd,
	0x85, 0xa4, 0x9a, 0xf0, 0xa1, 0x7d, 0x34, 0x36, 0x8c, 0x87, 0x68, 0xd0,
	0x39, 0xed, 0xe9, 0xc9, 0x2a, 0xd2, 0x6b, 0x26, 0x30, 0x6b, 0x5f, 0xfd,
	0xef, 0x7b, 0xfd, 0x19
};
static const uint8_t nist_kas_ecc_cdh_testvector_337_public_y[] = {
/* QCAVSy */
	0x00, 0x81, 0x27, 0x5f, 0x7e, 0x2f, 0xf0, 0x68, 0xa6, 0xc1, 0xb9, 0x2d,
	0xd3, 0x8c, 0x03, 0x42, 0x56, 0xed, 0x73, 0x22, 0xb0, 0x27, 0x70, 0x29,
	0x94, 0xc7, 0x4f, 0x5b, 0x81, 0x81, 0x24, 0xd3, 0x4a, 0x19, 0x09, 0x87,
	0xfd, 0x65, 0x88, 0x92, 0xfc, 0x99, 0xe7, 0xac, 0xb9, 0x87, 0x7b, 0xd6,
	0xfe, 0x94, 0x69, 0x19
};
static const uint8_t nist_kas_ecc_cdh_testvector_337_private[] = {
/* dIUT */
	0x00, 0xbf, 0x3e, 0x73, 0x95, 0xc7, 0x2a, 0xa8, 0x4c, 0x09, 0x60, 0xe5,
	0xc6, 0x90, 0x22, 0xce, 0x39, 0x06, 0x74, 0x04, 0x53, 0x44, 0x73, 0xc4,
	0xc7, 0x82, 0x94, 0x24, 0xf8, 0x1f, 0x1d, 0x44, 0xb3, 0x1f, 0x20, 0xe2,
	0xb9, 0x82, 0xe2, 0x51, 0xcf, 0x9f, 0xfb, 0x32, 0x7a, 0x7d, 0x83, 0x4f,
	0x59, 0xd1, 0x94, 0x8a
};
/* QIUTx = 011cbc4ed9036a27effc89ffd55fa1e3ead0fb93bacfa0a78bcafe3914ab1a97860fec1334caaba07243591603e67791aea4bcb7 */
/* QIUTy = 0101074c444627630ad0a5258e24438d71f26ab94d05bb47d1ab97858c4b92c6ff1cb9be66b984fe8e16e44f393e63f9d64281c8 */
static const uint8_t nist_kas_ecc_cdh_testvector_337_out[] = {
/* ZIUT */
	0x00, 0x7e, 0x7a, 0x24, 0x90, 0x94, 0xeb, 0x52, 0xbe, 0xe0, 0x11, 0x5b,
	0x8b, 0xd5, 0x54, 0x5f, 0x81, 0xbf, 0x0b, 0x7d, 0x66, 0x99, 0x8f, 0xe1,
	0x24, 0xc9, 0xa3, 0xdd, 0x3c, 0x57, 0x15, 0xd0, 0x3b, 0x2f, 0x97, 0x3d,
	0x47, 0xc1, 0x9a, 0xf5, 0x10, 0x8a, 0x2a, 0xe0, 0x05, 0xfc, 0xca, 0x65,
	0xe6, 0x1f, 0x33, 0x7d
};
/* COUNT = 12 */
static const uint8_t nist_kas_ecc_cdh_testvector_338_public_x[] = {
/* QCAVSx */
	0x00, 0x5c, 0x24, 0xf4, 0xad, 0x9b, 0xdc, 0xb1, 0x46, 0x06, 0x85, 0xa2,
	0x2d, 0xa5, 0x4d, 0xbd, 0xdd, 0x15, 0x07, 0xef, 0x6d, 0xe4, 0x69, 0xda,
	0x41, 0x70, 0xce, 0x30, 0x14, 0x75, 0x79, 0xa5, 0x49, 0x45, 0xdb, 0xb1,
	0xbc, 0xe9, 0xf0, 0x2e, 0x47, 0x00, 0x33, 0xbb, 0x15, 0xfc, 0x1a, 0x70,
	0xf8, 0x31, 0xe7, 0x9b
};
static const uint8_t nist_kas_ecc_cdh_testvector_338_public_y[] = {
/* QCAVSy */
	0x01, 0x7c, 0xa9, 0x32, 0xb9, 0x0a, 0x08, 0xca, 0x2e, 0x3f, 0x55, 0xc5,
	0x0c, 0xc0, 0xe1, 0x3d, 0x27, 0x9d, 0x7b, 0xc9, 0x11, 0x9c, 0x57, 0x3c,
	0x3f, 0x74, 0x14, 0x10, 0xbb, 0x7c, 0x1c, 0xad, 0x10, 0x76, 0xc3, 0xba,
	0x42, 0xae, 0xd1, 0xce, 0x69, 0xd5, 0x62, 0x28, 0xb0, 0x82, 0xfb, 0x6d,
	0xe0, 0xee, 0xfb, 0x68
};
static const uint8_t nist_kas_ecc_cdh_testvector_338_private[] = {
/* dIUT */
	0x00, 0x96, 0xd4, 0x03, 0xb0, 0xfa, 0x60, 0x1c, 0x9a, 0x75, 0xaa, 0x7d,
	0xe9, 0xfe, 0x9e, 0x11, 0xd4, 0x2e, 0xfa, 0x93, 0xd9, 0x6d, 0xd3, 0x51,
	0x02, 0xda, 0x05, 0xd3, 0xac, 0x80, 0x7e, 0x44, 0x19, 0x4e, 0x18, 0xe7,
	0x9c, 0x8b, 0x5b, 0xe1, 0x1c, 0x5f, 0xb3, 0x9c, 0x8b, 0xd4, 0xe3, 0x12,
	0x32, 0x5a, 0xfa, 0xf2
};
/* QIUTx = 0009833946294d4aeecdb6f7254ca489c0ff13af2dc6e2ca5626835d5dd22241440c37a63690cd11867581ff61b7252d07afb8ff */
/* QIUTy = 006183fee6f4d6ef5b723c53c96c5c1ecdd84652e379c937878d766f83370500412359c22d4778bdf807b3c84e5b83350910a1a9 */
static const uint8_t nist_kas_ecc_cdh_testvector_338_out[] = {
/* ZIUT */
	0x00, 0xb9, 0xd8, 0xb6, 0x86, 0x42, 0xb2, 0x72, 0x93, 0x40, 0xd8, 0xb7,
	0xc5, 0xed, 0x3b, 0x3a, 0x89, 0x13, 0xc4, 0xa3, 0xf6, 0xb9, 0x47, 0x47,
	0x30, 0x17, 0xc0, 0xe1, 0x05, 0xbc, 0x7e, 0xdc, 0x60, 0xda, 0xa9, 0xb0,
	0x73, 0x27, 0x72, 0x22, 0x0f, 0x93, 0xec, 0xa4, 0x87, 0x80, 0x85, 0xf7,
	0x56, 0xe3, 0xad, 0xad
};
/* COUNT = 13 */
static const uint8_t nist_kas_ecc_cdh_testvector_339_public_x[] = {
/* QCAVSx */
	0x00, 0xaa, 0xbf, 0x6a, 0xab, 0xb3, 0xe9, 0x0f, 0x95, 0x6d, 0x70, 0x04,
	0xff, 0xc8, 0x93, 0xc7, 0x0f, 0x8e, 0x90, 0xcd, 0xc3, 0x1f, 0xc0, 0xc7,
	0xa8, 0x8f, 0x16, 0x32, 0x05, 0x41, 0xd5, 0x84, 0x43, 0xaf, 0x39, 0x40,
	0x5d, 0x88, 0x8d, 0x96, 0x76, 0x55, 0x7c, 0xdd, 0x39, 0x4b, 0x27, 0xdc,
	0x54, 0x49, 0xf9, 0x45
};
static const uint8_t nist_kas_ecc_cdh_testvector_339_public_y[] = {
/* QCAVSy */
	0x01, 0x27, 0xf2, 0x6d, 0xba, 0x06, 0xc3, 0x3f, 0x8f, 0xb4, 0x5d, 0x95,
	0x5c, 0xfd, 0xb5, 0xce, 0xdd, 0xa9, 0x3d, 0xd8, 0xa4, 0x5d, 0xb4, 0x2e,
	0xe0, 0xb9, 0x26, 0x4a, 0x05, 0x4c, 0x16, 0xa8, 0x7b, 0xed, 0xad, 0x45,
	0xc0, 0xd9, 0xa0, 0xf3, 0x5b, 0xbc, 0x6a, 0xa7, 0xa1, 0x29, 0x56, 0x22,
	0xe8, 0x3e, 0xbe, 0x8b
};
static const uint8_t nist_kas_ecc_cdh_testvector_339_private[] = {
/* dIUT */
	0x00, 0x67, 0x12, 0x5e, 0xc3, 0x09, 0xab, 0x5d, 0xc7, 0xea, 0x56, 0x8f,
	0x88, 0x15, 0xa2, 0xb3, 0x0c, 0xfa, 0xc3, 0x36, 0x6b, 0xb4, 0xf0, 0x16,
	0x0d, 0x53, 0x73, 0x8a, 0xb9, 0x95, 0xce, 0x75, 0x68, 0x1f, 0xcd, 0x5e,
	0x49, 0x2f, 0x3a, 0x97, 0x25, 0xb4, 0xcf, 0x75, 0xba, 0x43, 0x01, 0xa7,
	0x86, 0x04, 0x93, 0x42
};
/* QIUTx = 01f1d1aee5fc594ca4a22b81bad707d821bef3253966f5d77956157483961696f4c60476a42b452b89c1ecb3615475ec9c96dc87 */
/* QIUTy = 00755c5ef55889b415cefa0e881a3efc9be86f36c67615423b452eab4cd5611aef4198ddb31aecb434eeeec12edd05913af19fc4 */
static const uint8_t nist_kas_ecc_cdh_testvector_339_out[] = {
/* ZIUT */
	0x01, 0x7d, 0x60, 0x39, 0x4c, 0x7e, 0xe6, 0x4b, 0xa7, 0x3d, 0xb9, 0x14,
	0x84, 0x71, 0x33, 0x70, 0xda, 0xa8, 0x21, 0x25, 0x58, 0x07, 0x34, 0x9c,
	0x23, 0x7e, 0x58, 0x49, 0x41, 0x1b, 0xf0, 0xba, 0xb3, 0xa1, 0xb3, 0x53,
	0xbe, 0x3c, 0xd0, 0x7e, 0xed, 0xdc, 0x5c, 0x2f, 0xfc, 0x74, 0x33, 0x62,
	0x25, 0xda, 0xe6, 0xf7
};
/* COUNT = 14 */
static const uint8_t nist_kas_ecc_cdh_testvector_340_public_x[] = {
/* QCAVSx */
	0x00, 0x1f, 0x4f, 0xfb, 0xf2, 0x2f, 0x67, 0xc1, 0x59, 0x1b, 0x0a, 0x77,
	0x0e, 0x56, 0x3c, 0x0a, 0xba, 0x66, 0xfe, 0x01, 0x56, 0x1c, 0x5e, 0x22,
	0x7e, 0x52, 0x2b, 0x5d, 0xde, 0x23, 0xc7, 0x48, 0xca, 0xcf, 0x8f, 0x4a,
	0x02, 0x29, 0x0d, 0xe2, 0x6b, 0x47, 0x76, 0x7d, 0x38, 0x8a, 0x5c, 0x83,
	0x6d, 0x3e, 0xff, 0x4b
};
static const uint8_t nist_kas_ecc_cdh_testvector_340_public_y[] = {
/* QCAVSy */
	0x00, 0x2d, 0x27, 0x3f, 0x2e, 0x85, 0x16, 0xe5, 0x08, 0x38, 0x8f, 0x8e,
	0xd2, 0x01, 0x5e, 0xc9, 0xfe, 0x67, 0xc6, 0x6f, 0x83, 0x2c, 0xf2, 0xb2,
	0x61, 0xdf, 0xad, 0x58, 0x56, 0x12, 0x80, 0x42, 0xfb, 0x4a, 0x61, 0xa9,
	0x1a, 0x37, 0xb3, 0x41, 0xde, 0x42, 0x96, 0xd4, 0xbf, 0x63, 0xbf, 0x67,
	0xa3, 0x45, 0x8a, 0x74
};
static const uint8_t nist_kas_ecc_cdh_testvector_340_private[] = {
/* dIUT */
	0x00, 0x6b, 0x2c, 0xc2, 0x38, 0x7f, 0x69, 0xaf, 0xd4, 0x39, 0x78, 0xb7,
	0xf6, 0x6b, 0xd1, 0x76, 0x66, 0x25, 0x70, 0x81, 0xba, 0x4d, 0x66, 0xee,
	0x6a, 0x9a, 0x82, 0xb7, 0xc8, 0x7c, 0x4a, 0xc5, 0xf0, 0xeb, 0xa6, 0xbc,
	0x2d, 0x98, 0x1c, 0xa1, 0xda, 0x9f, 0xf2, 0x02, 0xba, 0x72, 0xcb, 0x7f,
	0xe9, 0xc0, 0x6c, 0xf0
};
/* QIUTx = 0086a44d6ee4e8c50d1e10d7d1d113a9610750210679e0e4cab8c62267842938ad5d933c980eef9d4644791bbfd35bbac649d213 */
/* QIUTy = 011da63212631605fea0e93f5826b1929b2bd1db950615fcb05eb47bd9cb69eae03b1c33d7a9e47b335a40498238fedb8999b04d */
static const uint8_t nist_kas_ecc_cdh_testvector_340_out[] = {
/* ZIUT */
	0x00, 0xb1, 0x9e, 0x05, 0x2e, 0xdd, 0x44, 0x42, 0x1e, 0xe2, 0xf5, 0xba,
	0x84, 0x59, 0x11, 0xfe, 0xd9, 0x18, 0x3d, 0x88, 0x5d, 0xa8, 0x5d, 0x51,
	0xdc, 0x81, 0x9c, 0xa5, 0x65, 0xce, 0x57, 0x4f, 0x7d, 0xb2, 0x57, 0x50,
	0x98, 0x76, 0x37, 0x7b, 0x40, 0xc5, 0xa0, 0x83, 0x49, 0x01, 0x95, 0x63,
	0xb6, 0x0e, 0x13, 0xe9
};
/* COUNT = 15 */
static const uint8_t nist_kas_ecc_cdh_testvector_341_public_x[] = {
/* QCAVSx */
	0x01, 0xb0, 0x83, 0x3e, 0xb3, 0x44, 0x04, 0x50, 0xe3, 0xfa, 0x51, 0x48,
	0xc2, 0x5c, 0x2d, 0xf2, 0xe0, 0x02, 0x06, 0x26, 0xf2, 0x40, 0x74, 0x22,
	0x21, 0x7e, 0x4e, 0xcb, 0x8b, 0xd8, 0xa7, 0x51, 0xa7, 0x2b, 0xab, 0x2e,
	0xc5, 0x64, 0x2a, 0xe9, 0x0f, 0xd2, 0x9d, 0x8c, 0x4d, 0x79, 0xe9, 0xcc,
	0x19, 0x1b, 0x5b, 0xa5
};
static const uint8_t nist_kas_ecc_cdh_testvector_341_public_y[] = {
/* QCAVSy */
	0x00, 0x23, 0x07, 0x89, 0x05, 0xb6, 0xa3, 0x30, 0x09, 0xff, 0xea, 0x1a,
	0x19, 0x77, 0xdb, 0x94, 0x35, 0x79, 0xaf, 0xbe, 0xb8, 0x71, 0x97, 0x00,
	0x59, 0x69, 0x6b, 0x29, 0xef, 0x90, 0xdd, 0x84, 0x61, 0x77, 0x6b, 0x34,
	0x3a, 0x09, 0xc8, 0x53, 0xa5, 0x38, 0xe4, 0xf2, 0x2f, 0xdf, 0x85, 0x4f,
	0xcb, 0xf3, 0xb7, 0x34
};
static const uint8_t nist_kas_ecc_cdh_testvector_341_private[] = {
/* dIUT */
	0x00, 0x3e, 0x09, 0x8f, 0x3f, 0x19, 0x5e, 0x89, 0xda, 0x71, 0xd6, 0x36,
	0x70, 0x00, 0xf8, 0x04, 0x07, 0x9a, 0xdc, 0xa3, 0x27, 0x5b, 0x2e, 0x79,
	0x3e, 0x8d, 0x31, 0x2c, 0x8e, 0x40, 0x2c, 0xf0, 0xd0, 0xce, 0x53, 0x31,
	0x74, 0x2f, 0x87, 0x51, 0x5f, 0x4d, 0xd9, 0xcc, 0x66, 0x82, 0x46, 0x19,
	0x4b, 0x95, 0x72, 0xb6
};
/* QIUTx = 010af4ae334ba40bd6538e0f095aa56f61a2bd2b5f38e954b7617d92ba10603cdcca836554d0242ddb37d5e1576b0be69f0eece7 */
/* QIUTy = 01b335521aec305f314d7f23ed28cc0c4d23f33a6785fc6c6de93e5fabce271302f9557f6d2ae77c52720eda5a2e15436443dfd2 */
static const uint8_t nist_kas_ecc_cdh_testvector_341_out[] = {
/* ZIUT */
	0x01, 0x69, 0x75, 0x12, 0x67, 0x6a, 0xe5, 0x6f, 0xf5, 0xab, 0x77, 0x8c,
	0x41, 0x10, 0x42, 0xd2, 0x17, 0xad, 0x24, 0xa2, 0x4e, 0xa0, 0x5b, 0xbc,
	0x25, 0x3e, 0x43, 0x95, 0xfe, 0xcc, 0x8a, 0x07, 0xfe, 0x77, 0xae, 0x0c,
	0xa4, 0xed, 0x97, 0x74, 0x59, 0xf1, 0xa1, 0x4d, 0x9b, 0x83, 0x93, 0x1b,
	0xcc, 0xf4, 0x61, 0x07
};
/* COUNT = 16 */
static const uint8_t nist_kas_ecc_cdh_testvector_342_public_x[] = {
/* QCAVSx */
	0x01, 0x74, 0xbd, 0x23, 0x3f, 0x86, 0x1c, 0x7b, 0x85, 0x3c, 0xca, 0x8f,
	0x5a, 0x38, 0x35, 0x74, 0x84, 0x9e, 0xf2, 0xcd, 0x76, 0xef, 0x22, 0xbc,
	0x0e, 0x15, 0x9f, 0x71, 0x3a, 0x1d, 0x07, 0x38, 0x7c, 0x42, 0x03, 0xb1,
	0x1f, 0x4c, 0x33, 0x9b, 0x66, 0x96, 0x74, 0xfc, 0xf1, 0xda, 0xc1, 0x99,
	0x70, 0x3b, 0xeb, 0x07
};
static const uint8_t nist_kas_ecc_cdh_testvector_342_public_y[] = {
/* QCAVSy */
	0x01, 0xe2, 0xc7, 0x78, 0xcc, 0xa6, 0x49, 0x63, 0xd8, 0x73, 0x29, 0xe5,
	0x7c, 0x8b, 0xc9, 0x6d, 0x0f, 0x67, 0x37, 0x04, 0x1f, 0xd0, 0x87, 0xda,
	0xfc, 0x07, 0xdd, 0x67, 0x0e, 0x2c, 0xe7, 0x25, 0x54, 0x7e, 0x1a, 0x26,
	0x1c, 0x43, 0xfb, 0xc5, 0x4e, 0x14, 0xc3, 0x47, 0x3e, 0xbd, 0xbb, 0x31,
	0xfd, 0xa8, 0x47, 0x3a
};
static const uint8_t nist_kas_ecc_cdh_testvector_342_private[] = {
/* dIUT */
	0x00, 0x7d, 0x84, 0x93, 0x13, 0xc6, 0x49, 0x9d, 0xae, 0x47, 0x2b, 0x0b,
	0xdd, 0xb7, 0x6d, 0xec, 0x45, 0x80, 0x6f, 0x82, 0xe0, 0x98, 0x72, 0x33,
	0x01, 0xdf, 0x33, 0xb6, 0xbb, 0xb9, 0x7f, 0x79, 0x4b, 0xf2, 0x68, 0x79,
	0xfc, 0x33, 0xc2, 0x97, 0x3f, 0x86, 0xc1, 0x55, 0x15, 0x49, 0x64, 0x1a,
	0x81, 0x9b, 0x57, 0x11
};
/* QIUTx = 004812af1937630b8ea7d0ff723cbb05b7a2740fc4c9be792db204f929674c32e47d85e4770b903d3290a6d62c274cb257b76837 */
/* QIUTy = 008c6f61711786bf5c54eb0c1b3126d641b24a6662b67b257302a9a61aa8cd503846bcbb1b14fa5c97454368b6c27dd2de2ae80b */
static const uint8_t nist_kas_ecc_cdh_testvector_342_out[] = {
/* ZIUT */
	0x01, 0x59, 0x60, 0xea, 0x8b, 0x92, 0xbd, 0x77, 0xd5, 0x28, 0x74, 0xe3,
	0xea, 0x82, 0xed, 0x17, 0x63, 0x44, 0x01, 0x89, 0xd6, 0x87, 0x28, 0xd3,
	0x97, 0x4d, 0x4c, 0x01, 0xd6, 0xaa, 0xfd, 0xbb, 0x52, 0x74, 0x64, 0x8f,
	0x6f, 0x3e, 0xaa, 0x4f, 0xaf, 0x3f, 0xc7, 0x2d, 0x09, 0x89, 0x2a, 0xb0,
	0x38, 0xcb, 0x2f, 0xb7
};
/* COUNT = 17 */
static const uint8_t nist_kas_ecc_cdh_testvector_343_public_x[] = {
/* QCAVSx */
	0x00, 0xc1, 0xdc, 0xb7, 0x37, 0xd2, 0x53, 0x03, 0x5b, 0xb9, 0x1d, 0x2a,
	0x4a, 0x85, 0xf3, 0x7d, 0x00, 0x14, 0x2b, 0xe8, 0x1f, 0xc9, 0x27, 0x8c,
	0xb2, 0x3a, 0x4d, 0x1d, 0x79, 0xd2, 0x7c, 0x8d, 0x3c, 0x44, 0x40, 0xb2,
	0xc8, 0x42, 0xbc, 0x1e, 0x21, 0xf6, 0x92, 0x4e, 0x14, 0xdc, 0x83, 0x1b,
	0x0a, 0xbf, 0xb8, 0x45
};
static const uint8_t nist_kas_ecc_cdh_testvector_343_public_y[] = {
/* QCAVSy */
	0x00, 0x0c, 0x73, 0xd5, 0x68, 0x7b, 0x04, 0x90, 0xcc, 0xc0, 0x7f, 0x65,
	0x41, 0x01, 0xac, 0xdd, 0xb3, 0x6c, 0xd0, 0xc2, 0xee, 0xcc, 0xe1, 0x65,
	0xdf, 0x27, 0x6f, 0x83, 0xbe, 0x21, 0x1d, 0x01, 0xd3, 0x0f, 0xf5, 0xc2,
	0x43, 0xf0, 0x90, 0x05, 0x72, 0xee, 0x6d, 0xf0, 0x7f, 0x53, 0x9d, 0xf6,
	0xa4, 0x68, 0x9b, 0x0b
};
static const uint8_t nist_kas_ecc_cdh_testvector_343_private[] = {
/* dIUT */
	0x00, 0xbf, 0xa5, 0x94, 0x85, 0x6c, 0x67, 0xc2, 0x83, 0x6b, 0x7f, 0xb1,
	0x71, 0xb6, 0x7c, 0x7a, 0x41, 0xae, 0x43, 0xef, 0x34, 0x50, 0x89, 0x80,
	0x24, 0xa9, 0x31, 0x36, 0x54, 0xfc, 0xf3, 0x1e, 0x1e, 0x1f, 0xba, 0xc7,
	0xad, 0x52, 0xb2, 0xbc, 0x43, 0x58, 0x97, 0x5a, 0x5c, 0x61, 0xab, 0x9f,
	0x4e, 0x3e, 0x4e, 0x9e
};
/* QIUTx = 00e1b5309a44800a916ad8a4d19b82a58b00ee048248050a6ed6c33ce1bc9701547e93d7c9042f8490654b73a2cd7d73f733c0bf */
/* QIUTy = 0180b20338746351faccfb9a3711a4e138457550bbf58316034c6f216a53749263dffe2359bddcdc89ec6446a9a4a9f4ef90c86d */
static const uint8_t nist_kas_ecc_cdh_testvector_343_out[] = {
/* ZIUT */
	0x01, 0x12, 0x74, 0x91, 0xff, 0x33, 0xa6, 0x7f, 0xfc, 0x47, 0x57, 0x41,
	0x6c, 0xd0, 0x2a, 0x08, 0x1c, 0xaf, 0xb7, 0x23, 0xaf, 0xf5, 0x2a, 0xf3,
	0x5b, 0x06, 0x9b, 0x89, 0x96, 0x3e, 0x8e, 0x3e, 0xf5, 0xbc, 0x19, 0xc5,
	0xa0, 0x93, 0xcc, 0xf5, 0x11, 0xe3, 0xc3, 0xc1, 0x9b, 0xe7, 0x89, 0x28,
	0x0e, 0x98, 0x68, 0x09
};
/* COUNT = 18 */
static const uint8_t nist_kas_ecc_cdh_testvector_344_public_x[] = {
/* QCAVSx */
	0x01, 0x3d, 0x96, 0xa2, 0x67, 0xd1, 0xa2, 0xa9, 0xea, 0x83, 0xae, 0xb1,
	0xb0, 0x1d, 0x8a, 0xce, 0x22, 0xe2, 0x51, 0xc8, 0x2f, 0x5f, 0x5f, 0xc3,
	0xef, 0x59, 0x97, 0xa3, 0x01, 0x1a, 0x74, 0xa1, 0x01, 0x15, 0xdf, 0x60,
	0xe9, 0x8d, 0x13, 0x9c, 0xdd, 0x36, 0x0e, 0x74, 0xd7, 0x6f, 0xa5, 0x22,
	0xee, 0xb5, 0x6f, 0x4b
};
static const uint8_t nist_kas_ecc_cdh_testvector_344_public_y[] = {
/* QCAVSy */
	0x01, 0x6b, 0x65, 0x5a, 0xb7, 0xcd, 0x0d, 0x39, 0xf5, 0x88, 0xfb, 0xef,
	0xec, 0x54, 0xe4, 0xf4, 0x50, 0x47, 0x66, 0x4c, 0x8b, 0x3b, 0xe8, 0xe5,
	0x7a, 0xb1, 0x13, 0x77, 0x0f, 0x5f, 0xe0, 0xc6, 0x23, 0x00, 0xf4, 0xa0,
	0x9f, 0xa2, 0x89, 0x9e, 0x73, 0xbb, 0xc9, 0x82, 0x32, 0x65, 0xf5, 0x5d,
	0x5c, 0xf4, 0xae, 0x18
};
static const uint8_t nist_kas_ecc_cdh_testvector_344_private[] = {
/* dIUT */
	0x00, 0x4a, 0x02, 0x0e, 0x06, 0xc4, 0x00, 0xef, 0x24, 0x98, 0xc1, 0x11,
	0xcd, 0xe1, 0x50, 0x87, 0xcd, 0xa4, 0x8a, 0x6f, 0xb2, 0xec, 0xc0, 0x1d,
	0x98, 0x5b, 0x57, 0xf0, 0xd3, 0x92, 0x19, 0x20, 0xe9, 0x2c, 0x43, 0xf3,
	0xab, 0x68, 0x81, 0x29, 0xdc, 0x01, 0xad, 0x29, 0xfc, 0x31, 0xd6, 0x8e,
	0x96, 0x22, 0x31, 0x9b
};
/* QIUTx = 0167227f62849594ed63f247f780b2d11dd9a2c2c71bd6b71294cf8b59ce690bfe00da9bc1db8d1daac9bff8c00e7bdf071fe0d3 */
/* QIUTy = 0136c3ea77d093d9739fbe6891318b14959778599bd1e7d5a97bfc82ffe85fd5a9a01b82f72e11fad96d2f5cb5798f59efea15ed */
static const uint8_t nist_kas_ecc_cdh_testvector_344_out[] = {
/* ZIUT */
	0x01, 0x25, 0x45, 0x08, 0x55, 0x3e, 0xab, 0x09, 0xfb, 0xc2, 0xfa, 0xfe,
	0x13, 0xfa, 0x9b, 0x32, 0x4d, 0x92, 0x17, 0xd7, 0xd0, 0xba, 0x4c, 0xed,
	0xbe, 0x5d, 0xc8, 0x69, 0xad, 0x68, 0xde, 0x4f, 0x87, 0x77, 0x4d, 0xd1,
	0x7d, 0x64, 0x28, 0xed, 0x24, 0x2c, 0x71, 0x95, 0x6f, 0x25, 0x29, 0x69,
	0xe6, 0xbd, 0x58, 0x37
};
/* COUNT = 19 */
static const uint8_t nist_kas_ecc_cdh_testvector_345_public_x[] = {
/* QCAVSx */
	0x01, 0x78, 0x7b, 0x30, 0xb3, 0xb2, 0x04, 0xe2, 0x98, 0x69, 0x0b, 0x9d,
	0x71, 0x1f, 0xfe, 0xef, 0x16, 0x7a, 0xdc, 0x57, 0x92, 0x06, 0x8b, 0x5c,
	0x8d, 0x42, 0x2e, 0xc9, 0x0f, 0x94, 0xc2, 0xbd, 0xd2, 0x84, 0xcd, 0xbf,
	0x8b, 0xee, 0x64, 0x2f, 0x70, 0xbd, 0x7b, 0xe2, 0xda, 0x90, 0x6b, 0x9e,
	0xdb, 0xbc, 0x2c, 0xd1
};
static const uint8_t nist_kas_ecc_cdh_testvector_345_public_y[] = {
/* QCAVSy */
	0x00, 0x43, 0x07, 0x8f, 0x91, 0x21, 0x10, 0x29, 0x0a, 0x13, 0xd9, 0x01,
	0x60, 0xf0, 0xe7, 0x15, 0x82, 0xfa, 0x39, 0xc0, 0xe7, 0x5d, 0x81, 0x90,
	0xeb, 0x81, 0x1d, 0x45, 0x02, 0x20, 0x04, 0x4c, 0xc6, 0xd6, 0x80, 0xd9,
	0x56, 0xa9, 0x88, 0x60, 0xe6, 0xfc, 0x85, 0xbb, 0x86, 0xd6, 0x59, 0x90,
	0xa1, 0x60, 0xc5, 0xb8
};
static const uint8_t nist_kas_ecc_cdh_testvector_345_private[] = {
/* dIUT */
	0x00, 0xc1, 0x9b, 0x39, 0x16, 0x65, 0xf5, 0x03, 0x53, 0x54, 0x7f, 0xc7,
	0x2c, 0x9e, 0xd0, 0x19, 0xf5, 0x31, 0x16, 0x90, 0xee, 0x41, 0xe7, 0xc8,
	0x95, 0xaa, 0x7e, 0xf9, 0x2c, 0x60, 0xfb, 0x9f, 0x34, 0x54, 0xdf, 0xac,
	0x57, 0x52, 0x45, 0xa6, 0x86, 0x9f, 0x1f, 0xde, 0xc7, 0x45, 0xd6, 0x3e,
	0xa5, 0x6c, 0x89, 0x22
};
/* QIUTx = 0053a7a62a8b4044b60af76efa5b44429bf65f65987d6a062163dd55f08dc9a91b8bb9b6270f8a026123f99eb9372ccbdd27ca3b */
/* QIUTy = 00add46f7ea7092f48ddaa2feb96cb24bf92d2628fb6e4f7cddf523e5f84011cf8aababd6009a13f29a63b6b7ee664c66f3829f3 */
static const uint8_t nist_kas_ecc_cdh_testvector_345_out[] = {
/* ZIUT */
	0x00, 0x4b, 0x9a, 0xcc, 0xc2, 0x1d, 0x71, 0x22, 0x83, 0x5f, 0xc2, 0x14,
	0x10, 0xed, 0x1d, 0x83, 0x76, 0x7c, 0x47, 0xa5, 0x4f, 0xfe, 0xe5, 0xf0,
	0xc1, 0x80, 0xfc, 0x55, 0xf3, 0xd0, 0xe8, 0x48, 0x4a, 0xf3, 0xad, 0x38,
	0x02, 0x02, 0x94, 0xbe, 0x92, 0xf0, 0x2f, 0x0b, 0xa7, 0xe2, 0xb4, 0xf4,
	0xeb, 0x1d, 0xb0, 0x7f
};
/* COUNT = 20 */
static const uint8_t nist_kas_ecc_cdh_testvector_346_public_x[] = {
/* QCAVSx */
	0x01, 0xe9, 0xda, 0x0a, 0xd1, 0xa1, 0x5a, 0xc3, 0xc4, 0x31, 0xf2, 0x20,
	0x95, 0x4e, 0xd2, 0xe5, 0x02, 0xaf, 0x7b, 0x74, 0x6c, 0x3f, 0xd5, 0x7b,
	0x2e, 0xce, 0xb7, 0x74, 0x86, 0x58, 0x02, 0x0a, 0x09, 0x56, 0x64, 0x87,
	0x83, 0x54, 0xdf, 0x0a, 0xa1, 0x81, 0xe5, 0x7e, 0x5e, 0xad, 0x2c, 0x98,
	0x5a, 0xd3, 0x02, 0x3d
};
static const uint8_t nist_kas_ecc_cdh_testvector_346_public_y[] = {
/* QCAVSy */
	0x00, 0x9c, 0xce, 0x73, 0xa5, 0x47, 0x08, 0x34, 0x8b, 0x48, 0xf8, 0xf3,
	0xf6, 0x74, 0xbb, 0x76, 0x54, 0xf4, 0x41, 0xf2, 0x83, 0xd4, 0xe8, 0xa4,
	0xec, 0x8f, 0x85, 0x92, 0xef, 0x52, 0x39, 0x5f, 0x24, 0xc1, 0x12, 0xd5,
	0x94, 0x2d, 0x3a, 0xe0, 0x8f, 0xfe, 0x8d, 0x99, 0x9e, 0xfd, 0xe3, 0x99,
	0x88, 0x8a, 0x7c, 0xf3
};
static const uint8_t nist_kas_ecc_cdh_testvector_346_private[] = {
/* dIUT */
	0x00, 0x6c, 0x90, 0x98, 0xb5, 0x3d, 0x10, 0xf2, 0xac, 0x02, 0x84, 0xa9,
	0x99, 0x02, 0x65, 0x8f, 0x66, 0x7e, 0xa4, 0xca, 0xb2, 0x86, 0x98, 0xaf,
	0x3f, 0xa0, 0x70, 0x06, 0xa1, 0xbb, 0x46, 0x36, 0x3b, 0x10, 0x3c, 0x4a,
	0xa4, 0xc9, 0x2c, 0x1c, 0x3f, 0xe7, 0x53, 0x90, 0x97, 0xfa, 0x70, 0xb8,
	0xa4, 0xfa, 0x46, 0xc5
};
/* QIUTx = 00d3edf652f43f9c9a92a2e4d34ba83f5d7e950c28346a2a6851bf75547050140a4e9c1c1b500e1d2ad364c306b9a44af503a621 */
/* QIUTy = 0099b26c64367f1903da95df51562d25042c01a1adda75bba58bdb0d8aab350b52ecfbe98488c2619de01cd70f5e008953bca547 */
static const uint8_t nist_kas_ecc_cdh_testvector_346_out[] = {
/* ZIUT */
	0x00, 0x93, 0xe2, 0x58, 0x1c, 0x15, 0x9d, 0x74, 0xd1, 0x1f, 0x86, 0x67,
	0xee, 0x03, 0x39, 0x92, 0x08, 0xb5, 0xc1, 0xa4, 0xee, 0x5b, 0x20, 0x07,
	0x0c, 0xe8, 0xd9, 0x7d, 0x25, 0x1e, 0xf1, 0x23, 0x6d, 0xc8, 0x1d, 0xd6,
	0x88, 0xb2, 0xf0, 0x7a, 0x73, 0x0e, 0x6b, 0x8a, 0xec, 0xa0, 0xc1, 0x93,
	0xa2, 0x8b, 0x17, 0x8f
};
/* COUNT = 21 */
static const uint8_t nist_kas_ecc_cdh_testvector_347_public_x[] = {
/* QCAVSx */
	0x00, 0xc4, 0x92, 0x94, 0xfb, 0x71, 0x29, 0x42, 0x22, 0x1a, 0x25, 0x00,
	0x32, 0x4a, 0xf7, 0xbd, 0x8c, 0x7e, 0xc1, 0xcd, 0x1b, 0x80, 0x94, 0xde,
	0xd1, 0xba, 0xc0, 0x01, 0x0a, 0x86, 0x96, 0x08, 0x3f, 0x7e, 0xfa, 0xec,
	0xaa, 0x51, 0x03, 0xd6, 0x76, 0x24, 0x99, 0xe1, 0xbe, 0x48, 0x57, 0xd3,
	0x20, 0x03, 0x02, 0x81
};
static const uint8_t nist_kas_ecc_cdh_testvector_347_public_y[] = {
/* QCAVSy */
	0x00, 0x56, 0x4f, 0xa1, 0x11, 0x0b, 0x39, 0x39, 0x25, 0xdf, 0xbb, 0x24,
	0xba, 0x9a, 0x6b, 0x33, 0x73, 0xf4, 0x62, 0x4e, 0xcb, 0xc3, 0xe1, 0x2f,
	0x97, 0x06, 0xf3, 0xab, 0x05, 0x42, 0x99, 0x2d, 0x8d, 0xb6, 0xc8, 0xd8,
	0xbb, 0x25, 0xfa, 0x06, 0x14, 0xd4, 0x86, 0xf6, 0xd1, 0xac, 0x9f, 0x3d,
	0x98, 0xb9, 0xed, 0xfe
};
static const uint8_t nist_kas_ecc_cdh_testvector_347_private[] = {
/* dIUT */
	0x00, 0xa7, 0xfa, 0x38, 0xa8, 0xab, 0x80, 0x30, 0xd6, 0xb4, 0x97, 0xa2,
	0x3b, 0xde, 0x5e, 0x50, 0x07, 0xe3, 0x9d, 0x14, 0xda, 0x9f, 0x82, 0xdc,
	0x56, 0x4a, 0xe3, 0xcd, 0xb4, 0xaf, 0x5f, 0xcf, 0x41, 0xbc, 0xfe, 0xf7,
	0xad, 0xad, 0xb5, 0x91, 0x71, 0xe6, 0xd7, 0xd3, 0xd3, 0xc3, 0xac, 0x67,
	0xf7, 0xbe, 0x70, 0x73
};
/* QIUTx = 0013bb3ba91d5d2488af572d995cef8fffb1fd85d113421e8d2c0c3aa97cdb8a933fc0d3f05f4646ce841ebdcf1a98604bffa3df */
/* QIUTy = 01f2e04ea16a012d4864cf2ca7564846de73a33f24578dc4d221359c4f2f86ca823cb0596bfe4760e9eadcb4ad508ab1a171ecbd */
static const uint8_t nist_kas_ecc_cdh_testvector_347_out[] = {
/* ZIUT */
	0x00, 0x8e, 0x2f, 0x1c, 0x4b, 0xad, 0x19, 0xc4, 0x6a, 0x51, 0x34, 0xaf,
	0xcc, 0xf7, 0xf4, 0xec, 0x14, 0xab, 0x59, 0x1c, 0x8b, 0x8e, 0xa4, 0x8d,
	0x9c, 0x3d, 0x1e, 0x73, 0x54, 0xab, 0x43, 0xba, 0x20, 0xaa, 0x39, 0xa6,
	0x5f, 0xd9, 0x2c, 0xdc, 0x17, 0x6c, 0xf3, 0xde, 0xde, 0xcb, 0xf9, 0xda,
	0x49, 0xa8, 0xd8, 0x55
};
/* COUNT = 22 */
static const uint8_t nist_kas_ecc_cdh_testvector_348_public_x[] = {
/* QCAVSx */
	0x01, 0x34, 0xad, 0xd2, 0xc4, 0x99, 0x17, 0x2d, 0xf7, 0x92, 0xd9, 0x4a,
	0x9b, 0x38, 0x95, 0xe2, 0x45, 0xb8, 0x40, 0x73, 0xc3, 0x25, 0x26, 0x3a,
	0x85, 0x8c, 0x1e, 0x9f, 0x7c, 0xf3, 0x0a, 0x44, 0xf2, 0x68, 0xd3, 0xf8,
	0x35, 0x84, 0x11, 0xdc, 0x0a, 0x9c, 0xaa, 0xb5, 0x05, 0xc0, 0xab, 0xc0,
	0x16, 0x13, 0x0b, 0xf5
};
static const uint8_t nist_kas_ecc_cdh_testvector_348_public_y[] = {
/* QCAVSy */
	0x00, 0x31, 0xc2, 0x36, 0xb1, 0x43, 0xca, 0x03, 0x6c, 0x88, 0x36, 0x41,
	0xf7, 0xf9, 0xb9, 0x57, 0xf4, 0xf7, 0x98, 0xa3, 0x16, 0x67, 0xc4, 0x15,
	0x60, 0x34, 0x02, 0x79, 0xfc, 0xe0, 0x96, 0x2a, 0x21, 0xbd, 0x8b, 0xb5,
	0x2f, 0xa2, 0x3d, 0xb7, 0x1a, 0x84, 0xf3, 0x5a, 0x57, 0x94, 0xef, 0x5e,
	0x07, 0x59, 0x72, 0xdd
};
static const uint8_t nist_kas_ecc_cdh_testvector_348_private[] = {
/* dIUT */
	0x00, 0xce, 0x9f, 0x82, 0x7b, 0xd2, 0x4c, 0x01, 0x4c, 0x3e, 0xe5, 0x9e,
	0xde, 0xf7, 0x47, 0x17, 0x8d, 0x6c, 0x03, 0x0c, 0x19, 0x66, 0x9a, 0xd8,
	0xe7, 0x18, 0xba, 0x13, 0x02, 0xbe, 0xf4, 0xb5, 0xad, 0x2c, 0x12, 0x33,
	0x44, 0x8f, 0x52, 0x75, 0xb2, 0x9a, 0x89, 0x6c, 0x0b, 0x2e, 0x7b, 0x0d,
	0xa9, 0x20, 0x68, 0xbe
};
/* QIUTx = 0176e31012d9c604b2d1a1922a28d8a574f060cc36388b2816d2f8117da20c0699ab0a08f76fbaa476f0a9c424bf4c952b4754fd */
/* QIUTy = 011fedc3e8f8e828e0ffbf02fd85d29c0201fd0f53bf2614c10ae51ccb58cbc4900c38cc4c9a52d86d89f9b8c2de4e227f4e228e */
static const uint8_t nist_kas_ecc_cdh_testvector_348_out[] = {
/* ZIUT */
	0x01, 0x90, 0xa1, 0x69, 0x3e, 0xeb, 0xe2, 0x87, 0xec, 0x98, 0x02, 0x36,
	0xd8, 0x76, 0x28, 0x04, 0xd2, 0x3f, 0xdb, 0x6f, 0x22, 0x27, 0x63, 0xa0,
	0xef, 0xc3, 0x64, 0xf9, 0x28, 0x0f, 0xdd, 0x53, 0x39, 0x4c, 0x2b, 0xad,
	0xcc, 0x51, 0xff, 0x09, 0x55, 0x7f, 0x3b, 0x97, 0xca, 0xe7, 0xf7, 0x0d,
	0x79, 0x0b, 0xf9, 0xdf
};
/* COUNT = 23 */
static const uint8_t nist_kas_ecc_cdh_testvector_349_public_x[] = {
/* QCAVSx */
	0x00, 0xf0, 0xec, 0x97, 0x2d, 0xc9, 0xfd, 0xfd, 0x08, 0xcd, 0x8d, 0xfc,
	0xba, 0x72, 0x98, 0xb4, 0xdf, 0x2d, 0xbd, 0x80, 0xc2, 0x0b, 0x28, 0x89,
	0xe6, 0x63, 0xac, 0x58, 0xcc, 0x34, 0x8c, 0xbf, 0x8f, 0x9f, 0xfd, 0x31,
	0xff, 0xb5, 0x06, 0x18, 0xd6, 0xc3, 0x8d, 0x72, 0xa9, 0x9d, 0x5c, 0x5d,
	0x2e, 0xac, 0xc0, 0x01
};
static const uint8_t nist_kas_ecc_cdh_testvector_349_public_y[] = {
/* QCAVSy */
	0x00, 0xbb, 0x0b, 0x48, 0x89, 0x3c, 0xdb, 0x91, 0x5e, 0x65, 0xcd, 0x5d,
	0x79, 0x78, 0x04, 0x80, 0x20, 0x17, 0xa2, 0x95, 0x34, 0x36, 0x54, 0x24,
	0x6a, 0x37, 0xfe, 0x3a, 0x60, 0xd7, 0xde, 0x98, 0x7e, 0x6a, 0x9a, 0x10,
	0xaa, 0xf0, 0x63, 0xd9, 0x6b, 0x10, 0x18, 0x46, 0x12, 0xcc, 0xd2, 0x64,
	0x07, 0xd7, 0xe0, 0x3e
};
static const uint8_t nist_kas_ecc_cdh_testvector_349_private[] = {
/* dIUT */
	0x00, 0xe3, 0x6f, 0x3b, 0x9a, 0x13, 0x41, 0x99, 0x5b, 0x13, 0xfe, 0x70,
	0xbc, 0x54, 0x5d, 0x27, 0x9e, 0x6d, 0xb1, 0x48, 0x2c, 0x92, 0xb1, 0x3c,
	0xe8, 0xcc, 0x0d, 0xa1, 0xc1, 0x00, 0xea, 0x2f, 0xaa, 0x80, 0x3a, 0x64,
	0xa5, 0x8c, 0xc7, 0xeb, 0x1c, 0xfd, 0x16, 0x75, 0x70, 0x83, 0x5c, 0x52,
	0x2f, 0x65, 0x93, 0x47
};
/* QIUTx = 00d1ca82393b8d50bd1898a909bf39333eca3bde98b0b0dced66f828630e69e6eb128b7cec23f07260047073260a765331dd6f57 */
/* QIUTy = 006c535ff943a0fe750fc6c39904a6912ba1ebc0f46c1b0823e4013c77475ea29b3f32481966f1b165bedba6c17a1494fb6d4f3d */
static const uint8_t nist_kas_ecc_cdh_testvector_349_out[] = {
/* ZIUT */
	0x00, 0x14, 0x69, 0xda, 0xbc, 0xf2, 0x21, 0x0a, 0xa7, 0xde, 0x00, 0x40,
	0xb2, 0x01, 0x22, 0x1e, 0xb4, 0xd1, 0xa4, 0x72, 0x54, 0x31, 0xfb, 0x5a,
	0x93, 0x21, 0x2a, 0x66, 0xdd, 0xea, 0x41, 0x87, 0xe0, 0x78, 0xf5, 0xe3,
	0xd8, 0x26, 0x06, 0xf6, 0xcd, 0xfc, 0x0f, 0xfe, 0x6b, 0x69, 0x57, 0x4d,
	0x1d, 0x0b, 0xa6, 0x43
};
/* COUNT = 24 */
static const uint8_t nist_kas_ecc_cdh_testvector_350_public_x[] = {
/* QCAVSx */
	0x01, 0x37, 0x84, 0x44, 0xe0, 0xde, 0xec, 0xff, 0x3a, 0xec, 0x5a, 0xb6,
	0xe7, 0x4e, 0x81, 0x23, 0xba, 0x98, 0xd8, 0xb9, 0x1a, 0x50, 0x7c, 0xfc,
	0xa0, 0xd8, 0x50, 0x97, 0xaa, 0xd9, 0x44, 0xc1, 0x5b, 0x4f, 0xd8, 0x9c,
	0x8c, 0xbe, 0x2c, 0x74, 0x51, 0xd8, 0xec, 0x64, 0x10, 0x45, 0x42, 0x1b,
	0x4b, 0xf6, 0x97, 0x8b
};
static const uint8_t nist_kas_ecc_cdh_testvector_350_public_y[] = {
/* QCAVSy */
	0x01, 0x64, 0x47, 0xc2, 0x13, 0xc9, 0x03, 0x5d, 0xe7, 0xbc, 0xc2, 0x9b,
	0xdd, 0x61, 0xd6, 0xee, 0x6e, 0xd5, 0x57, 0x9c, 0x36, 0xbe, 0xc5, 0x6b,
	0xc6, 0xb4, 0x4f, 0x92, 0x86, 0xbf, 0x9e, 0x99, 0xfa, 0xc9, 0x7f, 0x35,
	0x67, 0x08, 0xcd, 0x03, 0x10, 0xdb, 0xf6, 0x33, 0x8f, 0x9a, 0xf8, 0xd7,
	0xb1, 0x35, 0x91, 0x02
};
static const uint8_t nist_kas_ecc_cdh_testvector_350_private[] = {
/* dIUT */
	0x00, 0x08, 0xa0, 0x67, 0x16, 0xed, 0x6f, 0x4c, 0xf7, 0x28, 0xf9, 0x01,
	0x99, 0x28, 0xf3, 0x67, 0xc7, 0x7a, 0x90, 0x52, 0x49, 0x0b, 0x9a, 0x8b,
	0xa8, 0x7a, 0x59, 0xcd, 0xca, 0x84, 0xe7, 0x7c, 0x6a, 0x29, 0x98, 0x53,
	0xf5, 0x49, 0x6f, 0xeb, 0xe6, 0x52, 0xf4, 0xba, 0x33, 0x35, 0x01, 0xc4,
	0xfc, 0xf2, 0xba, 0x2f
};
/* QIUTx = 00a045b5e6bbb7950495f6d5d645a2b7d72006725d0223c7ff75534022c9260ab0d2d8d333789a3dccfc3a89502ca500bd0c1f61 */
/* QIUTy = 01ec556e1b1621ec1893654e198d5923e311478a8bd2ffff280c9092ffc0737289a997492b6e9ebf931947634ef7f43b429cf36a */
static const uint8_t nist_kas_ecc_cdh_testvector_350_out[] = {
/* ZIUT */
	0x00, 0x5c, 0x70, 0x1a, 0x93, 0xd7, 0x79, 0x03, 0x22, 0xaa, 0x7c, 0x67,
	0x44, 0x0f, 0xdd, 0x9e, 0xe8, 0x05, 0x7a, 0x0d, 0xae, 0x86, 0xd1, 0xe8,
	0x56, 0xae, 0x89, 0xe7, 0x89, 0x3d, 0xa1, 0x78, 0xbd, 0x67, 0x77, 0x7f,
	0x86, 0xdb, 0x2b, 0xe5, 0xc8, 0xe3, 0x1d, 0xc5, 0x0e, 0xd8, 0xa4, 0x40,
	0xaa, 0xbc, 0x34, 0x2d
};
/* [B-571] - GP NOT SUPPORTED */
/* COUNT = 0 */
static const uint8_t nist_kas_ecc_cdh_testvector_351_public_x[] = {
/* QCAVSx */
	0x03, 0xb6, 0x3f, 0x5f, 0xa1, 0x12, 0xae, 0x6b, 0x5f, 0x11, 0x3c, 0x76,
	0x51, 0x44, 0xfe, 0x4c, 0xbd, 0x60, 0x20, 0xe2, 0x6d, 0x40, 0x0c, 0x11,
	0x60, 0x9a, 0x3a, 0x63, 0x4b, 0x9a, 0x32, 0x5f, 0x41, 0x6b, 0x0e, 0x3d,
	0x32, 0x15, 0x73, 0x4c, 0x68, 0xa1, 0xc2, 0xc8, 0xfa, 0xd1, 0xd0, 0xbb,
	0x9e, 0xb3, 0x93, 0x9a, 0x41, 0xaf, 0x22, 0x42, 0x1f, 0x68, 0x78, 0x1e,
	0x7e, 0xb0, 0x66, 0x4b, 0x9d, 0xf5, 0xce, 0xa4, 0x48, 0xde, 0xaa, 0x3b
};
static const uint8_t nist_kas_ecc_cdh_testvector_351_public_y[] = {
/* QCAVSy */
	0x00, 0x8e, 0x6c, 0xc7, 0x7b, 0xcd, 0xdc, 0x81, 0x6e, 0x84, 0xcf, 0xc1,
	0xf6, 0x26, 0x82, 0x4f, 0xa2, 0x4d, 0x3d, 0x5f, 0xd3, 0x3d, 0x80, 0x93,
	0xcb, 0xfe, 0x1f, 0xc4, 0xd8, 0x81, 0xb6, 0x3b, 0x49, 0x41, 0x23, 0xbc,
	0x75, 0x96, 0x70, 0xed, 0xcb, 0x18, 0x87, 0xbb, 0x3b, 0x9d, 0x5a, 0x8b,
	0x51, 0x6b, 0xc5, 0x03, 0x82, 0x81, 0x63, 0x70, 0x9d, 0x4d, 0xac, 0xb5,
	0x94, 0xd2, 0x77, 0xa1, 0x5a, 0x92, 0xc0, 0x64, 0xe5, 0x77, 0x0d, 0x1b
};
static const uint8_t nist_kas_ecc_cdh_testvector_351_private[] = {
/* dIUT */
	0x03, 0x44, 0xf2, 0x2b, 0xe8, 0x79, 0x99, 0xb9, 0x5b, 0x22, 0x87, 0xf6,
	0x74, 0x30, 0xea, 0x8f, 0xe6, 0x46, 0xc6, 0x2f, 0xe3, 0x8b, 0x7c, 0xe6,
	0x1f, 0x1f, 0x95, 0x65, 0x97, 0xc2, 0x7b, 0xdd, 0xd9, 0x90, 0x2e, 0x20,
	0xd4, 0x43, 0x6a, 0xbf, 0x3b, 0xeb, 0xd8, 0x24, 0x3e, 0xc2, 0x9a, 0x00,
	0x48, 0x1a, 0x8a, 0x2c, 0x19, 0xf5, 0x50, 0xe9, 0x96, 0x41, 0xb5, 0xf1,
	0x4a, 0xaf, 0xbb, 0x5b, 0xda, 0x95, 0x3a, 0x75, 0x59, 0xf8, 0x65, 0x3a
};
/* QIUTx = 06af71fcec1a2904116fe14878663764c1ec74870e5d2d53919f0b635912db80dd5460d9e699458ff8494c5bfc74fba8d3b12f65f015e8def10de33f1800191f4cb502d21938b951 */
/* QIUTy = 019584177b189c6641ffb678b6d7833d8d4bb25dee5018dda4e4c0d219048c01cd0da9eaffe346d53cf1a07b33b3dbdd4bc3acabe4832f9981eff2660991aac852147985eea3a51e */
static const uint8_t nist_kas_ecc_cdh_testvector_351_out[] = {
/* ZIUT */
	0x06, 0x77, 0x5e, 0x1b, 0x99, 0xa2, 0x36, 0xe0, 0x2b, 0x02, 0x0b, 0xc7,
	0x36, 0x66, 0xe5, 0x75, 0x1c, 0x12, 0x10, 0xdc, 0xb6, 0xe9, 0xb0, 0x2a,
	0x69, 0xf4, 0x07, 0x53, 0x76, 0xe4, 0x9f, 0x7a, 0x14, 0x76, 0xd2, 0x20,
	0x9e, 0x86, 0x1a, 0xbb, 0x73, 0xf5, 0xe3, 0xad, 0x18, 0x9d, 0x26, 0x8e,
	0x03, 0x5b, 0x1d, 0xe9, 0x3d, 0x47, 0xb3, 0xa6, 0x4d, 0xe5, 0x78, 0x3c,
	0x9a, 0x09, 0xbc, 0x22, 0x3e, 0x1c, 0xc6, 0x12, 0xf2, 0x6d, 0xcd, 0xf1
};
/* COUNT = 1 */
static const uint8_t nist_kas_ecc_cdh_testvector_352_public_x[] = {
/* QCAVSx */
	0x05, 0x75, 0xcb, 0xb0, 0x59, 0xf4, 0x23, 0x30, 0x9f, 0x99, 0x3b, 0x6c,
	0x06, 0xac, 0x71, 0xd7, 0xbc, 0xc5, 0xd1, 0xe6, 0xa1, 0x9a, 0xfe, 0x72,
	0x81, 0x1c, 0xb6, 0x12, 0xa6, 0x23, 0x8c, 0x9c, 0xcc, 0x33, 0x1e, 0x67,
	0xda, 0x0c, 0x10, 0xb8, 0x8c, 0xc2, 0xa5, 0xf1, 0xef, 0x2f, 0xf6, 0xd6,
	0xb7, 0x44, 0x06, 0x5d, 0x24, 0x2f, 0x59, 0x8d, 0xa2, 0xd6, 0x33, 0x5d,
	0x4c, 0x3b, 0xec, 0xf5, 0xc3, 0x95, 0x39, 0x40, 0xc6, 0x0e, 0xfc, 0xc7
};
static const uint8_t nist_kas_ecc_cdh_testvector_352_public_y[] = {
/* QCAVSy */
	0x06, 0xb4, 0x33, 0x65, 0x2e, 0x3a, 0x36, 0xa0, 0x70, 0x18, 0xaa, 0x8a,
	0xd3, 0xd2, 0xff, 0x31, 0xed, 0x78, 0x5c, 0xe5, 0x60, 0x17, 0x16, 0xef,
	0xf7, 0x71, 0x0f, 0xc1, 0x3c, 0x6f, 0xf9, 0xff, 0x75, 0xc7, 0xf3, 0x70,
	0x1d, 0x45, 0x9f, 0xd8, 0xfe, 0x70, 0xc0, 0xb4, 0xaf, 0xce, 0xda, 0x08,
	0x68, 0x17, 0x17, 0xdb, 0x98, 0x21, 0xd8, 0xc8, 0x58, 0xfd, 0x39, 0xe2,
	0x74, 0xff, 0x37, 0x77, 0x2f, 0x8e, 0x84, 0x85, 0x6e, 0x70, 0x67, 0x45
};
static const uint8_t nist_kas_ecc_cdh_testvector_352_private[] = {
/* dIUT */
	0x02, 0xf4, 0xd2, 0xb7, 0xe6, 0x36, 0x60, 0xe6, 0xc2, 0x09, 0x49, 0xe0,
	0x6d, 0xc6, 0x70, 0xbe, 0x8a, 0xaf, 0x82, 0x53, 0x0e, 0x0b, 0x6e, 0xaf,
	0xe2, 0x10, 0x11, 0xfe, 0x9d, 0x0f, 0x44, 0x07, 0xc8, 0x54, 0x95, 0x15,
	0x73, 0x45, 0x28, 0xcd, 0xa2, 0x99, 0xe9, 0xfc, 0xf7, 0x38, 0xa9, 0x7f,
	0xbf, 0x43, 0xc4, 0xbb, 0xa2, 0x67, 0x44, 0xb3, 0x27, 0x53, 0x1b, 0x40,
	0x14, 0x3e, 0x15, 0x8b, 0xc8, 0x64, 0x59, 0x09, 0xea, 0x88, 0x84, 0x56
};
/* QIUTx = 06ea711827ad8ed589b709ef35f6a9cd4625798bd887e5fe59c51f0f41c328b7ecdf84736c43fb70e3986ee5e5f986e009f641158a75cce6b39f53a8bf0682830194e4007148deef */
/* QIUTy = 04c6b9f2a6099fc0367fa9609394c3221ad8c6fb111d2bdc4305053804788d32eaf76431406e768a448cb5c8e34c81225eec9015abbd92725c002712ed3192d807b36afea853f722 */
static const uint8_t nist_kas_ecc_cdh_testvector_352_out[] = {
/* ZIUT */
	0x03, 0xa8, 0x0e, 0xa8, 0xcf, 0xec, 0xb8, 0x58, 0xf9, 0xb7, 0x7b, 0xdb,
	0x46, 0xb6, 0xcd, 0xa2, 0x63, 0x20, 0xee, 0x8c, 0x56, 0x1a, 0x2f, 0xd6,
	0xb7, 0xe0, 0xa2, 0xb6, 0x22, 0x01, 0xfb, 0xfe, 0x60, 0xf5, 0x77, 0x78,
	0x0c, 0x75, 0xa9, 0x8a, 0x11, 0xa6, 0x9d, 0xe4, 0xc4, 0xee, 0x91, 0x19,
	0x30, 0xd2, 0x20, 0x0b, 0x69, 0x72, 0xbc, 0x31, 0x23, 0xd7, 0xf2, 0x78,
	0x61, 0x5e, 0xcc, 0x65, 0x98, 0x4a, 0x59, 0xfe, 0x35, 0x2a, 0x1c, 0xec
};
/* COUNT = 2 */
static const uint8_t nist_kas_ecc_cdh_testvector_353_public_x[] = {
/* QCAVSx */
	0x06, 0x4a, 0xa6, 0x68, 0x30, 0xff, 0x44, 0x32, 0x4a, 0x67, 0xae, 0x8a,
	0x90, 0x78, 0x96, 0x89, 0x7b, 0x50, 0x75, 0x66, 0xcf, 0x52, 0xdf, 0xe1,
	0x3e, 0x3a, 0xdb, 0xb1, 0xe7, 0x93, 0x66, 0x5d, 0x2b, 0x71, 0x83, 0x58,
	0x75, 0x4e, 0xfe, 0x80, 0x9e, 0x44, 0x96, 0x21, 0x85, 0x02, 0xfe, 0xb5,
	0x60, 0x4d, 0xbf, 0xbc, 0x04, 0xa1, 0x10, 0x7c, 0xa9, 0xec, 0x4e, 0xad,
	0xc7, 0xd1, 0x0a, 0x9d, 0x6d, 0x14, 0x74, 0xce, 0xdf, 0x57, 0x81, 0x45
};
static const uint8_t nist_kas_ecc_cdh_testvector_353_public_y[] = {
/* QCAVSy */
	0x06, 0xf6, 0x3f, 0x69, 0xf8, 0xc1, 0x8b, 0x67, 0xf1, 0x10, 0x51, 0xb3,
	0xd3, 0x02, 0x36, 0xa1, 0xa2, 0x49, 0x08, 0x8b, 0x2b, 0xca, 0xb5, 0xcf,
	0xf8, 0x30, 0xcd, 0xb9, 0xeb, 0x3e, 0x75, 0xc1, 0xe8, 0x72, 0x52, 0xe5,
	0xd8, 0xe6, 0x1b, 0xb1, 0xa6, 0x63, 0x48, 0xfb, 0x68, 0x1e, 0x96, 0x2d,
	0x65, 0xab, 0xc5, 0x4d, 0x5d, 0xea, 0x2d, 0xd7, 0x2c, 0x55, 0x45, 0x90,
	0x74, 0x00, 0x74, 0xf7, 0xc6, 0x6c, 0x4b, 0x8d, 0xfd, 0x30, 0x75, 0x61
};
static const uint8_t nist_kas_ecc_cdh_testvector_353_private[] = {
/* dIUT */
	0x01, 0x2b, 0x63, 0x13, 0xb5, 0x68, 0x53, 0xcf, 0x8d, 0x02, 0x73, 0x04,
	0x9c, 0xf7, 0xed, 0x2a, 0xb8, 0xe6, 0x32, 0xe5, 0x92, 0x56, 0xed, 0x04,
	0x33, 0x66, 0x85, 0x76, 0x48, 0xf3, 0xf2, 0xa9, 0x67, 0x4c, 0xae, 0xb6,
	0xfb, 0x0f, 0xcd, 0x5f, 0xba, 0xb0, 0xbb, 0xab, 0xbc, 0xe1, 0x7a, 0x0f,
	0xc4, 0xa7, 0x81, 0x48, 0x49, 0x9c, 0x38, 0x9a, 0xf5, 0x74, 0x86, 0x37,
	0x46, 0x41, 0x69, 0x5b, 0x0e, 0x85, 0x2f, 0x31, 0x52, 0xee, 0xc7, 0x24
};
/* QIUTx = 040a78763d170459dd34b5c04ec782e698cbe903a5a348551c5248d9dacf19bcb9a498ea05e80e2d6cc1f3ea5ba3a43855b801c8c0356fe3e29ee224bb91f4ed0c85678379b72542 */
/* QIUTy = 01ff49ce0a62e9edae6aa63a9848e44f185412d0feb46b87f91424bdaffed5168321ed76f235f75d33667f6d7d6a9c857bb4f85442fc40f9a20c04ae06362a46eceea15c45d69beb */
static const uint8_t nist_kas_ecc_cdh_testvector_353_out[] = {
/* ZIUT */
	0x03, 0xed, 0xea, 0x7e, 0x47, 0xde, 0xd7, 0xc2, 0xab, 0x11, 0x15, 0xf4,
	0xeb, 0xcb, 0xb4, 0x26, 0x77, 0xc7, 0xfb, 0xa6, 0xe0, 0xcf, 0xd8, 0x11,
	0x60, 0x28, 0x96, 0x25, 0x1a, 0xda, 0x1d, 0x5a, 0x0b, 0x46, 0x1a, 0xaf,
	0x4e, 0x00, 0x0f, 0x4d, 0x42, 0x31, 0xb9, 0x6d, 0x8d, 0xee, 0x76, 0x30,
	0xd9, 0xf1, 0xb7, 0x86, 0x0e, 0x64, 0x18, 0xda, 0xc8, 0xc3, 0xb0, 0x7b,
	0x66, 0xaf, 0x6f, 0xd1, 0xac, 0xdb, 0x44, 0xb2, 0x68, 0x3b, 0x29, 0xb4
};
/* COUNT = 3 */
static const uint8_t nist_kas_ecc_cdh_testvector_354_public_x[] = {
/* QCAVSx */
	0x05, 0x06, 0x71, 0xaf, 0x65, 0xcb, 0xef, 0x92, 0xf3, 0x05, 0xe5, 0xfa,
	0xcb, 0x42, 0x88, 0xcc, 0x04, 0xa4, 0xc6, 0x97, 0x8a, 0x3b, 0x78, 0xaf,
	0xe4, 0x04, 0x9c, 0x6a, 0x99, 0x5f, 0xe8, 0xc3, 0xc0, 0xbb, 0x60, 0x9a,
	0xbe, 0x49, 0xd1, 0x52, 0xb1, 0xee, 0xd6, 0xc7, 0x14, 0xd2, 0x54, 0xfe,
	0x6e, 0xff, 0x15, 0x9a, 0x9e, 0xbd, 0x24, 0xad, 0x16, 0x91, 0x9e, 0xf7,
	0x6f, 0x44, 0x70, 0x05, 0x7e, 0xb7, 0xc2, 0x65, 0xa4, 0xbd, 0x96, 0xe8
};
static const uint8_t nist_kas_ecc_cdh_testvector_354_public_y[] = {
/* QCAVSy */
	0x05, 0x1d, 0x08, 0xe2, 0x1d, 0x26, 0x4d, 0x8e, 0x4d, 0xbc, 0x73, 0x40,
	0x88, 0x42, 0xab, 0x57, 0xcd, 0x78, 0xd3, 0x23, 0xe7, 0xde, 0xb6, 0x25,
	0xb3, 0x74, 0x19, 0x94, 0xb8, 0xaf, 0xfe, 0x01, 0xaf, 0x44, 0x61, 0x62,
	0x2d, 0xb4, 0x19, 0xaf, 0xee, 0xad, 0x04, 0x58, 0x45, 0xf6, 0xc3, 0xdb,
	0x6d, 0x98, 0x2f, 0x45, 0xb6, 0x92, 0xbe, 0xa1, 0x1c, 0xf2, 0x5d, 0x18,
	0xac, 0xa3, 0xc8, 0x3b, 0xec, 0x84, 0x0c, 0x75, 0x82, 0xa7, 0x06, 0x2d
};
static const uint8_t nist_kas_ecc_cdh_testvector_354_private[] = {
/* dIUT */
	0x02, 0x19, 0x97, 0xb5, 0x48, 0x1c, 0x0c, 0xf6, 0xcf, 0x43, 0x6b, 0xfe,
	0x36, 0x0c, 0x3b, 0x11, 0x9b, 0x9e, 0x4d, 0xd5, 0x6f, 0x3c, 0x28, 0x47,
	0xaf, 0xfb, 0x20, 0x21, 0xcb, 0xac, 0x4b, 0x57, 0xdc, 0x18, 0xf5, 0x07,
	0x5d, 0x67, 0x8a, 0xf2, 0xba, 0x6e, 0x9e, 0xef, 0xbc, 0x41, 0x38, 0xd8,
	0x18, 0x05, 0x3f, 0x2d, 0xf3, 0x2a, 0x10, 0xe8, 0xae, 0x5d, 0x64, 0x09,
	0xf5, 0xb2, 0xf1, 0xf3, 0xca, 0xbf, 0x36, 0xf8, 0x08, 0xfd, 0xc0, 0x7c
};
/* QIUTx = 0560cf91328c26bba13f71c9b5dddd05c185969d88bd0e9d34a3607a923b23a5b675452167003ae2f0add5141ea4be41ebae91d3a6aa15c393dbf585ad6c9214b269e86b4f054bf5 */
/* QIUTy = 02e32ec240418a9a4f9017e632f8a77897a2233d6f1f45b8f7aa818f847ddb3ceab5a5a12c754fce8d57b0320a076b53441dcf9f65ef3204e089191ef156ff762294897a72fca932 */
static const uint8_t nist_kas_ecc_cdh_testvector_354_out[] = {
/* ZIUT */
	0x00, 0x5b, 0x64, 0x00, 0x15, 0x33, 0x0f, 0x84, 0x16, 0xf2, 0xbb, 0xbf,
	0x8b, 0x56, 0x60, 0xe0, 0x1a, 0x7a, 0xbb, 0xa8, 0xb0, 0x19, 0x7a, 0x29,
	0xe5, 0x2b, 0xb5, 0x35, 0xd6, 0x2f, 0x89, 0xad, 0x04, 0x43, 0xe0, 0x8b,
	0x6e, 0x0d, 0x1d, 0x15, 0xf4, 0xeb, 0x03, 0xc0, 0xfe, 0x35, 0xe3, 0xe4,
	0x3b, 0xd7, 0x73, 0x9c, 0xb6, 0x92, 0x09, 0x26, 0x98, 0xa2, 0xcd, 0x13,
	0x12, 0x6c, 0xee, 0x44, 0x32, 0x83, 0x1e, 0xc7, 0x42, 0x3b, 0x34, 0x34
};
/* COUNT = 4 */
static const uint8_t nist_kas_ecc_cdh_testvector_355_public_x[] = {
/* QCAVSx */
	0x03, 0x9a, 0xc9, 0xe9, 0x1a, 0xf5, 0x94, 0x07, 0x4d, 0xcd, 0x33, 0x8d,
	0xa4, 0xf5, 0x24, 0x05, 0x74, 0xf0, 0x1e, 0x41, 0x3a, 0x49, 0xb9, 0x22,
	0x46, 0xba, 0x3d, 0x6d, 0xe8, 0x55, 0xe3, 0xde, 0xdf, 0x6e, 0x7f, 0xde,
	0xda, 0x9a, 0xb7, 0xf7, 0xf8, 0x47, 0x6e, 0x77, 0x0c, 0xe9, 0xbb, 0xc3,
	0xa9, 0xa5, 0xeb, 0x98, 0x45, 0x43, 0xdc, 0xc3, 0x7f, 0x5f, 0x11, 0xbe,
	0x6e, 0x28, 0xa1, 0xd1, 0x09, 0x09, 0x31, 0xf5, 0xc5, 0xb5, 0xa3, 0x51
};
static const uint8_t nist_kas_ecc_cdh_testvector_355_public_y[] = {
/* QCAVSy */
	0x07, 0x80, 0xd3, 0x2d, 0xbb, 0x13, 0x48, 0x99, 0xbd, 0xa2, 0xe9, 0x88,
	0x48, 0x94, 0x18, 0x78, 0x38, 0x7a, 0xba, 0x66, 0x65, 0xfd, 0x24, 0x25,
	0x21, 0x60, 0xce, 0x31, 0x23, 0xf6, 0x8f, 0x9b, 0x5b, 0xd8, 0xf2, 0x54,
	0xa3, 0x8b, 0x84, 0xec, 0x53, 0x65, 0x25, 0xfe, 0x00, 0x7a, 0x86, 0x3b,
	0x6f, 0xcc, 0x48, 0x9f, 0x93, 0x7a, 0x05, 0xa5, 0xfd, 0x94, 0x6d, 0x62,
	0x82, 0x53, 0x28, 0xa0, 0x9f, 0x83, 0xa7, 0xcb, 0xa2, 0x7f, 0xea, 0x5e
};
static const uint8_t nist_kas_ecc_cdh_testvector_355_private[] = {
/* dIUT */
	0x02, 0xb5, 0x39, 0xac, 0xc7, 0x70, 0x75, 0x87, 0x99, 0xf4, 0x39, 0x67,
	0x0e, 0xae, 0x85, 0xb9, 0xba, 0x34, 0xa8, 0xb4, 0xf3, 0x71, 0xcc, 0x93,
	0x5a, 0x20, 0xce, 0x8c, 0x56, 0x65, 0x21, 0xee, 0xcd, 0x8c, 0x4f, 0x5a,
	0xff, 0x11, 0x6a, 0xe0, 0xdb, 0x2a, 0xd6, 0xea, 0xe1, 0xa3, 0x38, 0x44,
	0x34, 0xc5, 0x99, 0x37, 0x98, 0x21, 0xad, 0x05, 0xd8, 0x1a, 0xda, 0x05,
	0x48, 0x29, 0x9d, 0xfd, 0x98, 0xcf, 0xd6, 0xd3, 0xf1, 0x57, 0x35, 0x24
};
/* QIUTx = 06dae538c820443977415cef4e79974ba762b69b434810200cc6fff326a2344cd21be19c153642df82a3e57a5531a8bf19767e1995d2728fcb661d58ec561ef23a34d8607971490d */
/* QIUTy = 0504243c792b903184ea725a947ca89218ca9c8fa1e09a7dd68de88eae90f9bd2a8df414dd69a8b2b1a2ded2c6d7f514c8907997624eb0bc9ea933a2d474ef8f83baea3243834de2 */
static const uint8_t nist_kas_ecc_cdh_testvector_355_out[] = {
/* ZIUT */
	0x02, 0x7a, 0xf0, 0x5e, 0xcd, 0x03, 0x32, 0x78, 0x4d, 0x64, 0xb0, 0xb1,
	0xbd, 0xb4, 0x5c, 0x31, 0x0f, 0xd4, 0x45, 0xc5, 0xa6, 0xd6, 0xb3, 0x4f,
	0x35, 0xf4, 0xea, 0xa3, 0xfa, 0x3e, 0x17, 0x1a, 0xb9, 0x87, 0x63, 0xd2,
	0x43, 0xa1, 0xde, 0xdf, 0x46, 0xaa, 0x29, 0x86, 0x46, 0x20, 0xa4, 0x7d,
	0x05, 0xee, 0xae, 0xfd, 0x74, 0x81, 0x86, 0xbc, 0xbc, 0xf1, 0x87, 0xc0,
	0x1e, 0x7c, 0xe3, 0x6e, 0x2a, 0x53, 0xde, 0xd0, 0x71, 0x03, 0x6b, 0x59
};
/* COUNT = 5 */
static const uint8_t nist_kas_ecc_cdh_testvector_356_public_x[] = {
/* QCAVSx */
	0x06, 0xf6, 0x58, 0x84, 0x91, 0x06, 0x0a, 0x1e, 0x88, 0x14, 0x8e, 0x4b,
	0xde, 0xe3, 0x8b, 0xc6, 0x74, 0x71, 0x3f, 0xe3, 0x84, 0xd7, 0xcf, 0xdb,
	0xf5, 0xbd, 0x90, 0xc9, 0xdb, 0xb6, 0xe1, 0x58, 0x7e, 0x45, 0x9d, 0xce,
	0x6e, 0x0d, 0x69, 0xb8, 0xb2, 0xcf, 0xeb, 0x50, 0x55, 0xbe, 0xe5, 0x6a,
	0x73, 0xc1, 0x34, 0x36, 0x06, 0x01, 0x98, 0xad, 0x47, 0x50, 0xda, 0xe8,
	0x25, 0x3e, 0xa8, 0x39, 0xa2, 0xe2, 0x46, 0xd5, 0x41, 0x45, 0x97, 0x75
};
static const uint8_t nist_kas_ecc_cdh_testvector_356_public_y[] = {
/* QCAVSy */
	0x05, 0xb6, 0x1b, 0x8f, 0x7d, 0x8d, 0x6c, 0x81, 0x62, 0xa2, 0x26, 0x9e,
	0x72, 0x87, 0xd4, 0x59, 0x03, 0x4b, 0x8f, 0xaa, 0xc0, 0x36, 0x0f, 0xcf,
	0x99, 0xfb, 0x21, 0xda, 0x34, 0xa3, 0x14, 0xe6, 0x73, 0x53, 0x19, 0xb9,
	0xd0, 0x36, 0x26, 0xb9, 0x26, 0x83, 0x69, 0x34, 0x5f, 0x3a, 0x62, 0x4a,
	0xca, 0xdb, 0x21, 0x9b, 0x20, 0x71, 0x88, 0xd0, 0xe9, 0x45, 0xcb, 0xc6,
	0x7c, 0x98, 0x20, 0x68, 0xd3, 0x26, 0x13, 0xfc, 0x21, 0xf8, 0xb0, 0xf4
};
static const uint8_t nist_kas_ecc_cdh_testvector_356_private[] = {
/* dIUT */
	0x03, 0x18, 0xa9, 0x6e, 0x38, 0x27, 0x82, 0xd4, 0x47, 0x6f, 0x1b, 0xeb,
	0xf6, 0x97, 0xa1, 0x07, 0x6f, 0x22, 0xe1, 0xd2, 0xec, 0x84, 0x74, 0x7f,
	0x9f, 0xc4, 0x25, 0x05, 0xd5, 0x54, 0x7d, 0xaa, 0xa0, 0x8d, 0x81, 0x47,
	0x21, 0x75, 0x96, 0x59, 0x95, 0x86, 0x85, 0xcf, 0x4e, 0xa4, 0xbb, 0xa1,
	0x2f, 0xff, 0xb6, 0x6a, 0xf0, 0x9f, 0x66, 0x94, 0x52, 0x1f, 0x11, 0xc0,
	0x9b, 0x66, 0x26, 0xc8, 0xae, 0x52, 0xfb, 0xfb, 0x33, 0x6a, 0x52, 0xa1
};
/* QIUTx = 06770f2fcd2e9b7f8bc5c292d283abad85155071fe37ef7ce84f34c7616da3dbe1bdce9ab04cea7bc4bc258c5d2ab77239d3d084568b2dff779988288d9fc6bb364f519d0e855ad3 */
/* QIUTy = 04f6a1f4e5fe00fe9a25d8459b88803988ef2bf2fef5a23f13e7a7e7f3459abfc3d5c00303abcc5080fab81b09d5be0320ef990519a06af13c29562ee955715a82cc0daef2c5e0eb */
static const uint8_t nist_kas_ecc_cdh_testvector_356_out[] = {
/* ZIUT */
	0x07, 0x63, 0xc0, 0xd6, 0x59, 0xa7, 0xc0, 0x80, 0x91, 0x20, 0x05, 0xa2,
	0xaf, 0xd6, 0x0c, 0xe5, 0x7e, 0x61, 0x06, 0x19, 0xb3, 0x88, 0xef, 0x3d,
	0x5d, 0xd3, 0xc9, 0x38, 0x6a, 0xb1, 0x20, 0x69, 0xc6, 0xef, 0x3a, 0x8e,
	0x72, 0xeb, 0x74, 0x1c, 0xba, 0x2d, 0xa5, 0xc6, 0xf9, 0x26, 0x7f, 0x6c,
	0x09, 0xfa, 0xda, 0x64, 0x59, 0x69, 0x0e, 0xd4, 0xe4, 0x32, 0x44, 0x5d,
	0x6f, 0x0f, 0x72, 0xdb, 0xcb, 0x05, 0x9c, 0x87, 0xdf, 0x36, 0xf6, 0x65
};
/* COUNT = 6 */
static const uint8_t nist_kas_ecc_cdh_testvector_357_public_x[] = {
/* QCAVSx */
	0x05, 0xa5, 0x2c, 0xeb, 0xf6, 0x81, 0x03, 0xca, 0xb0, 0x26, 0x6c, 0xf2,
	0xc6, 0x89, 0xc4, 0x8f, 0x08, 0x05, 0x49, 0xff, 0xfc, 0x70, 0xdb, 0x98,
	0x09, 0xc2, 0xa4, 0x6f, 0x90, 0x8b, 0x72, 0x89, 0xbe, 0x59, 0x73, 0x29,
	0xf3, 0x9e, 0xe1, 0xe4, 0xcc, 0xa3, 0x98, 0x66, 0x4f, 0xfa, 0x9b, 0xdc,
	0xf0, 0x12, 0x93, 0xf4, 0x35, 0x93, 0xd1, 0x88, 0xe1, 0x24, 0x11, 0xd5,
	0x7e, 0x55, 0x9b, 0x3f, 0x6a, 0x30, 0xe9, 0x55, 0x48, 0x69, 0xf0, 0x49
};
static const uint8_t nist_kas_ecc_cdh_testvector_357_public_y[] = {
/* QCAVSy */
	0x01, 0x4e, 0x13, 0x71, 0x65, 0xfb, 0x0d, 0x53, 0x0e, 0x86, 0x53, 0xd7,
	0xcb, 0x2a, 0x84, 0x61, 0x8d, 0xd3, 0xaf, 0xcf, 0xa3, 0xf0, 0x85, 0x60,
	0x17, 0x91, 0x42, 0xaa, 0xe9, 0x72, 0x79, 0x0c, 0xe7, 0x46, 0xa2, 0xfd,
	0x44, 0x69, 0xd4, 0x15, 0x58, 0x74, 0x43, 0x78, 0xc6, 0x40, 0xae, 0x73,
	0xa4, 0x89, 0xbb, 0x7f, 0x81, 0xcd, 0xca, 0x6b, 0x1b, 0xb1, 0x67, 0xc7,
	0x94, 0xc2, 0x6d, 0x62, 0x38, 0xa0, 0xd2, 0x56, 0xaf, 0xc3, 0xba, 0x21
};
static const uint8_t nist_kas_ecc_cdh_testvector_357_private[] = {
/* dIUT */
	0x02, 0x8b, 0x43, 0x19, 0xeb, 0x70, 0x54, 0xcf, 0xf6, 0x38, 0x28, 0x20,
	0xc5, 0x2f, 0x9c, 0x33, 0x2e, 0xae, 0x67, 0x0d, 0x1f, 0x07, 0xcf, 0xc8,
	0xf1, 0x47, 0x2e, 0x92, 0x60, 0xf5, 0xe4, 0x7a, 0x38, 0x57, 0x68, 0x01,
	0x6c, 0xd2, 0x00, 0x67, 0x00, 0xca, 0x7b, 0xdc, 0x5d, 0x1d, 0x56, 0x7d,
	0x92, 0x46, 0x0a, 0xf7, 0xc2, 0xa4, 0x25, 0xdd, 0x0d, 0x78, 0xae, 0xee,
	0x3d, 0x15, 0xfb, 0x28, 0xd7, 0x11, 0x67, 0xe6, 0x48, 0x6b, 0x81, 0xc4
};
/* QIUTx = 05b1b114cef13aa5df306ce74197d680f9b8c9d8f6753a09db88466a6bb04eaf1eb873836022d7504f45fae85a8e4a5417edd7ce3a0e5eb9e79264884ed783577b3fc52d825f0b57 */
/* QIUTy = 018e3226e36b4b336799c4684bba505e984dc8819166f17ceb840e36125b283a8c8635ddf7e770406d9856d82b37cff1fbcc5d3f5cf4b55eca41ee131f21ea7bcb19ce05f6564245 */
static const uint8_t nist_kas_ecc_cdh_testvector_357_out[] = {
/* ZIUT */
	0x04, 0x28, 0x41, 0x3f, 0x2d, 0x2a, 0xad, 0x4d, 0x52, 0x88, 0x88, 0x5c,
	0x2e, 0xdc, 0x8b, 0x97, 0x63, 0x21, 0xae, 0x1d, 0xd4, 0xfc, 0x6b, 0x41,
	0x27, 0x5f, 0xb8, 0x8b, 0x8c, 0x5e, 0x77, 0x76, 0x16, 0x5e, 0xff, 0xce,
	0x79, 0x02, 0x51, 0x63, 0x53, 0x8a, 0x0e, 0x83, 0xc9, 0x19, 0x22, 0x0a,
	0x40, 0x7e, 0xad, 0x6c, 0xef, 0xd6, 0x16, 0xb4, 0xb0, 0x52, 0x94, 0x48,
	0x8c, 0x2e, 0xf5, 0xd3, 0x0a, 0xb8, 0xca, 0xa5, 0x5c, 0xcb, 0xd1, 0xb1
};
/* COUNT = 7 */
static const uint8_t nist_kas_ecc_cdh_testvector_358_public_x[] = {
/* QCAVSx */
	0x02, 0x6e, 0x2f, 0x1e, 0xe6, 0x4e, 0x79, 0x58, 0xe9, 0x02, 0x54, 0x7a,
	0x7d, 0xb0, 0xa1, 0xe1, 0x48, 0x66, 0xf3, 0xd2, 0xc0, 0x12, 0x7c, 0x2b,
	0xb9, 0xb0, 0x9e, 0xe2, 0x32, 0xd3, 0xd9, 0x51, 0x8e, 0xe4, 0x4a, 0xe8,
	0xf5, 0xbb, 0x43, 0x3a, 0x08, 0x80, 0x69, 0xfa, 0x38, 0x6c, 0xd5, 0xc8,
	0x90, 0x27, 0x11, 0xb7, 0x62, 0xac, 0x0d, 0xa3, 0xa7, 0xa3, 0x42, 0x04,
	0x72, 0xc4, 0x7e, 0x85, 0x0f, 0x98, 0x8d, 0xd6, 0x0a, 0x63, 0x6d, 0x7d
};
static const uint8_t nist_kas_ecc_cdh_testvector_358_public_y[] = {
/* QCAVSy */
	0x06, 0x77, 0xff, 0x51, 0x00, 0x52, 0xd4, 0xf4, 0x60, 0x84, 0x9f, 0xb8,
	0xef, 0x0d, 0x4f, 0x35, 0x19, 0xcd, 0x23, 0x8e, 0x4e, 0x1c, 0x68, 0x8b,
	0x73, 0x6c, 0xf6, 0xe3, 0x75, 0x95, 0x50, 0xd1, 0x34, 0xa1, 0xe6, 0xca,
	0x3c, 0xb4, 0x79, 0xd6, 0x8b, 0x4d, 0xc5, 0xd0, 0xbb, 0xa1, 0xae, 0xe1,
	0x78, 0xbd, 0x6f, 0xe1, 0x5e, 0xc1, 0x96, 0xfb, 0x1f, 0x62, 0x7d, 0x87,
	0x07, 0x93, 0x94, 0xf6, 0xf7, 0x85, 0x4e, 0x05, 0x32, 0x28, 0xde, 0xe5
};
static const uint8_t nist_kas_ecc_cdh_testvector_358_private[] = {
/* dIUT */
	0x02, 0x01, 0x15, 0xd1, 0x7e, 0x41, 0xe1, 0x31, 0x78, 0xb4, 0x2a, 0x00,
	0x4c, 0x01, 0xd5, 0xe4, 0xef, 0x1c, 0x76, 0x24, 0x10, 0x49, 0xc7, 0xd3,
	0x1b, 0xf0, 0xea, 0x85, 0xd6, 0xe0, 0x70, 0xa2, 0xe2, 0xb9, 0x20, 0x80,
	0xe6, 0x1d, 0xe5, 0x46, 0xfc, 0xcb, 0xd4, 0xd9, 0x91, 0x23, 0x6b, 0xb3,
	0x60, 0xef, 0x3f, 0x20, 0x6e, 0xe1, 0x6d, 0x88, 0x43, 0xa0, 0xdd, 0xc8,
	0x03, 0x46, 0x36, 0x64, 0xa8, 0xcc, 0xdc, 0x2d, 0x87, 0xa1, 0x02, 0x77
};
/* QIUTx = 06c8ac34364acae35e3c417160333e48641868fcca04c0d577be06f58ab0a55fd7db779fe737779da33d009f57b5bad49702eacf575acbaf27df833070cd893a7924770c92eff3a0 */
/* QIUTy = 061b82e545d41c62fef068b34cdbf01396115d2a1417f9719483d26986b6d52f8f6de06837795f6d9dd7cd095741114318c6e8a6206b3deeef014f0e44b0dc6684e100e4ac361650 */
static const uint8_t nist_kas_ecc_cdh_testvector_358_out[] = {
/* ZIUT */
	0x03, 0x1b, 0xd2, 0xa8, 0x43, 0x69, 0xe9, 0x3d, 0xfa, 0x00, 0x58, 0x14,
	0x46, 0xd5, 0x27, 0x62, 0x10, 0x0d, 0x98, 0x5c, 0xc7, 0xbb, 0x91, 0xc4,
	0xfa, 0x8b, 0xe7, 0x47, 0x2e, 0x2e, 0x8e, 0x97, 0x81, 0xc5, 0x2b, 0x19,
	0xa5, 0x43, 0x30, 0x44, 0x24, 0x41, 0xba, 0xca, 0xe2, 0x3f, 0x4b, 0xdc,
	0x76, 0x48, 0x6e, 0xb4, 0x75, 0xd5, 0x1f, 0x26, 0xaa, 0xfb, 0xfb, 0x27,
	0x2a, 0x5a, 0xb5, 0xdb, 0x18, 0x4a, 0x4d, 0x3c, 0x30, 0x06, 0xe5, 0xd1
};
/* COUNT = 8 */
static const uint8_t nist_kas_ecc_cdh_testvector_359_public_x[] = {
/* QCAVSx */
	0x02, 0x3e, 0xe4, 0xf9, 0xec, 0x24, 0xde, 0xe2, 0x03, 0xac, 0xfb, 0x65,
	0x86, 0x31, 0x31, 0x3c, 0x7a, 0xd4, 0x39, 0x4c, 0x47, 0xf1, 0x79, 0x4d,
	0x08, 0xb5, 0x99, 0xff, 0xc1, 0x5f, 0x0e, 0x5d, 0xab, 0x29, 0x11, 0xd9,
	0x7e, 0x03, 0x0d, 0xdf, 0x7c, 0xb4, 0xbb, 0xad, 0xf8, 0xa5, 0xbc, 0xe0,
	0x5c, 0x35, 0x35, 0x8f, 0xbd, 0x0c, 0xf9, 0x5d, 0x3d, 0x5c, 0x7f, 0xf3,
	0xcd, 0x8e, 0xe6, 0xb5, 0x4e, 0x37, 0x9d, 0x8d, 0x01, 0x23, 0x93, 0x9b
};
static const uint8_t nist_kas_ecc_cdh_testvector_359_public_y[] = {
/* QCAVSy */
	0x06, 0x06, 0xbe, 0x23, 0xe7, 0xc5, 0x74, 0x6d, 0xbd, 0x38, 0x40, 0x4f,
	0xd6, 0x07, 0xfb, 0x7f, 0x27, 0x8e, 0xe2, 0x49, 0xdc, 0x8e, 0x27, 0x40,
	0xcf, 0x1b, 0xb9, 0xb1, 0xc0, 0x7b, 0x1c, 0xf7, 0xe0, 0xa5, 0x0a, 0x43,
	0x25, 0x67, 0xd1, 0x86, 0x97, 0x99, 0xa8, 0x03, 0x12, 0x25, 0x10, 0xdb,
	0x43, 0x79, 0x81, 0xa2, 0xaa, 0x12, 0x6e, 0xb9, 0xaa, 0xf3, 0xc7, 0xbe,
	0x05, 0xa8, 0x0f, 0xac, 0x14, 0x95, 0xe1, 0xc4, 0x0c, 0xa1, 0xc1, 0x06
};
static const uint8_t nist_kas_ecc_cdh_testvector_359_private[] = {
/* dIUT */
	0x00, 0x84, 0x7b, 0x54, 0x5e, 0xf4, 0x96, 0x15, 0x67, 0x1f, 0x08, 0xbe,
	0x73, 0xa4, 0x91, 0x47, 0x06, 0x31, 0x84, 0x49, 0x33, 0x40, 0x11, 0x1e,
	0xa4, 0xdc, 0xe1, 0x3c, 0x2f, 0x92, 0x1f, 0x07, 0xbf, 0xac, 0xff, 0xc8,
	0x44, 0x1f, 0x4c, 0x7c, 0x9d, 0x04, 0x79, 0xf5, 0x7f, 0x3a, 0x13, 0xf4,
	0xc3, 0x3c, 0x63, 0xed, 0x47, 0xc3, 0xa4, 0x3f, 0xb2, 0xf0, 0x6d, 0x06,
	0xa9, 0x78, 0x0e, 0x5c, 0x0b, 0x3a, 0xc3, 0x04, 0x10, 0xad, 0xc4, 0x91
};
/* QIUTx = 06994ddc5ae2c5b6f45dc32b710f1a49391a47f3a0f8c2d7846552fe487ef01cca0431155bb54533b067a29e8367373af95d6a7f0bf98d869b708f48f95f1b88a1530fe22547e97e */
/* QIUTy = 04f6288d4d704f33a898031e7d0046fbf1e34a72c8af190f4d33163343c897ba0c0d8af8a86236a1c3b655b979dc4522d33d66a665b3b6501570f076322af0ad2bbaaa04ea2e995d */
static const uint8_t nist_kas_ecc_cdh_testvector_359_out[] = {
/* ZIUT */
	0x04, 0xdf, 0x20, 0x15, 0x4f, 0xa4, 0x9a, 0x1d, 0x6e, 0x04, 0xdc, 0x2b,
	0xa6, 0xe5, 0x5a, 0x7f, 0x2a, 0xe5, 0x75, 0xde, 0x5e, 0x2c, 0x6e, 0x40,
	0x91, 0xa4, 0xd2, 0xc3, 0x6a, 0xa9, 0x3c, 0xa9, 0x69, 0x9b, 0x89, 0x0f,
	0x0e, 0xe4, 0xdf, 0x53, 0xaa, 0x75, 0xd0, 0xd9, 0xba, 0xba, 0xd6, 0x86,
	0x05, 0xbc, 0x02, 0x7e, 0xc6, 0x7c, 0x18, 0x7a, 0x68, 0x26, 0xaa, 0xc0,
	0xf4, 0xbc, 0x59, 0x6b, 0xaa, 0xe7, 0x88, 0xb3, 0x76, 0x11, 0x02, 0x16
};
/* COUNT = 9 */
static const uint8_t nist_kas_ecc_cdh_testvector_360_public_x[] = {
/* QCAVSx */
	0x00, 0xd4, 0xa0, 0xb1, 0x1c, 0x17, 0x39, 0xbe, 0xd0, 0x94, 0xe7, 0x2d,
	0x7a, 0x69, 0x23, 0x83, 0x68, 0x36, 0xd9, 0x21, 0x57, 0x46, 0xc7, 0x2c,
	0xc6, 0x80, 0x04, 0x5a, 0x36, 0xd8, 0x1a, 0xdf, 0x5e, 0x25, 0x39, 0x4f,
	0x26, 0x9a, 0x2a, 0xda, 0x1d, 0x94, 0x39, 0xeb, 0xc3, 0x3b, 0xb9, 0x31,
	0xd6, 0xfa, 0x59, 0x5a, 0x25, 0x26, 0x1c, 0x24, 0x4a, 0x1e, 0x17, 0xb0,
	0x46, 0xfb, 0x10, 0xfb, 0x54, 0xbb, 0x31, 0x22, 0x88, 0xcf, 0x2e, 0x8d
};
static const uint8_t nist_kas_ecc_cdh_testvector_360_public_y[] = {
/* QCAVSy */
	0x07, 0x52, 0x04, 0xf5, 0x0d, 0x32, 0xab, 0x8a, 0x6a, 0xbb, 0xff, 0x98,
	0x2d, 0x1f, 0xe3, 0x72, 0xb8, 0xc5, 0x41, 0x5b, 0xb5, 0xb7, 0x26, 0xb3,
	0x46, 0xaa, 0x4f, 0x08, 0xbe, 0x32, 0xf8, 0xca, 0x28, 0x2c, 0x1e, 0xf6,
	0xe1, 0x52, 0x42, 0x33, 0x60, 0xd9, 0x7b, 0x72, 0x8a, 0x07, 0x4e, 0x6b,
	0x3c, 0xf3, 0xb9, 0x12, 0x71, 0x8b, 0x16, 0x92, 0xcd, 0x98, 0x30, 0x19,
	0x74, 0x1a, 0x25, 0x41, 0x82, 0x42, 0x34, 0xbd, 0xc8, 0xc3, 0x23, 0xf9
};
static const uint8_t nist_kas_ecc_cdh_testvector_360_private[] = {
/* dIUT */
	0x03, 0x4c, 0x24, 0x58, 0x30, 0x2b, 0x43, 0x85, 0x7f, 0x12, 0xad, 0x8b,
	0xd9, 0xa8, 0x75, 0x23, 0x76, 0x41, 0xa2, 0x1e, 0x21, 0xca, 0x3c, 0xf9,
	0xa0, 0x95, 0x6d, 0x3c, 0xfe, 0xde, 0xd9, 0x6a, 0x5e, 0x1f, 0x53, 0x3d,
	0x82, 0x7b, 0x52, 0x8f, 0xbb, 0x58, 0x6d, 0xa9, 0x3e, 0xef, 0xbb, 0x66,
	0xd0, 0x77, 0x8b, 0x19, 0xb1, 0xa7, 0xfb, 0x6f, 0x17, 0xbb, 0xf9, 0xe7,
	0x9b, 0x9a, 0xce, 0xfc, 0xdd, 0x7b, 0x96, 0x05, 0xe7, 0x89, 0x8f, 0x26
};
/* QIUTx = 032d3a7a4099f089fea9189211f7366f2edc4abfb316c5c05948d8de57fca023bfb6a11b102ea4120ba62192c0df610bd8d2f63fc57727f4a6b640abf8d299fac56c4c7af88349ea */
/* QIUTy = 04e6399f1ced2669d3a5506d35ea2bebfccf0cec84bc97383aadc3b48347f629626e6096f890435e5933675048fdcefcdede3ed616e6560d42e9e17c5492e30bc2de4689c0592ecb */
static const uint8_t nist_kas_ecc_cdh_testvector_360_out[] = {
/* ZIUT */
	0x03, 0x7a, 0x38, 0x0f, 0x52, 0x55, 0x90, 0x58, 0x26, 0x58, 0xe2, 0xdd,
	0x27, 0x2a, 0x32, 0xde, 0x67, 0xfc, 0x0c, 0xf5, 0x39, 0x0b, 0x37, 0xf4,
	0xd3, 0x3c, 0x13, 0x59, 0xf0, 0x75, 0xd4, 0x46, 0x1e, 0xa3, 0x8a, 0x55,
	0x02, 0x73, 0x17, 0x89, 0x2a, 0x3d, 0x1d, 0x22, 0xf5, 0xea, 0x33, 0x3a,
	0xd4, 0x37, 0x66, 0x7d, 0x2f, 0x3e, 0xb8, 0x78, 0x1c, 0x39, 0x50, 0x40,
	0x36, 0xae, 0x33, 0xe4, 0xb0, 0xa2, 0x6b, 0x68, 0x94, 0x72, 0x2f, 0x0b
};
/* COUNT = 10 */
static const uint8_t nist_kas_ecc_cdh_testvector_361_public_x[] = {
/* QCAVSx */
	0x03, 0xbb, 0x84, 0x03, 0x2b, 0x7f, 0xff, 0xce, 0x27, 0xac, 0xcf, 0x35,
	0x4b, 0x89, 0xdd, 0xdf, 0x64, 0x6c, 0xdc, 0xb5, 0x66, 0x34, 0xdf, 0x0f,
	0x85, 0x20, 0xa7, 0x73, 0x0f, 0x8a, 0xbe, 0xb0, 0x5f, 0x99, 0x33, 0xd8,
	0xa4, 0x35, 0x2d, 0x1c, 0x77, 0x67, 0xcc, 0x3f, 0x9b, 0x80, 0xce, 0xff,
	0xcd, 0xd0, 0xcb, 0x3a, 0x97, 0xb5, 0x92, 0x83, 0xfd, 0x0a, 0x67, 0x4d,
	0xc4, 0xfd, 0x24, 0x03, 0x33, 0xf0, 0x20, 0xc8, 0x2b, 0x48, 0x04, 0xc5
};
static const uint8_t nist_kas_ecc_cdh_testvector_361_public_y[] = {
/* QCAVSy */
	0x07, 0x44, 0x99, 0x33, 0x6a, 0xc3, 0xa8, 0x05, 0x43, 0x07, 0x89, 0x90,
	0x27, 0x68, 0x25, 0x20, 0x26, 0xb5, 0x26, 0xec, 0xe5, 0x4a, 0xc2, 0x8e,
	0x8c, 0xc8, 0x78, 0xf1, 0x8b, 0xaf, 0x9f, 0xab, 0x42, 0xba, 0x4c, 0xe3,
	0x4e, 0x49, 0x68, 0xaa, 0xc1, 0xee, 0x6a, 0x0b, 0xb1, 0x5c, 0x9a, 0x70,
	0x98, 0x82, 0xa5, 0x37, 0x2a, 0xf5, 0x6e, 0xa0, 0xb3, 0x68, 0x17, 0x38,
	0x5f, 0xbb, 0xfe, 0xac, 0x4b, 0x90, 0x60, 0x69, 0xe5, 0x3f, 0xbf, 0xba
};
static const uint8_t nist_kas_ecc_cdh_testvector_361_private[] = {
/* dIUT */
	0x01, 0x2d, 0xb7, 0x85, 0xa0, 0x3c, 0x26, 0xbe, 0x3a, 0x6e, 0x9a, 0x58,
	0x2e, 0x5c, 0x32, 0xa8, 0x95, 0x70, 0xad, 0x43, 0x08, 0xb7, 0x13, 0xce,
	0x54, 0x71, 0xea, 0x19, 0x3d, 0xec, 0x1f, 0x32, 0xd6, 0x8b, 0x4f, 0xcd,
	0xfb, 0x16, 0x00, 0xfd, 0xb1, 0xec, 0xb6, 0x76, 0x9e, 0x26, 0xa0, 0xe0,
	0x57, 0x81, 0x2d, 0xbb, 0xf0, 0xed, 0x49, 0x55, 0x92, 0x66, 0x5e, 0x6b,
	0x8e, 0x9a, 0x97, 0x37, 0x8a, 0x30, 0xb5, 0xc6, 0x60, 0xfb, 0xad, 0xc1
};
/* QIUTx = 07edf7ee0ec77f5a6c3c9ec4ed8fd3cb814a342e9cc6470b54781ed6c141e2115c86dbd7ba27993eb7ebed7a38be488f96fddfa982f3691aa1c2a697f7706bff3d1add7396066194 */
/* QIUTy = 07b3824b7f7b266fa42fe536adc2ac79b9d1e5b408e7217b3a99ddeb992f3123ff2d168774d300a818a32692e265afc6f6f578d9bd3121132b5979841f7a2d060e8948901d657c1c */
static const uint8_t nist_kas_ecc_cdh_testvector_361_out[] = {
/* ZIUT */
	0x04, 0x20, 0xde, 0x31, 0x3b, 0xdd, 0xce, 0x87, 0xd0, 0x73, 0x21, 0xe3,
	0xf0, 0xaf, 0x40, 0x4d, 0x9d, 0x13, 0xe5, 0x36, 0x9b, 0x79, 0x50, 0x6e,
	0x80, 0x71, 0x78, 0x71, 0x11, 0x53, 0xc9, 0xb1, 0x83, 0x7c, 0xd0, 0x55,
	0x56, 0x2e, 0xff, 0x3a, 0xad, 0xfc, 0x59, 0x54, 0xa2, 0x21, 0xee, 0xeb,
	0xb1, 0xbe, 0xc1, 0x69, 0x6d, 0x3d, 0xf1, 0xcc, 0xcf, 0xb8, 0xb6, 0x11,
	0x72, 0xa5, 0x0d, 0x83, 0xce, 0xe9, 0x5f, 0x41, 0x40, 0xba, 0x07, 0x0b
};
/* COUNT = 11 */
static const uint8_t nist_kas_ecc_cdh_testvector_362_public_x[] = {
/* QCAVSx */
	0x06, 0x55, 0x6a, 0x4c, 0xc9, 0x84, 0x66, 0x79, 0x4a, 0x93, 0xd0, 0x33,
	0x88, 0x53, 0x67, 0x76, 0xf7, 0xa4, 0xb3, 0x34, 0x4c, 0x3d, 0xc4, 0xeb,
	0x96, 0x0a, 0x4a, 0x64, 0x58, 0xfc, 0x78, 0x69, 0xcd, 0x4e, 0x45, 0xb2,
	0xf1, 0x40, 0xc4, 0x68, 0xa7, 0xd4, 0xeb, 0xba, 0x84, 0xc9, 0x48, 0x23,
	0x37, 0xa2, 0xa8, 0xad, 0xaa, 0xc8, 0x8a, 0x9a, 0x62, 0x9d, 0xa0, 0x3d,
	0xd2, 0x47, 0x52, 0x66, 0x42, 0xb0, 0xab, 0x71, 0xfb, 0x7a, 0x8c, 0x70
};
static const uint8_t nist_kas_ecc_cdh_testvector_362_public_y[] = {
/* QCAVSy */
	0x05, 0x4b, 0x97, 0xd9, 0x52, 0xb1, 0x9f, 0x74, 0x28, 0x56, 0xda, 0xcf,
	0x4e, 0x50, 0xdf, 0x0c, 0x31, 0x03, 0xba, 0xf2, 0x53, 0xf4, 0xde, 0x65,
	0xa3, 0xd9, 0xca, 0xce, 0x63, 0xfe, 0x82, 0x90, 0x6d, 0x2c, 0x8e, 0x8a,
	0x33, 0x12, 0xfb, 0x53, 0x5e, 0x00, 0xf9, 0xb5, 0xca, 0x69, 0xf8, 0x7d,
	0xbc, 0x7f, 0xa3, 0xf7, 0xd8, 0x7f, 0xe0, 0x24, 0x53, 0x66, 0x04, 0xaa,
	0xfe, 0x46, 0x40, 0x59, 0x3c, 0xcc, 0xfe, 0xf6, 0xfa, 0xc0, 0x28, 0xa6
};
static const uint8_t nist_kas_ecc_cdh_testvector_362_private[] = {
/* dIUT */
	0x02, 0x02, 0x60, 0x6a, 0x76, 0xb6, 0xa1, 0x3d, 0x6e, 0x29, 0x28, 0x0b,
	0xc1, 0x61, 0x3e, 0x11, 0x50, 0x25, 0x77, 0x0b, 0x24, 0x5f, 0x55, 0x61,
	0xd5, 0x88, 0x3e, 0x13, 0x5e, 0x15, 0x9c, 0xc4, 0x37, 0xb1, 0xc9, 0x35,
	0x5b, 0x2e, 0xee, 0x2b, 0x3b, 0xab, 0xef, 0x22, 0x9f, 0xe5, 0x45, 0xaa,
	0xb2, 0xbc, 0xca, 0x15, 0x5e, 0x89, 0x72, 0x49, 0x5f, 0x19, 0x74, 0xbd,
	0xb1, 0xec, 0x0e, 0x60, 0xc4, 0xe6, 0xc7, 0x9c, 0x48, 0xf2, 0x6a, 0x46
};
/* QIUTx = 06e74dba4e0702f186d334d3c49e2578e1edfac564645dda8c4a588158f8d7a3ef63243653c0d507427734fb4cc87adf4a36bd5abca1f920b9bd6e3bfa51c916d5710884594e9485 */
/* QIUTy = 05b92147a2db48a3830ccfa28951a2b7e8eb84313b99b0a99031c7834c633f865a2f9844952528ae5dee02428a824cdfb7e20928ffc53420df38ead0b4240d0659d5adb1ff2e2dcb */
static const uint8_t nist_kas_ecc_cdh_testvector_362_out[] = {
/* ZIUT */
	0x06, 0x06, 0x22, 0x8f, 0x5a, 0x05, 0x07, 0x7a, 0xee, 0xfb, 0xef, 0xac,
	0x23, 0xc0, 0xd5, 0xba, 0xc7, 0xa6, 0x06, 0x2b, 0xfc, 0x2b, 0x02, 0xce,
	0x8b, 0xba, 0x66, 0x98, 0xea, 0x96, 0xb4, 0x56, 0xb1, 0xf0, 0xd3, 0x2c,
	0x6e, 0x05, 0xdb, 0xb9, 0xbe, 0x61, 0xa8, 0x30, 0x90, 0x42, 0x8e, 0xed,
	0xea, 0x18, 0xc7, 0x4f, 0x41, 0x23, 0x8e, 0xde, 0xde, 0x9e, 0x3a, 0x12,
	0xe2, 0x87, 0x22, 0xd2, 0xf3, 0x14, 0x61, 0x3c, 0x2e, 0x84, 0xd6, 0xdb
};
/* COUNT = 12 */
static const uint8_t nist_kas_ecc_cdh_testvector_363_public_x[] = {
/* QCAVSx */
	0x01, 0x00, 0x51, 0x82, 0xb0, 0x29, 0xa4, 0x85, 0x28, 0xee, 0xf5, 0xff,
	0xd0, 0x22, 0x1a, 0xd8, 0x70, 0x85, 0xab, 0xac, 0x6a, 0x72, 0x70, 0x52,
	0x03, 0xa3, 0xc1, 0x68, 0x9a, 0xbb, 0xbc, 0x0e, 0x12, 0x92, 0x7a, 0x5e,
	0x83, 0xb3, 0x52, 0xa1, 0xba, 0xd9, 0x77, 0x06, 0x10, 0x1f, 0x44, 0xa1,
	0x02, 0x2c, 0xcc, 0x0d, 0x55, 0x22, 0xdc, 0x5d, 0x1c, 0xa1, 0x43, 0x3d,
	0xe0, 0x3a, 0x2b, 0xa1, 0xdf, 0x86, 0x48, 0x75, 0xf5, 0x22, 0xbe, 0x61
};
static const uint8_t nist_kas_ecc_cdh_testvector_363_public_y[] = {
/* QCAVSy */
	0x01, 0x8b, 0x02, 0xa9, 0x8f, 0x0b, 0x3e, 0x4c, 0xcf, 0x44, 0xa9, 0x69,
	0x39, 0xa2, 0x08, 0x3a, 0xb1, 0xf2, 0xa0, 0x4d, 0xaf, 0xd5, 0xbd, 0xce,
	0xe3, 0xcf, 0xf4, 0x38, 0xbb, 0x08, 0xbf, 0xf1, 0x20, 0x43, 0xaa, 0x19,
	0x2c, 0x5f, 0xcf, 0x34, 0xe1, 0x3b, 0x5c, 0x29, 0x74, 0x2c, 0x5d, 0x86,
	0x4b, 0x9c, 0xac, 0x46, 0xbe, 0xa6, 0xe9, 0x6d, 0xf2, 0xb1, 0xbe, 0x44,
	0x93, 0xac, 0xf9, 0x50, 0x22, 0x4d, 0x71, 0x73, 0x7f, 0x99, 0x06, 0x58
};
static const uint8_t nist_kas_ecc_cdh_testvector_363_private[] = {
/* dIUT */
	0x00, 0x48, 0x67, 0x83, 0x48, 0xac, 0x33, 0xb9, 0x2f, 0x2c, 0x59, 0x67,
	0x71, 0x03, 0xea, 0x40, 0x99, 0x46, 0xb5, 0x59, 0x3d, 0x10, 0x5f, 0xc4,
	0x98, 0x33, 0x51, 0xc4, 0xed, 0xe9, 0x29, 0xc4, 0xb9, 0x3b, 0xfc, 0x69,
	0x58, 0x76, 0x55, 0x5e, 0x3a, 0xce, 0x41, 0x7b, 0x82, 0xac, 0x05, 0xb8,
	0x32, 0x67, 0x6a, 0xc2, 0x3e, 0x29, 0x55, 0xa0, 0x9e, 0xe6, 0x4a, 0x20,
	0xa5, 0xf9, 0x8e, 0x62, 0x49, 0x9f, 0x43, 0xba, 0x7f, 0x7f, 0xc8, 0xe1
};
/* QIUTx = 031dd4808d2b341b8881f5e50a2dcce38df839009f92185978dfd9a60cdaee005cdba82655647736d407afb90c67cddb13ba2b01618f45e8a274317e02f770f80ef87bbbc1b11056 */
/* QIUTy = 050a0671c9c0ce57a494e6911f1376cf1fc3393885ba8c26f6ddcbb5361876860a35afc1f4560f2970c30db3f1c817dbc8af2b025daed3a9da12d2fae9d714cead80445e6a0a0813 */
static const uint8_t nist_kas_ecc_cdh_testvector_363_out[] = {
/* ZIUT */
	0x05, 0x26, 0x69, 0x33, 0x60, 0x19, 0xdb, 0x5e, 0xdd, 0xef, 0x5e, 0xab,
	0x23, 0x36, 0xab, 0xeb, 0x60, 0xbb, 0xc7, 0x29, 0x5e, 0x4b, 0xb6, 0x63,
	0xab, 0x43, 0xe3, 0x73, 0xfb, 0x6d, 0x88, 0x8d, 0x74, 0x33, 0xec, 0x89,
	0xa4, 0x87, 0xa9, 0x1d, 0x4a, 0x59, 0xc2, 0x89, 0xa9, 0x50, 0x9d, 0xdd,
	0x1b, 0xab, 0x33, 0xcd, 0x02, 0xa7, 0xbf, 0x37, 0xaa, 0xad, 0x78, 0xdb,
	0xed, 0xf0, 0xb4, 0xae, 0x5f, 0x2f, 0x35, 0xd1, 0x5c, 0xb4, 0xe6, 0x28
};
/* COUNT = 13 */
static const uint8_t nist_kas_ecc_cdh_testvector_364_public_x[] = {
/* QCAVSx */
	0x07, 0xfa, 0xb4, 0xe5, 0x93, 0x28, 0xc7, 0x00, 0xf7, 0x46, 0x49, 0xbd,
	0x90, 0xa7, 0xd5, 0x1f, 0xf2, 0x89, 0x58, 0xfe, 0x72, 0x0d, 0xaa, 0xab,
	0x32, 0x8c, 0xfc, 0x9b, 0x00, 0x2a, 0xa7, 0x06, 0xce, 0xb3, 0x99, 0x34,
	0xdb, 0x9c, 0xcf, 0x81, 0xde, 0xec, 0x95, 0x68, 0x9c, 0xe8, 0xc7, 0x76,
	0xb4, 0xfc, 0x65, 0x42, 0xa8, 0x23, 0x58, 0xcc, 0x51, 0xeb, 0xbc, 0x6d,
	0x8e, 0x53, 0x22, 0xcb, 0x3f, 0xa6, 0xe4, 0x69, 0x5e, 0x17, 0x0f, 0xc1
};
static const uint8_t nist_kas_ecc_cdh_testvector_364_public_y[] = {
/* QCAVSy */
	0x05, 0xac, 0xd4, 0x5c, 0xff, 0xa2, 0x9d, 0xdb, 0x34, 0xee, 0x42, 0xe7,
	0x41, 0x00, 0x26, 0x79, 0x8e, 0x37, 0xa8, 0xd1, 0xa9, 0xce, 0x9f, 0x92,
	0x94, 0xda, 0x51, 0x98, 0x16, 0x4b, 0x69, 0x01, 0x0c, 0x68, 0xc5, 0x32,
	0x81, 0xcc, 0xbf, 0xc4, 0x07, 0xd1, 0x41, 0x09, 0x7d, 0xa1, 0x37, 0xe7,
	0x84, 0x9f, 0x22, 0x8f, 0xdc, 0x1a, 0x07, 0xaa, 0x29, 0x8b, 0xe2, 0x6c,
	0xa7, 0x71, 0xf4, 0x7a, 0xc4, 0xfe, 0xb2, 0x72, 0x3d, 0x5a, 0x66, 0x66
};
static const uint8_t nist_kas_ecc_cdh_testvector_364_private[] = {
/* dIUT */
	0x00, 0x17, 0xba, 0xb7, 0x2d, 0x78, 0x8f, 0x8b, 0x78, 0xb9, 0xbf, 0xc4,
	0x91, 0x28, 0x63, 0xc5, 0xa4, 0x89, 0x22, 0xfe, 0x69, 0xe8, 0xa4, 0xcf,
	0x5e, 0x6e, 0x91, 0x76, 0x3e, 0xfd, 0x54, 0x77, 0xa1, 0xcd, 0x43, 0x9d,
	0xed, 0xd0, 0xaf, 0xea, 0x50, 0x4e, 0x3b, 0x3a, 0xf6, 0x82, 0x3e, 0xa3,
	0x08, 0x9c, 0x03, 0x74, 0xed, 0x9a, 0xee, 0x24, 0xa8, 0x85, 0x16, 0xc8,
	0xcf, 0x3a, 0xfa, 0xbe, 0x99, 0x5b, 0x9b, 0x96, 0x75, 0xf3, 0xb5, 0xab
};
/* QIUTx = 0161c14bbc84e42ec7677a8c3770065ecd1f0f44eac8242a715a61971e7e4ffff78ff57a1bf1b95cbfc2ed957d1195f9ea50809715c2439c7543e573520135426d47535b8bfc8533 */
/* QIUTy = 01253633d02251464edcc53ed9e8a9ed9329320ef5eeaf35d64c59b9735c96e07f1a62ec17bcee4f04cd9a85a3eb504aaf37bb388c6c7d08d90aa0b68556b5c068ecbf0a5984460d */
static const uint8_t nist_kas_ecc_cdh_testvector_364_out[] = {
/* ZIUT */
	0x06, 0x2d, 0xe5, 0xaa, 0x98, 0xb4, 0x40, 0xc6, 0xcb, 0x7a, 0x14, 0x28,
	0xf6, 0xb5, 0xe4, 0x74, 0x52, 0xb3, 0x04, 0x54, 0xee, 0xc4, 0xd6, 0x51,
	0x98, 0x2b, 0x53, 0x11, 0x21, 0xfe, 0xbb, 0xd5, 0xa3, 0x83, 0x3b, 0x18,
	0x00, 0x17, 0xf7, 0xdd, 0xb5, 0xce, 0x38, 0xd7, 0xbb, 0x1c, 0x84, 0x2d,
	0xe1, 0xa8, 0xa8, 0xfc, 0x7f, 0xc9, 0x81, 0xe2, 0x47, 0x33, 0xb7, 0x66,
	0x28, 0x13, 0xfd, 0x01, 0x0a, 0x4e, 0x75, 0x7c, 0xa4, 0xea, 0x5c, 0x28
};
/* COUNT = 14 */
static const uint8_t nist_kas_ecc_cdh_testvector_365_public_x[] = {
/* QCAVSx */
	0x07, 0x26, 0x76, 0x30, 0x2a, 0xd1, 0x87, 0x31, 0xb7, 0x62, 0x02, 0xbc,
	0x51, 0x42, 0x9e, 0xbf, 0x7e, 0xcc, 0xf6, 0x32, 0x5f, 0x4e, 0x08, 0x4c,
	0x2f, 0x92, 0xe3, 0x28, 0x8e, 0xd2, 0x90, 0x48, 0x8b, 0x9e, 0x36, 0x72,
	0x0e, 0x29, 0xda, 0xa2, 0xdb, 0x19, 0x93, 0xa7, 0xd1, 0x7c, 0xe8, 0xef,
	0x9d, 0x8c, 0xce, 0xc6, 0x1d, 0xe8, 0xa4, 0x07, 0x17, 0x6e, 0x26, 0x74,
	0xc2, 0x5d, 0x57, 0xbf, 0xf2, 0xc4, 0x65, 0x96, 0x35, 0x8b, 0x36, 0x05
};
static const uint8_t nist_kas_ecc_cdh_testvector_365_public_y[] = {
/* QCAVSy */
	0x03, 0xc0, 0x02, 0x2d, 0x53, 0x22, 0x90, 0x91, 0xe1, 0x4a, 0xf0, 0xf7,
	0x45, 0x0d, 0xec, 0xa1, 0xcb, 0x5d, 0xb8, 0x21, 0xe7, 0x15, 0x90, 0x60,
	0x8f, 0xe0, 0x98, 0x6d, 0x73, 0xe8, 0x8c, 0x91, 0x5e, 0x5e, 0xe8, 0xdf,
	0xeb, 0xc8, 0x95, 0x59, 0x13, 0xd9, 0x16, 0x4f, 0x99, 0x2f, 0x56, 0x39,
	0x4a, 0x66, 0x2e, 0xf1, 0x1c, 0x82, 0x14, 0xe8, 0xad, 0xa8, 0x5d, 0xf1,
	0xb1, 0x7b, 0x0b, 0x97, 0x41, 0x4c, 0xdd, 0x66, 0x2d, 0x18, 0x8b, 0x5d
};
static const uint8_t nist_kas_ecc_cdh_testvector_365_private[] = {
/* dIUT */
	0x02, 0xab, 0x2d, 0x43, 0x02, 0x7b, 0x08, 0xf8, 0xab, 0xfa, 0x35, 0x98,
	0xef, 0x01, 0x44, 0x39, 0x9a, 0x60, 0xb6, 0x03, 0x7b, 0x17, 0xa3, 0xae,
	0x41, 0x3d, 0x42, 0x2e, 0xfa, 0x21, 0x67, 0xe9, 0xea, 0x4f, 0x19, 0xd7,
	0xec, 0xa9, 0x8d, 0x85, 0xc6, 0x7c, 0x1f, 0xe8, 0x5f, 0xbc, 0xbc, 0x1f,
	0x12, 0xba, 0xfa, 0x30, 0xa8, 0x5d, 0xbd, 0xf5, 0x42, 0x46, 0x68, 0x89,
	0x31, 0x5f, 0x15, 0x32, 0xde, 0xfc, 0x5d, 0x18, 0x15, 0x09, 0xf0, 0x08
};
/* QIUTx = 0328c0d67fd552ea10e5bdf7b87d50bf4dcba34dca569aeb869c5c7dc7d832ce30feed32e25a723793f97c557e2f978c5e1349e69b73ef9916001ffb0d6cdb2c6343e34538386e6e */
/* QIUTy = 01d151b46ed004263cd9a5c0d46a840d03222631f92ff9280e95a35746cdbcafd9fed6811c7614b9d50aa2828dc7a275b39d3d418a349dd1e2b73211f4de9a34b42fca11b9760eca */
static const uint8_t nist_kas_ecc_cdh_testvector_365_out[] = {
/* ZIUT */
	0x07, 0xc7, 0xeb, 0x48, 0x92, 0x81, 0x6c, 0xc3, 0x38, 0x8e, 0xbc, 0xdf,
	0xb4, 0x12, 0x98, 0x4e, 0x05, 0x91, 0x0c, 0x11, 0x2d, 0xd1, 0x5b, 0x8e,
	0x54, 0x81, 0x71, 0x94, 0x01, 0x70, 0x1a, 0xce, 0xba, 0x22, 0xfc, 0xf3,
	0x5a, 0xab, 0x0c, 0x3b, 0x04, 0x00, 0x96, 0x16, 0x10, 0x11, 0xf6, 0x17,
	0x70, 0x97, 0xc5, 0x05, 0x39, 0x5d, 0x9d, 0x6d, 0x8a, 0x71, 0x3f, 0x6a,
	0x51, 0x00, 0xfb, 0x47, 0x6a, 0xdb, 0xe7, 0xb9, 0xcd, 0xf4, 0xb6, 0x8b
};
/* COUNT = 15 */
static const uint8_t nist_kas_ecc_cdh_testvector_366_public_x[] = {
/* QCAVSx */
	0x06, 0xcd, 0x79, 0x31, 0xfc, 0xf1, 0x93, 0x5f, 0x81, 0xf3, 0x01, 0x47,
	0x9e, 0xd9, 0xad, 0x0c, 0x6f, 0x9a, 0x05, 0xbe, 0xcf, 0x4e, 0x57, 0x3a,
	0x2f, 0xf4, 0x09, 0xba, 0xfc, 0x44, 0x2e, 0xc1, 0x95, 0xf7, 0xe3, 0xfd,
	0xfd, 0x08, 0xe5, 0x81, 0x61, 0xd4, 0xe0, 0xfd, 0x37, 0xf6, 0x2a, 0x96,
	0x94, 0x21, 0xb1, 0x9c, 0xd4, 0x8f, 0xe8, 0x48, 0xa5, 0xd7, 0xf7, 0x4b,
	0x81, 0x37, 0xa7, 0xc7, 0x26, 0xa9, 0xcb, 0xd3, 0x7a, 0x2c, 0xf3, 0xb4
};
static const uint8_t nist_kas_ecc_cdh_testvector_366_public_y[] = {
/* QCAVSy */
	0x04, 0xb5, 0xb2, 0xcd, 0x83, 0xb2, 0x78, 0x95, 0x75, 0x1c, 0x34, 0xd3,
	0xac, 0x5b, 0x96, 0x0a, 0x13, 0x3e, 0xc1, 0x8b, 0x03, 0x9c, 0x2e, 0x12,
	0x8d, 0x34, 0x41, 0xdb, 0x4f, 0x76, 0xe8, 0xb7, 0x50, 0x64, 0x09, 0x46,
	0x19, 0xb1, 0x22, 0xe5, 0xfb, 0x2f, 0x1c, 0x27, 0x96, 0x55, 0x9a, 0xd9,
	0x53, 0xc7, 0x11, 0xe3, 0x30, 0xdc, 0x7b, 0xf5, 0x5e, 0xdf, 0x29, 0xf0,
	0x95, 0xca, 0xe4, 0x55, 0x57, 0xb7, 0xc8, 0xd5, 0x84, 0x3d, 0x89, 0xbd
};
static const uint8_t nist_kas_ecc_cdh_testvector_366_private[] = {
/* dIUT */
	0x00, 0x49, 0xc6, 0xe4, 0xc0, 0x5a, 0x19, 0x7b, 0x24, 0xaf, 0xd2, 0x70,
	0x72, 0x43, 0xff, 0xbf, 0xd5, 0x5b, 0x00, 0x88, 0xfd, 0x33, 0xd8, 0x7d,
	0xae, 0x4d, 0x21, 0x04, 0x8f, 0x75, 0xf2, 0xb8, 0x62, 0x56, 0x30, 0x75,
	0x24, 0x1d, 0x2f, 0x36, 0xfd, 0xd0, 0xe9, 0x40, 0x5a, 0xb4, 0x2a, 0xa5,
	0x5c, 0xbf, 0x20, 0x95, 0xda, 0xbc, 0x3d, 0xae, 0xdf, 0xae, 0x9d, 0xeb,
	0x92, 0x22, 0x20, 0x78, 0x3e, 0x85, 0x91, 0xcf, 0xd6, 0x76, 0x00, 0xb1
};
/* QIUTx = 001fe29a4c2dd000bbed129121b88edbb5c39b34003f170ac19fa9a85c5fe587aab821361f4963440f25acb49758810552f06b719a9eb43b720e9b7ad6ef9d41248d5f335f99515a */
/* QIUTy = 01499db95808c719d24eb05c633db8b05cf969ca0bf656435b1fdf1b0928290f6a6bf880adb9fd53c86ec76e0f62ce89cbeb4c266f64a876d778231a0030c38aa00d66c6bd680785 */
static const uint8_t nist_kas_ecc_cdh_testvector_366_out[] = {
/* ZIUT */
	0x05, 0xc6, 0x38, 0x34, 0x90, 0x00, 0xec, 0x30, 0x88, 0x1c, 0xd1, 0x90,
	0xc0, 0x67, 0xe7, 0xf1, 0x2b, 0x6b, 0x42, 0xd5, 0x84, 0x2a, 0x82, 0x85,
	0xa8, 0xff, 0x0d, 0xc7, 0xe9, 0xc9, 0xea, 0xf4, 0x83, 0x30, 0x9e, 0x48,
	0x31, 0x4f, 0xdc, 0x2c, 0xe7, 0xf9, 0xda, 0x6a, 0x46, 0x8e, 0x54, 0x9c,
	0x8e, 0x70, 0xa5, 0x0b, 0x68, 0xd0, 0x7a, 0xee, 0x29, 0x70, 0x8a, 0x98,
	0x17, 0x22, 0x09, 0xe5, 0xcd, 0x2e, 0x8c, 0x09, 0xcb, 0x66, 0xd9, 0x82
};
/* COUNT = 16 */
static const uint8_t nist_kas_ecc_cdh_testvector_367_public_x[] = {
/* QCAVSx */
	0x02, 0x98, 0x4b, 0x65, 0x30, 0x74, 0xc3, 0x6a, 0x25, 0x9a, 0xd9, 0x56,
	0xd5, 0x55, 0x65, 0x12, 0xc2, 0xc7, 0x31, 0xfa, 0x50, 0xf2, 0x00, 0x5d,
	0x00, 0x49, 0xa9, 0xd9, 0x77, 0xde, 0x5c, 0x00, 0xb7, 0xa0, 0x54, 0xc9,
	0x60, 0xcd, 0xd7, 0x07, 0x89, 0x63, 0x21, 0x49, 0x0b, 0xe4, 0x33, 0xbd,
	0x5e, 0xff, 0xd4, 0x4c, 0x56, 0x4e, 0xaa, 0x2d, 0x50, 0x21, 0x17, 0x50,
	0x50, 0xc5, 0xbf, 0xc1, 0x63, 0xcd, 0xb1, 0xe8, 0x1d, 0xf1, 0x33, 0x5a
};
static const uint8_t nist_kas_ecc_cdh_testvector_367_public_y[] = {
/* QCAVSy */
	0x01, 0xa7, 0x86, 0xd2, 0x90, 0x98, 0xb3, 0x34, 0xf5, 0xc1, 0xc4, 0xae,
	0x86, 0xa4, 0x1b, 0xf2, 0x75, 0xcc, 0x67, 0x87, 0xda, 0x72, 0x06, 0x91,
	0x65, 0x57, 0xa4, 0xf4, 0x33, 0x19, 0x21, 0x41, 0x03, 0x45, 0x67, 0xe0,
	0x41, 0xd5, 0x5d, 0x79, 0x4a, 0x77, 0x07, 0xc7, 0xaa, 0xf2, 0x88, 0x42,
	0xd5, 0xc8, 0xf5, 0x90, 0x37, 0x5a, 0x43, 0x65, 0x69, 0x18, 0xaa, 0x80,
	0xe5, 0x5b, 0x02, 0x85, 0x34, 0x7c, 0xce, 0x8f, 0xfe, 0x1f, 0x15, 0xe8
};
static const uint8_t nist_kas_ecc_cdh_testvector_367_private[] = {
/* dIUT */
	0x01, 0x86, 0xb3, 0x1c, 0xe4, 0x90, 0xc7, 0xf2, 0x8f, 0x27, 0x93, 0x07,
	0x5a, 0x4a, 0xe6, 0x45, 0xac, 0xb3, 0x9e, 0x71, 0xff, 0xe9, 0x44, 0xee,
	0x62, 0xbf, 0x82, 0x58, 0x7f, 0x1c, 0x3c, 0xbe, 0x28, 0x8c, 0xe6, 0x02,
	0x4d, 0x8d, 0x03, 0x5f, 0x10, 0x7d, 0x9a, 0x4f, 0xae, 0xd5, 0x7a, 0x7b,
	0x21, 0xee, 0x1d, 0x6e, 0x71, 0x29, 0xa0, 0x98, 0x00, 0x4f, 0x22, 0xcc,
	0xd5, 0x27, 0x40, 0xc0, 0x34, 0xa6, 0xdf, 0x37, 0xb5, 0x3d, 0x07, 0x32
};
/* QIUTx = 06b15f1a859e3d80924611b20c1b94dff6bd0574fef81937f1e54d148d2d31f8c21b0ea9ce031c9455706f085a69fd492418558c7de9aadc2c9a996e7ed1feda329c7d7609bb6b22 */
/* QIUTy = 032910544cb136e2c29aa33572aa6c3471a52ebca6b228bee749fa9ffe29296a4a5b6aa0c6dc9f095216e7b1513d81cba00794a3f558f74a1b541c73b2308f4f8e74028b5c2bcdf3 */
static const uint8_t nist_kas_ecc_cdh_testvector_367_out[] = {
/* ZIUT */
	0x00, 0x7a, 0x40, 0xa5, 0x9b, 0x66, 0x32, 0x15, 0x6a, 0x43, 0x15, 0x85,
	0x65, 0xa4, 0xee, 0xaf, 0x80, 0x61, 0x8e, 0x50, 0x1c, 0x5a, 0xc5, 0xaf,
	0xda, 0xb4, 0xce, 0x3c, 0xb7, 0x6a, 0xc9, 0x9a, 0x0b, 0xcd, 0x17, 0xe9,
	0xee, 0xc5, 0x49, 0x37, 0x3a, 0xce, 0x8c, 0x96, 0xaa, 0xc7, 0x8e, 0x2a,
	0xf6, 0x60, 0x04, 0x83, 0xa2, 0xc4, 0x9e, 0xc8, 0x12, 0x98, 0xa0, 0x83,
	0xd5, 0x23, 0x71, 0x18, 0xde, 0x96, 0xa9, 0x53, 0x99, 0x9b, 0xeb, 0x26
};
/* COUNT = 17 */
static const uint8_t nist_kas_ecc_cdh_testvector_368_public_x[] = {
/* QCAVSx */
	0x01, 0xa8, 0x68, 0x2e, 0x09, 0xec, 0xcd, 0x18, 0x68, 0xda, 0x20, 0x29,
	0x16, 0xa5, 0x61, 0xee, 0x85, 0x13, 0xc0, 0xd7, 0x34, 0x70, 0xcd, 0x34,
	0x1a, 0xee, 0x79, 0xed, 0x93, 0x55, 0x6a, 0x3a, 0x6e, 0x7c, 0x7b, 0x20,
	0x30, 0x2e, 0xc7, 0x4a, 0x0c, 0x51, 0x70, 0xa8, 0xe3, 0x7d, 0x78, 0xa9,
	0xb5, 0xd0, 0xde, 0x39, 0x00, 0xeb, 0x2a, 0x66, 0x3a, 0x72, 0x47, 0xcf,
	0x79, 0x43, 0xfd, 0x38, 0x1d, 0x95, 0xb3, 0xaa, 0xfd, 0x15, 0x61, 0x67
};
static const uint8_t nist_kas_ecc_cdh_testvector_368_public_y[] = {
/* QCAVSy */
	0x05, 0x2f, 0xec, 0xc6, 0x8f, 0x76, 0x95, 0xd4, 0xe4, 0x1a, 0x08, 0x0c,
	0x47, 0x65, 0x0d, 0x20, 0x28, 0x74, 0xda, 0x16, 0x3a, 0x17, 0x48, 0xe5,
	0x50, 0x37, 0x39, 0x58, 0xe3, 0x1b, 0xd0, 0xaa, 0xe5, 0x20, 0x99, 0x6d,
	0x30, 0xf3, 0x84, 0x73, 0x0f, 0x48, 0x54, 0xf5, 0xe5, 0x4e, 0x68, 0xcc,
	0x24, 0x95, 0x8a, 0xdc, 0x52, 0xe2, 0xa4, 0xc4, 0x07, 0x35, 0x65, 0x14,
	0xf3, 0xea, 0x71, 0x66, 0x05, 0x6d, 0xc6, 0x7e, 0x4d, 0x11, 0x8f, 0xa8
};
static const uint8_t nist_kas_ecc_cdh_testvector_368_private[] = {
/* dIUT */
	0x03, 0x41, 0xf8, 0xe8, 0x61, 0x82, 0xde, 0x4f, 0xc3, 0xf4, 0x38, 0x57,
	0x25, 0x0a, 0x92, 0x9a, 0x41, 0x99, 0x4d, 0x33, 0x1d, 0xa1, 0x54, 0xc0,
	0x24, 0x9f, 0xa0, 0xd1, 0xc2, 0x6a, 0x6d, 0xe0, 0xe8, 0x35, 0xfa, 0x08,
	0xa8, 0xcc, 0x52, 0x4e, 0x3d, 0xac, 0x28, 0x63, 0x83, 0xf9, 0x0b, 0xd2,
	0xf4, 0xd2, 0xc7, 0x51, 0x42, 0xf1, 0xd3, 0x81, 0x08, 0xd9, 0xc0, 0x62,
	0x14, 0x3c, 0x8e, 0x6e, 0xdb, 0xbd, 0xa0, 0xaf, 0x87, 0xa7, 0x6a, 0xd5
};
/* QIUTx = 02c5c5eb7327402672573c37b492890343ab422b51bc65b600766ec1d07908ff03bcfde7694d832bcde52946339df0aab4074ae07a89f821f5a1130d2b73db0c423ae7a023ae2c18 */
/* QIUTy = 0476ed3dbd936d1c36987a43512c8f0562e316122d05a7edd4e4248984c11f6eb85215d5aaa0262a95f20666c9dbf45248ae177d2dfffa3a6a950533298b5c3f4a1b62da1eafcd51 */
static const uint8_t nist_kas_ecc_cdh_testvector_368_out[] = {
/* ZIUT */
	0x02, 0x1f, 0xd2, 0x72, 0x69, 0x73, 0x40, 0x5f, 0xc3, 0x0d, 0x2a, 0x1f,
	0x21, 0x15, 0x90, 0x7c, 0xbd, 0x0d, 0xe9, 0x0b, 0xb6, 0xbc, 0xb0, 0x49,
	0x64, 0x52, 0xe3, 0x89, 0xb1, 0xb1, 0x0c, 0xcf, 0x38, 0xe2, 0x40, 0x06,
	0x17, 0x04, 0x0c, 0xf0, 0xdb, 0xb1, 0x88, 0xf3, 0x45, 0x33, 0x76, 0x78,
	0xb0, 0xad, 0x86, 0x03, 0xdc, 0xfe, 0x92, 0x65, 0x82, 0xd4, 0x32, 0x1f,
	0x38, 0x4d, 0xae, 0xc0, 0x94, 0x3e, 0x2c, 0xd2, 0x67, 0xf4, 0x83, 0x43
};
/* COUNT = 18 */
static const uint8_t nist_kas_ecc_cdh_testvector_369_public_x[] = {
/* QCAVSx */
	0x02, 0xcd, 0xaf, 0x13, 0x9a, 0x0c, 0xda, 0x28, 0x00, 0xd6, 0x11, 0x28,
	0xff, 0xe4, 0xd7, 0x32, 0x3b, 0x34, 0xa0, 0xfc, 0xf4, 0x8c, 0x94, 0x00,
	0x47, 0x9f, 0xf4, 0xc8, 0x29, 0x1c, 0xbf, 0x46, 0xf1, 0x6c, 0x41, 0xe4,
	0x40, 0x9a, 0xae, 0xdf, 0x14, 0xbc, 0x60, 0xa6, 0x42, 0xb2, 0xd7, 0xba,
	0xac, 0xde, 0x8e, 0x00, 0x51, 0xdd, 0x8a, 0xe0, 0x1b, 0xf5, 0xad, 0x2e,
	0x6e, 0x64, 0x90, 0xc7, 0x7c, 0xd4, 0x06, 0xa9, 0x99, 0xc5, 0x65, 0xe6
};
static const uint8_t nist_kas_ecc_cdh_testvector_369_public_y[] = {
/* QCAVSy */
	0x07, 0x8e, 0xdd, 0x29, 0xdb, 0x6a, 0x3b, 0x87, 0xa1, 0x15, 0x05, 0xb5,
	0x7c, 0x54, 0x3f, 0xfb, 0x74, 0x6a, 0x5b, 0x40, 0xfb, 0x83, 0xd7, 0x20,
	0x61, 0x80, 0xf3, 0xae, 0x9f, 0xcb, 0x22, 0x2c, 0x54, 0x11, 0xa7, 0x74,
	0x76, 0x66, 0x0c, 0x7b, 0x31, 0x1b, 0x64, 0x63, 0x10, 0x90, 0x58, 0x89,
	0xa9, 0x5a, 0x0f, 0x2f, 0xdc, 0x35, 0xd3, 0x0f, 0xc6, 0x1c, 0xc5, 0x56,
	0x0a, 0x29, 0x14, 0x23, 0x2d, 0x62, 0xad, 0x36, 0x38, 0x6b, 0x91, 0x79
};
static const uint8_t nist_kas_ecc_cdh_testvector_369_private[] = {
/* dIUT */
	0x02, 0x07, 0xa7, 0x38, 0x2d, 0x8a, 0x22, 0x57, 0x12, 0x26, 0xe0, 0xc0,
	0x6c, 0x26, 0x81, 0xd0, 0x9b, 0xca, 0x19, 0xb5, 0xdb, 0x7e, 0x7b, 0xbf,
	0xc1, 0x3a, 0xc2, 0x08, 0x38, 0x9d, 0xf8, 0x16, 0x8d, 0x77, 0x61, 0x5e,
	0x30, 0xca, 0x86, 0x10, 0x39, 0x36, 0xe5, 0x3d, 0xd9, 0xaf, 0x01, 0xcd,
	0xfe, 0x24, 0xf5, 0x08, 0xec, 0x60, 0x93, 0x99, 0x77, 0x5c, 0xe8, 0x4c,
	0x86, 0x89, 0xf8, 0xd5, 0xf9, 0x6f, 0x65, 0x2e, 0x01, 0x4e, 0x0d, 0xe8
};
/* QIUTx = 04608dc0512bc55c734cd562ac5825f7ca38b793f8ece9b981cc1c4032ddd8039164d0c646b42b2fd453b5a1d3a74ae23c32c7d584007de3cd34e33121b90fab3ada6621b3ac9785 */
/* QIUTy = 06aa9ffbfd65c509370846707674ac723dac24a6f33a1e0bbcdf8b24ba32cf7bdec8fdc9233b757bc073d64dedf484c6fa01ef28e874fb0d34f58b0e32b18645c30bdcb516ee3841 */
static const uint8_t nist_kas_ecc_cdh_testvector_369_out[] = {
/* ZIUT */
	0x07, 0xa4, 0x7b, 0xdc, 0x7d, 0x54, 0xec, 0xd3, 0x91, 0x67, 0x2f, 0x13,
	0x1b, 0x32, 0x14, 0xd0, 0xef, 0xc4, 0xd4, 0x01, 0x95, 0xdb, 0x1e, 0xc9,
	0x93, 0xa6, 0x2f, 0xe9, 0xda, 0x87, 0x5e, 0xff, 0xf5, 0x40, 0x3b, 0xd7,
	0x08, 0xfa, 0x49, 0x1a, 0x01, 0xa9, 0x4f, 0x4b, 0xdd, 0xc7, 0xd5, 0x16,
	0xba, 0xff, 0xff, 0x9f, 0xbd, 0xd2, 0x13, 0xca, 0x1a, 0x49, 0x05, 0xf9,
	0xaa, 0x67, 0x9d, 0x65, 0xda, 0x25, 0xc0, 0xf1, 0xfd, 0x2a, 0xfb, 0x0a
};
/* COUNT = 19 */
static const uint8_t nist_kas_ecc_cdh_testvector_370_public_x[] = {
/* QCAVSx */
	0x00, 0x05, 0x15, 0x12, 0xe4, 0xa0, 0xdb, 0xc5, 0x35, 0xc9, 0x7b, 0xe1,
	0x0f, 0xfa, 0x74, 0x25, 0x75, 0x83, 0x82, 0x88, 0x30, 0x40, 0x46, 0x66,
	0x01, 0xd5, 0x39, 0x1b, 0xcb, 0x35, 0x82, 0xc1, 0x15, 0x25, 0x29, 0x32,
	0x49, 0xf2, 0x44, 0x97, 0xcc, 0x80, 0x72, 0x16, 0xb3, 0x4c, 0x92, 0xc1,
	0xe0, 0x75, 0x78, 0x1c, 0x83, 0x91, 0xc3, 0xf6, 0xd3, 0xd1, 0x4f, 0x88,
	0xa1, 0xd5, 0x0e, 0xa9, 0xfc, 0x75, 0xff, 0x8d, 0x51, 0xcc, 0xf9, 0x33
};
static const uint8_t nist_kas_ecc_cdh_testvector_370_public_y[] = {
/* QCAVSy */
	0x03, 0x9d, 0xa4, 0x6c, 0xac, 0x86, 0x6a, 0xb3, 0x47, 0x61, 0x7a, 0xc5,
	0xa8, 0xb4, 0xf1, 0x65, 0x70, 0x34, 0xe3, 0xb8, 0xdd, 0xb6, 0x6b, 0xc4,
	0x27, 0x3e, 0x2e, 0x1c, 0xe0, 0x16, 0x41, 0xec, 0xe6, 0x36, 0x97, 0x9d,
	0xe8, 0xb2, 0x49, 0x2d, 0xc6, 0x9e, 0x88, 0x53, 0x7c, 0x36, 0xb1, 0xc3,
	0xad, 0x0d, 0x35, 0x22, 0x7f, 0x86, 0x7e, 0x43, 0xdf, 0x9c, 0x89, 0x17,
	0xdc, 0xe9, 0xf8, 0xc1, 0xef, 0x3b, 0xa3, 0xcb, 0x5c, 0xa8, 0xba, 0x52
};
static const uint8_t nist_kas_ecc_cdh_testvector_370_private[] = {
/* dIUT */
	0x00, 0x6b, 0xa8, 0xf1, 0x2c, 0xc6, 0xe0, 0xe7, 0x8d, 0xf8, 0xcc, 0x62,
	0x98, 0x84, 0x8a, 0x74, 0x00, 0x25, 0xe7, 0x2c, 0x62, 0xd0, 0x99, 0xe9,
	0x25, 0x84, 0xac, 0x76, 0xf5, 0x95, 0xac, 0x1f, 0xc7, 0x24, 0xcb, 0x06,
	0xa8, 0x5a, 0x07, 0xf0, 0xd4, 0x44, 0x0f, 0xaf, 0x3d, 0xde, 0xa2, 0xf2,
	0x65, 0xf2, 0x01, 0x5d, 0xd0, 0x59, 0xa1, 0x6a, 0x03, 0xa2, 0x99, 0x15,
	0xb8, 0x73, 0x1d, 0x60, 0x45, 0x12, 0xce, 0xef, 0x22, 0xb8, 0x41, 0xf3
};
/* QIUTx = 0636f435e80600666108737300773a8ed6ffa8ebf8307c81ff5f44353e91bad086331b8feff3f1cdb86e061bde5f71c5fb938f117e2226a97d2b66b098e9ff525182c816e702c6a9 */
/* QIUTy = 01c1bd8afae6a94108fc2c755d5de3fa2a4b3471fc2a5cdf4adda68529bf180ff28db154ab4311247b392e93a335bbe8796608bbd6013f43cdcc846ec22267423c3cfda2ce8a3d96 */
static const uint8_t nist_kas_ecc_cdh_testvector_370_out[] = {
/* ZIUT */
	0x07, 0x32, 0x61, 0x96, 0xa7, 0xde, 0xcc, 0x92, 0xc8, 0x1a, 0xe5, 0xa0,
	0x77, 0x9c, 0x9a, 0x42, 0xf5, 0x3d, 0x94, 0xcf, 0xa4, 0xc3, 0xa1, 0x3f,
	0x19, 0xdb, 0xb5, 0x54, 0x13, 0x8e, 0x0e, 0x86, 0x4e, 0xee, 0x6b, 0xc9,
	0x3e, 0x39, 0x21, 0x4e, 0x2f, 0x74, 0x70, 0x5a, 0x4b, 0x17, 0x2a, 0xab,
	0x51, 0x04, 0x44, 0xc9, 0x3b, 0x5b, 0x3e, 0x62, 0x51, 0x7b, 0xbb, 0x72,
	0x79, 0x33, 0x71, 0x02, 0xdb, 0x1c, 0x61, 0xde, 0x34, 0x9d, 0x97, 0x47
};
/* COUNT = 20 */
static const uint8_t nist_kas_ecc_cdh_testvector_371_public_x[] = {
/* QCAVSx */
	0x00, 0x4c, 0x2d, 0xe5, 0x64, 0x24, 0x31, 0xbc, 0xc6, 0xeb, 0x82, 0xef,
	0xd4, 0x35, 0x55, 0x40, 0xa8, 0xb5, 0xd2, 0x3b, 0x12, 0xb0, 0xdf, 0x7d,
	0x31, 0xad, 0x69, 0x42, 0x5b, 0x94, 0x54, 0x98, 0x77, 0x44, 0x3e, 0xe8,
	0xdd, 0x7c, 0x09, 0xcf, 0xbb, 0xed, 0x86, 0xf1, 0x36, 0x65, 0x93, 0x1d,
	0x4b, 0x2a, 0x21, 0x75, 0x9c, 0x33, 0xe1, 0x0b, 0x4a, 0xcf, 0xc6, 0x3b,
	0xa1, 0xef, 0x61, 0xac, 0xaa, 0xa1, 0x8c, 0x94, 0xe3, 0xcf, 0xc9, 0x33
};
static const uint8_t nist_kas_ecc_cdh_testvector_371_public_y[] = {
/* QCAVSy */
	0x01, 0x76, 0x5b, 0x7a, 0x37, 0xeb, 0x80, 0x6d, 0x43, 0x19, 0x6d, 0x29,
	0x31, 0xda, 0x1a, 0x19, 0x53, 0x74, 0x2d, 0x3e, 0x0d, 0xa7, 0xcc, 0xb6,
	0x7e, 0x0d, 0xfd, 0xba, 0x5e, 0x03, 0x49, 0x14, 0xcc, 0xe3, 0xee, 0x63,
	0x93, 0xbf, 0xde, 0x40, 0x67, 0x0f, 0x40, 0x61, 0x96, 0x06, 0x7d, 0xa8,
	0xb2, 0x93, 0xc6, 0x84, 0x35, 0x93, 0xdd, 0x22, 0x1c, 0x89, 0xbf, 0x97,
	0x96, 0x36, 0x76, 0xbd, 0x04, 0x4e, 0x8c, 0x8a, 0xb8, 0xe7, 0x17, 0xad
};
static const uint8_t nist_kas_ecc_cdh_testvector_371_private[] = {
/* dIUT */
	0x01, 0x07, 0x16, 0xf2, 0xe7, 0x74, 0xf2, 0x7f, 0x42, 0xde, 0x3f, 0x6c,
	0x96, 0x94, 0xd8, 0xec, 0xa2, 0x17, 0x98, 0x23, 0x09, 0x1d, 0x20, 0x2f,
	0x2b, 0xa1, 0x62, 0x91, 0x93, 0xa1, 0xc9, 0x87, 0x00, 0x69, 0x33, 0x98,
	0xff, 0xc8, 0x31, 0x57, 0xf7, 0xce, 0x48, 0x58, 0xe7, 0x53, 0x5e, 0x39,
	0x90, 0xd2, 0x19, 0xbc, 0x24, 0x9d, 0xe1, 0x64, 0x55, 0x8c, 0xac, 0x80,
	0x7e, 0xe1, 0x59, 0x77, 0x8a, 0x01, 0x2d, 0xa1, 0x9e, 0x50, 0x12, 0xbf
};
/* QIUTx = 0150b3adde162a7f09350dacf460419fe86b99dcd94f44283fba3e43d281b93bb54282812ce52265a94838968d67a9d6ecdc1b6cb64cf1594521c4749ea43d8e4ec045e645ff238b */
/* QIUTy = 07b43321b6118b87c46c7b52288df5dd1cf7da6183ece5633b4c17cae362d821191f7d57923928339aadf7d85f7f19de9486709e4d2ddef42c55bb4d76a3cb50cad2a098ead5952a */
static const uint8_t nist_kas_ecc_cdh_testvector_371_out[] = {
/* ZIUT */
	0x05, 0x90, 0x52, 0xd3, 0xe1, 0xc6, 0x6e, 0xfa, 0x4b, 0x7d, 0xd3, 0x9e,
	0x74, 0x29, 0x9e, 0x88, 0x63, 0x67, 0xd8, 0xfe, 0x49, 0xd7, 0xca, 0xb9,
	0x0e, 0x4f, 0x05, 0x1b, 0xec, 0x10, 0x31, 0x64, 0x38, 0xfb, 0x29, 0xb1,
	0x29, 0x0d, 0xfd, 0xae, 0xc1, 0x69, 0xde, 0xcd, 0x62, 0x2a, 0x10, 0x10,
	0xcf, 0x0a, 0x02, 0x75, 0x00, 0x88, 0x14, 0xf4, 0x86, 0x1b, 0x4d, 0x83,
	0xba, 0x78, 0x51, 0x5a, 0x87, 0x68, 0xd9, 0x78, 0xbe, 0x43, 0x00, 0x11
};
/* COUNT = 21 */
static const uint8_t nist_kas_ecc_cdh_testvector_372_public_x[] = {
/* QCAVSx */
	0x02, 0x50, 0x38, 0xa0, 0xe7, 0x2a, 0xe8, 0xc1, 0x6e, 0x36, 0xe3, 0xe3,
	0xb5, 0x04, 0xed, 0x73, 0x41, 0xef, 0x70, 0x9b, 0x9f, 0xec, 0x8b, 0xe9,
	0x01, 0x77, 0x34, 0x6d, 0x76, 0xca, 0x7b, 0xc7, 0x13, 0x3d, 0x0e, 0xc2,
	0x80, 0xac, 0xf0, 0x66, 0x00, 0x5c, 0x5c, 0xc1, 0x0b, 0x52, 0xaa, 0x65,
	0x43, 0x35, 0xfe, 0x82, 0x0a, 0x66, 0x17, 0xe5, 0x60, 0xe2, 0x70, 0x90,
	0x3f, 0xf1, 0xc2, 0xcc, 0x8a, 0xf1, 0x39, 0x8f, 0x24, 0xdf, 0xe2, 0xb0
};
static const uint8_t nist_kas_ecc_cdh_testvector_372_public_y[] = {
/* QCAVSy */
	0x03, 0x10, 0x74, 0xca, 0x39, 0x31, 0x80, 0x1a, 0x6a, 0xcb, 0x76, 0x5b,
	0x6e, 0x91, 0x44, 0x17, 0x2e, 0xd8, 0x1d, 0x99, 0x9e, 0xd9, 0xe8, 0x35,
	0xbd, 0x35, 0x52, 0x6b, 0x03, 0xef, 0x2a, 0x13, 0xf7, 0x83, 0x76, 0x03,
	0x2b, 0x0e, 0xb8, 0x14, 0x6c, 0x23, 0x13, 0x23, 0x65, 0xfc, 0xe1, 0x76,
	0xa7, 0xcb, 0xdc, 0xa4, 0x4b, 0x35, 0xaa, 0x37, 0x98, 0x59, 0xf6, 0x88,
	0xac, 0x26, 0xdc, 0x64, 0xc8, 0x14, 0x9a, 0x43, 0x22, 0xd0, 0x83, 0xd1
};
static const uint8_t nist_kas_ecc_cdh_testvector_372_private[] = {
/* dIUT */
	0x01, 0xd0, 0x10, 0x3f, 0xc7, 0x94, 0x8a, 0xf1, 0x07, 0xe5, 0x1f, 0x4d,
	0x2c, 0xc0, 0x39, 0x2b, 0x66, 0x80, 0x80, 0x59, 0xd1, 0xf2, 0x6c, 0xba,
	0x05, 0xbe, 0x6a, 0x38, 0x1f, 0x52, 0x2d, 0x4c, 0xb8, 0x54, 0x13, 0x79,
	0x34, 0xac, 0xcd, 0x1c, 0xea, 0x33, 0x60, 0x94, 0x8e, 0x40, 0x6d, 0x31,
	0x08, 0xc9, 0x43, 0x76, 0x9d, 0xc7, 0x00, 0xb4, 0xc9, 0xcc, 0x0c, 0xc1,
	0xd8, 0x4b, 0xab, 0x58, 0xa3, 0x5e, 0x27, 0xeb, 0x24, 0x04, 0x75, 0xf0
};
/* QIUTx = 012bda8ded3ed7e8b6d39b5855a58d725b65e3857c2a674996eb393a3e3f91595bbfa87253a56ebac2b10ed406af9dbff53b22265fbeb5a769cace2b60b45dbf97ceed2b0a04db50 */
/* QIUTy = 026454827efe29b324ae3f2d4c0dca3a3a95491511c531645acf545b45ef6ac4a50c09d3d21f213ca76b96fb18242ecbe08af68755de4e1077173475826eaabed26a75c369cd7b0f */
static const uint8_t nist_kas_ecc_cdh_testvector_372_out[] = {
/* ZIUT */
	0x03, 0xac, 0xfa, 0x4b, 0x3d, 0x1c, 0x2a, 0x6b, 0x62, 0xaf, 0x23, 0xbd,
	0xff, 0x6a, 0x21, 0x5a, 0x41, 0x6d, 0x44, 0x37, 0xce, 0x6c, 0xc1, 0x14,
	0xd1, 0x7d, 0xc4, 0x20, 0x11, 0x95, 0x98, 0x7a, 0x5d, 0x73, 0x01, 0xda,
	0x11, 0xb9, 0x13, 0x25, 0x47, 0x02, 0xd7, 0x17, 0x2e, 0x31, 0xd6, 0x4e,
	0x59, 0xb2, 0x4d, 0xea, 0xa3, 0x27, 0x0f, 0x20, 0x44, 0x5e, 0x51, 0xdc,
	0x48, 0x4f, 0x7a, 0x2b, 0x8c, 0x3c, 0xbe, 0xb0, 0xbb, 0x9e, 0xfb, 0x28
};
/* COUNT = 22 */
static const uint8_t nist_kas_ecc_cdh_testvector_373_public_x[] = {
/* QCAVSx */
	0x01, 0xbd, 0xff, 0xfd, 0x69, 0xc2, 0xe0, 0x8f, 0xb0, 0x3c, 0x85, 0x3e,
	0xf2, 0xeb, 0xd0, 0x88, 0xe6, 0x8d, 0x23, 0x3f, 0xdb, 0x95, 0xf0, 0xb2,
	0x46, 0xde, 0x79, 0x55, 0xd6, 0x15, 0x07, 0x7d, 0xfd, 0x0b, 0x0f, 0xf0,
	0x2c, 0x64, 0xd0, 0x1d, 0xe7, 0x93, 0x35, 0x90, 0x96, 0xb8, 0x5e, 0x05,
	0x7b, 0x1b, 0x7f, 0x9f, 0x59, 0x26, 0x2d, 0xc2, 0x75, 0x7f, 0x18, 0x24,
	0x3e, 0x18, 0x2e, 0x1a, 0x0b, 0xfe, 0x9d, 0xcb, 0xb0, 0x27, 0xd6, 0x8b
};
static const uint8_t nist_kas_ecc_cdh_testvector_373_public_y[] = {
/* QCAVSy */
	0x02, 0x18, 0xbe, 0x7d, 0x95, 0x60, 0x29, 0xf1, 0x39, 0xc1, 0x9d, 0x2d,
	0xa3, 0x46, 0x77, 0x3b, 0x16, 0xd7, 0xaf, 0xc8, 0x58, 0xab, 0x8d, 0xcb,
	0x60, 0xd7, 0xe4, 0x84, 0xae, 0xce, 0xc3, 0x09, 0xcb, 0x3f, 0xea, 0x96,
	0xaf, 0x39, 0x03, 0x63, 0x7e, 0x5d, 0xb4, 0xdb, 0x67, 0x8b, 0xb5, 0xdb,
	0x9b, 0x0b, 0x18, 0xd8, 0x3c, 0xf9, 0xeb, 0xc1, 0xb1, 0xaa, 0xf2, 0x4f,
	0x43, 0x67, 0xec, 0x53, 0x36, 0x84, 0xce, 0x9d, 0x56, 0x58, 0x2d, 0x43
};
static const uint8_t nist_kas_ecc_cdh_testvector_373_private[] = {
/* dIUT */
	0x03, 0x2d, 0x2f, 0x55, 0x7f, 0xe4, 0x7b, 0x8d, 0x28, 0x0f, 0x68, 0x2e,
	0x24, 0xfd, 0xa6, 0x27, 0xdd, 0x7a, 0x58, 0xe9, 0xb0, 0x08, 0x22, 0xa3,
	0xaa, 0xf6, 0xeb, 0x7a, 0x01, 0x4f, 0x47, 0x6c, 0x17, 0x94, 0x1a, 0xdc,
	0x5e, 0x22, 0x38, 0xa3, 0x08, 0x0d, 0x70, 0x6f, 0x1e, 0x16, 0xa4, 0x51,
	0xb7, 0xe9, 0x29, 0x42, 0x77, 0x99, 0x30, 0xc5, 0x67, 0x0a, 0x47, 0x32,
	0x81, 0xca, 0xc7, 0x8b, 0x85, 0x8d, 0x1f, 0x1c, 0xc9, 0x9b, 0x0a, 0xff
};
/* QIUTx = 040f3130e74b1c8eb265e7c4e6921411eb971418267e8dea879c2e8b563864f23a61b23422c9a06fa178a8a155e3e78457597587f3e35b79f19d0c2e185aef46db95819cbe127b10 */
/* QIUTy = 01c91d27c2ae7113eb03be98e94d3ad6dec791fac2fe0d2c8c98b71371b058a649fa9c3fa3ccdbba932395c27affa20d95ac041bc9978e3f530829a2c64c89b1bcceac06854fb903 */
static const uint8_t nist_kas_ecc_cdh_testvector_373_out[] = {
/* ZIUT */
	0x06, 0x7a, 0x58, 0xe5, 0xb3, 0x28, 0x7b, 0xb9, 0xaa, 0x83, 0xed, 0x9c,
	0xa2, 0xd7, 0x18, 0xcf, 0x71, 0x65, 0xfb, 0x57, 0x4b, 0x6a, 0x44, 0x6c,
	0x30, 0x19, 0x84, 0x9c, 0xd1, 0x58, 0x46, 0x73, 0xd5, 0x61, 0xb5, 0x74,
	0xbc, 0x8f, 0x68, 0x41, 0x94, 0x37, 0xc5, 0xe8, 0x11, 0x3e, 0x06, 0x08,
	0x47, 0xca, 0xd3, 0xb5, 0xdd, 0xc2, 0xf6, 0x7a, 0xd7, 0x5b, 0xc1, 0xe3,
	0xf0, 0x45, 0x54, 0xe6, 0x3a, 0x5e, 0x49, 0x45, 0xcf, 0xcb, 0x65, 0xf5
};
/* COUNT = 23 */
static const uint8_t nist_kas_ecc_cdh_testvector_374_public_x[] = {
/* QCAVSx */
	0x00, 0x8f, 0xc3, 0xb4, 0x14, 0xf3, 0x41, 0x2b, 0x40, 0x3f, 0x01, 0xc2,
	0x53, 0xbd, 0x22, 0x26, 0x15, 0x02, 0x25, 0xdd, 0xaa, 0xb3, 0x4d, 0x20,
	0x10, 0x89, 0xf4, 0x9d, 0x79, 0xe5, 0xdc, 0xc2, 0xe3, 0xb6, 0x82, 0x16,
	0xfa, 0xa6, 0x6d, 0xac, 0x44, 0x52, 0x9c, 0x7f, 0xe3, 0xba, 0x4d, 0x28,
	0xd8, 0x15, 0xb0, 0x88, 0x23, 0x59, 0x55, 0x71, 0x3b, 0xb7, 0x72, 0x13,
	0x83, 0x53, 0x3b, 0x5d, 0x94, 0x22, 0x1b, 0x4e, 0xd1, 0xe1, 0x62, 0xb8
};
static const uint8_t nist_kas_ecc_cdh_testvector_374_public_y[] = {
/* QCAVSy */
	0x02, 0xb3, 0x22, 0x01, 0xde, 0x27, 0x2b, 0x1b, 0x32, 0xb6, 0xa6, 0xa5,
	0x8e, 0xa2, 0x24, 0x11, 0xc4, 0x8f, 0x5d, 0xc5, 0xcf, 0x0f, 0x95, 0x87,
	0x2e, 0x67, 0x51, 0xed, 0x62, 0x2c, 0xee, 0xce, 0xa2, 0x2a, 0x55, 0x69,
	0x75, 0xde, 0x60, 0x03, 0x86, 0x9a, 0xe2, 0x0a, 0xf3, 0x9b, 0x42, 0xba,
	0x88, 0x71, 0x78, 0x9c, 0x82, 0xe8, 0xf3, 0xad, 0x3c, 0xf6, 0x00, 0x6f,
	0x43, 0xbc, 0x4c, 0x7d, 0x41, 0x02, 0x03, 0x2c, 0x43, 0xf8, 0xf7, 0x97
};
static const uint8_t nist_kas_ecc_cdh_testvector_374_private[] = {
/* dIUT */
	0x03, 0xee, 0xe2, 0x91, 0x96, 0xa8, 0xbe, 0x70, 0xeb, 0x3a, 0x31, 0x04,
	0x64, 0x05, 0x9c, 0xc0, 0xc4, 0xc4, 0x2f, 0x13, 0x48, 0x7a, 0xb1, 0xa0,
	0x76, 0x2c, 0x2c, 0xbe, 0x30, 0x4e, 0xbe, 0x63, 0x50, 0x3e, 0x6c, 0x70,
	0x68, 0xa7, 0xf4, 0xbc, 0x19, 0x7f, 0x81, 0xf6, 0x5b, 0x42, 0x95, 0xc1,
	0x4b, 0x21, 0x0f, 0x3c, 0xb2, 0x37, 0x8b, 0x67, 0x40, 0x1f, 0xcf, 0x52,
	0xbe, 0xc0, 0x2c, 0x13, 0xb6, 0x1b, 0x6d, 0xe1, 0x4e, 0x1b, 0x7e, 0x5b
};
/* QIUTx = 0177acc5fe9f42f4de2d27ab9bf6f7e0eace303c266ff8b3469082aba9367e66440bd6b1bd8b6e1aec92b65e35aea8f007f09d4cd67eea5d6000736cabbb9dccc943ebb5656a0586 */
/* QIUTy = 0716f1898e2a8c27319de7a2698f21d5de58a4b8b8dd02b5e433110d3977fee8ec5c089d170af02a4ad3c1fab44b0d1e2a3beba9e0719cd8bf8364478d686c4e35f7457d24d021d6 */
static const uint8_t nist_kas_ecc_cdh_testvector_374_out[] = {
/* ZIUT */
	0x06, 0xb2, 0x72, 0xca, 0x33, 0x30, 0xc0, 0xcd, 0xfb, 0xe6, 0x0a, 0x17,
	0x46, 0xbc, 0x0d, 0xde, 0xa6, 0x25, 0x75, 0x36, 0xcd, 0xd8, 0xe9, 0x76,
	0xf2, 0x51, 0x7e, 0xb5, 0x41, 0x46, 0x0a, 0x3f, 0x0e, 0x6e, 0xa7, 0xfe,
	0xc2, 0xb4, 0x95, 0xe0, 0xf5, 0x77, 0x12, 0xc8, 0xca, 0xc3, 0x5e, 0x8a,
	0x7d, 0x64, 0xd8, 0x76, 0xc2, 0x98, 0x51, 0xbb, 0xfe, 0xb6, 0xfe, 0x72,
	0x6d, 0x57, 0xe0, 0xbe, 0x43, 0xdc, 0x76, 0xa5, 0x84, 0xef, 0x9c, 0x93
};
/* COUNT = 24 */
static const uint8_t nist_kas_ecc_cdh_testvector_375_public_x[] = {
/* QCAVSx */
	0x05, 0x65, 0xa8, 0x29, 0x94, 0xd7, 0xe6, 0xf5, 0x3e, 0xeb, 0x6b, 0xf6,
	0x75, 0x23, 0xee, 0x68, 0x0f, 0xfb, 0x77, 0x01, 0x18, 0x67, 0x3c, 0x3e,
	0x15, 0xc3, 0x20, 0x0e, 0x6c, 0x8d, 0x1f, 0x26, 0xca, 0xba, 0xf0, 0x0c,
	0x1d, 0xa4, 0x8e, 0x63, 0x74, 0x31, 0x64, 0x97, 0xcb, 0xa5, 0xf1, 0x9f,
	0x17, 0x42, 0x0f, 0x26, 0x76, 0x33, 0xf4, 0x0e, 0x5b, 0x06, 0x36, 0x27,
	0x89, 0xbf, 0xf1, 0x1a, 0xdf, 0x59, 0x6d, 0x5b, 0x1c, 0xf7, 0x68, 0xef
};
static const uint8_t nist_kas_ecc_cdh_testvector_375_public_y[] = {
/* QCAVSy */
	0x01, 0x6b, 0x2d, 0x4d, 0xaa, 0xca, 0x9c, 0x6b, 0xed, 0x97, 0x6b, 0x20,
	0x64, 0xef, 0x54, 0x35, 0x2a, 0x58, 0xae, 0x34, 0x36, 0x78, 0x35, 0xa6,
	0x21, 0x0e, 0x15, 0x78, 0x29, 0x1c, 0x1d, 0xe8, 0xd6, 0x7c, 0x20, 0xbc,
	0x3d, 0x6f, 0xfa, 0x62, 0x0c, 0x87, 0xb3, 0x09, 0x8a, 0x2b, 0x9f, 0x3a,
	0xbb, 0x8d, 0x2c, 0xac, 0xd5, 0xb2, 0xee, 0x2b, 0x68, 0x39, 0x9e, 0xac,
	0x4e, 0x8f, 0x65, 0xce, 0xbd, 0xd6, 0x63, 0x00, 0xfd, 0x04, 0x9b, 0x5b
};
static const uint8_t nist_kas_ecc_cdh_testvector_375_private[] = {
/* dIUT */
	0x01, 0x69, 0xa2, 0xd8, 0x75, 0x86, 0x94, 0x4c, 0x31, 0x73, 0xbf, 0x9a,
	0x22, 0x75, 0xe3, 0x08, 0x00, 0x03, 0xdb, 0x64, 0x8c, 0x2d, 0x1e, 0x1c,
	0x56, 0xe2, 0xc3, 0x7c, 0xe0, 0xd7, 0xcd, 0x9f, 0x81, 0x8e, 0xa6, 0xb7,
	0xbb, 0xa3, 0x43, 0xf7, 0x74, 0xef, 0x0f, 0x33, 0x4e, 0xa5, 0xc1, 0x2e,
	0xf0, 0xbe, 0x75, 0x93, 0xd0, 0x4e, 0xd9, 0x45, 0x45, 0x8d, 0x71, 0xe1,
	0x71, 0x12, 0xeb, 0x01, 0xd9, 0x04, 0x1d, 0x21, 0x33, 0xb1, 0x34, 0x73
};
/* QIUTx = 051e521764265af7f01bcd9c3fd022dfdb2d4a2c58b3b23d2e550302c42aadd57d1df6fc18e465bd98442495eed22f3fd6700284c9fa7833b5165149b8e1a91e0e099a0a5732d5c2 */
/* QIUTy = 0198e7e7d094e207528c583865d262a918fc2a39261e95c07dcbd044efd3981899078af3eb97398201a4650f0dccbf19f922c8dbc3839bf6be0053f84531c71843a9e6a102ab58d6 */
static const uint8_t nist_kas_ecc_cdh_testvector_375_out[] = {
/* ZIUT */
	0x02, 0xda, 0x26, 0x6a, 0x26, 0x9b, 0xdc, 0x8d, 0x8b, 0x2a, 0x0c, 0x6b,
	0xb5, 0x76, 0x2f, 0x10, 0x2f, 0xc8, 0x01, 0xc8, 0xd5, 0x39, 0x4a, 0x92,
	0x71, 0x53, 0x91, 0x36, 0xbd, 0x81, 0xd4, 0xb6, 0x9c, 0xfb, 0xb7, 0x52,
	0x5c, 0xd0, 0xa9, 0x83, 0xfb, 0x7f, 0x7e, 0x9d, 0xee, 0xc5, 0x83, 0xb8,
	0xf8, 0xe5, 0x74, 0xc6, 0x18, 0x4b, 0x2d, 0x79, 0x83, 0x1e, 0xc7, 0x70,
	0x64, 0x9e, 0x48, 0x4d, 0xc0, 0x06, 0xfa, 0x35, 0xb0, 0xbf, 0xfd, 0x0b
};
